<?php
 
/**
 * init.form284.php - Room select popup
 * Job: 224
 * Function: 52
 */

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/room_select.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],9,"");

$groupId		= $_SERVER['argv'][1];
$roomId			= $_SERVER['argv'][2];
$resItemId	= $_SERVER['argv'][3];
$method			= $_SERVER['argv'][4];

if ( trim($_SERVER['argv'][5]) == "" ) {
	$roomList = array();
} else {
	$roomList = explode(":",$_SERVER['argv'][5]);
}

$requestYN			= $_SERVER['argv'][6];
$requestReason	= urldecode($_SERVER['argv'][7]);
$itemInfo				= explode(":",$_SERVER['argv'][8]);

if ( $resItemId == "" ) {
	$resItemId = $GLOBALS['lDB']->get("
		SELECT
			rv_reservation_item_id
		FROM
			rv_res_item_group
		WHERE
			rv_res_item_group.rv_res_item_group_ix = '$groupId'
	",4);
}

$GLOBALS['temp']['resItemId']	= $resItemId;
$GLOBALS['temp']['groupId']		= $groupId;

$resItemInfo = $GLOBALS['lDB']->get("
	SELECT
		rv_reservation_item.rv_item_date_arrive,
		rv_reservation_item.rv_item_date_depart,
		rv_reservation_item.rv_item_adult_count,
		rv_reservation_item.rv_item_child_count,
		rv_reservation_item.rv_item_accomm_count,
		pr_persona.pr_name_last,
		rv_reservation_item.ac_accomm_type_id,
		rv_reservation_item.pr_business_id,
		ac_accomm_type.ac_accomm_desc,
		rv_reservation.rv_reservation_ix,
		rv_reservation.rv_res_name,
		rv_reservation.rf_reservation_status_id
	FROM
		rv_reservation_item
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation_item.pr_business_id
		INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
	WHERE
		rv_reservation_item_ix = '$resItemId'
",1);

$resStatus = $resItemInfo['rf_reservation_status_id'];

if ( $groupId == "" ) {
	$accommCount	= $resItemInfo['rv_item_accomm_count'];
	$allocCount		= $GLOBALS['lDB']->get("SELECT COUNT(*) FROM rv_res_item_group WHERE rv_reservation_item_id = '" . $resItemId . "'",4);
	$unallocCount	= $accommCount - $allocCount;
}

if ( $method == "calendar" ) {
	$accommCount	= $resItemInfo['rv_item_accomm_count'];
	$allocCount		= $GLOBALS['lDB']->get("SELECT COUNT(*) FROM rv_res_item_group WHERE rv_reservation_item_id = '" . $resItemId . "'",4);
	$unallocCount	= $accommCount;
}

if ( $method == "roomPopup" || $method == "calendarRoomPopup" ) {
	$resItemInfo['rv_item_date_arrive']		= $itemInfo[1];
	$resItemInfo['rv_item_date_depart']		= $itemInfo[2];
	$rateGroups = explode("~",$itemInfo[4]);
	list(,$resItemInfo['rv_item_accomm_count']) = explode("_",array_shift($rateGroups));
	$adults = $children = 0;
	foreach($rateGroups as $rateGroupRaw) {
		list($rateGroupId,$amount) = explode("_",$rateGroupRaw);
		$class = $GLOBALS['lDB']->get("
			SELECT
				rt_rate_group_class
			FROM
				rt_rate_group
			WHERE
				rt_rate_group_ix = '$rateGroupId'
		",4);
		switch($class) {
		case 1:
			$adults += $amount;
			break;
		case 2:
			$children += $amount;
			break;
		}
	}

	$resItemInfo['rv_item_adult_count']		= $adults;
	$resItemInfo['rv_item_child_count']		= $children;
	//$resItemInfo['rv_item_accomm_count']	= $itemInfo[4];
	$resItemInfo['ac_accomm_type_id']			= $itemInfo[0];

	$resItemInfo['pr_name_last'] = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_last
		FROM
			ac_accomm_type
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id 
		WHERE
			ac_accomm_type.ac_accomm_type_ix = '" . $itemInfo[0] . "'
	",4);

	$resItemInfo['pr_business_id'] = $GLOBALS['lDB']->get("SELECT pr_business_id FROM ac_accomm_type WHERE ac_accomm_type.ac_accomm_type_ix = '$itemInfo[0]'",4);
	$resItemInfo['ac_accomm_desc'] = $GLOBALS['lDB']->get("SELECT ac_accomm_desc FROM ac_accomm_type WHERE ac_accomm_type.ac_accomm_type_ix = '$itemInfo[0]'",4);
	$resItemInfo['rv_reservation_ix'] = "";
	$resItemInfo['rv_res_name'] = "New Reservation";

	$accommCount = $resItemInfo['rv_item_accomm_count'];
	$allocCount = sizeof($roomList);
	$unallocCount = $accommCount;
}

$propertyDB = $GLOBALS['lDB']->get("
	SELECT
		rf_db_code
	FROM
		rf_db_business
	WHERE
		pr_business_id = '$resItemInfo[pr_business_id]'
",4);

$groupStatus = $GLOBALS['lDB']->get("
	SELECT
		rv_grp_status_ind
	FROM
		rv_res_item_group
	WHERE
		rv_res_item_group.rv_res_item_group_ix = '$groupId'		
",4);
$GLOBALS['temp']['groupStatus'] = $groupStatus ? $groupStatus : 0;

if ( $groupStatus == "8" ) {
	$groupStatusTime = $GLOBALS['lDB']->get("
		SELECT
			rv_grp_status_time
		FROM
			rv_res_item_group
		WHERE
			rv_res_item_group.rv_res_item_group_ix = '$groupId'		
	",4);
	$groupStatusTimeArray = explode(" ",$groupStatusTime);
	$resItemInfo['rv_item_date_depart'] = $groupStatusTimeArray[0];
}

$GLOBALS['temp']['noneRowClass'] = "";

if ( $groupStatus == "5" ) {
	$GLOBALS['temp']['noneRowClass'] = " class=\"collapse\" ";
}

$GLOBALS['temp']['allowCheckIn'] = "";

if (
  $propertyDB != $GLOBALS['dbcode'] 
  || $GLOBALS['jobLevelArray'][234] < 10
  || $groupStatus == "5" 
  || $resStatus != "30" 
  || date("Y-m-d") < $resItemInfo['rv_item_date_arrive']
  || date("Y-m-d") > $resItemInfo['rv_item_date_depart']
  || $method == "calendar"
  || $method == "calendarRoomPopup"
) {
	$GLOBALS['temp']['allowCheckIn'] = "disabled";
}

$GLOBALS['temp']['dateArrive']		= chng_date($resItemInfo['rv_item_date_arrive'],"-");
$GLOBALS['temp']['dateDepart']		= chng_date($resItemInfo['rv_item_date_depart'],"-");
$GLOBALS['temp']['adultCount']		= $resItemInfo['rv_item_adult_count'];
$GLOBALS['temp']['childCount']		= $resItemInfo['rv_item_child_count'];
$GLOBALS['temp']['propertyName']	= t_encodeHTMLField($resItemInfo['pr_name_last']);
$GLOBALS['temp']['accommType']		= t_encodeHTMLField($resItemInfo['ac_accomm_desc']);

$GLOBALS['temp']['optionals'] = t_encodeHTMLField(getOptionalComponents($resItemId));

$GLOBALS['temp']['rv_reservation_ix']	= $resItemInfo['rv_reservation_ix'];
$GLOBALS['temp']['rv_res_name']				= $resItemInfo['rv_res_name'];
$GLOBALS['temp']['roomTitle']					= "Change / Check-In Room";
$GLOBALS['temp']['resStatus'] = isset($resItemInfo['rf_reservation_status_id']) ? $resItemInfo['rf_reservation_status_id'] : "25"; // if res not created yet, 25 = "In progress"

if ( $method == "allocate" ) {
	$GLOBALS['temp']['roomTitle'] = "Allocate Room";
}

if ( $method == "change" ) {
	$GLOBALS['temp']['roomTitle'] = "Change Room";
}

if ( $method == "checkin" ) {
	$GLOBALS['temp']['roomTitle'] = "Check-In Room";
}

if ( $method == "upgrade" || $method == "calendar" || $method == "roomPopup" || $method == "calendarRoomPopup" ) {
	$GLOBALS['temp']['roomTitle'] = "Room Functions";
}

$GLOBALS['temp']['guestNames'] = getGuestNames($groupId);

if ( $method == "upgrade" || $method == "calendar" || $method == "roomPopup" || $method == "calendarRoomPopup" ) {
	$accommList = $GLOBALS['lDB']->get("
		SELECT
			ac_accomm_type_ix
		FROM
			ac_accomm_type
		WHERE
			pr_business_id = '" . $resItemInfo['pr_business_id'] . "'
	",3);
	$accommWhere = " ac_accomm_room.ac_accomm_type_id IN ('".join("','",$accommList)."') ";
} else {
	$accommWhere = " ac_accomm_room.ac_accomm_type_id = '" . $resItemInfo['ac_accomm_type_id'] . "' ";
}

$roomArray = $GLOBALS['lDB']->get("
	SELECT
		ac_accomm_room.ac_accomm_room_ix as id,
		ac_accomm_room.ac_desc,
		ac_accomm_type.ac_accomm_type_ix,
		ac_accomm_type.ac_accomm_desc
	FROM
		ac_accomm_room
		INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
		INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
	WHERE
		" . $accommWhere . "
		AND ac_accomm_room_inactive_yn = '0'
		AND ac_accomm_type.ac_accomm_type_inactive_yn = '0'
	ORDER BY
		ac_accomm_type.ac_accomm_desc,
		ac_accomm_room.ac_desc+0,
		ac_accomm_room.ac_desc
",2);

// Cut out used rooms ---------------------------------------------------------
$newRoomArray = array();
foreach ( $roomArray as $item ) {
	// Check for bookings during this time period --------------------------------
	$allowRooms = "";
	if ( $method == "calendar" || $method == "roomPopup" || $method == "calendarRoomPopup" ) {
		// Allow rooms in the current reservation (if the calendar) -----------------
		$allowRooms = " AND (rv_res_item_group.ac_accomm_room_id NOT IN ('".join("','",$roomList)."') )";
	}

	$roomCheck = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			rv_res_item_group
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
		WHERE
			ac_accomm_room_id = '" . $item['id'] . "'
			AND (
					(
						rv_reservation_item.rv_item_date_arrive >= '" . $resItemInfo['rv_item_date_arrive'] . "'
						AND rv_reservation_item.rv_item_date_arrive < '" . $resItemInfo['rv_item_date_depart'] . "'
					) OR (
						(
							(
								rv_reservation_item.rv_item_date_depart > '" . $resItemInfo['rv_item_date_arrive'] . "'
								AND rv_res_item_group.rv_grp_status_ind <> '8'
							) OR (
								rv_res_item_group.rv_grp_status_time > '" . $resItemInfo['rv_item_date_arrive'] . " 23:59:59'
								AND rv_res_item_group.rv_grp_status_ind = '8'
							)
						) AND (
							(
								rv_reservation_item.rv_item_date_depart <= '" . $resItemInfo['rv_item_date_depart'] . "'
								AND rv_res_item_group.rv_grp_status_ind <> '8'
							) OR (
								rv_res_item_group.rv_grp_status_time <= '" . $resItemInfo['rv_item_date_depart'] . " 23:59:59'
								AND rv_res_item_group.rv_grp_status_ind = '8'
							)
						)
					) OR (
						rv_reservation_item.rv_item_date_arrive < '" . $resItemInfo['rv_item_date_arrive'] . "'
						AND (
							(
								rv_reservation_item.rv_item_date_depart > '" . $resItemInfo['rv_item_date_depart'] . "'
								AND rv_res_item_group.rv_grp_status_ind <> '8'
							) OR (
								rv_res_item_group.rv_grp_status_time > '" . $resItemInfo['rv_item_date_depart'] . " 23:59:59'
								AND rv_res_item_group.rv_grp_status_ind = '8'
							) 
						)
					) OR (
						rv_res_item_group.rv_grp_status_ind = '5'
						AND '" . $resItemInfo['rv_item_date_arrive'] . "' < '" . date("Y-m-d") . "'
					)
			) " . $allowRooms
	,4);

	// Check for blocks ----------------------------------------------------------
	$blockCheck = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			ac_accomm_room_block
		INNER JOIN ac_accomm_block ON 
			ac_accomm_block.ac_accomm_block_ix = ac_accomm_room_block.ac_accomm_block_id
		WHERE
			ac_accomm_room_id = '" . $item['id'] . "'
		AND
			(
				(
					'" . $resItemInfo['rv_item_date_arrive'] . "' >= ac_accomm_block.ac_start_date 
					AND 
					'" . $resItemInfo['rv_item_date_arrive'] . "' < ac_accomm_block.ac_end_date
				) OR (
					'" . $resItemInfo['rv_item_date_depart'] . "' > ac_accomm_block.ac_start_date 
					AND 
					'" . $resItemInfo['rv_item_date_depart'] . "' <= ac_accomm_block.ac_end_date
				) OR (
					'" . $resItemInfo['rv_item_date_arrive'] . "' < ac_accomm_block.ac_start_date 
					AND 
					'" . $resItemInfo['rv_item_date_depart'] . "' > ac_accomm_block.ac_end_date
				)									
			)
	",4);

	$checkInCheck = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			rv_res_item_group
		WHERE
			rv_res_item_group.ac_accomm_room_id = '" . $item['id'] . "'
			AND rv_res_item_group.rv_grp_status_ind = '5'
	",4);

	if ( $checkInCheck > 0 ) {
		$allowCheckIn = "false";
	} else {
		$allowCheckIn = "true";
	}

	if ( ($blockCheck == 0 && $roomCheck == 0) || $item['id'] == $roomId ) {
		array_push($newRoomArray, array(
			'id' => $item['id'],
			'ac_desc' => $item['ac_desc'],
			'ac_accomm_type_ix' => $item['ac_accomm_type_ix'],
			'ac_accomm_desc' => $item['ac_accomm_desc'],
			'allowCheckIn' => $allowCheckIn
		));
	}
}

$roomArray = $newRoomArray;

$rowHTML = "
	<tr class=\"!filterable!\">\n
		<td class=\"uk-table-shrink \"><input id=\"chk!id!\" class=\"!checkClass! uk-margin-small-right\" type=\"!checkType!\" name=\"room\" value=\"!id!\" !checked! onclick=\"clickCheck(!allowCheckIn!,this);\" /></td>
		<td><label for=\"chk!id!\">!ac_desc!</label></td>
	</tr>
";

$GLOBALS['temp']['allocCount'] = "0";

if ( $method == "calendar" || $method == "roomPopup" || $method == "calendarRoomPopup" ) {
	$GLOBALS['temp']['allocCount'] = sizeof($roomList);
}

if ( $groupId == "" && $unallocCount > 1 ) {
	$rowHTML = str_replace("!checkType!","checkbox",$rowHTML);
	$GLOBALS['temp']['unallocCount'] = $unallocCount;
} else {
	$rowHTML = str_replace("!checkType!","radio",$rowHTML);
	$GLOBALS['temp']['unallocCount'] = "1";
}

$rows	= "";
$noneChecked = "checked";
$GLOBALS['temp']['noneClass'] = "";
$GLOBALS['temp']['noneHover'] = "";

$countExtra = $GLOBALS['lDB']->get("
	SELECT
		count(rv_extra_id)
	FROM
		rv_extra
	WHERE
		rv_extra.rv_res_item_group_id = '" . $groupId . "'
	AND 
		rv_extra.rv_extra_void_ind = '0'
",4);

$countGuest = $GLOBALS['lDB']->get("
	SELECT
		count(rv_res_item_guest_id)
	FROM
		rv_res_item_guest
	WHERE
		rv_res_item_group_id = '" . $groupId . "'
",4);

if(trim($groupId != "") && $countExtra > 0 && $countGuest == 0) {
	$noneChecked = "disabled";
	$GLOBALS['temp']['noneClass'] = "txtg";
	$GLOBALS['temp']['noneHover'] = "onmouseout=\"nd();\" onmouseover=\"overlib('There are extras billed to this room. In order to deallocate the room you must either remove the extras or allocate a guest to the room group.');\"";
}


$ac_accomm_type_ix = null;
$GLOBALS['temp']['allowCurrentCheckIn'] = "disabled";

foreach ( $roomArray as $item ) {
	if ( $ac_accomm_type_ix !== $item['ac_accomm_type_ix'] && ($method == "upgrade" || $method == "calendar" || $method == "roomPopup" || $method == "calendarRoomPopup") ) {
		$rows .= 
			str_replace("!filterable!","accomm-type",
			str_replace("!id!","",
			str_replace("!ac_desc!","" . t_encodeHTMLField($item['ac_accomm_desc']) . "",
			str_replace("!checked!","",
			str_replace("!allowCheckIn!",$item['allowCheckIn'],
			str_replace("!checkClass!","collapse",$rowHTML
		))))));
		$ac_accomm_type_ix = $item['ac_accomm_type_ix'];
	}

	$attrArray = $GLOBALS['lDB']->get("
		SELECT
			rt_component_desc
		FROM
			ac_accomm_room_attr
		INNER JOIN rt_component ON 
			ac_accomm_room_attr.rt_component_id = rt_component.rt_component_ix
		WHERE
			ac_accomm_room_attr.ac_accomm_room_id = '" . $item['id'] . "'
	",3);

	$attrNames = join(", ",$attrArray);

	if ( $attrNames != "" ) {
		$attrNames = "(".$attrNames.")";
	}

	if ( $item['id'] == $roomId || ( ($method == "calendar" || $method == "roomPopup" || $method == "calendarRoomPopup") && in_array($item['id'],$roomList) ) ) {
		$checked = "checked";

/*		if ( $noneCheck == "checked" ) {
			$noneChecked = "";
}*/

		if ( $item['allowCheckIn'] == "true" ) {
			$GLOBALS['temp']['allowCurrentCheckIn'] = "";
		}
	} else {
		$checked = "";
	}

	$rows .= str_replace("!id!",$item['id'],
		str_replace("!ac_desc!",t_encodeHTMLField($item['ac_desc']." $attrNames"),
		str_replace("!filterable!","accom",
		str_replace("!checked!",$checked,
		str_replace("!allowCheckIn!",$item['allowCheckIn'],
		str_replace("!checkClass!","uk-radio",$rowHTML
	))))));
}

$GLOBALS['temp']['rows'] = $rows;
$GLOBALS['temp']['noneChecked'] = $noneChecked;

if ( $method != "calendar" && $method != "roomPopup" && $method != "calendarRoomPopup" ) {
	$requestInfo = $GLOBALS['lDB']->get("
		SELECT
			rv_room_requested_yn,
			rv_room_request_reason
		FROM
			rv_res_item_group
		WHERE
			rv_res_item_group.rv_res_item_group_ix = '$groupId'
	",2);

	$GLOBALS['temp']['requestCheck']	= "";
	$GLOBALS['temp']['requestReason']	= "";

	if(sizeof($requestInfo) > 0 && $requestInfo[0]['rv_room_requested_yn'] ) {
		$GLOBALS['temp']['requestCheck']	= "checked";
		$GLOBALS['temp']['requestReason']	= $requestInfo[0]['rv_room_request_reason'];
	}
} else {
	$GLOBALS['temp']['requestCheck']	= "";
	$GLOBALS['temp']['requestReason']	= "";

	if ( $requestYN == "1" ) {
		$GLOBALS['temp']['requestCheck']	= "checked";
		$GLOBALS['temp']['requestReason']	= $requestReason;
	}
}

$GLOBALS['temp']['dateNow'] = chng_date(date("Y-m-d"),"-");
		 

function getOptionalComponents($resItemId) {
	$compArray = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			rt_component.rt_component_abbrv
		FROM
			rv_res_item_comp
		INNER JOIN rt_component ON
			rv_res_item_comp.rt_component_id = rt_component.rt_component_ix
		WHERE
			rv_res_item_comp.rv_reservation_item_id = '$resItemId'
		AND 
			rv_item_comp_option_yn = '1' 
		ORDER BY 
			rt_component.rt_component_abbrv
	",2);

	$compList = "";
	foreach ( $compArray as $item ) {
		if ( $compList != "" ) {
			$compList .= ", ";
		}
		$compList .= $item['rt_component_abbrv'];
	}

	if ( $compList != "" ) {
		$compList = "(" . $compList . ")";
	}
	return $compList;
}

function getGuestNames($rv_res_item_group_id) {
	$guestNameList = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_last,
			pr_persona.pr_name_first
		FROM
			rv_res_item_guest
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
		WHERE
			rv_res_item_guest.rv_res_item_group_id = '" . $rv_res_item_group_id . "'
	",2);
	$guestNames = "";

	foreach ( $guestNameList as $item ) {
		$guestName = trim($item['pr_name_first'] . " " . $item['pr_name_last']);

		if ( $guestNames != "" && $guestName != "" ) {
			$guestNames .= ", ";
		}

		$guestNames .= $guestName;
	}
	return $guestNames;
}
