<?php

/**
 * init.form286.php - Rooming calendar (historical)
 * Job: 226
 * Function: 81 (Rooming calendar)
*/

if (!isset($GLOBALS[$form])) {
   $GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rooming_cal.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],9,"");

$thisSession = array_slice($_SERVER['argv'],1,8);
if($_SERVER['argv'][1] == "last") {
	$thisSession = $_SESSION['calendarParms'];
	$_SERVER['argv'][1] = $thisSession[0];
	$_SERVER['argv'][2] = $thisSession[1];
	$_SERVER['argv'][3] = $thisSession[2];
	$_SERVER['argv'][4] = $thisSession[3];
	$_SERVER['argv'][5] = $thisSession[4];
	$_SERVER['argv'][6] = $thisSession[5];
	$_SERVER['argv'][7] = $thisSession[6];
	$_SERVER['argv'][8] = $thisSession[7];
} else {
	session_set("calendarParms",$thisSession);
}


$fromDate = useDate("from", $_SERVER['argv'][1]);
$dayCount = $_SERVER['argv'][2];
$propertyACL= $GLOBALS['lDB']->get("
         SELECT DISTINCT
            ac_accomm_type.pr_business_id
         FROM
            sc_accomm, ac_accomm_type, pr_business, pr_persona
         WHERE
            sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
         AND
            sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
         AND
            ac_accomm_type.ac_accomm_type_inactive_yn=0
         AND
            ac_accomm_type.pr_business_id = pr_business.pr_business_id
         AND
            pr_business.pr_bus_inactive_yn= '0'
         AND
            pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id",3);
$propertyId = $_SERVER['argv'][3];
if($propertyId == "" || !in_array($propertyId,$propertyACL)) {
   //$propertyId = $propertyACL[0];
}
$accommACL = $GLOBALS['lDB']->get("
   SELECT DISTINCT
      ac_accomm_type.ac_accomm_type_ix
   FROM
      ac_accomm_type
   WHERE
      pr_business_id = '$propertyId'
",3);
/*$accommId = $_SERVER['argv'][4];
if($accommId == "" || !in_array($accommId,$accommACL)) {
   //$accommId = $accommACL[0];
}*/


$propertyName = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '$propertyId'",4);
$extraCategoryFilter = useFilter("extraCategory", $_SERVER['argv'][5], "SELECT ac_extra_cat_desc  FROM ac_extra_category WHERE ac_extra_category_ix =", "ac_extra_category_id", false, false, false);


$options = $_SERVER['argv'][6];

$advClass = $_SERVER['argv'][7];
$GLOBALS['temp']['advClass'] = urldecode($advClass);
if($advClass == ""){
   $GLOBALS['temp']['advClass'] = "collapse printCollapse";
}

$filterStatus = $_SERVER['argv'][8];
$GLOBALS['temp']['filterStatus'] = urldecode($filterStatus);
if($filterStatus == ""){
   $GLOBALS['temp']['filterStatus'] = "expand";
}

$GLOBALS['temp']['dayCount7Selected'] = "";
$GLOBALS['temp']['dayCount14Selected'] = "";
$GLOBALS['temp']['dayCount21Selected'] = "";
$GLOBALS['temp']['dayCount28Selected'] = "";
if($dayCount == 7) {
   $GLOBALS['temp']['dayCount7Selected'] = "SELECTED";
}
if($dayCount == 14) {
   $GLOBALS['temp']['dayCount14Selected'] = "SELECTED";
}
if($dayCount == 21) {
   $GLOBALS['temp']['dayCount21Selected'] = "SELECTED";
}
if($dayCount == 28) {
   $GLOBALS['temp']['dayCount28Selected'] = "SELECTED";
}

$GLOBALS['temp']['propertyId'] = $propertyId;
//$GLOBALS['temp']['accommId'] = $accommId;
if($propertyId == "") {
	$GLOBALS['temp']['propertyName'] = "";
	$GLOBALS['temp']['accommName'] = "";
} else {
	$GLOBALS['temp']['propertyName'] = $propertyName;
	$GLOBALS['temp']['accommName'] = isset($accommName)?$accommName:"";
}	

// var checkList = new Array("guestInfo","resNotes","resNation","intMemos","agent","resExtras","option","roomExtras","resTravel","roomTravel");

$GLOBALS['temp']['guestInfoChecked'] = "";
$GLOBALS['temp']['resNotesChecked'] = "";
$GLOBALS['temp']['resNationChecked'] = "";
$GLOBALS['temp']['intMemosChecked'] = "";
$GLOBALS['temp']['agentChecked'] = "";
$GLOBALS['temp']['resExtrasChecked'] = "";
$GLOBALS['temp']['optionChecked'] = "";
$GLOBALS['temp']['roomExtrasChecked'] = "";
$GLOBALS['temp']['resTravelChecked'] = "";
$GLOBALS['temp']['roomTravelChecked'] = "";

$guestClass = "class=\"collapse\"";
$nationalityClass = "class=\"collapse\"";
$agentClass = "class=\"collapse\"";
$optionalClass = "class=\"collapse\"";
$resNoteClass = "class=\"collapse\"";
$resMemoClass = "class=\"collapse\"";
$extraClass = "class=\"collapse\"";
$travelClass = "class=\"collapse\"";
$extraRoomClass = "class=\"collapse\"";
$travelRoomClass = "class=\"collapse\"";

if(($options & 8184) == 0 && $_SERVER['argv'][1] != "") {
   $options |= 8184;
}

if($options & 8) {
   $GLOBALS['temp']['guestInfoChecked'] = "CHECKED";
   $guestClass = "class=\"expand\"";
}
if($options & 16) {
   $GLOBALS['temp']['resNotesChecked'] = "CHECKED";
   $resNoteClass = "class=\"expand\"";
}
if($options & 32) {
   $GLOBALS['temp']['resNationChecked'] = "CHECKED";
   $nationalityClass = "class=\"expand\"";
}
if($options & 64) {
   $GLOBALS['temp']['intMemosChecked'] = "CHECKED";
   $resMemoClass = "class=\"expand\"";
}
if($options & 128) {
   $GLOBALS['temp']['agentChecked'] = "CHECKED";
   $agentClass = "class=\"expand\"";
}
if($options & 256) {
   $GLOBALS['temp']['resExtrasChecked'] = "CHECKED";
   $extraClass = "class=\"expand\"";
}
if($options & 512) {
   $GLOBALS['temp']['optionChecked'] = "CHECKED";
   $optionalClass = "class=\"expand\"";
}
if($options & 1024) {
   $GLOBALS['temp']['extrasRoomChecked'] = "CHECKED";
   $extraRoomClass = "class=\"expand\"";
}
if($options & 2048) {
   $GLOBALS['temp']['resTravelChecked'] = "CHECKED";
   $travelClass = "class=\"expand\"";
}
if($options & 4096) {
   $GLOBALS['temp']['travelRoomChecked'] = "CHECKED";
   $travelRoomClass = "class=\"expand\"";
}

switch($options & 7) {
   case REP_VIEW_HTML:
      $renderMode = "html";
      $renderType = "";
      break;
   case REP_VIEW_PDF:
      $renderMode = "pdf";
      $renderType = "view";
      break;
   case REP_EMAIL_PDF:
      $renderMode = "pdf";
      $renderType = "email";
      break;
   case REP_SEND_PDF:
      $renderMode = "pdf";
      $renderType = "send";
      break;
   case REP_VIEW_CSV:
      $renderMode = "csv";
      $renderType = "";
}


if($_SERVER['argv'][1] != "") {
   $GLOBALS['temp']['reportGenerated'] = "";

# Get the room list....
$roomList = $GLOBALS['lDB']->get("
   SELECT
      ac_accomm_room.ac_accomm_room_ix as id,
      ac_accomm_room.ac_desc as name,
	  ac_accomm_type.ac_accomm_name_short as accommName
   FROM
      ac_accomm_room
	  INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
   WHERE
      ac_accomm_room.ac_accomm_type_id IN ('".join("','",$accommACL)."')
      AND ac_accomm_room.ac_accomm_room_inactive_yn = 0
",2);

# Generate the date range....
$startDate = strtotime($fromDate['jsDate']);
$dateList = array();
for($count = 0; $count < $dayCount; $count++) {
   $currDate = $startDate + ( 86400 * $count );
   $weekDay = date("D",$currDate);
   $dateRaw = date("Y-m-d",$currDate);
   $dateFormat = date("d M Y",$currDate);
   array_push($dateList,array('dateRaw'=>$dateRaw, 'dateFormat'=>$dateFormat, 'weekDay'=>$weekDay));
}

# For each room, give it a date range, then get info on each date.
foreach($roomList as $roomKey=>$roomItem) {
   $attrList = $GLOBALS['lDB']->get("
      SELECT
         rt_component.rt_component_desc
      FROM
         ac_accomm_room_attr
         INNER JOIN rt_component ON rt_component.rt_component_ix = ac_accomm_room_attr.rt_component_id
      WHERE
         ac_accomm_room_attr.ac_accomm_room_id = '$roomItem[id]'
   ",3);
   $roomList[$roomKey]['attr'] = join(", ",$attrList);
   $roomList[$roomKey]['period'] = $dateList;
   foreach($roomList[$roomKey]['period'] as $dateKey=>$dateItem) {
	   if(trim($extraCategoryFilter['where']) != "") {
		   $extraWhere = $extraCategoryFilter['where'] . "
            AND (
               (
                  rv_extra.pr_business_id = '0'
                  AND rv_extra.rv_extra_date_serv = '0000-00-00'
               ) OR (
                  rv_extra.pr_business_id = '0'
                  AND rv_extra.rv_extra_date_serv = '$dateItem[dateRaw]'
               ) OR (
                  rv_extra.pr_business_id = rv_reservation_item.pr_business_id
                  AND rv_extra.rv_extra_date_serv = '0000-00-00'
               ) OR (
                  rv_extra.pr_business_id = rv_reservation_item.pr_business_id
                  AND rv_extra.rv_extra_date_serv = '$dateItem[dateRaw]'
               )
            )
			AND (
				rv_extra.rv_res_item_group_id = ''
				OR rv_extra.rv_res_item_group_id IS NULL
				OR rv_extra.rv_res_item_group_id = '0'
				OR rv_extra.rv_res_item_group_id = rv_res_item_group.rv_res_item_group_ix
			)
		
		   ";
	   }
      $roomInfo = $GLOBALS['lDB']->get("
         SELECT DISTINCT
            rv_reservation_item.rv_reservation_id as resId,
            rv_reservation_item.rv_reservation_item_ix as resItemId,
            rf_reservation_status. rf_reservation_status_desc as statusDesc,
            rv_reservation.rv_note_general as resNote,
            rv_note_internal as resMemo,
            pr_persona.pr_name_last as agentName,
            rf_country.rf_country_name as countryName,
            rv_res_item_group.rv_res_item_group_ix as resItemGroupId,
            rv_reservation_item.pr_business_id as businessId,
            rv_reservation_item.rv_item_date_arrive as resItemArrive,
            rv_reservation_item.rv_item_date_depart as resItemDepart
         FROM
            rv_reservation_item
            INNER JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
            INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
            INNER JOIN rf_reservation_status ON  rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
            LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
            LEFT JOIN rf_country ON rf_country.rf_country_ix = rv_reservation.rf_country_id
			LEFT JOIN rv_extra ON rv_extra.rv_reservation_id = rv_reservation_item.rv_reservation_id
            LEFT JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
         WHERE
            rv_item_date_arrive <= '$dateItem[dateRaw]'
            AND rv_item_date_depart > '$dateItem[dateRaw]'
            AND rv_res_item_group.ac_accomm_room_id = '$roomItem[id]'
			".(isset($extraWhere)?$extraWhere:"")."

      ",1);
      if($roomInfo['agentName'] == ""  || $roomInfo['agentName'] == "0") {
         $roomInfo['agentName'] == "Direct";
      }
      $roomList[$roomKey]['period'][$dateKey]['resId'] = $roomInfo['resId'];
	  if(checkJob(2)) {
      	$roomList[$roomKey]['period'][$dateKey]['resJob'] = "2";
	  } else {
      	$roomList[$roomKey]['period'][$dateKey]['resJob'] = "0";
	  }		  
      $roomList[$roomKey]['period'][$dateKey]['resItemId'] = $roomInfo['resItemId'];
      $roomList[$roomKey]['period'][$dateKey]['statusDesc'] = substr($roomInfo['statusDesc'],0,1);
      $roomList[$roomKey]['period'][$dateKey]['resNote'] = $roomInfo['resNote'];
      $roomList[$roomKey]['period'][$dateKey]['resMemo'] = $roomInfo['resMemo'];
      $roomList[$roomKey]['period'][$dateKey]['agentName'] = $roomInfo['agentName'];
      $roomList[$roomKey]['period'][$dateKey]['countryName'] = $roomInfo['countryName'];
      $roomList[$roomKey]['period'][$dateKey]['components'] = getOptionalComponents($roomInfo['resItemId']);

      $guestInfo = $GLOBALS['lDB']->get("
         SELECT
            pr_persona.pr_name_last,
            pr_persona.pr_name_first
         FROM
            rv_res_item_guest
            INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
         WHERE
            rv_res_item_guest.rv_res_item_group_id = '$roomInfo[resItemGroupId]'
      ",2);
      $guestList = array();
      foreach($guestInfo as $guestItem) {
         $name = $guestItem['pr_name_last'];
         if($guestItem['pr_name_first'] != "" && $guestItem['pr_name_first'] != "0") {
			if(trim($name) != "") {
			   $name .= ", ";
		  	}	   
            $name .= $guestItem['pr_name_first'];
         }
         array_push($guestList,$name);
      }
      $roomList[$roomKey]['period'][$dateKey]['guestList'] = $guestList;

      $extraInfo = $GLOBALS['lDB']->get("
         SELECT
            rv_extra.rv_extra_note as extraNote,
            rv_extra.rv_extra_note_internal as extraMemo,
            rv_extra.rv_extra_ind as extraInd,
            ac_extra.ac_ext_desc as extraName,
            rv_extra.rv_extra_units as extraUnits
         FROM
            rv_extra
            INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
         WHERE
            rv_extra.rv_reservation_id = '$roomInfo[resId]'
            AND (
               (
                  rv_extra.pr_business_id = '0'
                  AND rv_extra.rv_extra_date_serv = '0000-00-00'
               ) OR (
                  rv_extra.pr_business_id = '0'
                  AND rv_extra.rv_extra_date_serv = '$dateItem[dateRaw]'
               )
            )
			AND (
				rv_extra.rv_res_item_group_id = ''
				OR rv_extra.rv_res_item_group_id IS NULL
				OR rv_extra.rv_res_item_group_id = '0'
			)
         ORDER BY
            ac_extra.ac_ext_desc
      ",2);
      $roomList[$roomKey]['period'][$dateKey]['extraList'] = $extraInfo;


      $extraRoomInfo = $GLOBALS['lDB']->get("
         SELECT
            rv_extra.rv_extra_note as extraNote,
            rv_extra.rv_extra_note_internal as extraMemo,
            rv_extra.rv_extra_ind as extraInd,
            ac_extra.ac_ext_desc as extraName,
            rv_extra.rv_extra_units as extraUnits
         FROM
            rv_extra
            INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
			INNER JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_extra.rv_res_item_group_id
         WHERE
            rv_extra.rv_reservation_id = '$roomInfo[resId]'
            AND (
               (
                  rv_extra.pr_business_id = '0'
                  AND rv_extra.rv_extra_date_serv = '0000-00-00'
               ) OR (
                  rv_extra.pr_business_id = '0'
                  AND rv_extra.rv_extra_date_serv = '$dateItem[dateRaw]'
               )
            )
			AND rv_extra.rv_res_item_group_id <> ''
			AND rv_extra.rv_res_item_group_id IS NOT NULL
			AND rv_extra.rv_res_item_group_id <> '0'
			AND rv_res_item_group.ac_accomm_room_id = '$roomItem[id]'
         ORDER BY
            ac_extra.ac_ext_desc
      ",2);
      $roomList[$roomKey]['period'][$dateKey]['extraRoomList'] = $extraRoomInfo;
	  

   }
}


if($renderMode == "html") {

   /*<td height=\"30\" width=\"136\" class=\"outLt\">*/

$headerRowHTML = "
<td height=\"30\" width=\"90\" class=\"outLt\">
   <table cellspacing=\"0\" cellpadding=\"0\" width=\"90\">
   <tr>
      <td class=\"txtb\" align=\"center\">&nbsp;!date!</td>
   </tr>
   <tr>
      <td align=\"center\">&nbsp;!weekDay!</td>
   </tr>
   </table>
</td>
";

$headerRowFiller = "
   <td class=\"outLt\" height=\"30\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
";

$roomHeaderHTML = "
<tr>
   <td height=\"410\" width=\"90\" class=\"colLtt bb br bl\" id=\"room_!roomNum!\">&nbsp;<b>!name!</b><br>!attr!</td>
</tr>
";

$guestInfoHTML = "
<tr>
   <td height=\"15\">!name!</td>
</tr>
";

$extraInfoHTML = "
<tr>
   <td height=\"15\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
   <td class=\"link\" onMouseOver=\"if(!showNote!) {overlib('!note!',BELOW,HEIGHT,15,WIDTH,105)}\" onMouseOut=\"if(!showNote!){nd();}\">!unit!x !name!</td>
   <td align=\"right\">&nbsp;</td>
</tr>
";

$travelInfoHTML = "
<tr valign=\"top\">
   <td height=\"15\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
   <td onMouseOver=\"if(!showNote!){overlib('!note!',BELOW,HEIGHT,15,WIDTH,105)}\" onMouseOut=\"if(!showNote!){nd();}\">!unit! x !type!: <span id=\"travDesc\">!name!</span></td>
   <td align=\"right\">
   </td>
</tr>
";

$headerRow = "";
foreach($dateList as $item) {
   $headerRow .= str_replace("!date!",$item['dateFormat'],
      str_replace("!weekDay!",$item['weekDay'],$headerRowHTML));
}
if(sizeof($dateList) < 8) {
   $headerRow .= $headerRowFiller;
}
$GLOBALS['temp']['headerRow'] = $headerRow;

$roomRows = "";
$roomNum = 0;
foreach($roomList as $item) {
   $roomRows .= str_replace("!name!",$item['name'] . " ($item[accommName])",
      str_replace("!attr!",$item['attr'],
      str_replace("!roomNum!",$roomNum,$roomHeaderHTML)));
   $roomNum++;
}
$GLOBALS['temp']['roomHeaderRows'] = $roomRows;

$itemHTML = Join("", file(__DIR__ . "/../../../public/html/rooming_cal_item.htm"));

$items = "";
$roomNum = 0;
$resCol = array();
$currCol = 1;
srand(200);
foreach($roomList as $item) {
   $items .= "<tr>";
   $itemNum = 0;
   foreach($item['period'] as $periodItem) {
      $guestList = "";
      foreach($periodItem['guestList'] as $guestItem) {
         $guestList .= str_replace("!name!",$guestItem,$guestInfoHTML);
      }

      $extraList = "";
      $travelList = "";
      foreach($periodItem['extraList'] as $extraItem) {
			$note = "";
			if(trim($extraItem['extraNote']) != "") {
				$note .= "<u>Note</u><br>" . t_encodeOverlib($extraItem['extraNote']);
			}
			if(trim($extraItem['extraMemo']) != "") {
				if($note != "") {
					$note .= "<br><br>";
				}
				$note .= "<u>Internal Memo</u><br>" . t_encodeOverlib($extraItem['extraMemo']);
			}
			if($note != "") {
				$showNote = "true";
			} else {
				$showNote = "false";
			}
         if($extraItem['extraInd'] == "0") {
            $extraList .= str_replace("!name!",$extraItem['extraName'],
               str_replace("!note!",$note,
			   str_replace("!showNote!",$showNote,
			   str_replace("!unit!",$extraItem['extraUnits'],$extraInfoHTML))));
         } else {
            $type = "";
            if($extraItem['extraInd'] == "1") {
               $type = "Arr";
            }
            if($extraItem['extraInd'] == "2") {
               $type = "Dpt";
            }
            if($extraItem['extraInd'] == "3") {
               $type = "Xfr";
            }
            $travelList .= str_replace("!name!",$extraItem['extraName'],
               str_replace("!note!",$note,
			   str_replace("!showNote!",$showNote,
               str_replace("!type!",$type,
               str_replace("!unit!",$extraItem['extraUnits'],$extraInfoHTML)))));
         }
      }

      $extraRoomList = "";
      $travelRoomList = "";
      foreach($periodItem['extraRoomList'] as $extraItem) {
			$note = "";
			if(trim($extraItem['extraNote']) != "") {
				$note .= "<u>Note</u><br>" . t_encodeOverlib($extraItem['extraNote']);
			}
			if(trim($extraItem['extraMemo']) != "") {
				if($note != "") {
					$note .= "<br><br>";
				}
				$note .= "<u>Internal Memo</u><br>" . t_encodeOverlib($extraItem['extraMemo']);
			}
			if($note != "") {
				$showNote = "true";
			} else {
				$showNote = "false";
			}
         if($extraItem['extraInd'] == "0") {
            $extraRoomList .= str_replace("!name!",$extraItem['extraName'],
               str_replace("!note!",$note,
			   str_replace("!showNote!",$showNote,
			   str_replace("!unit!",$extraItem['extraUnits'],$extraInfoHTML))));
         } else {
            $type = "";
            if($extraItem['extraInd'] == "1") {
               $type = "Arr";
            }
            if($extraItem['extraInd'] == "2") {
               $type = "Dpt";
            }
            if($extraItem['extraInd'] == "3") {
               $type = "Xfr";
            }
            $travelRoomList .= str_replace("!name!",$extraItem['extraName'],
               str_replace("!note!",$note,
			   str_replace("!showNote!",$showNote,
               str_replace("!type!",$type,
               str_replace("!unit!",$extraItem['extraUnits'],$extraInfoHTML)))));
         }
      }	  

      if($periodItem['resId'] != "") {
         if(!in_array($periodItem['resId'],array_keys($resCol))) {
            //$resCol[$periodItem[resId]] = "grp".$currCol;
            $r = rand(127,255);
            $g = rand(127,255);
            $b = rand(127,255);
            $resCol[$periodItem['resId']] = sprintf("#%X%X%X",$r,$g,$b);
//          $currCol++;
            if($currCol > 5) { $currCol = 1; }
         }
         $hideGuests = "";
         $hideNationality = "";
         $hideAgent = "";
         $hideOptionals = "";
         $hideResNote = "";
         $hideResMemo = "";
         $hideExtras = "";
         $hideTravel = "";
		 $hideRoomExtras = "";
		 $hideRoomTravel = "";
         if($guestList == "") { $hideGuests = "style=\"display:none\""; }
         if($periodItem['countryName'] == "" || $periodName['countryName'] == "0") {
            $hideNationality = "style=\"display:none\"";
         }
         if($periodItem['agentName'] == "" || $periodName['agentName'] == "0") {
            $hideAgent = "style=\"display:none\"";
         }
         if($periodItem['components'] == "" || $periodName['components'] == "0") {
            $hideOptionals = "style=\"display:none\"";
         }
         if($periodItem['resNote'] == "" || $periodName['resNote'] == "0") {
            $hideResNote = "style=\"display:none\"";
         }
         if($periodItem['resMemo'] == "" || $periodName['resMemo'] == "0") {
            $hideResMemo = "style=\"display:none\"";
         }
         if($extraList == "") { $hideExtras = "style=\"display:none\""; }
         if($travelList == "") { $hideTravel = "style=\"display:none\""; }
         if($extraRoomList == "") { $hideRoomExtras = "style=\"display:none\""; }
         if($travelRoomList == "") { $hideRoomTravel = "style=\"display:none\""; }
         $items .= str_replace("!resId!",$periodItem['resId'],
		    str_replace("!resJob!",$periodItem['resJob'],
            str_replace("!statusDesc!",$periodItem['statusDesc'],
            str_replace("!roomNum!",$roomNum,
            str_replace("!itemNum!",$itemNum,
            str_replace("!guestInfo!",$guestList,
            str_replace("!extraInfo!",$extraList,
            str_replace("!travelInfo!",$travelList,
            str_replace("!extraRoomInfo!",$extraRoomList,
            str_replace("!travelRoomInfo!",$travelRoomList,
            str_replace("!nationality!",$periodItem['countryName'],
            str_replace("!agentName!",$periodItem['agentName'],
            str_replace("!components!",$periodItem['components'],
            str_replace("!resNote!",t_encodeOverlib($periodItem['resNote']),
            str_replace("!resMemo!",t_encodeOverlib($periodItem['resMemo']),
            str_replace("!hideItem!","",
            str_replace("!blankItem!","style=\"display:none\"",
            str_replace("!hideGuests!",$hideGuests,
            str_replace("!hideNationality!",$hideNationality,
            str_replace("!hideAgent!",$hideAgent,
            str_replace("!hideOptionals!",$hideOptionals,
            str_replace("!hideResNote!",$hideResNote,
            str_replace("!hideResMemo!",$hideResMemo,
            str_replace("!hideExtras!",$hideExtras,
            str_replace("!hideTravel!",$hideTravel,
            str_replace("!hideRoomExtras!",$hideRoomExtras,
            str_replace("!hideRoomTravel!",$hideRoomTravel,
            str_replace("!guestClass!",$guestClass,
            str_replace("!nationalityClass!",$nationalityClass,
            str_replace("!agentClass!",$agentClass,
            str_replace("!optionalClass!",$optionalClass,
            str_replace("!resNoteClass!",$resNoteClass,
            str_replace("!resMemoClass!",$resMemoClass,
            str_replace("!extraClass!",$extraClass,
            str_replace("!travelClass!",$travelClass,
            str_replace("!extraRoomClass!",$extraRoomClass,
            str_replace("!travelRoomClass!",$travelRoomClass,
            str_replace("!itemClass!",$resCol[$periodItem['resId']],
            $itemHTML))))))))))))))))))))))))))))))))))))));
      } else {
         $items .= str_replace("!hideItem!","style=\"display:none\"",
            str_replace("!blankItem!","",
            str_replace("!roomNum!",$roomNum,
            str_replace("!itemNum!",$itemNum,
            str_replace("!itemClass!","grp",
            $itemHTML)))));
      }

      $itemNum++;
   }
   $items .= "</tr>";
   $roomNum++;
}
$GLOBALS['temp']['items'] = $items;
$GLOBALS['temp']['rowCount'] = sizeof($roomList)+1;
$GLOBALS['temp']['roomCount'] = sizeof($roomList);
$GLOBALS['temp']['periodCount'] = sizeof($dateList);
}

if ($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {
   $pdf = new PDF("Room Allocation Calendar");
   $reportLabel = "Room Allocation Calendar";
   $headerArray = array(
      array(name => "From date", value => $fromDate['htmlDate'])
   );
   $pdf->ReportHeader($reportLabel, $headerArray);
   $pdfFontSize = 8;
   $pdf->SetFont('Arial', '', $pdfFontSize);
// $pdf->SetFont('Arial', '', 6);

   $pdf->Ln(2);

   for($count=0; $count<ceil(sizeof($dateList)/5); $count++) {
      $header = array(array(width=>"20%", data=>$propertyName . ", " . $accommName, border=>"LTBR", fill=>1));
      for($count2=$count*5; $count2 < ( (sizeof($dateList) < ($count*5) + 5) ? sizeof($dateList) : $count*5+5);
         $count2++) {
/*    foreach($dateList as $item) {*/
         array_push($header,array(width=>"15%", data=>$dateList[$count2]['dateRaw'], border=>"LTBR", fill=>1));
      }
      $pdf->Row($header);
      foreach($roomList as $item) {
         $row = array(array(width=>"20%", data=>$item['name']  . " ($item[accommName])" . ", " . $item['attr'], border=>"LTBR", fill=>1));
         for($count2=$count*5; $count2 < ( (sizeof($dateList) < ($count*5) + 5) ? sizeof($dateList) : $count*5+5);
            $count2++) {
            $cell = "";
            $cell .= $item['period'][$count2]['resId'] . "(" . $item['period'][$count2]['statusDesc'] . ")";
            $cell .= "\n".join("\n",$item['period'][$count2]['guestList']);
            $cell .= "\nAgent:";
            $cell .= "\n".$item['period'][$count2]['agentName'];
            array_push($row,
               array(width=>"15%", data=>$cell, border=>"LTBR")
            );

         }
         $pdf->Row($row);
      }
      $pdf->Ln(2);
   }



   if($renderType == "view") {
      $pdf->OutPut();
      die();
   }
   if($renderType == "send") {
      $to = $_POST['mail_to'];
      $from = $_POST['mail_from'];
      $subject = stripslashes($_POST['mail_subj']);
      $message = stripslashes($_POST['mail_body']);
      $attachmentName = $_POST['attachmentName'];

      $headers = "From: ".$GLOBALS['princName']."<$from>\r\n";

      // close the pdf
      if($pdf->state<3) $pdf->Close();

      /* and now mail it */
      if($attachmentName != "!attachmentName!") {
         $pdfName = $attachmentName;
      } else {
         $pdfName = "Update report from $fromDate to $toDate.pdf";
      }

      $error = email($from, $to, $subject, $headers, $message, 0, 0, $_SERVER['argv'][1], $GLOBALS['princName'],$pdf->buffer,$pdfName);     // (from, to, subject, headers, message, action, emailID, resID)
      if(!$error) {
         echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
         die();
      } else {
         echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
         die();
      }
   }

}


if($renderMode == "csv") {
   $csvFile = array();

   array_push($csvFile,array("Room Allocations Calendar"));
   array_push($csvFile,array());

   $header = array($propertyName . ", " . $accommName);
   foreach($dateList as $item) {
      array_push($header,$item['dateRaw']);
   }
   array_push($csvFile,$header);

   foreach($roomList as $item) {
      $row = array();
      array_push($row,"$item[name] ($item[accommName] - $item[attr])");
      foreach($item['period'] as $periodItem) {
         $cell = "";
		 if($periodItem['resId'] != "") {
	         $cell = "$periodItem[resId]";
    	     $guestList = join("\n",$periodItem['guestList']);
			 if(trim($guestList) != "") {
	        	 $cell .= "\n$guestList";
			 }
			 if(trim($periodItem['agentName']) != "") {
		         $cell .= "\nAgent:";
    		     $cell .= "\n$periodItem[agentName]";
			 }
			 if(trim($periodItem['components']) != "") {
	        	 $cell .= "\nOptionals:";
		         $cell .= "\n$periodItem[components]";
			 }
			 if(trim($periodItem['resNote']) != "") {
	    	     $cell .= "\n$periodItem[resNote]";
			 }
			 if(trim($periodItem['resMemo']) != "") {
		         $cell .= "\n$periodItem[resMemo]";
			 }
    	     $extras = "";
        	 $travel = "";
	         foreach($periodItem['extraList'] as $extraItem) {
    	        if($extraItem['extraInd'] == "0") {
        	       $extras .= "$extraItem[extraName]\n$extraItem[extraNote]\n$extraItem[extraMemo]";
            	} else {
	               $travel .= "$extraItem[extraName]\n$extraItem[extraNote]\n$extraItem[extraMemo]";
    	        }
        	 }
			 if($extras != "") {
		         $cell .= "\nRes Extras";
    		     $cell .= "\n$extras";
			 }
			 if($travel != "") {
	        	 $cell .= "\nRes Travel";
		         $cell .= "\n$travel";
			 }
		 }
         array_push($row,$cell);
      }
      array_push($csvFile,$row);
   }

   $csvText = "";
   foreach($csvFile as $csvLine) {
      $first = true;
      foreach($csvLine as $csvItem) {
         if(!$first) {
            $csvText .= ",";
         } else {
            $first = false;
         }
         $csvText .= "\"".str_replace("\"","\"\"",$csvItem)."\"";
      }
      $csvText .= "\n";
   }
   if(headers_sent()) {
      echo('Some data has already been output to browser, can\'t send CSV file');
   }
   header('Content-Type: text/csv');
   header("Cache-control: private");
   header('Content-Length: '.strlen($csvText));
   header("Content-Disposition: inline; filename=rooming_calender_".chng_date(date("Y-m-d"),"-").".csv");
   echo $csvText;
   flush();
   die();
}

   $GLOBALS['temp']['generated'] = "true";

} else {
   $GLOBALS['temp']['generated'] = "false";
   $GLOBALS['temp']['reportGenerated'] = "class=\"collapse\"";
}
//debug($roomList);


function getOptionalComponents($resItemId) {
   $compArray = $GLOBALS['lDB']->get("
      SELECT DISTINCT
         rt_component.rt_component_abbrv
      FROM
         rv_res_item_comp
      INNER JOIN rt_component ON
         rv_res_item_comp.rt_component_id = rt_component.rt_component_ix
      WHERE
         rv_res_item_comp.rv_reservation_item_id = '$resItemId'
         AND rv_item_comp_option_yn = '1' ORDER BY rt_component.rt_component_abbrv",2);
   $compList = "";
   foreach($compArray as $item) {
      if($compList != "") {
         $compList .= ", ";
      }
      $compList .= $item['rt_component_abbrv'];
   }
   if($compList != "") {
      $compList = $compList;
   }
   return $compList;
}
$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));
