<?php
/**
 * Current reservation listing by room
 */

if (!isset($GLOBALS[$form])) {
	$GLOBALS['form288'] = new Form("form288","",__DIR__ . "/../../../public/html/property_acc_res.htm");
}

if($_SERVER['argv'][1] != "block") {
	$roomId = $_SERVER['argv'][1];
	$date = date("Y-m-d");


	$roomName = $GLOBALS['lDB']->get("
		SELECT
			ac_desc
		FROM
			ac_accomm_room
		WHERE
			ac_accomm_room.ac_accomm_room_ix = '$roomId'
	",4);

/*	$GLOBALS['temp'][roomName] = $roomName;
	$GLOBALS['temp']['date'] = chng_date($date,"-");*/

	$GLOBALS['temp']['subTitle'] = "Room '$roomName' allocations from '".chng_date($date,"-")."'";

	$rowHTML = Join("", file(__DIR__ . "/../../../public/html/property_acc_res_rows.htm"));

	$today = date("Y-m-d");

	$resList = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			rv_reservation.rv_reservation_ix,
			rv_reservation.rv_res_name,
			rf_reservation_status.rf_reservation_status_desc,
			rv_reservation_item.rv_item_date_arrive as rv_date_arrive,
			rv_reservation_item.rv_item_date_depart as rv_date_depart,
			prAgent.pr_name_last as agent_name_last,
			prContact.pr_name_last as contact_name_last,
			prConsultant.pr_name_last as consultant_name_last,
			prAgent.pr_name_first as agent_name_first,
			prContact.pr_name_first as contact_name_first,
			prConsultant.pr_name_first as consultant_name_first
		FROM
			rv_res_item_group
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			INNER JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
			LEFT JOIN pr_persona AS prAgent ON prAgent.pr_persona_ix = rv_reservation.rv_agent_id
			LEFT JOIN pr_persona AS prContact ON prContact.pr_persona_ix = rv_reservation.rv_corr_persona_id
			LEFT JOIN pr_persona AS prConsultant ON prConsultant.pr_persona_ix = rv_reservation.rv_consultant_id
		WHERE
			rv_res_item_group.ac_accomm_room_id = '$roomId'
		AND (
			rv_reservation.rv_date_arrive >= '$today'
			OR rv_reservation.rv_date_depart > '$today'
		)
	",2);
	$onclickCode = "opener.opener.location = 'reservation.php?!resJob!+!resNum!'; opener.close(); window.close();";
	$rowHTML = str_replace("!onclickCode!",$onclickCode,$rowHTML);
} else {
	$roomArray = explode(":",$_SERVER['argv'][2]);
	$fromDate = $_SERVER['argv'][3];
	$toDate = $_SERVER['argv'][4];
	$rowHTML = Join("", file(__DIR__ . "/../../../public/html/property_acc_res_rows.htm"));

	$roomNames = $GLOBALS['lDB']->get("
		SELECT ac_desc FROM ac_accomm_room WHERE ac_accomm_room_ix IN ('".join("','",$roomArray)."')",3);

	$GLOBALS['temp']['subTitle'] = "Rooms '".join(", ",$roomNames)."' allocations from '".chng_date($fromDate,"-")."' to '".chng_date($toDate,"-")."'";

	$resList = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			rv_reservation.rv_reservation_ix,
			rv_reservation.rv_res_name,
			rf_reservation_status.rf_reservation_status_desc,
			rv_reservation_item.rv_item_date_arrive as rv_date_arrive,
			rv_reservation_item.rv_item_date_depart as rv_date_depart,
			rv_reservation_item.rv_reservation_item_ix,
			prAgent.pr_name_last as agent_name_last,
			prContact.pr_name_last as contact_name_last,
			prConsultant.pr_name_last as consultant_name_last,
			prAgent.pr_name_first as agent_name_first,
			prContact.pr_name_first as contact_name_first,
			prConsultant.pr_name_first as consultant_name_first
		FROM
			rv_res_item_group
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			INNER JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
			LEFT JOIN pr_persona AS prAgent ON prAgent.pr_persona_ix = rv_reservation.rv_agent_id
			LEFT JOIN pr_persona AS prContact ON prContact.pr_persona_ix = rv_reservation.rv_corr_persona_id
			LEFT JOIN pr_persona AS prConsultant ON prConsultant.pr_persona_ix = rv_reservation.rv_consultant_id
		WHERE
			rv_res_item_group.ac_accomm_room_id IN ('".join("','",$roomArray)."')
				AND (
					(
						rv_reservation_item.rv_item_date_arrive >= '".$fromDate."'
						AND rv_reservation_item.rv_item_date_arrive <= '".$toDate."'
					) OR (
						rv_reservation_item.rv_item_date_depart >= '".$fromDate."'
						AND rv_reservation_item.rv_item_date_depart <= '".$toDate."'
					)
				)
	",2);
	$onclickCode = "opener.opener.opener.location = 'reservation.php?!resJob!+!resNum!'; opener.opener.close(); opener.close(); window.close();";
	$rowHTML = str_replace("!onclickCode!",$onclickCode,$rowHTML);

}

$resJob = "215";
if(checkjob(216)) {
	$resJob = "216";
}

$rows = "";
foreach($resList as $item) {
	$agent = $item['agent_name_last'];
	if($item['agent_name_first'] != "" && $item['agent_name_first'] != "0") {
		$agent .= ", " . $item['agent_name_first'];
	}
	if(strlen($agent) > 8) {
		$agent = substr($agent,0,8) . "...";
	}
	$contact = $item['contact_name_last'];
	if($item['contact_name_first'] != "" && $item['contact_name_first'] != "0") {
		$contact .= ", " . $item['contact_name_first'];
	}
	if(strlen($contact) > 8) {
		$contact = substr($contact,0,8) . "...";
	}
	$consultant = $item['consultant_name_last'];
	if($item['consultant_name_first'] != "" && $item['consultant_name_first'] != "0") {
		$consultant .= ", " . $item['consultant_name_first'];
	}
	if(strlen($consultant) > 8) {
		$consultant = substr($consultant,0,8) . "...";
	}
	$propCount = $GLOBALS['lDB']->get("
		SELECT
			COUNT(DISTINCT pr_business_id)
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.rv_reservation_id = '".$item['rv_reservation_ix']."'
	",4);
	$components = (isset($item['rv_reservation_item_ix'])) ? getOptionalComponents($item['rv_reservation_item_ix']) : "";
	if(trim($components) == "") {
		$hasComponents = " class=\"collapse\" ";
	} else {
		$hasComponents = "";
	}
	$rows .= str_replace("!resNum!",$item['rv_reservation_ix'],
		str_replace("!resName!",$item['rv_res_name'],
		str_replace("!status!",$item['rf_reservation_status_desc'],
		str_replace("!arrive!",chng_date($item['rv_date_arrive'],"-"),
		str_replace("!depart!",chng_date($item['rv_date_depart'],"-"),
		str_replace("!agent!",$agent,
		str_replace("!contact!",$contact,
		str_replace("!consultant!",$consultant,
		str_replace("!propCount!",$propCount,
		str_replace("!resJob!",$resJob,
		str_replace("!hasAttributes!",$hasComponents,
		str_replace("!attributes!",$components,
		$rowHTML))))))))))));
}

$GLOBALS['temp']['rows'] = $rows;

function getOptionalComponents($resItemId) {
	$compArray = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			rt_component.rt_component_abbrv
		FROM
			rv_res_item_comp
		INNER JOIN rt_component ON
			rv_res_item_comp.rt_component_id = rt_component.rt_component_ix
		WHERE
			rv_res_item_comp.rv_reservation_item_id = '$resItemId'
			AND rv_item_comp_option_yn = '1' ORDER BY rt_component.rt_component_abbrv",2);
	$compList = "";
	foreach($compArray as $item) {
		if($compList != "") {
			$compList .= ", ";
		}
		$compList .= $item['rt_component_abbrv'];
	}
	if($compList != "") {
		$compList = $compList;
	}
	return $compList;
}
