<?php
 
/**
 * Form 294 - Extras quick search
 */

$today_datetime = date("j M Y H:i:s");

if(isset($_POST['url']) && $_POST['url'] != "") {
   $_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
   $_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],17,"");
$jobId = $_SERVER['argv'][0];
$princName = $_SERVER['argv'][1];
$propertyId = $_SERVER['argv'][1];
$serviceDate = $_SERVER['argv'][2];
$billingName = $_SERVER['argv'][3];
$statutory1 = $_SERVER['argv'][4];
$statutory2 = $_SERVER['argv'][5];
$statutory3 = $_SERVER['argv'][6];
$statutory1label = $_SERVER['argv'][7];
$statutory2label = $_SERVER['argv'][8];
$statutory3label = $_SERVER['argv'][9];
$chargedTo = $_SERVER['argv'][10];
$invoicedTo = $_SERVER['argv'][11];
$cashier = trim($GLOBALS['firstname']." ".$GLOBALS['lastname']);
$taxTotal = $_SERVER['argv'][12];
$grandTotal = $_SERVER['argv'][13];
$homeCurrency = $_SERVER['argv'][14];
$extrasList = $_SERVER['argv'][15];
$options = $_SERVER['argv'][16];
// Check if user is allowed to do cross invoicing
$sc_grp_cross_invoice_yn = $GLOBALS['lDB']->get("
	SELECT
		sc_group.sc_grp_cross_invoice_yn
	FROM
		sc_user
		INNER JOIN sc_group ON sc_group.sc_group_id = sc_user.sc_group_id
	WHERE
		sc_user.pr_user_id = '$GLOBALS[userid]'
",4);
$GLOBALS['temp']['sc_grp_cross_invoice_yn'] = $sc_grp_cross_invoice_yn ? "true" : "false";

switch($options & 3) {
   case REP_VIEW_HTML:
      $renderMode = "html";
      $renderType = "";
      break;
   case REP_VIEW_PDF:
      $renderMode = "pdf";
      $renderType = "view";
      break;
   case REP_EMAIL_PDF:
      $renderMode = "pdf";
      $renderType = "email";
      break;
   case REP_SEND_PDF:
      $renderMode = "pdf";
      $renderType = "send";
      break;
}

$GLOBALS['temp']['jobId'] = $jobId;

$GLOBALS['temp']['serviceY'] = date("Y");
$GLOBALS['temp']['serviceM'] = date("m");
$GLOBALS['temp']['serviceD'] = date("d");

if($renderMode == "pdf" && $renderType == "email") {
	if (!isset($GLOBALS[$form])) {
		$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/quick_entry_confirm.htm");
	} 
   $pdfName = "Extra Confirmation" . " for " . $serviceDate;
	$attachmentTable = "
		<table border=\"0\" cellspacing=\"0\" width=\"100%\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\"></td>
			<td id=\"attachmentLabel\" width=\"100%\">$pdfName.pdf</td>
		</tr>
		</table>
	";
   $newOptions = ($options & ~3) + 3;
   $formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,16))."+".$newOptions;

   $GLOBALS[$form]->FormHTML =   str_replace("!formAction!",$formAction,
               str_replace("!attachmentInfo!",$attachmentTable,
               str_replace("!attachmentName!",$pdfName.".pdf",
               str_replace("!hasAttachment!","expand",
               str_replace("!emailBody!","",
               str_replace("!emailSubject!",$pdfName,
               Join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));
   // get principal
   $principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
   $resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
   $principalInfo = getPersonaDetail($principalId);
   $resOfficeInfo = getPersonaDetail($resOfficeId);
   	
   $addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
   $GLOBALS['temp']['princName'] = $principalInfo['name'];
   $GLOBALS['temp']['fax'] = $resOfficeInfo['fax'];
   $GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
   $userId = $_SESSION['userid'];
   	
   $GLOBALS['temp']['emailFrom'] = $lDB->get("   SELECT
                           pr_persona.pr_email
                        FROM
                           pr_persona
                        WHERE
                           pr_persona.pr_persona_ix = '".$userId."'", 4);
   $GLOBALS['temp']['emailTo'] = "";
}

if($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {

  $pdf = new PDF("Extra Confirmation");

   $logoY = $pdf->y;
   $pdf->Ln(0, 1);
   $server = $_SESSION['server'];
   $principal_id = $_SESSION['principal_id'];
   if (file_exists($GLOBALS['images_dir_on_disk']."/".$principal_id)) {
	   $pic = $pdf->_parsejpg($GLOBALS['images_dir_on_disk']."/".$principal_id."/top_clientlogo.jpg");
	   if ($pic['w'] > $pdf->GetPageWidth(1)/4) {
		  $pic['w'] = $pdf->GetPageWidth(1)/4;
	   }
	   require_once(__DIR__ . '/functions.imageset.php');
	   $logoWidth = imagesetLogoSizeOverride("extraConfirmationPdfLogoWidthOverride", $pic['w']);
	   $finalH = $pdf->Image($GLOBALS['images_dir_on_disk']."/".$principal_id."/top_clientlogo.jpg", ($pdf->GetPageWidth(1)/2)-($pic['w']/2), $logoY, $logoWidth);
	   if (($logoY + $finalH) > $pdf->y) {
		  $pdf->y = $logoY + $finalH;
	   }  
   }
   $pdf->Ln(1);
   $pdf->SetFont('Arial', '', 9);
   $pdf->Row(array(
	   array('width' => "100%", 'data' => $princName, 'align' => "C")
   ));
   $pdf->Ln(0,1);
   $pdf->Row(array(
	   array('width' => "50%", 'data' => "Cashier: ".$cashier),
	   array('width' => "50%", 'data' => $billingName, 'align' =>"R", 'style' => "B")
   )); 
   $pdf->Ln(0,1);
   $pdf->Row(array(
	   array('width' => "50%", 'data' => "Captured: ".$today_datetime),
	   array('width' => "50%", 'data' => $statutory1label.": ".$statutory1, 'align' =>"R")
   ));
   $pdf->Ln(0,1);
   $pdf->Row(array(
	   array('width' => "100%", 'data' => $statutory2label.": ".$statutory2, 'align' =>"R")
   ));
   $pdf->Ln(0,1);
   $pdf->Row(array(
	   array('width' => "100%", 'data' => $statutory3label.": ".$statutory3, 'align' =>"R")
   ));
   $pdf->Ln(1);
   $pdf->Row(array(
	   array('width' => "100%", 'height' => "6", 'data' => "Charged to: ".$chargedTo, 'style' => "B")
   ));
   $pdf->Ln(0,1);
   $pdf->Row(array(
	   array('width' => "100%", 'height' => "6", 'data' => "Invoiced to: ".$invoicedTo, 'style' => "B")
   ));

 
   $headRow = array();
    array_push($headRow,
      array('width' =>"30%", 'height' =>"5", 'data' =>"Description", 'border' =>"LTBR", 'style' =>"B"),
      array('width' =>"20%", 'height' =>"5", 'data' =>"Category", 'border' =>"TBR", 'style' =>"B"),
      array('width' =>"10%", 'height' =>"5", 'data' =>"Qty", 'border' =>"TBR", 'align' =>"R", 'style' =>"B"),
      array('width' =>"20%", 'height' =>"5", 'data' =>"Total", 'border' =>"TBR", 'align' =>"R", 'style' =>"B")
    );
   $pdf->Row($headRow);
   $pdf->Ln(0,1);
   
   //Need to loop through all extras???
   $extrasListArray = explode(":",$extrasList);      
   foreach($extrasListArray as $itemId) {
		$item = $lDB->get("
			SELECT
				ac_ext_amount,
				ac_ext_comm_pay,
				ac_ext_comm_rec,
				ac_extra.rf_tax_ind,
				IF(	ac_extra.rf_tax_ind = '10',
					rf_tax_rate.rf_tax_rate_perc,
					(
						SELECT
							SUM(rf_tax_rate.rf_tax_rate_perc)
						FROM
							ac_extra
							LEFT JOIN rt_tax_group_item ON rt_tax_group_item.rt_tax_group_id = ac_extra.rf_tax_id
							LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rt_tax_group_item.rf_tax_rate_id
							INNER JOIN rv_extra ON rv_extra.rv_extra_ix = '$itemId'
						WHERE
							ac_extra_ix = rv_extra.ac_extra_id
					)
					) AS rf_tax_rate_perc,
				rf_currency.rf_currency_ix as rf_currency_id,
				ac_ext_desc,
				ac_extra_category.ac_extra_cat_desc,
				rv_extra.rv_extra_units        
			FROM
				ac_extra
				INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
				LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = ac_extra.rf_tax_id
				LEFT JOIN rt_tax_group ON rt_tax_group.rt_tax_group_ix = ac_extra.rf_tax_id
				LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = ac_extra.rf_currency_id
        INNER JOIN rv_extra ON rv_extra.rv_extra_ix = '$itemId'
			WHERE
				ac_extra_ix = rv_extra.ac_extra_id
		",1);
		if($GLOBALS['isPropServer']) {
			$homeCurrencyId = $lDB->get("SELECT pr_bus_prop_curr_id FROM pr_business WHERE pr_business_id = '$_POST[pr_business_id]'",4);
		} else {
			$homeCurrencyId = $lDB->get("SELECT rv_invoice_currency_id FROM rv_reservation WHERE rv_reservation_ix = '$chargedTo'",4);
		}		
		if($item['rf_currency_id'] == $homeCurrencyId) {
			$item['exch'] = 1;
		}
		$item['total'] = $lDB->get("SELECT rv_extra_amt_payable FROM rv_extra WHERE rv_extra_ix = '$itemId'",4);

	  $dataRow = array();
	   if($item['rf_currency_id'] == "" || $item['rf_currency_id'] == "0") {
		   $itemTotal = "";
	   } else {
		   $itemTotal = $item['total']." ".$homeCurrency;
	   }
	  
      array_push($dataRow,
        array('width' =>"30%", 'height' =>"5", 'data' =>$item['ac_ext_desc'], 'border' =>"LTBR"),
        array('width' =>"20%", 'height' =>"5", 'data' =>$item['ac_extra_cat_desc'], 'border' =>"TBR"),
        array('width' =>"10%", 'height' =>"5", 'data' =>$item['rv_extra_units'], 'border' =>"TBR", 'align' =>"R"),
        array('width' =>"20%", 'height' =>"5", 'data' =>$itemTotal, 'border' =>"TBR", 'align' =>"R")
      );
     $pdf->Row($dataRow);        
   }
   $pdf->Ln(0,1);
   $taxRow = array();
   
    array_push($taxRow,
      array('width' =>"30%", 'height' =>"5", 'data' =>"", 'border' =>"R"),
      array('width' =>"30%", 'height' =>"5", 'data' =>"Tax included", 'border' =>"TBR", 'align' =>"R"),
      array('width' =>"20%", 'height' =>"5", 'data' =>$taxTotal." ".$homeCurrency, 'border' =>"TBR", 'align' =>"R")
    );
   $pdf->Row($taxRow);
   $pdf->Ln(0,1);
   
   $totalRow = array();
    array_push($totalRow,
      array('width' =>"30%", 'height' =>"5", 'data' =>"", 'border' =>"R"),
      array('width' =>"30%", 'height' =>"5", 'data' =>"Total", 'border' =>"TBR", 'align' =>"R"),
      array('width' =>"20%", 'height' =>"5", 'data' =>$grandTotal." ".$homeCurrency, 'border' =>"TBR", 'align' =>"R")
    );
   $pdf->Row($totalRow);      
   $pdf->Ln(0,1);
   $pdf->Ln(1);
	 $pdf->Row(array(
     array('width' =>"100%", 'height' =>"5", 'data' =>""),
   )); 
   $pdf->Row(array(
     array('width' =>"30%", 'height' =>"5", 'data' =>""),
	   array('width' => "30%", 'height' => "6", 'data' => "Gratuity", 'align' =>"R"),
     array('width' => "20%", 'height' => "6", 'data' => "", 'style' => "B", 'border' =>"B")
   )); 
   $pdf->Ln(1);
	 $pdf->Row(array(
     array('width' =>"100%", 'height' =>"5", 'data' =>""),
   ));     
   $pdf->Row(array(
     array('width' =>"30%", 'height' =>"5", 'data' =>""),
	   array('width' => "30%", 'height' => "6", 'data' => "Signature", 'align' =>"R"),
     array('width' => "20%", 'height' => "6", 'data' => "", 'style' => "B", 'border' =>"B")
   )); 
   $pdf->Ln(0,1);   
   $pdf->Row(array(
     array('width' =>"30%", 'height' =>"5", 'data' =>""),
	   array('width' => "30%", 'height' => "6", 'data' => "Room number", 'align' =>"R"),
     array('width' => "20%", 'height' => "6", 'data' => "", 'style' => "B", 'border' =>"B")
   ));
   
   
   $powerY = $pdf->y;
         
  //go at end
  if($renderType == "save"){
    $pdf->OutPut('./PDF/current/extraConfirmation.pdf');
    echo "PDF created";
  } elseif ($renderType == "view") {
    $pdf->OutPut();
    die();
  } elseif ($renderType == "send") {
    $to = $_POST['mail_to'];
    $from = $_POST['mail_from'];
    $subject = stripslashes($_POST['mail_subj']);
    $message = stripslashes($_POST['mail_body']);
    $attachmentName = $_POST['attachmentName'];

    $headers = "From: ".$GLOBALS['princName']."<$from>\r\n";

    // close the pdf
    if($pdf->state<3) $pdf->Close();

    /* and now mail it */
    //echo "ATTACHMENTNAME: $attachmentName<BR>";
    if($attachmentName != "!attachmentName!") {
       $pdfName = $attachmentName;
    } else {
      $pdfName = "extraConfirmation.pdf";
    }

    //echo "NAME: $pdfName<BR>";
    $error = email($from, $to, $subject, $headers, $message, 0, 0, $_SERVER['argv'][1], $GLOBALS['princName'],$pdf->buffer,$pdfName);     // (from, to, subject, headers, message, action, emailID, resID)
    //echo "<html><head>";
    //echo "<script src='include/js/system.js' language='javascript'></script></head>";
    if(!$error) {
       echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
    } else {
       echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
    }
    //die();
  }     
  die();
  // End PDF code
}

if(isset($_POST['action']) && $_POST['action'] == "add" && isset($_POST['randomId']) && isset($_SESSION['quickExtraRandomId']) && $_POST['randomId'] == $_SESSION['quickExtraRandomId']) {
	//debug($_POST);

	// Find billing entity
	//	$today = date("Y-m-d"); // this needs to be received from the client
	$serviceDate = isset($_POST['rv_extra_date_serv']) ? $_POST['rv_extra_date_serv'] : date("Y-m-d");
	$businessId = "";
	$currId = $_POST['pr_business_id'];
	while($businessId == "" && $currId != "0" && trim($currId) != "") {
		if(!$GLOBALS['isPropServer']) {
			$billingYN = $lDB->get("SELECT pr_bus_billing_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
		} else {
			$billingYN = $lDB->get("SELECT pr_bus_billing_prop_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
		}
		if($billingYN == "1") {
				$businessId = $currId;
		} else {
				$currId = $lDB->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id ='$currId'",4);
		}
	}
  if($businessId == "" || $businessId == "0") {
		// hide billing entity fields to stop from looking ugly
	}  
  
  $name = $lDB->get("SELECT pr_name_first, pr_name_last FROM pr_persona WHERE pr_persona_ix = '$businessId'",1);
  if($name[0] != ""){
  	$name[0] .= ", "; 
  }
  $billingName = $name[0].$name[1];
	$statutory = $lDB->get("
		SELECT
			pr_bus_statutory_1,
			pr_bus_statutory_2,
			pr_bus_statutory_3,
			pr_bus_statutory_label_1,
			pr_bus_statutory_label_2,
			pr_bus_statutory_label_3
		FROM
			pr_business
		WHERE
			pr_business_id = '$businessId'
	",1);

	$default_statutory_labels = $GLOBALS['lDB']->get("SELECT rf_statutory_label_1, rf_statutory_label_2, rf_statutory_label_3 FROM rf_default",1);

	if($GLOBALS['isPropServer']) {
		$homeCurrencyId = $lDB->get("SELECT pr_bus_prop_curr_id FROM pr_business WHERE pr_business_id = '$_POST[pr_business_id]'",4);
	} else {
		$homeCurrencyId = $lDB->get("SELECT rv_invoice_currency_id FROM rv_reservation WHERE rv_reservation_ix = '$_POST[rv_reservation_ix]'",4);
	}		
	$homeCurrency = $lDB->get("SELECT rf_currency_symbol FROM rf_currency WHERE rf_currency_ix = '$homeCurrencyId'",4);
	$expiryDays = $lDB->get("select rf_exch_expiry_days from rf_default",4);
	$expiryDate = date("Y-m-d",mktime(0,0,0,date("m"),date("d")+$expiryDays,date("Y")));
	//debug(unserialize(str_replace("\\","",$_POST['extras'])));
	//extraList = unserialize(str_replace("\\","",$_POST['extras']));
	$extraList = unserialize(str_replace("\r","",stripslashes($_POST['extras'])));

	$rows = "";
	$rowHTML = "
		<tr valign=\"top\"> 
			<td class=\"br bl\">!ac_ext_desc!</td>
			<td class=\"br\">!ac_extra_cat_desc!</td>
			<td class=\"br\" align=\"right\">!qty!</td>
			<td align=\"right\" class=\"br\">!total!</td>
		</tr>
	";
	$grandTotal = 0;
	$taxTotal = 0;
	$first = false;
  
  $newExtraList = array();
	foreach($extraList as $item) {
		$item = array_merge($item,$lDB->get("
			SELECT
				ac_ext_amount,
				ac_ext_comm_pay,
				ac_ext_comm_rec,
				ac_ext_note,
				ac_ext_note_internal,
				ac_extra.rf_tax_ind,
				IF(	ac_extra.rf_tax_ind = '10',
					rf_tax_rate.rf_tax_rate_perc,
					(
						SELECT
							SUM(rf_tax_rate.rf_tax_rate_perc)
						FROM
							ac_extra
							LEFT JOIN rt_tax_group_item ON rt_tax_group_item.rt_tax_group_id = ac_extra.rf_tax_id
							LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rt_tax_group_item.rf_tax_rate_id
						WHERE
							ac_extra_ix = '".$item['ac_extra_ix']."'
					)
					) AS rf_tax_rate_perc,
				rf_currency.rf_currency_ix as rf_currency_id,
				ac_ext_desc,
				ac_extra_category.ac_extra_cat_desc,
				ac_extra.rf_tax_id
			FROM
				ac_extra
				INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
				LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = ac_extra.rf_tax_id
				LEFT JOIN rt_tax_group ON rt_tax_group.rt_tax_group_ix = ac_extra.rf_tax_id
				LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = ac_extra.rf_currency_id
			WHERE
				ac_extra_ix = '$item[ac_extra_ix]'
		",1));

		if($item['rf_currency_id'] == $homeCurrencyId) {
			$item['exch'] = 1;
		}
		if($_POST['rv_res_item_group_ix'] == "") {
			$_POST['rv_res_item_group_ix'] = false;
		}

		// Ignore passed percentage, look up percentage from Tax Code Table
		$taxPerc = taxPercentage($item['rf_tax_id'], $item['rf_tax_ind']);
		
		$newExtraId = db_rv_extra_insert($_POST['rv_reservation_ix'], $item['ac_extra_ix'], $_POST['pr_business_id'], $item['qty'], $item['rv_extra_date_serv'], $item['price'], 0, $taxPerc, $item['ac_ext_comm_rec'], $item['ac_ext_comm_pay'], addslashes($item['note']), addslashes($item['memo']), $_POST['rv_res_item_group_ix'], $item['rf_currency_id'], $homeCurrencyId, $item['exch'], $expiryDate, $businessId, addslashes($item['rv_extra_travel_eta']), addslashes($item['rv_extra_travel_etd']), $item['rv_extra_adult_count'], $item['rv_extra_child_count'], $item['rv_extra_date_depart'], addslashes($item['rv_extra_ref']), intval($item['rv_extra_supplier_conf_yn']), $item['pr_supplier_id']);
		db_rv_extra_tax_insert($newExtraId, $item['rf_tax_ind'], $item['rf_tax_id']);
		verify_extra($newExtraId);

		array_push($newExtraList,$newExtraId);     
		$GLOBALS['temp']['extraList'] = join(":",$newExtraList);
		if($item['rf_currency_id'] == "" || $item['rf_currency_id'] == "0") {
			$chargable = false;
		} else {
			$chargable = true;
		}
    
    if($first == false && $chargable) {
			$fn_folio_id = db_fn_folio_insert_extra($newExtraId, $_POST['rv_res_item_group_ix'], $_POST['rv_invoice_persona_id']);
			$first = true;
		}

		if($chargable) {
			db_rv_extra_set_folio($newExtraId, $fn_folio_id);
		}

		if($item['rf_currency_id'] == "" || $item['rf_currency_id'] == "0") {
			$item['total'] = "&nbsp;";
		} else {
			$item['total'] = $lDB->get("SELECT rv_extra_amt_payable FROM rv_extra WHERE rv_extra_ix = '$newExtraId'",4);
			$tax = $item['total'] / ($item['rf_tax_rate_perc'] + 100) * $item['rf_tax_rate_perc'];
			$taxTotal += $tax;
			$grandTotal += $item['total'];
			fixAmtDisplay($item['total']);
			 $item['total'] .= " ".$homeCurrency;
	    }

		db_rf_exchange_rate_set($item['rf_currency_id'],$homeCurrencyId,$item['exch']);

		$rows .= showpage($item,$rowHTML);
	}
	$GLOBALS['temp']['rows'] = $rows;
	fixAmtDisplay($taxTotal);
	fixAmtDisplay($grandTotal);
	$GLOBALS['temp']['taxTotal'] = $taxTotal;
	$GLOBALS['temp']['grandTotal'] = $grandTotal;
	$GLOBALS['temp']['homeCurrency'] = $homeCurrency;
	if (!isset($GLOBALS[$form])) {
		$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/quick_entry_confirm.htm");
	} 
	
  	$GLOBALS['temp']['resExtraJob'] = "609";
  	$jobLevel = checkJob(0,2);
	if ($jobLevel > 5) {
		$GLOBALS['temp']['resExtraJob'] = "610";
	}
	$GLOBALS['temp']['returnToResDisabled'] = $jobLevel == 0 ? "disabled" : "";
	$GLOBALS['temp']['returnToResDisabledStyle'] = $jobLevel == 0 ? "background-color: #ededed; color: #667;" : "";

	$GLOBALS['temp']['rnum'] = $_POST['rv_reservation_ix']; 
  
	$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
	$GLOBALS['temp']['principalName'] = getContactFullName($principalId);
	$GLOBALS['temp']['serviceDate'] = $today_datetime;
	$GLOBALS['temp']['billingName'] = $billingName;

	$statutoryData = "";

	$statutory1label = $default_statutory_labels['rf_statutory_label_1'];
	$GLOBALS['temp']['statutory1label'] = "";
	$GLOBALS['temp']['statutory1'] = "";
	if ($statutory['pr_bus_statutory_1'] != "") {
		$statutory1label = $statutory['pr_bus_statutory_label_1'] != "" ? $statutory['pr_bus_statutory_label_1'] : $default_statutory_labels['rf_statutory_label_1'];
		$statutoryData .= "<div>".$statutory1label.":&nbsp;".$statutory['pr_bus_statutory_1']."</div>";
		$GLOBALS['temp']['statutory1label'] = $statutory1label;
		$GLOBALS['temp']['statutory1'] = $statutory['pr_bus_statutory_1'];
	}
	
	$statutory2label = $default_statutory_labels['rf_statutory_label_2'];
	$GLOBALS['temp']['statutory2label'] = "";
	$GLOBALS['temp']['statutory2'] = "";
	if ($statutory['pr_bus_statutory_2'] != "") {
		$statutory2label = $statutory['pr_bus_statutory_label_2'] != "" ? $statutory['pr_bus_statutory_label_2'] : $default_statutory_labels['rf_statutory_label_2'];
		$statutoryData .= "<div>".$statutory2label.":&nbsp;".$statutory['pr_bus_statutory_2']."</div>";
		$GLOBALS['temp']['statutory2label'] = $statutory2label;
		$GLOBALS['temp']['statutory2'] = $statutory['pr_bus_statutory_2'];
	}
	
	$statutory3label = $default_statutory_labels['rf_statutory_label_3'];
	$GLOBALS['temp']['statutory3label'] = "";
	$GLOBALS['temp']['statutory3'] = "";
	if ($statutory['pr_bus_statutory_3'] != "") {
		$statutory3label = $statutory['pr_bus_statutory_label_3'] != "" ? $statutory['pr_bus_statutory_label_3'] : $default_statutory_labels['rf_statutory_label_3'];
		$statutoryData .= "<div>".$statutory3label.":&nbsp;".$statutory['pr_bus_statutory_3']."</div>";
		$GLOBALS['temp']['statutory3label'] = $statutory3label;
		$GLOBALS['temp']['statutory3'] = $statutory['pr_bus_statutory_3'];
	}

	$GLOBALS['temp']['statutoryData'] = $statutoryData;

	$desc = $lDB->get("
		SELECT
			ac_accomm_room.ac_desc
		FROM
			rv_res_item_group
			INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		WHERE
			rv_res_item_group.rv_res_item_group_ix = '$_POST[rv_res_item_group_ix]'
	",4);
	if(trim($desc) == "" || $desc == "0") {
		$desc = "";
	}

	$guestName = $lDB->get("SELECT pr_name_first,pr_name_last FROM pr_persona WHERE pr_persona_ix = '$_POST[pr_guest_id]'",1);
	$guestName = trim($guestName['pr_name_first'] . " " . $guestName['pr_name_last']);
	if($guestName != "") {
		if($desc != "") {
			$desc .= " - ";
		}
		$desc .= $guestName;
	}

	if($desc == "") {
		$desc = $_POST['rv_reservation_ix'];
	} else {
		$desc .= " (".$_POST['rv_reservation_ix'].")";
	}
	$GLOBALS['temp']['chargedTo'] = $desc;

	$invoicedTo = $lDB->get("SELECT pr_name_first,pr_name_last FROM pr_persona WHERE pr_persona_ix = '$_POST[rv_invoice_persona_id]'",1);
	$GLOBALS['temp']['invoicedTo'] = trim($invoicedTo['pr_name_first'] . " " . $invoicedTo['pr_name_last']);
	if($GLOBALS['temp']['invoicedTo'] == "") {
		$GLOBALS['temp']['invoicedTo'] = "Cash";
	}
	$GLOBALS['temp']['cashier'] = $cashier;
	$GLOBALS['temp']['logoURL'] = $GLOBALS['http'].$GLOBALS['images_dir']."/".$GLOBALS['principal_id']."/top_clientlogo.jpg";
	array_pop($GLOBALS['history']);	// Remove from 'back'
} else {
if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/quick_entry.htm");
} 





// Get the currenct user's property / business link
$businessId = $lDB->get("
	SELECT
		pr_link.pr_link_to
	FROM
		pr_link
	WHERE
		pr_link.pr_link_from = '$GLOBALS[userid]'
		AND pr_link.rf_link_type_id = 'RS1'
",4);

// Get a list of all the properties linked to the users property / business link
$propertyList = $lDB->get("
	SELECT DISTINCT
		ac_accomm_type.pr_business_id,
		pr_persona.pr_name_last
	FROM
		ac_accomm_type 
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
/*	WHERE
		ac_accomm_type.pr_business_id IN ('".join("','",getChildren($businessId))."')*/
",2);
$dbProperty = $lDB->get("
	SELECT
		pr_business_id
	FROM
		rf_db_business
	WHERE
		rf_db_code = '$GLOBALS[dbcode]'
",3);

if($propertyId == "") {
	foreach($propertyList as $item) {
		foreach($dbProperty as $dbItem) {
			if($item['pr_business_id'] == $dbItem) {
				$propertyId = $dbItem;
			}
		}
	}
}

if($propertyId == "") {
	$propertyId = $propertyList[0]['pr_business_id'];
}

// Find billing entity
$businessId = "";
$currId = $propertyId;
while($businessId == "" && $currId != "0" && trim($currId) != "") {
	if(!$GLOBALS['isPropServer']) {
		$billingYN = $lDB->get("SELECT pr_bus_billing_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
	} else {
		$billingYN = $lDB->get("SELECT pr_bus_billing_prop_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
	}
	if($billingYN == "1") {
			$businessId = $currId;
	} else {
			$currId = $lDB->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id ='$currId'",4);
	}
}
if($GLOBALS['isPropServer']) {
	$homeCurrencyId = $lDB->get("SELECT pr_bus_prop_curr_id FROM pr_business WHERE pr_business_id = '$propertyId'",4);
} else {
	$homeCurrencyId = "";;
}
$homeCurrency = $lDB->get("SELECT rf_currency_symbol FROM rf_currency WHERE rf_currency_ix = '$homeCurrencyId'",4);
$GLOBALS['temp']['homeCurrencyId'] = $homeCurrencyId;
$GLOBALS['temp']['homeCurrency'] = $homeCurrency;

if(isset($_POST['action']) && $_POST['action'] == 'category') {
	echo "
		<script language=\"javascript\">
			parent.id(\"selExtra\").options.length = 0;
			parent.noteArray = new Array();
			parent.memoArray = new Array();
			parent.etaArray = new Array();
			parent.etdArray = new Array();
			parent.referenceArray = new Array();
			count = 0;
	";
	$extraList = $lDB->get("
		SELECT DISTINCT
			ac_extra.ac_extra_ix,
			ac_extra.ac_ext_desc,
			ac_extra.ac_ext_amount,
			rf_tax_rate.rf_tax_rate_perc,
			ac_extra.rf_tax_ind,
			ac_extra.rf_currency_id,
			rf_currency.rf_currency_symbol,
			rf_tax_rate.rf_tax_rate_ix,
            rt_tax_group.rt_tax_group_ix,
			ac_extra.ac_ext_note,
			ac_extra.ac_ext_note_internal,
			ac_extra.ac_ext_travel_eta,
			ac_extra.ac_ext_travel_etd,
			ac_extra.ac_ext_adult_count,
			ac_extra.ac_ext_child_count,
			ac_extra.ac_ext_nights,
			ac_extra.ac_extra_xref,
			ac_extra.ac_extra_external_yn,
			ac_extra.ac_ext_supplier_conf_yn,
			ac_extra.pr_supplier_id,
			ac_extra_category.ac_extra_cat_ind,
			CONCAT_WS(' ',pr_persona.pr_name_first,pr_persona.pr_name_last) AS supplier_name
		FROM
			ac_extra
			INNER JOIN ac_extra_prop ON ac_extra_prop.ac_extra_id = ac_extra.ac_extra_ix
			INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
			LEFT JOIN pr_business ON pr_business.pr_business_id = ac_extra_prop.pr_business_id
			LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = ac_extra.rf_tax_id
            LEFT JOIN rt_tax_group ON rt_tax_group.rt_tax_group_ix = ac_extra.rf_tax_id
			LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = ac_extra.rf_currency_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = ac_extra.pr_supplier_id
		WHERE
			ac_extra.ac_inactive_yn = '0'
			AND (ac_extra_prop.pr_business_id = '$propertyId' OR pr_business.pr_business_id IS NULL)
			AND ac_extra.ac_extra_category_id = '$_POST[ac_extra_category_ix]'
		ORDER BY 
			ac_extra.ac_ext_desc
	",2);
	echo "parent.id(\"selExtra\").options[count++] = new Option(\"Please choose...\",\"0:|:0\");";
	foreach($extraList as $item) {
        if( $item['rf_tax_ind'] == 10 && (trim($item['rf_tax_rate_ix']) == "" || $item['rf_tax_rate_ix'] == "0") ||
            $item['rf_tax_ind'] == 20 && (trim($item['rt_tax_group_ix']) == "" || $item['rt_tax_group_ix'] == "0") ) {
            $item['rf_currency_id'] = "";
        }
		$taxPercent = $item['rf_tax_rate_perc'];
		
		if ($item['rf_tax_ind'] == 20) {
			$taxPercent = $lDB->get("
				SELECT
					SUM(rf_tax_rate.rf_tax_rate_perc)
				FROM
					ac_extra
					LEFT JOIN rt_tax_group_item ON rt_tax_group_item.rt_tax_group_id = ac_extra.rf_tax_id
					LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rt_tax_group_item.rf_tax_rate_id
				WHERE
					ac_extra_ix = '".$item['ac_extra_ix']."'
			",4);
		}

		echo "parent.id(\"selExtra\").options[count] = new Option(\"$item[ac_ext_desc]\",\"$item[ac_extra_ix]:|:$item[ac_ext_amount]:|:$taxPercent:|:$item[rf_currency_id]:|:$item[rf_currency_symbol]:|:$item[pr_supplier_id]:|:$item[supplier_name]:|:$item[ac_ext_supplier_conf_yn]:|:$item[ac_ext_adult_count]:|:$item[ac_ext_child_count]:|:$item[ac_ext_nights]:|:$item[ac_extra_cat_ind]\");";
		echo "parent.noteArray[count-1] = \"".t_encodeOverlib($item['ac_ext_note'])."\";";
		echo "parent.memoArray[count-1] = \"".t_encodeOverlib($item['ac_ext_note_internal'])."\";";
		echo "parent.etaArray[count-1] = \"".t_encodeOverlib($item['ac_ext_travel_eta'])."\";";
		echo "parent.etdArray[count-1] = \"".t_encodeOverlib($item['ac_ext_travel_etd'])."\";";
		echo "parent.referenceArray[count-1] = \"".t_encodeOverlib($item['ac_extra_xref'])."\";";
		echo "count++;";
	}	
	echo "
		</script>
	";
	die();
}

if(isset($_POST['action']) && $_POST['action'] == 'reservation') {
	$resId = $_POST['rv_reservation_ix'];
	$roomList = $lDB->get("
		SELECT
			rv_res_item_group.rv_res_item_group_ix,
			ac_accomm_room.ac_desc,
			rv_res_item_group.rv_reservation_item_id,
			pr_persona.pr_name_last,
			ac_accomm_type.ac_accomm_desc,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart
		FROM
			rv_res_item_group
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation_item.pr_business_id
			LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$resId'
		ORDER BY
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart
	",2);

	$newRoomList = array();
	foreach($roomList as $item) {
		$item['rv_item_date_arrive'] = chng_date($item['rv_item_date_arrive'],"-");
		$item['rv_item_date_depart'] = chng_date($item['rv_item_date_depart'],"-");
		$item['ac_desc_raw'] = $item['ac_desc'];
		if(trim($item['ac_desc']) == "") {
			$item['ac_desc'] = "&nbsp;";
		}
		$guestList = $lDB->get("
			SELECT
				pr_persona.pr_name_last,
				pr_persona.pr_name_first,
				pr_persona.pr_persona_ix,
				pr_guest.pr_guest_primary_yn,
				rf_title.rf_title_desc,
				rf_name_suffix.rf_suffix_desc
			FROM
				rv_res_item_guest
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
				LEFT JOIN pr_guest ON pr_guest.pr_guest_id = pr_persona.pr_persona_ix
				LEFT JOIN rf_title ON rf_title.rf_title_ix = pr_persona.pr_title_id
				LEFT JOIN rf_name_suffix ON rf_name_suffix.rf_name_suffix_ix = pr_persona.pr_name_suffix_id
			WHERE
				rv_res_item_group_id = '$item[rv_res_item_group_ix]'
		",2);
		if(sizeof($guestList) > 0) {
			$guestNames = "";
			foreach($guestList as $guestItem) {
				/*if($guestNames != "") {
					$guestNames .= "<BR>";
				}*/
				$guestNames = $guestItem['pr_name_last'];
    	  if(trim($guestItem['rf_suffix_desc']) != "") {
					$guestNames .= " " . $guestItem['rf_suffix_desc'];
				}
				if(trim($guestItem['pr_name_first']) != "") {
					$guestNames .= ", " . $guestItem['pr_name_first'];
				}
				if(trim($guestItem['rf_title_desc']) != "") {
					$guestNames .= " " . $guestItem['rf_title_desc'];
				}
				
				$item['guestNames'] = $guestNames;
				if($guestItem['pr_guest_primary_yn'] == "1") {
					$item['guestNames'] = "<span class=\"txtb\">$guestNames</span>";
				}
				$item['guestNamesRaw'] = $guestNames;
				$item['role'] = "Guest";
				$item['pr_persona_ix'] = $guestItem['pr_persona_ix'];
				array_push($newRoomList,$item);
			}
		} elseif( $item['ac_desc'] != "0" && trim($item['ac_desc']) != "") {
			$item['guestNamesRaw'] = "";
			$item['guestNames'] = "&nbsp;";
			$item['role'] = "Room";
			$item['pr_persona_ix'] = "";
			array_push($newRoomList, $item);
		}
	}
	$agentInfo = $lDB->get("
		SELECT
			pr_persona.pr_name_last,
			pr_persona.pr_persona_ix
		FROM
			rv_reservation
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
		WHERE
			rv_reservation_ix = '$resId'
	",1);
	array_unshift($newRoomList,array('role'=>'Agent', 'guestNames'=>$agentInfo['pr_name_last'],'guestNamesRaw'=>$agentInfo['pr_name_last'], 'ac_desc'=>"&nbsp;",'ac_desc_raw'=>"", 'rv_item_date_arrive'=>"&nbsp;", 'rv_item_date_depart'=>"&nbsp;", 'pr_name_last'=>"&nbsp;", 'ac_accomm_desc'=>"&nbsp;", 'pr_persona_ix'=>$agentInfo['pr_persona_ix'],'rv_res_item_group_ix'=>""));
	$billing = $lDB->get("
		SELECT
			pr_persona.pr_name_first,
			pr_persona.pr_name_last,
			pr_persona.pr_persona_ix
		FROM
			rv_reservation
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_billing_persona_id 
		WHERE
			rv_reservation_ix = '$resId'
	",1);
	$billingName = trim($billing['pr_name_first']);
	if($billingName != "") { $billingName .= " "; }
	$billingName .= trim($billing['pr_name_last']);
	array_unshift($newRoomList,array('role'=>'Billing Contact','guestNames'=>$billingName, 'guestNamesRaw'=>$billingName, 'ac_desc'=>"&nbsp;", 'ac_desc_raw'=>"",'rv_item_date_arrive'=>"&nbsp;", 'rv_item_date_depart'=>"&nbsp;", 'pr_name_last'=>"&nbsp;", 'ac_accomm_desc'=>"&nbsp;",'pr_persona_ix'=>$billing['pr_persona_ix'],'rv_res_item_group_ix'=>""));
	$invoice = $lDB->get("
		SELECT
			pr_persona.pr_name_first,
			pr_persona.pr_name_last,
			pr_persona.pr_persona_ix
		FROM
			rv_reservation
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_invoice_persona_id  
		WHERE
			rv_reservation_ix = '$resId'
	",1);
	$invoiceName = trim($invoice['pr_name_first']);
	if($invoiceName != "") { $invoiceName .= " "; }
	$invoiceName .= trim($invoice['pr_name_last']);
	array_unshift($newRoomList,array('role'=>'Invoice Contact','guestNames'=>$invoiceName, 'guestNamesRaw'=>$invoiceName, 'ac_desc'=>"&nbsp;",'ac_desc_raw'=>"", 'rv_item_date_arrive'=>"&nbsp;", 'rv_item_date_depart'=>"&nbsp;", 'pr_name_last'=>"&nbsp;", 'ac_accomm_desc'=>"&nbsp;",'pr_persona_ix'=>$invoice['pr_persona_ix'],'rv_res_item_group_ix'=>""));
	$roomList = null;
	//debug($newRoomList);

	$rowHTML = join("\n",file(__DIR__ . "/../../../public/html/quick_entry_res_rows.htm"));
	$rows = "";
	foreach($newRoomList as $item) {
		$item['guestNamesRaw'] = t_encodeOverlib($item['guestNamesRaw']);
		$rows .= showpage($item,$rowHTML);
	}
	$GLOBALS['temp']['contactRows'] = $rows;	
	$tableHTML = "
	<div id=\"tmpTable\">
		<table width=\"600\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" summary=\"\" align=\"center\" class=\"colWh\">
			<col width=\"80\" />
			<col width=\"120\" />
			<col width=\"53\" />
			<col width=\"70\" />
			<col width=\"70\" />
			<col width=\"90\" />
			<col width=\"100\" />
			<col width=\"17\" />
			<thead>
				<tr style=\"height: 20px;\">
					<th class=\"outLt\">Role</th>
					<th class=\"outLt\">Contact / Guests</th>
					<th class=\"outLt\">Room</th>
					<th class=\"outLt\">Arrive</th>
					<th class=\"outLt\">Depart</th>
					<th class=\"outLt\">Property</th>
					<th class=\"outLt\">Accom</th>
					<th class=\"outLt bb txtb imgLink\" onclick=\"click();\" align=\"center\">X</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td colspan=\"8\">
						<div id=\"contactRows\" style=\"height: 200px;\" class=\"scrollY\">
							<table id=\"contactTable\" width=\"583\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" summary=\"\" class=\"bb\">
								<col width=\"80\" />
								<col width=\"120\" />
								<col width=\"53\" />
								<col width=\"70\" />
								<col width=\"70\" />
								<col width=\"90\" />
								<col width=\"100\" />
								<tbody>
									$rows
								</tbody>
							</table>
						</div>
					</td>
				</tr>
			</tbody>
		</table>
	</div>
	";
	echo $tableHTML;
	echo "<script language=\"javascript\">";
	
//	echo "parent.id('contactList').innerHTML = '".($tableHTML)."'";
//echo "alert('".t_encodeOverlib($tableHTML)."');";
//	echo "parent.id('contactTable').innerHTML = '<col width=\"80\"><col width=\"120\"><col width=\"57\"><col width=\"70\"><col width=\"70\"><col width=\"90\"><col width=\"100\">';";
//	echo "parent.id('contactTable').innerHTML += '<tr><td>blah blah</td></tr>';";
	echo "parent.id('contactList').innerHTML = '';";
	echo "parent.id('contactList').innerHTML = document.getElementById('tmpTable').innerHTML;";
	echo "parent.id('btnShowContactPopup').disabled = false;";
	echo "parent.id('btnInvoiceTo').disabled = false;";
	echo "parent.id('btnShowContactPopup').focus();";
	if(!$GLOBALS['isPropServer']) {
		$currencyId = $lDB->get("SELECT rv_invoice_currency_id FROM rv_reservation WHERE rv_reservation_ix = '$resId'",4);
		$currencyName = $lDB->get("SELECT rf_currency_symbol FROM rf_currency WHERE rf_currency_ix = '$currencyId'",4);
		echo "parent.homeCurrencyId = '$currencyId';";
		echo "parent.homeCurrency = '$currencyName';";
		echo "parent.updateHomeCurrency();";
	}
	
	echo "</script>";
	
	die();
}

$propertyOptions = "";
$chargePropertyOptions = "";
foreach($propertyList as $item) {
	if($propertyId == $item['pr_business_id']) {
		$selected = " SELECTED ";
	} else {
		$selected = "";
	}
	if($propertyId == $item['pr_business_id']) {
		$chargeSelected = " SELECTED ";
	} else {
		$chargeSelected = "";
	}
	$propertyOptions .= "<option value=\"$item[pr_business_id]\" $selected>$item[pr_name_last]</option>";
	$chargePropertyOptions .= "<option value=\"$item[pr_business_id]\" $chargeSelected>$item[pr_name_last]</option>";
}
$GLOBALS['temp']['propertyOptions'] = $propertyOptions;
$GLOBALS['temp']['chargePropertyOptions'] = $chargePropertyOptions;

$today = date("Y-m-d");
//$today = "2003-12-16";

$GLOBALS['temp']['today'] = $today;
$GLOBALS['temp']['today_fmt'] = chng_date($today,"-");
$arriveList = $lDB->get("
	SELECT
		rv_reservation.rv_reservation_ix,
		pr_persona.pr_name_last,
		pr_persona.pr_name_first,
		rv_reservation.rv_res_name,
		ac_accomm_room.ac_desc,
		rv_res_item_group.rv_res_item_group_ix,
		rv_res_item_guest.pr_guest_id,
		rf_title.rf_title_desc,
		rf_name_suffix.rf_suffix_desc
	FROM
		rv_reservation
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
		LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
		LEFT JOIN rv_res_item_guest ON rv_res_item_guest.rv_res_item_group_id = rv_res_item_group.rv_res_item_group_ix
		LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
		LEFT JOIN rf_title ON rf_title.rf_title_ix = pr_persona.pr_title_id
		LEFT JOIN rf_name_suffix ON rf_name_suffix.rf_name_suffix_ix = pr_persona.pr_name_suffix_id
	WHERE
		rv_reservation.rf_reservation_status_id = '30'
		AND rv_reservation_item.rv_item_date_arrive = '$today'
		AND rv_reservation_item.rv_item_date_depart > '$today'
		AND rv_reservation_item.pr_business_id = '$propertyId'
",2);

$stayoverList = $lDB->get("
	SELECT
		rv_reservation.rv_reservation_ix,
		pr_persona.pr_name_last,
		pr_persona.pr_name_first,
		rv_reservation.rv_res_name,
		ac_accomm_room.ac_desc,
		rv_res_item_group.rv_res_item_group_ix,
		rv_res_item_guest.pr_guest_id,
		rf_title.rf_title_desc,
		rf_name_suffix.rf_suffix_desc
	FROM
		rv_reservation
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
		LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
		LEFT JOIN rv_res_item_guest ON rv_res_item_guest.rv_res_item_group_id = rv_res_item_group.rv_res_item_group_ix
		LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
		LEFT JOIN rf_title ON rf_title.rf_title_ix = pr_persona.pr_title_id
		LEFT JOIN rf_name_suffix ON rf_name_suffix.rf_name_suffix_ix = pr_persona.pr_name_suffix_id
	WHERE
		rv_reservation.rf_reservation_status_id = '30'
		AND rv_reservation_item.rv_item_date_arrive < '$today'
		AND rv_reservation_item.rv_item_date_depart > '$today'
		AND rv_reservation_item.pr_business_id = '$propertyId'
",2);

$departList = $lDB->get("
	SELECT
		rv_reservation.rv_reservation_ix,
		pr_persona.pr_name_last,
		pr_persona.pr_name_first,
		rv_reservation.rv_res_name,
		ac_accomm_room.ac_desc,
		rv_res_item_group.rv_res_item_group_ix,
		rv_res_item_guest.pr_guest_id,
		rf_title.rf_title_desc,
		rf_name_suffix.rf_suffix_desc
	FROM
		rv_reservation
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
		LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
		LEFT JOIN rv_res_item_guest ON rv_res_item_guest.rv_res_item_group_id = rv_res_item_group.rv_res_item_group_ix
		LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
		LEFT JOIN rf_title ON rf_title.rf_title_ix = pr_persona.pr_title_id
		LEFT JOIN rf_name_suffix ON rf_name_suffix.rf_name_suffix_ix = pr_persona.pr_name_suffix_id
	WHERE
		rv_reservation.rf_reservation_status_id = '30'
		AND rv_reservation_item.rv_item_date_arrive < '$today'
		AND rv_reservation_item.rv_item_date_depart = '$today'
		AND rv_reservation_item.pr_business_id = '$propertyId'
",2);


//debug($resList);
$resHTML = "
	<tr class=\"imgLink\" onmouseover=\"this.style.backgroundColor='#cfc';\" onmouseout=\"this.style.backgroundColor='#fff';\" style=\"background-color: #fff;\" onclick=\"selectFolio('!rv_reservation_ix!','!rv_res_name!', '!rv_res_item_group_ix!', '!ac_desc!', '!pr_guest_id!','!pr_name_full!');\">
		<td class=\"br bb\" valign=\"top\">!ac_desc_fmt!</td>
		<td class=\"br bb\" valign=\"top\">!pr_name_full_fmt!</td>
		<td class=\"br bb\" valign=\"top\">!rv_reservation_ix!: !rv_res_name_fmt!</td>
	</tr>
";
$resRows = "";
if(sizeof($arriveList) > 0) {
	$resRows .= "
		<tr>
			<td colspan=\"3\" align=\"center\" class=\"colLtt br bb\">Arrive</td>
		</tr>
	";
	foreach($arriveList as $item) {
		if($item['ac_desc'] == "") {
			$item['ac_desc_fmt'] = "&nbsp;";
		} else {
			$item['ac_desc_fmt'] = $item['ac_desc'];
		}

		$guestName = $item['pr_name_last'];
		if(trim($item['rf_suffix_desc']) != "") {
			$guestName .= " " . $item['rf_suffix_desc'];
		}
		if(trim($item['pr_name_first']) != "") {
			$guestName .= ", " . $item['pr_name_first'];
		}
		if(trim($item['rf_title_desc']) != "") {
			$guestName .= " " . $item['rf_title_desc'];
		}
		
		$item['pr_name_full'] = $guestName;
		
//		$item['pr_name_full'] = trim($item['pr_name_first'] . " " . $item['pr_name_last']);
		if($item['pr_name_full'] == "") {
			$item['pr_name_full_fmt'] = "&nbsp;";
		} else {
			$item['pr_name_full_fmt'] = $item['pr_name_full'];
		}
		$item['pr_name_full'] = t_encodeOverlib($item['pr_name_full']);
		$item['rv_res_name_fmt'] = $item['rv_res_name'];
		$item['rv_res_name'] = t_encodeOverlib($item['rv_res_name']);
		$resRows .= showpage($item,$resHTML);
	}
}
if(sizeof($stayoverList) > 0) {
	$resRows .= "
		<tr>
			<td colspan=\"3\" align=\"center\" class=\"colLtt br bb\">Stay-over</td>
		</tr>
	";
	foreach($stayoverList as $item) {
		if($item['ac_desc'] == "") {
			$item['ac_desc_fmt'] = "&nbsp;";
		} else {
			$item['ac_desc_fmt'] = $item['ac_desc'];
		}

		$guestName = $item['pr_name_last'];
		if(trim($item['rf_suffix_desc']) != "") {
			$guestName .= " " . $item['rf_suffix_desc'];
		}
		if(trim($item['pr_name_first']) != "") {
			$guestName .= ", " . $item['pr_name_first'];
		}
		if(trim($item['rf_title_desc']) != "") {
			$guestName .= " " . $item['rf_title_desc'];
		}
		
		$item['pr_name_full'] = $guestName;
/*		$item['pr_name_full'] = trim($item['pr_name_first'] . " " . $item['pr_name_last']);*/
		if($item['pr_name_full'] == "") {
			$item['pr_name_full_fmt'] = "&nbsp;";
		} else {
			$item['pr_name_full_fmt'] = $item['pr_name_full'];
		}
		$item['pr_name_full'] = t_encodeOverlib($item['pr_name_full']);
		$item['rv_res_name_fmt'] = $item['rv_res_name'];
		$item['rv_res_name'] = t_encodeOverlib($item['rv_res_name']);
		$resRows .= showpage($item,$resHTML);
	}
}

if(sizeof($departList) > 0) {
	$resRows .= "
		<tr>
			<td colspan=\"3\" align=\"center\" class=\"colLtt br bb\">Depart</td>
		</tr>
	";
	foreach($departList as $item) {
		if($item['ac_desc'] == "") {
			$item['ac_desc_fmt'] = "&nbsp;";
		} else {
			$item['ac_desc_fmt'] = $item['ac_desc'];
		}

		$guestName = $item['pr_name_last'];
		if(trim($item['rf_suffix_desc']) != "") {
			$guestName .= " " . $item['rf_suffix_desc'];
		}
		if(trim($item['pr_name_first']) != "") {
			$guestName .= ", " . $item['pr_name_first'];
		}
		if(trim($item['rf_title_desc']) != "") {
			$guestName .= " " . $item['rf_title_desc'];
		}
		
		$item['pr_name_full'] = $guestName;
		
//		$item['pr_name_full'] = trim($item['pr_name_first'] . " " . $item['pr_name_last']);
		if($item['pr_name_full'] == "") {
			$item['pr_name_full_fmt'] = "&nbsp;";
		} else {
			$item['pr_name_full_fmt'] = $item['pr_name_full'];
		}
		$item['pr_name_full'] = t_encodeOverlib($item['pr_name_full']);
		$item['rv_res_name_fmt'] = $item['rv_res_name'];
		$item['rv_res_name'] = t_encodeOverlib($item['rv_res_name']);
		$resRows .= showpage($item,$resHTML);
	}
}

if($resRows == "") {
	$resRows = "
		<tr>
			<td colspan=\"3\" align=\"center\" class=\"txti\">No current reservations</td>
		</tr>
	";
}

$GLOBALS['temp']['resRows'] = $resRows;

// Look up valid extras categorys
$extraCategoryId = false;
$extraCategoryList = $lDB->get("
	SELECT DISTINCT
		ac_extra_category.ac_extra_category_db,
		ac_extra_category.ac_extra_category_ix,
		ac_extra_category.ac_extra_cat_desc
	FROM
		ac_extra_category
		INNER JOIN ac_extra ON ac_extra.ac_extra_category_id = ac_extra_category.ac_extra_category_ix
		INNER JOIN ac_extra_prop ON ac_extra_prop.ac_extra_id = ac_extra.ac_extra_ix
		LEFT JOIN pr_business ON pr_business.pr_business_id = ac_extra_prop.pr_business_id
	WHERE
		ac_extra_category_inactive_yn = '0'
		AND ac_extra.ac_inactive_yn = '0'
		AND (ac_extra_prop.pr_business_id = '$propertyId' OR pr_business.pr_business_id IS NULL)
	ORDER BY
		ac_extra_category.ac_extra_cat_desc
",2);
$extraCategoryOptions = "";
foreach($extraCategoryList as $item) {
	if($extraCategoryId === false && $item['ac_extra_category_db'] == $GLOBALS['dbcode']) {
		$extraCategoryId = $item['ac_extra_category_ix'];
		$selected = " selected ";
	} else {
		$selected = "";
	}
	$extraCategoryOptions .= "<option value=\"$item[ac_extra_category_ix]\" $selected>$item[ac_extra_cat_desc]</option>";
}
$GLOBALS['temp']['extraCategoryOptions'] = $extraCategoryOptions;
if($extraCategoryId === false && isset($extraCategoryList[0]['ac_extra_category_ix']) ) {
	$extraCategoryId = $extraCategoryList[0]['ac_extra_category_ix'];
}

$travelCatList = $lDB->get("
	SELECT
		ac_extra_category_ix 
	FROM 
		ac_extra_category 
	WHERE
		ac_extra_cat_ind = 2
",3);
$travelCatData = "[]";
if(sizeof($travelCatList) > 0) {
	$travelCatData = '["'.join('","',$travelCatList).'"]';
}
$GLOBALS['temp']['travelCatData'] = $travelCatData;

$accomCatList = $lDB->get("
	SELECT
		ac_extra_category_ix 
	FROM 
		ac_extra_category 
	WHERE
		ac_extra_cat_ind = 3
",3);
$accomCatData = "[]";
if(sizeof($accomCatList) > 0) {
	$accomCatData = '["'.join('","',$accomCatList).'"]';
}
$GLOBALS['temp']['accomCatData'] = $accomCatData;

$extraList = $lDB->get("
	SELECT DISTINCT
		ac_extra.ac_extra_ix,
		ac_extra.ac_ext_desc,
		ac_extra.ac_ext_amount,
		rf_tax_rate.rf_tax_rate_perc,
		ac_extra.rf_tax_ind,
		ac_extra.rf_currency_id,
		rf_currency.rf_currency_symbol,
		rf_tax_rate.rf_tax_rate_ix,
        rt_tax_group.rt_tax_group_ix,
		ac_extra.ac_ext_note,
		ac_extra.ac_ext_note_internal,
		ac_extra.ac_ext_travel_eta,
		ac_extra.ac_ext_travel_etd,
		ac_extra.ac_ext_adult_count,
		ac_extra.ac_ext_child_count,
		ac_extra.ac_ext_nights,
		ac_extra.ac_extra_xref,
		ac_extra.ac_extra_external_yn,
		ac_extra.ac_ext_supplier_conf_yn,
		ac_extra.pr_supplier_id,
		ac_extra_category.ac_extra_cat_ind,
		CONCAT_WS(' ',pr_persona.pr_name_first,pr_persona.pr_name_last) AS supplier_name
	FROM
		ac_extra
		INNER JOIN ac_extra_prop ON ac_extra_prop.ac_extra_id = ac_extra.ac_extra_ix
		INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
		LEFT JOIN pr_business ON pr_business.pr_business_id = ac_extra_prop.pr_business_id
		LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = ac_extra.rf_tax_id
        LEFT JOIN rt_tax_group ON rt_tax_group.rt_tax_group_ix = ac_extra.rf_tax_id
		LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = ac_extra.rf_currency_id
		LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = ac_extra.pr_supplier_id
	WHERE
		ac_extra.ac_inactive_yn = '0'
		AND (ac_extra_prop.pr_business_id = '$propertyId' OR pr_business.pr_business_id IS NULL)
		AND ac_extra.ac_extra_category_id = '$extraCategoryId'
	ORDER BY
		ac_extra.ac_ext_desc
",6);
$extraOptions = "<option value=\"0:|:0\">Please choose...</option>";
$noteJS = "";
$extraCount = 0;

foreach($extraList as $item) {
	$item['ac_ext_travel_eta'] = substr($item['ac_ext_travel_eta'],0,5);
	$item['ac_ext_travel_etd'] = substr($item['ac_ext_travel_etd'],0,5);

	if( $item['rf_tax_ind'] == 10 && (trim($item['rf_tax_rate_ix']) == "" || $item['rf_tax_rate_ix'] == "0") ||
        $item['rf_tax_ind'] == 20 && (trim($item['rt_tax_group_ix']) == "" || $item['rt_tax_group_ix'] == "0") ) {
		$item['rf_currency_id'] = "";
	}

	$taxPercent = $item['rf_tax_rate_perc'];
	
	if ($item['rf_tax_ind'] == 20) {
		$taxPercent = $lDB->get("
			SELECT
				SUM(rf_tax_rate.rf_tax_rate_perc)
			FROM
				ac_extra
				LEFT JOIN rt_tax_group_item ON rt_tax_group_item.rt_tax_group_id = ac_extra.rf_tax_id
				LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rt_tax_group_item.rf_tax_rate_id
			WHERE
				ac_extra_ix = '".$item['ac_extra_ix']."'
		",4);
	}

	$extraOptions .= "<option value=\"$item[ac_extra_ix]:|:$item[ac_ext_amount]:|:$taxPercent:|:$item[rf_currency_id]:|:$item[rf_currency_symbol]:|:$item[pr_supplier_id]:|:$item[supplier_name]:|:$item[ac_ext_supplier_conf_yn]:|:$item[ac_ext_adult_count]:|:$item[ac_ext_child_count]:|:$item[ac_ext_nights]:|:$item[ac_extra_cat_ind]\">$item[ac_ext_desc]</option>";
	$noteJS .=  "noteArray[$extraCount] = \"".t_encodeOverlib($item['ac_ext_note'])."\";";
    $noteJS .= "memoArray[$extraCount] = \"".t_encodeOverlib($item['ac_ext_note_internal'])."\";";
	$noteJS .= "etaArray[$extraCount] = \"".t_encodeOverlib($item['ac_ext_travel_eta'])."\";";
	$noteJS .= "etdArray[$extraCount] = \"".t_encodeOverlib($item['ac_ext_travel_etd'])."\";";
	$noteJS .= "referenceArray[$extraCount] = \"".t_encodeOverlib($item['ac_extra_xref'])."\";";
	$extraCount++;
}
$GLOBALS['temp']['extraOptions'] = $extraOptions;
$GLOBALS['temp']['noteJS'] = $noteJS;

$exchangeList = db_rf_exchange_rate_get_all_rates();
$rows = "";
foreach($exchangeList as $item) {
	$rows .= "<INPUT type=\"hidden\" id=\"curr$item[rf_exch_curr_from_id]_$item[rf_exch_curr_to_id]\" value=\"$item[rf_exch_rate]\">\n";
}
$GLOBALS['temp']['exchangeList'] = $rows;

$expiryDays = $lDB->get("select rf_exch_expiry_days from rf_default",4);
$expiryDate = date("Y-m-d",mktime(0,0,0,date("m"),date("d")+$expiryDays,date("Y")));
list($expiryYear, $expiryMonth, $expiryDay) = explode("-",$expiryDate);
$GLOBALS['temp']['expiryDate'] = $expiryDate;
$GLOBALS['temp']['expiryYear'] = $expiryYear;
$GLOBALS['temp']['expiryMonth'] = $expiryMonth;
$GLOBALS['temp']['expiryDay'] = $expiryDay;

$adminId = $lDB->get("SELECT pr_persona_id FROM rf_sys_admin WHERE rf_sys_admin_primary = 1 LIMIT 1",4);
$adminEmail = $lDB->get("SELECT TRIM(pr_email) FROM pr_persona WHERE pr_persona_ix = '$adminId'",4);
if($adminEmail != "") {
	$GLOBALS['temp']['adminEmail'] = $adminEmail;
} else {
	$GLOBALS['temp']['adminEmail'] = "";
}
}

session_set("quickExtraRandomId",md5(uniqid(rand(),1)));
$GLOBALS['temp']['randomId'] = $_SESSION['quickExtraRandomId'];

$GLOBALS['temp']['propertyId'] = $propertyId;
$GLOBALS['temp']['chargePropertyId'] = $propertyId;
