<?php

/**
 * Form 296: Manage folios
 */

if(!isset($GLOBALS[$form])) {
   $GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/folio_manage.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],5,"");

$rv_reservation_ix = $_SERVER['argv'][1];
$GLOBALS['temp']['rv_reservation_ix'] = $rv_reservation_ix;
$pr_business_id = $_SERVER['argv'][2];
$GLOBALS['temp']['parentId'] = $_SERVER['argv'][4];

if($_SERVER['argv'][3] != "") {
	$list = unserialize(str_replace("\\\"","\"",urldecode($_SERVER['argv'][3])));
	$paymentCancel = false;
	foreach($list as $item) {
		$resItemCount = $GLOBALS['lDB']->get("
			SELECT
				COUNT(rv_reservation_item_ix)
			FROM
				rv_reservation_item
			WHERE
				fn_folio_id = '$item[oldFolioId]'
		",4);
		$extraCount = $GLOBALS['lDB']->get("
			SELECT
				COUNT(rv_extra_id)
			FROM
				rv_extra
			WHERE
				fn_folio_id = '$item[oldFolioId]'
		",4);
		$totalCount = $resItemCount + $extraCount;
		$paymentTotal = $GLOBALS['lDB']->get("
			SELECT
				SUM(rv_payment_item_amt)
			FROM
				rv_payment_item
			WHERE
				fn_folio_id = '$item[oldFolioId]'
		",4);
		$folioTotal = $GLOBALS['lDB']->get("
			SELECT
				fn_folio_amount
			FROM
				fn_folio
			WHERE
				fn_folio_ix = '$item[oldFolioId]'
		",4);
		if($item['itemId'] == "A") {
			$itemTotal = $GLOBALS['lDB']->get("
				SELECT
					SUM(rv_item_amt_payable)
				FROM
					rv_reservation_item
				WHERE
					fn_folio_id = '$item[oldFolioId]'
			",4);
		} else {
			$itemTotal = $GLOBALS['lDB']->get("
				SELECT
					rv_extra_amt_payable
				FROM
					rv_extra
				WHERE
					rv_extra_ix = '$item[itemId]'
			",4);
		}
		$finalTotal = $folioTotal - $itemTotal;
		if(trim($paymentTotal) == "") {
			$paymentTotal = "0";
		}
		if( ($totalCount == 1 && $paymentTotal != 0) || ($finalTotal < $paymentTotal && $paymentTotal != 0) ) {
			$paymentCancel = true;
			continue;
		}
		if($item['itemId'] == "A") {
			$GLOBALS['lDB']->put("
				UPDATE
					rv_reservation_item
				SET
					fn_folio_id = '$item[folioId]'
				WHERE
					fn_folio_id = '$item[oldFolioId]'
			");
		} else {
			db_rv_extra_set_folio($item['itemId'], $item['folioId'],false);
		}
		db_fn_folio_update_totals($item['folioId']);
		db_fn_folio_update_totals($item['oldFolioId']);			
	}
	// Need to be separate to prevent removal of a folio which is going to have something added to it.
	foreach($list as $item) {
		db_fn_folio_delete_by_id($item['oldFolioId']);
	}
	if($paymentCancel) {
		$paymentMessage = "opener.openMessage('One or more items could not be moved as there is a payment allocated to this folio');";
	} else {
		$paymentMessage = "";
	}
	ammendReservation($rv_reservation_ix,"Manage Folios");	
	if($_SERVER['argv'][4] == "") {
		$GLOBALS[$form]->FormHTML = "<html><body onload=\"$paymentMessage opener.location = 'reservation.php?647+$rv_reservation_ix'; window.close();\"</body></html>";	
	} else {
		$GLOBALS[$form]->FormHTML = "<html><body onload=\"$paymentMessage opener.location = opener.location; window.close();\"</body></html>";	
	}
}


$entityList = $GLOBALS['lDB']->get("
	SELECT DISTINCT
		pr_persona.pr_persona_ix,
		pr_persona.pr_name_last
	FROM
		fn_folio
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = fn_folio.pr_business_id
		INNER JOIN pr_business ON pr_business.pr_business_id = pr_persona.pr_persona_ix
	WHERE
		fn_folio.rv_reservation_id = '$rv_reservation_ix'
		AND (
			fn_folio.fn_invoice_id IS NULL
			OR fn_folio.fn_invoice_id = ''
			OR fn_folio.fn_invoice_id = '0'
		)
      ORDER BY
         pr_business_sequence
	
",2);
if($pr_business_id == "" && isset($entityList[0])) {
	$pr_business_id = $entityList[0]['pr_persona_ix'];
}
$GLOBALS['temp']['pr_business_id'] = $pr_business_id;

$entityHTML = "<li class=\"!tabClass!\"><a onclick=\"changeEntity('!pr_persona_ix!');\">!pr_name_last!</a></li>";

$entityTabs = "";
foreach($entityList as $item) {
	if($item['pr_persona_ix'] == $pr_business_id) {
		$item['tabClass'] = "uk-active";
		$item['tabBackground'] = "background-color:#f6f6f6;";
	} else {
		$item['tabClass'] = "buttonTab bb";
		$item['tabBackground'] = "";
	}
		
	$item['pr_name_last'] = t_encodeHTMLField($item['pr_name_last']);
	$entityTabs .= showpage($item,$entityHTML);
}
$GLOBALS['temp']['entityTabs'] = $entityTabs;

$folioList = $GLOBALS['lDB']->get("
	SELECT
		fn_folio.fn_folio_ix,
		fn_folio.fn_folio_folio_num,
		fn_folio.fn_folio_amount,
		pr_persona.pr_name_last,
		pr_persona.pr_name_first,
    rf_title.rf_title_desc,
    rf_name_suffix.rf_suffix_desc,
		rf_currency.rf_currency_symbol,
		fn_folio.rf_currency_id,
		fn_folio.fn_folio_db,
		fn_folio.fn_folio_trf_yn,
		ac_accomm_room.ac_desc
	FROM
		fn_folio
		LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = fn_folio.fn_folio_to_id
    LEFT JOIN rf_title ON rf_title.rf_title_ix = pr_persona.pr_title_id
    LEFT JOIN rf_name_suffix ON rf_name_suffix.rf_name_suffix_ix = pr_persona.pr_name_suffix_id
		LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
	 	LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = fn_folio.rv_res_item_group_id
		LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		
	WHERE
		fn_folio.rv_reservation_id = '$rv_reservation_ix'
		AND fn_folio.pr_business_id = '$pr_business_id'
		AND (
			fn_folio.fn_invoice_id IS NULL
			OR fn_folio.fn_invoice_id = ''
			OR fn_folio.fn_invoice_id = '0'
		)
",2);


$folioHTML = "
	<tr class=\"mgrey-bg\"> 
		<td class=\"bb\">&nbsp;<span>Folio !fn_folio_folio_num!</span></td>
		<td colspan=\"2\" class=\"bb\">&nbsp;!fn_folio_to_name! - <span class=\"txt\">!rf_currency_symbol!</span>!ac_desc!</td>
		<td colspan=\"2\" class=\"bb\">Room / Guest</td>
		<td class=\"bb uk-text-right\">!fn_folio_amount! !rf_currency_symbol!&nbsp;</td>
		<td class=\"bb\">&nbsp;</td>
	</tr>
";

$folioSectionHTML = "
        <tr valign=\"middle\"> 
          <td></td>
          <td>!name!</td>
		  <td>!pr_name_last!</td>
		  <td>!ac_desc!</td>
		  <td>!guests!</td>
          <td class=\"uk-text-right\">!amount! !currency!&nbsp;</td>
          <td><select class=\"uk-select\" onchange=\"updateFolios(this);\">!options!</select></td>
        </tr>
";

$folioSectionHTMLInactive = "
        <tr valign=\"middle\"> 
          <td></td>
          <td class=\"txtg\">!name!</td>
		  <td class=\"txtg\">!pr_name_last!</td>
		  <td class=\"txtg\">!ac_desc!</td>
		  <td class=\"txtg\">!guests!</td>
          <td align=\"right\" class=\"txtg\">!amount! !currency!&nbsp;</td>
          <td></td>
        </tr>
";

$folioRows = "";
foreach($folioList as $item) {
	$canEdit = canEditDB($item['fn_folio_db']) || ($GLOBALS['dbcode'] == $item['fn_folio_db'] && $item['fn_folio_trf_yn'] == "0");
	$tbaCheck = $GLOBALS['lDB']->get("
		SELECT
			COUNT(rv_res_item_comp.rv_res_item_comp_ix)
		FROM
			rv_reservation_item
			LEFT JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
		WHERE
			rv_reservation_item.fn_folio_id = '$item[fn_folio_ix]'
		GROUP BY
			rv_reservation_item.rv_reservation_item_ix
	",3);
	$isTBA = false;
    foreach($tbaCheck as $tbaItem) {
		if($tbaItem == "0") {
			$isTBA = true;
			$item['fn_folio_amount'] = "TBA";
			$item['rf_currency_symbol'] = "";
		}
	}	  
  $item['fn_folio_to_name'] = trim($item['pr_name_last']);
  if($item['rf_suffix_desc'] != ""){
   $item['fn_folio_to_name'] .= " ".$item['rf_suffix_desc'];
  }
  if(trim($item['pr_name_first']) != ""){
   if($item['fn_folio_to_name'] != ""){
   	 $item['fn_folio_to_name'] .= ", ";
   } 
   $item['fn_folio_to_name'] .= trim($item['pr_name_first']);
  }
  if($item['rf_title_desc'] != ""){
   $item['fn_folio_to_name'] .= " ".$item['rf_title_desc'];
  }
  
	if($item['fn_folio_to_name'] == "") {
		$item['fn_folio_to_name'] = "Cash";
	}
	if(trim($item['ac_desc']) != "") {
		$item['ac_desc'] = " - $item[ac_desc]";
	}

	$item['fn_folio_to_name'] = t_encodeHTMLField($item['fn_folio_to_name']);
	$item['ac_desc'] = t_encodeHTMLField($item['ac_desc']);
	$item['rf_currency_symbol'] = t_encodeHTMLField($item['rf_currency_symbol']);
	$folioRows .= showpage($item,$folioHTML);
	$folioAccomm = $GLOBALS['lDB']->get("
		SELECT
			count(rv_reservation_item.rv_reservation_item_ix) as count,
			sum(rv_reservation_item.rv_item_amt_payable) as amount
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.fn_folio_id = '$item[fn_folio_ix]'
	",1);
	if($folioAccomm['count'] > 0) {
		fixAmtDisplay($folioAccomm['amount']);
		$folioDropList = $GLOBALS['lDB']->get("
			SELECT
				fn_folio.fn_folio_ix,
				fn_folio.fn_folio_folio_num,
				fn_folio.fn_folio_db,
				fn_folio.fn_folio_trf_yn
			FROM
				fn_folio
			WHERE
				fn_folio.rv_reservation_id = '$rv_reservation_ix'
				AND fn_folio.pr_business_id = '$pr_business_id'
				AND fn_folio.rf_currency_id = '$item[rf_currency_id]'
				AND (
					fn_folio.fn_invoice_id IS NULL
					OR fn_folio.fn_invoice_id = ''
					OR fn_folio.fn_invoice_id = '0'
				)		
		",2);
		$folioOptions = "";
		foreach($folioDropList as $folioDropItem) {
			$canEditItem = canEditDB($folioDropItem['fn_folio_db']) || ($GLOBALS['dbcode'] == $folioDropItem['fn_folio_db'] && $folioDropItem['fn_folio_trf_yn'] == "0");
			if($canEditItem) {
				if($folioDropItem['fn_folio_ix'] == $item['fn_folio_ix']) {
					$selected = " SELECTED ";
				} else {
					$selected = "";
				}
				$folioOptions .= "<option value=\"$item[fn_folio_ix]:A:$folioDropItem[fn_folio_ix]\" $selected>Folio $folioDropItem[fn_folio_folio_num]</option>";
			}
		}		
		if($isTBA) {
			$folioAccomm['amount'] = "TBA";
		}
		$section = array('name'=>"Accommodation", 'amount'=>$folioAccomm['amount'], 'currency'=>$item['rf_currency_symbol'],'ac_desc'=>"&nbsp;", 'pr_name_last'=>"&nbsp;", 'guests'=>"&nbsp;", "options"=>$folioOptions);
		if($canEdit) {
			$folioRows .= showpage($section,$folioSectionHTML);
		} else {
			$folioRows .= showpage($section,$folioSectionHTMLInactive);
		}
	}
	$folioExtras = $GLOBALS['lDB']->get("
		SELECT
			ac_extra.ac_ext_desc,
			rv_extra.rv_extra_amt_payable,
			pr_persona.pr_name_last,
			ac_accomm_room.ac_desc,
			rv_res_item_group.rv_res_item_group_ix,
			rv_extra.rv_extra_ix
		FROM
			rv_extra
			INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_extra.pr_business_id
			LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_extra.rv_res_item_group_id
			LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		WHERE
			rv_extra.fn_folio_id = '$item[fn_folio_ix]'
		ORDER BY
			rv_extra.pr_business_id,
			rv_extra.rv_res_item_group_id
	",2);
	foreach($folioExtras as $extraItem) {
		fixAmtDisplay($extraItem['rv_extra_amt_payable']);
		$guestList = $GLOBALS['lDB']->get("
			SELECT
				pr_persona.pr_name_first,
				pr_persona.pr_name_last
			FROM
				rv_res_item_guest
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
			WHERE
				rv_res_item_guest.rv_res_item_group_id = '$extraItem[rv_res_item_group_ix]'
				
		",2);
		$guests = "";
		foreach($guestList as $guest) {
			if($guests != "") {
				$guests .= ", ";
			}
			$guests .= trim($guest['pr_name_first'] . " " . $guest['pr_name_last']);
		}
		$folioDropList = $GLOBALS['lDB']->get("
			SELECT
				fn_folio.fn_folio_ix,
				fn_folio.fn_folio_folio_num,
				fn_folio.fn_folio_db,
				fn_folio.fn_folio_trf_yn
			FROM
				fn_folio
			WHERE
				fn_folio.rv_reservation_id = '$rv_reservation_ix'
				AND fn_folio.pr_business_id = '$pr_business_id'
				AND fn_folio.rf_currency_id = '$item[rf_currency_id]'
				AND (
					fn_folio.fn_invoice_id IS NULL
					OR fn_folio.fn_invoice_id = ''
					OR fn_folio.fn_invoice_id = '0'
				)
				
		",2);
		$folioOptions = "";
		foreach($folioDropList as $folioDropItem) {
			$canEditItem = canEditDB($folioDropItem['fn_folio_db']) || ($GLOBALS['dbcode'] == $folioDropItem['fn_folio_db'] && $folioDropItem['fn_folio_trf_yn'] == "0");
			if($canEditItem) {
				if($folioDropItem['fn_folio_ix'] == $item['fn_folio_ix']) {
					$selected = " SELECTED ";
				} else {
					$selected = "";
				}
				$folioOptions .= "<option value=\"$item[fn_folio_ix]:$extraItem[rv_extra_ix]:$folioDropItem[fn_folio_ix]\" $selected>Folio $folioDropItem[fn_folio_folio_num]</option>";
			}
		}
		$section = array('name'=>t_encodeHTMLField($extraItem['ac_ext_desc']), 'amount'=>$extraItem['rv_extra_amt_payable'], 'currency'=>$item['rf_currency_symbol'],'ac_desc'=>t_encodeHTMLField($extraItem['ac_desc']), 'pr_name_last'=>t_encodeHTMLField($extraItem['pr_name_last']), 'guests'=>t_encodeHTMLField($guests), 'options'=>$folioOptions);
		if($canEdit) {
			$folioRows .= showpage($section,$folioSectionHTML);
		} else {
			$folioRows .= showpage($section,$folioSectionHTMLInactive);
		}
	}
}
$GLOBALS['temp']['folioRows'] = $folioRows ? $folioRows : "No folios found";
