<?php

/**
 * init.form298.php - Invoice Report
 * Job: 
*/

if(isset($_POST['action'])) {
	if($_POST['action'] == "checkLock") {
		$lock = new Lock("batch_invoice_$_POST[businessId]");
		if($lock->IsHeld()) {
			echo "held";
		} else {
			echo "free";
		}
		die();
	}
}

// Set the time limit to 15 minutes
@set_time_limit(900);

if ( isset($_POST['url']) && $_POST['url'] != "" ) {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
	// For passthrough from the financial setup/processing (form345), only the billing unit is set
	if($_SERVER['argc'] == 6) {
		if($_SERVER['argv'][1] == "" && $_SERVER['argv'][2] == "" && $_SERVER['argv'][3] == "" && $_SERVER['argv'][4] == "" && $_SERVER['argv'][5] != "") {
			$_SERVER['argc'] = 1;
		}
	}
}

$pf_object_id = db_pf_object_by_name("folio_invoice_report");
processProfileAction($pf_object_id,$profileFields);

$pf_option_id = applyProfile($pf_object_id,$profileFields);
$title = db_pf_option_get_title($pf_option_id);
if(trim($title) == "") {
	$title = "Folio / Invoice Report";
}
$newRelic = new NewRelic();
$newRelic->record_transaction($title);

$GLOBALS['temp']['title'] = $title;

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id, $pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();

if (!isset($GLOBALS[$form])) {
   $GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_invoice.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],25,"");

$allowInvoiceCreate = $GLOBALS['funLevelArray'][108] >= 10;
$allowInvoiceVoid = db_sc_group_get_user_setting("sc_grp_res_void_invoice_yn") == "1";

$GLOBALS['temp']['rows'] = "";

$resScrollSet = array();
$fiscalise = false;
$fiscal_status = '';
$fiscalMessage = '';
$fsInvoiceJoin = "";
$fsInvoiceDocNo = "";
$disablePrinting = '';
$disablePrintingClass = "";

$fiscalStatusCheck = updateIncompleteFiscalInvoices();

$GLOBALS['temp']['startupListTitle'] = "";
$GLOBALS['temp']['startupList'] = "";
$GLOBALS['temp']['fiscal_status'] = "";

$fromD = $_SERVER['argv'][1];
$toD = $_SERVER['argv'][2];


switch($fromD) {
case "all":
	$GLOBALS['temp']['optAll'] = "checked=\"checked\"";
	$fromDate = "All";
	$tmpDate = date("Y-m-d");
	$tmpArray = explode("-",$tmpDate);	

	$GLOBALS['temp']['fromY']	= $tmpArray[0];
	$GLOBALS['temp']['fromM']	= $tmpArray[1];
	$GLOBALS['temp']['fromD']	= $tmpArray[2];
	$GLOBALS['temp']['toY']		= $tmpArray[0];
	$GLOBALS['temp']['toM']		= $tmpArray[1];
	$GLOBALS['temp']['toD']		= $tmpArray[2];
	break;
case "today":
	$GLOBALS['temp']['optToday'] = "checked=\"checked\"";
	$fromDate = useDate("from","");
	$toDate = useDate("to","");
	break;
default:
	$GLOBALS['temp']['optCustomDate'] = "checked=\"checked\"";
	$fromDate = useDate("from", $fromD);
	$toDate = useDate("to", $toD);
	break;
}

if ($_SERVER['argv'][21] != "0"){
	$fromTravelDate = useDate("fromTravel", $_SERVER['argv'][21]);
} else {
	$fromTravelDate = useDate("fromTravel", "");
}

if ($_SERVER['argv'][22] != "0"){
	$toTravelDate = useDate("toTravel", $_SERVER['argv'][22]);
} else {
	$toTravelDate = useDate("toTravel", "");
}

// Race condition below :p
$GLOBALS['temp']['todayD'] = date("d");
$GLOBALS['temp']['todayM'] = date("m");
$GLOBALS['temp']['todayY'] = date("Y");
$today = date("Y-m-d");

// BUG #5484 : START ----------------------------------------------------------
// Reports to hide filters by default
$filterStatus = $_SERVER['argv'][15];
$showHideButtonText = $_SERVER['argv'][16];

$GLOBALS['temp']['filterStatus'] = urldecode($filterStatus);
$GLOBALS['temp']['showHideButtonText'] = $showHideButtonText;

if($filterStatus == "") {
	$GLOBALS['temp']['filterStatus'] = "";
}

if($showHideButtonText == "") {
	$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
}

if($_SERVER['argc'] > 1) {
	if($filterStatus == "") {
		$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";
		$GLOBALS['temp']['showHideButtonText'] = ">> Show Filters";
	}
}
// BUG #5484: END -------------------------------------------------------------


$GLOBALS['temp']['advancedForm'] = "collapse";
$GLOBALS['temp']['advancedTag'] = "<<  More";

if($_SERVER['argv'][1] == "" && $_SERVER['argv'][3] == "") {
	if($lDB->get("SELECT rf_db_env_type_ind FROM rf_database WHERE rf_db_code = '".$GLOBALS['dbcode']."'",4) == "2") {
		$_SERVER['argv'][3] = "Res";
	} else {
		$_SERVER['argv'][3] = $GLOBALS['dbcode'];
	}
}
$serverFilter = useFilter("server",$_SERVER['argv'][3],"SELECT rf_db_description FROM rf_database WHERE  rf_db_code=","fn_folio.fn_folio_db",false,"Reservation Office","Res");
$resList = $lDB->get("SELECT rf_db_code FROM rf_database WHERE rf_db_env_type_ind = '2'",3);
$serverFilter['where'] = str_replace("'Res'","'".join("','",$resList)."'",$serverFilter['where']);
$folioContactFilter = useFilter("folioContact",$_SERVER['argv'][4],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","fn_folio.fn_folio_to_id",false,"Cash","0");
//$billingEntitiesFilter = useFilter("billingEntities",$_SERVER['argv'][5],"SELECT pr_persona.pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix =","fn_folio.pr_business_id",false,false,false);
/*$billingList = $lDB->get("
         SELECT DISTINCT
			pr_business.pr_business_id as id,
            pr_persona.pr_name_last as namelast
         FROM
            pr_business
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
         WHERE
			pr_business.pr_bus_billing_yn = 1
			",2);*/
$billingList = $lDB->get("
	SELECT DISTINCT
			pr_business.pr_business_id as id,
            pr_persona.pr_name_last as namelast,
			pr_business.pr_bus_billing_yn
	FROM
		fn_folio
		INNER JOIN pr_business ON pr_business.pr_business_id = fn_folio.pr_business_id
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
",2);

function getHighestBilling($id) {
	global $lDB;
	$list = $lDB->get("
		SELECT
			pr_business_id
		FROM
			pr_business
		WHERE
			pr_business_parent = '$id'
		ORDER BY
			pr_business_sequence
	",3);
	foreach($list as $item) {
		$isInvoice = $lDB->get("SELECT pr_bus_billing_yn FROM pr_business WHERE pr_business_id = '$item'",4);
		if($isInvoice == "1") {
			return $item;
		} else {
			return getHighestBilling($item);
		}
	}
	return "";
}

if(trim($_SERVER['argv'][5]) == "") {
	$_SERVER['argv'][5] = $lDB->get("
		SELECT
			pr_business_id
		FROM
			rf_db_business
		WHERE
			rf_db_code = '".$GLOBALS['dbcode']."'
	",4);
	if($_SERVER['argv'][5] == "0" || trim($_SERVER['argv'][5]) == "") {
		$topLevel = $lDB->get("SELECT pr_business_id FROM pr_business WHERE pr_business_parent = '0'",3);
		$finalId = "";
		foreach($topLevel as $topId) {
			$currId = $topId;
			$isInvoice = $lDB->get("SELECT pr_bus_billing_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
			if($isInvoice == "1") {
				$finalId = $currId; 
				break;
			} else {
				$finalId =	getHighestBilling($currId);
			}			
		}
		$_SERVER['argv'][5] = "";
		if($finalId != "") {
			$_SERVER['argv'][5] = $finalId;
		}
	} else {
		$currId = $_SERVER['argv'][5];
		$finalId = "";
		while($currId != "0" && trim($currId) != "" && $finalId == "") {
			$isInvoice = $lDB->get("SELECT pr_bus_billing_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
			if($isInvoice == "1") { $finalId = $currId; }
			$currId = $lDB->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id = '$currId'",4);
		}
		if($finalId != "") {
			$_SERVER['argv'][5] = $finalId;
		}
	}
}
$billingOptions = "";
foreach($billingList as $billingItem) {
	$selected = "";
	if($_SERVER['argv'][5] == $billingItem['id']) {
		$selected = "selected";
	}
	$prefix = "";
	if($billingItem['pr_bus_billing_yn'] != "1") {
		$prefix = "* ";
	}
	$billingOptions .= "<option $selected value=\"$billingItem[id]\">$prefix$billingItem[namelast]</option>";
}
$billingId = trim($_SERVER['argv'][5]);
if($billingId != "") {
	$billingEntitiesFilter['where'] = " AND fn_folio.pr_business_id = '$billingId' ";
	if (checkFiscalisationByBusinessId($billingId) == true) {
		$disablePrinting = " disabled";
		$disablePrintingClass = " txtgr";
		$fsInvoiceJoin = " LEFT JOIN fs_invoice ON fs_invoice.fn_invoice_id = fn_invoice.fn_invoice_ix";
		$fsInvoiceDocNo = ", fs_invoice.fn_invoice_doc";
	}
}

$GLOBALS['temp']['disablePrinting'] = $disablePrinting;
$GLOBALS['temp']['disablePrintingClass'] = $disablePrintingClass;
$businessInfo = $lDB->get("
	SELECT
		pr_business.pr_bus_home_curr_id,
		rf_currency.rf_currency_symbol,
		pr_persona.pr_name_last		
	FROM
		pr_business
		INNER JOIN rf_currency  ON rf_currency.rf_currency_ix = pr_business.pr_bus_home_curr_id
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id		
	WHERE
		pr_business_id = '$billingId'
",1);
$GLOBALS['temp']['businessId'] = $billingId;
$GLOBALS['temp']['businessCurrencyId'] = $businessInfo['pr_bus_home_curr_id'];
$GLOBALS['temp']['businessCurrencySymbol'] = $businessInfo['rf_currency_symbol'];

$businessName = $businessInfo['pr_name_last'];

$GLOBALS['temp']['billingOptions'] = $billingOptions;
$statusACL = $lDB->get("
	SELECT
		rf_reservation_status_id
	FROM
		rf_reservation_status
	WHERE
		rf_reservation_status_id <> 25
		AND rf_reservation_status_id <> 15
		AND rf_reservation_status_id <> 97
",3);
$GLOBALS['temp']['hide'] = "";
if($_SERVER['argc'] < 2) {
	$GLOBALS['temp']['hide'] = "collapse";
}
if($_SERVER['argv'][1] == "" && $_SERVER['argv'][6] == "") {
//	$_SERVER['argv'][6] = "30:20";
	$_SERVER['argv'][6] = "30";
  $GLOBALS['temp']['hide'] = "collapse";
}
$statusFilter = useFilter("status",$_SERVER['argv'][6],"SELECT rf_reservation_status.rf_reservation_status_desc FROM rf_reservation_status WHERE rf_reservation_status_id =","rv_reservation.rf_reservation_status_id",$statusACL,false,false);
$currenciesFilter = useFilter("currencies",$_SERVER['argv'][7],"SELECT rf_currency.rf_currency_name FROM rf_currency WHERE rf_currency.rf_currency_ix =","fn_folio.rf_currency_id",false,false,false);

$invoiceDB = $_SERVER['argv'][8];
$invoicePrefix = $_SERVER['argv'][9];
$fromInvoice = trim($_SERVER['argv'][10]);
$toInvoice = trim($_SERVER['argv'][11]);
$sort = $_SERVER['argv'][12];
if(trim($sort) == "") {
	$sort = "7";
}
$GLOBALS['temp']['sort'] = $sort;
$options = $_SERVER['argv'][13];
$outstandingLimitType = $_SERVER['argv'][17];
$GLOBALS['temp']['outstandingLimitTypeAbove'] = "";
$GLOBALS['temp']['outstandingLimitTypeBelow'] = "";
if($outstandingLimitType == "above") {
	$GLOBALS['temp']['outstandingLimitTypeAbove'] = "selected";
} else {
	$GLOBALS['temp']['outstandingLimitTypeBelow'] = "selected";
}

$outstandingLimit = $_SERVER['argv'][18];
$GLOBALS['temp']['outstandingLimit'] = $outstandingLimit;

$overpaidLimitType = $_SERVER['argv'][19];
$GLOBALS['temp']['overpaidLimitTypeAbove'] = "";
$GLOBALS['temp']['overpaidLimitTypeBelow'] = "";
if($overpaidLimitType == "above") {
	$GLOBALS['temp']['overpaidLimitTypeAbove'] = "selected";
} else {
	$GLOBALS['temp']['overpaidLimitTypeBelow'] = "selected";
}

$overpaidLimit = $_SERVER['argv'][20];
$GLOBALS['temp']['overpaidLimit'] = $overpaidLimit;

$invoiceDBArray = $lDB->get("
	SELECT DISTINCT
		fn_folio_db
	FROM
		fn_folio
	ORDER BY
		fn_folio_db
",3);
$invoiceDBList = "";
foreach($invoiceDBArray as $item) {
	if($item == $invoiceDB) {
		$selected = " selected ";
	} else {
		$selected = "";
	}
	$invoiceDBList .= "<option $selected value=\"$item\">$item</option>";
}
if($invoiceDB == "") {
	$GLOBALS['temp']['invoiceDBAllSelected'] = "selected";
} else {
	$GLOBALS['temp']['invoiceDBAllSelected'] = "";
}
$GLOBALS['temp']['invoiceDBList'] = $invoiceDBList;
$invoicePrefixArray = $lDB->get("
	SELECT DISTINCT
		fn_invoice_prefix
	FROM
		fn_invoice
	WHERE
		trim(fn_invoice_prefix) <> ''
	ORDER BY
		fn_invoice_prefix
",3);
$invoicePrefixList = "";
foreach($invoicePrefixArray as $item) {
	if($item == $invoicePrefix) {
		$selected = " selected ";
	} else {
		$selected = "";
	}
	$invoicePrefixList .= "<option $selected value=\"$item\">$item</option>";	
}
if($invoicePrefix == "") {
	$GLOBALS['temp']['invoicePrefixAllSelected'] = "selected";
} else {
	$GLOBALS['temp']['invoicePrefixAllSelected'] = "";
}
$GLOBALS['temp']['invoicePrefixList'] = $invoicePrefixList;

// START - Process any invoice requests
$GLOBALS['temp']['invoiceScript'] = "";
$randomArray = explode("_",$_SERVER['argv'][14]);
$invoiceArray = array();
if(isset($_SESSION['repInvoiceRandomId']) && $randomArray[0] == $_SESSION['repInvoiceRandomId']) {
	if(isset($_POST['invoiceFolio']) && trim($_POST['invoiceFolio']) != "" && isset($_POST['invoiceDate']) && trim($_POST['invoiceDate']) != "" && $allowInvoiceCreate) {
		$newInvoice = db_fn_invoice_create($_POST['invoiceFolio'], $_POST['invoiceDate'], $_POST['invoiceExch']);
		array_push($invoiceArray,$newInvoice);
	}

	if(isset($_POST['voidId']) && trim($_POST['voidId']) != "" && $allowInvoiceVoid) {
	   db_fn_invoice_void($_POST['voidId']);
	}

	if(isset($_POST['batchInvoice']) && $_POST['batchInvoice'] == "1" && $allowInvoiceCreate) {
		$folioArray = explode(":",$_POST['batchInvoiceFolioList']);
		$businessId = $lDB->get("SELECT pr_business_id FROM fn_folio WHERE fn_folio.fn_folio_ix = '".$folioArray[0]."'",4);
		if(empty($businessId)) {
			$GLOBALS['temp']['invoiceScript'] = "
				<script language=\"javascript\">
					showMessage(\"Unknown or missing billing unit. Try again and if the problem persists, contact your system administrator.\",\"Error\");
				</script>
			";
		} else {
			$lock = new Lock("batch_invoice_$businessId");
			if($lock->Acquire()) {
				$dateType = $_POST['batchInvoiceDateType'];
				$invoiceDate = $_POST['batchInvoiceDate'];
				$exchangeRate = $_POST['batchInvoiceExch'];
				$printInvoice = $_POST['batchInvoicePrint'];
				$invoiceArray = array();
				foreach($folioArray as $folioId) {
					$businessPrint = $lDB->get("
						SELECT
							fn_folio.fn_folio_date as invoiceDate,
							pr_business.pr_bus_opt_accomm,
							pr_business.pr_bus_opt_bank,
							pr_business.pr_bus_opt_cca,
							pr_business.pr_bus_opt_date,
							pr_business.pr_bus_opt_special,
							pr_business.pr_bus_opt_special_note,
							pr_business.pr_bus_opt_tax,
							pr_business.pr_bus_opt_tax_table,
							pr_business.pr_bus_opt_tax_table_gl,
							pr_business.pr_bus_opt_tax_table_rate,
							pr_business.pr_bus_opt_tax_table_total,
							pr_business.pr_bus_opt_terms,
							pr_business.pr_bus_opt_terms_bus,
							pr_business.pr_bus_tax_table_align,
							pr_business.pr_business_id,
							fn_folio.rf_currency_id
						FROM
							fn_folio
							INNER JOIN pr_business ON pr_business.pr_business_id = fn_folio.pr_business_id
						WHERE
							fn_folio.fn_folio_ix = '$folioId'
					",1);
					if($dateType == 1) {
						$invoiceDate = $businessPrint['invoiceDate'];
					}
					if(trim($exchangeRate) == "") {
						$newInvoice = db_fn_invoice_create($folioId,$invoiceDate);
					} else {
						$newInvoice = db_fn_invoice_create($folioId,$invoiceDate,$exchangeRate);
					}
					if($businessPrint['pr_bus_opt_bank'] == "1") {
						$folioCurrencyId = $businessPrint['rf_currency_id'];
						if(cacheExists("batchInvoiceBank_".$businessPrint['pr_business_id']."_".$folioCurrencyId)) {
							$bankArray = cacheGet("batchInvoiceBank_".$businessPrint['pr_business_id']."_".$folioCurrencyId);
						} else {
							$bankArray = $lDB->get("
								SELECT DISTINCT
									rf_currency.rf_currency_symbol,
									rf_bank.rf_bank_name,
									rf_bank.rf_bank_acc_no,
									rf_bank.rf_bank_detail_1,
									rf_bank.rf_bank_detail_2,
									rf_bank.rf_bank_detail_3,
									rf_bank.rf_bank_acc_name,
									rf_bank.rf_bank_ix as bankId
								FROM
									pr_bus_bank
									INNER JOIN rf_bank ON rf_bank.rf_bank_ix = pr_bus_bank.rf_bank_id
									INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rf_bank.rf_currency_id
								WHERE
									pr_bus_bank.pr_business_id = '".$businessPrint['pr_business_id']."'
									AND rf_bank.rf_currency_id = '$folioCurrencyId'
							",2);
							cacheSet("batchInvoiceBank_".$businessPrint['pr_business_id']."_".$folioCurrencyId,$bankArray);
						}
						foreach($bankArray as $bankItem) {
							$lDB->put("
								INSERT INTO fn_invoice_bank (
									fn_invoice_bank_db,
									fn_invoice_bank_id,
									fn_inv_bank_acc_name,
									fn_inv_bank_acc_no,
									fn_inv_bank_detail_1,
									fn_inv_bank_detail_2,
									fn_inv_bank_detail_3,
									fn_inv_bank_name,
									fn_inv_currency_symbol,
									fn_invoice_id
								) VALUES (
									'".$GLOBALS['dbcode']."',
									'',
									'".$bankItem['rf_bank_acc_name']."',
									'".$bankItem['rf_bank_acc_no']."',
									'".$bankItem['rf_bank_detail_1']."',
									'".$bankItem['rf_bank_detail_2']."',
									'".$bankItem['rf_bank_detail_3']."',
									'".$bankItem['rf_bank_name']."',
									'".$bankItem['rf_currency_symbol']."',
									'$newInvoice'
								)
							");
						}
					}
					$lDB->put("
						UPDATE fn_invoice SET
							fn_inv_opt_accomm = '".$businessPrint['pr_bus_opt_accomm']."',
							fn_inv_opt_bank = '".$businessPrint['pr_bus_opt_bank']."',
							fn_inv_opt_cca = '".$businessPrint['pr_bus_opt_cca']."',
							fn_inv_opt_date = '".$businessPrint['pr_bus_opt_date']."',
							fn_inv_opt_special = '".$businessPrint['pr_bus_opt_special']."',
							fn_inv_opt_special_note = '".$businessPrint['pr_bus_opt_special_note']."',
							fn_inv_opt_tax = '".$businessPrint['pr_bus_opt_tax']."',
							fn_inv_opt_tax_table = '".$businessPrint['pr_bus_opt_tax_table']."',
							fn_inv_opt_tax_table_gl = '".$businessPrint['pr_bus_opt_tax_table_gl']."',
							fn_inv_opt_tax_table_rate = '".$businessPrint['pr_bus_opt_tax_table_rate']."',
							fn_inv_opt_tax_table_total = '".$businessPrint['pr_bus_opt_tax_table_total']."',
							fn_inv_opt_terms = '".$businessPrint['pr_bus_opt_terms']."',
							fn_inv_opt_terms_bus = '".$businessPrint['pr_bus_opt_terms_bus']."',
							fn_inv_tax_table_align = '".$businessPrint['pr_bus_tax_table_align']."',
							fn_inv_print_count = '-1'
						WHERE
							fn_invoice_ix = '$newInvoice'
					");
					array_push($invoiceArray,$newInvoice);
				}

				if(isset($_POST['batchInvoicePrint']) && $_POST['batchInvoicePrint'] == "1") {
					$GLOBALS['temp']['invoiceScript'] .= "
						<form method=\"post\" id=\"docPrintForm\" action=\"reservation.php?642\" target=\"docPrintPop\">
							<input type=\"hidden\" name=\"url\" id=\"docPrintURL\" value=\"\" />
						</form>
						
						<script language=\"javascript\">
							id(\"docPrintURL\").value = \"reservation.php?642++1++".join("|",$invoiceArray)."++++++++++1\";
							docPrintPop=openPopup(\"/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading PDF...\",640,480,0,0,0,1,\"docPrintPop\",\"opener.id('docPrintForm').submit();\");
						</script>
					";
				}
				$GLOBALS['temp']['startupList'] = "'" . join("','",$invoiceArray) . "'";
				if(sizeof($invoiceArray) > 1) {
					$GLOBALS['temp']['startupListTitle'] = sizeof($invoiceArray) . " invoices have been created:";
				} else {
					$GLOBALS['temp']['startupListTitle'] = sizeof($invoiceArray) . " invoice has been created:";
				}
				$lock->Release();
			} else {
				$GLOBALS['temp']['invoiceScript'] = "
					<script language=\"javascript\">
						showMessage(\"Another user is busy generating invoices for this billing unit. Try again later.\",\"Error\");
					</script>
				";
			}
		}
	}

	if(isset($_POST['batchPrint']) && $_POST['batchPrint'] == "1") {
		$GLOBALS['temp']['invoiceScript'] .= "
			<form method=\"post\" id=\"docPrintForm\" action=\"reservation.php?642\" target=\"docPrintPop\">
				<input type=\"hidden\" name=\"url\" id=\"docPrintURL\" value=\"\" />
			</form>
				
			<script language=\"javascript\">
				id(\"docPrintURL\").value = \"reservation.php?642++1++".join("|",explode(":",$_POST['batchPrintInvoiceList']))."++++++++++1\";
				docPrintPop=openPopup(\"/resource/Resrequest/Application/public/html/wait.htm?Please wait, loading PDF...\",640,480,0,0,0,1,\"docPrintPop\",\"opener.id('docPrintForm').submit();\");
			</script>			
		";
	}

	if(isset($_POST['batchRegen']) && $_POST['batchRegen'] == "1") {
		$folioList = explode(":",$_POST['batchRegenList']);
		foreach($folioList as $fn_folio_id) {
			regenFolio($fn_folio_id);
			$rv_reservation_id = db_get_rv_reservation_by_folio($fn_folio_id);
			specialsAutoApply($rv_reservation_id);
			ammendReservation($rv_reservation_id,"Regenerate Folio");
		}
		$GLOBALS['temp']['invoiceScript'] .= "
			<script language=\"javascript\">
				openMessage(\"Regeneration of selected folios is complete\");
			</script>
		";	
	}

	if(isset($_POST['writeOff']) && $_POST['writeOff'] == "1") {
		$folioList = explode(":",$_POST['writeOffList']);
		foreach($folioList as $fn_folio_id) {
			$folioInfo = $lDB->get("
				SELECT
					fn_folio.rf_currency_id,
					pr_business.pr_bus_home_curr_id
				FROM
					fn_folio
					INNER JOIN pr_business ON pr_business.pr_business_id = fn_folio.pr_business_id
				WHERE
					fn_folio.fn_folio_ix = '$fn_folio_id'
			",1);
			if($folioInfo['rf_currency_id'] == $folioInfo['pr_bus_home_curr_id']) {
				$exch = 1;
			} else {
				$exch = $_POST['writeOffExch'];
			}
			fn_folio_pay($fn_folio_id,$exch);
		}
		$GLOBALS['temp']['invoiceScript'] .= "
			<script language=\"javascript\">
				openMessage(\"Writing off of the outstanding amount on the selected folios is complete\");
			</script>
		";
	}
}
// END   - Process any invoice requests

switch($options & 7) {
   case REP_VIEW_HTML:
      $renderMode = "html";
      $renderType = "";
      break;
   case REP_VIEW_PDF:
      $renderMode = "pdf";
      $renderType = "view";
      break;
   case REP_EMAIL_PDF:
      $renderMode = "pdf";
      $renderType = "email";
      break;
   case REP_SEND_PDF:
      $renderMode = "pdf";
      $renderType = "send";
      break;
   case REP_VIEW_CSV:
      $renderMode = "csv";
      $renderType = "";
}

if($_SERVER['argc'] <= 2 && empty($_SERVER['argv'][13])) {
	$options = 8 + 32 + 64;
}

$folioCheck = false;
$invoiceCheck = false;
$debitCheck = false;
$creditCheck = false;
$balanceCheck = false;
$outstandingCheck = false;
$overpaidCheck = false;
$paidCheck = false;
$partPaidCheck = false;
$unpaidCheck = false;
$tbaCheck = false;
$validInvoiceCheck = false;
$voidInvoiceCheck = false;
$outstandingLimitCheck = false;
$overpaidLimitCheck = false;
$voidUnlinkedInvoiceCheck = false;
$checkFiscalisedInvoice = false;
$checkFiscalisedErrorInvoice = false;

$GLOBALS['temp']['reportType'] = "";
if($options & 8) {
	$folioCheck = true;
	$GLOBALS['temp']['reportType'] = "folio";
}
if($options & 16) {
	$invoiceCheck = true;
	$GLOBALS['temp']['reportType'] = "invoice";
}
if($folioCheck == false && $invoiceCheck == false) {
	$folioCheck = true;
}
if($options & 32) {
	$debitCheck = true;
}
if($options & 64) {
	$creditCheck = true;
}
if($options & 128) {
	$balanceCheck = true;
}
if($options & 256) {
	$outstandingCheck = true;
}
if($options & 512) {
	$overpaidCheck = true;
}
if($options & 1024) {
	$paidCheck = true;
}
if($options & 524288) {
	$partPaidCheck = true;
}
if($options & 262144) {
	$unpaidCheck = true;
}
if($options & 2048) {
	$tbaCheck = true;
}
if($options & 4096) {
	$validInvoiceCheck = true;
}
if($options & 8192) {
	$voidInvoiceCheck = true;
}
if($options & 16384) {
	$outstandingLimitCheck = true;
}
if($options & 32768) {
	$overpaidLimitCheck = true;
}
if($options & 65536) {
	$voidUnlinkedInvoiceCheck = true;
}
if(!$validInvoiceCheck && !$voidInvoiceCheck && !$voidUnlinkedInvoiceCheck) {
	$validInvoiceCheck = true;
}

if($options & REP_TRAVEL_DATE_RANGE) {
	$travelDateRange = true;
}

$GLOBALS['temp']['debitChecked'] = "";
$GLOBALS['temp']['creditChecked'] = "";
$GLOBALS['temp']['balanceChecked'] = "";
$GLOBALS['temp']['outstandingChecked'] = "";
$GLOBALS['temp']['overpaidChecked'] = "";
$GLOBALS['temp']['paidChecked'] = "";
$GLOBALS['temp']['partPaidChecked'] = "";
$GLOBALS['temp']['unpaidChecked'] = "";
$GLOBALS['temp']['tbaChecked'] = "";
$GLOBALS['temp']['validInvoiceChecked'] = "";
$GLOBALS['temp']['voidInvoiceChecked'] = "";
$GLOBALS['temp']['outstandingLimitChecked'] = "";
$GLOBALS['temp']['overpaidLimitChecked'] = "";
$GLOBALS['temp']['voidUnlinkedInvoiceChecked'] = "";
$GLOBALS['temp']['checkFiscalisedInvoiceChecked'] = "";
$GLOBALS['temp']['checkFiscalisedErrorInvoiceChecked'] = "";

$fiscalWhere = "";
if(isset($_SERVER['argv'][23]) && $_SERVER['argv'][23] == 'true' && $invoiceCheck) {
	$GLOBALS['temp']['checkFiscalisedInvoiceChecked'] = "checked";
	$fiscalWhere = " AND (fn_invoice.fn_inv_fiscal_status_ind = 2 || fn_invoice.fn_inv_fiscal_status_ind = 7) ";
}
if(isset($_SERVER['argv'][24]) && $_SERVER['argv'][24] == 'true' && $invoiceCheck) {
	$GLOBALS['temp']['checkFiscalisedErrorInvoiceChecked'] = "checked";
	$fiscalWhere = " AND (fn_invoice.fn_inv_fiscal_status_ind != 2 && fn_invoice.fn_inv_fiscal_status_ind != 7) ";
}

if($debitCheck) {
	$GLOBALS['temp']['debitChecked'] = "checked";
}
if($creditCheck){ 
	$GLOBALS['temp']['creditChecked'] = "checked";
}
if($balanceCheck){ 
	$GLOBALS['temp']['balanceChecked'] = "checked";
}
if($outstandingCheck) {
	$GLOBALS['temp']['outstandingChecked'] = "checked";
}
if($overpaidCheck) {
	$GLOBALS['temp']['overpaidChecked'] = "checked";
}
if($paidCheck) {
	$GLOBALS['temp']['paidChecked'] = "checked";
}
if($partPaidCheck) {
	$GLOBALS['temp']['partPaidChecked'] = "checked";
}
if($unpaidCheck) {
	$GLOBALS['temp']['unpaidChecked'] = "checked";
}
if($tbaCheck) {
	$GLOBALS['temp']['tbaChecked'] = "checked";
}
if($validInvoiceCheck) {
	$GLOBALS['temp']['validInvoiceChecked'] = "checked";
}
if($voidInvoiceCheck) {
	$GLOBALS['temp']['voidInvoiceChecked'] = "checked";
}
if($outstandingLimitCheck) {
	$GLOBALS['temp']['outstandingLimitChecked'] = "checked";
}
if($overpaidLimitCheck) {
	$GLOBALS['temp']['overpaidLimitChecked'] = "checked";
}
if($voidUnlinkedInvoiceCheck) {
	$GLOBALS['temp']['voidUnlinkedInvoiceChecked'] = "checked";
}
$GLOBALS['temp']['folioChecked'] = "";
$GLOBALS['temp']['invoiceChecked'] = "";
if($folioCheck) {
	$GLOBALS['temp']['folioChecked'] = "checked";
}
if($invoiceCheck) {
	$GLOBALS['temp']['invoiceChecked'] = "checked";
}

$GLOBALS['temp']['fromInvoice'] = "";
$GLOBALS['temp']['toInvoice'] = "";

if($fromInvoice != "") {
	$GLOBALS['temp']['fromInvoice'] = $fromInvoice;
}
if($toInvoice != "") {
	$GLOBALS['temp']['toInvoice'] = $toInvoice;
}

if($renderMode == "pdf" && $renderType == "email") {
	$pdfName = $fromDate == "All" ? "All" : "Invoice Report - ".$fromDate['htmlDate']." to ".$toDate['htmlDate']."";
	$attachmentTable = "
		<table border=\"0\" cellspacing=\"0\" width=\"100%\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\"></td>
			<td id=\"attachmentLabel\" width=\"100%\">$pdfName.pdf</td>
		</tr>
		</table>
	";
	
	$newOptions = ($options & ~3) + REP_SEND_PDF;
	$formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,13))."+".$newOptions."+".join("+",array_slice($_SERVER['argv'],14,23));

// echo $formAction."<BR>";

	$GLOBALS[$form]->FormHTML =   str_replace("!formAction!",$formAction,
				str_replace("!attachmentInfo!",$attachmentTable,
				str_replace("!attachmentName!",$pdfName.".pdf",
				str_replace("!hasAttachment!","expand",
				str_replace("!emailBody!","",
				str_replace("!emailSubject!",$pdfName,
				join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));
   // get principal
	$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
	$principalInfo = getPersonaDetail($principalId);
	$resOfficeInfo = getPersonaDetail($resOfficeId);

	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	$GLOBALS['temp']['princName'] = $principalInfo['name'];
	$GLOBALS['temp']['fax'] = $resOfficeInfo['fax'];
	$GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
	$userId = $_SESSION['userid'];
	$GLOBALS['temp']['emailFrom'] = $lDB->get("   SELECT
						   pr_persona.pr_email
						FROM
						   pr_persona
						WHERE
						   pr_persona.pr_persona_ix = '".$userId."'", 4);
	$GLOBALS['temp']['emailTo'] = "";
}


if($renderMode == "html") {
	if($options & REP_TRAVEL_DATE_RANGE) {
		$GLOBALS['temp']['travelDateRange'] = "checked";
		$GLOBALS['temp']['travelDateRangeSpan'] = "class=\"expand\"";
	} else {
		$GLOBALS['temp']['travelDateRange'] = "";
		$GLOBALS['temp']['travelDateRangeSpan'] = "class=\"collapse\"";
	}
}
	
$GLOBALS['temp']['showInvoiceButton'] = "collapse printCollapse";
$GLOBALS['temp']['showPrintButton'] = "collapse printCollapse";

$GLOBALS['temp']['resUp'] = "std";
$GLOBALS['temp']['resDown'] = "std";
$GLOBALS['temp']['resNameUp'] = "std";
$GLOBALS['temp']['resNameDown'] = "std";
$GLOBALS['temp']['invoiceIdUp'] = "std";
$GLOBALS['temp']['invoiceIdDown'] = "std";
$GLOBALS['temp']['invoiceToUp'] = "std";
$GLOBALS['temp']['invoiceToDown'] = "std";
$GLOBALS['temp']['invoiceDateUp'] = "std";
$GLOBALS['temp']['invoiceDateDown'] = "std";

$GLOBALS['temp']['today']				= chng_date(date("Y-m-d"),"-");

if($_SERVER['argc'] > 2) {
	if($folioCheck && $allowInvoiceCreate) {
		$GLOBALS['temp']['showInvoiceButton'] = "expand";
	}
	if($invoiceCheck) {
		$GLOBALS['temp']['showPrintButton'] = "expand";
	}

	if($renderMode == "html") {
		setLastReport("reservation.php?" . join("+",$_SERVER['argv']));
	}
	
	if ($fromDate == "All") {
		$folioDateWhere = "";
	} else {
		$folioDateWhere = "
			fn_folio.fn_folio_date BETWEEN '".$fromDate['jsDate']."' AND '".$toDate['jsDate']."'
		";
	}

	$sqlSelect = "
		SELECT
			rv_reservation.rv_reservation_ix,
			rv_reservation.rv_res_name,
			rv_reservation.rv_date_arrive,
			rv_reservation.rv_date_depart,
			rv_reservation.rf_reservation_status_id,
			rf_reservation_status.rf_reservation_status_desc,
			fn_invoice.fn_invoice_prefix,
			fn_invoice.fn_invoice_ix,
			pr_persona.pr_name_last,
			fn_invoice.fn_inv_status_ind,
			pr_persona.pr_name_first,
			fn_invoice.fn_inv_print_count,
			fn_invoice.fn_inv_date,
			rf_currency.rf_currency_symbol,
			fn_folio.fn_folio_amount,
			fn_invoice.fn_inv_amt_payable,
			fn_folio.fn_folio_amt_paid,
			fn_invoice.fn_inv_amt_paid,			
			rf_database.rf_db_code,
			rf_database.rf_db_env_type_ind,
			fn_folio.fn_folio_db,
			fn_folio.fn_folio_ix,
			fn_folio.rf_currency_id as folio_currency_id,
			pr_business.pr_bus_home_curr_id as business_currency_id,
			business_currency.rf_currency_symbol as business_currency_symbol,
			fn_folio.fn_folio_date,
			fn_folio.fn_folio_amt_tba_yn,
			pr_business.fiscalator_key,
			fn_invoice.fn_inv_fiscal_status_ind
			$fsInvoiceDocNo
	";
	$folioClause = "";
	if($folioCheck) {
		$folioClause = "
			AND fn_invoice.fn_inv_status_ind <> 8
		";
	}
	$sqlFrom = "
		FROM
			rv_reservation
			INNER JOIN fn_folio ON fn_folio.rv_reservation_id = rv_reservation.rv_reservation_ix
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
			INNER JOIN rf_database ON rf_database.rf_db_code = fn_folio.fn_folio_db
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = fn_folio.fn_folio_to_id
			LEFT JOIN fn_invoice ON fn_invoice.fn_folio_id = fn_folio.fn_folio_ix $folioClause
			$fsInvoiceJoin
			INNER JOIN pr_business ON pr_business.pr_business_id = fn_folio.pr_business_id
			LEFT JOIN rf_currency AS business_currency ON business_currency.rf_currency_ix = pr_business.pr_bus_home_curr_id
			LEFT JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
	";
	$invoiceWhere = "";
	if($invoiceCheck) {
		if($invoiceDB != "") {
			$invoiceWhere .= "
				AND fn_invoice.fn_invoice_db = '$invoiceDB'
			";
		}
		if($invoicePrefix != "") {
			$invoiceWhere .= "
				AND fn_invoice.fn_invoice_prefix = '$invoicePrefix'
			";
		}
		if($validInvoiceCheck && !$voidInvoiceCheck) {
			$invoiceWhere .= "
				AND fn_invoice.fn_inv_status_ind <> 8
			";
		}
		if(!$validInvoiceCheck && $voidInvoiceCheck) {
			$invoiceWhere .= "
				AND fn_invoice.fn_inv_status_ind = 8
			";
		}
		if($fromInvoice != "" && $toInvoice != "") {
			$invoiceWhere .= "
				AND fn_invoice.fn_invoice_id BETWEEN '$fromInvoice' AND '$toInvoice'
			";
		}
	}
	$checkWhere = "";
	if($folioCheck && !$invoiceCheck) {
		$checkWhere = "
			AND (fn_invoice.fn_invoice_ix IS NULL OR fn_invoice.fn_inv_status_ind = 8)
		";
	}
	if(!$folioCheck && $invoiceCheck) {
		$checkWhere = "
			AND fn_invoice.fn_invoice_ix IS NOT NULL
		";
	}

	$amountWhere = "";
	if($creditCheck) {
		$amountWhere = "
			AND fn_folio.fn_folio_amount < 0
		";
	}
	if($debitCheck) {
		$amountWhere = "
			AND fn_folio.fn_folio_amount > 0
		";
	}
	if($creditCheck && $debitCheck) {
		$amountWhere = "";
	}

	$balanceWhere = "";
	if($balanceCheck) {
		$balanceSQLArray = array();
		if($outstandingCheck) {
			if(!$outstandingLimitCheck) {
				$balanceSQLArray[] = "
					(fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) > 0
				";
			} else {
				if($outstandingLimitType == "above") {
					$balanceSQLArray[] = "
						(fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) > $outstandingLimit
					";
				} else {
					$balanceSQLArray[] = "
						(fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) > 0
						AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) < $outstandingLimit
					";
				}
			}
		}
		if($overpaidCheck) {
			if(!$overpaidLimitCheck) {
				$balanceSQLArray[] = "
					(fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) < 0
				";
			} else {
				$overpaidLimit = -$overpaidLimit;
				if($overpaidLimitType == "above") {
					$balanceSQLArray[] = "
						(fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) < $overpaidLimit
					";
				} else {
					$balanceSQLArray[] = "
						(fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) < 0
						AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) > $overpaidLimit
					";
				}
			}
		}
		if($paidCheck) {
			$balanceSQLArray[] = "
				(fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) = 0
			";
		}
		if($partPaidCheck) {
			$balanceSQLArray[] = "
				(fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) > 0
				AND fn_folio.fn_folio_amt_paid > 0
			";
		}
		if($unpaidCheck) {
			$balanceSQLArray[] = "
				fn_folio.fn_folio_amt_paid = 0
			";
		}

		if($tbaCheck) {
			$balanceSQLArray[] = "
				fn_folio.fn_folio_amt_tba_yn = '1'
			";
		} else {
			$balanceWhere .= "
				AND fn_folio.fn_folio_amt_tba_yn = '0'
			";
		}
		
		if(!empty($balanceSQLArray)) {
			$balanceWhere .= "AND ( (".join(") OR (",$balanceSQLArray) . ") )";
		}

	}
	
	
	if ( $options & REP_TRAVEL_DATE_RANGE ) {
		$sqlTravelWhere = "
			AND (
				(
					rv_reservation.rv_date_arrive >= '".$fromTravelDate['jsDate']."' 
					AND rv_reservation.rv_date_arrive <= '".$toTravelDate['jsDate']."'
				) OR (
					rv_reservation.rv_date_depart >= '".$fromTravelDate['jsDate']."' 
					AND rv_reservation.rv_date_depart <= '".$toTravelDate['jsDate']."'
				) OR (
					rv_reservation.rv_date_arrive < '".$fromTravelDate['jsDate']."' 
					AND rv_reservation.rv_date_depart > '".$toTravelDate['jsDate']."'
				)
			)
		";
	} else {
		$sqlTravelWhere = "";
	}	

	$sqlOrderBy = " ORDER BY ";
	$invDate = isset($invDate) ? $invDate : 0;
	switch($sort) {
	case 1:
		$sqlOrderBy .= "LENGTH(rv_reservation.rv_reservation_ix) ASC, rv_reservation.rv_reservation_ix ASC";
		$GLOBALS['temp']['resUp'] = "down";
		break;
	case 2:
		$sqlOrderBy .= "LENGTH(rv_reservation.rv_reservation_ix) DESC, rv_reservation.rv_reservation_ix DESC";
		$GLOBALS['temp']['resDown'] = "down";
		break;
	case 3:
		$sqlOrderBy .= "rv_reservation.rv_res_name";
		$GLOBALS['temp']['resNameUp'] = "down";
		break;
	case 4:
		$sqlOrderBy .= "rv_reservation.rv_res_name DESC";
		$GLOBALS['temp']['resNameDown'] = "down";
		break;
	case 5:
		$sqlOrderBy .= "LENGTH(fn_invoice.fn_invoice_ix) ASC, fn_invoice.fn_invoice_ix ASC";
		$GLOBALS['temp']['invoiceIdUp'] = "down";
		break;
	case 6:
		$sqlOrderBy .= "LENGTH(fn_invoice.fn_invoice_ix) DESC, fn_invoice.fn_invoice_ix DESC";
		$GLOBALS['temp']['invoiceIdDown'] = "down";
		break;
	case 7:
		$sqlOrderBy .= "pr_name_first, pr_name_last";
		$GLOBALS['temp']['invoiceToUp'] = "down";
		break;
	case 8:
		$sqlOrderBy .= "pr_name_first DESC, pr_name_last DESC";
		$GLOBALS['temp']['invoiceToDown'] = "down";
		break;
	case 9:
		if($invDate == 2) {
			$sqlOrderBy .= "rv_reservation.rv_date_arrive";
		} else {
			$sqlOrderBy .= "rv_reservation.rv_date_depart";
		}		
		$GLOBALS['temp']['invoiceDateUp'] = "down";
		break;
	case 10:
		if($invDate == 2) {
			$sqlOrderBy .= "rv_reservation.rv_date_arrive DESC";
		} else {
			$sqlOrderBy .= "rv_reservation.rv_date_depart DESC";
		}		
		$GLOBALS['temp']['invoiceDateDown'] = "down";
		break;
	}

	if ($fromDate == "All"){

		$sqlDateWhere = "
				(
					(/* folio */
						fn_invoice.fn_invoice_ix IS NULL
					) OR (/* invoice */
						fn_invoice.fn_invoice_ix IS NOT NULL
					) 
				)
		";
	
	} else {

		$sqlDateWhere = "
				(
					(/* folio */
						fn_invoice.fn_invoice_ix IS NULL
						AND $folioDateWhere
					) OR (/* invoice */
						fn_invoice.fn_invoice_ix IS NOT NULL
						AND fn_invoice.fn_inv_date BETWEEN '".$fromDate['jsDate']."' AND '".$toDate['jsDate']."'
					) 
				)
		";
	}



	$sqlWhere = "
		WHERE
			$sqlDateWhere
			$invoiceWhere
			$checkWhere
			$amountWhere
			$balanceWhere
			$sqlTravelWhere
			$fiscalWhere
	 ".$serverFilter['where']." ".$folioContactFilter['where']." ".$billingEntitiesFilter['where']." ".$statusFilter['where']." ".$currenciesFilter['where']."
	";
	if (!$validInvoiceCheck && !$voidInvoiceCheck) {
		$listArray = array();
	} else {
		$listArray = $lDB->get($sqlSelect.$sqlFrom.$sqlWhere.$sqlOrderBy,2);
	}

	if($voidUnlinkedInvoiceCheck) {
		if($billingId != "") {
			$billingUnitWhere = " AND fn_invoice.pr_business_id = '$billingId' ";
		} else {
			$billingUnitWhere = "";
		}
		$extraList = $lDB->get("			
			SELECT
				rv_reservation.rv_reservation_ix,
				rv_reservation.rv_res_name,
				rv_reservation.rv_date_arrive,
				rv_reservation.rv_date_depart,
				rv_reservation.rf_reservation_status_id,
				rf_reservation_status.rf_reservation_status_desc,
				fn_invoice.fn_invoice_prefix,
				fn_invoice.fn_invoice_ix,
				fn_invoice.fn_inv_to AS pr_name_last,
				'' AS pr_name_first,
				fn_invoice.fn_inv_status_ind,
				fn_invoice.fn_inv_print_count,
				fn_invoice.fn_inv_date,
				fn_invoice.fn_inv_curr AS rf_currency_symbol,
				fn_invoice.fn_inv_amt_payable,
				fn_invoice.fn_inv_amt_paid,
				fn_invoice.fn_inv_amt_paid AS fn_folio_amt_paid,
				rf_database.rf_db_code,
				rf_database.rf_db_env_type_ind,
				fn_invoice.fn_inv_curr_home AS business_currency_symbol,
				fn_invoice.fn_inv_date AS fn_folio_date,
				fn_folio.fn_folio_amt_tba_yn,
				fn_invoice.fn_inv_fiscal_status_ind
				$fsInvoiceDocNo
			FROM
				fn_invoice
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_invoice.rv_reservation_id
				LEFT JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
				LEFT JOIN fn_folio ON fn_folio.fn_folio_ix = fn_invoice.fn_folio_id
				INNER JOIN rf_database ON rf_database.rf_db_code = fn_invoice.fn_invoice_db
				$fsInvoiceJoin
			WHERE
				$sqlDateWhere
				$billingUnitWhere
				$fiscalWhere
				".$statusFilter['where']."
				AND fn_folio.fn_folio_ix IS NULL
				".$sqlOrderBy."
		",2);

		$listArray = array_merge($listArray,$extraList);
	}
	
	// Data setup - START
	$totals = array();
	foreach($listArray as $key=>$item) {
		$batchCheck = $lDB->get("
			SELECT
				COUNT(*)
			FROM
				fn_tran
				INNER JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
			WHERE
				fn_tran.fn_tran_link_id = '".$item['fn_invoice_ix']."'
				AND fn_tran.fn_tran_link_ind = ".DB_FN_TRAN_LINK_INVOICE."			
		",4);
		$hasBatch = false;
		if($batchCheck > 0) {
			$hasBatch = true;
			$batchClosedCheck = $lDB->get("
				SELECT
					COUNT(*)
				FROM
					fn_tran
					INNER JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
				WHERE
					fn_tran.fn_tran_link_id = '".$item['fn_invoice_ix']."'
					AND fn_tran.fn_tran_link_ind = ".DB_FN_TRAN_LINK_INVOICE."
					AND fn_batch.fn_batch_closed_yn = 1
			",4);
			$hasClosedBatch = false;
			if($batchClosedCheck > 0) {
				$hasClosedBatch = true;
			}
		}
		
		$hasTBA = false;
		if (isset($item['fn_folio_ix']) && $item['fn_folio_amt_tba_yn'] == "1") {
			$hasTBA = true;
		}
		
	    array_push($resScrollSet,$item['rv_reservation_ix']);		
		if(trim($listArray[$key]['fn_inv_date']) == "" || $listArray[$key]['fn_inv_date'] == "0") {
			$listArray[$key]['fn_inv_date'] = $listArray[$key]['fn_folio_date'];
		}
		$item['fn_inv_date_raw'] = $listArray[$key]['fn_inv_date_raw'] = $listArray[$key]['fn_inv_date'];
		$listArray[$key]['inv_type'] = "";
		if($item['fn_inv_status_ind'] == "2") { $listArray[$key]['inv_type'] = ""; }
		if($item['fn_inv_status_ind'] == "4") { $listArray[$key]['inv_type'] = "Credit"; }
		if($item['fn_inv_status_ind'] == "8") { $listArray[$key]['inv_type'] = "Void"; }
		$listArray[$key]['fn_inv_date'] = chng_date($listArray[$key]['fn_inv_date'],"-");
		$pr_name = "";
		$pr_name .= trim($item['pr_name_first']);
		if($pr_name != "") {
			$pr_name .= " ";
		}
		$pr_name = trim($pr_name . $item['pr_name_last']);
		if($pr_name == "") {
			$pr_name = "Cash";
		}
		$listArray[$key]['pr_name'] = $pr_name;
		$rv_payment_amt = 0;
		if (isset($item['fn_folio_ix'])) {
			$rv_payment_amt = $lDB->get("
				SELECT 
					SUM(rv_payment_item_amt) as rv_payment_amt
				FROM
					rv_payment_item
				WHERE
					fn_folio_id = '".$item['fn_folio_ix']."'
			",4);
		}
		if($rv_payment_amt == "0" || trim($rv_payment_amt) == "") {
			$rv_payment_amt = "0";
		}

		if(!empty($item['fn_invoice_ix'])) {
			$item['fn_folio_amount'] = $listArray[$key]['fn_folio_amount'] = $listArray[$key]['fn_inv_amt_payable'];
		}
		
		if(!$hasTBA && ( (!$balanceCheck) || ($balanceCheck && !$tbaCheck) ) ) {
			if(!array_key_exists($item['rf_currency_symbol'],$totals)) {
				$totals[$item['rf_currency_symbol']] = array(
					"invoice_amount" => $listArray[$key]['fn_folio_amount'],
					"pay_amount" => $rv_payment_amt,
					"due_amount" => $listArray[$key]['fn_folio_amount']-$rv_payment_amt
				);
			} else {
				$totals[$item['rf_currency_symbol']]['invoice_amount'] += $listArray[$key]['fn_folio_amount'];
				$totals[$item['rf_currency_symbol']]['pay_amount'] += $rv_payment_amt;
				$totals[$item['rf_currency_symbol']]['due_amount'] += $listArray[$key]['fn_folio_amount']-$rv_payment_amt;
			}
		}

		if($item['fn_inv_status_ind'] != "8") {
			$rv_payment_amt = $listArray[$key]['fn_folio_amount']-$rv_payment_amt;
		} else {
			$rv_payment_amt = $listArray[$key]['fn_folio_amount']-$item['fn_inv_amt_paid'];
		}
		fixAmtDisplay($rv_payment_amt);
		$listArray[$key]['rv_payment_amt'] = $rv_payment_amt; 

		$listArray[$key]['outstanding'] = $item['fn_folio_amount'] - $item['fn_folio_amt_paid'];
		$exchangeNeeded = "false";
		if(isset($item['folio_currency_id']) && isset($item['business_currency_id']) && ($item['folio_currency_id'] != $item['business_currency_id'])) {
			// need exchange
			$exchangeNeeded = "true";
			$exchangeRate = db_rf_exchange_rate_get_rate_by_all($item['folio_currency_id'],$item['business_currency_id']);
		} else {
			$exchangeNeeded = "false";
			$exchangeRate = "1";
		}
		$listArray[$key]['exchangeNeeded'] = $exchangeNeeded;
		$listArray[$key]['exchangeRate'] = $exchangeRate;

		$listArray[$key]['invoiceDate'] = $item['fn_folio_date'];
		$listArray[$key]['showVoidButton'] = " visibility: hidden; ";		
		$listArray[$key]['allowVoid'] = "0";
		$listArray[$key]['hasBatch'] = "0";
		$listArray[$key]['docType'] = "folio";
		$listArray[$key]['doc'] = "bFolio";
		$listArray[$key]['openDoc'] = isset($item['fn_folio_ix']) ? "showFolio('".$item['fn_folio_ix']."')" : "";
		$listArray[$key]['docOverlib'] = "<span class=txts>View Proforma</span>";    

		$canEditFolio = isset($item['fn_folio_db']) ? canEditDB($item['fn_folio_db']) : false;
		$allowInvoice = /*$item['rf_reservation_status_id'] >= 30 &&*/ $canEditFolio /*&& !$hasTBA*/ && $GLOBALS['jobLevelArray'][233] >= 10;
		$invoiceExists = trim($item['fn_invoice_ix']) != "" && $item['fn_inv_status_ind'] != "8";
		
		$cannotInvoiceReason = "";
		/*if($item['rf_reservation_status_id'] < 30) {
			$cannotInvoiceReason = "A reservation must have either a confirmed or cancelled status for the folios to be invoiced.";
		}*/
		if($hasTBA) {
			$cannotInvoiceReason = "This folio contains a to be advised charge and as such cannot be invoiced.";
			$listArray[$key]['fn_folio_amount'] = "TBA";
			$listArray[$key]['rv_payment_amt'] = "TBA";
			$listArray[$key]['is_tba'] = "1";
			$item['is_tba'] = "1";
		}
		if(!$canEditFolio) {
			$cannotInvoiceReason = "You do not have access to invoice this folio on this enviroment. This is due to either the folio belonging to a different environment or your environment not having master status.";
		}
		if($invoiceExists) {
			$cannotInvoiceReason = "This folio has already been invoiced.";
		}
		if($GLOBALS['jobLevelArray'][233] < 10) {
			$cannotInvoiceReason = "You do not have the required level of access invoice this folio.";
		}		
		$listArray[$key]['invoiceCheck'] = "<span onmouseover=\"overlib('".t_encodeOverlib($cannotInvoiceReason)."')\" onmouseout=\"nd()\"><input type=\"checkbox\" disabled><span>";
		if($invoiceExists || !$allowInvoice) {
			$listArray[$key]['showInvoiceButton'] = " visibility: hidden; ";
			if($invoiceExists) {
				$listArray[$key]['showVoidButton'] = "";
				$listArray[$key]['allowVoid'] = "1";
				if(!$allowInvoiceVoid) {
					$listArray[$key]['allowVoid'] = "0";
				}
				if($hasBatch) {
					$listArray[$key]['hasBatch'] = "1";
					if($hasClosedBatch == "1") {
						$listArray[$key]['allowVoid'] = "0";
					}
				}
				$listArray[$key]['docType'] = "invoice";
				$listArray[$key]['doc'] = "bInvoice";
		    	$listArray[$key]['openDoc'] = "showInvoice('".$item['fn_invoice_ix']."')";
			    $listArray[$key]['docOverlib'] = "<span class=txts>View Invoice</span>";
			}
		} else {
			if($item['fn_inv_status_ind'] != "8") {
				$listArray[$key]['showInvoiceButton'] = "";

				$allowFutureInvoice = (db_fn_invoice_allow_future_date($item['fn_folio_ix'])?"1":"0");
				$invoiceMaxDate = db_fn_invoice_max_date($item['fn_folio_ix']);
				
				$item['is_tba'] = isset($item['is_tba']) ? $item['is_tba'] : "";
				$listArray[$key]['invoiceCheck'] = "<span><input name=\"invoiceCheck\" type=\"checkbox\" onclick=\"invoiceCheckClick(this);\" currency=\"$item[rf_currency_symbol]\" currency_id=\"$item[folio_currency_id]\" folio_id=\"$item[fn_folio_ix]\" folio_date=\"$item[fn_inv_date_raw]\" invoice_max_date=\"$invoiceMaxDate\" allow_future_invoice=\"$allowFutureInvoice\" outstanding=\"".$listArray[$key]['outstanding']."\" reservation_id=\"$item[rv_reservation_ix]\" is_tba=\"$item[is_tba]\" status_id=\"$item[rf_reservation_status_id]\" exchange=\"$exchangeRate\"></span>";
			} else {
				$listArray[$key]['showInvoiceButton'] = " visibility: hidden; ";
				$listArray[$key]['docType'] = "invoice";
				$listArray[$key]['doc'] = "bInvoice";
		    	$listArray[$key]['openDoc'] = "showInvoice('".$item['fn_invoice_ix']."')";
			    $listArray[$key]['docOverlib'] = "<span class=txts>View Invoice</span>";
			}
		}

		$fiscalise = false;
		$fiscal_status = '';
		$fiscalMessage = '';
		$fiscalDisable = "";

		if (checkFiscalisationByInvoice($item['fn_invoice_ix'])) {
			// 1 = Pending, 2 = Verified, 3 = Rejected, 4 = Error, 6 = creditPending, 7 = creditApproved, 8 = creditError, 9 = Zero folio
			$fiscalDisable = "disabled";
			$fiscal_status = '<i class="material-icons txtred">report</i>';
			$fiscalise = true;
	
			switch ($item['fn_inv_fiscal_status_ind']) {
				case 1:
				case 6:
					$fiscalMessage = "title='Fiscal status: Pending'";
					break;
				case 2:
				case 7:
					$fiscalMessage = "title='Fiscal status: Verified'";
					$fiscal_status = '<i class="material-icons">check_circle</i>';
					$fiscalDisable = "";
					break;
				case 3:
					$fiscalMessage = "title='Fiscal status: Rejected'";
					break;
				case 4:
				case 8:
					$fiscalMessage = "title='Fiscal status: Error'";
					break;
				case 9:
					$fiscalMessage = "title='Fiscal status: Zero total not submitted'";
					$fiscal_status = "";
					$fiscalDisable = "";	
					break;
				default:
					$fiscalMessage = "title='Fiscal status: Not Submitted'";
			}
		}

		if($invoiceCheck) {
			$item['folio_currency_id'] = isset($item['folio_currency_id']) ? $item['folio_currency_id'] : "";
			$item['fn_folio_ix'] = isset($item['fn_folio_ix']) ? $item['fn_folio_ix'] : "";
			$listArray[$key]['invoiceCheck'] = "<span><input name=\"printCheck\" type=\"checkbox\" currency=\"$item[rf_currency_symbol]\" currency_id=\"$item[folio_currency_id]\" invoice_id=\"$item[fn_invoice_ix]\" folio_id=\"$item[fn_folio_ix]\" $fiscalDisable></span>";
		}
		$listArray[$key]['colClass'] = "colInv";
		if($rv_payment_amt < 0) {
			$listArray[$key]['colClass'] = "colInvCrBal";
		}

		if($item['fn_folio_amount'] < 0) {
			$listArray[$key]['colClass'] = "colInvCrNote";
		}
			
		if($item['fn_inv_status_ind'] == "8" && (!$folioCheck)) {
			$listArray[$key]['colClass'] = "colInvVoid";
		}
		if($item['fn_inv_print_count'] == "-1") {
			$listArray[$key]['fn_inv_print_count'] = "0";
		}
		if ($fiscalise) {
			$listArray[$key]['fiscalMessage'] = $fiscalMessage;
			$listArray[$key]['fiscal_status'] = $fiscal_status;
			$listArray[$key]['fiscalise'] = $fiscalise;
		}

		$listArray[$key]['fn_invoice_doc'] = $listArray[$key]['fn_invoice_doc'] ?? '';

		$listArray[$key]['fn_invoice_doc'] = strpos($listArray[$key]['fn_invoice_doc'], ',') !== false
			? substr($listArray[$key]['fn_invoice_doc'], 0, strpos($listArray[$key]['fn_invoice_doc'], ','))
			: $listArray[$key]['fn_invoice_doc'];
	}

	setRecordScroll(array_unique($resScrollSet));
	// Data setup - END

	// Data output - START
	if($renderMode == "html") {
		$rowHTML = Join("",file(__DIR__ . "/../../../public/html/rep_invoice_row.htm"));
		$totalRowHTML = Join("",file(__DIR__ . "/../../../public/html/rep_invoice_total_row.htm"));
		$rows = "";
		foreach($listArray as $item) {
			$rows .= showpage($item,$rowHTML);
		}
		$first = true;
		foreach($totals as $currencySymbol => $currencyItem) {
			$currencyItem['rf_currency_symbol'] = $currencySymbol;
			fixAmtDisplay($currencyItem['invoice_amount']);
			fixAmtDisplay($currencyItem['due_amount']);
			if($first) {
				$currencyItem['totalClass'] = "bt";
				$currencyItem['total_label'] = "Totals";
			} else {
				$currencyItem['totalClass'] = "";
				$currencyItem['total_label'] = "&nbsp;";
			}
			$rows .= showpage($currencyItem,$totalRowHTML);
			$first = false;
		}
		$GLOBALS['temp']['rows'] = $rows;
		if(sizeof($listArray) == "") {
			$GLOBALS['temp']['rows'] = "<tr><td colspan=\"14\" align=\"center\" class=\"br bl\">No data matched your filter criteria.</td></tr>";
		}
	}

	if ($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {
		$pdf = new PDF("Invoice Report");
		$reportLabel = "Invoice Report";

		if ($folioCheck) {
			$invoiceType = "Uninvoiced Folios";
		}		
		
		if ($invoiceCheck) {
			$invoiceType = "Invoiced";

			if ($validInvoiceCheck) {
				$invoiceType .= ", Valid Invoices";
			}		
	
			if ($voidInvoiceCheck) {
				$invoiceType .= ", Voided Invoices";
			}		
			
			if ($voidUnlinkedInvoiceCheck) {
				$invoiceType .= ", Unlinked Voided Invoices";
			}

			$fiscalFilterType = '';
			if ($GLOBALS['temp']['checkFiscalisedInvoiceChecked'] == "checked") {
				$fiscalFilterType = 'Verified';
			}
			if ($GLOBALS['temp']['checkFiscalisedErrorInvoiceChecked'] == "checked") {
				$fiscalFilterType = 'Unverified';
			}
		}				
		
		// Main PDF header		
		$headerArray[] = array('name' => "Uninvoiced / Invoiced", 'value' => $invoiceType);
		if ($item['fn_inv_fiscal_status_ind'] && !empty($fiscalFilterType)) {
			$headerArray[] = array('name' => "Verified / Unverified", 'value' => $fiscalFilterType);
		}

		if ($fromInvoice != "" || $toInvoice != "" ) {
			$headerArray[] = array('name' => "Invoice Range", 'value' => $fromInvoice . " to " . $toInvoice);
		}

		$headerArray[] = array('name' => "Date Range", 'value' => ( $fromDate == "All" ? "All" : $fromDate['htmlDate'] . " to " . $toDate['htmlDate'] ) );
		$headerArray[] = array('name' => "Status", 'value' => $statusFilter['names']);
		$headerArray[] = array('name' => "Owner Environment", 'value' => $serverFilter['names']);
		$headerArray[] = array('name' => "Debtor", 'value' => $folioContactFilter['names']);
		$headerArray[] = array('name' => "Invoice From", 'value' => $businessName);

		if ($outstandingCheck) {
			$headerArray[] = array('name' => "Balance", 'value' => "Amount Outstanding");
		}
		
		if ($overpaidCheck) {
			$headerArray[] = array('name' => "Balance", 'value' => "Overpaid");
		}
		
		if ($paidCheck) {
			$headerArray[] = array('name' => "Balance", 'value' => "Fully Paid");
		}

		if ($partPaidCheck) {
			$headerArray[] = array('name' => "Balance", 'value' => "Part Paid");
		}

		if ($unpaidCheck) {
			$headerArray[] = array('name' => "Balance", 'value' => "Unpaid");
		}
		
		if ($tbaCheck) {
			$headerArray[] = array('name' => "Balance", 'value' => "TBA");
		}						

		if($options & REP_TRAVEL_DATE_RANGE) {
			$headerArray[] = array('name' => "Travel date range", 'value' => $fromTravelDate['htmlDate']." to " .$toTravelDate['htmlDate']);
		}
		
		//$pdf->ReportHeader($reportLabel, $headerArray);
		$pdfFontSize = 8;
		$pdf->SetFont('Arial', '', $pdfFontSize);
		$pdf->SetFont('Arial', '', 7);

		$pdf->Ln(2);
		$headRow = array();
		array_push($headRow,
			array('width'=>"8%", 'height'=>"4", 'data'=>"Res No", 'border'=>"LTB", 'fill'=>1),
			array('width'=>"16%", 'height'=>"4", 'data'=>"Reservation Name", 'border'=>"LTB", 'fill'=>1),
			array('width'=>"10%", 'height'=>"4", 'data'=>"Inv #", 'border'=>"LTB", 'fill'=>1),
			array('width'=>"13%", 'height'=>"4", 'data'=>"Invoice To", 'border'=>"LTB", 'fill'=>1),
			array('width'=>"4%", 'height'=>"4", 'data'=>"Print", 'border'=>"LTB", 'fill'=>1, 'align'=>"C"),
			array('width'=>"9%", 'height'=>"4", 'data'=>"Inv Date", 'border'=>"LTB", 'fill'=>1),
			array('width'=>"9%", 'height'=>"4", 'data'=>"Status", 'border'=>"LTB", 'fill'=>1),
			array('width'=>"7%", 'height'=>"4", 'data'=>"Curr", 'border'=>"LTB", 'fill'=>1, 'align'=>"C"),
			array('width'=>"8%", 'height'=>"4", 'data'=>"Inv Amt", 'border'=>"LTB", 'fill'=>1, 'align'=>"R"),
			array('width'=>"8%", 'height'=>"4", 'data'=>"Amt Due", 'border'=>"LTB", 'fill'=>1, 'align'=>"R"),
			array('width'=>"4%", 'height'=>"4", 'data'=>"Inv Type", 'border'=>"LTB", 'fill'=>1),
			array('width'=>"4%", 'height'=>"4", 'data'=>"FS", 'border'=>"LTRB", 'fill'=>1, 'align'=>"C")
		);
        $pdf->Row($headRow);
		foreach($listArray as $item) {
			// 1 = Pending, 2 = Verified, 3 = Rejected, 4 = Error, 6 = creditPending, 7 = creditApproved, 8 = creditError, 9 = Zero folio
			switch ($item['fn_inv_fiscal_status_ind']) {
				case 2:
				case 7:
					$fiscal_status_indicator = __DIR__ . '/../../../public/img/tick.jpg';
					break;
				case 1:
				case 3:
				case 4:
				case 6:
				case 8:
					$fiscal_status_indicator = __DIR__ . '/../../../public/img/warn.jpg';
					break;
				default:
					$fiscal_status_indicator = __DIR__ . '/../../../public/img/1x1.jpg';
			}

			$Y_Pos = $pdf->GetY()+0.5;
			$X_Pos = $pdf->GetX()+185;
			if ($Y_Pos >= 270) {
				$pdf->SetY(-15);
				$pdf->AddPage();
				$Y_Pos = 11.5;
			}
			$setFisImage = $pdf->image($fiscal_status_indicator,$X_Pos,$Y_Pos, 0, 2.5,'jpg');
			$fsInvoiceDocNoPdf = $fsInvoiceDocNo == "" ? "" : " " . substr($item['fn_invoice_doc'],-12);
			$pdf->Row(array(
				array('width'=>"8%", 'data'=>$item['rv_reservation_ix'], 'border'=>'LR'),
				array('width'=>"16%", 'data'=>$item['rv_res_name'], 'border'=>'LR'),
				array('width'=>"10%", 'data'=>$item['fn_invoice_ix'] . $fsInvoiceDocNoPdf, 'border'=>'LR'),
				array('width'=>"13%", 'data'=>$item['pr_name'], 'border'=>'LR'),
				array('width'=>"4%", 'data'=>$item['fn_inv_print_count'], 'border'=>'LR','align'=>"C"),
				array('width'=>"9%", 'data'=>$item['fn_inv_date'], 'border'=>'LR'),
				array('width'=>"9%", 'data'=>$item['rf_reservation_status_desc'], 'border'=>'LR'),
				array('width'=>"7%", 'data'=>$item['rf_currency_symbol'], 'border'=>'LR', 'align'=>"C"),
				array('width'=>"8%", 'data'=>$item['fn_folio_amount'], 'border'=>'LR', 'align'=>"R"),
				array('width'=>"8%", 'data'=>$item['rv_payment_amt'], 'border'=>'LR', 'align'=>"R"),
				array('width'=>"4%", 'data'=>$item['inv_type'], 'border'=>'LR'),
				array('width'=>"4%", 'data'=>'', 'border'=>'LR', 'align'=>"C"),
			));
		}
		$first = true;
		foreach($totals as $currencySymbol => $currencyItem) {
			if($first) {
				$totalLabel = "Totals";
				$extraBorder = "T";
			} else {
				$totalLabel = "";
				$extraBorder = "";
			}
			fixAmtDisplay($currencyItem['invoice_amount'],2);
			fixAmtDisplay($currencyItem['due_amount'],2);
			$pdf->Row(array(
				array('width'=>"8%", 'data'=>$totalLabel, 'border'=>'LR'.$extraBorder, 'fill'=>"1"),
				array('width'=>"16%", 'data'=>"", 'border'=>'LR'.$extraBorder, 'fill'=>"1"),
				array('width'=>"10%", 'data'=>"", 'border'=>'LR'.$extraBorder, 'fill'=>"1"),
				array('width'=>"13%", 'data'=>"", 'border'=>'LR'.$extraBorder, 'fill'=>"1"),
				array('width'=>"4%", 'data'=>"", 'border'=>'LR'.$extraBorder,'align'=>"C", 'fill'=>"1"),
				array('width'=>"9%", 'data'=>"", 'border'=>'LR'.$extraBorder, 'fill'=>"1"),
				array('width'=>"9%", 'data'=>"", 'border'=>'LR'.$extraBorder, 'fill'=>"1"),
				array('width'=>"7%", 'data'=>$currencySymbol, 'border'=>'LR'.$extraBorder, 'align'=>"C", 'fill'=>"1"),
				array('width'=>"8%", 'data'=>$currencyItem['invoice_amount'], 'border'=>'LR'.$extraBorder, 'align'=>"R", 'fill'=>"1"),
				array('width'=>"8%", 'data'=>$currencyItem['due_amount'], 'border'=>'LR'.$extraBorder, 'align'=>"R", 'fill'=>"1"),
				array('width'=>"4%", 'data'=>"", 'border'=>'LR'.$extraBorder, 'fill'=>"1"),
				array('width'=>"4%", 'data'=>"", 'border'=>'LR'.$extraBorder, 'fill'=>"1"),
			));
			$first = false;
		}
		$pdf->Row(array(array('width'=>"100%", 'border'=>'T')));
		
		$pdfFontSize = 6;
		$pdf->SetFont('Arial', '', $pdfFontSize);
		$pdf->ReportHeader($reportLabel, $headerArray);

		if($renderType == "view") {
			$pdf->OutPut();
			die();
		}
		if($renderType == "send") {
		
			$to = $_POST['mail_to'];
			$from = $_POST['mail_from'];
			$subject = $_POST['mail_subj'];
			$message = $_POST['mail_body'];
			$attachmentName = $_POST['attachmentName'];

			$headers = "From: ".$GLOBALS['princName']."<$from>\r\n";

			// close the pdf
			if($pdf->state<3) $pdf->Close();

			/* and now mail it */
			if($attachmentName != "!attachmentName!") {
				$pdfName = $attachmentName;
			} else {
				$pdfName = "Update report from $fromDate to $toDate.pdf";
			}

			$error = email($from, $to, $subject, $headers, $message, 0, 0, $_SERVER['argv'][1], $GLOBALS['princName'],$pdf->buffer,$pdfName);     // (from, to, subject, headers, message, action, emailID, resID)
			
			if(!$error) {
				echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
				die();
			} else {
				echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
				die();
			}
      }
	}
	// Data output - END
}

if($renderMode == "csv") {

	if ($folioCheck) {
		$invoiceType = "Uninvoiced Folios";
	}		
	
	if ($invoiceCheck) {
		$invoiceType = "Invoiced";

		if ($validInvoiceCheck) {
			$invoiceType .= ", Valid Invoices";
		}		

		if ($voidInvoiceCheck) {
			$invoiceType .= ", Voided Invoices";
		}		
		
		if ($voidUnlinkedInvoiceCheck) {
			$invoiceType .= ", Unlinked Voided Invoices";
		}

	}	


	$csvFile = array();
	array_push($csvFile,array("Folio / Invoice Report"));
	array_push($csvFile,array());
	array_push($csvFile,array("Uninvoiced / Invoiced", $invoiceType));				
	if ($fromInvoice != "" || $toInvoice != "" ) {
		array_push($csvFile,array("Invoice Range", $fromInvoice . " to " . $toInvoice));
	}	
	array_push($csvFile,array("Date Range", ( $fromDate == "All" ? "All" : $fromDate['htmlDate'] . " to " . $toDate['htmlDate'] ) ));
	array_push($csvFile,array("Status",$statusFilter['names']));
	array_push($csvFile,array("Owner Environment",$serverFilter['names']));
	array_push($csvFile,array("Debtor",$folioContactFilter['names']));
	array_push($csvFile,array("Invoice From",$businessName));

	if ($outstandingCheck) {
		array_push($csvFile,array("Balance", "Amount Outstanding"));			
	}
	
	if ($overpaidCheck) {
		array_push($csvFile,array("Balance", "Overpaid"));						
	}
	
	if ($paidCheck) {
		array_push($csvFile,array("Balance", "Fully Paid"));						
	}

	if ($partPaidCheck) {
		array_push($csvFile,array("Balance", "Part Paid"));
	}
	
	if ($unpaidCheck) {
		array_push($csvFile,array("Balance", "Unpaid"));
	}

	if ($tbaCheck) {
		array_push($csvFile,array("Balance", "TBA"));						
	}	

	if($options & REP_TRAVEL_DATE_RANGE) {
		array_push($csvFile,array("Travel date range",$fromTravelDate['htmlDate']." to " .$toTravelDate['htmlDate']));
	}	

	array_push($csvFile,array());
	if ($fsInvoiceDocNo != "") {
		array_push($csvFile,array("Res No","Reservation Name","Inv No","Fis Inv No", "Invoice To","Print","Inv Date","Status","Curr","Inv Amt","Amt Due","Inv Type"));
	}
	else {
		array_push($csvFile,array("Res No","Reservation Name","Inv No","Invoice To","Print","Inv Date","Status","Curr","Inv Amt","Amt Due","Inv Type"));
	}


  
	foreach($listArray as $key=>$item) {
		$listArray[$key]['fn_inv_date'] = chng_date( date("Y-m-d", strtotime($item['fn_inv_date'])) ,"-");
		$pr_name = "";
		$pr_name .= trim($item['pr_name_first']);
		if($pr_name != "") {
			$pr_name .= " ";
		}
		$pr_name = trim($pr_name . $item['pr_name_last']);
		$listArray[$key]['pr_name'] = $pr_name;
		$rv_payment_amt = 0;
		if (isset($item['fn_folio_ix'])) {
			$rv_payment_amt = $lDB->get("
				SELECT 
					SUM(rv_payment_item_amt) as rv_payment_amt
				FROM
					rv_payment_item
				WHERE
					fn_folio_id = '".$item['fn_folio_ix']."'
			",4);
		}
		if($rv_payment_amt == "0" || trim($rv_payment_amt) == "") {
			$rv_payment_amt = "0";
		}
		fixAmtDisplay($rv_payment_amt);
		$listArray[$key]['rv_payment_amt'] = $rv_payment_amt; 	
		if ($fsInvoiceDocNo != "") {
			array_push($csvFile,array($item['rv_reservation_ix'],$item['rv_res_name'],$item['fn_invoice_ix'],$item['fn_invoice_doc'],$item['pr_name'],$item['fn_inv_print_count'],$item['fn_inv_date'],$item['rf_reservation_status_desc'],$item['rf_currency_symbol'],$item['fn_folio_amount'],$item['rv_payment_amt'],$item['inv_type']));  
		}
		else {
			array_push($csvFile,array($item['rv_reservation_ix'],$item['rv_res_name'],$item['fn_invoice_ix'],$item['pr_name'],$item['fn_inv_print_count'],$item['fn_inv_date'],$item['rf_reservation_status_desc'],$item['rf_currency_symbol'],$item['fn_folio_amount'],$item['rv_payment_amt'],$item['inv_type']));  
		}
	}
	foreach($totals as $currencySymbol => $currencyItem) {
		array_push($csvFile,array(
			"Totals",
			"",
			"",
			"",
			"",
			"",
			"",
			$currencySymbol,
			$currencyItem['invoice_amount'],
			$currencyItem['due_amount'],
			""
		));
	}
	$csvText = "";
	foreach($csvFile as $csvLine) {
		$first = true;
		foreach($csvLine as $csvItem) {
			if(!$first) {
				$csvText .= ",";
			} else {
				$first = false;
			}
			$csvText .= "\"".str_replace("\"","\"\"",$csvItem)."\"";
		}
		$csvText .= "\n";
	}
   
	if(headers_sent()) {
		//    echo('Some data has already been output to browser, can\'t send PDF file');
	}
	header('Content-Type: text/csv');
	header("Cache-control: private");
	header('Content-Length: '.strlen($csvText));
	$filename = "folio_invoice_". ( $fromDate = "All" ? "All" : $fromDate['jsDate']."_to_".$toDate['jsDate'] ).".csv";
	header("Content-Disposition: inline; filename=".$filename);
	//header("Content-Disposition: inline; filename=contact_".date("Y-m-d").".csv");
	echo $csvText;
	flush();
	die();
}

$newRelic->stop_transaction();

function getPersonaFax($personaId) {
	$fax = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone, rf_phone_type
		WHERE
			pr_phone.pr_persona_id = '$personaId'
		AND pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
		AND rf_phone_type.rf_phone_type_sys_code = '1'", 4);
	if (trim($fax) == "" || $fax == "0") {
		$fax = "";
	}
	return $fax;
}

function getPersonaTelephone($personaId) {
	$tel = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
		WHERE
			pr_phone.pr_persona_id = '$personaId'
		AND pr_phone.pr_default_yn = '1'", 4);
	if (trim($tel) == "" || $tel == "0") {
		$tel = "";
	}
	return $tel;
}

function getPersonaDetail($personaId) {
	$detail = $GLOBALS['lDB']->get("
			SELECT
			pr_persona.pr_name_first,
			pr_persona.pr_name_second,
			pr_persona.pr_name_last,
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '".$personaId."'", 2);
	$detail = $detail[0];
	$name = "";
	if (trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
		$name .= $detail['pr_name_first'] . " ";
	}
	if (trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
		$name .= $detail['pr_name_second'] . " ";
	}
	if (trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
		$name .= $detail['pr_name_last'] . " ";
	}
	$result = array();
	$result['name'] = trim($name);
	$result['fax'] = getPersonaFax($personaId);
	$result['telephone'] = getPersonaTelephone($personaId);
	$result['email'] = $detail['pr_email'];
	if (trim($result['email']) == "" || $result['email'] == "0") {
		$result['email'] = "";
	}
	return $result;
}

session_set("repInvoiceRandomId",md5(uniqid(rand(),1)));
$GLOBALS['temp']['randomId'] = $_SESSION['repInvoiceRandomId'];
if ( isset($_POST['url']) && $_POST['url'] != "" ) {
	$urlArray = explode("+",$_POST['url']);
	$urlArray[14] = $_SESSION['repInvoiceRandomId'];
	$GLOBALS['temp']['url'] = join("+",$urlArray);
}
