<?php

/**
 * init.form3.php - The reservation status form
 * Job: 16, 17
 * Function: 52 (Reservation: Maintenance)
 */

require_once "class.template.php";

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/status_change.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],6,"");

$record = $_SERVER['argv'][1];

if ($_SERVER['argv'][2] == "1") {
	$_POST['var_status'] = "var_waitlist";
}
if ($_SERVER['argv'][2] == "2") {
	$_POST['var_status'] = "var_provisional";
	$_POST['prov_date_day'] = $_SERVER['argv'][5];
	$_POST['prov_date_month'] = $_SERVER['argv'][4];
	$_POST['prov_date_year'] = $_SERVER['argv'][3];
}

if ($_SERVER['argv'][2] == "3") {
	$_POST['var_status'] = "var_confirm";
}
$GLOBALS['temp']['resnum'] = $record;

$GLOBALS[$form]->Get($action);

$resfields = $db->get("
	SELECT
		rv_reservation_ix,
		rv_cancel_date,
		rv_confirmation_date,
		rv_invoice_date,
		rv_provision_expiry_date,
		rv_wait_list_date,
		rv_cancel_reason,
		rf_reservation_status_id,
		rv_amt_paid
	FROM
		rv_reservation
	WHERE
		rv_reservation_ix = '$record'
",1);

$deffields = $db->get("SELECT rf_prov_expiry_days FROM rf_default LIMIT 1",1);
list($GLOBALS['temp']['cancelWarn'],$GLOBALS['temp']['cancelWarnNote']) = $db->get("SELECT rf_cancel_warn_yn, rf_cancel_warn_note FROM rf_default",1);

$rv_reservation_id = $resfields['rv_reservation_ix'];
$rv_cancel_date = $resfields['rv_cancel_date'];
$rv_confirmation_date = $resfields['rv_confirmation_date'];
$rv_invoice_date = $resfields['rv_invoice_date'];
$rv_provision_expiry_date = $resfields['rv_provision_expiry_date'];
$m_provision_expiry_date = $rv_provision_expiry_date;
$rv_wait_list_date = $resfields['rv_wait_list_date'];
$rv_cancel_reason = $resfields['rv_cancel_reason'];
$rf_reservation_status_id = $resfields['rf_reservation_status_id'];
$rv_amt_paid = $resfields['rv_amt_paid'];

$GLOBALS['temp']['cancel_reason'] = $rv_cancel_reason;

$rf_prov_expiry_days = $deffields['rf_prov_expiry_days'];

$wait_list = "0";
$provisional = "0";
$confirm = "0";
$cancel = "0";

$states = array("WAITLISTED" => "0","PROVISIONAL" => "0","CONFIRMED" => "0","CANCELLED" => "0");
$active = array("var_waitlist" => "1","var_provisional" => "1","var_confirm" => "1","var_cancel" => "1");

if ($rv_cancel_date != "0000-00-00") {
	$states['CANCELLED'] = "1";
} else {
	if ($rv_confirmation_date != "0000-00-00") {
		$states['CONFIRMED'] = "1";
	}
}

$t8x = explode("-",$rv_provision_expiry_date);
$year = (integer) $t8x[0];
$month = (integer) $t8x[1];
$day = (integer) $t8x[2];
if ($year <= "2000") { $year = "2000"; }
if ($month == "00") { $month = "01"; }
if ($day == "00") { $day = "01"; }

$GLOBALS[$form]->AddField("prov_date_day","prov_date_day",$t8x[2],"3");
$GLOBALS[$form]->AddField("prov_date_month","prov_date_month",$t8x[1],"3");
$GLOBALS[$form]->AddField("prov_date_year","prov_date_year",$t8x[0],"0");

$days = range(1,31);
$output = array();
$output[0] = "0:|:";
for ($i = 0; $i < sizeof($days); $i++) {
	$day = $days[$i];
	$output[$i+1] = $day."-".($day<10?"0":"").$day;
}
$GLOBALS['prov_date_day']->Select = $output;

$months = range(1,12);
$monthOut = array();
$monthOut[0] = "0:|:";
for ($i = 0; $i < sizeof($months); $i++) {
	$month = $months[$i];
	$monthname = date('M',mktime (0,0,0,$month,1,2000));
	$monthOut[$i+1] = $month."-".$monthname;
}

$GLOBALS['prov_date_month']->Select = $monthOut;
$GLOBALS['prov_date_month']->onChange = "select_daymonth_changed();";
$GLOBALS['prov_date_year']->Length = "4";
$GLOBALS['prov_date_year']->StyleType = "txt";
$GLOBALS['prov_date_year']->onChange = "year_changed();";

$now = date("U",mktime (0,0,0,date("m"),date("d"),date("Y")));
if ($rv_provision_expiry_date >= $now) {
	$states['PROVISIONAL'] = "1";
}

if ($rv_provision_expiry_date == "0000-00-00" || $rv_provision_expiry_date == "") {
	$rv_provision_expiry_date = date("U",mktime (0,0,0,$month,$day,$year));
}


$hasOverbooking = !(check_availability($record)===true);
$allowOverbooking = db_sc_group_get_user_setting("sc_grp_res_ovr_overbooking_yn") == "1";

if(isset($_POST['action']) && $_POST['action'] == "overbooking_check") {
	if($hasOverbooking && !$allowOverbooking) {
		echo "false";
	} else {
		echo "true";
	}
	die();
}

if ($pmode == "0") { # on display
	$GLOBALS[$form]->Arguments = "17+".$record;
	# set the form start tag containing the submit action
	$GLOBALS['temp']['formstart'] = "<form name=\"".$GLOBALS[$form]->Name."\" action=\"".$GLOBALS[$form]->TargetPage."?"
		. $GLOBALS[$form]->Arguments."\" target=\"submitframe\" method=\"".$GLOBALS[$form]->Method."\" enctype=\"". $GLOBALS[$form]->Enctype."\">\n";

	$GLOBALS[$form]->Arguments = $_SERVER['argv'][0]."+".$record;
	$GLOBALS['temp']['formsubmit'] = "
			<input type=\"hidden\" name=\"record\" value=\"$record\">
			<input type=\"hidden\" name=\"inputchange\">
		</form>
	";

	$statuses = allowStatuses($record, true, true);
	$GLOBALS['temp']['c0'] = "";
	$GLOBALS['temp']['c1'] = "";
	$GLOBALS['temp']['c2'] = "";
	$GLOBALS['temp']['c3'] = "";
	$GLOBALS['temp']['c9'] = "";
	$GLOBALS['temp']['c'.$rf_reservation_status_id[0]] = " checked";

	$GLOBALS['temp']['allowDateChange'] = "true";

	$GLOBALS['temp']['dx'] = "";
	if($rf_reservation_status_id == DB_RF_RESERVATION_STATUS_CANCELLED && !empty($rv_cancel_reason)) {
		$GLOBALS['temp']['dx'] = " disable";
	}

	$size = "',WIDTH,'230";
	foreach($statuses as $id=>$status) {
		$id = (string)$id;
		$GLOBALS['temp']['d' . $id[0]] = ($status['allow']?"":" disabled");

		if(array_key_exists("allow_date",$status) && !$status['allow_date']) {
			$GLOBALS['temp']['allowDateChange'] = "false";
		}

		$reason = join(", ", $status['reasons']);
		if(!empty($reason)) {
			switch($id) {
			case DB_RF_RESERVATION_STATUS_QUOTATION:
				$reasonTag = "quot";
				break;
			case DB_RF_RESERVATION_STATUS_WAITLIST:
				$reasonTag = "wait";
				break;
			case DB_RF_RESERVATION_STATUS_PROVISIONAL:
				$reasonTag = "prov";
				break;
			case DB_RF_RESERVATION_STATUS_CONFIRMED:
				$reasonTag = "conf";
				break;
			case DB_RF_RESERVATION_STATUS_CANCELLED:
				$reasonTag = "canc";
				break;
			}
			$GLOBALS['tagList'][$reasonTag.'Tag'] = setOverlib($reason.$size);
		}
	}

	if ($rf_reservation_status_id != "20") {
		$autoexpire = explode("-",date("Y-m-d",mktime (0,0,0,date("m"),date("d")+$rf_prov_expiry_days,date("Y"))));
		$nday = $autoexpire[2];
		$nmonth = $autoexpire[1];
		$nyear = $autoexpire[0];
		$GLOBALS['prov_date_day']->Value = $nday;
		$GLOBALS['prov_date_month']->Value = $nmonth;
		$GLOBALS['prov_date_year']->Value = $nyear;
	}
} else { # on save
	$rv_provision_expiry_date = false;
	$rv_cancel_reason = false;

	switch ($_POST['var_status']) {
	case "var_quotation" :
		$rf_reservation_status_id = DB_RF_RESERVATION_STATUS_QUOTATION;
		break;
	case "var_waitlist" :
		$rf_reservation_status_id = DB_RF_RESERVATION_STATUS_WAITLIST;
		break;
	case "var_provisional" :
		$rf_reservation_status_id = DB_RF_RESERVATION_STATUS_PROVISIONAL;
		if(trim($_POST['prov_date_year']) != "" && trim($_POST['prov_date_month']) != "" && trim($_POST['prov_date_day']) != "") {
			$rv_provision_expiry_date = "$_POST[prov_date_year]-$_POST[prov_date_month]-$_POST[prov_date_day]";
		}
		break;
	case "var_confirm" :
		$rf_reservation_status_id = DB_RF_RESERVATION_STATUS_CONFIRMED;
		break;
	case "var_cancel" :
		$rv_cancel_reason = trim($_POST['cancel_reason']);
		$rf_reservation_status_id = DB_RF_RESERVATION_STATUS_CANCELLED;
		break;
	}

	$free_stock = false;
	$current_status = db_rv_reservation_get_status($record);

	if (
		($current_status['rf_reservation_status_id'] == 30 || $current_status['rf_reservation_status_id'] == 20)
		&& ($rf_reservation_status_id == 90 || $rf_reservation_status_id == 10 || $rf_reservation_status_id == 0)
	) {
		// Stock freed up
		$free_stock = true;
	}

	$changeStatus = ($hasOverbooking && !$allowOverbooking) ? false : true;
	$changeStatus = ($free_stock) ? true : $changeStatus;

	$result = db_rv_reservation_set_status($record,$rf_reservation_status_id,$rv_provision_expiry_date,$rv_cancel_reason, true);
	$overbookingError = !$result ? true : false;

	if (!$overbookingError) {
		if ($GLOBALS['userStatusId'] == 1) {
			// Flag modifications made by external users
			$reservationAuditTrail = new AuditTrail($record,TYPE_RESERVATION);
			$reservationAuditTrail->flagReservationModification();
		}
	}

	echo "<body class=\"popupBody\" onload=\""."javascript:parent.opener.location='reservation.php?2+$record".($free_stock?"+waitlist":"").($overbookingError?"+overbookingError":"")."'; parent.window.close();"."\">\nClosing...\n";
}

# The updated reservation.php for no frames automatically echo a lot of junk,
# so we kill the process before it gets there.
if ((isset($_POST['hafsubmit']) && $_POST['hafsubmit'] == 1) || $_SERVER['argv'][2] != "") {
	die();
}

// Area for changing the provisional date colours
if ($rf_reservation_status_id == "20") {
	$today = date("Y-m-d"); // 2003-04-24
	$GLOBALS['temp']['provColor'] = "";
	if ($today == $m_provision_expiry_date) {
		$GLOBALS['temp']['provColor'] = "#F1C55D";
	} elseif($today > $m_provision_expiry_date) {
		$GLOBALS['temp']['provColor'] = "#DB4242";
	} else {
		$GLOBALS['temp']['provColor'] = "";
	}
}
if ($rf_reservation_status_id != "20") {
	$GLOBALS['temp']['provColor'] = "";
}
