<?php

/**
 * init.form300.php - PAX Count Popup
 * Job: 736 - PAX Count Popup 
 * Function: 95 (Reports: PAX Analysis, PAX Count (today))
 */

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/calendar_pax_count.htm");
}

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode(
		"+",
		substr(
			$_POST['url'],
			strpos($_POST['url'], "reservation.php?") + 16
		)
	);
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
	$renderMode = "csv";
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],3,"");

$startDate = $_SERVER['argv'][1];

if ( $startDate == "0" || $startDate == "" ) {
	$startDate = date("Y-m-d");
}

$GLOBALS['temp']['startDate'] = $startDate;
$GLOBALS['temp']['headDate'] = chng_date($startDate,"-");
$startDateArray = explode("-",$startDate);
$GLOBALS['temp']['headD'] = date("l",mktime(0,0,0,$startDateArray[1],$startDateArray[2],$startDateArray[0]));

$showAllocations = $_SERVER['argv'][2];

$GLOBALS['temp']['showAllocationsChecked'] = "checked";
if($showAllocations == "2") {
	$GLOBALS['temp']['showAllocationsChecked'] = "";
}

$dateStamp = strtotime($startDate);

$dateArray = array();

// Array to store all table rows for later use in the CSV generation
$data = array();

$dateArray[0] = date("Y-m-d",$dateStamp);
$dateArray[1] = date("Y-m-d",$dateStamp + 86400);
$dateArray[2] = date("Y-m-d",$dateStamp + 86400 + 86400);
$dateArray[3] = date("Y-m-d",$dateStamp + 86400 + 86400 + 86400);
$dateArray[4] = date("Y-m-d",$dateStamp + 86400 + 86400 + 86400 + 86400);

// debug($dateArray[0],$dateArray[1],$dateArray[2]);
$date1Fmt = chng_date($dateArray[0],"-");
$date2Fmt = chng_date($dateArray[1],"-");
$date3Fmt = chng_date($dateArray[2],"-");
$date4Fmt = chng_date($dateArray[3],"-");
$date5Fmt = chng_date($dateArray[4],"-");

$GLOBALS['temp']['date1'] = $date1Fmt;
$GLOBALS['temp']['date2'] = $date2Fmt;
$GLOBALS['temp']['date3'] = $date3Fmt;
$GLOBALS['temp']['date4'] = $date4Fmt;
$GLOBALS['temp']['date5'] = $date5Fmt;

// Make sure that the date entered does not exceed the date set in the rf_default table
$dateLimitError = false;
$dateLimit = $GLOBALS['lDB']->get("SELECT rf_default.rf_date_res_limit FROM rf_default",4);

foreach ( $dateArray as $d ) {
	if ( $d > $dateLimit ) {
		$dateLimitError = true;
	}
}

if ( $dateLimitError ) {
	$GLOBALS['temp']['rows'] = "<tr><td colspan=\"16\" style=\"padding: 5px 0;\" class=\"colRed txtb txtWh\" align=\"center\">Some or all of the selected dates fall outside the latest allowable date</td></tr>";
} else {
	$propertyRow = "
		<tr>
	  		<td class=\"colLtt bb\">!propertyName!</td>
	    	<td align=\"center\" class=\"bl bb\">!adult1!</td>
	    	<td align=\"center\" class=\"bl bb\">!child1!</td>
	    	<td align=\"center\" class=\"bl bb colGryLt\">!total1!</td>
	    	<td align=\"center\" class=\"bl bb\">!adult2!</td>
	    	<td align=\"center\" class=\"bl bb\">!child2!</td>
		    <td align=\"center\" class=\"bl bb colGryLt\">!total2!</td>
		    <td align=\"center\" class=\"bl bb\">!adult3!</td>
		    <td align=\"center\" class=\"bl bb\">!child3!</td>
		    <td align=\"center\" class=\"bl bb colGryLt\">!total3!</td>
		    <td align=\"center\" class=\"bl bb\">!adult4!</td>
		    <td align=\"center\" class=\"bl bb\">!child4!</td>
		    <td align=\"center\" class=\"bl bb colGryLt\">!total4!</td>
		    <td align=\"center\" class=\"bl bb\">!adult5!</td>
		    <td align=\"center\" class=\"bl bb\">!child5!</td>
			<td align=\"center\" class=\"bl bb colGryLt\">!total5!</td>        
			<td class=\"bl bb\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
		</tr>
	";
	// Start process for default access controlled, correctly sequenced proplist
	/* This was not limiting the properties according to access control $calPropList returns the correct properties
	$sql = "select pr_business_id from pr_business where pr_bus_inactive_yn = '0' order by pr_business_parent asc limit 1";
	$propMaster = $GLOBALS['lDB']->get($sql,4);
	calAcRecurse($propMaster);
	global $calAcRecurseResult;*/
	
	//$calPropList = $_SESSION['calPropList'];
	
	$rows = "";
	
	$calPropList = !empty($_SESSION['calPropList']) ? $_SESSION['calPropList'] : getDefaultProperties();
	
	$defaultStartDate = date("Y-m-d");
	$defaultStartDateTime = date("Y-m-d H:i:s");
	
	$propertyACL = $GLOBALS['lDB']->get("
		SELECT
			DISTINCT ac_accomm_type.pr_business_id
		FROM
			sc_accomm
		INNER JOIN sc_user ON 
			sc_accomm.sc_group_id = sc_user.sc_group_id
		AND 
			sc_user.pr_user_id = '" . $GLOBALS['userid'] . "'
		INNER JOIN ac_accomm_type ON
			ac_accomm_type.ac_accomm_type_ix = sc_accomm.ac_accomm_type_id
	",3);
	
	$accommList = $GLOBALS['lDB']->get("
		SELECT
			sc_accomm.ac_accomm_type_id
		FROM
	    	sc_accomm
		INNER JOIN sc_user ON
	    	sc_accomm.sc_group_id = sc_user.sc_group_id
		AND
	 		sc_user.pr_user_id = '" . $GLOBALS['userid'] . "'
	",3);

	foreach ( $calPropList as $item ) {
		$outArr = array();
		$outArr['propertyName'] = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '" . $item . "'",4);
		$count = 1;
		foreach($dateArray as $date) {
			$allocationSQL = "";
			if($showAllocations == "1") {
				$today = date("Y-m-d");
				$allocationSQL = "
						OR (
							rv_reservation.rf_reservation_status_id = '15'
							AND (
								(
									rv_reservation_item.rv_alloc_expiry_date = '0000-00-00'
									AND (
										rv_reservation.rv_alloc_expiry_date <> '0000-00-00'
										AND rv_reservation.rv_alloc_expiry_date >= '$today'
									) OR (
										rv_reservation.rv_alloc_expiry_date = '0000-00-00'
										AND rv_reservation.rv_alloc_expiry_days <= ".dateSubtract($date, $today)."
									)
								) OR (
									rv_reservation_item.rv_alloc_expiry_date <> '0000-00-00'
									AND rv_reservation_item.rv_alloc_expiry_date >= '$today'
								)
							)
						)
				";	
			}
			$pax = array_merge($outArr,$GLOBALS['lDB']->get("
				SELECT
					SUM(rv_item_adult_count*rv_item_accomm_count) AS adult,
					SUM(rv_item_child_count*rv_item_accomm_count) AS child,
					SUM((rv_item_adult_count + rv_item_child_count) *rv_item_accomm_count ) AS total
				FROM
					rv_reservation_item
					INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
				WHERE
					rv_reservation_item.pr_business_id = '" . $item . "'
					AND (
						(
							rv_reservation.rf_reservation_status_id = '30'
					    ) OR (
							rv_reservation.rf_reservation_status_id = '20'
							AND rv_reservation.rv_provision_expiry_date >= '" . $defaultStartDate . "'
						) OR (
							rv_reservation.rf_reservation_status_id = '25'
							AND rv_reservation.rv_create_expiry_date >= '" . $defaultStartDateTime . "' 
						) $allocationSQL										
					)
					AND rv_reservation_item.rv_item_date_arrive <= '$date'
					AND	rv_reservation_item.rv_item_date_depart > '$date'
					AND rv_reservation_item.ac_accomm_type_id IN ('" . join("','",$accommList) . "')
			",1));
			if ( $pax['adult'] == "" ) $pax['adult'] = "0";
			if ( $pax['child'] == "" ) $pax['child'] = "0";
			if ( $pax['total'] == "" ) $pax['total'] = "0";
			$outArr["adult$count"] = $pax['adult'];
			$outArr["child$count"] = $pax['child'];
			$outArr["total$count"] = $pax['total'];
			$count++;
		}
		array_push($data,$outArr);			
		$rows .= showpage($outArr,$propertyRow);
	}	
	$GLOBALS['temp']['rows'] = $rows;
}

if(isset($renderMode) && $renderMode == "csv") {
	$csvFile = array();		
	array_push($csvFile,array("Pax Count (Today)"));
	array_push($csvFile,array("Include Allocations", $showAllocations == "1" ? "Yes" : "No"));
	array_push($csvFile,array());
	array_push($csvFile,array("", $date1Fmt, "", "", $date2Fmt, "", "", $date3Fmt, "", "", $date4Fmt, "", "", $date5Fmt)); // Adds date headers with empty spacers for CSV layout.

	array_push($csvFile,array("", "Adlts", "Chld", "Total", "Adlts", "Chld", "Total", "Adlts", "Chld", "Total", "Adlts", "Chld", "Total", "Adlts", "Chld", "Total"));   

	foreach($data as $item) {
		array_push($csvFile, array(
			$item['propertyName'],
			$item['adult1'], $item['child1'], $item['total1'],
			$item['adult2'], $item['child2'], $item['total2'],
			$item['adult3'], $item['child3'], $item['total3'],
			$item['adult4'], $item['child4'], $item['total4'],
			$item['adult5'], $item['child5'], $item['total5'],
		));
	}
	csv_output("pax_count_" . chng_date(date("Y-m-d"), "-"), $csvFile); // Creates and outputs a CSV file named "pax_count_" with today's date, replacing dashes with underscores.
}