<?php

/**
 * init.form3000.php - Error reporting popup (Job 3000)
 */

// Form setup
if(!isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/error_handling_page.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],2,"");
$error_fatal 	= $_SERVER['argv'][1];

if ($error_fatal == 1) { // Display fatal error screen
	$errorHandlingHomepageJobId = "";
	$defaultHomepages = db_pf_option_get_defaults(db_pf_object_by_name("user_preferences"));
	if(sizeof($defaultHomepages) > 0) {
		db_pf_field_load_by_name($defaultHomepages[0],'sc_job_id',$errorHandlingHomepageJobId);
	}
	if(empty($errorHandlingHomepageJobId)) {
		$errorHandlingHomepageJobId = "693";
	}

	$GLOBALS['temp']['errorHandlingHomepageJobId'] = $errorHandlingHomepageJobId;

	$errors = json_decode($_POST['errors'],true);
	$GLOBALS['temp']['errorHandlingCommonHTML'] = errorHandlerCommon($errors);

} else { // Send error email
	$from = $lDB->get("SELECT pr_persona.pr_email FROM pr_persona WHERE pr_persona.pr_persona_ix = '".$GLOBALS['userid']."'",4);
	if(empty($from)) {
		$from = "noreply@resrequest.com";
	}
	$to = "support@resrequest.com";
	$subject = "Error message";
	$body = $_POST['errorHandlingContent'];
	$principal = isset($GLOBALS['princName']) ? $GLOBALS['princName'] : "Resrequest User";
	$headers = "From: ".$principal."<".$from.">\r\n";

	$attachmentFilename = "";
	$attachmentString = "";
	if(array_key_exists("errorHandlingJSON",$_POST) && !empty($_POST['errorHandlingJSON'])) {
		$errors = json_decode($_POST['errorHandlingJSON'],true);
		$attachmentFilename = $GLOBALS['principal_id'].
			"_".date("Y-m-d_H-i-s").
			"_".$GLOBALS['dbcode'].
			"_".$GLOBALS['userid'].
			"_error_log.csv";
		$attachmentArray = array(array_keys($errors[0]));
		foreach($errors as $error) {
			$row = array();
			foreach($error as $item) {
				if(!is_array($item)) {
					$row[] = $item;
				} else {
					$row[] = join("\n",$item);
				}
			}
			$attachmentArray[] = $row;
		}
		$attachmentString = csv_array_to_text($attachmentArray,false);
	}	

	$error = email($from, $to, $subject, $headers, $body, 0, 0, "", $principal,$attachmentString,$attachmentFilename, false, false, 500);
	if($error) {
		echo "1";
		die();
	}

	die();
}
