<?php

/**
 * init.form3001.func.php - Auto mailer (Job 3001)
 */

require_once(__DIR__ . "/functions.transfer.common.php");
require_once(__DIR__ . "/functions.csv.php");

function getCredField($zm_account_id, $zm_credential_field_id) {
	global $lDB;

	if (empty($zm_account_id) || empty($zm_credential_field_id)) {
		return;
	}

	$field = $lDB->get("
		SELECT
			zm_account_credentials.zm_account_cred_value
		FROM
			zm_account_credentials
			LEFT JOIN zm_account ON zm_account.zm_account_ix = zm_account_credentials.zm_account_id
			LEFT JOIN zm_account_type ON zm_account_type.zm_account_type_ix = zm_account.zm_account_type_id
			LEFT JOIN zm_credential_field ON zm_credential_field.zm_credential_field_ix = zm_account_credentials.zm_credential_field_id
		WHERE
			zm_account.zm_account_ix = '".$zm_account_id."'
			AND zm_account_credentials.zm_credential_field_id = '".$zm_credential_field_id."'
	",4);

	return $field;
}

function getCredField($zm_account_id, $zm_credential_field_id) {
	global $lDB;

	if (empty($zm_account_id) || empty($zm_credential_field_id)) {
		return;
	}

	$field = $lDB->get("
		SELECT
			zm_account_credentials.zm_account_cred_value
		FROM
			zm_account_credentials
			LEFT JOIN zm_account ON zm_account.zm_account_ix = zm_account_credentials.zm_account_id
			LEFT JOIN zm_account_type ON zm_account_type.zm_account_type_ix = zm_account.zm_account_type_id
			LEFT JOIN zm_credential_field ON zm_credential_field.zm_credential_field_ix = zm_account_credentials.zm_credential_field_id
		WHERE
			zm_account.zm_account_ix = '".$zm_account_id."'
			AND zm_account_credentials.zm_credential_field_id = '".$zm_credential_field_id."'
	",4);

	return $field;
}

function uploadToRocketmailerFTP($output) {
	global $lDB;
	global $principal_id;
	global $dbcode;
	global $userid;

	$ftp_server 	= getCredField("WB1", "WB3");
	$ftp_user_name 	= getCredField("WB1", "WB1");
	$ftp_user_pass 	= getCredField("WB1", "WB2");

	$rocketmailerFilenameFTP = "resrequest_londolozi_guest_followup.csv";

	$rocketmailerFilename = $GLOBALS['rocketmailerFilename'].".csv";
	rocketmailerLogFile("Initiating FTP process with ResRequest filename ".$rocketmailerFilename);

	$csvFile = @fopen(__DIR__ . "/" . $rocketmailerFilename,"w+");
	
	if (@fwrite($csvFile,$output) === FALSE) {
		rocketmailerLogFile("Error writing to CSV file");
		$message = "\n40|Error writing to CSV file";
	} else {
		rocketmailerLogFile("Created CSV file");
		@rewind($csvFile);

		$conn_id = @ftp_connect($ftp_server);
		if ($conn_id) {
			rocketmailerLogFile("Connected to FTP server");
			if (@ftp_login($conn_id, $ftp_user_name, $ftp_user_pass)) {
				rocketmailerLogFile("Logged in to FTP server");
				ftp_pasv($conn_id, true);

				if (ftp_fput($conn_id, $rocketmailerFilenameFTP, $csvFile, FTP_ASCII)) {
					rocketmailerLogFile("Uploaded CSV file to FTP server");
					$message = "\n0|Sucessfully uploaded file";
					@fclose($csvFile);
					if (!renameFile($rocketmailerFilename,$GLOBALS['rocketmailerFilename']."_uploaded.csv")) {
						$message = "\n40|Error renaming CSV file";
					} else {
						rocketmailerLogFile("Renamed CSV file");
					}
				} else {
					@fclose($csvFile);
					rocketmailerLogFile("Error uploading CSV file to FTP server");
					$message = "\n30|FTP not uploaded";
				}
			} else {
				rocketmailerLogFile("Error logging in to FTP server, FTP username and/or password incorrect");
				$message = "\n30|FTP username and/or password incorrect";
			}
			ftp_close($conn_id);
		} else {
			rocketmailerLogFile("Error connecting to FTP server, FTP server name is invalid or connection error");
			$message = "\n30|FTP server name is invalid or connection error";
		}
	}

	return $message;
}

function renameFile($oldfile,$newfile) {
	if (!rename($oldfile,$newfile)) {
		if (copy ($oldfile,$newfile)) {
			unlink($oldfile);
			return TRUE;
		}
		return FALSE;
	}
	return TRUE;
}

function getGuests($interval_start, $interval_end) {
	global $lDB;

	$guests = $lDB->get("
		SELECT DISTINCT
			rv_reservation_item.rv_item_date_depart,
			pr_persona.pr_name_first, 
			pr_persona.pr_name_last,
			pr_persona.pr_email,
			pr_persona.pr_persona_ix
		FROM
			rv_res_item_guest
			INNER JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_res_item_guest.rv_res_item_group_id
			LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			LEFT JOIN pr_guest ON pr_guest.pr_guest_id = rv_res_item_guest.pr_guest_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = pr_guest.pr_guest_id
		WHERE
			pr_guest.pr_guest_primary_yn = '1'
			AND pr_guest.pr_guest_inactive_yn = '0'
			AND rv_reservation_item.rv_item_date_depart BETWEEN CURDATE()-INTERVAL ".$interval_end." DAY AND CURDATE()-INTERVAL ".$interval_start." DAY
		ORDER BY
			rv_reservation_item.rv_item_date_depart ASC
	",2);
	return $guests;
}

function rocketmailerLogFile($data) {
	$rocketmailerFilename = $GLOBALS['rocketmailerFilename'].".log";
	$newline = is_file($rocketmailerFilename) ? "\n" : "";
	$logFile = @fopen(__DIR__ . "/" . $rocketmailerFilename,"a+");
	@fwrite($logFile,$newline.$data);
	@fclose($logFile);
}

function generateRocketmailerFilename() {
	global $principal_id;
	global $dbcode;
	global $userid;

	// The second parameter is a placeholder for the transfer ID, which might be implemented in future
	$logFileName = $principal_id."_1_".str_replace(" ","_",str_replace(":","-",date("Y-m-d H:i:s")))."_".$dbcode."_".$userid;
	$logStash = getTransferDirDT37($logFileName,TRANSFER_DIR_ROCKETMAILER);
	$GLOBALS['rocketmailerFilename'] = $logStash.$logFileName;
}