<?php

/**
 * init.form3001.php - Auto mailer (Job 3001)
 */

// Form setup
if(!isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"","");
}

generateRocketmailerFilename();

rocketmailerLogFile("Starting Rocketmailer guest export process...");

$guests = getGuests('14', '21');

if (is_array($guests) && !empty($guests)) {
	rocketmailerLogFile("Guest list with ".count($guests)." names extracted from database");
	$guest_list = array();
	foreach ($guests as $guest) {
		// Check for single occurance of '*'
		// As per discussions with Belinda, Londolozi uses *'s to indicate duplicate guests, so only guests with a single * should be used
		if ($pos = strpos($guest['pr_name_last'], '*') == strrpos($guest['pr_name_last'], '*') ) {
			$pr_name_first = str_replace('"', '', $guest['pr_name_first']);
			$pr_name_last = str_replace('"', '', $guest['pr_name_last']);
			$pr_name_last = str_replace('*', '', $guest['pr_name_last']);
			if (trim($guest['pr_email']) != '' && strpos($guest['pr_email'], '@') !== false) {
				$guest_list[] = array(
						trim($pr_name_first),
						trim($pr_name_last),
						trim($guest['pr_email']),
						$guest['rv_item_date_depart'],
						$guest['pr_persona_ix']);
			}
		}
	}

	if (!empty($guest_list)) {
		rocketmailerLogFile("Sending filtered guest list with ".count($guest_list)." names for CSV population");
		$output = csv_array_to_text($guest_list);
		$result = uploadToRocketmailerFTP($output);
	} else {
		rocketmailerLogFile("No names on filtered guest list");
		$result = "\n0|No filtered guest results";
	}
} else if (is_array($guests) && empty($guests)) {
	rocketmailerLogFile("No names on guest list extracted from database");
	$result = "\n0|No guest results";
} else if (!is_array($guests)) {
	rocketmailerLogFile("SQL error while extracting guest names from database");
	$result = "\n40|Database error";
}

rocketmailerLogFile("Finishing with code: ".$result);
echo $result;
die;