<?php

 /**
  * init.form3002.func.php - Profiles
  * Job: 3002
  */

require_once(__DIR__ . '/functions.profile.php');
require_once(__DIR__ . '/db.pf_option.php');

function displayReportProfiles() {
	$excludedReport = [
		'email_document',
		'email_proforma',
		'email_invoice',
		'user_preferences',
		'email_templates'
	];

	

	$intUser = $GLOBALS['lDB']->get("
		SELECT
			COUNT(pr_link.rf_link_type_id)
		FROM
			pr_link
		WHERE
			pr_link.pr_link_from = '".$GLOBALS['userid']."'
			AND pr_link.rf_link_type_id = 'RS1' 
	",4);

	$profiles = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			pf_option.pf_option_ix,
			pf_option.pf_object_id,
			pf_option.pf_option_name,
			pf_option.pf_option_note,
			pf_option.pf_level_link_id,
			pf_option.pf_option_favourite_yn,
			pf_object.pf_object_name,
			pf_object.pf_object_note,
			pf_object.sc_job_id,
			pf_option.pf_level_ind
		FROM
			pf_option
			INNER JOIN pf_object ON pf_object.pf_object_ix = pf_option.pf_object_id
		WHERE
			(pf_option.pf_level_link_id = '".$GLOBALS['userid']."'
			OR pf_option.pf_level_link_id = '')
			AND pf_object.pf_object_name NOT IN ( '" . implode($excludedReport, "', '") . "' )
		ORDER BY
			pf_object.pf_object_note ASC,
			pf_option.pf_option_name ASC
	",2);

	$profileData = array();
	$currentReport = '';

	if (!empty($profiles)) {

		$userReports = array();
		$reportBreakdowns = [];

		foreach ($profiles as $key => $profile){
			if (!isset($userReports[$profile['pf_object_note']])) {
				$userReports[$profile['pf_object_note']] = 0;
			}
			if ($profile['pf_level_link_id'] != '') {
				$userReports[$profile['pf_object_note']]++;
			}

			if (!isset($reportBreakdowns[$profile['pf_object_note']])) {
				$reportBreakdowns[$profile['pf_object_note']] = [
					'hasGlobal' => false,
					'hasUser' => false,
					'hasTemplate' => false
				];
			}

			switch ($profile['pf_level_ind']) {
				case DB_PF_LEVEL_USER:
					$reportBreakdowns[$profile['pf_object_note']]['hasUser'] = true;
					break;
				case DB_PF_LEVEL_TEMPLATE:
					$reportBreakdowns[$profile['pf_object_note']]['hasTemplate'] = true;
					break;
				default:
					$reportBreakdowns[$profile['pf_object_note']]['hasGlobal'] = true;
					break;
			}

			// Filter out non-access profiles
			$jobAllow = checkJob($profile['sc_job_id']);
			if (!$jobAllow) {
				unset($profiles[$key]);
			}

			// External user: show only allowed user-level profiles (remove global)
			if (!$intUser && $profile['pf_level_link_id'] == '') {
				unset($profiles[$key]);
			}
		}

		foreach ($profiles as $profile){

			$fields = $GLOBALS['lDB']->get("
				SELECT
					pf_field.pf_field_contents
				FROM
					pf_field
				WHERE
					pf_field.pf_option_id = '".$profile['pf_option_ix']."'
				ORDER BY
					pf_field.pf_field_ix DESC
			",3);

			

			if ($currentReport != $profile['pf_object_note']) {
				$currentReport = $profile['pf_object_note'];

				$breakDownClass = '';
				if ($reportBreakdowns[$currentReport]['hasUser']) {
					$breakDownClass .= ' hasUserProfile';
				}
				if ($reportBreakdowns[$currentReport]['hasTemplate']) {
					$breakDownClass .= ' hasTemplateProfile';
				}
				if ($reportBreakdowns[$currentReport]['hasGlobal']) {
					$breakDownClass .= ' hasGlobalProfile';
				}

				$profileData[] = '
				<div class="reportHeader button '.$breakDownClass.'" style="text-align:left; font-weight:bold; background-color:#cacaca; cursor: pointer; cursor: hand; padding-left:5px; padding-top:5px; height:15px; margin-top:10px;" onclick="expandReports(\''.$profile['pf_object_name'].'\')"  onmouseover="this.style.backgroundColor = \'#ddd\';"  onmouseout="this.style.backgroundColor = \'#cacaca\';">
					'.$currentReport.'
				</div>';
			}

			$profileClass = "global";
			$profileType = "Global";

			if ($profile['pf_level_ind'] == DB_PF_LEVEL_USER) {
				$profileClass = "user";
				$profileType = "User";
			} else if ($profile['pf_level_ind'] == DB_PF_LEVEL_TEMPLATE) {
				$profileClass = "template";
				$profileType = "Template";
			}

			$profileData[] = '
			<div class="reportContainer pf_option '.$profile['pf_object_name'].'" style="display:none;">
				<div class="profileContainer '.$profileClass.'" style="cursor: pointer; cursor: hand; padding-left:5px; padding-right:5px; padding-top:5px; height:15px;" onclick="loadReportProfileAjax(\''.$profile['pf_option_ix'].'\');" onmouseover="this.style.backgroundColor = \'#cfc\';"  onmouseout="this.style.backgroundColor = \'\';">
					<span title="'.($profile['pf_option_note'] == '' ? '' : $profile['pf_option_note']).'">
								<span class="profileName">'.$profile['pf_option_name'].'</span> <span style="float:right;">'.$profileType.'</span>
					</span>
				</div>
			</div>';
		}
	}

	$GLOBALS['temp']['profile_rows'] = join($profileData,"");
}

function loadReportProfileAjax($pf_option_id) {
	$pf_object = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			pf_object.pf_object_ix,
			pf_object.sc_job_id
		FROM
			pf_object
			INNER JOIN pf_option ON pf_option.pf_object_id = pf_object.pf_object_ix
		WHERE
			pf_option.pf_option_ix = '".$pf_option_id."'
	",2);
	$pf_object_id = $pf_object[0]['pf_object_ix'];
	$sc_job_id = $pf_object[0]['sc_job_id'];

	$sc_job_id_cords = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			sc_job.sc_job_cords
		FROM
			sc_job
		WHERE
			sc_job.sc_job_id = '".$sc_job_id."'
	",4);

	$fileBits = explode(":", $sc_job_id_cords);
	$file = $fileBits[1];
	include(__DIR__ ."/init.form".$file.".func.php");

	echo $sc_job_id.",".$pf_option_id;
	exit;
}