<?php

 /**
  * init.form3003.func.php - Quick Menu Search
  * Job: 3003
  */

require_once('functions.profile.php');
require_once('db.ad_user_log.php');

function useFilter($prefix,$itemList,$selectName,$whereName, $includeList, $emptyLabel=false, $emptyWhere=false, $emptyNull=false) {
	global $lDB;
	global $temp;

	$itemArray = explode(":",$itemList);

	$emptyEnabled = true;
	if($emptyLabel === false || $emptyWhere === false) {
		$emptyEnabled = false;
	}

	$matchInclude = false;
	if($includeList !== false) {
		$itemArray = array_intersect($itemArray,$includeList);
		sort($includeList);
		sort($itemArray);

		if($itemArray === $includeList) {
			$matchInclude = true;
		}
	}

	if(trim($itemList) == "" || sizeof($itemArray) == 0 || $matchInclude) {
		$where = "";
		$ids = "";
		if($includeList !== false) {
			$ids = join(":",$includeList);
			if(!$emptyEnabled || !in_array($emptyWhere,$includeList)) {
				$where = " AND " . $whereName . " IN ('".join("','",$includeList)."') ";
			} else {
				array_push($includeList,"");
				array_push($includeList,$emptyWhere);
				if(!$emptyNull) {
					$where = " AND " . $whereName . " IN ('".join("','",$includeList)."') ";
				} else {
					$where = "
						AND (
							" . $whereName . " IN ('".join("','",$includeList)."')
							OR $whereName IS NULL
						)
					";
					$ids .= ":NULL";
				}
			}
		}
		$temp[$prefix . "Ids"] = '<input type="hidden" id="'.$prefix.'Ids" name="'.$prefix.'Ids" value="'.$ids.'">';
		$temp[$prefix . "Names"] = "All";
		return array('ids'=>$ids, 'names'=>"All", 'where'=>$where, 'all'=>true);
	}

	if(!in_array($emptyWhere,$itemArray,true)) {
		$emptyEnabled = false;
	}

	$nameList = "";
	$addNull = false;
	if($emptyEnabled) {
		if( (!($includeList === false) && in_array($emptyWhere,$includeList)) || ($includeList === false) ) {
			array_push($itemArray,"");
			array_push($itemArray,$emptyWhere);
			$nameList .= $emptyLabel;
			if($emptyNull) {
				$addNull = true;
			}
		}
	}

	if(!$addNull) {
		$whereList = " AND " . $whereName . " IN ('".join("','",$itemArray)."') ";
	} else {
		$whereList = "
			AND (
				$whereName IN ('".join("','",$itemArray)."')
				OR $whereName IS NULL
			)";
	}
	foreach($itemArray as $item) {
		if($item !== $emptyWhere && $item != "") {
			$nameArray = $lDB->get($selectName . "'" . $item . "'",1);

			$name = "";
			if (is_array($nameArray)) {
				foreach($nameArray as $nameKey=>$nameItem) {
					if(!is_numeric($nameKey)) {
						$name .= $nameItem . " ";
					}
				}

				$name = trim($name);
				if($nameList != "") {
					$nameList .= ", ";
				}
				$nameList .= $name;
			}
		}
	}

	if(strlen($nameList) > 600) {
		$nameList = substr($nameList,0,600) . "... &#10;[Total records: ".(sizeof($itemArray))."]";
	}
	$temp[$prefix . "Ids"] = '<input type="hidden" id="'.$prefix.'Ids" name="'.$prefix.'Ids" value="'.$itemList.'">';
	$temp[$prefix . "Names"] = $nameList;
	return array('ids'=>$itemList, 'names'=>$nameList, 'where'=>$whereList, 'all'=>false);
}


function getMenuItems() {
	global $lDB;
	global $userStatusId;
	global $calAgentId;

	// Menu items
	$menu_system = generateMenu();

	$quickMenuOptions = $menuItemsNameArray = $menuItemsLinkArray = array();
	$menuQuickMenu = explode(";", $menu_system);
    $query = str_replace("'", "''", $_POST['query']);

	foreach ($menuQuickMenu as $entry) {
		$item = substr($entry, strpos($entry, "Array(")+6 );
		$menuItemsNameArray = explode('","', $item);
		if (isset($menuItemsNameArray[1])) { $menuItemsLinkArray = explode(',', $menuItemsNameArray[1]); }
		$name = isset($menuItemsNameArray[0]) ? str_replace('"', '', $menuItemsNameArray[0]) : '';
		$link = isset($menuItemsLinkArray[0]) ? str_replace('"', '', $menuItemsLinkArray[0]) : '';
		
		if (!empty($name) && !empty($link) && substr($link,0,11) != 'menuProfile') {
			$pass = true;

            $nameReplacements = array(  // Link as it appears in menu => new name for this entry
                "gotoLink('reservation.php?565')" => "Extras Code Table",           // Extras
                "gotoLink('reservation.php?200')" => "Extras Report",               // Extras
                "gotoLink('reservation.php?715')" => "Business Structure Report",   // Business Structure
				"gotoLink('reservation.php?257')" => "Telephone Report",            // Telephone
                "gotoLink('reservation.php?234')" => "Rooming Calendar Classic",    // Classic
                "gotoLink('reservation.php?1024')" => "Rooming Calendar Modern",    // Modern
            );

            if (isset($nameReplacements[$link])) {
                $name = $nameReplacements[$link];
            }

			foreach ($quickMenuOptions as $quickMenuOption) {
				if ($quickMenuOption['value'] == $name && $quickMenuOption['data']['link'] == $link) {
					$pass = false;
				}
			}

			if ( strpos( strtolower($name), strtolower($query) ) === false) {
				$pass = false;
			}

			if ($pass) {
				$quickMenuOptions[] = [
					"value" => $name,
					"data" => [
						"link" => $link,
						"category" => "Pages"
						]
					];
			}
		}
	}

	// Reservations
	$acReservations = checkJob(0);
	if ($acReservations) { // If no reservation view access, bypass reservation lookup

		$agentACL = "";
		if($userStatusId < 2) {
			$agentACL = " AND rv_reservation.rv_agent_id = '$calAgentId' ";
		}

		$propertyACL= $lDB->get("
			SELECT DISTINCT
				ac_accomm_type.pr_business_id
			FROM
				sc_accomm
				INNER JOIN ac_accomm_type ON sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
				INNER JOIN pr_business ON ac_accomm_type.pr_business_id = pr_business.pr_business_id
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
			WHERE
				sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
				AND ac_accomm_type.ac_accomm_type_inactive_yn = 0
		",3);

		$accommACL = $lDB->get("
			SELECT
				sc_accomm.ac_accomm_type_id
			FROM
				sc_accomm
				INNER JOIN sc_user ON sc_accomm.sc_group_id = sc_user.sc_group_id AND sc_user.pr_user_id = '".$GLOBALS['userid']."'
		",3);

		$quickMenuReservations = $lDB->get("
			SELECT DISTINCT
				rv_reservation.rv_reservation_ix,
				rv_reservation.rv_res_name,
				rv_reservation.rv_agent_ref
			FROM
				rv_reservation
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
			WHERE
				(rv_reservation.rv_reservation_ix REGEXP '".$query."'
				OR rv_reservation.rv_res_name REGEXP '".$query."'
				OR rv_reservation.rv_agent_ref REGEXP '".$query."'
				OR (
					SELECT
						rv_note_general
					FROM
						rv_note
					WHERE
						rv_note.rv_reservation_id = rv_reservation.rv_reservation_ix
					ORDER BY
						ad_create_date DESC
					LIMIT 1
				) REGEXP '".$query."')
				AND rv_reservation_item.pr_business_id IN ('".join("','",$propertyACL)."')
				AND rv_reservation_item.ac_accomm_type_id IN ('".join("','",$accommACL)."')
				".$agentACL."
				AND rv_reservation.rf_reservation_status_id IN ('0', '10', '20', '30', '40', '90', '95')
			ORDER BY
				rv_reservation.rv_date_arrive desc,
				rv_reservation.rv_date_depart desc,
				rv_reservation.rv_res_name asc
			LIMIT 20
		",2);

		foreach ($quickMenuReservations as $quickMenuReservation) {
			$resJob = "0";
			if(canEditReservation($quickMenuReservation['rv_reservation_ix'])) {
				$resJob = "2";
			}
			$menuValue = $quickMenuReservation['rv_reservation_ix']." - ".$quickMenuReservation['rv_res_name'];
			if(stripos(str_replace(" ", "", $menuValue), $query) === false) {
				$menuValue .= " <strong>(note)</strong>"; 
				$resJob = canEditReservation($quickMenuReservation['rv_reservation_ix']) ? "137" : "138";
			}
			$quickMenuOptions[] = [
				"value" => $menuValue,
				"data" => [
					"link" => "gotoLink('reservation.php?".$resJob."+".$quickMenuReservation['rv_reservation_ix']."')",
					"category" => "Reservations"
					]
				];
		}
	}

    // Invoices

    function getChildren($businessId) {
        $list = $GLOBALS['lDB']->get("
            SELECT
                pr_business_id
            FROM
                pr_business
            WHERE
                pr_business_parent = '$businessId'
        ",3);
        $children = array();
        foreach($list as $item) {
            $children = array_merge($children,getChildren($item));
        }
        array_push($children, $businessId);
        return $children;
    }

    $businessInternal = $GLOBALS['lDB']->get("
        SELECT
            pr_link_to
        FROM
            pr_link
        WHERE
            pr_link_from = '$GLOBALS[userid]'
            AND rf_link_type_id = 'RS1'
    ",4);

    $businessACL = getChildren($businessInternal);

    $invoicingUnitIDs = $GLOBALS['lDB']->get("
        SELECT 
            pr_business_id 
        FROM 
            pr_business 
        WHERE 
            pr_bus_inactive_yn = '0' 
            AND pr_business.pr_bus_billing_yn = '1'
            OR pr_business.pr_bus_billing_prop_yn = '1'
        ORDER BY 
            pr_business_sequence ASC
    ",3);

    $invoicingUnitIDs = array_intersect($invoicingUnitIDs,$businessACL);

	$quickMenuInvoices = $lDB->get("
        SELECT DISTINCT
            fn_invoice.fn_invoice_ix,
            fn_invoice.fn_inv_to,
            fn_folio.pr_business_id,
            rv_reservation.rv_res_name,
            rv_reservation.rv_reservation_ix
        FROM
            fn_invoice
            LEFT JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_invoice.rv_reservation_id
            LEFT JOIN fn_folio ON fn_folio.fn_folio_ix = fn_invoice.fn_folio_id
        WHERE
			fn_invoice.fn_invoice_ix LIKE '%".$query."%'
            AND fn_folio.pr_business_id IN ('".join("','",$invoicingUnitIDs)."')
            AND fn_invoice.fn_inv_status_ind != 8
        ORDER BY
            fn_invoice.fn_invoice_ix
        LIMIT 20
    ",2);

    $resJob = "647";
    foreach ($quickMenuInvoices as $quickMenuInvoice) {
        $quickMenuOptions[] = [
            "value" => $quickMenuInvoice['fn_invoice_ix'] . ": " . $quickMenuInvoice['pr_business_id'] . " - " . $quickMenuInvoice['fn_inv_to'] . " (" . $quickMenuInvoice['rv_res_name'] . ")",
            "data" => [
                "link" => "gotoLink('reservation.php?".$resJob."+".$quickMenuInvoice['rv_reservation_ix']."')",
                "category" => "Invoices"
                ]
            ];
    }

	$quickMenuFiscalInvoices = $lDB->get("
		SELECT DISTINCT
			fs_invoice.fn_invoice_id,
			fn_invoice.fn_inv_to,
			fs_invoice.fn_invoice_doc,
			fn_folio.pr_business_id,
			rv_reservation.rv_res_name,
			rv_reservation.rv_reservation_ix
		FROM
			fs_invoice
			LEFT JOIN fn_invoice ON fn_invoice.fn_invoice_ix = fs_invoice.fn_invoice_id 
			LEFT JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_invoice.rv_reservation_id
			LEFT JOIN fn_folio ON fn_folio.fn_folio_ix = fn_invoice.fn_folio_id
		WHERE
			fs_invoice.fn_invoice_doc LIKE '%".$query."%'
			AND fn_folio.pr_business_id IN ('".join("','",$invoicingUnitIDs)."')
			AND fn_invoice.fn_inv_status_ind != 8
		ORDER BY
			fn_invoice.fn_invoice_ix
		LIMIT 20
	",2);

	$resJob = "647";
	foreach ($quickMenuFiscalInvoices as $quickMenuFiscalInvoice) {
		$quickMenuOptions[] = [
			"value" => $quickMenuFiscalInvoice['fn_invoice_id'] . ": " . $quickMenuFiscalInvoice['pr_business_id'] . " - " . $quickMenuFiscalInvoice['fn_inv_to'] . " (" . $quickMenuFiscalInvoice['rv_res_name'] . ")",
			"data" => [
				"link" => "gotoLink('reservation.php?".$resJob."+".$quickMenuFiscalInvoice['rv_reservation_ix']."')",
				"category" => "Fiscalised Invoices"
				]
			];
	}

    // Payments
    $quickMenuPayments = $lDB->get("
        SELECT DISTINCT
            rv_payment.rv_payment_ix,
            rv_payment_item.rv_reservation_id,
            rv_reservation.rv_res_name,
            rv_payment.rv_pmnt_ref,
            TRIM(CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last)) AS name
        FROM
            rv_payment_item
            INNER JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
            INNER JOIN rv_reservation ON rv_payment_item.rv_reservation_id = rv_reservation.rv_reservation_ix
            LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_payment.pr_persona_id
            LEFT JOIN fn_folio ON fn_folio.fn_folio_ix = rv_payment_item.fn_folio_id
        WHERE
            rv_payment.rv_payment_ix LIKE '%".$query."%'
            AND fn_folio.pr_business_id IN ('".join("','",$invoicingUnitIDs)."')
        LIMIT 20
    ",2);

    $resJob = "647";
    foreach ($quickMenuPayments as $quickMenuPayment) {
        $quickMenuOptions[] = [
            "value" => $quickMenuPayment['rv_payment_ix'] . ": " . $quickMenuPayment['name'] . " -  (" . $quickMenuPayment['rv_reservation_id'] . " - " . $quickMenuPayment['rv_res_name'] . ")",
            "data" => [
                "link" => "gotoPaymentLink('reservation.php?".$resJob."+".$quickMenuPayment['rv_reservation_id']."')",
                "category" => "Payments"
                ]
            ];
    }

	// Contacts
	$acContacts = checkJob(47);
	if ($acContacts) { // If no contact view access, bypass contact lookup
		$agentACL = false;

		if($userStatusId < 2) {
			$agentACL = array($calAgentId);
		}
		$guestLinkACL = $lDB->get("
			SELECT DISTINCT
				pr_persona.pr_persona_ix
			FROM
				pr_persona
				INNER JOIN pr_link ON pr_link.pr_link_to = pr_persona.pr_persona_ix
					AND (pr_link.rf_link_type_id = 'RS3' OR pr_link.rf_link_type_id = 'RS4')
            WHERE
                pr_persona.pr_sys_code < 6
		",3);

		$agentFilter = useFilter("agent","","SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","pr_link.pr_link_to",$agentACL,"Direct booking","0");
		$guestLinkFilter = useFilter("guestLink","","SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","guestLink.pr_link_to",false,false,false);

		$busList = $lDB->get("
			SELECT
				pr_business_id
			FROM
				pr_business
		",3);

		$quickMenuPersonas = $lDB->get("
			SELECT DISTINCT
				pr_persona.pr_persona_ix,
				pr_persona.pr_name_first,
				pr_persona.pr_name_last
			FROM
				pr_persona
				LEFT JOIN pr_user ON pr_user_id = pr_persona.pr_persona_ix
				LEFT JOIN pr_link ON (pr_link.pr_link_from = pr_persona.pr_persona_ix)
					AND (pr_link.rf_link_type_id = 'RS2')
				LEFT JOIN pr_link as guestLink ON (guestLink.pr_link_from = pr_persona.pr_persona_ix)
					AND (guestLink.rf_link_type_id = 'RS3' OR guestLink.rf_link_type_id = 'RS4')
			WHERE
				(pr_persona.pr_name_first LIKE '%".$query."%'
				OR pr_persona.pr_name_last LIKE '%".$query."%')
				".$agentFilter['where']."
				".$guestLinkFilter['where']."
                AND pr_persona.pr_sys_code < 6
                AND pr_persona.pr_persona_ix NOT IN ('" . join("','", $busList) . "')
			ORDER BY
				pr_persona.pr_name_last ASC,
				pr_persona.pr_name_first ASC
			LIMIT 20
		",2);

		foreach ($quickMenuPersonas as $quickMenuPersona) {
			$quickMenuOptions[] = [
				"value" => $quickMenuPersona['pr_name_first']." ".$quickMenuPersona['pr_name_last'],
				"data" => [
					"link" => "gotoLink('reservation.php?45+".$quickMenuPersona['pr_persona_ix']."')",
					"category" => "Contacts"
					]
				];
		}
	}

	// Profiles
	$excludedReport = [
		'email_document',
		'email_proforma',
		'email_invoice',
		'user_preferences',
		'email_templates'
	];

	$quickMenuProfiles = $lDB->get("
		SELECT DISTINCT
			pf_option.pf_option_ix,
			pf_option.pf_object_id,
			pf_option.pf_option_name,
			pf_option.pf_option_note,
			pf_option.pf_level_link_id,
			pf_option.pf_option_favourite_yn,
			pf_object.pf_object_name,
			pf_object.pf_object_note,
			pf_object.sc_job_id
		FROM
			pf_option
			INNER JOIN pf_object ON pf_object.pf_object_ix = pf_option.pf_object_id
		WHERE
			(pf_option.pf_level_link_id = '".$GLOBALS['userid']."'
			OR pf_option.pf_level_link_id = '')
			AND pf_object.pf_object_name NOT IN ( '" . implode($excludedReport, "', '") . "' )
			AND pf_option.pf_option_name LIKE '%".$query."%'
		ORDER BY
			pf_object.pf_object_note ASC,
			pf_option.pf_option_name ASC
	",2);
	
	foreach ($quickMenuProfiles as $key => $profile){
		// Filter out non-access profiles
		$jobAllow = checkJob($profile['sc_job_id']);
		if (!$jobAllow) {
			unset($quickMenuProfiles[$key]);
		}
	}

	$quickMenuProfiles = array_slice($quickMenuProfiles, 0, 20);

	foreach ($quickMenuProfiles as $quickMenuProfile) {
		$quickMenuOptions[] = [
			"value" => $quickMenuProfile['pf_option_name'],
			"data" => [
				"link" => "openProfile('".$quickMenuProfile['pf_option_ix']."')",
				"category" => "Profiles"
				]
			];
	}

	$result = array();
	$result['query'] = $query;
	$result['suggestions'] = $quickMenuOptions;

	echo json_encode($result, true);
	die;
}

function displayReportProfiles() {
	$excludedReport = [
		'email_document',
		'email_proforma',
		'email_invoice',
		'user_preferences',
		'email_templates'
	];

	$profiles = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			pf_option.pf_option_ix,
			pf_option.pf_object_id,
			pf_option.pf_option_name,
			pf_option.pf_option_note,
			pf_option.pf_level_link_id,
			pf_option.pf_option_favourite_yn,
			pf_object.pf_object_name,
			pf_object.pf_object_note,
			pf_object.sc_job_id
		FROM
			pf_option
			INNER JOIN pf_object ON pf_object.pf_object_ix = pf_option.pf_object_id
		WHERE
			(pf_option.pf_level_link_id = '".$GLOBALS['userid']."'
			OR pf_option.pf_level_link_id = '')
			AND pf_object.pf_object_name NOT IN ( '" . implode($excludedReport, "', '") . "' )
		ORDER BY
			pf_object.pf_object_note ASC,
			pf_option.pf_option_name ASC
	",2);

	$profileData = array();
	$currentReport = '';

	if (!empty($profiles)) {

		$userReports = array();
		foreach ($profiles as $profile){
			if (!isset($userReports[$profile['pf_object_note']])) {
				$userReports[$profile['pf_object_note']] = 0;
			}
			if ($profile['pf_level_link_id'] != '') {
				$userReports[$profile['pf_object_note']]++;
			}
		}

		foreach ($profiles as $profile){

			$fields = $GLOBALS['lDB']->get("
				SELECT
					pf_field.pf_field_contents
				FROM
					pf_field
				WHERE
					pf_field.pf_option_id = '".$profile['pf_option_ix']."'
				ORDER BY
					pf_field.pf_field_ix DESC
			",3);

			if ($currentReport != $profile['pf_object_note']) {
				$currentReport = $profile['pf_object_note'];
				$profileData[] = '
				<div class="button '.( $userReports[$profile['pf_object_note']] == 0 ? 'global' : '').'" style="text-align:left; font-weight:bold; background-color:#cacaca; cursor: pointer; cursor: hand; padding-left:5px; padding-top:5px; height:15px; margin-top:10px;" onclick="expandReports(\''.$profile['pf_object_name'].'\')"  onmouseover="this.style.backgroundColor = \'#ddd\';"  onmouseout="this.style.backgroundColor = \'#cacaca\';">
					'.$currentReport.'
				</div>';
			}

			$profileData[] = '
			<div class="reportContainer pf_option '.$profile['pf_object_name'].'" style="display:none;">
				<div class="profileContainer '.( $profile['pf_level_link_id'] == '' ? 'global' : 'user').'" style="cursor: pointer; cursor: hand; padding-left:5px; padding-right:5px; padding-top:5px; height:15px;" onclick="loadReportProfileAjax(\''.$profile['pf_option_ix'].'\');" onmouseover="this.style.backgroundColor = \'#cfc\';"  onmouseout="this.style.backgroundColor = \'\';">
					<span title="'.($profile['pf_option_note'] == '' ? '' : $profile['pf_option_note']).'">
								<span class="profileName">'.$profile['pf_option_name'].'</span> <span style="float:right;">'.( $profile['pf_level_link_id'] == '' ? 'Global' : 'User').'</span>
					</span>
				</div>
			</div>';
		}
	}

	$GLOBALS['temp']['profile_rows'] = join($profileData,"");
}

function profileJob($pf_option_id) {
	$pf_object = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			pf_object.pf_object_ix,
			pf_object.sc_job_id
		FROM
			pf_object
			INNER JOIN pf_option ON pf_option.pf_object_id = pf_object.pf_object_ix
		WHERE
			pf_option.pf_option_ix = '".$pf_option_id."'
	",2);
	$pf_object_id = $pf_object[0]['pf_object_ix'];
	$sc_job_id = $pf_object[0]['sc_job_id'];

	$sc_job_id_cords = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			sc_job.sc_job_cords
		FROM
			sc_job
		WHERE
			sc_job.sc_job_id = '".$sc_job_id."'
	",4);

	$fileBits = explode(":", $sc_job_id_cords);
	$file = $fileBits[1];
	include("init.form".$file.".func.php");

	return $sc_job_id;
	exit;
}
