<?php

/**
* init.form3005.php - Wetu mapping code table
* Job: 3005
* Function: 57 (Code Tables: General)
*/

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"3005",__DIR__ . "/../../../public/html/code_wetu.htm");
}
$_SERVER['argv'] = array_pad($_SERVER['argv'],2,"");
$category = (string) $_SERVER['argv'][1];
if (isset($_POST['cat_change']) && $_POST['cat_change'] != '') {
	$category = $_POST['cat_change'];
}
$category = $category == '' ? '0' : str_replace('cat_', '', $category);

global $lDB;
$wetu = new Wetu('', $lDB);

if (isset($_POST['action'])) {
	switch ($_POST['action']) {
		case 'searchProp':
			if (empty(trim($_POST['searchString']))) {
				die;
			}
			echo $wetu->SearchWetuProperty(trim($_POST['searchString']));
			die;
			break;
		case 'searchAccomm':
			if (empty($_POST['searchString'])) {
				die;
			}
			echo $wetu->SearchWetuAccomm($_POST['searchString']);
			die;
			break;
        case 'searchActivity':
            if (empty(trim($_POST['searchString']))) {
                die;
            }
            echo $wetu->SearchWetuActivity(trim($_POST['searchString']));
            die;
            break;
        case 'searchActivitySupplier':
            if (empty(trim($_POST['searchString']))) {
                die;
            }
            echo $wetu->SearchWetuActivitySupplier(trim($_POST['searchString']));
            die;
            break;
        case 'SearchWetuActivitySupplierActivity':
            if (empty(trim($_POST['searchString']))) {
                die;
            }
            echo $wetu->SearchWetuActivitySupplierActivity(trim($_POST['searchString']));
            die;
            break;
        case 'searchTravel':
            if (empty(trim($_POST['searchString']))) {
                die;
            }
            echo $wetu->SearchWetuTravel(trim($_POST['searchString']));
            die;
            break;
        case 'lookupName':
            if (empty(trim($_POST['searchId']))) {
                die;
            }
            if (!empty(trim($_POST['secondId']))) {
            	$result = $wetu->LookupNameSupplier(trim($_POST['searchId']), trim($_POST['secondId']));
            } else {
            	$result = $wetu->LookupName(trim($_POST['searchId']));
            }
            echo ($result) ? json_encode($result, true) : '{"error":"1"}';
            die;
            break;
        case 'lookupAccommName':
            if (empty(trim($_POST['searchId'])) || empty(trim($_POST['propId']))) {
                die;
            }
            $result = $wetu->LookupAccommName(trim($_POST['searchId']), trim($_POST['propId']));
            echo ($result) ? json_encode($result, true) : '{"error":"1"}';
            die;
            break;
	}
}

if (isset($_POST['save_action']) && !empty($_POST['save_action'])) {
	$values = json_decode($_POST['save_action'], true);
	$propValues = array();
	$accommValues = array();
	$extrasValues = array();

	foreach ($values as $item) {
		if (strpos($item['name'], 'prop_') !== false) {
			$lDB->put("UPDATE pr_business SET pr_bus_wetu_id = '".$lDB->escape($item['value'])."' WHERE pr_business.pr_business_id = '".$lDB->escape(str_replace("prop_", "", $item['name']))."'");
		}
		if (strpos($item['name'], 'accomm_') !== false) {
			$lDB->put("UPDATE ac_accomm_type SET ac_accomm_wetu_id = '".$lDB->escape($item['value'])."' WHERE ac_accomm_type.ac_accomm_type_ix = '".$lDB->escape(str_replace("accomm_", "", $item['name']))."'");
		}
		if (strpos($item['name'], 'extra_prop_') !== false) {
			$lDB->put("UPDATE ac_extra SET ac_ext_wetu_prop_id = '".$lDB->escape($item['value'])."' WHERE ac_extra.ac_extra_ix = '".$lDB->escape(str_replace("extra_prop_", "", $item['name']))."'");
		}
		if (strpos($item['name'], 'extra_accomm_') !== false) {
			$lDB->put("UPDATE ac_extra SET ac_ext_wetu_accomm_id = '".$lDB->escape($item['value'])."' WHERE ac_extra.ac_extra_ix = '".$lDB->escape(str_replace("extra_accomm_", "", $item['name']))."'");
		}
		if (strpos($item['name'], 'exclude_prop_') !== false) {
			$lDB->put("UPDATE pr_business SET pr_bus_wetu_exclude = '".$lDB->escape($item['value'])."' WHERE pr_business.pr_business_id = '".$lDB->escape(str_replace("exclude_prop_", "", $item['name']))."'");
		}
		if (strpos($item['name'], 'exclude_accomm_') !== false) {
			$lDB->put("UPDATE ac_accomm_type SET ac_accomm_wetu_exclude = '".$lDB->escape($item['value'])."' WHERE ac_accomm_type.ac_accomm_type_ix = '".$lDB->escape(str_replace("exclude_accomm_", "", $item['name']))."'");
		}
        if (strpos($item['name'], 'exclude_extra_prop_') !== false) {
            $lDB->put("UPDATE ac_extra SET ac_ext_wetu_exclude = '".$lDB->escape($item['value'])."' WHERE ac_extra.ac_extra_ix = '".$lDB->escape(str_replace("exclude_extra_prop_", "", $item['name']))."'");
        }
        if ($item['name'] == 'wetuUsername') {
            $lDB->put("UPDATE rf_system SET rf_sys_wetu_username = '".$lDB->escape($item['value'])."' WHERE rf_system.rf_system_id = 1;");
            $wetu->WetuCredentials['username'] = $item['value'];
        }
        if ($item['name'] == 'wetuPassword') {
            $lDB->put("UPDATE rf_system SET rf_sys_wetu_password = '".$lDB->escape($item['value'])."' WHERE rf_system.rf_system_id = 1;");
            $wetu->WetuCredentials['password'] = $item['value'];
        }
        if ($item['name'] == 'wetuApiKey') {
            $lDB->put("UPDATE rf_system SET rf_sys_wetu_api_key = '".$lDB->escape($item['value'])."' WHERE rf_system.rf_system_id = 1;");
            $wetu->WetuCredentials['api_key'] = $item['value'];
        }
	}
}

$newr = 508;
$edit = $newr + 2;
$view = $newr - 1;
$dele = $newr + 4;
$sedit = $edit + 1;
$snewr = $newr + 1;

// Start Access Control Toolbar Setup
$pgJOBS = array();
$pgJOBS['view'] = "0";
if (checkJob($view)) {
	$pgJOBS['view'] = "1";
}
$pgJOBS['add'] = "0";
$pgJOBS['edit'] = "0";
if (checkJob($edit)) {
	$pgJOBS['save'] = "1";
}
$pgJOBS['del'] = "0";

$GLOBALS['temp']['pgJobs'] = "<input type=\"hidden\" id=\"pgJobNew\" value=\"".$pgJOBS['add']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobEdit\" value=\"".$pgJOBS['edit']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobDelete\" value=\"".$pgJOBS['del']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSave\" value=\"".$pgJOBS['save']."\">\n";
// End Access Control Toolbar Setup

$GLOBALS['temp']['new_record'] = "reservation.php?3005";
$GLOBALS['temp']['edit_view'] = "reservation.php?3005";
$GLOBALS['temp']['edit_save'] = "document.forms[0].submit()";

$disabled = checkJob($edit) == 1 ? "" : "disabled";

$GLOBALS['temp']['rows'] = "";
$GLOBALS['temp']['rowsAccommExtras'] = "";
$GLOBALS['temp']['rowsActivityExtras'] = "";
$GLOBALS['temp']['rowsTravelExtras'] = "";
$GLOBALS['temp']['propAccommDisplay'] = 'display: none;';
$GLOBALS['temp']['accommExtrasDisplay'] = 'display: none;';
$GLOBALS['temp']['activityExtrasDisplay'] = 'display: none;';
$GLOBALS['temp']['travelExtrasDisplay'] = 'display: none;';
$GLOBALS['temp']['noResultsDisplay'] = 'display: none;';

$GLOBALS['temp']['wetuCredentialsPopulated'] = !empty($wetu->WetuCredentials) && isset($wetu->WetuCredentials['api_key']) && $wetu->WetuCredentials['api_key'] != '' ? 'true' : 'false';
$GLOBALS['temp']['wetuEnabled'] = $wetu->WetuEnabled ? 'true' : 'false';

if ($disabled == "" && !$wetu->WetuEnabled) {
    $disabled = "disabled";
}

if ($disabled == "disabled") {
    $GLOBALS['temp']['disabledCredIcon'] = "display: none;";
    $GLOBALS['temp']['disabledCred'] = "disabled='disabled'";
}


$GLOBALS['temp']['wetuUsername'] = isset($wetu->WetuCredentials['username']) ? $wetu->WetuCredentials['username'] : "";
$GLOBALS['temp']['wetuPassword'] = isset($wetu->WetuCredentials['password']) ? $wetu->WetuCredentials['password'] : "";
$GLOBALS['temp']['wetuApiKey'] = isset($wetu->WetuCredentials['api_key']) ? $wetu->WetuCredentials['api_key'] : "";

$extraCategories = $lDB->get("
	SELECT
		ac_extra_category.ac_extra_category_ix,
		ac_extra_category.ac_extra_cat_desc,
		ac_extra_category.ac_extra_category_inactive_yn
	FROM
		ac_extra_category
	ORDER BY
        ac_extra_category.ac_extra_cat_ind DESC,
		ac_extra_category.ac_extra_category_inactive_yn DESC,
		ac_extra_category.ac_extra_cat_desc ASC
",2);

$catTabs = '<td id="cat_propaccomm" class="tab '.($category == '0' ? 'tabActive redOverline' : 'tabInactive redUnderline').' tabLink tabFirst" style="width: 120px; height: 25px;" align="center" onclick="showCat(\'\');">Props / Accomm</td>';

$catTabDropdown = '';
$count = 0;
foreach ($extraCategories as $cat) {
	$inactive = $cat['ac_extra_category_inactive_yn'] == 0 ? '' : '* ';
	$inactiveStyle = $cat['ac_extra_category_inactive_yn'] == 0 ? '' : 'font-style: italic;';
	if ($count < 4) {
		$catTabs .= '<td id="cat_'.$cat['ac_extra_category_ix'].'" class="tab '.($category == $cat['ac_extra_category_ix'] ? 'tabActive redOverline' : 'tabInactive redUnderline').' tabLink" style="width: 120px; height: 25px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; '.$inactiveStyle.'" align="center" onclick="showCat(\'cat_'.$cat['ac_extra_category_ix'].'\');">'.$inactive.$cat['ac_extra_cat_desc'].'</td>';
	} else {
		$catTabDropdown .= '<option style="'.$inactiveStyle.'" value="cat_'.$cat['ac_extra_category_ix'].'" '.($category == $cat['ac_extra_category_ix'] ? 'selected=selected' : '').'>'.$inactive.$cat['ac_extra_cat_desc'].'</option>';
	}
	$count++;
}
if (!empty($catTabDropdown)) {
	$catTabs .= '<td class="redUnderline" style="position: relative;">
		<select id="catSelect" onchange="showCatDropdown();" style="height: 25px;">
			<option id="0">&nbsp;More...</option>
			'.$catTabDropdown.'
		</select>
		</td>';
}
$GLOBALS['temp']['catTabs'] = $catTabs;

if (isset($_POST['searchFieldString']) && trim($_POST['searchFieldString']) != '') {
    $searchFieldString = trim($_POST['searchFieldString']);
    $searchFieldString = str_replace(array("*", "%"), "", $searchFieldString);
	$bussIDs = array();
    $results = false;

	$buss = $lDB->get("
		SELECT
			pr_business.pr_business_id,
			pr_persona.pr_name_last,
			pr_business.pr_bus_wetu_id,
			pr_business.pr_bus_wetu_exclude
		FROM
			pr_business
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
		WHERE
			pr_business.pr_bus_property_yn = 1
			AND pr_persona.pr_name_last LIKE '%" . $searchFieldString . "%'
		ORDER BY
			pr_business.pr_business_sequence ASC
	",2);

	if (!empty($buss)) {
		$bussIDs = bussOutput($buss, $disabled);
        $results = true;
	}

	$accomms = $lDB->get("
		SELECT
			ac_accomm_type.ac_accomm_type_ix,
			ac_accomm_type.ac_accomm_desc,
			ac_accomm_type.ac_accomm_wetu_id,
			ac_accomm_type.ac_accomm_wetu_exclude,
			ac_accomm_type.pr_business_id
		FROM
			ac_accomm_type
		WHERE
			ac_accomm_type.ac_accomm_desc LIKE '%" . $searchFieldString . "%'
		ORDER BY
			ac_accomm_type.ac_accomm_sequence ASC
	",2);

	foreach ($accomms as $accomm) {
		if (!in_array($accomm['pr_business_id'], $bussIDs)) {
			$bussIDs[] = $accomm['pr_business_id'];
			$buss = $lDB->get("
				SELECT
					pr_business.pr_business_id,
					pr_persona.pr_name_last,
					pr_business.pr_bus_wetu_id,
					pr_business.pr_bus_wetu_exclude
				FROM
					pr_business
					LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
				WHERE
					pr_business.pr_bus_property_yn = 1
					AND pr_business.pr_business_id = '".$accomm['pr_business_id']."'
				ORDER BY
					pr_business.pr_business_sequence ASC
			",2);
			if (!empty($buss)) {
				bussOutput($buss, $disabled);
                $results = true;
			}
		}
	}

    $accommExtras = $lDB->get("
        SELECT
            ac_extra.ac_extra_ix,
            ac_extra.ac_ext_desc,
            ac_extra.ac_ext_wetu_prop_id,
            ac_extra.ac_ext_wetu_accomm_id,
            ac_extra_category.ac_extra_cat_desc,
            ac_extra_category.ac_extra_category_ix,
            ac_extra.ac_ext_wetu_exclude,
            ac_extra_category.ac_extra_cat_ind
        FROM
            ac_extra
            LEFT JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
        WHERE
            ac_extra_category.ac_extra_cat_ind = 3
            AND ac_extra.ac_ext_desc LIKE '%" . $searchFieldString . "%'
    ",2);
    if (!empty($accommExtras)) {
        extraOutput($accommExtras, $disabled, "3");
        $results = true;
    }

    $travelExtras = $lDB->get("
        SELECT
            ac_extra.ac_extra_ix,
            ac_extra.ac_ext_desc,
            ac_extra.ac_ext_wetu_prop_id,
            ac_extra.ac_ext_wetu_accomm_id,
            ac_extra_category.ac_extra_cat_desc,
            ac_extra_category.ac_extra_category_ix,
            ac_extra.ac_ext_wetu_exclude,
            ac_extra_category.ac_extra_cat_ind
        FROM
            ac_extra
            LEFT JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
        WHERE
            ac_extra_category.ac_extra_cat_ind = 2
            AND ac_extra.ac_ext_desc LIKE '%" . $searchFieldString . "%'
    ",2);
    if (!empty($travelExtras)) {
        extraOutput($travelExtras, $disabled, "2");
        $results = true;
    }

    $activityExtras = $lDB->get("
        SELECT
            ac_extra.ac_extra_ix,
            ac_extra.ac_ext_desc,
            ac_extra.ac_ext_wetu_prop_id,
            ac_extra.ac_ext_wetu_accomm_id,
            ac_extra_category.ac_extra_cat_desc,
            ac_extra_category.ac_extra_category_ix,
            ac_extra.ac_ext_wetu_exclude,
            ac_extra_category.ac_extra_cat_ind
        FROM
            ac_extra
            LEFT JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
        WHERE
            (
                ac_extra_category.ac_extra_cat_ind = 0
                OR ac_extra_category.ac_extra_cat_ind = 1
            )
            AND ac_extra.ac_ext_desc LIKE '%" . $searchFieldString . "%'
    ",2);
    if (!empty($activityExtras)) {
        extraOutput($activityExtras, $disabled, "1");
        $results = true;
    }

    if (!$results) {
        $GLOBALS['temp']['noResultsDisplay'] = '';
    }
} else {
	if ($category == '0') {
		// Properties and accommodation types
		$buss = $lDB->get("
			SELECT
				pr_business.pr_business_id,
				pr_persona.pr_name_last,
				pr_business.pr_bus_wetu_id,
				pr_business.pr_bus_wetu_exclude
			FROM
				pr_business
				LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
			WHERE
				pr_business.pr_bus_property_yn = 1
			ORDER BY
				pr_business.pr_business_sequence ASC
		",2);

		bussOutput($buss, $disabled);
	} else {
		// Extras
		$extras = $lDB->get("
			SELECT
				ac_extra.ac_extra_ix,
				ac_extra.ac_ext_desc,
				ac_extra.ac_ext_wetu_prop_id,
				ac_extra.ac_ext_wetu_accomm_id,
				ac_extra_category.ac_extra_cat_desc,
				ac_extra_category.ac_extra_category_ix,
				ac_extra.ac_ext_wetu_exclude,
				ac_extra.ac_inactive_yn,
                ac_extra_category.ac_extra_cat_ind
			FROM
				ac_extra
				LEFT JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
			WHERE
				ac_extra_category.ac_extra_category_ix = '".$category."'
		",2);
        if (!empty($extras)) {
            $catInd = $extras[0]['ac_extra_cat_ind'];
            extraOutput($extras, $disabled, $catInd);
        } else {
            $GLOBALS['temp']['noResultsDisplay'] = '';
        }
        
	}
}

function extraOutput($extras, $disabled, $catInd) {
	global $lDB;
	$categories = array();

    switch ($catInd) {
        case '3':   // Accomm
            $HTMLExtras = __DIR__ . "/../../../public/html/code_wetu_extras_accomm_rows.htm";
            $rowHtmlExtras = Join("",File($HTMLExtras));
            $GLOBALS['temp']['accommExtrasDisplay'] = '';
            $extraRowsTag = "rowsAccommExtras";
            break;
        case '2':   // Travel
            $HTMLExtras = __DIR__ . "/../../../public/html/code_wetu_extras_travel_rows.htm";
            $rowHtmlExtras = Join("",File($HTMLExtras));
            $GLOBALS['temp']['travelExtrasDisplay'] = '';
            $extraRowsTag = "rowsTravelExtras";
            break;
        default:  // General, Activity
            $HTMLExtras = __DIR__ . "/../../../public/html/code_wetu_extras_activity_rows.htm";
            $rowHtmlExtras = Join("",File($HTMLExtras));
            $GLOBALS['temp']['activityExtrasDisplay'] = '';
            $extraRowsTag = "rowsActivityExtras";
            break;
    }

	foreach ($extras as $extra) {
		$inactiveStyle = !isset($extra['ac_inactive_yn']) || $extra['ac_inactive_yn'] == 0 ? '' : 'font-style: italic; background-color: #eee;';
		$data = array('name' => $extra['ac_ext_desc'],
			'id' => 'extra_prop_'.$extra['ac_extra_ix'],
			'prop_wetu_id' => $extra['ac_ext_wetu_prop_id'],
            'prop_id' => 'extra_prop_'.$extra['ac_extra_ix'],
			'accomm_id' => 'extra_accomm_'.$extra['ac_extra_ix'],
			'accomm_wetu_id' => $extra['ac_ext_wetu_accomm_id'],
			'style' => 'padding-left:10px; '.$inactiveStyle,
			'disabled' => $disabled,
			'cat' => 'cat_'.$extra['ac_extra_category_ix'],
			'exclude_id' => 'exclude_extra_prop_'.$extra['ac_extra_ix'],
			'exclude_checked' => $extra['ac_ext_wetu_exclude'] == 1 ? 'checked' : '',
			'exclude_checked_value' => $extra['ac_ext_wetu_exclude'] == 1 ? '1' : '',
			'parent_prop' => $extra['ac_extra_ix'],
            'displayLookupName1' => $extra['ac_ext_wetu_prop_id'] == "" ? 'display:none;' : '',
            'displayLookupName2' => $extra['ac_ext_wetu_accomm_id'] == "" ? 'display:none;' : '',
			'search' => '<i class="material-icons" style="font-size:12px; cursor:pointer;" onclick="searchWetuContainer(\'' . $extra['ac_extra_ix'] . '\', \'' . str_replace(array("'", '"'), "", $extra['ac_ext_desc']) . '\', \'' . $extra['ac_extra_cat_ind'] . '\');">search</i>'
		);
        $GLOBALS['temp'][$extraRowsTag] .= showpage($data,$rowHtmlExtras);
		$categories[$extra['ac_extra_category_ix']] = $extra['ac_extra_cat_desc'];
	}
}

function bussOutput($buss, $disabled) {
    global $lDB;
    $bussIDs = array();
    $HTML = __DIR__ . "/../../../public/html/code_wetu_prop_rows.htm";
    $rowHtml = Join("",File($HTML));
    $GLOBALS['temp']['propAccommDisplay'] = '';

    foreach ($buss as $prop) {
        $bussIDs[] = $prop['pr_business_id'];
        $data = array('name' => $prop['pr_name_last'],
            'id' => 'prop_'.$prop['pr_business_id'],
            'wetu_id' => $prop['pr_bus_wetu_id'],
            'style' => 'padding-left:10px',
            'disabled' => $disabled,
            'cat' => 'cat_propaccomm',
            'exclude_id' => 'exclude_prop_'.$prop['pr_business_id'],
            'exclude_checked' => $prop['pr_bus_wetu_exclude'] == 1 ? 'checked' : '',
            'exclude_checked_value' => $prop['pr_bus_wetu_exclude'] == 1 ? '1' : '',
            'parent_prop' => '',
            'displayLookupName1' => $prop['pr_bus_wetu_id'] == "" ? 'display:none;' : '',
            'search' => '<i class="material-icons" style="font-size:12px; cursor:pointer;" onclick="searchWetuContainer(\'' . $prop['pr_business_id'] . '\', \'' . str_replace(array("'", '"'), "", $prop['pr_name_last']) . '\', \'accomm\');">search</i>',
            'lookup_function' => 'lookupName',
            'prop_param' => ''
        );
        $GLOBALS['temp']['rows'] .= showpage($data,$rowHtml);

        $accomms = $lDB->get("
            SELECT
                ac_accomm_type.ac_accomm_type_ix,
                ac_accomm_type.ac_accomm_desc,
                ac_accomm_type.ac_accomm_wetu_id,
                ac_accomm_type.ac_accomm_wetu_exclude,
                ac_accomm_type.ac_accomm_type_inactive_yn
            FROM
                ac_accomm_type
            WHERE
                ac_accomm_type.pr_business_id = '".$prop['pr_business_id']."'
            ORDER BY
                ac_accomm_type.ac_accomm_sequence ASC
        ",2);

        foreach ($accomms as $accomm) {
            $inactiveStyle = $accomm['ac_accomm_type_inactive_yn'] == 0 ? '' : 'font-style: italic;  background-color: #eee;';
            $data = array('name' => $accomm['ac_accomm_desc'],
                'id' => 'accomm_'.$accomm['ac_accomm_type_ix'],
                'wetu_id' => $accomm['ac_accomm_wetu_id'],
                'style' => 'padding-left:40px;'.$inactiveStyle,
                'disabled' => $disabled,
                'cat' => 'cat_propaccomm',
                'exclude_id' => 'exclude_accomm_'.$accomm['ac_accomm_type_ix'],
                'exclude_checked' => $accomm['ac_accomm_wetu_exclude'] == 1 ? 'checked' : '',
                'exclude_checked_value' => $accomm['ac_accomm_wetu_exclude'] == 1 ? '1' : '',
                'parent_prop' => $prop['pr_business_id'],
                'displayLookupName1' => $accomm['ac_accomm_wetu_id'] == "" ? 'display:none;' : '',
                'search' => '',
                'lookup_function' => 'lookupAccommName',
                'prop_param' => ", '" . $prop['pr_bus_wetu_id'] . "'"
            );
            $GLOBALS['temp']['rows'] .= showpage($data,$rowHtml);
        }
    }
    return $bussIDs;
}