<?php

/**
 * init.form3008.func.php - Add Reminder Search Reservations and Contacts to email
 * Job: 3008
 */

require_once(__DIR__ . '/db.re_reminder.php');
require_once(__DIR__ . '/db.re_reminder_persona.php');

/**
 * @param string $query
 * @return array
 */
function get_user_email($query = "") {
    global $lDB;
    $data = [];

    $sql = "SELECT 
              pr_persona.pr_email,
              pr_persona.pr_persona_ix,
              pr_persona.pr_name_first,
              pr_persona.pr_name_last
            FROM 
              pr_persona
            WHERE 
              pr_persona.pr_persona_inactive_yn = 0 AND
              (
                pr_persona.pr_email IS NOT NULL AND
                pr_persona.pr_email <> ''
              )
              AND
              (
                pr_persona.pr_email LIKE '%{$query}%' OR
                pr_persona.pr_name_first LIKE '%{$query}%' OR
                pr_persona.pr_name_last LIKE '%{$query}%'
              ) 
            
          ";
    $results = $lDB->get($sql, 2);
    foreach($results as $item) {
        $name = ($item['pr_name_first'] != "") ? $item['pr_name_first'] . " " : "";
        $data [] = [
            'id' => $item['pr_persona_ix'],
            'text' => $name.$item['pr_name_last']." - ". $item['pr_email'],
        ];
    }

    return ["results" => $data];
}

/**
 * @param string $query
 * @return array
 */
function get_refer_to($query = ""){
    global $lDB;

    $rv_data = $pr_data = [];

    //Reservation date
    $rev_sql = "SELECT 
                 rv_reservation.rv_reservation_ix,
                 rv_reservation.rv_res_name
            FROM rv_reservation
            WHERE 
                  rv_reservation.rv_deleted_yn = 0 AND
                  (
                    rv_reservation.rv_reservation_ix LIKE '%{$query}%' OR 
                    rv_reservation.rv_res_name LIKE '%{$query}%'
                  )
                  ";

    $rv_results = $lDB->get($rev_sql, 2);
    foreach($rv_results as $item) {
        $rv_data [] = [
            'id' => "1|".$item['rv_reservation_ix'],
            'text' => $item['rv_reservation_ix']." - ". $item['rv_res_name'],
        ];
    }

    $data = [
      "results" => [
          [
            "text" => "Reservations",
            "children" => $rv_data
          ]
      ]
    ];


    return $data;
}

function add_reminder(){
    global $lDB;

    $re_repeat = (isset($_GET['re_repeat'])) ? $_GET['re_repeat'] : 0;

    if(!isset($_GET['re_note']) || $_GET['re_note'] == "") {
        return ["status" => "error", "message" => "Please fill in reminder note."];
    }


    if(!isset($_GET['re_send_date']) || $_GET['re_send_date'] == "") {
        return ["status" => "error", "message" => "Please fill in reminder send date."];
    }
    else {
        $send_date = strtotime($_GET['re_send_date']);
        $now = strtotime(date("Y-m-d H:i:s"));
        if($re_repeat == 0 && $send_date < $now) {
            return ["status" => "error", "message" => "The date and time selected to send the reminder has already elapsed."];
        }
    }

    if(!isset($_GET['re_refer_to_id']) || $_GET['re_refer_to_id'] == "") {
        return ["status" => "error", "message" => "Please fill in reminder reference object"];
    }

    if((!isset($_GET['re_persona_id']) || $_GET['re_persona_id'] == "") && (!isset($_GET['re_include_me']) || $_GET['re_include_me'] == "")) {
        return ["status" => "error", "message" => "Please select at least 1 recipient for the reminder."];
    }
    else {
        $_GET['re_persona_id'] = ($_GET['re_include_me'] == '1') ? $_GET['re_persona_id'].",".$_SESSION['userid'] : $_GET['re_persona_id'];
    }

    if($_GET['re_persona_id'] == "") {
        return ["status" => "error", "message" => "Please select at least 1 recipient for the reminder."];
    }

    $refer_to = explode("|", $_GET['re_refer_to_id']);
    $re_reminder_ix = db_re_reminder_insert($_GET['re_note'], $_GET['re_send_date'], date('e'), $re_repeat, $refer_to[0], $refer_to[1], RE_REMINDER_STATUS_ACTIVE);

    $ids = explode(',', $_GET['re_persona_id']);
    $ids = array_unique($ids);
    foreach ($ids as $id){
        db_re_reminder_persona_insert($re_reminder_ix, $id);
    }

    return ["message" => "Reminder successfully added.", "status" => "success"];

}

function edit_reminder(){
    global $lDB;

    $re_repeat = (isset($_GET['re_repeat'])) ? $_GET['re_repeat'] : 0;

    if(!isset($_GET['re_id']) || $_GET['re_id'] == "") {
        return ["status" => "error", "message" => "Invalid reminder."];
    }

    $re_reminder_ix = $_GET['re_id'];

    if(!isset($_GET['re_note']) || $_GET['re_note'] == "") {
        return ["status" => "error", "message" => "Please fill in reminder note."];
    }

    if(!isset($_GET['re_send_date']) || $_GET['re_send_date'] == "") {
        return ["status" => "error", "message" => "Please fill in reminder send date."];
    }
    else {
        $send_date = strtotime($_GET['re_send_date']);
        $now = strtotime(date("Y-m-d H:i:s"));
        if($re_repeat == 0 && $send_date < $now) {
            return ["status" => "error", "message" => "The date and time selected to send the reminder has already elapsed."];
        }
    }

    if(!isset($_GET['re_refer_to_id']) || $_GET['re_refer_to_id'] == "") {
        return ["status" => "error", "message" => "Please fill in reminder reference object"];
    }

    if((!isset($_GET['re_persona_id']) || $_GET['re_persona_id'] == "") && (!isset($_GET['re_include_me']) || $_GET['re_include_me'] == "")) {
        return ["status" => "error", "message" => "Please select at least 1 recipient for the reminder."];
    }
    else {
        $_GET['re_persona_id'] = ($_GET['re_include_me'] == '1') ? $_GET['re_persona_id'].",".$_SESSION['userid'] : $_GET['re_persona_id'];
    }

    if($_GET['re_persona_id'] == "") {
        return ["status" => "error", "message" => "Please select at least 1 recipient for the reminder."];
    }

    $refer_to = explode("|", $_GET['re_refer_to_id']);
    $result = db_re_reminder_update($_GET['re_id'],$_GET['re_note'], $_GET['re_send_date'], date('e'), $re_repeat, $refer_to[0], $refer_to[1], RE_REMINDER_STATUS_ACTIVE);

    if($result === false){
        return ["message" => "An internal server error occurred, reminder could not be updated.", "status" => "error"];
    }


    $ids = explode(',', $_GET['re_persona_id']);
    $ids = array_unique($ids);

    //get re_reminder_persona_ids to delete
    $deleted_ids = db_get_re_reminder_persona_ids_by_re_reminder_id($re_reminder_ix);
    foreach ($deleted_ids as $delete_id) {
        db_re_reminder_persona_delete_by_id($delete_id);
    }

    //re-insert re_reminder_persona_delete
    foreach ($ids as $id) {
        db_re_reminder_persona_insert($re_reminder_ix, $id);
    }

    return ["message" => "Reminder successfully updated.", "status" => "success"];

}

function delete_reminder() {

    if(!isset($_GET['re_id']) || $_GET['re_id'] == "") {
        return ["status" => "error", "message" => "Invalid reminder."];
    }

    $re_reminder_ix = $_GET['re_id'];

    //delete reminder
    if(db_re_reminder_delete($re_reminder_ix)){
        //get re_reminder_persona_ids to delete
        $deleted_ids = db_get_re_reminder_persona_ids_by_re_reminder_id($re_reminder_ix);
        foreach ($deleted_ids as $delete_id) {
            db_re_reminder_persona_delete_by_id($delete_id);
        }

        $message = "Reminder successfully deleted.";
        $status = "success";
    }
    else {
        $message = "Reminder could not be deleted.";
        $status = "error";
    }

    return ["message" => $message, "status" => $status];
}

function count_reminder() {

    if(!isset($_GET['re_reservation_id']) || $_GET['re_reservation_id'] == "") {
        return ["status" => "error", "message" => "Invalid reservation id."];
    }

    $reservation_id = $_GET['re_reservation_id'];

    if(db_re_reminder_count_by_reservation($reservation_id)){
        $message = "Reservation has reminder(s)";
        $status = "success";
    }
    else {
        $message = "Reminder does not have reminder(s)";
        $status = "error";
    }

    return ["message" => $message, "status" => $status];
}

function get_reminder() {

    if(!isset($_GET['re_reminder_id']) || $_GET['re_reminder_id'] == "") {
        return ["status" => "error", "message" => "Invalid reminder."];
    }

    $cc_me = 0;
    $re_reminder_ix = $_GET['re_reminder_id'];
    $info = db_re_reminder_info($re_reminder_ix);
    $recipients = db_re_reminder_recipient_list($re_reminder_ix);
    $recipient_id_str = $recipient_name_str = $cc_me = "";
    foreach ($recipients as $item){
        $recipient_id_str .= $item['pr_persona_ix'].', ';
        $recipient_name_str .= $item['pr_name_first'].' '.$item['pr_name_last'].' - '.$item['pr_email'].'| ';
        if($item['pr_persona_ix'] == $_SESSION['userid']){
            $cc_me = 1;
        }
    }

    $recipient_id_str = ($recipient_id_str != "") ? rtrim(  $recipient_id_str, ", ") : "";
    $recipient_name_str = ($recipient_name_str != "") ? rtrim( $recipient_name_str, "| ") : "";

    $data = [
        'ReReminderNote' => t_encodeHTML($info['re_reminder_note']),
        'ReReminderRepeat' => $info['re_reminder_repeat_yn'],
        'ReReminderSendDate' => date("m/d/Y H:i", strtotime($info['re_reminder_send_date'])),
        'ReReminderReferToId' => $info['re_reminder_link_to_ind_id'].'|'.$info['re_reminder_link_to_id'],
        'ReReminderRecipientListId' => $recipient_id_str,
        'ReReminderRecipientListName' => $recipient_name_str,
        'ReReminderRecipientCCMe' => $cc_me
    ];

    return ["message" => "", "status" => "success", "data" => $data];
}


