<?php

/**
 * init.form301.php - Rooming Calendar
 * Job: 234
 * Function: 81
*/

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}
if(array_key_exists("pf_option_id",$_POST) && isset($_SERVER['argv'][1]) && $_SERVER['argv'][1] == "last") {
	$_SERVER['argv'][1] = "";
	$_SERVER['argc'] = 1;
}
$_SERVER['argv'] = array_pad($_SERVER['argv'],11,"");
$pf_object_id = db_pf_object_by_name("rooming_calendar");
processProfileAction($pf_object_id,$profileFields);

$pf_option_id = applyProfile($pf_object_id,$profileFields);
$title = db_pf_option_get_title($pf_option_id);
if(trim($title) == "") {
	$title = "Extras Report";
}
$GLOBALS['temp']['title'] = $title;

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id,$pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();

$GLOBALS['temp']['startupMessage'] 		= "";
$GLOBALS['temp']['startupList'] 			= "";
$GLOBALS['temp']['startupListTitle'] 	= "";

$readOnlyClassHide = "collapse printCollapse";
if($GLOBALS['jobLevelArray'][234] < 10) {
	$readonly = true;
	$GLOBALS['temp']['readonly'] = "1";
	$GLOBALS['temp']['readOnlyClassHide'] = $readOnlyClassHide;
} else {
	$readonly = false;
	$GLOBALS['temp']['readonly'] = "0";
	$GLOBALS['temp']['readOnlyClassHide'] = "";
}

//user access to reservation tabs
if (isset($GLOBALS['funLevelArray'][52]) && $GLOBALS['funLevelArray'][52] >= 5) {
	$GLOBALS['temp']['reservationTabsAccess'] = "1";
} else {
	$GLOBALS['temp']['reservationTabsAccess'] = "0";
}

$oldSession = $_SESSION['calendarParms'];
$thisSession = array(//array_slice($_SERVER['argv'],1,8);
	/*	0 */ $_SERVER['argv'][1], // Date
	/*	1 */ $_SERVER['argv'][2], // Property
	/*	2 */ $_SERVER['argv'][3], // Options (Avail = $oldSession[2], // Status Filter)
	/*	3 */ "", // RandomID $oldSession[3], // Agent
	/*	4 */ $_SERVER['argv'][5], // Accommsort $oldSession[4], // Rate
	/*	5 */ $_SERVER['argv'][6], // Days $oldSession[5], // Agent contact
	/*	6 */ $_SERVER['argv'][7], // Res num line $oldSession[6], // Commission
	/*	7 */ $_SERVER['argv'][8], // Res name line $oldSession[7], // Allocation
	/*	8 */ $_SERVER['argv'][9], // $oldSession[8], // Provisional disable
	/*	9 */ $_SERVER['argv'][10], // advanced $oldSession[9], // Provisional check
	/* 10 */ "", //$oldSession[10], // Comm deduct
	/* 11 */ "" //$_SERVER['argv'][5], // Accommodation sort
);
if($_SERVER['argv'][1] == "last") {
	$thisSession = $oldSession;
	$_SERVER['argv'][1] = $thisSession[0];
	$_SERVER['argv'][2] = $thisSession[1];
	$_SERVER['argv'][3] = $thisSession[2];
	$_SERVER['argv'][4] = $thisSession[3];
	$_SERVER['argv'][5] = $thisSession[4];
	$_SERVER['argv'][6] = $thisSession[5];
	$_SERVER['argv'][7] = $thisSession[6];
	$_SERVER['argv'][8] = $thisSession[7];
	$_SERVER['argv'][9] = $thisSession[8];
	$_SERVER['argv'][10] = $thisSession[9];
} else {
    if( ($_SERVER['argv'][3] & 7) == 0) {
        session_set("calendarParms", $thisSession);
    }
}

/* START - Action code */
if(!$readonly && isset($_POST['setRoomId']) && $_POST['setRoomId'] != "") {
	$args = explode("+",$_POST['setRoomId']);
	$groupId = $args[0];
	$roomList = explode(":",$args[1]);
	$resItemId = $args[2];
	$requestYN = $args[3];
	$requestReason = $_POST['requestReason'];

	if ( $roomList[0] == "0" || trim($roomList[0]) == "" ) {
		$requestYN = "0";
		$requestReason = "";
	}

	foreach ( $roomList as $roomId ) {
		if ( $groupId == "" ) {
			$groupId = db_rv_res_item_group_insert($resItemId);
		}

		if ( $roomId != "" ) {
			db_rv_res_item_group_set_room($groupId, $roomId, $requestYN, $requestReason);
			$resId = $GLOBALS['lDB']->get("SELECT rv_reservation_id FROM rv_reservation_item WHERE rv_reservation_item_ix = '$resItemId'",4);
			ammendReservation($resId,"Room Allocation");
		}

		if ( $_POST['roomAction'] == "checkin" ) {
			db_rv_res_item_group_set_status($groupId,5);
			if ( $roomId == "" ) {
				$roomName = $GLOBALS['lDB']->get("
					SELECT
						ac_accomm_room.ac_desc
					FROM
						rv_res_item_group
						INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
					WHERE
						rv_res_item_group.rv_res_item_group_ix = '$groupId'
				",4);
				$resId = $GLOBALS['lDB']->get("SELECT rv_reservation_id FROM rv_reservation_item WHERE rv_reservation_item_ix = '$resItemId'",4);
				ammendReservation($resId,"Room Check In");
				$GLOBALS['temp']['startupMessage'] .= "Room '$roomName' has been <span class='txtb'>checked in</span>";
			}
		}
		$groupId = ""; // Should always be the last line in this loop
	}
}

if(!$readonly && isset($_POST['roomAction']) && $_POST['roomAction'] == "checkout" ) {
	$groupId = $_POST['checkoutId'];
	$checkoutDate = $_POST['checkoutDate'];
	/*if($checkoutDate == date("Y-m-d")) {
		db_rv_res_item_group_set_status($groupId,8);
	} else {*/
		db_rv_res_item_group_set_status($groupId,8,$checkoutDate);
	/*}*/
	$resId = $GLOBALS['lDB']->get("
		SELECT
			rv_reservation_item.rv_reservation_id
		FROM
			rv_res_item_group
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
		WHERE
			rv_res_item_group.rv_res_item_group_ix = '$groupId'
	",4);
	$roomName = $GLOBALS['lDB']->get("
		SELECT
			ac_accomm_room.ac_desc
		FROM
			rv_res_item_group
			INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		WHERE
			rv_res_item_group.rv_res_item_group_ix = '$groupId'
	",4);
	$GLOBALS['temp']['startupMessage'] .= "Room '$roomName' has been <span class='txtb'>checked out</span>";
	ammendReservation($resId,"Room Check Out");
}
if(!$readonly && isset($_POST['roomAction']) && $_POST['roomAction'] == "batchCheckIn") {
	$checkInList = explode("|",$_POST['batchCheckInList']);
	$roomNumberList = array();
	foreach($checkInList as $item) {
		$roomNumber = $GLOBALS['lDB']->get("
			SELECT
				ac_accomm_room.ac_desc
			FROM
				rv_res_item_group
				INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
			WHERE
				rv_res_item_group.rv_res_item_group_ix = '$item'
		",4);
		array_push($roomNumberList,$roomNumber);
		db_rv_res_item_group_set_status($item,5);
		$resId = $GLOBALS['lDB']->get("
			SELECT
				rv_reservation_item.rv_reservation_id
			FROM
				rv_res_item_group
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			WHERE
				rv_res_item_group.rv_res_item_group_ix = '$item'
		",4);
		ammendReservation($resId,"Room Check In");
	}
	$GLOBALS['temp']['startupList'] = "'" . join("','",$roomNumberList) . "'";
	$GLOBALS['temp']['startupListTitle'] = "The following rooms have been checked in:";
}
if(!$readonly && isset($_POST['roomAction']) && $_POST['roomAction'] == "batchCheckOut") {
	$checkOutList = explode("|",$_POST['batchCheckOutList']);
	$roomNumberList = array();
	foreach($checkOutList as $item) {
		$roomNumber = $GLOBALS['lDB']->get("
			SELECT
				ac_accomm_room.ac_desc
			FROM
				rv_res_item_group
				INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
			WHERE
				rv_res_item_group.rv_res_item_group_ix = '$item'
		",4);
		array_push($roomNumberList,$roomNumber);
		db_rv_res_item_group_set_status($item,8);
		$resId = $GLOBALS['lDB']->get("
			SELECT
				rv_reservation_item.rv_reservation_id
			FROM
				rv_res_item_group
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			WHERE
				rv_res_item_group.rv_res_item_group_ix = '$item'
		",4);
		ammendReservation($resId,"Room Check Out");
	}
	$GLOBALS['temp']['startupList'] = "'" . join("','",$roomNumberList) . "'";
	$GLOBALS['temp']['startupListTitle'] = "The following rooms have been checked out:";
}
/* END	- Action code */

$agentCheck = $GLOBALS['lDB']->get("
	SELECT
		COUNT(*)
	FROM
		pr_link
	WHERE
		rf_link_type_id = 'RS2'
		AND pr_link_from = '" . $GLOBALS['userid'] . "'
",4);

if($agentCheck > 0) {
	$pageHTML = __DIR__ . "/../../../public/html/whitescreenofdeath.htm";
	$sql = "
		SELECT
			pr_persona.pr_email
		FROM
			rf_sys_admin
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rf_sys_admin.pr_persona_id
		WHERE
			rf_sys_admin_primary = 1
		LIMIT 1";
	$temp = $GLOBALS['lDB']->get($sql,4);
	$GLOBALS['temp']['sysAdminEmail'] = "none";
	if ($temp != "" && $temp != "0") {
		$GLOBALS['temp']['sysAdminEmail'] = $temp;
	}
} else {
	$pageHTML = __DIR__ . "/../../../public/html/rooming_calnew.htm";
}

if (!array_key_exists($form, $GLOBALS)) {
	$GLOBALS[$form] = "";
}

if (!is_object($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",$pageHTML);
}

//$resHTMLColour = array("#5ab3eb","#394aa2","#f066a5","#26bd2d","#882dcf","#b88b8b","#6c9677","#c1a0bd","#ada846");
$resHTMLColour = array("#fcc","#9cf","#9cc","#c9c","#cc9","#fc3","#6cc","#99f","#ffc","#a4c1b6","#bff939","#E0DCCF","#abfef5","#efdbf0","#9fa257","#4d8dce");
//$resPDFColour = array("#5AB3EB","#394AA2","#F066A5","#26BD2D","#882DCF","#B88B8B","#6C9677","#C1A0BD","#ADA846");

$GLOBALS['temp']['today'] = date("Y-m-d");
$days = $_SERVER['argv'][6];
if(empty($days) || !is_numeric($days)) {
	$days = $GLOBALS['lDB']->get("SELECT rf_room_cal_days FROM rf_default",4);
}
$GLOBALS['temp']['days'] = $days;
$fromDate = useDate("from", $_SERVER['argv'][1]);
$toDate =	useDate("to",dateAddDay($fromDate['jsDate'],$days-1));
$GLOBALS['temp']['toDate'] = $toDate['jsDate'];

$moveDays = floor($days/2)+1;
$GLOBALS['temp']['moveDays'] = $moveDays;
$GLOBALS['temp']['datePrev'] = dateAddDay($fromDate['jsDate'],-$moveDays);
$GLOBALS['temp']['dateNext'] = dateAddDay($fromDate['jsDate'],$moveDays);

$changeDate = dateAddDay(date("Y-m-d"),-7);

$userProperty = $GLOBALS['lDB']->get("
	SELECT
		pr_link_to
	FROM
		pr_link
	WHERE
		pr_link_from = '" . $GLOBALS['userid'] . "'
	AND
		pr_link.rf_link_type_id = 'RS1'
",4);

$propertyACL = $GLOBALS['lDB']->get("
	SELECT DISTINCT
		ac_accomm_type.pr_business_id
	FROM
		sc_accomm,
		ac_accomm_type,
		pr_business,
		pr_persona
	WHERE
		sc_accomm.sc_group_id= '" . $GLOBALS['sc_group_id'] . "'
	AND
		sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
	AND
		ac_accomm_type.ac_accomm_type_inactive_yn = '0'
	AND
		ac_accomm_type.pr_business_id = pr_business.pr_business_id
	AND
		pr_business.pr_bus_inactive_yn = '0'
	AND
		pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
",3);

if($_SERVER['argv'][1] == "" && $_SERVER['argv'][2] == "" && $pf_option_id == "") {
	if(trim($userProperty) != "" && $userProperty != "0" && in_array($userProperty,$propertyACL)) {
		$_SERVER['argv'][2] = join(":",$GLOBALS['lDB']->get("
				SELECT
					ac_accomm_type_ix
				FROM
					ac_accomm_type
				WHERE
					pr_business_id = '$userProperty'
					AND ac_accomm_type_inactive_yn = '0'
		",3));
	}
	$_SERVER['argv'][2] = join(":",$GLOBALS['lDB']->get("
		SELECT
			ac_accomm_type_ix
		FROM
			ac_accomm_type
		WHERE
			pr_business_id = '".(isset($propertyACL[0])?$propertyACL[0]:"")."'
			AND ac_accomm_type_inactive_yn = '0'
	",3));
}

$accommACL= $GLOBALS['lDB']->get("
	SELECT DISTINCT
		ac_accomm_type.ac_accomm_type_ix
	FROM
		sc_accomm, ac_accomm_type
	WHERE
		sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
		AND sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
",3);
$accommFilter = useFilter("accomm",$_SERVER['argv'][2],"SELECT CONCAT(pr_business.pr_bus_name_short,CONCAT(' - ',ac_accomm_type.ac_accomm_desc)) FROM ac_accomm_type INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id WHERE ac_accomm_type_ix =","rv_reservation_item.ac_accomm_type_id",$accommACL,false,false);
$propertyArray = $GLOBALS['lDB']->get("
	SELECT DISTINCT pr_business_id FROM ac_accomm_type WHERE 1 ".str_replace("rv_reservation_item.ac_accomm_type_id","ac_accomm_type_ix",$accommFilter['where'])
,3);
$propertyWhere = "IN ('".join("','",$propertyArray) . "')";
$propertyCount = sizeof($propertyArray);

$GLOBALS['temp']['pr_bus_name_short'] = join(", ",$GLOBALS['lDB']->get("SELECT pr_bus_name_short FROM pr_business WHERE pr_business_id $propertyWhere",3));
if(strlen($GLOBALS['temp']['pr_bus_name_short'])>40) {
	/*
	 * The list of properties is too long and will cause alignment issues. To fix this the
	 * list will be truncated with an ellipsis and overlib will be used to show the entire
	 * list.
	 */
	$longList = $GLOBALS['temp']['pr_bus_name_short'];
	$shortList = substr($longList, 0, 37) . '...';
	$shortListDisplay = "<span class=\"txt\" style=\"cursor:default;\" onmouseover=\"overlib('$longList',WIDTH,180,ABOVE,OFFSETY,5,LEFT);\" onmouseout=\"nd();\">$shortList</span>";
	$GLOBALS['temp']['pr_bus_name_short'] = $shortListDisplay;
}

if($propertyCount > 1) {
	$GLOBALS['temp']['propId'] = "DISABLED";
} else {
	$GLOBALS['temp']['propId'] = isset($propertyArray[0])?$propertyArray[0]:"";
}

$showResNum = $_SERVER['argv'][7];
$showResName = $_SERVER['argv'][8];
$showGuestName = $_SERVER['argv'][9];
if($showResNum == 0 && $showResName == 0 && $showGuestName == 0) {
	$showResNum = 1;
	$showResName = 1;
	$showGuestName = 1;
}
$detailCount = 0;
$GLOBALS['temp']['showResNumChecked'] = "";
if($showResNum == 1) {
	$GLOBALS['temp']['showResNumChecked'] = "checked";
	$detailCount++;
}
$GLOBALS['temp']['showResNameChecked'] = "";
if($showResName == 1) {
	$GLOBALS['temp']['showResNameChecked'] = "checked";
	$detailCount++;
}
$GLOBALS['temp']['showGuestNameChecked'] = "";
if($showGuestName == 1) {
	$GLOBALS['temp']['showGuestNameChecked'] = "checked";
	$detailCount++;
}

$advancedDisplay = $_SERVER['argv'][10];
$GLOBALS['temp']['advancedForm'] = "collapse printCollapse";
if($advancedDisplay == "1") {
	$GLOBALS['temp']['advancedForm'] = "colLt";
}

$options = $_SERVER['argv'][3];

switch($options & 7) {
	case REP_VIEW_HTML:
		$renderMode = "html";
		$renderType = "";
		break;
	case REP_VIEW_PDF:
		$renderMode = "pdf";
		$renderType = "view";
		break;
	case REP_EMAIL_PDF:
		$renderMode = "pdf";
		$renderType = "email";
		break;
	case REP_SEND_PDF:
		$renderMode = "pdf";
		$renderType = "send";
		break;
	case REP_VIEW_CSV:
		$renderMode = "csv";
		$renderType = "";
}

if(isset($_POST['action']) && $_POST['action'] == "findRes") {
	// START - Find res
	$findGuestName = addslashes(str_replace("*","%",$_POST['findGuestName']));
	$findVoucherRef = addslashes(str_replace("*","%",$_POST['findVoucherRef']));
	$findResNum = addslashes(str_replace("*","%",$_POST['findResNum']));
	$findResName = addslashes(str_replace("*","%",$_POST['findResName']));
	$findRoomSQL = "";
	$findRoomSort = array();
	$findResSQL = "";
	$findResSort = array();
	$searchRes = true;
	if(trim(str_replace("%","",$findGuestName)) != "") {
		$findRoomSQL .= "
			AND CONCAT(pr_persona.pr_name_first,CONCAT(' ',pr_persona.pr_name_last)) LIKE '%$findGuestName%'
		";
		array_push($findRoomSort,"CONCAT(pr_persona.pr_name_first,CONCAT(' ',pr_persona.pr_name_last))");
		$searchRes = false;
	}
	if(trim(str_replace("%","",$findVoucherRef)) != "") {
		$findRoomSQL .= "
			AND rv_reservation.rv_agent_ref LIKE '%$findVoucherRef%'
		";
		$findResSQL .= "
			AND rv_reservation.rv_agent_ref LIKE '%$findVoucherRef%'
		";
		array_push($findRoomSort,"rv_reservation.rv_agent_ref");
		array_push($findResSort,"rv_reservation.rv_agent_ref");
	}
	if(trim(str_replace("%","",$findResNum)) != "") {
		$findRoomSQL .= "
			AND rv_reservation.rv_reservation_ix LIKE '%$findResNum%'
		";
		$findResSQL .= "
			AND rv_reservation.rv_reservation_ix LIKE '%$findResNum%'
		";
		array_push($findRoomSort,"rv_reservation.rv_reservation_ix");
		array_push($findResSort,"rv_reservation.rv_reservation_ix");
	}
	if(trim(str_replace("%","",$findResName)) != "") {
		$findRoomSQL .= "
			AND rv_reservation.rv_res_name LIKE '%$findResName%'
		";
		$findResSQL .= "
			AND rv_reservation.rv_res_name LIKE '%$findResName%'
		";
		array_push($findResSort,"rv_reservation.rv_res_name");
		array_push($findRoomSort,"rv_reservation.rv_res_name");
	}
	if(sizeof($findRoomSort) == 0) {
		array_push($findRoomSort,"CONCAT(pr_persona.pr_name_first,CONCAT(' ',pr_persona.pr_name_last))");
	}
	if(sizeof($findResSort) == 0) {
		array_push($findResSort,"rv_reservation.rv_res_name");
	}
	array_push($findRoomSort,"(ac_accomm_room.ac_desc)+0");
	$findRoomSortSQL = "ORDER BY " . join(",",$findRoomSort);
	$findResSortSQL = "ORDER BY " . join(",",$findResSort);
	$resListSQL = "
		";
	$resListWhereSQL = "
			AND (
				rv_reservation.rf_reservation_status_id = '30'
				OR (
					rv_reservation.rf_reservation_status_id = '20'
					AND rv_reservation.rv_provision_expiry_date >= '".date("Y-m-d")."'
				)
			)
			AND (
				(rv_reservation_item.rv_item_date_arrive >= '$fromDate[jsDate]' AND rv_reservation_item.rv_item_date_arrive <= '$toDate[jsDate]')
				OR (rv_reservation_item.rv_item_date_depart >= '$fromDate[jsDate]' AND rv_reservation_item.rv_item_date_depart <= '$toDate[jsDate]')
				OR (rv_reservation_item.rv_item_date_arrive < '$fromDate[jsDate]' AND rv_reservation_item.rv_item_date_depart > '$toDate[jsDate]')
			)
			$accommFilter[where]

	";
	$roomList = $GLOBALS['lDB']->get("
		SELECT
			rv_reservation.rv_reservation_ix,
			rv_reservation_item.rv_reservation_item_ix,
			pr_persona.pr_name_last,
			pr_persona.pr_name_first,
			rv_reservation.rv_res_name,
			ac_accomm_room.ac_desc,
			ac_accomm_room.ac_accomm_room_ix,
			rv_res_item_group.rv_res_item_group_ix,
			rv_res_item_group.rv_grp_status_ind,
			rv_res_item_guest.pr_guest_id,
			rf_title.rf_title_desc,
			rf_name_suffix.rf_suffix_desc
		FROM
			rv_reservation
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
			LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
			LEFT JOIN rv_res_item_guest ON rv_res_item_guest.rv_res_item_group_id = rv_res_item_group.rv_res_item_group_ix
			LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
			LEFT JOIN rf_title ON rf_title.rf_title_ix = pr_persona.pr_title_id
			LEFT JOIN rf_name_suffix ON rf_name_suffix.rf_name_suffix_ix = pr_persona.pr_name_suffix_id
		WHERE
			(
				ac_accomm_room.ac_accomm_room_ix IS NOT NULL
				OR pr_persona.pr_persona_ix IS NOT NULL
			)
		$resListWhereSQL
			$findRoomSQL
		$findRoomSortSQL
	",2);

	$resList = array();
	if($searchRes) {
		$resList = $GLOBALS['lDB']->get("
			SELECT
				rv_reservation.rv_reservation_ix,
				rv_reservation_item.rv_reservation_item_ix,
				(rv_reservation_item.rv_item_accomm_count - COUNT(ac_accomm_room.ac_accomm_room_ix)) AS accomm_left,
				rv_reservation.rv_res_name,
				'' AS pr_name_last,
				'' AS pr_name_first,
				'' AS ac_desc,
				'' AS ac_accomm_room_ix,
				'' AS rv_res_item_group_ix,
				'' AS rv_grp_status_ind,
				'' AS pr_guest_id,
				'' AS rf_title_desc,
				'' AS rf_suffix_desc
			FROM
				rv_reservation
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
				LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
				LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
			WHERE
				1
			$resListWhereSQL
				$findResSQL
			GROUP BY
				rv_reservation_item.rv_reservation_item_ix
				HAVING accomm_left > 0
			$findResSortSQL
		",2);
	}

	$resList = array_merge($roomList,$resList);

	//debug($resList);
	//
	//FIXME: CANCHECK
	$resHTML = "
		<tr class=\"imgLink\" onmouseover=\"this.style.backgroundColor='#cfc';\" onmouseout=\"this.style.backgroundColor='#fff';\" style=\"background-color: #fff;\" onclick=\"findSelectCell('!rv_reservation_ix!', '!rv_reservation_item_ix!','!rv_res_item_group_ix!','!ac_accomm_room_ix!','!rv_grp_status_ind!',false);\">
			<td class=\"br bb\" valign=\"top\">!ac_desc_fmt!</td>
			<td class=\"br bb\" valign=\"top\">!pr_name_full_fmt!</td>
			<td class=\"br bb\" valign=\"top\">!rv_reservation_ix!: !rv_res_name_fmt!</td>
		</tr>
	";
	$resRows = "";
	if(sizeof($resList) > 0) {
		foreach($resList as $item) {
			if($item['ac_desc'] == "") {
				$item['ac_desc_fmt'] = "&nbsp;";
			} else {
				$item['ac_desc_fmt'] = $item['ac_desc'];
			}

			$guestName = $item['pr_name_last'];
			if(trim($item['rf_suffix_desc']) != "") {
				$guestName .= " " . $item['rf_suffix_desc'];
			}
			if(trim($item['pr_name_first']) != "") {
				$guestName .= ", " . $item['pr_name_first'];
			}
			if(trim($item['rf_title_desc']) != "") {
				$guestName .= " " . $item['rf_title_desc'];
			}

			$item['pr_name_full'] = $guestName;

	//		$item['pr_name_full'] = trim($item['pr_name_first'] . " " . $item['pr_name_last']);
			if($item['pr_name_full'] == "") {
				$item['pr_name_full_fmt'] = "&nbsp;";
			} else {
				$item['pr_name_full_fmt'] = $item['pr_name_full'];
			}
			$item['pr_name_full'] = t_encodeOverlib($item['pr_name_full']);
			$item['rv_res_name_fmt'] = $item['rv_res_name'];
			$item['rv_res_name'] = t_encodeOverlib($item['rv_res_name']);
			$resRows .= showpage($item,$resHTML);
		}
	}

	if($resRows == "") {
		$resRows = "
			<tr>
				<td colspan=\"3\" align=\"center\" class=\"txti\">No current reservations</td>
			</tr>
		";
	}

	echo "
		<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\" style=\"table-layout: fixed;\">
		<col width=\"100\" />
		<col width=\"150\" />
		<col />
		$resRows
		</table>
	";
	die();
	// END - Find res
}

if ( $renderMode == "pdf" && $renderType == "email" ) {
	$pdfName = "Rooming Calendar - due to: " . $toDate['htmlDate'];

	$attachmentTable = '
		<table width="100%" border="0" cellpadding="0" cellspacing="0" summary="">
			<tr>
				<td valign="top"><img src="/resource/Resrequest/Application/public/img/eml_pdf.gif" alt="" /></td>
				<td id="attachmentLabel" width="100%">' . $pdfName . '.pdf</td>
			</tr>
		</table>
	';

	$newOptions = ($options & ~3) + 3;
	$formAction = 'reservation.php?' . join("+",array_slice($_SERVER['argv'],0,3)) . '+' . $newOptions . '+' . join("+",array_slice($_SERVER['argv'],4,1));

	$GLOBALS[$form]->FormHTML = str_replace("!formAction!",$formAction,
															str_replace("!attachmentInfo!",$attachmentTable,
															str_replace("!attachmentName!",$pdfName.".pdf",
															str_replace("!hasAttachment!","expand",
															str_replace("!emailBody!","",
															str_replace("!emailSubject!",$pdfName,
															join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));

	$principalId = $GLOBALS['lDB']->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId = $GLOBALS['lDB']->get("SELECT rf_res_office_id FROM rf_default", 4);

	$principalInfo = getPersonaDetail($principalId);
	$resOfficeInfo = getPersonaDetail($resOfficeId);

	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));

	$GLOBALS['temp']['princName'] = $principalInfo['name'];
	$GLOBALS['temp']['fax'] = $resOfficeInfo['fax'];
	$GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
	$userId = $_SESSION['userid'];

	$GLOBALS['temp']['emailFrom'] = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '".$userId."'
	",4);
	$GLOBALS['temp']['emailTo'] = "";
}


$headerRowHTML = '
	<div class="!headerClass! bt bb br" style="display:inline-block;width: 168px; height: 100%;box-sizing: border-box;max-width: 168;overflow: hidden;font-size: 11px;padding: 15px 0;">
		<table cellspacing="0" cellpadding="0" width="167">
			<tr valign="top">
				<td colspan="2" height="31" class="txtb" align="center">&nbsp;!weekDay!, !dateFormat!<span id="pax" class="txt" style="cursor: default;" onmouseover="this.className=\'txtbr\'; overlib(\'PAX: !adultCount! Adults, !childCount! Child<br />(Confirmed &amp; Provisional reservations)\',WIDTH,180,ABOVE,OFFSETY,5,LEFT);" onmouseout="this.className=\'txt\'; nd();">&nbsp;(!adultCount!A,!childCount!C)</span>&nbsp;<input type="button" class="button bRepDrop '.$GLOBALS['temp']['readOnlyClassHide'].'" style="width: 18px; padding-right: 10px;" onclick="showHide(event,\'\',\'!dateRaw!\');" onmouseover="overlib(\'Reports for: !weekDay!, !dateFormat!\',WIDTH,180,ABOVE,OFFSETY,5,LEFT);" onmouseout="nd();" /></td>
			</tr>
		</table>
	</div>
';

// [START] Security checks ----------------------------------------------------
$propertyDB = $GLOBALS['lDB']->get("
	SELECT
		rf_db_code
	FROM
		rf_db_business
	WHERE
		pr_business_id $propertyWhere
",4);

$allowedProps = $GLOBALS['lDB']->get("
	SELECT
		pr_business_id
	FROM
		rf_db_business
	WHERE
		rf_db_code = '" . $GLOBALS['dbcode'] . "'
",3);

$GLOBALS['temp']['allowCheckIn'] = "true";
$GLOBALS['temp']['allowCheckOut'] = "true";
$GLOBALS['temp']['allowRoomFunctions'] = "true";
$GLOBALS['temp']['allowedProps'] = !empty($allowedProps) ? "'" . join("','", $allowedProps) . "'" : "";

$calendarLevel = $lDB->get("select sc_fun_grp_level from sc_fun_group where sc_group_id = '" . $GLOBALS['sc_group_id'] . "' and sc_function_id = '81'",4);
$GLOBALS['temp']['allowMultiCheckout'] = $calendarLevel == 15 ? "true" : "false";

if($propertyDB != $GLOBALS['dbcode'] || $readonly) {
	$GLOBALS['temp']['allowCheckIn'] = "false";
	$GLOBALS['temp']['allowCheckOut'] = "false";
}
if($readonly) {
	$GLOBALS['temp']['allowRoomFunctions'] = "false";
}
// [ END ] Security checks ----------------------------------------------------

// [START] Generate date range ------------------------------------------------
$startDate = strtotime($fromDate['jsDate']);
$dateList = array();
$pax = $GLOBALS['lDB']->get("
	SELECT
		rv_reservation_item.rv_item_adult_count,
		rv_reservation_item.rv_item_child_count,
		rv_reservation_item.rv_item_accomm_count,
		rv_reservation_item.rv_item_date_arrive,
		rv_reservation_item.rv_item_date_depart,
		rv_reservation.rv_reservation_id
	FROM
		rv_reservation_item
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
	WHERE
		1
		$accommFilter[where]
		AND (
			(
				rv_reservation_item.rv_item_date_arrive >= '$fromDate[jsDate]'
				AND rv_reservation_item.rv_item_date_arrive <= '$toDate[jsDate]'
			) OR (
				rv_reservation_item.rv_item_date_depart >= '$fromDate[jsDate]'
				AND rv_reservation_item.rv_item_date_depart <= '$toDate[jsDate]'
			) OR (
				rv_reservation_item.rv_item_date_arrive < '$fromDate[jsDate]'
				AND rv_reservation_item.rv_item_date_depart > '$toDate[jsDate]'
			)
		) AND (
			rv_reservation.rf_reservation_status_id = '30'
			OR (
				rv_reservation.rf_reservation_status_id = '20'
				AND rv_reservation.rv_provision_expiry_date >= '" . date("Y-m-d") . "'
			)
		)
",2);
for($count = 0; $count < $days; $count++) {
	$currDate = $startDate + ( 86400 * $count );
	$weekDay = date("D",$currDate);
	$dateRaw = date("Y-m-d",$currDate);
	$dateFormat = date("d M y",$currDate);
	$paxLookup = array("adultCount"=>0,"childCount"=>0);
	foreach($pax as $item) {
		if($item['rv_item_date_arrive'] <= $dateRaw && $item['rv_item_date_depart'] > $dateRaw) {
			$paxLookup['adultCount'] += $item['rv_item_adult_count'] * $item['rv_item_accomm_count'];
			$paxLookup['childCount'] += $item['rv_item_child_count'] * $item['rv_item_accomm_count'];
		}
	}
	if ( $paxLookup['adultCount'] == "" ) {
		$paxLookup['adultCount'] = "0";
	}

	if($paxLookup['childCount'] == "") {
		$paxLookup['childCount'] = "0";
	}
	array_push($dateList,array('dateRaw'=>$dateRaw, 'dateFormat'=>$dateFormat, 'weekDay'=>$weekDay, 'adultCount'=>$paxLookup['adultCount'], 'childCount'=>$paxLookup['childCount']));
}

$headerRow ="";
foreach($dateList as $dateItem) {
	if($dateItem['weekDay'] == "Sun" || $dateItem['weekDay'] == "Sat") {
		$dateItem['headerClass'] = "colDk";
	} else {
		$dateItem['headerClass'] = "colLt";
	}
	$headerRow .= showpage($dateItem,$headerRowHTML);
}
$headerRow .= '<div class="bt bb br" style="display:inline-block;width: 168px; height: 100%;box-sizing: border-box;max-width: 168;overflow: hidden;font-size: 11px;padding: 15px 0;"></div>';

$GLOBALS['temp']['headerRow'] = $headerRow;

// [ END ] - Generate date range ----------------------------------------------

// [START] - Generate room list -----------------------------------------------
if($_SERVER['argv'][5] == "") {
	$defaultAccommSort = $GLOBALS['lDB']->get("SELECT rf_accomm_sort_ind FROM rf_default", 4);
} else {
	$defaultAccommSort = $_SERVER['argv'][5];
}

if($defaultAccommSort == 1) {
	$order = " pr_business.pr_bus_name_short,(ac_desc+0), ac_desc, ac_accomm_type.ac_accomm_sequence";
	$GLOBALS['temp']['accommSortTypeChecked'] = "";
	$GLOBALS['temp']['accommSortRoomChecked'] = "checked";
} else {
	$order = " pr_business.pr_bus_name_short,ac_accomm_type.ac_accomm_sequence, (ac_desc+0), ac_desc";
	$GLOBALS['temp']['accommSortTypeChecked'] = "checked";
	$GLOBALS['temp']['accommSortRoomChecked'] = "";
}
$roomList = $GLOBALS['lDB']->get("
	SELECT
		ac_accomm_room.ac_desc,
		ac_accomm_type.ac_accomm_desc,
		ac_accomm_type.ac_accomm_name_short,
		ac_accomm_room.ac_accomm_room_ix,
		ac_accomm_type.ac_accomm_sequence,
		pr_business.pr_bus_name_short,
		pr_persona.pr_name_last
	FROM
		ac_accomm_room
		INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
		INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
	WHERE
		1
		".str_replace("rv_reservation_item.ac_accomm_type_id","ac_accomm_type.ac_accomm_type_ix",$accommFilter['where'])."
		AND ac_accomm_room.ac_accomm_room_inactive_yn = '0'
	ORDER BY
		$order
",2);

$sort = array();
foreach($roomList as $key=>$value) {
	$sort['pr_bus_name_short'][$key]	= $value['pr_bus_name_short'];
	$sort['ac_desc'][$key]				= $value['ac_desc'];
	$sort['ac_accomm_sequence'][$key]	= $value['ac_accomm_sequence'];
}

if($defaultAccommSort == 1) {
	array_multisort(
		$sort['pr_bus_name_short'], SORT_ASC, SORT_NATURAL,
		$sort['ac_desc'], SORT_ASC, SORT_NATURAL,
		$sort['ac_accomm_sequence'], SORT_ASC, SORT_NATURAL,
		$roomList
	);
} else {
	array_multisort(
		$sort['pr_bus_name_short'], SORT_ASC, SORT_NATURAL,
		$sort['ac_accomm_sequence'], SORT_ASC, SORT_NATURAL,
		$sort['ac_desc'], SORT_ASC, SORT_NATURAL,
		$roomList
	);
}

/*switch($detailCount) {
case 1:
	$roomListHeight = 19; //4 + ($detailCount * 15);
	break;
case 2:
	$roomListHeight = 34; //4 + ($detailCount * 15);
	break;
case 3:
	$roomListHeight = 49; //4 + ($detailCount * 15);
	break;
}*/
$roomListHeight = 5 + ($detailCount * 15);
if($detailCount > 1) {
	$roomListHTML = '
		<tr valign="top" class="!attrClass!" !attrList! style="display:inline-block;height: '.$roomListHeight.'px;">
			<td width="83" class="colLtt bb br bl" id="room_!roomNum!" style="padding: 0 2px;height: '.($roomListHeight-1).'px;display: inline-block;width:79px;">
				<div style="height:'.($roomListHeight-1).'px; overflow: hidden;">
					<table width="79" cellpadding="0" cellspacing="0" border="0" style="table-layout: fixed;">
					<col width="79" />
					<tr>
						<td class="txtb" height="16" style="line-height: 16px;" nowrap><span style="white-space:nowrap;">Rm !ac_desc!</span></td>
					</tr>
					<tr>
						<td>!property!!ac_accomm_name_short!</td>
					</tr>
					</table>
				</div>
			</td>
		</tr>
	';
} else {
	$roomListHTML = '
		<tr valign="top" class="!attrClass!" !attrList! style="display:inline-block;height: '.$roomListHeight.'px;">
			<td width="83" class="colLtt bb br bl" id="room_!roomNum!" style="padding: 0 2px;height: '.($roomListHeight-1).'px;display: inline-block;width:79px;">
				<table width="79" cellpadding="0" cellspacing="0" border="0" style="table-layout: fixed;">
				<col width="79" />
				<tr>
					<td class="txtb" height="16" style="line-height: 16px;" nowrap><span style="white-space:nowrap;">!property_short!Rm!ac_desc_short!-!ac_accomm_name_short!</span></td>
				</tr>
				</table>
			</td>
		</tr>
	';
}

$roomRows = "";
foreach($roomList as $roomItem) {
	$attrList = $GLOBALS['lDB']->get("
		SELECT
			rt_component.rt_component_desc
		FROM
			ac_accomm_room_attr
			INNER JOIN rt_component ON rt_component.rt_component_ix = ac_accomm_room_attr.rt_component_id
		WHERE
			ac_accomm_room_attr.ac_accomm_room_id = '" . $roomItem['ac_accomm_room_ix'] . "'
	",3);

	if ( sizeof($attrList) > 0 ) {
		$roomItem['attrList'] = " onmouseout=\"nd();\" onmouseover=\"overlib('<b>Attributes</b><br />" . join("<br />",$attrList) . "');\" onclick=\"roomAttributePopupShow(event,this,'" . $roomItem['ac_accomm_desc'] . "-" .	$roomItem['ac_desc'] . "','" . join("<br />",$attrList) . "');\"";
		$roomItem['attrClass'] = "imgLink";
	} else {
		$roomItem['attrList'] = "";
		$roomItem['attrClass'] = "";
	}
	if($propertyCount > 1) {
		$roomItem['property'] = $roomItem['pr_bus_name_short'] . " - ";
		$roomItem['property_short'] = $roomItem['pr_bus_name_short'] . "-";
	} else {
		$roomItem['property'] = "";
		$roomItem['property_short'] = "";
	}

	preg_match("/(\d+)/",$roomItem['ac_desc'],$matches);
	$matches = array_pad($matches,2,"");
	$roomNumber = trim($matches[1]);
	if(empty($roomNumber)) { // revert to full names if no number is found
		$roomNumber = $roomItem['ac_desc'];
	}
	$roomItem['ac_desc_short'] = $roomNumber;

	$roomRows .= showpage($roomItem,$roomListHTML);
}
$roomRows .= '
	<tr valign="top" class="!attrClass!" !attrList! style="height: '.$roomListHeight.'px;">
		<td width="83" class="colLtt bb br bl" id="room_!roomNum!" style="padding: 0 2px;">&nbsp;</td>
	</tr>
';

$GLOBALS['temp']['roomRows'] = $roomRows;
// [ END ] - Generate room list -----------------------------------------------

$roomData = $GLOBALS['lDB']->get("
	SELECT
		rv_reservation.rv_reservation_ix,
		rv_reservation.rv_res_name,
		rv_reservation.rv_agent_ref,
		rv_reservation.rf_reservation_status_id,
		rv_reservation.rv_provision_expiry_date,
		rv_reservation.rv_date_changed,
		rv_reservation_item.rv_item_adult_count,
		rv_reservation_item.rv_item_child_count,
		rv_res_item_group.ac_accomm_room_id,
		rv_res_item_group.rv_grp_status_ind,
		rv_res_item_group.rv_room_requested_yn,
		rv_res_item_group.rv_room_request_reason,
		rv_reservation_item.rv_item_date_arrive,
		rv_reservation_item.rv_item_date_depart,
		rv_reservation_item.rv_reservation_item_ix,
		rv_res_item_group.rv_res_item_group_ix as rv_res_item_group_id,
		rv_res_item_group.rv_grp_status_time,
		rv_res_item_group.rv_grp_accomm_overide_yn,
		rv_res_item_group.rv_grp_date_allocated,
		ac_accomm_type.pr_business_id AS prop
	FROM
		rv_res_item_group
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
		INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		LEFT JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
	WHERE
		rv_reservation_item.rv_item_date_arrive <= '$toDate[jsDate]'
		AND (
			rv_reservation_item.rv_item_date_depart >= '$fromDate[jsDate]'
			OR (
				rv_res_item_group.rv_grp_status_ind = '5'
			) OR (
				rv_res_item_group.rv_grp_status_ind = '8'
				AND rv_res_item_group.rv_grp_status_time >= '$fromDate[jsDate] 00:00:00'
				AND rv_res_item_group.rv_grp_status_time <= '$toDate[jsDate] 23:59:59'
			)
		)
		$accommFilter[where]
",2);

$dateData = array();
foreach($dateList as $dateKey=>$dateItem) {
	$arrival = array();
	$departure = array();
	$stayover = array();
	foreach($roomData as $item) {
		if($item['rv_item_date_arrive'] == $dateItem['dateRaw']) {
			array_push($arrival,$item);
		} else if(
			(
				$item['rv_grp_status_ind'] == "5"
				&& (
					(
						$item['rv_item_date_depart'] <= date("Y-m-d")
						&& $dateItem['dateRaw'] == date("Y-m-d")
					) || (
						$item['rv_item_date_depart'] > date("Y-m-d")
						&& $item['rv_item_date_depart'] == $dateItem['dateRaw']
					)
				)
			) || (
				$item['rv_grp_status_ind'] == "2" && $item['rv_item_date_depart'] == $dateItem['dateRaw']
			) || (
				$item['rv_grp_status_ind'] == "8"
				&& $item['rv_grp_status_time'] == "$item[rv_item_date_arrive] 00:00:00"
				&& $item['rv_item_date_depart'] == $dateItem['dateRaw']
			) || (
				$item['rv_grp_status_ind'] == "8"
				&& $item['rv_grp_status_time'] >= "$dateItem[dateRaw] 00:00:00"
				&& $item['rv_grp_status_time'] <= "$dateItem[dateRaw] 23:59:59"
			)
		) {
			array_push($departure,$item);
		} else if(
			$item['rv_item_date_arrive'] < $dateItem['dateRaw']
			&& (
				(
					$item['rv_grp_status_ind'] == "5"
					&& $dateItem['dateRaw'] < date("Y-m-d")
				) || (
					$item['rv_grp_status_ind'] != "8"
					&& $item['rv_item_date_depart'] > $dateItem['dateRaw']
				) || (
					$item['rv_grp_status_ind'] == "8"
					&& $item['rv_grp_status_time'] == "$item[rv_item_date_arrive] 00:00:00"
					&& $item['rv_item_date_depart'] > $dateItem['dateRaw']
				) || (
					$item['rv_grp_status_ind'] == "8"
					&& $item['rv_grp_status_time'] > "$dateItem[dateRaw] 23:59:59"
				)
			)
		) {
			array_push($stayover,$item);
		}
	}

	$dateData[$dateKey] = array("arrival"=>$arrival,"departure"=>$departure,"stayover"=>$stayover);
}

$roomingData = array();
foreach($roomList as $roomItem) {
	$roomingItems = array();
	foreach($dateList as $dateKey=>$dateItem) {
		// Get any arrivals ---------------------------------------------------------
		$arrival = array();
		foreach($dateData[$dateKey]['arrival'] as $item) {
			if($item['ac_accomm_room_id'] == $roomItem['ac_accomm_room_ix']) {
				$check = $GLOBALS['lDB']->get("
					SELECT
						COUNT(*)
					FROM
						rv_reservation_item
					WHERE
						rv_reservation_item.rv_reservation_id = '$item[rv_reservation_ix]'
						AND rv_reservation_item.rv_item_date_depart = '$item[rv_item_date_arrive]'
				",4);

				if ( $check > 0 ) {
					$item['hasDepart'] = true;
				} else {
					$item['hasDepart'] = false;
				}

				$canCheckIn = $GLOBALS['lDB']->get("
					SELECT
						COUNT(*)
					FROM
						rv_res_item_group
					WHERE
						rv_res_item_group.rv_res_item_group_ix != '$item[rv_res_item_group_id]'
						AND rv_res_item_group.ac_accomm_room_id = '$item[ac_accomm_room_id]'
						AND rv_res_item_group.rv_grp_status_ind = '5'
				",4);

				if ( $canCheckIn > 0 ) {
					$item['canCheckIn'] = false;
				} else {
					$item['canCheckIn'] = true;
				}

				$item['rv_res_name_js'] = t_encodeOverlib($item['rv_res_name']);
				$item['rv_agent_ref_js'] = t_encodeOverlib($item['rv_agent_ref']);

				array_push($arrival,$item);
			}
		}
		$departure = array();
		foreach($dateData[$dateKey]['departure'] as $item) {
			if($item['ac_accomm_room_id'] == $roomItem['ac_accomm_room_ix']) {
				$check = $GLOBALS['lDB']->get("
					SELECT
						COUNT(*)
					FROM
						rv_reservation_item
					WHERE
						rv_reservation_item.rv_reservation_id = '$item[rv_reservation_ix]'
						AND rv_reservation_item.rv_item_date_arrive = '$item[rv_item_date_depart]'
				",4);
				if($check > 0) {
					$item['hasArrive'] = true;
				} else {
					$item['hasArrive'] = false;
				}
				$canCheckIn = $GLOBALS['lDB']->get("
					SELECT
						COUNT(*)
					FROM
						rv_res_item_group
					WHERE
						rv_res_item_group.rv_res_item_group_ix != '$item[rv_res_item_group_id]'
						AND rv_res_item_group.ac_accomm_room_id = '$item[ac_accomm_room_id]'
						AND rv_res_item_group.rv_grp_status_ind = '5'
				",4);
				if($canCheckIn > 0) {
					$item['canCheckIn'] = false;
				} else {
					$item['canCheckIn'] = true;
				}
				$item['rv_res_name_js'] = t_encodeOverlib($item['rv_res_name']);
				$item['rv_agent_ref_js'] = t_encodeOverlib($item['rv_agent_ref']);

				array_push($departure,$item);
			}
		}
		$stayover = array();
		foreach($dateData[$dateKey]['stayover'] as $item) {
			if($item['ac_accomm_room_id'] == $roomItem['ac_accomm_room_ix']) {
				$canCheckIn = $GLOBALS['lDB']->get("
					SELECT
						COUNT(*)
					FROM
						rv_res_item_group
					WHERE
						rv_res_item_group.rv_res_item_group_ix != '$item[rv_res_item_group_id]'
						AND rv_res_item_group.ac_accomm_room_id = '$item[ac_accomm_room_id]'
						AND rv_res_item_group.rv_grp_status_ind = '5'
				",4);
				if($canCheckIn > 0) {
					$item['canCheckIn'] = false;
				} else {
					$item['canCheckIn'] = true;
				}
				$item['rv_res_name_js'] = t_encodeOverlib($item['rv_res_name']);
				$item['rv_agent_ref_js'] = t_encodeOverlib($item['rv_agent_ref']);

				array_push($stayover,$item);
			}
		}

		$block = $GLOBALS['lDB']->get("
			SELECT
				COUNT(*)
			FROM
				ac_accomm_room_block
				INNER JOIN ac_accomm_block ON ac_accomm_block.ac_accomm_block_ix = ac_accomm_room_block.ac_accomm_block_id
			WHERE
				ac_accomm_room_block.ac_accomm_room_id = '" . $roomItem['ac_accomm_room_ix'] . "'
				AND ac_accomm_block.ac_start_date <= '" . $dateItem['dateRaw'] . "'
				AND ac_accomm_block.ac_end_date > '" . $dateItem['dateRaw'] . "'
		",4);

		$roomingItems[$dateItem['dateRaw']] =	array('arrive'=>$arrival, 'depart'=>$departure, 'stayover'=>$stayover, 'weekDay'=>$dateItem['weekDay'], 'block'=>$block);
	}
	$roomingItems = array_merge($roomingItems,$roomItem);
	$roomingData[$roomItem['ac_accomm_room_ix']] = $roomingItems;
}

// [START] HTML ---------------------------------------------------------------
$calCellHeight = $detailCount * 15;
$roomCellCount = 0;
$roomCellArray = array();
$resColourCount = 0;
$resColourArray = array();
if($renderMode == "html") {
	$calendarRows = "";
	foreach($roomingData as $roomingItems) {
		$calWidth = 168*$days;
		$calendarRows .= '
					<div id="tblCalendarRows" style="display: block; width: '.$calWidth.'px; height: '.$roomListHeight.'px; max-height: ' . $roomListHeight . 'px; box-sizing: border-box; font-size: 0px;">
		';
		$resItemList = array();
		foreach($roomingItems as $date=>$item) {
			if(!is_array($item)) {
				continue;
			}
			$calendarRows .= '
						<div class="bb br" style="display: inline-block; height: '.$roomListHeight.'px; width: 168px; max-width: 168px; box-sizing: border-box; font-size: 11px; overflow: hidden;">
							<table width="168" border="0" cellpadding="0" cellspacing="0" style="table-layout: fixed;">
								<col width="84" />
								<col width="84" />
			';
			$cellColour = "";
			$conflictCheck = (sizeof($item['stayover']) + sizeof($item['arrive'])) > 1 || (sizeof($item['stayover']) + sizeof($item['depart'])) > 1;
			$conflictArray = array();

			if($conflictCheck) {
				foreach($item['stayover'] as $conflictItem) {
					array_push($conflictArray,$conflictItem);
				}
				foreach($item['arrive'] as $conflictItem) {
					array_push($conflictArray,$conflictItem);
				}
				foreach($item['depart'] as $conflictItem) {
					array_push($conflictArray,$conflictItem);
				}
			}

			if(sizeof($item['stayover']) > 0) { // Generate stayover cell
				$resItem = $item['stayover'][0];
				$resClass = "";
				$resBackground = "";
				$cellColour = "#fff";
				$cellClass =	getCellClass($resItem['rv_item_date_arrive'], $resItem['rv_item_date_depart'], $resItem['rv_grp_status_ind'],$resItem['rv_grp_status_time'],$resItem['rf_reservation_status_id']);
				if( ( $resItem['rv_item_date_depart'] < date("Y-m-d") ) || ( $resItem['rv_grp_status_ind'] > 5 && $resItem['rv_item_date_depart'] == date("Y-m-d") ) ) {
					$isPast = true;
				} else {
					$isPast = false;
				}
				//$cellColour = "#FFFFFF";
				if(isset($resColourArray[$resItem['rv_reservation_ix']])) {
					$cellColour = $resHTMLColour[$resColourArray[$resItem['rv_reservation_ix']]];
				} else {
					$cellColour = "";
				}
				/*
				if($item['weekDay'] == "Sun" || $item['weekDay'] == "Sat") {
					$cellColour = "#E5D199";
				}
					*/
				if($item['block'] > 0) {
					$cellColour = "#ccc";
				}
				if($resItem['rf_reservation_status_id'] == "20") {
					$resClass .= " u";
					if($resItem['rv_provision_expiry_date'] == date("Y-m-d")) {
						$resBackground = "#F1C55D";
					}
					if($resItem['rv_provision_expiry_date'] < date("Y-m-d")) {
						$resBackground = "#DB4242";
					}
				}
				if(isset($resColourArray[$resItem['rv_reservation_ix']])) {
					$fontColour = "#000";
					$cellColour = $resHTMLColour[$resColourArray[$resItem['rv_reservation_ix']]];
				} else {
					$resColourArray[$resItem['rv_reservation_ix']] = $resColourCount;
					$fontColour = "#000";
					$cellColour = $resHTMLColour[$resColourArray[$resItem['rv_reservation_ix']]];
					$resColourCount++;
					if($resColourCount >= sizeof($resHTMLColour)) {
						$resColourCount = 0;
					}
				}
				$fontColourOverride = "";
				if($isPast) {
					$fontColour = "#8a7a75";
					$fontColourOverride = "#8a7a75";
				}
				$guestNames = getGuestNames($resItem['rv_res_item_group_id']);
				if ( $conflictCheck && (!in_array($item['stayover'][0]['rv_reservation_item_ix'],$resItemList)|| $date == $toDate['jsDate']) ) {
					$guestNames = "";
					foreach ( $conflictArray as $conflictItem ) {
						if ( $conflictItem['rv_res_item_group_id'] == $resItem['rv_res_item_group_id'] ) {
							continue;
						}
						if ( $guestNames != "" ) {
							$guestNames .= ", ";
						}
						$canCheck = "false";
						$roomCellCount++;
						if(!isset($roomCellArray[$conflictItem['rv_res_item_group_id']])) { $roomCellArray[$conflictItem['rv_res_item_group_id']] = array(); }
						array_push($roomCellArray[$conflictItem['rv_res_item_group_id']],$roomCellCount);

						$guestNames .= "<span id=\"roomCell_" . $roomCellCount . "\" resId=\"" . $conflictItem['rv_reservation_ix'] . "\" resName=\"" . $conflictItem['rv_res_name_js'] . "\" prop=\"" . $conflictItem['prop'] . "\" agentRef=\"" . $conflictItem['rv_agent_ref_js'] . "\" class=\"imgLink txtred\" onclick=\"selectCell(this,'" . $conflictItem['rv_reservation_ix'] . "','" . $conflictItem['rv_reservation_item_ix'] . "','" . $conflictItem['rv_res_item_group_id'] . "','" . $conflictItem['ac_accomm_room_id'] . "'," . $conflictItem['rv_grp_status_ind'] . ",$canCheck); event.cancelBubble = true;\">" . $conflictItem['rv_reservation_ix'] . "</span>";
					}
					$guestNames = "<span class=\"txtred\">" . $guestNames . "</span>";
				}

				$calendarRows .= '<tr><td colspan="2" class="' . $cellClass . '"><img src="/resource/Resrequest/Application/public/img/1x1.gif" width="1" height="3" alt="" /></td></tr>';

				$resItem['rv_reservation_ix_fmt'] = $resItem['rv_reservation_ix'];

				if ( $resItem['rv_date_changed'] >= $changeDate ) {
					$resItem['rv_reservation_ix_fmt'] = $resItem['rv_reservation_ix_fmt'];
					$resClass .= " txti";
				}
				$canCheck = "true";
				if(date("Y-m-d") < $resItem['rv_item_date_arrive'] || date("Y-m-d") > $resItem['rv_item_date_depart'] || !allowItemCheckIn($resItem) || !$resItem['canCheckIn']) {
					$canCheck = "false";
				}
				if ( !in_array($item['stayover'][0]['rv_reservation_item_ix'],$resItemList) || $date == $toDate['jsDate'] ) {
					if ( $resItem['rv_room_requested_yn'] != "0" ) {
						$resHover = ' onmouseover="overlib(\'' . t_encodeOverlib($resItem['rv_room_request_reason']) . '\');" onmouseout="nd();" ';
						$resClass .= ' txtb imgLink';
					} else {
						$resHover = '';
					}
					$roomCellCount++;

					if ( !isset($roomCellArray[$resItem['rv_res_item_group_id']]) ) {
						$roomCellArray[$resItem['rv_res_item_group_id']] = array();
					}
					array_push($roomCellArray[$resItem['rv_res_item_group_id']],$roomCellCount);

					if ( $resItem['rv_grp_accomm_overide_yn'] == "1" ) {
						$upgradeDate = chng_date($resItem['rv_grp_date_allocated'],"-");
						$upgradeSpan = '<span class="txtb" style="background-color: ' . (isset($bgColour) ? $bgColour : "") . '; color: ' . $fontColour . ';" onmouseout="nd();" onmouseover="overlib(\'Upgrade to [' . $roomingItems['ac_accomm_desc'] . ']: ' . $upgradeDate . '\');">/U</span>';
					} else {
						$upgradeSpan = '';
					}
					if($showResNum == 1) {
						$resNumCell = '
									<tr style="height: 15px;">
										<td style="background-color: ' . $resBackground . '; color: ' . $fontColourOverride . ';"><span ' . $resHover . ' class="' . $resClass . '" style="color: ' . $fontColour . ';">' . $resItem['rv_reservation_ix_fmt'] . $upgradeSpan . '</span>-' . $resItem['rv_item_adult_count'] . ',' . $resItem['rv_item_child_count'] . '</td>
									</tr>
						';
					} else {
						$resNumCell = '';
					}
					if($showResName == 1) {
						$resNameCell = '
									<tr style="height: 15px;">
										<td style="color: ' . $fontColourOverride . ';"><span style="white-space: nowrap">' . $resItem['rv_res_name'] . '</span><</td>
									</tr>
						';
					} else {
						$resNameCell = '';
					}
					if($showGuestName == 1) {
						$guestNameCell = '
									<tr style="height: 15px;">
										<td style="color: ' . $fontColourOverride . ';"><span style="white-space: nowrap">' . $guestNames . '</span></td>
									</tr>
						';
					} else {
						$guestNameCell = '';
					}
					$calendarRows .= '
						<tr valign="top" class="imgLink">
							<td id="roomCell_' . $roomCellCount . '" resId="' . $resItem['rv_reservation_ix'] . '" resName="' . $resItem['rv_res_name_js'] . '" prop="' . $resItem['prop'] . '" agentRef="' . $resItem['rv_agent_ref_js'] . '" colspan="2" style="background-color: ' . $cellColour . '" onclick="selectCell(this,\'' . $resItem['rv_reservation_ix'] . '\',\'' . $resItem['rv_reservation_item_ix'] . '\',\'' . $resItem['rv_res_item_group_id'] . '\',\'' . $resItem['ac_accomm_room_id'] . '\',' . $resItem['rv_grp_status_ind'] . ',' . $canCheck . ');">
								<table width="168" border="0" cellpadding="0" cellspacing="0" style="table-layout: fixed;">
									<col width="168" />
									'.$resNumCell.'
									'.$resNameCell.'
									'.$guestNameCell.'
								</table>
							</td>
						</tr>
					';
				} else {
					$cellColour = $resHTMLColour[$resColourArray[$resItem['rv_reservation_ix']]];

					if ( $item['block'] > 0 ) {
						$cellColour = "#ccc";
					}

					$roomCellCount++;
					if ( !is_array($roomCellArray[$resItem['rv_res_item_group_id']]) ) {
						$roomCellArray[$resItem['rv_res_item_group_id']] = array();
					}
					array_push($roomCellArray[$resItem['rv_res_item_group_id']],$roomCellCount);

					if($showResNum == 1) {
						$resNumCell = '
									<tr style="height: 15px;">
										<td style="background-color: ' . $resBackground . ';">&nbsp;</td>
									</tr>
						';
					} else {
						$resNumCell = '';
					}
					if($showResName == 1) {
						$resNameCell = '
									<tr style="height: 15px;">
										<td>&nbsp;</td>
									</tr>
						';
					} else {
						$resNameCell = '';
					}
					if($showGuestName == 1) {
						$guestNameCell = '
									<tr style="height: 15px;">
										<td>&nbsp;</td>
									</tr>
						';
					} else {
						$guestNameCell = '';
					}

					$calendarRows .= '
						<tr valign="top" class="' . $cellClass . ' imgLink">
							<td id="roomCell_' . $roomCellCount . '" resId="' . $resItem['rv_reservation_ix'] . '" resName="' . $resItem['rv_res_name_js'] . '" prop="' . $resItem['prop'] . '" agentRef="' . $resItem['rv_agent_ref_js'] . '" colspan="2" style="background-color: ' . $cellColour . '" onclick="selectCell(this,\'' . $resItem['rv_reservation_ix'] . '\',\'' . $resItem['rv_reservation_item_ix'] . '\',\'' . $resItem['rv_res_item_group_id'] . '\',\'' . $resItem['ac_accomm_room_id'] . '\',' . $resItem['rv_grp_status_ind'] . ',' . $canCheck . ');">
								<table width="168" border="0" cellpadding="0" cellspacing="0" style="table-layout: fixed;">
									<col width="168" />
									'.$resNumCell.'
									'.$resNameCell.'
									'.$guestNameCell.'
								</table>
							</td>
						</tr>
					';
				}
				array_push($resItemList,$item['stayover'][0]['rv_reservation_item_ix']);
			} else { // Generate arrive / depart cell
				if(sizeof($item['arrive']) > 0) {
					$resItem = $item['arrive'][0];
					$resClass = "";
					$resBackground = "";
					$cellColour = "";
					$cellClass =	getCellClass($resItem['rv_item_date_arrive'], $resItem['rv_item_date_depart'], $resItem['rv_grp_status_ind'],$resItem['rv_grp_status_time'],$resItem['rf_reservation_status_id']);

					if ( ( $resItem['rv_item_date_depart'] < date("Y-m-d") ) || ( $resItem['rv_grp_status_ind'] > 5 && $resItem['rv_item_date_depart'] == date("Y-m-d") ) ) {
						$isPast = true;
					} else {
						$isPast = false;
					}

					if(isset($resColourArray[$resItem['rv_reservation_ix']])) {
						$cellColour = $resHTMLColour[$resColourArray[$resItem['rv_reservation_ix']]];
					} else {
						$cellColour = "";
					}

					if ( $item['block'] > 0 ) {
						$cellColour = "#ccc";
					}

					if ( $resItem['rf_reservation_status_id'] == "20" ) {
						$resClass .= " u";
						if ( $resItem['rv_provision_expiry_date'] == date("Y-m-d") ) {
							$resBackground = "#f1c55d";
						}
						if ( $resItem['rv_provision_expiry_date'] < date("Y-m-d") ) {
							$resBackground = "#db4242";
						}
					}

					if (isset($resColourArray[$resItem['rv_reservation_ix']])) {
						$fontColour = "#000";
						$cellColour = $resHTMLColour[$resColourArray[$resItem['rv_reservation_ix']]];
					} else {
						$resColourArray[$resItem['rv_reservation_ix']] = $resColourCount;
						$fontColour = "#000";
						$cellColour = $resHTMLColour[$resColourArray[$resItem['rv_reservation_ix']]];
						$resColourCount++;

						if ( $resColourCount >= sizeof($resHTMLColour) ) {
							$resColourCount = 0;
						}
					}

					$fontColourOverride = "";
					if ( $isPast ) {
						$fontColour = "#8a7a75";
						$fontColourOverride = "#8a7a75";
					}

					$guestNames = getGuestNames($resItem['rv_res_item_group_id']);
					if ( $conflictCheck ) {
						$guestNames = '';
						foreach ( $conflictArray as $conflictItem ) {
							if ( $conflictItem['rv_res_item_group_id'] == $resItem['rv_res_item_group_id']) {
								continue;
							}

							if ( $guestNames != "" ) {
								$guestNames .= ", ";
							}

							$canCheck = "false";
							$roomCellCount++;

							if (!isset($roomCellArray[$conflictItem['rv_res_item_group_id']]) || !is_array($roomCellArray[$conflictItem['rv_res_item_group_id']]) ) {
								$roomCellArray[$conflictItem['rv_res_item_group_id']] = array();
							}

							array_push($roomCellArray[$conflictItem['rv_res_item_group_id']],$roomCellCount);

							$guestNames .= '<span id="roomCell_' . $roomCellCount . '" resId="' . $conflictItem['rv_reservation_ix'] . '" resName="' . $conflictItem['rv_res_name_js'] . '" prop="' . $conflictItem['prop'] . '" agentRef="' . $conflictItem['rv_agent_ref_js'] . '" class="imgLink txtred" onclick="selectCell(this,\'' . $conflictItem['rv_reservation_ix'] . '\',\'' . $conflictItem['rv_reservation_item_ix'] . '\',\'' . $conflictItem['rv_res_item_group_id'] . '\',\'' . $conflictItem['ac_accomm_room_id'] . '\',' . $conflictItem['rv_grp_status_ind'] . ',' . $canCheck . '); event.cancelBubble=true;">' . $conflictItem['rv_reservation_ix'] . '</span>';
						}
						$guestNames = '<span class="txtred">' . $guestNames . '</span>';
					}

					if ( $guestNames == '' ) {
						$guestNames = '&nbsp;';
					}

					$resItem['rv_reservation_ix_fmt'] = $resItem['rv_reservation_ix'];

					if ( $resItem['rv_date_changed'] >= $changeDate ) {
						$resItem['rv_reservation_ix_fmt'] = $resItem['rv_reservation_ix_fmt'];
						$resClass .= " txti";
					}

					$arriveTopHTML = '<td class="' . $cellClass . '"><img src="/resource/Resrequest/Application/public/img/1x1.gif" width="1" height="3" alt="" /></td>';
					if ( $resItem['rv_room_requested_yn'] != "0" ) {
						$resHover = ' onmouseover="overlib(\'' . t_encodeOverlib($resItem['rv_room_request_reason']) . '\');" onmouseout="nd();" ';
						$resClass .= ' txtb imgLink';
					} else {
						$resHover = '';
					}

					$canCheck = 'true';
					if ( date("Y-m-d") < $resItem['rv_item_date_arrive'] || date("Y-m-d") > $resItem['rv_item_date_depart']|| !allowItemCheckIn($resItem) || !$resItem['canCheckIn'] ) {
						$canCheck = 'false';
					}

					$roomCellCount++;

					if ( !isset($roomCellArray[$resItem['rv_res_item_group_id']]) ) {
						$roomCellArray[$resItem['rv_res_item_group_id']] = array();
					}

					array_push($roomCellArray[$resItem['rv_res_item_group_id']],$roomCellCount);

					if ( $resItem['rv_grp_accomm_overide_yn'] == "1" ) {
						$upgradeDate = chng_date($resItem['rv_grp_date_allocated'],"-");
						$upgradeSpan = '<span class="txtb" style="color: ' . $fontColour . ';" onmouseout="nd();" onmouseover="overlib(\'Upgrade to [' . $roomingItems['ac_accomm_desc'] . ']: ' . $upgradeDate . '\');">/U</span>';
					} else {
						$upgradeSpan = '';
					}

					$arrivePointer = '&gt;&gt;';
					if ( $resItem['hasDepart'] ) {
						$arrivePointer = '&gt;';
					}

					if($showResNum == 1) {
						$resNumCell = '
								<tr style="height: 15px;">
									<td style="background-color: ' . $resBackground . '; color: ' . $fontColourOverride . ';">
										<strong>' . $arrivePointer . '</strong><span ' . $resHover . ' class="' . $resClass . '" style="color: ' . $fontColour . ';">' . $resItem['rv_reservation_ix_fmt'] . $upgradeSpan . '</span>-' . $resItem['rv_item_adult_count'] . ',' . $resItem['rv_item_child_count'] . '<br />
									</td>
								</tr>
						';
					} else {
						$resNumCell = '';
					}
					if($showResName == 1) {
						$resNameCell = '
								<tr style="height: 15px;">
									<td style="color: ' . $fontColourOverride . ';"><span style="white-space: nowrap">' . $resItem['rv_res_name'] . '</span></td>
								</tr>
						';
					} else {
						$resNameCell = '';
					}
					if($showGuestName == 1) {
						$guestNameCell = '
								<tr style="height: 15px;">
									<td style="color: ' . $fontColourOverride . ';"><span style="white-space: nowrap">' . $guestNames . '</span></td>
								</tr>
						';
					} else {
						$guestNameCell = '';
					}

					$arriveHTML = '
						<td id="roomCell_' . $roomCellCount . '" resId="' . $resItem['rv_reservation_ix'] . '" resName="' . $resItem['rv_res_name_js'] . '" prop="' . $resItem['prop'] . '" agentRef="' . $resItem['rv_agent_ref_js'] . '" style="background-color: ' . $cellColour . '" onclick="selectCell(this,\'' . $resItem['rv_reservation_ix'] . '\',\'' . $resItem['rv_reservation_item_ix'] . '\',\'' . $resItem['rv_res_item_group_id'] . '\',\'' . $resItem['ac_accomm_room_id'] . '\',' . $resItem['rv_grp_status_ind'] . ',' . $canCheck . ');" class="imgLink">
							<table width="84" border="0" cellpadding="0" cellspacing="0" style="table-layout: fixed;">
							<col width="84" />
							'.$resNumCell.'
							'.$resNameCell.'
							'.$guestNameCell.'
							</table>
						</td>
					';
					array_push($resItemList,$item['arrive'][0]['rv_reservation_item_ix']);
				} else {
					$cellColour = "#fff";

					if ( $item['weekDay'] == "Sun" || $item['weekDay'] == "Sat" ) {
						$cellColour = "#dbe1ef";
					}

					if ( $item['block'] > 0 ) {
						$cellColour = "#ccc";
					}

					$arriveTopHTML	= '<td style="background-color: ' . $cellColour . '"><img src="/resource/Resrequest/Application/public/img/1x1.gif" width="1" height="3" alt="" /></td>';
					$arriveHTML			= '<td style="background-color: ' . $cellColour . '"><img src="/resource/Resrequest/Application/public/img/1x1.gif" width="84" height="'.$calCellHeight.'" alt="" /></td>';
				}

				if ( sizeof($item['depart']) > 0 ) {
					$resItem = $item['depart'][0];
					$resClass = "";
					$resBackground = "";
					$cellColour = "";
					$cellClass =	getCellClass($resItem['rv_item_date_arrive'], $resItem['rv_item_date_depart'], $resItem['rv_grp_status_ind'],$resItem['rv_grp_status_time'],$resItem['rf_reservation_status_id']);

					if ( ( $resItem['rv_item_date_depart'] < date("Y-m-d") ) || ( $resItem['rv_grp_status_ind'] > 5 && $resItem['rv_item_date_depart'] == date("Y-m-d") ) ) {
						$isPast = true;
					} else {
						$isPast = false;
					}
					if(isset($resColourArray[$resItem['rv_reservation_ix']])) {
						$cellColour = $resHTMLColour[$resColourArray[$resItem['rv_reservation_ix']]];
					} else {
						$cellColour = "";
					}

					if ( $item['block'] > 0 ) {
						$cellColour = "#ccc";
					}

					if ( $resItem['rf_reservation_status_id'] == "20" ) {
						$resClass .= " u";
						if ( $resItem['rv_provision_expiry_date'] == date("Y-m-d") ) {
							$resBackground = "#f1c55d";
						}

						if ( $resItem['rv_provision_expiry_date'] < date("Y-m-d") ) {
							$resBackground = "#db4242";
						}
					}

					if(isset($resColourArray[$resItem['rv_reservation_ix']])) {
						$fontColour	= "#000";
						$bgColour		= $resHTMLColour[$resColourArray[$resItem['rv_reservation_ix']]];
						$cellColour	= $resHTMLColour[$resColourArray[$resItem['rv_reservation_ix']]];
					} else {
						$resColourArray[$resItem['rv_reservation_ix']] = $resColourCount;
						$fontColour	= "#000";
						$bgColour		= $resHTMLColour[$resColourArray[$resItem['rv_reservation_ix']]];
						$cellColour	= $resHTMLColour[$resColourArray[$resItem['rv_reservation_ix']]];
						$resColourCount++;

						if ( $resColourCount >= sizeof($resHTMLColour) ) {
							$resColourCount = 0;
						}
					}
					$fontColourOverride = "";
					if ( $isPast ) {
						$fontColour = "#8a7a75";
						$fontColourOverride = "#8a7a75";
					}

					$guestNames = getGuestNames($resItem['rv_res_item_group_id']);
					if ( $conflictCheck ) {
						$guestNames = '';
						foreach($conflictArray as $conflictItem) {
							if($conflictItem['rv_res_item_group_id'] == $resItem['rv_res_item_group_id']) { continue; }
							if($guestNames != "") {
								$guestNames .= ", ";
							}
							$canCheck = "false";
							$roomCellCount++;
							if(!isset($roomCellArray[$conflictItem['rv_res_item_group_id']]) || !is_array($roomCellArray[$conflictItem['rv_res_item_group_id']])) { $roomCellArray[$conflictItem['rv_res_item_group_id']] = array(); }
							array_push($roomCellArray[$conflictItem['rv_res_item_group_id']],$roomCellCount);
							$guestNames .= "<span id=\"roomCell_" . $roomCellCount . "\" resId=\"" . $conflictItem['rv_reservation_ix'] . "\" resName=\"" . $conflictItem['rv_res_name_js'] . "\" prop=\"" . $conflictItem['prop'] . "\" agentRef=\"" . $conflictItem['rv_agent_ref_js'] . "\" class=\"imgLink txtred\" onclick=\"selectCell(this,'" . $conflictItem['rv_reservation_ix'] . "','" . $conflictItem['rv_reservation_item_ix'] . "','" . $conflictItem['rv_res_item_group_id'] . "','" . $conflictItem['ac_accomm_room_id'] . "'," . $conflictItem['rv_grp_status_ind'] . "," . $canCheck . "); event.cancelBubble = true;\">" . $conflictItem['rv_reservation_ix'] . "</span>";
						}
						$guestNames = '<span class="txtred">' . $guestNames . '</span>';
					}

					if ( $guestNames == '' ) {
						$guestNames = '&nbsp;';
					}

					$resItem['rv_reservation_ix_fmt'] = $resItem['rv_reservation_ix'];
					if($resItem['rv_date_changed'] >= $changeDate) {
						$resItem['rv_reservation_ix_fmt'] = $resItem['rv_reservation_ix_fmt'];
						$resClass .= " txti";
					}

					$departTopHTML = '<td class="' . $cellClass . '"><img src="/resource/Resrequest/Application/public/img/1x1.gif" width="1" height="3" alt="" /></td>';
					if ( $resItem['rv_room_requested_yn'] != "0" ) {
						$resHover = ' onmouseover="overlib(\'' . t_encodeOverlib($resItem['rv_room_request_reason']) . '\');" onmouseout="nd();" ';
						$resClass .= ' txtb imgLink';
					} else {
						$resHover = '';
					}
					$canCheck = 'true';
					if(date("Y-m-d") < $resItem['rv_item_date_arrive'] || date("Y-m-d") > $resItem['rv_item_date_depart']|| !allowItemCheckIn($resItem) || !$resItem['canCheckIn']) {
						$canCheck = 'false';
					}

					$roomCellCount++;
					if ( !isset($roomCellArray[$resItem['rv_res_item_group_id']]) ) {
						$roomCellArray[$resItem['rv_res_item_group_id']] = array();
					}

					array_push($roomCellArray[$resItem['rv_res_item_group_id']],$roomCellCount);
					if ( $resItem['rv_grp_accomm_overide_yn'] == "1" ) {
						$upgradeDate = chng_date($resItem['rv_grp_date_allocated'],"-");
						$upgradeSpan = '<span class="txtb" style="color: ' . $fontColour . ';" onmouseout="nd();" onmouseover="overlib(\'Upgrade to [' . $roomingItems['ac_accomm_desc'] . ']: ' . $upgradeDate . '\');">/U</span>';
					} else {
						$upgradeSpan = '';
					}

					$departPointer = "&gt;&gt;";

					if ( $resItem['hasArrive'] ) {
						$departPointer = "&gt;";
					}

					if($showResNum == 1) {
						$resNumCell = '
								<tr style="height: 15px;">
									<td style="background-color: ' . $resBackground . '; color: ' . $fontColourOverride . ';">
										<span ' . $resHover . ' class="' . $resClass . '" style="color: ' . $fontColour . ';">' . $resItem['rv_reservation_ix_fmt'] . $upgradeSpan . '</span>-' . $resItem['rv_item_adult_count'] . ',' . $resItem['rv_item_child_count'] . '&nbsp;<strong>' . $departPointer . '</strong>
									</td>
								</tr>
						';
					} else {
						$resNumCell = '';
					}
					if($showResName == 1) {
						$resNameCell = '
								<tr style="height: 15px;">
									<td style="color: ' . $fontColourOverride . ';"><span style="white-space: nowrap">' . $resItem['rv_res_name'] . '</span></td>
								</tr>
						';
					} else {
						$resNameCell = '';
					}
					if($showGuestName == 1) {
						$guestNameCell = '
								<tr style="height: 15px;">
									<td style="color: ' . $fontColourOverride . ';"><span style="white-space: nowrap">' . $guestNames . '</span></td>
								</tr>
						';
					} else {
						$guestNameCell = '';
					}

					$departHTML = '
						<td id="roomCell_' . $roomCellCount . '" resId="' . $resItem['rv_reservation_ix'] . '" resName="' . $resItem['rv_res_name_js'] . '" prop="' . $resItem['prop'] . '" agentRef="' . $resItem['rv_agent_ref_js'] . '" style="background-color: ' . $cellColour . '" onclick="selectCell(this,\'' . $resItem['rv_reservation_ix'] . '\',\'' . $resItem['rv_reservation_item_ix'] . '\',\'' . $resItem['rv_res_item_group_id'] . '\',\'' . $resItem['ac_accomm_room_id'] . '\',' . $resItem['rv_grp_status_ind'] . ',' . $canCheck . ');" class="imgLink">
							<table width="84" border="0" cellpadding="0" cellspacing="0" style="table-layout: fixed;">
							<col width="84" />
							'.$resNumCell.'
							'.$resNameCell.'
							'.$guestNameCell.'
							</table>
						</td>
					';
					array_push($resItemList,$item['depart'][0]['rv_reservation_item_ix']);
				} else {
					$cellColour = "#fff";
					if($item['weekDay'] == "Sun" || $item['weekDay'] == "Sat") {
						$cellColour = "#dbe1ef";
					}
					if($item['block'] > 0) {
						$cellColour = "#ccc";
					}

					$departTopHTML	= '<td style="background-color: ' . $cellColour . ';"><img src="/resource/Resrequest/Application/public/img/1x1.gif" width="1" height="3" alt="" /></td>';
					$departHTML			= '<td style="background-color: ' . $cellColour . ';"><img src="/resource/Resrequest/Application/public/img/1x1.gif" width="84" height="'.$calCellHeight.'" alt="" /></td>';
				}
				$calendarRows .= "<tr>" . $departTopHTML . $arriveTopHTML . "</tr><tr valign=\"top\">" . $departHTML . $arriveHTML . "</tr>";
			}
			$calendarRows .= "</table></div>";
		}
		$calendarRows .= "</div>";
	}
	$GLOBALS['temp']['calendarRows'] = $calendarRows;
}

$roomCellJS = "";

foreach($roomCellArray as $key=>$item) {
	$roomCellJS .= "roomCells['$key'] = new Array();\n";
	foreach($item as $cellId) {
		$roomCellJS .= "roomCells['$key'][roomCells['$key'].length] = '$cellId';\n";
	}
}

$GLOBALS['temp']['roomCells'] = $roomCellJS;

// [END] HTML -----------------------------------------------------------------

// [START] PDF ----------------------------------------------------------------
if ( $renderMode == "pdf" && ($renderType == "view" || $renderType == "send") ) {
	$pdf = new PDF("Rooming Calendar","L");

	// Set the margins ----------------------------------------------------------
	$pdf->tMargin = 5;
	$pdf->rMargin = 5;
	$pdf->bMargin = 5;
	$pdf->lMargin = 5;

	$reportLabel = "Rooming Calendar";

	$logo = "top_clientlogo.jpg";
	$principal_id = $_SESSION['principal_id'];

	if ( file_exists("$GLOBALS[images_dir_on_disk]/" . $principal_id . "/" . $logo) ) {
		$pic = $pdf->_parsejpg("$GLOBALS[images_dir_on_disk]/" . $principal_id . "/" . $logo);

		$h = $pic['h']/4;
		$w = $pic['w']/4;

		require_once(__DIR__ . '/functions.imageset.php');
		$logoWidth = imagesetLogoSizeOverride("roomingCalendarPdfLogoWidthOverride", $w);
		$pdf->Image("$GLOBALS[images_dir_on_disk]/" . $principal_id . "/" . $logo, $h, 5, $logoWidth);

		if ( ($h + 8) > $pdf->y ) {
			$pdf->y = $h + 8;
		}
	}

	// Main PDF header ----------------------------------------------------------
	$headerArray = array(
		array('name'=>"Date Range", 'value'=>$fromDate['htmlDate'] . " to " . chng_date($toDate['jsDate'],"-")),
		array('name'=>"Property / Accommodation", 'value'=>$accommFilter['names'])
	);

	// Moved to the end of the report -------------------------------------------
	// $pdf->ReportHeader($reportLabel, $headerArray);

	$pdfFontSize = 8;
	$pdf->SetFont('Arial', '', $pdfFontSize);
	$pdf->SetDrawColor(131,131,131);
	$pdf->Ln(2);

	$rowSet1 = array();
	$rowSet2 = array();

	$cProvDue		= array(241,197,93);
	$cProvExpire	= array(219,66,66);
	$cWhite			= array(255,255,255);
	$cBlock			= array(204,204,204);
	$cColLt			= array(241,239,239);
	$cColLtt		= array(252,252,252);
	$cColDk			= array(219,225,239);

	$resPDFColour = array(
		array(255,204,204),
		array(153,204,255),
		array(153,204,204),
		array(204,153,204),
		array(204,204,153),
		array(255,204,51),
		array(102,204,204),
		array(153,153,255),
		array(255,255,204),
		array(164,193,182),
		array(191,249,57),
		array(224,220,207),
		array(171,254,245),
		array(239,219,240),
		array(159,162,87),
		array(77,141,206)
	);

	$checkInPic		= $pdf->_parsejpg(__DIR__ . "/../../../public/img/button_checkIn.jpg");
	$checkOutPic 	= $pdf->_parsejpg(__DIR__ . "/../../../public/img/button_checkOut.jpg");

	$pdf->Ln(5);

	foreach ( $roomingData as $roomingItems ) {

		// Accommodation name -----------------------------------------------------
		$rows = array(
			array(
				'width'			=> "8%",
				'data'			=> "Room " . $roomingItems['ac_desc'] . "\n" . $roomingItems['ac_accomm_desc'],
				'border'		=> "LRB",
				'fill'			=> "1",
				'fillColor'	=> $cColLtt
			)
		);
		// Accommodation name -----------------------------------------------------

		$rows2 = $rows;

		// Line above accommodation name ------------------------------------------
		$rowHeaders = array(
			array(
				'width'		=> "8%",
				'height'		=> "0.5",
				'data'			=> "",
				'border'		=> "LRT",
				'fill'			=> "1",
				'fillColor'	=> $cColLtt
			)
		);
		// Line above accommodation name ------------------------------------------

		$rowHeaders2 = $rowHeaders;
		$resItemList = array();
		$colCount = 0;

		foreach($roomingItems as $date=>$item) {
			if ( !is_array($item) ) {
				continue;
			}

			if ( sizeof($item['stayover']) > 0 ) { // Generate stayover cell --------
				$resItem = $item['stayover'][0];

				$cellClass = getCellClass($resItem['rv_item_date_arrive'], $resItem['rv_item_date_depart'], $resItem['rv_grp_status_ind'],$resItem['rv_grp_status_time'],$resItem['rf_reservation_status_id'],true);

				if (isset($resColourArray[$resItem['rv_reservation_ix']])) {
					$cellColour = $resPDFColour[$resColourArray[$resItem['rv_reservation_ix']]];
				} else {
					$resColourArray[$resItem['rv_reservation_ix']] = $resColourCount;
					$cellColour = $resPDFColour[$resColourArray[$resItem['rv_reservation_ix']]];
					$resColourCount++;

					if ( $resColourCount >= sizeof($resPDFColour)) {
						$resColourCount = 0;
					}
				}

				if ( $item['block'] > 0 ) {
					$cellColour = $cBlock;
				}

				if ( $resItem['rf_reservation_status_id'] == "20" ) {
					if ( $resItem['rv_provision_expiry_date'] == date("Y-m-d") ) {
						$cellColour = $cProvDue;
					}
					if ( $resItem['rv_provision_expiry_date'] < date("Y-m-d") ) {
						$cellColour = $cProvExpire;
					}
				}

				$guestNames = getGuestNames($resItem['rv_res_item_group_id']);

				// Coloured line above a stayover cell --------------------------------
				$rowItemHeader = array(
					'width'		=> "11.5%",
					'height'		=> "0.5",
					'data'			=> "",
					'border'		=> "LRT",
					'fill'			=> "1",
					'fillColor'	=> $cellClass
				);
				// Coloured line above a stayover cell --------------------------------

				if ( $resItem['rv_item_date_depart'] < date("Y-m-d") ) {
					$fontColour = array(0x8a, 0x7a, 0x75);
				} else {
					$fontColour = array(0x00, 0x00, 0x00);
				}

				if ( $resItem['rv_grp_accomm_overide_yn'] == "1" ) {
					$upgradeSpan = "/U";
				} else {
					$upgradeSpan = "";
				}

				if ( !in_array($item['stayover'][0]['rv_reservation_item_ix'],$resItemList) || $date == $toDate['jsDate'] ) {

					$thisRowData = $resItem['rv_reservation_ix'] . $upgradeSpan . "-" . $resItem['rv_item_adult_count'] . "," . $resItem['rv_item_child_count'];

					if ( trim($resItem['rv_res_name']) != "" ) {
							$thisRowData .= "\n" . $resItem['rv_res_name'];
					}

					if ( is_array($guestNames) ) {
						$thisRowData .= "\n" . str_replace("<BR>","",implode(",",$guestNames));
					}

					// This is a stayover cell at the start of the report ---------------
					$rowItem = array(
						'width' 		=> "11.5%",
						'data'			=> $thisRowData,
						'border'		=> "LRB",
						'fill'			=> "1",
						'fillColor'	=> $cellColour,
						'textColor'	=> $fontColour
					);
					// This is a stayover cell at the start of the report ---------------

				} else {
					if ( $resPDFColour[$resColourArray[$resItem['rv_reservation_ix']]] != null ) {
						$cellColour = $resPDFColour[$resColourArray[$resItem['rv_reservation_ix']]];
					} else {
						$resColourArray[$resItem['rv_reservation_ix']] = $resColourCount;
						$cellColour = $resPDFColour[$resColourArray[$resItem['rv_reservation_ix']]];
						$resColourCount++;
						if ( $resColourCount >= sizeof($resPDFColour) ) {
							$resColourCount = 0;
						}
					}

					if ( $item['block'] > 0 ) {
						$cellColour = $cBlock;
					}

					// This is a blank cell in a stayover area --------------------------
					$rowItem = array(
						'width' 		=> "11.5%",
						'data' 			=> "",
						'border' 		=> "LRB",
						'fillColor'	=> $cellColour,
						'fill'			=> "1"
					);
					// This is a blank cell in a stayover area --------------------------
				}

				array_push($resItemList,$item['stayover'][0]['rv_reservation_item_ix']);

				if ( $colCount <= 7 ) {
					array_push($rowHeaders,$rowItemHeader);
					array_push($rows,$rowItem);
				} else {
					array_push($rowHeaders2,$rowItemHeader);
					array_push($rows2,$rowItem);
				}
			} else { // Generate arrive / depart cell -------------------------------

				if ( sizeof($item['depart']) > 0 ) {
					$resItem = $item['depart'][0];

					$cellClass = getCellClass($resItem['rv_item_date_arrive'], $resItem['rv_item_date_depart'], $resItem['rv_grp_status_ind'],$resItem['rv_grp_status_time'],$resItem['rf_reservation_status_id'],true);

					$cellColour = $resPDFColour[$colCount];

					if ( isset($resColourArray[$resItem['rv_reservation_ix']]) && $resPDFColour[$resColourArray[$resItem['rv_reservation_ix']]] != null ) {
						$cellColour = $resPDFColour[$resColourArray[$resItem['rv_reservation_ix']]];
					} else {
						$resColourArray[$resItem['rv_reservation_ix']] = $resColourCount;
						$cellColour = $resPDFColour[$resColourArray[$resItem['rv_reservation_ix']]];
						$resColourCount++;

						if ( $resColourCount >= sizeof($resPDFColour) ) {
							$resColourCount = 0;
						}
					}

					if ( $item['block'] > 0 ) {
						$cellColour = $cBlock;
					}

					if ( $resItem['rf_reservation_status_id'] == "20" ) {
						if ( $resItem['rv_provision_expiry_date'] == date("Y-m-d") ) {
							$cellColour = $cProvDue;
						}
						if ( $resItem['rv_provision_expiry_date'] < date("Y-m-d") ) {
							$cellColour = $cProvExpire;
						}
					}

					$guestNames = getGuestNames($resItem['rv_res_item_group_id']);
					$departPointer = ">>";

					if ( $resItem['hasArrive'] ) {
						$departPointer = ">";
					}

					// Row above a departure block --------------------------------------
					$rowItemHeader = array(
						'width'			=> "5.75%",
						'height'		=> "0.5",
						'data' 			=> "",
						'border'		=> "LT",
						'fill'			=> "1",
						'fillColor' => $cellClass
					);
					// Row above a departure block --------------------------------------

					if ( $resItem['rv_item_date_depart'] < date("Y-m-d") ) {
						$fontColour = array(0x8a, 0x7a, 0x75);
					} else {
						$fontColour = array(0x00, 0x00, 0x00);
					}

					if ( $resItem['rv_grp_accomm_overide_yn'] == "1" ) {
						$upgradeSpan = "/U";
					} else {
						$upgradeSpan = "";
					}

					$thisRowData = $resItem['rv_reservation_ix'] . $upgradeSpan . "-" . $resItem['rv_item_adult_count'] . "," . $resItem['rv_item_child_count'] . $departPointer;

					if ( trim($resItem['rv_res_name']) != "" ) {
							$thisRowData .= "\n" . $resItem['rv_res_name'];
					}

					if ( is_array($guestNames) ) {
						$thisRowData .=	"\n" . str_replace("<BR>","",implode(",",$guestNames));
					}

					// Departure block --------------------------------------------------
					$rowItem = array(
						'width'		=> "5.75%",
						'data'			=> $thisRowData,
						'border'		=> "LB",
						'fill' 			=> "1",
						'fillColor'	=> $cellColour,
						'textColor'	=> $fontColour
					);
					// Departure block --------------------------------------------------

					array_push($resItemList,$item['depart'][0]['rv_reservation_item_ix']);
				} else {
					$cellColour = $cWhite;

					if ( $item['weekDay'] == "Sun" || $item['weekDay'] == "Sat" ) {
						$cellColour = $cColDk;
					}

					if ( $item['block'] > 0 ) {
						$cellColour = $cBlock;
					}

					// Row above 1st half of blank cell --------------------------------
					$rowItemHeader = array(
						'width'		=> "5.75%",
						'height'		=> "0.5",
						'data'			=> "",
						'border'		=> "LT",
						'fill'			=> "1",
						'fillColor'	=> $cellColour
					);
					// Row above 1st half of blank cell --------------------------------

					// 1st half of blank cell -------------------------------------------
					$rowItem = array(
						'width'		=> "5.75%",
						'data'			=> "",
						'border'		=> "LB",
						'fillColor'	=> $cellColour,
						'fill'			=> "1"
					);
					// 1st half of blank cell -------------------------------------------
				}

				if ( $colCount <= 7 ) {
					array_push($rowHeaders,$rowItemHeader);
					array_push($rows,$rowItem);
				} else {
					array_push($rowHeaders2,$rowItemHeader);
					array_push($rows2,$rowItem);
				}

				if ( sizeof($item['arrive']) > 0 ) {

					$resItem = $item['arrive'][0];

					$cellClass = getCellClass($resItem['rv_item_date_arrive'], $resItem['rv_item_date_depart'], $resItem['rv_grp_status_ind'],$resItem['rv_grp_status_time'],$resItem['rf_reservation_status_id'],true);

					if (isset($resColourArray[$resItem['rv_reservation_ix']])) {
						$cellColour = $resPDFColour[$resColourArray[$resItem['rv_reservation_ix']]];
					} else {
						$resColourArray[$resItem['rv_reservation_ix']] = $resColourCount;
						$cellColour = $resPDFColour[$resColourArray[$resItem['rv_reservation_ix']]];
						$resColourCount++;

						if ( $resColourCount >= sizeof($resPDFColour) ) {
							$resColourCount = 0;
						}

					}

					if ( $item['block'] > 0 ) {
						$cellColour = $cBlock;
					}

					if ( $resItem['rf_reservation_status_id'] == "20" ) {
						if ( $resItem['rv_provision_expiry_date'] == date("Y-m-d") ) {
							$cellColour = $cProvDue;
						}

						if ( $resItem['rv_provision_expiry_date'] < date("Y-m-d") ) {
							$cellColour = $cProvExpire;
						}
					}

					$guestNames = getGuestNames($resItem['rv_res_item_group_id']);
					$arrivePointer = ">>";

					if ( $resItem['hasDepart'] ) {
						$arrivePointer = ">";
					}

					// Line above the arrival block -------------------------------------
					$rowItemHeader = array(
						'width'		=> "5.75%",
						'height'		=> "0.5",
						'data'			=> "",
						'border'		=> "RT",
						'fill'			=> "1",
						'fillColor'	=> $cellClass
					);
					// Line above the arrival block -------------------------------------

					if($resItem['rv_item_date_depart'] < date("Y-m-d")) {
						$fontColour = array(0x8a, 0x7a, 0x75);
					} else {
						$fontColour = array(0x00, 0x00, 0x00);
					}
					if ( $resItem['rv_grp_accomm_overide_yn'] == "1" ) {
						$upgradeSpan = "/U";
					} else {
						$upgradeSpan = "";
					}

					$thisRowData = $arrivePointer . $resItem['rv_reservation_ix'] . $upgradeSpan . "-" . $resItem['rv_item_adult_count'] . "," . $resItem['rv_item_child_count'];

					if ( trim($resItem['rv_res_name']) != "" ) {
							$thisRowData .= "\n" . $resItem['rv_res_name'];
					}

					if ( is_array($guestNames) ) {
						$thisRowData .=	"\n" . str_replace("<BR>","",implode(",",$guestNames));
					}

					// Arrival block ----------------------------------------------------
					$rowItem = array(
						'width'			=> "5.75%",
						'data'			=> $thisRowData,
						'border'		=> "RB",
						'fill'			=> "1",
						'fillColor'	=> $cellColour,
						'textColor'	=> $fontColour
					);
					// Arrival block ----------------------------------------------------

					array_push($resItemList,$item['arrive'][0]['rv_reservation_item_ix']);
				} else {
					$cellColour = $cWhite;
					if ( $item['weekDay'] == "Sun" || $item['weekDay'] == "Sat" ) {
						$cellColour = $cColDk;
					}

					if ( $item['block'] > 0 ) {
						$cellColour = $cBlock;
					}

					// Line above 2nd half of blank cell --------------------------------
					$rowItemHeader = array(
						'width'		=> "5.75%",
						'height' 		=> "0.5",
						'data' 			=> "",
						'border' 		=> "RT",
						'fill' 			=> "1",
						'fillColor' => $cellColour
					);
					// Line above 2nd half of blank cell --------------------------------

					// 2nd half of blank cell -------------------------------------------
					$rowItem = array(
						'width' 		=> "5.75%",
						'data' 			=> "",
						'border' 		=> "RB",
						'fillColor' => $cellColour,
						'fill' 			=> "1"
					);
					// 2nd half of blank cell -------------------------------------------
				}

				if ( $colCount <= 7 ) {
					array_push($rowHeaders,$rowItemHeader);
					array_push($rows,$rowItem);
				} else {
					array_push($rowHeaders2,$rowItemHeader);
					array_push($rows2,$rowItem);
				}
			}
			$colCount++;
		}
		array_push($rowSet1,$rowHeaders);
		array_push($rowSet1,$rows);
		array_push($rowSet2,$rowHeaders2);
		array_push($rowSet2,$rows2);
	}

	// Top left cell containing the Property Name -------------------------------
	$HeaderRow = array(
		array(
			'width'			=> "8%",
			'data' 			=> $accommFilter['names'],
			'border' 		=> "LRTB",
			'fill' 			=> '1',
			'fillColor' => $cColLt
		)
	);
	// Top left cell containing the Property Name -------------------------------

	$colCount = 0;

	foreach ( $dateList as $dateItem ) {
		if ( $dateItem['weekDay'] == "Sun" || $dateItem['weekDay'] == "Sat" ) {
			$cellColour = $cColDk;
		} else {
			$cellColour = $cColLt;
		}

		if ( $colCount <= 7 ) {
			// Row of dates across the top ------------------------------------------
			array_push($HeaderRow, array(
				'width' 		=> "11.5%",
				'data' 			=> $dateItem['weekDay'] . ", " . $dateItem['dateFormat'] . " (" . $dateItem['adultCount'] . "A, " . $dateItem['childCount'] . "C)",
				'border' 		=> "LRTB",
				'fill' 			=> "1",
				'fillColor'	=> $cellColour,
				'align' 		=> "C"
			));
			// Row of dates across the top ------------------------------------------
		}
		$colCount++;
	}

	$pdf->Row($HeaderRow);

	foreach ( $rowSet1 as $row ) {
		$pdf->Row($row);
	}

	$pdf->Ln(4);
	$pdf->ReportHeader($reportLabel, $headerArray);

	if ( $renderType == "view" ) {
		$pdf->OutPut();
		die();
	}

	if ( $renderType == "send" ) {
		$to = $_POST['mail_to'];
		$from = $_POST['mail_from'];
		$subject = stripslashes($_POST['mail_subj']);
		$message = stripslashes($_POST['mail_body']);
		$attachmentName = $_POST['attachmentName'];

		$headers = "From: " . $GLOBALS['princName'] . "<$from>\r\n";

		// close the pdf
		if($pdf->state < 3) {
			$pdf->Close();
		}

		/* and now mail it */
		if($attachmentName != "!attachmentName!") {
			$pdfName = $attachmentName;
		} else {
			$pdfName = "Update report from $fromDate[jsDate] to $toDate[jsDate].pdf";
		}

		$error = email($from, $to, $subject, $headers, $message, 0, 0, $_SERVER['argv'][1], $GLOBALS['princName'],$pdf->buffer,$pdfName);		// (from, to, subject, headers, message, action, emailID, resID)
		if(!$error) {
			echo "<script language=\"javascript\">if(opener && !opener.closed){opener.showMessage('Your email has been sent.');} window.close();</script></body></html>";
			die();
		} else {
			echo "<script language=\"javascript\">if(opener && !opener.closed){opener.showMessage('Error sending email!');} window.close();</script></body></html>";
			die();
		}
	}
}
// END		- Generate calendar (PDF)

// START	- Generate calendar (CSV)
if($renderMode == "csv") {
	$csvFile = array();

	array_push($csvFile,array("Rooming Calendar"));
	array_push($csvFile,array());
	array_push($csvFile,array("Date Range",$fromDate['htmlDate'] . " to " . chng_date($toDate['jsDate'],"-")));
	array_push($csvFile,array("Property / Accommodation",$accommFilter['names']));
	array_push($csvFile,array());

	$headerRow = array("");
	foreach($dateList as $dateItem) {
		array_push($headerRow,$dateItem['weekDay'].", ".$dateItem['dateFormat'],"");
	}
	array_push($csvFile,$headerRow);

	foreach($roomingData as $roomingItems) {
		$row = array("Room $roomingItems[ac_desc], Accommodation $roomingItems[ac_accomm_desc]");
		foreach($roomingItems as $date=>$item) {
			if(!is_array($item)) {
				continue;
			}
			if(sizeof($item['stayover']) > 0) { // Generate stayover cell
				$resItem = $item['stayover'][0];
				if($resItem['rv_grp_accomm_overide_yn'] == "1") {
					$upgradeSpan = "/U";
				} else {
					$upgradeSpan = "";
				}
				array_push($row,"$resItem[rv_reservation_ix]$upgradeSpan-$resItem[rv_item_adult_count],$resItem[rv_item_child_count] $resItem[rv_res_name] ".getGuestNames($resItem['rv_res_item_group_id']));
				array_push($row,"");
			} else { // Generate arrive / depart cell
				if(sizeof($item['depart']) > 0) {
					$resItem = $item['depart'][0];
					if($resItem['rv_grp_accomm_overide_yn'] == "1") {
						$upgradeSpan = "/U";
					} else {
						$upgradeSpan = "";
					}
					array_push($row,"$resItem[rv_reservation_ix]$upgradeSpan-$resItem[rv_item_adult_count],$resItem[rv_item_child_count] $resItem[rv_res_name] ".getGuestNames($resItem['rv_res_item_group_id'])." >>");
				} else {
					array_push($row,"");
				}
				if(sizeof($item['arrive']) > 0) {
					$resItem = $item['arrive'][0];
					if($resItem['rv_grp_accomm_overide_yn'] == "1") {
						$upgradeSpan = "/U";
					} else {
						$upgradeSpan = "";
					}
					array_push($row,">> $resItem[rv_reservation_ix]$upgradeSpan-$resItem[rv_item_adult_count],$resItem[rv_item_child_count] $resItem[rv_res_name] ".getGuestNames($resItem['rv_res_item_group_id']));
				} else {
					array_push($row,"");
				}
			}
		}
		array_push($csvFile,$row);
	}


	$csvText = "";
	foreach($csvFile as $csvLine) {
		$first = true;
		foreach($csvLine as $csvItem) {
			if(!$first) {
				$csvText .= ",";
			} else {
				$first = false;
			}
			$csvText .= "\"".str_replace("\"","\"\"",$csvItem)."\"";
		}
		$csvText .= "\n";
	}
	if(headers_sent()) {
		echo('Some data has already been output to browser, can\'t send CSV file');
	}
	header('Content-Type: text/csv');
	header("Cache-control: private");
	header('Content-Length: '.strlen($csvText));
	header("Content-Disposition: inline; filename=rooming_calendar_$fromDate[jsDate]_to_$toDate[jsDate].csv");
	echo $csvText;
	flush();
	die();
}
// END		- Generate calendar (CSV)


// START - Create unallocated reservations listing
$resItemList = $GLOBALS['lDB']->get("
	SELECT
		rv_reservation.rv_reservation_ix,
		rv_reservation.rv_res_name,
		rv_reservation.rv_agent_ref,
		rv_reservation.rv_note_general,
		rv_reservation.rv_note_guests,
		rv_reservation.rv_note_internal,
		rv_reservation.rv_provision_expiry_date,
		rv_reservation.rv_consultant_id,
		rv_reservation.rf_reservation_status_id,
		rv_reservation_item.rv_item_date_arrive,
		rv_reservation_item.rv_item_date_depart,
		ac_accomm_type.ac_accomm_desc,
		rv_reservation_item.rv_item_accomm_count,
		rv_reservation_item.rv_item_adult_count,
		rv_reservation_item.rv_item_child_count,
		rv_reservation_item.rv_reservation_item_ix

	FROM
		rv_reservation_item
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
		INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
	WHERE
		(
			(rv_reservation_item.rv_item_date_arrive >= '$fromDate[jsDate]' AND rv_reservation_item.rv_item_date_arrive <= '$toDate[jsDate]')
			OR
			(rv_reservation_item.rv_item_date_depart >= '$fromDate[jsDate]' AND rv_reservation_item.rv_item_date_depart <= '$toDate[jsDate]')
			OR
			(rv_reservation_item.rv_item_date_arrive < '$fromDate[jsDate]' AND rv_reservation_item.rv_item_date_depart > '$toDate[jsDate]')
		)
		$accommFilter[where]
		AND (
			rv_reservation.rf_reservation_status_id = '30'
			OR (
				rv_reservation.rf_reservation_status_id = '20'
				AND rv_reservation.rv_provision_expiry_date >= '".date("Y-m-d")."'
			)
		)
	ORDER BY
		rv_reservation_item.rv_item_date_arrive,
		rv_reservation_item.rv_item_date_depart,
		rv_reservation.rv_reservation_ix
",2);

$resItemHTML = "
	<tr id=\"unallocRow_!rowNum!\" resId=\"!rv_reservation_ix!\" resName=\"!rv_res_name_js!\" prop=\"!prop!\" agentRef=\"!rv_agent_ref_js!\" resItemId=\"!rv_reservation_item_ix!\" resGroupId=\"\" class=\"imglink\" valign=\"top\" onclick=\"selectResItem(this,'!rv_reservation_ix!','!rv_reservation_item_ix!',null);\">
	<td style=\"background-color: !bgColour!; color: !resColor!\">!rv_reservation_ix_fmt!</td>
	<td class=\"bl\" style=\"background-color: !bgColour!; color: !resColour!; overflow: hidden;\">!rv_res_name!</td>
	<td class=\"bl\" style=\"overflow: hidden;\">!rv_agent_ref!</td>
	<td class=\"bl\" style=\"!cellColour!\">!rf_reservation_status_desc!</td>
	<td class=\"bl\">!ac_accomm_desc!</td>
	<td class=\"bl\" align=\"center\">!rv_item_accomm_count!</td>
	<td class=\"bl\" align=\"center\">!rv_item_adult_count!</td>
	<td class=\"bl\" align=\"center\">!rv_item_child_count!</td>
	<td class=\"bl\">!rv_item_date_arrive!</td>
	<td class=\"bl\">!rv_item_date_depart!</td>
	<td class=\"bl br\" align=\"center\"><input type=\"button\" class=\"button bDropDown\" style=\"width:90px; ".($readonly?"color: rgb(131, 131, 131);":"")."\" value=\"Res Details\" ".($readonly?"disabled":"")." onclick=\"showResItemDropDown(event,this,'!rv_reservation_ix_raw!');\"></td>
	</tr>
";
/*
		<!--<input type=\"button\" class=\"button bRooms\" style=\"width:20; height:20;\">
		<input type=\"button\" class=\"button bGuestNote\" style=\"width:20; height:20;\">
			<input type=\"button\" class=\"button bNote\" style=\"width:20; height:20;\">
		<input type=\"button\" class=\"button bIntNote\" style=\"width:20; height:20;\">
		<input type=\"button\" class=\"button bAgent\" style=\"width:20; height:20; background-position:center;\">
		<input type=\"button\" class=\"button bDoc\" style=\"width:20; height:20; background-position:center;\">-->

*/

$guestItemHTML = "
	<tr id=\"unallocRow_!rowNum!\" resId=\"!rv_reservation_ix!\" resName=\"!rv_res_name_js!\" prop=\"!prop!\" agentRef=\"!rv_agent_ref_js!\" resItemId=\"!rv_reservation_item_ix!\" resGroupId=\"!rv_res_item_group_ix!\" class=\"imglink\" valign=\"top\" onclick=\"selectResItem(this,'!rv_reservation_ix!','!rv_reservation_item_ix!','!rv_res_item_group_ix!');\" height=\"22\">
	<td style=\"background-color: !bgColour!; color: !resColour!;\">!rv_reservation_ix_fmt!</td>
	<td class=\"bl\" style=\"background-color: !bgColour!; color: !resColour!; overflow: hidden;\">!rv_res_name!</td>
	<td class=\"bl\" style=\"overflow: hidden;\">!rv_agent_ref!</td>
	<td class=\"bl\" style=\"!cellColour!;\">!rf_reservation_status_desc!</td>
	<td class=\"bl\">!ac_accomm_desc!</td>
	<td class=\"bl\" align=\"center\">!rv_item_accomm_count!</td>
	<td class=\"bl\" align=\"center\">!rv_item_adult_count!</td>
	<td class=\"bl\" align=\"center\">!rv_item_child_count!</td>
	<td class=\"bl\">!rv_item_date_arrive!</td>
	<td class=\"bl\">!rv_item_date_depart!</td>
	<td class=\"bl br\" align=\"center\"><input type=\"button\" class=\"button bDropDown\" style=\"width:82; ".($readonly?"color: rgb(131, 131, 131);":"")."\" value=\" Res Details\" ".($readonly?"disabled":"")." onclick=\"showResItemDropDown(event,this,'!rv_reservation_ix!');\">
			<input type=\"button\" class=\"button bAgent\" style=\"width:20; height:18; background-position:center; !showGuestStyle!\" onclick=\"showGuestNames('!rv_reservation_ix!','!rv_res_item_group_ix!');\">

	</td>
	</tr>
";
/* BUTTONS

		<!--<input type="button" class="button bDropDown" style="width:120;" value="Reservation Details"></td>-->
		<!--<input type="button" class="button bRooms" style="width:20; height:20;">
		<input type="button" class="button bGuestNote" style="width:20; height:20;">
			<input type="button" class="button bNote" style="width:20; height:20;">
		<input type="button" class="button bIntNote" style="width:20; height:20;">
		<input type="button" class="button bAgent" style="width:20; height:20; background-position:center;">
		<input type="button" class="button bDoc" style="width:20; height:20; background-position:center;">-->

*/

$statusNames = array("0" => "Quotation", "10" => "Waitlist", "20" => "Provisional", "30" => "Confirmed");
$statusNamesB = array("0" => "Quote (Req)", "10" => "Wait (Req)", "20" => "Prov (Req)", "30" => "Confirm (Req)");

$resItemRows = "";
$lastResId = null;
$resNotes = array();
$resMemos = array();
$guestNotes = array();
$guestNames = array();
$rowNum = 0;
foreach($resItemList as $resItem) {
	if($resItem['rv_consultant_id'] == '0' || trim($resItem['rv_consultant_id']) == "") {
		$resItem['rf_reservation_status_desc'] = $statusNamesB[$resItem['rf_reservation_status_id']];
	} else {
		$resItem['rf_reservation_status_desc'] = $statusNames[$resItem['rf_reservation_status_id']];
	}

	$resItem['rv_res_name_js'] = t_encodeOverlib($resItem['rv_res_name']);
	$resItem['rv_agent_ref_js'] = t_encodeOverlib($resItem['rv_agent_ref']);
	if(trim($resItem['rv_agent_ref']) == "") {
		$resItem['rv_agent_ref'] = "<img src=\"/resource/Resrequest/Application/public/img/1x1.gif\">";
	}

	if(isset($resColourArray[$resItem['rv_reservation_ix']])) {
		$fontColour = "#000";
		$bgColour = $resHTMLColour[$resColourArray[$resItem['rv_reservation_ix']]];
	} else {
		$resColourArray[$resItem['rv_reservation_ix']] = $resColourCount;
		$fontColour = "#000";
		$bgColour = $resHTMLColour[$resColourArray[$resItem['rv_reservation_ix']]];
		$resColourCount++;
		if($resColourCount >= sizeof($resHTMLColour)) {
			$resColourCount = 0;
		}
	}
	$resItem['resColour'] = $fontColour;
	$resItem['bgColour'] = $bgColour;
	$optionsList = $GLOBALS['lDB']->get("SELECT rt_component.rt_component_abbrv FROM rv_res_item_comp LEFT JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id WHERE rv_reservation_item_id = '$resItem[rv_reservation_item_ix]' AND rv_item_comp_option_yn = '1' ORDER BY rt_component.rt_component_abbrv",3);
	if (sizeof($optionsList > 0)) {
		$listB = join(", ",$optionsList);
		if (trim($listB) != "," && trim($listB) != "") {
			$resItem['ac_accomm_desc'] .= " (".$listB.")";
		}
	}


	$resItem['cellColour'] = "";
	// Check for unallocated rooms.
	if($resItem['rf_reservation_status_id'] == "20") {
		if($resItem['rv_provision_expiry_date'] == date("Y-m-d")) {
			$resItem['cellColour'] = "background-color: #F1C55D;";
		}
		if($resItem['rv_provision_expiry_date'] < date("Y-m-d")) {
			$resItem['cellColour'] = "background-color: #DB4242;";
		}
	}

	$resNotes[$resItem['rv_reservation_ix']] = t_encodeOverlib($resItem['rv_note_general']);
	$resMemos[$resItem['rv_reservation_ix']] = t_encodeOverlib($resItem['rv_note_internal']);
	$guestNotes[$resItem['rv_reservation_ix']] = t_encodeOverlib($resItem['rv_note_guests']);

	$resItem['rv_item_date_arrive'] = chng_date($resItem['rv_item_date_arrive'],"-");
	$resItem['rv_item_date_depart'] = chng_date($resItem['rv_item_date_depart'],"-");

	$resItem['rv_reservation_ix_raw'] = $resItem['rv_reservation_ix'];
	$roomCheck = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			rv_res_item_group
			LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		WHERE
			rv_res_item_group.rv_reservation_item_id = '$resItem[rv_reservation_item_ix]'
			AND ac_accomm_room.ac_accomm_room_ix IS NOT NULL
	",4);
	$roomUnalloc = $resItem['rv_item_accomm_count'] - $roomCheck;
	if($roomUnalloc > 0) {
		if($resItem['rv_reservation_ix'] == $lastResId) {
			$resItem['rv_reservation_ix_fmt'] = "&nbsp;";
			$resItem['rv_res_name'] = "&nbsp;";
			$resItem['rf_reservation_status_desc'] = "&nbsp;";
		} else {
			$lastResId = $resItem['rv_reservation_ix'];
			$resItem['rv_reservation_ix_fmt'] = $resItem['rv_reservation_ix'];
		}
		$guestList = $GLOBALS['lDB']->get("
			SELECT
				rv_res_item_group.rv_res_item_group_ix as rv_res_item_group_ix
			FROM
				rv_res_item_group
				LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
				LEFT JOIN rv_res_item_guest ON rv_res_item_guest.rv_res_item_group_id = rv_res_item_group.rv_res_item_group_ix
			WHERE
				rv_res_item_group.rv_reservation_item_id = '$resItem[rv_reservation_item_ix]'
				AND ac_accomm_room.ac_accomm_room_ix IS NULL
			GROUP BY
				rv_res_item_group.rv_res_item_group_ix
		",3);
		if(sizeof($guestList) > 0) {
			for($count = 0; $count < sizeof($guestList); $count++) {
				$guestNameList = $GLOBALS['lDB']->get("
					SELECT
						pr_name_first,
						pr_name_last
					FROM
						rv_res_item_guest
						INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
					WHERE
						rv_res_item_guest.rv_res_item_group_id = '".$guestList[$count]."'
				",2);
				$guestNameStr = "";
				foreach($guestNameList as $guestNameItem) {
					$guest = trim($guestNameItem['pr_name_first'] . " " . $guestNameItem['pr_name_last']);
					if($guest != "") {
						$guestNameStr .= $guest . "\n";
					}
				}
				$guestNames[$guestList[$count]] = $guestNameStr;
				$resItem['rv_item_accomm_count'] = "1";
				$resItem['rv_res_item_group_ix'] = $guestList[$count];
				$resItem['showGuestStyle'] = "";
				if(trim($guestNameStr) == "") {
					$resItem['showGuestStyle'] = " visibility: hidden; ";
				}
				$roomUnalloc--;
				$resItem['rowNum'] = $rowNum;
				$resItemRows .= showpage($resItem,$guestItemHTML);
				$rowNum++;
			}
		}
		if($roomUnalloc > 0) {
			$resItem['rv_item_accomm_count'] = $roomUnalloc;
			$resItem['rowNum'] = $rowNum;
			$resItemRows .= showpage($resItem,$resItemHTML);
			$rowNum++;
		}
	}
}
if(trim($resItemRows) == "") {
	$resItemRows .= "
	<tr>
	<td colspan=\"10\" class=\"txti\" align=\"center\">No unallocated reservations found</td>
	</tr>
	";
}
$resItemRows .= "
	<tr>
	<td colspan=\"10\" class=\"bt\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
	</tr>
";
$GLOBALS['temp']['unallocatedReservationRows'] = $resItemRows;

$resNoteJS = "";
foreach($resNotes as $key=>$item) {
	$resNoteJS .= "resNotes['$key'] = '$item';\n";
}
$GLOBALS['temp']['resNotes'] = $resNoteJS;

$resMemoJS = "";
foreach($resMemos as $key=>$item) {
	$resMemoJS .= "resMemos['$key'] = '$item';\n";
}
$GLOBALS['temp']['resMemos'] = $resMemoJS;

$guestNoteJS = "";
foreach($guestNotes as $key=>$item) {
	$guestNoteJS .= "guestNotes['$key'] = '$item';\n";
}
$GLOBALS['temp']['guestNotes'] = $guestNoteJS;

$guestNameJS = "";
foreach($guestNames as $key=>$item) {
	$guestNameJS .= "guestNames['$key'] = '".t_encodeOverlib($item)."';\n";
}
$GLOBALS['temp']['guestNames'] = $guestNameJS;
// END	- Create unallocated reservations listing


// START - Batch Check In
$checkInList = $GLOBALS['lDB']->get("
	SELECT
		ac_accomm_room.ac_desc,
		rv_res_item_group.rv_res_item_group_ix as rv_res_item_group_id,
		rv_res_item_group.ac_accomm_room_id,
		rv_reservation.rv_reservation_ix,
		rv_reservation.rv_res_name,
		rv_reservation.rf_reservation_status_id
	FROM
		rv_res_item_group
		INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
		INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
	WHERE
		1
		".str_replace("rv_reservation_item.ac_accomm_type_id","ac_accomm_type.ac_accomm_type_ix",$accommFilter['where'])."
		AND rv_res_item_group.rv_grp_status_ind != '5'
		AND rv_reservation_item.rv_item_date_arrive = '".date("Y-m-d")."'
	ORDER BY
		ac_accomm_room.ac_desc+0,
		ac_accomm_room.ac_desc
",2);



$checkInHTML = "
	<tr>
		<td height=\"16\" valign=\"top\"><input type=checkbox name=\"batchCheckIn\" id=\"!rv_res_item_group_id!\"></td>
		<td height=\"16\" valign=\"top\">!desc!</td>
	</tr>
";

$checkInRows = "";
foreach($checkInList as $item) {
	$canCheckIn = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			rv_res_item_group
		WHERE
			rv_res_item_group.rv_res_item_group_ix != '$item[rv_res_item_group_id]'
			AND rv_res_item_group.ac_accomm_room_id = '$item[ac_accomm_room_id]'
			AND rv_res_item_group.rv_grp_status_ind = '5'
	",4);
	if($canCheckIn <= 0 && $item['rf_reservation_status_id'] == 30) {
		$item['desc'] = $item['ac_desc'] . " - " . $item['rv_reservation_ix'] . " " . $item['rv_res_name'];
		$guestNames =	getGuestNames($item['rv_res_item_group_id']);
		if(trim($guestNames) != "") {
			$item['desc'] .= " (" . $guestNames . ")";
		}
		$checkInRows .= showpage($item,$checkInHTML);
	}
}
if($checkInRows == "") {
	$checkInRows = "<tr><td colspan=2 align=\"center\" class=\"txti\">No rooms due for check-in</td></tr>";
}
$GLOBALS['temp']['checkInRows'] = $checkInRows;
// END	- Batch Check In

// START - Batch Check Out
$checkOutList = $GLOBALS['lDB']->get("
	SELECT
		ac_accomm_room.ac_desc,
		rv_res_item_group.rv_res_item_group_ix as rv_res_item_group_id,
		rv_reservation_item.rv_reservation_id
	FROM
		rv_res_item_group
		INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
		INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
	WHERE
		1
		".str_replace("rv_reservation_item.ac_accomm_type_id","ac_accomm_type.ac_accomm_type_ix",$accommFilter['where'])."
		AND rv_res_item_group.rv_grp_status_ind = '5'
		AND rv_reservation_item.rv_item_date_depart = '".date("Y-m-d")."'
	ORDER BY
		ac_accomm_room.ac_desc+0,
		ac_accomm_room.ac_desc
",2);

$oldCheckOutList = $GLOBALS['lDB']->get("
	SELECT
		ac_accomm_room.ac_desc,
		rv_res_item_group.rv_res_item_group_ix as rv_res_item_group_id,
		rv_reservation_item.rv_reservation_id
	FROM
		rv_res_item_group
		INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
		INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
	WHERE
		1
		".str_replace("rv_reservation_item.ac_accomm_type_id","ac_accomm_type.ac_accomm_type_ix",$accommFilter['where'])."
		AND rv_res_item_group.rv_grp_status_ind = '5'
		AND rv_reservation_item.rv_item_date_depart < '".date("Y-m-d")."'
	ORDER BY
		ac_accomm_room.ac_desc+0,
		ac_accomm_room.ac_desc
",2);

#Get list of default Custom Notes
$customNotes = $GLOBALS['lDB']->get("SELECT
	rf_note_custom.rf_note_custom_ix as custNoteId
	FROM rf_note_custom
",2);
$customIds = array();
if(sizeof($customNotes) > 0){
	foreach($customNotes as $custom){
	// get defaults
	$dbInd = $GLOBALS['lDB']->get("SELECT rf_database.rf_db_env_type_ind FROM rf_database WHERE rf_database.rf_db_code = '$GLOBALS[dbcode]'",4);
		if($dbInd == 2){
		$checkDB = "AND rf_note_cust_default.rf_db_code = ''";
	}else{
		$checkDB = "AND rf_note_cust_default.rf_db_code = '$GLOBALS[dbcode]'";
	}
	$def = $GLOBALS['lDB']->get("SELECT
					rf_note_cust_def_ext_inv_yn,
			rf_note_cust_def_ext_summ_yn,
			rf_note_cust_def_ext_pro_yn,
			rf_note_cust_def_int_inv_yn,
			rf_note_cust_def_int_summ_yn,
			rf_note_cust_def_int_pro_yn
		FROM rf_note_cust_default
		WHERE rf_note_cust_default.rf_note_custom_id = '$custom[custNoteId]'
		$checkDB
	",1);
	$check = "";
	if($userStatusId < 2){
		if($def['rf_note_cust_def_ext_pro_yn'] == 1){
		array_push($customIds,$custom['custNoteId']);
		}
	}else{
		if($def['rf_note_cust_def_int_pro_yn'] == 1){
		array_push($customIds,$custom['custNoteId']);
		}
	}
	}
	//debug($customIds);
	$GLOBALS['temp']['customIds'] = join(",",$customIds);
}

$checkOutHTML = "
	<tr>
		<td><input type=checkbox name=\"batchCheckOut\" id=\"!rv_res_item_group_id!\"></td>
		<td class=\"!class!\">!ac_desc!</td>
		<td><input type=\"button\" class=\"button bPDF\" style=\"width:20; height:20;\" onclick=\"openFolioPDF('!fn_folio_ix!');\"></td>
	</tr>
";

$checkOutRows = "";
if(sizeof($checkOutList) > 0) {
	$checkOutRows .= "
		<tr>
			<td colspan=3 align=\"center\" class=\"outLt\">Current</td>
		</tr>
	";
}
foreach($checkOutList as $item) {
	$folioList = $GLOBALS['lDB']->get("
		SELECT
			fn_folio.fn_folio_ix,
			(fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) as fn_folio_outstanding
		FROM
			fn_folio
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_folio.rv_reservation_id
		WHERE
			fn_folio.rv_reservation_id = '$item[rv_reservation_id]'
	",2);
	$item['class'] = "txt";
	$item['fn_folio_ix'] = "";
	foreach($folioList as $folioItem) {
		if($item['fn_folio_ix'] != "") {
			$item['fn_folio_ix'] .= "|";
		}
		$item['fn_folio_ix'] .= $folioItem['fn_folio_ix'];
		if($folioItem['fn_folio_outstanding'] > 0) {
			$item['class'] = "txtred";
		}
	}

	$checkOutRows .= showpage($item,$checkOutHTML);
}
if(sizeof($oldCheckOutList) > 0) {
	$checkOutRows .= "
		<tr>
			<td colspan=3 align=\"center\" class=\"outLt\">Past</td>
		</tr>
	";
}
foreach($oldCheckOutList as $item) {
	$folioList = $GLOBALS['lDB']->get("
		SELECT
			fn_folio.fn_folio_ix,
			(fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) as fn_folio_outstanding
		FROM
			fn_folio
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_folio.rv_reservation_id
		WHERE
			fn_folio.rv_reservation_id = '$item[rv_reservation_id]'
	",2);
	$item['class'] = "txt";
	$item['fn_folio_ix'] = "";
	foreach($folioList as $folioItem) {
		if($item['fn_folio_ix'] != "") {
			$item['fn_folio_ix'] .= "|";
		}
		$item['fn_folio_ix'] .= $folioItem['fn_folio_ix'];
		if($folioItem['fn_folio_outstanding'] > 0) {
			$item['class'] = "txtred";
		}
	}

	$checkOutRows .= showpage($item,$checkOutHTML);
}
if($checkOutRows == "") {
	$checkOutRows = "<tr><td colspan=2 align=\"center\" class=\"txti\">No rooms due for check-out</td></tr>";
}
$GLOBALS['temp']['checkOutRows'] = $checkOutRows;
// END	- Batch Check In



$GLOBALS['temp']['resJob'] = "0";
if(checkJob(2)) {
	$GLOBALS['temp']['resJob'] = "2";
}


if($_SERVER['argc'] > 1 || $options & 8) {
	$GLOBALS['temp']['showHideFilterButtonText'] = "<< Show Filters";
	$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";
} else {
	$GLOBALS['temp']['showHideFilterButtonText'] = "<< Hide Filters";
	$GLOBALS['temp']['filterStatus'] = "expand";
}
$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));

function getCellClass($arrivalDate, $departureDate, $checkInStatus, $rv_grp_status_time, $rf_reservation_status_id, $pdf = false) {

/*
.bcRoomInOld { background-color: #8a7a75; } GREY
.bcRoomIn { background-color: #2868DE; } BLUE
.bcRoomCheckIn { background-color: #0EB64D; } GREEN
.bcRoomNoShow { background-color: #D62323; } RED
.bcRoomCheckOut { background-color: #FBB60F; } ORANGE
.bcRoomFuture { background-color: #000000; } BLACK
.bcRoomEarly { #9255a4 } PURPLE
*/
	if($rf_reservation_status_id == 25) {
		if(!$pdf) {
			return "bcRoomCheckIn";
		} else {
			return array(0x0e,0xb6,0x4d);
		}
	}
	$today = date("Y-m-d");
	if( ( $departureDate < $today && $checkInStatus != 5 ) || ( $departureDate == $today && $checkInStatus > 5 ) ) {
		if(!$pdf) {
			return "bcRoomInOld";
		} else {
			return array(0xb6,0xb6,0xb6);
		}
	}
	if($arrivalDate == $today && ($checkInStatus <= 2 || $checkInStatus > 5) ) {
		if(!$pdf) {
			return "bcRoomCheckOut";
		} else {
			return array(0xfb,0xb6,0x0f);
		}
	}
	if($departureDate == $today && $checkInStatus == 5) {
		if(!$pdf) {
			return "bcRoomNoShow";
		} else {
			return array(0xd6,0x23,0x23);
		}
	}
	if($checkInStatus == 5 && $departureDate > $today) {
		if(!$pdf) {
			return "bcRoomIn";
		} else {
			return array(0x28,0x68,0xde);
		}
	}
	if($checkInStatus == 5 && $departureDate < $today) {
		if(!$pdf) {
			return "bcRoomLate";
		} else {
			return array(0x28,0xcb,0xde);
		}
	}
	if($checkInStatus == 8) {
		$timeSplit = explode(" ", $rv_grp_status_time);
		if($departureDate != $timeSplit[0]) {
			if(!$pdf) {
				return "bcRoomEarly";
			} else {
				return array(0x92,0x55,0xa4);
			}
		}
	}
	//default?
	if(!$pdf) {
		return "bcRoomFuture";
	} else {
		return array(0x00,0x00,0x00);
	}
}

function getGuestNames($rv_res_item_group_id) {
	$guestNameList = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_last,
			pr_persona.pr_name_first
		FROM
			rv_res_item_guest
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
		WHERE
			rv_res_item_guest.rv_res_item_group_id = '$rv_res_item_group_id'
	",2);
	$guestNames = "";
	foreach($guestNameList as $item) {
		$guestName = trim($item['pr_name_first'] . " " . $item['pr_name_last']);
		if($guestNames != "" && $guestName != "") {
			$guestNames .= ", ";
		}
		$guestNames .= $guestName;

	}
	return $guestNames;
}

function getPersonaFax($personaId) {
	$fax = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone, rf_phone_type
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
			AND rf_phone_type.rf_phone_type_sys_code = '1'",4);
	if(trim($fax) == "" || $fax == "0") {
		$fax = "";
	}
	return $fax;
}

function getPersonaTelephone($personaId) {
	$tel = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND pr_phone.pr_default_yn = '1'",4);
	if(trim($tel) == "" || $tel == "0") {
		$tel = "";
	}
	return $tel;
}

function getPersonaDetail($personaId) {
	$detail = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_first,
			pr_persona.pr_name_second,
			pr_persona.pr_name_last,
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '".$personaId."'",2);
	$detail = $detail[0];
	$name = "";
	if(trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
		$name .= $detail['pr_name_first'] . " ";
	}
	if(trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
		$name .= $detail['pr_name_second'] . " ";
	}
	if(trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
		$name .= $detail['pr_name_last'] . " ";
	}
	$result = array();
	$result['name'] = trim($name);
	$result['fax'] = getPersonaFax($personaId);
	$result['telephone'] = getPersonaTelephone($personaId);
	$result['email'] = $detail['pr_email'];
	if(trim($result['email']) == "" || $result['email'] == "0") {
		$result['email'] = "";
	}
	return $result;
}

function allowItemCheckIn($resItem) {
/*
	[0] => PA3
	[rv_reservation_ix] => PA3
	[1] => rt1
	[rv_res_name] => rt1
	[2] => 30
	[rf_reservation_status_id] => 30
	[3] => 0000-00-00
	[rv_provision_expiry_date] => 0000-00-00
	[4] => 2004-11-23
	[rv_date_changed] => 2004-11-23
	[5] => 2
	[rv_item_adult_count] => 2
	[6] => 0
	[rv_item_child_count] => 0
	[7] => RS3
	[ac_accomm_room_id] => RS3
	[8] => 8
	[rv_grp_status_ind] => 8
	[9] => 0
	[rv_room_requested_yn] => 0
	[10] =>
	[rv_room_request_reason] =>
	[11] => 2004-11-23
	[rv_item_date_arrive] => 2004-11-23
	[12] => 2004-11-26
	[rv_item_date_depart] => 2004-11-26
	[13] => PA3
	[rv_reservation_item_ix] => PA3
	[14] => PA21
	[rv_res_item_group_id] => PA21
	[rv_reservation_ix_fmt] => PA3
	rv_res_item_group.rv_grp_status_time
*/
	if($resItem['rv_grp_status_ind'] != '8' && $resItem['rf_reservation_status_id'] == '30') {
		return true;
	}
	$endDate = $resItem['rv_item_date_depart'];
	$temp = explode(" ",$resItem['rv_grp_status_time']);
	$startDate = $temp[0];
	if($endDate == $startDate) {
		return true;
	}
	$check = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			rv_res_item_group
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
		WHERE
			rv_res_item_group.ac_accomm_room_id = '$resItem[ac_accomm_room_id]'
			AND	rv_reservation_item.rv_item_date_arrive >= '$startDate'
			AND rv_reservation_item.rv_item_date_arrive < '$endDate'

	",4);
	if($check > 0) {
		return false;
	}
	return true;
}
