<?php

/**
 * init.form302.php - PAX analysis report. Full and rooming calendar popup.
 */

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strpos($_POST['url'], "reservation.php?")+16));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$pf_object_id = db_pf_object_by_name("pax_report");
processProfileAction($pf_object_id,$profileFields);

$pf_option_id = applyProfile($pf_object_id,$profileFields);
$title = db_pf_option_get_title($pf_option_id);
if(trim($title) == "") {
	$title = "PAX Analysis Report";
}
$GLOBALS['temp']['title'] = $title;

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id, $pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();

$_SERVER['argv'] = array_pad($_SERVER['argv'],17,"");

$rowHTML = "";
switch($_SERVER['argv'][0]) {
case 737:
	if (!isset($GLOBALS[$form])) {
		$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/room_rep_pax_pop.htm");
	}
	$rowHTML = join("\n",file(__DIR__ . "/../../../public/html/room_rep_pax_pop_rows.htm"));
	// $GLOBALS['temp']['tableWidth'] = "690";//$_SERVER['argv'][17];//"740";
	$GLOBALS['temp']['tableWidth'] = "";//$_SERVER['argv'][17];//"740";
	$GLOBALS['temp']['divWidth'] = "690";
	break;
case 738:
	if (!isset($GLOBALS[$form])) {
		$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/room_rep_pax.htm");
	}   
	$rowHTML = join("\n",file(__DIR__ . "/../../../public/html/room_rep_pax_rows.htm"));
	break;
}  

// Accomm or per date
$propId = $_SERVER['argv'][1];

/* Convert old profiles */
if(!empty($propId) && empty($_SERVER['argv'][16])) {
	$_SERVER['argv'][16] = join(":",$lDB->get("
		SELECT
			ac_accomm_type.ac_accomm_type_ix
		FROM
			ac_accomm_type
			INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		WHERE
			ac_accomm_type.ac_accomm_type_inactive_yn = '0'
			AND pr_business.pr_bus_inactive_yn = '0'
			AND pr_business.pr_business_id = '$propId'
	",3));
}


if($_SERVER['argv'][2] == "" && $_SERVER['argv'][6] == "" && $_SERVER['argv'][16] == "" && $pf_option_id == "") {
	$properties = $lDB->get("
	  	SELECT
  			DISTINCT ac_accomm_type.pr_business_id
	  	FROM
  			sc_accomm
  			INNER JOIN sc_user ON sc_accomm.sc_group_id = sc_user.sc_group_id AND sc_user.pr_user_id = '$GLOBALS[userid]'
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = sc_accomm.ac_accomm_type_id
	",3);


	
	$_SERVER['argv'][16] = join(":",$lDB->get("
		SELECT
			ac_accomm_type.ac_accomm_type_ix
		FROM
			ac_accomm_type
			INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		WHERE
			ac_accomm_type.ac_accomm_type_inactive_yn = '0'
			AND pr_business.pr_bus_inactive_yn = '0'
			AND ac_accomm_type.pr_business_id = '$properties[0]'
	",3));
}


$accommACL= $lDB->get("
	SELECT DISTINCT
		ac_accomm_type.ac_accomm_type_ix
	FROM
		sc_accomm, ac_accomm_type
	WHERE
		sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
		AND sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
",3);
$accommFilter = useFilter("accomm",$_SERVER['argv'][16],"SELECT CONCAT(pr_business.pr_bus_name_short,CONCAT(' - ',ac_accomm_type.ac_accomm_desc)) FROM ac_accomm_type INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id WHERE ac_accomm_type_ix =","rv_reservation_item.ac_accomm_type_id",$accommACL,false,false);

if(!empty($accommFilter['ids'])) {
	$accommWhere = " AND ac_accomm_type.ac_accomm_type_ix IN ('".join("','",explode(":",$accommFilter['ids']))."') ";
} else {
	$accommWhere = "";
}

$propertyCount = $lDB->get("SELECT COUNT(DISTINCT ac_accomm_type.pr_business_id) FROM ac_accomm_type WHERE 1 $accommWhere",4);
if($propertyCount == 1) {
	list($propertyName,$propAbbr) = $lDB->get("
		SELECT DISTINCT
			pr_persona.pr_name_last,
			pr_business.pr_bus_name_short
		FROM
			ac_accomm_type
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
			INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		WHERE
			1 $accommWhere
	",1);
} else {
	$propertyName = $accommFilter['names'];
	$propAbbr = "multi-property"; //strtolower($accommFilter['names']);
}
$GLOBALS['temp']['propertyName'] = $propertyName;



$dateType = $_SERVER['argv'][6];
// Convert old profiles
if($dateType == "1") {
	$dateType = "today";
} elseif($dateType == "2") {
	$dateType = "todayPlus";
} elseif($dateType == "3") {
	$dateType = "range";
} elseif($dateType == "") {
	$dateType = "day";
}

$GLOBALS['temp']['dateTodayChecked'] = "";
$GLOBALS['temp']['dateTodayDaysChecked'] = "";
$GLOBALS['temp']['dateRangeChecked'] = "";
$GLOBALS['temp']['toDatePlus'] = "";

if($_SERVER['argv'][2] == "" || $_SERVER['argc'] < 2){
	$GLOBALS['temp']['dateTodayChecked'] = "checked";
}

switch($dateType) {
case "today":
	$startDate = date("Y-m-d");
	$endDate = $startDate;
	$GLOBALS['temp']['endDateClass'] = "collapse printCollapse";
	$perHead = "Accomm";
	$GLOBALS['temp']['dateTodayChecked'] = "checked";
	break;
case "todayPlus":
	$startDate = date("Y-m-d");
	$dateArray = explode("-",$startDate);
	$plusDays = $_SERVER['argv'][4];
	if(empty($plusDays)) {
		$plusDays = 7;
	}
	$endDate = date("Y-m-d",mktime(12,0,0,$dateArray[1],$dateArray[2]+$plusDays,$dateArray[0]));
	$GLOBALS['temp']['endDateClass'] = "txtb";
	$perHead = "Date";
	$GLOBALS['temp']['dateTodayDaysChecked'] = "checked";
	$GLOBALS['temp']['toDatePlus'] = $plusDays;    
	break;
case "range":
	$startDate = $_SERVER['argv'][2];
	$endDate = $_SERVER['argv'][3];
	$GLOBALS['temp']['endDateClass'] = "txtb";
	$perHead = "Date";
	$GLOBALS['temp']['dateRangeChecked'] = "checked";
	break;
case "day":
	$startDate = $_SERVER['argv'][2];
	$endDate = $startDate;
	$GLOBALS['temp']['endDateClass'] = "collapse printCollapse";
	$perHead = "Accomm";
	break;
}

$GLOBALS['temp']['dateType'] = $dateType;
$GLOBALS['temp']['startDate'] = $startDate;
$GLOBALS['temp']['startDateFmt'] = date("l j M Y",strtotime($startDate));
$GLOBALS['temp']['endDate'] = $endDate;
$GLOBALS['temp']['endDateFmt'] = date("l j M Y",strtotime($endDate));
$GLOBALS['temp']['perHead'] = $perHead;
    
$filterStatus = $_SERVER['argv'][7];
$showHideButtonText = $_SERVER['argv'][15];

$GLOBALS['temp']['filterStatus'] = urldecode($filterStatus);
$GLOBALS['temp']['showHideButtonText'] = $showHideButtonText;

if($filterStatus == "") {
	$GLOBALS['temp']['filterStatus'] = "";
}

if($showHideButtonText == "") {
	$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
}

if($_SERVER['argc'] > 1) {
	if($filterStatus == "") {
		$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";
		$GLOBALS['temp']['showHideButtonText'] = ">> Show Filters";
	}
}

$options = $_SERVER['argv'][10];

$GLOBALS['temp']['advancedClass'] = "collapse printCollapse";
if($_SERVER['argv'][9] != "" || $_SERVER['argv'][13] != "") {
	$GLOBALS['temp']['advancedClass'] = "colLt";
}

$GLOBALS['temp']['todayFmt'] = date("j M Y");

$defaultStartDate = date("Y-m-d");

$confirmCheck = $_SERVER['argv'][11];
$provCheck = $_SERVER['argv'][12];

if(empty($confirmCheck) && empty($provCheck)) {
	$confirmCheck = "1";
	$provCheck = "1";
}

$GLOBALS['temp']['confCheck'] = "";
$GLOBALS['temp']['provCheck'] = "";  
$statusFilter = array();
if($confirmCheck == "1") {
	$GLOBALS['temp']['confCheck'] = "checked";
	$statusFilter[] = "rv_reservation.rf_reservation_status_id = '30'";
}
if($provCheck == "1") {
	$GLOBALS['temp']['provCheck'] = "checked";
	$statusFilter[] = "
		(
			rv_reservation.rf_reservation_status_id = '20'
			AND rv_reservation.rv_provision_expiry_date >= '$defaultStartDate'
		)
	";
}
$statusFilter = " AND ( " . join(" OR ",$statusFilter) . " ) ";


// 'menu report'
if($_SERVER['argv'][0] == 738) {
	$fromDate = useDate("from", $startDate);
	$toDate = useDate("to", $endDate);

	$nationalityFilter = useFilter("nationality",$_SERVER['argv'][9],"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =","rv_reservation.rf_country_id",false,"No nationality","0");

	$sourceFilter = useFilter("source",$_SERVER['argv'][13],"SELECT rf_source.rf_source_desc FROM rf_source WHERE rf_source_ix =","rv_reservation.rf_source_ix",false,"No Source","0");
}  

switch($options & 7) {
case REP_VIEW_HTML:
	$renderMode = "html";
	$renderType = "";
	break;
case REP_VIEW_PDF:
	$renderMode = "pdf";
	$renderType = "view";
	break;
case REP_EMAIL_PDF:
	$renderMode = "pdf";
	$renderType = "email";
	break;
case REP_SEND_PDF:
	$renderMode = "pdf";
	$renderType = "send";
	break;
case REP_VIEW_CSV:
	$renderMode = "csv";
	$renderType = "export";
	break;
}

if(isset($renderMode) && $renderMode == "pdf" && isset($renderType) && $renderType == "email") {
	$pdfName = "PAX_".$propAbbr."_".$startDate;
	$pdfSub = "PAX report for ".$propertyName." on ".chng_date($startDate,"-");
	$attachmentTable = "
		<table border=\"0\" cellspacing=\"0\" width=\"100%\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\"></td>
			<td id=\"attachmentLabel\" width=\"100%\">$pdfName.pdf</td>
		</tr>
		</table>
	";
	$newOptions = ($options & ~3) + 3;
	$formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,10))."+$newOptions+".join("+",array_slice($_SERVER['argv'],11));

	// echo $formAction."<BR>";

	$GLOBALS[$form]->FormHTML =
		str_replace("!formAction!",$formAction,
		str_replace("!attachmentInfo!",$attachmentTable,
		str_replace("!attachmentName!",$pdfName.".pdf",
		str_replace("!hasAttachment!","expand",
		str_replace("!emailBody!","",
		str_replace("!emailSubject!",$pdfSub,
		join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));

	// get principal
	$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
	$principalInfo = getPersonaDetail($principalId);
	$resOfficeInfo = getPersonaDetail($resOfficeId);

	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	$GLOBALS['temp']['princName'] = $principalInfo['name'];
	$GLOBALS['temp']['fax'] = $resOfficeInfo['fax'];
	$GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
	$userId = $_SESSION['userid'];
	$GLOBALS['temp']['emailFrom'] = $lDB->get("
		SELECT
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '".$userId."'
	", 4);
	$GLOBALS['temp']['emailTo'] = "";
}

$GLOBALS['temp']['dataClass'] = "collapse printCollapse"; 
if($_SERVER['argc'] > 1) {
	// Prepare data

	if (isset($nationalityFilter['where'])){
		$nationalityWhere = $nationalityFilter['where'];
	} else {
		$nationalityWhere = "";
	}

	if (isset($sourceFilter['where'])){
		$sourceWhere = $sourceFilter['where'];
	} else {
		$sourceWhere = "";
	}

	if($perHead == "Accomm") {
		$accomm = $lDB->get("
			SELECT DISTINCT
				ac_accomm_type.ac_accomm_type_ix,
				ac_accomm_type.ac_accomm_desc,
				ac_accomm_type.pr_business_id,
				pr_persona.pr_name_last,
				COUNT(*) as ac_accomm_room_count		
			FROM
				ac_accomm_room
				INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
				INNER JOIN pr_business on pr_business.pr_business_id = ac_accomm_type.pr_business_id
			WHERE
				ac_accomm_room.ac_accomm_room_inactive_yn = '0'
				$accommWhere
			GROUP BY
				ac_accomm_type.ac_accomm_type_ix
			ORDER BY
				pr_business.pr_business_sequence,	
				ac_accomm_type.pr_business_id,				
				ac_accomm_type.ac_accomm_sequence,
				ac_accomm_type.ac_accomm_type_ix
		",2);
		$properties = array();
		foreach($accomm as $item) {
			$properties[] = $item['pr_business_id'];
		}
		$properties = array_unique($properties);
		$lastProperty = "";
		$data = array();
		$totalRooms = 0;
		foreach($accomm as $item) {
			if(sizeof($properties) > 1 && $lastProperty != $item['pr_business_id']) {
				$data[] = array(
					'type'=>"header",
					'id'=>$item['pr_business_id'],
					'rowHead'=>$item['pr_name_last']
				);
				$lastProperty = $item['pr_business_id'];
			}
			$data[] = array(
				'type'=>"accomm",
				'id'=>$item['ac_accomm_type_ix'],
				'rowHead'=>$item['ac_accomm_desc'],
				'rooms'=>$item['ac_accomm_room_count']
			);
			$totalRooms += $item['ac_accomm_room_count'];
		}
	} else {
		$days = dateSubtract($endDate,$startDate)+1;
		$dateArray = explode("-",$startDate);

		$totalRooms = $lDB->get("
			SELECT
				COUNT(*) as ac_accomm_room_count		
			FROM
				ac_accomm_room
				INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
			WHERE
				ac_accomm_room.ac_accomm_room_inactive_yn = '0'
				$accommWhere
		",4);
		$data = array();
		for($count = 0; $count < $days; $count++) {
			$data[] = array(
				'type'=>"date",
				'id'=>date("Y-m-d",mktime(12,0,0,$dateArray[1],$dateArray[2]+$count,$dateArray[0])),
				'rowHead'=>date("j M Y l",mktime(12,0,0,$dateArray[1],$dateArray[2]+$count,$dateArray[0])),
				'rooms'=>$totalRooms
			);
		}
	}

	$paxSQL = array(
		'in'=>"(rv_reservation_item.rv_item_date_arrive <= '!date!' AND rv_reservation_item.rv_item_date_depart > '!date!')",
		'arr'=>"(rv_reservation_item.rv_item_date_arrive = '!date!' AND rv_reservation_item.rv_item_date_depart > '!date!')",
		'stay'=>"(rv_reservation_item.rv_item_date_arrive < '!date!' AND rv_reservation_item.rv_item_date_depart > '!date!')",
		'dep'=>"(rv_reservation_item.rv_item_date_arrive < '!date!' AND rv_reservation_item.rv_item_date_depart = '!date!')"
	);

	$totals = array();
	foreach($paxSQL as $paxKey=>$sql) {
		$totals[$paxKey."RmTotal"] = 0;
		$totals[$paxKey."AdTotal"] = 0;
		$totals[$paxKey."ChTotal"] = 0;
		$totals[$paxKey."Total"] = 0;
	}

	foreach($data as $key=>$item) {
		if($item['type'] == "header") {
			continue;
		} elseif($item['type'] == "date") {
			$accommWhere = $accommFilter['where'];
			$date = $item['id'];
		} else {
			$accommWhere = "AND rv_reservation_item.ac_accomm_type_id = '$item[id]'";
			$date = $startDate;
		}
		foreach($paxSQL as $paxKey=>$sql) {
			$pax = $lDB->get("
				SELECT
					SUM(rv_reservation_item.rv_item_accomm_count) as rooms,
					SUM(rv_reservation_item.rv_item_adult_count*rv_reservation_item.rv_item_accomm_count) as adult,
					SUM(rv_reservation_item.rv_item_child_count*rv_reservation_item.rv_item_accomm_count) as child,
					SUM((rv_reservation_item.rv_item_adult_count + rv_reservation_item.rv_item_child_count) *rv_reservation_item.rv_item_accomm_count ) as total
				FROM
					rv_reservation_item
					INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
				WHERE
					".str_replace("!date!",$date,$sql)."
					$accommWhere
					$nationalityWhere
					$sourceWhere
					$statusFilter 
		   	",1);			

			if(empty($pax['rooms'])) { $pax['rooms'] = "0"; }
			if(empty($pax['adult'])) { $pax['adult'] = "0"; }
			if(empty($pax['child'])) { $pax['child'] = "0"; }
			if(empty($pax['total'])) { $pax['total'] = "0"; }

			$data[$key][$paxKey."NumRooms"] = $pax['rooms'];
			$data[$key][$paxKey."PercRooms"] = round($pax['rooms'] / $item['rooms'] * 100);
			$data[$key][$paxKey."NumAdlts"] = $pax['adult'];
			$data[$key][$paxKey."NumChld"] = $pax['child'];
			$data[$key][$paxKey."Total"] = $pax['total'];

			$totals[$paxKey."RmTotal"] += $pax['rooms'];
			$totals[$paxKey."AdTotal"] += $pax['adult'];
			$totals[$paxKey."ChTotal"] += $pax['child'];
			$totals[$paxKey."Total"] += $pax['total'];
		}
	}

	if(isset($renderMode) && $renderMode == "html") {
        $url = "reservation.php?" . join("+",$_SERVER['argv']);
        setLastReport($url,$pf_option_id=false);
		$GLOBALS['temp']['dataClass'] = "expand"; 
		$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));		

		$headerHTML = "
			<tr>
				<td colspan=\"18\" class=\"colLt bl br bb txtb\">!rowHead!</td>
			</tr>
		";

		$rows = "";
		foreach($data as $item) {
			if($item['type'] == "header") {
				$html = $headerHTML;
			} else {
				$html = $rowHTML;
			}
			$rows .= showpage($item,$html);
		}
		$GLOBALS['temp']['rows'] = $rows;

		$GLOBALS['temp'] = array_merge($GLOBALS['temp'],$totals);
		$GLOBALS['temp']['headAccNum'] = "(".$totalRooms.")";
		
	}

	if(isset($renderMode) && $renderMode == "pdf" && isset($renderType) && ($renderType == "view" || $renderType == "send")) {  
		$pdf = new PDF("PAX Report");

		if($perHead == "Accomm") {
			$dateVal = chng_date($startDate,"-");
			$hh = "";
			$rh = "";
		} else {
			$dateVal = chng_date($startDate,"-")." to ".chng_date($endDate,"-");
			$hh = "3.5";
			$rh = "7";
		}

		$reportHeader = array(
			array('name'=>"Property / Accommodation",'value'=>$accommFilter['names']),
			array('name'=>"Date",'value'=>$dateVal)
		);


		if($_SERVER['argv'][0] == 738) {
			$status = array();
			if($confirmCheck == "1") {
				$status[] = "Confirmed";
			}
			if($provCheck == "1") {
				$status[] = "Provisional";
			}
			array_push($reportHeader,array('name'=>"Status",'value'=>join(", ",$status)));
		}
			
		$pdf->ReportHeader("PAX Report",$reportHeader);
   
		$pdf->SetFont('Arial', '', 7);
		$pdf->Row(array(
			array('width'=>"100%", 'data'=>"PAX analysis for ".$accommFilter['names']." - ".$dateVal, 'style'=>"B")
		));
    
		$pdf->Ln(1);
		$pdf->SetFont('Arial', '', 6);
		$pdf->Row(array(
			array('width'=>"14%", 'data'=>"", 'border'=>"TLBR", 'fill'=>1),
			array('width'=>"26%", 'data'=>"In-House", 'border'=>"TLBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"20%", 'data'=>"Arrive", 'border'=>"TLBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"20%", 'data'=>"Stay Over", 'border'=>"TLBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"20%", 'data'=>"Depart", 'border'=>"TLBR", 'fill'=>1, 'align'=>"C")
		));
  
		$pdf->Row(array(
			array('width'=>"14%", 'data'=>$perHead, 'border'=>"LBR", 'fill'=>1),
			array('width'=>"5%", 'data'=>"Rooms", 'border'=>"TLBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"6%", 'data'=>"Room %", 'border'=>"TLBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"15%", 'data'=>"PAX", 'border'=>"TLBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"5%", 'data'=>"Rooms", 'border'=>"TLBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"15%", 'data'=>"PAX", 'border'=>"TLBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"5%", 'data'=>"Rooms", 'border'=>"TLBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"15%", 'data'=>"PAX", 'border'=>"TLBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"5%", 'data'=>"Rooms", 'border'=>"TLBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"15%", 'data'=>"PAX", 'border'=>"TLBR", 'fill'=>1, 'align'=>"C")
		));

		$pdf->Row(array(
			array('width'=>"14%", 'data'=>"", 'border'=>"LBR", 'fill'=>1),
			array('width'=>"5%", 'data'=>"", 'border'=>"LBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"6%", 'data'=>"", 'border'=>"LBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"5%", 'data'=>"Adlts", 'border'=>"TLBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"5%", 'data'=>"Chld", 'border'=>"TLBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"5%", 'data'=>"Total", 'border'=>"TLBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"5%", 'data'=>"", 'border'=>"LBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"5%", 'data'=>"Adlts", 'border'=>"TLBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"5%", 'data'=>"Chld", 'border'=>"TLBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"5%", 'data'=>"Total", 'border'=>"TLBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"5%", 'data'=>"", 'border'=>"LBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"5%", 'data'=>"Adlts", 'border'=>"TLBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"5%", 'data'=>"Chld", 'border'=>"TLBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"5%", 'data'=>"Total", 'border'=>"TLBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"5%", 'data'=>"", 'border'=>"LBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"5%", 'data'=>"Adlts", 'border'=>"TLBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"5%", 'data'=>"Chld", 'border'=>"TLBR", 'fill'=>1, 'align'=>"C"),
			array('width'=>"5%", 'data'=>"Total", 'border'=>"TLBR", 'fill'=>1, 'align'=>"C")
		)); 

		foreach($data as $item) {
			if($item['type'] == "header") {
				$pdf->Row(array(
					array('width'=>"100%",'data'=>$item['rowHead'],'border'=>"LRTB",'fill'=>1)
				));
			} else {
				$pdf->Row(array(
					array('width'=>"14%", 'height'=>$hh, 'data'=>$item['rowHead'], 'border'=>"TLBR", 'fill'=>1),

					array('width'=>"5%", 'height'=>$rh, 'data'=>$item['inNumRooms'], 'border'=>"LBR", 'align'=>"C"),
					array('width'=>"6%", 'height'=>$rh, 'data'=>$item['inPercRooms']." %", 'border'=>"LBR", 'align'=>"C"),
					array('width'=>"5%", 'height'=>$rh, 'data'=>$item['inNumAdlts'], 'border'=>"TLBR", 'align'=>"C"),
					array('width'=>"5%", 'height'=>$rh, 'data'=>$item['inNumChld'], 'border'=>"TLBR", 'align'=>"C"),
					array('width'=>"5%", 'height'=>$rh, 'data'=>$item['inTotal'], 'border'=>"TLBR", 'fill'=>1, 'align'=>"C"),

					array('width'=>"5%", 'height'=>$rh, 'data'=>$item['arrNumRooms'], 'border'=>"LBR", 'align'=>"C"),
					array('width'=>"5%", 'height'=>$rh, 'data'=>$item['arrNumAdlts'], 'border'=>"TLBR", 'align'=>"C"),
					array('width'=>"5%", 'height'=>$rh, 'data'=>$item['arrNumChld'], 'border'=>"TLBR", 'align'=>"C"),
					array('width'=>"5%", 'height'=>$rh, 'data'=>$item['arrTotal'], 'border'=>"TLBR", 'fill'=>1, 'align'=>"C"),
					
					array('width'=>"5%", 'height'=>$rh, 'data'=>$item['stayNumRooms'], 'border'=>"LBR", 'align'=>"C"),
					array('width'=>"5%", 'height'=>$rh, 'data'=>$item['stayNumAdlts'], 'border'=>"TLBR", 'align'=>"C"),
					array('width'=>"5%", 'height'=>$rh, 'data'=>$item['stayNumChld'], 'border'=>"TLBR", 'align'=>"C"),
					array('width'=>"5%", 'height'=>$rh, 'data'=>$item['stayTotal'], 'border'=>"TLBR", 'fill'=>1, 'align'=>"C"),

					array('width'=>"5%", 'height'=>$rh, 'data'=>$item['depNumRooms'], 'border'=>"LBR", 'align'=>"C"),
					array('width'=>"5%", 'height'=>$rh, 'data'=>$item['depNumAdlts'], 'border'=>"TLBR", 'align'=>"C"),
					array('width'=>"5%", 'height'=>$rh, 'data'=>$item['depNumChld'], 'border'=>"TLBR", 'align'=>"C"),
					array('width'=>"5%", 'height'=>$rh, 'data'=>$item['depTotal'], 'border'=>"TLBR", 'fill'=>1, 'align'=>"C")
				));
			}
		}

		$pdf->Row(array(
			array('width'=>"14%", 'height'=>$rh, 'data'=>"Total", 'border'=>"TLBR", 'fill'=>1, 'style'=>"B"),
			array('width'=>"5%", 'height'=>$rh, 'data'=>$totals['inRmTotal'], 'border'=>"LBR", 'align'=>"C", 'fill'=>1, 'style'=>"B"),
			array('width'=>"6%", 'height'=>$rh, 'data'=>"", 'border'=>"LBR", 'align'=>"C", 'fill'=>1, 'style'=>"B"),    
			array('width'=>"5%", 'height'=>$rh, 'data'=>$totals['inAdTotal'], 'border'=>"TLBR", 'align'=>"C", 'fill'=>1, 'style'=>"B"),
			array('width'=>"5%", 'height'=>$rh, 'data'=>$totals['inChTotal'], 'border'=>"TLBR", 'align'=>"C", 'fill'=>1, 'style'=>"B"),
			array('width'=>"5%", 'height'=>$rh, 'data'=>$totals['inTotal'], 'border'=>"TLBR", 'align'=>"C", 'fill'=>1, 'style'=>"B"),

			array('width'=>"5%", 'height'=>$rh, 'data'=>$totals['arrRmTotal'], 'border'=>"LBR", 'align'=>"C", 'fill'=>1, 'style'=>"B"),
			array('width'=>"5%", 'height'=>$rh, 'data'=>$totals['arrAdTotal'], 'border'=>"TLBR", 'align'=>"C", 'fill'=>1, 'style'=>"B"),
			array('width'=>"5%", 'height'=>$rh, 'data'=>$totals['arrChTotal'], 'border'=>"TLBR", 'align'=>"C", 'fill'=>1, 'style'=>"B"),
			array('width'=>"5%", 'height'=>$rh, 'data'=>$totals['arrTotal'], 'border'=>"TLBR", 'align'=>"C", 'fill'=>1, 'style'=>"B"),

			array('width'=>"5%", 'height'=>$rh, 'data'=>$totals['stayRmTotal'], 'border'=>"LBR", 'align'=>"C", 'fill'=>1, 'style'=>"B"),
			array('width'=>"5%", 'height'=>$rh, 'data'=>$totals['stayAdTotal'], 'border'=>"TLBR", 'align'=>"C", 'fill'=>1, 'style'=>"B"),
			array('width'=>"5%", 'height'=>$rh, 'data'=>$totals['stayChTotal'], 'border'=>"TLBR", 'align'=>"C", 'fill'=>1, 'style'=>"B"),
			array('width'=>"5%", 'height'=>$rh, 'data'=>$totals['stayTotal'], 'border'=>"TLBR", 'align'=>"C", 'fill'=>1, 'style'=>"B"),

			array('width'=>"5%", 'height'=>$rh, 'data'=>$totals['depRmTotal'], 'border'=>"LBR", 'align'=>"C", 'fill'=>1, 'style'=>"B"),
			array('width'=>"5%", 'height'=>$rh, 'data'=>$totals['depAdTotal'], 'border'=>"TLBR", 'align'=>"C", 'fill'=>1, 'style'=>"B"),
			array('width'=>"5%", 'height'=>$rh, 'data'=>$totals['depChTotal'], 'border'=>"TLBR", 'align'=>"C", 'fill'=>1, 'style'=>"B"),
			array('width'=>"5%", 'height'=>$rh, 'data'=>$totals['depTotal'], 'border'=>"TLBR", 'align'=>"C", 'fill'=>1, 'style'=>"B"),
		));
		$pdf->Ln(2);		

		if ($renderType == "view") {
			pdf_view($pdf);
		} elseif ($renderType == "send") {
			pdf_send($pdf,"pax_report.pdf");
		}
	}	

	if(isset($renderMode) && $renderMode == "csv") {  
		$csvFile = array();		
		array_push($csvFile,array("Pax Report"));
		array_push($csvFile,array());
		array_push($csvFile,array("Property / Accommodation",$accommFilter['names']));
		array_push($csvFile,array("Date",chng_date($startDate,"-")));
		array_push($csvFile,array());
		array_push($csvFile,array($perHead,"In-House","","","","","Arrive","","","","Stay Over","","","","Depart"));
		array_push($csvFile,array("","Rooms","Room %","PAX","","","Rooms","PAX","","","Rooms","PAX","","","Rooms","PAX"));
		array_push($csvFile,array("","","","Adlts","Chld","Total","","Adlts","Chld","Total","","Adlts","Chld","Total","","Adlts","Chld","Total"));   

		foreach($data as $item) {
			if($item['type'] == "header") {
				array_push($csvFile,array($item['rowHead']));
			} else {
				array_push($csvFile,array(
					$item['rowHead'],
					$item['inNumRooms'], $item['inPercRooms']."%", $item['inNumAdlts'], $item['inNumChld'], $item['inTotal'],
					$item['arrNumRooms'],$item['arrNumAdlts'],$item['arrNumChld'],$item['arrTotal'],
					$item['stayNumRooms'],$item['stayNumAdlts'],$item['stayNumChld'],$item['stayTotal'],
					$item['depNumRooms'],$item['depNumAdlts'],$item['depNumChld'],$item['depTotal']
				));				
			}
		}

		array_push($csvFile,array(
			"Total",
			$totals['inRmTotal'],"",$totals['inAdTotal'],$totals['inChTotal'],$totals['inTotal'],
			$totals['arrRmTotal'],$totals['arrAdTotal'],$totals['arrChTotal'],$totals['arrTotal'],
			$totals['stayRmTotal'],$totals['stayAdTotal'],$totals['stayChTotal'],$totals['stayTotal'],
			$totals['depRmTotal'],$totals['depAdTotal'],$totals['depChTotal'],$totals['depTotal']
		));

		array_push($csvFile,array());    			
		
		csv_output("pax_report_".chng_date(date("Y-m-d"),"-").".csv",$csvFile);
	}
}

function getPersonaDetail($personaId) {
	$detail = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_first,
			pr_persona.pr_name_second,
			pr_persona.pr_name_last,
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '".$personaId."'",2);
	$detail = $detail[0];
	$name = "";
	if(trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
		$name .= $detail['pr_name_first'] . " ";
	}
	if(trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
		$name .= $detail['pr_name_second'] . " ";
	}
	if(trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
		$name .= $detail['pr_name_last'] . " ";
	}
	$result = array();
	$result['name'] = trim($name);
	$result['fax'] = getPersonaFax($personaId);
	$result['telephone'] = getPersonaTelephone($personaId);
	$result['email'] = $detail['pr_email'];
	if(trim($result['email']) == "" || $result['email'] == "0") {
		$result['email'] = "";
	}
	return $result;
}
function getPersonaFax($personaId) {
	$fax = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone, rf_phone_type
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
			AND rf_phone_type.rf_phone_type_sys_code = '1'
	",4);
	if(trim($fax) == "" || $fax == "0") {
		$fax = "";
	}
	return $fax;
}

function getPersonaTelephone($personaId) {
	$tel = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND pr_phone.pr_default_yn = '1'
	",4);
	if(trim($tel) == "" || $tel == "0") {
		$tel = "";
	}
	return $tel;
}
