<?php

/*
 * $Id: init.form304.php,v 1.36 2013-03-13 16:53:11 light Exp $
 *
 * $Log: init.form304.php,v $
 * Revision 1.36  2013-03-13 16:53:11  light
 * Bug #8129 - ZRA: Invoice date in the future
 *
 */

/**
 * init.form304.php - Arrival / departure folios report popup
 * Job: 740
 * Function: 81 (Rooming Calendar)
 */

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
	$GLOBALS['temp']['url'] = $_POST['url'];
} else {
	$GLOBALS['temp']['url'] = "";
}
  
if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/room_rep_folios.htm");
}  

if($GLOBALS['jobLevelArray'][740] < 10) {
	$disabled = "disabled";
	$readonly = true;
} else {
	$readonly = false;
	$disabled = "";
}

$allowInvoiceCreate = $GLOBALS['funLevelArray'][108] >= 10;
$allowInvoiceVoid = db_sc_group_get_user_setting("sc_grp_res_void_invoice_yn") == "1";

$fiscal_status = '';
$fiscalMessage = '';
$fiscalStatusHidePdf = '';
$fiscalStatusHide = ' collapse';

$fiscalStatusCheck = updateIncompleteFiscalInvoices();

// Accomm or per date
$propId = $_SERVER['argv'][1];
$startDate = $_SERVER['argv'][2];
if($startDate == "0" || $startDate == ""){
	$startDate = date("Y-m-d");
}
$GLOBALS['temp']['startDate'] = chng_date($startDate,"-");
$GLOBALS['temp']['weekDay'] = date("l",strtotime($startDate));

$endDate = $_SERVER['argv'][3];
$GLOBALS['temp']['endDate'] = "";

$GLOBALS['temp']['propId'] = $propId;
$propertyName = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '$propId'",4);
$propAbbr = $GLOBALS['lDB']->get("SELECT pr_bus_name_short FROM pr_business WHERE pr_business_id = '$propId'",4);
$GLOBALS['temp']['propertyName'] = $propertyName;

$options = $_SERVER['argv'][4]; 
$reportType = $_SERVER['argv'][5];

// START - Process any invoice requests
if(!$readonly && isset($_POST['invoiceFolio']) && $_POST['invoiceFolio'] && isset($_POST['invoiceDate']) && $_POST['invoiceDate'] && $allowInvoiceCreate) {
	$newInvoice = db_fn_invoice_create($_POST['invoiceFolio'], $_POST['invoiceDate'], $_POST['invoiceExch']);
}

if(!$readonly && isset($_POST['voidId']) && $_POST['voidId'] && $allowInvoiceVoid) {
	db_fn_invoice_void($_POST['voidId']);
}

// END   - Process any invoice requests

switch($options & 7) {
case REP_VIEW_HTML:
	$renderMode = "html";
	$renderType = "";
	break;
case REP_VIEW_PDF:
	$renderMode = "pdf";
	$renderType = "view";
	break;
case REP_EMAIL_PDF:
	$renderMode = "pdf";
	$renderType = "email";
	break;
case REP_SEND_PDF:
	$renderMode = "pdf";
	$renderType = "send";
	break;
case REP_VIEW_CSV:
	$renderMode = "csv";
	$renderType = "export";
	break;
}

// Determine if it is Arrival Folios or Departure Folios
switch($reportType){
case "depart":
	$arrDepSql = " AND rv_reservation_item.rv_item_date_depart = '$startDate'";
	$GLOBALS['temp']['repHeader'] = "Departure";
	$repHeader = "departure";
	break;
case "arrive":
	$arrDepSql = " AND rv_reservation_item.rv_item_date_arrive = '$startDate'";
	$GLOBALS['temp']['repHeader'] = "Arrival";
	$repHeader = "arrival";			
	break;
}

// [START] HTML
#list of reservations where itinerary item is at property
$resList = $GLOBALS['lDB']->get("
	SELECT DISTINCT
		rv_reservation.rv_reservation_ix as resId,
		rv_reservation.rv_res_name as resName,
		rf_reservation_status.rf_reservation_status_desc as resStatus
	FROM  
		rv_reservation_item
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
		LEFT JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id  
	WHERE
		rv_reservation_item.pr_business_id = '$propId'
		$arrDepSql
		AND (
			rv_reservation.rf_reservation_status_id = '30'
			OR rv_reservation.rf_reservation_status_id = '20'
			OR rv_reservation.rf_reservation_status_id = '25'
		)
	ORDER BY
		rv_reservation.rv_reservation_ix ASC
",2);

#Get list of default Custom Notes
$customNotes = $GLOBALS['lDB']->get("
	SELECT
		rf_note_custom.rf_note_custom_ix as custNoteId
	FROM
		rf_note_custom
",2); 
$customIds = array();
if(sizeof($customNotes) > 0) {
	foreach($customNotes as $custom) {
		// get defaults   		
		$dbInd = $GLOBALS['lDB']->get("SELECT rf_database.rf_db_env_type_ind FROM rf_database WHERE rf_database.rf_db_code = '$GLOBALS[dbcode]'",4);
		if($dbInd == 2) {
			$checkDB = "AND rf_note_cust_default.rf_db_code = ''";
		} else {
			$checkDB = "AND rf_note_cust_default.rf_db_code = '$GLOBALS[dbcode]'";              
		}
		$def = $GLOBALS['lDB']->get("
			SELECT
				rf_note_cust_def_ext_inv_yn,
				rf_note_cust_def_ext_summ_yn,
				rf_note_cust_def_ext_pro_yn,
				rf_note_cust_def_int_inv_yn,
				rf_note_cust_def_int_summ_yn,
				rf_note_cust_def_int_pro_yn
			FROM
				rf_note_cust_default
			WHERE
				rf_note_cust_default.rf_note_custom_id = '$custom[custNoteId]'
				$checkDB
		",1);
		$check = "";
		if($userStatusId < 2) {
			if($def['rf_note_cust_def_ext_pro_yn'] == 1) {
				array_push($customIds,$custom['custNoteId']); 
			}
		} else {
			if($def['rf_note_cust_def_int_pro_yn'] == 1) {
				array_push($customIds,$custom['custNoteId']); 
			}
		}    
	}
	$GLOBALS['temp']['customIds'] = join(",",$customIds);
}

#Get the other itinerary items per reservation
$itemList = array();
$folioList = "";
$foliohtml = Join("\n",File(__DIR__ . "/../../../public/html/room_rep_folios_frows.htm"));
$folioRowHtml = "
	<tr valign=\"top\" !fiscalMessage!>
		<td class=\"br v-alignm uk-text-center\"><input type=\"checkbox\" class=\"printCollapse uk-checkbox\" !disable! name=\"folioCheck\" id=\"!fn_folio_ix!\"></td>
		<td class=\"br\" id=\"folio\">
			<div class=\"uk-flex\">
				<div class=\"uk-width-2-5 !grey! !rowColour! v-alignm uk-text-center\">
					!folioNum!
				</div>
				<div class=\"!grey! !rowColour! uk-width-expand\">
					!folioPayee!
				</div>
			</div>
		</td>  
		<td class=\"br !grey! !rowColour!\" id=\"payPlan\">!folioPayPlan!</td>
		<td class=\"br !grey! !rowColour!\" id=\"nett\" align=\"right\">!folioNett! !folioCurr!</td>
		<td class=\"br !grey! !rowColour!\" id=\"paid\" align=\"right\">!folioPaid! !folioCurr!</td>
		<td class=\"br !grey! !red! !rowColour!\" id=\"outstand\" align=\"right\">!folioOutstand! !folioCurr!</td>
		<td class=\"br\" align=\"center\">
			<button type=\"button\" class=\"btn btn-ns btn-icon !fiscalHidePdf! printCollapse\" onclick=\"openPDF('!fn_folio_ix!','!fn_invoice_ix!');\" onmouseover=\"overlib('<span class=txts>Open document (folio/invoice) as PDF</span>',LEFT,WIDTH,200);\" onmouseout=\"nd();\"><i class=\"material-icons\">picture_as_pdf</i></button>
			<button type=\"button\" class=\"btn btn-ns btn-icon printCollapse\" background-position:center; \"  onclick=\"showFolio('!fn_folio_ix!','!fn_invoice_ix!');\" onmouseover=\"overlib('<span class=txts>Open document (folio/invoice)</span>',LEFT,WIDTH,160);\" onmouseout=\"nd();\"><i class=\"material-icons\">description</i></button>
			<button $disabled type=\"button\" class=\"btn btn-ns btn-icon printCollapse\" onclick=\"event.cancelBubble = true; nd(); showPaymentPopup(event,'!fn_folio_ix!','!rv_reservation_ix!');\" onMouseOver=\"overlib('<span class=txts>Payments</span>',LEFT,WIDTH,77)\"; onMouseOut=\"nd()\"><i class=\"material-icons\">credit_card</i></button>
			<button $disabled type=\"button\" class=\"btn btn-ns btn-icon printCollapse\" style=\"!showInvoiceButton! background-position:center;\" onclick=\"event.cancelBubble = true; showHide(event,'!fn_folio_ix!',!exchangeNeeded!,!exchangeRate!,'!rf_currency_symbol!','!business_currency_symbol!','!invoiceDate!','!invoiceMaxDate!','!allowFutureInvoice!',!outstanding!);\" onMouseOver=\"overlib('<span class=txts>Generate invoice</span>',LEFT,WIDTH,110)\"; onMouseOut=\"nd()\"><i class=\"material-icons\">restore_page</i></button>
			<button $disabled type=\"button\" class=\"btn btn-ns btn-icon printCollapse\" style=\"!showVoidButton! background-position:center;\" onMouseOver=\"overlib('<span class=txts>Void invoice</span>',LEFT,WIDTH,90,OFFSETX,15)\"; onMouseOut=\"nd()\" onclick=\"event.cancelBubble = true; voidInvoice('!fn_invoice_ix!','!hasBatch!');\"><i class=\"material-icons\">cancel</i></button>
			<button $disabled type=\"button\" class=\"btn btn-ns btn-icon !fiscalStatusHide! printCollapse\" style=\"background-position:center;\" onmouseover=\"overlib('<span class=txts>Query fiscal status</span>',LEFT,WIDTH,120);\" onmouseout=\"nd();\" onclick=\"event.cancelBubble = true; showFiscalInfoByInvoice('!folioNum!');\">!fiscal_status!</button>
		</td>
	</tr>
";

foreach($resList as $resitem) {
	$resName = $resitem['resName'];
	$list = $lDB->get("SELECT rv_reservation_item_ix FROM rv_reservation_item WHERE rv_reservation_id = '$resitem[resId]'",3);  
  
	foreach($list as $listItem) {
		$resItemDetail = getItemDetails($listItem);
		$resItemDetail['folioRows'] = "";
		array_push($itemList,$resItemDetail);
	}
    
	$folioList = getFolios($resitem['resId'],$dbcode);
	$folioRows = "";
	foreach($folioList as $fItem) {
		$fiscal_status = '';
		$fiscalStatusHidePdf = '';
		$fiscalStatusHide = ' collapse';
		$fiscalMessage = '';

		$exchangeNeeded = "false";
		if($fItem['rf_currency_id'] != $fItem['business_currency_id']) {
			// An exchange rate is required...
			$exchangeNeeded = "true";
			$exchangeRate = db_rf_exchange_rate_get_rate_by_all($fItem['rf_currency_id'],$fItem['business_currency_id']);
			if(empty($exchangeRate)) {
				$exchangeRate = "''";
			}
		} else {
			$exchangeNeeded = "false";
			$exchangeRate = "1";
		}
		$fItem['exchangeNeeded'] = $exchangeNeeded;
		$fItem['exchangeRate'] = $exchangeRate;

		$fItem['showInvoiceButton'] = "";
		$fItem['showVoidButton'] = " display: none; ";
		$fItem['hasBatch'] = "0";
		$fItem['doc'] = "bFolio";
		$fItem['openDoc'] = "openPDF('$fItem[fn_folio_ix]')";
		$fItem['docOverlib'] = "<span class=txts>View Proforma</span>";    

		$hasTBA = false;
		$resItemList = $GLOBALS['lDB']->get("SELECT rv_reservation_item_ix FROM rv_reservation_item WHERE rv_reservation_id = '$fItem[rv_reservation_ix]'",3);
		foreach($resItemList as $resItem) {
			$resCompCount = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM rv_res_item_comp WHERE rv_reservation_item_id = '$resItem'",4);
			if($resCompCount < 1) { $hasTBA = true; }
		}
		$allowInvoice = $fItem['rf_reservation_status_id'] >= 30 && canEditDB($fItem['fn_folio_db']) && !$hasTBA && $allowInvoiceCreate;
		$invoiceExists = trim($fItem['fn_invoice_ix']) != "" && $fItem['fn_inv_status_ind'] != "8";

		if($invoiceExists) {
			$fItem['folioNum'] = $fItem['fn_invoice_ix'];
		}

		if($invoiceExists || !$allowInvoice) {
			$fItem['showInvoiceButton'] = " display: none; ";
			if($invoiceExists && canEditDB($fItem['fn_folio_db'])) {
				$fItem['showVoidButton'] = "";
				if(!$allowInvoiceVoid) {
					$fItem['showVoidButton'] = " display: none; ";
				}
				if($fItem['fn_batch_ix'] != "") {
					$fItem['hasBatch'] = "1";
					if($fItem['fn_batch_closed_yn'] == "1") {
						$fItem['showVoidButton'] = " display: none; ";
					}
				}
				$fItem['doc'] = "bInvoice";
				$fItem['openDoc'] = "openPDF('$fItem[fn_folio_ix]','$fItem[fn_invoice_ix]')";
			    $fItem['docOverlib'] = "<span class=txts>View Invoice</span>";
			}
		}

		$fiscal_status = '';
		$fiscalMessage = '';
		$fiscalStatusHidePdf = '';
		$fiscalStatusHide = ' collapse';
		
		if (checkFiscalisationByInvoice($fItem['fn_invoice_ix'])) {
			// 1 = Pending, 2 = Verified, 3 = Rejected, 4 = Error, 9 = Zero folio
			
			$fiscalStatusHidePdf = " hidden";
			$fiscal_status = '<i class="material-icons txtred">report</i>';
			$item['showVoidButton'] = " visibility: hidden; ";
	
			switch ($fItem['fn_inv_fiscal_status_ind']) {
				case 1:
					$fiscalMessage = "title='Fiscal status: Pending'";
					break;
				case 2:
					$fiscalMessage = "title='Fiscal status: Verified'";
					$fiscalStatusHidePdf = '';
					$fiscalStatusHide = '';
					$fiscal_status = '<i class="material-icons">check_circle</i>';
					break;
				case 3:
					$fiscalMessage = "title='Fiscal status: Rejected'";
					break;
				case 4:
					$fiscalMessage = "title='Fiscal status: Error'";
					break;
				case 9:
					$fiscalMessage = "title='Fiscal status: Zero total not submitted'";
					$fiscalStatusHidePdf = '';
					$fiscal_status = '';
					break;
				default:
					$fiscalMessage = "title='Fiscal status: Not Submitted'";
			}
		}
		$fItem['fiscal_status'] = $fiscal_status;
		$fItem['fiscalStatusHidePdf'] = $fiscalStatusHidePdf;
		$fItem['fiscalStatusHide'] = $fiscalStatusHide;
		$fItem['fiscalMessage'] = $fiscalMessage;
		$folioRows .= showpage($fItem,$folioRowHtml);  	
	}    
	$folioRows = str_replace("!folios!",$folioRows,$foliohtml);

	$itemList[sizeof($itemList)-1]['folioRows'] = $folioRows;
	$folioRows = "";
}

$reshtml = Join("\n",File(__DIR__ . "/../../../public/html/room_rep_folios_rows.htm"));
$lastRes = "";
$resRows = "";
foreach($itemList as $item) {
	if($item['rv_reservation_id'] == $lastRes) {
		$item['resId'] = "&nbsp;";
		$item['resName'] = "&nbsp;";
		$item['bt'] = "";
	} else {
		$item['resId'] = $item['rv_reservation_id'];
		$item['resName'] = $lDB->get("SELECT rv_reservation.rv_res_name FROM rv_reservation WHERE rv_reservation.rv_reservation_ix = '$item[rv_reservation_id]'",4);
		$item['bt'] = "bt";
		if($lastRes == "") {
			$item['bt'] = "";
		}
	}

	$resStatus = $lDB->get("
		SELECT
			rf_reservation_status_desc
		FROM
			rv_reservation
			LEFT JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
		WHERE
			rv_reservation.rv_reservation_ix = '$item[rv_reservation_id]'
	",4);
  
	$item['status'] = $resStatus;
	$item['arrDate'] = chng_date($item['rv_item_date_arrive'],"-");
	$item['depDate'] = chng_date($item['rv_item_date_depart'],"-");
	$item['propName'] = $item['pr_name_last'];  
	$item['accommDesc'] = $lDB->get("SELECT ac_accomm_type.ac_accomm_desc FROM ac_accomm_type WHERE ac_accomm_type.ac_accomm_type_ix = '$item[ac_accomm_type_id]'",4);
	$item['folioNum'] = $item['fn_folio_folio_num'];
	$item['numNght'] = $item['noNights'];
	$item['numRms'] = $item['rv_item_accomm_count'];
	$item['numAdlt'] = $item['rv_item_adult_count'];
	$item['numChld'] = $item['rv_item_child_count'];
  
	$resRows .= showpage($item,$reshtml);
	$lastRes = $item['rv_reservation_id'];  
}

$GLOBALS['temp']['resRows'] = isset($resRows) ? $resRows : "";

if($GLOBALS['temp']['resRows'] == "") {
	$GLOBALS['temp']['resRows'] = "<tr><td colspan=\"11\" height=\"30\">There are no ".$repHeader." folios for the selected criteria</td></tr>";
}

function getFolios($resNum,$dbcode) {
	$folioList = $GLOBALS['lDB']->get("
		SELECT
			fn_folio.fn_folio_db,
			fn_folio.fn_folio_ix,
			fn_folio.fn_folio_amount as folioNett,
			fn_folio.fn_folio_folio_num as folioNum,
			fn_folio.rv_reservation_id,
			fn_folio.fn_folio_to_id as folioToId,
			rf_currency.rf_currency_symbol as folioCurr,
			pr_persona.pr_name_first as fName,
			pr_persona.pr_name_last as lName,
			ac_pay_plan.ac_pay_plan_desc as folioPayPlan,
			ac_accomm_room.ac_desc,
			rf_currency.rf_currency_symbol,
			fn_folio.rf_currency_id,
			pr_business.pr_bus_home_curr_id as business_currency_id,
			business_currency.rf_currency_symbol as business_currency_symbol,
			rv_reservation.rv_reservation_db,
			rv_reservation.rv_reservation_ix,
			rv_reservation.rv_invoice_currency_id,
			rv_reservation.rf_reservation_status_id,
			fn_invoice.fn_invoice_ix,
			fn_invoice.fn_inv_status_ind,
			fn_invoice.fn_inv_fiscal_status_ind,
			fn_batch.fn_batch_ix,
			fn_batch.fn_batch_closed_yn,
			fn_folio.fn_folio_date AS invoiceDate
		FROM
			fn_folio
			LEFT JOIN fn_invoice ON fn_invoice.fn_folio_id = fn_folio.fn_folio_ix AND fn_invoice.fn_inv_status_ind <> 8
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = fn_folio.fn_folio_to_id 
			LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
			LEFT JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_folio.rv_reservation_id
			LEFT JOIN ac_pay_plan ON ac_pay_plan.ac_pay_plan_ix = rv_reservation.ac_pay_plan_id
			LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = fn_folio.rv_res_item_group_id
			LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
			INNER JOIN rf_database as folio_database ON fn_folio.fn_folio_db = folio_database.rf_db_code
			INNER JOIN rf_database as reservation_database ON fn_folio.fn_folio_db = reservation_database.rf_db_code
			INNER JOIN pr_business ON pr_business.pr_business_id = fn_folio.pr_business_id
			INNER JOIN rf_currency AS business_currency ON business_currency.rf_currency_ix = pr_business.pr_bus_home_curr_id
			LEFT JOIN fn_tran ON fn_tran.fn_tran_link_id = fn_invoice.fn_invoice_ix AND fn_tran.fn_tran_link_ind = ".DB_FN_TRAN_LINK_INVOICE."
			LEFT JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
		WHERE
			fn_folio.rv_reservation_id = '$resNum'
		ORDER BY
			(ac_accomm_room.ac_desc+0),ac_accomm_room.ac_desc,fn_folio.fn_folio_folio_num
	",2);  

	foreach($folioList as $key=>$item) {
		$folioList[$key]['allowFutureInvoice'] = (db_fn_invoice_allow_future_date($item['fn_folio_ix'])?"1":"0");
		$folioList[$key]['invoiceMaxDate'] = db_fn_invoice_max_date($item['fn_folio_ix']);
		$folioList[$key]['grey'] = "";
		$folioList[$key]['red'] = "";
		$folioList[$key]['disable'] = "";

		$folioList[$key]['folioPaid'] = $GLOBALS['lDB']->get("
			SELECT
				SUM(rv_payment_item_amt)
			FROM
				rv_payment_item
			WHERE
				fn_folio_id = '$item[fn_folio_ix]'
		",4);
		fixAmtDisplay($folioList[$key]['paymentTotal']);
		if($folioList[$key]['folioPaid'] == "") {
			$folioList[$key]['folioPaid'] = "0.00";
		}
		$item['folioPaid'] = $folioList[$key]['folioPaid'];

		$folioPayee = trim($item['fName']." ".$item['lName']);
		if($folioPayee == "") {
			$folioPayee = "Cash";
		}
		if(trim($item['ac_desc']) != "") {
			if($item['fn_folio_db'] != $dbcode) {
				$folioPayee .= " ($item[ac_desc])";
			} else {
				$folioPayee .= " (<b>$item[ac_desc]</b>)";
			}
		}    
		$folioList[$key]['folioPayee'] = $folioPayee;
		$folioList[$key]['folioOutstand'] = $item['folioNett']-$item['folioPaid'];
		$folioList[$key]['outstanding'] = $item['folioNett']-$item['folioPaid'];
		fixAmtDisplay($folioList[$key]['folioOutstand']);
    
		// Get TBAs
		$folioTBA = false;
		$resItemList = $GLOBALS['lDB']->get("
			SELECT
				rv_reservation_item_ix
			FROM
				rv_reservation_item
			WHERE
				fn_folio_id = '$item[fn_folio_ix]'
		",3);    
		if($resItemList > 0) {    
			$resItemCheck = $GLOBALS['lDB']->get("
				SELECT
					COUNT(rv_res_item_comp.rv_res_item_comp_ix)
				FROM
					rv_reservation_item
					LEFT JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
				WHERE
					rv_reservation_item.rv_reservation_item_ix IN ('".join("','",$resItemList)."')
				GROUP BY
					rv_reservation_item.rv_reservation_item_ix
			",3);
			if(in_array("0",$resItemCheck)) {
				$folioTBA = true;
				$folioList[$key]['folioNett'] = "TBA";
				$folioList[$key]['folioPaid'] = "TBA";
				$folioList[$key]['folioOutstand'] = "TBA";
				$folioList[$key]['folioCurr'] = "";
			}
		}  
		if($folioList[$key]['folioOutstand'] != "0.00" && $folioList[$key]['folioOutstand'] != "TBA") {
			$folioList[$key]['red'] = "txtred";
		}
		if($folioList[$key]['folioPayPlan'] == "") {
			$folioList[$key]['folioPayPlan'] = "&nbsp;";
		}
		if($item['fn_folio_db'] != $dbcode) {
			$folioList[$key]['grey'] = "txtg";
			$folioList[$key]['disable'] = "disabled";
			$folioList[$key]['hide'] = " style=\"display: none;\"";
			// Mike must get back to Jill about the payment plan on folios
			$folioList[$key]['folioPayPlan'] = "&nbsp;";
		}  
	}
	return $folioList;
}
// [END] HTML

$GLOBALS['temp']['rf_doc_settings'] = $GLOBALS['lDB']->get("SELECT rf_doc_settings FROM rf_default",4);

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));
