<?php

/**
 * init.form305.php - Day sheet
 * Job: 741
 * Function: 66 (General Access)
 */ 

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}
  
if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/room_day_sheet.htm");
}  

$_SERVER['argv'] = array_pad($_SERVER['argv'],6,"");

$propId = $_SERVER['argv'][1];
$GLOBALS['temp']['pr_business_id'] = $propId;
$propertyName = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '$propId'",4);
$propAbbr = $GLOBALS['lDB']->get("SELECT pr_bus_name_short FROM pr_business WHERE pr_business_id = '$propId'",4);
$GLOBALS['temp']['propertyName'] = $propertyName;

$fromDate = $_SERVER['argv'][2];
if(empty($fromDate)) {
	$fromDate = date("Y-m-d");
}
$GLOBALS['temp']['fromDate'] = $fromDate;
$endDate = "";
$GLOBALS['temp']['fromDateFormat'] = chng_date($fromDate,"-");
$fromWeekDay = date("l",strtotime($fromDate));
$GLOBALS['temp']['fromWeekDay'] = date("l",strtotime($fromDate));

$resGuest = $_SERVER['argv'][3];

$toggleMap = $_SERVER['argv'][4];
$togglePax = ($toggleMap & 1) == 1;
$toggleFinSum = ($toggleMap & 2) == 2;
$toggleResSum = ($toggleMap & 4) == 4;
$toggleRoom = ($toggleMap & 8) == 8;
$toggleRequests = ($toggleMap & 16) == 16;
$toggleExtDet = ($toggleMap & 32) == 32;  

$options = $_SERVER['argv'][5];
$defaultStartDate = date("Y-m-d");
$defaultStartDateTime = date("Y-m-d H:i:s");

switch($options & 7) {
case REP_VIEW_HTML:
	$renderMode = "html";
	$renderType = "";
	break;
case REP_VIEW_PDF:
	$renderMode = "pdf";
	$renderType = "view";
	break;
case REP_EMAIL_PDF:
	$renderMode = "pdf";
	$renderType = "email";
	break;
case REP_SEND_PDF:
	$renderMode = "pdf";
	$renderType = "send";
	break;
case REP_VIEW_CSV:
	$renderMode = "csv";
	$renderType = "view";
	break;
}

if($renderMode == "pdf" && $renderType == "email") {
	$pdfName = "DaySheet_".$propAbbr."_".$fromDate;
	$pdfSub = "Day Sheet for ".$propertyName." on ".chng_date($fromDate,"-");
	$attachmentTable = "
		<table border=\"0\" cellspacing=\"0\" width=\"100%\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\"></td>
			<td id=\"attachmentLabel\" width=\"100%\">$pdfName.pdf</td>
		</tr>
		</table>
	";
	$newOptions = ($options & ~3) + 3;
	$formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,5))."+$newOptions";
	$GLOBALS[$form]->FormHTML =   str_replace("!formAction!",$formAction,
		str_replace("!attachmentInfo!",$attachmentTable,
		str_replace("!attachmentName!",$pdfName.".pdf",
		str_replace("!hasAttachment!","expand",
		str_replace("!emailBody!","",
		str_replace("!emailSubject!",$pdfSub,
		Join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));
	
	// get principal
	$principalId = $GLOBALS['lDB']->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId = $GLOBALS['lDB']->get("SELECT rf_res_office_id FROM rf_default", 4);
	$principalInfo = getPersonaDetail($principalId);
	$resOfficeInfo = getPersonaDetail($resOfficeId);

	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	$GLOBALS['temp']['princName'] = $principalInfo['name'];
	$GLOBALS['temp']['fax'] = $resOfficeInfo['fax'];
	$GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
	$userId = $_SESSION['userid'];
	$GLOBALS['temp']['emailFrom'] = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '$userId'
	",4);
	$GLOBALS['temp']['emailTo'] = "";
}

if($_SERVER['argc'] > 1) {

	$accommList = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			ac_accomm_type.ac_accomm_type_ix
		FROM
			ac_accomm_type
			INNER JOIN sc_accomm ON sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
			INNER JOIN sc_user ON sc_user.sc_group_id = sc_accomm.sc_group_id
		WHERE
			sc_user.pr_user_id = '$GLOBALS[userid]'
			AND ac_accomm_type.ac_accomm_type_inactive_yn = '0'
			AND ac_accomm_type.pr_business_id = '$propId'
		ORDER BY
			ac_accomm_type.ac_accomm_sequence
	",3);

	$pax = array();
	foreach($accommList as $ac_accomm_type_id) {
		$stock = new Stock($ac_accomm_type_id,$fromDate,$fromDate);
		$accomm = $stock->ToAccomm();
		$block = $stock->ToBlock();

		$pax[$ac_accomm_type_id] = array(
			'name'=>$GLOBALS['lDB']->get("SELECT ac_accomm_desc FROM ac_accomm_type WHERE ac_accomm_type_ix = '$ac_accomm_type_id'",4),
			'accomm'=>$accomm[$fromDate],
			'block'=>$block[$fromDate],
			'summary'=>array(
				'arrive'=>array(),
				'depart'=>array(),
				'stay'=>array(),
				'in'=>array()
			),
			'details'=>array(
				'arrive'=>array(),
				'depart'=>array(),
				'stay'=>array(),
				'in'=>array()
			)
		);
	}

	$roomList = $GLOBALS['lDB']->get("
		SELECT
			ac_accomm_room.ac_accomm_room_ix
		FROM
			ac_accomm_room
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
		WHERE
			ac_accomm_type.ac_accomm_type_ix IN ('".join("','",$accommList)."')
			AND (
				(
					ac_accomm_room.ac_accomm_room_inactive_yn = '0'
					AND ac_accomm_room.ac_accomm_room_create_date <= '$fromDate'
				) OR (
					ac_accomm_room.ac_accomm_room_inactive_yn = '1'
					AND ac_accomm_room.ac_accomm_room_inactive_date > '$fromDate'
					AND ac_accomm_room.ac_accomm_room_create_date <= '$fromDate'
				)
			)
		ORDER BY
			ac_accomm_type.ac_accomm_sequence,
			(ac_desc+0),ac_desc				
	",3);
	
	$roomPax = array();
	foreach($roomList as $ac_accomm_room_id) {
		$roomPax[$ac_accomm_room_id] = array(
			'name'=>$GLOBALS['lDB']->get("SELECT ac_desc FROM ac_accomm_room WHERE ac_accomm_room_ix = '$ac_accomm_room_id'",4),
			'details'=>array(
				'arrive'=>array(),
				'depart'=>array(),
				'stay'=>array()
			)				
		);
	}

	$resList = $GLOBALS['lDB']->get("
		SELECT
			rv_reservation.rv_reservation_ix,
			rv_reservation.rv_res_name,
			rv_reservation_item.rv_reservation_item_ix,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			rv_reservation_item.rv_item_accomm_count,
			rv_reservation_item.rv_item_adult_count,
			rv_reservation_item.rv_item_child_count,
			rv_reservation_item.ac_accomm_type_id,
			rv_reservation.rv_agent_ref,
			rv_reservation.rf_reservation_status_id,
			rv_reservation.rv_provision_expiry_date,
			rv_reservation.rv_date_changed
		FROM
			rv_reservation_item
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
		WHERE
			rv_reservation_item.ac_accomm_type_id IN ('".join("','",$accommList)."')
			AND rv_reservation_item.rv_item_date_arrive <= '$fromDate'
			AND rv_reservation_item.rv_item_date_depart >= '$fromDate'
			AND (
				rv_reservation.rf_reservation_status_id = '30'
				OR (
					rv_reservation.rf_reservation_status_id = '20'
					AND rv_reservation.rv_provision_expiry_date >= '$defaultStartDate'
				) OR (
					rv_reservation.rf_reservation_status_id = '25'
					AND rv_reservation.rv_create_expiry_date >= '$defaultStartDateTime'
				)
			)
		ORDER BY
			rv_reservation_item.rv_item_date_arrive, rv_reservation_item.rv_item_date_depart
	",2);

	$requests = array();
	$extras = array();
	$extraCategories = array();
    $today = date("Y-m-d");
	foreach($resList as $item) {
		$item['adult_total'] = $item['rv_item_accomm_count'] * $item['rv_item_adult_count'];
		$item['child_total'] = $item['rv_item_accomm_count'] * $item['rv_item_child_count'];
		$item['pax_total'] = $item['adult_total'] + $item['child_total'];
		$item['ac_accomm_desc'] = $pax[$item['ac_accomm_type_id']]['name'];

		$item['requests'] = $GLOBALS['lDB']->get("
			SELECT
				rt_component.rt_component_abbrv
			FROM
				rv_res_item_comp
				INNER JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
			WHERE
				rv_res_item_comp.rv_reservation_item_id = '$item[rv_reservation_item_ix]'
				AND rv_item_comp_option_yn = '1'
		",3);
		$item['request_count'] = sizeof($item['requests']);

		if(strlen($item['rv_res_name']) > 10) {
			$item['rv_res_name_fmt'] = substr($item['rv_res_name'],0,10) . "...";
		} else {
			$item['rv_res_name_fmt'] = $item['rv_res_name'];
		}

		if($item['request_count'] > 0) {
			$item['rv_res_name_fmt'] .= "*";
		}

		$item['rv_agent_ref'] = trim($item['rv_agent_ref']);
		if(strlen($item['rv_agent_ref'])) {
			$item['rv_agent_ref_fmt'] = substr($item['rv_agent_ref'],0,5) . "...";
		} else {
			$item['rv_agent_ref_fmt'] = $item['rv_agent_ref'];
		}
		if(!empty($item['rv_agent_ref_fmt'])) {
			$item['rv_agent_ref_fmt'] = "Vouch: " . $item['rv_agent_ref_fmt'];
		}

		$item['prov_state'] = "";
		if($item['rf_reservation_status_id'] == "20") {
			if($item['rv_provision_expiry_date'] == $today) {
				$item['prov_state'] = "today";
			}
			if($item['rv_provision_expiry_date'] < $today) {
				$item['prov_state'] = "expired";
			}
		}

		$item['amend_days'] = dateSubtract($today,$item['rv_date_changed']);
		$item['amend_state'] = false;
		if($item['amend_days'] <= 7) {
			$item['amend_state'] = true;
		}		
		
		$details =& $pax[$item['ac_accomm_type_id']]['details'];
		if($item['rv_item_date_arrive'] == $fromDate) {
			array_push($details['arrive'],$item);
		}
		if($item['rv_item_date_depart'] == $fromDate) {
			array_push($details['depart'],$item);
		}
		if($fromDate > $item['rv_item_date_arrive'] && $fromDate < $item['rv_item_date_depart']) {
			array_push($details['stay'],$item);
		}
		if($fromDate >= $item['rv_item_date_arrive']&& $fromDate < $item['rv_item_date_depart']) {
			array_push($details['in'],$item);
		}

		$rooms = $GLOBALS['lDB']->get("
			SELECT
				rv_res_item_group.rv_res_item_group_ix,
				rv_res_item_group.ac_accomm_room_id
			FROM
				rv_res_item_group
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			WHERE
				rv_reservation_item.rv_reservation_item_ix = '$item[rv_reservation_item_ix]'
		",2);
		$item['rooms'] = array();
		foreach($rooms as $roomItem) {
			if(empty($roomItem['ac_accomm_room_id'])) {
				continue;
			}
			$item['rooms'][$roomItem['ac_accomm_room_id']] = $roomPax[$roomItem['ac_accomm_room_id']]['name'];
			$details =& $roomPax[$roomItem['ac_accomm_room_id']]['details'];
			$item['rv_res_item_group_id'] = $roomItem['rv_res_item_group_ix'];
			$guestList = $GLOBALS['lDB']->get("
				SELECT
					pr_persona.pr_name_first,
					pr_persona.pr_name_last
				FROM
					rv_res_item_guest
					INNER JOIN pr_guest ON pr_guest.pr_guest_id = rv_res_item_guest.pr_guest_id
					INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
				WHERE
					rv_res_item_guest.rv_res_item_group_id = '$roomItem[rv_res_item_group_ix]'
				ORDER BY
					pr_guest.pr_guest_primary_yn DESC
			",2);
			$guests = array();
			foreach($guestList as $guestKey=>$guestItem) {
				$first = trim($guestItem['pr_name_first']);
				$last = trim($guestItem['pr_name_last']);
				if(!empty($first) && !empty($last)) {
					array_push($guests,$guestItem['pr_name_last'] . ", " . $guestItem['pr_name_first']);
				} elseif(!empty($first)) {
					array_push($guests,$guestItem['pr_name_first']);
				} else {
					array_push($guests,$guestItem['pr_name_last']);
				}
				
			}
			$item['guests'] = $guests;

			if($item['rv_item_date_arrive'] == $fromDate) {
				array_push($details['arrive'],$item);
			}
			if($item['rv_item_date_depart'] == $fromDate) {
				array_push($details['depart'],$item);
			}
			if($fromDate > $item['rv_item_date_arrive'] && $fromDate < $item['rv_item_date_depart']) {
				array_push($details['stay'],$item);
			}
		}
		if($item['request_count'] > 0) {
			$requests[$item['rv_reservation_ix']] = $item;
		}
		$extraList = $GLOBALS['lDB']->get("
			SELECT
				rv_extra.rv_extra_ix,
				rv_extra.rv_extra_units,
				ac_extra.ac_ext_desc,
				ac_extra_category.ac_extra_category_ix,
				ac_extra_category.ac_extra_cat_desc,
				ac_extra_category.ac_extra_cat_ind,
				rv_extra.rv_extra_date_serv,
				ac_accomm_room.ac_desc,
		        rv_extra.rv_extra_travel_eta,
        		rv_extra.rv_extra_travel_etd
			FROM
				rv_extra
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_extra.rv_reservation_id  
				LEFT JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
				LEFT JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
				LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_extra.rv_res_item_group_id
				LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
			WHERE
				rv_extra.rv_reservation_id = '$item[rv_reservation_ix]'
				AND rv_extra.pr_business_id = '$propId'
				AND (
					rv_extra.rv_extra_date_serv = '$fromDate'
					OR rv_extra.rv_extra_date_serv = '0000-00-00'
				) AND rv_extra.rv_extra_void_ind = 0
		",2);
		foreach($extraList as $extraItem) {
			$extraItem['rv_extra_date_serv_fmt'] = chng_date($extraItem['rv_extra_date_serv'],"-");
			$extras[$extraItem['rv_extra_ix']] = array_merge($item,$extraItem);
			array_push($extraCategories,$extraItem['ac_extra_category_ix']);
		}
	}

	function extraCompare($a, $b) {
		if($a['ac_extra_cat_desc'] == $b['ac_extra_cat_desc']) {
			if($a['ac_ext_desc'] == $b['ac_ext_desc']) {
				return 0;
			} else {
				if($a['ac_ext_desc'] < $b['ac_ext_desc']) {
					return -1;
				} else {
					return 1;
				}
			}
		} else {
			if($a['ac_extra_cat_desc'] < $b['ac_extra_cat_desc']) {
				return -1;
			} else {
				return 1;
			}
		}
	}
	usort($extras,"extraCompare");

	$paxTotals = array();
	$roomPaxTotals = array();
	$sections = array("arrive","depart","stay","in");
	foreach($sections as $section) {
		$paxTotals[$section] = array(
			'adult_total'=>0,
			'child_total'=>0,
			'pax_total'=>0,
			'room_total'=>0,
			'room_percent'=>0
		);
		$roomPaxTotals[$section] = array(
			'adult_total'=>0,
			'child_total'=>0,
			'pax_total'=>0,
			'room_total'=>0,
			'room_percent'=>0
		);
	}

	$accommTotal = 0;
	foreach($pax as $key=>$item) {
		foreach($sections as $section) {
			$details =& $pax[$key]['details'][$section];
			$summary =& $pax[$key]['summary'][$section];
			$totals = array(
				'adult_total'=>0,
				'child_total'=>0,
				'pax_total'=>0,
				'room_total'=>0,
				'room_percent'=>0
			);
			foreach($details as $detail) {
				$totals['adult_total'] += $detail['adult_total'];
				$totals['child_total'] += $detail['child_total'];
				$totals['pax_total'] += $detail['pax_total'];
				$totals['room_total'] += $detail['rv_item_accomm_count'];
			}
			if($item['accomm'] != 0) {
				$totals['room_percent'] = round ($totals['room_total'] / $item['accomm'] * 100);
			}
			$summary = $totals;

			$paxTotals[$section]['adult_total'] += $totals['adult_total'];
			$paxTotals[$section]['child_total'] += $totals['child_total'];
			$paxTotals[$section]['pax_total'] += $totals['pax_total'];
			$paxTotals[$section]['room_total'] += $totals['room_total'];
		}
		$accommTotal += $item['accomm'];
	}

	$quickClean = false;
	foreach($roomPax as $key=>$item) {
		foreach($sections as $section) {
			$roomPaxTotals[$section]['adult_total'] += isset($item['details'][$section][0]['rv_item_adult_count']) ? $item['details'][$section][0]['rv_item_adult_count'] : 0;
			$roomPaxTotals[$section]['child_total'] += isset($item['details'][$section][0]['rv_item_child_count']) ? $item['details'][$section][0]['rv_item_child_count'] : 0;
		}
		if(sizeof($item['details']['arrive']) > 0 && sizeof($item['details']['depart']) > 0) {
			$roomPax[$key]['quickClean'] = true;
			$quickClean = true;
		}
	}

	$extraCategories = array_unique($extraCategories);
	$extraCatList = $GLOBALS['lDB']->get("
		SELECT
			ac_extra_category.ac_extra_category_ix,
			ac_extra_category.ac_extra_cat_desc
		FROM
			ac_extra_category
		WHERE
			ac_extra_category_ix IN ('".join("','",$extraCategories)."')
		ORDER BY
			ac_extra_cat_desc
	",2);
	

	if($renderMode == "html") {
		$GLOBALS['temp']['catToggles'] = "";
		foreach($extraCatList as $category) {
			$GLOBALS['temp']['catToggles'] .= "
				<tr>
					<td height=\"15\"><input type=\"checkbox\" class=\"uk-checkbox\" id=\"$category[ac_extra_category_ix]\" onClick=\"showHideCat('$category[ac_extra_category_ix]')\" checked></td>
					<td>$category[ac_extra_cat_desc]</td>
				</tr>
			";
		}	
		$GLOBALS['temp']['roomids'] = join(",",$roomList);
		$paxHTML = Join("\n",File(__DIR__ . "/../../../public/html/room_rep_pax_rows.htm"));
		$rows = "";
		foreach($pax as $item) {
			$item['rowHead'] = $item['name'] . " (" . $item['accomm'] . ")";
			$item['inNumRooms'] = $item['summary']['in']['room_total'];
			$item['inPercRooms'] = $item['summary']['in']['room_percent'];
			$item['inNumAdlts'] = $item['summary']['in']['adult_total'];
			$item['inNumChld'] = $item['summary']['in']['child_total'];
			$item['inTotal'] = $item['summary']['in']['pax_total'];

			$item['arrNumRooms'] = $item['summary']['arrive']['room_total'];
			$item['arrPercRooms'] = $item['summary']['arrive']['room_percent'];
			$item['arrNumAdlts'] = $item['summary']['arrive']['adult_total'];
			$item['arrNumChld'] = $item['summary']['arrive']['child_total'];
			$item['arrTotal'] = $item['summary']['arrive']['pax_total'];
			
			$item['stayNumRooms'] = $item['summary']['stay']['room_total'];
			$item['stayPercRooms'] = $item['summary']['stay']['room_percent'];
			$item['stayNumAdlts'] = $item['summary']['stay']['adult_total'];
			$item['stayNumChld'] = $item['summary']['stay']['child_total'];
			$item['stayTotal'] = $item['summary']['stay']['pax_total'];

			$item['depNumRooms'] = $item['summary']['depart']['room_total'];
			$item['depPercRooms'] = $item['summary']['depart']['room_percent'];
			$item['depNumAdlts'] = $item['summary']['depart']['adult_total'];
			$item['depNumChld'] = $item['summary']['depart']['child_total'];
			$item['depTotal'] = $item['summary']['depart']['pax_total'];
			
			$item['summary'] = "";
			$item['details'] = "";
			$rows .= showpage($item,$paxHTML);
		}
		$GLOBALS['temp']['paxrows'] = $rows;

		$GLOBALS['temp']['totInRm'] = $paxTotals['in']['room_total'];
		$GLOBALS['temp']['totInAd'] = $paxTotals['in']['adult_total'];
		$GLOBALS['temp']['totInCh'] = $paxTotals['in']['child_total'];
		$GLOBALS['temp']['totInTotal'] = $paxTotals['in']['pax_total'];

		$GLOBALS['temp']['totArrRm'] = $paxTotals['arrive']['room_total'];
		$GLOBALS['temp']['totArrAd'] = $paxTotals['arrive']['adult_total'];
		$GLOBALS['temp']['totArrCh'] = $paxTotals['arrive']['child_total'];
		$GLOBALS['temp']['totArrTotal'] = $paxTotals['arrive']['pax_total'];

		$GLOBALS['temp']['totStRm'] = $paxTotals['stay']['room_total'];
		$GLOBALS['temp']['totStAd'] = $paxTotals['stay']['adult_total'];
		$GLOBALS['temp']['totStCh'] = $paxTotals['stay']['child_total'];
		$GLOBALS['temp']['totStTotal'] = $paxTotals['stay']['pax_total'];
		
		$GLOBALS['temp']['totDepRm'] = $paxTotals['depart']['room_total'];
		$GLOBALS['temp']['totDepAd'] = $paxTotals['depart']['adult_total'];
		$GLOBALS['temp']['totDepCh'] = $paxTotals['depart']['child_total'];
		$GLOBALS['temp']['totDepTotal'] = $paxTotals['depart']['pax_total'];

		$GLOBALS['temp']['headAccNum'] = "(" . $accommTotal . ")";

		$resHTML = Join("\n",File(__DIR__ . "/../../../public/html/room_day_sheet_resSum.htm"));
		$rows = "";
		$sections = array('arrive'=>"arr",'stay'=>"stay",'depart'=>"dep");
		foreach($pax as $paxItem) {
			$first = true;

			$max = 0;
			foreach($sections as $section=>$htmlSection) {
				$count = sizeof($paxItem['details'][$section]);
				if($count > $max) {
					$max = $count;
				}
			}

			for($count = 0; $count<$max; $count++) {
				$item = array();
				if($first) {
					$item['rowHead'] = $paxItem['name'] . " (" . $paxItem['accomm'] . ")";
					$item['bb'] = "bt";
					$first = false;
				} else {
					$item['rowHead'] = "&nbsp;";
					$item['bb'] = "";
				}

				foreach($sections as $section=>$htmlSection) {
					$paxSection =& $paxItem['details'][$section];
					$item[$htmlSection.'NumRooms'] = "&nbsp;";
					$item[$htmlSection.'NumAdlts'] = "&nbsp;";
					$item[$htmlSection.'NumChld'] = "&nbsp;";
					$item[$htmlSection.'ResNum'] = "&nbsp;";
					$item[$htmlSection.'ResName'] = "&nbsp;";
					$item[$htmlSection.'AgentRef'] = "&nbsp;";
					$item[$htmlSection.'Total'] = "&nbsp;";
					$item[$htmlSection.'Prov'] = "";
					$item[$htmlSection.'Amend'] = "";
					if($count < sizeof($paxSection)) {
						$item[$htmlSection.'NumRooms'] = $paxSection[$count]['rv_item_accomm_count'];
						$item[$htmlSection.'NumAdlts'] = $paxSection[$count]['adult_total'];
						$item[$htmlSection.'NumChld'] = $paxSection[$count]['child_total'];
						$item[$htmlSection.'Total'] = $paxSection[$count]['pax_total'];
						$item[$htmlSection.'ResNum'] = $paxSection[$count]['rv_reservation_ix'];
						$item[$htmlSection.'ResName'] = $paxSection[$count]['rv_res_name_fmt'];
						if(trim($paxSection[$count]['rv_agent_ref_fmt']) != "") {
							$item[$htmlSection.'AgentRef'] = $paxSection[$count]['rv_agent_ref_fmt'];
						} 
						if($paxSection[$count]['prov_state'] == "today") {
							$item[$htmlSection.'Prov'] = "#F1C55D";
						}
						if($paxSection[$count]['prov_state'] == "expired") {
							$item[$htmlSection.'Prov'] = "#DB4242";
						}
						if($paxSection[$count]['amend_state']) {
							$item[$htmlSection.'Amend'] = "txti";
						}
					}
				}
				$rows .= showpage($item,$resHTML);
			}
		}
		$GLOBALS['temp']['resrows'] = $rows;

		$GLOBALS['temp']['aTotalRms'] = $paxTotals['arrive']['room_total'];
		$GLOBALS['temp']['aTotalAdlts'] = $paxTotals['arrive']['adult_total'];
		$GLOBALS['temp']['aTotalChld'] = $paxTotals['arrive']['child_total'];
		$GLOBALS['temp']['aTotal'] = $paxTotals['arrive']['pax_total'];

		$GLOBALS['temp']['sTotalRms'] = $paxTotals['stay']['room_total'];
		$GLOBALS['temp']['sTotalAdlts'] = $paxTotals['stay']['adult_total'];
		$GLOBALS['temp']['sTotalChld'] = $paxTotals['stay']['child_total'];
		$GLOBALS['temp']['sTotal'] = $paxTotals['stay']['pax_total'];
		
		$GLOBALS['temp']['dTotalRms'] = $paxTotals['depart']['room_total'];
		$GLOBALS['temp']['dTotalAdlts'] = $paxTotals['depart']['adult_total'];
		$GLOBALS['temp']['dTotalChld'] = $paxTotals['depart']['child_total'];
		$GLOBALS['temp']['dTotal'] = $paxTotals['depart']['pax_total'];

		$roomHTML = Join("\n",File(__DIR__ . "/../../../public/html/room_day_sheet_roomRows.htm"));
		$rows = "";
		$sections = array('arrive'=>"arr",'stay'=>"stay",'depart'=>"dep");
		foreach($roomPax as $ac_accomm_room_id=>$paxItem) {
			$item = array();
			$item['block'] = "";
			$item['roomDesc'] = $paxItem['name'];
			$item['roomId'] = $ac_accomm_room_id;
			$item['quickClean'] = "";
			if(isset($paxItem['quickClean'])) {
				$item['quickClean'] = "style=\"color:#AA0000;\"";
			}

			foreach($sections as $section=>$htmlSection) {
				$paxSection =& $paxItem['details'][$section];
				$item[$htmlSection.'GuestName'] = "";
				$item[$htmlSection.'ResNum'] = "&nbsp;";
				$item[$htmlSection.'ResName'] = "&nbsp;";
				$item[$htmlSection.'AgentRef'] = "&nbsp;";
				$item[$htmlSection.'NumAdlts'] = "&nbsp;";
				$item[$htmlSection.'NumChld'] = "&nbsp;";      
				$item[$htmlSection.'Prov'] = "";  
				$item[$htmlSection.'Amend'] = "";
				if(sizeof($paxSection) > 0) {
					if(sizeof($paxSection[0]['guests']) > 0) {
						$item[$htmlSection.'GuestName'] = join("<br />",$paxSection[0]['guests']);
					}
					$item[$htmlSection.'ResNum'] = $paxSection[0]['rv_reservation_ix'];
					$item[$htmlSection.'ResName'] = $paxSection[0]['rv_res_name_fmt'];
					if($paxSection[0]['rv_agent_ref_fmt'] != "") {
						$item[$htmlSection.'AgentRef'] = $paxSection[0]['rv_agent_ref_fmt'];
					}
					$item[$htmlSection.'NumAdlts'] = $paxSection[0]['rv_item_adult_count'];
					$item[$htmlSection.'NumChld'] = $paxSection[0]['rv_item_child_count'];
					if($paxSection[0]['prov_state'] == "today") {
						$item[$htmlSection.'Prov'] = "#F1C55D";
					}
					if($paxSection[0]['prov_state'] == "expired") {
						$item[$htmlSection.'Prov'] = "#DB4242";
					}
					if($paxSection[0]['amend_state']) {
						$item[$htmlSection.'Amend'] = "txti";
					}
				}
			}		
			$rows .= showpage($item,$roomHTML);
		}
		$GLOBALS['temp']['roomrows'] = $rows;

		$GLOBALS['temp']['aTotAdlts'] = $roomPaxTotals['arrive']['adult_total'];
		$GLOBALS['temp']['aTotChld'] = $roomPaxTotals['arrive']['child_total'];

		$GLOBALS['temp']['sTotAdlts'] = $roomPaxTotals['stay']['adult_total'];
		$GLOBALS['temp']['sTotChld'] = $roomPaxTotals['stay']['child_total'];

		$GLOBALS['temp']['dTotAdlts'] = $roomPaxTotals['depart']['adult_total'];
		$GLOBALS['temp']['dTotChld'] = $roomPaxTotals['depart']['child_total'];

	    $GLOBALS['temp']['quickClean'] = "display:none;";
		if($quickClean) {
		    $GLOBALS['temp']['quickClean'] = "color:#AA0000;";
		}

		$GLOBALS['temp']['roomsUnalloc'] = "collapse printCollapse";
		if(isset($roomsUnalloc)){
			$GLOBALS['temp']['roomsUnalloc'] = "txtbr";
		}
		

		$reqHTML = Join("\n",File(__DIR__ . "/../../../public/html/room_day_sheet_reqRows.htm"));
		$rows = "";
		foreach($requests as $reqItem) {
			$dateArrive = new \DateTime($reqItem['rv_item_date_arrive']);
			$dateDepart = new \DateTime($reqItem['rv_item_date_depart']);
			$item = array();
			$item['reqResNum'] = $reqItem['rv_reservation_ix'];
			$item['reqResName'] = $reqItem['rv_res_name'];
			$item['reqArrive'] = $dateArrive->format('d M Y');
			$item['reqDepart'] = $dateDepart->format('d M Y');
			$item['reqAccomm'] = $reqItem['ac_accomm_desc'];
			$item['reqComps'] = join(", ",$reqItem['requests']);
			$item['reqTotRooms'] = $reqItem['rv_item_accomm_count'];
			$item['reqRooms'] = join(", ",$reqItem['rooms']);
			$item['reqProv'] = "";

			if($reqItem['prov_state'] == "today") {
				$item['reqProv'] = "#F1C55D";
			}
			if($reqItem['prov_state'] == "expired") {
				$item['reqProv'] = "#DB4242";
			}
			
			$rows .= showpage($item,$reqHTML);
		}
		$GLOBALS['temp']['reqrows'] = $rows;
		if($rows == "") {
			$GLOBALS['temp']['reqrows'] = "<tr><td colspan=\"7\" class=\"bl bb br\">None</td></tr>"; 
		}

		$extraHTML = Join("\n",File(__DIR__ . "/../../../public/html/room_rep_extra_drows.htm"));
		$rows = "";
		$lastCategory = "";
		$lastExtra = "";
		$extraCount = 0;
		foreach($extras as $extraItem) {
			$item = array();
			$item['servDate'] = $extraItem['rv_extra_date_serv_fmt'];
			$item['travInd'] = "&nbsp;";
			if($extraItem['ac_extra_cat_ind'] == 2) {
				$item['travInd'] = "<img src=\"/resource/Resrequest/Application/public/img/button_travel.gif\">";
			}
			if($extraItem['ac_extra_cat_desc'] != $lastCategory) {
				$item['catDesc'] = $extraItem['ac_extra_cat_desc'];
				$lastCategory = $extraItem['ac_extra_cat_desc'];
				$lastExtra = "";
			} else {
				$item['catDesc'] = "&nbsp;";
			}

			if($extraItem['ac_ext_desc'] != $lastExtra) {
				$item['extraDesc'] = $extraItem['ac_ext_desc'];
				$lastExtra = $extraItem['ac_ext_desc'];
			} else {
				$item['extraDesc'] = "&nbsp;";
			}

			if(trim($extraItem['rv_extra_travel_eta']) != "") {
				$item['rv_extra_travel_eta'] = $extraItem['rv_extra_travel_eta'];
			} else {
				$item['rv_extra_travel_eta'] = "&nbsp;";
			}
			if(trim($extraItem['rv_extra_travel_etd']) != "") {
				$item['rv_extra_travel_etd'] = $extraItem['rv_extra_travel_etd'];
			} else {
				$item['rv_extra_travel_etd'] = "&nbsp;";
			}

			$item['resNum'] = $extraItem['rv_reservation_ix'];
			$item['resName'] = $extraItem['rv_res_name'];
			$item['provColor'] = "";
			if($extraItem['prov_state'] == "today") {
				$item['provColor'] = "#F1C55D";
			}
			if($extraItem['prov_state'] == "expired") {
				$item['provColor'] = "#DB4242";
			}

			$item['numUnits'] = $extraItem['rv_extra_units'];

			$item['roomDesc'] = "&nbsp;";
			if(!empty($extraItem['ac_desc'])) {
				$item['roomDesc'] = $extraItem['ac_desc'];
			}

			$item['extraSummNote'] = "";
			$item['extraSummIntNote'] = "";

			$item['catLine'] = "";

			$item['count'] = $extraCount;
			$item['catId'] = $extraItem['ac_extra_category_ix'];

			$item['hideNotes'] = "collapse";

			$rows .= showpage($item,$extraHTML);
			$extraCount++;
		}
		$GLOBALS['temp']['detRows'] = $rows;
		$GLOBALS['temp']['dSize'] = sizeof($extras);
	}

	if($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {
		$pdf = new PDF("Day Sheet");

		$pdf->ReportHeader("Day Sheet",array(
			array("name"=>"Property","value"=>$propertyName),
			array("name"=>"Date","value"=>chng_date($fromDate,"-")),
		));
		$pdf->SetFont('Arial', '', 7);
		
		if($togglePax) {
			$pdf->Row(array(
				array("width"=>"100%", "data"=>"PAX Analysis", "style"=>"B")
			)); 
			$pdf->Ln(1);
			$paxTotal = array(0xef,0xef,0xe7);
			$cProvDue = array(0xf1,0xc5,0x5d);
			$cProvExpire = array(0xdb,0x42,0x42);  
			$txtbr = array(0x99,0x66,0x33);
  
			$pdf->SetFont('Arial', '', 6);
			$pdf->Row(array(
				array("width"=>"14%", "data"=>"", "border"=>"TLBR", "fill"=>1),
				array("width"=>"26%", "data"=>"In-House", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"20%", "data"=>"Arrive", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"20%", "data"=>"Stay Over", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"20%", "data"=>"Depart", "border"=>"TLBR", "fill"=>1, "align"=>"C")
			));
      
			$pdf->Row(array(
				array("width"=>"14%", "data"=>"Accommodation", "border"=>"LBR", "fill"=>1),
				array("width"=>"5%", "data"=>"Rooms", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"6%", "data"=>"Room %", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"15%", "data"=>"PAX", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"5%", "data"=>"Rooms", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"15%", "data"=>"PAX", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"5%", "data"=>"Rooms", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"15%", "data"=>"PAX", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"5%", "data"=>"Rooms", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"15%", "data"=>"PAX", "border"=>"TLBR", "fill"=>1, "align"=>"C")
			));
  
			$pdf->Row(array(
				array("width"=>"14%", "data"=>"", "border"=>"LBR", "fill"=>1),
				array("width"=>"5%", "data"=>"", "border"=>"LBR", "fill"=>1, "align"=>"C"),
				array("width"=>"6%", "data"=>"", "border"=>"LBR", "fill"=>1, "align"=>"C"),
				array("width"=>"5%", "data"=>"Adlts", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"5%", "data"=>"Chld", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"5%", "data"=>"Total", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"5%", "data"=>"", "border"=>"LBR", "fill"=>1, "align"=>"C"),
				array("width"=>"5%", "data"=>"Adlts", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"5%", "data"=>"Chld", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"5%", "data"=>"Total", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"5%", "data"=>"", "border"=>"LBR", "fill"=>1, "align"=>"C"),
				array("width"=>"5%", "data"=>"Adlts", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"5%", "data"=>"Chld", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"5%", "data"=>"Total", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"5%", "data"=>"", "border"=>"LBR", "fill"=>1, "align"=>"C"),
				array("width"=>"5%", "data"=>"Adlts", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"5%", "data"=>"Chld", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"5%", "data"=>"Total", "border"=>"TLBR", "fill"=>1, "align"=>"C")
			));  	

			foreach($pax as $item) {
				$pdf->Row(array(
					array('width'=>"14%", 'data'=>$item['name'] . " (" . $item['accomm'] . ")", 'border'=>"TLBR", 'fill'=>1, 'fillColor'=>$paxTotal),
					array("width"=>"5%", "data"=>$item['summary']['in']['room_total'], "border"=>"LBR", "align"=>"C"),
					array("width"=>"6%", "data"=>$item['summary']['in']['room_percent']." %", "border"=>"LBR", "align"=>"C"),
					array("width"=>"5%", "data"=>$item['summary']['in']['adult_total'], "border"=>"TLBR", "align"=>"C"),
					array("width"=>"5%", "data"=>$item['summary']['in']['child_total'], "border"=>"TLBR", "align"=>"C"),
					array("width"=>"5%", "data"=>$item['summary']['in']['pax_total'], "border"=>"TLBR", "fill"=>1, "fillColor"=>$paxTotal, "align"=>"C"),

					array("width"=>"5%", "data"=>$item['summary']['arrive']['room_total'], "border"=>"LBR", "align"=>"C"),
					array("width"=>"5%", "data"=>$item['summary']['arrive']['adult_total'], "border"=>"TLBR", "align"=>"C"),
					array("width"=>"5%", "data"=>$item['summary']['arrive']['child_total'], "border"=>"TLBR", "align"=>"C"),
					array("width"=>"5%", "data"=>$item['summary']['arrive']['pax_total'], "border"=>"TLBR", "align"=>"C", "fill"=>1, "fillColor"=>$paxTotal),

					array("width"=>"5%", "data"=>$item['summary']['stay']['room_total'], "border"=>"LBR", "align"=>"C"),
					array("width"=>"5%", "data"=>$item['summary']['stay']['adult_total'], "border"=>"TLBR", "align"=>"C"),
					array("width"=>"5%", "data"=>$item['summary']['stay']['child_total'], "border"=>"TLBR", "align"=>"C"),
					array("width"=>"5%", "data"=>$item['summary']['stay']['pax_total'], "border"=>"TLBR", "align"=>"C", "fill"=>1, "fillColor"=>$paxTotal),
				
					array("width"=>"5%", "data"=>$item['summary']['depart']['room_total'], "border"=>"LBR", "align"=>"C"),
					array("width"=>"5%", "data"=>$item['summary']['depart']['adult_total'], "border"=>"TLBR", "align"=>"C"),
					array("width"=>"5%", "data"=>$item['summary']['depart']['child_total'], "border"=>"TLBR", "align"=>"C"),
					array("width"=>"5%", "data"=>$item['summary']['depart']['pax_total'], "border"=>"TLBR", "align"=>"C", "fill"=>1, "fillColor"=>$paxTotal)
				));
			}

			$pdf->Row(array(
				array("width"=>"14%", "data"=>"Total", "border"=>"TLBR", "fill"=>1, "fillColor"=>$paxTotal),
				array("width"=>"5%", "data"=>$paxTotals['in']['room_total'], "border"=>"LBR", "align"=>"C"),
				array("width"=>"6%", "data"=>"", "border"=>"LBR", "align"=>"C"),    
				array("width"=>"5%", "data"=>$paxTotals['in']['adult_total'], "border"=>"TLBR", "align"=>"C"),
				array("width"=>"5%", "data"=>$paxTotals['in']['child_total'], "border"=>"TLBR", "align"=>"C"),
				array("width"=>"5%", "data"=>$paxTotals['in']['pax_total'], "border"=>"TLBR", "align"=>"C", "fill"=>1, "fillColor"=>$paxTotal),

				array("width"=>"5%", "data"=>$paxTotals['arrive']['room_total'], "border"=>"LBR", "align"=>"C"),
				array("width"=>"5%", "data"=>$paxTotals['arrive']['adult_total'], "border"=>"TLBR", "align"=>"C"),
				array("width"=>"5%", "data"=>$paxTotals['arrive']['child_total'], "border"=>"TLBR", "align"=>"C"),
				array("width"=>"5%", "data"=>$paxTotals['arrive']['pax_total'], "border"=>"TLBR", "align"=>"C", "fill"=>1, "fillColor"=>$paxTotal),

				array("width"=>"5%", "data"=>$paxTotals['stay']['room_total'], "border"=>"LBR", "align"=>"C"),
				array("width"=>"5%", "data"=>$paxTotals['stay']['adult_total'], "border"=>"TLBR", "align"=>"C"),
				array("width"=>"5%", "data"=>$paxTotals['stay']['child_total'], "border"=>"TLBR", "align"=>"C"),
				array("width"=>"5%", "data"=>$paxTotals['stay']['pax_total'], "border"=>"TLBR", "align"=>"C", "fill"=>1, "fillColor"=>$paxTotal),

				array("width"=>"5%", "data"=>$paxTotals['depart']['room_total'], "border"=>"LBR", "align"=>"C"),
				array("width"=>"5%", "data"=>$paxTotals['depart']['adult_total'], "border"=>"TLBR", "align"=>"C"),
				array("width"=>"5%", "data"=>$paxTotals['depart']['child_total'], "border"=>"TLBR", "align"=>"C"),
				array("width"=>"5%", "data"=>$paxTotals['depart']['pax_total'], "border"=>"TLBR", "align"=>"C", "fill"=>1, "fillColor"=>$paxTotal),
			));
		}

		if($toggleResSum) {
			$pdf->SetFont('Arial', '', 7);
			$pdf->Row(array(
				array("width"=>"100%", "height"=>"6", "data"=>"Reservation Summary", "style"=>"B")
			));  
    
			$pdf->SetFont('Arial', '', 6);
			$pdf->Row(array(
				array("width"=>"16%", "data"=>"Accommodation", "border"=>"TLBR", "fill"=>1),
				array("width"=>"28%", "data"=>"Arrive", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"28%", "data"=>"Stay Over", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"28%", "data"=>"Depart", "border"=>"TLBR", "fill"=>1, "align"=>"C")
			));        
  
			$pdf->Row(array(
				array("width"=>"16%", "data"=>"", "border"=>"LBR", "fill"=>1),
				array("width"=>"4%", "data"=>"Rms", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"12%", "data"=>"Res Details", "border"=>"TLBR", "fill"=>1),    
				array("width"=>"4%", "data"=>"Adlts", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"4%", "data"=>"Chld", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"4%", "data"=>"Total", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"4%", "data"=>"Rms", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"12%", "data"=>"Res Details", "border"=>"TLBR", "fill"=>1),    
				array("width"=>"4%", "data"=>"Adlts", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"4%", "data"=>"Chld", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"4%", "data"=>"Total", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"4%", "data"=>"Rms", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"12%", "data"=>"Res Details", "border"=>"TLBR", "fill"=>1),    
				array("width"=>"4%", "data"=>"Adlts", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"4%", "data"=>"Chld", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"4%", "data"=>"Total", "border"=>"TLBR", "fill"=>1, "align"=>"C")
			));

			$sections = array('arrive'=>"arr",'stay'=>"stay",'depart'=>"dep");
			foreach($pax as $paxItem) {
				$first = true;

				$max = 0;
				foreach($sections as $section=>$htmlSection) {
					$count = sizeof($paxItem['details'][$section]);
					if($count > $max) {
						$max = $count;
					}
				}

				for($count = 0; $count<$max; $count++) {
					$item = array();
					$row = array();
					if($first) {
						array_push($row,
							array("width"=>"16%", "data"=>$paxItem['name'] . " (" . $paxItem['accomm'] . ")", "border"=>"TLBR", "fill"=>1, "fillColor"=>$paxTotal)
						); 
						$first = false;
					} else {
						array_push($row,
							array("width"=>"16%", "border"=>"TLBR", "fill"=>1, "fillColor"=>$paxTotal)
						);
					}


					foreach($sections as $section=>$htmlSection) {
						$cellColour = "";
						$paxSection =& $paxItem['details'][$section];
						if($count < sizeof($paxSection)) {
							$fill = "0";
							if($paxSection[$count]['prov_state'] == "today") {
								$fill = "1";
								$cellColour = $cProvDue;
							}
							if($paxSection[$count]['prov_state'] == "expired") {
								$fill = "1";
								$cellColour = $cProvExpire;
							}
							$style = "";
							if($paxSection[$count]['amend_state']) {
								$style = "I";
							}
							$details = $paxSection[$count]['rv_reservation_ix'] . " " . $paxSection[$count]['rv_res_name_fmt'];
							if(trim($paxSection[$count]['rv_agent_ref_fmt']) != "") {
								$details .= $paxSection[$count]['rv_agent_ref_fmt'];
							} 

							array_push($row,
								array("width"=>"4%", "data"=>$paxSection[$count]['rv_item_accomm_count'], "border"=>"TLBR", "align"=>"C"),            
								array("width"=>"12%", "data"=>$details, "border"=>"TLBR", "fill"=>$fill, "fillColor"=>$cellColour, "style"=>$style),
								array("width"=>"4%", "data"=>$paxSection[$count]['adult_total'], "border"=>"TLBR", "align"=>"C"),
								array("width"=>"4%", "data"=>$paxSection[$count]['child_total'], "border"=>"TLBR", "align"=>"C"),
								array("width"=>"4%", "data"=>$paxSection[$count]['pax_total'], "border"=>"TLBR", "fill"=>1, "fillColor"=>$paxTotal, "align"=>"C")
							);
						} else {
							array_push($row,
								array("width"=>"4%", "data"=>"", "border"=>"TLBR", "align"=>"C"),            
								array("width"=>"12%", "data"=>"", "border"=>"TLBR"),
								array("width"=>"4%", "data"=>"", "border"=>"TLBR", "align"=>"C"),
								array("width"=>"4%", "data"=>"", "border"=>"TLBR", "align"=>"C"),
								array("width"=>"4%", "data"=>"", "border"=>"TLBR", "fill"=>1, "fillColor"=>$paxTotal, "align"=>"C")
							);
						}
					}
					$pdf->Row($row);
				}
			}

			$pdf->Row(array(
				array("width"=>"16%", "data"=>"Total", "border"=>"TLBR", "fill"=>1, "fillColor"=>$paxTotal),

				array("width"=>"4%", "data"=>$paxTotals['arrive']['room_total'], "border"=>"TLBR", "align"=>"C"),
				array("width"=>"12%", "data"=>"", "border"=>"TLBR"),
				array("width"=>"4%", "data"=>$paxTotals['arrive']['adult_total'], "border"=>"TLBR", "align"=>"C"),
				array("width"=>"4%", "data"=>$paxTotals['arrive']['child_total'], "border"=>"TLBR", "align"=>"C"),
				array("width"=>"4%", "data"=>$paxTotals['arrive']['pax_total'], "border"=>"TLBR", "fill"=>1, "fillColor"=>$paxTotal, "align"=>"C"),

				array("width"=>"4%", "data"=>$paxTotals['stay']['room_total'], "border"=>"TLBR", "align"=>"C"),
				array("width"=>"12%", "data"=>"", "border"=>"TLBR"),
				array("width"=>"4%", "data"=>$paxTotals['stay']['adult_total'], "border"=>"TLBR", "align"=>"C"),
				array("width"=>"4%", "data"=>$paxTotals['stay']['child_total'], "border"=>"TLBR", "align"=>"C"),
				array("width"=>"4%", "data"=>$paxTotals['stay']['pax_total'], "border"=>"TLBR", "fill"=>1, "fillColor"=>$paxTotal, "align"=>"C"),

				array("width"=>"4%", "data"=>$paxTotals['depart']['room_total'], "border"=>"TLBR", "align"=>"C"),
				array("width"=>"12%", "data"=>"", "border"=>"TLBR"),
				array("width"=>"4%", "data"=>$paxTotals['depart']['adult_total'], "border"=>"TLBR", "align"=>"C"),
				array("width"=>"4%", "data"=>$paxTotals['depart']['child_total'], "border"=>"TLBR", "align"=>"C"),
				array("width"=>"4%", "data"=>$paxTotals['depart']['pax_total'], "border"=>"TLBR", "fill"=>1, "fillColor"=>$paxTotal, "align"=>"C")
			));
			$pdf->Ln(1);			
		}		

		if($toggleRoom) {
			$quickCleanCol = array(0xaa,0x00,0x00);
			$pdf->SetFont('Arial', '', 7);
			$pdf->Row(array(
				array("width"=>"100%", "height"=>"6", "data"=>"Rooming Plan", "style"=>"B")
			));  
		
			$roomHead = "Per Reservation";
			if($resGuest == "guest"){
				$roomHead = "Per Guest";
			}
		
			$pdf->SetFont('Arial', '', 6);
			$pdf->Row(array(
				array("width"=>"25%", "data"=>$roomHead, "border"=>"TLR"),
				array("width"=>"25%", "data"=>"Arrive", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"25%", "data"=>"Stay Over", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"25%", "data"=>"Depart", "border"=>"TLBR", "fill"=>1, "align"=>"C")
			));        
		  
			$pdf->Row(array(
				array("width"=>"25%", "data"=>"", "border"=>"LBR"),
				array("width"=>"17%", "data"=>"Res Details", "border"=>"TLBR", "fill"=>1),    
				array("width"=>"4%", "data"=>"Adlts", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"4%", "data"=>"Chld", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"17%", "data"=>"Res Details", "border"=>"TLBR", "fill"=>1),    
				array("width"=>"4%", "data"=>"Adlts", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"4%", "data"=>"Chld", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"17%", "data"=>"Res Details", "border"=>"TLBR", "fill"=>1),    
				array("width"=>"4%", "data"=>"Adlts", "border"=>"TLBR", "fill"=>1, "align"=>"C"),
				array("width"=>"4%", "data"=>"Chld", "border"=>"TLBR", "fill"=>1, "align"=>"C")
			));  

			$sections = array('arrive'=>"arr",'stay'=>"stay",'depart'=>"dep");
			foreach($roomPax as $ac_accomm_room_id=>$paxItem) {
				$item = array();
				$item['block'] = "";
				$item['roomDesc'] = $paxItem['name'];
				$item['roomId'] = $ac_accomm_room_id;
				$roomCol = "";
				if(isset($paxItem['quickClean']) && $paxItem['quickClean']) {
					$roomCol = $quickCleanCol;
				}
				$row = array(
					array("width"=>"25%", "data"=>$paxItem['name'], "border"=>"TLBR", "textColor"=>$roomCol)
				);


				foreach($sections as $section=>$htmlSection) {
					$paxSection =& $paxItem['details'][$section];
					if (count($paxSection) > 0){
						$fill = "0";
						$cellColour = "";
						if($paxSection[0]['prov_state'] == "today") {
							$fill = "1";
							$cellColour = $cProvDue;
						}
						if($paxSection[0]['prov_state'] == "expired") {
							$fill = "1";
							$cellColour = $cProvExpire;
						}
						$style = "";
						if($paxSection[0]['amend_state']) {
							$style = "I";
						}
						
						$detail = $paxSection[0]['rv_reservation_ix'] . " ";
						if($resGuest == "guest") {
							$detail .= join(" ",$paxSection[0]['guests']);
						} else {
							$detail .= $paxSection[0]['rv_res_name_fmt'];
						}
						array_push($row,
							array("width"=>"17%", "data"=>$detail, "border"=>"TLBR", "style"=>$style, "fill"=>$fill, "fillColor"=>$cellColour),    
							array("width"=>"4%", "data"=>$paxSection[0]['rv_item_adult_count'], "border"=>"TLBR", "align"=>"C", "fill"=>$fill, "fillColor"=>$cellColour),
							array("width"=>"4%", "data"=>$paxSection[0]['rv_item_child_count'], "border"=>"TLBR", "align"=>"C", "fill"=>$fill, "fillColor"=>$cellColour)
						);
					} else {
						array_push($row,
							array("width"=>"17%", "data"=>"", "border"=>"TLBR", "style"=>$style, "fill"=>$fill, "fillColor"=>$cellColour),    
							array("width"=>"4%", "data"=>"", "border"=>"TLBR", "align"=>"C", "fill"=>$fill, "fillColor"=>$cellColour),
							array("width"=>"4%", "data"=>"", "border"=>"TLBR", "align"=>"C", "fill"=>$fill, "fillColor"=>$cellColour)
						);
					}
					
				}
				$pdf->Row($row);
			}
			$pdf->Row(array(
				array("width"=>"25%", "data"=>"PAX Totals", "border"=>"TLBR", "fill"=>1, "fillColor"=>$paxTotal),
				array("width"=>"17%", "data"=>"", "border"=>"TLBR"),    
				array("width"=>"4%", "data"=>$roomPaxTotals['arrive']['adult_total'], "border"=>"TLBR", "align"=>"C"),
				array("width"=>"4%", "data"=>$roomPaxTotals['arrive']['child_total'], "border"=>"TLBR", "align"=>"C"),
				array("width"=>"17%", "data"=>"", "border"=>"TLBR"),    
				array("width"=>"4%", "data"=>$roomPaxTotals['stay']['adult_total'], "border"=>"TLBR", "align"=>"C"),
				array("width"=>"4%", "data"=>$roomPaxTotals['stay']['child_total'], "border"=>"TLBR", "align"=>"C"),
				array("width"=>"17%", "data"=>"", "border"=>"TLBR"),    
				array("width"=>"4%", "data"=>$roomPaxTotals['depart']['adult_total'], "border"=>"TLBR", "align"=>"C"),
				array("width"=>"4%", "data"=>$roomPaxTotals['depart']['child_total'], "border"=>"TLBR", "align"=>"C"),
			));

			if(isset($roomsUnalloc)) {
				$pdf->Row(array(
					array("width"=>"100%", "data"=>"There are rooms not yet allocated", "textColor"=>$txtbr)
				));  
			}
    
			if(isset($quickClean)) {
				$pdf->Row(array(
					array("width"=>"100%", "data"=>"When there is an Arrival and a Departure happening on the same day and in the same room, the room will be displayed in red.", "textColor"=>$quickCleanCol)
				));        
			}

			$pdf->Ln(1);			
		}	

		if($toggleRequests) {
			$pdf->SetFont('Arial', '', 7);
			$pdf->Row(array(
				array("width"=>"100%", "height"=>"6", "data"=>"Requests", "style"=>"B")
			));  
    
			$pdf->SetFont('Arial', '', 6);
			$pdf->Row(array(
				array("width"=>"24%", "data"=>"Reservation Details", "border"=>"TLBR", "fill"=>1),
				array("width"=>"13%", "data"=>"Arriving", "border"=>"TLBR", "fill"=>1),
				array("width"=>"13%", "data"=>"Departing", "border"=>"TLBR", "fill"=>1),
				array("width"=>"13%", "data"=>"Accomm Type", "border"=>"TLBR", "fill"=>1),
				array("width"=>"23%", "data"=>"Request", "border"=>"TLBR", "fill"=>1),
				array("width"=>"7%", "data"=>"Tot Rms", "border"=>"TLBR", "fill"=>1),
				array("width"=>"7%", "data"=>"Rooms", "border"=>"TLBR", "fill"=>1)
			));

			foreach($requests as $reqItem) {		
				$fill = "0";
				if($reqItem['prov_state'] == "today") {
					$fill = "1";
					$cellColour = $cProvDue;
				}
				if($reqItem['prov_state'] == "expired") {
					$fill = "1";
					$cellColour = $cProvExpire;
				}
				
				$pdf->Row(array(
					array("width"=>"24%", "data"=>$reqItem['rv_reservation_ix']." ".$reqItem['rv_res_name'], "border"=>"TLBR", "fill"=>$fill, "fillColor"=>$cellColour),
					array("width"=>"13%", "data"=>$reqItem['rv_item_date_arrive'], "border"=>"TLBR"),
					array("width"=>"13%", "data"=>$reqItem['rv_item_date_depart'], "border"=>"TLBR"),
					array("width"=>"13%", "data"=>$reqItem['ac_accomm_desc'], "border"=>"TLBR"),
					array("width"=>"23%", "data"=>join(", ",$reqItem['requests']), "border"=>"TLBR"),
					array("width"=>"7%", "data"=>$reqItem['rv_item_accomm_count'], "border"=>"TLBR"),
					array("width"=>"7%", "data"=>join(", ",$reqItem['rooms']), "border"=>"TLBR")
				));
			}  
			if(sizeof($requests) == 0){
				$pdf->Row(array(
					array("width"=>"100%", "data"=>"None", "border"=>"TLBR")
				));
			}
			$pdf->Ln(1);
		}

		if($toggleExtDet) {
			$pdf->SetFont('Arial', '', 7);
			$pdf->Row(array(
				array("width"=>"100%", "data"=>"Extras", "style"=>"B")
			));
			$pdf->Ln(1);
    
			$pdf->SetFont('Arial', '', 6);
			$pdf->Row(array(
				array("width"=>"10%", "data"=>"Service Date", "border"=>"TLBR", "fill"=>1),
				array("width"=>"5%", "data"=>"Travel", "border"=>"TLBR", "fill"=>1),              
				array("width"=>"15%", "data"=>"Category", "border"=>"TLBR", "fill"=>1),
				array("width"=>"15%", "data"=>"Extra", "border"=>"TLBR", "fill"=>1),
				array("width"=>"10%", "data"=>"ETA", "border"=>"TLBR", "fill"=>1),
				array("width"=>"10%", "data"=>"ETD", "border"=>"TLBR", "fill"=>1),
				array("width"=>"15%", "data"=>"Reservation", "border"=>"TLBR", "fill"=>1),
				array("width"=>"10%", "data"=>"Qty", "border"=>"TLBR", "fill"=>1, "align"=>"R"),
				array("width"=>"10%", "data"=>"Room", "border"=>"TLBR", "fill"=>1)
			));

			$lastCategory = "";
			$lastExtra = "";
			foreach($extras as $extraItem) {
				$travInd = "";
				if($extraItem['ac_extra_cat_ind'] == 2){
					$travInd = "X";
				}        

				if($extraItem['ac_extra_cat_desc'] != $lastCategory) {
					$catDesc = $extraItem['ac_extra_cat_desc'];
					$lastCategory = $extraItem['ac_extra_cat_desc'];
					$lastExtra = "";
					$catBord = "LRT";
				} else {
					$catDesc = "";
					$catBord = "LR";
				}
				if($extraItem['ac_ext_desc'] != $lastExtra) {
					$extraDesc = $extraItem['ac_ext_desc'];
					$lastExtra = $extraItem['ac_ext_desc'];
					$exBord = "LRT";
				} else {
					$extraDesc = "";
					$exBord = "LR";
				}
				$fill = "0";
				if($extraItem['prov_state'] == "today") {
					$fill = "1";
					$cellColour = $cProvDue;
				}
				if($extraItem['prov_state'] == "expired") {
					$fill = "1";
					$cellColour = $cProvExpire;
				}
				$roomDesc = "";
				if(!empty($extraItem['ac_desc'])) {
					$roomDesc = $extraItem['ac_desc'];
				}

				$pdf->Row(array(
					array("width"=>"10%", "data"=>$extraItem['rv_extra_date_serv_fmt'], "border"=>$catBord),
					array("width"=>"5%", "data"=>$travInd, "border"=>$catBord, "align"=>"C"),                
					array("width"=>"15%", "data"=>$catDesc, "border"=>$catBord),
					array("width"=>"15%", "data"=>$extraDesc, "border"=>$exBord),
					array("width"=>"10%", "data"=>$extraItem['rv_extra_travel_eta'], "border"=>$exBord),
					array("width"=>"10%", "data"=>$extraItem['rv_extra_travel_etd'], "border"=>$exBord),
					array("width"=>"15%", "data"=>$extraItem['rv_reservation_ix']." ".$extraItem['rv_res_name'], "border"=>"TLBR"),
					array("width"=>"10%", "data"=>$extraItem['rv_extra_units'], "border"=>"TLBR", "align"=>"R"),
					array("width"=>"10%", "data"=>$roomDesc, "border"=>"TLBR")
				));
			}
			if(sizeof($extras) > 0) {
				$pdf->Row(array(
					array("width"=>"100%", "data"=>"", "border"=>"T")
				));
			} else {
				$pdf->Row(array(
					array("width"=>"100%", "data"=>"No Extras", "border"=>"TLBR")
				));
			}  
			$pdf->Ln(1);			
		}
		
	
		if($renderType == "save") {
			$pdf->OutPut('./PDF/current/paxReport.pdf');
			echo "PDF created";
		} elseif ($renderType == "view") {
			$pdf->OutPut();
			die();
		} elseif ($renderType == "send") {
			$to = $_POST['mail_to'];
			$from = $_POST['mail_from'];
			$subject = stripslashes($_POST['mail_subj']);
			$message = stripslashes($_POST['mail_body']);
			$attachmentName = $_POST['attachmentName'];

			$headers = "From: ".$GLOBALS['princName']."<$from>\r\n";

			// close the pdf
			if($pdf->state<3) $pdf->Close();

			/* and now mail it */
			//echo "ATTACHMENTNAME: $attachmentName<BR>";
			if($attachmentName != "!attachmentName!") {
				$pdfName = $attachmentName;
			} else {
				$pdfName = "Pax report.pdf";
			}

			$error = email($from, $to, $subject, $headers, $message, 0, 0, $_SERVER['argv'][1], $GLOBALS['princName'],$pdf->buffer,$pdfName);     // (from, to, subject, headers, message, action, emailID, resID)
			//echo "<html><head>";
			//echo "<script src='include/js/system.js' language='javascript'></script></head>";
			if(!$error) {
				echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
			} else {
				echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
			}
			die();
		}
	}

	if($renderMode == "csv") {
		$csvFile = array();
		array_push($csvFile,array("Day Sheet for ".$propertyName." - ".$fromWeekDay." ".chng_date($fromDate,"-")));
		array_push($csvFile,array());

		if($togglePax) {
			array_push($csvFile,array("PAX Analysis"));  
			array_push($csvFile,array("","In-House","","","","","Arrive","","","","Stay Over","","","","Depart"));
			array_push($csvFile,array("Accommodation","Rooms","Room %","PAX","","","Rooms","PAX","","","Rooms","PAX","","","Rooms","PAX"));
			array_push($csvFile,array("","","","Adlts","Chld","Total","","Adlts","Chld","Total","","Adlts","Chld","Total","","Adlts","Chld","Total",""));  

			foreach($pax as $item) {
				array_push($csvFile,array(
					$item['name'] . " (" . $item['accomm'] . ")",
					$item['summary']['in']['room_total'],
					$item['summary']['in']['room_percent']." %",
					$item['summary']['in']['adult_total'],
					$item['summary']['in']['child_total'],
					$item['summary']['in']['pax_total'],

					$item['summary']['arrive']['room_total'],
					$item['summary']['arrive']['adult_total'],
					$item['summary']['arrive']['child_total'],
					$item['summary']['arrive']['pax_total'],

					$item['summary']['stay']['room_total'],
					$item['summary']['stay']['adult_total'],
					$item['summary']['stay']['child_total'],
					$item['summary']['stay']['pax_total'],

					$item['summary']['depart']['room_total'],
					$item['summary']['depart']['adult_total'],
					$item['summary']['depart']['child_total'],
					$item['summary']['depart']['pax_total']
				));	
			}

			array_push($csvFile,array(
				"Total",
				$paxTotals['in']['room_total'],
				"",
				$paxTotals['in']['adult_total'],
				$paxTotals['in']['child_total'],
				$paxTotals['in']['pax_total'],
				
				$paxTotals['arrive']['room_total'],
				$paxTotals['arrive']['adult_total'],
				$paxTotals['arrive']['child_total'],
				$paxTotals['arrive']['pax_total'],
				
				$paxTotals['stay']['room_total'],
				$paxTotals['stay']['adult_total'],
				$paxTotals['stay']['child_total'],
				$paxTotals['stay']['pax_total'],

				$paxTotals['depart']['room_total'],
				$paxTotals['depart']['adult_total'],
				$paxTotals['depart']['child_total'],
				$paxTotals['depart']['pax_total']
			));

			array_push($csvFile,array());
		}

		if($toggleResSum) {
			array_push($csvFile,array("Reservation Summary"));  
			array_push($csvFile,array("Accommodation","Arrive","","","","","Stay Over","","","","","Depart"));
			array_push($csvFile,array("","Rms","Res Details","Adlts","Chld","Total","Rms","Res Details","Adlts","Chld","Total","Rms","Res Details","Adlts","Chld","Total"));    

			$sections = array('arrive'=>"arr",'stay'=>"stay",'depart'=>"dep");
			foreach($pax as $paxItem) {
				$first = true;

				$max = 0;
				foreach($sections as $section=>$htmlSection) {
					$count = sizeof($paxItem['details'][$section]);
					if($count > $max) {
						$max = $count;
					}
				}

				for($count = 0; $count<$max; $count++) {
					$item = array();
					$row = array();
					if($first) {
						array_push($row,$paxItem['name']);
						$first = false;
					} else {
						array_push($row,"");
					}


					foreach($sections as $section=>$htmlSection) {
						$paxSection =& $paxItem['details'][$section];
						if($count < sizeof($paxSection)) {
							$details = $paxSection[$count]['rv_reservation_ix'] . " " . $paxSection[$count]['rv_res_name_fmt'];
							if(trim($paxSection[$count]['rv_agent_ref_fmt']) != "") {
								$details .= $paxSection[$count]['rv_agent_ref_fmt'];
							} 

							array_push($row,
								$paxSection[$count]['rv_item_accomm_count'],
								$details,
								$paxSection[$count]['adult_total'],
								$paxSection[$count]['child_total'],
								$paxSection[$count]['pax_total']
							);
						} else {
							array_push($row,
								"",
								"",
								"",
								"",
								""
							);
						}
					}
					array_push($csvFile,$row);
				}
			}

			array_push($csvFile,array(
				"Total",

				$paxTotals['arrive']['room_total'],
				"",
				$paxTotals['arrive']['adult_total'],
				$paxTotals['arrive']['child_total'],
				$paxTotals['arrive']['pax_total'],

				$paxTotals['stay']['room_total'],
				"",
				$paxTotals['stay']['adult_total'],
				$paxTotals['stay']['child_total'],
				$paxTotals['stay']['pax_total'],

				$paxTotals['depart']['room_total'],
				"",
				$paxTotals['depart']['adult_total'],
				$paxTotals['depart']['child_total'],
				$paxTotals['depart']['pax_total']
			));

			array_push($csvFile,array());
		}

		if($toggleRoom) {
			array_push($csvFile,array("Rooming Plan"));        

			$roomHead = "Per Reservation";
			if($resGuest == "guest") {
				$roomHead = "Per Guest";
			}
			array_push($csvFile,array($roomHead,"Arrive","","","Stay Over","","","Depart"));    
			array_push($csvFile,array("","Res Details","Adlts","Chld","Res Details","Adlts","Chld","Res Details","Adlts","Chld"));    

			$sections = array('arrive'=>"arr",'stay'=>"stay",'depart'=>"dep");
			foreach($roomPax as $ac_accomm_room_id=>$paxItem) {
				$row = array($paxItem['name']);

				foreach($sections as $section=>$htmlSection) {
					$paxSection =& $paxItem['details'][$section];
					if (count($paxSection) > 0){
						$detail = $paxSection[0]['rv_reservation_ix'] . " ";
						if($resGuest == "guest") {
							$detail .= join(" ",$paxSection[0]['guests']);
						} else {
							$detail .= $paxSection[0]['rv_res_name_fmt'];
						}
						array_push($row,
							$detail,
							$paxSection[0]['rv_item_adult_count'],
							$paxSection[0]['rv_item_child_count']
						);
					}

				}
				array_push($csvFile,$row);
			}
			array_push($csvFile,array(
				"PAX Totals",
				"",
				$roomPaxTotals['arrive']['adult_total'],
				$roomPaxTotals['arrive']['child_total'],
				"",
				$roomPaxTotals['stay']['adult_total'],
				$roomPaxTotals['stay']['child_total'],
				"",
				$roomPaxTotals['depart']['adult_total'],
				$roomPaxTotals['depart']['child_total'],
				
			));
			array_push($csvFile,array());
		}

		if($toggleRequests) {
			array_push($csvFile,array("Requests")); 
			array_push($csvFile,array("Reseration Details","Arriving","Departing","Accomm Type","Request","Tot Rms","Rooms")); 

			foreach($requests as $reqItem) {
				array_push($csvFile,array(
					$reqItem['rv_reservation_ix']." ".$reqItem['rv_res_name'],
					$reqItem['rv_item_date_arrive'],
					$reqItem['rv_item_date_depart'],
					$reqItem['ac_accomm_desc'],
					join(", ",$reqItem['requests']),
					$reqItem['rv_item_accomm_count'],
					join(", ",$reqItem['rooms'])
				));
			}  
			
			array_push($csvFile,array());
		}

		if($toggleExtDet) {
			array_push($csvFile,array("Extras"));  
			array_push($csvFile,array("Service Date","Travel","Category","Extra","ETA","ETD","Res Details","Qty","Room (if applicable)"));

			$lastCategory = "";
			$lastExtra = "";
			foreach($extras as $extraItem) {
				$travInd = "";
				if($extraItem['ac_extra_cat_ind'] == 2){
					$travInd = "X";
				}        
				
				if($extraItem['ac_extra_cat_desc'] != $lastCategory) {
					$catDesc = $extraItem['ac_extra_cat_desc'];
					$lastCategory = $extraItem['ac_extra_cat_desc'];
					$lastExtra = "";
				} else {
					$catDesc = "";
				}
				if($extraItem['ac_ext_desc'] != $lastExtra) {
					$extraDesc = $extraItem['ac_ext_desc'];
					$lastExtra = $extraItem['ac_ext_desc'];
				} else {
					$extraDesc = "";
				}
				$roomDesc = "";
				if(!empty($extraItem['ac_desc'])) {
					$roomDesc = $extraItem['ac_desc'];
				}
				array_push($csvFile,array(
					$extraItem['rv_extra_date_serv_fmt'],
					$travInd,
					$catDesc,
					$extraDesc,
					$extraItem['rv_extra_travel_eta'],
					$extraItem['rv_extra_travel_etd'],
					$extraItem['rv_reservation_ix']." ".$extraItem['rv_res_name'],
					$extraItem['rv_extra_units'],
					$roomDesc
				));
			}

			array_push($csvFile,array());
		}
		

		$csvText = "";
		foreach($csvFile as $csvLine) {
			$first = true;
			foreach($csvLine as $csvItem) {
				if(!$first) {
					$csvText .= ",";
				} else {
					$first = false;
				}
				$csvText .= "\"".str_replace("\"","\"\"",$csvItem)."\"";
			}
			$csvText .= "\n";
		}
		if(headers_sent()) {
			//echo('Some data has already been output to browser, can\'t send PDF file');
		}
		$filename = "day_sheet_".str_replace(" ","_",strtolower($propertyName))."_".strtolower($fromWeekDay)."_".str_replace(" ","_",strtolower(chng_date($fromDate,"-"))).".csv";
		header('Content-Type: text/csv');
		header("Cache-control: private");
		header('Content-Length: '.strlen($csvText));
		header("Content-Disposition: inline; filename=$filename");
		echo $csvText;
		flush();
		die();       		
	}
}

function getPersonaDetail($personaId) {
   $detail = $GLOBALS['lDB']->get("
      SELECT
         pr_persona.pr_name_first,
         pr_persona.pr_name_second,
         pr_persona.pr_name_last,
         pr_persona.pr_email
      FROM
         pr_persona
      WHERE
         pr_persona.pr_persona_ix = '".$personaId."'",2);
   $detail = $detail[0];
   $name = "";
   if(trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
      $name .= $detail['pr_name_first'] . " ";
   }
   if(trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
      $name .= $detail['pr_name_second'] . " ";
   }
   if(trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
      $name .= $detail['pr_name_last'] . " ";
   }
   $result = array();
   $result['name'] = trim($name);
   $result['fax'] = getPersonaFax($personaId);
   $result['telephone'] = getPersonaTelephone($personaId);
   $result['email'] = $detail['pr_email'];
   if(trim($result['email']) == "" || $result['email'] == "0") {
      $result['email'] = "";
   }
   return $result;
}
function getPersonaFax($personaId) {
   $fax = $GLOBALS['lDB']->get("
      SELECT
         pr_phone.pr_phone_number
      FROM
         pr_phone, rf_phone_type
      WHERE
         pr_phone.pr_persona_id = '$personaId'
         AND pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
         AND rf_phone_type.rf_phone_type_sys_code = '1'",4);
   if(trim($fax) == "" || $fax == "0") {
      $fax = "";
   }
   return $fax;
}

function getPersonaTelephone($personaId) {
   $tel = $GLOBALS['lDB']->get("
      SELECT
         pr_phone.pr_phone_number
      FROM
         pr_phone
      WHERE
         pr_phone.pr_persona_id = '$personaId'
         AND pr_phone.pr_default_yn = '1'",4);
   if(trim($tel) == "" || $tel == "0") {
      $tel = "";
   }
   return $tel;
}

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));
