<?php

/**
 * init.form306.php - Rooming Report
 * Job: 742
 * Function: 67
*/

require_once(__DIR__ . "/Roman/roman.php");

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
  $_SERVER['argc'] = sizeof($_SERVER['argv']);
}

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_arr_dep.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],16,"");

if($_SERVER['argv'][1] == ""){
	$GLOBALS['temp']['hideResults'] = "display: none";
  $GLOBALS['temp']['hideNotes'] = "display: none"; 	
}else{
  $GLOBALS['temp']['hideNotes'] = "";
}

$fromDate = useDate("from",$_SERVER['argv'][1]);
$toDate = useDate("to",$_SERVER['argv'][2]);
$propertyId = $_SERVER['argv'][3];


// BUG #5484 : START ----------------------------------------------------------
// Reports to hide filters by default
$filterStatus = $_SERVER['argv'][4];
$showHideButtonText = $_SERVER['argv'][15];

$GLOBALS['temp']['filterStatus'] = urldecode($filterStatus);
$GLOBALS['temp']['showHideButtonText'] = $showHideButtonText;

if($filterStatus == "") {
	$GLOBALS['temp']['filterStatus'] = "";
}

if($showHideButtonText == "") {
	$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
}

if($_SERVER['argc'] > 1) {
	if($filterStatus == "") {
		$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";
		$GLOBALS['temp']['showHideButtonText'] = ">> Show Filters";
	}
}

// BUG #5484: END -------------------------------------------------------------

$GLOBALS['temp']['checkByDate'] = "";
$GLOBALS['temp']['checkByDateRange'] = "";
if($fromDate['jsDate'] == $toDate['jsDate']) {
	$GLOBALS['temp']['checkByDate'] = "checked";
} else {
	$GLOBALS['temp']['checkByDateRange'] = "checked";
}

// Get the currenct user's property / business link
$businessId = $lDB->get("
	SELECT
		pr_link.pr_link_to
	FROM
		pr_link
	WHERE
		pr_link.pr_link_from = '$GLOBALS[userid]'
		AND pr_link.rf_link_type_id = 'RS1'
",4);

// Get a list of all the properties linked to the users property / business link
$propertyList = $lDB->get("
	SELECT DISTINCT
		ac_accomm_type.pr_business_id,
		pr_persona.pr_name_last
	FROM
		ac_accomm_type 
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
	WHERE
		ac_accomm_type.pr_business_id IN ('".join("','",getChildren($businessId))."')
",2);
if($propertyId == "") {
	$propertyId = $propertyList[0]['pr_business_id'];
}
$propertyOptions = "";
foreach($propertyList as $property) {
	if($property['pr_business_id'] == $propertyId) {
		$selected = " selected ";
	} else {
		$selected = "";
	}
	$propertyOptions .= "<option $selected value=\"$property[pr_business_id]\">$property[pr_name_last]</option>";
}
$GLOBALS['temp']['propertyOptions'] = $propertyOptions;
$propertyName = $lDB->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '$propertyId'",4);

$reportType = $_SERVER['argv'][5];
$GLOBALS['temp']['reportType'] = $reportType;
$options = $_SERVER['argv'][6];
$GLOBALS['temp']['check'] = "checked";

define("REP_ROOMING_CALENDAR",8);
switch($reportType) {
   case "summary":
      define("REP_PAX_SUMM",16);
      define("RES_CHART",32);
      define("REP_ROOM_SUMM",64);
      define("REP_SUMM_EXTRAS",128);
      break;
   case "daySheet":
      define("REP_PAX",16);
      define("RES_SUMM",32);
      define("REP_ROOM",64);
      define("REP_REQUESTS",128);
      define("REP_EXTRA_DET",256);
      break;
}
define("REP_RES",512);
define("REP_ROOM_LIST",1024);
define("REP_RES_NOTE",2048);
define("REP_AGENT",4096);
define("REP_NATIONALITY",8192);
define("REP_GUEST",16384);
define("REP_GUEST_NOTE",32768);
define("REP_INTERNAL_MEMOS",65536);
define("REP_GUEST_MEMO",131072);
define("REP_EXTRA",262144);
define("REP_EXTRA_NOTE",524288);
define("REP_EXTRA_MEMO",1048576);
define("REP_EXTRA_SERVICE",33554432);
define("REP_EXTRA_REFERENCE",67108864);
define("REP_TRAVEL",2097152);
define("REP_TRAVEL_SERVICE",134217728);
define("REP_TRAVEL_REFERENCE",268435456);
define("REP_TRAVEL_NOTE",4194304);
define("REP_TRAVEL_MEMO",8388608);
define("REP_RATE_TYPE",16777216);

switch($options & 7) {
   case REP_VIEW_HTML:
      $renderMode = "html";
      $renderType = "";
      break;
   case REP_VIEW_PDF:
      $renderMode = "pdf";
      $renderType = "view";
      break;
   case REP_EMAIL_PDF:
      $renderMode = "pdf";
      $renderType = "email";
      break;
   case REP_SEND_PDF:
      $renderMode = "pdf";
      $renderType = "send";
      break;
  case REP_VIEW_CSV:
      $renderMode = "csv";
      $renderType = "export";
      break;
}

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));
$GLOBALS['temp']['hidePageSplit'] = "style=\"display: none;\"";

$resHTMLColour = array("#fcc","#9cf","#9cc","#c9c","#cc9","#fc3","#6cc","#99f","#ffc","#a4c1b6","#bff939","#E0DCCF","#abfef5","#efdbf0","#9fa257","#4d8dce");

if($renderMode == "pdf" && $renderType == "email") {
   $pdfName = "Rooming Report - $fromDate[htmlDate] to $toDate[htmlDate]";
	$attachmentTable = "
		<table border=\"0\" cellspacing=\"0\" width=\"100%\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\"></td>
			<td id=\"attachmentLabel\" width=\"100%\">$pdfName.pdf</td>
		</tr>
		</table>
	";
   $newOptions = ($options & ~7) + 3;
   $formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,6))."+".$newOptions;
	
// echo $formAction."<BR>";

   // get principal
   $principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
   $resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
   $principalInfo = getPersonaDetail($principalId);
   $resOfficeInfo = getPersonaDetail($resOfficeId);

   $GLOBALS[$form]->FormHTML =   str_replace("!formAction!",$formAction,
               str_replace("!attachmentInfo!",$attachmentTable,
               str_replace("!attachmentName!",$pdfName.".pdf",
               str_replace("!hasAttachment!","expand",
               str_replace("!emailBody!","",
               str_replace("!emailSubject!",$pdfName,
               str_replace("!princName!",$principalInfo['name'],
               Join("", file(__DIR__ . "/../../../public/html/email_popup.htm")))))))));

   $addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
   $GLOBALS['temp']['princName]'] = $principalInfo['name'];
   $GLOBALS['temp']['fax'] = $resOfficeInfo['fax'];
   $GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
   $userId = $_SESSION['userid'];
   $GLOBALS['temp']['emailFrom'] = $lDB->get("   SELECT
                           pr_persona.pr_email
                        FROM
                           pr_persona
                        WHERE
                           pr_persona.pr_persona_ix = '".$userId."'", 4);
   $GLOBALS['temp']['emailTo'] = "";
}

if($_SERVER['argc'] > 1) {
	if($renderMode == "html") {
		setLastReport("reservation.php?" . join("+",$_SERVER['argv']));
	}
}  

$currDate = strtotime($fromDate['jsDate']);

$GLOBALS['temp']['showSummary'] = "display: none";
$GLOBALS['temp']['showDaySheet'] = "display: none";

switch($reportType) {
case "summary":
	$reportName = "Rooming Summary";
	$GLOBALS['temp']['showSummary'] = "";
	break;
case "daySheet":
	$reportName = "Rooming Day Sheet";
	$GLOBALS['temp']['showDaySheet'] = "";
	break;
}

$GLOBALS['temp']['showButtons'] = "collapse";

if ( trim($_SERVER['argv'][1]) != "" ) {
	$GLOBALS['temp']['showButtons'] = "";
}	

$dateArray = array();

while ( $currDate <= strtotime($toDate['jsDate']) ) {
	array_push($dateArray,date("Y-m-d",$currDate));
	$currDate += 86400;	
}

$sql = "SELECT
       sc_accomm.ac_accomm_type_id
     FROM
        sc_accomm
     INNER JOIN sc_user ON
        sc_accomm.sc_group_id = sc_user.sc_group_id
     AND
        sc_user.pr_user_id = '".$GLOBALS['userid']."'";
$accommList = $lDB->get($sql,3);  

$accommArray = $lDB->get("
	SELECT
		ac_accomm_type.ac_accomm_type_ix,
		ac_accomm_type.ac_accomm_desc,
		ac_accomm_type.ac_accomm_name_short 
	FROM
		ac_accomm_type
	WHERE
		pr_business_id = '$propertyId'
    AND 
		ac_accomm_type.ac_accomm_type_ix IN ('" . join("','",$accommList) . "')
	AND
		ac_accomm_type.ac_accomm_type_inactive_yn = '0'
",2);

$roomTotal = $lDB->get("
	SELECT
		COUNT(*)
	FROM
		ac_accomm_room
		INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
	WHERE
		ac_accomm_room.ac_accomm_room_inactive_yn = '0'
		AND ac_accomm_type.ac_accomm_type_inactive_yn = '0'
		AND ac_accomm_type.pr_business_id = '$propertyId'
",4);
$GLOBALS['temp']['roomsTotal'] = $roomTotal;

# [Start] PAX
if($reportType == "summary"){
  $paxArray = array();
  $paxTotals = array();
  
  foreach($dateArray as $dateItem) {
  	$inHouse = $lDB->get("
  		SELECT
  			SUM(rv_reservation_item.rv_item_adult_count*rv_reservation_item.rv_item_accomm_count) as adultCount,
  			SUM(rv_reservation_item.rv_item_child_count*rv_reservation_item.rv_item_accomm_count) as childCount,
  			SUM(rv_reservation_item.rv_item_accomm_count) as accommCount,
  			ROUND(SUM(rv_reservation_item.rv_item_accomm_count) / '$roomTotal' * 100) as roomPerc
  		FROM
  			rv_reservation_item
  			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
  		WHERE
  			(
  				rv_reservation_item.rv_item_date_arrive = '$dateItem'
  				OR (
  					rv_reservation_item.rv_item_date_arrive < '$dateItem'					
  					AND rv_reservation_item.rv_item_date_depart > '$dateItem'					
  				)
  			)
  			AND rv_reservation_item.pr_business_id = '$propertyId'
        AND rv_reservation_item.ac_accomm_type_id IN ('".join("','",$accommList)."')
  			AND (
  				rv_reservation.rf_reservation_status_id = '30'
  				OR rv_reservation.rf_reservation_status_id = '20'
  			)
  	",1);
  
    $inHouse['totalCount'] = $inHouse['adultCount'] + $inHouse['childCount'];
  	if (isset($paxTotals['inHouseAccommCount'])) {
  		$paxTotals['inHouseAccommCount'] += $inHouse['accommCount'];
  	} else {
  		$paxTotals['inHouseAccommCount'] = $inHouse['accommCount'];
  	}
  	if (isset($paxTotals['inHouseAdultCount'])) {
  		$paxTotals['inHouseAdultCount'] += $inHouse['adultCount'];
  	} else {
  		$paxTotals['inHouseAdultCount'] = $inHouse['adultCount'];
  	}
  	if (isset($paxTotals['inHouseChildCount'])) {
  		$paxTotals['inHouseChildCount'] += $inHouse['childCount'];
  	} else {
  		$paxTotals['inHouseChildCount'] = $inHouse['childCount'];
  	}
  	
  	if (isset($paxTotals['inHouseTotalCount'])) {
  		$paxTotals['inHouseTotalCount'] += $inHouse['totalCount'];
  	} else {
  		$paxTotals['inHouseTotalCount'] = $inHouse['totalCount'];
  	}
  	
  	$arrive = $lDB->get("
  		SELECT
  			SUM(rv_reservation_item.rv_item_adult_count*rv_reservation_item.rv_item_accomm_count) as adultCount,
  			SUM(rv_reservation_item.rv_item_child_count*rv_reservation_item.rv_item_accomm_count) as childCount,
  			SUM(rv_reservation_item.rv_item_accomm_count) as accommCount
  		FROM
  			rv_reservation_item
  			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
  		WHERE
  			rv_reservation_item.rv_item_date_arrive = '$dateItem'
  			AND rv_reservation_item.pr_business_id = '$propertyId'
        AND rv_reservation_item.ac_accomm_type_id IN ('".join("','",$accommList)."')
  			AND (
  				rv_reservation.rf_reservation_status_id = '30'
  				OR rv_reservation.rf_reservation_status_id = '20'
  			)
  	",1);
    $arrive['totalCount'] = $arrive['adultCount'] + $arrive['childCount'];
    if (isset($paxTotals['arriveAccommCount'])) {
    	$paxTotals['arriveAccommCount'] += $arrive['accommCount'];
    } else {
    	$paxTotals['arriveAccommCount'] = $arrive['accommCount'];
    }
    if (isset($paxTotals['arriveAdultCount'])) {
    	$paxTotals['arriveAdultCount'] += $arrive['adultCount'];
    } else {
    	$paxTotals['arriveAdultCount'] = $arrive['adultCount'];
    }
    if (isset($paxTotals['arriveChildCount'])) {
    	$paxTotals['arriveChildCount'] += $arrive['childCount'];
    } else {
    	$paxTotals['arriveChildCount'] = $arrive['childCount'];
    }
    if (isset($paxTotals['arriveTotalCount'])) {
    	$paxTotals['arriveTotalCount'] += $arrive['totalCount'];
    } else {
    	$paxTotals['arriveTotalCount'] = $arrive['totalCount'];
    }
  	
  	$stayover = $lDB->get("
  		SELECT
  			SUM(rv_reservation_item.rv_item_adult_count*rv_reservation_item.rv_item_accomm_count) as adultCount,
  			SUM(rv_reservation_item.rv_item_child_count*rv_reservation_item.rv_item_accomm_count) as childCount,			
  			SUM(rv_reservation_item.rv_item_accomm_count) as accommCount
  		FROM
  			rv_reservation_item
  			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
  		WHERE
  			rv_reservation_item.rv_item_date_arrive < '$dateItem'
  			AND rv_reservation_item.rv_item_date_depart > '$dateItem'
  			AND rv_reservation_item.pr_business_id = '$propertyId'
        AND rv_reservation_item.ac_accomm_type_id IN ('".join("','",$accommList)."')
  			AND (
  				rv_reservation.rf_reservation_status_id = '30'
  				OR rv_reservation.rf_reservation_status_id = '20'
  			)
  	",1);
    $stayover['totalCount'] = $stayover['adultCount'] + $stayover['childCount'];
    if (isset($paxTotals['stayoverAccommCount'])) {
    	$paxTotals['stayoverAccommCount'] += $stayover['accommCount'];
    } else {
    	$paxTotals['stayoverAccommCount'] = $stayover['accommCount'];
    }
    if (isset($paxTotals['stayoverAdultCount'])) {
    	$paxTotals['stayoverAdultCount'] += $stayover['adultCount'];
    } else {
    	$paxTotals['stayoverAdultCount'] = $stayover['adultCount'];
    }
    if (isset($paxTotals['stayoverChildCount'])) {
    	$paxTotals['stayoverChildCount'] += $stayover['childCount'];
    } else {
    	$paxTotals['stayoverChildCount'] = $stayover['childCount'];
    }
    if (isset($paxTotals['stayoverTotalCount'])) {
    	$paxTotals['stayoverTotalCount'] += $stayover['totalCount'];
    } else {
    	$paxTotals['stayoverTotalCount'] = $stayover['totalCount'];
    }
  	
  	$depart = $lDB->get("
  		SELECT
  			SUM(rv_reservation_item.rv_item_adult_count*rv_reservation_item.rv_item_accomm_count) as adultCount,
  			SUM(rv_reservation_item.rv_item_child_count*rv_reservation_item.rv_item_accomm_count) as childCount,
  			SUM(rv_reservation_item.rv_item_accomm_count) as accommCount
  		FROM
  			rv_reservation_item
  			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
  		WHERE
  			rv_reservation_item.rv_item_date_depart = '$dateItem'
  			AND rv_reservation_item.pr_business_id = '$propertyId'
        AND rv_reservation_item.ac_accomm_type_id IN ('".join("','",$accommList)."')
  			AND (
  				rv_reservation.rf_reservation_status_id = '30'
  				OR rv_reservation.rf_reservation_status_id = '20'
  			)
  	",1);
    $depart['totalCount'] = $depart['adultCount'] + $depart['childCount'];
    if (isset($paxTotals['departAccommCount'])) {
    	$paxTotals['departAccommCount'] += $depart['accommCount'];
    } else {
    	$paxTotals['departAccommCount'] = $depart['accommCount'];
    }
    if (isset($paxTotals['departAdultCount'])) {
    	$paxTotals['departAdultCount'] += $depart['adultCount'];
    } else {
    	$paxTotals['departAdultCount'] = $depart['adultCount'];
    }
    if (isset($paxTotals['departChildCount'])) {
    	$paxTotals['departChildCount'] += $depart['childCount'];
    } else {
    	$paxTotals['departChildCount'] = $depart['childCount'];
    }
    if (isset($paxTotals['departTotalCount'])) {
    	$paxTotals['departTotalCount'] += $depart['totalCount'];
    } else {
    	$paxTotals['departTotalCount'] = $depart['totalCount'];
    }

  	array_push($paxArray,array('date'=>$dateItem, 'inHouse'=>$inHouse, 'arrive'=>$arrive, 'stayover'=>$stayover, 'depart'=>$depart));
  }
}

if($reportType == "daySheet"){
  $dayPaxArray = array();
  $dayPaxTotalArray = array();
  foreach($dateArray as $dateItem) {
  	$dayPaxArray[$dateItem] = $accommArray;
  	foreach($dayPaxArray[$dateItem] as $dayPaxKey=>$dayPaxItem) {
  		$dayPaxArray[$dateItem][$dayPaxKey]['inHouse'] = $lDB->get("
  			SELECT
  				SUM(rv_reservation_item.rv_item_adult_count*rv_reservation_item.rv_item_accomm_count) as adultCount,
  				SUM(rv_reservation_item.rv_item_child_count*rv_reservation_item.rv_item_accomm_count) as childCount,			
  				SUM(rv_reservation_item.rv_item_accomm_count) as accommCount,
  				ROUND(SUM(rv_reservation_item.rv_item_accomm_count) / '$roomTotal' * 100) as roomPerc
  			FROM
  				rv_reservation_item
  				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
  			WHERE
  				(
  					rv_reservation_item.rv_item_date_arrive = '$dateItem'
  					OR (
  						rv_reservation_item.rv_item_date_arrive < '$dateItem'					
  						AND rv_reservation_item.rv_item_date_depart > '$dateItem'					
  					)
  				)
  				AND rv_reservation_item.pr_business_id = '$propertyId'
  				AND rv_reservation_item.ac_accomm_type_id = '$dayPaxItem[ac_accomm_type_ix]'
  				AND (
  					rv_reservation.rf_reservation_status_id = '30'
  					OR rv_reservation.rf_reservation_status_id = '20'
  				)
  		",1);
  		if($dayPaxArray[$dateItem][$dayPaxKey]['inHouse']['accommCount'] == "0" || $dayPaxArray[$dateItem][$dayPaxKey]['inHouse']['accommCount'] == "") {
  			$dayPaxArray[$dateItem][$dayPaxKey]['inHouse']['adultCount'] = "0";
  			$dayPaxArray[$dateItem][$dayPaxKey]['inHouse']['childCount'] = "0";
  			$dayPaxArray[$dateItem][$dayPaxKey]['inHouse']['totalCount'] = "0";
  			$dayPaxArray[$dateItem][$dayPaxKey]['inHouse']['accommCount'] = "0";
  			$dayPaxArray[$dateItem][$dayPaxKey]['inHouse']['roomPerc'] = "0";
  		}
      
		$dayPaxArray[$dateItem][$dayPaxKey]['inHouse']['totalCount'] = $dayPaxArray[$dateItem][$dayPaxKey]['inHouse']['adultCount'] + $dayPaxArray[$dateItem][$dayPaxKey]['inHouse']['childCount'];
  		if (isset($dayPaxTotalArray[$dateItem]['inHouseAccommCount'])) {
  			$dayPaxTotalArray[$dateItem]['inHouseAccommCount'] += $dayPaxArray[$dateItem][$dayPaxKey]['inHouse']['accommCount'];
  		} else {
  			$dayPaxTotalArray[$dateItem]['inHouseAccommCount'] = $dayPaxArray[$dateItem][$dayPaxKey]['inHouse']['accommCount'];
  		}
  		if (isset($dayPaxTotalArray[$dateItem]['inHouseAdultCount'])) {
  			$dayPaxTotalArray[$dateItem]['inHouseAdultCount'] += $dayPaxArray[$dateItem][$dayPaxKey]['inHouse']['adultCount'];
  		} else {
  			$dayPaxTotalArray[$dateItem]['inHouseAdultCount'] = $dayPaxArray[$dateItem][$dayPaxKey]['inHouse']['adultCount'];
  		}
  		if (isset($dayPaxTotalArray[$dateItem]['inHouseChildCount'])) {
  			$dayPaxTotalArray[$dateItem]['inHouseChildCount'] += $dayPaxArray[$dateItem][$dayPaxKey]['inHouse']['childCount'];
  		} else {
  			$dayPaxTotalArray[$dateItem]['inHouseChildCount'] = $dayPaxArray[$dateItem][$dayPaxKey]['inHouse']['childCount'];
  		}
  		if (isset($dayPaxTotalArray[$dateItem]['inHouseTotalCount'])) {
  			$dayPaxTotalArray[$dateItem]['inHouseTotalCount'] += $dayPaxArray[$dateItem][$dayPaxKey]['inHouse']['totalCount'];
  		} else {
  			$dayPaxTotalArray[$dateItem]['inHouseTotalCount'] = $dayPaxArray[$dateItem][$dayPaxKey]['inHouse']['totalCount'];
  		}
  
  		$dayPaxArray[$dateItem][$dayPaxKey]['arrive'] = $lDB->get("
  			SELECT
  				SUM(rv_reservation_item.rv_item_adult_count*rv_reservation_item.rv_item_accomm_count) as adultCount,
  				SUM(rv_reservation_item.rv_item_child_count*rv_reservation_item.rv_item_accomm_count) as childCount,
  				SUM(rv_reservation_item.rv_item_accomm_count) as accommCount
  			FROM
  				rv_reservation_item
  				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
  			WHERE
  				rv_reservation_item.rv_item_date_arrive = '$dateItem'
  				AND rv_reservation_item.pr_business_id = '$propertyId'
  				AND rv_reservation_item.ac_accomm_type_id = '$dayPaxItem[ac_accomm_type_ix]'
  				AND (
  					rv_reservation.rf_reservation_status_id = '30'
  					OR rv_reservation.rf_reservation_status_id = '20'
  				)
  		",1);
  		if ( $dayPaxArray[$dateItem][$dayPaxKey]['arrive']['accommCount'] == "0" || $dayPaxArray[$dateItem][$dayPaxKey]['arrive']['accommCount'] == "" ) {
			$dayPaxArray[$dateItem][$dayPaxKey]['arrive']['adultCount'] = "0";
  			$dayPaxArray[$dateItem][$dayPaxKey]['arrive']['childCount'] = "0";
  			$dayPaxArray[$dateItem][$dayPaxKey]['arrive']['totalCount'] = "0";
  			$dayPaxArray[$dateItem][$dayPaxKey]['arrive']['accommCount'] = "0";
  		}
      	$dayPaxArray[$dateItem][$dayPaxKey]['arrive']['totalCount'] = $dayPaxArray[$dateItem][$dayPaxKey]['arrive']['adultCount'] + $dayPaxArray[$dateItem][$dayPaxKey]['arrive']['childCount'];
  		if (isset($dayPaxTotalArray[$dateItem]['arriveAccommCount'])) {
  			$dayPaxTotalArray[$dateItem]['arriveAccommCount'] += $dayPaxArray[$dateItem][$dayPaxKey]['arrive']['accommCount'];
  		} else {
  			$dayPaxTotalArray[$dateItem]['arriveAccommCount'] = $dayPaxArray[$dateItem][$dayPaxKey]['arrive']['accommCount'];
  		}
  		if (isset($dayPaxTotalArray[$dateItem]['arriveAdultCount'])) {
  			$dayPaxTotalArray[$dateItem]['arriveAdultCount'] += $dayPaxArray[$dateItem][$dayPaxKey]['arrive']['adultCount'];
  		} else {
  			$dayPaxTotalArray[$dateItem]['arriveAdultCount'] = $dayPaxArray[$dateItem][$dayPaxKey]['arrive']['adultCount'];
  		}
  		if (isset($dayPaxTotalArray[$dateItem]['arriveChildCount'])) {
  			$dayPaxTotalArray[$dateItem]['arriveChildCount'] += $dayPaxArray[$dateItem][$dayPaxKey]['arrive']['childCount'];
  		} else {
  			$dayPaxTotalArray[$dateItem]['arriveChildCount'] = $dayPaxArray[$dateItem][$dayPaxKey]['arrive']['childCount'];
  		}
  		if (isset($dayPaxTotalArray[$dateItem]['arriveTotalCount'])) {
  			$dayPaxTotalArray[$dateItem]['arriveTotalCount'] += $dayPaxArray[$dateItem][$dayPaxKey]['arrive']['totalCount'];
  		} else {
  			$dayPaxTotalArray[$dateItem]['arriveTotalCount'] = $dayPaxArray[$dateItem][$dayPaxKey]['arrive']['totalCount'];
  		}
  
  		$dayPaxArray[$dateItem][$dayPaxKey]['stayover'] = $lDB->get("
  			SELECT
  				SUM(rv_reservation_item.rv_item_adult_count*rv_reservation_item.rv_item_accomm_count) as adultCount,
  				SUM(rv_reservation_item.rv_item_child_count*rv_reservation_item.rv_item_accomm_count) as childCount,				
  				SUM(rv_reservation_item.rv_item_accomm_count) as accommCount
  			FROM
  				rv_reservation_item
  				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
  			WHERE
  				rv_reservation_item.rv_item_date_arrive < '$dateItem'
  				AND rv_reservation_item.rv_item_date_depart >= '$dateItem'
  				AND rv_reservation_item.pr_business_id = '$propertyId'
  				AND rv_reservation_item.ac_accomm_type_id = '$dayPaxItem[ac_accomm_type_ix]'
  				AND (
  					rv_reservation.rf_reservation_status_id = '30'
  					OR rv_reservation.rf_reservation_status_id = '20'
  				)
  		",1);
  		if($dayPaxArray[$dateItem][$dayPaxKey]['stayover']['accommCount'] == "0" || $dayPaxArray[$dateItem][$dayPaxKey]['stayover']['accommCount'] == "") {
  			$dayPaxArray[$dateItem][$dayPaxKey]['stayover']['adultCount'] = "0";
  			$dayPaxArray[$dateItem][$dayPaxKey]['stayover']['childCount'] = "0";
  			$dayPaxArray[$dateItem][$dayPaxKey]['stayover']['totalCount'] = "0";
  			$dayPaxArray[$dateItem][$dayPaxKey]['stayover']['accommCount'] = "0";
  		}
      $dayPaxArray[$dateItem][$dayPaxKey]['stayover']['totalCount'] = $dayPaxArray[$dateItem][$dayPaxKey]['stayover']['adultCount'] + $dayPaxArray[$dateItem][$dayPaxKey]['stayover']['childCount']; 
  		if (isset($dayPaxTotalArray[$dateItem]['stayoverAccommCount'])) {
  			$dayPaxTotalArray[$dateItem]['stayoverAccommCount'] += $dayPaxArray[$dateItem][$dayPaxKey]['stayover']['accommCount'];
  		} else {
  			$dayPaxTotalArray[$dateItem]['stayoverAccommCount'] = $dayPaxArray[$dateItem][$dayPaxKey]['stayover']['accommCount'];
  		}
  		if (isset($dayPaxTotalArray[$dateItem]['stayoverAdultCount'])) {
  			$dayPaxTotalArray[$dateItem]['stayoverAdultCount'] += $dayPaxArray[$dateItem][$dayPaxKey]['stayover']['adultCount'];
  		} else {
  			$dayPaxTotalArray[$dateItem]['stayoverAdultCount'] = $dayPaxArray[$dateItem][$dayPaxKey]['stayover']['adultCount'];
  		}
  		if (isset($dayPaxTotalArray[$dateItem]['stayoverChildCount'])) {
  			$dayPaxTotalArray[$dateItem]['stayoverChildCount'] += $dayPaxArray[$dateItem][$dayPaxKey]['stayover']['childCount'];
  		} else {
  			$dayPaxTotalArray[$dateItem]['stayoverChildCount'] = $dayPaxArray[$dateItem][$dayPaxKey]['stayover']['childCount'];
  		}
  		if (isset($dayPaxTotalArray[$dateItem]['stayoverTotalCount'])) {
  			$dayPaxTotalArray[$dateItem]['stayoverTotalCount'] += $dayPaxArray[$dateItem][$dayPaxKey]['stayover']['totalCount'];
  		} else {
  			$dayPaxTotalArray[$dateItem]['stayoverTotalCount'] = $dayPaxArray[$dateItem][$dayPaxKey]['stayover']['totalCount'];
  		}
  
  		$dayPaxArray[$dateItem][$dayPaxKey]['depart'] = $lDB->get("
  			SELECT
  				SUM(rv_reservation_item.rv_item_adult_count*rv_reservation_item.rv_item_accomm_count) as adultCount,
  				SUM(rv_reservation_item.rv_item_child_count*rv_reservation_item.rv_item_accomm_count) as childCount,
  				SUM(rv_reservation_item.rv_item_accomm_count) as accommCount
  			FROM
  				rv_reservation_item
  				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
  			WHERE
  				rv_reservation_item.rv_item_date_depart = '$dateItem'
  				AND rv_reservation_item.pr_business_id = '$propertyId'
  				AND rv_reservation_item.ac_accomm_type_id = '$dayPaxItem[ac_accomm_type_ix]'
  				AND (
  					rv_reservation.rf_reservation_status_id = '30'
  					OR rv_reservation.rf_reservation_status_id = '20'
  				)
  		",1);
  		if($dayPaxArray[$dateItem][$dayPaxKey]['depart']['accommCount'] == "0" || $dayPaxArray[$dateItem][$dayPaxKey]['depart']['accommCount'] == "") {
  			$dayPaxArray[$dateItem][$dayPaxKey]['depart']['adultCount'] = "0";
  			$dayPaxArray[$dateItem][$dayPaxKey]['depart']['childCount'] = "0";
  			$dayPaxArray[$dateItem][$dayPaxKey]['depart']['totalCount'] = "0";
  			$dayPaxArray[$dateItem][$dayPaxKey]['depart']['accommCount'] = "0";
  		}
      $dayPaxArray[$dateItem][$dayPaxKey]['depart']['totalCount'] = $dayPaxArray[$dateItem][$dayPaxKey]['depart']['adultCount'] + $dayPaxArray[$dateItem][$dayPaxKey]['depart']['childCount']; 
  		if (isset($dayPaxTotalArray[$dateItem]['departAccommCount'])) {
  			$dayPaxTotalArray[$dateItem]['departAccommCount'] += $dayPaxArray[$dateItem][$dayPaxKey]['depart']['accommCount'];
  		} else {
  			$dayPaxTotalArray[$dateItem]['departAccommCount'] = $dayPaxArray[$dateItem][$dayPaxKey]['depart']['accommCount'];
  		}
  		if (isset($dayPaxTotalArray[$dateItem]['departAdultCount'])) {
  			$dayPaxTotalArray[$dateItem]['departAdultCount'] += $dayPaxArray[$dateItem][$dayPaxKey]['depart']['adultCount'];
  		} else {
  			$dayPaxTotalArray[$dateItem]['departAdultCount'] = $dayPaxArray[$dateItem][$dayPaxKey]['depart']['adultCount'];
  		}
  		if (isset($dayPaxTotalArray[$dateItem]['departChildCount'])) {
  			$dayPaxTotalArray[$dateItem]['departChildCount'] += $dayPaxArray[$dateItem][$dayPaxKey]['depart']['childCount'];
  		} else {
  			$dayPaxTotalArray[$dateItem]['departChildCount'] = $dayPaxArray[$dateItem][$dayPaxKey]['depart']['childCount'];
  		}
  		if (isset($dayPaxTotalArray[$dateItem]['departTotalCount'])) {
  			$dayPaxTotalArray[$dateItem]['departTotalCount'] += $dayPaxArray[$dateItem][$dayPaxKey]['depart']['totalCount'];
  		} else {
  			$dayPaxTotalArray[$dateItem]['departTotalCount'] = $dayPaxArray[$dateItem][$dayPaxKey]['depart']['totalCount'];
  		}
  	}
  }
}  

$resSummaryArray = array();
$resSummaryMax = 0;

foreach ( $accommArray as $accommItem ) {
	$resSummaryArray[$accommItem['ac_accomm_desc']] = array();  
	foreach($dateArray as $dateItem) {
		$resSummaryArray[$accommItem['ac_accomm_desc']][$dateItem] = $lDB->get("
			SELECT
				rv_reservation.rv_reservation_ix,
				rv_reservation.rv_res_name,
				rv_reservation.rv_agent_ref,
        rv_reservation.rv_provision_expiry_date,
        rv_reservation.rf_reservation_status_id,
        rv_reservation_item.rv_reservation_item_ix,
				rv_reservation_item.rv_item_adult_count,
				rv_reservation_item.rv_item_child_count,
				rv_reservation_item.rv_item_accomm_count,
        rv_res_item_group.rv_res_item_group_ix
			FROM
				rv_reservation_item
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
        LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
			WHERE
				rv_reservation_item.rv_item_date_arrive <= '$dateItem'
				AND rv_reservation_item.rv_item_date_depart > '$dateItem'
				AND rv_reservation_item.pr_business_id = '$propertyId'
				AND rv_reservation_item.ac_accomm_type_id = '$accommItem[ac_accomm_type_ix]'
				AND (
					rv_reservation.rf_reservation_status_id = '30'
					OR rv_reservation.rf_reservation_status_id = '20'
				)
		",2);
    
		if(sizeof($resSummaryArray[$accommItem['ac_accomm_desc']][$dateItem]) > $resSummaryMax) {
			$resSummaryMax = sizeof($resSummaryArray[$accommItem['ac_accomm_desc']][$dateItem]);
		}
	}
}

$roomSummaryArray = $lDB->get("
	SELECT
		ac_accomm_room.ac_desc,
		ac_accomm_room.ac_accomm_room_ix,
		ac_accomm_type.ac_accomm_desc,
		ac_accomm_type.ac_accomm_type_ix,
    ac_accomm_type.ac_accomm_name_short
	FROM
		ac_accomm_room
		INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
	WHERE
		ac_accomm_room.ac_accomm_room_inactive_yn = '0'
		AND ac_accomm_type.ac_accomm_type_inactive_yn = '0'
		AND ac_accomm_type.pr_business_id = '$propertyId'
    AND ac_accomm_type.ac_accomm_type_ix IN ('".join("','",$accommList)."')    
	ORDER BY		
		ac_accomm_room.ac_desc,
    ac_accomm_type.ac_accomm_desc
",2);

$resItemList = array();
foreach($roomSummaryArray as $roomSummaryKey=>$roomSummaryItem) {
	foreach($dateArray as $dateItem) {
		$roomSummaryArray[$roomSummaryKey]['items'][$dateItem] = $lDB->get("
			SELECT
				rv_reservation.rv_reservation_ix,
				rv_reservation.rv_res_name,
				rv_reservation.rv_agent_ref,
				rv_reservation.rv_provision_expiry_date,
				rv_reservation.rf_reservation_status_id,
				rv_reservation_item.rv_reservation_item_ix,
				rv_reservation_item.rv_item_adult_count,
				rv_reservation_item.rv_item_child_count,
				rv_res_item_group.rv_res_item_group_ix as groupId
			FROM
				rv_res_item_group
			INNER JOIN rv_reservation_item ON
				rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			INNER JOIN rv_reservation ON
				rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			WHERE
				rv_res_item_group.ac_accomm_room_id = '" . $roomSummaryItem['ac_accomm_room_ix'] . "'
			AND
				rv_reservation_item.rv_item_date_arrive <= '" . $dateItem . "'
			AND
				rv_reservation_item.rv_item_date_depart > '" . $dateItem . "'
        	AND
				rv_reservation_item.ac_accomm_type_id IN ('" . join("','",$accommList) . "')
			AND (
					rv_reservation.rf_reservation_status_id = '30'
					OR 
					rv_reservation.rf_reservation_status_id = '20'
				)
		",1);
    
    	/* Reservations only get allocated to a 'rv_res_item_group' when rooms/guest names have been allocated before
		$noRoomSummaryArray[$roomSummaryKey]['items'][$dateItem] = $lDB->get("
			SELECT
				rv_reservation.rv_reservation_ix
			FROM
				rv_res_item_group
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			WHERE
				(rv_res_item_group.ac_accomm_room_id = '0' OR rv_res_item_group.ac_accomm_room_id = '')
				AND rv_reservation_item.rv_item_date_arrive <= '$dateItem'
				AND rv_reservation_item.rv_item_date_depart > '$dateItem'
        AND rv_reservation_item.ac_accomm_type_id IN ('".join("','",$accommList)."')
				AND (
					rv_reservation.rf_reservation_status_id = '30'
					OR rv_reservation.rf_reservation_status_id = '20'
				)
		",1);*/
    
	    // Therefore, check Reservations that do note have a 'rv_res_item_group' link
		$resItemList = $lDB->get("
			SELECT DISTINCT
				rv_reservation_item.rv_reservation_id
			FROM
      			rv_reservation_item
        	INNER JOIN rv_reservation ON
				rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			WHERE				      
				(
					rv_reservation_item.rv_item_date_arrive <= '" . $dateItem . "'
					AND
					rv_reservation_item.rv_item_date_depart >= '" .$dateItem . "'
				)
        	AND
				rv_reservation_item.ac_accomm_type_id IN ('" . join("','",$accommList) . "')
			AND
				(
					rv_reservation.rf_reservation_status_id = '30'
					OR
					rv_reservation.rf_reservation_status_id = '20'
				)
     ",3);
	}
}

$itemSize = sizeof($resItemList);
$roomItems = array();
foreach($resItemList as $rItem){
	 // Check if there is a room allocated
 	 $groupRoomId = $lDB->get("
			SELECT
				rv_res_item_group.rv_res_item_group_ix
			FROM
				rv_res_item_group
			WHERE
         rv_res_item_group.rv_reservation_item_id = '$rItem'
         AND
				(rv_res_item_group.ac_accomm_room_id != '0' OR rv_res_item_group.ac_accomm_room_id != '')
		",4);
    if($groupRoomId != '0'){
	    array_push($roomItems,$groupRoomId);
    }  
} 

$roomSize = sizeof($roomItems);
$GLOBALS['temp']['noRooms'] = "collapse printCollapse";

$dayResSummaryArray = array();
$dayResSummaryTotalArray = array();
$dayResSummSql = "
	SELECT
		rv_reservation.rv_reservation_ix,
		rv_reservation.rv_res_name,
		rv_reservation.rv_agent_ref,
		rv_reservation.rf_reservation_status_id,
		rv_reservation.rv_provision_expiry_date,
		rv_reservation_item.rv_item_adult_count,
		rv_reservation_item.rv_item_child_count,
		rv_reservation_item.rv_item_accomm_count
	FROM
		rv_reservation_item
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
";

foreach($dateArray as $dateItem) {
	$dayResSummaryArray[$dateItem] = $accommArray;
	foreach($dayResSummaryArray[$dateItem] as $dayResSummaryKey=>$dayResSummaryItem) {
		$dayResSummaryArray[$dateItem][$dayResSummaryKey]['arrive'] = $lDB->get("
			$dayResSummSql
			WHERE
				rv_reservation_item.rv_item_date_arrive = '$dateItem'
				AND rv_reservation_item.pr_business_id = '$propertyId'	
				AND rv_reservation_item.ac_accomm_type_id = '$dayResSummaryItem[ac_accomm_type_ix]'
				AND (
					rv_reservation.rf_reservation_status_id = '30'
					OR rv_reservation.rf_reservation_status_id = '20'
				)
		",2);
		foreach($dayResSummaryArray[$dateItem][$dayResSummaryKey]['arrive'] as $item) {
			if (isset($dayResSummaryTotalArray[$dateItem]['arriveRoom'])) {
				$dayResSummaryTotalArray[$dateItem]['arriveRoom'] += $item['rv_item_accomm_count'];
			} else {
				$dayResSummaryTotalArray[$dateItem]['arriveRoom'] = $item['rv_item_accomm_count'];
			}
			if (isset($dayResSummaryTotalArray[$dateItem]['arriveAdult'])) {
				$dayResSummaryTotalArray[$dateItem]['arriveAdult'] += $item['rv_item_adult_count'];
			} else {
				$dayResSummaryTotalArray[$dateItem]['arriveAdult'] = $item['rv_item_adult_count'];
			}
			if (isset($dayResSummaryTotalArray[$dateItem]['arriveChild'])) {
				$dayResSummaryTotalArray[$dateItem]['arriveChild'] += $item['rv_item_child_count'];
			} else {
				$dayResSummaryTotalArray[$dateItem]['arriveChild'] = $item['rv_item_child_count'];
			}
			if (isset($dayResSummaryTotalArray[$dateItem]['arriveTotal'])) {
				$dayResSummaryTotalArray[$dateItem]['arriveTotal'] += ($item['rv_item_adult_count']*$item['rv_item_accomm_count']) + ($item['rv_item_child_count']*$item['rv_item_accomm_count']);
			} else {
				$dayResSummaryTotalArray[$dateItem]['arriveTotal'] = ($item['rv_item_adult_count']*$item['rv_item_accomm_count']) + ($item['rv_item_child_count']*$item['rv_item_accomm_count']);
			}
			
		}
		$dayResSummaryArray[$dateItem][$dayResSummaryKey]['stayover'] = $lDB->get(
			$dayResSummSql . "
			WHERE
				rv_reservation_item.rv_item_date_arrive < '$dateItem'
			AND
				rv_reservation_item.rv_item_date_depart > '$dateItem'
			AND
				rv_reservation_item.pr_business_id = '$propertyId'	
			AND
				rv_reservation_item.ac_accomm_type_id = '" . $dayResSummaryItem['ac_accomm_type_ix'] . "'
			AND
				(
					rv_reservation.rf_reservation_status_id = '30'
					OR
					rv_reservation.rf_reservation_status_id = '20'
				)
		",2);
		foreach ( $dayResSummaryArray[$dateItem][$dayResSummaryKey]['stayover'] as $item ) {
			if (isset($dayResSummaryTotalArray[$dateItem]['stayoverRoom'])) {
				$dayResSummaryTotalArray[$dateItem]['stayoverRoom'] += $item['rv_item_accomm_count'];
			} else {
				$dayResSummaryTotalArray[$dateItem]['stayoverRoom'] = $item['rv_item_accomm_count'];
			}
			if (isset($dayResSummaryTotalArray[$dateItem]['stayoverAdult'])) {
				$dayResSummaryTotalArray[$dateItem]['stayoverAdult'] += $item['rv_item_adult_count'];
			} else {
				$dayResSummaryTotalArray[$dateItem]['stayoverAdult'] = $item['rv_item_adult_count'];
			}
			if (isset($dayResSummaryTotalArray[$dateItem]['stayoverChild'])) {
				$dayResSummaryTotalArray[$dateItem]['stayoverChild'] += $item['rv_item_child_count'];
			} else {
				$dayResSummaryTotalArray[$dateItem]['stayoverChild'] = $item['rv_item_child_count'];
			}
			if (isset($dayResSummaryTotalArray[$dateItem]['stayoverTotal'])) {
				$dayResSummaryTotalArray[$dateItem]['stayoverTotal'] += ($item['rv_item_adult_count']*$item['rv_item_accomm_count']) + ($item['rv_item_child_count']*$item['rv_item_accomm_count']);
			} else {
				$dayResSummaryTotalArray[$dateItem]['stayoverTotal'] = ($item['rv_item_adult_count']*$item['rv_item_accomm_count']) + ($item['rv_item_child_count']*$item['rv_item_accomm_count']);
			}
			
		}
		$dayResSummaryArray[$dateItem][$dayResSummaryKey]['depart'] = $lDB->get("
			$dayResSummSql
			WHERE
				rv_reservation_item.rv_item_date_depart = '$dateItem'
				AND rv_reservation_item.pr_business_id = '$propertyId'	
				AND rv_reservation_item.ac_accomm_type_id = '$dayResSummaryItem[ac_accomm_type_ix]'
				AND (
					rv_reservation.rf_reservation_status_id = '30'
					OR rv_reservation.rf_reservation_status_id = '20'
				)
		",2);

		foreach($dayResSummaryArray[$dateItem][$dayResSummaryKey]['depart'] as $item) {
			if (isset($dayResSummaryTotalArray[$dateItem]['departRoom'])) {
				$dayResSummaryTotalArray[$dateItem]['departRoom'] += $item['rv_item_accomm_count'];
			} else {
				$dayResSummaryTotalArray[$dateItem]['departRoom'] = $item['rv_item_accomm_count'];
			}
			if (isset($dayResSummaryTotalArray[$dateItem]['departAdult'])) {
				$dayResSummaryTotalArray[$dateItem]['departAdult'] += $item['rv_item_adult_count'];
			} else {
				$dayResSummaryTotalArray[$dateItem]['departAdult'] = $item['rv_item_adult_count'];
			}
			if (isset($dayResSummaryTotalArray[$dateItem]['departChild'])) {
				$dayResSummaryTotalArray[$dateItem]['departChild'] += $item['rv_item_child_count'];
			} else {
				$dayResSummaryTotalArray[$dateItem]['departChild'] = $item['rv_item_child_count'];
			}
			if (isset($dayResSummaryTotalArray[$dateItem]['departTotal'])) {
				$dayResSummaryTotalArray[$dateItem]['departTotal'] += ($item['rv_item_adult_count']*$item['rv_item_accomm_count']) + ($item['rv_item_child_count']*$item['rv_item_accomm_count']);
			} else {
				$dayResSummaryTotalArray[$dateItem]['departTotal'] = ($item['rv_item_adult_count']*$item['rv_item_accomm_count']) + ($item['rv_item_child_count']*$item['rv_item_accomm_count']);
			}
			
		}
	}
}

$roomArray = $lDB->get("
	SELECT
		ac_accomm_room.ac_desc,
		ac_accomm_room.ac_accomm_room_ix,
		ac_accomm_type.ac_accomm_desc,
		ac_accomm_type.ac_accomm_type_ix
	FROM
		ac_accomm_room
		INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
	WHERE
		ac_accomm_room.ac_accomm_room_inactive_yn = '0'
		AND ac_accomm_type.ac_accomm_type_inactive_yn = '0'
		AND ac_accomm_type.pr_business_id = '$propertyId'
    AND ac_accomm_type.ac_accomm_type_ix IN ('".join("','",$accommList)."')
	ORDER BY
		ac_accomm_type.ac_accomm_desc,
		ac_accomm_room.ac_desc
",2);

$dayRoomArray = array();
$dayRoomTotalArray = array();
$dayRoomSql = "
	SELECT
		rv_reservation.rv_reservation_ix,
		rv_reservation.rv_res_name,
		rv_reservation.rv_agent_ref,
		rv_reservation.rf_reservation_status_id,
		rv_reservation.rv_provision_expiry_date,
		rv_reservation_item.rv_item_adult_count,
		rv_reservation_item.rv_item_child_count,
		rv_reservation_item.rv_item_accomm_count,
      rv_res_item_group.rv_res_item_group_ix as groupId
	FROM
		rv_res_item_group
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
";

foreach($dateArray as $dateItem) {
	$dayRoomArray[$dateItem] = $roomArray;
	foreach($dayRoomArray[$dateItem] as $dayRoomKey=>$dayRoomItem) {
		$dayRoomArray[$dateItem][$dayRoomKey]['arrive'] = $lDB->get("
			$dayRoomSql
			WHERE
				rv_res_item_group.ac_accomm_room_id = '$dayRoomItem[ac_accomm_room_ix]'
				AND rv_reservation_item.rv_item_date_arrive = '$dateItem'
				AND (
					rv_reservation.rf_reservation_status_id = '30'
					OR rv_reservation.rf_reservation_status_id = '20'
				)
		",1);
    if($dayRoomArray[$dateItem][$dayRoomKey]['arrive']['groupId'] != ""){
	    $dayRoomArray[$dateItem][$dayRoomKey]['arrive']['guestList'] = getGuestNames($dayRoomArray[$dateItem][$dayRoomKey]['arrive']['groupId']);
    }  
		if (isset($dayRoomTotalArray[$dateItem]['arriveAdult'])) {
			$dayRoomTotalArray[$dateItem]['arriveAdult'] += $dayRoomArray[$dateItem][$dayRoomKey]['arrive']['rv_item_adult_count']; 
		} else {
			$dayRoomTotalArray[$dateItem]['arriveAdult'] = $dayRoomArray[$dateItem][$dayRoomKey]['arrive']['rv_item_adult_count']; 
		}
		if (isset($dayRoomTotalArray[$dateItem]['arriveChild'])) {
			$dayRoomTotalArray[$dateItem]['arriveChild'] += $dayRoomArray[$dateItem][$dayRoomKey]['arrive']['rv_item_child_count'];     
		} else {
			$dayRoomTotalArray[$dateItem]['arriveChild'] = $dayRoomArray[$dateItem][$dayRoomKey]['arrive']['rv_item_child_count'];     
		}
    
		$dayRoomArray[$dateItem][$dayRoomKey]['stayover'] = $lDB->get("
			$dayRoomSql
			WHERE
				rv_res_item_group.ac_accomm_room_id = '$dayRoomItem[ac_accomm_room_ix]'
				AND rv_reservation_item.rv_item_date_arrive < '$dateItem'
				AND rv_reservation_item.rv_item_date_depart > '$dateItem'
				AND (
					rv_reservation.rf_reservation_status_id = '30'
					OR rv_reservation.rf_reservation_status_id = '20'
				)
		",1);

    if($dayRoomArray[$dateItem][$dayRoomKey]['stayover']['groupId'] != ""){
	    $dayRoomArray[$dateItem][$dayRoomKey]['stayover']['guestList'] = getGuestNames($dayRoomArray[$dateItem][$dayRoomKey]['stayover']['groupId']);
    }      
    
		if (isset($dayRoomTotalArray[$dateItem]['stayoverAdult'])) {
			$dayRoomTotalArray[$dateItem]['stayoverAdult'] += $dayRoomArray[$dateItem][$dayRoomKey]['stayover']['rv_item_adult_count']; 
		} else {
			$dayRoomTotalArray[$dateItem]['stayoverAdult'] = $dayRoomArray[$dateItem][$dayRoomKey]['stayover']['rv_item_adult_count']; 
		}
		if (isset($dayRoomTotalArray[$dateItem]['stayoverChild'])) {
			$dayRoomTotalArray[$dateItem]['stayoverChild'] += $dayRoomArray[$dateItem][$dayRoomKey]['stayover']['rv_item_child_count'];    		
		} else {
			$dayRoomTotalArray[$dateItem]['stayoverChild'] = $dayRoomArray[$dateItem][$dayRoomKey]['stayover']['rv_item_child_count'];    		
		}

    $dayRoomArray[$dateItem][$dayRoomKey]['depart'] = $lDB->get("
			$dayRoomSql
			WHERE
				rv_res_item_group.ac_accomm_room_id = '$dayRoomItem[ac_accomm_room_ix]'
				AND rv_reservation_item.rv_item_date_depart = '$dateItem'
				AND (
					rv_reservation.rf_reservation_status_id = '30'
					OR rv_reservation.rf_reservation_status_id = '20'
				)
		",1);
    
    if($dayRoomArray[$dateItem][$dayRoomKey]['depart']['groupId'] != ""){
	    $dayRoomArray[$dateItem][$dayRoomKey]['depart']['guestList'] = getGuestNames($dayRoomArray[$dateItem][$dayRoomKey]['depart']['groupId']);
    }
		if (isset($dayRoomTotalArray[$dateItem]['departAdult'])) {
			$dayRoomTotalArray[$dateItem]['departAdult'] += $dayRoomArray[$dateItem][$dayRoomKey]['depart']['rv_item_adult_count']; 
		} else {
			$dayRoomTotalArray[$dateItem]['departAdult'] = $dayRoomArray[$dateItem][$dayRoomKey]['depart']['rv_item_adult_count']; 
		}
		if (isset($dayRoomTotalArray[$dateItem]['departChild'])) {
			$dayRoomTotalArray[$dateItem]['departChild'] += $dayRoomArray[$dateItem][$dayRoomKey]['depart']['rv_item_child_count']; 
		} else {
			$dayRoomTotalArray[$dateItem]['departChild'] = $dayRoomArray[$dateItem][$dayRoomKey]['depart']['rv_item_child_count']; 
		}
	}
}

$dayRequestArray = array();
foreach($dateArray as $dateItem) {
	$dayRequestArray[$dateItem] = $lDB->get("
		SELECT 
			rv_reservation.rv_reservation_ix as reqResNum,
			rv_reservation.rv_res_name as reqResName,
			rv_reservation.rv_agent_ref as reqAgentRef,
			rv_reservation_item.rv_reservation_item_ix as reqResItemId,
			rv_reservation_item.rv_item_date_arrive as reqArrive,
			rv_reservation_item.rv_item_date_depart as reqDepart,
			ac_accomm_type.ac_accomm_desc as reqAccomm,      
			rv_reservation_item.rv_item_accomm_count as reqTotRooms,
			rv_reservation.rf_reservation_status_id as reqStatId,
			rv_reservation.rv_provision_expiry_date as reqProvExpDt
		FROM 
			rv_reservation_item
			INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
		WHERE 
			rv_reservation_item.pr_business_id = '$propertyId'
      AND rv_reservation_item.ac_accomm_type_id IN ('".join("','",$accommList)."')
			AND rv_res_item_comp.rv_item_comp_option_yn = '1'    	
			AND rv_reservation.rv_consultant_id != '0'
			AND rv_reservation.rv_consultant_id IS NOT NULL
			AND rv_reservation.rv_consultant_id != ''
			AND (rv_reservation.rf_reservation_status_id = '30' OR rv_reservation.rf_reservation_status_id = '20')
			AND (rv_reservation_item.rv_item_date_arrive <= '$dateItem' AND rv_reservation_item.rv_item_date_depart >= '$dateItem')
		GROUP BY rv_res_item_comp.rv_reservation_item_id 
		ORDER BY rv_reservation_item.rv_item_date_arrive, rv_reservation_item.rv_item_date_depart         	 
	",2);
	foreach($dayRequestArray[$dateItem] as $dayRequestKey=>$dayRequestItem) {
		$reqRmList = $lDB->get("
			SELECT 
				ac_accomm_room.ac_desc
			FROM 
				rv_res_item_group
				INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
			WHERE 
				rv_res_item_group.rv_reservation_item_id = '$dayRequestItem[reqResItemId]'  
		",3);
		if(sizeof($reqRmList) > 0){
			$dayRequestArray[$dateItem][$dayRequestKey]['reqRooms'] = join(", ",$reqRmList);
		}else{
			$dayRequestArray[$dateItem][$dayRequestKey]['reqRooms'] = "";
		}
  		
		$reqCompList = $lDB->get("
			SELECT 
				rt_component.rt_component_abbrv as reqComps
			FROM 
				rv_res_item_comp           
				INNER JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
			WHERE
				rv_res_item_comp.rv_reservation_item_id = '$dayRequestItem[reqResItemId]'
				AND rv_res_item_comp.rv_item_comp_option_yn = '1'
		",3);
    
		if(sizeof($reqCompList) > 0){
			$dayRequestArray[$dateItem][$dayRequestKey]['reqComps'] = join(", ",$reqCompList);
		}else{
			$dayRequestArray[$dateItem][$dayRequestKey]['reqComps'] = "";
		}
	}
}

$dayExtraSummaryArray = array();
$dayExtraDetailArray = array();
foreach($dateArray as $dateItem) {
	$extraIds = $lDB->get("
		SELECT DISTINCT
			rv_extra.rv_extra_ix
		FROM
			rv_extra
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_extra.rv_reservation_id
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_extra.rv_reservation_id
		WHERE
			(
				rv_extra.pr_business_id = '$propertyId'
				/*OR rv_extra.pr_business_id = '0'*/
			) AND (
				rv_extra.rv_extra_date_serv = '$dateItem'
				OR (
					rv_extra.rv_extra_date_serv = '0000-00-00'
					AND rv_reservation.rv_date_arrive <= '$dateItem'
					AND rv_reservation.rv_date_depart >= '$dateItem'					
				)					
			) AND (
				rv_reservation.rf_reservation_status_id = '30'
				OR rv_reservation.rf_reservation_status_id = '20'
			)
			AND rv_extra.rv_extra_void_ind = 0
	",3);
  
  $dayExtraSummaryArray[$dateItem] = $lDB->get("
		SELECT
			ac_extra.ac_ext_desc,
			ac_extra_category.ac_extra_cat_desc,
			SUM(rv_extra.rv_extra_units) as rv_extra_units
		FROM
			rv_extra
			INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
			INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
		WHERE
			rv_extra.rv_extra_ix IN ('".join("','",$extraIds)."')      
			AND rv_extra.rv_extra_void_ind = 0
		GROUP BY
			rv_extra.ac_extra_id
	",2);
	$dayExtraDetailArray[$dateItem] = $lDB->get("
		SELECT
			ac_extra.ac_ext_desc,
			ac_extra_category.ac_extra_cat_desc,
			ac_extra_category.ac_extra_cat_ind,
			rv_extra.rv_extra_units,
			rv_extra.rv_extra_travel_eta,
			rv_extra.rv_extra_travel_etd,
			rv_extra.rv_extra_supplier_conf_yn,
			rv_extra.pr_supplier_id,
			rv_extra.rv_extra_ref,
			CONCAT_WS(' ',pr_extra_supplier.pr_name_first,pr_extra_supplier.pr_name_last) AS supplier_name,
			rv_extra.rv_extra_date_serv,
			rv_extra.rv_extra_note,
			rv_extra.rv_extra_note_internal,
			rv_reservation.rv_reservation_ix,
			rv_reservation.rv_res_name,
			rv_reservation.rf_reservation_status_id,
			rv_reservation.rv_provision_expiry_date,
			ac_accomm_room.ac_desc
		FROM
			rv_extra
			INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
			INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_extra.rv_reservation_id
			LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_extra.rv_res_item_group_id
			LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
			LEFT JOIN pr_persona AS pr_extra_supplier ON pr_extra_supplier.pr_persona_ix = rv_extra.pr_supplier_id
		WHERE
			rv_extra.rv_extra_ix IN ('".join("','",$extraIds)."')
			AND rv_extra.rv_extra_void_ind = 0
    ORDER BY rv_extra.rv_extra_date_serv, ac_extra_category.ac_extra_cat_desc, ac_extra.ac_ext_desc
	",2);  
}

// Extras on Summary Report ---------------------------------------------------
// NOTE: uses same html file as on the day sheet ------------------------------
$extrasSummRows = "";
$extrasSummHTML = join("",file(__DIR__ . "/../../../public/html/room_rep_extra_drows.htm"));
$eArray = array();


foreach($dayExtraDetailArray as $extras){
  if(sizeof($extras) > 0){
    foreach($extras as $eItem){
		  array_push($eArray,$eItem);
    }
  }
}  
$lastDate = "";
$lastCat = "";
foreach($eArray as $extrasSumm){
	if($lastDate == $extrasSumm['rv_extra_date_serv']){
	  $extrasSumm['servDate'] = "&nbsp;";
  }else{
    $extrasSumm['servDate'] = chng_date($extrasSumm['rv_extra_date_serv'],"-");
  }
  $extrasSumm['travInd'] = "&nbsp;";
  if($extrasSumm['ac_extra_cat_ind'] == 2){
    $extrasSumm['travInd'] = "<img src=\"/resource/Resrequest/Application/public/img/button_travel.gif\">";
  }	
  if($lastCat == $extrasSumm['ac_extra_cat_desc']){
  	$extrasSumm['catDesc'] = "&nbsp;";
  }else{
	  $extrasSumm['catDesc'] = $extrasSumm['ac_extra_cat_desc'];
  }  
	$extrasSumm['extraDesc'] = $extrasSumm['ac_ext_desc'];

	if(trim($extrasSumm['rv_extra_travel_eta']) != "") {
		$extrasSumm['rv_extra_travel_eta'] = $extrasSumm['rv_extra_travel_eta'];
	} else {
		$extrasSumm['rv_extra_travel_eta'] = "&nbsp;";
	}
	if(trim($extrasSumm['rv_extra_travel_etd']) != "") {
		$extrasSumm['rv_extra_travel_etd'] = $extrasSumm['rv_extra_travel_etd'];
	} else {
		$extrasSumm['rv_extra_travel_etd'] = "&nbsp;";
	}
  
  $extrasSumm['resNum'] = $extrasSumm['rv_reservation_ix'];
  $extrasSumm['resName'] = $extrasSumm['rv_res_name'];
  $extrasSumm['numUnits'] = $extrasSumm['rv_extra_units'];
  $extrasSumm['roomDesc'] = $extrasSumm['ac_desc'];
	
  $extrasSumm['extraSummNote'] = "&nbsp;";
  if(trim($extrasSumm['rv_extra_note']) != ""){
	  $extrasSumm['extraSummNote'] = "x";
  }
  $extrasSumm['extraSummIntNote'] = "&nbsp;";  
  if(trim($extrasSumm['rv_extra_note_internal']) != ""){
  	$extrasSumm['extraSummIntNote'] = "x";
  }
  $extrasSumm['provColor'] = "#FFFFFF";  			
  if($extrasSumm['rf_reservation_status_id'] == "20") {
		if($extrasSumm['rv_provision_expiry_date'] == date("Y-m-d")) {
			$extrasSumm['provColor'] = "#F1C55D";
		}
		if($extrasSumm['rv_provision_expiry_date'] < date("Y-m-d")) {
		$extrasSumm['provColor'] = "#DB4242";
		}
	}  
            
  $extrasSummRows .= showpage($extrasSumm,$extrasSummHTML);
  $lastDate = $extrasSumm['rv_extra_date_serv'];
  $lastCat = $extrasSumm['ac_extra_cat_desc'];
}

$GLOBALS['temp']['extrasSummRows'] = $extrasSummRows;
if($extrasSummRows == ""){
 $GLOBALS['temp']['extrasSummRows'] = "<tr><td colspan=\"6\" align=\"center\">No extras</td></tr>";
}  

// [START] Notes
$resIds = $lDB->get("
		SELECT
			DISTINCT rv_reservation.rv_reservation_ix as resId,
      rv_reservation.rv_res_name as resName,
      rv_reservation.rf_country_id,
      rv_reservation.rv_agent_id
		FROM
			rv_reservation_item
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
		WHERE
      rv_reservation_item.pr_business_id = '$propertyId'          	
      AND (
         (rv_reservation.rv_date_arrive >= '".$fromDate['jsDate']."' AND rv_reservation.rv_date_arrive <= '".$toDate['jsDate']."')
         OR
         (rv_reservation.rv_date_depart >= '".$fromDate['jsDate']."' AND rv_reservation.rv_date_depart <= '".$toDate['jsDate']."')
         OR
         (rv_reservation.rv_date_arrive < '".$fromDate['jsDate']."' AND rv_reservation.rv_date_depart > '".$toDate['jsDate']."')
      )    
			AND (
				rv_reservation.rf_reservation_status_id = '30'
				OR rv_reservation.rf_reservation_status_id = '20'
			)
	",2);

foreach($resIds as $resKey=>$resItem) {
	$resIds[$resKey]['roomArray'] = $lDB->get("
		SELECT
			ac_accomm_room.ac_desc
		FROM
			rv_reservation
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
			INNER JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
			INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		WHERE
			rv_reservation.rv_reservation_ix = '$resItem[resId]'
			AND rv_reservation_item.pr_business_id = '$propertyId'          	
			AND (
				(rv_reservation_item.rv_item_date_arrive >= '".$fromDate['jsDate']."' AND rv_reservation_item.rv_item_date_arrive <= '".$toDate['jsDate']."')
				OR
				(rv_reservation_item.rv_item_date_depart >= '".$fromDate['jsDate']."' AND rv_reservation_item.rv_item_date_depart <= '".$toDate['jsDate']."')
				OR
				(rv_reservation_item.rv_item_date_arrive < '".$fromDate['jsDate']."' AND rv_reservation_item.rv_item_date_depart > '".$toDate['jsDate']."')
			) AND (
				rv_reservation.rf_reservation_status_id = '30'
				OR rv_reservation.rf_reservation_status_id = '20'
			)
	",3);
}

$GLOBALS['temp']['internalNoteToggle'] = "collapse printCollapse";  
$noteHTML = Join("", file(__DIR__ . "/../../../public/html/room_rep_notes_rows.htm"));
$extraHTML = Join("", file(__DIR__ . "/../../../public/html/room_rep_enotes_rows.htm"));
$travelHTML = Join("", file(__DIR__ . "/../../../public/html/room_rep_tnotes_rows.htm"));
$noterows = "";
$extrasrows = "";
$travelrows = "";
$lastProp = "";
$travCheck = 0;
$extCheck = 0;

foreach($resIds as $resNoteItem){
	$noteItem = array();
  $extraItem = array();	    
	$travelItem = array();
	
  $note = t_decodeHTML(getReservationNote($resNoteItem['resId']));
	$guest = t_decodeHTML(getReservationGuestInfo($resNoteItem['resId']));
  $nationality = getGuestNationality($resNoteItem['rf_country_id']);  
  $rooming = getReservationRooming($resNoteItem['resId']);
  if($userStatusId > 1) {
	  $GLOBALS['temp']['internalNoteToggle'] = "";
    $resInt = t_decodeHTML(getReservationMemo($resNoteItem['resId']));    
  }  	
  $extNoteArray = getExtraNotes($resNoteItem['resId'],0,2,$fromDate,$toDate,$propertyId);  
  $travNoteArray = getExtraNotes($resNoteItem['resId'],1,2,$fromDate,$toDate,$propertyId);
  if($note != "FALSE" || $guest != "" || $nationality != "" || sizeof($rooming['notes']) > 0 || $resInt != "" || $resNoteItem['rv_agent_id'] != ""){
		if($lastProp != ""){
			if (isset($noteItem['resDetails'])) {
				$noteItem['resDetails'] .= "<tr><td colspan=\"2\" height=\"1\" class=\"bt\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td></tr>";
			} else {
				$noteItem['resDetails'] = "<tr><td colspan=\"2\" height=\"1\" class=\"bt\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td></tr>";
			}
    }  
    if (isset($noteItem['resDetails'])) {
		$noteItem['resDetails'] .= "<tr><td class=\"txtbbr\" colspan=\"2\">$resNoteItem[resId]: ".t_encodeHTML($resNoteItem['resName'])."</td></tr>";
    } else {
    	$noteItem['resDetails'] = "<tr><td class=\"txtbbr\" colspan=\"2\">$resNoteItem[resId]: ".t_encodeHTML($resNoteItem['resName'])."</td></tr>";
    }
    $lastProp = $resNoteItem['resId'];
  }else{
    $noteItem['resDetails'] = "";
  }  
  if(sizeof($extNoteArray) > 0){
    if(isset($lastRes) && $lastRes != ""){
		  if (isset($extraItem['resDetails'])) {
		  	$extraItem['resDetails'] .= "<tr><td colspan=\"2\" height=\"1\" class=\"bt\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td></tr>";
		  } else {
		  	$extraItem['resDetails'] = "<tr><td colspan=\"2\" height=\"1\" class=\"bt\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td></tr>";
		  }
    }
    if (isset($extraItem['resDetails'])) {
    	$extraItem['resDetails'] .= "<tr><td class=\"txtbbr\" colspan=\"2\">$resNoteItem[resId]: $resNoteItem[resName]</td></tr>";
    } else {
    	$extraItem['resDetails'] = "<tr><td class=\"txtbbr\" colspan=\"2\">$resNoteItem[resId]: $resNoteItem[resName]</td></tr>";
    }
    $lastRes = $resNoteItem['resId'];
  }else{    
	  $extraItem['resDetails'] = "";
  }
  if(sizeof($travNoteArray) > 0){
    if(isset($lastRes) && $lastRes != ""){
    	if (isset($travelItem['resDetails'])) {
    		$travelItem['resDetails'] .= "<tr><td colspan=\"2\" height=\"1\" class=\"bt\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td></tr>";      
    	} else {
    		$travelItem['resDetails'] = "<tr><td colspan=\"2\" height=\"1\" class=\"bt\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td></tr>";      
    	}
    }
		if (isset($travelItem['resDetails'])) {
			$travelItem['resDetails'] .= "<tr><td class=\"txtbbr\" colspan=\"2\">$resNoteItem[resId]: $resNoteItem[resName]</td></tr>";      
		} else {
			$travelItem['resDetails'] = "<tr><td class=\"txtbbr\" colspan=\"2\">$resNoteItem[resId]: $resNoteItem[resName]</td></tr>";      
		}
		
    $lastRes = $resNoteItem['resId']; 
  }else{
    $travelItem['resDetails'] = "";
  }      
  $noteItem['roomList'] = "";
  if(sizeof($resNoteItem['roomArray']) > 0) {
	  $noteItem['roomList'] = "<tr valign=\"top\" id=\"roomListArea\"><td class=\"txtbr\" width=\"75\">Rooms / Units:</td><td>".join(", ",$resNoteItem['roomArray'])."</td></tr>";
  }

  // res note
  if($note != "FALSE"){
  	$noteItem['resNote'] = "<tr valign=\"top\" id=\"resNoteArea\"><td class=\"txtbr\" width=\"75\">Res note:</td><td>".t_encodeHTML($note)."</td></tr>";    
	  $GLOBALS['temp']['noResNotes'] = "expand";
  }else{
    $noteItem['resNote'] = "";
  }     
	// agent
  $agentName = agentName($resNoteItem['rv_agent_id']);
  if($agentName != "0"){
	  $noteItem['agentName'] = "<tr valign=\"top\" id=\"agentArea\"><td class=\"txtbr\" width=\"75\">Agent:</td><td>$agentName</td></tr>";
  } else{
    $noteItem['agentName'] = "";
  }
  // Rate Type
  $rateType = $lDB->get("
		SELECT 
    	rt_rate_type.rt_rate_type_desc as rateType 
    FROM 
			rv_reservation
    INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id
		WHERE
      rv_reservation.rv_reservation_ix = '$resNoteItem[resId]';
	",4); 
  if($rateType != ""){
	  $noteItem['rateType'] = "<tr valign=\"top\" id=\"rateTypeArea\"><td class=\"txtbr\" width=\"75\">Rate Type:</td><td>$rateType</td></tr>";
  }else{
    $noteItem['rateType'] = "";
  } 
  // Nationality
  if($nationality != ""){
	  $noteItem['nationality'] = "<tr valign=\"top\" id=\"nationArea\"><td class=\"txtbr\" width=\"75\">Nationality:</td><td>$nationality</td></tr>";
    $GLOBALS['temp']['noGuestNationality'] = "expand";
  }else{
    $noteItem['nationality'] = "";
  }
  // guest info
  if($guest != ""){
	  $noteItem['guestInfo'] = "<tr valign=\"top\" id=\"guestArea\"><td class=\"txtbr\" width=\"75\">Guest info:</td><td>".t_encodeHTML($guest)."</td></tr><tr>";
    $GLOBALS['temp']['noGuest'] = "expand";
  }else{
    $noteItem['guestInfo'] = "";
  }
  // Rooming - guest notes and memos  
  if(sizeof($rooming['notes']) > 0){  
    $guestLabel = "";
    foreach($rooming['notes'] as $guestn){
      if($guestLabel == ""){$gLabel = "Guest notes:";}else{$gLabel = "";}    
	  	if(!isset($noteItem['guestNote'])) {
			$noteItem['guestNote'] = "";
		}
    	$noteItem['guestNote'] .= "<tr id=\"guestNoteArea\"><td class=\"txtbr\" width=\"75\">$gLabel</td><td>$guestn[name]: ".t_encodeHTML($guestn['note'])."</td></tr>";
      $guestLabel = $gLabel;      
    }
    $GLOBALS['temp']['noGuestNotes'] = "expand";    
  }else{
    $noteItem['guestNote'] = "";
  }
  if(sizeof($rooming['memos']) > 0){
    $memoLabel = "";
    foreach($rooming['memos'] as $guestm){
      if($memoLabel == ""){$mLabel = "Guest Memos:";}else{$mLabel = "";}
	  if(!isset($noteItem['guestMemo'])) {
		  $noteItem['guestMemo'] = "";
		}
      $noteItem['guestMemo'] .= "<tr id=\"guestMemoArea\"><td class=\"txtbr\" width=\"75\">$mLabel</td><td>$guestm[name]: ".t_encodeHTML($guestm['note'])."</td></tr>";
      $memoLabel = $mLabel;
    }
    $GLOBALS['temp']['noGuestMemo'] = "expand";
  }else{
    $noteItem['guestMemo'] = "";
  }
  if($userStatusId > 1) {
		// res internal
    if($resInt != ""){
  	  $noteItem['resIntNote'] = "<tr valign=\"top\" id=\"internalArea\"><td class=\"txtbr\" width=\"75\">Res Memo:</td><td>".t_encodeHTML($resInt)."</td></tr>";
      $GLOBALS['temp']['noResInt'] = "expand";
    }else{
    	$noteItem['resIntNote'] = "";
    }
  }
  if(sizeof($extNoteArray) > 0){
    if (isset($extraItem['extraNote'])) {
    	$extraItem['extraNote'] .= "<tr valign=\"top\"><td colspan=\"2\"><table width=\"100%\" cellspacing=\"0\" cellpadding=\"1\">";
    } else {
    	$extraItem['extraNote'] = "<tr valign=\"top\"><td colspan=\"2\"><table width=\"100%\" cellspacing=\"0\" cellpadding=\"1\">";
    }
    foreach($extNoteArray as $extra){
    	$noExtNote = "display:visible;";
        $noExtIntNote = "display:visible;";
		$noExtService = "display:visible;";
		$noExtReference = "display:visible;";
      if(trim($extra['note']) == ""){$noExtNote = "display:none;";}
      if(trim($extra['intNote']) == ""){$noExtIntNote = "display:none;";}  
	  if(trim($extra['supplier_name']) == ""){$noExtService = "display:none;";}
	  if(trim($extra['rv_extra_ref']) == ""){$noExtReference = "display:none;";}
    	$serviceDate = chng_date($extra['serviceDate'],"-");
      
  	  $extraItem['extraNote'] .= "<tr valign=\"top\"><td width=\"75\" class=\"txtbr\">Description:</td><td>$serviceDate: $extra[description]</td></tr>
	   <tr id=\"extraServiceArea\" style=\"$noExtService\" valign=\"top\"><td class=\"txtbr\">Service By: </td><td>".t_encodeHTML($extra['supplier_name'])."</td></tr>
      <tr id=\"extraReferenceArea\" style=\"$noExtReference\" valign=\"top\"><td class=\"txtbr\">Reference: </td><td>".t_encodeHTML($extra['rv_extra_ref'])."</td></tr>
      <tr id=\"extraNoteArea\" style=\"$noExtNote\" valign=\"top\"><td class=\"txtbr\">Note: </td><td>".t_encodeHTML($extra['note'])."</td></tr>
      <tr id=\"extraIntArea\" style=\"$noExtIntNote\" valign=\"top\"><td class=\"txtbr\">Internal Memo: </td><td>".t_encodeHTML($extra['intNote'])."</td></tr>
      <tr><td colspan=\"2\" height=\"5\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td></tr>";
      $serviceDate = "";    
    }
		$extraItem['extraNote'] .= "</table></td></tr>";    
    $GLOBALS['temp']['noExtraNotes'] = "expand";
    $extCheck ++;
  }else{
    $extraItem['extraNote'] = "";
  }
  // travel note  
  if(sizeof($travNoteArray) > 0){    
    if (isset($travelItem['travelNote'])) {
    	$travelItem['travelNote'] .= "<tr valign=\"top\"><td colspan=\"2\"><table width=\"100%\" cellspacing=\"0\" cellpadding=\"1\">";
    } else {
    	$travelItem['travelNote'] = "<tr valign=\"top\"><td colspan=\"2\"><table width=\"100%\" cellspacing=\"0\" cellpadding=\"1\">";
    }
    
    foreach($travNoteArray as $trav){
    	$noTravNote = "display:visible;";
        $noTravIntNote = "display:visible;";
		$noTravService = "display:visible;";
		$noTravReference = "display:visible;";
      if(trim($trav['note']) == ""){$noTravNote = "display:none;";}
      if(trim($trav['intNote']) == ""){$noTravIntNote = "display:none;";}
	  if(trim($trav['supplier_name']) == ""){$noTravService = "display:none;";}
	  if(trim($trav['rv_extra_ref']) == ""){$noTravReference = "display:none;";}
          
    	$serviceDate = chng_date($trav['serviceDate'],"-");
  	  $travelItem['travelNote'] .= "<tr valign=\"top\"><td width=\"75\" class=\"txtbr\">Description:</td><td>$serviceDate: $trav[description]</td></tr>
	  <tr id=\"travelServiceArea\" style=\"$noTravService\" valign=\"top\"><td class=\"txtbr\">Service By: </td><td>".t_encodeHTML($trav['supplier_name'])."</td></tr>
      <tr id=\"travelReferenceArea\" style=\"$noTravReference\" valign=\"top\"><td class=\"txtbr\">Reference: </td><td>".t_encodeHTML($trav['rv_extra_ref'])."</td></tr>
      <tr id=\"travelNoteArea\" style=\"$noTravNote\" valign=\"top\"><td class=\"txtbr\">Note: </td><td>".t_encodeHTML($trav['note'])."</td></tr>
      <tr id=\"travelIntArea\" style=\"$noTravIntNote\" valign=\"top\"><td class=\"txtbr\">Internal Memo: </td><td>".t_encodeHTML($trav['intNote'])."</td></tr>
      <tr><td colspan=\"2\" height=\"5\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td></tr>";
      $serviceDate = "";    
    }
		$travelItem['travelNote'] .= "</table></td></tr>";    
    $GLOBALS['temp']['noTravelNotes'] = "expand";
    $travCheck ++;    
  }else{
    $travelItem['travelNote'] = "";    
  }  
	
  $noterows .= showpage($noteItem,$noteHTML);
  $extrasrows .= showpage($extraItem,$extraHTML);
  $travelrows .= showpage($travelItem,$travelHTML);
}  
$GLOBALS['temp']['noterows'] = $noterows;
$GLOBALS['temp']['extrasrows'] = $extrasrows;
$GLOBALS['temp']['travelrows'] = $travelrows;

if($noterows == ""){
	$GLOBALS['temp']['noterows'] = "<tr><td align=\"center\">No reservation notes</td></tr>";
}  

if($extCheck == 0 ){
	//$GLOBALS['temp']['extrasrows'] = "<tr><td align=\"center\">No extras notes</td></tr>";
  $GLOBALS['temp']['noExtraNotes'] = "collapse printCollapse";  
}
if($travCheck == 0){
	$GLOBALS['temp']['noTravelNotes'] = "collapse printCollapse";    
}  

// Rooming calendar code -- START
$userProperty = $lDB->get("
	SELECT
		pr_link_to
	FROM
		pr_link
	WHERE
		pr_link_from = '$GLOBALS[userid]'
		AND pr_link.rf_link_type_id = 'RS1'
",4);

$accommList = $lDB->get("
	SELECT
		sc_accomm.ac_accomm_type_id
	FROM
		sc_accomm
		INNER JOIN sc_user ON sc_accomm.sc_group_id = sc_user.sc_group_id
			AND sc_user.pr_user_id = '".$GLOBALS['userid']."'
",3);
$accommWhere = " IN ('".join("','",$accommList)."') ";

$headerRowHTML = '
	<td class="!headerClass! bt bb br" style="width: 168px; height: 45px;">
		<table border="0" cellpadding="2" cellspacing="0" summary="" style="width: 168px;">
			<tr valign="top">
				<td align="center"><strong>&nbsp;!weekDay!, !dateFormat!<span id="pax" style="cursor: default;" onmouseover="this.className=\'txtbr\'; overlib(\'PAX: !adultCount! Adults, !childCount! Child <br />(Confirmed &amp; Provisional reservations)\',WIDTH,180,ABOVE,OFFSETY,5,LEFT);" onmouseout="this.className=\'txt\'; nd();">&nbsp;(!adultCount!A,!childCount!C)</span></strong></td>
			</tr>
		</table>
	</td>
';

// START - Security checks
$propertyDB = $lDB->get("
	SELECT
		rf_db_code
	FROM
		rf_db_business
	WHERE
		pr_business_id = '$propertyId'
",4);

$GLOBALS['temp']['allowCheckIn'] = "true";
$GLOBALS['temp']['allowCheckOut'] = "true";
$GLOBALS['temp']['allowRoomFunctions'] = "true";

$roomingCalendarAccess = isset($GLOBALS['jobLevelArray'][234])?$GLOBALS['jobLevelArray'][234]:0;
if ( $propertyDB != $GLOBALS['dbcode'] || $roomingCalendarAccess < 10 ) {
	$GLOBALS['temp']['allowCheckIn'] = "false";	
	$GLOBALS['temp']['allowCheckOut'] = "false";	
}

if ($roomingCalendarAccess < 10 ) {
	$GLOBALS['temp']['allowRoomFunctions'] = "false";
}
// END - Security checks

// START - Generate date range
$startDate = strtotime($fromDate['jsDate']);
$dateCount = dateSubtract($toDate['jsDate'],$fromDate['jsDate'])+1;
$dateList = array();
for($count = 0; $count < $dateCount; $count++) {
	$currDate = $startDate + ( 86400 * $count );
	$weekDay = date("D",$currDate);
	$dateRaw = date("Y-m-d",$currDate);
	$dateFormat = date("d M y",$currDate);
	$paxLookup = $lDB->get("
   		SELECT
			SUM(rv_reservation_item.rv_item_adult_count * rv_reservation_item.rv_item_accomm_count) as adultCount,
			SUM(rv_reservation_item.rv_item_child_count * rv_reservation_item.rv_item_accomm_count) as childCount
		FROM
			rv_reservation_item
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
		WHERE
			rv_reservation_item.pr_business_id = '$propertyId'
			AND rv_reservation_item.ac_accomm_type_id $accommWhere
			AND rv_reservation_item.rv_item_date_arrive <= '$dateRaw'
			AND rv_reservation_item.rv_item_date_depart > '$dateRaw'
			AND (
				rv_reservation.rf_reservation_status_id = '30'
				OR (
					rv_reservation.rf_reservation_status_id = '20'
					AND rv_reservation.rv_provision_expiry_date <= '".date("Y-m-d")."'
				)
			)
			
	",1);
	if($paxLookup['adultCount'] == "") {
		$paxLookup['adultCount'] = "0";
	}
	if($paxLookup['childCount'] == "") {
		$paxLookup['childCount'] = "0";
	}
	array_push($dateList,array('dateRaw'=>$dateRaw, 'dateFormat'=>$dateFormat, 'weekDay'=>$weekDay, 'adultCount'=>$paxLookup['adultCount'], 'childCount'=>$paxLookup['childCount']));
}

$headerRow ="";
foreach($dateList as $dateItem) {
	if($dateItem['weekDay'] == "Sun" || $dateItem['weekDay'] == "Sat") {
		$dateItem['headerClass'] = "colDk";
	} else {
		$dateItem['headerClass'] = "colLt";
	}
	$headerRow .= showpage($dateItem,$headerRowHTML);
}
$GLOBALS['temp']['headerRow'] = $headerRow;
// END - Generate date range

// START - Generate room list
$roomList = $lDB->get("
	SELECT
		ac_accomm_room.ac_desc,
		ac_accomm_type.ac_accomm_desc,
		ac_accomm_room.ac_accomm_room_ix
	FROM
		ac_accomm_room
		INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
	WHERE
		ac_accomm_type.pr_business_id = '$propertyId'
		AND ac_accomm_type.ac_accomm_type_ix $accommWhere
		AND ac_accomm_room.ac_accomm_room_inactive_yn = '0'
	ORDER BY
		ac_accomm_type.ac_accomm_desc,
		(ac_desc+0),ac_desc
",2);

// END - Generate room list
/*
$roomingData = array();
foreach ( $roomList as $roomItem ) {
	$roomingItems = array();
	foreach ( $dateList as $dateKey => $dateItem ) {
		// Get any arrivals
		$arrival = $lDB->get("
			SELECT
				rv_reservation.rv_reservation_ix,
				rv_reservation.rv_res_name,
				rv_reservation.rf_reservation_status_id,
				rv_reservation.rv_provision_expiry_date,
				rv_reservation.rv_date_changed,
				rv_reservation_item.rv_item_adult_count,
				rv_reservation_item.rv_item_child_count,
				rv_res_item_group.ac_accomm_room_id,
				rv_res_item_group.rv_grp_status_ind,
				rv_res_item_group.rv_room_requested_yn,
				rv_res_item_group.rv_room_request_reason,
				rv_reservation_item.rv_item_date_arrive,
				rv_reservation_item.rv_item_date_depart,
				rv_reservation_item.rv_reservation_item_ix,
				rv_res_item_group.rv_res_item_group_ix as rv_res_item_group_id,
				rv_res_item_group.rv_grp_status_time,
				rv_res_item_group.rv_grp_accomm_overide_yn,
				rv_res_item_group.rv_grp_date_allocated
			FROM
				rv_res_item_group
			INNER JOIN rv_reservation_item ON 
				rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			INNER JOIN rv_reservation ON 
				rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			WHERE
				rv_res_item_group.ac_accomm_room_id = '" . $roomItem['ac_accomm_room_ix'] . "' 
			AND 
				rv_reservation_item.rv_item_date_arrive = '" . $dateItem['dateRaw'] . "'
		",2);

		foreach ( $arrival as $aKey => $aItem ) {
			$check = $lDB->get("
				SELECT
					COUNT(*)
				FROM
					rv_reservation_item
				WHERE
					rv_reservation_item.rv_reservation_id = '$aItem[rv_reservation_ix]'
					AND rv_reservation_item.rv_item_date_depart = '$aItem[rv_item_date_arrive]'
			",4);
			if($check > 0) {
				$arrival[$aKey]['hasDepart'] = true;
			} else {
				$arrival[$aKey]['hasDepart'] = false;
			}
			$canCheckIn = $lDB->get("
				SELECT
					COUNT(*)
				FROM
					rv_res_item_group
				WHERE
					rv_res_item_group.rv_res_item_group_ix != '$aItem[rv_res_item_group_id]'
					AND rv_res_item_group.ac_accomm_room_id = '$aItem[ac_accomm_room_id]'
					AND rv_res_item_group.rv_grp_status_ind = '5'
			",4);
			if($canCheckIn > 0) {
				$arrival[$aKey]['canCheckIn'] = false;
			} else {
				$arrival[$aKey]['canCheckIn'] = true;
			}
		}

		$departure = $lDB->get("
			SELECT
				rv_reservation.rv_reservation_ix,
				rv_reservation.rv_res_name,
				rv_reservation.rf_reservation_status_id,
				rv_reservation.rv_provision_expiry_date,
				rv_reservation.rv_date_changed,
				rv_reservation_item.rv_item_adult_count,
				rv_reservation_item.rv_item_child_count,
				rv_res_item_group.ac_accomm_room_id,
				rv_res_item_group.rv_grp_status_ind,
				rv_res_item_group.rv_room_requested_yn,
				rv_res_item_group.rv_room_request_reason,
				rv_reservation_item.rv_item_date_arrive,
				rv_reservation_item.rv_item_date_depart,
				rv_reservation_item.rv_reservation_item_ix,
				rv_res_item_group.rv_res_item_group_ix as rv_res_item_group_id,
				rv_res_item_group.rv_grp_status_time,
				rv_res_item_group.rv_grp_accomm_overide_yn,
				rv_res_item_group.rv_grp_date_allocated
			FROM
				rv_res_item_group
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			WHERE
				rv_res_item_group.ac_accomm_room_id = '$roomItem[ac_accomm_room_ix]'
				AND (
						(
							rv_res_item_group.rv_grp_status_ind <> '8'
							AND rv_reservation_item.rv_item_date_depart = '$dateItem[dateRaw]'
						) OR (
							rv_res_item_group.rv_grp_status_ind = '8'
							AND rv_res_item_group.rv_grp_status_time >= '$dateItem[dateRaw] 00:00:00'
							AND rv_res_item_group.rv_grp_status_time <= '$dateItem[dateRaw] 23:59:59'
						)
					)
		",2);
		foreach($departure as $dKey=>$dItem) {
			$check = $lDB->get("
				SELECT
					COUNT(*)
				FROM
					rv_reservation_item
				WHERE
					rv_reservation_item.rv_reservation_id = '$dItem[rv_reservation_ix]'
					AND rv_reservation_item.rv_item_date_arrive = '$dItem[rv_item_date_depart]'
			",4);
			if($check > 0) {
				$departure[$dKey]['hasArrive'] = true;
			} else {
				$departure[$dKey]['hasArrive'] = false;
			}
			$canCheckIn = $lDB->get("
				SELECT
					COUNT(*)
				FROM
					rv_res_item_group
				WHERE
					rv_res_item_group.rv_res_item_group_ix != '$dItem[rv_res_item_group_id]'
					AND rv_res_item_group.ac_accomm_room_id = '$dItem[ac_accomm_room_id]'
					AND rv_res_item_group.rv_grp_status_ind = '5'
			",4);
			if($canCheckIn > 0) {
				$departure[$dKey]['canCheckIn'] = false;
			} else {
				$departure[$dKey]['canCheckIn'] = true;
			}
		}

		$stayover = $lDB->get("
			SELECT
				rv_reservation.rv_reservation_ix,
				rv_reservation.rv_res_name,
				rv_reservation.rf_reservation_status_id,
				rv_reservation.rv_provision_expiry_date,
				rv_reservation.rv_date_changed,
				rv_reservation_item.rv_item_adult_count,
				rv_reservation_item.rv_item_child_count,
				rv_res_item_group.ac_accomm_room_id,
				rv_res_item_group.rv_grp_status_ind,
				rv_res_item_group.rv_room_requested_yn,
				rv_res_item_group.rv_room_request_reason,
				rv_reservation_item.rv_item_date_arrive,
				rv_reservation_item.rv_item_date_depart,
				rv_reservation_item.rv_reservation_item_ix,
				rv_res_item_group.rv_res_item_group_ix as rv_res_item_group_id,
				rv_res_item_group.rv_grp_status_time,
				rv_res_item_group.rv_grp_accomm_overide_yn,
				rv_res_item_group.rv_grp_date_allocated
			FROM
				rv_res_item_group
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			WHERE
				rv_res_item_group.ac_accomm_room_id = '$roomItem[ac_accomm_room_ix]'
				AND rv_reservation_item.rv_item_date_arrive < '$dateItem[dateRaw]'
				AND (
						(
							rv_reservation_item.rv_item_date_depart > '$dateItem[dateRaw]'
							AND rv_res_item_group.rv_grp_status_ind <> '8'
						) OR (
							rv_res_item_group.rv_grp_status_time > '$dateItem[dateRaw] 23:59:59'
							AND rv_res_item_group.rv_grp_status_ind = '8'
						)
					)

		",2);
		foreach($stayover as $sKey=>$sItem) {
			$canCheckIn = $lDB->get("
				SELECT
					COUNT(*)
				FROM
					rv_res_item_group
				WHERE
					rv_res_item_group.rv_res_item_group_ix != '$sItem[rv_res_item_group_id]'
					AND rv_res_item_group.ac_accomm_room_id = '$sItem[ac_accomm_room_id]'
					AND rv_res_item_group.rv_grp_status_ind = '5'
			",4);
			if($canCheckIn > 0) {
				$stayover[$sKey]['canCheckIn'] = false;
			} else {
				$stayover[$sKey]['canCheckIn'] = true;
			}
		}

		$block = $lDB->get("
			SELECT
				COUNT(*)
			FROM
				ac_accomm_room_block
				INNER JOIN ac_accomm_block ON ac_accomm_block.ac_accomm_block_ix = ac_accomm_room_block.ac_accomm_block_id
			WHERE
				ac_accomm_room_block.ac_accomm_room_id = '$roomItem[ac_accomm_room_ix]'
				AND ac_accomm_block.ac_start_date <= '$dateItem[dateRaw]'
				AND ac_accomm_block.ac_end_date > '$dateItem[dateRaw]'
		",4);
		
		$roomingItems[$dateItem['dateRaw']] =  array('arrive'=>$arrival, 'depart'=>$departure, 'stayover'=>$stayover, 'weekDay'=>$dateItem['weekDay'], 'block'=>$block);		
	}
	$roomingItems = array_merge($roomingItems,$roomItem);
	$roomingData[$roomItem['ac_accomm_room_ix']] = $roomingItems;
}
*/

// [START] New rooming SQL stuff
$roomingData = array();
foreach($roomList as $roomItem) {
	$roomingItems = array();
	foreach($dateList as $dateKey=>$dateItem) {
		// Get any arrivals
		$arrival = $lDB->get("
			SELECT
				rv_reservation.rv_reservation_ix,
				rv_reservation.rv_res_name,
				rv_reservation.rv_agent_ref,
				rv_reservation.rf_reservation_status_id,
				rv_reservation.rv_provision_expiry_date,
				rv_reservation.rv_date_changed,
				rv_reservation_item.rv_item_adult_count,
				rv_reservation_item.rv_item_child_count,
				rv_res_item_group.ac_accomm_room_id,
				rv_res_item_group.rv_grp_status_ind,
				rv_res_item_group.rv_room_requested_yn,
				rv_res_item_group.rv_room_request_reason,
				rv_reservation_item.rv_item_date_arrive,
				rv_reservation_item.rv_item_date_depart,
				rv_reservation_item.rv_reservation_item_ix,
				rv_res_item_group.rv_res_item_group_ix as rv_res_item_group_id,
				rv_res_item_group.rv_grp_status_time,
				rv_res_item_group.rv_grp_accomm_overide_yn,
				rv_res_item_group.rv_grp_date_allocated
			FROM
				rv_res_item_group
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			WHERE
				rv_res_item_group.ac_accomm_room_id = '" . $roomItem['ac_accomm_room_ix'] . "'
				AND rv_reservation_item.rv_item_date_arrive = '" . $dateItem['dateRaw'] . "'
		",2);
		foreach($arrival as $aKey=>$aItem) {
			$check = $lDB->get("
				SELECT
					COUNT(*)
				FROM
					rv_reservation_item
				WHERE
					rv_reservation_item.rv_reservation_id = '" . $aItem['rv_reservation_ix'] . "'
					AND rv_reservation_item.rv_item_date_depart = '" . $aItem['rv_item_date_arrive'] . "'
			",4);
			if($check > 0) {
				$arrival[$aKey]['hasDepart'] = true;
			} else {
				$arrival[$aKey]['hasDepart'] = false;
			}
			$canCheckIn = $lDB->get("
				SELECT
					COUNT(*)
				FROM
					rv_res_item_group
				WHERE
					rv_res_item_group.rv_res_item_group_ix != '" . $aItem['rv_res_item_group_id'] . "'
					AND rv_res_item_group.ac_accomm_room_id = '" . $aItem['ac_accomm_room_id'] . "'
					AND rv_res_item_group.rv_grp_status_ind = '5'
			",4);
			if($canCheckIn > 0) {
				$arrival[$aKey]['canCheckIn'] = false;
			} else {
				$arrival[$aKey]['canCheckIn'] = true;
			}
			$arrival[$aKey]['rv_res_name_js'] = t_encodeOverlib($aItem['rv_res_name']);
			$arrival[$aKey]['rv_agent_ref_js'] = t_encodeOverlib($aItem['rv_agent_ref']);
		}

		$departure = $lDB->get("
			SELECT
				rv_reservation.rv_reservation_ix,
				rv_reservation.rv_res_name,
				rv_reservation.rv_agent_ref,
				rv_reservation.rf_reservation_status_id,
				rv_reservation.rv_provision_expiry_date,
				rv_reservation.rv_date_changed,
				rv_reservation_item.rv_item_adult_count,
				rv_reservation_item.rv_item_child_count,
				rv_res_item_group.ac_accomm_room_id,
				rv_res_item_group.rv_grp_status_ind,
				rv_res_item_group.rv_room_requested_yn,
				rv_res_item_group.rv_room_request_reason,
				rv_reservation_item.rv_item_date_arrive,
				rv_reservation_item.rv_item_date_depart,
				rv_reservation_item.rv_reservation_item_ix,
				rv_res_item_group.rv_res_item_group_ix as rv_res_item_group_id,
				rv_res_item_group.rv_grp_status_time,
				rv_res_item_group.rv_grp_accomm_overide_yn,
				rv_res_item_group.rv_grp_date_allocated
			FROM
				rv_res_item_group
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			WHERE
				rv_res_item_group.ac_accomm_room_id = '" . $roomItem['ac_accomm_room_ix'] . "'
				AND (
						(
							rv_res_item_group.rv_grp_status_ind = '5'
							/*AND '" . $dateItem['dateRaw'] . "' = '" . date("Y-m-d") . "'*/
							AND (
								(
									rv_reservation_item.rv_item_date_depart <= '" . date("Y-m-d") . "'
									AND '" . $dateItem['dateRaw'] . "' = '" . date("Y-m-d") . "'
								) OR (
									rv_reservation_item.rv_item_date_depart > '" . date("Y-m-d") . "'
									AND rv_reservation_item.rv_item_date_depart = '" . $dateItem['dateRaw'] . "'
								)
							)
						) OR (
							rv_res_item_group.rv_grp_status_ind < '5'
							AND rv_reservation_item.rv_item_date_depart = '" . $dateItem['dateRaw'] . "'
						) OR (
							rv_res_item_group.rv_grp_status_ind = '8'
							AND rv_res_item_group.rv_grp_status_time >= '" . $dateItem['dateRaw'] . "00:00:00'
							AND rv_res_item_group.rv_grp_status_time <= '" . $dateItem['dateRaw'] . "23:59:59'
						)
					)
		",2);
		foreach($departure as $dKey=>$dItem) {
			$check = $lDB->get("
				SELECT
					COUNT(*)
				FROM
					rv_reservation_item
				WHERE
					rv_reservation_item.rv_reservation_id = '" . $dItem['rv_reservation_ix'] . "'
					AND rv_reservation_item.rv_item_date_arrive = '" . $dItem['rv_item_date_depart'] . "'
			",4);
			if($check > 0) {
				$departure[$dKey]['hasArrive'] = true;
			} else {
				$departure[$dKey]['hasArrive'] = false;
			}
			$canCheckIn = $lDB->get("
				SELECT
					COUNT(*)
				FROM
					rv_res_item_group
				WHERE
					rv_res_item_group.rv_res_item_group_ix != '" . $dItem['rv_res_item_group_id'] . "'
					AND rv_res_item_group.ac_accomm_room_id = '" . $dItem['ac_accomm_room_id'] . "'
					AND rv_res_item_group.rv_grp_status_ind = '5'
			",4);
			if($canCheckIn > 0) {
				$departure[$dKey]['canCheckIn'] = false;
			} else {
				$departure[$dKey]['canCheckIn'] = true;
			}
			$departure[$dKey]['rv_res_name_js'] = t_encodeOverlib($dItem['rv_res_name']);
			$departure[$dKey]['rv_agent_ref_js'] = t_encodeOverlib($dItem['rv_agent_ref']);
		}

		$stayover = $lDB->get("
			SELECT
				rv_reservation.rv_reservation_ix,
				rv_reservation.rv_res_name,
				rv_reservation.rv_agent_ref,
				rv_reservation.rf_reservation_status_id,
				rv_reservation.rv_provision_expiry_date,
				rv_reservation.rv_date_changed,
				rv_reservation_item.rv_item_adult_count,
				rv_reservation_item.rv_item_child_count,
				rv_res_item_group.ac_accomm_room_id,
				rv_res_item_group.rv_grp_status_ind,
				rv_res_item_group.rv_room_requested_yn,
				rv_res_item_group.rv_room_request_reason,
				rv_reservation_item.rv_item_date_arrive,
				rv_reservation_item.rv_item_date_depart,
				rv_reservation_item.rv_reservation_item_ix,
				rv_res_item_group.rv_res_item_group_ix as rv_res_item_group_id,
				rv_res_item_group.rv_grp_status_time,
				rv_res_item_group.rv_grp_accomm_overide_yn,
				rv_res_item_group.rv_grp_date_allocated
			FROM
				rv_res_item_group
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			WHERE
				rv_res_item_group.ac_accomm_room_id = '" . $roomItem['ac_accomm_room_ix'] . "'
				AND rv_reservation_item.rv_item_date_arrive < '" . $dateItem['dateRaw'] . "'
				AND (
						(
							rv_res_item_group.rv_grp_status_ind = '5'
							AND '" . $dateItem['dateRaw'] . "' < '" . date("Y-m-d") . "'
						) OR (
							rv_reservation_item.rv_item_date_depart > '" . $dateItem['dateRaw'] . "'
							AND rv_res_item_group.rv_grp_status_ind <> '8'
						) OR (
							rv_res_item_group.rv_grp_status_time > '" . $dateItem['dateRaw'] . " 23:59:59'
							AND rv_res_item_group.rv_grp_status_ind = '8'
						)
					)

		",2);
		foreach($stayover as $sKey=>$sItem) {
			$canCheckIn = $lDB->get("
				SELECT
					COUNT(*)
				FROM
					rv_res_item_group
				WHERE
					rv_res_item_group.rv_res_item_group_ix != '" . $sItem['rv_res_item_group_id'] . "'
					AND rv_res_item_group.ac_accomm_room_id = '" . $sItem['ac_accomm_room_id'] . "'
					AND rv_res_item_group.rv_grp_status_ind = '5'
			",4);
			if($canCheckIn > 0) {
				$stayover[$sKey]['canCheckIn'] = false;
			} else {
				$stayover[$sKey]['canCheckIn'] = true;
			}
			$stayover[$sKey]['rv_res_name_js'] = t_encodeOverlib($sItem['rv_res_name']);
			$stayover[$sKey]['rv_agent_ref_js'] = t_encodeOverlib($sItem['rv_agent_ref']);
		}

		$block = $lDB->get("
			SELECT
				COUNT(*)
			FROM
				ac_accomm_room_block
				INNER JOIN ac_accomm_block ON ac_accomm_block.ac_accomm_block_ix = ac_accomm_room_block.ac_accomm_block_id
			WHERE
				ac_accomm_room_block.ac_accomm_room_id = '" . $roomItem['ac_accomm_room_ix'] . "'
				AND ac_accomm_block.ac_start_date <= '" . $dateItem['dateRaw'] . "'
				AND ac_accomm_block.ac_end_date > '" . $dateItem['dateRaw'] . "'
		",4);
		
		$roomingItems[$dateItem['dateRaw']] =  array('arrive'=>$arrival, 'depart'=>$departure, 'stayover'=>$stayover, 'weekDay'=>$dateItem['weekDay'], 'block'=>$block);
	}
	$roomingItems = array_merge($roomingItems,$roomItem);
	$roomingData[$roomItem['ac_accomm_room_ix']] = $roomingItems;


}
// [END] New Rooming SQL stuff

$roomListHTML = '
	<tr valign="top" class="!attrClass!" !attrList! style="height: 49px; _height: 48px;">
		<td class="colLtt bb br bl" id="room_!roomNum!" style="padding: 2px;">
			<strong>Room !ac_desc!</strong><br />
			!ac_accomm_desc!			
    </td>
  </tr>
';

$roomRows = "";
foreach($roomList as $roomItem) {
	$attrList = $lDB->get("
		SELECT
			rt_component.rt_component_desc
		FROM
			ac_accomm_room_attr
			INNER JOIN rt_component ON rt_component.rt_component_ix = ac_accomm_room_attr.rt_component_id
		WHERE
			ac_accomm_room_attr.ac_accomm_room_id = '$roomItem[ac_accomm_room_ix]'
	",3);
	if(sizeof($attrList) > 0) {
		$roomItem['attrList'] = " onmouseout=\"nd();\" onmouseover=\"overlib('<b>Attributes</b><br>".join("<br>",$attrList)."');\" onclick=\"roomAttributePopupShow(this,'$roomItem[ac_accomm_desc] - $roomItem[ac_desc]','".join("<br>",$attrList)."');\"";
		$roomItem['attrClass'] = "imgLink";
	} else {
		$roomItem['attrList'] = "";
		$roomItem['attrClass'] = "";
	}
	$roomRows .= showpage($roomItem,$roomListHTML);
}
$GLOBALS['temp']['roomRows'] = $roomRows;
$GLOBALS['temp']['rowCount'] = ( 2 ) + ( sizeof($roomList) );


// remove blank rooms

// Rooming calendar code -- END

$GLOBALS['temp']['pr_bus_name_short'] = $lDB->get("SELECT pr_bus_name_short FROM pr_business WHERE pr_business_id = '$propertyId'",4);

if ( $renderMode == "html" ) {
	$resColourCount = 0;
	$resColourArray = array();
	$calendarRows = "";
	$cellColour = "";
	
	foreach ( $roomingData as $roomingItems ) {
		$totalWidth = $dateCount * 168;
		$calendarRows .= '<table width="' . $totalWidth . '" border="0" cellspacing="0" cellpadding="0" style="table-layout: fixed;">';

		for ( $x = 1; $x < $dateCount; $x++ ) {
			$calendarRows.= '
				<col width="168" />
			';
		}

		$calendarRows .= '		
			<tr valign="top">
		';

		$resItemList = array();

		foreach ( $roomingItems as $date=>$item ) {
			if ( !is_array($item) ) {
				continue;
			}

			$calendarRows .= '
				<td class="bb br" style="height: 48px;">
					<table border="0" cellspacing="0" cellpadding="0" width="168" style="table-layout: fixed;">
						<col width="84" />
						<col width="84" />
			';
			$cellColour = '#fff';
			$conflictCheck = (sizeof($item['stayover']) + sizeof($item['arrive'])) > 1 || (sizeof($item['stayover']) + sizeof($item['depart'])) > 1;
			$conflictArray = array();

			if ( $conflictCheck ) {
				foreach($item['stayover'] as $conflictItem) {
					array_push($conflictArray,$conflictItem);
				}
				foreach($item['arrive'] as $conflictItem) {
					array_push($conflictArray,$conflictItem);
				}
				foreach($item['depart'] as $conflictItem) {
					array_push($conflictArray,$conflictItem);
				}
			}
			
			if ( sizeof($item['stayover']) > 0 ) { // Generate stayover cell
				$resItem = $item['stayover'][0];
				$resClass = "";
				$resBackground = "";
				$cellClass =  getCellClass($resItem['rv_item_date_arrive'], $resItem['rv_item_date_depart'], $resItem['rv_grp_status_ind'],$resItem['rv_grp_status_time'],$resItem['rf_reservation_status_id']);
				
				if($resItem['rv_item_date_depart'] < date("Y-m-d")) {
					$isPast = true;
				} else {
					$isPast = false;
				}
				
				if(array_key_exists($resItem['rv_reservation_ix'],$resColourArray)) {
					$cellColour = isset($resHTMLColour[$resColourArray[$resItem['rv_reservation_ix']]]) ? $resHTMLColour[$resColourArray[$resItem['rv_reservation_ix']]] : "";
				} else {
					$cellColour = "";
				}
				
				if($item['block'] > 0) {
					$cellColour = "#ccc";
				}
				
				if($resItem['rf_reservation_status_id'] == "20") {
					$resClass .= " u";
					if($resItem['rv_provision_expiry_date'] == date("Y-m-d")) {
						$resBackground = "#F1C55D";
					}
					if($resItem['rv_provision_expiry_date'] < date("Y-m-d")) {
						$resBackground = "#DB4242";
					}
				}
				if(isset($resColourArray[$resItem['rv_reservation_ix']]) && $resColourArray[$resItem['rv_reservation_ix']] !== null) {
					$fontColour = "#000";
					$cellColour = $resHTMLColour[$resColourArray[$resItem['rv_reservation_ix']]];
				} else {
					$resColourArray[$resItem['rv_reservation_ix']] = $resColourCount;
					$fontColour = "#000";
					$cellColour = $resHTMLColour[$resColourArray[$resItem['rv_reservation_ix']]];
					$resColourCount++;
					if($resColourCount >= sizeof($resHTMLColour)) {
						$resColourCount = 0;
					}
				}
				$fontColourOverride = "";
				if($isPast) {
					$fontColour = "#8a7a75";
					$fontColourOverride = "#8a7a75";
				}
				
				$guestNames = getGuestNamesCalendar($resItem['rv_res_item_group_id']);
				
				if($conflictCheck && (!in_array($item['stayover'][0]['rv_reservation_item_ix'],$resItemList)|| $date == $toDate)) {
					$guestNames = "";
					foreach($conflictArray as $conflictItem) {
						if($conflictItem['rv_res_item_group_id'] == $resItem['rv_res_item_group_id']) { continue; }
						if($guestNames != "") {
							$guestNames .= ", ";
						}
						$canCheck = "false";
						if (isset($roomCellCount)) {
							$roomCellCount++;
						} else {
							$roomCellCount = 1;
						}
						if(empty($roomCellArray[$conflictItem['rv_res_item_group_id']])) { 
							$roomCellArray[$conflictItem['rv_res_item_group_id']] = array(); 
						}
						array_push($roomCellArray[$conflictItem['rv_res_item_group_id']],$roomCellCount);
						$guestNames .= "<span id=\"roomCell_" . $roomCellCount . "\" class=\"imgLink txtred\">" . $conflictItem['rv_reservation_ix'] . "</span>";
					}
					$guestNames = "<span class=\"txtred\">" . $guestNames . "</span>";
				}

				if ( $guestNames == '' ) {
					$guestNames = "&nbsp;";
				}

				$calendarRows .= '
					<tr>
						<td colspan="2" class="' . $cellClass . '"><img src="/resource/Resrequest/Application/public/img/1x1.gif" width="1" height="3" alt="" /></td>
					</tr>
				';
				$resItem['rv_reservation_ix_fmt'] = $resItem['rv_reservation_ix'];
				if(isset($changeDate) && $resItem['rv_date_changed'] >= $changeDate) {
					$resItem['rv_reservation_ix_fmt'] = $resItem['rv_reservation_ix_fmt'];
					$resClass .= " txti";
				}
				$canCheck = "true";
				if(!in_array($item['stayover'][0]['rv_reservation_item_ix'],$resItemList) || $date == $toDate) {
					if($resItem['rv_room_requested_yn'] != "0") {
						$resHover = " onmouseover=\"overlib('".t_encodeOverlib($resItem['rv_room_request_reason'])."');\" onmouseout=\"nd();\" ";
						$resClass .= " txtb imgLink";
					} else {
						$resHover = "";
					}
					if (isset($roomCellCount)) {
						$roomCellCount++;
					} else {
						$roomCellCount = 1;
					}
					if(!isset($roomCellArray[$resItem['rv_res_item_group_id']]) || !is_array($roomCellArray[$resItem['rv_res_item_group_id']])) { $roomCellArray[$resItem['rv_res_item_group_id']] = array(); }
					array_push($roomCellArray[$resItem['rv_res_item_group_id']],$roomCellCount);
					if($resItem['rv_grp_accomm_overide_yn'] == "1") {
						$upgradeDate = chng_date($resItem['rv_grp_date_allocated'],"-");
						$upgradeSpan = '<span class="txtb" style="color: ' . $fontColour . ';" onmouseout="nd();" onmouseover="overlib(\'Upgrade to [' . $roomingItems['ac_accomm_desc'] . ']: ' . $upgradeDate . '\');">/U</span>';
					} else {
						$upgradeSpan = "";
					}
					$calendarRows .= '
						<tr valign="top" class="imgLink">
							<td id="roomCell_' . $roomCellCount . '" colspan="2" style="background-color: ' . $cellColour . '">
								<table border="0" cellpadding="0" cellspacing="0" style="table-layout:fixed; width: 168px;">
									<col width="168" />
									<tr style="height: 15px;">
										<td style="background-color: ' . $resBackground . '; color: ' . $fontColourOverride . ';"><span ' . $resHover . ' class="' . $resClass . '" style="color: ' . $fontColour . ';">' . $resItem['rv_reservation_ix_fmt'] . $upgradeSpan . '</span>-' . $resItem['rv_item_adult_count'] . ',' . $resItem['rv_item_child_count'] . '</td>
									</tr>
									<tr style="height: 15px;">
										<td style="color: ' . $fontColourOverride . ';">' . $resItem['rv_res_name'] . '</td>
									</tr>
									<tr style="height: 15px;">
										<td style="color: ' . $fontColourOverride . ';">' . $guestNames . '</td>
									</tr>
								</table>
							</td>
						</tr>
					';
				} else {
					$roomCellCount++;
					if(!is_array($roomCellArray[$resItem['rv_res_item_group_id']])) { $roomCellArray[$resItem['rv_res_item_group_id']] = array(); }
					array_push($roomCellArray[$resItem['rv_res_item_group_id']],$roomCellCount);
					$calendarRows .= '
						<tr valign="top" class="' . $cellClass . '" imgLink">
							<td id="roomCell_' . $roomCellCount . '" colspan="2" style="background-color: ' . $cellColour . '">
								<table width="168" border="0" cellpadding="0" cellspacing="0" style="table-layout: fixed;">
									<col width="168" />
									<tr style="height: 15px;">
										<td style="background-color: ' . $resBackground . ';">&nbsp;</td>
									</tr>
									<tr style="height: 15px;">
										<td>&nbsp;</td>
									</tr>
									<tr style="height: 15px;">
										<td>&nbsp;</td>
									</tr>
								</table>
							</td>
						</tr>
					';
				}
				array_push($resItemList,$item['stayover'][0]['rv_reservation_item_ix']);
			} else { // Generate arrive / depart cell
				if(sizeof($item['arrive']) > 0) {
					$resItem = $item['arrive'][0];
					$resClass = "";
					$resBackground = "";
					$cellColour = "";
					$cellClass =  getCellClass($resItem['rv_item_date_arrive'], $resItem['rv_item_date_depart'], $resItem['rv_grp_status_ind'],$resItem['rv_grp_status_time'],$resItem['rf_reservation_status_id']);
					if($resItem['rv_item_date_depart'] < date("Y-m-d")) {
						$isPast = true;
					} else {
						$isPast = false;
					}
					$cellColour = (isset($resColourArray[$resItem['rv_reservation_ix']]) && isset($resHTMLColour[$resColourArray[$resItem['rv_reservation_ix']]])) ? $resHTMLColour[$resColourArray[$resItem['rv_reservation_ix']]] : "";
					
					if ( $item['block'] > 0 ) {
						$cellColour = "#ccc";
					}
					
					if ( $resItem['rf_reservation_status_id'] == "20" ) {
						$resClass .= " u";
						if ( $resItem['rv_provision_expiry_date'] == date("Y-m-d") ) {
							$resBackground = "#f1c55d";
						}
						if ( $resItem['rv_provision_expiry_date'] < date("Y-m-d") ) {
							$resBackground = "#db4242";
						}
					}
					if(isset($resColourArray[$resItem['rv_reservation_ix']]) && $resColourArray[$resItem['rv_reservation_ix']] !== null) {
						$fontColour = "#000";
						$cellColour = $resHTMLColour[$resColourArray[$resItem['rv_reservation_ix']]];
					} else {
						$resColourArray[$resItem['rv_reservation_ix']] = $resColourCount;
						$fontColour = "#000";
						$cellColour = $resHTMLColour[$resColourArray[$resItem['rv_reservation_ix']]];
						$resColourCount++;
						if($resColourCount >= sizeof($resHTMLColour)) {
							$resColourCount = 0;
						}
					}
					$fontColourOverride = "";
					if($isPast) {
						$fontColour = "#8a7a75";
						$fontColourOverride = "#8a7a75";
					}
					$guestNames = getGuestNamesCalendar($resItem['rv_res_item_group_id']);
					if($conflictCheck) {
						$guestNames = "";
						foreach($conflictArray as $conflictItem) {
							if($conflictItem['rv_res_item_group_id'] == $resItem['rv_res_item_group_id']) { continue; }
							if($guestNames != "") {
								$guestNames .= ", ";
							}
							$canCheck = "false";
							$roomCellCount++;
							if(!is_array($roomCellArray[$conflictItem['rv_res_item_group_id']])) { 
								$roomCellArray[$conflictItem['rv_res_item_group_id']] = array(); 
							}
							array_push($roomCellArray[$conflictItem['rv_res_item_group_id']],$roomCellCount);
							
							$guestNames .= '<span id="roomCell_' . $roomCellCount . '" class="imgLink txtred">' . $conflictItem['rv_reservation_ix'] . '</span>';
						}
						$guestNames = '<span class="txtred">' . $guestNames . '</span>';
					}
					if ( $guestNames == '' ) {
						$guestNames = '&nbsp;';
					}

					$resItem['rv_reservation_ix_fmt'] = $resItem['rv_reservation_ix'];

					if ( isset($resItem['rv_date_changed']) && isset($changeDate) && $resItem['rv_date_changed'] >= $changeDate ) {
						$resItem['rv_reservation_ix_fmt'] = $resItem['rv_reservation_ix_fmt'];
						$resClass .= " txti";
					}

					$arriveTopHTML = '<td class="' . $cellClass . '"><img src="/resource/Resrequest/Application/public/img/1x1.gif" width="1" height="3" alt="" /></td>';

					if ( $resItem['rv_room_requested_yn'] != "0" ) {
						$resHover = ' onmouseover="overlib(\'' . t_encodeOverlib($resItem['rv_room_request_reason']) . '\');" onmouseout="nd();" ';
						$resClass .= ' txtb imgLink';
					} else {
						$resHover = '';
					}
					$canCheck = "true";
					if (isset($roomCellCount)) {
						$roomCellCount++;
					} else {
						$roomCellCount = 1;
					}
					
					if ( !isset($roomCellArray[$resItem['rv_res_item_group_id']]) || !is_array($roomCellArray[$resItem['rv_res_item_group_id']]) ) {
						$roomCellArray[$resItem['rv_res_item_group_id']] = array();
					}

					array_push($roomCellArray[$resItem['rv_res_item_group_id']],$roomCellCount);

					if($resItem['rv_grp_accomm_overide_yn'] == "1") {
						$upgradeDate = chng_date($resItem['rv_grp_date_allocated'],"-");
						$upgradeSpan = '<span class="txtb" style="color: ' . $fontColour . ';" onmouseout="nd();" onmouseover="overlib(\'Upgrade to [' . $roomingItems['ac_accomm_desc'] . ']: ' . $upgradeDate . '\');">/U</span>';
					} else {
						$upgradeSpan = "";
					}

					$arrivePointer = "&gt;&gt;";

					if ( $resItem['hasDepart'] ) {
						$arrivePointer = "&gt;";
					}

					$arriveHTML = '
						<td id="roomCell_' . $roomCellCount . '" style="background-color: ' . $cellColour . '">
							<table width="84" border="0" cellpadding="0" cellspacing="0" style="table-layout: fixed;">
							<col width="84" />
							<tr style="height: 15px;">
								<td style="background-color: ' . $resBackground . '; color: ' . $fontColourOverride . ';">
								<strong>' . $arrivePointer . '</strong><span ' . $resHover . ' class="' . $resClass . '" style="color: ' . $fontColour . ';">' . $resItem['rv_reservation_ix_fmt'] . $upgradeSpan . '</span>-' . $resItem['rv_item_adult_count'] . ',' . $resItem['rv_item_child_count'] . '<br /></td>
							</tr>
							<tr style="height: 15px;">
								<td style="color: ' . $fontColourOverride . ';">' . $resItem['rv_res_name'] . '</td>
							</tr>
							<tr style="height: 15px;">
								<td style="color: ' . $fontColourOverride . ';">' . $guestNames . '</td>
							</tr>
							</table>
						</td>
					';
					array_push($resItemList,$item['arrive'][0]['rv_reservation_item_ix']);
				} else {
					$cellColour = "#fff";
					if($item['weekDay'] == "Sun" || $item['weekDay'] == "Sat") {
						$cellColour = "#E5D199";
					}
					if($item['block'] > 0) {
						$cellColour = "#ccc";
					}
					$arriveTopHTML	= '<td style="background-color: ' . $cellColour . '"><img src="/resource/Resrequest/Application/public/img/1x1.gif" width="1" height="3" alt="" /></td>';
					$arriveHTML			= '<td style="background-color: ' . $cellColour . '"><img src="/resource/Resrequest/Application/public/img/1x1.gif" width="1" height="45" alt="" /></td>';
				}
				if(sizeof($item['depart']) > 0) {
					$resItem = $item['depart'][0];
					$resClass = "";
					$resBackground = "";
					$cellColour = "";
					$cellClass =  getCellClass($resItem['rv_item_date_arrive'], $resItem['rv_item_date_depart'], $resItem['rv_grp_status_ind'],$resItem['rv_grp_status_time'],$resItem['rf_reservation_status_id']);
					if($resItem['rv_item_date_depart'] < date("Y-m-d")) {
						$isPast = true;
					} else {
						$isPast = false;
					}
					
					if (isset($resHTMLColour) && 
						isset($resColourArray) && 
						isset($resItem['rv_reservation_ix']) && 
						isset($resColourArray[$resItem['rv_reservation_ix']])
						) {
						$cellColour = $resHTMLColour[$resColourArray[$resItem['rv_reservation_ix']]];
					}
					
					if ( $item['block'] > 0 ) {
						$cellColour = "#ccc";
					}
					
					if ( $resItem['rf_reservation_status_id'] == "20" ) {
						$resClass .= " u";
						if ( $resItem['rv_provision_expiry_date'] == date("Y-m-d") ) {
							$resBackground = "#f1c55d";
						}
						if ( $resItem['rv_provision_expiry_date'] < date("Y-m-d") ) {
							$resBackground = "#db4242";
						}
					}
					
					if ( isset($resColourArray[$resItem['rv_reservation_ix']]) && $resColourArray[$resItem['rv_reservation_ix']] !== null ) {
						$fontColour = "#000";
						$cellColour = $resHTMLColour[$resColourArray[$resItem['rv_reservation_ix']]];
					} else {
						$resColourArray[$resItem['rv_reservation_ix']] = $resColourCount;
						$fontColour = "#000";
						$cellColour = $resHTMLColour[$resColourArray[$resItem['rv_reservation_ix']]];
						$resColourCount++;
						
						if ( $resColourCount >= sizeof($resHTMLColour) ) {
							$resColourCount = 0;
						}
					}
					
					$fontColourOverride = "";
					
					if ( $isPast ) {
						$fontColour = "#8a7a75";
						$fontColourOverride = "#8a7a75";
					}
					
					$guestNames = getGuestNamesCalendar($resItem['rv_res_item_group_id']);
					
					if ( $conflictCheck ) {
						$guestNames = "";
						foreach ( $conflictArray as $conflictItem ) {
							if ( $conflictItem['rv_res_item_group_id'] == $resItem['rv_res_item_group_id'] ) { 
								continue; 
							}
							
							if ( $guestNames != "" ) {
								$guestNames .= ", ";
							}
							
							$canCheck = "false";
							if (isset($roomCellCount)) {
								$roomCellCount++;
							} else {
								$roomCellCount = 1;
							}
		
							
							if ( empty($roomCellArray[$conflictItem['rv_res_item_group_id']]) ) {
								$roomCellArray[$conflictItem['rv_res_item_group_id']] = array();
							}
							array_push($roomCellArray[$conflictItem['rv_res_item_group_id']],$roomCellCount);
							$guestNames .= "<span id=\"roomCell_" . $roomCellCount . "\" class=\"imgLink txtred\">" . $conflictItem['rv_reservation_ix'] . "</span>";
						}
						$guestNames = "<span class=\"txtred\">" . $guestNames . "</span>";
					}

					if ( $guestNames == '' ) {
						$guestNames = '&nbsp;';
					}

					$resItem['rv_reservation_ix_fmt'] = $resItem['rv_reservation_ix'];
					if ( isset($resItem['rv_date_changed']) && isset($changeDate) && $resItem['rv_date_changed'] >= $changeDate ) {
						$resItem['rv_reservation_ix_fmt'] = $resItem['rv_reservation_ix_fmt'];
						$resClass .= " txti";
					}

					$departTopHTML = '<td class="' . $cellClass . '"><img src="/resource/Resrequest/Application/public/img/1x1.gif" width="1" height="3" alt="" /></td>';
					if ( $resItem['rv_room_requested_yn'] != "0" ) {
						$resHover = " onmouseover=\"overlib('" . t_encodeOverlib($resItem['rv_room_request_reason']) . "');\" onmouseout=\"nd();\" ";
						$resClass .= " txtb imgLink";
					} else {
						$resHover = "";
					}
					$canCheck = "true";

					if (isset($roomCellCount)) {
						$roomCellCount++;
					} else {
						$roomCellCount = 1;
					}

					if ( !isset($roomCellArray[$resItem['rv_res_item_group_id']]) || !is_array($roomCellArray[$resItem['rv_res_item_group_id']]) ) {
						$roomCellArray[$resItem['rv_res_item_group_id']] = array();
					}

					array_push($roomCellArray[$resItem['rv_res_item_group_id']],$roomCellCount);

					if ( $resItem['rv_grp_accomm_overide_yn'] == "1" ) {
						$upgradeDate = chng_date($resItem['rv_grp_date_allocated'],"-");
						$upgradeSpan = '<span class="txtb" style="color: ' . $fontColour . ';" onmouseout="nd();" onmouseover="overlib(\'Upgrade to [' . $roomingItems['ac_accomm_desc'] . ']: ' . $upgradeDate . '\');">/U</span>';
					} else {
						$upgradeSpan = '';
					}

					$departPointer = "&gt;&gt;";
					if ( $resItem['hasArrive'] ) {
						$departPointer = "&gt;";
					}

					$departHTML = '
						<td id="roomCell_' . $roomCellCount . '" style="background-color: ' . $cellColour . '" class="imgLink">
							<table width="84" border="0" cellpadding="0" cellspacing="0" style="table-layout: fixed;">
								<col width="84" />
								<tr style="height: 15px;">
									<td style="background-color: ' . $resBackground . '"; color: ' . $fontColourOverride . ';">
									<span ' . $resHover . ' class="' . $resClass . '" style="color: ' . $fontColour . ';">' . $resItem['rv_reservation_ix_fmt'] . $upgradeSpan . '</span>-' . $resItem['rv_item_adult_count'] . ',' . $resItem['rv_item_child_count'] . '&nbsp;<strong>' . $departPointer . '</strong></td>
								</tr>
								<tr style="height: 15px;">
									<td style="color: ' . $fontColourOverride . ';">' . $resItem['rv_res_name'] . '</td>
								</tr>
								<tr style="height: 15px;">
									<td style="color: ' . $fontColourOverride . ';">' . $guestNames . '</td>
								</tr>
							</table>
						</td>
					';
					array_push($resItemList,$item['depart'][0]['rv_reservation_item_ix']);
				} else {
					$cellColour = "#fff";
					if($item['weekDay'] == "Sun" || $item['weekDay'] == "Sat") {
						$cellColour = "#e5d199";
					}
					if($item['block'] > 0) {
						$cellColour = "#ccc";
					}
					$departTopHTML	= '<td style="background-color: ' . $cellColour . '"><img src="/resource/Resrequest/Application/public/img/1x1.gif" width="1" height="3" alt="" /></td>';
					$departHTML			= '<td style="background-color: ' . $cellColour . '"><img src="/resource/Resrequest/Application/public/img/1x1.gif" width="84" height="44" alt="" /></td>';
				}
				$calendarRows .= "<tr>" . $departTopHTML . $arriveTopHTML . "</tr><tr valign=\"top\">" . $departHTML . $arriveHTML . "</tr>";
			}
			$calendarRows .= "</table></td>";
		}
		$calendarRows .= "</tr></table>";
	}
	$GLOBALS['temp']['calendarRows'] = $calendarRows;
}

// Generate any warnings ------------------------------------------------------
$GLOBALS['temp']['warnings'] = "";
$GLOBALS['temp']['showWarning'] = "style=\"display: none;\"";

if ( array_key_exists("url",$_POST) ) {
	$warnings = array();	

	// Unallocated rooms abound ---------------------------------------------------
	$allReservationIds = array();
	$roomedReservationIds = array();
	// Find all the reservations --------------------------------------------------
	foreach ( $resSummaryArray as $r ) {
		foreach ( $r as $s ) {
			foreach ( $s as $t ) {
				if ( $t['rv_provision_expiry_date'] != 0000-00-00 && $t['rv_provision_expiry_date'] < date("Y-m-d") ) {
					// debug($t[0]);
				} else {
					array_push($allReservationIds,$t[0]);
				}
			}
		}
	}

	$allReservationIds = array_unique($allReservationIds);

	foreach ( $roomingData as $r ) {
		foreach ( $r as $s ) {
			if ( isset($s['arrive']) && is_array($s['arrive']) && count($s['arrive']) > 0 ) {
				foreach ( $s['arrive'] as $a ) {
					array_push($roomedReservationIds,$a[0]);
				}
			}

			if ( isset($s['stayover']) && is_array($s['stayover']) && count($s['stayover']) > 0 ) {
				foreach ( $s['stayover'] as $a ) {
					array_push($roomedReservationIds,$a[0]);
				}
			}

			if ( isset($s['depart']) && is_array($s['depart'])  && count($s['depart']) > 0 ) {
				foreach ( $s['depart'] as $a ) {
					array_push($roomedReservationIds,$a[0]);
				}
			}
		}
	}

	$roomedReservationIds = array_unique($roomedReservationIds);
	// From here we can simply do a count on the two arrays to see if there's a 
	// difference indicating that there are unroomed reservations
	if ( count($allReservationIds) > count($roomedReservationIds) ) {
		$warnings[0] = "There are confirmed and provisional reservations for this period that are not yet allocated to rooms";
	}

	// Expired provisionals abound ------------------------------------------------
	foreach ( $resSummaryArray as $r => $date ) {
		foreach ( $date as $k => $res ) {
			foreach ( $res as $rk => $resInfo ) {
				if ( $resInfo['rf_reservation_status_id'] == "20" && dateSubtract($resInfo['rv_provision_expiry_date'],date("Y-m-d")) < 0 ) {
					$warnings[1] = "There are provisional reservations that have expired for this period.";
				}
			}
		}
	}

	// Expired provisionals have been roomed --------------------------------------

	// This has proved to be really annoying as some person has mixed the 
	// $roomingData array keys between numbers and dates... which makes getting 
	// anything sensible out of the array an exercise in maintining control of the
	// Fists of Death(tm)

	// So let's generate an array of the dates used in the date filter ------------
	$days = dateSubtract($toDate['jsDate'],$fromDate['jsDate']) + 1;
	$daterange = makeDates($fromDate['jsDate'],$days);

	foreach ( $roomingData as $r ) {
		foreach ( $daterange as $dk => $date ) {
			if ( array_key_exists($date,$r) ) {
				if ( count($r[$date]['arrive']) > 0 ) {
					foreach ( $r[$date]['arrive'] as $a ) {
						if ( $a['rf_reservation_status_id'] == "20" && dateSubtract($a['rv_provision_expiry_date'],date("Y-m-d")) < 0 ) {
							$warnings[2] = "There are expired provisional reservations that have been allocated to a room for this period.";
						}
					}
				}
					
				if ( count($r[$date]['stayover']) > 0 ) {
					foreach ( $r[$date]['stayover'] as $a ) {
						if ( $a['rf_reservation_status_id'] == "20" && dateSubtract($a['rv_provision_expiry_date'],date("Y-m-d")) < 0 ) {
							$warnings[2] = "There are expired provisional reservations that have been allocated to a room for this period.";
						}
					}
				}

				if ( count($r[$date]['depart']) > 0 ) {
					foreach ( $r[$date]['depart'] as $a ) {
						if ( $a['rf_reservation_status_id'] == "20" && dateSubtract($a['rv_provision_expiry_date'],date("Y-m-d")) < 0 ) {
							$warnings[2] = "There are expired provisional reservations that have been allocated to a room for this period.";
						}
					}
				}
			}
		}
	}

	// If two reservations share a room
	if ( isset($conflictArray) && count($conflictArray) > 0 ) {
		$warnings[3] = "Some rooms for this period are overbooked.";
	}
}
// Generate any warnings : END ------------------------------------------------


// [START] HTML Report --------------------------------------------------------
if ( $renderMode == "html" ) {
	if($reportType == "summary"){
  	$paxHTML = Join("", file(__DIR__ . "/../../../public/html/room_rep_pax_rows.htm"));
		$paxRows = "";

		foreach($paxArray as $paxItem) {
  		$rowItem['rowHead'] = chng_date($paxItem['date'],"-");
  		$rowItem['inNumRooms'] =  $paxItem['inHouse']['accommCount'];
  	    if($rowItem['inNumRooms'] == ""){$rowItem['inNumRooms'] = "0";}
  		$rowItem['inPercRooms'] = $paxItem['inHouse']['roomPerc'];
  	    if($rowItem['inPercRooms'] == ""){$rowItem['inPercRooms'] = "0";}    
  		$rowItem['inNumAdlts'] = $paxItem['inHouse']['adultCount'];
  	    if($rowItem['inNumAdlts'] == ""){$rowItem['inNumAdlts'] = "0";}    
  		$rowItem['inNumChld'] = $paxItem['inHouse']['childCount'];
  	    if($rowItem['inNumChld'] == ""){$rowItem['inNumChld'] = "0";}    
  		$rowItem['inTotal'] = $paxItem['inHouse']['totalCount'];
  	    if($rowItem['inTotal'] == ""){$rowItem['inTotal'] = "0";}    
  		$rowItem['arrNumRooms'] = $paxItem['arrive']['accommCount'];
  	    if($rowItem['arrNumRooms'] == ""){$rowItem['arrNumRooms'] = "0";}    
  		$rowItem['arrNumAdlts'] = $paxItem['arrive']['adultCount'];
  	    if($rowItem['arrNumAdlts'] == ""){$rowItem['arrNumAdlts'] = "0";}    
  		$rowItem['arrNumChld'] = $paxItem['arrive']['childCount'];
  	    if($rowItem['arrNumChld'] == ""){$rowItem['arrNumChld'] = "0";}    
  		$rowItem['arrTotal'] = $paxItem['arrive']['totalCount'];
  	    if($rowItem['arrTotal'] == ""){$rowItem['arrTotal'] = "0";}    
  		$rowItem['stayNumRooms'] = $paxItem['stayover']['accommCount'];
  	    if($rowItem['stayNumRooms'] == ""){$rowItem['stayNumRooms'] = "0";}    
  		$rowItem['stayNumAdlts'] = $paxItem['stayover']['adultCount'];
  	    if($rowItem['stayNumAdlts'] == ""){$rowItem['stayNumAdlts'] = "0";}    
  		$rowItem['stayNumChld'] = $paxItem['stayover']['childCount'];
  	    if($rowItem['stayNumChld'] == ""){$rowItem['stayNumChld'] = "0";}    
  		$rowItem['stayTotal'] = $paxItem['stayover']['totalCount'];
  	    if($rowItem['stayTotal'] == ""){$rowItem['stayTotal'] = "0";}    
  		$rowItem['depNumRooms'] = $paxItem['depart']['accommCount'];
  	    if($rowItem['depNumRooms'] == ""){$rowItem['depNumRooms'] = "0";}    
  		$rowItem['depNumAdlts'] = $paxItem['depart']['adultCount'];
  	    if($rowItem['depNumAdlts'] == ""){$rowItem['depNumAdlts'] = "0";}    
  		$rowItem['depNumChld'] = $paxItem['depart']['childCount'];
  	    if($rowItem['depNumChld'] == ""){$rowItem['depNumChld'] = "0";}    
  		$rowItem['depTotal'] = $paxItem['depart']['totalCount'];
  	    if($rowItem['depTotal'] == ""){$rowItem['depTotal'] = "0";}    
      
  		$paxRows .= showpage($rowItem,$paxHTML);
  	}
		
		$GLOBALS['temp']['paxRows'] = $paxRows;
  
  	$GLOBALS['temp']['totInRm'] = $paxTotals['inHouseAccommCount'];
  	$GLOBALS['temp']['totInAd'] = $paxTotals['inHouseAdultCount'];
  	$GLOBALS['temp']['totInCh'] = $paxTotals['inHouseChildCount'];
  	$GLOBALS['temp']['totInTotal'] = $paxTotals['inHouseTotalCount'];
  
  	$GLOBALS['temp']['totArrRm'] = $paxTotals['arriveAccommCount'];
  	$GLOBALS['temp']['totArrAd'] = $paxTotals['arriveAdultCount'];
  	$GLOBALS['temp']['totArrCh'] = $paxTotals['arriveChildCount'];
  	$GLOBALS['temp']['totArrTotal'] = $paxTotals['arriveTotalCount'];
  
  	$GLOBALS['temp']['totStRm'] = $paxTotals['stayoverAccommCount'];
  	$GLOBALS['temp']['totStAd'] = $paxTotals['stayoverAdultCount'];
  	$GLOBALS['temp']['totStCh'] = $paxTotals['stayoverChildCount'];
  	$GLOBALS['temp']['totStTotal'] = $paxTotals['stayoverTotalCount'];
  	
  	$GLOBALS['temp']['totDepRm'] = $paxTotals['departAccommCount'];
  	$GLOBALS['temp']['totDepAd'] = $paxTotals['departAdultCount'];
  	$GLOBALS['temp']['totDepCh'] = $paxTotals['departChildCount'];
  	$GLOBALS['temp']['totDepTotal'] = $paxTotals['departTotalCount'];
  # [End] PAX
  
  	$resSummaryRowHTML = "
  		<tr>
  			<td>!ac_accomm_desc!</td>
  			!dateItems!
  		</tr>		
  	";	
  	$resSummaryItemHTML = " 
  		<td>!roomCount!</td>
  		<td>!rv_reservation_ix!: !rv_res_name!</td>
  		<td>!adultCount!</td>
  		<td>!childCount!</td>
  		<td>!totalCount!</td>
  	";
  	$GLOBALS['temp']['resSummaryDates'] = "";
  	$GLOBALS['temp']['resSummaryHeadings'] = "";
    
  	foreach($dateArray as $dateItem) {
			$GLOBALS['temp']['resSummaryDates'] .= "
				<td>
					<table border=\"0\" cellspacing=\"0\" cellpadding=\"1\" style=\"table-layout: fixed;\">
						<tr>
							<td height=\"15\" align=\"center\" class=\"colLt br\">" . chng_date($dateItem,"-") . "</td>
						</tr>
						<tr>
							<td height=\"15\" align=\"center\" valign=\"top\" class=\"colLt bb br\">" . date("D",strtotime($dateItem)) . "</td>
						</tr>
      		</table>
				</td>
      ";
  		$GLOBALS['temp']['resSummaryHeadings'] .= "
				<td>
					<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"table-layout: fixed;\">
						<col width=\"30\"></col>
      			<col width=\"135\"></col>
      			<col width=\"30\"></col>
						<col width=\"30\"></col>
						<tr>
							<td height=\"15\" align=\"center\" class=\"colLtt br bb\">Rms</td>
							<td class=\"colLtt br bb\">&nbsp;Res Details</td>
							<td align=\"center\" class=\"colLtt br bb\">Ad</td>
							<td align=\"center\" class=\"colLtt br bb\">Ch</td>
						</tr>
					</table>
				</td>  
      ";
  	}

  	$GLOBALS['temp']['resSummaryDivWidth'] = 225*sizeof($dateArray);
  	$GLOBALS['temp']['resSummaryAccommRows'] = "";
    $GLOBALS['temp']['expiredProv'] = "collapse printCollapse";

		$totalMax = 0;
		foreach ( $resSummaryArray as $resKey => $resItem ) {
  		$first = true;
  		$max = 0;
			
			foreach ( $resItem as $dayItem ) {
				if ( sizeof($dayItem) > $max) {
					$max = sizeof($dayItem);
				}
  		}
			
			$resSummaryRow = "";
      $overlib = "";
			
			for ( $count = 0; $count < $max; $count++ ) {
				$resSummaryRow .= "<form><tr valign=\"top\">";
        $idCount = 0;
				
				foreach ( $resItem as $dayItem ) {
					if ( $count < sizeof($dayItem) ) {
						$currItem = $dayItem[$count];
            $compList = "";
            $compSql = $lDB->get("
            	SELECT
              	rt_component.rt_component_abbrv as compAbbr
              FROM rv_res_item_comp
              INNER JOIN rt_component ON 
              	rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
              WHERE rv_res_item_comp.rv_reservation_item_id = '$currItem[rv_reservation_item_ix]'
              AND rv_res_item_comp.rv_item_comp_option_yn = '1'
              ORDER BY rt_component.rt_component_ix
            ",3);
						
						if ( sizeof($compSql) > 0 ) {
							$compList = "(".join($compSql,", ").") ";
            }
						
						$currItem['total'] = ($currItem['rv_item_accomm_count']*$currItem['rv_item_adult_count']) + ($currItem['rv_item_accomm_count']*$currItem['rv_item_child_count']);
						
						$provColor = "#FFFFFF";
						
						if ( $currItem['rf_reservation_status_id'] == "20" ) {
							if ( $currItem['rv_provision_expiry_date'] == date("Y-m-d") ) {
								$provColor = "#F1C55D";
  						}              
							if ( $currItem['rv_provision_expiry_date'] < date("Y-m-d") ) {
								$provColor = "#DB4242";
								$GLOBALS['temp']['expiredProv'] = "txtbr";								
  						}
  					}

						$rv_res_name = $currItem['rv_res_name'];
						if ( strlen($currItem['rv_res_name']) > 26 && $renderMode == "html" ) {
							$rv_res_name = substr($currItem['rv_res_name'],0,26) . "...";
							$resName = t_encodeOverlib($currItem['rv_res_name']);
							$overlib = "onMouseOver=\"overlib('<span class=txts>$resName</span>',WIDTH,220,OFFSETY,5);\" onMouseOut=\"nd();\"";
						}
						
						$rv_agent_ref = $currItem['rv_agent_ref'];
						if ( strlen($currItem['rv_agent_ref']) > 26 && $renderMode == "html" ) {
							$rv_agent_ref = substr($currItem['rv_agent_ref'],0,26) . "...";
						}
						
						$gNames = getGuestNames($currItem['rv_res_item_group_ix']);
						
						if ( trim($rv_agent_ref) != "" ) {
							$voucher = "Vouch: $rv_agent_ref";
						} else {
							$voucher = "";
						}
						
						$resSummaryRow .= "
					<td>
					<table cellspacing=\"0\" cellpadding=\"1\" style=\"table-layout: fixed\">
					<col width=\"30\"></col>
          <col width=\"135\"></col>
          <col width=\"30\"></col>
          <col width=\"30\"></col>
          <tr valign=\"top\">
						<td class=\"br bb\" height=\"60\" align=\"center\">" . $currItem['rv_item_accomm_count'] . "</td>
						<td class=\"br bb\" style=\"cursor: default;\" bgcolor=\"" . $provColor . "\"><span " . $overlib . ">" . $currItem['rv_reservation_ix'] . "</span>: <span name='resName' id='resName' class=''>" . $rv_res_name . "</span><br /><span name='guestName' id='guestName'>" . $gNames['guestName'] . "</span> " . $compList . "<br />" . $voucher . "</td>
						<td class=\"br bb\" align=\"center\">" . $currItem['rv_item_adult_count'] . "</td>
						<td class=\"br bb\" align=\"center\">" . $currItem['rv_item_child_count'] . "</td>
					</tr>            
          </table></td>";
				} else {
  				$resSummaryRow .= "
						<td>
						<table cellspacing=\"0\" cellpadding=\"1\" style=\"table-layout: fixed\">
            <col width=\"30\"></col>
            <col width=\"135\"></col>
            <col width=\"30\"></col>
            <col width=\"30\"></col>
            <tr>
    					<td class=\"br bb\" height=\"60\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" width=\"1\" height=\"60\" alt=\"\" /></td>
    					<td class=\"br bb\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" width=\"1\" height=\"1\" alt=\"\" /></td>
    					<td class=\"br bb\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" width=\"1\" height=\"1\" alt=\"\" /></td>
    					<td class=\"br bb\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" width=\"1\" height=\"1\" alt=\"\" /></td>
            </tr>
            </table></td>";
  				}
          $idCount ++;
  			}
        $resSummaryRow .= "</tr></form>";
				
				if($first) {
					$GLOBALS['temp']['resSummaryAccommRows'] .= "<tr valign=\"top\"><td class=\"bl br bt\"><table cellspacing=\"0\" cellpadding=\"1\" style=\"table-layout:fixed\">
						<col width=\"100\"></col>
            <tr valign=\"top\"><td height=\"60\">" . $resKey . "</td></tr>
            </table></td></tr>";
  				$first = false;
  			} else {
					$GLOBALS['temp']['resSummaryAccommRows'] .= "<tr valign=\"top\"><td class=\"bl br\"><table cellspacing=\"0\" cellpadding=\"1\" style=\"table-layout:fixed\">
						<col width=\"100\"></col>
            <tr valign=\"top\"><td height=\"60\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td></tr>
            </table></td></tr>";
  			}
  		}
  		if (isset($totalMax)) {
  			$totalMax += $max;
  		} else {
  			$totalMax = $max;
  		}
  		
  		if (isset($GLOBALS['temp']['resSummaryRows'])) {
  			$GLOBALS['temp']['resSummaryRows'] .= $resSummaryRow;
  		} else {
  			$GLOBALS['temp']['resSummaryRows'] = $resSummaryRow;
  		}
  	}
      $GLOBALS['temp']['resSummaryAccommRows'] .= "<tr>
        	<td height=\"16\" class=\"colLt bAll\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
        </tr>";  
  	//	debug($totalMax);
  	$GLOBALS['temp']['resSummaryRowSpan'] = $totalMax + 1;
  	
    // [START] Rooming Summ
  	$GLOBALS['temp']['roomSummaryDates'] = "";
  	$GLOBALS['temp']['roomSummaryHeadings'] = "";
  	foreach($dateArray as $dateItem) {
  		$GLOBALS['temp']['roomSummaryDates'] .= "<td><table cellspacing=\"0\" cellpadding=\"1\" style=\"table-layout:fixed\">
      	<tr><td height=\"15\" align=\"center\" class=\"colLt br\">".chng_date($dateItem,"-")."</td></tr>
        <tr valign=\"top\"><td height=\"15\" align=\"center\" class=\"colLt bb br\">".date("D",strtotime($dateItem))."</td></tr>
      </table></td>
      ";
  		$GLOBALS['temp']['roomSummaryHeadings'] .= "
      <td><table cellspacing=\"0\" cellpadding=\"0\" style=\"table-layout:fixed\">
      <col width=\"165\"></col>
      <col width=\"30\"></col>
      <col width=\"30\"></col>
      	<tr>    
  		    <td height=\"15\" class=\"colLtt br bb\">&nbsp;Res Details</td>
  		    <td align=\"center\" class=\"colLtt br bb\">Ad</td>
  		    <td align=\"center\" class=\"colLtt br bb\">Ch</td>
        </tr>
      </table></td>    
  		";
  	}
  	$roomSummaryRows = "";
  	$roomSummaryAccommRows = "";
  	$roomSummaryCount = 0;
  	foreach($roomSummaryArray as $roomKey=>$roomItem) {
    	$noResRoom = 0;
			$blockRooms = $lDB->get("
      	SELECT 
        	ac_accomm_room_block.ac_accomm_room_id,
          ac_accomm_block.ac_start_date,
          ac_accomm_block.ac_end_date
        FROM ac_accomm_room_block
        INNER JOIN ac_accomm_block ON ac_accomm_block.ac_accomm_block_ix = ac_accomm_room_block.ac_accomm_block_id 
        WHERE 
        	ac_accomm_room_block.ac_accomm_room_id = '$roomItem[ac_accomm_room_ix]'
          AND (
           (ac_accomm_block.ac_start_date >= '".$fromDate['jsDate']."' AND ac_accomm_block.ac_start_date <= '".$toDate['jsDate']."')
           OR
           (ac_accomm_block.ac_end_date >= '".$fromDate['jsDate']."' AND ac_accomm_block.ac_end_date <= '".$toDate['jsDate']."')
           OR
           (ac_accomm_block.ac_start_date < '".$fromDate['jsDate']."' AND ac_accomm_block.ac_end_date > '".$toDate['jsDate']."')
          )
      ",1);
      
      foreach($roomItem['items'] as $key=>$item) {
      	if($item['rv_reservation_ix'] != ""){
        	$noResRoom ++;
        }
      }
      if($noResRoom > 0){
        $roomSummaryAccommRows .= "<tr valign=\"top\"><td class=\"bl br bt\"><table cellspacing=\"0\" cellpadding=\"1\" style=\"table-layout:fixed\">
              <col width=\"100\"></col>
              <tr valign=\"top\"><td height=\"59\">$roomItem[ac_desc] ($roomItem[ac_accomm_desc])</td></tr>
              </table></td></tr>";
                  
    		$roomSummaryRows .= "<tr>";
  
    		foreach($roomItem['items'] as $key=>$item) {
          $blocked = "";
          if($key >= $blockRooms['ac_start_date'] && $key <= $blockRooms['ac_end_date']){
          	$blocked = "txtg colGry";
          }
                
    		  $provColor = "";
            if($item['rf_reservation_status_id'] == "20") {
    				if($item['rv_provision_expiry_date'] == date("Y-m-d")) {
    					$provColor = "#F1C55D";
    				}
    				if($item['rv_provision_expiry_date'] < date("Y-m-d")) {
    				$provColor = "#DB4242";
    				}
    			}
          
          $compList = "";
          $compSql = $lDB->get("
          	SELECT
            	rt_component.rt_component_abbrv as compAbbr
            FROM rv_res_item_comp
            INNER JOIN rt_component ON 
            	rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
            WHERE rv_res_item_comp.rv_reservation_item_id = '$item[rv_reservation_item_ix]'
            AND rv_res_item_comp.rv_item_comp_option_yn = '1'
            ORDER BY rt_component.rt_component_ix
          ",3);
          if(sizeof($compSql)>0){
          	$compList = "(".join($compSql,", ").") ";
          }
          $gNames = getGuestNames($item['groupId']);
          
    			if(trim($item['rv_reservation_ix']) != "") {
					if(trim($item['rv_agent_ref']) != "") {
						$voucher = "Vouch: $item[rv_agent_ref]";
					} else {
						$voucher = "";
					}
    				$roomSummaryRows .= "
            <td><table cellspacing=\"0\" cellpadding=\"1\" style=\"table-layout:fixed\">
            <col width=\"165\"></col>
            <col width=\"30\"></col>
            <col width=\"30\"></col>
            	<tr valign=\"top\">            
    					<td class=\"br bb $blocked\" height=\"60\" bgcolor=\"$provColor\">$item[rv_reservation_ix]: <span name='resName' id='resName' class=''>$item[rv_res_name]</span> <br> <span name='guestName' id='guestName'>$gNames[guestName]</span> $compList<br>$voucher</td>
    					<td class=\"br bb $blocked\" align=\"center\">$item[rv_item_adult_count]</td>
    					<td class=\"br bb $blocked\" align=\"center\">$item[rv_item_child_count]</td>
              </tr>
            </table>
            </td>  
    				";
    			} else {
    				$roomSummaryRows .= "
            <td><table cellspacing=\"0\" cellpadding=\"0\" style=\"table-layout:fixed\">
            <col width=\"165\"></col>
            <col width=\"30\"></col>
            <col width=\"30\"></col>
            	<tr>            
    					<td class=\"br bb $blocked\" height=\"60\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
    					<td class=\"br bb $blocked\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
    					<td class=\"br bb $blocked\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
              </tr>
            </table></td>  
    				";
    			}
    		}
    		$roomSummaryRows .= "</tr>";
    		$roomSummaryCount++;
      }  
  	}
  	$GLOBALS['temp']['roomSummaryRows'] = $roomSummaryRows;
  	$GLOBALS['temp']['roomSummaryAccommRows'] = $roomSummaryAccommRows;
    $GLOBALS['temp']['roomSummaryAccommRows'] .= "<tr>
      	<td height=\"16\" class=\"colLt bAll\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
      </tr>";    
  	$GLOBALS['temp']['roomSummaryRowSpan'] = $roomSummaryCount + 1;
  }
  
  if($reportType == "daySheet"){
  	$daySheetRows = "";
  	$daySheetHTML = join('',file(__DIR__ . '/../../../public/html/rep_arr_dep_rows.htm'));
  	$divide = "0";
  	foreach($dateArray as $dateItem) {
  		$currItem = array();
  		$currItem['propertyName'] = $propertyName;
  		$currItem['weekDay'] = date("D",strtotime($dateItem));
  		$currItem['startDate'] = chng_date($dateItem,"-");
      
  		$paxHTML = Join("", file(__DIR__ . "/../../../public/html/room_rep_pax_rows.htm"));
  		$paxRows = "";
  		foreach($dayPaxArray[$dateItem] as $paxItem) {
  			$rowItem['rowHead'] = $paxItem['ac_accomm_desc'];
  			$rowItem['inNumRooms'] =  $paxItem['inHouse']['accommCount'];
  			$rowItem['inPercRooms'] = $paxItem['inHouse']['roomPerc'];
  			$rowItem['inNumAdlts'] = $paxItem['inHouse']['adultCount'];
  			$rowItem['inNumChld'] = $paxItem['inHouse']['childCount'];
  			$rowItem['inTotal'] = $paxItem['inHouse']['totalCount'];
  			$rowItem['arrNumRooms'] = $paxItem['arrive']['accommCount'];
  			$rowItem['arrNumAdlts'] = $paxItem['arrive']['adultCount'];
  			$rowItem['arrNumChld'] = $paxItem['arrive']['childCount'];
  			$rowItem['arrTotal'] = $paxItem['arrive']['totalCount'];
  			$rowItem['stayNumRooms'] = $paxItem['stayover']['accommCount'];
  			$rowItem['stayNumAdlts'] = $paxItem['stayover']['adultCount'];
  			$rowItem['stayNumChld'] = $paxItem['stayover']['childCount'];
  			$rowItem['stayTotal'] = $paxItem['stayover']['totalCount'];
  			$rowItem['depNumRooms'] = $paxItem['depart']['accommCount'];
  			$rowItem['depNumAdlts'] = $paxItem['depart']['adultCount'];
  			$rowItem['depNumChld'] = $paxItem['depart']['childCount'];
  			$rowItem['depTotal'] = $paxItem['depart']['totalCount'];
  		
  			$paxRows .= showpage($rowItem,$paxHTML);
  		}
  		$currItem['paxrows'] = $paxRows;
  
  		$currItem['totInRm'] = $dayPaxTotalArray[$dateItem]['inHouseAccommCount'];
  		$currItem['totInAd'] = $dayPaxTotalArray[$dateItem]['inHouseAdultCount'];
  		$currItem['totInCh'] = $dayPaxTotalArray[$dateItem]['inHouseChildCount'];
  		$currItem['totInTotal'] = $dayPaxTotalArray[$dateItem]['inHouseTotalCount'];
  	
  		$currItem['totArrRm'] = $dayPaxTotalArray[$dateItem]['arriveAccommCount'];
  		$currItem['totArrAd'] = $dayPaxTotalArray[$dateItem]['arriveAdultCount'];
  		$currItem['totArrCh'] = $dayPaxTotalArray[$dateItem]['arriveChildCount'];
  		$currItem['totArrTotal'] = $dayPaxTotalArray[$dateItem]['arriveTotalCount'];
  
  		$currItem['totStRm'] = $dayPaxTotalArray[$dateItem]['stayoverAccommCount'];
  		$currItem['totStAd'] = $dayPaxTotalArray[$dateItem]['stayoverAdultCount'];
  		$currItem['totStCh'] = $dayPaxTotalArray[$dateItem]['stayoverChildCount'];
  		$currItem['totStTotal'] = $dayPaxTotalArray[$dateItem]['stayoverTotalCount'];
  	
  		$currItem['totDepRm'] = $dayPaxTotalArray[$dateItem]['departAccommCount'];
  		$currItem['totDepAd'] = $dayPaxTotalArray[$dateItem]['departAdultCount'];
  		$currItem['totDepCh'] = $dayPaxTotalArray[$dateItem]['departChildCount'];
  		$currItem['totDepTotal'] = $dayPaxTotalArray[$dateItem]['departTotalCount'];
  /*
  				rv_reservation.rv_reservation_ix,
  				rv_reservation.rv_res_name,
  				rv_reservation_item.rv_item_adult_count,
  				rv_reservation_item.rv_item_child_count,
  				rv_reservation_item.rv_item_accomm_count
  */
  		$resSummaryHTML = Join("", file(__DIR__ . "/../../../public/html/room_day_sheet_resSum.htm"));
  		$resSummaryRows = "";
  		foreach($dayResSummaryArray[$dateItem] as $dayResSummaryItem) {
  			$max = sizeof($dayResSummaryItem['arrive']);
  			if(sizeof($dayResSummaryItem['stayover']) > $max) {
  				$max = sizeof($dayResSummaryItem['stayover']);
  			}
  			if(sizeof($dayResSummaryItem['depart']) > $max) {
  				$max = sizeof($dayResSummaryItem['depart']);
  			}
  			for($count = 0; $count < $max; $count++) {
  				$sumItem = array();
  				if($count == 0) {
  					$sumItem['rowHead'] = $dayResSummaryItem['ac_accomm_desc'];
  				} else {
  					$sumItem['rowHead'] = "&nbsp;";
  				}
  				$sumItem['arrProv'] = "#FFFFFF";
  				if($count < sizeof($dayResSummaryItem['arrive'])) {
  					$sumItem['arrNumRooms'] = $dayResSummaryItem['arrive'][$count]['rv_item_accomm_count'];
  					$sumItem['arrResNum'] = $dayResSummaryItem['arrive'][$count]['rv_reservation_ix'];
  					$sumItem['arrResName'] = $dayResSummaryItem['arrive'][$count]['rv_res_name'];
					if(trim($dayResSummaryItem['arrive'][$count]['rv_agent_ref']) != "") {
						$arriveVoucher = " Vouch: " . $dayResSummaryItem['arrive'][$count]['rv_agent_ref'];
					} else {
						$arriveVoucher = "&nbsp;";
					}
  					$sumItem['arrAgentRef'] = $arriveVoucher;
  					$sumItem['arrNumAdlts'] = $dayResSummaryItem['arrive'][$count]['rv_item_adult_count'];
  					$sumItem['arrNumChld'] = $dayResSummaryItem['arrive'][$count]['rv_item_child_count'];
  					$sumItem['arrTotal'] = ($dayResSummaryItem['arrive'][$count]['rv_item_accomm_count']*$dayResSummaryItem['arrive'][$count]['rv_item_adult_count']) + ($dayResSummaryItem['arrive'][$count]['rv_item_accomm_count']*$dayResSummaryItem['arrive'][$count]['rv_item_child_count']);
  					if($dayResSummaryItem['arrive'][$count]['rf_reservation_status_id'] == "20") {
  						if($dayResSummaryItem['arrive'][$count]['rv_provision_expiry_date'] == date("Y-m-d")) {
  							$sumItem['arrProv'] = "#F1C55D";
  						}
  						if($dayResSummaryItem['arrive'][$count]['rv_provision_expiry_date'] < date("Y-m-d")) {
  						$sumItem['arrProv'] = "#DB4242";
  						}
  					}
  				} else {
  					$sumItem['arrNumRooms'] = "&nbsp;";
  					$sumItem['arrResNum'] = "&nbsp;";
  					$sumItem['arrAgentRef'] = "&nbsp;";
  					$sumItem['arrResName'] = "&nbsp;";
  					$sumItem['arrNumAdlts'] = "&nbsp;";
  					$sumItem['arrNumChld'] = "&nbsp;";
  					$sumItem['arrTotal'] = "&nbsp;";
  				}
  				$sumItem['stayProv'] = "#FFFFFF";
  				if($count < sizeof($dayResSummaryItem['stayover'])) {
  					$sumItem['stayNumRooms'] = $dayResSummaryItem['stayover'][$count]['rv_item_accomm_count'];
  					$sumItem['stayResNum'] = $dayResSummaryItem['stayover'][$count]['rv_reservation_ix'];
  					$sumItem['stayResName'] = $dayResSummaryItem['stayover'][$count]['rv_res_name'];
					if(trim($dayResSummaryItem['stayover'][$count]['rv_agent_ref']) != "") {
						$stayVoucher = " Vouch: " . $dayResSummaryItem['stayover'][$count]['rv_agent_ref'];
					} else {
						$stayVoucher = "&nbsp;";
					}
  					$sumItem['stayAgentRef'] = $stayVoucher; 
  					$sumItem['stayNumAdlts'] = $dayResSummaryItem['stayover'][$count]['rv_item_adult_count'];
  					$sumItem['stayNumChld'] = $dayResSummaryItem['stayover'][$count]['rv_item_child_count'];
  					$sumItem['stayTotal'] = ($dayResSummaryItem['stayover'][$count]['rv_item_accomm_count']*$dayResSummaryItem['stayover'][$count]['rv_item_adult_count']) + ($dayResSummaryItem['stayover'][$count]['rv_item_accomm_count']*$dayResSummaryItem['stayover'][$count]['rv_item_child_count']);					
            if($dayResSummaryItem['stayover'][$count]['rf_reservation_status_id'] == "20") {
  						if($dayResSummaryItem['stayover'][$count]['rv_provision_expiry_date'] == date("Y-m-d")) {
  							$sumItem['stayProv'] = "#F1C55D";
  						}
  						if($dayResSummaryItem['stayover'][$count]['rv_provision_expiry_date'] < date("Y-m-d")) {
  						$sumItem['stayProv'] = "#DB4242";
  						}
  					}
  				} else {
  					$sumItem['stayNumRooms'] = "&nbsp;";
  					$sumItem['stayResNum'] = "&nbsp;";
  					$sumItem['stayResName'] = "&nbsp;";
  					$sumItem['stayAgentRef'] = "&nbsp;";
  					$sumItem['stayNumAdlts'] = "&nbsp;";
  					$sumItem['stayNumChld'] = "&nbsp;";
  					$sumItem['stayTotal'] = "&nbsp;";
  				}
  				$sumItem['depProv'] = "#FFFFFF";
  				if($count < sizeof($dayResSummaryItem['depart'])) {
  					$sumItem['depNumRooms'] = $dayResSummaryItem['depart'][$count]['rv_item_accomm_count'];
  					$sumItem['depResNum'] = $dayResSummaryItem['depart'][$count]['rv_reservation_ix'];
  					$sumItem['depResName'] = $dayResSummaryItem['depart'][$count]['rv_res_name'];
					if(trim($dayResSummaryItem['depart'][$count]['rv_agent_ref']) != "") {
						$departVoucher = " Vouch: " . $dayResSummaryItem['depart'][$count]['rv_agent_ref'];
					} else {
						$departVoucher = "";
					}
  					$sumItem['depAgentRef'] = $departVoucher;
  					$sumItem['depNumAdlts'] = $dayResSummaryItem['depart'][$count]['rv_item_adult_count'];
  					$sumItem['depNumChld'] = $dayResSummaryItem['depart'][$count]['rv_item_child_count'];
  					$sumItem['depTotal'] = ($dayResSummaryItem['depart'][$count]['rv_item_accomm_count']*$dayResSummaryItem['depart'][$count]['rv_item_adult_count']) + ($dayResSummaryItem['depart'][$count]['rv_item_accomm_count']*$dayResSummaryItem['depart'][$count]['rv_item_child_count']);
  					if($dayResSummaryItem['depart'][$count]['rf_reservation_status_id'] == "20") {
  						if($dayResSummaryItem['depart'][$count]['rv_provision_expiry_date'] == date("Y-m-d")) {
  							$sumItem['depProv'] = "#F1C55D";
  						}
  						if($dayResSummaryItem['depart'][$count]['rv_provision_expiry_date'] < date("Y-m-d")) {
  						$sumItem['depProv'] = "#DB4242";
  						}
  					}
  				} else {
  					$sumItem['depNumRooms'] = "&nbsp;";
  					$sumItem['depResNum'] = "&nbsp;";
  					$sumItem['depResName'] = "&nbsp;";
  					$sumItem['depAgentRef'] = "&nbsp;";
  					$sumItem['depNumAdlts'] = "&nbsp;";
  					$sumItem['depNumChld'] = "&nbsp;";
  					$sumItem['depTotal'] = "&nbsp;";
  				}
  				$resSummaryRows .= showpage($sumItem,$resSummaryHTML);
  			}
  		}
  		$currItem['resrows'] = $resSummaryRows;
  
  		$currItem['aTotalRms'] = isset($dayResSummaryTotalArray[$dateItem]['arriveRoom']) ? $dayResSummaryTotalArray[$dateItem]['arriveRoom'] : "";
  		$currItem['aTotalAdlts'] = isset($dayResSummaryTotalArray[$dateItem]['arriveAdult']) ? $dayResSummaryTotalArray[$dateItem]['arriveAdult'] : "";
  		$currItem['aTotalChld'] = isset($dayResSummaryTotalArray[$dateItem]['arriveChild']) ? $dayResSummaryTotalArray[$dateItem]['arriveChild'] : "";
  		$currItem['aTotal'] = isset($dayResSummaryTotalArray[$dateItem]['arriveTotal']) ? $dayResSummaryTotalArray[$dateItem]['arriveTotal'] : "";
  		
  		$currItem['sTotalRms'] = isset($dayResSummaryTotalArray[$dateItem]['stayoverRoom']) ? $dayResSummaryTotalArray[$dateItem]['stayoverRoom'] : "";
  		$currItem['sTotalAdlts'] = isset($dayResSummaryTotalArray[$dateItem]['stayoverAdult']) ? $dayResSummaryTotalArray[$dateItem]['stayoverAdult'] : "";
  		$currItem['sTotalChld'] = isset($dayResSummaryTotalArray[$dateItem]['stayoverChild']) ? $dayResSummaryTotalArray[$dateItem]['stayoverChild'] : "";
  		$currItem['sTotal'] = isset($dayResSummaryTotalArray[$dateItem]['stayoverTotal']) ? $dayResSummaryTotalArray[$dateItem]['stayoverTotal'] : "";
  		
  		$currItem['dTotalRms'] = isset($dayResSummaryTotalArray[$dateItem]['departRoom']) ? $dayResSummaryTotalArray[$dateItem]['departRoom'] : "";
  		$currItem['dTotalAdlts'] = isset($dayResSummaryTotalArray[$dateItem]['departAdult']) ? $dayResSummaryTotalArray[$dateItem]['departAdult'] : "";
  		$currItem['dTotalChld'] = isset($dayResSummaryTotalArray[$dateItem]['departChild']) ? $dayResSummaryTotalArray[$dateItem]['departChild'] : "";
  		$currItem['dTotal'] = isset($dayResSummaryTotalArray[$dateItem]['departTotal']) ? $dayResSummaryTotalArray[$dateItem]['departTotal'] : "";

  		$dayRoomHTML = join("", file(__DIR__ . "/../../../public/html/room_day_sheet_roomRows.htm"));
  		$dayRoomRows = "";      
      
  		foreach($dayRoomArray[$dateItem] as $key=>$dayRoomItem) {
  			$blockRooms = $lDB->get("
        	SELECT 
          	ac_accomm_room_block.ac_accomm_room_id,
            ac_accomm_block.ac_start_date,
            ac_accomm_block.ac_end_date
          FROM ac_accomm_room_block
          INNER JOIN ac_accomm_block ON ac_accomm_block.ac_accomm_block_ix = ac_accomm_room_block.ac_accomm_block_id 
          WHERE 
          	ac_accomm_room_block.ac_accomm_room_id = '$dayRoomItem[ac_accomm_room_ix]'
            AND (
             (ac_accomm_block.ac_start_date >= '".$fromDate['jsDate']."' AND ac_accomm_block.ac_start_date <= '".$toDate['jsDate']."')
             OR
             (ac_accomm_block.ac_end_date >= '".$fromDate['jsDate']."' AND ac_accomm_block.ac_end_date <= '".$toDate['jsDate']."')
             OR
             (ac_accomm_block.ac_start_date < '".$fromDate['jsDate']."' AND ac_accomm_block.ac_end_date > '".$toDate['jsDate']."')
            )
        ",1);
        
  			$sumItem = array();
        $sumItem['block'] = "";
        if($dateItem >= $blockRooms['ac_start_date'] && $dateItem <= $blockRooms['ac_end_date']){
        	$sumItem['block'] = "txtg colGry";
        }        
        
  			$sumItem['roomDesc'] = $dayRoomItem['ac_desc'] . " (". $dayRoomItem['ac_accomm_desc'] . ")";
  
  			$sumItem['arrProv'] = "#FFFFFF";
  			if(trim($dayRoomItem['arrive']['rv_reservation_ix']) != "") {
  				$sumItem['arrResNum'] = $dayRoomItem['arrive']['rv_reservation_ix'];        
  				$sumItem['arrResName'] = $dayRoomItem['arrive']['rv_res_name'];				
				if(trim($dayRoomItem['arrive']['rv_agent_ref']) != "") {
					$arriveVoucher = " Vouch: " . $dayRoomItem['arrive']['rv_agent_ref'];
				} else {
					$arriveVoucher = "&nbsp;";
				}
  				$sumItem['arrAgentRef'] = $arriveVoucher;
  				$sumItem['arrNumAdlts'] = $dayRoomItem['arrive']['rv_item_adult_count'];
  				$sumItem['arrNumChld'] = $dayRoomItem['arrive']['rv_item_child_count'];
  				if($dayRoomItem['arrive']['rf_reservation_status_id'] == "20") {
  					if($dayRoomItem['arrive']['rv_provision_expiry_date'] == date("Y-m-d")) {
  						$sumItem['arrProv'] = "#F1C55D";
  					}
  					if($dayRoomItem['arrive']['rv_provision_expiry_date'] < date("Y-m-d")) {
  						$sumItem['arrProv'] = "#DB4242";
  					}
  				}
  				
  			} else {
  				$sumItem['arrResNum'] = "&nbsp;";
  				$sumItem['arrResName'] = "&nbsp;";
  				$sumItem['arrAgentRef'] = "&nbsp;";
  				$sumItem['arrNumAdlts'] = "&nbsp;";
  				$sumItem['arrNumChld'] = "&nbsp;";
  			}
  			
  			$sumItem['stayProv'] = "#FFFFFF";
  			if(trim($dayRoomItem['stayover']['rv_reservation_ix']) != "") {
  				$sumItem['stayResNum'] = $dayRoomItem['stayover']['rv_reservation_ix'];
  				$sumItem['stayResName'] = $dayRoomItem['stayover']['rv_res_name'];
				if(trim($dayRoomItem['stayover']['rv_agent_ref']) != "") {
					$stayVoucher = " Vouch: " . $dayRoomItem['stayover']['rv_agent_ref'];
				} else {
					$stayVoucher = "&nbsp;";
				}
  				$sumItem['stayAgentRef'] = $stayVoucher;
  				$sumItem['stayNumAdlts'] = $dayRoomItem['stayover']['rv_item_adult_count'];
  				$sumItem['stayNumChld'] = $dayRoomItem['stayover']['rv_item_child_count'];
  				if($dayRoomItem['stayover']['rf_reservation_status_id'] == "20") {
  					if($dayRoomItem['stayover']['rv_provision_expiry_date'] == date("Y-m-d")) {
  						$sumItem['stayProv'] = "#F1C55D";
  					}
  					if($dayRoomItem['stayover']['rv_provision_expiry_date'] < date("Y-m-d")) {
  						$sumItem['stayProv'] = "#DB4242";
  					}
  				}
  			} else {
  				$sumItem['stayResNum'] = "&nbsp;";
  				$sumItem['stayResName'] = "&nbsp;";
  				$sumItem['stayAgentRef'] = "&nbsp;";
  				$sumItem['stayNumAdlts'] = "&nbsp;";
  				$sumItem['stayNumChld'] = "&nbsp;";
  			}
  			
  			$sumItem['depProv'] = "#FFFFFF";
  			if(trim($dayRoomItem['depart']['rv_reservation_ix']) != "") {
  				$sumItem['depResNum'] = $dayRoomItem['depart']['rv_reservation_ix'];
  				$sumItem['depResName'] = $dayRoomItem['depart']['rv_res_name'];
				if(trim($dayRoomItem['depart']['rv_agent_ref']) != "") {
					$departVoucher = " Vouch: " . $dayRoomItem['depart']['rv_agent_ref'];
				} else {
					$departVoucher = "&nbsp;";
				}
  				$sumItem['depAgentRef'] = $departVoucher;
  				$sumItem['depNumAdlts'] = $dayRoomItem['depart']['rv_item_adult_count'];
  				$sumItem['depNumChld'] = $dayRoomItem['depart']['rv_item_child_count'];
  				
  				if ( $dayRoomItem['depart']['rf_reservation_status_id'] == "20" ) {
  					if ( $dayRoomItem['depart']['rv_provision_expiry_date'] == date("Y-m-d") ) {
  						$sumItem['depProv'] = "#F1C55D";
  					}
  					
  					if ( $dayRoomItem['depart']['rv_provision_expiry_date'] < date("Y-m-d") ) {
  						$sumItem['depProv'] = "#DB4242";
  					}
  				}
  			} else {
  				$sumItem['depResNum']		= "&nbsp;";
  				$sumItem['depResName']		= "&nbsp;";
  				$sumItem['depAgentRef']	= "&nbsp;";
  				$sumItem['depNumAdlts']	= "&nbsp;";
  				$sumItem['depNumChld']		= "&nbsp;";
  			}
  			$dayRoomRows .= showPage($sumItem,$dayRoomHTML);
  		}
  		$currItem['roomrows'] = $dayRoomRows;
  
  		$currItem['aTotAdlts']	= $dayRoomTotalArray[$dateItem]['arriveAdult'];
  		$currItem['aTotChld']	= $dayRoomTotalArray[$dateItem]['arriveChild'];
  		$currItem['sTotAdlts']	= $dayRoomTotalArray[$dateItem]['stayoverAdult'];
  		$currItem['sTotChld']	= $dayRoomTotalArray[$dateItem]['stayoverAdult'];
  		$currItem['dTotAdlts']	= $dayRoomTotalArray[$dateItem]['departAdult'];
  		$currItem['dTotChld']	= $dayRoomTotalArray[$dateItem]['departAdult'];
  
  		$dayRequestHTML = join("",file(__DIR__ . "/../../../public/html/room_day_sheet_reqRows.htm"));
  		$dayRequestRows = "";
  		foreach($dayRequestArray[$dateItem] as $dayRequestItem) {
  			/*			rv_reservation.rf_reservation_status_id as reqStatId,
  			rv_reservation.rv_provision_expiry_date as reqProvExpDt
  */
  			$dayRequestItem['reqProv'] = "#FFFFFF";
  			if($dayRequestItem['reqStatId'] == "20") {
  				if($dayRequestItem['reqProvExpDt'] == date("Y-m-d")) {
  					$dayRequestItem['reqProv'] = "#F1C55D";
  				}
  				if($dayRequestItem['reqProvExpDt'] < date("Y-m-d")) {
  					$dayRequestItem['reqProv'] = "#DB4242";
  				}
  			}
        $dayRequestItem['reqArrive'] = chng_date($dayRequestItem['reqArrive'],"-");
        $dayRequestItem['reqDepart'] = chng_date($dayRequestItem['reqDepart'],"-");
        
  			if($dayRequestItem['reqRooms'] == "") {
  				$dayRequestItem['reqRooms'] = "&nbsp;";
  			}
  			$dayRequestRows .= showpage($dayRequestItem, $dayRequestHTML);
  		}
  		$currItem['reqrows'] = $dayRequestRows;
      $currItem['noReq'] = "";
      if($dayRequestRows == ""){
        $currItem['noReq'] = "collapse printCollapse";
        $currItem['reqrows'] = "<tr><td colspan=\"7\" class=\"bl bb br\">&nbsp;No Requests</td></tr>";
      }
  
  		$dayExtraDetailHTML = join("",file(__DIR__ . "/../../../public/html/room_rep_extra_drows.htm"));
      $dayExtraDetailRows = "";  		
      $dayLastDate = "";
      $dayLastCat = "";      
			foreach($dayExtraDetailArray[$dateItem] as $dayExtraDetailItem) {  
				if(trim($dayExtraDetailItem['rv_extra_travel_eta']) != "") {
					$sumItem['rv_extra_travel_eta'] = $dayExtraDetailItem['rv_extra_travel_eta'];
				} else {
					$sumItem['rv_extra_travel_eta'] = "&nbsp;";
				}
				if(trim($dayExtraDetailItem['rv_extra_travel_etd']) != "") {
					$sumItem['rv_extra_travel_etd'] = $dayExtraDetailItem['rv_extra_travel_etd'];
				} else {
					$sumItem['rv_extra_travel_etd'] = "&nbsp;";
				}

      	if($dayLastDate == $dayExtraDetailItem['rv_extra_date_serv']){
          $sumItem['servDate'] = "&nbsp;";
        }else{
  				$sumItem['servDate'] = chng_date($dayExtraDetailItem['rv_extra_date_serv'],"-");
        }  
        $sumItem['travInd'] = "&nbsp;";
        if($dayExtraDetailItem['ac_extra_cat_ind'] == 2){
          $sumItem['travInd'] = "<img src=\"/resource/Resrequest/Application/public/img/button_travel.gif\">";
        }      
        if($dayLastCat == $dayExtraDetailItem['ac_extra_cat_desc']){
        	$sumItem['catDesc'] = "&nbsp;";
        }else{
  				$sumItem['catDesc'] = $dayExtraDetailItem['ac_extra_cat_desc'];
        }  
  			$sumItem['extraDesc'] = $dayExtraDetailItem['ac_ext_desc'];
  			$sumItem['numUnits'] = $dayExtraDetailItem['rv_extra_units'];
  			$sumItem['roomDesc'] = $dayExtraDetailItem['ac_desc'];
  			$sumItem['resNum'] = $dayExtraDetailItem['rv_reservation_ix'];
  			$sumItem['resName'] = $dayExtraDetailItem['rv_res_name'];
  
        $sumItem['extraSummNote'] = "&nbsp;";   
        if(trim($dayExtraDetailItem['rv_extra_note']) != ""){
      	  $sumItem['extraSummNote'] = "x";
        }
        $sumItem['extraSummIntNote'] = "&nbsp;";  
        if(trim($dayExtraDetailItem['rv_extra_note_internal']) != ""){
        	$sumItem['extraSummIntNote'] = "x";
        }
        $sumItem['provColor'] = "#FFFFFF";  			
          if($dayExtraDetailItem['rf_reservation_status_id'] == "20") {
      		if($dayExtraDetailItem['rv_provision_expiry_date'] == date("Y-m-d")) {
      			$sumItem['provColor'] = "#F1C55D";
      		}
      		if($dayExtraDetailItem['rv_provision_expiry_date'] < date("Y-m-d")) {
      		$sumItem['provColor'] = "#DB4242";
      		}
      	}
            
  			$dayExtraDetailRows .= showpage($sumItem,$dayExtraDetailHTML);
        $dayLastDate = $dayExtraDetailItem['rv_extra_date_serv'];
        $dayLastCat = $dayExtraDetailItem['ac_extra_cat_desc'];
  		}
  		$currItem['detRows'] = $dayExtraDetailRows;
      if($dayExtraDetailRows == ""){
  	    $currItem['detRows'] = "<tr><td colspan=\"8\" align=\"center\">&nbsp;No Extras for: ".chng_date($dateItem,"-")."</td></tr>";
      }
  		$daySheetRows .= showpage($currItem,$daySheetHTML);
  	}
  	$GLOBALS['temp']['daySheetRows'] = $daySheetRows;
    $GLOBALS['temp']['options'] = $options;
	}

	if ( array_key_exists("url",$_POST) ) {
		foreach( $warnings as $w ) {
			if ( trim($w) != "" ) {
				$GLOBALS['temp']['warnings'] .= $w . "<br />";
				$GLOBALS['temp']['showWarning'] = "style=\"display: block;\"";
			}
		}
	}
}  


// PDF Report : START ---------------------------------------------------------
if ( $renderMode == "pdf" && ($renderType == "view" || $renderType == "send") ) {
	$pdf = new PDF("Rooming Report (Conf and Prov reports)","L");

	// Main PDF header --------------------------------------------------------
	$headerArray = array(
		array('name' => "Date Range", 'value' => $fromDate['htmlDate'] . " to " . $toDate['htmlDate']),
		array('name' => "Property", 'value'=> $propertyName)
	);
	
	switch($reportType){
  	case "summary":
			$reportLabel = "Rooming Summary Report"; 
    break;
    case "daySheet":
      $reportLabel = "Rooming Day Sheet Report";
    break;
  }

	// In adding page breaks for each section we need to be sure we don't include
	// a blank page at the start of the Report... so we use this variable.
	$firstpage = true;

	if ( $options & REP_ROOMING_CALENDAR ) {
		
		( $firstpage ) ? $firstpage = false : $pdf->AddPage();

		$pdfFontSize = 8;
		$pdf->SetFont('Arial', '', $pdfFontSize);
		$pdf->SetDrawColor(0x66,0x33,0x00);
		$pdf->Ln(2);

		$rowSet1 = array();
		$rowSet2 = array();

		$cProvDue		= array(0xf1,0xc5,0x5d);
		$cProvExpire	= array(0xdb,0x42,0x42);
		$cWhite			= array(0xff,0xff,0xff);
		$cBlock			= array(0xcc,0xcc,0xcc);
		$cColLt			= array(0xf8,0xe8,0xbb);
		$cColLtt		= array(0xfc,0xf3,0xda);
		$cColDk			= array(0xe5,0xd1,0x99);

		$resPDFColour = array(
			array(0xff,0xcc,0xcc),
			array(0x99,0xcc,0xff),
			array(0x99,0xcc,0xcc),
			array(0xcc,0x99,0xcc),
			array(0xcc,0xcc,0x99),
			array(0xff,0xcc,0x33),
			array(0x66,0xcc,0xcc),
			array(0x99,0x99,0xff),
			array(0xff,0xff,0xcc),		
			array(0xa4,0xc1,0xb6),
			array(0xbf,0xf9,0x39),
			array(0xe0,0xdc,0xcf),
			array(0xab,0xfe,0xf5),
			array(0xef,0xdb,0xf0),
			array(0x9f,0xa2,0x57),
			array(0x4d,0x8d,0xce)
		);
		
		$resColourArray = array();
		$resColourCount = 0;

		$checkInPic = $pdf->_parsejpg(__DIR__ . "/../../../public/img/button_checkIn.jpg");
		$checkOutPic = $pdf->_parsejpg(__DIR__ . "/../../../public/img/button_checkOut.jpg");

		$pdf->SetFont("Arial","",14);
		$pdf->Row(array(array(
			"width"		=> "100%",
			"data" 		=> 	"<B>" . $propertyName . "</B>",
			"border" 	=> "",
			"fill"		=> ""
		)));

		$pdf->SetFont("Arial","",8);
		$pdf->Row(
			array(
				array(
					"width"		=> "100%",
					"data" 		=> 	$reportLabel . " " . $fromDate['htmlDate'] . " - " . $toDate['htmlDate'],
					"border" 	=> "",
					"fill" 		=> ""
				)
			)
		);
		$pdf->SetFont("Arial","",5);

		$pdf->Ln(5);

		$dataRows = array();
		$dataRows2 = array();
		$dataRowCount = 0;

		foreach ( $roomingData as $roomingItems ) {
			$dataRows[$dataRowCount] = array();
			$dataRows2[$dataRowCount] = array();

			$rowStart = array(
				array(
					'width'			=> "8%",
					'data'			=> "Room " . $roomingItems['ac_desc'] . "\n" . $roomingItems['ac_accomm_desc'],
					'border'		=> "LRB",
					'fill'			=> 1,
					'fillColor'	=> $cColLtt
				)
			);

			$rowHeaderStart = array(
				array(
					'width'		=> "8%",
					'height'		=> "0.5",
					'data'			=> "",
					'border'		=> "LRT",
					'fill'			=> 1,
					'fillColor'	=> $cColLtt
				)
			);

			$resItemList = array();
			$colCount = 0;

			$dataRowCount2 = 0;
			$dataRows[$dataRowCount][$dataRowCount2] = $rowHeaderStart;
			$dataRows2[$dataRowCount][$dataRowCount2] = $rowStart;
			
			foreach ( $roomingItems as $date => $item ) {
				if ( !is_array($item) ) {
					continue;
				}

				if ( sizeof($item['stayover']) > 0 ) {
					// Generate stayover cell ------------------------------------------------
					$resItem = $item['stayover'][0];
					
					$cellClass = getCellClass($resItem['rv_item_date_arrive'], $resItem['rv_item_date_depart'], $resItem['rv_grp_status_ind'],$resItem['rv_grp_status_time'],$resItem['rf_reservation_status_id'],true);

					if (isset($resColourArray[$resItem['rv_reservation_ix']]) && $resColourArray[$resItem['rv_reservation_ix']] !== null ) {
						$cellColour = $resPDFColour[$resColourArray[$resItem['rv_reservation_ix']]];
					} else {
						$resColourArray[$resItem['rv_reservation_ix']] = $resColourCount;
						$cellColour = $resPDFColour[$resColourArray[$resItem['rv_reservation_ix']]];
						$resColourCount++;
						
						if ( $resColourCount >= sizeof($resPDFColour) ) {
							$resColourCount = 0;
						}
					}			

					if ( $item['block'] > 0 ) {
						$cellColour = $cBlock; 
					}
					
					if ( $resItem['rf_reservation_status_id'] == "20" ) {
						if ( $resItem['rv_provision_expiry_date'] == date("Y-m-d") ) {
							$cellColour = $cProvDue;
						}
						
						if ( $resItem['rv_provision_expiry_date'] < date("Y-m-d") ) {
							$cellColour = $cProvExpire;
						}
					}
					
					$guestNames = getGuestNames($resItem['rv_res_item_group_id']);
					
					$rowItemHeader = array(
						'width'			=> "13%",
						'height'		=> "0.5",
						'data'			=> "",
						'border'		=> "LRT",
						'fill'			=> 1,
						'fillColor'	=> $cellClass
					);
					
					if ( $resItem['rv_item_date_depart'] < date("Y-m-d") ) {
						$fontColour = array(0x8a, 0x7a, 0x75);
					} else {
						$fontColour = array(0x00, 0x00, 0x00);
					}
					
					if ( $resItem['rv_grp_accomm_overide_yn'] == "1" ) {
						$upgradeSpan = "/U";
					} else {
						$upgradeSpan = "";
					}
					
					$thisRowData = $resItem['rv_reservation_ix'] . $upgradeSpan . " - " . $resItem['rv_item_adult_count'] . "," . $resItem['rv_item_child_count'];
					
					if ( trim($resItem['rv_res_name']) != "" ) {
						$thisRowData .= "\n" . $resItem['rv_res_name'];
					}
					
					if ( is_array($guestNames) ) {
						$thisRowData .= "\n" . str_replace("<BR>",", ",implode(",",$guestNames));
					}
					
					if ( !in_array($item['stayover'][0]['rv_reservation_item_ix'],$resItemList) || $date == $toDate ) {
						$rowItem = array(
							'width'			=> "13%",
							'data'			=> $thisRowData,
							'border'		=> "LRB",
							'fill'			=> 1,
							'fillColor'	=> $cellColour,
							'textColor'	=> $fontColour
						);
					} else {
						if ( $resColourArray[$resItem['rv_reservation_ix']] !== null ) {
							$cellColour = $resPDFColour[$resColourArray[$resItem['rv_reservation_ix']]];
						} else {
							$resColourArray[$resItem['rv_reservation_ix']] = $resColourCount;
							$cellColour = $resPDFColour[$resColourArray[$resItem['rv_reservation_ix']]];
							$resColourCount++;
							
							if ( $resColourCount >= sizeof($resPDFColour) ) {
								$resColourCount = 0;
							}
						}

						if ( $item['block'] > 0 ) {
							$cellColour = $cBlock; 
						}
						
						$rowItem = array(
							'width'			=> "13%",
							'data'			=> "",
							'border'		=> "LRB",
							'fillColor'	=> $cellColour,
							'fill'			=>	1
						);					
					}					
					array_push($resItemList,$item['stayover'][0]['rv_reservation_item_ix']);
					array_push($dataRows[$dataRowCount][$dataRowCount2],$rowItemHeader);
					array_push($dataRows2[$dataRowCount][$dataRowCount2],$rowItem);
				} else {
					// Generate arrive / depart cell -----------------------------------------
					if ( sizeof($item['depart']) > 0 ) {
						$resItem = $item['depart'][0];
						
						$cellClass =  getCellClass($resItem['rv_item_date_arrive'], $resItem['rv_item_date_depart'], $resItem['rv_grp_status_ind'],$resItem['rv_grp_status_time'],$resItem['rf_reservation_status_id'],true);
						
						$cellColour = $resPDFColour[$colCount];
						
						if (isset($resColourArray[$resItem['rv_reservation_ix']]) && $resColourArray[$resItem['rv_reservation_ix']] !== null ) {
							$cellColour = $resPDFColour[$resColourArray[$resItem['rv_reservation_ix']]];
						} else {
							$resColourArray[$resItem['rv_reservation_ix']] = $resColourCount;
							$cellColour = $resPDFColour[$resColourArray[$resItem['rv_reservation_ix']]];
							$resColourCount++;

							if ( $resColourCount >= sizeof($resPDFColour) ) {
								$resColourCount = 0;
							}
						}
						
						if ( $item['block'] > 0 ) {
							$cellColour = $cBlock; 
						}

						if ( $resItem['rf_reservation_status_id'] == "20" ) {
							if ( $resItem['rv_provision_expiry_date'] == date("Y-m-d") ) {
								$cellColour = $cProvDue;
							}

							if ( $resItem['rv_provision_expiry_date'] < date("Y-m-d") ) {
								$cellColour = $cProvExpire;
							}
						}

						$guestNames = getGuestNames($resItem['rv_res_item_group_id']);
						$departPointer = ">>";

						if ( $resItem['hasArrive'] ) {
							$departPointer = ">";
						}

						// Row above a departure block ------------------------------------------
						$rowItemHeader = array(
							'width'			=> "6.5%",
							'height'		=> "0.5",
							'data'			=> "",
							'border'		=> "LT",
							'fill'			=> 1,
							'fillColor'	=> $cellClass
						);
						// Row above a departure block ------------------------------------------

						if ( $resItem['rv_item_date_depart'] < date("Y-m-d") ) {
							$fontColour = array(0x8a, 0x7a, 0x75);
						} else {
							$fontColour = array(0x00, 0x00, 0x00);
						}

						if ( $resItem['rv_grp_accomm_overide_yn'] == "1" ) {
							$upgradeSpan = "/U";
						} else {
							$upgradeSpan = "";
						}

						$thisRowData = "<B>" . $resItem['rv_reservation_ix'] . $upgradeSpan . " - " . $resItem['rv_item_adult_count'] . "," . $resItem['rv_item_child_count'] . " " . $departPointer . "</B>";
						if ( trim($resItem['rv_res_name']) != "" ) {
							$thisRowData .= "\n" . $resItem['rv_res_name'];
						}

						if ( is_array($guestNames) ) {
							$thisRowData .=  "\n" . str_replace("<BR>",", ",implode(",",$guestNames));							
						}

						// Departure block ------------------------------------------------------
						$rowItem = array(
							'width'			=> "6.5%",
							'data'			=> $thisRowData,
							'border'		=> "LB",
							'fill'			=> 1,
							'fillColor'	=> $cellColour,
							'textColor'	=> $fontColour
						);
						// Departure block ------------------------------------------------------

						array_push($resItemList,$item['depart'][0]['rv_reservation_item_ix']);
					} else {
						$cellColour = $cWhite;

						if ( $item['weekDay'] == "Sun" || $item['weekDay'] == "Sat" ) {
							$cellColour = $cColDk;
						}

						if ( $item['block'] > 0 ) {
							$cellColour = $cBlock; 
						}

						// Row above 1st half of blank cell -------------------------------------
						$rowItemHeader = array(
							'width'			=> "6.5%",
							'height'		=> "0.5",
							'data'			=> "",
							'border'		=> "LT",
							'fill'			=> 1,
							'fillColor'	=> $cellColour
						);
						// Row above 1st half of blank cell -------------------------------------

						// 1st half of blank cell -----------------------------------------------
						$rowItem = array(
							'width'			=> "6.5%",
							'data'			=> "",
							'border'		=> "LB",
							'fillColor'	=> $cellColour,
							'fill'			=> 1
						);
						// 1st half of blank cell -----------------------------------------------
					}

					array_push($dataRows[$dataRowCount][$dataRowCount2],$rowItemHeader);
					array_push($dataRows2[$dataRowCount][$dataRowCount2],$rowItem);

					if ( sizeof($item['arrive']) > 0 ) {
						$resItem = $item['arrive'][0];

						$cellClass =  getCellClass($resItem['rv_item_date_arrive'], $resItem['rv_item_date_depart'], $resItem['rv_grp_status_ind'],$resItem['rv_grp_status_time'],$resItem['rf_reservation_status_id'],true);

						$cellColour = $resPDFColour[$colCount];

						if (isset($resColourArray[$resItem['rv_reservation_ix']]) && $resColourArray[$resItem['rv_reservation_ix']] !== null ) {
							$cellColour = $resPDFColour[$resColourArray[$resItem['rv_reservation_ix']]];
						} else {
							$resColourArray[$resItem['rv_reservation_ix']] = $resColourCount;
							$cellColour = $resPDFColour[$resColourArray[$resItem['rv_reservation_ix']]];
							$resColourCount++;
							
							if ( $resColourCount >= sizeof($resPDFColour) ) {
								$resColourCount = 0;
							}
						}

						if ( $item['block'] > 0 ) {
							$cellColour = $cBlock; 
						}

						if ( $resItem['rf_reservation_status_id'] == "20" ) {
							if ( $resItem['rv_provision_expiry_date'] == date("Y-m-d") ) {
								$cellColour = $cProvDue;
							}

							if ( $resItem['rv_provision_expiry_date'] < date("Y-m-d") ) {
								$cellColour = $cProvExpire;
							}
						}

						$guestNames = getGuestNames($resItem['rv_res_item_group_id']);
						$arrivePointer = ">>";

						if ( $resItem['hasDepart'] ) {
							$arrivePointer = ">";
						}

						// Line above the arrival block -----------------------------------------
						$rowItemHeader = array(
							'width'			=> "6.5%",
							'height'		=> "0.5",
							'data'			=> "",
							'border'		=> "RT",
							'fill'			=> 1,
							'fillColor'	=> $cellClass
						);
						// Line above the arrival block -----------------------------------------

						if ( $resItem['rv_item_date_depart'] < date("Y-m-d") ) {
							$fontColour = array(0x8a, 0x7a, 0x75);
						} else {
							$fontColour = array(0x00, 0x00, 0x00);
						}

						if ( $resItem['rv_grp_accomm_overide_yn'] == "1" ) {
							$upgradeSpan = "/U";
						} else {
							$upgradeSpan = "";
						}

						$thisRowData = "<B>" . $arrivePointer . "</B> " . $resItem['rv_reservation_ix'] . $upgradeSpan . " - " . $resItem['rv_item_adult_count'] . "," . $resItem['rv_item_child_count'];

						if ( trim($resItem['rv_res_name']) != "" ) {
							$thisRowData .= "\n" . $resItem['rv_res_name'];
						}

						if ( is_array($guestNames) ) {
							$thisRowData .= "\n" . str_replace("<BR>",", ",implode(",",$guestNames));
						}

						// Arrival block --------------------------------------------------------
						$rowItem = array(
							'width'			=> "6.5%",
							'data'			=> $thisRowData,
							'border'		=> "RB",
							'fill'			=> 1,
							'fillColor'	=> $cellColour,
							'textColor'	=> $fontColour
						);
						// Arrival block --------------------------------------------------------

						array_push($resItemList,$item['arrive'][0]['rv_reservation_item_ix']);
					} else {
						$cellColour = $cWhite;

						if ( $item['weekDay'] == "Sun" || $item['weekDay'] == "Sat" ) {
							$cellColour = $cColDk;
						}

						if ( $item['block'] > 0 ) {
							$cellColour = $cBlock; 
						}

						$rowItemHeader = array(
							'width'			=> "6.5%",
							'height'		=> "0.5",
							'data'			=> "",
							'border'		=> "RT",
							'fill'			=> 1,
							'fillColor'	=> $cellColour
						);

						$rowItem = array(
							'width'			=> "6.5%",
							'data'			=> "",
							'border'		=> "RB",
							'fillColor'	=> $cellColour,
							'fill'			=> 1
						);
					}
					array_push($dataRows[$dataRowCount][$dataRowCount2],$rowItemHeader);
					array_push($dataRows2[$dataRowCount][$dataRowCount2],$rowItem);
				}

				$colCount++;
				if ( $colCount > 6 ) {
					$colCount = 0;
					$dataRowCount2++;
					$dataRows[$dataRowCount][$dataRowCount2] = $rowHeaderStart;
					$dataRows2[$dataRowCount][$dataRowCount2] = $rowStart;
				}
			}
			$dataRowCount++;
			if (isset($rowHeaders)) 	{ array_push($rowSet1,$rowHeaders); }
			if (isset($rows)) 			{ array_push($rowSet1,$rows); }
			if (isset($rowHeaders2)) 	{ array_push($rowSet2,$rowHeaders2); }
			if (isset($rows2)) 			{ array_push($rowSet2,$rows2); }
		}

		$headerRows = array();
		$colCount = 0;
		$headerCount = 0;
		$headerRowStart = array(
			array(
				'width'			=> "8%",
				'data'			=> $propertyName,
				'border'		=> "LRTB",
				'fill'			=> 1,
				'fillColor'	=> $cColLt
			)
		);

		$headerRows[$headerCount] = $headerRowStart;
		$colMax = count($dateList);

		foreach ( $dateList as $dateItem ) {
			if ( $dateItem['weekDay'] == "Sun" || $dateItem['weekDay'] == "Sat" ) {
				$cellColour = $cColDk;
			} else {
				$cellColour = $cColLt;
			}

			array_push($headerRows[$headerCount], array(
				'width'			=> "13%",
				'data'			=> "<B>" . $dateItem['weekDay'] ."</B>, ".$dateItem['dateFormat']. " ($dateItem[adultCount]A, $dateItem[childCount]C)",
				'border'		=> "LRTB",
				'fill'			=> 1,
				'fillColor'	=> $cellColour,
				'align'			=> "C"
			));

			$colCount++;
			
			if ( $colCount > 6 && $colCount < $colMax ) {
				$colCount = 0;
				$headerCount++;
				$headerRows[$headerCount] = $headerRowStart;				
			}
		}

		for ( $count = 0; $count < sizeof($headerRows); $count++ ) {
			//$pdf->SetFont("Arial","",8);
			$pdf->Row($headerRows[$count]);
			$pdf->SetFont("Arial","",7);
			for ( $count2 = 0; $count2 < sizeof($dataRows); $count2++ ) {
				$pdf->Row($dataRows[$count2][$count]);
				$pdf->Row($dataRows2[$count2][$count]);
			}
		}

		$pdfWarningTop = array(
			array(
				'width'			=> "100%",
				'height'		=> "1",
				'data'			=> "",
				'border'		=> "LRT",
				'fill'			=> 1,
				'fillColor'	=> $cProvExpire,
				'align'			=> "C"
			)
		);

		$pdfWarningTitle = array(
			array(
				'width'			=> "100%",
				'data'			=> "WARNING!",
				'border'		=> "LR",
				'fill'			=> "1",
				'fillColor'	=> $cProvExpire,
				'align'			=> "C"
			)
		);

		$pdfWarningBot = array(
			array(
				'width'			=> "100%",
				'height'		=> "1",
				'data'			=> "",
				'border'		=> "LRB",
				'fill'			=> "1",
				'fillColor'	=> $cProvExpire,
				'align'			=> "C"
			)
		);

		$pdfWarning = array();

		foreach( $warnings as $k => $w ) {
			if ( trim($w) != "" ) {
				array_push($pdfWarning,array(
					'width'			=> "100%",
					'data'			=> $w,
					'border'		=> "LR",
					'fill'			=> "1",
					'fillColor'	=> $cProvExpire,
					'align'			=> "C"
				));
			}
		}

		if ( count($pdfWarning) > 0 ) {
			$pdf->Ln(4);
			$pdf->SetFont("Arial","",10);
			$pdf->SetTextColor(0xff,0xff,0xff);
			$pdf->Row($pdfWarningTop);
			$pdf->Row($pdfWarningTitle);
			foreach ( $pdfWarning as $p ) {
				$pdf->Row(array($p));
			}
			$pdf->Row($pdfWarningBot);
		}
		$pdf->SetFont("Arial","",4);
		$pdf->SetTextColor(0x00,0x00,0x00);

		$pdf->Ln(4);

	}

	$pdfFontSize = 8;
	$pdf->SetFont('Arial', '', $pdfFontSize);
	$pdf->SetFont('Arial', '', 8);

	$pdf->Ln(5);

	if ( $reportType == "summary" ) {
		if ( $options & REP_PAX_SUMM ) {

			( $firstpage ) ? $firstpage = false : $pdf->AddPage();
			
			$pdf->Row(array(
				array('data'=>"PAX Summary")
			));

			$pdf->Ln(1);

			$pdf->Row(array(
				array('data' => "",						'width' => "20%",								'fill' => 1,	'border' => "LTR"),
				array('data' => "In-House",		'width' => "20%",	'align' => "C",	'fill' => 1,	'border' => "LTRB"),
				array('data' => "Arrive",			'width' => "15%",	'align' => "C",	'fill' => 1,	'border' => "LTRB"),
				array('data' => "Stay Over",	'width' => "15%",	'align' => "C",	'fill' => 1,	'border' => "LTRB"),
				array('data' => "Depart",			'width' => "15%",	'align' => "C",	'fill' => 1,	'border' => "LTRB")
			));

			$pdf->Row(array(
				array('data' => "Date",		'width' => "20%",								'fill' => 1,	'border'=>"LR"),
				array('data' => "Rooms",	'width' => "5%",	'align' => "C",	'fill' => 1,	'border'=>"LRT"),
				array('data' => "Room %",	'width' => "5%",	'align' => "C",	'fill' => 1,	'border'=>"LRT"),
				array('data' => "PAX",		'width' => "10%",	'align' => "C",	'fill' => 1,	'border'=>"LRTB"),
				array('data' => "Rooms",	'width' => "5%",	'align' => "C",	'fill' => 1,	'border'=>"LRT"),
				array('data' => "PAX",		'width' => "10%",	'align' => "C",	'fill' => 1,	'border'=>"LRTB"),
				array('data' => "Rooms",	'width' => "5%",	'align' => "C",	'fill' => 1,	'border'=>"LRT"),
				array('data' => "PAX",		'width' => "10%",	'align' => "C",	'fill' => 1,	'border'=>"LRTB"),
				array('data' => "Rooms",	'width' => "5%",	'align' => "C",	'fill' => 1,	'border'=>"LRT"),
				array('data' => "PAX",		'width' => "10%",	'align' => "C",	'fill' => 1,	'border'=>"LRTB")
    	));
    
    	$pdf->Row(array(
    		array('data' => "",				'width' => "20%",								'fill' => 1,	'border' => "LRB"),
    		array('data' => "",				'width' => "5%",								'fill' => 1,	'border' => "LRB"),
    		array('data' => "",				'width' => "5%",								'fill' => 1,	'border' => "LRB"),
    		array('data' => "Adlts",	'width' => "3%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
    		array('data' => "Chld",		'width' => "3%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
    		array('data' => "Total",	'width' => "4%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
    		array('data' => "",				'width' => "5%",								'fill' => 1,	'border' => "LRB"),
    		array('data' => "Adlts",	'width' => "3%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
    		array('data' => "Chld",		'width' => "3%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
    		array('data' => "Total",	'width' => "4%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
    		array('data' => "",				'width' => "5%",								'fill' => 1,	'border' => "LRB"),
    		array('data' => "Adlts",	'width' => "3%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
    		array('data' => "Chld",		'width' => "3%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
    		array('data' => "Total",	'width' => "4%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
    		array('data' => "",				'width' => "5%",								'fill' => 1,	'border' => "LRB"),
    		array('data' => "Adlts",	'width' => "3%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
    		array('data' => "Chld",		'width' => "3%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
    		array('data' => "Total",	'width' => "4%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
    		
    	));

			foreach($paxArray as $paxItem) {
				// Make nice happy zeros if there is no data --------------------------
				if ( $paxItem['arrive']['accommCount'] 		== "" ) { $paxItem['arrive']['accommCount'] 	= "0"; }
    		if ( $paxItem['arrive']['adultCount']			== "" ) { $paxItem['arrive']['adultCount'] 		= "0"; }
				if ( $paxItem['arrive']['childCount'] 		== "" ) { $paxItem['arrive']['childCount'] 		= "0"; }

				if ( $paxItem['stayover']['accommCount']	== "" ) { $paxItem['stayover']['accommCount'] = "0"; }
    		if ( $paxItem['stayover']['adultCount']		== "" ) { $paxItem['stayover']['adultCount'] 	= "0"; }
				if ( $paxItem['stayover']['childCount'] 	== "" ) { $paxItem['stayover']['childCount'] 	= "0"; }

				if ( $paxItem['depart']['accommCount'] 		== "" ) { $paxItem['depart']['accommCount'] 	= "0"; }
				if ( $paxItem['depart']['adultCount']			== "" ) { $paxItem['depart']['adultCount'] 		= "0"; }
				if ( $paxItem['depart']['childCount'] 		== "" ) { $paxItem['depart']['childCount'] 		= "0"; }

				$pdf->Row(array(
					array('data' => chng_date($paxItem['date'],'-'),			'width' => "20%",								'border' => "LRTB"),
					array('data' => $paxItem['inHouse']['accommCount'],		'width' => "5%",								'border' => "LRB"),
					array('data' => $paxItem['inHouse']['roomPerc'],			'width' => "5%",								'border' => "LRB"),
					array('data' => $paxItem['inHouse']['adultCount'],		'width' => "3%",	'align' => "C",	'border' => "LRTB"),
					array('data' => $paxItem['inHouse']['childCount'],		'width' => "3%",	'align' => "C",	'border' => "LRTB"),
					array('data' => $paxItem['inHouse']['totalCount'],		'width' => "4%",	'align' => "C",	'border' => "LRTB"),
					array('data' => $paxItem['arrive']['accommCount'],		'width' => "5%",								'border' => "LRB"),
					array('data' => $paxItem['arrive']['adultCount'],			'width' => "3%",	'align' => "C",	'border' => "LRTB"),
					array('data' => $paxItem['arrive']['childCount'],			'width' => "3%",	'align' => "C",	'border' => "LRTB"),
					array('data' => $paxItem['arrive']['totalCount'],			'width' => "4%",	'align' => "C",	'border' => "LRTB"),
					array('data' => $paxItem['stayover']['accommCount'],	'width' => "5%",								'border' => "LRB"),
					array('data' => $paxItem['stayover']['adultCount'],		'width' => "3%",	'align' => "C",	'border' => "LRTB"),
					array('data' => $paxItem['stayover']['childCount'],		'width' => "3%",	'align' => "C",	'border' => "LRTB"),
					array('data' => $paxItem['stayover']['totalCount'],		'width' => "4%",	'align' => "C",	'border' => "LRTB"),
					array('data' => $paxItem['depart']['accommCount'],		'width' => "5%",								'border' => "LRB"),
					array('data' => $paxItem['depart']['adultCount'],			'width' => "3%",	'align' => "C",	'border' => "LRTB"),
					array('data' => $paxItem['depart']['childCount'],			'width' => "3%",	'align' => "C",	'border' => "LRTB"),
					array('data' => $paxItem['depart']['totalCount'],			'width' => "4%",	'align' => "C",	'border' => "LRTB"),
				));
			}

			$pdf->Row(array(
				array('data' => "Total",														'width' => "20%",								'border' => "LRTB",'style' => "B"),
				array('data' => $paxTotals['inHouseAccommCount'],		'width' => "5%",								'border' => "LRTB"),
				array('data' => "",																	'width' => "5%",								'border' => "LRB"),
				array('data' => $paxTotals['inHouseAdultCount'],		'width' => "3%",	'align' => "C",	'border' => "LRTB"),
				array('data' => $paxTotals['inHouseChildCount'],		'width' => "3%",	'align' => "C",	'border' => "LRTB"),
				array('data' => $paxTotals['inHouseTotalCount'],		'width' => "4%",	'align' => "C",	'border' => "LRTB"),
				array('data' => $paxTotals['arriveAccommCount'],		'width' => "5%",								'border' => "LRB"),
				array('data' => $paxTotals['arriveAdultCount'],			'width' => "3%",	'align' => "C",	'border' => "LRTB"),
				array('data' => $paxTotals['arriveChildCount'],			'width' => "3%",	'align' => "C",	'border' => "LRTB"),
				array('data' => $paxTotals['arriveTotalCount'],			'width' => "4%",	'align' => "C",	'border' => "LRTB"),
				array('data' => $paxTotals['stayoverAccommCount'],	'width' => "5%",								'border' => "LRB"),
				array('data' => $paxTotals['stayoverAdultCount'],		'width' => "3%",	'align' => "C",	'border' => "LRTB"),
				array('data' => $paxTotals['stayoverChildCount'],		'width' => "3%",	'align' => "C",	'border' => "LRTB"),
				array('data' => $paxTotals['stayoverTotalCount'],		'width' => "4%",	'align' => "C",	'border' => "LRTB"),
				array('data' => $paxTotals['departAccommCount'],		'width' => "5%",								'border' => "LRB"),
				array('data' => $paxTotals['departAdultCount'],			'width' => "3%",	'align' => "C",	'border' => "LRTB"),
				array('data' => $paxTotals['departChildCount'],			'width' => "3%",	'align' => "C",	'border' => "LRTB"),
				array('data' => $paxTotals['departTotalCount'],			'width' => "4%",	'align' => "C",	'border' => "LRTB"),
			));

			$pdf->Ln(4);
		}  

		if ( $options & RES_CHART ) {

			( $firstpage ) ? $firstpage = false : $pdf->AddPage();

			$pdf->Row(array(array('data'=>"Reservation Chart")));
			$pdf->Ln(1);

			$tableMax = 7;
			$tableCount = sizeof($dateArray) / $tableMax;

			for ( $count = 0; $count < $tableCount; $count++ ) {
				$headerRow1 = array(
					array(
						'data'		=> "",
						'width'		=> "5.5%",
						'fill'		=> 1,
						'border'	=> "LRT"
					)
				);

				$headerRow2 = array(
					array(
						'data'		=> "Accomm",
						'width'		=> "5.5%",
						'fill'		=> 1,
						'border'	=> "LR"
					)
				);

				$headerRow3 = array(
					array(
						'data'		=>"",
						'width'		=>"5.5%",
						'fill'		=>1,
						'border'	=>"LRB"
					)
				);

				for ( $dateCount = ($count * $tableMax); $dateCount < ( ($count * $tableMax) + $tableMax); $dateCount++ ) {
					if ( $dateCount < sizeof($dateArray) ) {
						array_push($headerRow1,array('width' => "13.5%",	'data' => chng_date($dateArray[$dateCount],"-"),				'align' => "C",	'fill' => 1,	'border' => "LRT"));
						array_push($headerRow2,array('width' => "13.5%",	'data' => date("D",strtotime($dateArray[$dateCount])),	'align' => "C",	'fill' => 1,	'border' => "LRB"));

						array_push($headerRow3,
							array('width' => "2.5%",	'data' => "Rm",					'fill' => 1,	'border' => "LRTB",	'align' => "C"),
							array('width' => "7%",		'data' => "Res Detail",	'fill' => 1,	'border' => "LRTB"),
							array('width' => "2%",		'data' => "Ad",					'fill' => 1,	'border' => "LRTB",	'align' => "C"),
							array('width' => "2%",		'data' => "Ch",					'fill' => 1,	'border' => "LRTB",	'align' => "C")
						);
					}
				}
				$pdf->Row($headerRow1);
				$pdf->Row($headerRow2);
				$pdf->Row($headerRow3);

				foreach ( $resSummaryArray as $sumKey => $sumItem ) {
					$max = 0;
					for ( $dateCount = ($count * $tableMax); $dateCount < ( ($count * $tableMax) + $tableMax); $dateCount++ ) {
						if ( sizeof($sumItem[$dateArray[$dateCount]]) > $max ) {
							$max = sizeof($sumItem[$dateArray[$dateCount]]);
						}
					}

					for ( $resCount = 0; $resCount < $max; $resCount++ ) {
						if ( ($resCount+1) == $max ) {
							$borderExtra = "B";
						} else {
							$borderExtra = "";
						}

						if ( $resCount == 0 ) {
							$dataRow = array(array('data'=>$sumKey, 'width'=>"5.5%", 'border'=>"TLR".$borderExtra, 'fill'=>1));
						} else {
							$dataRow = array(array('data'=>"", 'width'=>"5.5%", 'border'=>"LR".$borderExtra, 'fill'=>1));
						}

						for ( $dateCount = ($count * $tableMax); $dateCount < ( ($count * $tableMax) + $tableMax); $dateCount++ ) {
							if ( $dateCount < sizeof($dateArray) ) {
								$resItem = $sumItem[$dateArray[$dateCount]][$resCount];

								$compList = "";
								$compSql = $lDB->get("
									SELECT
										rt_component.rt_component_abbrv as compAbbr
									FROM 
										rv_res_item_comp
									INNER JOIN rt_component ON 
										rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
									WHERE 
										rv_res_item_comp.rv_reservation_item_id = '" . $resItem['rv_reservation_item_ix'] . "'
									AND 
										rv_res_item_comp.rv_item_comp_option_yn = '1'
									ORDER BY 
										rt_component.rt_component_ix
								",3);

								if ( sizeof($compSql) > 0 ) {
									$compList = "(".join($compSql,", ").") ";
								}

								$g = getGuestNames($resItem['rv_res_item_group_ix']);

								$gNames = str_replace("<BR>",", ",$g['guestName']);

								if ( $resItem['rv_item_accomm_count'] != "0" && trim($resItem['rv_item_accomm_count']) != "" ) {
									if ( trim($resItem['rv_agent_ref']) != "" ) {
										$voucher = " Vouch: " . $resItem['rv_agent_ref'];
									} else {
										$voucher = "";
									}

									array_push($dataRow,
										array('width' => "2.5%",	'data' => $resItem['rv_item_accomm_count'],																																				'border' => "LRTB",	'align'=>"C"),
										array('width' => "7%",		'data' => $resItem['rv_reservation_ix'] .": ". $resItem['rv_res_name']." " . $gNames . " " . $compList.$voucher,	'border' => "LRTB"),
										array('width' => "2%",		'data' => $resItem['rv_item_adult_count'],																																				'border' => "LRTB",	'align'=>"C"),
										array('width' => "2%",		'data' => $resItem['rv_item_child_count'],																																				'border' => "LRTB",	'align'=>"C")
									);
								} else {
									array_push($dataRow,
										array('width' => "2.5%",	'data' => "",	'border' => "LRTB"),
										array('width' => "7%",		'data' => "",	'border' => "LRTB"),
										array('width' => "2%",		'data' => "",	'border' => "LRTB"),
										array('width' => "2%",		'data' => "",	'border' => "LRTB")
									);
								}
							}
						}
						$pdf->Row($dataRow);
					}
				}
				$pdf->Ln(1);
			}
			$pdf->Ln(4);
		}

		if ( $options & REP_ROOM_SUMM ) {

			( $firstpage ) ? $firstpage = false : $pdf->AddPage();

			$pdf->Row(array(array('data'=>"Rooming Summary (planned) ")));
			$pdf->Ln(1);

			$tableMax = 7;
			$tableCount = sizeof($dateArray) / $tableMax;

			for ( $count = 0; $count < $tableCount; $count++ ) {
				$headerRow1 = array(array('data' => "",				'width' => "5.5%",	'fill' => 1,	'border' => "LRT"));
    		$headerRow2 = array(array('data' => "Accomm",	'width' => "5.5%",	'fill' => 1,	'border' => "LR"));
    		$headerRow3 = array(array('data' => "",				'width' => "5.5%",	'fill' => 1,	'border' => "LRB"));

				for ( $dateCount = ($count * $tableMax); $dateCount < ( ($count * $tableMax) + $tableMax); $dateCount++ ) {
					if ( $dateCount < sizeof($dateArray) ) {
						array_push($headerRow1,array('width' => "13.5%",	'data' => chng_date($dateArray[$dateCount],"-"),				'align' => "C",	'fill' => 1,	'border' => "LRT"));
						array_push($headerRow2,array('width' => "13.5%",	'data' => date("D",strtotime($dateArray[$dateCount])),	'align' => "C",	'fill' => 1,	'border' => "LRB"));

						array_push($headerRow3,
							array('width' => "9.5%",	'data' => "Res Detail",	'fill' => 1,	'border' => "LRTB"),
							array('width' => "2%",		'data' => "Ad",					'fill' => 1,	'border' => "LRTB"),
							array('width' => "2%",		'data' => "Ch",					'fill' => 1,	'border' => "LRTB")
						);
					}
				}
				$pdf->Row($headerRow1);
				$pdf->Row($headerRow2);
				$pdf->Row($headerRow3);

				$provRow = array();
				$provCount = 0;
				$expiredProv = "Some of the allocated reservations displayed have passed their provisional expiry date";

				foreach ( $roomSummaryArray as $roomItem ) {
					$blockRooms = $lDB->get("
						SELECT 
							ac_accomm_room_block.ac_accomm_room_id,
							ac_accomm_block.ac_start_date,
							ac_accomm_block.ac_end_date
						FROM 
							ac_accomm_room_block
						INNER JOIN ac_accomm_block ON 
							ac_accomm_block.ac_accomm_block_ix = ac_accomm_room_block.ac_accomm_block_id 
						WHERE 
							ac_accomm_room_block.ac_accomm_room_id = '" . $roomItem['ac_accomm_room_ix'] . "'
						AND 
							(
								(
									ac_accomm_block.ac_start_date >= '" . $fromDate['jsDate'] . "'
									AND 
									ac_accomm_block.ac_start_date <= '" . $toDate['jsDate'] . "'
								)
								OR
								(
									ac_accomm_block.ac_end_date >= '" . $fromDate['jsDate'] . "'
									AND 
									ac_accomm_block.ac_end_date <= '" . $toDate['jsDate'] . "'
								)
								OR
								(
									ac_accomm_block.ac_start_date < '" . $fromDate['jsDate'] . "'
									AND 
									ac_accomm_block.ac_end_date > '" . $toDate['jsDate'] . "'
								)
							)
					",1);
					$shortName = "";
					$noResRoom = 0;

					for ( $dateCount = ($count * $tableMax); $dateCount < ( ($count * $tableMax) + $tableMax); $dateCount++ ) {
						if ( $dateCount < sizeof($dateArray) ) {
							$item = $roomItem['items'][$dateArray[$dateCount]];

							if ( $item['rv_reservation_item_ix'] != "" ) {
								$noResRoom ++;
							}
						}
					}

					if ( $noResRoom > 0 ) {
						if ( trim($roomItem['ac_accomm_name_short']) != "" && $roomItem['ac_accomm_name_short'] != "0" ) {
							$shortName = " (".$roomItem['ac_accomm_name_short'].")";
						}
						
						$dataRow = array(array('width' => "5.5%", 'data' => $roomItem['ac_desc'] . $shortName, 'fill' => 1, 'border' => "LRTB"));
						
						for ( $dateCount = ($count * $tableMax); $dateCount < ( ($count * $tableMax) + $tableMax); $dateCount++ ) {
							if ( $dateCount < sizeof($dateArray) ) {
								$item = $roomItem['items'][$dateArray[$dateCount]];
								$compList = "";
								$compSql = $lDB->get("
									SELECT
										rt_component.rt_component_abbrv AS compAbbr
									FROM 
										rv_res_item_comp
									INNER JOIN rt_component ON 
										rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
									WHERE 
										rv_res_item_comp.rv_reservation_item_id = '" . $item['rv_reservation_item_ix'] . "'
									AND 
										rv_res_item_comp.rv_item_comp_option_yn = '1'
									ORDER BY 
										rt_component.rt_component_ix
								",3);

								if ( sizeof($compSql) > 0 ) {
									$compList = "(".join($compSql,", ").") ";
								}

								$g = getGuestNames($item['groupId']);
								$gNames = str_replace("<BR>",", ",$g['guestName']);

								$block = "";
								$fill = "0";

								if ( $dateArray[$dateCount] >= $blockRooms['ac_start_date'] && $dateArray[$dateCount] <= $blockRooms['ac_end_date'] ) {
									$block = array(0xe4,0xe3,0xe3);
									$fill = "1";
								}

								if ( $item['rf_reservation_status_id'] == "20" ) {
									if ( $item['rv_provision_expiry_date'] < date("Y-m-d") ) {
										$provCount ++;
									}
								}
								
								if ( $item['rv_reservation_ix'] != "" ) {
									if ( trim($item['rv_agent_ref']) != "" ) {
										$voucher = " Vouch: " . $item['rv_agent_ref'];
									} else {
										$voucher = "";
									}

									array_push($dataRow,
										array('width' => "9.5%",	'data' => $item['rv_reservation_ix'] .": ".$item['rv_res_name']." \n".$gNames." ".$compList. $voucher,	'border' => "LRTB",	'fill' => $fill,	'fillColor' => $block),
										array('width' => "2%",		'data' => $item['rv_item_adult_count'],	'border' => "LRTB",	'fill' => $fill,	'fillColor' => $block),
										array('width' => "2%",		'data' => $item['rv_item_child_count'],	'border' => "LRTB",	'fill' => $fill,	'fillColor' => $block)
									);
								} else {
									array_push($dataRow,
										array('width' => "9.5%",	'data' => "",	'border' => "LRTB",	'fill' => $fill,	'fillColor' => $block),
										array('width' => "2%",		'data' => "",	'border' => "LRTB",	'fill' => $fill,	'fillColor' => $block),
										array('width' => "2%",		'data' => "",	'border' => "LRTB",	'fill' => $fill,	'fillColor' => $block)
									);
								}
							}
						}
						$pdf->Row($dataRow);
					}
				}
				$pdf->Ln(1);

				if ( $provCount > 0 ) {
					$pdf->Row(array(array('data'=>$expiredProv)));
				}

				$noRooms = "";

				$pdf->Row(array(array('data'=>$noRooms)));
				$pdf->Ln(1);
			}
			$pdf->Ln(4);
		}

		if ( $options & REP_SUMM_EXTRAS ) {

			( $firstpage ) ? $firstpage = false : $pdf->AddPage();

			$pdf->Row(array(array('data'=>"Extras summary")));

			$pdf->Ln(1);

			$pdf->Row(array(array('width'=>"100%",'data'=>"Details", 'border'=>"LRTB", 'fill'=>1)));

			$pdf->Row(array(
				array('width' => "9%",	'data' => "Service Date",	'border' => "LRTB",	'fill' => 1),
				array('width' => "5%",	'data' => "Travel",				'border' => "LRTB",	'fill' => 1,	'align' => "C"),        
				array('width' => "12%",	'data' => "Category",			'border' => "LRTB",	'fill' => 1),
				array('width' => "18%",	'data' => "Extra",				'border' => "LRTB",	'fill' => 1),
				array('width' => "6%",	'data' => "ETD",				'border' => "LRTB",	'fill' => 1),
				array('width' => "6%",	'data' => "ETA",				'border' => "LRTB",	'fill' => 1),
				array('width' => "26%",	'data' => "Reservation",	'border' => "LRTB",	'fill' => 1),
				array('width' => "5%",	'data' => "Qty",					'border' => "LRTB",	'fill' => 1,	'align' => "R"),
				array('width' => "5%",	'data' => "Room",					'border' => "LRTB",	'fill' => 1,	'align' => "R"),
				array('width' => "4%",	'data' => "Note",					'border' => "LRTB",	'fill' => 1,	'align' => "C"),
				array('width' => "4%",	'data' => "Memo",					'border' => "LRTB",	'fill' => 1,	'align' => "C")
			));

			$lastDate = "";
			$lastCat = "";

			foreach ( $eArray as $extrasSumm ) {
				if ( $lastDate == $extrasSumm['rv_extra_date_serv'] ) {
					$extrasSumm['servDate'] = "";
				} else {
					$extrasSumm['servDate'] = chng_date($extrasSumm['rv_extra_date_serv'],"-");
				}

				$extrasSumm['travInd'] = "";

				if ( $extrasSumm['ac_extra_cat_ind'] == 2 ) {
					$extrasSumm['travInd'] = "x";
				}

				if ( $lastCat == $extrasSumm['ac_extra_cat_desc'] ) {
					$extrasSumm['catDesc'] = "";
				} else {
					$extrasSumm['catDesc'] = $extrasSumm['ac_extra_cat_desc'];
				}

				$extrasSumm['extraSummNote'] = "";

				if ( trim($extrasSumm['rv_extra_note']) != "" ) {
					$extrasSumm['extraSummNote'] = "x";
				}

				$extrasSumm['extraSummIntNote'] = "";

				if ( trim($extrasSumm['rv_extra_note_internal']) != "" ) {
					$extrasSumm['extraSummIntNote'] = "x";
				}
                
				$pdf->Row(array(
					array('width' => "9%", 'data' => $extrasSumm['servDate'], 'border' => "LRTB"),
					array('width' => "5%", 'data' => $extrasSumm['travInd'], 'border' => "LRTB", 'align'=>"C"),
					array('width' => "12%", 'data' => $extrasSumm['catDesc'], 'border' => "LRTB"),
					array('width' => "18%", 'data' => $extrasSumm['ac_ext_desc'], 'border' => "LRTB"),
					array('width' => "6%", 'data' => $extrasSumm['rv_extra_travel_etd'], 'border' => "LRTB"),
					array('width' => "6%", 'data' => $extrasSumm['rv_extra_travel_eta'], 'border' => "LRTB"),
					array('width' => "26%", 'data' => $extrasSumm['rv_reservation_ix'] .": " .$extrasSumm['rv_res_name'], 'border' => "LRTB"),
					array('width' => "5%", 'data' => $extrasSumm['rv_extra_units'], 'border' => "LRTB", 'align'=>"R"),
					array('width' => "5%", 'data' => $extrasSumm['ac_desc'], 'border' => "LRTB", 'align'=>"R"),
					array('width' => "4%", 'data' => $extrasSumm['extraSummNote'], 'border' => "LRTB", 'align'=>"C"),
					array('width' => "4%", 'data' => $extrasSumm['extraSummIntNote'], 'border' => "LRTB", 'align'=>"C"),
				));

				$lastDate	= $extrasSumm['rv_extra_date_serv'];
				$lastCat	= $extrasSumm['ac_extra_cat_desc'];
			}
		}
	}

	if ( $reportType == "daySheet" ) {
		$first = "";

		foreach ( $dateArray as $dateItem ) {
			if ( $first != "" ) {
				// Add page break - set to Portrait ---------------------------------------
				$pdf->AddPage('L');
			}

			$pdf->SetFont('Arial', 'B', 8);
			$pdf->Row(array(array('data'=>"Day Sheet for ".$propertyName." - ".chng_date($dateItem,"-"))));  

			$pdf->Ln(2);
			$pdf->SetFont('Arial', '', 7);

			if ( $options & REP_PAX ) {

				( $firstpage ) ? $firstpage = false : $pdf->AddPage();

				$pdf->AddPage();
				$pdf->Row(array(array('data'=>"PAX Analysis")));

				$pdf->Ln(1);

				$pdf->Row(array(
					array('data' => "",						'width' => "20%",								'fill' => 1,	'border' => "LTR"),
					array('data' => "In-House",		'width' => "20%",	'align' => "C",	'fill' => 1,	'border' => "LTRB"),
					array('data' => "Arrive",			'width' => "15%",	'align' => "C",	'fill' => 1,	'border' => "LTRB"),
					array('data' => "Stay Over",	'width' => "15%",	'align' => "C",	'fill' => 1,	'border' => "LTRB"),
					array('data' => "Depart",			'width' => "15%",	'align' => "C",	'fill' => 1,	'border' => "LTRB")
				));

				$pdf->Row(array(
					array('data' => "Accomm",	'width' => "20%",								'fill' => 1,	'border' => "LR"),
					array('data' => "Rooms",	'width' => "5%",	'align' => "C",	'fill' => 1,	'border' => "LRT"),
					array('data' => "Room %",	'width' => "5%",	'align' => "C",	'fill' => 1,	'border' => "LRT"),
					array('data' => "PAX",		'width' => "10%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
					array('data' => "Rooms",	'width' => "5%",	'align' => "C",	'fill' => 1,	'border' => "LRT"),
					array('data' => "PAX",		'width' => "10%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
					array('data' => "Rooms",	'width' => "5%",	'align' => "C",	'fill' => 1,	'border' => "LRT"),
					array('data' => "PAX",		'width' => "10%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
					array('data' => "Rooms",	'width' => "5%",	'align' => "C",	'fill' => 1,	'border' => "LRT"),
					array('data' => "PAX",		'width' => "10%",	'align' => "C",	'fill' => 1,	'border' => "LRTB")
				));

				$pdf->Row(array(
					array('data' => "",				'width' => "20%",								'fill' => 1,	'border' => "LRB"),
					array('data' => "",				'width' => "5%",								'fill' => 1,	'border' => "LRB"),
					array('data' => "",				'width' => "5%",								'fill' => 1,	'border' => "LRB"),
					array('data' => "Adlts",	'width' => "3%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
					array('data' => "Chld",		'width' => "3%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
					array('data' => "Total",	'width' => "4%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
					array('data' => "",				'width' => "5%",								'fill' => 1,	'border' => "LRB"),
					array('data' => "Adlts",	'width' => "3%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
					array('data' => "Chld",		'width' => "3%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
					array('data' => "Total",	'width' => "4%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
					array('data' => "",				'width' => "5%",								'fill' => 1,	'border' => "LRB"),
					array('data' => "Adlts",	'width' => "3%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
					array('data' => "Chld",		'width' => "3%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
					array('data' => "Total",	'width' => "4%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
					array('data' => "",				'width' => "5%",								'fill' => 1,	'border' => "LRB"),
					array('data' => "Adlts",	'width' => "3%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
					array('data' => "Chld",		'width' => "3%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
					array('data' => "Total",	'width' => "4%",	'align' => "C",	'fill' => 1,	'border' => "LRTB"),
				));

				foreach ( $dayPaxArray[$dateItem] as $paxItem ) {
					$pdf->Row(array(
						array('data' => $paxItem['ac_accomm_desc'],						'width' => "20%",								'border' => "LRTB"),
						array('data' => $paxItem['inHouse']['accommCount'],		'width' => "5%",								'border' => "LRB"),
						array('data' => $paxItem['inHouse']['roomPerc'],			'width' => "5%",								'border' => "LRB"),
						array('data' => $paxItem['inHouse']['adultCount'],		'width' => "3%",	'align' => "C",	'border' => "LRTB"),
						array('data' => $paxItem['inHouse']['childCount'],		'width' => "3%",	'align' => "C",	'border' => "LRTB"),
						array('data' => $paxItem['inHouse']['totalCount'],		'width' => "4%",	'align' => "C",	'border' => "LRTB"),
						array('data' => $paxItem['arrive']['accommCount'],		'width' => "5%",								'border' => "LRB"),
						array('data' => $paxItem['arrive']['adultCount'],			'width' => "3%",	'align' => "C",	'border' => "LRTB"),
						array('data' => $paxItem['arrive']['childCount'],			'width' => "3%",	'align' => "C",	'border' => "LRTB"),
						array('data' => $paxItem['arrive']['totalCount'],			'width' => "4%",	'align' => "C",	'border' => "LRTB"),
						array('data' => $paxItem['stayover']['accommCount'],	'width' => "5%",								'border' => "LRB"),
						array('data' => $paxItem['stayover']['adultCount'],		'width' => "3%",	'align' => "C",	'border' => "LRTB"),
						array('data' => $paxItem['stayover']['childCount'],		'width' => "3%",	'align' => "C",	'border' => "LRTB"),
						array('data' => $paxItem['stayover']['totalCount'],		'width' => "4%",	'align' => "C",	'border' => "LRTB"),
						array('data' => $paxItem['depart']['accommCount'],		'width' => "5%",								'border' => "LRB"),
						array('data' => $paxItem['depart']['adultCount'],			'width' => "3%",	'align' => "C",	'border' => "LRTB"),
						array('data' => $paxItem['depart']['childCount'],			'width' => "3%",	'align' => "C",	'border' => "LRTB"),
						array('data' => $paxItem['depart']['totalCount'],			'width' => "4%",	'align' => "C",	'border' => "LRTB"),
					));
				}

				$pdf->Row(array(
					array('data' => "Total",'width' => "20%",'border' => "LRTB",'style' => "B"),
					array('data' => $dayPaxTotalArray[$dateItem]['inHouseAccommCount'],		'width' => "5%",								'border' => "LRTB"),
					array('data' => "",																										'width' => "5%",								'border' => "LRB"),
					array('data' => $dayPaxTotalArray[$dateItem]['inHouseAdultCount'],		'width' => "3%",	'align' => "C",	'border' => "LRTB"),
					array('data' => $dayPaxTotalArray[$dateItem]['inHouseChildCount'],		'width' => "3%",	'align' => "C",	'border' => "LRTB"),
					array('data' => $dayPaxTotalArray[$dateItem]['inHouseTotalCount'],		'width' => "4%",	'align' => "C",	'border' => "LRTB"),
					array('data' => $dayPaxTotalArray[$dateItem]['arriveAccommCount'],		'width' => "5%",								'border' => "LRB"),
					array('data' => $dayPaxTotalArray[$dateItem]['arriveAdultCount'],			'width' => "3%",	'align' => "C",	'border' => "LRTB"),
					array('data' => $dayPaxTotalArray[$dateItem]['arriveChildCount'],			'width' => "3%",	'align' => "C",	'border' => "LRTB"),
					array('data' => $dayPaxTotalArray[$dateItem]['arriveTotalCount'],			'width' => "4%",	'align' => "C",	'border' => "LRTB"),
					array('data' => $dayPaxTotalArray[$dateItem]['stayoverAccommCount'],	'width' => "5%",								'border' => "LRB"),
					array('data' => $dayPaxTotalArray[$dateItem]['stayoverAdultCount'],		'width' => "3%",	'align' => "C",	'border' => "LRTB"),
					array('data' => $dayPaxTotalArray[$dateItem]['stayoverChildCount'],		'width' => "3%",	'align' => "C",	'border' => "LRTB"),
					array('data' => $dayPaxTotalArray[$dateItem]['stayoverTotalCount'],		'width' => "4%",	'align' => "C",	'border' => "LRTB"),
					array('data' => $dayPaxTotalArray[$dateItem]['departAccommCount'],		'width' => "5%",								'border' => "LRB"),
					array('data' => $dayPaxTotalArray[$dateItem]['departAdultCount'],			'width' => "3%",	'align' => "C",	'border' => "LRTB"),
					array('data' => $dayPaxTotalArray[$dateItem]['departChildCount'],			'width' => "3%",	'align' => "C",	'border' => "LRTB"),
					array('data' => $dayPaxTotalArray[$dateItem]['departTotalCount'],			'width' => "4%",	'align' => "C",	'border' => "LRTB"),
				));
				$pdf->Ln(4);
			}
			// [ END ] PAX -------------------------------------------------------------

			if ( $options & RES_SUMM) {

				( $firstpage ) ? $firstpage = false : $pdf->AddPage();

				$pdf->Row(array(array('data'=>"Reservation Summary")));

				$pdf->Ln(1);

				$pdf->Row(array(
					array('width' => "10%",	'data' => "Accommodation",	'fill' => 1,								'border' => "LRT"),
					array('width' => "30%",	'data' => "Arrive",					'fill' => 1,	'align' => "C",	'border' => "LRTB"),
					array('width' => "30%",	'data' => "Stay Over",			'fill' => 1,	'align' => "C",	'border' => "LRTB"),
					array('width' => "30%",	'data' => "Depart",					'fill' => 1,	'align' => "C",	'border' => "LRTB"),
				));

				$pdf->Row(array(
					array('width' => "10%",	'data' => "",							'fill' => 1,								'border' => "LRB"),
					array('width' => "3%", 	'data' => "Rms",					'fill' => 1,	'align' => "C",	'border' => "LRTB"),
					array('width' => "18%",	'data' => "Res Details",	'fill' => 1,	'align' => "C",	'border' => "LRTB"),
					array('width' => "3%",	'data' => "Ad",						'fill' => 1,	'align' => "C",	'border' => "LRTB"),
					array('width' => "3%",	'data' => "Ch",						'fill' => 1,	'align' => "C",	'border' => "LRTB"),
					array('width' => "3%",	'data' => "Tot",					'fill' => 1,	'align' => "C",	'border' => "LRTB"),
					array('width' => "3%",	'data' => "Rms",					'fill' => 1,	'align' => "C",	'border' => "LRTB"),
					array('width' => "18%",	'data' => "Res Details",	'fill' => 1,	'align' => "C",	'border' => "LRTB"),
					array('width' => "3%",	'data' => "Ad",						'fill' => 1,	'align' => "C",	'border' => "LRTB"),
					array('width' => "3%",	'data' => "Ch",						'fill' => 1,	'align' => "C",	'border' => "LRTB"),
					array('width' => "3%",	'data' => "Tot",					'fill' => 1,	'align' => "C",	'border' => "LRTB"),
					array('width' => "3%",	'data' => "Rms",					'fill' => 1,	'align' => "C",	'border' => "LRTB"),
					array('width' => "18%",	'data' => "Res Details",	'fill' => 1,	'align' => "C",	'border' => "LRTB"),
					array('width' => "3%",	'data' => "Ad",						'fill' => 1,	'align' => "C",	'border' => "LRTB"),
					array('width' => "3%",	'data' => "Ch",						'fill' => 1,	'align' => "C",	'border' => "LRTB"),
					array('width' => "3%",	'data' => "Tot",					'fill' => 1,	'align' => "C",	'border' => "LRTB")
				));

				foreach ( $dayResSummaryArray[$dateItem] as $sumItem ) {
					$max = sizeof($sumItem['arrive']);

					if ( sizeof($sumItem['stayover']) > $max ) {
						$max = sizeof($sumItem['stayover']);
					}
					
					if ( sizeof($sumItem['depart']) > $max ) {
						$max = sizeof($sumItem['depart']);
					}

					for ( $count = 0; $count < $max; $count++ ) {
						if ( $count == 0 ) {
							$accommName = $sumItem['ac_accomm_desc'];
						} else {
							$accommName = "";
						}

						$arriveTotal = (($sumItem['arrive'][$count]['rv_item_adult_count']*$sumItem['arrive'][$count]['rv_item_accomm_count']) + ($sumItem['arrive'][$count]['rv_item_child_count']*$sumItem['arrive'][$count]['rv_item_accomm_count']));

						if ( $arriveTotal == 0 ) {
							$arriveTotal = "";
						}

						$stayOverTotal = (($sumItem['stayover'][$count]['rv_item_adult_count']*$sumItem['stayover'][$count]['rv_item_accomm_count']) + ($sumItem['stayover'][$count]['rv_item_child_count']*$sumItem['stayover'][$count]['rv_item_accomm_count']));

						if ( $stayOverTotal == 0 ) {
							$stayOverTotal = "";
						}

						$departTotal = (($sumItem['depart'][$count]['rv_item_adult_count']*$sumItem['depart'][$count]['rv_item_accomm_count']) + ($sumItem['depart'][$count]['rv_item_child_count']*$sumItem['depart'][$count]['rv_item_accomm_count']));

						if ( $departTotal == 0 ) {
							$departTotal = "";
						}

						if ( trim($sumItem['arrive'][$count]['rv_agent_ref']) != "" ) {
							$arriveVoucher = " Vouch: " . $sumItem['arrive'][$count]['rv_agent_ref'];
						} else {
							$arriveVoucher = "";
						}

						if ( trim($sumItem['stayover'][$count]['rv_agent_ref']) != "" ) {
							$stayVoucher = " Vouch: " . $sumItem['stayover'][$count]['rv_agent_ref'];
						} else {
							$stayVoucher = "";
						}

						if ( trim($sumItem['depart'][$count]['rv_agent_ref']) != "" ) {
							$departVoucher = " Vouch: " . $sumItem['depart'][$count]['rv_agent_ref'];
						} else {
							$departVoucher = "";
						}

						$pdf->Row(array(
							array('width' => "10%",	'data' => $accommName,																												'border' => "LRTB"),
							array('width' => "3%",	'data' => $sumItem['arrive'][$count]['rv_item_accomm_count'],		'align' => "C",	'border' => "LRTB"),
							array('width' => "18%",	'data' => $sumItem['arrive'][$count]['rv_reservation_ix'] . " " . $sumItem['arrive'][$count]['rv_res_name'] . $arriveVoucher,	'border' => "LRTB"),
							array('width' => "3%",	'data' => $sumItem['arrive'][$count]['rv_item_adult_count'],		'align' => "C",	'border' => "LRTB"),
							array('width' => "3%",	'data' => $sumItem['arrive'][$count]['rv_item_child_count'],		'align' => "C",	'border' => "LRTB"),
							array('width' => "3%",	'data' => $arriveTotal,																					'align' => "C",	'border' => "LRTB"),
							array('width' => "3%",	'data' => $sumItem['stayover'][$count]['rv_item_accomm_count'],	'align' => "C",	'border' => "LRTB"),
							array('width' => "18%",	'data' => $sumItem['stayover'][$count]['rv_reservation_ix'] . " " . $sumItem['stayover'][$count]['rv_res_name'] . $stayVoucher,'border' => "LRTB"),
							array('width' => "3%",	'data' => $sumItem['stayover'][$count]['rv_item_adult_count'],	'align' => "C",	'border' => "LRTB"),
							array('width' => "3%",	'data' => $sumItem['stayover'][$count]['rv_item_child_count'],	'align' => "C",	'border' => "LRTB"),
							array('width' => "3%",	'data' => $stayOverTotal,																				'align' => "C",	'border' => "LRTB"),
							array('width' => "3%",	'data' => $sumItem['depart'][$count]['rv_item_accomm_count'],		'align' => "C",	'border' => "LRTB"),
							array('width' => "18%",	'data' => $sumItem['depart'][$count]['rv_reservation_ix'] . " " . $sumItem['depart'][$count]['rv_res_name'] . $departVoucher,'border' => "LRTB"),
							array('width' => "3%",	'data' => $sumItem['depart'][$count]['rv_item_adult_count'],		'align' => "C",	'border' => "LRTB"),
							array('width' => "3%",	'data' => $sumItem['depart'][$count]['rv_item_child_count'],		'align' => "C",	'border' => "LRTB"),
							array('width' => "3%",	'data' => $departTotal,																					'align' => "C",	'border' => "LRTB")
						));
					}
				}

				$aTotalRms		= $dayResSummaryTotalArray[$dateItem]['arriveRoom'];
				$aTotalAdlts	= $dayResSummaryTotalArray[$dateItem]['arriveAdult'];
				$aTotalChld		= $dayResSummaryTotalArray[$dateItem]['arriveChild'];
				$aTotal				= $dayResSummaryTotalArray[$dateItem]['arriveTotal'];

				$sTotalRms		= $dayResSummaryTotalArray[$dateItem]['stayoverRoom'];
				$sTotalAdlts	= $dayResSummaryTotalArray[$dateItem]['stayoverAdult'];
				$sTotalChld		= $dayResSummaryTotalArray[$dateItem]['stayoverChild'];
				$sTotal				= $dayResSummaryTotalArray[$dateItem]['stayoverTotal'];

				$dTotalRms		= $dayResSummaryTotalArray[$dateItem]['departRoom'];
				$dTotalAdlts	= $dayResSummaryTotalArray[$dateItem]['departAdult'];
				$dTotalChld		= $dayResSummaryTotalArray[$dateItem]['departChild'];
				$dTotal				= $dayResSummaryTotalArray[$dateItem]['departTotal'];        

				$pdf->Row(array(
					array('width' => "10%",	'data' => "Total",										'border' => "LRTB",	'style' => "B"),
					array('width' => "3%",	'data' => $aTotalRms,		'align' => "C",	'border' => "LRTB"),
					array('width' => "18%",	'data' => "",													'border' => "LRTB"),
					array('width' => "3%",	'data' => $aTotalAdlts,	'align' => "C",	'border' => "LRTB"),
					array('width' => "3%",	'data' => $aTotalChld,	'align' => "C",	'border' => "LRTB"),
					array('width' => "3%",	'data' => $aTotal,			'align' => "C",	'border' => "LRTB"),
					array('width' => "3%",	'data' => $sTotalRms,		'align' => "C",	'border' => "LRTB"),
					array('width' => "18%",	'data' => "",													'border' => "LRTB"),
					array('width' => "3%",	'data' => $sTotalAdlts,	'align' => "C",	'border' => "LRTB"),
					array('width' => "3%",	'data' => $sTotalChld,	'align' => "C",	'border' => "LRTB"),
					array('width' => "3%",	'data' => $sTotal,			'align' => "C",	'border' => "LRTB"),
					array('width' => "3%",	'data' => $dTotalRms,		'align' => "C",	'border' => "LRTB"),
					array('width' => "18%",	'data' => "",													'border' => "LRTB"),
					array('width' => "3%",	'data' => $dTotalAdlts,	'align' => "C",	'border' => "LRTB"),
					array('width' => "3%",	'data' => $dTotalChld,	'align' => "C",	'border' => "LRTB"),
					array('width' => "3%",	'data' => $dTotal,			'align' => "C",	'border' => "LRTB")
				));
				$pdf->Ln(2);
			}

			if ( $options & REP_ROOM ) {

				( $firstpage ) ? $firstpage = false : $pdf->AddPage();

				$pdf->Row(array(array('data'=>"Rooming Plan")));

				$pdf->Ln(1);

				$pdf->Row(array(
					array('width' => "10%",	'data' => "Room",				'fill' => 1,								'border' => "LRT"),
					array('width' => "30%",	'data' => "Arrive",			'fill' => 1,	'align' => "C",	'border' => "LRTB"),
					array('width' => "30%",	'data' => "Stay Over",	'fill' => 1,	'align' => "C",	'border' => "LRTB"),
					array('width' => "30%",	'data' => "Depart",			'fill' => 1,	'align' => "C",	'border' => "LRTB")			
				));

				$pdf->Row(array(
					array('width' => "10%",	'data' => "",							'fill' => 1,	'border' => "LRB"),
					array('width' => "24%",	'data' => "Res Details",	'fill' => 1,	'border' => "LRTB"),
					array('width' => "3%",	'data' => "Ad",						'fill' => 1,	'border' => "LRTB"),
					array('width' => "3%",	'data' => "Ch",						'fill' => 1,	'border' => "LRTB"),
					array('width' => "24%",	'data' => "Res Details",	'fill' => 1,	'border' => "LRTB"),
					array('width' => "3%",	'data' => "Ad",						'fill' => 1,	'border' => "LRTB"),
					array('width' => "3%",	'data' => "Ch",						'fill' => 1,	'border' => "LRTB"),
					array('width' => "24%",	'data' => "Res Details",	'fill' => 1,	'border' => "LRTB"),
					array('width' => "3%",	'data' => "Ad",						'fill' => 1,	'border' => "LRTB"),
					array('width' => "3%",	'data' => "Ch",						'fill' => 1,	'border' => "LRTB")
				));

				foreach($dayRoomArray[$dateItem] as $roomItem) {
					$blockRooms = $lDB->get("
						SELECT 
							ac_accomm_room_block.ac_accomm_room_id,
							ac_accomm_block.ac_start_date,
							ac_accomm_block.ac_end_date
						FROM 
							ac_accomm_room_block
						INNER JOIN ac_accomm_block ON 
							ac_accomm_block.ac_accomm_block_ix = ac_accomm_room_block.ac_accomm_block_id 
						WHERE 
							ac_accomm_room_block.ac_accomm_room_id = '$roomItem[ac_accomm_room_ix]'
						AND
							(
								(
									ac_accomm_block.ac_start_date >= '" . $fromDate['jsDate'] . "' 
									AND 
									ac_accomm_block.ac_start_date <= '" . $toDate['jsDate'] . "'
								)
								OR
								(
									ac_accomm_block.ac_end_date >= '" . $fromDate['jsDate'] . "'
									AND
									ac_accomm_block.ac_end_date <= '" . $toDate['jsDate'] . "'
								)
								OR
								(
									ac_accomm_block.ac_start_date < '" . $fromDate['jsDate'] . "'
									AND 
									ac_accomm_block.ac_end_date > '" . $toDate['jsDate'] . "'
								)
							)
					",1);

					$block = "";
					$fill = "0";
					$textCol = "";

					if ( $dateItem >= $blockRooms['ac_start_date'] && $dateItem <= $blockRooms['ac_end_date'] ) {
						$block = array(0xe4,0xe3,0xe3);
						$textCol = array(0x99,0x99,0x99);
						$fill = "1";
					}

					if ( trim($roomItem['arrive']['rv_agent_ref']) != "" ) {
						$arriveVoucher = " Vouch: " . $roomItem['arrive']['rv_agent_ref'];
					} else {
						$arriveVoucher = "";
					}

					if ( trim($roomItem['stayover']['rv_agent_ref']) != "" ) {
						$stayVoucher = " Vouch: " . $roomItem['stayover']['rv_agent_ref'];
					} else {
						$stayVoucher = "";
					}

					if ( trim($roomItem['depart']['rv_agent_ref']) != "" ) {
						$departVoucher = " Vouch: " . $roomItem['depart']['rv_agent_ref'];
					} else {
						$departVoucher = "";
					}

					$pdf->Row(array(
						array('width' => "10%",	'data' => $roomItem['ac_desc'] . " (". $roomItem['ac_accomm_desc'] . ")",																		'border' => "LRTB", 'fill' => $fill,	'fillColor' => $block,	'textColor' => $textCol),
						array('width' => "24%",	'data' => $roomItem['arrive']['rv_reservation_ix']." ".$roomItem['arrive']['rv_res_name'].$arriveVoucher,		'border' => "LRTB", 'fill' => $fill,	'fillColor' => $block,	'textColor' => $textCol),
						array('width' => "3%",	'data' => $roomItem['arrive']['rv_item_adult_count'],																												'border' => "LRTB", 'fill' => $fill,	'fillColor' => $block,	'textColor' => $textCol),
						array('width' => "3%",	'data' => $roomItem['arrive']['rv_item_child_count'],																												'border' => "LRTB", 'fill' => $fill,	'fillColor' => $block,	'textColor' => $textCol),
						array('width' => "24%",	'data' => $roomItem['stayover']['rv_reservation_ix']." ".$roomItem['stayover']['rv_res_name'].$stayVoucher,	'border' => "LRTB", 'fill' => $fill,	'fillColor' => $block,	'textColor' => $textCol),
						array('width' => "3%",	'data' => $roomItem['stayover']['rv_item_adult_count'],																											'border' => "LRTB", 'fill' => $fill,	'fillColor' => $block, 'textColor'=>$textCol),
						array('width' => "3%",	'data' => $roomItem['stayover']['rv_item_child_count'],																											'border' => "LRTB", 'fill' => $fill,	'fillColor' => $block,	'textColor' => $textCol),
						array('width' => "24%",	'data' => $roomItem['depart']['rv_reservation_ix']." ".$roomItem['depart']['rv_res_name'].$departVoucher,		'border' => "LRTB", 'fill' => $fill,	'fillColor' => $block,	'textColor' => $textCol),
						array('width' => "3%",	'data' => $roomItem['depart']['rv_item_adult_count'],																												'border' => "LRTB", 'fill' => $fill,	'fillColor' => $block,	'textColor' => $textCol),
						array('width' => "3%",	'data' => $roomItem['depart']['rv_item_child_count'],																												'border' => "LRTB", 'fill' => $fill,	'fillColor' => $block,	'textColor' => $textCol)
					));
				}

				$pdf->Row(array(
					array('width' => "10%",	'data' => "PAX Totals",																		'border' => "LRTB", 'style' => "B"),
					array('width' => "24%",	'data' => "",																							'border' => "LRTB"),
					array('width' => "3%",	'data' => $dayRoomTotalArray[$dateItem]['arriveAdult'],		'border' => "LRTB"),
					array('width' => "3%",	'data' => $dayRoomTotalArray[$dateItem]['arriveChild'],		'border' => "LRTB"),
					array('width' => "24%",	'data' => "",																							'border' => "LRTB"),
					array('width' => "3%",	'data' => $dayRoomTotalArray[$dateItem]['stayoverAdult'],	'border' => "LRTB"),
					array('width' => "3%",	'data' => $dayRoomTotalArray[$dateItem]['stayoverChild'],	'border' => "LRTB"),
					array('width' => "24%",	'data' => "",																							'border' => "LRTB"),
					array('width' => "3%",	'data' => $dayRoomTotalArray[$dateItem]['departAdult'],		'border' => "LRTB"),
					array('width' => "3%",	'data' => $dayRoomTotalArray[$dateItem]['departChild'],		'border' => "LRTB"),
				));
				$pdf->Ln(2);
			}

			if ( $options & REP_REQUESTS ) {

				( $firstpage ) ? $firstpage = false : $pdf->AddPage();

				if ( sizeof($dayRequestArray[$dateItem]) > 0 ) {
					$pdf->Row(array(array('data'=>"Resquests")));

					$pdf->Ln(1);

					$pdf->Row(array(
						array('width' => "10%",	'data' => "Reservation Details",	'fill' => 1,	'border' => "LRTB"),
						array('width' => "10%",	'data' => "Arriving",							'fill' => 1,	'border' => "LRTB"),
						array('width' => "10%",	'data' => "Departing",						'fill' => 1,	'border' => "LRTB"),
						array('width' => "10%",	'data' => "Accomm Type",					'fill' => 1,	'border' => "LRTB"),
						array('width' => "10%",	'data' => "Request",							'fill' => 1,	'border' => "LRTB"),
						array('width' => "10%",	'data' => "Tot Rooms",						'fill' => 1,	'border' => "LRTB"),
						array('width' => "10%",	'data' => "Rooms",								'fill' => 1,	'border' => "LRTB")
					));

					foreach($dayRequestArray[$dateItem] as $reqItem) {
						$pdf->Row(array(
							array('width' => "10%", 'data' => $reqItem['reqResNum'] . ": ". $reqItem['reqResName'],	'border' => "LRTB"),
							array('width' => "10%", 'data' => $reqItem['reqArrive'],																'border' => "LRTB"),
							array('width' => "10%", 'data' => $reqItem['reqDepart'],																'border' => "LRTB"),
							array('width' => "10%", 'data' => $reqItem['reqAccomm'],																'border' => "LRTB"),
							array('width' => "10%", 'data' => $reqItem['reqComps'],																	'border' => "LRTB"),
							array('width' => "10%", 'data' => $reqItem['reqTotRooms'],															'border' => "LRTB"),
							array('width' => "10%", 'data' => $reqItem['reqRooms'],																	'border' => "LRTB")
						));
					}
					$pdf->Ln(2);
				}
			}

			if ( $options & REP_EXTRA_DET ) {

				( $firstpage ) ? $firstpage = false : $pdf->AddPage();

				$pdf->Row(array(array('data'=>"Extras")));

				$pdf->Ln(1);

				$pdf->Row(array(array('width'=>"100%", 'data'=>"Details", 'fill'=>1, 'border'=>"LRTB")));

				$pdf->Row(array(
					array('width' => "9%",	'data' => "Service Date",	'border' => "LRTB", 'fill' => 1),
					array('width' => "5%",	'data' => "Travel",				'border' => "LRTB", 'fill' => 1,	'align' => "C"),        
					array('width' => "12%",	'data' => "Category",			'border' => "LRTB", 'fill' => 1),
					array('width' => "18%",	'data' => "Extra",				'border' => "LRTB", 'fill' => 1),
					array('width' => "6%",	'data' => "ETD",			'border' => "LRTB", 'fill' => 1),
					array('width' => "6%",	'data' => "ETA",			'border' => "LRTB", 'fill' => 1),
					array('width' => "26%",	'data' => "Reservation",	'border' => "LRTB", 'fill' => 1),
					array('width' => "5%",	'data' => "Qty",					'border' => "LRTB", 'fill' => 1,	'align' => "R"),
					array('width' => "5%",	'data' => "Room",					'border' => "LRTB", 'fill' => 1,	'align' => "R"),
					array('width' => "4%",	'data' => "Note",					'border' => "LRTB", 'fill' => 1,	'align' => "C"),
					array('width' => "4%",	'data' => "Memo",					'border' => "LRTB", 'fill' => 1,	'align' => "C")                
				));

				if(sizeof($dayExtraDetailArray[$dateItem]) > 0){
					foreach($dayExtraDetailArray[$dateItem] as $extraItem) {
						$extraItem['travInd'] = "";
						if($extraItem['ac_extra_cat_ind'] == 2){
							$extraItem['travInd'] = "x";
						}
						$extraItem['extraSummNote'] = "";   
						if(trim($extraItem['rv_extra_note']) != ""){
							$extraItem['extraSummNote'] = "x";
						}
						$extraItem['extraSummIntNote'] = "";  
						if(trim($extraItem['rv_extra_note_internal']) != ""){
							$extraItem['extraSummIntNote'] = "x";
						}  
						
						$pdf->Row(array(
							array('width' => "9%",	'data' => chng_date($extraItem['rv_extra_date_serv'],"-"),										'border' => "LRTB"),
							array('width' => "5%",	'data' => $extraItem['travInd'],																							'border' => "LRTB",	'align' => "C"),
							array('width' => "12%",	'data' => $extraItem['ac_extra_cat_desc'],																		'border' => "LRTB"),
							array('width' => "18%",	'data' => $extraItem['ac_ext_desc'],																					'border' => "LRTB"),
							array('width' => "6%",	'data' => $extraItem['rv_extra_travel_etd'],																		'border' => "LRTB"),
							array('width' => "6%",	'data' => $extraItem['rv_extra_travel_eta'],																		'border' => "LRTB"),
							array('width' => "26%",	'data' => $extraItem['rv_reservation_ix'] . ": " . $extraItem['rv_res_name'],	'border' => "LRTB"),
							array('width' => "5%",	'data' => $extraItem['rv_extra_units'],																				'border' => "LRTB",	'align' => "R"),
							array('width' => "5%",	'data' => $extraItem['ac_desc'],																							'border' => "LRTB",	'align' => "R"),
							array('width' => "4%",	'data' => $extraItem['extraSummNote'],																				'border' => "LRTB",	'align' => "C"),
							array('width' => "4%",	'data' => $extraItem['extraSummIntNote'],																			'border' => "LRTB",	'align' => "C")
						));
					}
				} else {
					$pdf->Row(array(array('width'=>"100%", 'data'=>"No Extras for: ".chng_date($dateItem,"-"), 'border'=>"LRTB", 'align'=>"C")));
				}
				$pdf->Ln(4);
			}
			$first = chng_date($dateItem,"-");
		}
	}
	// [ END ] Day sheet ---------------------------------------------------------

	// [START] Notes -------------------------------------------------------------
	if ( $options & REP_RES ) {
		// Add page break - set to Portrait
		$pdf->AddPage('P');

		$pdf->Row(array(array('width'=>"100%", 'data'=>"Reservation notes", 'fill'=>1, 'border'=>"LRT")));        

		foreach ( $resIds as $resNoteItem ) {
			$note					= t_decodeHTML(getReservationNote($resNoteItem['resId']));
			$guest				= t_decodeHTML(getReservationGuestInfo($resNoteItem['resId']));
			$nationality	= getGuestNationality($resNoteItem['rf_country_id']);
			$rooming			= getReservationRooming($resNoteItem['resId']);

			if ( $userStatusId > 1 ) {
				$resInt = t_decodeHTML(getReservationMemo($resNoteItem['resId']));
			}

			if ( $note != "FALSE" || $guest != "" || $nationality != "" || sizeof($rooming['notes']) > 0 || $resInt != "" || $resNoteItem['rv_agent_id'] != "" ) {
				$pdf->SetFont('Arial', 'B', 8);
				$pdf->Row(array(array('width' => "100%",	'height' => "1%",	'data' => "",	'border'=>"T")));
				$pdf->Row(array(array('width' => "100%",									'data' => $resNoteItem['resId'] . ": " . $resNoteItem['resName'])));
				$pdf->SetFont('Arial', '', 7);
			}

			// Room list ---------------------------------------------------------------
			if ( $options & REP_ROOM_LIST && sizeof($resNoteItem['roomArray']) > 0 ) {
				$pdf->Row(array(
					array('width' => "10%", 'data' => "Rooms / Units:"),
					array('width' => "90%", 'data' => join(", ", $resNoteItem['roomArray']))
				));
			}

			// Agent --------------------------------------------------------------------
			if ( $options & REP_AGENT ) {
				$agentName = agentName($resNoteItem['rv_agent_id']);
				if ( $agentName != "0" ) {
					$pdf->Row(array(
						array('width'=>"10%", 'data'=>"Agent:"),
						array('width'=>"90%", 'data'=>$agentName)
					));
				}
			}

			// Rate type ----------------------------------------------------------------
			if ( $options & REP_RATE_TYPE ) {
				$rateType = $lDB->get("
					SELECT 
						rt_rate_type.rt_rate_type_desc as rateType
					FROM 
						rv_reservation
					INNER JOIN rt_rate_type ON 
						rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id
					WHERE
						rv_reservation.rv_reservation_ix = '" . $resNoteItem['resId'] . "'
				",4);
	
				if ( $rateType != "" ) {
					$pdf->Row(array(
						array('width' => "10%",	'data' => "Rate type:"),
						array('width' => "90%",	'data' => $rateType)
					));
				}
			}

			// Nationality --------------------------------------------------------------
			if ( $options & REP_NATIONALITY ) {
				if ( $nationality != "" ) {
					$pdf->Row(array(
						array('width' => "10%",	'data' => "Nationality:"),
						array('width' => "90%",	'data' => $nationality)
					));
				}
			}
	
			// Res note -----------------------------------------------------------------
			if ( $options & REP_RES_NOTE ) {
				if ( $note != "FALSE" ) {
					$pdf->Row(array(
						array('width' => "10%",	'data' => "Res Note:"),
						array('width' => "90%",	'data' => $note)
					));
				}
			}
	
			if ( $userStatusId > 1 ) {
				// Res internal ------------------------------------------------------------
				if ( $options & REP_INTERNAL_MEMOS ) {
					if ( $resInt != "" ) {
						$pdf->Row(array(
							array('width' => "10%",	'data' => "Res Memo:"),
							array('width' => "90%",	'data' => $resInt)
						));
					}
				}
			}
	
			// Guest info ---------------------------------------------------------------
			if ( $options & REP_GUEST ) {
				if ( $guest != "" ) {
					$pdf->Row(array(
						array('width' => "10%",	'data' => "Guest info:"),
						array('width' => "90%",	'data' => $guest)
					));
				}
			}
	
			// Rooming - guest notes and memos ------------------------------------------
			if ( $options & REP_GUEST_NOTE ) {
				if ( sizeof($rooming['notes']) > 0 ) {
					$guestLabel = "";
	
					foreach ( $rooming['notes'] as $guestn ) {
						if ( $guestLabel == "" ) {
							$gLabel = "Guest notes:";
						} else {
							$gLabel = "";
						}
	
						$pdf->Row(array(
							array('width' => "10%",	'data' => $gLabel),
							array('width' => "90%",	'data' => $guestn['name'] . ": " . $guestn['note'])
						));
						$guestLabel = $gLabel;
					}
				}
			}
	
			if ( $options & REP_GUEST_MEMO ) {
				if ( sizeof($rooming['memos']) > 0 ) {
					$memoLabel = "";
	
					foreach ( $rooming['memos'] as $guestm ) {
						if ( $memoLabel == "" ) {
							$mLabel = "Guest Memos:";
						} else { 
							$mLabel = "";
						}
	
						$pdf->Row(array(
							array('width' => "10%",	'data' => $mLabel),
							array('width' => "90%",	'data' => $guestm['name'] . ": " . $guestm['note'])
						));
						$memoLabel = $mLabel;
					}
				}
			}
			$pdf->Row(array(array('width' => "100%",	'data' => "")));
		}
	}

	// Extras --------------------------------------------------------------------
	if ( $options & REP_EXTRA ) {
		$extNoteRow = array();
		$arrayFirst = true;

		foreach ( $resIds as $resNoteItem ) {
			$extraItem = array();
			$extNoteArray = getExtraNotes($resNoteItem['resId'],0,2,$fromDate,$toDate,$propertyId);

			// Extra note --------------------------------------------------------------
			if ( sizeof($extNoteArray) > 0 ) {
				if ( $arrayFirst == true ) {
					$pdf->AddPage('P');

					$pdf->Row(array(array('width' => "100%",	'data' => "Extras notes",	'fill' => 1,	'border' => "LRT")));

					$arrayFirst == false;
				}

				$pdf->SetFont('Arial', 'B', 8);

				$pdf->Row(array(array('width' => "100%",	'height' => "1%",	'data' => "",	'border'=>"T")));
				$pdf->Row(array(array('width' => "100%",									'data' => $resNoteItem['resId'] . ": " . $resNoteItem['resName'])));
				$pdf->SetFont('Arial', '', 7);

				foreach ( $extNoteArray as $extra ) {
					$serviceDate = chng_date($extra['serviceDate'],"-");
					$pdf->Row(array(
						array('width' => "10%",	'data' => "Description:"),
						array('width' => "90%",	'data' => $serviceDate . ": " . $extra['description'])
					));


					if ( $options & REP_EXTRA_SERVICE ) {
						if ( trim($extra['supplier_name']) != "" ) {
							$pdf->Row(array(
								array('width' => "10%",	'data' => "Service By:"),
								array('width' => "90%",	'data' => $extra['supplier_name'])
							));
						}
					}

					if ( $options & REP_EXTRA_REFERENCE ) {
						if ( trim($extra['rv_extra_ref']) != "" ) {
							$pdf->Row(array(
								array('width' => "10%",	'data' => "Reference:"),
								array('width' => "90%",	'data' => $extra['rv_extra_ref'])
							));
						}
					}

					if ( $options & REP_EXTRA_NOTE ) {
						if ( trim($extra['note']) != "" ) {
							$pdf->Row(array(
								array('width' => "10%",	'data' => "Note:"),
								array('width' => "90%",	'data' => $extra['note'])
							));
						}
					}

					if ( $options & REP_EXTRA_MEMO ) {
						if ( trim($extra['intNote']) != "" ) {
							$pdf->Row(array(
								array('width' => "10%",	'data' => "Internal Memo:"),
								array('width' => "90%",	'data' => $extra['intNote'])
							));
						}
					}
					$serviceDate = "";
				}
			}

			if ( sizeof($extNoteArray) > 0 ) {
				$pdf->Row(array(array('width' => "100%",	'data' => "")));
			}
		}
	}

	// Travel --------------------------------------------------------------------
	if ( $options & REP_TRAVEL ) {
		$pdf->AddPage('P');

		$pdf->Row(array(array('width' => "100%",	'data' => "Travel notes",	'fill' => 1,	'border' => "LRTB")));

		$travNoteRow = array();

		foreach ( $resIds as $resNoteItem ) {
			$travelItem = array();
			$travNoteArray = getExtraNotes($resNoteItem['resId'],1,2,$fromDate,$toDate,$propertyId);

			// Travel note -------------------------------------------------------------
			if ( sizeof($travNoteArray) > 0 ) {
				$pdf->SetFont('Arial', 'B', 8);

				$pdf->Row(array(array('width' => "100%",	'height' => "1%",	'data' => "", 'border'=>"T")));
				$pdf->Row(array(array('width' => "100%",									'data' => $resNoteItem['resId'] . ": " . $resNoteItem['resName'])));

				$pdf->SetFont('Arial', '', 7);

				foreach ( $travNoteArray as $trav ) {
					$serviceDate = chng_date($trav['serviceDate'],"-");

					$pdf->Row(array(
								array('width' => "10%",	'data' => "Description:"),
								array('width' => "90%",	'data' => $serviceDate . ": " . $trav['description'])
					));
                   
                   if ( $options & REP_TRAVEL_SERVICE ) {
						if ( trim($trav['supplier_name']) != "" ) {
							$pdf->Row(array(
								array('width' => "10%",	'data' => "Service By:"),
								array('width' => "90%",	'data' => $trav['supplier_name'])
							));
						}
					}

					if ( $options & REP_TRAVEL_REFERENCE ) {
						if ( trim($trav['rv_extra_ref']) != "" ) {
							$pdf->Row(array(
								array('width' => "10%",	'data' => "Reference:"),
								array('width' => "90%",	'data' => $trav['rv_extra_ref'])
							));
						}
					}

					if ( $options & REP_TRAVEL_NOTE ) {
						if ( trim($trav['note']) != "" ) {
							$pdf->Row(array(
								array('width' => "10%",	'data' => "Note:"),
								array('width' => "90%",	'data' => $trav['note'])
							));
						}
					}

					if ( $options & REP_TRAVEL_MEMO ) {
						if ( trim($trav['intNote']) != "" ) {
							$pdf->Row(array(
								array('width' => "10%",	'data' => "Internal Memo:"),
								array('width' => "90%",	'data' => $trav['intNote'])
							));
						}
					}
					$serviceDate = "";
				}
			}
			$pdf->Row(array(array('width' => "100%",	'data' => "")));
		}
	}
	// [ END ] Notes -------------------------------------------------------------

	$pdf->Ln(4);

	$pdf->ReportHeader($reportLabel, $headerArray);
	
	if ( $renderType == "view" ) {
		$pdf->OutPut();
		die();
	}

	if ( $renderType == "send" ) {
		$to 						= $_POST['mail_to'];
		$from 					= $_POST['mail_from'];
		$subject 				= stripslashes($_POST['mail_subj']);
		$message 				= stripslashes($_POST['mail_body']);
		$attachmentName	= $_POST['attachmentName'];

		$headers = "From: " . $GLOBALS['princName'] . "<" . $from . ">\r\n";

		// Close the pdf ----------------------------------------------------------
		if ( $pdf->state < 3 ) {
			$pdf->Close();
		}

		// And now mail it --------------------------------------------------------
		if($attachmentName != "!attachmentName!") {
			$pdfName = $attachmentName;
		} else {
			$pdfName = "Update report from " . $fromDate . " to " .  $toDate . ".pdf";
		}

		// ( From, To, Subject, Headers, Message, Action, emailID, resID ) --------
		$error = email($from, $to, $subject, $headers, $message, 0, 0, $_SERVER['argv'][1], $GLOBALS['princName'],$pdf->buffer,$pdfName);
		
		if ( !$error ) {
			echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
			die();
		} else {
			echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
			die();
		}
	}
}
// [ END ] PDF Report ---------------------------------------------------------

// [START] CSV File -----------------------------------------------------------
if ( $renderMode == "csv" ) {
	$csvFile = array();
  
  switch ( $reportType ){
	case "summary":
		$reportLabel = "Rooming Summary Report"; 
   	break;
	case "daySheet":
  	$reportLabel = "Rooming Day Sheet Report";
		break;
	}  
  
	array_push($csvFile,array($reportLabel));
	array_push($csvFile,array());
	array_push($csvFile,array("Date Range",$fromDate['htmlDate'] . " to " . $toDate['htmlDate']));
	array_push($csvFile,array("Property",$propertyName));
	array_push($csvFile,array());
	
  if ( $reportType == "summary" ){
		if ( $options & REP_PAX_SUMM ) {
    	array_push($csvFile,array("PAX Summary"));
    	array_push($csvFile,array("Date","In-House","In-House","In-House","In-House","In-House","Arrive","Arrive","Arrive","Arrive","Stay Over","Stay Over","Stay Over","Stay Over","Depart","Depart","Depart","Depart"));
    	array_push($csvFile,array("","Rooms","Room %","PAX","PAX","PAX","Rooms","PAX","PAX","PAX","Rooms","PAX","PAX","PAX","Rooms","PAX","PAX","PAX"));
    	array_push($csvFile,array("","","","Adults","Children","Total","","Adults","Children","Total","","Adults","Children","","Adults","Children","Total"));
	
    	foreach ( $paxArray as $paxItem ) {
    		array_push($csvFile,array(
    			$paxItem['date'],
    			$paxItem['inHouse']['accommCount'],
    			$paxItem['inHouse']['roomPerc'],
    			$paxItem['inHouse']['adultCount'],
    			$paxItem['inHouse']['childCount'],
    			$paxItem['inHouse']['totalCount'],
    			$paxItem['arrive']['accommCount'],
    			$paxItem['arrive']['adultCount'],
    			$paxItem['arrive']['childCount'],
    			$paxItem['arrive']['totalCount'],
    			$paxItem['stayover']['accommCount'],
    			$paxItem['stayover']['adultCount'],
    			$paxItem['stayover']['childCount'],
    			$paxItem['stayover']['totalCount'],
    			$paxItem['depart']['accommCount'],
    			$paxItem['depart']['adultCount'],
    			$paxItem['depart']['childCount'],
    			$paxItem['depart']['totalCount']
    		));
    	}
			
			array_push($csvFile,array(
    		"Total",
    		$paxTotals['inHouseAccommCount'],
    		"",
    		$paxTotals['inHouseAdultCount'],
    		$paxTotals['inHouseChildCount'],
    		$paxTotals['inHouseTotalCount'],
    		$paxTotals['arriveAccommCount'],
    		$paxTotals['arriveAdultCount'],
    		$paxTotals['arriveChildCount'],
    		$paxTotals['arriveTotalCount'],
    		$paxTotals['stayoverAccommCount'],
    		$paxTotals['stayoverAdultCount'],
    		$paxTotals['stayoverChildCount'],
    		$paxTotals['stayoverTotalCount'],
    		$paxTotals['departAccommCount'],
    		$paxTotals['departAdultCount'],
    		$paxTotals['departChildCount'],
    		$paxTotals['departTotalCount']
    	));
    }
		array_push($csvFile,array());      

		if ( $options & RES_CHART ) {	
			array_push($csvFile,array("Reservation Chart"));
    	$header1 = array("Accommodation");
    	$header2 = array("");
    	foreach($dateArray as $dateItem) {
    		array_push($header1,$dateItem,"","","","");
    		array_push($header2,"Rooms","Res Details","Adults","Children","Total");
    	}
    	array_push($csvFile,$header1);
    	array_push($csvFile,$header2);
    	foreach($resSummaryArray as $sumKey=>$sumItem) {
    		$max = 0;
    		for($dateCount = 0; $dateCount < sizeof($dateArray); $dateCount++) {
    			if(sizeof($sumItem[$dateArray[$dateCount]]) > $max) { $max = sizeof($sumItem[$dateArray[$dateCount]]); }
    		}
    		for($resCount = 0; $resCount < $max; $resCount++) {
    			if($resCount == 0) {
    				$dataRow = array($sumKey);
    			} else {
    				$dataRow = array("");
    			}
    			for($dateCount = 0; $dateCount < sizeof($dateArray); $dateCount++) {			
    				$resItem = $sumItem[$dateArray[$dateCount]][$resCount];
            
            $compList = "";
            $compSql = $lDB->get("
            	SELECT
              	rt_component.rt_component_abbrv as compAbbr
              FROM rv_res_item_comp
              INNER JOIN rt_component ON 
              	rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
              WHERE rv_res_item_comp.rv_reservation_item_id = '$resItem[rv_reservation_item_ix]'
              AND rv_res_item_comp.rv_item_comp_option_yn = '1'
              ORDER BY rt_component.rt_component_ix
            ",3);
            if(sizeof($compSql)>0){
            	$compList = "(".join($compSql,", ").") ";
            }
            $g = getGuestNames($resItem['rv_res_item_group_ix']);
            $gNames = str_replace("<BR>",", ",$g['guestName']);

    				if($resItem['rv_item_accomm_count'] != "0" && trim($resItem['rv_item_accomm_count']) != "") {
						if(trim($resItem['rv_agent_ref']) != "") {
							$voucher = "\nVouch: " . $resItem['rv_agent_ref'];
						} else {
							$voucher = "";
						}
    					array_push($dataRow,
    						$resItem['rv_item_accomm_count'],
    						$resItem['rv_reservation_ix'] . ": " . $resItem['rv_res_name']." \n".$gNames." ".$compList.$voucher,
    						$resItem['rv_item_adult_count'],
    						$resItem['rv_item_child_count'],
    						( ($resItem['rv_item_adult_count']*$resItem['rv_item_accomm_count']) + ($resItem['rv_item_child_count']*$resItem['rv_item_accomm_count']) )
    					);
    				} else {
    					array_push($dataRow,
    						"",
    						"",
    						"",
    						"",
    						""
    					);
    				}
    			}
    			array_push($csvFile,$dataRow);
    		}
    	}
    array_push($csvFile,array());
    }  
		
		if ( $options & REP_ROOM_SUMM ) {	
			array_push($csvFile,array("Rooming Summary (planned)"));
    	$header1 = array("Accommodation");
    	$header2 = array("");
    	foreach($dateArray as $dateItem) {
    		array_push($header1,$dateItem,"","");
    		array_push($header2,"Res Details","Adults","Children");
    	}
    	array_push($csvFile,$header1);
    	array_push($csvFile,$header2);
    	
      $pCount = 0;
    	foreach($roomSummaryArray as $roomItem) {
    		$dataRow = array($roomItem['ac_desc'] . " (" . $roomItem['ac_accomm_desc'] . ")");

    		for($dateCount = 0; $dateCount < sizeof($dateArray); $dateCount++) {
    			$item = $roomItem['items'][$dateArray[$dateCount]];
    			
          if($item['rf_reservation_status_id'] == "20") {
    				if($item['rv_provision_expiry_date'] < date("Y-m-d")) {
    				  $pCount ++;              
    				}
    			}          
          
    			if($item['rv_reservation_ix'] != "") {
					if(trim($item['rv_agent_ref']) != "") {
						$voucher = " Vouch: " . $item['rv_agent_ref'];
					} else {
						$voucher = "";
					}
    				array_push($dataRow,
    					$item['rv_reservation_ix'] .": ".$item['rv_res_name'] . $voucher,
    					$item['rv_item_adult_count'],
    					$item['rv_item_child_count']
    				);
    			} else {
    				array_push($dataRow,
    					"",
    					"",
    					""
    				);
    			}
    		}
    		array_push($csvFile,$dataRow);
    	}
      if($pCount > 0){
				$expiredProv = "Some of the allocated reservations displayed have passed their provisional expiry date";
        array_push($csvFile,array($expiredProv));      
      }

      $noRooms = "";
			/*if($itemSize > $roomSize){
        $noRooms = "There are reservations still to be allocated to rooms";
      }*/
	    array_push($csvFile,array($noRooms));      
    	array_push($csvFile,array());
    }  
	}//End Summary report
  
  if($reportType == "daySheet"){ 
    foreach($dateArray as $dateItem) {
  		array_push($csvFile,array("Day Sheet for ".$propertyName." - ".chng_date($dateItem,"-")));
  		array_push($csvFile,array());			

			if($options & REP_PAX){
    		array_push($csvFile,array("PAX Analysis"));
    		array_push($csvFile,array("Accommodation","In-House","In-House","In-House","In-House","In-House","Arrive","Arrive","Arrive","Arrive","Stay Over","Stay Over","Stay Over","Stay Over","Depart","Depart","Depart","Depart"));
    		array_push($csvFile,array("","Rooms","Room %","PAX","PAX","PAX","Rooms","PAX","PAX","PAX","Rooms","PAX","PAX","PAX","Rooms","PAX","PAX","PAX"));		
    		foreach($dayPaxArray[$dateItem] as $paxItem) {
    			array_push($csvFile,array(
    				$paxItem['ac_accomm_desc'],
    				$paxItem['inHouse']['accommCount'],
    				$paxItem['inHouse']['roomPerc'],
    				$paxItem['inHouse']['adultCount'],
    				$paxItem['inHouse']['childCount'],
    				$paxItem['inHouse']['totalCount'],
    				$paxItem['arrive']['accommCount'],
    				$paxItem['arrive']['adultCount'],
    				$paxItem['arrive']['childCount'],
    				$paxItem['arrive']['totalCount'],
    				$paxItem['stayover']['accommCount'],
    				$paxItem['stayover']['adultCount'],
    				$paxItem['stayover']['childCount'],
    				$paxItem['stayover']['totalCount'],
    				$paxItem['depart']['accommCount'],
    				$paxItem['depart']['adultCount'],
    				$paxItem['depart']['childCount'],
    				$paxItem['depart']['totalCount']
    			));
    		}
    		array_push($csvFile,array(
    			"Total",
    			$dayPaxTotalArray[$dateItem]['inHouseAccommCount'],
    			"",
    			$dayPaxTotalArray[$dateItem]['inHouseAdultCount'],
    			$dayPaxTotalArray[$dateItem]['inHouseChildCount'],
    			$dayPaxTotalArray[$dateItem]['inHouseTotalCount'],
    			$dayPaxTotalArray[$dateItem]['arriveAccommCount'],
    			$dayPaxTotalArray[$dateItem]['arriveAdultCount'],
    			$dayPaxTotalArray[$dateItem]['arriveChildCount'],
    			$dayPaxTotalArray[$dateItem]['arriveTotalCount'],
    			$dayPaxTotalArray[$dateItem]['stayoverAccommCount'],
    			$dayPaxTotalArray[$dateItem]['stayoverAdultCount'],
    			$dayPaxTotalArray[$dateItem]['stayoverChildCount'],
    			$dayPaxTotalArray[$dateItem]['stayoverTotalCount'],
    			$dayPaxTotalArray[$dateItem]['departAccommCount'],
    			$dayPaxTotalArray[$dateItem]['departAdultCount'],
    			$dayPaxTotalArray[$dateItem]['departChildCount'],
    			$dayPaxTotalArray[$dateItem]['departTotalCount']
    		));
    		array_push($csvFile,array());
      }  					
    
			if ( $options & RES_SUMM ) {
    		array_push($csvFile,array("Reservation Summary"));
    		array_push($csvFile,array("Accommodation","Arrive","Arrive","Arrive","Arrive","Arrive","Stay Over","Stay Over","Stay Over","Stay Over","Stay Over","Depart","Depart","Depart","Depart","Depart"));
    		array_push($csvFile,array("","Rooms","Res Details","Adults","Children","Total","Rooms","Res Details","Adults","Children","Total","Rooms","Res Details","Adults","Children","Total"));
    
    		foreach($dayResSummaryArray[$dateItem] as $sumItem) {
    			$max = sizeof($sumItem['arrive']);
    			if(sizeof($sumItem['stayover']) > $max) { $max = sizeof($sumItem['stayover']); }
    			if(sizeof($sumItem['depart']) > $max) { $max = sizeof($sumItem['depart']); }
    			for($count=0; $count<$max; $count++) {
					if(trim($sumItem['arrive'][$count]['rv_agent_ref']) != "") {
						$arriveVoucher = " Vouch: " . $sumItem['arrive'][$count]['rv_agent_ref'];
					} else {
						$arriveVoucher = "";
					}
					if(trim($sumItem['stayover'][$count]['rv_agent_ref']) != "") {
						$stayVoucher = " Vouch: " . $sumItem['stayover'][$count]['rv_agent_ref'];
					} else {
						$stayVoucher = "";
					}
					if(trim($sumItem['depart'][$count]['rv_agent_ref']) != "") {
						$departVoucher = " Vouch: " . $sumItem['depart'][$count]['rv_agent_ref'];
					} else {
						$departVoucher = "";
					}
					
    				if($count==0) {
    					$accommName = $sumItem['ac_accomm_desc'];
    				} else {
    					$accommName = "";
    				}
    				array_push($csvFile,array(
    					$accommName,
    					$sumItem['arrive'][$count]['rv_item_accomm_count'],
    					$sumItem['arrive'][$count]['rv_reservation_ix']." ".$sumItem['arrive'][$count]['rv_res_name'].$arriveVoucher,
    					$sumItem['arrive'][$count]['rv_item_adult_count'],
    					$sumItem['arrive'][$count]['rv_item_child_count'],
    					( ($sumItem['arrive'][$count]['rv_item_adult_count']*$sumItem['arrive']['rv_item_accomm_count']) + ($sumItem['arrive']['rv_item_adult_count']*$sumItem['arrive']['rv_item_accomm_count']) ),
    					$sumItem['stayover'][$count]['rv_item_accomm_count'],
    					$sumItem['stayover'][$count]['rv_reservation_ix']." ".$sumItem['stayover'][$count]['rv_res_name'].$stayVoucher,
    					$sumItem['stayover'][$count]['rv_item_adult_count'],
    					$sumItem['stayover'][$count]['rv_item_child_count'],
    					( ($sumItem['stayover'][$count]['rv_item_adult_count']*$sumItem['stayover']['rv_item_accomm_count']) + ($sumItem['stayover']['rv_item_adult_count']*$sumItem['stayover']['rv_item_accomm_count']) ),
    					$sumItem['depart'][$count]['rv_item_accomm_count'],
    					$sumItem['depart'][$count]['rv_reservation_ix']." ".$sumItem['depart'][$count]['rv_res_name'].$departVoucher,
    					$sumItem['depart'][$count]['rv_item_adult_count'],
    					$sumItem['depart'][$count]['rv_item_child_count'],
    					( ($sumItem['depart'][$count]['rv_item_adult_count']*$sumItem['depart']['rv_item_accomm_count']) + ($sumItem['depart']['rv_item_adult_count']*$sumItem['depart']['rv_item_accomm_count']) )
    				));
    			}    			
        }
        array_push($csvFile,array());
      }  

			if ( $options & REP_ROOM ) {
    		array_push($csvFile,array("Rooming Plan"));
    		array_push($csvFile,array("Accommodation","Arrive","Arrive","Arrive","Stay Over","Stay Over","Stay Over","Depart","Depart","Depart"));
    		array_push($csvFile,array("","Res Details","Adults","Children","Res Details","Adults","Children","Res Details","Adults","Children"));
    		
    		foreach($dayRoomArray[$dateItem] as $roomItem) {
    			array_push($csvFile,array(
    				$roomItem['ac_desc'] . " (". $roomItem['ac_accomm_desc'] . ")",
    				$roomItem['arrive']['rv_reservation_ix'],
    				$roomItem['arrive']['rv_item_adult_count'],
    				$roomItem['arrive']['rv_item_child_count'],
    				$roomItem['stayover']['rv_reservation_ix'],
    				$roomItem['stayover']['rv_item_adult_count'],
    				$roomItem['stayover']['rv_item_child_count'],
    				$roomItem['depart']['rv_reservation_ix'],
    				$roomItem['depart']['rv_item_adult_count'],
    				$roomItem['depart']['rv_item_child_count']
    			));
    		}
    		array_push($csvFile,array(
    			"PAX Totals",
    			"",
    			$dayRoomTotalArray[$dateItem]['arriveAdult'],
    			$dayRoomTotalArray[$dateItem]['arriveChild'],
    			"",
    			$dayRoomTotalArray[$dateItem]['stayoverAdult'],
    			$dayRoomTotalArray[$dateItem]['stayoverChild'],
    			"",
    			$dayRoomTotalArray[$dateItem]['departAdult'],
    			$dayRoomTotalArray[$dateItem]['departChild']
    		));
    		
    		array_push($csvFile,array());
      }  			
		
			if ( $options & REP_REQUESTS ) {
    		array_push($csvFile,array("Requests"));
    		array_push($csvFile,array("Reservation Details","Arriving","Departing","Accomm Type","Request","Total Rooms","Rooms"));
    		if(sizeof($dayRequestArray[$dateItem]) > 0){
          foreach($dayRequestArray[$dateItem] as $reqItem) {
      			array_push($csvFile,array(
      				$reqItem['reqResNum'] . ": ". $reqItem['reqResName'],
      				$reqItem['reqArrive'],
      				$reqItem['reqDepart'],
      				$reqItem['reqAccomm'],
      				$reqItem['reqComps'],
      				$reqItem['reqTotRooms'],
      				$reqItem['reqRooms']
      			));			
      		}
        }else{
        	array_push($csvFile,array("No Requests"));
        }  
    		array_push($csvFile,array());
      }  			

			if ( $options & REP_EXTRA_DET ) {
    		array_push($csvFile,array("Extras"));	
    		array_push($csvFile,array());			
    		
    		array_push($csvFile,array("Details"));
    		array_push($csvFile,array("Category","Extra","ETD","ETA","Reservation","Quantity","Room"));
        if(sizeof($dayExtraDetailArray[$dateItem]) > 0){
      		foreach($dayExtraDetailArray[$dateItem] as $extraItem) {
				array_push($csvFile,array(
						$extraItem['ac_extra_cat_desc'],
						$extraItem['ac_ext_desc'],
						$extraItem['rv_extra_travel_etd'],
						$extraItem['rv_extra_travel_eta'],
						$extraItem['rv_reservation_ix'] . ": " . $extraItem['rv_res_name'],
						$extraItem['rv_extra_units'],
						$extraItem['ac_desc']
					));
      		}
        }else{
			array_push($csvFile,array("No Extras"));
        }  
    		array_push($csvFile,array());
      }
    }    			
  }

  //[START] Notes
	if($options & REP_RES){        
		array_push($csvFile,array("Reservation notes"));
    foreach($resIds as $resNoteItem){      
      $note = t_decodeHTML(getReservationNote($resNoteItem['resId']));
    	$guest = t_decodeHTML(getReservationGuestInfo($resNoteItem['resId']));
      $nationality = getGuestNationality($resNoteItem['rf_country_id']);
      $rooming = getReservationRooming($resNoteItem['resId']);
      if($userStatusId > 1) {
        $resInt = t_decodeHTML(getReservationMemo($resNoteItem['resId']));
      }
  
      if($note != "FALSE" || $guest != "" || $nationality != "" || sizeof($rooming['notes']) > 0 || $resInt != "" || $resNoteItem['rv_agent_id'] != ""){
				array_push($csvFile,array($resNoteItem['resId'].": ".$resNoteItem['resName']));        
      }
	  // room list
	  if($options & REP_ROOM_LIST && sizeof($resNoteItem['roomArray']) > 0) {
			array_push($csvFile,array("Rooms / Units:",join(", ",$resNoteItem['roomArray'])));		  
	  }
    	// agent
      if($options & REP_AGENT){
        $agentName = agentName($resNoteItem['rv_agent_id']);
        if($agentName != "0"){
					array_push($csvFile,array("Agent:",$agentName));
        }
      }
      // Rate Type
      if($options & REP_RATE_TYPE){
        $rateType = $lDB->get("
      		SELECT 
          	rt_rate_type.rt_rate_type_desc as rateType 
          FROM 
      			rv_reservation
          INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id
      		WHERE
            rv_reservation.rv_reservation_ix = '$resNoteItem[resId]';
      	",4); 
        if($rateType != ""){
      	  array_push($csvFile,array("Rate Type:",$rateType));
        }
      }         
      // Nationality
      if($options & REP_NATIONALITY){
        if($nationality != ""){
	        array_push($csvFile,array("Nationality:",$nationality));
        }
      }        
      // res note
      if($options & REP_RES_NOTE){
        if($note != "FALSE"){
					array_push($csvFile,array("Res Note:",$note));
        }  
      }
			if($userStatusId > 1) {
    		// res internal
        if($options & REP_INTERNAL_MEMOS){
          if($resInt != ""){
            array_push($csvFile,array("Res Memo:",$resInt));
          }
        }
      }                 
      // guest info
  	  if($options & REP_GUEST){    
        if($guest != ""){      
          array_push($csvFile,array("Guest info:",$guest));
        }
      }  
      // Rooming - guest notes and memos
      if($options & REP_GUEST_NOTE){  
        if(sizeof($rooming['notes']) > 0){  
          $guestLabel = "";
          foreach($rooming['notes'] as $guestn){
            if($guestLabel == ""){$gLabel = "Guest notes:";}else{$gLabel = "";}
            array_push($csvFile,array($gLabel,$guestn['name'].": ".$guestn['note']));
            $guestLabel = $gLabel;      
          }    
        }
      }  
      if($options & REP_GUEST_MEMO){    
        if(sizeof($rooming['memos']) > 0){
          $memoLabel = "";
          foreach($rooming['memos'] as $guestm){
            if($memoLabel == ""){$mLabel = "Guest Memos:";}else{$mLabel = "";}   
            array_push($csvFile,array($mLabel,$guestm['name'].": ".$guestm['note']));
            $memoLabel = $mLabel;
          }
        }
      }      
    }
		array_push($csvFile,array());
  }

  //Extras
  if($options & REP_EXTRA){
  	array_push($csvFile,array("Extras"));
    $extNoteRow = array();  
    foreach($resIds as $resNoteItem){
  		$extraItem = array();
      $extNoteArray = getExtraNotes($resNoteItem['resId'],0,2,$fromDate,$toDate,$propertyId);
      
    	// extra note
      if(sizeof($extNoteArray) > 0){
        array_push($csvFile,array($resNoteItem['resId'].": ".$resNoteItem['resName']));                    
        foreach($extNoteArray as $extra){
        	$serviceDate = chng_date($extra['serviceDate'],"-");
          array_push($csvFile,array("Description:",$serviceDate.": ".$extra['description']));

		  if($options & REP_EXTRA_SERVICE){
          	if(trim($extra['supplier_name']) != ""){
							array_push($csvFile,array("Service By:",$extra['supplier_name']));
            }  
          }

		   if($options & REP_EXTRA_REFERENCE){
          	if(trim($extra['rv_extra_ref']) != ""){
							array_push($csvFile,array("Reference:",$extra['rv_extra_ref']));
            }  
          }

          if($options & REP_EXTRA_NOTE){
          	if(trim($extra['note']) != ""){
							array_push($csvFile,array("Note:",$extra['note']));
            }  
          }
          if($options & REP_EXTRA_MEMO){
          	if(trim($extra['intNote']) != ""){
	            array_push($csvFile,array("Internal Memo:",$extra['intNote']));
            }  
          }  
          $serviceDate = "";    
        }
      }    
    }
    array_push($csvFile,array());
  }    
	//Travel
  if($options & REP_TRAVEL){
    array_push($csvFile,array("Travel")); 
    $travNoteRow = array();    
    foreach($resIds as $resNoteItem){    	    
    	$travelItem = array();
      $travNoteArray = getExtraNotes($resNoteItem['resId'],1,2,$fromDate,$toDate,$propertyId);
  
      // travel note    
      if(sizeof($travNoteArray) > 0){
				array_push($csvFile,array($resNoteItem['resId'].": ".$resNoteItem['resName']));
        foreach($travNoteArray as $trav){
        	$serviceDate = chng_date($trav['serviceDate'],"-");
          array_push($csvFile,array("Description:",$serviceDate.": ".$trav['description']));

		   if($options & 'REP_TRAVEL_SERVICE'){
          	if(trim($trav['supplier_name']) != ""){
							array_push($csvFile,array("Service By:",$trav['supplier_name']));
            }  
          }
		   if($options & REP_TRAVEL_REFERENCE){
          	if(trim($trav['rv_extra_ref']) != ""){
							array_push($csvFile,array("Reference:",$trav['rv_extra_ref']));
            }  
          }
          if($options & REP_TRAVEL_NOTE){
            if(trim($trav['note']) != ""){
	            array_push($csvFile,array("Note:",$trav['note']));
            }  
          }
          if($options & REP_TRAVEL_MEMO){
            if(trim($trav['intNote']) != ""){
		          array_push($csvFile,array("Internal Memo:",$trav['intNote']));
            }  
          }  
          $serviceDate = "";    
        }
      }    
    }
    array_push($csvFile,array());
  }  
  //[END] Notes  
  
	// Convert the csvFile array into final CVS format
	$csvText = "";
	foreach($csvFile as $csvLine) {
		$first = true;
		foreach($csvLine as $csvItem) {
			if(!$first) { $csvText .= ","; } else { $first = false; }
			$csvText .= "\"".str_replace("\"","\"\"",$csvItem)."\"";
		}
		$csvText .= "\n";
	}
   
	if(headers_sent()) {
		//    echo('Some data has already been output to browser, can\'t send CSV file');
	}
	header('Content-Type: text/csv');
	header("Cache-control: private");
	header('Content-Length: '.strlen($csvText));
	header("Content-Disposition: inline; filename=rooming_".str_replace(" ","_",$fromDate['htmlDate'])."_to_".str_replace(" ","_",$toDate['htmlDate']).".csv");
	//header("Content-Disposition: inline; filename=contact_".date("Y-m-d").".csv");
	echo $csvText;
	flush();
	die();
}


// BEGIN - Functions
function getChildren($businessId) {
	global $lDB;
	$list = $lDB->get("
		SELECT
			pr_business_id
		FROM
			pr_business
		WHERE
			pr_business_parent = '$businessId'
	",3);
	$children = array();
	foreach($list as $item) {
		$children = array_merge($children,getChildren($item));
	}
	array_push($children, $businessId);
	return $children;
}
// END - Functions

function getPersonaFax($personaId) {
	global $lDB;
      $fax = $lDB->get("
         SELECT
         pr_phone.pr_phone_number
         FROM
         pr_phone, rf_phone_type
         WHERE
         pr_phone.pr_persona_id = '$personaId'
         AND pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
         AND rf_phone_type.rf_phone_type_sys_code = '1'", 4);
      if (trim($fax) == "" || $fax == "0") {
         $fax = "";
      }
      return $fax;
   }
   function getPersonaTelephone($personaId) {
	global $lDB;
      $tel = $lDB->get("
         SELECT
         pr_phone.pr_phone_number
         FROM
         pr_phone
         WHERE
         pr_phone.pr_persona_id = '$personaId'
         AND pr_phone.pr_default_yn = '1'", 4);
      if (trim($tel) == "" || $tel == "0") {
         $tel = "";
      }
      return $tel;
   }
function getPersonaDetail($personaId) {
	global $lDB;
      $detail = $lDB->get("
         SELECT
         pr_persona.pr_name_first,
         pr_persona.pr_name_second,
         pr_persona.pr_name_last,
         pr_persona.pr_email
         FROM
         pr_persona
         WHERE
         pr_persona.pr_persona_ix = '".$personaId."'", 2);
      $detail = $detail[0];
      $name = "";
      if (trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
         $name .= $detail['pr_name_first'] . " ";
      }
      if (trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
         $name .= $detail['pr_name_second'] . " ";
      }
      if (trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
         $name .= $detail['pr_name_last'] . " ";
      }
      $result = array();
      $result['name'] = trim($name);
      $result['fax'] = getPersonaFax($personaId);
      $result['telephone'] = getPersonaTelephone($personaId);
      $result['email'] = $detail['pr_email'];
      if (trim($result['email']) == "" || $result['email'] == "0") {
         $result['email'] = "";
      }
      return $result;
   }

function getReservationGuestInfo($resNum) {
	global $lDB;
   $info = $lDB->get("SELECT rv_note_guests FROM rv_reservation WHERE rv_reservation.rv_reservation_ix = '".$resNum."'",4);
   if(trim($info) == "" || $info == "0") {
      $info = "";
   }
   return $info;
}

function getExtraNotes($resNum,$travel=0,$memo=0,$fromDate,$toDate,$propertyId) {	
	global $lDB;
   if($travel == 0) {
      $travelIndex = " <> 2 ";
   } else {   
      $travelIndex = " = 2 ";
   }
   switch($memo){
   	 case 0:
       $noteType = "rv_extra.rv_extra_note as note,";
       $noteTypeName = "trim(rv_extra.rv_extra_note) <> ''";
     break;
     case 1:
       $noteType = "rv_extra.rv_extra_note_internal as note,";
       $noteTypeName = "rv_extra.rv_extra_note_internal";
       $noteTypeName = "trim(rv_extra.rv_extra_note_internal) <> ''";
     break;
     case 2:
       $noteType = "rv_extra.rv_extra_note as note,
       rv_extra.rv_extra_note_internal as intNote,";
       $noteTypeName = "(trim(rv_extra.rv_extra_note) <> '' OR trim(rv_extra.rv_extra_note_internal) <> '')";
     break;
   }
   
   $notes = $lDB->get("
      SELECT
         ".$noteType."
         pr_persona.pr_name_last as property,
         rv_extra.rv_extra_date_serv as serviceDate,
         rv_extra.rv_extra_ind as travelType,
         ac_extra.ac_ext_desc as description,
         rv_extra.rv_extra_travel_eta,
		 rv_extra.rv_extra_travel_etd,
		 rv_extra.rv_extra_supplier_conf_yn,
		 rv_extra.pr_supplier_id,
		 rv_extra.rv_extra_ref,
		 CONCAT_WS(' ',pr_extra_supplier.pr_name_first,pr_extra_supplier.pr_name_last) AS supplier_name
      FROM
         rv_extra
         LEFT JOIN pr_persona ON
            pr_persona.pr_persona_ix = rv_extra.pr_business_id
         LEFT JOIN ac_extra ON
            rv_extra.ac_extra_id = ac_extra.ac_extra_ix
         LEFT JOIN pr_persona AS pr_extra_supplier ON pr_extra_supplier.pr_persona_ix = rv_extra.pr_supplier_id
      WHERE
         rv_extra.rv_reservation_id = '".$resNum."'
         AND rv_extra.rv_extra_ind ".$travelIndex."
         AND $noteTypeName
         AND( rv_extra.rv_extra_date_serv >= '$fromDate[jsDate]' AND rv_extra.rv_extra_date_serv <= '$toDate[jsDate]'
         	  OR rv_extra.rv_extra_date_serv = '0000-00-00'  
         )
         AND (
    			 rv_extra.pr_business_id = '$propertyId'
				 /*  OR rv_extra.pr_business_id = '0'*/
    		 )
		AND rv_extra.rv_extra_void_ind = 0			 
      ORDER BY
         rv_extra.rv_extra_date_serv, pr_persona.pr_name_last",2);
			
   return $notes;
}

function getReservationMemo($resNum) {
	global $lDB;
   $memo = $lDB->get("SELECT rv_reservation.rv_note_internal as resInt FROM rv_reservation WHERE rv_reservation.rv_reservation_ix = '".$resNum."'",4);

   if(trim($memo) == "" || $memo == "0") {
      $memo = "";
   }
   return $memo;
}

function getGuestNationality($country_id) {
	global $lDB;
   $exists = $lDB->get("SELECT count(rf_country_name) FROM rf_country WHERE rf_country_ix = '$country_id'",4);
   if($exists > 0) {
      return $lDB->get("SELECT rf_country_name FROM rf_country WHERE rf_country_ix = '$country_id'",4);
   }
   return "";
}

function getReservationRooming($resNum) {
	global $lDB;
	$guestList = $lDB->get("
		SELECT DISTINCT
			pr_persona.pr_name_last,
			pr_persona.pr_name_first,
			pr_persona.pr_persona_ix,
			pr_guest.pr_guest_note,
			pr_guest.pr_guest_memo
		FROM
			rv_reservation_item
			INNER JOIN rv_res_item_guest ON rv_res_item_guest.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
			INNER JOIN pr_guest ON pr_guest.pr_guest_id = rv_res_item_guest.pr_guest_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$resNum'
	",2);

   $roomList = $lDB->get("
      SELECT
      rv_reservation_item.rv_item_date_arrive as arrive,
      rv_reservation_item.rv_item_date_depart as depart,
      pr_persona.pr_name_last as property,
      ac_accomm_type.ac_accomm_desc  as accomm,
      ac_accomm_room.ac_desc as room,
      rv_res_item_group.rv_room_requested_yn as locked,
      rv_room_request_reason as reason
   FROM
      rv_reservation_item
      INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation_item.pr_business_id
      INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
      INNER JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
      INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
   WHERE
      rv_reservation_item.rv_reservation_id = '$resNum'
   ORDER BY
      rv_reservation_item.rv_item_date_arrive,
      rv_reservation_item.rv_item_date_depart,
      pr_persona.pr_name_last,
      ac_accomm_type.ac_accomm_desc,
      (ac_accomm_room.ac_desc+0),
      ac_accomm_room.ac_desc
   ",2);
   //debug($roomList);
   $arrive = null;
   $depart = null;
   $property = null;
   $accomm = null;
   $level = 1;
   foreach($roomList as $key=>$item) {
      $roomList[$key]['arrive'] = chng_date($item['arrive'],"-");	    
			$roomList[$key]['depart'] = chng_date($item['depart'],"-");
      
      if($arrive != $item['arrive']) {
      $arrive = $item['arrive'];
      $depart = $item['depart'];
      $property = $item['property'];
      $accomm = $item['accomm'];
      $level = 1;
      }
      if($depart != $item['depart']) {
      $depart = $item['depart'];
      $property = $item['property'];
      $accomm = $item['accomm'];
      $level = 2;
      }
      if($property != $item['property']) {
         $property = $item['property'];
         $accomm = $item['accomm'];
         $level = 3;
      }
      if($accomm != $item['accomm']) {
         $accomm = $item['accomm'];
         $level = 4;
      }

      if($level == 2) { $roomList[$key]['arrive'] = ""; }
      if($level == 3) { $roomList[$key]['arrive'] = ""; $roomList[$key]['depart'] = ""; }
      if($level == 4) { $roomList[$key]['arrive'] = ""; $roomList[$key]['depart'] = ""; $roomList[$key]['property'] = ""; }
      if($level == 5) { $roomList[$key]['arrive'] = ""; $roomList[$key]['depart'] = ""; $roomList[$key]['property'] = ""; $roomList[$key]['accomm'] = ""; }

      $level = 5;

      if($item['locked'] == "1") {
      $roomList[$key]['locked'] = "Yes";
      } else {
         $roomList[$key]['locked'] = "No";
         $roomList[$key]['reason'] = "";
      }
   }
   $guestGroup = array();
   $itemList = $lDB->get("
      SELECT
      rv_reservation_item_ix
   FROM
      rv_reservation_item
   WHERE
      rv_reservation_id = '$resNum'
   ",3);

   $groupName = $lDB->get("
      SELECT DISTINCT
      rv_res_item_group.rv_res_item_group_ix
   FROM
      rv_res_item_group
      INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
      INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
      INNER JOIN rv_res_item_guest ON rv_res_item_guest.rv_res_item_group_id = rv_res_item_group.rv_res_item_group_ix
   WHERE
      rv_reservation.rv_reservation_ix = '$resNum'
      AND (
         rv_res_item_group.ac_accomm_room_id = ''
         OR rv_res_item_group.ac_accomm_room_id IS NULL
         OR rv_res_item_group.ac_accomm_room_id = '0'
      )
   ",3);

   //debug($groupName);
   //debug($itemList);
   for($count = 0; $count < ceil(sizeof($itemList) / 4); $count++) {
      $row = array();
	  $row['itemHeader1'] = "";
	  $row['itemHeader2'] = "";
	  $row['itemHeader3'] = "";
	  $row['itemHeader4'] = "";
      $row['rows'] = array();
      foreach($guestList as $guestItem) {
         $item = array('name' => $guestItem['pr_name_last'] . ($guestItem['pr_name_first'] != ""?", ".$guestItem['pr_name_first']:""));				 	
         if(trim($guestItem['pr_guest_note']) != "") {
            $item['guestNote'] = "x";
         } else {
            $item['guestNote'] = "";
         }
         if(trim($guestItem['pr_guest_memo']) != "") {
            $item['guestMemo'] = "x";
         } else {
            $item['guestMemo'] = "";
         }

         for($count2 = 0; $count2 < 4; $count2++) {
            if( ($count * 4) + $count2 < sizeof($itemList) ) {
               $guestRoom = $lDB->get("
                  SELECT
                  ac_accomm_room.ac_desc,
                  rv_res_item_group.rv_room_requested_yn,
                  rv_res_item_group.rv_res_item_group_ix as id,
				  rv_reservation_item.rv_item_date_arrive,
				  rv_reservation_item.rv_item_date_depart,
				  rv_reservation_item.rv_item_adult_count,
				  rv_reservation_item.rv_item_child_count,
				  pr_business.pr_bus_name_short,
				  ac_accomm_type.ac_accomm_name_short
				FROM
					rv_reservation_item
					INNER JOIN pr_business ON pr_business.pr_business_id = rv_reservation_item.pr_business_id
					INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
					INNER JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
					LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
					INNER JOIN rv_res_item_guest ON rv_res_item_guest.rv_res_item_group_id = rv_res_item_group.rv_res_item_group_ix
					INNER JOIN pr_guest ON pr_guest.pr_guest_id = rv_res_item_guest.pr_guest_id
               WHERE
					rv_reservation_item.rv_reservation_item_ix = '".$itemList[($count * 4) + $count2]."'
					AND rv_res_item_guest.pr_guest_id = '" . $guestItem['pr_persona_ix'] . "'
               ",1);
			   if($guestRoom !== false) {
				//debug($guestRoom);
				if($guestRoom['ac_desc'] == "" || $guestRoom['ac_desc'] == "0") {
					$groupKey = array_search($guestRoom['id'],$groupName);
					if($groupKey === false) {
						$guestRoom['ac_desc'] = "";
					} else {
						$guestRoom['ac_desc'] = "(" . strtolower(IntToRoman($groupKey+1)) . ")";
					}
				}
				$item["item".($count2+1)] = $guestRoom['ac_desc'];
				if($guestRoom['rv_room_requested_yn'] == "1") {
					$item["item".($count2+1)."Lock"] = "";
				} else {
					$item["item".($count2+1)."Lock"] = "display:none;";
				}
					$row['itemHeader'.($count2+1)] = 
						"Arr: " . chng_date($guestRoom['rv_item_date_arrive'],"-") . "<BR>" . 
						"Dep: " . chng_date($guestRoom['rv_item_date_depart'],"-") . "<BR>" .
						"Prop: " . $guestRoom['pr_bus_name_short'].", ".$guestRoom['ac_accomm_name_short']."<BR>" .
						"Adult: " .$guestRoom['rv_item_adult_count'] . "<BR>" .
						"Child: " .$guestRoom['rv_item_child_count'];
			   } else {
					$item["item".($count2+1)] = "";
					$item["item".($count2+1)."Lock"] = "";
					$row['itemHeader'.($count2+1)] = "";
		       }
					
            } else {
               $item["item".($count2+1)] = "";
               $item["item".($count2+1)."Lock"] = "display:none;";
               //$item[guestNote] = "";
               //$item[guestMemo] = "";
    		   $row['itemHeader'.($count2+1)] = "&nbsp;";
        }

         }
         array_push($row['rows'],$item);
      }
      $row['rows']['html'] = __DIR__ . "/../../../public/html/rep_detbilling_guest_group_rows.htm";
      $row['htmlRow'] = true;
      array_push($guestGroup,$row);
   }

//   debug($guestGroup);
   $notes = array();
   $memos = array();

   foreach($guestList as $item) {
      $name = $item['pr_name_last'] . ($item['pr_name_first'] != ""?", ".$item['pr_name_first']:"");
      if(trim($item['pr_guest_note']) != "") {
         array_push($notes,array('name'=>$name, 'note'=>$item['pr_guest_note']));
      }
      if(trim($item['pr_guest_memo']) != "") {
         array_push($memos,array('name'=>$name, 'note'=>$item['pr_guest_memo']));
      }
   }

   return array('guests'=>$guestList, 'rooms'=>$roomList, 'guestGroups'=>$guestGroup, 'notes'=>$notes, 'memos'=>$memos);
}

function getGuestNames($groupId){
	global $lDB;
	$guestList = $lDB->get("
		SELECT 
			pr_persona.pr_name_first as guestF,
			pr_persona.pr_name_last as guestL,
			pr_guest.pr_guest_primary_yn as guestPrim
		FROM 
			rv_res_item_guest
		INNER JOIN pr_persona ON 
			pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id 
		INNER JOIN pr_guest ON 
			pr_guest.pr_guest_id = rv_res_item_guest.pr_guest_id 
		WHERE 
			rv_res_item_guest.rv_res_item_group_id = '" . $groupId . "' 
		ORDER BY 
			pr_guest.pr_guest_primary_yn DESC,
			pr_persona.pr_name_last
	",2);

	if ( sizeof($guestList) > 0 ) {
		$max = count($guestList);
		for ( $i = 0; $i < $max; $i++ ) { 
		//foreach ( $guestList as $guestName ) {
			$guestName = $guestList[$i];
			$guestItem = array('guestName'=>"");
			if ( $guestName['guestL'] && $guestName['guestF'] ) {
				$guestItem['guestName'] .= $guestName['guestF'] . " " . $guestName['guestL'];
			}

			if ( $guestName['guestL'] && !$guestName['guestF'] ) {
				$guestItem['guestName'] .= $guestName['guestL'];
			}

			if ( $guestName['guestF'] && !$guestName['guestL'] ) {
				$guestItem['guestName'] .= $guestName['guestF'];
			}
			if ( $i < $max - 1 ) {
				$guestItem['guestName'] .= "<BR>";
			}
		}
		return $guestItem;
	}
	return false;
	
}

function getCellClass($arrivalDate, $departureDate, $checkInStatus, $rv_grp_status_time, $rf_reservation_status_id, $pdf = false) {

/*
.bcRoomInOld { background-color: #8a7a75; } GREY
.bcRoomIn { background-color: #2868DE; } BLUE 
.bcRoomCheckIn { background-color: #0EB64D; } GREEN
.bcRoomNoShow { background-color: #D62323; } RED
.bcRoomCheckOut { background-color: #FBB60F; } ORANGE 
.bcRoomFuture { background-color: #000000; } BLACK
.bcRoomEarly { #9255a4 } PURPLE
*/
	$today = date("Y-m-d");

	if($rf_reservation_status_id == 25) {
		if(!$pdf) {
			return "bcRoomCheckIn";
		} else {
			return array(0x0e,0xb6,0x4d);
		}
	}
	
	if($departureDate < $today) {
		if(!$pdf) {
			return "bcRoomInOld";
		} else {
			return array(0xb6,0xb6,0xb6);
		}
	}
	if($arrivalDate == $today && ($checkInStatus <= 2 || $checkInStatus > 5) ) {
		if(!$pdf) {
			return "bcRoomCheckOut";
		} else {
			return array(0xfb,0xb6,0x0f);
		}
	}
	if($departureDate == $today && $checkInStatus == 5) {
		if(!$pdf) {
			return "bcRoomNoShow";
		} else {
			return array(0xd6,0x23,0x23);
		}
	}
	/*
	if($checkInStatus == 5) {
		if(!$pdf) {
			return "bcRoomIn";
		} else {
			return array(0x28,0x68,0xde);
		}
	}*/
	// [START] Late checkout
	if($checkInStatus == 5 && $departureDate > $today) {
		if(!$pdf) {
			return "bcRoomIn";
		} else {
			return array(0x28,0x68,0xde);
		}
	}
	if($checkInStatus == 5 && $departureDate < $today) {
		if(!$pdf) {
			return "bcRoomLate";
		} else {
			debug($checkInStatus);
			return array(0x28,0xcb,0xde);
		}
	}
	// [END] Late Checkout
	if($checkInStatus == 8) {
		$timeSplit = explode(" ", $rv_grp_status_time);
		if($departureDate != $timeSplit[0]) {
			if(!$pdf) {
				return "bcRoomEarly";
			} else {
				return array(0x92,0x55,0xa4);
			}
		}
	}
	//default?
	if(!$pdf) {
		return "bcRoomFuture";
	} else {
		return array(0x00,0x00,0x00);
	}
}

function getGuestNamesCalendar($rv_res_item_group_id) {
	global $lDB;
	$guestNameList = $lDB->get("
		SELECT
			pr_persona.pr_name_last,
			pr_persona.pr_name_first
		FROM
			rv_res_item_guest
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
		WHERE
			rv_res_item_guest.rv_res_item_group_id = '" . $rv_res_item_group_id . "'
	",2);

	$guestNames = "";

	foreach ( $guestNameList as $item ) {
		$guestName = trim($item['pr_name_first'] . " " . $item['pr_name_last']);

		if ( $guestNames != "" && $guestName != "" ) {
			$guestNames .= ", ";
		}
		$guestNames .= $guestName;
	}
	return $guestNames;
}
