<?php

/**
 * init.form305.php - Room Checkout
 * Job: 235
 * Function: 81
 */

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/room_checkOut.htm");
}

if($GLOBALS['jobLevelArray'][235] < 10) {
	$readonly = true;
	$disabled = $GLOBALS['temp']['disabled'] = "disabled";
} else {
	$readonly = false;
	$disabled = $GLOBALS['temp']['disabled'] = "";
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

$allowInvoiceCreate = $GLOBALS['funLevelArray'][108] >= 10;
$allowInvoiceVoid = db_sc_group_get_user_setting("sc_grp_res_void_invoice_yn") == "1";

$rv_res_item_group_id = $_SERVER['argv'][1];
$ac_accomm_room_id = $_SERVER['argv'][2];
$rv_reservation_item_id = $_SERVER['argv'][3];

$GLOBALS['temp']['groupId'] = $rv_res_item_group_id;

$resInfo = $GLOBALS['lDB']->get("
	SELECT
		rv_reservation.rv_reservation_ix,
		rv_reservation.rv_res_name,
		rv_reservation_item.rv_item_date_depart
	FROM
		rv_reservation_item
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
	WHERE
		rv_reservation_item.rv_reservation_item_ix = '$rv_reservation_item_id'
",1);

$GLOBALS['temp']['rv_reservation_ix'] = $resInfo['rv_reservation_ix'];
$GLOBALS['temp']['rv_res_name'] = $resInfo['rv_res_name'];
$GLOBALS['temp']['expectedDate'] = chng_date($resInfo['rv_item_date_depart'],"-");
$GLOBALS['temp']['todayDate'] = date("Y-m-d");
$GLOBALS['temp']['todayYear'] = date("Y");
$GLOBALS['temp']['todayMonth'] = date("m");
$GLOBALS['temp']['todayDay'] = date("d");
$GLOBALS['temp']['allowDateChange'] = "0";
if($GLOBALS['jobLevelArray'][$_SERVER['argv'][0]] == 15) {
	$GLOBALS['temp']['allowDateChange'] = "1";
} 

// START - Process any invoice requests

$fiscal_status = '';
$fiscalMessage = '';
$fiscalStatusHidePdf = '';
$fiscalStatusHide = "display: none; ";

$fiscalStatusCheck = updateIncompleteFiscalInvoices();

$fiscalise = false;
$invoiceArray = array();
if(!$readonly && isset($_POST['invoiceFolio']) && $_POST['invoiceFolio'] && isset($_POST['invoiceDate']) && $_POST['invoiceDate'] && $allowInvoiceCreate) {
	$newInvoice = db_fn_invoice_create($_POST['invoiceFolio'], $_POST['invoiceDate'], $_POST['invoiceExch']);
	$fiscalise = checkFiscalisationByInvoice($newInvoice);
	array_push($invoiceArray,$newInvoice);
}

if(!$readonly && isset($_POST['voidId']) && $_POST['voidId'] && $allowInvoiceVoid) {
	db_fn_invoice_void($_POST['voidId']);
}

// END   - Process any invoice requests

$folioRowHTML = "
	<tr valign=\"top\" !fiscalMessage!>
		<td class=\"br\"><input type=\"checkbox\" name=\"folioCheck\" id=\"!fn_folio_ix!\" style=\"position:relative; top:-2;\"></td>
		<td class=\"br\" id=\"folio\">
			<table cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">
				<tr valign=\"top\">
					<td width=\"40%\" class=\"!textClass!\">!fn_folio_folio_num!</td>
					<td class=\"!textClass!\">!payee_name!</td>
				</tr>
			</table>
		</td>  
		<td class=\"br !textClass!\" id=\"payPlan\">!ac_pay_plan_desc!</td>
		<td class=\"br !textClass!\" id=\"env\" align=\"center\">!fn_folio_db!</td>
		<td class=\"br !textClass!\" id=\"nett\" align=\"right\">!fn_folio_amount! !rf_currency_symbol!</td>
		<td class=\"br !textClass!\" id=\"paid\" align=\"right\">!fn_folio_amt_paid! !rf_currency_symbol!</td>
		<td class=\"br !outstandingClass!\" id=\"outstand\" align=\"right\">!fn_folio_outstanding! !rf_currency_symbol!</td>
		<td>
			<input type=\"button\" class=\"button bPDF !fiscalHidePdf!\" style=\"width:18; height:18;\" onclick=\"openPDF('!fn_folio_ix!','!fn_invoice_ix!');\" onmouseover=\"overlib('<span class=txts>Open document (folio/invoice) as PDF</span>',LEFT,WIDTH,200);\" onmouseout=\"nd();\">
			<input type=\"button\" class=\"button bFolio\" style=\"width:18; height:20; background-position:center; \"  onclick=\"showFolio('!fn_folio_ix!','!fn_invoice_ix!');\" onmouseover=\"overlib('<span class=txts>Open document (folio/invoice)</span>',LEFT,WIDTH,160);\" onmouseout=\"nd();\">
			<input $disabled type=\"button\" class=\"button bCoins\" style=\"width:20; height:20;\" onclick=\"event.cancelBubble = true; nd(); showPaymentPopup(event,'!fn_folio_ix!','!rv_reservation_ix!');\" onMouseOver=\"overlib('<span class=txts>Payments</span>',LEFT,WIDTH,77)\"; onMouseOut=\"nd()\">
			<input $disabled type=\"button\" class=\"button bGenInvoice\" style=\"width:20; height:20; !showInvoiceButton! background-position:center;\" onclick=\"event.cancelBubble = true; showHide(event,'!fn_folio_ix!',!exchangeNeeded!,!exchangeRate!,'!rf_currency_symbol!','!business_currency_symbol!','!invoiceDate!','!invoiceMaxDate!','!allowFutureInvoice!',!outstanding!);\" onMouseOver=\"overlib('<span class=txts>Generate invoice</span>',LEFT,WIDTH,110)\"; onMouseOut=\"nd()\">
			<input $disabled type=\"button\" class=\"button bVoid\" style=\"width:18; height:18; !showVoidButton! background-position:center;\" onMouseOver=\"overlib('<span class=txts>Void invoice</span>',LEFT,WIDTH,90,OFFSETX,15)\"; onMouseOut=\"nd()\" onclick=\"event.cancelBubble = true; voidInvoice('!fn_invoice_ix!','!hasBatch!');\">
			<button $disabled type=\"button\" class=\"button \" style=\"width:20; height:20; padding:0; !fiscalStatusHide!\" onmouseover=\"overlib('<span class=txts>Query fiscal status</span>',LEFT,WIDTH,120);\" onmouseout=\"nd();\" onclick=\"event.cancelBubble = true; showFiscalInfoByInvoice('!folioNum!');\">!fiscal_status!</button>
		</td>
	</tr>
";

$folioList = $GLOBALS['lDB']->get("
	SELECT
		fn_folio.fn_folio_db,
		fn_folio.fn_folio_ix,
		fn_folio.fn_folio_folio_num,
		fn_folio.fn_folio_amount,
		fn_folio.fn_folio_amt_paid,
		(fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) as fn_folio_outstanding,
		rf_currency.rf_currency_symbol,
		ac_pay_plan.ac_pay_plan_desc,
		pr_persona.pr_persona_ix,
		pr_persona.pr_name_first,
		pr_persona.pr_name_last,
		rv_reservation.rv_reservation_db,
		rv_reservation.rv_reservation_ix,
		rv_reservation.rv_invoice_currency_id,
		rv_reservation.rf_reservation_status_id,
		fn_folio.rf_currency_id,
		folio_database.rf_db_env_type_ind as folio_env_ind,
		reservation_database.rf_db_env_type_ind as reservation_env_ind,
		pr_business.pr_bus_home_curr_id as business_currency_id,
		business_currency.rf_currency_symbol as business_currency_symbol,
		fn_invoice.fn_invoice_ix,
		fn_invoice.fn_inv_status_ind,
		fn_invoice.fn_inv_fiscal_status_ind,
		ac_accomm_room.ac_desc,
		fn_batch.fn_batch_ix,
		fn_batch.fn_batch_closed_yn,
		fn_folio.fn_folio_date AS invoiceDate
	FROM
		fn_folio
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_folio.rv_reservation_id
		LEFT JOIN ac_pay_plan ON ac_pay_plan.ac_pay_plan_ix = rv_reservation.ac_pay_plan_id
		INNER JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
		LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = fn_folio.fn_folio_to_id
		INNER JOIN rf_database as folio_database ON fn_folio.fn_folio_db = folio_database.rf_db_code
		INNER JOIN rf_database as reservation_database ON fn_folio.fn_folio_db = reservation_database.rf_db_code
		INNER JOIN pr_business ON pr_business.pr_business_id = fn_folio.pr_business_id
		INNER JOIN rf_currency AS business_currency ON business_currency.rf_currency_ix = pr_business.pr_bus_home_curr_id
		LEFT JOIN fn_invoice ON fn_invoice.fn_folio_id = fn_folio.fn_folio_ix AND fn_invoice.fn_inv_status_ind <> 8
		LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = fn_folio.rv_res_item_group_id
		LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		LEFT JOIN fn_tran ON fn_tran.fn_tran_link_id = fn_invoice.fn_invoice_ix AND fn_tran.fn_tran_link_ind = ".DB_FN_TRAN_LINK_INVOICE."
		LEFT JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
	WHERE
		fn_folio.rv_reservation_id = '$resInfo[rv_reservation_ix]'
	ORDER BY
		(ac_accomm_room.ac_desc+0),ac_accomm_room.ac_desc,fn_folio.fn_folio_folio_num
",2);

$folioRows = "";
$hasOutstanding = false;
foreach($folioList as $item) {
	$item['allowFutureInvoice'] = (db_fn_invoice_allow_future_date($item['fn_folio_ix'])?"1":"0");
	$item['invoiceMaxDate'] = db_fn_invoice_max_date($item['fn_folio_ix']);

	$folioPaid = $GLOBALS['lDB']->get("
			SELECT
				SUM(rv_payment_item.rv_payment_item_amt)
			FROM
				rv_payment_item
			WHERE
				rv_payment_item.fn_folio_id = '$item[fn_folio_ix]'
	
	",4);
	$item['fn_folio_amt_paid'] = $folioPaid;
	$item['fn_folio_outstanding'] = $item['fn_folio_amount'] - $item['fn_folio_amt_paid'];
	if($item['fn_folio_outstanding'] > 0) {
		$item['outstandingClass'] = "txtred";
		$hasOutstanding = true;
	} else {
		$item['outstandingClass'] = "txt";
	}
	if(isset($item['pr_persona_ix'])) {
		$item['payee_name'] = trim($item['pr_name_first'] . " " . $item['pr_name_last']);
	} else {
		$item['payee_name'] = "Cash";
	}
	if(trim($item['ac_desc']) != "") {
		if($item['fn_folio_db'] != $dbcode) {
			$item['payee_name'] .= " ($item[ac_desc])";
		} else {
			$item['payee_name'] .= " (<b>$item[ac_desc]</b>)";
		}
	}
	if(!canEditDB($item['fn_folio_db'])) {
		$item['textClass'] = "txtg";
		if($item['outstandingClass'] == "txt") {
			$item['outstandingClass'] = "txtg";
		}
	} else {
		$item['textClass'] = "";
	}

	fixAmtDisplay($item['fn_folio_amount'],2);
	fixAmtDisplay($item['fn_folio_amt_paid'],2);
	fixAmtDisplay($item['fn_folio_outstanding'],2);

	// Payment plan items are all in the res invoice currency
	if($item['rf_currency_id'] != $item['rv_invoice_currency_id']) {
		$item['ac_pay_plan_desc'] = "None";
	}		

	// payment plan items are all at the same env level for 2 (RS/WA/WB) ...
	if($item['reservation_env_ind'] == "2") {
		if($item['folio_env_ind'] == "4") {
			$item['ac_pay_plan_desc'] = "None";
		}
	} else { // .. and the same db code for level 4
		if($item['fn_folio_db'] != $item['rv_reservation_db']) {
			$item['ac_pay_plan_desc'] = "None";
		}			
	}
	if(trim($item['ac_pay_plan_desc']) == "" || $item['ac_pay_plan_desc'] == "0") {
		$item['ac_pay_plan_desc'] = "&nbsp;";
	}
	$item['outstanding'] = $item['fn_folio_amount'] - $item['fn_folio_amt_paid'];

	$exchangeNeeded = "false";
	if($item['rf_currency_id'] != $item['business_currency_id']) {
		// An exchange rate is required...
		$exchangeNeeded = "true";
		$exchangeRate = db_rf_exchange_rate_get_rate_by_all($item['rf_currency_id'],$item['business_currency_id']);
		if(empty($exchangeRate)) {
			$exchangeRate = "''";
		}		
	} else {
		$exchangeNeeded = "false";
		$exchangeRate = "1";
	}
	$item['exchangeNeeded'] = $exchangeNeeded;
	$item['exchangeRate'] = $exchangeRate;

	$item['showInvoiceButton'] = "";
	$item['showVoidButton'] = " visibility: hidden; ";
	$item['doc'] = "bFolio";
	$item['openDoc'] = "openPDF('$item[fn_folio_ix]')";
	$item['docOverlib'] = "<span class=txts>View Proforma</span>";    

	$hasTBA = false;
	$resItemList = $GLOBALS['lDB']->get("SELECT rv_reservation_item_ix FROM rv_reservation_item WHERE rv_reservation_id = '$item[rv_reservation_ix]'",3);
	foreach($resItemList as $resItem) {
		$resCompCount = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM rv_res_item_comp WHERE rv_reservation_item_id = '$resItem'",4);
		if($resCompCount < 1) { $hasTBA = true; }
	}
	$allowInvoice = $item['rf_reservation_status_id'] >= 30 && canEditDB($item['fn_folio_db']) && !$hasTBA && $allowInvoiceCreate;
	$invoiceExists = trim($item['fn_invoice_ix']) != "" && $item['fn_inv_status_ind'] != "8";
	if($invoiceExists) {
		$item['fn_folio_folio_num'] = $item['fn_invoice_ix'];
	} else {
		$item['fn_folio_folio_num'] = "Folio " . $item['fn_folio_folio_num'];
	}
	
	if( $invoiceExists || !$allowInvoice) {
		$item['showInvoiceButton'] = " visibility: hidden; ";
		if($invoiceExists && canEditDB($item['fn_folio_db'])) {
			$item['showVoidButton'] = "";
			if(!$allowInvoiceVoid) {
				$item['showVoidButton'] = " visibility: hidden; ";
			}
			if($item['fn_batch_ix'] != "") {
				$item['hasBatch'] = "1";
				if($item['fn_batch_closed_yn'] == "1") {
					$item['showVoidButton'] = " visibility: hidden; ";
				}
			}
			$item['doc'] = "bInvoice";
			$item['openDoc'] = "openPDF('$item[fn_folio_ix]','$item[fn_invoice_ix]')";
			$item['docOverlib'] = "<span class=txts>View Invoice</span>";
		}
	}

	$isTBA = false;
	$folioResItemList = $GLOBALS['lDB']->get("SELECT rv_reservation_item_ix FROM rv_reservation_item WHERE fn_folio_id = '$item[fn_folio_ix]'",3);
	foreach($folioResItemList as $resItem) {
		$resCompCount = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM rv_res_item_comp WHERE rv_reservation_item_id = '$resItem'",4);
		if($resCompCount < 1) { $isTBA = true; }
	}
	if($isTBA) {
		$item['fn_folio_amount'] = "TBA";
		$item['fn_folio_outstanding'] = "TBA";
	}

	$fiscal_status = '';
	$fiscalMessage = '';
	$fiscalStatusHidePdf = '';
	$fiscalStatusHide = " display: none; ";

	if (checkFiscalisationByInvoice($item['fn_invoice_ix'])) {
		// 1 = Pending, 2 = Verified, 3 = Rejected, 4 = Error, 9 = Zero folio
		
		$fiscalStatusHidePdf = " hidden";
		$fiscalStatusHide = "";
		$fiscal_status = '<i class="material-icons txtred">report</i>';
		$item['showVoidButton'] = " visibility: hidden; ";

		switch ($item['fn_inv_fiscal_status_ind']) {
			case 1:
				$fiscalMessage = "title='Fiscal status: Pending'";
				break;
			case 2:
				$fiscalMessage = "title='Fiscal status: Verified'";
				$fiscalStatusHidePdf = '';
				$fiscal_status = '<i class="material-icons">check_circle</i>';
				break;
			case 3:
				$fiscalMessage = "title='Fiscal status: Rejected'";
				break;
			case 4:
				$fiscalMessage = "title='Fiscal status: Error'";
				break;
			case 9:
				$fiscalMessage = "title='Fiscal status: Zero total not submitted'";
				$fiscalStatusHidePdf = '';
				$fiscal_status = '';
				break;
			default:
				$fiscalMessage = "title='Fiscal status: Not Submitted'";
		}
	}
	$item['fiscal_status'] = $fiscal_status;
	$item['fiscalStatusHidePdf'] = $fiscalStatusHidePdf;
	$item['fiscalStatusHide'] = $fiscalStatusHide;
	$item['fiscalMessage'] = $fiscalMessage;
	$item['folioNum'] = $item['fn_invoice_ix'];
	
	$folioRows .= showpage($item,$folioRowHTML);
}
if($hasOutstanding) {
	$GLOBALS['temp']['titleText'] = "There are amounts outstanding on this reservation: ";
	$GLOBALS['temp']['titleClass'] = "txtred";
	$GLOBALS['temp']['titleBoldClass'] = "txtbred";
} else {
	$GLOBALS['temp']['titleText'] = "This reservation is full paid: ";
	$GLOBALS['temp']['titleClass'] = "txt";
	$GLOBALS['temp']['titleBoldClass'] = "txtb";
}

$GLOBALS['temp']['folioRows'] = $folioRows;

$GLOBALS['temp']['rf_doc_settings'] = $GLOBALS['lDB']->get("SELECT rf_doc_settings FROM rf_default",4);

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(), 1));
