<?php

require_once(__DIR__ . "/db.ac_pos_map.php");
require_once(__DIR__ . "/db.ac_pos_map_accomm.php");
require_once(__DIR__ . "/db.pr_business.php");
require_once(__DIR__ . "/db.rf_db_business.php");

function listMappings($ac_pos_id) {
	global $lDB;

	if(!db_ac_pos_exists($ac_pos_id)) {
		return [];
	}

	$pos_property_id = $lDB->get("SELECT pr_business_id FROM ac_pos WHERE ac_pos.ac_pos_ix = '" . $lDB->escape($ac_pos_id) . "'",4);
	$pr_business_id = db_pr_business_get_billing($pos_property_id, DB_PR_BUSINESS_BILLING_PROPERTY);
	$ac_pos_stock_default_id = $lDB->get("SELECT ac_pos_stock_id FROM ac_pos WHERE ac_pos.ac_pos_ix = '" . $lDB->escape($ac_pos_id) . "'",4);

	$propertyAcl = $lDB->get("
		SELECT DISTINCT
			ac_accomm_type.pr_business_id
		FROM
			sc_accomm
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = sc_accomm.ac_accomm_type_id
		WHERE
			sc_accomm.sc_group_id = '" . $lDB->escape($GLOBALS['sc_group_id']) . "'
	",3);

	return $lDB->get("
		SELECT DISTINCT
			ac_pos_stock.ac_pos_stock_ix,
			ac_pos_stock.ac_pos_stock_code,
			ac_extra.ac_ext_desc,
			IF(ac_pos_stock.ac_pos_stock_ix = '" . $lDB->escape($ac_pos_stock_default_id) . "',1,0) AS default_yn,
			IF(ac_pos_map.ac_pos_map_ix IS NOT NULL,1,0) AS allocated_yn
		FROM
			ac_pos_stock
			INNER JOIN ac_extra ON ac_extra.ac_extra_ix = ac_pos_stock.ac_extra_id
			INNER JOIN ac_extra_prop ON ac_extra_prop.ac_extra_id = ac_extra.ac_extra_ix
			LEFT JOIN ac_pos_map ON
				ac_pos_map.ac_pos_stock_id = ac_pos_stock.ac_pos_stock_ix
				AND ac_pos_map.ac_pos_id = '" . $lDB->escape($ac_pos_id) . "'
		WHERE
			ac_pos_stock.pr_business_id = '" . $lDB->escape($pr_business_id) . "'
			AND (
				ac_extra_prop.pr_business_id = '" . $lDB->escape($pos_property_id) . "'
				OR ac_pos_map.ac_pos_map_ix IS NOT NULL
				OR ac_pos_stock.ac_pos_stock_ix = '" . $lDB->escape($ac_pos_stock_default_id) . "'
			)
		ORDER BY
			ac_pos_stock.ac_pos_stock_code
	",6);
}

function saveMappings($ac_pos_id, $stock_items) {
	global $lDB;

	if(!db_ac_pos_exists($ac_pos_id)) {
		return [];
	}

	$default_pos_stock_id = "";
	$allocated_ids = [];
	foreach($stock_items as $item) {
		if($item['default_yn'] == "1") {
			$default_pos_stock_id = $item['ac_pos_stock_ix'];
		}
		if($item['allocated_yn'] == "1") {
			$allocated_ids[] = $item['ac_pos_stock_ix'];
		}
	}

	db_ac_pos_set_pos_stock($ac_pos_id, $default_pos_stock_id);
	db_ac_pos_map_bulk_update($ac_pos_id, $allocated_ids);

	return true;
}
