<?php

/**
 * init.form308.php - POS code table detail
 * Job: 236, 237, 238, 239, 240, 241
 * Function: 86 (Code Tables: POS)
*/

$jobLevel = checkJob(236,2);
$GLOBALS['temp']['readOnly'] = ($jobLevel < 10) ? "true" : "false";
$GLOBALS['temp']['readOnlyDisabled'] = ($jobLevel < 10) ? "disabled" : "";

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

$postAction = $_POST['action'] ?? "";
if(!empty($postAction)) {
	$response = false;

	switch($postAction) {
	case "list_mappings":
		$ac_pos_id = $_POST['ac_pos_id'] ?? "";
		$response = listMappings($ac_pos_id);
		break;
	case "save_mappings":
		if($jobLevel < 10) {
			$response = false;
		} else {
			$ac_pos_id = $_POST['ac_pos_id'] ?? "";
			$stock_items = json_decode($_POST['stock_items'],true);
			$response = saveMappings($ac_pos_id, $stock_items);
		}
		break;
	}
	echo json_encode($response);
	die();
}

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/code_pos.htm");
	$fields = array(
		"ac_pos_ix",
		"pr_business_id",
		"ac_pos_name",
		"ac_pos_name_rr",
		"ac_pos_stock_id",
		"rv_reservation_id",
		"rf_bank_id",
		"ac_cash_period_ind",
		"ac_cash_folio_ind",
		"ac_inactive_yn"
	);
	$ident = array("rf_country_name");
	$GLOBALS[$form]->AddTable($GLOBALS['lDB'],"ac_pos",$fields,"ac_pos_ix = '$record'","","",$ident);
}

$record = $_SERVER['argv'][1];
$GLOBALS['autovar'] = "1";
if($record != "") {
	$GLOBALS['passthrurecord'] = $record;
} else {
	if($action != "2") {
		$record = $GLOBALS['passthrurecord']??"";
		if($_SERVER['argv'][1] == "") {
			$_SERVER['argv'][1] = $record;
		}
	}
}
$GLOBALS['temp']['record'] = $record;


$GLOBALS[$form]->Get($action);

$hideList = array();
$disablelist = array();

if($action == "3" && !canEditDB($GLOBALS['form308_ac_pos_ac_pos_db']->Value)) {
	$action = "1";
	$disablelist[] = "form308_ac_pos_ac_pos_name";
	$disablelist[] = "form308_ac_pos_ac_pos_name_rr";
	$disablelist[] = "form308_ac_pos_ac_cash_period_ind";
	$disablelist[] = "form308_ac_pos_ac_cash_folio_ind";
	$disablelist[] = "form308_ac_pos_rv_reservation_id";
	$disablelist[] = "form308_ac_pos_rf_bank_id";
	$GLOBALS['temp']['readOnly'] = "true";
	$GLOBALS['temp']['readOnlyDisabled'] = "disabled";
}

$table = $GLOBALS[$form]->TableList[0];

if($record != "" || $action == "3" && $action != "1") {
	$GLOBALS[$table]->Refresh($record,$action);
}

if(db_ac_pos_has_default($record) || db_ac_pos_map_exists_by_pos($record)) {
	$disablelist[] = "form308_ac_pos_pr_business_id";
}


if($action == "2") {
	$GLOBALS['form308_ac_pos_ac_pos_db']->SetValue($dbcode);
}

$propertyAcl = $lDB->get("
	SELECT DISTINCT
		ac_accomm_type.pr_business_id
	FROM
		sc_accomm
		INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = sc_accomm.ac_accomm_type_id
	WHERE
		sc_accomm.sc_group_id = '" . $lDB->escape($GLOBALS['sc_group_id']) . "'
",3);

$GLOBALS[$form.'_ac_pos_pr_business_id']->Select(combolist($lDB,"
	SELECT
		pr_business.pr_business_id,
		pr_persona.pr_name_last
	FROM
		pr_business
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
	WHERE
		pr_business.pr_bus_property_yn = '1'
		AND pr_business.pr_business_id IN ('" . join("','",$propertyAcl) . "')
	ORDER BY
		pr_persona.pr_name_last
","0:|:"));
$GLOBALS[$form.'_ac_pos_pr_business_id']->StyleType = "uk-select select2";

$billingPropertyId = db_pr_business_get_billing($GLOBALS['form308_ac_pos_pr_business_id']->Value, DB_PR_BUSINESS_BILLING_PROPERTY);
$GLOBALS['temp']['business_name_last'] = "";
if($billingPropertyId != "") {
	$GLOBALS['temp']['business_name_last'] = $lDB->get("
		SELECT
			pr_persona.pr_name_last
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '" . $lDB->escape($billingPropertyId) . "'
	",4);
}

$GLOBALS['form308_ac_pos_ac_pos_name_rr']->TabIndex = 1;
$GLOBALS['form308_ac_pos_ac_pos_name_rr']->Size = 40;
$GLOBALS['form308_ac_pos_ac_pos_name_rr']->StyleType = "uk-input";

$GLOBALS['form308_ac_pos_ac_pos_name']->TabIndex = 2;
$GLOBALS['form308_ac_pos_ac_pos_name']->Size = 15;
$GLOBALS['form308_ac_pos_ac_pos_name']->StyleType = "uk-input";
$dbInfo = $GLOBALS['lDB']->get("
	SELECT
		rf_db_description
	FROM
		rf_database
	WHERE
		rf_db_code = '$GLOBALS[dbcode]'
",4);

$GLOBALS['form308_ac_pos_rv_reservation_id']->TabIndex = 3;
$GLOBALS['form308_ac_pos_rv_reservation_id']->Size = 15;
$GLOBALS['form308_ac_pos_rv_reservation_id']->StyleType = "uk-input";

$GLOBALS[$form.'_ac_pos_rf_bank_id']->Select(
	combolist($lDB,"
		SELECT 
			rf_bank_ix as rf_bank_id, rf_bank_acc_name 
		FROM 
			rf_bank
		WHERE (rf_bank_acc_no = '' OR rf_bank_acc_no is null) 
		AND (rf_currency_id != '' AND rf_currency_id is not null)
		AND (rf_bank_acc_name != '' AND rf_bank_acc_name is not null)
		AND (rf_bank_abbrev != '' AND rf_bank_abbrev is not null)
		AND rf_bank_sys_code = '0'
		AND 
			!rf_bank_inactive_yn
	","0:|:"));

$GLOBALS[$form.'_ac_pos_rf_bank_id']->StyleType = "uk-select select2";

$GLOBALS[$form.'_ac_pos_ac_cash_period_ind']->Select(array(
	"0:|:",
	"1:|:Daily",
	"2:|:Weekly",
	"3:|:Monthly"
));
$GLOBALS[$form.'_ac_pos_ac_cash_period_ind']->StyleType = "uk-select select2";

$GLOBALS[$form.'_ac_pos_ac_cash_folio_ind']->Select(array(
	"0:|:",
	"1:|:Consolidate by currency",
	"2:|:Split by transaction"
));
$GLOBALS[$form.'_ac_pos_ac_cash_folio_ind']->StyleType = "uk-select select2";


$GLOBALS['temp']['form308_ac_pos_environment'] = "";
if(trim($GLOBALS['form308_ac_pos_pr_business_id']->Value) != "") {
	$propertyDb = $lDB->get("
		SELECT
			rf_database.rf_db_code,
			rf_database.rf_db_description
		FROM
			rf_database
		WHERE
			rf_db_code = '" . $lDB->escape(db_rf_db_business_get_by_business($GLOBALS['form308_ac_pos_pr_business_id']->Value)) . "'
	",1);
	if(!empty($propertyDb)) {
		$GLOBALS['temp']['form308_ac_pos_environment'] = $propertyDb['rf_db_description'] . " (" . $propertyDb['rf_db_code'] . ")";
	}
}

$actVal = "0";
$inActVal = "1";
$actFlag = "form308_ac_pos_ac_inactive_yn";
if ($GLOBALS[$actFlag]->Value == $actVal || $action == "2") {
	$GLOBALS[$actFlag]->Value = $actVal;
	$GLOBALS['temp']['actInd'] = " style=\"display:none\"";
	$hideList[] = $actFlag;
} else {
	if ($record == "" && $action == "1") {
		$GLOBALS['temp']['actInd'] = " style=\"display:none\"";
	} else {
		$GLOBALS[$actFlag]->Value = $inActVal;
		$GLOBALS['temp']['actInd'] = "";
	}
}
$GLOBALS[$actFlag]->Select(array("$inActVal-Inactive","$actVal-Active"));
$GLOBALS[$actFlag]->StyleType = "uk-select select2";


$disablelist[] = "form308_ac_pos_ac_pos_stock_id";
$GLOBALS[$form]->Hide($hideList);
$GLOBALS[$form]->Disable($disablelist);

$table = $GLOBALS[$form]->TableList[0];

$GLOBALS['temp']['envCodes'] = "var envCodes = new Array();";
$GLOBALS['temp']['currCode'] = $GLOBALS['form308_ac_pos_ac_pos_name']->Value;
$GLOBALS['temp']['saved_property_id'] = $GLOBALS['form308_ac_pos_pr_business_id']->Value;

$envCodeList = $GLOBALS['lDB']->get("SELECT ac_pos_name FROM ac_pos WHERE ac_pos_db = '$GLOBALS[dbcode]'",3);
if(sizeof($envCodeList) > 0) {
	$GLOBALS['temp']['envCodes'] = "var envCodes = new Array('".join("','",$envCodeList)."');";
}

$mappingCount = $lDB->get("
	SELECT
		COUNT(*)
	FROM
		ac_pos_map
	WHERE
		ac_pos_map.ac_pos_id = '" . $lDB->escape($record) . "'
",4);
$GLOBALS['temp']['ac_pos_stock_count'] = $mappingCount;

$GLOBALS['temp']['ac_pos_default'] = "";
if(!empty($GLOBALS['form308_ac_pos_ac_pos_stock_id']->Value)) {
	list($ac_pos_stock_code, $ac_ext_desc, $ac_extra_cat_desc) = $GLOBALS['lDB']->get("
		SELECT
			ac_pos_stock.ac_pos_stock_code,
			ac_extra.ac_ext_desc,
			ac_extra_category.ac_extra_cat_desc
		FROM
			ac_pos_stock
			INNER JOIN ac_extra ON ac_extra.ac_extra_ix = ac_pos_stock.ac_extra_id
			INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
		WHERE
			ac_pos_stock.ac_pos_stock_ix = '" . $lDB->escape($GLOBALS['form308_ac_pos_ac_pos_stock_id']->Value) . "'
	",1);	
	$GLOBALS['temp']['ac_pos_default'] = $ac_pos_stock_code . " (" . $ac_ext_desc . ")";
}

   
// Start Access Control Toolbar Setup
$newr = 237;
$edit = 239;
$view = 236;
$dele = 241;
$sedit = 240;
$snewr = 238;

$pgJOBS = array();
$pgJOBS['view'] = "0";
if(checkJob($view)) {
	$pgJOBS['view'] = "1";
}
$pgJOBS['add'] = "0";
if(checkJob($newr)) {
	$pgJOBS['add'] = "1";
}
$pgJOBS['edit'] = "0";
if(checkJob($edit)) {
	$pgJOBS['edit'] = "1";
}
$pgJOBS['del'] = "0";
$pgJOBS['save'] = "0";
if($action == "2" || $action == "3") {
	$pgJOBS['save'] = "1";
}
if($action == "2" || $action == "4" || $record == null) {
	$pgJOBS['edit'] = "0";
}
if($action == "3") {
	$pgJOBS['edit'] = $pgJOBS['view'];
	if(checkJob($dele)) {
		$pgJOBS['del'] = "1";
	}
}
if($GLOBALS[$actFlag]->Value != $actVal) {
	$pgJOBS['del'] = "0";
}

$GLOBALS['temp']['pgJobs'] = "<input type=\"hidden\" id=\"pgJobNew\" value=\"$pgJOBS[add]\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobEdit\" value=\"$pgJOBS[edit]\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobDelete\" value=\"$pgJOBS[del]\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSave\" value=\"$pgJOBS[save]\">\n";
// End Access Control Toolbar Setup

switch ($action) {
case (0) : // List Records
	break;
case (1) : // Display Record
	$GLOBALS['mode'] = "display";
	$GLOBALS['temp']['new_record'] = "reservation.php?237";
	$GLOBALS['temp']['edit_view'] = "reservation.php?239+".$record;
	$GLOBALS['temp']['save_record'] = "#";
	$GLOBALS['temp']['del_record'] = "#";
	break;
case (2) : // Add Record
	$GLOBALS[$form]->Arguments = "238";
	$GLOBALS['temp']['new_record'] = "reservation.php?237";
	$GLOBALS['temp']['edit_view'] = "#";
	$GLOBALS['temp']['save_record'] = "document.forms[0].submit()";
	$GLOBALS['temp']['del_record'] = "#";

	$GLOBALS['mode'] = "new";
	break;
case (3) : // Edit Record
	$GLOBALS[$form]->Arguments = "240+".$record;
	$GLOBALS['mode'] = "edit";
	$GLOBALS['temp']['new_record'] = "reservation.php?237";
	$GLOBALS['temp']['edit_view'] = "reservation.php?239+".$record;
	$GLOBALS['temp']['save_record'] = "document.forms[0].submit()";
	$GLOBALS['temp']['del_record'] = "reservation.php?241+".$record;
	break;
case (4) : // Delete Record
	$inactivate = "0";
	$GLOBALS['temp']['new_record'] = "reservation.php?237";

	$extras = $GLOBALS['lDB']->get("SELECT COUNT(rv_extra_ix) FROM rv_extra WHERE rv_extra.ac_pos_id = '$record'",4);
	if($extras > 0) $inactivate = "1";

	$mappings = $GLOBALS['lDB']->get("SELECT COUNT(ac_pos_map_ix) FROM ac_pos_map WHERE ac_pos_id = '$record'",4);
	if($mappings > 0) $inactivate = "1";


	if ($inactivate != "0") {
		$GLOBALS['lDB']->put("UPDATE ac_pos SET ac_inactive_yn = '-1' where ac_pos_ix = '$record'");
	} else {
		$GLOBALS['initrecord'] = $record;
		$GLOBALS['delrecord'] = $record;
	}
	break;
}

$GLOBALS['temp']['new_record'] .= "++".$_SERVER['argv'][2]."+".$_SERVER['argv'][3];
$GLOBALS['temp']['record'] = $record;

