<?php

/*
 * $Id: init.form31.php,v 1.12 2011-05-30 12:50:02 light Exp $
 *
 * $Log: init.form31.php,v $
 * Revision 1.12  2011-05-30 12:50:02  light
 * Bug #7609 - General system speed (on larger databases)
 *
 * Revision 1.11  2011-05-17 14:08:29  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.10  2009-09-11 18:52:52  light
 * Bug #6948 - PHP 5.3.x & MySQL 5.1.x fixes
 *
 *
 */

/**
* init.form31.php - The Country Code Listing
* Job: 76
* Function: 57 (Code Tables: General)
*/

if(!array_key_exists($form,$GLOBALS) || !isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/code_country_list.htm");
}

// Counter for preventing duplicate entries
$counti = 0;

$selectjob = (isset($_SERVER['argv'][1]) ? $_SERVER['argv'][1] : "");
$orderby = (isset($_SERVER['argv'][2]) ? $_SERVER['argv'][2] : 0);

if (isset($_SERVER['argv'][3])) {
	$order = ($_SERVER['argv'][3] == "1" ? " desc" : " asc");
} else {
	$order = " asc";
}

$GLOBALS['temp']['imgSort1'] = "";
$GLOBALS['temp']['imgSort2'] = "";
$GLOBALS['temp']['imgSort3'] = "";
$GLOBALS['temp']['imgSort4'] = "";
$GLOBALS['temp']['imgSort5'] = "";
$GLOBALS['temp']['imgSort6'] = "";

$GLOBALS['temp']['imgSort1Mode'] = "std"; #(name, asc)
$GLOBALS['temp']['imgSort2Mode'] = "std"; #(name, desc)
$GLOBALS['temp']['imgSort3Mode'] = "std"; #(abbrev, asc)
$GLOBALS['temp']['imgSort4Mode'] = "std"; #(abbrev, desc)
$GLOBALS['temp']['imgSort5Mode'] = "std"; #(inactive, asc)
$GLOBALS['temp']['imgSort6Mode'] = "std"; #(inactive, desc)


switch($orderby) {
case 0:
	$orderbyfield = "rf_country_name";
	if($order == " asc") {
		$GLOBALS['temp']['imgSort1Mode'] = "down"; #(name, asc)
	} else {
		$GLOBALS['temp']['imgSort2Mode'] = "down"; #(name, desc)
	}
	break;
case 1:
	$orderbyfield = "rf_country_code";
	if($order == " asc") {
		$GLOBALS['temp']['imgSort3Mode'] = "down"; #(name, asc)
	} else {
		$GLOBALS['temp']['imgSort4Mode'] = "down"; #(name, desc)
	}
	break;
case 2:
	$orderbyfield = "rf_country_inactive";
	if($order == " asc") {
		$GLOBALS['temp']['imgSort6Mode'] = "down"; #(name, asc)
	} else {
		$GLOBALS['temp']['imgSort5Mode'] = "down"; #(name, desc)
	}
	break;
}

if(sizeof($GLOBALS[$form]->RecordList) < "1") {
	$RecordStart = "0";

	$where = "";
	$RecordListSQL = "
		SELECT 
			rf_country_code,
			rf_country_dialcode,
			rf_country_name,
			rf_currency_id,
			rf_country_inactive,
			rf_country_ix,
			rf_country_db,
			rf_country_colour
		FROM 
			rf_country " . $where . "
		ORDER BY " . $orderbyfield . $order;
	$countsql = "select count(*) from rf_country".$where;
	$tempcount = $lDB->get($countsql,"1");
	$GLOBALS['temp']['numrows'] = $tempcount[0];
	$RecordCount = $tempcount[0];
	$Limit = $RecordCount;
	$RecordLimit = $RecordStart-- + $Limit++;
	if($RecordStart < 0) { $RecordStart = 0; }

	$GLOBALS['temp']['selectjob'] = "";

	$sortclick = "0";
	if(checkjob("78") == true) {
		$selectjob = "78";
		if($record == "") {
			$sortclick = "76";
		}
	}else {
		$selectjob = "70";
	}
	if ($sortclick == "0") {
		$sortclick = $selectjob;
	}

	$GLOBALS['temp']['selectjob'] = $selectjob;
	$GLOBALS['temp']['sortclick'] = $sortclick;
	$GLOBALS['temp']['rows'] = "";
	if ($RecordCount != "0") {
		$recordid = $lDB->get($RecordListSQL,"2");
		for($i = $RecordStart; $i < $RecordLimit; $i++) {
			$country_id = $recordid[$i][5];
			$country_code = t_encodeHTMLField($recordid[$i][0]);
			$country_dial = $recordid[$i][1];
			$country_name = $recordid[$i][2];
			$country_currency = $recordid[$i][3];
			$country_inactive = $recordid[$i][4];
			$country_colour = $recordid[$i][7];
			$country_db = $recordid[$i]['rf_country_db'];

			if (strlen($country_name) < 25) {
				$country_name = substr($country_name,0,25);
			} else {
				$country_name = substr($country_name,0,25)."...";
			}

			$country_name = t_encodeHTMLField($country_name);

			$sql = "select rf_currency_name, rf_currency_inactive_yn from rf_currency where rf_currency_ix = '$country_currency'";
			$temp = $lDB->get($sql,1);
			$country_currency = "";
			$inactive_curr = "0";
			if ($temp[0] != "0") {
				$country_currency = t_encodeHTMLField($temp[0]);
				$inactive_curr = $temp[1];
			}

			if ($country_id != "" && $country_name != "") {
				$country = array();
				$country['country_id'] = $country_id;
				$country['country_code'] = $country_code;
				$country['country_dial'] = $country_dial;
				$country['country_colour'] = $country_colour;
				if($country_id == $record) {
					$country['country_name'] = $country_name;
				} else {
					if(canEditDB($country_db)) {
						$country['country_name'] = "<span id='country".(string) $counti++."'>".$country_name."</span>";
					} else {
						$country['country_name'] = "<span class='txtg' id='country".(string) $counti++."'>".$country_name."</span>";
					}
				}               
               
				$country['country_currency'] = $country_currency;
				$country['inactiveCurr'] = "";
				if($inactive_curr != "0") {
					$country['inactiveCurr'] = "txtg txti";
				}
				$country['country_inactive'] = "";
				if ($country_inactive != "0") {
					$country['country_inactive'] = "x";
				}
				$country['selectjob'] = $selectjob;
				if(canEditDB($country_db)) {
					$country['rowClass'] = "linkrow";
					$country['itemClass'] = "";
					$country['canEdit'] = "";
				} else {
					$country['rowClass'] = "";
					$country['itemClass'] = "txtg";
					$country['canEdit'] = "return;";
				}

				# Add this line to each code table
				$HTML = __DIR__ . "/../../../public/html/code_country_rows.htm";
				$rowHtml = Join("",File($HTML));
				$GLOBALS['temp']['rows'] .= showpage($country,$rowHtml);
			}
		}
	} else {
		$it ="
			<tr class='txt' height='20'>
				<td height='20' class='txt' colspan=4 align=center>&nbsp;&nbsp;There are no existing countries.</td>
			</tr></a>
		";
		$GLOBALS['temp']['rows'] = $it;
	}
}

$hidelist = array();
$GLOBALS[$form]->Hide($hidelist);

$disablelist = array();
$GLOBALS[$form]->Disable($disablelist);

$GLOBALS['temp']['rowCount'] = (string) $counti;
