<?php

/**
 * init.form301.php - Rooming Calendar
 * Job: 242
 * Function: 81
 */

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/room_guestNames.htm");
}

if($GLOBALS['jobLevelArray'][242] < 10) {
	$readonly = true;
	$disabled = $GLOBALS['temp']['disabled'] = "disabled";
} else {
	$readonly = false;
	$disabled = $GLOBALS['temp']['disabled'] = "";
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],3,"");

$groupId = $_SERVER['argv'][1];

// Check for saved group ID in $_POST.  This could have happened if a guest was saved, group was created and the page reloaded.
if (isset($_POST['groupId']) && $groupId == "" && $_POST['groupId'] != ""){
	$groupId = $_POST['groupId'];
}
$resItemId = $_SERVER['argv'][2];

$resId = $GLOBALS['lDB']->get("SELECT rv_reservation_id FROM rv_reservation_item WHERE rv_reservation_item_ix = '$resItemId'",4);
$resName = $GLOBALS['lDB']->get("SELECT rv_res_name FROM rv_reservation WHERE rv_reservation_ix = '$resId'",4);
$resItemInfo = $GLOBALS['lDB']->get("
	SELECT
		rv_reservation_item.rv_item_adult_count,
		rv_reservation_item.rv_item_child_count
	FROM
		rv_reservation_item
	WHERE
		rv_reservation_item_ix = '$resItemId'
",1);


if(!$readonly && isset($_POST['guestList']) && $_POST['guestList'] != "") {
	$guestList = unserialize(str_replace("\\","",$_POST['guestList']));
	foreach($guestList as $guestKey=>$guestItem) {
		if($guestItem['pr_phone_number'] == "Telephone") { $guestItem['pr_phone_number'] = ""; }
		if($guestItem['pr_email'] == "Email") { $guestItem['pr_email'] = ""; }
		if($guestItem['pr_persona_ix'] != "0" && trim($guestItem['pr_persona_ix']) != "") { // Edit Existing Guest
			$pr_persona_ix = $guestItem['pr_persona_ix'];
			$personaAudit = new AuditTrail($pr_persona_ix,TYPE_PERSONA);
			$personaChanges = false;
			$old = $lDB->get("
				SELECT
					pr_name_last,
					pr_name_first,
					pr_email,
					pr_title_id,
					pr_name_suffix_id
				FROM
					pr_persona
				WHERE
					pr_persona_ix = '".$lDB->escape($pr_persona_ix)."'
			",1);
			$GLOBALS['lDB']->put("
				UPDATE pr_persona SET
					pr_name_first = '$guestItem[pr_name_first]',
					pr_name_last = '$guestItem[pr_name_last]',
					pr_email = '$guestItem[pr_email]',
					pr_title_id = '$guestItem[rf_title_ix]',
					pr_name_suffix_id = '$guestItem[rf_name_suffix_ix]'
				WHERE
					pr_persona_ix = '$guestItem[pr_persona_ix]'
			");
			if($old['pr_name_last'] != $guestItem['pr_name_last']) {
				$personaAudit->addDetail($old['pr_name_last'], $guestItem['pr_name_last'], $pr_persona_ix, $pr_persona_ix, DB_AD_PERSONA_DETAIL_ACTION_EDIT, "persona", "pr_persona.pr_name_last");
				$personaChanges = true;
			}
			if($old['pr_name_first'] != $guestItem['pr_name_first']) {
				$personaAudit->addDetail($old['pr_name_first'], $guestItem['pr_name_first'], $pr_persona_ix, $pr_persona_ix, DB_AD_PERSONA_DETAIL_ACTION_EDIT, "persona", "pr_persona.pr_name_first");
				$personaChanges = true;
			}
			if($old['pr_email'] != $guestItem['pr_email']) {
				$personaAudit->addDetail($old['pr_email'], $guestItem['pr_email'], $pr_persona_ix, $pr_persona_ix, DB_AD_PERSONA_DETAIL_ACTION_EDIT, "persona", "pr_persona.pr_email");
				$personaChanges = true;
			}
			if($old['pr_title_id'] != $guestItem['rf_title_ix']) {
				$personaAudit->addDetail($old['pr_title_id'], $guestItem['rf_title_ix'], $pr_persona_ix, $pr_persona_ix, DB_AD_PERSONA_DETAIL_ACTION_EDIT, "persona", "pr_persona.pr_title_id");
				$personaChanges = true;
			}
			if($old['pr_name_suffix_id'] != $guestItem['rf_name_suffix_ix']) {
				$personaAudit->addDetail($old['pr_name_suffix_id'], $guestItem['rf_name_suffix_ix'], $pr_persona_ix, $pr_persona_ix, DB_AD_PERSONA_DETAIL_ACTION_EDIT, "persona", "pr_persona.pr_name_suffix_id");
				$personaChanges = true;
			}

			$GLOBALS['lDB']->put("
				UPDATE pr_guest SET
					pr_guest_primary_yn = '$guestItem[pr_guest_primary_yn]',
					pr_guest_note = '$guestItem[pr_guest_note]',
					pr_guest_memo = '$guestItem[pr_guest_memo]'
				WHERE pr_guest_id = '$guestItem[pr_persona_ix]'
				");

			if($guestItem['pr_phone_number'] != $guestItem['pr_phone_number_old']) {
				// Remove old telephone record
				$oldPhoneId = $GLOBALS['lDB']->get("
					SELECT
						pr_phone_ix
					FROM
						pr_phone
					WHERE
						pr_phone.pr_persona_id = '$guestItem[pr_persona_ix]'
						AND pr_phone.pr_default_yn = '1'
						AND pr_phone.pr_phone_number = '$guestItem[pr_phone_number_old]'
				",4);

				$GLOBALS['lDB']->put("DELETE FROM pr_phone WHERE pr_phone_ix = '$oldPhoneId'");
				$personaAudit->addDetail($guestItem['pr_phone_number_old'], "", $oldPhoneId, "", DB_AD_PERSONA_DETAIL_ACTION_DELETE, "phone", "pr_phone.pr_phone_number");
				$personaChanges = true;

				if($guestItem['pr_phone_number'] != "") {
					// Add new telephone record
					$GLOBALS['lDB']->put("
						INSERT INTO pr_phone (
							pr_phone_db,
							pr_phone_id,
							pr_default_yn,
							pr_phone_number,
							rf_phone_type_id,
							pr_persona_id
						) VALUES (
							'$GLOBALS[dbcode]',
							'',
							'1',
							'$guestItem[pr_phone_number]',
							'RS3',
							'$guestItem[pr_persona_ix]'
						)
					",1);
					$pr_phone_id = $lDB->insert_id;
					$personaAudit->addDetail("", 1, "", $pr_phone_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.pr_default_yn");
					$personaAudit->addDetail("", $guestItem['pr_phone_number'], "", $pr_phone_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.pr_phone_number");
					$personaAudit->addDetail("", "RS3", "", $pr_phone_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.rf_phone_type_id");
				}
			}
			if($personaChanges) {
				$personaAudit->save("Contact details (Edit)");
			}
			$guestName = getContactFullName($guestItem['pr_persona_ix'],false);
			ammendReservation($resId,"Guests (Edit: $guestName [".$guestItem['pr_persona_ix']."])");
		} else {
			$GLOBALS['lDB']->put("
				INSERT INTO pr_persona (
					pr_persona_db,
					pr_persona_id,
					pr_name_last,
					pr_name_first,
					pr_email,
					pr_title_id,
					pr_name_suffix_id
				) VALUES (
					'$GLOBALS[dbcode]',
					'',
					'$guestItem[pr_name_last]',
					'$guestItem[pr_name_first]',
					'$guestItem[pr_email]',
					'$guestItem[rf_title_ix]',
					'$guestItem[rf_name_suffix_ix]'
				)
			");
			$pr_persona_ix = $GLOBALS['lDB']->insert_id;
			$personaAudit = new AuditTrail($pr_persona_ix,TYPE_PERSONA);
			$personaAudit->addDetail("", $guestItem['pr_name_last'], "", $pr_persona_ix, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_name_last");
			$personaAudit->addDetail("", $guestItem['pr_name_first'], "", $pr_persona_ix, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_name_first");
			$personaAudit->addDetail("", $guestItem['pr_email'], "", $pr_persona_ix, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_email");
			$personaAudit->addDetail("", $guestItem['rf_title_ix'], "", $pr_persona_ix, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_title_id");
			$personaAudit->addDetail("", $guestItem['rf_name_suffix_ix'], "", $pr_persona_ix, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_name_suffix_id");
			$guestItem['pr_persona_ix'] = $pr_persona_ix;
			$guestList[$guestKey]['pr_persona_ix'] = $pr_persona_ix;
			db_pr_guest_insert($pr_persona_ix, '0', '0', '0',$guestItem['pr_guest_note'], $guestItem['pr_guest_memo'], $guestItem['pr_guest_primary_yn']);

			db_rv_reservation_guest_insert($resId,$pr_persona_ix);
			if($groupId == "" || $groupId == "0") {
				$groupId = db_rv_res_item_group_insert($resItemId);
			}

			if($groupId != "") {
				db_rv_res_item_guest_insert($pr_persona_ix, $groupId);
			}

			if($guestItem['pr_phone_number'] != "") {
				// Add new telephone record
				$GLOBALS['lDB']->put("
					INSERT INTO pr_phone (
						pr_phone_db,
						pr_phone_id,
						pr_default_yn,
						pr_phone_number,
						rf_phone_type_id,
						pr_persona_id
					) VALUES (
						'$GLOBALS[dbcode]',
						'',
						'1',
						'$guestItem[pr_phone_number]',
						'RS3',
						'$guestItem[pr_persona_ix]'
					)
				",1);
				$pr_phone_id = $lDB->insert_id;
				$personaAudit->addDetail("", 1, "", $pr_phone_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.pr_default_yn");
				$personaAudit->addDetail("", $guestItem['pr_phone_number'], "", $pr_phone_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.pr_phone_number");
				$personaAudit->addDetail("", "RS3", "", $pr_phone_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.rf_phone_type_id");
			}
			$personaAudit->save("Contact details (Add)");
		}
		$guestName = getContactFullName($guestItem['pr_persona_ix'],false);
		ammendReservation($resId,"Guests (Insert: $guestName [".$guestItem['pr_persona_ix']."])");
	}
	// update linkage
	foreach($guestList as $guestKey=>$guestItem) {
		if($guestItem['primary_id'] !== "") { linkPrimary($guestItem['primary_id'], $guestItem['pr_persona_ix']); }
		if($guestItem['primary_count'] !== "") { linkPrimary($guestList[$guestItem['primary_count']]['pr_persona_ix'],$guestItem['pr_persona_ix']); }
	}
}

if(!$readonly && isset($_POST['guestImportList']) && $_POST['guestImportList'] != "") {
	$guestList = explode(":",$_POST['guestImportList']);
	if($groupId == "" && $resItemId != "") {
		$newGuestList = array();
		foreach($guestList as $item) {
			$check = $GLOBALS['lDB']->get("
				SELECT
					COUNT(rv_res_item_guest_id)
				FROM
					rv_res_item_guest
				WHERE
					rv_reservation_item_id = '$resItemId'
					AND pr_guest_id = '$item'
			",4);
			if($check == 0) {
				array_push($newGuestList,$item);
			}
		}
		$guestList = $newGuestList;
		unset($newGuestList);
		if(sizeof($guestList) > 0) {
			$groupId = db_rv_res_item_group_insert($resItemId);
		}
	}
	foreach($guestList as $item) {
		db_pr_guest_insert($item);
		db_rv_reservation_guest_insert($resId,$item);
		if($groupId != "") {
			db_rv_res_item_guest_insert($item, $groupId);
		}
		$guestName = getContactFullName($item,false);
		ammendReservation($resId,"Guests (Insert: $guestName [$item])");
	}
}

if(!$readonly && isset($_POST['removeGroupId']) && $_POST['removeGroupId'] != "" && isset($_POST['removeGuestId']) && $_POST['removeGuestId'] != "") {
	if($_POST['removeGroupGuestAll'] != "") {
		db_rv_res_item_guest_delete_by_guest($_POST['removeGuestId'], $resId);
		if($_POST['removeGroupGuestRes'] != "") {
			db_rv_reservation_guest_delete_by_all($resId, $_POST['removeGuestId']);
			if($_POST['removeGroupGuestContact'] != "") {
				$resCheck = $GLOBALS['lDB']->get("
					SELECT
						COUNT(rv_reservation_id)
					FROM
						rv_reservation_guest
					WHERE
						pr_guest_id = '$_POST[removeGuestId]'
				",4);
				$resCheck2 = $GLOBALS['lDB']->get("
					SELECT
						COUNT(*)
					FROM
						rv_res_item_guest
					WHERE
						pr_guest_id = '$_POST[removeGuestId]'
				",4);
				$linkCheck = $GLOBALS['lDB']->get("
					SELECT
						COUNT(pr_link_from)
					FROM
						pr_link
					WHERE
						(
							pr_link_to = '$_POST[removeGuestId]'
							AND rf_link_type_id <> 'RS3'
							AND rf_link_type_id <> 'RS4'
						) OR (
							pr_link_from = '$_POST[removeGuestId]'
							AND rf_link_type_id <> 'RS3'
							AND rf_link_type_id <> 'RS4'
						)
				",4);
				if($resCheck > 0 || $resCheck2 > 0) {
					db_pr_guest_set_inactive($_POST['removeGuestId']);
					if($linkCheck == 0) {
						$GLOBALS['lDB']->put("
							UPDATE
								pr_guest
							SET
								pr_guest_inactive_yn = '1'
							WHERE
								pr_guest_id = '$_POST[removeGuestId]'
							");
					}
				} else {
					db_pr_guest_delete($_POST['removeGuestId']);
					if(canDeleteContact($_POST['removeGuestId'])) {
						cleanContact($_POST['removeGuestId']);
						$GLOBALS['lDB']->put("DELETE FROM pr_persona WHERE pr_persona_ix = '$_POST[removeGuestId]'");
					}
				}
			}
		}
	} else {
		db_rv_res_item_guest_delete_by_group_guest($_POST['removeGuestId'], $_POST['removeGroupId']);
	}

	$guestName = getContactFullName($_POST['removeGuestId'],false);
	ammendReservation($resId,"Guests (Deleted : $guestName [".$_POST['removeGuestId']."])");
}

$GLOBALS['temp']['rv_reservation_ix'] = $resId;
$GLOBALS['temp']['rv_res_name'] = t_encodeHTMLField($resName);
$GLOBALS['temp']['rv_item_adult_count'] = $resItemInfo['rv_item_adult_count'];
$GLOBALS['temp']['rv_item_child_count'] = $resItemInfo['rv_item_child_count'];

$GLOBALS['temp']['groupId'] = $groupId;
$GLOBALS['temp']['resItemId'] = $resItemId;


$totalCount = $resItemInfo['rv_item_adult_count'] + $resItemInfo['rv_item_child_count'];

$guestRowHTML = "
<tr>
	<td class=\"!nameClass!\">!guestName!</td>
	<td align=\"right\" width=\"20\"><input type=\"button\" class=\"button bNote\" style=\"width:20; height:20; !showNote!\" onmouseout=\"nd();\" onmouseover=\"overlib('!guestNote!',LEFT);\"></td>
	<td align=\"right\" width=\"20\"><input type=\"button\" class=\"button bIntNote\" style=\"width:20; height:20; !showMemo!\" onmouseout=\"nd();\" onmouseover=\"overlib('!guestMemo!',LEFT);\"></td>
</tr>
";

$guestNotes = $GLOBALS['lDB']->get("SELECT rv_note_guests FROM rv_reservation WHERE rv_reservation_ix = '$resId'",4);
$GLOBALS['temp']['guestNotes'] = t_encodeHTMLField($guestNotes);


$guestArray = $GLOBALS['lDB']->get("
	SELECT
		pr_persona.pr_persona_ix,
		pr_persona.pr_name_last,
		pr_persona.pr_name_first,
		pr_persona.pr_email,
		pr_phone.pr_phone_number,
		rf_title.rf_title_ix,
		rf_title.rf_title_desc,
		rf_name_suffix.rf_suffix_desc,
		rf_name_suffix.rf_name_suffix_ix,
		pr_guest.pr_guest_primary_yn,
		pr_guest.pr_guest_note,
		pr_guest.pr_guest_memo
	FROM
		rv_res_item_guest
		INNER JOIN pr_guest ON pr_guest.pr_guest_id = rv_res_item_guest.pr_guest_id
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
		LEFT JOIN pr_phone ON pr_phone.pr_persona_id = pr_persona.pr_persona_ix AND pr_phone.pr_default_yn = '1'
		LEFT JOIN rf_title ON rf_title.rf_title_ix = pr_persona.pr_title_id
		LEFT JOIN rf_name_suffix ON rf_name_suffix.rf_name_suffix_ix = pr_persona.pr_name_suffix_id
	WHERE
		rv_res_item_guest.rv_res_item_group_id = '$groupId'
",2);


$guestEditHTML = "
	<tr>
		<td class=\"br uk-table-expand\"><input $disabled type=\"text\" id=\"lastname!count!\" class=\"uk-width-1-1\" placeholder=\"Last Name\" value=\"!pr_name_last!\" onfocus=\"lastnameFocus(!count!);\" onkeydown=\"lastnameKeyDown(!count!);\"></td>
		<td class=\"br uk-table-expand\"><input $disabled type=\"text\" id=\"firstname!count!\" class=\"uk-width-1-1\" placeholder=\"First Name\" value=\"!pr_name_first!\"></td>
		<td class=\"br uk-text-center uk-table-shrink\">
			<button $disabled type=\"button\" class=\"btn btn-sqr btn-lgrey \" onclick=\"checkDuplicate(this,!count!);\" />
				<i class=\"material-icons\">person</i>
			</button>
		</td>
		<td class=\"br uk-text-center\">
			<select $disabled class=\"uk-select\" id=\"title!count!\">
				<option value=\"\"></option>
				!titleOptions!
			</select>
		</td>
		<td class=\"br\" style=\"display:none;\">
			<select style=\"display:none;\" $disabled id=\"suffix!count!\">
				<option value=\"\"></option>
				!suffixOptions!
			</select>
		</td>
		<td class=\"br uk-text-center v-alignm uk-table-shrink uk-text-nowrap\">
			<input $disabled type=\"checkbox\" class=\"uk-checkbox\" id=\"primary!count!\" !primaryChecked! onclick=\"toggleSelectPrimary(!count!);\">
			&nbsp;
			<button $disabled id=\"btnSelectPrimary!count!\" type=button class=\"btn btn-sqr btn-lgrey\" style=\"!showSelectPrimary!\" onclick=\"showPrimary(this,!count!);\" id=\"primaryList!count!\" onmouseout=\"nd();\" onmouseover=\"showPrimaryOverlib(!count!);\">
				<i class=\"material-icons\">link</i>
			</button>
		</td>
		<td class=\"br uk-table-expand\"><input $disabled type=\"text\" size=\"10\" id=\"telephone!count!\" class=\"uk-width-1-1\" placeholder=\"Telephone\" value=\"!pr_phone_number!\" onblur=\"telephoneBlur(!count!);\"></td>
		<td class=\"br uk-table-expand \"><input $disabled type=\"text\" id=\"email!count!\" class=\"uk-width-1-1\" placeholder=\"Email\" value=\"!pr_email!\" onblur=\"emailBlur(!count!);\"></td>
		<td class=\"br uk-text-center uk-table-shrink\">
			<button $disabled type=\"button\" class=\"btn btn-sqr btn-lgrey\"  onmouseout=\"nd();\" onmouseover=\"showNote(!count!);\" onclick=\"editNote(this,!count!);\">
				<i class=\"material-icons\">subject</i>
			</button>
		</td>
		<td class=\"br uk-text-center uk-table-shrink\">
			<button $disabled type=\"button\" class=\"btn btn-sqr btn-lgrey\" style=\"!showIntNote!\" onmouseout=\"nd();\" onmouseover=\"showMemo(!count!);\" onclick=\"editMemo(this,!count!);\">
				<i class=\"material-icons\">note</i>
			</button>
		</td>
		<td class=\"br uk-text-center uk-table-shrink\">
			<button $disabled type=\"button\" class=\"btn btn-sqr btn-lgrey\" style=\"!showInfo!\" onclick=\"editGuest('!pr_persona_ix!');\">
				<i class=\"material-icons\">person</i>
			</button>
		</td>
		<td class=\"br uk-text-center uk-table-shrink\">
			<button $disabled type=\"button\" class=\"btn btn-sqr btn-lgrey\" style=\"!showDelete!\" onclick=\"removeGroupGuest('$groupId', '!pr_persona_ix!')\">
				<i class=\"material-icons\">delete</i>
			</button>
		<input type=\"hidden\" id=\"id!count!\" value=\"!pr_persona_ix!\">
		<input type=\"hidden\" id=\"oldTelephone!count!\" value=\"!pr_phone_number!\">
		<input type=\"hidden\" id=\"primaryLinkId!count!\" value=\"\">
		<input type=\"hidden\" id=\"primaryLinkCount!count!\" value=\"\">
		<input type=\"hidden\" id=\"primaryLinkName!count!\" value=\"!primaryName!\">
		<textarea id=\"pr_guest_note!count!\" style=\"display:none;\">!pr_guest_note!</textarea>
		<textarea id=\"pr_guest_memo!count!\"  style=\"display:none;\">!pr_guest_memo!</textarea>
		</td>
	</tr>
";

$titleArray = $GLOBALS['lDB']->get("
	SELECT
	rf_title_ix,
	rf_title_desc
	FROM
	rf_title
	WHERE
	rf_title_inactive_yn = '0'
",2);

$suffixArray = $GLOBALS['lDB']->get("
	SELECT
	rf_name_suffix_ix,
	rf_suffix_desc
	FROM
	rf_name_suffix
	WHERE
	rf_suffix_inactive_yn = '0'
",2);

$guestEditRows = "";

$blankCount = $totalCount - sizeof($guestArray);

$rowCount = 0;
foreach($guestArray as $guestItem) {
	$guestItem['primaryName'] = findPrimary($guestItem['pr_persona_ix']);
	//	debug(findPrimary($guestItem['pr_persona_ix']));
	$titleRows = "";
	foreach($titleArray as $titleItem) {
		if($titleItem['rf_title_ix'] == $guestItem['rf_title_ix']) {
			$selected = " selected ";
		} else {
			$selected = "";
		}
		$titleRows .= "<option $selected value=\"$titleItem[rf_title_ix]\">$titleItem[rf_title_desc]</option>";
	}
	$suffixRows = "";
	foreach($suffixArray as $suffixItem) {
		if($suffixItem['rf_name_suffix_ix'] == $guestItem['rf_name_suffix_ix']) {
			$selected = " selected ";
		} else {
			$selected = "";
		}
		$suffixRows .= "<option $selected value=\"$suffixItem[rf_name_suffix_ix]\">$suffixItem[rf_suffix_desc]</option>";
	}

	$guestItem['titleOptions'] = $titleRows;
	$guestItem['suffixOptions'] = $suffixRows;

	$guestItem['count'] = $rowCount;

	if($guestItem['pr_guest_primary_yn'] == "1") {
		$guestItem['primaryChecked'] = "checked";
		$guestItem['showSelectPrimary'] = "display: none;";
	} else {
		$guestItem['primaryChecked'] = "";
		$guestItem['showSelectPrimary'] = "";
	}
	$rowCount++;

	$guestItem['pr_name_first'] = t_encodeHTMLField(trim($guestItem['pr_name_first']));
	$guestItem['pr_name_last'] = t_encodeHTMLField(trim($guestItem['pr_name_last']));

	$guestItem['pr_guest_note'] = trim($guestItem['pr_guest_note']);
	$guestItem['pr_guest_memo'] = trim($guestItem['pr_guest_memo']);
	$guestItem['showNote'] = "";
	$guestItem['showIntNote'] = "";
	$guestItem['showInfo'] = "";
	$guestItem['showDelete'] = "";
	$guestEditRows .= showpage($guestItem,$guestEditHTML);
}

$titleRows = "";
foreach($titleArray as $titleItem) {
	$titleRows .= "<option value=\"$titleItem[rf_title_ix]\">$titleItem[rf_title_desc]</option>";
}
$suffixRows = "";
foreach($suffixArray as $suffixItem) {
	$suffixRows .= "<option value=\"$suffixItem[rf_name_suffix_ix]\">$suffixItem[rf_suffix_desc]</option>";
}
$guestEditHTML =
	str_replace("!titleOptions!",$titleRows,
		str_replace("!suffixOptions!",$suffixRows,$guestEditHTML));

for($count = 0; $count < $blankCount; $count++) {
	// If we have temp values (eg. if we are doing a duplicate check), fill those in the first blank slot
	$guestItem = array();
	if (isset($_POST['tempFirstname']) && $_POST['tempFirstname'] != "" && $count == 0){
		$guestItem['pr_name_first'] = $_POST['tempFirstname'];
	} else {
		$guestItem['pr_name_first'] = "FirstName";
	}
	if (isset($_POST['tempLastname']) && $_POST['tempLastname'] != ""  && $count == 0){
		$guestItem['pr_name_last'] = $_POST['tempLastname'];
	} else {
		$guestItem['pr_name_last'] = "LastName";
	}

	if (isset($_POST['tempEmail']) && $_POST['tempEmail'] != "" && $count == 0){
		$guestItem['pr_email'] = $_POST['tempEmail'];
	} else {
		$guestItem['pr_email'] = "Email";
	}

	if (isset($_POST['tempTelephone']) && $_POST['tempTelephone'] != "" && $count == 0){
		$guestItem['pr_phone_number'] = $_POST['tempTelephone'];
	} else {
		$guestItem['pr_phone_number'] = "Telephone";
	}

	if (isset($_POST['tempTitle']) && $_POST['tempTitle'] != ""  && $count == 0){
		$titleRows = "";
		foreach($titleArray as $titleItem) {
			if($titleItem['rf_title_ix'] == $_POST['tempTitle']) {
				$selected = " selected ";
			} else {
				$selected = "";
			}
			$titleRows .= "<option $selected value=\"$titleItem[rf_title_ix]\">$titleItem[rf_title_desc]</option>";
		}
	}
	if (isset($_POST['tempSuffix']) && $_POST['tempSuffix'] != ""  && $count == 0){
		$suffixRows = "";
		foreach($suffixArray as $suffixItem) {
			if($suffixItem['rf_name_suffix_ix'] == $_POST['tempSuffix']) {
				$selected = " selected ";
			} else {
				$selected = "";
			}
			$suffixRows .= "<option $selected value=\"$suffixItem[rf_name_suffix_ix]\">$suffixItem[rf_suffix_desc]</option>";
		}
	}

	$guestItem['titleOptions'] = $titleRows;
	$guestItem['suffixOptions'] = $suffixRows;
	$guestItem['count'] = $rowCount;
	$guestItem['pr_persona_ix'] = "";
	$guestItem['primaryName'] = "";
	$guestItem['showNote'] = "";
	$guestItem['showIntNote'] = "";
	$guestItem['showInfo'] = "visibility: hidden;";
	$guestItem['showDelete'] = "visibility: hidden;";
	$guestItem['pr_guest_note'] = "";
	$guestItem['pr_guest_memo'] = "";
	$rowCount++;
	$guestEditRows .= showpage($guestItem,$guestEditHTML);
}

$GLOBALS['temp']['guestEditRows'] = $guestEditRows;
$GLOBALS['temp']['rowCount'] = $rowCount;

function findPrimary($pr_persona_id) {
	global $lDB;
	$primaryId = $lDB->get("SELECT pr_link_to FROM pr_link WHERE pr_link_from = '$pr_persona_id' AND rf_link_type_id = 'RS3'",4);
	$name = $lDB->get("SELECT pr_name_last,pr_name_first FROM pr_persona WHERE pr_persona_ix = '$primaryId'",1);
	return trim($name['pr_name_first'] . " " . $name['pr_name_last']);
}

if(isset($_POST['closeWindowOnSave']) && $_POST['closeWindowOnSave'] == "yes") {
	echo "
		<script language=\"javascript\">
			if(opener.generateReport) { opener.generateReport() }
			if(opener.ng && opener.ng_rooming_legacy_add_guests) {
				opener.ng_rooming_legacy_add_guests(\"{$GLOBALS['temp']['rv_reservation_ix']}\", \"{$GLOBALS['temp']['resItemId']}\", \"{$GLOBALS['temp']['groupId']}\");
			}
			window.close();
		</script>
	";
	die();
}
