<?php

/**
 * init.form311.php - Rooming Calendar Extras
 * Job: 243
 * Function: 81
*/

if(isset($_POST['action']) && $_POST['action'] == "add" && isset($_POST['randomId']) && $_POST['randomId'] == $_SESSION['quickExtraRandomId']) {
	if (!isset($GLOBALS[$form])) {
		$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/room_extras_confirm.htm");
	} 
} else {
	if (!isset($GLOBALS[$form])) {
		$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/room_extras.htm");
	}
}

if($GLOBALS['jobLevelArray'][243] < 10) {
	$readonly = true;
} else {
	$readonly = false;
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],6,"");

$rv_res_item_group_id = $_SERVER['argv'][1];
$rv_reservation_item_id = $_SERVER['argv'][2];
$rv_reservation_id = $_SERVER['argv'][3];
if(trim($rv_reservation_id) == "" || $rv_reservation_id == "0") {
	$rv_reservation_id = $GLOBALS['lDB']->get("SELECT rv_reservation_id FROM rv_reservation_item WHERE rv_reservation_item_ix = '$rv_reservation_item_id'",4);
}
$properties = explode(":",$_SERVER['argv'][4]);
$propertyId = $properties[0];
if(empty($propertyId)) {
	$propertyId = $GLOBALS['lDB']->get("SELECT pr_business_id FROM rv_reservation_item WHERE rv_reservation_item_ix = '$rv_reservation_item_id'",4);
}
$chargePropertyId = $properties[1];
if(empty($chargePropertyId)) {
	$chargePropertyId = $GLOBALS['lDB']->get("SELECT pr_business_id FROM rv_reservation_item WHERE rv_reservation_item_ix = '$rv_reservation_item_id'",4);
}
$pr_persona_id = $_SERVER['argv'][5];

// Check if user is allowed to do cross invoicing
$sc_grp_cross_invoice_yn = $GLOBALS['lDB']->get("
	SELECT
		sc_group.sc_grp_cross_invoice_yn
	FROM
		sc_user
		INNER JOIN sc_group ON sc_group.sc_group_id = sc_user.sc_group_id
	WHERE
		sc_user.pr_user_id = '$GLOBALS[userid]'
",4);
$GLOBALS['temp']['sc_grp_cross_invoice_yn'] = $sc_grp_cross_invoice_yn ? "true" : "false";

$GLOBALS['temp']['rv_reservation_id'] = $rv_reservation_id;
$GLOBALS['temp']['rv_reservation_item_id'] = $rv_reservation_item_id;
$GLOBALS['temp']['rv_res_item_group_id'] = $rv_res_item_group_id;

$GLOBALS['temp']['serviceY'] = date("Y");
$GLOBALS['temp']['serviceM'] = date("m");
$GLOBALS['temp']['serviceD'] = date("d");

$today = date("Y-m-d");
$GLOBALS['temp']['today_fmt'] = chng_date($today,"-");
// Get the currenct user's property / business link
$businessId = $GLOBALS['lDB']->get("
	SELECT
		pr_link.pr_link_to
	FROM
		pr_link
	WHERE
		pr_link.pr_link_from = '$GLOBALS[userid]'
		AND pr_link.rf_link_type_id = 'RS1'
",4);

// Get a list of all the properties linked to the users property / business link
$propertyList = $GLOBALS['lDB']->get("
	SELECT DISTINCT
		ac_accomm_type.pr_business_id,
		pr_persona.pr_name_last
	FROM
		ac_accomm_type 
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
	WHERE
		ac_accomm_type.pr_business_id IN ('".join("','",getChildren($businessId))."')
",2);
if($propertyId == "") {
	$propertyId = $propertyList[0]['pr_business_id'];
}
if($chargePropertyId == "") {
	$chargePropertyId = $propertyList[0]['pr_business_id'];
}


// Find billing entity
$businessId = "";
$currId = $propertyId;
while($businessId == "" && $currId != "0" && trim($currId) != "") {
	if(!$GLOBALS['isPropServer']) {
		$billingYN = $GLOBALS['lDB']->get("SELECT pr_bus_billing_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
	} else {
		$billingYN = $GLOBALS['lDB']->get("SELECT pr_bus_billing_prop_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
	}
	if($billingYN == "1") {
			$businessId = $currId;
	} else {
			$currId = $GLOBALS['lDB']->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id ='$currId'",4);
	}
}
if(!$GLOBALS['isPropServer']) {
	$homeCurrencyId = $GLOBALS['lDB']->get("SELECT rv_invoice_currency_id FROM rv_reservation WHERE rv_reservation_ix = '$rv_reservation_id'",4);
} else {
	$homeCurrencyId = $GLOBALS['lDB']->get("SELECT pr_bus_prop_curr_id FROM pr_business WHERE pr_business_id = '$chargePropertyId'",4);
}
$homeCurrency = $GLOBALS['lDB']->get("SELECT rf_currency_symbol FROM rf_currency WHERE rf_currency_ix = '$homeCurrencyId'",4);
$GLOBALS['temp']['homeCurrencyId'] = $homeCurrencyId;
$GLOBALS['temp']['homeCurrency'] = $homeCurrency;

$propertyOptions = "";
$chargePropertyOptions = "";
foreach($propertyList as $item) {
	if($propertyId == $item['pr_business_id']) {
		$selected = " SELECTED ";
	} else {
		$selected = "";
	}
	if($chargePropertyId == $item['pr_business_id']) {
		$chargeSelected = " SELECTED ";
	} else {
		$chargeSelected = "";
	}
	$propertyOptions .= "<option value=\"$item[pr_business_id]\" $selected>$item[pr_name_last]</option>";
	$chargePropertyOptions .= "<option value=\"$item[pr_business_id]\" $chargeSelected>$item[pr_name_last]</option>";
}
$GLOBALS['temp']['propertyOptions'] = $propertyOptions;
$GLOBALS['temp']['chargePropertyOptions'] = $chargePropertyOptions;

$rv_res_name = $GLOBALS['lDB']->get("SELECT rv_res_name FROM rv_reservation WHERE rv_reservation_ix = '$rv_reservation_id'",4);
$ac_desc = $GLOBALS['lDB']->get("
	SELECT
		ac_accomm_room.ac_desc
	FROM
		rv_res_item_group
		INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
	WHERE
		rv_res_item_group.rv_res_item_group_ix = '$rv_res_item_group_id'",4);

if(trim($ac_desc) != "" && $ac_desc != "0") {
	$chargeTo = $ac_desc . " (" . $rv_reservation_id . ": " . $rv_res_name . ")";
} else {
	$chargeTo = $rv_reservation_id . ": " . $rv_res_name;
}

$GLOBALS['temp']['chargeTo'] = $chargeTo;

if(trim($pr_persona_id) == "" || $pr_persona_id == "0") {
	$invoiceTo = "Cash";
	$pr_persona_id = "";
} else {
	$personaLookup = $GLOBALS['lDB']->get("SELECT pr_name_first,pr_name_last FROM pr_persona WHERE pr_persona_ix = '$pr_persona_id'",1);
	$invoiceTo = trim($personaLookup['pr_name_first'] . " " . $personaLookup['pr_name_last']);
}
$GLOBALS['temp']['invoiceTo'] = $invoiceTo;
$GLOBALS['temp']['pr_persona_id'] = $pr_persona_id;

$roomArray = $GLOBALS['lDB']->get("
	SELECT
		rv_res_item_group.rv_res_item_group_ix as rv_res_item_group_ix,
		ac_accomm_room.ac_desc
	FROM
		rv_res_item_group
		INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
	WHERE
		rv_reservation_item_id = '$rv_reservation_item_id'
",2);

$roomHTML = "
	<tr>
		<td class=\"uk-padding-small\" onclick=\"selectRoom('!rv_res_item_group_ix!','$rv_reservation_id','".rawurlencode($rv_res_name)."','!ac_desc!');\">!ac_desc!</td>
	</tr>
";

$roomRows = str_replace("!ac_desc!","None",
			str_replace("!rv_res_item_group_ix!","",$roomHTML));
foreach($roomArray as $roomItem) {
	$roomRows .= showpage($roomItem,$roomHTML);
}
$GLOBALS['temp']['roomRows'] = $roomRows;

$roomList = $GLOBALS['lDB']->get("
	SELECT
		rv_res_item_group.rv_res_item_group_ix,
		ac_accomm_room.ac_desc,
		rv_res_item_group.rv_reservation_item_id,
		pr_persona.pr_name_last,
		ac_accomm_type.ac_accomm_desc,
		rv_reservation_item.rv_item_date_arrive,
		rv_reservation_item.rv_item_date_depart
	FROM
		rv_res_item_group
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
		INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation_item.pr_business_id
		LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
	WHERE
		rv_reservation_item.rv_reservation_id = '$rv_reservation_id'
	ORDER BY
		rv_reservation_item.rv_item_date_arrive,
		rv_reservation_item.rv_item_date_depart
",2);

$newRoomList = array();
foreach($roomList as $item) {
	$item['rv_item_date_arrive'] = chng_date($item['rv_item_date_arrive'],"-");
	$item['rv_item_date_depart'] = chng_date($item['rv_item_date_depart'],"-");
	$item['ac_desc_raw'] = $item['ac_desc'];
	if(trim($item['ac_desc']) == "") {
		$item['ac_desc'] = "&nbsp;";
	}
	$guestList = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_last,
			pr_persona.pr_name_first,
			pr_persona.pr_persona_ix,
			pr_guest.pr_guest_primary_yn,
			rf_title.rf_title_desc,
			rf_name_suffix.rf_suffix_desc
		FROM
			rv_res_item_guest
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
			LEFT JOIN pr_guest ON pr_guest.pr_guest_id = pr_persona.pr_persona_ix
			LEFT JOIN rf_title ON rf_title.rf_title_ix = pr_persona.pr_title_id
			LEFT JOIN rf_name_suffix ON rf_name_suffix.rf_name_suffix_ix = pr_persona.pr_name_suffix_id
		WHERE
			rv_res_item_group_id = '$item[rv_res_item_group_ix]'
	",2);
	if(sizeof($guestList) > 0) {
		$guestNames = "";
		foreach($guestList as $guestItem) {
			$guestNames = $guestItem['pr_name_last'];
			if(trim($guestItem['rf_suffix_desc']) != "") {
				$guestNames .= " " . $guestItem['rf_suffix_desc'];
			}
			if(trim($guestItem['pr_name_first']) != "") {
				$guestNames .= ", " . $guestItem['pr_name_first'];
			}
			if(trim($guestItem['rf_title_desc']) != "") {
				$guestNames .= " " . $guestItem['rf_title_desc'];
			}
				
			$item['guestNames'] = $guestNames;
			if($guestItem['pr_guest_primary_yn'] == "1") {
				$item['guestNames'] = "<span class=\"txtb\">$guestNames</span>";
			}
			$item['guestNamesRaw'] = $guestNames;
			$item['role'] = "Guest";
			$item['pr_persona_ix'] = $guestItem['pr_persona_ix'];
			array_push($newRoomList,$item);
		}
	} elseif( $item['ac_desc'] != "0" && trim($item['ac_desc']) != "") {
		$item['guestNamesRaw'] = "Cash";
		$item['guestNames'] = "Cash";
		$item['role'] = "Room";
		$item['pr_persona_ix'] = "";
		array_push($newRoomList, $item);
	}
}
$agentInfo = $GLOBALS['lDB']->get("
	SELECT
		pr_persona.pr_name_last,
		pr_persona.pr_persona_ix
	FROM
		rv_reservation
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
	WHERE
		rv_reservation_ix = '$rv_reservation_id'
",1);
if($agentInfo['pr_persona_ix'] == "") {
	$agentInfo['pr_name_last'] = "Cash";
}
array_unshift(
	$newRoomList,array(
		'role'=>'Agent', 
		'guestNames'=>$agentInfo['pr_name_last'],
		'guestNamesRaw'=>$agentInfo['pr_name_last'], 
		'ac_desc'=>"&nbsp;",'ac_desc_raw'=>"", 
		'rv_item_date_arrive'=>"&nbsp;", 
		'rv_item_date_depart'=>"&nbsp;", 
		'pr_name_last'=>"&nbsp;", 
		'ac_accomm_desc'=>"&nbsp;", 
		'pr_persona_ix'=>isset($agentInfo['pr_persona_ix']) ? $agentInfo['pr_persona_ix'] : "",
		'rv_res_item_group_ix'=>""
	)
);
$billing = $GLOBALS['lDB']->get("
	SELECT
		pr_persona.pr_name_first,
		pr_persona.pr_name_last,
		pr_persona.pr_persona_ix
	FROM
		rv_reservation
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_billing_persona_id 
	WHERE
		rv_reservation_ix = '$rv_reservation_id'
",1);
if(empty($billing) || $billing['pr_persona_ix'] == "") {
	$billing['pr_name_last'] = "Cash";
    $billing['pr_name_first'] = "";
    $billing['pr_persona_ix'] = "";
}
$billingName = trim($billing['pr_name_first']);
if($billingName != "") { $billingName .= " "; }
$billingName .= trim($billing['pr_name_last']);
array_unshift($newRoomList,array('role'=>'Billing Contact','guestNames'=>$billingName, 'guestNamesRaw'=>$billingName, 'ac_desc'=>"&nbsp;", 'ac_desc_raw'=>"",'rv_item_date_arrive'=>"&nbsp;", 'rv_item_date_depart'=>"&nbsp;", 'pr_name_last'=>"&nbsp;", 'ac_accomm_desc'=>"&nbsp;",'pr_persona_ix'=>$billing['pr_persona_ix'],'rv_res_item_group_ix'=>""));
$invoice = $GLOBALS['lDB']->get("
	SELECT
		pr_persona.pr_name_first,
		pr_persona.pr_name_last,
		pr_persona.pr_persona_ix
	FROM
		rv_reservation
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_invoice_persona_id  
	WHERE
		rv_reservation_ix = '$rv_reservation_id'
",1);
if(empty($invoice) || $invoice['pr_persona_ix'] == "") {
	$invoice['pr_name_last'] = "Cash";
    $invoice['pr_name_first'] = "";
    $invoice['pr_persona_ix'] = "";
}
$invoiceName = trim($invoice['pr_name_first']);
if($invoiceName != "") { $invoiceName .= " "; }
$invoiceName .= trim($invoice['pr_name_last']);
array_unshift($newRoomList,array('role'=>'Invoice Contact','guestNames'=>$invoiceName, 'guestNamesRaw'=>$invoiceName, 'ac_desc'=>"&nbsp;",'ac_desc_raw'=>"", 'rv_item_date_arrive'=>"&nbsp;", 'rv_item_date_depart'=>"&nbsp;", 'pr_name_last'=>"&nbsp;", 'ac_accomm_desc'=>"&nbsp;",'pr_persona_ix'=>$invoice['pr_persona_ix'],'rv_res_item_group_ix'=>""));
$roomList = null;
//debug($newRoomList);

$rowHTML = join("\n",file(__DIR__ . "/../../../public/html/room_extras_contact_rows.htm"));
$rows = "";
foreach($newRoomList as $item) {
	$item['guestNamesRaw'] = t_encodeOverlib($item['guestNamesRaw']);
	$rows .= showpage($item,$rowHTML);
}
//$GLOBALS['temp']['contactRows'] = $rows;	

$GLOBALS['temp']['contactList'] = "
<div id=\"tmpTable\">
	<table style=\"table-layout:fixed;\" class=\"colWh uk-table uk-table-hover fullWidth uk-table-striped\">
	<col width=\"80\">
	<col width=\"120\">
	<col width=\"57\">
	<col width=\"70\">
	<col width=\"70\">
	<col width=\"90\">
	<col width=\"100\">
	<col width=\"25\">
		<thead>
			<tr class=\"darkbar\">
				<td height=\"20\">Role</td>
				<td>Contact / Guests</td>
				<td>Room</td>
				<td>Arrive</td>
				<td>Depart</td>
				<td>Property</td>
				<td>Accom</td>
				<td class=\"uk-text-center toggle-pointer\" onclick=\"toggle('contactList');\"><i class=\"material-icons uk-margin-small-top btn-ns\">close</i></td>
			</tr>
		</thead>
		<tbody>
		$rows
		</tbody>
	</table>
</div>
";
$travelCatList = $GLOBALS['lDB']->get("
	SELECT
		ac_extra_category_ix 
	FROM 
		ac_extra_category 
	WHERE
		ac_extra_cat_ind = 2
",3);
$travelCatData = "[]";
if(sizeof($travelCatList) > 0) {
	$travelCatData = '["'.join('","',$travelCatList).'"]';
}
$GLOBALS['temp']['travelCatData'] = $travelCatData;


$extraCategoryId = false;
$extraCategoryList = $GLOBALS['lDB']->get("
	SELECT DISTINCT
		ac_extra_category.ac_extra_category_db,
		ac_extra_category.ac_extra_category_ix,
		ac_extra_category.ac_extra_cat_desc
	FROM
		ac_extra_category
		INNER JOIN ac_extra ON ac_extra.ac_extra_category_id = ac_extra_category.ac_extra_category_ix
		INNER JOIN ac_extra_prop ON ac_extra_prop.ac_extra_id = ac_extra.ac_extra_ix
		LEFT JOIN pr_business ON pr_business.pr_business_id = ac_extra_prop.pr_business_id
	WHERE
		ac_extra_category_inactive_yn = '0'
		AND ac_extra.ac_inactive_yn = '0'
		AND (ac_extra_prop.pr_business_id = '$chargePropertyId' OR pr_business.pr_business_id IS NULL)
	ORDER BY
		ac_extra_category.ac_extra_cat_desc
",2);
$extraCategoryOptions = "";
foreach($extraCategoryList as $item) {
	if($extraCategoryId === false && $item['ac_extra_category_db'] == $GLOBALS['dbcode']) {
		$extraCategoryId = $item['ac_extra_category_ix'];
		$selected = " selected ";
	} else {
		$selected = "";
	}
	$extraCategoryOptions .= "<option value=\"$item[ac_extra_category_ix]\" $selected>$item[ac_extra_cat_desc]</option>";
}
$GLOBALS['temp']['extraCategoryOptions'] = $extraCategoryOptions;
if($extraCategoryId === false) {
	$extraCategoryId = $extraCategoryList[0]['ac_extra_category_ix'];
}
$extraList = $GLOBALS['lDB']->get("
	SELECT DISTINCT
		ac_extra.ac_extra_ix,
		ac_extra.ac_ext_desc,
		ac_extra.ac_ext_amount,
		IF( ac_extra.rf_tax_ind != 20, 
			rf_tax_rate.rf_tax_rate_perc, 
			(SELECT sum(tr.rf_tax_rate_perc)
				FROM rt_tax_group tg
				INNER JOIN rt_tax_group_item ti ON ti.rt_tax_group_id = tg.rt_tax_group_ix 
				INNER JOIN rf_tax_rate tr ON tr.rf_tax_rate_ix = ti.rf_tax_rate_id
				WHERE tg.rt_tax_group_ix = rt_tax_group.rt_tax_group_ix)
		) AS rf_tax_rate_perc, 
		ac_extra.rf_tax_ind,
		ac_extra.rf_currency_id,
		rf_currency.rf_currency_symbol,
		rf_tax_rate.rf_tax_rate_ix,
        rt_tax_group.rt_tax_group_ix,
		ac_extra.ac_ext_note,
		ac_extra.ac_ext_note_internal,
		ac_extra.ac_ext_travel_eta,
		ac_extra.ac_ext_travel_etd,
		ac_extra.ac_ext_adult_count,
		ac_extra.ac_ext_child_count,
		ac_extra.ac_ext_nights,
		ac_extra.ac_extra_xref,
		ac_extra.ac_extra_external_yn,
		ac_extra.ac_ext_supplier_conf_yn,
		ac_extra.pr_supplier_id,
		ac_extra_category.ac_extra_cat_ind,
		CONCAT_WS(' ',pr_persona.pr_name_first,pr_persona.pr_name_last) AS supplier_name
	FROM
		ac_extra
		INNER JOIN ac_extra_prop ON ac_extra_prop.ac_extra_id = ac_extra.ac_extra_ix
		INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
		LEFT JOIN pr_business ON pr_business.pr_business_id = ac_extra_prop.pr_business_id
		LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = ac_extra.rf_tax_id
        LEFT JOIN rt_tax_group ON rt_tax_group.rt_tax_group_ix = ac_extra.rf_tax_id
		LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = ac_extra.rf_currency_id
		LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = ac_extra.pr_supplier_id
	WHERE
		ac_extra.ac_inactive_yn = '0'
		AND (ac_extra_prop.pr_business_id = '$chargePropertyId' OR pr_business.pr_business_id IS NULL)
		AND ac_extra.ac_extra_category_id = '$extraCategoryId'
	ORDER BY
		ac_extra.ac_ext_desc
",6);
$extraOptions = "<option value=\"0:|:0\">Please choose...</option>";
$noteJS = "";
$extraCount = 0;

foreach($extraList as $item) {
    if( $item['rf_tax_ind'] == 10 && (trim($item['rf_tax_rate_ix']) == "" || $item['rf_tax_rate_ix'] == "0") ||
        $item['rf_tax_ind'] == 20 && (trim($item['rt_tax_group_ix']) == "" || $item['rt_tax_group_ix'] == "0") ) {
        $item['rf_currency_id'] = "";
    }
	$extraOptions .= "<option value=\"$item[ac_extra_ix]:|:$item[ac_ext_amount]:|:$item[rf_tax_rate_perc]:|:$item[rf_currency_id]:|:$item[rf_currency_symbol]:|:$item[pr_supplier_id]:|:$item[supplier_name]:|:$item[ac_ext_supplier_conf_yn]:|:$item[ac_ext_adult_count]:|:$item[ac_ext_child_count]:|:$item[ac_ext_nights]:|:$item[ac_extra_cat_ind]\">$item[ac_ext_desc]</option>";
	$noteJS .=  "noteArray[$extraCount] = \"".t_encodeOverlib($item['ac_ext_note'])."\";";
	$noteJS .= "memoArray[$extraCount] = \"".t_encodeOverlib($item['ac_ext_note_internal'])."\";";
	$noteJS .= "etaArray[$extraCount] = \"".t_encodeOverlib($item['ac_ext_travel_eta'])."\";";
	$noteJS .= "etdArray[$extraCount] = \"".t_encodeOverlib($item['ac_ext_travel_etd'])."\";";
	$noteJS .= "referenceArray[$extraCount] = \"".t_encodeOverlib($item['ac_extra_xref'])."\";";
	$extraCount++;
}
$GLOBALS['temp']['extraOptions'] = $extraOptions;
$GLOBALS['temp']['noteJS'] = $noteJS;

if(isset($_POST['action']) && $_POST['action'] == 'category') {
	echo "
		<script language=\"javascript\">
			parent.id(\"ac_extra_id\").options.length = 0;
			parent.noteArray = new Array();
			parent.memoArray = new Array();
			parent.etaArray = new Array();
			parent.etdArray = new Array();
			parent.referenceArray = new Array();
			count = 0;
	";
	$extraList = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			ac_extra.ac_extra_ix,
			ac_extra.ac_ext_desc,
			ac_extra.ac_ext_amount,
			IF( ac_extra.rf_tax_ind != 20, 
				rf_tax_rate.rf_tax_rate_perc, 
				(SELECT sum(tr.rf_tax_rate_perc)
					FROM rt_tax_group tg
					INNER JOIN rt_tax_group_item ti ON ti.rt_tax_group_id = tg.rt_tax_group_ix 
					INNER JOIN rf_tax_rate tr ON tr.rf_tax_rate_ix = ti.rf_tax_rate_id
					WHERE tg.rt_tax_group_ix = rt_tax_group.rt_tax_group_ix)
			) AS rf_tax_rate_perc, 
			ac_extra.rf_tax_ind,
			ac_extra.rf_currency_id,
			rf_currency.rf_currency_symbol,
			rf_tax_rate.rf_tax_rate_ix,
            rt_tax_group.rt_tax_group_ix,
			ac_extra.ac_ext_note,
			ac_extra.ac_ext_note_internal,
			ac_extra.ac_ext_travel_eta,
			ac_extra.ac_ext_travel_etd,
			ac_extra.ac_ext_adult_count,
			ac_extra.ac_ext_child_count,
			ac_extra.ac_ext_nights,
			ac_extra.ac_extra_xref,
			ac_extra.ac_extra_external_yn,
			ac_extra.ac_ext_supplier_conf_yn,
			ac_extra.pr_supplier_id,
			ac_extra_category.ac_extra_cat_ind,
			CONCAT_WS(' ',pr_persona.pr_name_first,pr_persona.pr_name_last) AS supplier_name
		FROM
			ac_extra
			INNER JOIN ac_extra_prop ON ac_extra_prop.ac_extra_id = ac_extra.ac_extra_ix
			INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
			LEFT JOIN pr_business ON pr_business.pr_business_id = ac_extra_prop.pr_business_id
			LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = ac_extra.rf_tax_id
            LEFT JOIN rt_tax_group ON rt_tax_group.rt_tax_group_ix = ac_extra.rf_tax_id
			LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = ac_extra.rf_currency_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = ac_extra.pr_supplier_id
		WHERE
			ac_extra.ac_inactive_yn = '0'
			AND (ac_extra_prop.pr_business_id = '$chargePropertyId' OR pr_business.pr_business_id IS NULL)
			AND ac_extra.ac_extra_category_id = '$_POST[ac_extra_category_ix]'
		ORDER BY 
			ac_extra.ac_ext_desc
	",2);
	echo "parent.id(\"ac_extra_id\").options[count++] = new Option(\"Please choose...\",\"0:|:0\");";
	foreach($extraList as $item) {
        if( $item['rf_tax_ind'] == 10 && (trim($item['rf_tax_rate_ix']) == "" || $item['rf_tax_rate_ix'] == "0") ||
            $item['rf_tax_ind'] == 20 && (trim($item['rt_tax_group_ix']) == "" || $item['rt_tax_group_ix'] == "0") ) {
            $item['rf_currency_id'] = "";
        }
		
		echo "parent.id(\"ac_extra_id\").options[count] = new Option(\"$item[ac_ext_desc]\",\"$item[ac_extra_ix]:|:$item[ac_ext_amount]:|:$item[rf_tax_rate_perc]:|:$item[rf_currency_id]:|:$item[rf_currency_symbol]:|:$item[pr_supplier_id]:|:$item[supplier_name]:|:$item[ac_ext_supplier_conf_yn]:|:$item[ac_ext_adult_count]:|:$item[ac_ext_child_count]:|:$item[ac_ext_nights]:|:$item[ac_extra_cat_ind]\");";

		echo "parent.noteArray[count-1] = \"".t_encodeOverlib($item['ac_ext_note'])."\";";
		echo "parent.memoArray[count-1] = \"".t_encodeOverlib($item['ac_ext_note_internal'])."\";";
		echo "parent.etaArray[count-1] = \"".t_encodeOverlib($item['ac_ext_travel_eta'])."\";";
		echo "parent.etdArray[count-1] = \"".t_encodeOverlib($item['ac_ext_travel_etd'])."\";";
		echo "parent.referenceArray[count-1] = \"".t_encodeOverlib($item['ac_extra_xref'])."\";";
		echo "count++;";
	}	
	echo "
		</script>
	";
	die();
}

$exchangeList = db_rf_exchange_rate_get_all_rates();
$rows = "";
foreach($exchangeList as $item) {
	$rows .= "<INPUT type=\"hidden\" id=\"curr$item[rf_exch_curr_from_id]_$item[rf_exch_curr_to_id]\" value=\"$item[rf_exch_rate]\">\n";
}
$GLOBALS['temp']['exchangeList'] = $rows;

if(!$readonly && isset($_POST['action']) && $_POST['action'] == "add" && isset($_POST['randomId']) && $_POST['randomId'] == $_SESSION['quickExtraRandomId']) {
//debug($_POST);
	// Find billing entity
//	$today = date("Y-m-d"); // this needs to be received from the client
	$serviceDate = isset($_POST['rv_extra_date_serv']) ? $_POST['rv_extra_date_serv'] : "";
	$businessId = "";
	$currId = $_POST['pr_business_id'];
	while($businessId == "" && $currId != "0" && trim($currId) != "") {
		if(!$GLOBALS['isPropServer']) {
			$billingYN = $GLOBALS['lDB']->get("SELECT pr_bus_billing_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
		} else {
			$billingYN = $GLOBALS['lDB']->get("SELECT pr_bus_billing_prop_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
		}
		if($billingYN == "1") {
				$businessId = $currId;
		} else {
				$currId = $GLOBALS['lDB']->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id ='$currId'",4);
		}
	}
  if($businessId == "" || $businessId == "0") {
		// hide billing entity fields to stop from looking ugly
	}  
  
  $name = $GLOBALS['lDB']->get("SELECT pr_name_first, pr_name_last FROM pr_persona WHERE pr_persona_ix = '$businessId'",1);
  if($name[0] != ""){
	$name[0] .= ", "; 
  }
  $billingName = $name[0].$name[1];
  $regNum = $GLOBALS['lDB']->get("SELECT pr_bus_statutory_1 FROM pr_business WHERE pr_business_id = '$businessId'",4);
  $vatNum = $GLOBALS['lDB']->get("SELECT pr_bus_statutory_2 FROM pr_business WHERE pr_business_id = '$businessId'",4);

	if(!$GLOBALS['isPropServer']) {
		$homeCurrencyId = $GLOBALS['lDB']->get("SELECT rv_invoice_currency_id FROM rv_reservation WHERE rv_reservation_ix = '$rv_reservation_id'",4);
	} else {
		$homeCurrencyId = $GLOBALS['lDB']->get("SELECT pr_bus_prop_curr_id FROM pr_business WHERE pr_business_id = '$_POST[pr_business_id]'",4);
	}
	$homeCurrency = $GLOBALS['lDB']->get("SELECT rf_currency_symbol FROM rf_currency WHERE rf_currency_ix = '$homeCurrencyId'",4);
	$expiryDays = $GLOBALS['lDB']->get("select rf_exch_expiry_days from rf_default",4);
	$expiryDate = date("Y-m-d",mktime(0,0,0,date("m"),date("d")+$expiryDays,date("Y")));

	//debug(unserialize(str_replace("\\","",$_POST['extras'])));
	//$extraList = unserialize(str_replace("\\","",$_POST['extras']));
	$extraList = unserialize(str_replace("\r","",stripslashes($_POST['extras'])));
	
	$rows = "";
	$rowHTML = "
		<tr valign=\"top\"> 
			<td class=\"br bl\">!ac_ext_desc!</td>
			<td class=\"br\">!ac_extra_cat_desc!</td>
			<td class=\"br\" align=\"right\">!qty!</td>
			<td align=\"right\" class=\"br\">!total!</td>
		</tr>
	";
	$grandTotal = 0;
	$taxTotal = 0;
	$first = false;
  
  $newExtraList = array();
	foreach($extraList as $item) {
		$item = array_merge($item,$GLOBALS['lDB']->get("
			SELECT
				ac_ext_amount,
				ac_ext_comm_pay,
				ac_ext_comm_rec,
				ac_ext_note,
				ac_ext_note_internal,
				ac_extra.rf_tax_ind,
				IF(	ac_extra.rf_tax_ind = '10',
					rf_tax_rate.rf_tax_rate_perc,
					(
						SELECT
							SUM(rf_tax_rate.rf_tax_rate_perc)
						FROM
							ac_extra
							LEFT JOIN rt_tax_group_item ON rt_tax_group_item.rt_tax_group_id = ac_extra.rf_tax_id
							LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rt_tax_group_item.rf_tax_rate_id
						WHERE
							ac_extra_ix = '".$item['ac_extra_ix']."'
					)
					) AS rf_tax_rate_perc,
				rf_currency.rf_currency_ix as rf_currency_id,
				ac_ext_desc,
				ac_extra_category.ac_extra_cat_desc,
				ac_extra.rf_tax_id
			FROM
				ac_extra
				INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
				LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = ac_extra.rf_tax_id
				LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = ac_extra.rf_currency_id
			WHERE
				ac_extra_ix = '$item[ac_extra_ix]'
		",1));
		if($item['rf_currency_id'] == $homeCurrencyId) {
			$item['exch'] = 1;
		}
		if($_POST['rv_res_item_group_ix'] == "") {
			$_POST['rv_res_item_group_ix'] = false;
		}
		//$item['ac_ext_note'] = str_replace("'","\\'",$item['ac_ext_note']);
		//$item['ac_ext_note_internal'] = str_replace("'","\\'",$item['ac_ext_note_internal']);

		// Ignore passed percentage, look up percentage from Tax Code Table
		$taxPerc = taxPercentage($item['rf_tax_id'], $item['rf_tax_ind']);
		
		$newExtraId = db_rv_extra_insert($_POST['rv_reservation_ix'], $item['ac_extra_ix'], $_POST['pr_business_id'], $item['qty'], $item['rv_extra_date_serv'], $item['price'], 0, $taxPerc, $item['ac_ext_comm_rec'], $item['ac_ext_comm_pay'], addslashes($item['note']), addslashes($item['memo']), $_POST['rv_res_item_group_ix'], $item['rf_currency_id'], $homeCurrencyId, $item['exch'], $expiryDate, $businessId, addslashes($item['rv_extra_travel_eta']), addslashes($item['rv_extra_travel_etd']), $item['rv_extra_adult_count'], $item['rv_extra_child_count'], $item['rv_extra_date_depart'], addslashes($item['rv_extra_ref']), intval($item['rv_extra_supplier_conf_yn']), $item['pr_supplier_id']);
		db_rv_extra_tax_insert($newExtraId, $item['rf_tax_ind'], $item['rf_tax_id']);
		verify_extra($newExtraId);

		array_push($newExtraList,$newExtraId);     
		$GLOBALS['temp']['extraList'] = join(":",$newExtraList);
		if($item['rf_currency_id'] == "" || $item['rf_currency_id'] == "0") {
			$chargable = false;
		} else {
			$chargable = true;
		}
	
	if($first == false && $chargable) {
			$fn_folio_id = db_fn_folio_insert_extra($newExtraId, $_POST['rv_res_item_group_ix'], $_POST['rv_invoice_persona_id']);
			$first = true;
		}

		if($chargable) {
			db_rv_extra_set_folio($newExtraId, $fn_folio_id);
		}

		if($item['rf_currency_id'] == "" || $item['rf_currency_id'] == "0") {
			$item['total'] = "&nbsp;";
		} else {
			$item['total'] = $GLOBALS['lDB']->get("SELECT rv_extra_amt_payable FROM rv_extra WHERE rv_extra_ix = '$newExtraId'",4);
			$tax = $item['total'] / ($item['rf_tax_rate_perc'] + 100) * $item['rf_tax_rate_perc'];
			$taxTotal += $tax;
			$grandTotal += $item['total'];
			fixAmtDisplay($item['total']);
			 $item['total'] .= " ".$homeCurrency;
		}

		db_rf_exchange_rate_set($item['rf_currency_id'],$homeCurrencyId,$item['exch']);

		$rows .= showpage($item,$rowHTML);
	}
	$GLOBALS['temp']['rows'] = $rows;
	fixAmtDisplay($taxTotal);
	fixAmtDisplay($grandTotal);
	$GLOBALS['temp']['taxTotal'] = $taxTotal;
	$GLOBALS['temp']['grandTotal'] = $grandTotal;
	$GLOBALS['temp']['homeCurrency'] = $homeCurrency;
	if (!is_object($GLOBALS[$form])) {
		$GLOBALS['form294'] = new Form("form294","",__DIR__ . "/../../../public/html/quick_entry_confirm.htm");
	} 
	
  $GLOBALS['temp']['resExtraJob'] = "609";
   if (checkJob($_SERVER['argv'][0],2) > 5)
   {
	//  if ($action != "1")
	  //{
		 $GLOBALS['temp']['resExtraJob'] = "610";
	  //}
   }
	$GLOBALS['temp']['rnum'] = $_POST['rv_reservation_ix']; 
  
	$principalId = $GLOBALS['lDB']->get("SELECT rf_principal_id FROM rf_default", 4);
	$GLOBALS['temp']['principalName'] = getContactFullName($principalId);
	$GLOBALS['temp']['serviceDate'] = chng_date($serviceDate,"-");
  $GLOBALS['temp']['billingName'] = $billingName;  
  $GLOBALS['temp']['billingReg'] = $regNum;
  $GLOBALS['temp']['billingVat'] = $vatNum;  

	$checkDesc = $GLOBALS['lDB']->get("
		SELECT
			count(ac_accomm_room.ac_desc)
		FROM
			rv_res_item_group
			INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		WHERE
			rv_res_item_group.rv_res_item_group_ix = '$_POST[rv_res_item_group_ix]'
	",4);
	$desc = "";
	if($checkDesc > 0) {
		$desc = $GLOBALS['lDB']->get("
			SELECT
				ac_accomm_room.ac_desc
			FROM
				rv_res_item_group
				INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
			WHERE
				rv_res_item_group.rv_res_item_group_ix = '$_POST[rv_res_item_group_ix]'
		",4);
	}

	$guestName = $GLOBALS['lDB']->get("SELECT pr_name_first,pr_name_last FROM pr_persona WHERE pr_persona_ix = '$_POST[pr_guest_id]'",1);
	$guestName = trim($guestName['pr_name_first'] . " " . $guestName['pr_name_last']);
	if($guestName != "") {
		if($desc != "") {
			$desc .= " - ";
		}
		$desc .= $guestName;
	}

	if($desc == "") {
		$desc = $_POST['rv_reservation_ix'];
	} else {
		$desc .= " (".$_POST['rv_reservation_ix'].")";
	}
	$GLOBALS['temp']['chargedTo'] = $desc;

	$invoicedTo = $GLOBALS['lDB']->get("SELECT pr_name_first,pr_name_last FROM pr_persona WHERE pr_persona_ix = '$_POST[rv_invoice_persona_id]'",1);
	$GLOBALS['temp']['invoicedTo'] = trim($invoicedTo['pr_name_first'] . " " . $invoicedTo['pr_name_last']);
	if($GLOBALS['temp']['invoicedTo'] == "") {
		$GLOBALS['temp']['invoicedTo'] = "Cash";
	}
	$GLOBALS['temp']['logoURL'] = $GLOBALS['http'].$GLOBALS['images_dir']."/".$GLOBALS['principal_id']."/top_clientlogo.jpg";
	array_pop($GLOBALS['history']);	// Remove from 'back'

	if (isset($_POST['withClose'])){
		if($_POST['withClose'] == "1") {
			$message = $desc . " has been updated with " . $grandTotal . " " . $homeCurrency;
			//"RS:xyz (Room ref if applicable), Folio owner name has been updated with R150.00
			echo "<html><body><script language=\"javascript\">if (opener.openMessage) { opener.openMessage('".t_encodeOverlib($message)."'); } if(opener.ng && opener.ng_rooming_legacy_add_extras) { opener.ng_rooming_legacy_add_extras(); } window.close();</script></body></html>";
			die();
		} elseif($_POST['withClose'] == "2") {
			echo "<html><body><script language=\"javascript\">if (opener.addPayment) { opener.addPayment(); } if(opener.ng && opener.ng_rooming_legacy_add_extras) { opener.ng_rooming_legacy_add_extras('$rv_reservation_item_id'); } window.close();</script></body></html>";
			die();
		}
	}
	
}

function getChildren($businessId) {
	$list = $GLOBALS['lDB']->get("
		SELECT
			pr_business_id
		FROM
			pr_business
		WHERE
			pr_business_parent = '$businessId'
	",3);
	$children = array();
	foreach($list as $item) {
		$children = array_merge($children,getChildren($item));
	}
	array_push($children, $businessId);
	return $children;
}
session_set("quickExtraRandomId",md5(uniqid(rand(),1)));
$GLOBALS['temp']['randomId'] = $_SESSION['quickExtraRandomId'];

$GLOBALS['temp']['propertyId'] = $propertyId;
$GLOBALS['temp']['chargePropertyId'] = $chargePropertyId;
