<?php
/*
 * $Id: init.form314.php,v 1.6 2012-03-08 11:45:09 light Exp $
 *
 * $Log: init.form314.php,v $
 * Revision 1.6  2012-03-08 11:45:09  light
 * Bug #7746 - Data transfer enchancements (http upload + zip library)
 *
 * Revision 1.5  2011-05-17 14:08:29  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.4  2007-05-24 13:13:08  light
 * Data transfer automation update:
 *
 * 1) Removed all references to rf_message
 * 2) Changed the data transfer code to use sc_transfer
 *
 *
 */

/**
 * init.form314.php - Review data transfer popup
 * Job: 743
 * Function: 64 (Data transfer)
 */

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form("$form","",__DIR__ . "/../../../public/html/data_transfer_pop.htm");
}

global $principal_id;

$topProperty = $GLOBALS['lDB']->get("
	SELECT
		pr_link_to
	FROM
		pr_link
	WHERE
		pr_link.rf_link_type_id = 'RS1'
		AND pr_link.pr_link_from = '".$GLOBALS['userid']."'
",4);

$propertyList = $GLOBALS['lDB']->get("
	SELECT DISTINCT
		ac_accomm_type.pr_business_id
	FROM
		ac_accomm_type
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
	WHERE
		ac_accomm_type.pr_business_id IN ('".join("','",getChildren($topProperty))."')
",3);

$listArray = $GLOBALS['lDB']->get("
	SELECT
		rf_database.rf_db_code as id,
		rf_db_description as namelast
	FROM
		rf_database
		INNER JOIN rf_db_business ON rf_database.rf_db_code = rf_db_business.rf_db_code
	WHERE
		rf_db_business.pr_business_id IN ('".join("','",$propertyList)."')
	GROUP BY
		rf_db_business.rf_db_code
",2);

$propServerList = "";
$propServerNames = "All";
$imax = sizeof($listArray);
for ($i=0;$i<$imax;$i++) {
	if ($i!=0) $propServerList .= ":";
	$propServerList .= $listArray[$i]['id'];
}

$startFromDate = date("Y-m-d",mktime(0,0,0,date("m"),date("d")-30,date("Y")));

$GLOBALS['tagList']['propertyServerIds'] = setNewValue($propServerList);
$GLOBALS['tagList']['propertyServerFilter'] = $propServerNames;
$propListSQL = " tc_transfer_db IN ('".str_replace(":","','",$propServerList)."')";

if ($GLOBALS['rf_db_env_type_ind'] > "2") {
	$propListSQL .= " OR tc_transfer_db = '$dbcode'";
}

$trfSrcSql = "";
$resOffSQL = " AND tc_transfer_db NOT LIKE 'R%'";

$temp = explode("-",$startFromDate);
$GLOBALS['temp']['selectMonth'] = (string) (int) $temp[1];
$GLOBALS['temp']['selectDay'] = (string) (int) $temp[2];
$GLOBALS['temp']['year'] = (string) (int) $temp[0];

# Input parameters (for testing purposes)
$startTrfId = 'XX99999999999';

#---------------------------------------------------------------------#
# Start of Data access code                                           #
#---------------------------------------------------------------------#

###############################################################
# Get transfer records
###############################################################

$filterSQL = "WHERE tc_trf_time_start > '".$startFromDate." 00:00:00'";

$start = 0;
$limit = 20;
$trfSql = "
	SELECT
		tc_transfer.tc_transfer_ix as trfId,
		tc_transfer.tc_trf_time_start as timeStart,
		tc_transfer.tc_trf_time_close as timeClose,
		tc_transfer.tc_trf_time_extract as timeExtract,
		tc_transfer.tc_trf_time_send as timeSend,
		tc_transfer.tc_trf_file_size as filesize,
		pr_persona.pr_name_last as firstname,
		pr_persona.pr_name_first as lastname,
		sc_transfer.sc_trf_message as msg,
		tc_transfer.tc_trf_source as source,
		tc_transfer.sc_transfer_id as msgId,
		tc_transfer.tc_user_id as userId,
		tc_transfer.tc_transfer_db as trfDB
";

$where ="
	FROM
		tc_transfer
		INNER JOIN pr_persona ON tc_transfer.tc_user_id = pr_persona_ix
		LEFT JOIN sc_transfer ON tc_transfer.sc_transfer_id = sc_transfer.sc_transfer_id
		".$filterSQL."
	ORDER BY
		tc_transfer.tc_trf_time_start DESC
";

$count = $lDB->get("select count(tc_transfer_id) ".$where,4);
$GLOBALS['temp']['recFound'] = $count;
$trfSql .= $where." LIMIT $limit";

# Get the transfers record set
$transfers = $GLOBALS['lDB']->get($trfSql,2);
$trfRows = sizeof($transfers);

# Display test results
$HTML = Join("",file(__DIR__ . "/../../../public/html/data_transfer_pop_rows.htm"));
$GLOBALS['temp']['rows'] = "";
for ($i=0; $i<$trfRows; $i++) {
	$trf_enh = array();
	$trf_enh['id'] = $transfers[$i]['trfId'];
	$trf_enh['started'] = "";
	if ($transfers[$i]['timeStart'] != "0000-00-00 00:00:00"){
		$temp = explode(" ",$transfers[$i]['timeStart']);
		$trf_enh['started'] = $temp[1]." ".chng_date($temp[0],"-");
	}
	$trf_enh['completed'] = "";
	if ($transfers[$i]['timeClose'] != "0000-00-00 00:00:00"){
		$temp = explode(" ",$transfers[$i]['timeClose']);
		$trf_enh['completed'] = $temp[1]." ".chng_date($temp[0],"-");
	}

	$trf_enh['transmission'] = "";
	if ($transfers[$i]['timeExtract'] != "0000-00-00 00:00:00" && $transfers[$i]['timeSend'] != "0000-00-00 00:00:00"){
		$tempe = explode(" ",$transfers[$i]['timeSend']);
		$tempea = explode("-",$tempe[0]);
		$year = $tempea[0];
		$month = $tempea[1];
		$day = $tempea[2];
		$tempeb = explode(":",$tempe[1]);
		$hour = $tempeb[0];
		$minute = $tempeb[1];
		$second = $tempeb[2];
		$temps = explode(" ",$transfers[$i]['timeExtract']);
		$tempsa = explode("-",$temps[0]);
		$year -= $tempsa[0];
		$month -= $tempsa[1];
		$day -= $tempsa[2];
		$tempsb = explode(":",$temps[1]);
		$hour -= $tempsb[0];
		$minute -= $tempsb[1];
		$second -= $tempsb[2];
		$trf_enh['transmission'] = date("H:i:s",mktime($hour,$minute,$second,$month+date("M"),$day+date("d"),$year+date("Y")));
	}

	$trf_enh['filesize'] = "";
	if ($transfers[$i]['filesize'] != "0") {
		$trf_enh['filesize'] = $transfers[$i]['filesize'] / 10;
		$trf_enh['filesize'] = (int) $trf_enh['filesize'];
		$trf_enh['filesize'] = $trf_enh['filesize'] / 100;
	}
	if ($trf_enh['filesize'] != "") {
		$trf_enh['filesize'] .= " KB";
	}
	$trf_enh['user'] = "";
	if ($transfers[$i]['lastname'] != "0") {
		$trf_enh['user'] = trim($transfers[$i]['firstname']." ".$transfers[$i]['lastname']);
	}
	$trf_enh['msg'] = "";
	if ($transfers[$i]['msg'] != "" && $transfers[$i]['msg'] != "0") {
		$trf_enh['msg'] = t_encodeOverlib($transfers[$i]['msg']);
		if ($transfers[$i]['msgId'] != "" && $transfers[$i]['msgId'] != "0") {
			$trf_enh['msg'] .= " [".$transfers[$i]['msgId']."]";
		}
	}
	$trf_enh['msgShow'] = " style=\"display:none\"";
	if ($trf_enh['msg'] != "" && $transfers[$i]['msgId'] != "52" && $transfers[$i]['msgId'] != "1033" && $transfers[$i]['msgId'] != "1054" && $transfers[$i]['msgId'] != "1026" && $transfers[$i]['msgId'] != "1045") {
		$trf_enh['msgShow'] = "";
	}
	$trf_enh['source'] = $transfers[$i]['source'];
	$logFile = $principal_id."_".$transfers[$i]['trfId']."_".str_replace(" ","_",str_replace(":","-",$transfers[$i]['timeStart']))."_".$transfers[$i]['source']."_".$transfers[$i]['userId'].".log";
	$logDir = getTransferDirDT37($logFile,TRANSFER_DIR_LOG);  
	$logURL = "reservation.php?127+$GLOBALS[userid]+9+".TRANSFER_DIR_LOG."+$logFile";
	
	$trf_enh['logFile'] = $logURL;
	$trf_enh['hideLog'] = "";
	if (!is_file($logDir.$logFile)) {
		$trf_enh['logFile'] = "";
		$trf_enh['hideLog'] = " style=\"visibility:hidden\"";
	}
	$GLOBALS['temp']['rows'] .= showpage($trf_enh,$HTML);
}

if ($GLOBALS['temp']['rows'] == ""){
	$GLOBALS['temp']['rows'] .= "<tr class=form height=18><td align=center colspan=7>No transfers found.</td></tr>";
}
$GLOBALS['temp']['showLog'] = "false";
if ($GLOBALS['dbcode'][0] != "W") {
	$GLOBALS['temp']['showLog'] = "true";
}
