<?php

/*
 * $Id: init.form315.php,v 1.21 2013-04-15 12:33:55 light Exp $
 *
 * $Log: init.form315.php,v $
 * Revision 1.21  2013-04-15 12:33:55  light
 * Bug #8215 - Inactive banks and bank names on environment and billing unit
 *
 * Revision 1.20  2011-05-15 17:43:21  light
 * Bug #7581 - Mail update and enhancements
 *
 * Revision 1.19  2008-04-17 14:04:46  light
 * Fix to bank and environment code tables for new sys_code 7
 *
 * Revision 1.18  2007-12-19 09:18:24  light
 * Bug #5871 - Financial Interface
 *
 * Revision 1.17  2007-03-13 13:53:43  light
 * Bug #5728 - Environment setup
 *
 * Revision 1.16  2007-02-14 18:13:22  light
 * 3.14.0 bugs: Fixed the environment table password fields to disable when in list view or when editing WA/WB
 *
 * Revision 1.15  2007-02-08 15:44:37  light
 * 3.14.0 bugs: Fixed the environment table to use hidden password fields.
 *
 * Revision 1.14  2006-11-28 13:28:57  gregs
 * Bug #5485 - Server SMTP details. Added fix to utilise form class.
 *
 */

/** 
 * init.form315.php - The Environment Setup Code Table (Details)
 * Job: 744, 745, 746, 747, 748, 749
 * Function: 87 (Environment Setup)
 */

if( strtolower( $lDB->get("SELECT pr_user_name FROM pr_user WHERE pr_user_id= '".$GLOBALS['userid']."'", 4) ) == "censysad") {
	$isAdmin = true;
	$GLOBALS['temp']['isAdmin'] = "true";
} else {
	$isAdmin = false;
	$GLOBALS['temp']['isAdmin'] = "false";
}

if (!in_array(strtoupper($GLOBALS['dbcode']), array("WA", "WB", "RS"))) {
	// This be a property environment, no access!
	header("Location: reservation.php?999");
	die();
}

if(isset($_POST['action'])) {
	if($_POST['action'] == "clear_stock_cache" && $isAdmin) {
		if(Stock::EmptyCache()) {
			echo "Cleared stock cache";
		} else {
			echo "Error clearing stock cache";
		}
		die();
	}
	if($_POST['action'] == "test_services" && $isAdmin) {
		$cache = cacheMemSharedConnect();
		$queue = new Queue();
		$queue = ($queue->stats() !== false);
		echo json_encode(array(
			'cache'=>$cache,
			'queue'=>$queue
		));
		die();
	}
}

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/code_env_setup.htm");
	$fields = array(
		"rf_db_code",
		"rf_db_description",
		"rf_db_smtp_address",
		"rf_db_smtp_port",
		"rf_db_smtp_auth_ind",
		"rf_db_smtp_security_ind",
		"rf_db_smtp_username",
		"rf_db_smtp_hostname_override",
		"rf_db_time_zone",
		"rf_db_cache_stock_yn",
		"rf_db_inactive_yn"
	);
	$GLOBALS[$form]->AddTable($GLOBALS['lDB'],"rf_database",$fields,"rf_database.rf_db_code = '$record'","",""); 
} 

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

$GLOBALS['temp']['showMsg'] = "";
$record = $_SERVER['argv'][1];
$GLOBALS['autovar'] = "1";
$GLOBALS['temp']['isProperty'] = "";

$targetDbCode = $_SERVER['argv'][1];

if ($record != "") {
	$GLOBALS['passthrurecord'] = $record;
} else {
	if ($action != "2") {
  		$record = isset($GLOBALS['passthrurecord'])?$GLOBALS['passthrurecord']:"";
	    if ($_SERVER['argv'][1] == "") {
    		$_SERVER['argv'][1] = $record;
		}
	}
}

$GLOBALS['temp']['record'] = $record;

$recordId = $GLOBALS['lDB']->get("SELECT rf_database_id FROM rf_database WHERE rf_db_code = '$record'",4);

$GLOBALS[$form]->Get($action);

$table = $GLOBALS[$form]->TableList[0];

if ($record != "" || $action == "3" && $action != "1") {
	$GLOBALS[$table]->Refresh($record,$action);
}

$GLOBALS['temp']['allowClearStock'] = "false";
$GLOBALS['temp']['classClearStock'] = "collapse";
if($pmode != "1") {
	if(
		$action == "3"
		&& $isAdmin
		&& $GLOBALS[$form.'_rf_database_rf_db_code']->Value == $GLOBALS['dbcode']
		&& $GLOBALS[$form.'_rf_database_rf_db_cache_stock_yn']->Value == "1"
	) {
		$GLOBALS['temp']['allowClearStock'] = "true";
		$GLOBALS['temp']['classClearStock'] = "";
	}
}

$GLOBALS['temp']['cacheCheckbox'] = "";
$GLOBALS['temp']['cacheMessage'] = "";
$GLOBALS['temp']['environmentCheckbox'] = "";
$GLOBALS['temp']['environmentMessage'] = "";
$miscAuditTrail = new AuditTrail($record, TYPE_MISC);

/* Add / remove banks */
if($pmode == "1") {
	if($action == "2" || $action == "3") {
		if($isAdmin && (!isset($_POST['rf_db_cache_stock_yn']) || $_POST['rf_db_cache_stock_yn'] != "on")) {
			$GLOBALS[$form.'_rf_database_rf_db_cache_stock_yn']->SetValue(0);
		}
		if($isAdmin && (!isset($_POST['rf_db_inactive_yn']) || $_POST['rf_db_inactive_yn'] != "on")) {
			$GLOBALS[$form.'_rf_database_rf_db_inactive_yn']->SetValue(0);
		}
	}
	if(isset($_POST['deleteBank']) && trim($_POST['deleteBank']) != "") {
		$bank = $GLOBALS['lDB']->get(
			"
				SELECT
					rf_bank.rf_bank_acc_name,
					rf_bank_env.rf_bank_env_default_yn
				FROM
					rf_bank_env
					LEFT JOIN rf_bank ON rf_bank.rf_bank_ix = rf_bank_env.rf_bank_id
				WHERE
					rf_bank_env.rf_bank_env_ix = '" . $_POST['deleteBank'] . "'
			",
			1
		);
		$GLOBALS['lDB']->put("DELETE FROM rf_bank_env WHERE rf_bank_env_ix = '$_POST[deleteBank]'");
		$miscAuditTrail->addDetailMisc($bank['rf_bank_acc_name'], "", 3, $targetDbCode . " - Bank");
		if ($bank['rf_bank_env_default_yn'] == "1") {
			$miscAuditTrail->addDetailMisc($bank['rf_bank_acc_name'], "", 3, $targetDbCode . " - Bank default");
		}
	}
	
	if(isset($_POST['addBank']) && trim($_POST['addBank']) != "") {
		$count = $GLOBALS['lDB']->get("
			SELECT 
				COUNT(*) 
			FROM 
				rf_bank_env 
			WHERE 
				rf_database_id = '$recordId' 
				AND rf_bank_id = '$_POST[addBank]'
		",4);
		
		if($count < 1) {
			$rf_bank_env_default_yn = "0";
			if($_POST['addBankDefault'] == "new") {
				$rf_bank_env_default_yn = "1";
			}
			
			$GLOBALS['lDB']->put("
				INSERT INTO rf_bank_env (
					rf_bank_env_db,
					rf_bank_id,
					rf_database_id,
					rf_bank_env_default_yn
				) VALUES (
					'" . $GLOBALS['dbcode'] . "',
					'" . $_POST['addBank'] . "',
					'" . $recordId . "',
					'" . $rf_bank_env_default_yn . "'
				)
			");
			$bankName = $GLOBALS['lDB']->get("SELECT rf_bank_acc_name FROM rf_bank WHERE rf_bank_ix = '" . $_POST['addBank'] . "'", 4);
			$miscAuditTrail->addDetailMisc("", $bankName, 1, $targetDbCode . " - Bank");
		}
	}
	
	if(isset($_POST['addBankDefault']) && $_POST['addBankDefault'] != "new") {
		$oldDefault = $GLOBALS['lDB']->get("
			SELECT
				rf_bank_env_ix
			FROM
				rf_bank_env
			WHERE
				rf_bank_env_default_yn = '1'
			AND
				rf_database_id = '$recordId'
		",3);
		
		foreach($oldDefault as $item) {
			$GLOBALS['lDB']->put("
				UPDATE
					rf_bank_env
				SET
					rf_bank_env_default_yn = '0'
				WHERE
					rf_bank_env_ix = '$item'
			");
		}
		
		$GLOBALS['lDB']->put("
			UPDATE 
				rf_bank_env 
			SET 
				rf_bank_env_default_yn = '1' 
			WHERE 
				rf_bank_env_ix = '" . $_POST['addBankDefault'] . "'
		");
		$bankNamesOld = $GLOBALS['lDB']->get(
			"
				SELECT
					rf_bank.rf_bank_acc_name
				FROM
					rf_bank_env
					LEFT JOIN rf_bank ON rf_bank.rf_bank_ix = rf_bank_env.rf_bank_id
				WHERE
					rf_bank_env.rf_bank_env_ix IN ('" . join("','", $oldDefault) . "')
			",
			3
		);
		$bankName = $GLOBALS['lDB']->get(
			"
				SELECT
					rf_bank.rf_bank_acc_name
				FROM
					rf_bank_env
					LEFT JOIN rf_bank ON rf_bank.rf_bank_ix = rf_bank_env.rf_bank_id
				WHERE
					rf_bank_env.rf_bank_env_ix = '" . $_POST['addBankDefault'] . "'
			",
			4
		);
		if (!empty($bankName) && join(", ", $bankNamesOld) != $bankName) {
			$miscAuditTrail->addDetailMisc(join(", ", $bankNamesOld), $bankName, 2, $targetDbCode . " - Bank default");
		}
	}

	if(isset($_POST['deleteProperty']) && trim($_POST['deleteProperty']) != "") {
		$propName = $GLOBALS['lDB']->get(
			"
				SELECT
				pr_persona.pr_name_last
				FROM
					rf_db_business
					LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rf_db_business.pr_business_id
				WHERE
				rf_db_business.rf_db_business_ix = '" . $_POST['deleteProperty'] . "'
			",
			4
		);
		$miscAuditTrail->addDetailMisc($propName, "", 3, $targetDbCode . " - Property");
		db_rf_db_business_delete($_POST['deleteProperty']);
	}
	
	if(isset($_POST['addProperty']) && trim($_POST['addProperty']) != "") {
		db_rf_db_business_insert($record, $_POST['addProperty']);
		$propName = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '" . $_POST['addProperty'] . "'", 4);
		$miscAuditTrail->addDetailMisc("", $propName, 1, $targetDbCode . " - Property");
	}

	$smtpPassword = $GLOBALS['lDB']->get("SELECT rf_db_smtp_password FROM rf_database WHERE rf_db_code = '$record'",4);
	if(isset($_POST['rf_db_smtp_password']) && ($_POST['rf_db_smtp_password'] == "********" || $_POST['rf_db_smtp_password'] != $_POST['rf_db_smtp_password_confirm'])) {
		$_POST['rf_db_smtp_password'] = $smtpPassword;
	}

	$databaseValues = $GLOBALS['lDB']->get("
			SELECT
				rf_db_code,
				rf_db_description,
				rf_db_smtp_address,
				rf_db_smtp_port,
				rf_db_smtp_auth_ind,
				rf_db_smtp_security_ind,
				rf_db_smtp_username,
				rf_db_smtp_password,
				rf_db_smtp_hostname_override,
				rf_db_time_zone,
				rf_db_cache_stock_yn,
				rf_db_inactive_yn
			FROM
				rf_database
			WHERE
				rf_db_code = '$record'
		"
		,1
	);

	compareAuditValue("rf_db_code", "DB code", $databaseValues, $_POST, $miscAuditTrail, $targetDbCode);
	compareAuditValue("rf_db_description", "DB description", $databaseValues, $_POST, $miscAuditTrail, $targetDbCode);
	compareAuditValue("rf_db_smtp_address", "SMTP address", $databaseValues, $_POST, $miscAuditTrail, $targetDbCode);
	compareAuditValue("rf_db_smtp_port", "SMTP port", $databaseValues, $_POST, $miscAuditTrail, $targetDbCode);
	compareAuditValue("rf_db_smtp_auth_ind", "SMTP auth indicator", $databaseValues, $_POST, $miscAuditTrail, $targetDbCode);
	compareAuditValue("rf_db_smtp_security_ind", "SMTP security indicator", $databaseValues, $_POST, $miscAuditTrail, $targetDbCode);
	compareAuditValue("rf_db_smtp_username", "SMTP username", $databaseValues, $_POST, $miscAuditTrail, $targetDbCode);
	compareAuditValue("rf_db_smtp_password", "SMTP password", $databaseValues, $_POST, $miscAuditTrail, $targetDbCode);
	compareAuditValue("rf_db_smtp_hostname_override", "SMTP hostname override", $databaseValues, $_POST, $miscAuditTrail, $targetDbCode);
	compareAuditValue("rf_db_time_zone", "Timezone", $databaseValues, $_POST, $miscAuditTrail, $targetDbCode);
	compareAuditValue("rf_db_cache_stock_yn", "Cache active", $databaseValues, $_POST, $miscAuditTrail, $targetDbCode, true);
	compareAuditValue("rf_db_inactive_yn", "Inactive", $databaseValues, $_POST, $miscAuditTrail, $targetDbCode, true);

	$adMiscId = $miscAuditTrail->save("Environment Setup (Edit)");
}

$hidelist = array();
$GLOBALS[$form]->Hide($hidelist);

$GLOBALS['temp']['rf_db_cache_stock_overlib'] = "";
$disablelist = array();
if(!$isAdmin) {
	$disablelist[] = ["form315_rf_database_rf_db_cache_stock_yn", "form315_rf_database_rf_db_inactive_yn"];
	$GLOBALS['temp']['rf_db_cache_stock_overlib'] = "onmouseout=\"nd();\" onmouseover=\"overlib('Only the ResRequest administrator may change this setting.',WIDTH,320);\"";
	$GLOBALS['temp']['cacheCheckbox'] = "collapse";
	$GLOBALS['temp']['environmentCheckbox'] = "collapse";

	if ($GLOBALS[$form.'_rf_database_rf_db_cache_stock_yn']->Value == 1) {
		$GLOBALS['temp']['cacheMessage'] = "<span>Cache is enabled</span>";
	} else {
		$GLOBALS['temp']['cacheMessage'] = "<span>Cache is disabled</span>";
	}

	if ($GLOBALS[$form.'_rf_database_rf_db_inactive_yn']->Value == 1) {
		$GLOBALS['temp']['environmentMessage'] = "<span style=\"color: red\">Environment is inactive</span>";
	} else {
		$GLOBALS['temp']['environmentMessage'] = "<span>Environment is active</span>";
	}
	
}
$GLOBALS[$form]->Disable($disablelist);

$table = $GLOBALS[$form]->TableList[0];

$GLOBALS[$form.'_rf_database_rf_db_code']->TabIndex = 1;
$GLOBALS[$form.'_rf_database_rf_db_code']->Size = 10;
$GLOBALS[$form.'_rf_database_rf_db_code']->Width = 70;
$GLOBALS[$form.'_rf_database_rf_db_code']->IsDisabled = "1";

$GLOBALS[$form.'_rf_database_rf_db_description']->Width = 180;
$GLOBALS[$form.'_rf_database_rf_db_description']->IsDisabled = "1";

$zones = array(":|:");
foreach(timezone_identifiers_list() as $zone) {
	$zones[] = $zone . ":|:". $zone;
}
$GLOBALS[$form.'_rf_database_rf_db_time_zone']->Select = $zones;
$GLOBALS[$form.'_rf_database_rf_db_time_zone']->Class = 3;
$GLOBALS[$form.'_rf_database_rf_db_time_zone']->Width = 180;


$GLOBALS[$form.'_rf_database_rf_db_cache_stock_yn']->Class = 9;
$GLOBALS[$form.'_rf_database_rf_db_cache_stock_yn']->onChange = "changeClearStock();";

$GLOBALS[$form.'_rf_database_rf_db_inactive_yn']->Class = 9;

$property_env_type_ind = $lDB->get("
	SELECT 
		rf_database.rf_db_env_type_ind 
	FROM 
		rf_database WHERE rf_db_code = '" . $lDB->escape($GLOBALS[$form.'_rf_database_rf_db_code']->Value) . "'
",4);
$GLOBALS['temp']['isProperty'] = $property_env_type_ind == "2" ? "disabled" : "";

// BUG #5485 : Environment Email Server Details -------------------------------
$GLOBALS[$form.'_rf_database_rf_db_smtp_address']->Width = 180;
$GLOBALS[$form.'_rf_database_rf_db_smtp_port']->Width = 114;

$GLOBALS[$form.'_rf_database_rf_db_smtp_auth_ind']->Select(array("0:|:None","1:|:Username & Password"));
$GLOBALS[$form.'_rf_database_rf_db_smtp_auth_ind']->Class = 3;
$GLOBALS[$form.'_rf_database_rf_db_smtp_auth_ind']->onChange = "changeAuth();";
$GLOBALS[$form.'_rf_database_rf_db_smtp_auth_ind']->Width = 180;


$GLOBALS[$form.'_rf_database_rf_db_smtp_username']->Width = 180;


$GLOBALS[$form.'_rf_database_rf_db_smtp_security_ind']->Select(array("0:|:None","1:|:STARTTLS","2:|:SSL/TLS"));
$GLOBALS[$form.'_rf_database_rf_db_smtp_security_ind']->Class = 3;
$GLOBALS[$form.'_rf_database_rf_db_smtp_security_ind']->onChange = "changeSecurity();";
$GLOBALS[$form.'_rf_database_rf_db_smtp_security_ind']->Width = 180;

$GLOBALS[$form.'_rf_database_rf_db_smtp_hostname_override']->Width = 180;

// Don't allow users to update the web SMTP details
$GLOBALS['temp']['smtpDisable'] = 'true';
if (
	strlen($_SERVER['argv'][1]) > 0 &&
	$_SERVER['argv'][1][0] != 'W' &&
	($action == "2" || $action == "3") &&
	$property_env_type_ind != 4
) {	
	$GLOBALS['temp']['smtpDisable'] = 'false';
}

/* Bank / Cash point dropdown setup */
$bankList = $GLOBALS['lDB']->get("
	SELECT 
		rf_bank_id 
	FROM 
		rf_bank_env 
	WHERE 
		rf_database_id = '" . $recordId . "'
",3);

$newBankList = $GLOBALS['lDB']->get("
	SELECT
		rf_bank.rf_bank_ix,
		rf_bank.rf_bank_acc_name,
		rf_bank.rf_bank_name,
		rf_currency.rf_currency_symbol
	FROM
		rf_bank
		INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rf_bank.rf_currency_id
	WHERE
		rf_bank.rf_bank_ix NOT IN ('" . join("','",$bankList) . "')
		AND rf_bank.rf_bank_sys_code <> 7
		AND rf_bank.rf_bank_inactive_yn = 0
",2);

$bankDropDown = "<option value=\"0\">Select a bank / cash point to add</option>";

foreach($newBankList as $item) {

	if ($item['rf_bank_name'] != ""){
		$bank_name = " - ".$item['rf_bank_name'];
	} else {
		$bank_name = "";
	}
	$bankDropDown .= "<option value=\"" . $item['rf_bank_ix'] . "\">" . $item['rf_bank_acc_name'] .$bank_name." (" . $item['rf_currency_symbol'] . ")</option>";
}

$GLOBALS['temp']['bankDropDown'] = $bankDropDown;

/* Bank / Cash point listing */
$bankHTML = "
<tr>
	<td class=\"br\" height=\"20\" style=\"padding:2;\">!rf_bank_acc_name!!bank_name!</td>
	<td class=\"br\" align=\"center\">!rf_currency_symbol!</td>
	<td class=\"br\" align=\"center\"><input type=\"radio\" name=\"bankDefault\" id=\"!rf_bank_env_ix!\" !bankDefaultChecked!></td>
	<td align=\"center\">
		<button type=\"button\" class=\"button\" style=\"width:22px; height: 20px;\" onclick=\"processDeleteBank('!rf_bank_env_ix!');\">
			<img src=\"/resource/Resrequest/Application/public/img/icon_delete_16.gif\" />
		</button>
	</td>
<!--	<input type=\"button\" class=\"button bDelete\" style=\"width:16; height:17;\" onclick=\"processDeleteBank('!rf_bank_env_ix!');\"></td>-->
</tr>
";

$bankList = $GLOBALS['lDB']->get("
	SELECT
		rf_bank_env.rf_bank_env_ix,
		rf_bank.rf_bank_acc_name,
		rf_bank.rf_bank_name,
		rf_currency.rf_currency_symbol,
		rf_bank_env.rf_bank_env_default_yn
	FROM
		rf_bank_env
		INNER JOIN rf_bank ON rf_bank.rf_bank_ix = rf_bank_env.rf_bank_id
		INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rf_bank.rf_currency_id
	WHERE
		rf_bank_env.rf_database_id = '$recordId'
",2);

$bankRows = "";

foreach($bankList as $item) {
	$item['bankDefaultChecked'] = "";
	if($item['rf_bank_env_default_yn'] == "1") {
		$item['bankDefaultChecked'] = "checked";
	}
	if ($item['rf_bank_name'] != ""){
		$item['bank_name'] = " - ".$item['rf_bank_name'];
	} else {
		$item['bank_name'] = "";
	}	
	$bankRows .= showpage($item,$bankHTML);
}

if(sizeof($bankList) < 1) {
	$bankRows = "<tr><td colspan=\"4\" align=\"center\"><span class=\"txti\">No banks or cash points</span></td></tr>";
}

$GLOBALS['temp']['bankRows'] = $bankRows;


$propertyDropDownList = $lDB->get("
	SELECT
		pr_business.pr_business_id,
		pr_persona.pr_name_last
	FROM
		pr_business
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
		LEFT JOIN rf_db_business ON rf_db_business.pr_business_id = pr_business.pr_business_id
	WHERE
		pr_business.pr_bus_property_yn = '1'
		AND rf_db_business.rf_db_business_ix IS NULL
	ORDER BY
		pr_business.pr_business_sequence
",6);

$propertyDropDown = "
	<option value=\"0\">Select a property to add</option>
";

foreach($propertyDropDownList  as $property) {
	$propertyDropDown .= "
		<option value=\"" . $property['pr_business_id'] . "\">" . $property['pr_name_last'] . "</option>
	";
}

$GLOBALS['temp']['propertyDropDown'] = $propertyDropDown;

$propertyHTML = "
	<tr>
		<td>!pr_name_last!</td>
		<td align=\"center\">
			<button type=\"button\" class=\"button\" style=\"width:22px; height: 20px;\" onclick=\"processDeleteProperty('!rf_db_business_ix!');\">
				<img src=\"/resource/Resrequest/Application/public/img/icon_delete_16.gif\" />
			</button>
		</td>
	</tr>
";

$propertyList = $lDB->get("
	SELECT
		rf_db_business.rf_db_business_ix,
		rf_db_business.pr_business_id,
		pr_persona.pr_name_last
	FROM
		rf_db_business
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rf_db_business.pr_business_id
	WHERE
		rf_db_business.rf_db_code = '" . $lDB->escape($GLOBALS[$form.'_rf_database_rf_db_code']->Value) . "'
",6);
$propertyRows = "";

foreach($propertyList as $property) {
	$propertyRows .= showpage($property, $propertyHTML);
}

if(sizeof($propertyList) < 1) {
	$propertyRows = "<tr><td colspan=\"2\" align=\"center\"><span class=\"txti\">No properties linked</span></td></tr>";
}
$GLOBALS['temp']['propertyRows'] = $propertyRows;

$newr 	= 745;
$edit 	= $newr + 2;
$view 	= $newr - 1;
$dele 	= $newr + 4;
$sedit 	= $edit + 1;
$snewr 	= $newr + 1;

// Start Access Control Toolbar Setup
$pgJOBS = array();
$pgJOBS['view'] = "0";

if (checkJob($view)) {
	$pgJOBS['view'] = "1";
}

$pgJOBS['add'] = "0";

if (checkJob($newr)) {
	$pgJOBS['add'] = "0";
}

$pgJOBS['edit'] = "0";

if (checkJob($edit)) {
	$pgJOBS['edit'] = "1";
}

$pgJOBS['del'] 	= "0";
$pgJOBS['save'] = "0";

if ($action == "2" || $action == "3") {
	$pgJOBS['save'] = "1";
}

if ($action == "2" || $action == "4" || $record == null) {
	$pgJOBS['edit'] = "0";
}

if ($action == "3") {
	$pgJOBS['edit'] = $pgJOBS['view'];
	if (checkJob($dele)) {
  	$pgJOBS['del'] = "0";
	}
}

$GLOBALS['temp']['pgJobs'] = "<input type=\"hidden\" id=\"pgJobNew\" value=\"" . $pgJOBS['add'] . "\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobEdit\" value=\"" . $pgJOBS['edit'] . "\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobDelete\" value=\"" . $pgJOBS['del'] . "\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSave\" value=\"" . $pgJOBS['save'] . "\">\n";
// End Access Control Toolbar Setup

$GLOBALS['temp']['new_record'] = "reservation.php?" . $newr;

$GLOBALS['temp']['showBank'] = "collapse";
$GLOBALS['temp']['showProperty'] = "collapse";

switch ($action) {
	case (0) : // List Records
  	break;
	case (1) : // Display Record
		$GLOBALS['mode'] = "display";
		$GLOBALS['temp']['edit_view'] = "reservation.php?" . $edit . "+" . $record;
		$GLOBALS['temp']['save_record'] = "#";
		$GLOBALS['temp']['del_record'] = "#";
		break;
	case (2) : // Add Record
	  	$GLOBALS[$form]->Arguments = (string) $snewr;
	    $GLOBALS['temp']['edit_view'] = "#";
    	$GLOBALS['temp']['save_record'] = "document.forms[0].submit()";
	    $GLOBALS['temp']['del_record'] = "#";
    	$GLOBALS['mode'] = "view";
	    break;
	case (3) : // Edit Record
	  	$GLOBALS[$form]->Arguments = (string) $sedit . "+" . $record;
    	$GLOBALS['mode'] = "edit";
	    $GLOBALS['temp']['edit_view'] = "reservation.php?" . $view . "+" . $record;
    	$GLOBALS['temp']['save_record'] = "document.forms[0].submit()";
	    $GLOBALS['temp']['del_record'] = "reservation.php?" . $dele . "+" . $record;
    	$GLOBALS['temp']['showBank'] = "";
    	$GLOBALS['temp']['showProperty'] = "";
	    break;
}

$GLOBALS['temp']['new_record'] .= "++".$_SERVER['argv'][2]."+".$_SERVER['argv'][3];

$maxInvNumber = $GLOBALS['lDB']->get("
	SELECT
		MAX(fn_invoice_id)
	FROM
		fn_invoice
	WHERE
		fn_invoice.fn_invoice_db = '" . $GLOBALS[$form.'_rf_database_rf_db_code']->Value . "'
",4);
$GLOBALS['temp']['maxInvNumber'] = $maxInvNumber;

if($pmode == "1") {
	// Invoice number check
}	
