<?php

/*
 * $Id: init.form316.php,v 1.11 2011-05-15 17:43:21 light Exp $
 *
 * $Log: init.form316.php,v $
 * Revision 1.11  2011-05-15 17:43:21  light
 * Bug #7581 - Mail update and enhancements
 *
 * Revision 1.10  2007-12-19 09:18:24  light
 * Bug #5871 - Financial Interface
 *
 * Revision 1.9  2006-11-28 13:28:57  gregs
 * Bug #5485 - Server SMTP details. Added fix to utilise form class.
 *
 */

/** 
 * init.form316.php - The Environment Setup Code Table (Listing)
 * Job: 744, 745, 746, 747, 748, 749
 * Function: 87 (Environment Setup)
 */

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"","");
}

if(checkjob("747") == true) {
	$selectjob = "747";
} else {
	$selectjob = "744";
}

$GLOBALS['temp']['selectjob'] = $selectjob;
	
$list = $GLOBALS['lDB']->get("
	SELECT
		rf_database.rf_db_code,
		rf_database.rf_db_description,
		rf_bank.rf_bank_acc_name,
		rf_database.rf_db_time_zone,
		rf_database.rf_db_cache_stock_yn,
		rf_database.rf_db_inactive_yn,
		rf_database.rf_db_env_type_web_yn
	FROM
		rf_database
		LEFT JOIN rf_bank_env ON rf_bank_env.rf_database_id = rf_database.rf_database_id 
			AND rf_bank_env.rf_bank_env_default_yn = '1'
		LEFT JOIN rf_bank ON rf_bank.rf_bank_ix = rf_bank_env.rf_bank_id
	ORDER BY 
		rf_database.rf_db_code		
",2);
$rowHTML = join("",file(__DIR__ . "/../../../public/html/code_env_setup_rows.htm"));
$rows = "";
foreach($list as $item) {
	if(trim($item['rf_bank_acc_name']) == "") {
		$item['rf_bank_acc_name'] = "&nbsp;";
	}

	if( (trim($item['rf_db_time_zone']) == "") || !in_array($item['rf_db_time_zone'],timezone_identifiers_list())) {
		$item['rf_db_time_zone'] = "&nbsp;";
	}

	if($item['rf_db_cache_stock_yn'] == "1") {
		$item['rf_db_cache_stock_yn_fmt'] = "x";
	} else {
		$item['rf_db_cache_stock_yn_fmt'] = "&nbsp;";
	}

	if($item['rf_db_inactive_yn'] == "1") {
		$item['rf_db_inactive_yn'] = "x";
	} else {
		$item['rf_db_inactive_yn'] = "&nbsp;";
	}

	$item['rf_db_env_type_web_yn'] = $item['rf_db_env_type_web_yn'] == "1" ? "x" : "&nbsp;";

	$rows .= showpage($item,$rowHTML);
}

if($rows == "") {
	$rows = "
		<tr class=\"txt'\"height=\"18\">
			<td height=\"18\" colspan=\"5\" align=\"center\">&nbsp;&nbsp;There are no environments setup</td>
		</tr>
	";			
}

$GLOBALS['temp']['numrows'] = sizeof($list);
$GLOBALS['temp']['rows'] = $rows;
