<?php

/**
 * init.form317.php - Bednights report
 * Job: 246
 * Function: 53
*/

if(isset($_POST['url']) && $_POST['url'] != "") {
   $_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
   $_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$pf_object_id = db_pf_object_by_name("bed_night_report");
processProfileAction($pf_object_id,$profileFields);

$pf_option_id = applyProfile($pf_object_id,$profileFields);
$title = db_pf_option_get_title($pf_option_id);
if(trim($title) == "") {
	$title = "Bed Night Report";
}
$GLOBALS['temp']['title'] = $title;

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id,$pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_bed_nights.htm");
}

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));
$GLOBALS['temp']['genDate'] = chng_date(date("Y-m-d"),"-")." ".date("H:i:s");

$_SERVER['argv'] = array_pad($_SERVER['argv'],25,"");

if(trim($_SERVER['argv'][1]) == "" || trim($_SERVER['argv'][2]) == "") {
	$fromDate = date("Y-m") . "-01";
	$toDate = date("Y-m-d",mktime(0,0,0,date("m")+4,0,date("Y")));

	$fromYear = date("Y");
	$toYear = date("Y",mktime(0,0,0,date("m")+4,0,date("Y")));
	$fromMonth = date("M");
	$toMonth = date("M",mktime(0,0,0,date("m")+4,0,date("Y")));

	$GLOBALS['temp']['fromM'] = date("m");
	$GLOBALS['temp']['toM'] = date("m",mktime(0,0,0,date("m")+4,0,date("Y")));
	$GLOBALS['temp']['fromY'] = date("Y");
	$GLOBALS['temp']['toY'] = date("Y",mktime(0,0,0,date("m")+4,0,date("Y")));
	
} else {
	list($fromYear,$fromMonth) = explode("-",$_SERVER['argv'][1]);
	list($toYear,$toMonth) = explode("-",$_SERVER['argv'][2]);

	$fromDate = date("Y-m-d",mktime(0,0,0,$fromMonth,1,$fromYear));
	$toDate = date("Y-m-d",mktime(0,0,0,$toMonth+1,0,$toYear));
	
	$GLOBALS['temp']['fromM'] = $fromMonth;
	$GLOBALS['temp']['toM'] = $toMonth;
	$GLOBALS['temp']['fromY'] = $fromYear;
	$GLOBALS['temp']['toY'] = $toYear;
}

$GLOBALS['temp']['fromDateFormat'] = chng_date($fromDate,"-");
$GLOBALS['temp']['toDateFormat'] = chng_date($toDate,"-");

// Create an array of each month's start/end date
$currDate = $fromDate;
$dateArray = array();
while($currDate < $toDate) {
	list($currYear, $currMonth, $currDay) = explode("-",$currDate);
	array_push($dateArray,array(
		"start"=>date("Y-m-d",mktime(0,0,0,$currMonth,1,$currYear)),
		"end"=>date("Y-m-d",mktime(0,0,0,$currMonth+1,0,$currYear))
	));

	$currDate = date("Y-m-d",mktime(0,0,0,$currMonth+1,1,$currYear));
}

// BUG #5484 : START ----------------------------------------------------------
// Reports to hide filters by default
$filterStatus = $_SERVER['argv'][22];
$showHideButtonText = $_SERVER['argv'][23];

$GLOBALS['temp']['filterStatus'] = urldecode($filterStatus);
$GLOBALS['temp']['showHideButtonText'] = $showHideButtonText;

if($filterStatus == "") {
	$GLOBALS['temp']['filterStatus'] = "";
}

if($showHideButtonText == "") {
	$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
}

if($_SERVER['argc'] > 1) {
	if($filterStatus == "") {
		$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";
		$GLOBALS['temp']['showHideButtonText'] = ">> Show Filters";
	}
}
// BUG #5484: END -------------------------------------------------------------

if($_SERVER['argc'] < 2 && trim($_SERVER['argv'][4]) == "") {
	$_SERVER['argv'][4] = join(":",$lDB->get("
		SELECT
			ac_accomm_type.ac_accomm_type_ix
		FROM
			ac_accomm_type
			INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		WHERE
			ac_accomm_type.ac_accomm_type_inactive_yn = '0'
			AND pr_business.pr_bus_inactive_yn = '0'
	",3));
}


$accommACL= $lDB->get("
	SELECT DISTINCT
		ac_accomm_type.ac_accomm_type_ix
	FROM
		sc_accomm, ac_accomm_type
	WHERE
		sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
		AND sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
",3);
$accommFilter = useFilter("accomm",$_SERVER['argv'][4],"SELECT CONCAT(pr_business.pr_bus_name_short,CONCAT(' - ',ac_accomm_type.ac_accomm_desc)) FROM ac_accomm_type INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id WHERE ac_accomm_type_ix =","rv_reservation_item.ac_accomm_type_id",$accommACL,false,false);

$agentACL = false;
if($userStatusId < 2) {
   $agentACL = array($calAgentId);
}
$agentFilter = useFilter("agent",$_SERVER['argv'][6],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_agent_id",$agentACL,"Direct booking","0");
$agentCountryFilter = useFilter("agentCountry",$_SERVER['argv'][7],"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =","pr_ag.pr_corr_country_id",false,false,false);
$agentSelect = $_SERVER['argv'][5];
$GLOBALS['temp']['agentNameRadioChecked'] = "checked";
$GLOBALS['temp']['agentCountryRadioChecked'] = "";
if($agentSelect == "country") {
   $GLOBALS['temp']['agentNameRadioChecked'] = "";
   $GLOBALS['temp']['agentCountryRadioChecked'] = "checked";
   $agentWhere = $agentCountryFilter['where'];
} else {
   $agentWhere = $agentFilter['where'];
}

$statusACL = $lDB->get("
         SELECT
            rf_reservation_status_id
         FROM
            rf_reservation_status
         WHERE
		 	rf_reservation_status_id <> 25
			AND rf_reservation_status_id <> 97
",3);
// Set defaults
if($_SERVER['argc'] < 2 && trim($_SERVER['argv'][8]) == "" &&  $pf_option_id == "") {
	$_SERVER['argv'][8] = "30";
}

$statusFilter = useFilter("statusAlloc",$_SERVER['argv'][8],"SELECT rf_reservation_status.rf_reservation_status_desc FROM rf_reservation_status WHERE rf_reservation_status_id =","rv_reservation.rf_reservation_status_id",$statusACL,false,false);			

$excludeExpired = $_SERVER['argv'][24];
$GLOBALS['temp']['excludeExpiredChecked'] = "";
if($excludeExpired == "1") {
	$GLOBALS['temp']['excludeExpiredChecked'] = "checked";
	$statusFilter['where'] .= "
		AND (
			rv_reservation.rf_reservation_status_id != '20'
			OR (
				rv_reservation.rf_reservation_status_id = '20'
				AND rv_reservation.rv_provision_expiry_date >= '".date("Y-m-d")."'
			)
		)
	";
}


$consultantFilter = useFilter("consultant",$_SERVER['argv'][9],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_consultant_id",false,"No consultant","0");
$originatorFilter = useFilter("originator",$_SERVER['argv'][10],"SELECT pr_persona.pr_name_first,pr_persona.pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_origin_agent_id",false,"No originator","0");
$sourceFilter = useFilter("source",$_SERVER['argv'][11],"SELECT rf_source.rf_source_desc FROM rf_source WHERE rf_source_ix =","rv_reservation.rf_source_ix",false,"No source","0");
// 11 is nationality
$nationalityFilter = useFilter("nationality",$_SERVER['argv'][12],"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =","rv_reservation.rf_country_id",false,"No nationality","0");
$nationalityIds = explode(":",$nationalityFilter['ids']);
if(in_array("0",$nationalityIds)) {
	$nationalityFilter['where'] = "AND ( 1 ".$nationalityFilter['where']." OR rv_reservation.rf_country_id IS NULL )";
}
$rateFilter = useFilter("rate",$_SERVER['argv'][13],"SELECT rt_rate_type_desc FROM rt_rate_type WHERE rt_rate_type_ix=","rv_reservation_item.rt_rate_type_id",false,false,false);
if ($_SERVER['argv'][14] == "") {
	$_SERVER['argv'][14] = ":::";
}
list($rateOverride,$rateOverrideType,$rateOverrideAgentGranted,$rateOverrideAgentDenied) = explode(":",$_SERVER['argv'][14]);
$GLOBALS['temp']['rateOverrideChecked'] = "";
if(!empty($rateOverride)) {
	$GLOBALS['temp']['rateOverrideChecked'] = "checked";
}
$GLOBALS['temp']['rateOverrideExcludeResChecked'] = "";
$GLOBALS['temp']['rateOverrideIncludeResChecked'] = "";
$GLOBALS['temp']['rateOverrideExcludeItemChecked'] = "";
$GLOBALS['temp']['rateOverrideIncludeItemChecked'] = "";
switch($rateOverrideType) {
default:
case "excludeRes":
	$GLOBALS['temp']['rateOverrideExcludeResChecked'] = "checked";
	break;
case "includeRes":
	$GLOBALS['temp']['rateOverrideIncludeResChecked'] = "checked";
	break;
case "excludeItem":
	$GLOBALS['temp']['rateOverrideExcludeItemChecked'] = "checked";
	break;
case "includeItem":
	$GLOBALS['temp']['rateOverrideIncludeItemChecked'] = "checked";
	break;
}
if(empty($rateOverrideAgentGranted) && empty($rateOverrideAgentDenied)) {
	$rateOverrideAgentGranted = "1";
	$rateOverrideAgentDenied = "1";
}
$GLOBALS['temp']['rateOverrideAgentGrantedChecked'] = "";
if(!empty($rateOverrideAgentGranted)) {
	$GLOBALS['temp']['rateOverrideAgentGrantedChecked'] = "checked";
}
$GLOBALS['temp']['rateOverrideAgentDeniedChecked'] = "";
if(!empty($rateOverrideAgentDenied)) {
	$GLOBALS['temp']['rateOverrideAgentDeniedChecked'] = "checked";
}
if ($_SERVER['argv'][15] == "") {
	$_SERVER['argv'][15] = ":";
}
list($amountOverride,$amountOverrideType) = explode(":",$_SERVER['argv'][15]);
$GLOBALS['temp']['amountOverrideChecked'] = "";
if(!empty($amountOverride)) {
	$GLOBALS['temp']['amountOverrideChecked'] = "checked";
}
$GLOBALS['temp']['amountOverrideExcludeResChecked'] = "";
$GLOBALS['temp']['amountOverrideIncludeResChecked'] = "";
$GLOBALS['temp']['amountOverrideExcludeItemChecked'] = "";
$GLOBALS['temp']['amountOverrideIncludeItemChecked'] = "";
switch($amountOverrideType) {
default:
case "excludeRes":
	$GLOBALS['temp']['amountOverrideExcludeResChecked'] = "checked";
	break;
case "includeRes":
	$GLOBALS['temp']['amountOverrideIncludeResChecked'] = "checked";
	break;
case "excludeItem":
	$GLOBALS['temp']['amountOverrideExcludeItemChecked'] = "checked";
	break;
case "includeItem":
	$GLOBALS['temp']['amountOverrideIncludeItemChecked'] = "checked";
	break;
}

$showRevenueOption = $_SERVER['argv'][16];
$GLOBALS['temp']['showRevenueChecked'] = "";
$GLOBALS['temp']['revenueDivClass'] = "collapse printCollapse";
if($showRevenueOption == "1") {
	$GLOBALS['temp']['showRevenueChecked'] = " checked ";
	$GLOBALS['temp']['revenueDivClass'] = "";
}

$showRoomConfig = $_SERVER['argv'][17];
$GLOBALS['temp']['showRoomConfigChecked'] = " checked ";
if($showRoomConfig == "0") {
	$GLOBALS['temp']['showRoomConfigChecked'] = "";
}
$groupByOption = $_SERVER['argv'][18];
$sortBy = $_SERVER['argv'][19];
if($sortBy == "") {
	$sortBy = 1;
}
$GLOBALS['temp']['imgSort1Mode'] = "std"; #(desc, asc)
$GLOBALS['temp']['imgSort2Mode'] = "std"; #(desc, desc)
$GLOBALS['temp']['imgSort3Mode'] = "std"; #(desc, asc)
$GLOBALS['temp']['imgSort4Mode'] = "std"; #(desc, desc)
switch($sortBy) {
	case 1:
		$GLOBALS['temp']['imgSort1Mode'] = "down";
		break;
	case 2:
		$GLOBALS['temp']['imgSort2Mode'] = "down";
		break;
	case 3:
		$GLOBALS['temp']['imgSort3Mode'] = "down";
		break;
	case 4:
		$GLOBALS['temp']['imgSort4Mode'] = "down";
		break;		
}
$GLOBALS['temp']['sortBy'] = $sortBy;

$renderOption = $_SERVER['argv'][20];


if($renderOption == "2") {
   $pdfName = "$title from  " . chng_date($fromDate,"-") . " to " . chng_date($toDate,"-");
	$attachmentTable = "
		<table border=\"0\" cellspacing=\"0\" width=\"100%\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\"></td>
			<td id=\"attachmentLabel\" width=\"100%\">$pdfName.pdf</td>
		</tr>
		</table>
	";
   $newOptions = ($renderOption & ~3) + 3;
   $formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,20))."+$newOptions+".join("+",array_slice($_SERVER['argv'],21,3));

// echo $formAction."<BR>";

   $GLOBALS[$form]->FormHTML =   str_replace("!formAction!",$formAction,
               str_replace("!attachmentInfo!",$attachmentTable,
               str_replace("!attachmentName!",$pdfName.".pdf",
               str_replace("!hasAttachment!","expand",
               str_replace("!emailBody!","",
               str_replace("!emailSubject!",$pdfName,
               Join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));
   // get principal
   $principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
   $resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
   $principalInfo = getPersonaDetail($principalId);
   $resOfficeInfo = getPersonaDetail($resOfficeId);

   $addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
   $GLOBALS['temp']['princName'] = $principalInfo['name'];
   $GLOBALS['temp']['fax'] = $resOfficeInfo['fax'];
   $GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
   $userId = $_SESSION['userid'];
   $GLOBALS['temp']['emailFrom'] = $lDB->get("   SELECT
                           pr_persona.pr_email
                        FROM
                           pr_persona
                        WHERE
                           pr_persona.pr_persona_ix = '" . $userId . "'", 4);
   $GLOBALS['temp']['emailTo'] = "";
}


$GLOBALS['temp']['groupByAll'] = "";
$GLOBALS['temp']['groupByProperty'] = "";
$GLOBALS['temp']['groupByAccomm'] = "";
$GLOBALS['temp']['groupByAgent'] = "";
$GLOBALS['temp']['groupByContact'] = "";
$GLOBALS['temp']['groupBySource'] = "";
$GLOBALS['temp']['groupByOriginator'] = "";
$GLOBALS['temp']['groupByConsultant'] = "";
$GLOBALS['temp']['groupByNationality'] = "";
$GLOBALS['temp']['groupByStatus'] = "";
$groupByName = "";
$sqlGroupSelect = "";
$sqlGroupJoin = "";
$sqlOrderBy = "";

switch($groupByOption) {
case "all":
	$GLOBALS['temp']['groupByAll'] = "selected";
	$sqlOrderBy = "";
	$blankDesc = "All";
	$sqlGroupSelect = "
		'' as id,
		'All' as name
	";
	$GLOBALS['temp']['groupByName'] = "All";
	$groupByName = "All";
	break;
case "property":
	$GLOBALS['temp']['groupByProperty'] = "selected";
	$sqlOrderBy = "ORDER BY rv_reservation_item.pr_business_id";
	$sqlGroupSelect = "
			rv_reservation_item.pr_business_id as id,
			groupTable.pr_name_last as name
	";
	$sqlGroupJoin = "
		INNER JOIN pr_persona as groupTable ON groupTable.pr_persona_ix = rv_reservation_item.pr_business_id
	";
	$blankDesc = "Unknown Property";
	$GLOBALS['temp']['groupByName'] = "Property";
	$groupByName = "Property";
	break;
case "accomm":
	$GLOBALS['temp']['groupByAccomm'] = "selected";
	$sqlOrderBy = "ORDER BY rv_reservation_item.ac_accomm_type_id";
	$sqlGroupSelect = "
			rv_reservation_item.ac_accomm_type_id as id,
			CONCAT(groupTable2.pr_bus_name_short,CONCAT(' - ',groupTable.ac_accomm_desc)) as name
	";
	$sqlGroupJoin = "
		INNER JOIN ac_accomm_type as groupTable ON groupTable.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
		INNER JOIN pr_business as groupTable2 ON groupTable2.pr_business_id = groupTable.pr_business_id
	";
	$blankDesc = "Unknown Accommodation";
	$GLOBALS['temp']['groupByName'] = "Accommodation";
	$groupByName = "Accommodation";
	break;
case "agent":
	$GLOBALS['temp']['groupByAgent'] = "selected";
	$sqlOrderBy = "ORDER BY rv_reservation.rv_agent_id";
	$sqlGroupSelect = "
			rv_reservation.rv_agent_id as id,
			groupTable.pr_name_last as name
	";
	$sqlGroupJoin = "
		LEFT JOIN pr_persona as groupTable ON groupTable.pr_persona_ix = rv_reservation.rv_agent_id
	";
	$blankDesc = "Direct";
	$GLOBALS['temp']['groupByName'] = "Agent";
	$groupByName = "Agent";
	break;
case "contact":
	$GLOBALS['temp']['groupByContact'] = "selected";
	$sqlOrderBy = "ORDER BY rv_reservation.rv_corr_persona_id";
	$sqlGroupSelect = "
			rv_reservation.rv_corr_persona_id as id,
			groupTable.pr_name_first as name1,
			groupTable.pr_name_last as name2
	";
	$sqlGroupJoin = "
		LEFT JOIN pr_persona as groupTable ON groupTable.pr_persona_ix = rv_reservation.rv_corr_persona_id
	";
	$blankDesc = "No contact";
	$GLOBALS['temp']['groupByName'] = "Contact";
	$groupByName = "Contact";
	break;
case "source":
	$GLOBALS['temp']['groupBySource'] = "selected";
	$sqlOrderBy = "ORDER BY rv_reservation.rf_source_ix";
	$sqlGroupSelect = "
			rv_reservation.rf_source_ix as id,
			groupTable.rf_source_desc as name
	";
	$sqlGroupJoin = "
		LEFT JOIN rf_source as groupTable ON groupTable.rf_source_ix = rv_reservation.rf_source_ix
	";
	$blankDesc = "No Source";
	$GLOBALS['temp']['groupByName'] = "Source";
	$groupByName = "Source";
	break;
case "originator":
	$GLOBALS['temp']['groupByOriginator'] = "selected";
	$sqlOrderBy = "ORDER BY rv_reservation.rv_origin_agent_id";
	$sqlGroupSelect = "
			groupTable.pr_persona_ix as id,
			groupTable.pr_name_last as name
	";
	$sqlGroupJoin = "
		LEFT JOIN pr_persona as groupTable ON groupTable.pr_persona_ix = rv_reservation.rv_origin_agent_id
	";
	$blankDesc = "No Originator";
	$GLOBALS['temp']['groupByName'] = "Originator";
	$groupByName = "Originator";
	break;
case "consultant":
	$GLOBALS['temp']['groupByConsultant'] = "selected";
	$sqlOrderBy = "ORDER BY rv_reservation.rv_consultant_id";
	$sqlGroupSelect = "
			rv_reservation.rv_consultant_id as id,
			groupTable.pr_name_last as name
	";
	$sqlGroupJoin = "
		INNER JOIN pr_persona as groupTable ON groupTable.pr_persona_ix = rv_reservation.rv_consultant_id
	";
	$blankDesc = "No Consultant";
	$GLOBALS['temp']['groupByName'] = "Consultant";
	$groupByName = "Consultant";
	break;
case "nationality":
	$GLOBALS['temp']['groupByNationality'] = "selected";
	$sqlOrderBy = "ORDER BY rv_reservation.rf_country_id";
	$sqlGroupSelect = "
			groupTable.rf_country_ix as id,
			groupTable.rf_country_name as name
	";
	$sqlGroupJoin = "
		LEFT JOIN rf_country as groupTable ON groupTable.rf_country_ix = rv_reservation.rf_country_id
	";
	$blankDesc = "No Nationality";
	$GLOBALS['temp']['groupByName'] = "Nationality";
	$groupByName = "Nationality";
	break;
case "status":
	$GLOBALS['temp']['groupByStatus'] = "selected";
	$sqlOrderBy = "ORDER BY rv_reservation.rf_country_id";
	$sqlGroupSelect = "
			groupTable.rf_reservation_status_id as id,
			groupTable.rf_reservation_status_desc as name
	";
	$sqlGroupJoin = "
		INNER JOIN rf_reservation_status as groupTable ON groupTable.rf_reservation_status_id  = rv_reservation.rf_reservation_status_id 
	";
	$blankDesc = "No Status";
	$GLOBALS['temp']['groupByName'] = "Status";
	$groupByName = "Status";
	break;
case "resname":
	$GLOBALS['temp']['groupByResName'] = "selected";
	$sqlOrderBy = "ORDER BY rv_reservation.rv_res_name";
	$sqlGroupSelect = "
			rv_reservation.rv_reservation_ix as id,
			rv_reservation.rv_res_name as name
	";
	$sqlGroupJoin = "";
	$blankDesc = "No reservation name";
	$GLOBALS['temp']['groupByName'] = "Reservation name";
	$groupByName = "Reservation name";
	break;
case "resno":
	$GLOBALS['temp']['groupByResNo'] = "selected";
	$sqlOrderBy = "ORDER BY rv_reservation.rv_reservation_ix";
	$sqlGroupSelect = "
			rv_reservation.rv_reservation_ix as id,
			rv_reservation.rv_reservation_ix as name
	";
	$sqlGroupJoin = "";
	$blankDesc = "No res #";
	$GLOBALS['temp']['groupByName'] = "Res #";
	$groupByName = "Res #";
	break;	
default: // Use params for "all" as default to prevent mysql errors
	$GLOBALS['temp']['groupByAll'] = "selected";
	$sqlOrderBy = "";
	$blankDesc = "All";
	$sqlGroupSelect = "
		'' as id,
		'All' as name
	";
	$GLOBALS['temp']['groupByName'] = "All";
	$groupByName = "All";
	break;
	
}


$sqlFrom = "
	FROM
		rv_reservation_item
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
		INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rv_reservation.rv_invoice_currency_id
		LEFT JOIN pr_persona AS pr_ag ON pr_ag.pr_persona_ix = rv_reservation.rv_agent_id
";

$sqlWhere = "
	WHERE
		(
			(rv_reservation_item.rv_item_date_arrive >= '" . $fromDate . "' AND rv_reservation_item.rv_item_date_arrive <= '" . $toDate . "')
			OR (rv_reservation_item.rv_item_date_depart >= '" . $fromDate . "' AND rv_reservation_item.rv_item_date_depart <= '" . $toDate . "')
			OR (rv_reservation_item.rv_item_date_arrive < '" . $fromDate . "' AND rv_reservation_item.rv_item_date_depart > '" . $toDate . "')
		)
		" . $accommFilter['where'] . " 
		" . $agentWhere . " 
		" . $statusFilter['where'] . " 
		" . $consultantFilter['where'] . " 
		" . $originatorFilter['where'] . " 
		" . $sourceFilter['where'] . " 
		" . $nationalityFilter['where'] . " 
		" . $rateFilter['where']
;

if($groupByOption != "all") {
	$groupByList = $lDB->get("SELECT DISTINCT".$sqlGroupSelect.$sqlFrom.$sqlGroupJoin.$sqlWhere.$sqlOrderBy,2);
	if(is_array($groupByList)) {
		foreach($groupByList as $key=>$item) {
			if( (isset($item['name1']) && trim($item['name1']) != "") || (isset($item['name2']) && trim($item['name2']) ) != "") {
				$groupByList[$key]['name'] = trim($item['name1'] . " " . $item['name2']);
			}
		}
	}
} else {
	$groupByList = array(
		array("id"=>"0", "name"=>"All")
	);
}

if($_SERVER['argc'] > 1) {
	$GLOBALS['temp']['reportGenerated'] = "";

	$accommList = $lDB->get("
		SELECT
			DISTINCT
			ac_accomm_type.ac_accomm_type_ix
		FROM
			ac_accomm_type
		WHERE
			1
			".str_replace('ac_accomm_type_id','ac_accomm_type_ix',str_replace('rv_reservation_item','ac_accomm_type',$accommFilter['where']))."
	",3);

	$potentialArray = $dateArray;
	foreach($potentialArray as $potentialKey=>$potentialItem) {
		$monthDays = dateSubtract($potentialItem['end'],$potentialItem['start'])+1;
		$roomArray = $lDB->get("
			SELECT
				ac_accomm_room.ac_accomm_room_ix,
				ac_accomm_type.ac_accomm_type_ix,
				ac_accomm_room.ac_accomm_room_inactive_yn,
				ac_accomm_type.ac_accomm_type_inactive_yn,
				ac_accomm_room.ac_accomm_room_inactive_date,
				ac_accomm_type.ac_accomm_type_inactive_date,
				ac_accomm_type.ac_accomm_capacity,
				ac_accomm_room.ac_accomm_room_create_date
			FROM
				ac_accomm_room
				INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
			WHERE
				ac_accomm_type.ac_accomm_type_ix IN ('" . join("','",$accommList) . "')
				AND (
					(
						ac_accomm_room.ac_accomm_room_inactive_yn = '0'
						AND ac_accomm_type.ac_accomm_type_inactive_yn = '0'
					) OR (
						ac_accomm_room.ac_accomm_room_inactive_date > '" . $potentialItem['start'] . "'
						AND ac_accomm_room.ac_accomm_room_inactive_yn = '1'
						AND ac_accomm_type.ac_accomm_type_inactive_yn = '0'
					) OR (
						ac_accomm_type.ac_accomm_type_inactive_date > '" . $potentialItem['start'] . "'
						AND ac_accomm_type.ac_accomm_type_inactive_yn = '1'
						AND ac_accomm_room.ac_accomm_room_inactive_yn = '0'
					) OR (
						ac_accomm_room.ac_accomm_room_inactive_date > '" . $potentialItem['start'] . "'
						AND ac_accomm_type.ac_accomm_type_inactive_date > '" . $potentialItem['start'] . "'
						AND ac_accomm_room.ac_accomm_room_inactive_yn = '1'
						AND ac_accomm_type.ac_accomm_type_inactive_yn = '1'						
					)
				)
		",2);
		$roomCount = 0;
		$accommBedNight = 0;
		foreach($roomArray as $roomItem) {
			$startDate = $potentialItem['start'];
			$endDate = $potentialItem['end'];
			$addFirst = 1;
			if($roomItem['ac_accomm_room_create_date'] > $potentialItem['start']) {
				$startDate = $roomItem['ac_accomm_room_create_date'];
			}
			if($roomItem['ac_accomm_room_inactive_yn'] == "1") {
				$endDate = $roomItem['ac_accomm_room_inactive_date'];
				$addFirst = 0;
			}
			if($roomItem['ac_accomm_type_inactive_yn'] == "1") {
				$endDate = $roomItem['ac_accomm_type_inactive_date'];
				$addFirst = 0;
			}
			if($endDate > $potentialItem['end']) {
				$endDate = $potentialItem['end'];
				$addFirst = 1;
			}
			if($endDate < $startDate) { continue; }
			$roomCount += dateSubtract($endDate,$startDate)+$addFirst;
			$accommBedNight += $roomItem['ac_accomm_capacity'] * (dateSubtract($endDate,$startDate)+$addFirst);
		}
		$potentialArray[$potentialKey]['roomCount'] = $roomCount;
		$potentialArray[$potentialKey]['accommBedNight'] = $accommBedNight;

		$blockCount = 0;
		$blockBedNight = 0;
		// Find blocked rooms for each day.
		list($year, $month, $day) = explode("-",$potentialItem['start']);
		for($dayCount = 1; $dayCount <= $monthDays; $dayCount++) {
			$currDate = date("Y-m-d",mktime(0,0,0,$month,$dayCount,$year));
			$blockArray = $lDB->get("
				SELECT
					DISTINCT ac_accomm_room_block.ac_accomm_room_id,
					ac_accomm_type.ac_accomm_capacity
				FROM
					ac_accomm_block
					INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_block.ac_accomm_type_id
					INNER JOIN ac_accomm_room_block ON ac_accomm_room_block.ac_accomm_block_id = ac_accomm_block.ac_accomm_block_ix
					INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = ac_accomm_room_block.ac_accomm_room_id
				WHERE
					ac_accomm_type.ac_accomm_type_ix IN ('".join("','",$accommList)."')		
					AND ac_accomm_block.ac_start_date <= '" . $currDate . "'
					AND ac_accomm_block.ac_end_date > '" . $currDate . "'
					AND (
						(
							ac_accomm_room.ac_accomm_room_inactive_yn = '0'
							AND ac_accomm_type.ac_accomm_type_inactive_yn = '0'
							AND ac_accomm_room.ac_accomm_room_create_date <= '" . $currDate . "'
						) OR (
							ac_accomm_room.ac_accomm_room_inactive_date > '" . $currDate . "'
							AND ac_accomm_room.ac_accomm_room_inactive_yn = '1'
							AND ac_accomm_type.ac_accomm_type_inactive_yn = '0'
							AND ac_accomm_room.ac_accomm_room_create_date <= '" . $currDate . "'
						) OR (
							ac_accomm_type.ac_accomm_type_inactive_date > '" . $currDate . "'
							AND ac_accomm_type.ac_accomm_type_inactive_yn = '1'
							AND ac_accomm_room.ac_accomm_room_inactive_yn = '0'
							AND ac_accomm_room.ac_accomm_room_create_date <= '" . $currDate . "'
						) OR (
							ac_accomm_room.ac_accomm_room_inactive_date > '" . $currDate . "'
							AND ac_accomm_type.ac_accomm_type_inactive_date > '" . $currDate . "'
							AND ac_accomm_room.ac_accomm_room_inactive_yn = '1'
							AND ac_accomm_type.ac_accomm_type_inactive_yn = '1'
							AND ac_accomm_room.ac_accomm_room_create_date <= '" . $currDate . "'
						)
				)
			",2);
			foreach($blockArray as $blockItem) {
				$blockCount += 1;
				$blockBedNight += $blockItem['ac_accomm_capacity'];
			}
		}
		$potentialArray[$potentialKey]['blockCount'] = $blockCount;
		$potentialArray[$potentialKey]['blockBedNight'] = $blockBedNight;

		$potentialArray[$potentialKey]['potentialBedNight'] = $potentialArray[$potentialKey]['accommBedNight'] - $potentialArray[$potentialKey]['blockBedNight'];
	}

	$roomCountTotal = 0;
	$accommBedNightTotal = 0;
	$blockCountTotal = 0;
	$blockBedNightTotal = 0;
	$potentialBedNightTotal = 0;
	foreach($potentialArray as $potentialKey=>$potentialItem) {
		$roomCountTotal += $potentialItem['roomCount'];
		$accommBedNightTotal += $potentialItem['accommBedNight'];
		$blockCountTotal += $potentialItem['blockCount'];
		$blockBedNightTotal += $potentialItem['blockBedNight'];
		$potentialBedNightTotal += $potentialItem['potentialBedNight'];
	}


	function reservationHasRateOverride($rv_reservation_id) {
		global $lDB;

		$rt_rate_type_id = $lDB->get("SELECT rt_rate_type_id FROM rv_reservation WHERE rv_reservation_ix = '$rv_reservation_id'",4);

		$count = $lDB->get("
			SELECT
				COUNT(*)
			FROM
				rv_reservation_item
			WHERE
				rv_reservation_item.rt_rate_type_id != '$rt_rate_type_id'
				AND rv_reservation_item.rv_reservation_id = '$rv_reservation_id'
		",4);
		if($count > 0) {
			return true;
		} else {
			return false;
		}
	}

	function reservationItemHasRateOverride($rv_reservation_item_id) {
		global $lDB;

		$res_rate_type_id = $lDB->get("
			SELECT
				rv_reservation.rt_rate_type_id
			FROM 
				rv_reservation_item
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			WHERE
				rv_reservation_item.rv_reservation_item_ix = '$rv_reservation_item_id'
		",4);

		$item_rate_type_id = $lDB->get("
			SELECT
				rv_reservation_item.rt_rate_type_id
			FROM 
				rv_reservation_item
			WHERE
				rv_reservation_item.rv_reservation_item_ix = '$rv_reservation_item_id'
		",4);

		if($res_rate_type_id != $item_rate_type_id) {
			return true;
		} else {
			return false;
		}
	}
	
	function reservationHasOverride($rv_reservation_id) {
		global $lDB;
		$overrideComponentId = $lDB->get("SELECT rt_component_ix FROM rt_component WHERE ac_cmp_sys_code = '5'",4);

		$overrideCount = $lDB->get("
			SELECT
				COUNT(*)
			FROM
				rv_reservation
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
				INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
			WHERE
				rv_reservation.rv_reservation_ix = '" . $rv_reservation_id . "'
				AND (
					rv_res_item_comp.rt_component_id = '" . $overrideComponentId . "'
					OR rv_res_item_comp.rv_item_comp_var <> 0
				)
		",4);
		if($overrideCount > 0) {
			return true;
		} else {
			return false;
		}
	}

	function reservationItemHasOverride($rv_reservation_item_id) {
		global $lDB;
		$overrideComponentId = $lDB->get("SELECT rt_component_ix FROM rt_component WHERE ac_cmp_sys_code = '5'",4);

		$overrideCount = $lDB->get("
			SELECT
				COUNT(*)
			FROM
				rv_reservation_item
				INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
			WHERE
				rv_reservation_item.rv_reservation_item_ix = '" . $rv_reservation_item_id . "'
				AND (
					rv_res_item_comp.rt_component_id = '" . $overrideComponentId . "'
					OR rv_res_item_comp.rv_item_comp_var <> 0
				)
		",4);
		if($overrideCount > 0) {
			return true;
		} else {
			return false;
		}
	}

	function reservationHasAgentRateOverride($rv_reservation_id) {
		global $lDB;

		$pr_agent_id = $lDB->get("SELECT rv_agent_id FROM rv_reservation WHERE rv_reservation_ix = '$rv_reservation_id'",4);

		$check = $lDB->get("SELECT COUNT(*) FROM pr_agent WHERE pr_agent_id = '$pr_agent_id'",4);
		if($check > 0) {
			$allowRateList = $lDB->get("SELECT rt_rate_type_id FROM pr_agent_rate WHERE pr_agent_id = '$pr_agent_id'",3);
		} else {
			$allowRateList = $lDB->get("SELECT rf_default_rate_id FROM rf_default_rate",3);
		}
		
		$itemRateList = $lDB->get("SELECT DISTINCT rt_rate_type_id FROM rv_reservation_item WHERE rv_reservation_id = '$rv_reservation_id'",3);

		$check = array_diff($itemRateList,$allowRateList);
		if(sizeof($check) > 0) {
			return true;
		} else {
			return false;
		}
	}

	function reservationItemHasAgentRate($rv_reservation_id, $rv_reservation_item_id) {
		global $lDB;

		$pr_agent_id = $lDB->get("SELECT rv_agent_id FROM rv_reservation WHERE rv_reservation_ix = '$rv_reservation_id'",4);

		$check = $lDB->get("SELECT COUNT(*) FROM pr_agent WHERE pr_agent_id = '$pr_agent_id'",4);
		if($check > 0) {
			$allowRateList = $lDB->get("SELECT rt_rate_type_id FROM pr_agent_rate WHERE pr_agent_id = '$pr_agent_id'",3);
		} else {
			$allowRateList = $lDB->get("SELECT rf_default_rate_id FROM rf_default_rate",3);
		}
		
		$itemRateList = $lDB->get("SELECT DISTINCT rt_rate_type_id FROM rv_reservation_item WHERE rv_reservation_item_ix = '$rv_reservation_item_id'",3);

		$check = array_diff($itemRateList,$allowRateList);
		if(sizeof($check) > 0) {
			return true;
		} else {
			return false;
		}
	}

	$list = $lDB->get("
		SELECT
			rv_reservation.rv_reservation_ix,
			rv_reservation.rv_invoice_currency_id,
			rf_currency.rf_currency_symbol,
			rv_reservation_item.rv_reservation_item_ix,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			rv_reservation_item.rv_item_accomm_count,
			rv_reservation_item.rv_item_adult_count,
			rv_reservation_item.rv_item_child_count,
			rv_reservation_item.rv_item_amt_nett,
			rv_reservation_item.rv_item_amt_tax,
			$sqlGroupSelect
		$sqlFrom
		$sqlGroupJoin
		$sqlWhere
	",2);

	$bedNightGrid = array();
	$revenueGrid = array();
	foreach($list as $item) {
		if(!empty($rateOverride)) {
			switch($rateOverrideType) {
			default:
			case "excludeRes":
				$check = !reservationHasRateOverride($item['rv_reservation_ix']);
				break;
			case "includeRes":
				$check = reservationHasRateOverride($item['rv_reservation_ix']);
				break;
			case "excludeItem":
				$check = !reservationItemHasRateOverride($item['rv_reservation_item_ix']);
				break;
			case "includeItem":
				$check = reservationItemHasRateOverride($item['rv_reservation_item_ix']);
				break;
			}
			if(!$check) { continue; }

			if(empty($rateOverrideAgentGranted) || empty($rateOverrideAgentDenied)) {
				switch($rateOverrideType) {
				default:
				case "excludeRes":						
				case "includeRes":
					$check = reservationHasAgentRateOverride($item['rv_reservation_ix']);
					break;
				case "excludeItem":
				case "includeItem":
					$check = reservationItemHasAgentRate($item['rv_reservation_ix'], $item['rv_reservation_item_ix']);
					break;
				}
				if(!empty($rateOverrideAgentGranted)) { $check = !$check; }
				if(!$check) { continue; }
			}
		}
		
		if(!empty($amountOverride)) {
			switch($amountOverrideType) {
			default:
			case "excludeRes":
				$check = !reservationHasOverride($item['rv_reservation_ix']);
				break;
			case "includeRes":
				$check = reservationHasOverride($item['rv_reservation_ix']);
				break;
			case "excludeItem":
				$check = !reservationItemHasOverride($item['rv_reservation_item_ix']);
				break;
			case "includeItem":
				$check = reservationItemHasOverride($item['rv_reservation_item_ix']);
				break;
			}
			if(!$check) { continue; }
		}

		if(!isset($bedNightGrid[$item['id']]) || !is_array($bedNightGrid[$item['id']])) {
			$bedNightGrid[$item['id']] = $dateArray;
		}
		foreach($bedNightGrid[$item['id']] as $dateKey=>$dateItem) {
			$itemStart = $item['rv_item_date_arrive'];
			list($itemEndYear, $itemEndMonth, $itemEndDay) = explode("-",$item['rv_item_date_depart']);
			$itemEnd = date("Y-m-d",mktime(0,0,0,$itemEndMonth,$itemEndDay-1,$itemEndYear));
			if(
				($dateItem['start'] >= $itemStart && $dateItem['start'] <= $itemEnd)
				|| ($dateItem['end'] >= $itemStart && $dateItem['end'] <= $itemEnd)
				|| ($dateItem['start'] < $itemStart && $dateItem['end'] > $itemEnd) 
			) {
				// Find final start / ends
				if($dateItem['start'] > $item['rv_item_date_arrive']) {
					$finalStart = $dateItem['start'];
				} else {
					$finalStart = $item['rv_item_date_arrive'];
				}
				if($dateItem['end'] < $item['rv_item_date_depart']) {
					$finalEnd = $dateItem['end'];
				} else {
					$finalEnd = $itemEnd;
				}
				$fullDays = dateSubtract($item['rv_item_date_depart'],$item['rv_item_date_arrive']);
				$days = dateSubtract($finalEnd,$finalStart)+1;
				$accomm = $item['rv_item_accomm_count'];
				$adults = $item['rv_item_adult_count'];
				$children = $item['rv_item_child_count'];

				$adultBeds = $days * $accomm * $adults;
				$childBeds = $days * $accomm * $children;

				if (isset($bedNightGrid[$item['id']][$dateKey]['adultBeds'])) {
					$bedNightGrid[$item['id']][$dateKey]['adultBeds'] += $adultBeds;
				} else {
					$bedNightGrid[$item['id']][$dateKey]['adultBeds'] = $adultBeds;
				}
				
				if (isset($bedNightGrid[$item['id']][$dateKey]['childBeds'])) {
					$bedNightGrid[$item['id']][$dateKey]['childBeds'] += $childBeds;
				} else {
					$bedNightGrid[$item['id']][$dateKey]['childBeds'] = $childBeds;
				}
				

				// REVENUE!
				if(!isset($revenueGrid[$item['rf_currency_symbol']]) || !is_array($revenueGrid[$item['rf_currency_symbol']])) {
					$revenueGrid[$item['rf_currency_symbol']] = $dateArray;
				}
				if (isset($revenueGrid[$item['rf_currency_symbol']][$dateKey]['adultBeds'])) {
					$revenueGrid[$item['rf_currency_symbol']][$dateKey]['adultBeds'] += $adultBeds;
				} else {
					$revenueGrid[$item['rf_currency_symbol']][$dateKey]['adultBeds'] = $adultBeds;
				}
				if (isset($revenueGrid[$item['rf_currency_symbol']][$dateKey]['childBeds'])) {
					$revenueGrid[$item['rf_currency_symbol']][$dateKey]['childBeds'] += $childBeds;
				} else {
					$revenueGrid[$item['rf_currency_symbol']][$dateKey]['childBeds'] = $childBeds;
				}
				if (isset($revenueGrid[$item['rf_currency_symbol']][$dateKey]['revenue'])) {
					$revenueGrid[$item['rf_currency_symbol']][$dateKey]['revenue'] += ($item['rv_item_amt_nett'] - $item['rv_item_amt_tax']);
				} else {
					$revenueGrid[$item['rf_currency_symbol']][$dateKey]['revenue'] = ($item['rv_item_amt_nett'] - $item['rv_item_amt_tax']);
				}
				if($fullDays != 0) {
					if (isset($revenueGrid[$item['rf_currency_symbol']][$dateKey]['actualRevenue'])) {
						$revenueGrid[$item['rf_currency_symbol']][$dateKey]['actualRevenue'] += ($item['rv_item_amt_nett'] - $item['rv_item_amt_tax']) / $fullDays * $days;
					} else {
						$revenueGrid[$item['rf_currency_symbol']][$dateKey]['actualRevenue'] = ($item['rv_item_amt_nett'] - $item['rv_item_amt_tax']) / $fullDays * $days;
					}
					
				}
				if (isset($revenueGrid[$item['rf_currency_symbol']][$dateKey]['totalNights'])) {
					$revenueGrid[$item['rf_currency_symbol']][$dateKey]['totalNights'] += dateSubtract($item['rv_item_date_depart'],$item['rv_item_date_arrive']);
				} else {
					$revenueGrid[$item['rf_currency_symbol']][$dateKey]['totalNights'] = dateSubtract($item['rv_item_date_depart'],$item['rv_item_date_arrive']);
				}
				if (isset($revenueGrid[$item['rf_currency_symbol']][$dateKey]['actualNights'])) {
					$revenueGrid[$item['rf_currency_symbol']][$dateKey]['actualNights'] += $days;
				} else {
					$revenueGrid[$item['rf_currency_symbol']][$dateKey]['actualNights'] = $days;
				}
			}
		}
	}

	// Remove blanks and replace with 0's and calculate totals
	$monthTotals = $dateArray;
	foreach($bedNightGrid as $id=>$dateItem) {
		$grandTotalAdult = 0;
		$grandTotalChild = 0;
		$grandTotal = 0;
		foreach($dateItem as $totalKey=>$totals) {
			if(!isset($totals['adultBeds']) || trim($totals['adultBeds']) == "") { $bedNightGrid[$id][$totalKey]['adultBeds'] = 0; }
			if(!isset($totals['childBeds']) || trim($totals['childBeds']) == "") { $bedNightGrid[$id][$totalKey]['childBeds'] = 0; }
			$bedNightGrid[$id][$totalKey]['totalBeds'] = $bedNightGrid[$id][$totalKey]['adultBeds'] + $bedNightGrid[$id][$totalKey]['childBeds'];

			$grandTotalAdult += $bedNightGrid[$id][$totalKey]['adultBeds'];
			$grandTotalChild += $bedNightGrid[$id][$totalKey]['childBeds'];
			$grandTotal += $bedNightGrid[$id][$totalKey]['totalBeds'];

			if (isset($monthTotals[$totalKey]['adultBeds'])) {
				$monthTotals[$totalKey]['adultBeds'] += $bedNightGrid[$id][$totalKey]['adultBeds'];
			} else {
				$monthTotals[$totalKey]['adultBeds'] = $bedNightGrid[$id][$totalKey]['adultBeds'];
			}
			if (isset($monthTotals[$totalKey]['childBeds'])) {
				$monthTotals[$totalKey]['childBeds'] += $bedNightGrid[$id][$totalKey]['childBeds'];
			} else {
				$monthTotals[$totalKey]['childBeds'] = $bedNightGrid[$id][$totalKey]['childBeds'];
			}
			if (isset($monthTotals[$totalKey]['totalBeds'])) {
				$monthTotals[$totalKey]['totalBeds'] += $bedNightGrid[$id][$totalKey]['totalBeds'];
			} else {
				$monthTotals[$totalKey]['totalBeds'] = $bedNightGrid[$id][$totalKey]['totalBeds'];
			}
		}
		if($potentialBedNightTotal != 0) {
			$percTotal = $grandTotal / $potentialBedNightTotal * 100;
		} else {
			$percTotal = 0;
		}
		fixAmtDisplay($percTotal,2);
		$bedNightGrid[$id]['grandTotal'] = array(
			'adultBeds' => $grandTotalAdult,
			'childBeds' => $grandTotalChild,
			'totalBeds' => $grandTotal,
			'percTotal' => $percTotal
		);
	}

	// Apply Sorting...
	foreach($bedNightGrid as $id=>$item) {
		foreach($groupByList as $groupItem) {
			if(trim($id) == "" || ($id == "0" && $groupByOption != "status")) {
				$name = $blankDesc;
			} else {
				foreach($groupByList as $groupItem) {
					if($groupItem['id'] == $id) {
						$name = $groupItem['name'];
					}
				}
			}
		}
		$bedNightGrid[$id]['id'] = $id;
		$bedNightGrid[$id]['name'] = $name;
	}
	
	function sortNameDsc($a, $b) {
		if($a['name'] == $b['name']) { return 0; }
		if($a['name'] > $b['name']) {
			return 1;
		} else {
			return -1;
		}
	}
	
	function sortNameAsc($a, $b) {
		if($a['name'] == $b['name']) { return 0; }
		if($a['name'] > $b['name']) {
			return -1;
		} else {
			return 1;
		}
	}

	function sortPercDsc($a, $b) {
		if($a['grandTotal']['percTotal'] == $b['grandTotal']['percTotal']) { return 0; }
		if($a['grandTotal']['percTotal'] > $b['grandTotal']['percTotal']) {
			return 1;
		} else {
			return -1;
		}
	}

	function sortPercAsc($a, $b) {
		if($a['grandTotal']['percTotal'] == $b['grandTotal']['percTotal']) { return 0; }
		if($a['grandTotal']['percTotal'] > $b['grandTotal']['percTotal']) {
			return -1;
		} else {
			return 1;
		}
	}
//	debug($bedNightGrid);
	switch($sortBy) {
		case 1:
			usort($bedNightGrid, "sortNameDsc");
			break;
		case 2:
			usort($bedNightGrid, "sortNameAsc");
			break;
		case 3:
			usort($bedNightGrid, "sortPercDsc");
			break;
		case 4:
			usort($bedNightGrid, "sortPercAsc");
			break;
	}

	foreach($revenueGrid as $id=>$item) {
		$grandTotalAdult = 0;
		$grandTotalChild = 0;
		$grandTotal = 0;
		$grandTotalRevenue = 0;
		foreach($item as $totalKey=>$totals) {
			if(!isset($totals['adultBeds']) || trim($totals['adultBeds']) == "") { $revenueGrid[$id][$totalKey]['adultBeds'] = 0; }
			if(!isset($totals['childBeds']) || trim($totals['childBeds']) == "") { $revenueGrid[$id][$totalKey]['childBeds'] = 0; }
			$revenueGrid[$id][$totalKey]['totalBeds'] = $revenueGrid[$id][$totalKey]['adultBeds'] + $revenueGrid[$id][$totalKey]['childBeds'];
			if($revenueGrid[$id][$totalKey]['totalBeds'] != 0) {
				$revenueGrid[$id][$totalKey]['revenueNights'] = $revenueGrid[$id][$totalKey]['actualRevenue'] / $revenueGrid[$id][$totalKey]['totalBeds'];
			} else {
				$revenueGrid[$id][$totalKey]['revenueNights'] = 0;
			}

			
			$grandTotalAdult += $revenueGrid[$id][$totalKey]['adultBeds'];
			$grandTotalChild += $revenueGrid[$id][$totalKey]['childBeds'];
			$grandTotal += $revenueGrid[$id][$totalKey]['totalBeds'];
			$grandTotalRevenue += isset($revenueGrid[$id][$totalKey]['actualRevenue']) ? $revenueGrid[$id][$totalKey]['actualRevenue'] : 0;
		
			fixAmtDisplay($revenueGrid[$id][$totalKey]['revenue'],2);
			fixAmtDisplay($revenueGrid[$id][$totalKey]['actualRevenue'],2);
			fixAmtDisplay($revenueGrid[$id][$totalKey]['revenueNights'],2);
		}
		if($grandTotal != 0) {
			$grandTotalRevenueNights = $grandTotalRevenue / $grandTotal;
		} else {
			$grandTotalRevenueNights = 0;
		}
		fixAmtDisplay($grandTotalRevenueNights,2);
		if($potentialBedNightTotal != 0) {
			$percTotal = $grandTotal / $potentialBedNightTotal * 100;
		} else {
			$percTotal = 0;
		}
		fixAmtDisplay($percTotal,2);
		fixAmtDisplay($grandTotalRevenue,2);
		$revenueGrid[$id]['grandTotal'] = array(
			'adultBeds' => $grandTotalAdult,
			'childBeds' => $grandTotalChild,
			'totalBeds' => $grandTotal,
			'actualRevenue'   => $grandTotalRevenue,
			'revenueNights' => $grandTotalRevenueNights,
			'percTotal' => $percTotal
		);
	}

	$grandTotalAdult = 0;
	$grandTotalChild = 0;
	$grandTotal = 0;
	foreach($monthTotals as $monthKey=>$monthItem) {
		$monthItem['adultBeds'] = isset($monthItem['adultBeds']) ? $monthItem['adultBeds'] : "";
		$monthItem['childBeds'] = isset($monthItem['childBeds']) ? $monthItem['childBeds'] : "";
		$monthItem['totalBeds'] = isset($monthItem['totalBeds']) ? $monthItem['totalBeds'] : "";

		$grandTotalAdult += $monthItem['adultBeds'];
		$grandTotalChild += $monthItem['childBeds'];
		$grandTotal += $monthItem['totalBeds'];

		if($potentialArray[$monthKey]['potentialBedNight'] != 0) {
			$percMonth = $monthItem['totalBeds'] / $potentialArray[$monthKey]['potentialBedNight'] * 100;
		} else {
			$percMonth = 0;
		}
		fixAmtDisplay($percMonth,2);
		$monthTotals[$monthKey]['percMonth'] = $percMonth;
	}
	if($potentialBedNightTotal != 0) {		
		$percTotal = $grandTotal / $potentialBedNightTotal * 100;
	} else {
		$percTotal = 0;
	}
	fixAmtDisplay($percTotal,2);
	$monthTotals['grandTotal'] = array(
		'adultBeds' => $grandTotalAdult,
		'childBeds' => $grandTotalChild,
		'totalBeds' => $grandTotal,
		'percTotal' => $percTotal
	);


	$args = array_slice($_SERVER['argv'],1,24);
	$argList = join("+",$args);


	if($renderOption == 0) {
		setLastReport("reservation.php?" . join("+",$_SERVER['argv']));
		$revenueHeadRows = "";
		$revenueRows = "";
		$currRowCount = 0;
		$colspan = "1";
		if($showRoomConfig == "1") {
			$colspan = "3";
		}

		foreach($revenueGrid as $id=>$item) {
			$revBedNightHeadRow = "
		  <tr>
			  <td height=\"18\" class=\"outLt\" width=\"140\"><span style=\"width:30;\">$id</span>Bednights</td>
		  </tr>
			";
			$revBedNightRow = "
		  <tr>
		  	";
			$revAmountHeadRow = "
		  <tr>
			  <td height=\"18\" class=\"outLt\" width=\"140\"><span style=\"width:30;\"></span>Revenue</td>
		  </tr>
			";
			$revAmountRow = "
		  <tr>
		  	";
			$revAverageHeadRow = "
		  <tr>
			  <td height=\"18\" class=\"outLt\" width=\"140\"><span style=\"width:30;\"></span>Rev / Bed nts</td>
		  </tr>
			";
			$revAverageRow = "
		  <tr>
		    ";
			foreach($item as $totalKey=>$totals) {
				if($totalKey !== "grandTotal" && $totalKey !== "name"  && $totalKey !== "id") {
					if ( $showRoomConfig == "1" ) {
						$revBedNightRow .= "
			<td width=\"30\" height=\"18\" align=\"right\" class=\"br bb\">" . $totals['adultBeds'] . "&nbsp;</td>					
			<td width=\"30\" height=\"18\" align=\"right\" class=\"br bb\">" . $totals['childBeds'] . "&nbsp;</td>
						";
					}
					$revBedNightRow .= "
	  		<td width=\"55\" height=\"18\" align=\"right\" class=\"br bb\">" . $totals['totalBeds'] . "&nbsp;</td>
					";
					$revAmountRow .= "
				<td colspan=\"$colspan\" height=\"18\" align=\"right\" class=\"br bb\">" . $totals['actualRevenue'] . "&nbsp;</td>
					";
					$revAverageRow .= "
				<td colspan=\"$colspan\" height=\"18\" align=\"right\" class=\"br bb\">" . $totals['revenueNights'] . "&nbsp;</td>
					";
				}
			}
			if($showRoomConfig == "1") {
				$revBedNightRow .= "
		  	<td width=\"30\" height=\"18\" align=\"right\" class=\"br bb\">".$item['grandTotal']['adultBeds']."&nbsp;</td>
			<td width=\"30\" height=\"18\" align=\"right\" class=\"br bb\">".$item['grandTotal']['childBeds']."&nbsp;</td>
				";
			}
			$revBedNightRow .= "
	  		<td width=\"55\" height=\"18\" align=\"right\" class=\"br bb\">".$item['grandTotal']['totalBeds']."&nbsp;</td>
	    	<td class=\"br bb\" align=\"right\">".$item['grandTotal']['percTotal']."%&nbsp;</td>
		  </tr>    
			";
			$revAmountRow .= "
				<td colspan=\"$colspan\" height=\"18\" align=\"right\" class=\"br bb\">".$item['grandTotal']['actualRevenue']."&nbsp;</td>
        		<td class=\"br bb\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>                    
		  </tr>    
			";
			$revAverageRow .= "
				<td colspan=\"$colspan\" height=\"18\" align=\"right\" class=\"br bb\">".$item['grandTotal']['revenueNights']."&nbsp;</td>
		    <td class=\"br bb\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>                    
		  </tr>    
			";
			$revenueHeadRows .= $revBedNightHeadRow . $revAmountHeadRow . $revAverageHeadRow;
			$revenueRows .= $revBedNightRow . $revAmountRow . $revAverageRow;
		}
		$GLOBALS['temp']['revenueHeadRows'] = $revenueHeadRows;
		$GLOBALS['temp']['revenueRows'] = $revenueRows;

		
		$headRows = "";
		$rows = "";
		foreach($bedNightGrid as $id=>$item) {
			$name = $item['name'];
			$clickId = $item['id'];
			if(trim($clickId) == "") {
				$clickId = "0";
			}
			$overlibName = t_encodeOverlib($name);
			if(strlen($name) > 20) {
				$name = substr($name,0,18) . "...";
			}
			$headRow = "
			  <tr>
			  <td height=\"18\" class=\"outLt\" style=\"cursor: pointer; white-space: nowrap\" onclick=\"openDetailPopup('" . $argList . "+row+" . $clickId . "');\" onmouseover=\"rowOn(" . $currRowCount . "); overlib('" . $overlibName . "',WIDTH,100);\" onmouseout=\"rowOff(" . $currRowCount . "); nd();\" nowrap>" . $name . "</td>
			 </tr>
			";
			$row = "
				<tr id=\"groupRow" . $currRowCount . "\">
			";
			$currColCount = 0;
			foreach($item as $totalId=>$totals) {
				if($totalId !== "grandTotal" && $totalId !== "name" && $totalId !== "id") {
					$adult = $totals['adultBeds'];
					$child = $totals['childBeds'];
					$total = $totals['totalBeds'];
					if($showRoomConfig == "1") {
						$row .= "
				  		<td id=\"groupCellR".$currRowCount."C".$currColCount."A\" height=\"18\" align=\"right\" class=\"br bb\">$adult&nbsp;</td>
						<td id=\"groupCellR".$currRowCount."C".$currColCount."B\" height=\"18\" align=\"right\" class=\"br bb\">$child&nbsp;</td>
						";
					}
					$row .= "
				  		<td id=\"groupCellR".$currRowCount."C".$currColCount."C\" height=\"18\" align=\"right\" class=\"br bb\">$total&nbsp;</td>
					";
				}
				$currColCount++;
			}
			if($showRoomConfig == "1") {
				$row .= "
		 		<td height=\"18\" align=\"right\" class=\"br bb\">".$item['grandTotal']['adultBeds']."&nbsp;</td>
				<td height=\"18\" align=\"right\" class=\"br bb\">".$item['grandTotal']['childBeds']."&nbsp;</td>
				";
			}
			$row .= "
				<td height=\"18\" align=\"right\" class=\"br bb\">".$item['grandTotal']['totalBeds']."&nbsp;</td>
			    <td align=\"right\" class=\"br bb\">".$item['grandTotal']['percTotal']."%&nbsp;</td>                    
		  	</tr>
			";
			$rows .= $row;
			$headRows .= $headRow;
			$currRowCount++;
		}
		$GLOBALS['temp']['groupRows'] = $rows;
		$GLOBALS['temp']['groupHeadRows'] = $headRows;

		$monthTotalHeadRow = "
			  <tr>
    			<td class=\"outLt\" height=\"18\">Total occupied</td>
			  </tr>
		";
		$monthTotalRow = "
			  <tr>
	    ";
		$occupiedPercHeadRow = "
			<tr>
		    	<td class=\"outLt\" height=\"18\" onmouseout=\"nd();\" onmouseover=\"showPercentOccupancyOverlib();\">% Occupancy</td>
			</tr>
		";
		$occupiedPercRow = "
			<tr>
		";
		foreach($monthTotals as $monthKey=>$monthItem) {
			if($monthKey !== "grandTotal" && $monthKey !== "name" && $monthKey !== "id") {
				$adult = isset($monthItem['adultBeds']) ? $monthItem['adultBeds'] : "";
				$child = isset($monthItem['childBeds']) ? $monthItem['childBeds'] : "";
				$total = isset($monthItem['totalBeds']) ? $monthItem['totalBeds'] : "";
				$perc = isset($monthItem['percMonth']) ? $monthItem['percMonth'] : "";
				if($showRoomConfig == "1") {
					$monthTotalRow .= "
			  		<td height=\"18\" align=\"right\" class=\"br bb\">$adult&nbsp;</td>
					<td height=\"18\" align=\"right\" class=\"br bb\">$child&nbsp;</td>
					";
				}
				$monthTotalRow .= "
  					<td height=\"18\" align=\"right\" class=\"br bb\">$total&nbsp;</td>
				";
				if($showRoomConfig == "1") {
					$occupiedPercRow .= "
	  			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
				<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
					";
				}
					$occupiedPercRow .= "
				<td height=\"18\" align=\"right\" class=\"br bb\">$perc%&nbsp;</td>
				";
			}
		}
		if($showRoomConfig == "1") {
			$monthTotalRow .= "
  				<td height=\"18\" align=\"right\" class=\"br bb\">".$monthTotals['grandTotal']['adultBeds']."&nbsp;</td>
				<td height=\"18\" align=\"right\" class=\"br bb\">".$monthTotals['grandTotal']['childBeds']."&nbsp;</td>
			";
		}
		$monthTotalRow .= "
		  		<td height=\"18\" align=\"right\" class=\"br bb\">".$monthTotals['grandTotal']['totalBeds']."&nbsp;</td>
			    <td align=\"right\" class=\"br bb\">".$monthTotals['grandTotal']['percTotal']."%&nbsp;</td>                    
	  		</tr>
		";
		if($showRoomConfig == "1") {
			$occupiedPercRow .= "
	  		<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			";
		}
		$occupiedPercRow .= "
  			<td height=\"18\" align=\"right\" class=\"br bb\">".$monthTotals['grandTotal']['percTotal']."%&nbsp;</td>
		    <td class=\"br bb\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
		  </tr>
		";
		$GLOBALS['temp']['monthTotalHeadRow'] = $monthTotalHeadRow;
		$GLOBALS['temp']['monthTotalRow'] = $monthTotalRow;
		$GLOBALS['temp']['occupiedPercHeadRow'] = $occupiedPercHeadRow;
		$GLOBALS['temp']['occupiedPercRow'] = $occupiedPercRow;
	
/*		$colList = "
			<col width=\"140\">
		";*/
		$colListHead = "";
		$colList = "";
		$colListRevenue = "";

		$dateCol1 = "";
		$dateCol2 = "";

		$blankHeadRow = "
		  <tr>
	    	<td class=\"outLt\" height=\"18\">&nbsp;</td>
		  </tr>
		";
		$blankRow = "
		  <tr>
		";
		$revenueFiller = "";

		$currColCount = 0;
		foreach($dateArray as $dateItem) {
			list($year,$month,$day) = explode("-",$dateItem['start']);
			$monthFmt = date("F Y",mktime(0,0,0,$month,$day,$year));
			if($showRoomConfig == "1") {			
				$colListHead .= "
				<col width=\"30\">
				<col width=\"30\">
				";
			}
			$colListHead .= "
				<col width=\"55\">
			";
			$colList .= "
				<colgroup id=\"groupCol$currColCount\">
			";
			if($showRoomConfig == "1") {			
				$colList .= "
				<col width=\"30\">
				<col width=\"30\">
				";
			}
			$colList .= "
				<col width=\"55\">
				</colgroup>
			";
			$colListRevenue .= "
				<colgroup id=\"revenueCol$currColCount\">
			";
			if($showRoomConfig == "1") {			
				$colListRevenue .= "
				<col width=\"30\">
				<col width=\"30\">
				";
			}
			$colListRevenue .= "
				<col width=\"55\">
				</colgroup>
			";

			$dateCol1 .= "
	  			<td width=\"115\" colspan=\"$colspan\" align=\"center\" class=\"outDk\" style=\"cursor:pointer;\" onclick=\"openDetailPopup('" . $argList . "+col+" . $dateItem['start'] . "');\" onmouseover=\"colOn($currColCount);\" onmouseout=\"colOff($currColCount);\">$monthFmt</td>
			";
			if($showRoomConfig == "1") {			
				$dateCol2 .= "
	  			<td width=\"30\" align=\"right\" class=\"outDk\">Ad&nbsp;</td>
				<td width=\"30\" align=\"right\" class=\"outDk\">Ch&nbsp;</td>
				";
			}
			$dateCol2 .= "
			  	<td width=\"55\" align=\"right\" class=\"outDk\">Total&nbsp;</td>
			";
			if($showRoomConfig == "1") {			
				$blankRow .= "
		  		<td height=\"18\" align=\"center\" class=\"br bb\">&nbsp;</td>
				<td height=\"18\" align=\"center\" class=\"br bb\">&nbsp;</td>
				";
			}
			$blankRow .= "
				<td height=\"18\" align=\"center\" class=\"br bb\">&nbsp;</td>
			";
			if($showRoomConfig == "1") {			
				$revenueFiller .= "
	  			<td height=\"18\" align=\"center\" class=\"br bb\">&nbsp;</td>
				<td height=\"18\" align=\"center\" class=\"br bb\">&nbsp;</td>
				";
			}
			$revenueFiller .= "
				<td height=\"18\" align=\"center\" class=\"br bb\">&nbsp;</td>
			";
			$currColCount++;
		}

		if($showRoomConfig == "1") {			
			$colListHead .= "
			<col width=\"30\">
			<col width=\"30\">
			";
		}
		$colListHead .= "
			<col width=\"55\">
			<col width=\"55\">
		";
		if($showRoomConfig == "1") {			
			$colList .= "
			<col width=\"30\">
			<col width=\"30\">
			";
		}
		$colList .= "
			<col width=\"55\">
			<col width=\"55\">
		";		
		if($showRoomConfig == "1") {			
			$colListRevenue .= "
			<col width=\"30\">
			<col width=\"30\">
			";
		}
		$colListRevenue .= "
			<col width=\"55\">
			<col width=\"55\">
		";


		$dateCol1 .= "
  			<td colspan=\"$colspan\" align=\"right\" class=\"outDk\">Total&nbsp;</td>
	    	<td width=\"55\" rowspan=\"2\" align=\"right\" class=\"outDk\">% of Pot.<img class=\"imgLink printCollapse\" src=\"/resource/Resrequest/Application/public/img/arrow_ascend_".$GLOBALS['temp']['imgSort3Mode'].".gif\" width=\"10\" height=\"10\" border=\"0\" onclick=\"newSort(3);\"><img class=\"imgLink printCollapse\" src=\"/resource/Resrequest/Application/public/img/arrow_descend_".$GLOBALS['temp']['imgSort4Mode'].".gif\" width=\"10\" height=\"10\" border=\"0\" onclick=\"newSort(4);\"></td>
		  </tr>
		";
		if($showRoomConfig == "1") {			
			$dateCol2 .= "
			  	<td width=\"30\" align=\"right\" class=\"outDk\">Ad&nbsp;</td>
				<td width=\"30\" align=\"right\" class=\"outDk\">Ch&nbsp;</td>
			";
		}
		$dateCol2 .= "
		  		<td width=\"55\" align=\"right\" class=\"outDk\">Total&nbsp;</td>
		  </tr>
		";
		if($showRoomConfig == "1") {			
			$blankRow .= "
			  	<td height=\"18\" align=\"right\" class=\"br bb\">&nbsp;</td>
				<td align=\"right\" class=\"br bb\">&nbsp;</td>
			";
		}
		$blankRow .= "
				<td align=\"right\" class=\"br bb\">&nbsp;</td>
	    	<td class=\"br bb\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>                    
		  </tr>  
		";
		if($showRoomConfig == "1") {			
			$revenueFiller .= "
			  	<td height=\"18\" align=\"right\" class=\"br bb\">&nbsp;</td>
				<td align=\"right\" class=\"br bb\">&nbsp;</td>
			";
		}
		$revenueFiller .= "
				<td align=\"right\" class=\"br bb\">&nbsp;</td>
    		<td class=\"br bb\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>                    
		  </tr>  
		";

		$GLOBALS['temp']['colListHead'] = $colListHead;
		$GLOBALS['temp']['colList'] = $colList;
		$GLOBALS['temp']['colListRevenue'] = $colListRevenue;
		$GLOBALS['temp']['dateCol1'] = $dateCol1;
		$GLOBALS['temp']['dateCol2'] = $dateCol2;
		$GLOBALS['temp']['blankHeadRow'] = $blankHeadRow;
		$GLOBALS['temp']['blankRow'] = $blankRow;
		$GLOBALS['temp']['revenueFiller'] = $revenueFiller;

		$potentialHeadRow = "
		  <tr>
	    	<td class=\"outLt\" height=\"18\">Potential</td>
		  </tr>
		";
		$potentialRow = "
		  <tr>
		";
		$roomNightHeadRow = "
		  <tr>
		    <td class=\"outLt\" align=\"right\" height=\"18\" onmouseout=\"nd();\" onmouseover=\"showTotalRoomNightsOverlib();\">Total room nights</td>
		  </tr>
		";
		$roomNightRow = "
		  <tr>
		";
		$blockHeadRow = "
		  <tr>
		    <td class=\"outLt\" align=\"right\" height=\"18\" onmouseout=\"nd();\" onmouseover=\"showBlockedRoomNightsOverlib();\">Blocked room nights</td>
		  </tr>
		";
		$blockRow = "
		  <tr>
		";
		$potentialBedNightHeadRow = "
		  <tr>
		    <td class=\"outLt\" align=\"right\" height=\"18\" onmouseout=\"nd();\" onmouseover=\"showPotentialBedNightsOverlib();\">Potential bed nights</td>
		  </tr>
		";
		$potentialBedNightRow = "
		  <tr>
		";
		foreach($potentialArray as $potentialItem) {
			if($showRoomConfig == "1") {			
				$potentialRow .= "
		  	<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
				";
			}
			$potentialRow .= "
		  	<td height=\"18\" align=\"right\" class=\"br bb\">&nbsp;</td>
			";
			if($showRoomConfig == "1") {			
				$roomNightRow .= "
		  	<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
				";
			}
			$roomNightRow .= "
		  	<td height=\"18\" align=\"right\" class=\"br bb\">" . $potentialItem['roomCount'] . "&nbsp;</td>
			";
			if($showRoomConfig == "1") {			
				$blockRow .= "
		  	<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
				";
			}
			$blockRow .= "
			<td height=\"18\" align=\"right\" class=\"br bb\">" . $potentialItem['blockCount'] . "&nbsp;</td>
			";
			if($showRoomConfig == "1") {			
				$potentialBedNightRow .= "
  			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
				";
			}
			$potentialBedNightRow .= "
			<td height=\"18\" align=\"right\" class=\"br bb\">" . $potentialItem['potentialBedNight'] . "&nbsp;</td>
			";
		}
		if($showRoomConfig == "1") {			
			$potentialRow .= "
	  		<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			";
		}
		$potentialRow .= "
		  	<td height=\"18\" align=\"right\" class=\"br bb\">&nbsp;</td>
	    	<td height=\"18\" class=\"br bb\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>                    
		  </tr>
		";
		if($showRoomConfig == "1") {			
			$roomNightRow .= "
		  	<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			";
		}
		$roomNightRow .= "
		  	<td height=\"18\" align=\"right\" class=\"br bb\">$roomCountTotal&nbsp;</td>
		    <td height=\"18\" class=\"br bb\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>                    
		  </tr>
		";
		if($showRoomConfig == "1") {			
			$blockRow .= "
		  	<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			";
		}
		$blockRow .= "
		  	<td height=\"18\" align=\"right\" class=\"br bb\">$blockCountTotal&nbsp;</td>
		    <td height=\"18\" class=\"br bb\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>                    
		  </tr>
		";
		if($showRoomConfig == "1") {			
			$potentialBedNightRow .= "
		  	<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			<td height=\"18\" align=\"right\" class=\"br bb colGryLt\">&nbsp;</td>
			";
		}
		$potentialBedNightRow .= "
		  	<td height=\"18\" align=\"right\" class=\"br bb\">$potentialBedNightTotal&nbsp;</td>
		    <td height=\"18\" class=\"br bb\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>                    
		  </tr>
		";
		$GLOBALS['temp']['potentialHeadRow'] = $potentialHeadRow;
		$GLOBALS['temp']['potentialRow'] = $potentialRow;
		$GLOBALS['temp']['roomNightHeadRow'] = $roomNightHeadRow;
		$GLOBALS['temp']['roomNightRow'] = $roomNightRow;
		$GLOBALS['temp']['blockHeadRow'] = $blockHeadRow;
		$GLOBALS['temp']['blockRow'] = $blockRow;
		$GLOBALS['temp']['potentialBedNightHeadRow'] = $potentialBedNightHeadRow;
		$GLOBALS['temp']['potentialBedNightRow'] = $potentialBedNightRow;
	}
	if($renderOption == 1 || $renderOption == 3) { // PDF
		$pdf = new PDF($title,'L');
		$reportLabel = $title;
		// Main PDF header
		$rateOverrideFilter = "None";
		if(!empty($rateOverride)) {
			switch($rateOverrideType) {
			default:
			case "excludeRes":
				$rateOverrideFilter = "Exclude overrides";
				break;
			case "includeRes":
				$rateOverrideFilter = "Reservations including overrides only";
				break;
			case "excludeItem":
				$rateOverrideFilter = "Itinerary items with overrides only";
				break;
			case "includeItem":
				$rateOverrideFilter = "Itinerary items without overrides only";
				break;
			}			
		}		

		$amountOverrideFilter = "None";
		if(!empty($amountOverride)) {
			switch($amountOverrideType) {
			default:
			case "excludeRes":
				$amountOverrideFilter = "Exclude overrides";
				break;
			case "includeRes":
				$amountOverrideFilter = "Reservations including overrides only";
				break;
			case "excludeItem":
				$amountOverrideFilter = "Itinerary items with overrides only";
				break;
			case "includeItem":
				$amountOverrideFilter = "Itinerary items without overrides only";
				break;
			}			
		}		
		$headerArray = array(
			array('name' => "Date Range",    							 	'value' => chng_date($fromDate,"-") . " to " . chng_date($toDate,"-")),
			array('name' => "Property / Accommodation",			 		'value' => $accommFilter['names']),
			array('name' => "Agent",         						 		'value' => $agentFilter['names']),
			array('name' => "Agent country",						  	'value' => $agentCountryFilter['names']),
			array('name' => "Status",         							'value' => $statusFilter['names']),
			array('name' => "Exclude expired provisionals",				'value' => ($excludeExpired == "1" ? "Yes" : "No")),
			array('name' => "Consultant",     							'value' => $consultantFilter['names']),
			array('name' => "Originator",     							'value' => $originatorFilter['names']),
			array('name' => "Source",         							'value' => $sourceFilter['names']),
			array('name' => "Nationality",    							'value' => $nationalityFilter['names']),
			array('name' => "Rate",           							'value' => $rateFilter['names']),
			array('name' => "Rate type override filter",					'value' => $rateOverrideFilter),
			array('name' => "Rate amount override filter",				'value' => $amountOverrideFilter),
			array('name' => "Include Revenue",							'value' => ( $showRevenueOption == "1" ? "Yes" : "No" )),
			array('name' => "Include adult / child count",	'value' => ( $showRoomConfig == "1" ? "Yes" : "No" )), 
			array('name' => "Group by",	'value' => $groupByName) 
		);
		$pdfFontSize = 8;
		$pdf->SetFont('Arial', '', $pdfFontSize);
		$pdf->SetFont('Arial', '', 6);

		$colCount = sizeof($dateArray) + 1; // Includes total column
		$colMax = 8; // per 'row'

		$colSets = ceil($colCount / $colMax);

		$dateSize = "4%";
		$totalSize = "5%";
		if($showRoomConfig == "1") {			
			$dateSize = "10%";
			$totalSize = "11%";
		}

		for($cnt = 0; $cnt < $colSets; $cnt++) {
			// Make header
			$dateRow1 = array(array('width'=>"15%", 'data'=>"", 'border'=>"LRT", 'fill'=>"1"));
			$dateRow2 = array(array('width'=>"15%", 'data'=>"", 'border'=>"LRB", 'fill'=>"1"));
			$blankRow = array(array('width'=>"15%", 'data'=>"", 'border'=>"LRTB", 'fill'=>"1"));
			$totalOccRow = array(array('width'=>"15%", 'data'=>"Total Occupied", 'border'=>"LRTB", 'fill'=>"1"));
			$potentialRow = array(array('width'=>"15%", 'data'=>"Potential", 'border'=>"LRTB", 'fill'=>"1"));
			$roomNightRow = array(array('width'=>"15%", 'data'=>"Total room nights", 'align'=>"R", 'border'=>"LRTB", 'fill'=>"1"));
			$blockRow = array(array('width'=>"15%", 'data'=>"Blocked room nights", 'align'=>"R", 'border'=>"LRTB", 'fill'=>"1"));
			$potentialBedNightRow = array(array('width'=>"15%", 'data'=>"Potential bed nights", 'align'=>"R", 'border'=>"LRTB", 'fill'=>"1"));
			$occPercRow = array(array('width'=>"15%", 'data'=>"% Occupancy", 'border'=>"LRTB", 'fill'=>"1"));
			$revenueRow = array(array('width'=>"15%", 'data'=>"Revenue", 'border'=>"LRTB", 'fill'=>"1"));
			for($dateCnt = ($cnt * $colMax); $dateCnt < ( ($cnt * $colMax) + $colMax ) && $dateCnt < sizeof($dateArray)+1; $dateCnt++) {
				if($dateCnt < sizeof($dateArray)) {
					list($year,$month,$day) = explode("-",$dateArray[$dateCnt]['start']);
					if($showRoomConfig == "1") {			
						$monthFmt = date("F Y",mktime(0,0,0,$month,$day,$year));
					} else {
						$monthFmt = date("M y",mktime(0,0,0,$month,$day,$year));
					}
					array_push($dateRow1,array('width'=>$dateSize, 'data'=>$monthFmt, 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1"));
					if($showRoomConfig == "1") {			
						array_push($dateRow2,
							array('width'=>"3%", 'data'=>"Ad", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1"),
							array('width'=>"3%", 'data'=>"Ch", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1")
						);
					}
					array_push($dateRow2,
						array('width'=>"4%", 'data'=>"Total", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1")
					);
					if($showRoomConfig == "1") {			
						array_push($blankRow,
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB"),
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB")
						);
					}
					array_push($blankRow,
						array('width'=>"4%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB")
					);
					$adult = isset($monthTotals[$dateCnt]['adultBeds']) ? $monthTotals[$dateCnt]['adultBeds'] : "";
					$child = isset($monthTotals[$dateCnt]['childBeds']) ? $monthTotals[$dateCnt]['childBeds'] : "";
					$total = isset($monthTotals[$dateCnt]['totalBeds']) ? $monthTotals[$dateCnt]['totalBeds'] : "";
					$perc = isset($monthTotals[$dateCnt]['percMonth']) ? $monthTotals[$dateCnt]['percMonth'] : "";
					if($showRoomConfig == "1") {			
						array_push($totalOccRow,
							array('width'=>"3%", 'data'=>$adult, 'align'=>"C", 'border'=>"LRTB"),
							array('width'=>"3%", 'data'=>$child, 'align'=>"C", 'border'=>"LRTB")
						);
					}
					array_push($totalOccRow,
						array('width'=>"4%", 'data'=>$total, 'align'=>"C", 'border'=>"LRTB")
					);
					if($showRoomConfig == "1") {			
						array_push($potentialRow,
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1"),
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1")
						);
					}
					array_push($potentialRow,
						array('width'=>"4%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB")
					);
					if($showRoomConfig == "1") {			
						array_push($roomNightRow,
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1"),
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1")
						);
					}
					array_push($roomNightRow,
						array('width'=>"4%", 'data'=>$potentialArray[$dateCnt]['roomCount'], 'align'=>"C", 'border'=>"LRTB")
					);
					if($showRoomConfig == "1") {			
						array_push($blockRow,
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1"),
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1")
						);
					}
					array_push($blockRow,
						array('width'=>"4%", 'data'=>$potentialArray[$dateCnt]['blockCount'], 'align'=>"C", 'border'=>"LRTB")
					);
					if($showRoomConfig == "1") {			
						array_push($potentialBedNightRow,
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1"),
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1")
						);
					}
					array_push($potentialBedNightRow,
						array('width'=>"4%", 'data'=>$potentialArray[$dateCnt]['potentialBedNight'], 'align'=>"C", 'border'=>"LRTB")
					);
					if($showRoomConfig == "1") {			
						array_push($occPercRow,
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1"),
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1")
						);
					}
					array_push($occPercRow,
						array('width'=>"4%", 'data'=>$perc."%", 'align'=>"C", 'border'=>"LRTB")
					);
					if($showRoomConfig == "1") {			
						array_push($revenueRow,
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB"),
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB")
						);
					}
					array_push($revenueRow,
						array('width'=>"4%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB")
					);
				} else {
					$monthFmt = "Total";
					array_push($dateRow1,
						array('width'=>$totalSize, 'data'=>$monthFmt, 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1"),
						array('width'=>"4%", 'data'=>"% of", 'align'=>"C", 'border'=>"LRT", 'fill'=>"1")
					);
					if($showRoomConfig == "1") {			
						array_push($dateRow2,
							array('width'=>"3%", 'data'=>"Ad", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1"),
							array('width'=>"3%", 'data'=>"Ch", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1")
						);
					}
					array_push($dateRow2,
						array('width'=>"5%", 'data'=>"Total", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1"),
						array('width'=>"4%", 'data'=>"Potential", 'align'=>"C", 'border'=>"LRB", 'fill'=>"1")
					);
					if($showRoomConfig == "1") {			
						array_push($blankRow,
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB"),
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB")
						);
					}
					array_push($blankRow,
						array('width'=>"5%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB"),
						array('width'=>"4%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB")
					);
					if($showRoomConfig == "1") {			
						array_push($totalOccRow,
							array('width'=>"3%", 'data'=>$monthTotals['grandTotal']['adultBeds'], 'align'=>"C", 'border'=>"LRTB"),
							array('width'=>"3%", 'data'=>$monthTotals['grandTotal']['childBeds'], 'align'=>"C", 'border'=>"LRTB")
						);
					}
					array_push($totalOccRow,
						array('width'=>"5%", 'data'=>$monthTotals['grandTotal']['totalBeds'], 'align'=>"C", 'border'=>"LRTB"),
						array('width'=>"4%", 'data'=>$monthTotals['grandTotal']['percTotal']."%", 'align'=>"C", 'border'=>"LRTB")
					);
					if($showRoomConfig == "1") {			
						array_push($potentialRow,
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1"),
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1")
						);
					}
					array_push($potentialRow,
						array('width'=>"5%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB"),
						array('width'=>"4%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1")
					);
					if($showRoomConfig == "1") {			
						array_push($roomNightRow,
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1"),
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1")
						);
					}
					array_push($roomNightRow,
						array('width'=>"5%", 'data'=>$roomCountTotal, 'align'=>"C", 'border'=>"LRTB"),
						array('width'=>"4%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1")
					);
					if($showRoomConfig == "1") {			
						array_push($blockRow,
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1"),
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1")
						);
					}
					array_push($blockRow,
						array('width'=>"5%", 'data'=>$blockCountTotal, 'align'=>"C", 'border'=>"LRTB"),
						array('width'=>"4%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1")
					);
					if($showRoomConfig == "1") {			
						array_push($potentialBedNightRow,
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1"),
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1")
						);
					}
					array_push($potentialBedNightRow,
						array('width'=>"5%", 'data'=>$potentialBedNightTotal, 'align'=>"C", 'border'=>"LRTB"),
						array('width'=>"4%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1")
					);
					if($showRoomConfig == "1") {			
						array_push($occPercRow,
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1"),
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1")
						);
					}
					array_push($occPercRow,
						array('width'=>"5%", 'data'=>$monthTotals['grandTotal']['percTotal']."%", 'align'=>"C", 'border'=>"LRTB"),
						array('width'=>"4%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB", 'fill'=>"1")
					);
					if($showRoomConfig == "1") {			
						array_push($revenueRow,
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB"),
							array('width'=>"3%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB")
						);
					}
					array_push($revenueRow,
						array('width'=>"5%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB"),
						array('width'=>"4%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB")
					);
				}
			}
			
			$pdf->Row($dateRow1);
			$pdf->Row($dateRow2);

			
			foreach($bedNightGrid as $id=>$item) {
				$name = $item['name'];
				$row = array(array('width'=>"15%", 'data'=>$name, 'border'=>"LRTB", 'fill'=>"1"));
				for($dateCnt = ($cnt * $colMax); $dateCnt < ( ($cnt * $colMax) + $colMax ) && $dateCnt < sizeof($dateArray)+1; $dateCnt++) {
					$totalId = $dateCnt;
					if($dateCnt < sizeof($dateArray)) {
						$adult = isset($item[$totalId]['adultBeds']) ? $item[$totalId]['adultBeds'] : "";
						$child = isset($item[$totalId]['childBeds']) ? $item[$totalId]['childBeds'] : "";
						$total = isset($item[$totalId]['totalBeds']) ? $item[$totalId]['totalBeds'] : "";
						if($showRoomConfig == "1") {			
							array_push($row,
								array('width'=>"3%", 'data'=>$adult, 'align'=>"C", 'border'=>"LRTB"),
								array('width'=>"3%", 'data'=>$child, 'align'=>"C", 'border'=>"LRTB")
							);
						}
						array_push($row,
							array('width'=>"4%", 'data'=>$total, 'align'=>"C", 'border'=>"LRTB")
						);
					} else {
						if($showRoomConfig == "1") {			
							array_push($row,
								array('width'=>"3%", 'data'=>$item['grandTotal']['adultBeds'], 'align'=>"C", 'border'=>"LRTB"),
								array('width'=>"3%", 'data'=>$item['grandTotal']['childBeds'], 'align'=>"C", 'border'=>"LRTB")
							);
						}
						array_push($row,
							array('width'=>"5%", 'data'=>$item['grandTotal']['totalBeds'], 'align'=>"C", 'border'=>"LRTB"),
							array('width'=>"4%", 'data'=>$item['grandTotal']['percTotal']."%", 'align'=>"C", 'border'=>"LRTB")
						);
					}
				}
				$pdf->Row($row);
//				array_push($row,$item['grandTotal']['adultBeds'],$item['grandTotal']['childBeds'],$item['grandTotal']['totalBeds'],$item['grandTotal']['percTotal']);
//				array_push($csvFile,$row);
			}

			$pdf->Row($blankRow);
			$pdf->Row($totalOccRow);
			$pdf->Row($potentialRow);
			$pdf->Row($roomNightRow);
			$pdf->Row($blockRow);
			$pdf->Row($potentialBedNightRow);
			$pdf->Row($occPercRow);
			if($showRevenueOption == "1") {
				$pdf->Row($revenueRow);
				foreach($revenueGrid as $id=>$item) {
					$revBedNightRow = array(array('width'=>"15%", 'data'=>"$id Bednights", 'border'=>"LRTB", 'fill'=>"1"));
					$revAmountRow = array(array('width'=>"15%", 'data'=>"$id Revenue", 'border'=>"LRTB", 'fill'=>"1"));
					$revAverageRow = array(array('width'=>"15%", 'data'=>"$id Rev / Bed nts", 'border'=>"LRTB", 'fill'=>"1"));
					for($dateCnt = ($cnt * $colMax); $dateCnt < ( ($cnt * $colMax) + $colMax ) && $dateCnt < sizeof($dateArray)+1; $dateCnt++) {
						$totalKey = $dateCnt;
						$totals = isset($item[$dateCnt]) ? $item[$dateCnt] : array();
						if($dateCnt < sizeof($dateArray)) {
							$totals['adultBeds'] = isset($totals['adultBeds']) ? $totals['adultBeds'] : "";
							$totals['childBeds'] = isset($totals['childBeds']) ? $totals['childBeds'] : "";
							$totals['totalBeds'] = isset($totals['totalBeds']) ? $totals['totalBeds'] : "";
							$totals['actualRevenue'] = isset($totals['actualRevenue']) ? $totals['actualRevenue'] : "";
							$totals['revenueNights'] = isset($totals['revenueNights']) ? $totals['revenueNights'] : "";
							if($showRoomConfig == "1") {			
								array_push($revBedNightRow,
									array('width'=>"3%", 'data'=>$totals['adultBeds'], 'align'=>"C", 'border'=>"LRTB"),
									array('width'=>"3%", 'data'=>$totals['childBeds'], 'align'=>"C", 'border'=>"LRTB")
								);
							}
							array_push($revBedNightRow,
								array('width'=>"4%", 'data'=>$totals['totalBeds'], 'align'=>"C", 'border'=>"LRTB")
							);
							array_push($revAmountRow,
								array('width'=>$dateSize, 'data'=>$totals['actualRevenue'], 'align'=>"C", 'border'=>"LRTB")
							);
							array_push($revAverageRow,
								array('width'=>$dateSize, 'data'=>$totals['revenueNights'], 'align'=>"C", 'border'=>"LRTB")
							);

						/*	array_push($revBedNightRow,$totals['adultBeds'],$totals['childBeds'],$totals['totalBeds']);
							array_push($revAmountRow,$totals['actualRevenue'],'','');
							array_push($revAverageRow,$totals['revenueNights'],'','');*/
						} else {
							if($showRoomConfig == "1") {			
								array_push($revBedNightRow,
									array('width'=>"3%", 'data'=>$item['grandTotal']['adultBeds'], 'align'=>"C", 'border'=>"LRTB"),
									array('width'=>"3%", 'data'=>$item['grandTotal']['childBeds'], 'align'=>"C", 'border'=>"LRTB")
								);
							}
							array_push($revBedNightRow,
								array('width'=>"5%", 'data'=>$item['grandTotal']['totalBeds'], 'align'=>"C", 'border'=>"LRTB"),
								array('width'=>"4%", 'data'=>$item['grandTotal']['percTotal'], 'align'=>"C", 'border'=>"LRTB")
							);
							array_push($revAmountRow,
								array('width'=>$totalSize, 'data'=>$item['grandTotal']['actualRevenue'], 'align'=>"C", 'border'=>"LRTB"),
								array('width'=>"4%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB")
							);
							array_push($revAverageRow,
								array('width'=>$totalSize, 'data'=>$item['grandTotal']['revenueNights'], 'align'=>"C", 'border'=>"LRTB"),
								array('width'=>"4%", 'data'=>"", 'align'=>"C", 'border'=>"LRTB")
							);
						}
					}
/*					array_push($revBedNightRow,$item['grandTotal']['adultBeds'],$item['grandTotal']['childBeds'],$item['grandTotal']['totalBeds'],$item['grandTotal']['percTotal']);
					array_push($revAmountRow,$item['grandTotal']['actualRevenue']);
					array_push($revAverageRow,$item['grandTotal']['revenueNights']);
					array_push($csvFile,$revBedNightRow);
					array_push($csvFile,$revAmountRow);
					array_push($csvFile,$revAverageRow);*/

					$pdf->Row($revBedNightRow);
					$pdf->Row($revAmountRow);
					$pdf->Row($revAverageRow);
					
				}
			}
			
			$pdf->Ln(4);
		}

		$pdf->ReportHeader($reportLabel, $headerArray, "55%");	

		if($renderOption == 1) {
			$pdf->OutPut();
			die();
		}
		if($renderOption == 3) {
			$to = $_POST['mail_to'];
			$from = $_POST['mail_from'];
			$subject = $_POST['mail_subj'];
			$message = $_POST['mail_body'];
			$attachmentName = $_POST['attachmentName'];

			$headers = "From: ".$GLOBALS['princName']."<$from>\r\n";
	
			// close the pdf
			if($pdf->state<3) $pdf->Close();

			/* and now mail it */
			if($attachmentName != "!attachmentName!") {
				$pdfName = $attachmentName;
			} else {
				$pdfName = "Update report from $fromDate to $toDate.pdf";
			}

			$error = email($from, $to, $subject, $headers, $message, 0, 0, $_SERVER['argv'][1], $GLOBALS['princName'],$pdf->buffer,$pdfName);     // (from, to, subject, headers, message, action, emailID, resID)
			if(!$error) {
				echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
				die();
			} else {
				echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
				die();
			}
		}
	}

	if($renderOption == 4) {  //csv
		$rateOverrideFilter = "None";
		if(!empty($rateOverride)) {
			switch($rateOverrideType) {
			default:
			case "excludeRes":
				$rateOverrideFilter = "Exclude overrides";
				break;
			case "includeRes":
				$rateOverrideFilter = "Reservations including overrides only";
				break;
			case "excludeItem":
				$rateOverrideFilter = "Itinerary items with overrides only";
				break;
			case "includeItem":
				$rateOverrideFilter = "Itinerary items without overrides only";
				break;
			}			
		}		

		$amountOverrideFilter = "None";
		if(!empty($amountOverride)) {
			switch($amountOverrideType) {
			default:
			case "excludeRes":
				$amountOverrideFilter = "Exclude overrides";
				break;
			case "includeRes":
				$amountOverrideFilter = "Reservations including overrides only";
				break;
			case "excludeItem":
				$amountOverrideFilter = "Itinerary items with overrides only";
				break;
			case "includeItem":
				$amountOverrideFilter = "Itinerary items without overrides only";
				break;
			}			
		}		

		$csvFile = array();
		$headerLine = array();
		array_push($csvFile,array($title));
		array_push($csvFile,array());
		array_push($csvFile,array("Date range",$fromDate . " to " . $toDate));
		array_push($csvFile,array("Property / Accommodation",$accommFilter['names']));
		array_push($csvFile,array("Agent",$agentFilter['names']));
		array_push($csvFile,array("Agent country",$agentCountryFilter['names']));
		array_push($csvFile,array("Status",$statusFilter['names']));
		array_push($csvFile,array("Exclude expired provisionals",($excludeExpired=="1"?"Yes":"No")));
		array_push($csvFile,array("Consultant",$consultantFilter['names']));
		array_push($csvFile,array("Originator",$originatorFilter['names']));
		array_push($csvFile,array("Source",$sourceFilter['names']));
		array_push($csvFile,array("Nationality",$nationalityFilter['names']));
		array_push($csvFile,array("Rate",$rateFilter['names']));
		array_push($csvFile,array("Rate type override filter",$rateOverrideFilter));
		array_push($csvFile,array("Rate amount override filter",$amountOverrideFilter));
		array_push($csvFile,array("Include Revenue",($showRevenueOption=="1"?"Yes":"No")));
		array_push($csvFile,array("Include adult / child count",($showRoomConfig=="1"?"Yes":"No")));
		array_push($csvFile,array("Group by",$groupByName));
		array_push($csvFile,array());
		
		$dateRow1 = array('');
		$dateRow2 = array('');
		foreach($dateArray as $dateItem) {
			list($year,$month,$day) = explode("-",$dateItem['start']);
			$monthFmt = date("F Y",mktime(0,0,0,$month,$day,$year));
			if($showRoomConfig == "1") {						
				array_push($dateRow1,$monthFmt,'','');
				array_push($dateRow2,'Adults','Children','Total');
			} else {
				array_push($dateRow1,$monthFmt);
				array_push($dateRow2,'Total');
			}
		}
		if($showRoomConfig == "1") {						
			array_push($dateRow1,'Total','','','% of potential');
			array_push($dateRow2,'Adults','Children','Total','');
		} else {
			array_push($dateRow1,'Total','% of potential');
			array_push($dateRow2,'Total','');
		}

		array_push($csvFile,$dateRow1);
		array_push($csvFile,$dateRow2);


		foreach($bedNightGrid as $id=>$item) {
			$name = $item['name'];
			$row = array($name);
			foreach($item as $totalId=>$totals) {
				if($totalId !== "grandTotal" && $totalId !== "name" && $totalId !== "id") {
					$adult = $totals['adultBeds'];
					$child = $totals['childBeds'];
					$total = $totals['totalBeds'];
					if($showRoomConfig == "1") {						
						array_push($row,$adult,$child,$total);
					} else {
						array_push($row,$total);
					}
				}
			}
			if($showRoomConfig == "1") {						
				array_push($row,$item['grandTotal']['adultBeds'],$item['grandTotal']['childBeds'],$item['grandTotal']['totalBeds'],$item['grandTotal']['percTotal']);
			} else {
				array_push($row,$item['grandTotal']['totalBeds'],$item['grandTotal']['percTotal']);
			}
			array_push($csvFile,$row);
		}
		array_push($csvFile,array());


		$monthTotalRow = array('Total occupied');
		$occupiedPercRow = array('% Occupancy');
		foreach($monthTotals as $monthKey=>$monthItem) {
			if($monthKey !== "grandTotal") {
				$adult = $monthItem['adultBeds'];
				$child = $monthItem['childBeds'];
				$total = $monthItem['totalBeds'];
				$perc = $monthItem['percMonth'];
				if($showRoomConfig == "1") {						
					array_push($monthTotalRow,$adult,$child,$total);
					array_push($occupiedPercRow,'','',$perc);
				} else {
					array_push($monthTotalRow,$total);
					array_push($occupiedPercRow,$perc);
				}
			}
		}
		if($showRoomConfig == "1") {						
			array_push($monthTotalRow,$monthTotals['grandTotal']['adultBeds'],$monthTotals['grandTotal']['childBeds'],$monthTotals['grandTotal']['totalBeds'],$monthTotals['grandTotal']['percTotal']);
			array_push($occupiedPercRow,'','',$monthTotals['grandTotal']['percTotal'],'');
		} else {
			array_push($monthTotalRow,$monthTotals['grandTotal']['totalBeds'],$monthTotals['grandTotal']['percTotal']);
			array_push($occupiedPercRow,$monthTotals['grandTotal']['percTotal'],'');
		}

		$roomNightRow = array('Total room nights');
		$blockRow = array('Blocked room nights');
		$potentialBedNightRow = array('Potential bed nights');
		foreach($potentialArray as $potentialItem) {
			if($showRoomConfig == "1") {						
				array_push($roomNightRow,'','',$potentialItem['roomCount']);
				array_push($blockRow,'','',$potentialItem['blockCount']);
				array_push($potentialBedNightRow,'','',$potentialItem['potentialBedNight']);
			} else {
				array_push($roomNightRow,$potentialItem['roomCount']);
				array_push($blockRow,$potentialItem['blockCount']);
				array_push($potentialBedNightRow,$potentialItem['potentialBedNight']);
			}
		}
		if($showRoomConfig == "1") {						
			array_push($roomNightRow,'','',$roomCountTotal,'');
			array_push($blockRow,'','',$blockCountTotal,'');
			array_push($potentialBedNightRow,'','',$potentialBedNightTotal,'');
		} else {
			array_push($roomNightRow,$roomCountTotal,'');
			array_push($blockRow,$blockCountTotal,'');
			array_push($potentialBedNightRow,$potentialBedNightTotal,'');
		}
		

		array_push($csvFile,$monthTotalRow);
		array_push($csvFile,array('Potential'));
		array_push($csvFile,$roomNightRow);
		array_push($csvFile,$blockRow);
		array_push($csvFile,$potentialBedNightRow);
		array_push($csvFile,$occupiedPercRow);		
		array_push($csvFile,array());

		if($showRevenueOption == "1") {
			array_push($csvFile,array('Revenue'));
			foreach($revenueGrid as $id=>$item) {
				$revBedNightRow = array("$id Bednights");
				$revAmountRow = array("$id Revenue");
				$revAverageRow = array("$id Rev / Bed nts");
				foreach($item as $totalKey=>$totals) {
					if($totalKey !== "grandTotal" && $totalKey !== "name" && $totalKey !== "id") {
						if($showRoomConfig == "1") {						
							array_push($revBedNightRow,$totals['adultBeds'],$totals['childBeds'],$totals['totalBeds']);
							array_push($revAmountRow,$totals['actualRevenue'],'','');
							array_push($revAverageRow,$totals['revenueNights'],'','');
						} else {
							array_push($revBedNightRow,$totals['totalBeds']);
							array_push($revAmountRow,$totals['actualRevenue']);
							array_push($revAverageRow,$totals['revenueNights']);
						}
					}
				}
				if($showRoomConfig == "1") {						
					array_push($revBedNightRow,$item['grandTotal']['adultBeds'],$item['grandTotal']['childBeds'],$item['grandTotal']['totalBeds'],$item['grandTotal']['percTotal']);
				} else {
					array_push($revBedNightRow,$item['grandTotal']['totalBeds'],$item['grandTotal']['percTotal']);
				}
				array_push($revAmountRow,$item['grandTotal']['actualRevenue']);
				array_push($revAverageRow,$item['grandTotal']['revenueNights']);
				array_push($csvFile,$revBedNightRow);
				array_push($csvFile,$revAmountRow);
				array_push($csvFile,$revAverageRow);
			}
			array_push($csvFile,array());
		}
		
		$csvText = "";
		foreach($csvFile as $csvLine) {
			$first = true;
			foreach($csvLine as $csvItem) {
				if(!$first) {
					$csvText .= ",";
				} else {
					$first = false;
				}
				$csvText .= "\"".str_replace("\"","\"\"",$csvItem)."\"";
			}
			$csvText .= "\n";
		}
		//header('Content-Type: text/plain');
		//echo "<PRE>";
		//print_r($csvText);
		//echo $csvText;
		//die();
		if(headers_sent()) {
			//    echo('Some data has already been output to browser, can\'t send PDF file');
		}
		$fileName = str_replace(" ","_",strtolower($title))."_".str_replace(" ","_",chng_date(date("Y-m-d"),"-")).".csv";
		
		header('Content-Type: text/csv');
		header("Cache-control: private");
		header('Content-Length: '.strlen($csvText));
		header("Content-Disposition: inline; filename=".$fileName);
		echo $csvText;
		flush();
		die();
	}
} else {
	$GLOBALS['temp']['reportGenerated'] = " class=\"collapse\" ";
}

function getPersonaFax($personaId) {
   $fax = $GLOBALS['lDB']->get("
      SELECT
         pr_phone.pr_phone_number
      FROM
         pr_phone, rf_phone_type
      WHERE
         pr_phone.pr_persona_id = '" . $personaId . "'
         AND pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
         AND rf_phone_type.rf_phone_type_sys_code = '1'",4);
   if(trim($fax) == "" || $fax == "0") {
      $fax = "";
   }
   return $fax;
}

function getPersonaTelephone($personaId) {
   $tel = $GLOBALS['lDB']->get("
      SELECT
         pr_phone.pr_phone_number
      FROM
         pr_phone
      WHERE
         pr_phone.pr_persona_id = '" . $personaId . "'
         AND pr_phone.pr_default_yn = '1'",4);
   if(trim($tel) == "" || $tel == "0") {
      $tel = "";
   }
   return $tel;
}

function getPersonaDetail($personaId) {
   $detail = $GLOBALS['lDB']->get("
      SELECT
         pr_persona.pr_name_first,
         pr_persona.pr_name_second,
         pr_persona.pr_name_last,
         pr_persona.pr_email
      FROM
         pr_persona
      WHERE
         pr_persona.pr_persona_ix = '".$personaId."'",2);
   $detail = $detail[0];
   $name = "";
   if(trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
      $name .= $detail['pr_name_first'] . " ";
   }
   if(trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
      $name .= $detail['pr_name_second'] . " ";
   }
   if(trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
      $name .= $detail['pr_name_last'] . " ";
   }
   $result = array();
   $result['name'] = trim($name);
   $result['fax'] = getPersonaFax($personaId);
   $result['telephone'] = getPersonaTelephone($personaId);
   $result['email'] = $detail['pr_email'];
   if(trim($result['email']) == "" || $result['email'] == "0") {
      $result['email'] = "";
   }
   return $result;
}
