<?php
/**
 * init.form319.php - Bednights report
 * Job: 247
 * Function: 53
*/


if($_POST['url'] != "") {
   $_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
   $_SERVER['argc'] = sizeof($_SERVER['argv']);
}
if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_bed_nights_pop.htm");
}

$GLOBALS['temp']['url'] = join("+",$_SERVER['argv']);

$_SERVER['argv'] = array_pad($_SERVER['argv'],28,"");

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));
$GLOBALS['temp']['genDate'] = chng_date(date("Y-m-d"),"-")." ".date("H:i:s");

if(trim($_SERVER['argv'][1]) == "" || trim($_SERVER['argv'][2]) == "") {
	$fromDate = date("Y-m") . "-01";
	$toDate = date("Y-m-d",mktime(0,0,0,date("m")+5,0,date("Y")));

	$fromYear = date("Y");
	$toYear = date("Y",mktime(0,0,0,date("m")+5,0,date("Y")));
	$fromMonth = date("M");
	$toMonth = date("M",mktime(0,0,0,date("m")+5,0,date("Y")));

	$GLOBALS['temp']['fromM'] = date("m");
	$GLOBALS['temp']['toM'] = date("m",mktime(0,0,0,date("m")+5,0,date("Y")));
	$GLOBALS['temp']['fromY'] = date("Y");
	$GLOBALS['temp']['toY'] = date("Y",mktime(0,0,0,date("m")+5,0,date("Y")));
	
} else {
	list($fromYear,$fromMonth) = explode("-",$_SERVER['argv'][1]);
	list($toYear,$toMonth) = explode("-",$_SERVER['argv'][2]);

	$fromDate = date("Y-m-d",mktime(0,0,0,$fromMonth,1,$fromYear));
	$toDate = date("Y-m-d",mktime(0,0,0,$toMonth+1,0,$toYear));
	
	$GLOBALS['temp']['fromM'] = $fromMonth;
	$GLOBALS['temp']['toM'] = $toMonth;
	$GLOBALS['temp']['fromY'] = $fromYear;
	$GLOBALS['temp']['toY'] = $toYear;
}

// Create an array of each month's start/end date
$currDate = $fromDate;
$dateArray = array();
while($currDate < $toDate) {
	list($currYear, $currMonth, $currDay) = explode("-",$currDate);
	array_push($dateArray,array(
		"start"=>date("Y-m-d",mktime(0,0,0,$currMonth,1,$currYear)),
		"end"=>date("Y-m-d",mktime(0,0,0,$currMonth+1,0,$currYear))
	));

	$currDate = date("Y-m-d",mktime(0,0,0,$currMonth+1,1,$currYear));
}

$accommACL= $lDB->get("
	SELECT DISTINCT
		ac_accomm_type.ac_accomm_type_ix
	FROM
		sc_accomm, ac_accomm_type
	WHERE
		sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
		AND sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
",3);
$accommFilter = useFilter("accomm",$_SERVER['argv'][4],"SELECT CONCAT(pr_business.pr_bus_name_short,CONCAT(' - ',ac_accomm_type.ac_accomm_desc)) FROM ac_accomm_type INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id WHERE ac_accomm_type_ix =","rv_reservation_item.ac_accomm_type_id",$accommACL,false,false);

$agentACL = false;
if($userStatusId < 2) {
   $agentACL = array($calAgentId);
}
$agentFilter = useFilter("agent",$_SERVER['argv'][6],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_agent_id",$agentACL,"Direct booking","0");
$agentCountryFilter = useFilter("agentCountry",$_SERVER['argv'][7],"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =","pr_ag.pr_corr_country_id",false,false,false);
$agentSelect = $_SERVER['argv'][5];
$GLOBALS['temp']['agentNameRadioChecked'] = "checked";
$GLOBALS['temp']['agentCountryRadioChecked'] = "";
if($agentSelect == "country") {
   $GLOBALS['temp']['agentNameRadioChecked'] = "";
   $GLOBALS['temp']['agentCountryRadioChecked'] = "checked";
   $agentWhere = $agentCountryFilter['where'];
} else {
   $agentWhere = $agentFilter['where'];
}

$statusACL = $lDB->get("
         SELECT
            rf_reservation_status_id
         FROM
            rf_reservation_status
         WHERE
            rf_reservation_status_id <> 25",3);
$statusFilter = useFilter("status",$_SERVER['argv'][8],"SELECT rf_reservation_status.rf_reservation_status_desc FROM rf_reservation_status WHERE rf_reservation_status_id =","rv_reservation.rf_reservation_status_id",$statusACL,false,false);

$excludeExpired = $_SERVER['argv'][24];
$GLOBALS['temp']['excludeExpiredChecked'] = "";
if($excludeExpired == "1") {
	$GLOBALS['temp']['excludeExpiredChecked'] = "checked";
	$statusFilter['where'] .= "
		AND (
			rv_reservation.rf_reservation_status_id != '20'
			OR (
				rv_reservation.rf_reservation_status_id = '20'
				AND rv_reservation.rv_provision_expiry_date >= '".date("Y-m-d")."'
			)
		)
	";
}

$consultantFilter = useFilter("consultant",$_SERVER['argv'][9],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_consultant_id",false,"No consultant","0");
$originatorFilter = useFilter("originator",$_SERVER['argv'][10],"SELECT pr_persona.pr_name_first,pr_persona.pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_origin_agent_id",false,"No originator","0");
$sourceFilter = useFilter("source",$_SERVER['argv'][11],"SELECT rf_source.rf_source_desc FROM rf_source WHERE rf_source_ix =","rv_reservation.rf_source_ix",false,"No source","0");
// 11 is nationality
$nationalityFilter = useFilter("nationality",$_SERVER['argv'][12],"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =","rv_reservation.rf_country_id",false,"No nationality","0");
$nationalityFilter['where'] = "AND ( 1 ".$nationalityFilter['where']." OR rv_reservation.rf_country_id IS NULL )";
$rateFilter = useFilter("rate",$_SERVER['argv'][13],"SELECT rt_rate_type_desc FROM rt_rate_type WHERE rv_rate_type_ix=","rv_reservation.rt_rate_type_id",false,false,false);

list($rateOverride,$rateOverrideType,$rateOverrideAgentGranted,$rateOverrideAgentDenied) = explode(":",$_SERVER['argv'][14]);
$GLOBALS['temp']['rateOverrideChecked'] = "";
if(!empty($rateOverride)) {
	$GLOBALS['temp']['rateOverrideChecked'] = "checked";
}
$GLOBALS['temp']['rateOverrideExcludeResChecked'] = "";
$GLOBALS['temp']['rateOverrideIncludeResChecked'] = "";
$GLOBALS['temp']['rateOverrideExcludeItemChecked'] = "";
$GLOBALS['temp']['rateOverrideIncludeItemChecked'] = "";
switch($rateOverrideType) {
default:
case "excludeRes":
	$GLOBALS['temp']['rateOverrideExcludeResChecked'] = "checked";
	break;
case "includeRes":
	$GLOBALS['temp']['rateOverrideIncludeResChecked'] = "checked";
	break;
case "excludeItem":
	$GLOBALS['temp']['rateOverrideExcludeItemChecked'] = "checked";
	break;
case "includeItem":
	$GLOBALS['temp']['rateOverrideIncludeItemChecked'] = "checked";
	break;
}
if(empty($rateOverrideAgentGranted) && empty($rateOverrideAgentDenied)) {
	$rateOverrideAgentGranted = "1";
	$rateOverrideAgentDenied = "1";
}
$GLOBALS['temp']['rateOverrideAgentGrantedChecked'] = "";
if(!empty($rateOverrideAgentGranted)) {
	$GLOBALS['temp']['rateOverrideAgentGrantedChecked'] = "checked";
}
$GLOBALS['temp']['rateOverrideAgentDeniedChecked'] = "";
if(!empty($rateOverrideAgentDenied)) {
	$GLOBALS['temp']['rateOverrideAgentDeniedChecked'] = "checked";
}

list($amountOverride,$amountOverrideType) = explode(":",$_SERVER['argv'][15]);
$GLOBALS['temp']['amountOverrideChecked'] = "";
if(!empty($amountOverride)) {
	$GLOBALS['temp']['amountOverrideChecked'] = "checked";
}
$GLOBALS['temp']['amountOverrideExcludeResChecked'] = "";
$GLOBALS['temp']['amountOverrideIncludeResChecked'] = "";
$GLOBALS['temp']['amountOverrideExcludeItemChecked'] = "";
$GLOBALS['temp']['amountOverrideIncludeItemChecked'] = "";
switch($amountOverrideType) {
default:
case "excludeRes":
	$GLOBALS['temp']['amountOverrideExcludeResChecked'] = "checked";
	break;
case "includeRes":
	$GLOBALS['temp']['amountOverrideIncludeResChecked'] = "checked";
	break;
case "excludeItem":
	$GLOBALS['temp']['amountOverrideExcludeItemChecked'] = "checked";
	break;
case "includeItem":
	$GLOBALS['temp']['amountOverrideIncludeItemChecked'] = "checked";
	break;
}

$showRevenueOption = $_SERVER['argv'][16];
$GLOBALS['temp']['showRevenueChecked'] = "";
$GLOBALS['temp']['revenueDivClass'] = "collapse";
if($showRevenueOption == "1") {
	$GLOBALS['temp']['showRevenueChecked'] = " checked ";
	$GLOBALS['temp']['revenueDivClass'] = "";
}

$groupByOption = $_SERVER['argv'][18];

$GLOBALS['temp']['groupByAll'] = "";
$GLOBALS['temp']['groupByProperty'] = "";
$GLOBALS['temp']['groupByAccomm'] = "";
$GLOBALS['temp']['groupByAgent'] = "";
$GLOBALS['temp']['groupByContact'] = "";
$GLOBALS['temp']['groupBySource'] = "";
$GLOBALS['temp']['groupByOriginator'] = "";
$GLOBALS['temp']['groupByConsultant'] = "";
$GLOBALS['temp']['groupByNationality'] = "";
$GLOBALS['temp']['groupByStatus'] = "";

$sqlGroupSelect = "";
$sqlFrom = "";
$sqlGroupJoin = "";
$sqlWhere = "";

switch($groupByOption) {
case "all":
	$GLOBALS['temp']['groupByAll'] = "selected";
	$sqlOrderBy = "";
	$blankDesc = "All";
	$sqlGroupSelect = "
		'' as id,
		'All' as name
	";
	$sqlGroupWhere = "";
	break;
case "property":
	$GLOBALS['temp']['groupByProperty'] = "selected";
	$sqlOrderBy = "ORDER BY rv_reservation_item.pr_business_id";
	$sqlGroupSelect = "
			rv_reservation_item.pr_business_id as id,
			groupTable.pr_name_last as name
	";
	$sqlGroupJoin = "
		INNER JOIN pr_persona as groupTable ON groupTable.pr_persona_ix = rv_reservation_item.pr_business_id
	";
	$blankDesc = "Unknown Property";
	$sqlGroupWhere = "groupTable.pr_persona_ix";
	break;
case "accomm":
	$GLOBALS['temp']['groupByAccomm'] = "selected";
	$sqlOrderBy = "ORDER BY rv_reservation_item.ac_accomm_type_id";
	$sqlGroupSelect = "
			rv_reservation_item.ac_accomm_type_id as id,
			CONCAT(groupTable2.pr_bus_name_short,CONCAT(' - ',groupTable.ac_accomm_desc)) as name
	";
	$sqlGroupJoin = "
		INNER JOIN ac_accomm_type as groupTable ON groupTable.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
		INNER JOIN pr_business as groupTable2 ON groupTable2.pr_business_id = groupTable.pr_business_id
	";
	$blankDesc = "Unknown Accommodation";
	$sqlGroupWhere = "groupTable.ac_accomm_type_ix";
	break;
case "agent":
	$GLOBALS['temp']['groupByAgent'] = "selected";
	$sqlOrderBy = "ORDER BY rv_reservation.rv_agent_id";
	$sqlGroupSelect = "
			rv_reservation.rv_agent_id as id,
			groupTable.pr_name_last as name
	";
	$sqlGroupJoin = "
		LEFT JOIN pr_persona as groupTable ON groupTable.pr_persona_ix = rv_reservation.rv_agent_id
	";
	$blankDesc = "Direct";
	$sqlGroupWhere = "groupTable.pr_persona_ix";
	break;
case "contact":
	$GLOBALS['temp']['groupByContact'] = "selected";
	$sqlOrderBy = "ORDER BY rv_reservation.rv_corr_persona_id";
	$sqlGroupSelect = "
			rv_reservation.rv_corr_persona_id as id,
			groupTable.pr_name_first as name1,
			groupTable.pr_name_last as name2
	";
	$sqlGroupJoin = "
		LEFT JOIN pr_persona as groupTable ON groupTable.pr_persona_ix = rv_reservation.rv_corr_persona_id
	";
	$blankDesc = "No contact";
	$sqlGroupWhere = "groupTable.pr_persona_ix";
	break;
case "source":
	$GLOBALS['temp']['groupBySource'] = "selected";
	$sqlOrderBy = "ORDER BY rv_reservation.rf_source_ix";
	$sqlGroupSelect = "
			rv_reservation.rf_source_ix as id,
			groupTable.rf_source_desc as name
	";
	$sqlGroupJoin = "
		LEFT JOIN rf_source as groupTable ON groupTable.rf_source_ix = rv_reservation.rf_source_ix
	";
	$blankDesc = "No Source";
	$sqlGroupWhere = "groupTable.rf_source_ix";
	break;
case "originator":
	$GLOBALS['temp']['groupByOriginator'] = "selected";
	$sqlOrderBy = "ORDER BY rv_reservation.rv_origin_agent_id";
	$sqlGroupSelect = "
			groupTable.pr_persona_ix as id,
			groupTable.pr_name_last as name
	";
	$sqlGroupJoin = "
		LEFT JOIN pr_persona as groupTable ON groupTable.pr_persona_ix = rv_reservation.rv_origin_agent_id
	";
	$blankDesc = "No Originator";
	$sqlGroupWhere = "groupTable.pr_persona_ix";
	break;
case "consultant":
	$GLOBALS['temp']['groupByConsultant'] = "selected";
	$sqlOrderBy = "ORDER BY rv_reservation.rv_consultant_id";
	$sqlGroupSelect = "
			rv_reservation.rv_consultant_id as id,
			groupTable.pr_name_last as name
	";
	$sqlGroupJoin = "
		INNER JOIN pr_persona as groupTable ON groupTable.pr_persona_ix = rv_reservation.rv_consultant_id
	";
	$blankDesc = "No Consultant";
	$sqlGroupWhere = "groupTable.pr_persona_ix";
	break;
case "nationality":
	$GLOBALS['temp']['groupByNationality'] = "selected";
	$sqlOrderBy = "ORDER BY rv_reservation.rf_country_id";
	$sqlGroupSelect = "
			groupTable.rf_country_ix as id,
			groupTable.rf_country_name as name
	";
	$sqlGroupJoin = "
		LEFT JOIN rf_country as groupTable ON groupTable.rf_country_ix = rv_reservation.rf_country_id
	";
	$blankDesc = "No Nationality";
	$sqlGroupWhere = "groupTable.rf_country_ix";
	break;
case "status":
	$GLOBALS['temp']['groupByStatus'] = "selected";
	$sqlOrderBy = "ORDER BY rv_reservation.rf_country_id";
	$sqlGroupSelect = "
			groupTable.rf_reservation_status_id as id,
			groupTable.rf_reservation_status_desc as name
	";
	$sqlGroupJoin = "
		INNER JOIN rf_reservation_status as groupTable ON groupTable.rf_reservation_status_id  = rv_reservation.rf_reservation_status_id 
	";
	$blankDesc = "No Status";
	$sqlGroupWhere = "groupTable.rf_reservation_status_id";
	break;
case "resname":
	$GLOBALS['temp']['groupByResName'] = "selected";
	$sqlOrderBy = "ORDER BY rv_reservation.rv_res_name";
	$sqlGroupSelect = "
			rv_reservation.rv_reservation_ix as id,
			rv_reservation.rv_res_name as name
	";
	$sqlGroupJoin = "";
	$blankDesc = "No reservation name";
	$sqlGroupWhere = "rv_reservation.rv_reservation_ix";
	break;
case "resno":
	$GLOBALS['temp']['groupByResNo'] = "selected";
	$sqlOrderBy = "ORDER BY rv_reservation.rv_reservation_ix";
	$sqlGroupSelect = "
			rv_reservation.rv_reservation_ix as id,
			rv_reservation.rv_reservation_ix as name
	";
	$sqlGroupJoin = "";
	$blankDesc = "No reservations";
	$sqlGroupWhere = "rv_reservation.rv_reservation_ix";
	break;	
}


$sqlFrom = "
	FROM
		rv_reservation_item
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
		INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rv_reservation.rv_invoice_currency_id
		INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
		INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		LEFT JOIN pr_persona AS agent ON agent.pr_persona_ix = rv_reservation.rv_agent_id
		LEFT JOIN rf_reservation_status AS status ON status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
		LEFT JOIN pr_persona AS consultant ON consultant.pr_persona_ix = rv_reservation.rv_consultant_id
		LEFT JOIN pr_persona AS originator ON originator.pr_persona_ix = rv_reservation.rv_origin_agent_id
		LEFT JOIN rf_source AS source ON source.rf_source_ix = rv_reservation.rf_source_ix
		LEFT JOIN rf_country AS country ON country.rf_country_ix = rv_reservation.rf_country_id
";


if($_SERVER['argv'][25] == "row") {
	$sqlWhere = "
		WHERE
			(
				(rv_reservation_item.rv_item_date_arrive >= '$fromDate' AND rv_reservation_item.rv_item_date_arrive <= '$toDate')
				OR (rv_reservation_item.rv_item_date_depart >= '$fromDate' AND rv_reservation_item.rv_item_date_depart <= '$toDate')
				OR (rv_reservation_item.rv_item_date_arrive < '$fromDate' AND rv_reservation_item.rv_item_date_depart > '$toDate')
			)
			$accommFilter[where] $agentWhere $statusFilter[where] $consultantFilter[where] $originatorFilter[where] $sourceFilter[where] $nationalityFilter[where] $rateFilter[where]	
	";
	if($sqlGroupWhere != "") {
		if($_SERVER['argv'][26] != "0") {
			$sqlWhere .= "
				AND $sqlGroupWhere = '".$_SERVER['argv'][26]."'
			";
		} else {
			$sqlWhere .= "
				AND (
					$sqlGroupWhere IS NULL
					OR trim($sqlGroupWhere) = ''
					OR $sqlGroupWhere = '0'
				)
			";			
		}
	}
} elseif($_SERVER['argv'][25] == "col") {
	$fromDate = $_SERVER['argv'][26];
	list($year,$month,$day) = explode("-",$fromDate);
	$toDate = date("Y-m-d",mktime(0,0,0,$month+1,0,$year));
	$sqlWhere = "
		WHERE
			(
				(rv_reservation_item.rv_item_date_arrive >= '$fromDate' AND rv_reservation_item.rv_item_date_arrive <= '$toDate')
				OR (rv_reservation_item.rv_item_date_depart >= '$fromDate' AND rv_reservation_item.rv_item_date_depart <= '$toDate')
				OR (rv_reservation_item.rv_item_date_arrive < '$fromDate' AND rv_reservation_item.rv_item_date_depart > '$toDate')
			)
			$accommFilter[where] $agentWhere $statusFilter[where] $consultantFilter[where] $originatorFilter[where] $sourceFilter[where] $nationalityFilter[where] $rateFilter[where]	
	";	
}
$GLOBALS['temp']['fromPeriodName'] = chng_date($fromDate,"-");
$GLOBALS['temp']['toPeriodName'] = chng_date($toDate,"-");

$renderOption = $_SERVER['argv'][27];
if($renderOption == "") { $renderOption = 0; }


if($renderOption == 2) {
	$pdfName = "Bed Nights Report from  " . chng_date($fromDate,"-") . " to " . chng_date($toDate,"-");
	$attachmentTable = "
		<table border=\"0\" cellspacing=\"0\" width=\"100%\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\"></td>
			<td id=\"attachmentLabel\" width=\"100%\">$pdfName.pdf</td>
		</tr>
		</table>
	";
	$newOptions = ($renderOption & ~3) + 3;
	$formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,27))."+$newOptions";

	$GLOBALS[$form]->FormHTML =   str_replace("!formAction!",$formAction,
		str_replace("!attachmentInfo!",$attachmentTable,
		str_replace("!attachmentName!",$pdfName.".pdf",
		str_replace("!hasAttachment!","expand",
		str_replace("!emailBody!","",
		str_replace("!emailSubject!",$pdfName,
		Join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));
	// get principal
	$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
	$principalInfo = getPersonaDetail($principalId);
	$resOfficeInfo = getPersonaDetail($resOfficeId);

	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	$GLOBALS['temp']['princName'] = $principalInfo['name'];
	$GLOBALS['temp']['fax'] = $resOfficeInfo['fax'];
	$GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
	$userId = $_SESSION['userid'];
	$GLOBALS['temp']['emailFrom'] = $lDB->get("
		SELECT
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '".$userId."'
	", 4);
	$GLOBALS['temp']['emailTo'] = "";
}



$list = $lDB->get("
	SELECT
		rv_reservation.rv_reservation_ix,
		rv_reservation.rv_res_name,
		rv_reservation.rv_invoice_currency_id,
		rf_currency.rf_currency_symbol,
		rv_reservation_item.rv_reservation_item_ix,
		rv_reservation_item.rv_item_date_arrive,
		rv_reservation_item.rv_item_date_depart,
		rv_reservation_item.rv_item_accomm_count,
		rv_reservation_item.rv_item_adult_count,
		rv_reservation_item.rv_item_child_count,
		rv_reservation_item.rv_item_amt_nett,
		rv_reservation_item.rv_item_amt_tax,
		pr_business.pr_bus_name_short,
		ac_accomm_type.ac_accomm_name_short,
		agent.pr_name_last as agent_name,
		status.rf_reservation_status_desc,
		consultant.pr_name_first as consultant_name_first,
		consultant.pr_name_last as consultant_name_last,
		originator.pr_name_first as originator_name_first,
		originator.pr_name_last as originator_name_last,
		source.rf_source_desc as source_name,
		country.rf_country_name as country_name,
		$sqlGroupSelect
	$sqlFrom
	$sqlGroupJoin
	$sqlWhere
",2);

function reservationHasRateOverride($rv_reservation_id) {
	global $lDB;

	$rt_rate_type_id = $lDB->get("SELECT rt_rate_type_id FROM rv_reservation WHERE rv_reservation_ix = '$rv_reservation_id'",4);

	$count = $lDB->get("
		SELECT
			COUNT(*)
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.rt_rate_type_id != '$rt_rate_type_id'
			AND rv_reservation_item.rv_reservation_id = '$rv_reservation_id'
	",4);
	if($count > 0) {
		return true;
	} else {
		return false;
	}
}

function reservationItemHasRateOverride($rv_reservation_item_id) {
	global $lDB;

	$res_rate_type_id = $lDB->get("
		SELECT
			rv_reservation.rt_rate_type_id
		FROM 
			rv_reservation_item
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
		WHERE
			rv_reservation_item.rv_reservation_item_ix = '$rv_reservation_item_id'
	",4);

	$item_rate_type_id = $lDB->get("
		SELECT
			rv_reservation_item.rt_rate_type_id
		FROM 
			rv_reservation_item
		WHERE
			rv_reservation_item.rv_reservation_item_ix = '$rv_reservation_item_id'
	",4);

	if($res_rate_type_id != $item_rate_type_id) {
		return true;
	} else {
		return false;
	}
}

function reservationHasOverride($rv_reservation_id) {
	global $lDB;
	$overrideComponentId = $lDB->get("SELECT rt_component_ix FROM rt_component WHERE ac_cmp_sys_code = '5'",4);

	$overrideCount = $lDB->get("
		SELECT
			COUNT(*)
		FROM
			rv_reservation
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
			INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
		WHERE
			rv_reservation.rv_reservation_ix = '" . $rv_reservation_id . "'
			AND (
				rv_res_item_comp.rt_component_id = '" . $overrideComponentId . "'
				OR rv_res_item_comp.rv_item_comp_var <> 0
			)
	",4);
	if($overrideCount > 0) {
		return true;
	} else {
		return false;
	}
}

function reservationItemHasOverride($rv_reservation_item_id) {
	global $lDB;
	$overrideComponentId = $lDB->get("SELECT rt_component_ix FROM rt_component WHERE ac_cmp_sys_code = '5'",4);

	$overrideCount = $lDB->get("
		SELECT
			COUNT(*)
		FROM
			rv_reservation_item
			INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
		WHERE
			rv_reservation_item.rv_reservation_item_ix = '" . $rv_reservation_item_id . "'
			AND (
				rv_res_item_comp.rt_component_id = '" . $overrideComponentId . "'
				OR rv_res_item_comp.rv_item_comp_var <> 0
			)
	",4);
	if($overrideCount > 0) {
		return true;
	} else {
		return false;
	}
}

function reservationHasAgentRateOverride($rv_reservation_id) {
	global $lDB;

	$pr_agent_id = $lDB->get("SELECT rv_agent_id FROM rv_reservation WHERE rv_reservation_ix = '$rv_reservation_id'",4);

	$check = $lDB->get("SELECT COUNT(*) FROM pr_agent WHERE pr_agent_id = '$pr_agent_id'",4);
	if($check > 0) {
		$allowRateList = $lDB->get("SELECT rt_rate_type_id FROM pr_agent_rate WHERE pr_agent_id = '$pr_agent_id'",3);
	} else {
		$allowRateList = $lDB->get("SELECT rf_default_rate_id FROM rf_default_rate",3);
	}
	
	$itemRateList = $lDB->get("SELECT DISTINCT rt_rate_type_id FROM rv_reservation_item WHERE rv_reservation_id = '$rv_reservation_id'",3);

	$check = array_diff($itemRateList,$allowRateList);
	if(sizeof($check) > 0) {
		return true;
	} else {
		return false;
	}
}

function reservationItemHasAgentRate($rv_reservation_item_id) {
	global $lDB;

	$pr_agent_id = $lDB->get("SELECT rv_agent_id FROM rv_reservation WHERE rv_reservation_ix = '$rv_reservation_id'",4);

	$check = $lDB->get("SELECT COUNT(*) FROM pr_agent WHERE pr_agent_id = '$pr_agent_id'",4);
	if($check > 0) {
		$allowRateList = $lDB->get("SELECT rt_rate_type_id FROM pr_agent_rate WHERE pr_agent_id = '$pr_agent_id'",3);
	} else {
		$allowRateList = $lDB->get("SELECT rf_default_rate_id FROM rf_default_rate",3);
	}
	
	$itemRateList = $lDB->get("SELECT DISTINCT rt_rate_type_id FROM rv_reservation_item WHERE rv_reservation_item_ix = '$rv_reservation_item_id'",3);

	$check = array_diff($itemRateList,$allowRateList);
	if(sizeof($check) > 0) {
		return true;
	} else {
		return false;
	}
}

$newList = array();
foreach($list as $item) {
	if(!empty($rateOverride)) {
		switch($rateOverrideType) {
		default:
		case "excludeRes":
			$check = !reservationHasRateOverride($item['rv_reservation_ix']);
			break;
		case "includeRes":
			$check = reservationHasRateOverride($item['rv_reservation_ix']);
			break;
		case "excludeItem":
			$check = !reservationItemHasRateOverride($item['rv_reservation_item_ix']);
			break;
		case "includeItem":
			$check = reservationItemHasRateOverride($item['rv_reservation_item_ix']);
			break;
		}
		if(!$check) { continue; }

		if(empty($rateOverrideAgentGranted) || empty($rateOverrideAgentDenied)) {
			switch($rateOverrideType) {
			default:
			case "excludeRes":						
			case "includeRes":
				$check = reservationHasAgentRateOverride($item['rv_reservation_ix']);
				break;
			case "excludeItem":
			case "includeItem":
				$check = reservationItemHasAgentRate($item['rv_reservation_item_ix']);
				break;
			}
			if(!empty($rateOverrideAgentGranted)) { $check = !$check; }
			if(!$check) { continue; }
		}
	}
	
	if(!empty($amountOverride)) {
		switch($amountOverrideType) {
		default:
		case "excludeRes":
			$check = !reservationHasOverride($item['rv_reservation_ix']);
			break;
		case "includeRes":
			$check = reservationHasOverride($item['rv_reservation_ix']);
			break;
		case "excludeItem":
			$check = !reservationItemHasOverride($item['rv_reservation_item_ix']);
			break;
		case "includeItem":
			$check = reservationItemHasOverride($item['rv_reservation_item_ix']);
			break;
		}
		if(!$check) { continue; }
	}
	array_push($newList,$item);	
}
$list = $newList;

$totalNights = 0;
$totalIncNights = 0;
$totalRooms = 0;
$totalAdults = 0;
$totalChildren = 0;
$totalTotal = 0;
$totalBedNights = 0;
$totalIncBedNights = 0;

foreach($list as $key=>$item) {
	if($item['agent_name'] == "") { $list[$key]['agent_name'] = "Direct"; }
	
	$consultantName = trim($item['consultant_name_first'] . " " . $item['consultant_name_last']);
	if($consultantName == "") { $consultantName = "No consultant"; }
	$list[$key]['consultant_name'] = $consultantName;
	
	$originatorName = trim($item['originator_name_first'] . " " . $item['originator_name_last']);
	if($originatorName == "") { $originatorName = "No originator"; }
	$list[$key]['originator_name'] = $originatorName;

	if($item['source_name'] == "") { $list[$key]['source_name'] = "No source"; }

	if($item['country_name'] == "") { $list[$key]['country_name'] = "No country"; }
	

	//Check dates
	$arrive = $item['rv_item_date_arrive'];
	$depart = $item['rv_item_date_depart'];

	if($arrive < $fromDate) { $arrive = $fromDate; }
	if($depart > $toDate) {
		list($year,$month,$day) = explode("-",$toDate);
		$depart = date("Y-m-d",mktime(0,0,0,$month,$day+1,$year));
	}
	
	$dateArrive = chng_date($item['rv_item_date_arrive'],"-");
	$dateDepart = chng_date($item['rv_item_date_depart'],"-");
	$nights = dateSubtract($dateDepart,$dateArrive);
	$incNights = dateSubtract($depart,$arrive);

	$revenue = ( $item['rv_item_amt_nett'] - $item['rv_item_amt_tax'] );
	if($nights != 0) {
		$incRevenue = $revenue / $nights * $incNights;
	} else {
		$incRevenue = 0;
	}

	fixAmtDisplay($revenue,2);
	fixAmtDisplay($incRevenue,2);

	$list[$key]['revenue'] = $revenue;
	$list[$key]['incRevenue'] = $incRevenue;

	$list[$key]['nights'] = $nights;
	$list[$key]['incNights'] = $incNights;

	$rooms = $item['rv_item_accomm_count'];
	$adult = $item['rv_item_adult_count'];
	$child = $item['rv_item_child_count'];
	$total = $adult + $child;
	$bedNights = $total * $rooms * $nights;
	$incBedNights = $total * $rooms * $incNights;

	$totalNights += $nights;
	$totalIncNights += $incNights;
	$totalRooms += $rooms;
	$totalAdults += $adult;
	$totalChildren += $child;
	$totalTotal += $total;
	$totalBedNights += $bedNights;
	$totalIncBedNights += $incBedNights;
}

if($renderOption == 0) {
	// Enable scroll set
	$resScrollSet = array();

	$rows = "";
	//debug($list);
	foreach($list as $item) {
		$dateArrive = chng_date($item['rv_item_date_arrive'],"-");
		$dateDepart = chng_date($item['rv_item_date_depart'],"-");
		$nights = $item['nights'];
	    $incNights = $item['incNights'];	
		$rooms = $item['rv_item_accomm_count'];
		$adult = $item['rv_item_adult_count'];
		$child = $item['rv_item_child_count'];
		$total = $adult + $child;
		$bedNights = $total * $rooms * $nights;
		$incBedNights = $total * $rooms * $incNights;
		$currency = $item['rf_currency_symbol'];
		$revenue = $item['revenue'];
		$incRevenue = $item['incRevenue'];

		if($nights != $incNights) {
			$incNights = " ($incNights)";
		} else {
			$incNights = "";
		}
		if($bedNights != $incBedNights) {
			$incBedNights = " ($incBedNights)";
		} else {
			$incBedNights = "";
		}
		if($revenue != $incRevenue) {
			$incRevenue = " ($incRevenue)";
		} else {
			$incRevenue = "";
		}
    $agent_name = $item['agent_name'];
    if(strlen($item['agent_name']) > 11) {
      $agent_name = substr($item['agent_name'],0,11) . "...";
    }
    	array_push($resScrollSet,$item['rv_reservation_ix']);
	    $resJob = "0";
		if (canEditReservation($item['rv_reservation_ix'])) {
			$resJob = "2";
		}
   		$rows .= "
			<tr valign=\"top\" class=\"imgLink\" onclick=\"opener.location = 'reservation.php?$resJob+$item[rv_reservation_ix]'; window.close();\" onmouseover=\"this.style.backgroundColor = '#CCFFCC'\"  onmouseout=\"this.style.backgroundColor = ''\">
				<td class=\"br\">$item[rv_reservation_ix]</td>
				<td class=\"br\">$item[rv_res_name]</td>
				<td class=\"br\" align=\"center\">$item[pr_bus_name_short]</td>
				<td class=\"br\" align=\"center\">$item[ac_accomm_name_short]&nbsp;</td>
				<td class=\"br\" align=\"center\">$dateArrive</td>
				<td class=\"br\" align=\"center\">$dateDepart</td>
				<td class=\"br\" align=\"center\">$nights$incNights</td>
				<td class=\"br\" align=\"center\">$rooms</td>
				<td class=\"br\" align=\"center\">$adult</td>
				<td class=\"br\" align=\"center\">$child</td>
				<td class=\"br\" align=\"center\">$total</td>
				<td class=\"br\" align=\"center\">$bedNights$incBedNights</td>
				<td class=\"br\" align=\"center\">$currency</td>
				<td class=\"br\" align=\"center\">$revenue$incRevenue</td>
				<td class=\"br\">$agent_name</td>
				<td class=\"br\">$item[rf_reservation_status_desc]</td>
				<td class=\"br\">$item[consultant_name]</td>
				<td class=\"br\">$item[originator_name]</td>
				<td class=\"br\">$item[source_name]</td>
				<td class=\"br\">$item[country_name]</td>                
			</tr>          
		";
	}
	$GLOBALS['temp']['rows'] = $rows;
	$GLOBALS['temp']['totalNights'] = $totalNights;
	$GLOBALS['temp']['totalIncNights'] = $totalIncNights;
	$GLOBALS['temp']['totalRooms'] = $totalRooms;
	$GLOBALS['temp']['totalAdults'] = $totalAdults;
	$GLOBALS['temp']['totalChildren'] = $totalChildren;
	$GLOBALS['temp']['totalTotal'] = $totalTotal;
	$GLOBALS['temp']['totalBedNights'] = $totalBedNights;
	$GLOBALS['temp']['totalIncBedNights'] = $totalIncBedNights;

	setRecordScroll($resScrollSet);
	
}

if($renderOption == 4) {  //csv
	$csvFile = array();
	$headerLine = array();
	array_push($csvFile,array("Bed Nights Report"));
	array_push($csvFile,array());
	array_push($csvFile,array("Date range",$fromDate . " to " . $toDate));
	array_push($csvFile,array("Property / Accommodation",$accommFilter['names']));
	array_push($csvFile,array("Agent",$agentFilter['names']));
	array_push($csvFile,array("Agent country",$agentCountryFilter['names']));
	array_push($csvFile,array("Status",$statusFilter['names']));
	array_push($csvFile,array("Exclude expired provisionals",(isset($exludeExpired) && $exludeExpired=="1"?"Yes":"No")));
	array_push($csvFile,array("Consultant",$consultantFilter['names']));
	array_push($csvFile,array("Originator",$originatorFilter['names']));
	array_push($csvFile,array("Source",$sourceFilter['names']));
	array_push($csvFile,array("Nationality",$nationalityFilter['names']));
	array_push($csvFile,array("Rate",$rateFilter['names']));
	array_push($csvFile,array());


	array_push($csvFile,array("Reservation No.","Reservation Name","Property","Accommodation Type","Arrival Date","Departue Date","Nights Total","Nights Actual","Rooms","Adults","Children","Total","Bed Nights","Actual Bed Nights","Currency","Revenue","Actual Revenue","Agent","Status","Consultant","Originator","Source","Nationality"));
	
	foreach($list as $item) {
		$dateArrive = chng_date($item['rv_item_date_arrive'],"-");
		$dateDepart = chng_date($item['rv_item_date_depart'],"-");
		$nights = $item['nights'];
	    $incNights = $item['incNights'];	
		$rooms = $item['rv_item_accomm_count'];
		$adult = $item['rv_item_adult_count'];
		$child = $item['rv_item_child_count'];
		$total = $adult + $child;
		$bedNights = $total * $rooms * $nights;
		$incBedNights = $total * $rooms * $incNights;
		$currency = $item['rf_currency_symbol'];
		$revenue = $item['revenue'];
		$incRevenue = $item['incRevenue'];
		array_push($csvFile,array(
			$item['rv_reservation_ix'],
			$item['rv_res_name'],
			$item['pr_bus_name_short'],
			$item['ac_accomm_name_short'],
			$dateArrive,
			$dateDepart,
			$nights,
			$incNights,
			$rooms,
			$adult,
			$child,
			$total,
			$bedNights,
			$incBedNights,
			$currency,
			$revenue,
			$incRevenue,
			$item['agent_name'],
			$item['rf_reservation_status_desc'],
			$item['consultant_name'],
			$item['originator_name'],
			$item['source_name'],
			$item['country_name']
		));

	}

  array_push($csvFile,array(
			"",
			"",
			"",
			"",
      "",
			"Totals",
			$totalNights." (".$totalIncNights.")",
			$totalRooms,
			$totalAdults,
			$totalChildren,
			$totalTotal,
			$totalBedNights." (".$totalIncBedNights.")"
		));
  
	$csvText = "";
	foreach($csvFile as $csvLine) {
		$first = true;
		foreach($csvLine as $csvItem) {
			if(!$first) {
				$csvText .= ",";
			} else {
				$first = false;
			}
			$csvText .= "\"".str_replace("\"","\"\"",$csvItem)."\"";
		}
		$csvText .= "\n";
	}
	//header('Content-Type: text/plain');
	//echo "<PRE>";
	//print_r($csvText);
	//echo $csvText;
	//die();
	if(headers_sent()) {
		//    echo('Some data has already been output to browser, can\'t send PDF file');
	}
	header('Content-Type: text/csv');
	header("Cache-control: private");
	header('Content-Length: '.strlen($csvText));
	header("Content-Disposition: inline; filename=bednights_detail_".str_replace(" ","_",chng_date(date("Y-m-d"),"-")).".csv");
	echo $csvText;
	flush();
	die();	
}

if ($renderOption == 1 || $renderOption == 3) {
	$pdf = new PDF("Bed Nights Popup",'L');
	$reportLabel = "Bed Nights Popup";
	// Main PDF header
	$headerArray = array(
		array('name'=>"Date Range",    'value'=>$fromDate . " to " . $toDate),
		array('name'=>"Property / Accommodation", 'value'=>$accommFilter['names']),
		array('name'=>"Agent",         'value'=>$agentFilter['names']),
		array('name'=>"Agent country", 'value'=>$agentCountryFilter['names']),
		array('name'=>"Status",        'value'=>$statusFilter['names']),
		array('name'=>"Exclude Expired Provisionals", 'value'=>($excludeExpired=="1"?"Yes":"No")),
		array('name'=>"Consultant",    'value'=>$consultantFilter['names']),
		array('name'=>"Originator",    'value'=>$originatorFilter['names']),
		array('name'=>"Source",        'value'=>$sourceFilter['names']),
		array('name'=>"Nationality",   'value'=>$nationalityFilter['names']),
		array('name'=>"Rate",          'value'=>$rateFilter['names'])
	);
	$pdf->ReportHeader($reportLabel, $headerArray);
	$pdfFontSize = 8;
	$pdf->SetFont('Arial', '', $pdfFontSize);
	$pdf->SetFont('Arial', '', 6);

	$pdf->Row(array(
		array('width'=>"4%",'data'=>"Res No.", 'border'=>"LT", 'fill'=>1),
		array('width'=>"10%",'data'=>"Res Name", 'border'=>"LT", 'fill'=>1),
		array('width'=>"3%",'data'=>"Prop", 'border'=>"LT", 'fill'=>1),
		array('width'=>"3.5%",'data'=>"Acc\nType", 'border'=>"LT", 'fill'=>1),
		array('width'=>"5%",'data'=>"Arr Date", 'border'=>"LT", 'fill'=>1),
		array('width'=>"5%",'data'=>"Dep Date", 'border'=>"LT", 'fill'=>1),
		array('width'=>"3%",'data'=>"Nights", 'border'=>"LT", 'fill'=>1),
		array('width'=>"2%",'data'=>"Rm", 'border'=>"LT", 'fill'=>1),
		array('width'=>"2%",'data'=>"Ad", 'border'=>"LT", 'fill'=>1),
		array('width'=>"2%",'data'=>"Ch", 'border'=>"LT", 'fill'=>1),
		array('width'=>"2%",'data'=>"Ttl", 'border'=>"LT", 'fill'=>1),
		array('width'=>"3.5%",'data'=>"Bed Nts", 'border'=>"LT", 'fill'=>1),
		array('width'=>"3%",'data'=>"Curr", 'border'=>"LT", 'fill'=>1),
		array('width'=>"7%",'data'=>"Revenue", 'border'=>"LT", 'fill'=>1),
		array('width'=>"8%",'data'=>"Agent", 'border'=>"LT", 'fill'=>1),
		array('width'=>"5%",'data'=>"Status", 'border'=>"LT", 'fill'=>1),
		array('width'=>"8%",'data'=>"Consultant", 'border'=>"LT", 'fill'=>1),
		array('width'=>"8%",'data'=>"Originator", 'border'=>"LT", 'fill'=>1),
		array('width'=>"8%",'data'=>"Source", 'border'=>"LT", 'fill'=>1),
		array('width'=>"8%",'data'=>"Nationality", 'border'=>"LTR", 'fill'=>1)
	));

	foreach($list as $item) {
		$dateArrive = chng_date($item['rv_item_date_arrive'],"-");
		$dateDepart = chng_date($item['rv_item_date_depart'],"-");
		$nights = $item['nights'];
	    $incNights = $item['incNights'];	
		$rooms = $item['rv_item_accomm_count'];
		$adult = $item['rv_item_adult_count'];
		$child = $item['rv_item_child_count'];
		$total = $adult + $child;
		$bedNights = $total * $rooms * $nights;
		$incBedNights = $total * $rooms * $incNights;
		$currency = $item['rf_currency_symbol'];
		$revenue = $item['revenue'];
		$incRevenue = $item['incRevenue'];
		if($nights != $incNights) {
			$incNights = " ($incNights)";
		} else {
			$incNights = "";
		}
		if($bedNights != $incBedNights) {
			$incBedNights = " ($incBedNights)";
		} else {
			$incBedNights = "";
		}
		if($revenue != $incRevenue) {
			$incRevenue = " ($incRevenue)";
		} else {
			$incRevenue = "";
		}
		$pdf->Row(array(
			array('width'=>"4%",'data'=>$item['rv_reservation_ix'], 'border'=>"LTB"),
			array('width'=>"10%",'data'=>$item['rv_res_name'], 'border'=>"LTB"),
			array('width'=>"3%",'data'=>$item['pr_bus_name_short'], 'border'=>"LTB"),
			array('width'=>"3.5%",'data'=>$item['ac_accomm_name_short'], 'border'=>"LTB"),
			array('width'=>"5%",'data'=>$dateArrive, 'border'=>"LTB"),
			array('width'=>"5%",'data'=>$dateDepart, 'border'=>"LTB"),
			array('width'=>"3%",'data'=>$nights.$incNights, 'border'=>"LTB"),
			array('width'=>"2%",'data'=>$rooms, 'border'=>"LTB"),
			array('width'=>"2%",'data'=>$adult, 'border'=>"LTB"),
			array('width'=>"2%",'data'=>$child, 'border'=>"LTB"),
			array('width'=>"2%",'data'=>$total, 'border'=>"LTB"),
			array('width'=>"3.5%",'data'=>$bedNights.$incBedNights, 'border'=>"LTB"),
			array('width'=>"3%",'data'=>$currency, 'border'=>"LTB"),
			array('width'=>"7%",'data'=>$revenue.$incRevenue, 'border'=>"LTB"),
			array('width'=>"8%",'data'=>$item['agent_name'], 'border'=>"LTB"),
			array('width'=>"5%",'data'=>$item['rf_reservation_status_desc'], 'border'=>"LTB"),
			array('width'=>"8%",'data'=>$item['consultant_name'], 'border'=>"LTB"),
			array('width'=>"8%",'data'=>$item['originator_name'], 'border'=>"LTB"),
			array('width'=>"8%",'data'=>$item['source_name'], 'border'=>"LTB"),
			array('width'=>"8%",'data'=>$item['country_name'], 'border'=>"LTBR")
		));
	}
	$pdf->Row(array(
		array('width'=>"25.5%",'data'=>""),
		array('width'=>"5%",'data'=>"Totals", 'border'=>"LTB"),
		array('width'=>"3%",'data'=>"$totalNights ($totalIncNights)", 'border'=>"LTB"),
		array('width'=>"2%",'data'=>$totalRooms, 'border'=>"LTB"),
		array('width'=>"2%",'data'=>$totalAdults, 'border'=>"LTB"),
		array('width'=>"2%",'data'=>$totalChildren, 'border'=>"LTB"),
		array('width'=>"2%",'data'=>$totalTotal, 'border'=>"LTB"),
		array('width'=>"3.5%",'data'=>"$totalBedNights ($totalIncBedNights)", 'border'=>"LTBR"),
		array('width'=>"55%",'data'=>"")
	));
	
	if($renderOption == 1) {
		$pdf->OutPut();
		die();
	}
	if($renderOption == 3) {
		$to = $_POST['mail_to'];
		$from = $_POST['mail_from'];
		$subject = $_POST['mail_subj'];
		$message = $_POST['mail_body'];
		$attachmentName = $_POST['attachmentName'];

		$headers = "From: ".$GLOBALS['princName']."<$from>\r\n";

		// close the pdf
		if($pdf->state<3) $pdf->Close();

		/* and now mail it */
		if($attachmentName != "!attachmentName!") {
			$pdfName = $attachmentName;
		} else {
			$pdfName = "Update report from $fromDate to $toDate.pdf";
		}

		$error = email($from, $to, $subject, $headers, $message, 0, 0, $_SERVER['argv'][1], $GLOBALS['princName'],$pdf->buffer,$pdfName);     // (from, to, subject, headers, message, action, emailID, resID)
		if(!$error) {
			echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
			die();
		} else {
			echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
			die();
		}
	}
}
function getPersonaFax($personaId) {
      $fax = $GLOBALS['lDB']->get("
         SELECT
         pr_phone.pr_phone_number
         FROM
         pr_phone, rf_phone_type
         WHERE
         pr_phone.pr_persona_id = '$personaId'
         AND pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
         AND rf_phone_type.rf_phone_type_sys_code = '1'", 4);
      if (trim($fax) == "" || $fax == "0") {
         $fax = "";
      }
      return $fax;
   }
   function getPersonaTelephone($personaId) {
      $tel = $GLOBALS['lDB']->get("
         SELECT
         pr_phone.pr_phone_number
         FROM
         pr_phone
         WHERE
         pr_phone.pr_persona_id = '$personaId'
         AND pr_phone.pr_default_yn = '1'", 4);
      if (trim($tel) == "" || $tel == "0") {
         $tel = "";
      }
      return $tel;
   }
function getPersonaDetail($personaId) {
	$detail = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_first,
			pr_persona.pr_name_second,
			pr_persona.pr_name_last,
	    pr_persona.pr_email
		FROM
			pr_persona
		WHERE 
			pr_persona.pr_persona_ix = '" . $personaId . "'
	", 2);

	$detail = $detail[0];
	$name = "";

	if ( trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0" ) {
		$name .= $detail['pr_name_first'] . " ";
	}

	if ( trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0" ) {
		$name .= $detail['pr_name_second'] . " ";
	}

	if ( trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0" ) {
		$name .= $detail['pr_name_last'] . " ";
	}

	$result = array();

	$result['name']				= trim($name);
	$result['fax']				= getPersonaFax($personaId);
	$result['telephone']	= getPersonaTelephone($personaId);
	$result['email']			= $detail['pr_email'];

	if ( trim($result['email']) == "" || $result['email'] == "0" ) {
		$result['email'] = "";
	}

	return $result;
}
