<?php

/*
 * $Id: init.form32.php,v 1.10 2011-06-27 15:30:20 light Exp $
 *
 * $Log: init.form32.php,v $
 * Revision 1.10  2011-06-27 15:30:20  light
 * Bug #7626 - * Find and fix all incorrect guest lookups
 *
 * Revision 1.9  2011-05-30 12:50:02  light
 * Bug #7609 - General system speed (on larger databases)
 *
 * Revision 1.8  2010-11-18 21:34:36  light
 * Bug #7332 - Code table: Currency
 *
 *
 */

/**
 * init.form32.php - Currency code table (detail)
 * Job: 81, 82, 83, 84, 85, 86
 * Function: 57 (Code Tables: General)
*/

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/code_currency.htm");
	$fields = array(
		"rf_currency_ix",
		"rf_currency_exch_op",
		"rf_currency_name",
		"rf_currency_symbol",
		"rf_currency_inactive_yn"
	);
	$ident = array("rf_currency_name");
	$GLOBALS[$form]->AddTable($GLOBALS['lDB'],"rf_currency",$fields,"rf_currency_ix = '$record'","","",$ident);
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

$record = $_SERVER['argv'][1];
$GLOBALS['autovar'] = "1";
if ($record != "") {
	$GLOBALS['passthrurecord'] = $record;
} else {
	if ($action != "2") {
		$record = isset($GLOBALS['passthrurecord'])?$GLOBALS['passthrurecord']:"";
		if ($_SERVER['argv'][1] == "") {
			$_SERVER['argv'][1] = $record;
		}
	}
}
$GLOBALS['temp']['record'] = $record;

$GLOBALS[$form]->Get($action);

$table = $GLOBALS[$form]->TableList[0];

if ($record != "" || $action == "3" && $action != "1") {
	$GLOBALS[$table]->Refresh($record,$action);
}

$disablelist = array();
$GLOBALS[$form]->Disable($disablelist);

if ($action == "2") {
	$GLOBALS['form32_rf_currency_rf_currency_db']->SetValue($dbcode);
}

$GLOBALS['form32_rf_currency_rf_currency_name']->TabIndex = 1;
$GLOBALS['form32_rf_currency_rf_currency_name']->Size = 40;
$GLOBALS['form32_rf_currency_rf_currency_name']->StyleType = "txt";

$GLOBALS['form32_rf_currency_rf_currency_symbol']->TabIndex = 2;
$GLOBALS['form32_rf_currency_rf_currency_symbol']->Size = 15;
$GLOBALS['form32_rf_currency_rf_currency_symbol']->StyleType = "txt";

$actVal = "0";
$inActVal = "1";
$actFlag = "form32_rf_currency_rf_currency_inactive_yn";
if ($GLOBALS[$actFlag]->Value == $actVal || $action == "2") {
	$GLOBALS[$actFlag]->Value = $actVal;
	$GLOBALS['temp']['actInd'] = " style=\"display:none\"";
	$hidelist = array($actFlag);
} else {
	if ($record == "" && $action == "1") {
		$GLOBALS['temp']['actInd'] = " style=\"display:none\"";
	} else {
		$GLOBALS[$actFlag]->Value = $inActVal;
		$GLOBALS['temp']['actInd'] = "";
	}
	$hidelist = array();
}

$GLOBALS[$actFlag]->Select(array("$inActVal-Inactive","$actVal-Active"));
$GLOBALS[$actFlag]->StyleType = "txts";

$GLOBALS[$form]->Hide($hidelist);
// Start Access Control Toolbar Setup
$newr = 82;
$edit = 84;
$view = 81;
$dele = 86;
$sedit = 85;
$snewr = 83;

$pgJOBS = array();
$pgJOBS['view'] = "0";
if (checkJob($view)) {
	$pgJOBS['view'] = "1";
}
$pgJOBS['add'] = "0";
if (checkJob($newr)) {
	$pgJOBS['add'] = "1";
}
$pgJOBS['edit'] = "0";
if (checkJob($edit)) {
	$pgJOBS['edit'] = "1";
}
$pgJOBS['del'] = "0";
$pgJOBS['save'] = "0";
if ($action == "2" || $action == "3") {
	$pgJOBS['save'] = "1";
}
if ($action == "2" || $action == "4" || $record == null) {
	$pgJOBS['edit'] = "0";
}
if ($action == "3") {
	$pgJOBS['edit'] = $pgJOBS['view'];
	if (checkJob($dele)) {
		$pgJOBS['del'] = "1";
	}
}
if($GLOBALS[$actFlag]->Value != $actVal) {
	$pgJOBS['del'] = "0";
}

$GLOBALS['temp']['pgJobs'] = "
	<input type=\"hidden\" id=\"pgJobNew\" value=\"$pgJOBS[add]\">
	<input type=\"hidden\" id=\"pgJobEdit\" value=\"$pgJOBS[edit]\">
	<input type=\"hidden\" id=\"pgJobDelete\" value=\"$pgJOBS[del]\">
	<input type=\"hidden\" id=\"pgJobSave\" value=\"$pgJOBS[save]\">
";
// End Access Control Toolbar Setup

$GLOBALS['temp']['new_record'] = "reservation.php?82";
$GLOBALS['temp']['inactive_check'] = "";
switch ($action) {
case (0) : // List Records
	break;
case (1) : // Display Record
	$GLOBALS['mode'] = "display";
	$GLOBALS['temp']['edit_view'] = "reservation.php?84+".$record;
	$GLOBALS['temp']['save_record'] = "#";
	$GLOBALS['temp']['del_record'] = "#";
	$GLOBALS['temp']['inactive_check'] .= " disabled";
	break;
case (2) : // Add Record
	$GLOBALS[$form]->Arguments = "83";
	$GLOBALS['temp']['edit_view'] = "#";
	$GLOBALS['temp']['save_record'] = "document.forms[0].submit()";
	$GLOBALS['temp']['del_record'] = "#";
	$GLOBALS['mode'] = "new";
	break;
case (3) : // Edit Record
	$GLOBALS[$form]->Arguments = "85+".$record;
	$GLOBALS['mode'] = "edit";
	$GLOBALS['temp']['edit_view'] = "reservation.php?81+".$record;
	$GLOBALS['temp']['save_record'] = "document.forms[0].submit()";
	$GLOBALS['temp']['del_record'] = "reservation.php?86+".$record;
	break;
case (4) : // Delete Record
	$tables = array(
		"ac_extra"=>array("rf_currency_id"),
		"fn_debtor"=>array("rf_currency_id"),
		"fn_folio"=>array("rf_currency_id"),
		"fn_tran"=>array("rf_currency_id"),
		"fn_tran_item"=>array("rf_currency_id"),
		"pr_business"=>array("pr_bus_home_curr_id","pr_bus_prop_curr_id"),
		"rf_bank"=>array("rf_currency_id"),
		"rf_country"=>array("rf_currency_id"),
		"rf_exchange_rate"=>array("rf_exch_curr_from_id","rf_exch_curr_to_id"),
		"rt_rate_type"=>array("rf_currency_id"),
		"rv_extra"=>array("rf_currency_id","rv_extra_inv_curr_id"),
		"rv_payment"=>array("rf_currency_id"),
		"rv_payment_item"=>array("rf_currency_id"),
		"rv_reservation"=>array("rv_invoice_currency_id")
	);

	$checkTables = false;
	foreach($tables as $table=>$fields) {
		$where = array();
		foreach($fields as $field) {
			$where[] = "$field = '$record'";
		}
		$where = join(" OR ",$where);
		$check = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM $table WHERE $where",4);
		if($check > 0) {
			$checkTables = true;
		}
	}

	if($checkTables) {
		$GLOBALS['lDB']->put("update rf_currency set rf_currency_inactive_yn = '1' where rf_currency_ix = '$record'");
	} else {
		$GLOBALS['initrecord'] = $record;
		$GLOBALS['delrecord'] = $record;
	}		 
	break;
}

$GLOBALS['temp']['new_record'] .= "++".$_SERVER['argv'][2]."+".$_SERVER['argv'][3];

