<?php

	if($totalDisplay == "1") {
		$dateWhere = "
			AND (
				(
					fn_invoice.fn_invoice_ix IS NULL
					AND fn_folio.fn_folio_date >= '".$fromDate['jsDate']."'
					AND fn_folio.fn_folio_date <= '".$toDate['jsDate']."'
				) OR (
					fn_invoice.fn_invoice_ix IS NOT NULL
					AND fn_invoice.fn_inv_date >= '".$fromDate['jsDate']."'
					AND fn_invoice.fn_inv_date <= '".$toDate['jsDate']."'
				)
			)
		";
	} else {
		$dateWhere = "
			AND (
				(rv_reservation_item.rv_item_date_arrive >= '".$fromDate['jsDate']."' AND rv_reservation_item.rv_item_date_arrive <= '".$toDate['jsDate']."')
                 OR
                 (rv_reservation_item.rv_item_date_depart >= '".$fromDate['jsDate']."' AND rv_reservation_item.rv_item_date_depart <= '".$toDate['jsDate']."')
                 OR
                 (rv_reservation_item.rv_item_date_arrive < '".$fromDate['jsDate']."' AND rv_reservation_item.rv_item_date_depart > '".$toDate['jsDate']."')
			)
		";
	}
	$sqlFrom = "
		FROM
			rv_reservation_item
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_reservation_item.fn_folio_id
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
			LEFT JOIN fn_invoice ON fn_invoice.fn_folio_id = fn_folio.fn_folio_ix AND fn_invoice.fn_inv_status_ind = 2
	";
	$sqlWhere = "
		WHERE
			1
			$dateWhere
			$accommFilter[where] $currenciesFilter[where] $agentWhere $consultantFilter[where] $originatorFilter[where] $nationalityFilter[where] $rateFilter[where] $sourceFilter[where] $statusFilter[where]
	";

	$properties = $lDB->get("
		SELECT
			DISTINCT pr_business_id
		FROM
			ac_accomm_type
		WHERE
			ac_accomm_type_ix IN ('" . join("','" , explode(':', $accommFilter['ids'])) . "')
	", 3);

	$sqlFromExtras = "
		FROM
			rv_extra
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_extra.rv_reservation_id
			INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_extra.fn_folio_id
			LEFT JOIN fn_invoice ON fn_invoice.fn_folio_id = fn_folio.fn_folio_ix AND fn_invoice.fn_inv_status_ind = 2
	";
	$sqlWhereExtras = "
		WHERE
			1
			$dateWhere
			AND rv_extra.pr_business_id IN ('" . join("','" , $properties) . "')
			$currenciesFilter[where]
			$agentWhere
			$consultantFilter[where]
			$originatorFilter[where]
			$nationalityFilter[where]
			$rateFilter[where]
			$sourceFilter[where]
			$statusFilter[where]
	";

	if($invoiceStatus < 3) { // not all
		if($invoiceStatus == 1) {
			$sqlWhere .= "
				AND fn_invoice.fn_invoice_ix IS NOT NULL
			";
		} elseif($invoiceStatus == 2) {
			$sqlWhere .= "
				AND fn_invoice.fn_invoice_ix IS NULL
			";
		}
	}

	$groupList = $lDB->get("SELECT DISTINCT rv_reservation.rv_reservation_ix AS 'groupId', rv_reservation.rv_reservation_ix AS 'groupName' $sqlFrom $sqlWhere",2);

	$list = array();
	$grandTotalPax = 0;
	$grandTotalBedNights = 0;
	$groupList = is_array($groupList) ? $groupList : array();
	foreach($groupList as $groupItem) {
		$groupId = $groupItem['groupId'];
		$groupName = $groupItem['groupName'];
		$list[$groupId] = array();
		$list[$groupId]['name'] = $groupName;
		$list[$groupId]['resName'] = $lDB->get("SELECT rv_res_name FROM rv_reservation WHERE rv_reservation_ix = '$groupId'",4);
		$status = $lDB->get("
			SELECT
				rv_reservation.rf_reservation_status_id,
				rf_reservation_status.rf_reservation_status_desc,
				rv_reservation.rv_provision_expiry_date,
				rv_reservation.rv_date_recorded,
				rt_rate_type.rt_rate_type_desc,
				rf_source.rf_source_desc,
				rv_reservation.rv_confirmation_date,
				rv_reservation.rv_prov_date,
				rv_reservation.rv_wait_list_date,
				TRIM(CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last)) as originator
			FROM
				rv_reservation
				INNER JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
				INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id
				LEFT JOIN rf_source ON rf_source.rf_source_ix = rv_reservation.rf_source_ix
				LEFT JOIN pr_persona on pr_persona.pr_persona_ix = rv_reservation.rv_origin_agent_id
			WHERE
				rv_reservation_ix = '$groupId'
		",1);
		$statusColour = "";
		if($status['rf_reservation_status_id'] == "20") {
			$today = date("Y-m-d");
	
			if($status['rv_provision_expiry_date'] == $today ) {
				$statusColour = "#F1C55D";
			} elseif($status['rv_provision_expiry_date'] < $today) {
				$statusColour = "#DB4242";
			}
		}
		switch($status['rf_reservation_status_id']) {
		case 10:
			$list[$groupId]['resStatusDate'] = chng_date($status['rv_wait_list_date'],"-");
			$list[$groupId]['resStatusDateRaw'] = $status['rv_wait_list_date'];
			break;
		case 20:
			$list[$groupId]['resStatusDate'] = chng_date($status['rv_prov_date'],"-");
			$list[$groupId]['resStatusDateRaw'] = $status['rv_prov_date'];
			break;
		case 30:
			$list[$groupId]['resStatusDate'] = chng_date($status['rv_confirmation_date'],"-");
			$list[$groupId]['resStatusDateRaw'] = $status['rv_confirmation_date'];
			break;
		}
		if(empty($list[$groupId]['resStatusDateRaw']) || $list[$groupId]['resStatusDateRaw'] == "0000-00-00") {
			$list[$groupId]['resStatusDate'] = "Unknown";
			$list[$groupId]['resStatusDateRaw'] = "0000-00-00";
		}
		$list[$groupId]['resStatus'] = $status['rf_reservation_status_desc'];
		$list[$groupId]['resStatusColour'] = $statusColour;

		$list[$groupId]['rateType'] = $status['rt_rate_type_desc'];
		if(trim($status['rf_source_desc']) == "") {
			$list[$groupId]['resSource'] = "No source";
		} else {
			$list[$groupId]['resSource'] = $status['rf_source_desc'];
		}
		$list[$groupId]['resOriginator'] = $status['originator'] ?? "No originator";
		$list[$groupId]['dateCreate'] = chng_date($status['rv_date_recorded'],"-");
		$list[$groupId]['dateCreateRaw'] = $status['rv_date_recorded'];

		$list[$groupId]['resAgent'] = trim($lDB->get("
			SELECT
				pr_persona.pr_name_last
			FROM
				rv_reservation
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
			WHERE
				rv_reservation_ix = '$groupId'
		",4));
		if(empty($list[$groupId]['resAgent'])) {
			$list[$groupId]['resAgent'] = "Direct";
		}
		$list[$groupId]['propertiesRaw'] = join(", ",$lDB->get("
			SELECT DISTINCT
				pr_business.pr_bus_name_short
			FROM
				rv_reservation_item
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
				INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
				INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
			WHERE
				rv_reservation.rv_reservation_ix = '$groupId'
		",3));
		if(strlen($list[$groupId]['propertiesRaw']) > 8) {
			$list[$groupId]['properties'] = substr($list[$groupId]['propertiesRaw'],0,8) . "...";
		} else {
			$list[$groupId]['properties'] = $list[$groupId]['propertiesRaw'];
		}
		//$list[$groupId]['properties'] = "MXMXMXMX...";
		$dateRaw = $lDB->get("
			SELECT
				MIN(rv_item_date_arrive) AS rv_item_date_arrive,
				MAX(rv_item_date_depart) AS rv_item_date_depart
			FROM
				rv_reservation_item
			WHERE
				rv_reservation_item.rv_reservation_id = '$groupId'
				$accommFilter[where]
		",1);
		$list[$groupId]['dateArriveRaw'] = $dateRaw['rv_item_date_arrive'];
		$list[$groupId]['dateDepartRaw'] = $dateRaw['rv_item_date_depart'];
		$list[$groupId]['dateArrive'] = chng_date($dateRaw['rv_item_date_arrive'],"-");
		$list[$groupId]['dateDepart'] = chng_date($dateRaw['rv_item_date_depart'],"-");

		$resItemCurrencyList = $lDB->get("
			SELECT DISTINCT fn_folio.rf_currency_id
				" . $sqlFrom . "
				". $sqlWhere . " AND rv_reservation.rv_reservation_ix = '".$groupItem['groupId']."'",3);
		$resExtraCurrencyList = $lDB->get("
			SELECT DISTINCT
				fn_extra_folio.rf_currency_id
			$sqlFrom
				INNER JOIN rv_extra ON rv_extra.rv_reservation_id = rv_reservation.rv_reservation_ix
				INNER JOIN fn_folio AS fn_extra_folio ON fn_extra_folio.fn_folio_ix = rv_extra.fn_folio_id
				INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
				INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
			$sqlWhere $extraWhere AND rv_reservation.rv_reservation_ix = '".$groupItem['groupId']."' $extraCurrencyWhere",3);
		$currencyList = array_unique(array_merge($resItemCurrencyList, $resExtraCurrencyList));
		$list[$groupId]['currencies'] = array();


		foreach($currencyList as $currencyId) {
			$list[$groupId]['currencies'][$currencyId]['name'] = $lDB->get("SELECT rf_currency_symbol FROM rf_currency WHERE rf_currency_ix = '$currencyId'",4);
//PAX
			$resItemCurrencyIds = $lDB->get("
				SELECT
					DISTINCT rv_reservation_item.rv_reservation_item_ix
				" . $sqlFrom . $groupJoin . "
				". $sqlWhere . " AND rv_reservation.rv_reservation_ix = '".$groupItem['groupId']."' AND fn_folio.rf_currency_id = '$currencyId'
				AND rv_reservation_item.fn_folio_id = fn_folio.fn_folio_ix
			",3);
			$resItemPaxList = $lDB->get("
				SELECT
					rv_reservation_item.rv_reservation_item_ix as id,
	        		rv_reservation_item.rv_item_accomm_count as rooms,
					rv_reservation_item.rv_item_adult_count as adults,
    				rv_reservation_item.rv_item_child_count as children,
					rv_reservation_item.rv_item_date_arrive as arrive,
					rv_reservation_item.rv_item_date_depart as depart,
					rv_reservation_item.rv_item_nights as nights,
					$itemAmountSQL
				FROM
					rv_reservation_item
				WHERE
					rv_reservation_item.rv_reservation_item_ix IN ('".join("','",$resItemCurrencyIds)."')
			",2);

			$list[$groupId]['currencies'][$currencyId]['accomm'] = array();
			$compIds = $lDB->get("
				SELECT DISTINCT rv_res_item_comp.rt_component_id
				FROM
					rv_reservation_item
					INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
				WHERE
					rv_reservation_item.rv_reservation_item_ix IN ('".join("','",$resItemCurrencyIds)."')
			",3);
			foreach($compIds as $compId) {
				$list[$groupId]['currencies'][$currencyId]['accomm'][$compId]['gross'] = 0;
				$list[$groupId]['currencies'][$currencyId]['accomm'][$compId]['nett'] = 0;
				$list[$groupId]['currencies'][$currencyId]['accomm'][$compId]['payable'] = 0;
				$list[$groupId]['currencies'][$currencyId]['accomm'][$compId]['tax'] = 0;
			}
			
			$totalPax = 0;
			$totalBedNights = 0;
			$totalNights = 0;
			$totalActualNights = 0;
			$totalGross = 0;
			$totalNett = 0;
			$totalPayable = 0;
			$totalTax = 0;
			foreach($resItemPaxList as $paxItem) {
				if($totalDisplay != "1") { // per day
					$startDate = $paxItem['arrive'];
					if($fromDate['jsDate'] > $startDate) { $startDate = $fromDate['jsDate']; }
					list($itemEndYear, $itemEndMonth, $itemEndDay) = explode("-",$paxItem['depart']);
					$endDate = date("Y-m-d",mktime(0,0,0,$itemEndMonth,$itemEndDay-1,$itemEndYear));
					//$endDate = $paxItem['depart'];
					if($toDate['jsDate'] < $endDate) { $endDate = $toDate['jsDate']; }
					$nights = dateSubtract($endDate, $startDate)+1;
				} else {
					$startDate = $paxItem['arrive'];
					$endDate = $paxItem['depart'];
					$nights = $paxItem['nights'];
				}

				$pax = ($paxItem['adults'] + $paxItem['children']) * $paxItem['rooms'];
				$bedNights = $pax * $nights;

				$totalPax += $pax;
				$totalBedNights += $bedNights;
				$totalNights += $nights;
				$totalActualNights += $paxItem['nights'];
				
				if($totalDisplay == "1") {
					$totalGross += isset($paxItem['rv_item_amt_gross']) ? $paxItem['rv_item_amt_gross'] : 0;
					$totalNett += isset($paxItem['rv_item_amt_nett']) ? $paxItem['rv_item_amt_nett'] : 0;
					$totalPayable += isset($paxItem['rv_item_amt_payable']) ? $paxItem['rv_item_amt_payable'] : 0;
					$totalTax += isset($paxItem['rv_item_amt_tax']) ? $paxItem['rv_item_amt_tax'] : 0;
				} else {
					if($paxItem['nights'] != "0") {
						$totalGross += $paxItem['rv_item_amt_gross'] / $paxItem['nights'] * $nights;
						$totalNett += $paxItem['rv_item_amt_nett'] / $paxItem['nights'] * $nights;
						$totalPayable += $paxItem['rv_item_amt_payable'] / $paxItem['nights'] * $nights;
						$totalTax += $paxItem['rv_item_amt_tax'] / $paxItem['nights'] * $nights;
					}
				}
				foreach($compIds as $compId) {
					$compGross = 0;
					$compNett = 0;
					$compPayable = 0;
					$compTax = 0;
					$compList = $lDB->get("
						SELECT
							$compAmountSQL
						FROM
							rv_reservation_item
							INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
						WHERE
							rv_reservation_item.rv_reservation_item_ix = '".$paxItem['id']."'
							AND rv_res_item_comp.rt_component_id = '$compId'
					",2);
					foreach($compList as $compItem) {
						if($totalDisplay == "1") {
							$compGross += isset($compItem['gross']) ? $compItem['gross'] : 0;
							$compNett += isset($compItem['nett']) ? $compItem['nett'] : 0;
							$compPayable += isset($compItem['payable']) ? $compItem['payable'] : 0;
							$compTax += isset($compItem['tax']) ? $compItem['tax'] : 0;
						} else {
							if($paxItem['nights'] != "0") {
								$compGross += $compItem['gross'] / $paxItem['nights'] * $nights;
								$compNett += $compItem['nett'] / $paxItem['nights'] * $nights;
								$compPayable += $compItem['payable'] / $paxItem['nights'] * $nights;
								$compTax += $compItem['tax'] / $paxItem['nights'] * $nights;
							}
						}
					}
					$list[$groupId]['currencies'][$currencyId]['accomm'][$compId]['gross'] += $compGross;
					$list[$groupId]['currencies'][$currencyId]['accomm'][$compId]['nett'] += $compNett;
					$list[$groupId]['currencies'][$currencyId]['accomm'][$compId]['payable'] += $compPayable;
					$list[$groupId]['currencies'][$currencyId]['accomm'][$compId]['tax'] += $compTax;
				}
				
			}
			foreach($compIds as $compId) {
				fixAmtDisplay($list[$groupId]['currencies'][$currencyId]['accomm'][$compId]['gross'],2);
				fixAmtDisplay($list[$groupId]['currencies'][$currencyId]['accomm'][$compId]['nett'],2);
				fixAmtDisplay($list[$groupId]['currencies'][$currencyId]['accomm'][$compId]['payable'],2);
				fixAmtDisplay($list[$groupId]['currencies'][$currencyId]['accomm'][$compId]['tax'],2);
			}
			$grandTotalPax += $totalPax;
			$grandTotalBedNights += $totalBedNights;

			$list[$groupId]['currencies'][$currencyId]['pax'] = $totalPax;
			$list[$groupId]['currencies'][$currencyId]['bedNights'] = $totalBedNights;
			$list[$groupId]['currencies'][$currencyId]['nights'] = $totalNights;
			$list[$groupId]['currencies'][$currencyId]['actualNights'] = $totalActualNights;
		
			fixAmtDisplay($totalGross,2);
			fixAmtDisplay($totalNett,2);
			fixAmtDisplay($totalPayable,2);
			fixAmtDisplay($totalTax,2);

			$list[$groupId]['currencies'][$currencyId]['accomm_gross'] = $totalGross;
			$list[$groupId]['currencies'][$currencyId]['accomm_nett'] = $totalNett;
			$list[$groupId]['currencies'][$currencyId]['accomm_payable'] = $totalPayable;
			$list[$groupId]['currencies'][$currencyId]['accomm_tax'] = $totalTax;
//PAX -- END

			if($totalDisplay == "1") {
				$resItemFolioIds = $lDB->get("
					SELECT
						DISTINCT fn_folio.fn_folio_ix
					" . $sqlFrom . "
					" . $sqlWhere . "
						AND rv_reservation.rv_reservation_ix = '" . $groupItem['groupId'] . "'
						AND fn_folio.rf_currency_id = '" . $currencyId . "'
				", 3);

				$extraFolioIds = $lDB->get("
					SELECT
						DISTINCT fn_folio.fn_folio_ix
					" . $sqlFromExtras . "
					" . $sqlWhereExtras . "
						AND rv_reservation.rv_reservation_ix = '" . $groupItem['groupId'] . "'
						AND fn_folio.rf_currency_id = '" . $currencyId . "'
				", 3);

				$folioIds = array_unique(array_merge($extraFolioIds, $resItemFolioIds));

				$resItemExtraIds = $lDB->get("
					SELECT
						DISTINCT rv_extra.rv_extra_ix
					FROM
						rv_extra
					WHERE
						rv_extra.fn_folio_id IN ('" . join("','" , $folioIds) . "')
						" . $extraWhere . "
						AND rv_extra.rv_extra_ind <> '2'
				", 3);
			} else { // per day
				$resItemExtraIds = $lDB->get("
					SELECT DISTINCT rv_extra.rv_extra_ix
						" . $sqlFrom . "
						INNER JOIN rv_extra ON rv_extra.rv_reservation_id = rv_reservation.rv_reservation_ix
						INNER JOIN fn_folio AS fn_extra_folio ON fn_extra_folio.fn_folio_ix = rv_extra.fn_folio_id
						INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
						INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
						" . $sqlWhere . $extraWhere . "
							AND rv_reservation.rv_reservation_ix = '".$groupItem['groupId']."'
							AND fn_extra_folio.rf_currency_id = '$currencyId'
							AND rv_extra.rv_extra_ind <> '2'
							AND (
								rv_extra.rv_extra_date_serv = '0000-00-00'
								OR (
									rv_extra.rv_extra_date_serv >= '".$fromDate['jsDate']."'
									AND rv_extra.rv_extra_date_serv <= '".$toDate['jsDate']."'
								)
							)
				",3);
			}

			$resItemExtraList = $lDB->get("
				SELECT
					$extraAmountSQL
				FROM
					rv_extra
				WHERE
					rv_extra.rv_extra_ix IN ('".join("','",$resItemExtraIds)."')
			",1);

			$list[$groupId]['currencies'][$currencyId]['extra_gross'] = $resItemExtraList['gross'];
			$list[$groupId]['currencies'][$currencyId]['extra_nett'] = $resItemExtraList['nett'];
			$list[$groupId]['currencies'][$currencyId]['extra_payable'] = $resItemExtraList['payable'];
			$list[$groupId]['currencies'][$currencyId]['extra_tax'] = $resItemExtraList['tax'];

			if($totalDisplay == "1") {
				$resItemTravelIds = $lDB->get("
					SELECT DISTINCT rv_extra.rv_extra_ix
						" . $sqlFrom . "
						INNER JOIN rv_extra ON rv_extra.rv_reservation_id = rv_reservation.rv_reservation_ix
						INNER JOIN fn_folio AS fn_extra_folio ON fn_extra_folio.fn_folio_ix = rv_extra.fn_folio_id
						INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
						INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
						" . $sqlWhere . $extraWhere . "
							AND rv_reservation.rv_reservation_ix = '".$groupItem['groupId']."'
							AND fn_extra_folio.rf_currency_id = '$currencyId'
							AND rv_extra.rv_extra_ind = '2'
				",3);
			} else { // per day
				$resItemTravelIds = $lDB->get("
					SELECT DISTINCT rv_extra.rv_extra_ix
						" . $sqlFrom . "
						INNER JOIN rv_extra ON rv_extra.rv_reservation_id = rv_reservation.rv_reservation_ix
						INNER JOIN fn_folio AS fn_extra_folio ON fn_extra_folio.fn_folio_ix = rv_extra.fn_folio_id
						INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
						INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
						" . $sqlWhere . $extraWhere . "
							AND rv_reservation.rv_reservation_ix = '".$groupItem['groupId']."'
							AND fn_extra_folio.rf_currency_id = '$currencyId'
							AND rv_extra.rv_extra_ind = '2'
							AND (
								rv_extra.rv_extra_date_serv = '0000-00-00'
								OR (
									rv_extra.rv_extra_date_serv >= '".$fromDate['jsDate']."'
									AND rv_extra.rv_extra_date_serv <= '".$toDate['jsDate']."'
								)
							)
				",3);
			}

			$resItemTravelList = $lDB->get("
				SELECT
					$extraAmountSQL
				FROM
					rv_extra
				WHERE
					rv_extra.rv_extra_ix IN ('".join("','",$resItemTravelIds)."')
			",1);

			$list[$groupId]['currencies'][$currencyId]['travel_gross'] = $resItemTravelList['gross'];
			$list[$groupId]['currencies'][$currencyId]['travel_nett'] = $resItemTravelList['nett'];
			$list[$groupId]['currencies'][$currencyId]['travel_payable'] = $resItemTravelList['payable'];
			$list[$groupId]['currencies'][$currencyId]['travel_tax'] = $resItemTravelList['tax'];

			if($totalDisplay == "1") {
				$paymentIds = $lDB->get("
					SELECT DISTINCT
						rv_payment_item.rv_payment_item_ix
						" . $sqlFrom . "
						INNER JOIN fn_folio AS fn_payment_folio ON fn_payment_folio.rv_reservation_id = rv_reservation.rv_reservation_ix
						INNER JOIN rv_payment_item ON rv_payment_item.fn_folio_id = fn_payment_folio.fn_folio_ix
						INNER JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
						/*INNER JOIN fn_folio AS fn_payment_folio ON fn_payment_folio.fn_folio_ix = rv_payment_item.fn_folio_id*/
						". $sqlWhere . "
						AND rv_reservation.rv_reservation_ix = '".$groupItem['groupId']."'
						AND fn_payment_folio.rf_currency_id = '$currencyId'
				",3);
			} else { // per day
				$paymentIds = $lDB->get("
					SELECT DISTINCT
						rv_payment_item.rv_payment_item_ix
						" . $sqlFrom . "
						INNER JOIN fn_folio AS fn_payment_folio ON fn_payment_folio.rv_reservation_id = rv_reservation.rv_reservation_ix
						INNER JOIN rv_payment_item ON rv_payment_item.fn_folio_id = fn_payment_folio.fn_folio_ix
						INNER JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
						". $sqlWhere . "
						AND rv_reservation.rv_reservation_ix = '".$groupItem['groupId']."'
						AND fn_payment_folio.rf_currency_id = '$currencyId'
						AND rv_payment.rv_pmnt_date >= '".$fromDate['jsDate']."'
						AND rv_payment.rv_pmnt_date <= '".$toDate['jsDate']."'
				",3);
				$paymentOtherIds = $lDB->get("
					SELECT DISTINCT
						rv_payment_item.rv_payment_item_ix
						" . $sqlFrom . "
						INNER JOIN fn_folio AS fn_payment_folio ON fn_payment_folio.rv_reservation_id = rv_reservation.rv_reservation_ix
						INNER JOIN rv_payment_item ON rv_payment_item.fn_folio_id = fn_payment_folio.fn_folio_ix
						INNER JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
						". $sqlWhere . "
						AND rv_reservation.rv_reservation_ix = '".$groupItem['groupId']."'
						AND fn_payment_folio.rf_currency_id = '$currencyId'
						AND rv_payment_item.rv_payment_item_ix NOT IN ('".join("','",$paymentIds)."')
				",3);
				$paymentOtherTotal = $lDB->get("
					SELECT
						SUM(rv_payment_item.rv_payment_item_amt)
					FROM
						rv_payment_item
					WHERE
						rv_payment_item.rv_payment_item_ix IN ('".join("','",$paymentOtherIds)."')
				",4);
				$list[$groupId]['currencies'][$currencyId]['payment_other_total'] = $paymentOtherTotal;
			}
			
			$paymentTotal = $lDB->get("
				SELECT
					SUM(rv_payment_item.rv_payment_item_amt)
				FROM
					rv_payment_item
				WHERE
					rv_payment_item.rv_payment_item_ix IN ('".join("','",$paymentIds)."')
			",4);

			$list[$groupId]['currencies'][$currencyId]['payment_total'] = $paymentTotal;

			if($showReceipts == "1") {
				$list[$groupId]['currencies'][$currencyId]['receipts'] = $lDB->get("
					SELECT DISTINCT
						rv_payment_id
					FROM
						rv_payment_item
					WHERE
						rv_payment_item.rv_payment_item_ix IN ('".join("','",$paymentIds)."')
					ORDER BY
						rv_payment_id
				",3);
			}			
			/*if(sizeof($resItemExtraIds) == 0 && $showExtras == "1") { $showExtras = "0"; }
			if(sizeof($resItemTravelIds) == 0 && $showTravel == "1") { $showTravel = "0"; }
			if(sizeof($paymentIds) == 0 && $showPayments == "1") { $showPayments = "0"; }*/
			// Details (extras/travel)
			
			$list[$groupId]['currencies'][$currencyId]['extras'] = array();
			$extraIds = $lDB->get("
				SELECT DISTINCT rv_extra.ac_extra_id
				FROM
					rv_extra
				WHERE
					rv_extra.rv_extra_ix IN ('".join("','",$resItemExtraIds)."')
			",3);
			foreach($extraIds as $extraId) {
				$extraList = $lDB->get("
					SELECT
						$extraAmountSQL
					FROM
						rv_extra
					WHERE
						rv_extra.rv_extra_ix IN ('".join("','",$resItemExtraIds)."')
						AND rv_extra.ac_extra_id = '$extraId'
				",1);

				$list[$groupId]['currencies'][$currencyId]['extras'][$extraId]['gross'] = $extraList['gross'];
				$list[$groupId]['currencies'][$currencyId]['extras'][$extraId]['nett'] = $extraList['nett'];
				$list[$groupId]['currencies'][$currencyId]['extras'][$extraId]['payable'] = $extraList['payable'];
				$list[$groupId]['currencies'][$currencyId]['extras'][$extraId]['tax'] = $extraList['tax'];
			}
			
			$list[$groupId]['currencies'][$currencyId]['travel'] = array();
			$travelIds = $lDB->get("
				SELECT DISTINCT rv_extra.ac_extra_id
				FROM
					rv_extra
				WHERE
					rv_extra.rv_extra_ix IN ('".join("','",$resItemTravelIds)."')
			",3);
			foreach($travelIds as $travelId) {
				$travelList = $lDB->get("
					SELECT
						$extraAmountSQL
					FROM
						rv_extra
					WHERE
						rv_extra.rv_extra_ix IN ('".join("','",$resItemTravelIds)."')
						AND rv_extra.ac_extra_id = '$travelId'
				",1);

				$list[$groupId]['currencies'][$currencyId]['travel'][$travelId]['gross'] = $travelList['gross'];
				$list[$groupId]['currencies'][$currencyId]['travel'][$travelId]['nett'] = $travelList['nett'];
				$list[$groupId]['currencies'][$currencyId]['travel'][$travelId]['payable'] = $travelList['payable'];
				$list[$groupId]['currencies'][$currencyId]['travel'][$travelId]['tax'] = $travelList['tax'];
			}

			$list[$groupId]['currencies'][$currencyId]['payments'] = array();
			$paymentBankIds = $lDB->get("
				SELECT DISTINCT
					rv_payment.rf_bank_id
				FROM
					rv_payment_item
					INNER JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
				WHERE
					rv_payment_item.rv_payment_item_ix IN ('".join("','",$paymentIds)."')
			",3);

			foreach($paymentBankIds as $bankId) {
				$paymentAmount = $lDB->get("
					SELECT
						SUM(rv_payment_item.rv_payment_item_amt)
					FROM
						rv_payment_item
						INNER JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
					WHERE
						rv_payment_item.rv_payment_item_ix IN ('".join("','",$paymentIds)."')
						AND rv_payment.rf_bank_id = '$bankId'
				",4);
				$list[$groupId]['currencies'][$currencyId]['payments'][$bankId] = $paymentAmount;
			}
			
		}		
	}
	$foundAccomm = false;
	$foundExtras = false;
	$foundTravel = false;
	$foundPayments = false;
	foreach($list as $item) {
		foreach($item['currencies'] as $currencyItem) {
			if(sizeof($currencyItem['accomm']) > 0) {
				$foundAccomm = true;
			}
			if(sizeof($currencyItem['extras']) > 0) {
				$foundExtras = true;
			}
			if(sizeof($currencyItem['travel']) > 0) {
				$foundTravel = true;
			}
			if(sizeof($currencyItem['payments']) > 0) {
				$foundPayments = true;
			}
		}
	}
	if($showAccomm == "1" && !$foundAccomm) { $showAccomm = "0"; }
	if($showExtras == "1" && !$foundExtras) { $showExtras = "0"; }
	if($showTravel == "1" && !$foundTravel) { $showTravel = "0"; }
	if($showPayments == "1" && !$foundPayments) { $showPayments = "0"; }

	$compIds = array();
	foreach($list as $groupItem) {
		foreach($groupItem['currencies'] as $currencyItem) {
			foreach($currencyItem['accomm'] as $compId=>$compItem) {
				$compIds[$compId] = true;
			}
		}
	}
	$compList = array();
	foreach($compIds as $compId=>$compItem) {
		$compName = $lDB->get("SELECT rt_component_desc FROM rt_component WHERE rt_component_ix = '$compId'",4);
		array_push($compList,array('id'=>$compId, 'name'=>$compName));
	}
	function compCmp($a, $b) {
		if ($a['name'] == $b['name']) {
        	return 0;
		}
		return ($a['name'] < $b['name']) ? -1 : 1;
	}
	usort($compList,"compCmp");

	$extraIds = array();
	$extraCatIds = array();
	foreach($list as $groupItem) {
		foreach($groupItem['currencies'] as $currencyItem) {
			foreach($currencyItem['extras'] as $extraId=>$extraItem) {
				$extraIds[$extraId] = $lDB->get("SELECT ac_extra_category_id FROM ac_extra WHERE ac_extra_ix = '$extraId'",4);
			}
		}
	}
	$extraCatIds = array();
	foreach($extraIds as $extraId=>$extraItem) {
		$extraCatIds[$extraItem] = true;
	}

	$extraList = array();
	foreach($extraCatIds as $extraCatId=>$extraCatItem) {
		$catName = $lDB->get("SELECT ac_extra_cat_desc FROM ac_extra_category WHERE ac_extra_category_ix = '$extraCatId'",4);
		$extraSubList = array();
		foreach($extraIds as $extraId=>$extraItem) {
			if($extraItem == $extraCatId) {
				$extraName = $lDB->get("SELECT ac_ext_desc FROM ac_extra WHERE ac_extra_ix = '$extraId'",4);
				array_push($extraSubList,array('id'=>$extraId, 'name'=>$extraName));
			}
		}
		usort($extraSubList,"compCmp");
		array_push($extraList,array('id'=>$extraCatId, 'name'=>$catName, 'extras'=>$extraSubList));
	}
	usort($extraList,"compCmp");

	// Calculate extra category totals
	foreach($extraList as $extraCat) {
		foreach($list as $id=>$item) {
			foreach($item['currencies'] as $currencyId=>$currencyItem) {
				$gross = 0;
				$nett = 0;
				$payable = 0;
				$tax = 0;
				foreach($extraCat['extras'] as $extraItem) {
					$gross += isset($currencyItem['extras'][$extraItem['id']]['gross']) ? $currencyItem['extras'][$extraItem['id']]['gross'] : 0;
					$nett += isset($currencyItem['extras'][$extraItem['id']]['nett']) ? $currencyItem['extras'][$extraItem['id']]['nett'] : 0;
					$payable += isset($currencyItem['extras'][$extraItem['id']]['payable']) ? $currencyItem['extras'][$extraItem['id']]['payable'] : 0;
					$tax += isset($currencyItem['extras'][$extraItem['id']]['tax']) ? $currencyItem['extras'][$extraItem['id']]['tax'] : 0;
				}
				fixAmtDisplay($gross,2);
				fixAmtDisplay($nett,2);
				fixAmtDisplay($payable,2);
				fixAmtDisplay($tax,2);
				$list[$id]['currencies'][$currencyId]['extraCategories'][$extraCat['id']]['gross'] = $gross;
				$list[$id]['currencies'][$currencyId]['extraCategories'][$extraCat['id']]['nett'] = $nett;
				$list[$id]['currencies'][$currencyId]['extraCategories'][$extraCat['id']]['payable'] = $payable;
				$list[$id]['currencies'][$currencyId]['extraCategories'][$extraCat['id']]['tax'] = $tax;
			}
		}
	}

	$travelIds = array();
	$travelCatIds = array();
	foreach($list as $groupItem) {
		foreach($groupItem['currencies'] as $currencyItem) {
			foreach($currencyItem['travel'] as $travelId=>$travelItem) {
				$travelIds[$travelId] = $lDB->get("SELECT ac_extra_category_id FROM ac_extra WHERE ac_extra_ix = '$travelId'",4);
			}
		}
	}
	$travelCatIds = array();
	foreach($travelIds as $travelId=>$travelItem) {
		$travelCatIds[$travelItem] = true;
	}

	$travelList = array();
	foreach($travelCatIds as $travelCatId=>$travelCatItem) {
		$catName = $lDB->get("SELECT ac_extra_cat_desc FROM ac_extra_category WHERE ac_extra_category_ix = '$travelCatId'",4);
		$travelSubList = array();
		foreach($travelIds as $travelId=>$travelItem) {
			if($travelItem == $travelCatId) {
				$travelName = $lDB->get("SELECT ac_ext_desc FROM ac_extra WHERE ac_extra_ix = '$travelId'",4);
				array_push($travelSubList,array('id'=>$travelId, 'name'=>$travelName));
			}
		}
		usort($travelSubList,"compCmp");
		array_push($travelList,array('id'=>$travelCatId, 'name'=>$catName, 'travel'=>$travelSubList));
	}
	usort($travelList,"compCmp");

	// Calculate travel category totals
	foreach($travelList as $travelCat) {
		foreach($list as $id=>$item) {
			foreach($item['currencies'] as $currencyId=>$currencyItem) {
				$gross = 0;
				$nett = 0;
				$payable = 0;
				$tax = 0;
				foreach($travelCat['travel'] as $travelItem) {
					$gross += isset($currencyItem['travel'][$travelItem['id']]['gross']) ? $currencyItem['travel'][$travelItem['id']]['gross'] : 0;
					$nett += isset($currencyItem['travel'][$travelItem['id']]['nett']) ? $currencyItem['travel'][$travelItem['id']]['nett'] : 0;
					$payable += isset($currencyItem['travel'][$travelItem['id']]['payable']) ? $currencyItem['travel'][$travelItem['id']]['payable'] : 0;
					$tax += isset($currencyItem['travel'][$travelItem['id']]['tax']) ? $currencyItem['travel'][$travelItem['id']]['tax'] : 0;
				}
				fixAmtDisplay($gross,2);
				fixAmtDisplay($nett,2);
				fixAmtDisplay($payable,2);
				fixAmtDisplay($tax,2);
				$list[$id]['currencies'][$currencyId]['travelCategories'][$travelCat['id']]['gross'] = $gross;
				$list[$id]['currencies'][$currencyId]['travelCategories'][$travelCat['id']]['nett'] = $nett;
				$list[$id]['currencies'][$currencyId]['travelCategories'][$travelCat['id']]['payable'] = $payable;
				$list[$id]['currencies'][$currencyId]['travelCategories'][$travelCat['id']]['tax'] = $tax;
			}
		}
	}

	$bankIds = array();
	foreach($list as $groupItem) {
		foreach($groupItem['currencies'] as $currencyItem) {
			foreach($currencyItem['payments'] as $bankId=>$bankItem) {
				$bankIds[$bankId] = true;
			}
		}
	}
	$bankList = array();
	foreach($bankIds as $bankId=>$bankItem) {
		$bankName = $lDB->get("SELECT rf_bank_acc_name FROM rf_bank WHERE rf_bank.rf_bank_ix = '$bankId'",4);
		if($bankName == "" || $bankName == "0") { $bankName = "Unknown bank"; }
		if(strlen($bankName) > 8) {
			$bankName = substr($bankName,0,8) . "...";
		}
		array_push($bankList,array('id'=>$bankId, 'name'=>$bankName));
	}
	usort($bankList,"compCmp");

	$currencyList = array();
	foreach($list as $groupItem) {
		foreach($groupItem['currencies'] as $currencyId=>$currencyItem) {
			array_push($currencyList, $currencyId);
		}
	}
	$currencyList = array_unique($currencyList);

	$totals = array();
	foreach($currencyList as $currencyId) {
		$accomm_gross = 0;
		$accomm_nett = 0;
		$accomm_payable = 0;
		$accomm_tax = 0;

		$extra_gross = 0;
		$extra_nett = 0;
		$extra_payable = 0;
		$extra_tax = 0;

		$travel_gross = 0;
		$travel_nett = 0;
		$travel_payable = 0;
		$travel_tax = 0;

		$payment_total = 0;
		$payment_other_total = 0;
		
		foreach($list as $groupItem) {
			$accomm_gross += isset($groupItem['currencies'][$currencyId]['accomm_gross']) ? $groupItem['currencies'][$currencyId]['accomm_gross'] : 0;
			$accomm_nett += isset($groupItem['currencies'][$currencyId]['accomm_nett']) ? $groupItem['currencies'][$currencyId]['accomm_nett'] : 0;
			$accomm_payable += isset($groupItem['currencies'][$currencyId]['accomm_payable']) ? $groupItem['currencies'][$currencyId]['accomm_payable'] : 0;
			$accomm_tax += isset($groupItem['currencies'][$currencyId]['accomm_tax']) ? $groupItem['currencies'][$currencyId]['accomm_tax'] : 0;

			$extra_gross += isset($groupItem['currencies'][$currencyId]['extra_gross']) ? $groupItem['currencies'][$currencyId]['extra_gross'] : 0;
			$extra_nett += isset($groupItem['currencies'][$currencyId]['extra_nett']) ? $groupItem['currencies'][$currencyId]['extra_nett'] : 0;
			$extra_payable += isset($groupItem['currencies'][$currencyId]['extra_payable']) ? $groupItem['currencies'][$currencyId]['extra_payable'] : 0;
			$extra_tax += isset($groupItem['currencies'][$currencyId]['extra_tax']) ? $groupItem['currencies'][$currencyId]['extra_tax'] : 0;

			$travel_gross += isset($groupItem['currencies'][$currencyId]['travel_gross']) ? $groupItem['currencies'][$currencyId]['travel_gross'] : 0;
			$travel_nett += isset($groupItem['currencies'][$currencyId]['travel_nett']) ? $groupItem['currencies'][$currencyId]['travel_nett'] : 0;
			$travel_payable += isset($groupItem['currencies'][$currencyId]['travel_payable']) ? $groupItem['currencies'][$currencyId]['travel_payable'] : 0;
			$travel_tax += isset($groupItem['currencies'][$currencyId]['travel_tax']) ? $groupItem['currencies'][$currencyId]['travel_tax'] : 0;
			
			$payment_total += isset($groupItem['currencies'][$currencyId]['payment_total']) ? $groupItem['currencies'][$currencyId]['payment_total'] : 0;
			$payment_other_total += isset($groupItem['currencies'][$currencyId]['payment_other_total']) ? $groupItem['currencies'][$currencyId]['payment_other_total'] : 0;
			
		}
		$totals[$currencyId]['name'] = $lDB->get("SELECT rf_currency_symbol FROM rf_currency WHERE rf_currency_ix = '$currencyId'",4);

		fixAmtDisplay($accomm_gross,2);
		fixAmtDisplay($accomm_nett,2);
		fixAmtDisplay($accomm_payable,2);
		fixAmtDisplay($accomm_tax,2);		
		$totals[$currencyId]['accomm_gross'] = $accomm_gross;
		$totals[$currencyId]['accomm_nett'] = $accomm_nett;
		$totals[$currencyId]['accomm_payable'] = $accomm_payable;
		$totals[$currencyId]['accomm_tax'] = $accomm_tax;
		
		fixAmtDisplay($extra_gross,2);
		fixAmtDisplay($extra_nett,2);
		fixAmtDisplay($extra_payable,2);
		fixAmtDisplay($extra_tax,2);
		$totals[$currencyId]['extra_gross'] = $extra_gross;
		$totals[$currencyId]['extra_nett'] = $extra_nett;
		$totals[$currencyId]['extra_payable'] = $extra_payable;
		$totals[$currencyId]['extra_tax'] = $extra_tax;

		fixAmtDisplay($travel_gross,2);
		fixAmtDisplay($travel_nett,2);
		fixAmtDisplay($travel_payable,2);
		fixAmtDisplay($travel_tax,2);
		$totals[$currencyId]['travel_gross'] = $travel_gross;
		$totals[$currencyId]['travel_nett'] = $travel_nett;
		$totals[$currencyId]['travel_payable'] = $travel_payable;
		$totals[$currencyId]['travel_tax'] = $travel_tax;

		fixAmtDisplay($payment_total,2);
		$totals[$currencyId]['payment_total'] = $payment_total;
		fixAmtDisplay($payment_other_total,2);
		$totals[$currencyId]['payment_other_total'] = $payment_other_total;


		// Details
		foreach($compList as $compItem) {
			$comp_gross = 0;
			$comp_nett = 0;
			$comp_payable = 0;
			$comp_tax = 0;
			foreach($list as $groupItem) {
				$comp_gross += isset($groupItem['currencies'][$currencyId]['accomm'][$compItem['id']]['gross']) ? $groupItem['currencies'][$currencyId]['accomm'][$compItem['id']]['gross'] : 0;
				$comp_nett += isset($groupItem['currencies'][$currencyId]['accomm'][$compItem['id']]['nett']) ? $groupItem['currencies'][$currencyId]['accomm'][$compItem['id']]['nett'] : 0;
				$comp_payable += isset($groupItem['currencies'][$currencyId]['accomm'][$compItem['id']]['payable']) ? $groupItem['currencies'][$currencyId]['accomm'][$compItem['id']]['payable'] : 0;
				$comp_tax += isset($groupItem['currencies'][$currencyId]['accomm'][$compItem['id']]['tax']) ? $groupItem['currencies'][$currencyId]['accomm'][$compItem['id']]['tax'] : 0;
			}

			fixAmtDisplay($comp_gross,2);
			fixAmtDisplay($comp_nett,2);
			fixAmtDisplay($comp_payable,2);
			fixAmtDisplay($comp_tax,2);
			$totals[$currencyId]['accomm'][$compItem['id']]['gross'] = $comp_gross;
			$totals[$currencyId]['accomm'][$compItem['id']]['nett'] = $comp_nett;
			$totals[$currencyId]['accomm'][$compItem['id']]['payable'] = $comp_payable;
			$totals[$currencyId]['accomm'][$compItem['id']]['tax'] = $comp_tax;
		}

		foreach($extraList as $extraCat) {
			foreach($extraCat['extras'] as $extraItem) {
				$extra_gross = 0;
				$extra_nett = 0;
				$extra_payable = 0;
				$extra_tax = 0;
				foreach($list as $groupItem) {
					$extra_gross += isset($groupItem['currencies'][$currencyId]['extras'][$extraItem['id']]['gross']) ? $groupItem['currencies'][$currencyId]['extras'][$extraItem['id']]['gross'] : 0;
					$extra_nett += isset($groupItem['currencies'][$currencyId]['extras'][$extraItem['id']]['nett']) ? $groupItem['currencies'][$currencyId]['extras'][$extraItem['id']]['nett'] : 0;
					$extra_payable += isset($groupItem['currencies'][$currencyId]['extras'][$extraItem['id']]['payable']) ? $groupItem['currencies'][$currencyId]['extras'][$extraItem['id']]['payable'] : 0;
					$extra_tax += isset($groupItem['currencies'][$currencyId]['extras'][$extraItem['id']]['tax']) ? $groupItem['currencies'][$currencyId]['extras'][$extraItem['id']]['tax'] : 0;
				}
				fixAmtDisplay($extra_gross,2);
				fixAmtDisplay($extra_nett,2);
				fixAmtDisplay($extra_payable,2);
				fixAmtDisplay($extra_tax,2);
				$totals[$currencyId]['extra'][$extraItem['id']]['gross'] = $extra_gross;
				$totals[$currencyId]['extra'][$extraItem['id']]['nett'] = $extra_nett;
				$totals[$currencyId]['extra'][$extraItem['id']]['payable'] = $extra_payable;
				$totals[$currencyId]['extra'][$extraItem['id']]['tax'] = $extra_tax;
			}
		}

		foreach($extraList as $extraCat) {
			$gross = 0;
			$nett = 0;
			$payable = 0;
			$tax = 0;
			foreach($list as $groupItem) {
				$gross += isset($groupItem['currencies'][$currencyId]['extraCategories'][$extraCat['id']]['gross']) ? $groupItem['currencies'][$currencyId]['extraCategories'][$extraCat['id']]['gross'] : 0;
				$nett += isset($groupItem['currencies'][$currencyId]['extraCategories'][$extraCat['id']]['nett']) ? $groupItem['currencies'][$currencyId]['extraCategories'][$extraCat['id']]['nett'] : 0;
				$payable += isset($groupItem['currencies'][$currencyId]['extraCategories'][$extraCat['id']]['payable']) ? $groupItem['currencies'][$currencyId]['extraCategories'][$extraCat['id']]['payable'] : 0;
				$tax += isset($groupItem['currencies'][$currencyId]['extraCategories'][$extraCat['id']]['tax']) ? $groupItem['currencies'][$currencyId]['extraCategories'][$extraCat['id']]['tax'] : 0;

			}
			fixAmtDisplay($gross,2);
			fixAmtDisplay($nett,2);
			fixAmtDisplay($payable,2);
			fixAmtDisplay($tax,2);
			$totals[$currencyId]['extraCategories'][$extraCat['id']]['gross'] = $gross;
			$totals[$currencyId]['extraCategories'][$extraCat['id']]['nett'] = $nett;
			$totals[$currencyId]['extraCategories'][$extraCat['id']]['payable'] = $payable;
			$totals[$currencyId]['extraCategories'][$extraCat['id']]['tax'] = $tax;
		}
		
		foreach($travelList as $travelCat) {
			foreach($travelCat['travel'] as $travelItem) {
				$travel_gross = 0;
				$travel_nett = 0;
				$travel_payable = 0;
				$travel_tax = 0;
				foreach($list as $groupItem) {
					$travel_gross += isset($groupItem['currencies'][$currencyId]['travel'][$travelItem['id']]['gross']) ? $groupItem['currencies'][$currencyId]['travel'][$travelItem['id']]['gross'] : 0;
					$travel_nett += isset($groupItem['currencies'][$currencyId]['travel'][$travelItem['id']]['nett']) ? $groupItem['currencies'][$currencyId]['travel'][$travelItem['id']]['nett'] : 0;
					$travel_payable += isset($groupItem['currencies'][$currencyId]['travel'][$travelItem['id']]['payable']) ? $groupItem['currencies'][$currencyId]['travel'][$travelItem['id']]['payable'] : 0;
					$travel_tax += isset($groupItem['currencies'][$currencyId]['travel'][$travelItem['id']]['tax']) ? $groupItem['currencies'][$currencyId]['travel'][$travelItem['id']]['tax'] : 0;
				}

				fixAmtDisplay($travel_gross,2);
				fixAmtDisplay($travel_nett,2);
				fixAmtDisplay($travel_payable,2);
				fixAmtDisplay($travel_tax,2);
				$totals[$currencyId]['travel'][$travelItem['id']]['gross'] = $travel_gross;
				$totals[$currencyId]['travel'][$travelItem['id']]['nett'] = $travel_nett;
				$totals[$currencyId]['travel'][$travelItem['id']]['payable'] = $travel_payable;
				$totals[$currencyId]['travel'][$travelItem['id']]['tax'] = $travel_tax;
			}
		}

		foreach($travelList as $travelCat) {
			$gross = 0;
			$nett = 0;
			$payable = 0;
			$tax = 0;
			foreach($list as $groupItem) {
				$gross += isset($groupItem['currencies'][$currencyId]['travelCategories'][$travelCat['id']]['gross']) ? $groupItem['currencies'][$currencyId]['travelCategories'][$travelCat['id']]['gross'] : 0;
				$nett += isset($groupItem['currencies'][$currencyId]['travelCategories'][$travelCat['id']]['nett']) ? $groupItem['currencies'][$currencyId]['travelCategories'][$travelCat['id']]['nett'] : 0;
				$payable += isset($groupItem['currencies'][$currencyId]['travelCategories'][$travelCat['id']]['payable']) ? $groupItem['currencies'][$currencyId]['travelCategories'][$travelCat['id']]['payable'] : 0;
				$tax += isset($groupItem['currencies'][$currencyId]['travelCategories'][$travelCat['id']]['tax']) ? $groupItem['currencies'][$currencyId]['travelCategories'][$travelCat['id']]['tax'] : 0;

			}
			fixAmtDisplay($gross,2);
			fixAmtDisplay($nett,2);
			fixAmtDisplay($payable,2);
			fixAmtDisplay($tax,2);
			$totals[$currencyId]['travelCategories'][$travelCat['id']]['gross'] = $gross;
			$totals[$currencyId]['travelCategories'][$travelCat['id']]['nett'] = $nett;
			$totals[$currencyId]['travelCategories'][$travelCat['id']]['payable'] = $payable;
			$totals[$currencyId]['travelCategories'][$travelCat['id']]['tax'] = $tax;
		}

		foreach($bankList as $bankItem) {
			$payment_total = 0;
			foreach($list as $groupItem) {
				$payment_total += isset($groupItem['currencies'][$currencyId]['payments'][$bankItem['id']]) ? $groupItem['currencies'][$currencyId]['payments'][$bankItem['id']] : 0;
			}
			
			fixAmtDisplay($payment_total,2);
			$totals[$currencyId]['payments'][$bankItem['id']] = $payment_total;
		}
	}
	// Flatten list
	$newList = array();
	foreach($list as $id=>$item) {
		foreach($item['currencies'] as $currencyId=>$currencyItem) {
			$newItem = $item;
			$newItem['id'] = $id;
			$newItem['currencies'] = array();
			$newItem['currencies'][$currencyId] = $currencyItem;
			array_push($newList,$newItem);			
		}
	}
	$list = $newList;

	if($sortBy == "1") {
		function mainCmp($a, $b) {
			if ($a['resName'] == $b['resName']) {
        		return 0;
			}
			return ($a['resName'] < $b['resName']) ? -1 : 1;
		}
	}
	if($sortBy == "2") {
		function mainCmp($a, $b) {
			if ($a['resName'] == $b['resName']) {
        		return 0;
			}
			return ($a['resName'] > $b['resName']) ? -1 : 1;
		}
	}
	if($sortBy == "3") {
		function mainCmp($a, $b) {
			$x = 0;
			foreach($a['currencies'] as $aItem) {
				$x += $aItem['bedNights'];
			}
			$y = 0;
			foreach($b['currencies'] as $aItem) {
				$y += $aItem['bedNights'];
			}
			if ($x == $y) {
        		return 0;
			}
			return ($x < $y) ? -1 : 1;
		}
	}
	if($sortBy == "4") {
		function mainCmp($a, $b) {
			$x = 0;
			foreach($a['currencies'] as $aItem) {
				$x += $aItem['bedNights'];
			}
			$y = 0;
			foreach($b['currencies'] as $aItem) {
				$y += $aItem['bedNights'];
			}
			if ($x == $y) {
        		return 0;
			}
			return ($x > $y) ? -1 : 1;
		}
	}
	if($sortBy == "5") {
		function mainCmp($a, $b) {
			if ($a['dateArriveRaw'] == $b['dateArriveRaw']) {
        		return 0;
			}
			return ($a['dateArriveRaw'] < $b['dateArriveRaw']) ? -1 : 1;
		}
	}
	if($sortBy == "6") {
		function mainCmp($a, $b) {
			if ($a['dateArriveRaw'] == $b['dateArriveRaw']) {
        		return 0;
			}
			return ($a['dateArriveRaw'] > $b['dateArriveRaw']) ? -1 : 1;
		}
	}
	if($sortBy == "7") {
		if($commissionFilterType == "1") {
			$GLOBALS['amountType'] = "nett";
		} elseif($commissionFilterType == "2") {
			$GLOBALS['amountType'] = "gross";
		} else {
			$GLOBALS['amountType'] = "payable";
		}
		function mainCmp($a, $b) {
			$xTax = 0;
			$xTotal = 0;
			$xRevenue = 0;
			foreach($a['currencies'] as $aItem) {
				$xTax = $aItem['accomm_tax'] + $aItem['extra_tax'] + $aItem['travel_tax'];
				$xTotal = $aItem['accomm_'.$GLOBALS['amountType']] + $aItem['extra_'.$GLOBALS['amountType']] + $aItem['travel_'.$GLOBALS['amountType']];
				$xRevenue = $xTotal - $xTax;
			}
			$yTax = 0;
			$yTotal = 0;
			$yRevenue = 0;
			foreach($b['currencies'] as $bItem) {
				$yTax = $bItem['accomm_tax'] + $bItem['extra_tax'] + $bItem['travel_tax'];
				$yTotal = $bItem['accomm_'.$GLOBALS['amountType']] + $bItem['extra_'.$GLOBALS['amountType']] + $bItem['travel_'.$GLOBALS['amountType']];
				$yRevenue = $yTotal - $yTax;
			}
			if ($xRevenue == $yRevenue) {
        		return 0;
			}
			return ($xRevenue < $yRevenue) ? -1 : 1;
		}
	}
	if($sortBy == "8") {
		if($commissionFilterType == "1") {
			$GLOBALS['amountType'] = "nett";
		} elseif($commissionFilterType == "2") {
			$GLOBALS['amountType'] = "gross";
		} else {
			$GLOBALS['amountType'] = "payable";
		}
		function mainCmp($a, $b) {
			$xTax = 0;
			$xTotal = 0;
			$xRevenue = 0;
			foreach($a['currencies'] as $aItem) {
				$xTax = $aItem['accomm_tax'] + $aItem['extra_tax'] + $aItem['travel_tax'];
				$xTotal = $aItem['accomm_'.$GLOBALS['amountType']] + $aItem['extra_'.$GLOBALS['amountType']] + $aItem['travel_'.$GLOBALS['amountType']];
				$xRevenue = $xTotal - $xTax;
			}
			$yTax = 0;
			$yTotal = 0;
			$yRevenue = 0;
			foreach($b['currencies'] as $bItem) {
				$yTax = $bItem['accomm_tax'] + $bItem['extra_tax'] + $bItem['travel_tax'];
				$yTotal = $bItem['accomm_'.$GLOBALS['amountType']] + $bItem['extra_'.$GLOBALS['amountType']] + $bItem['travel_'.$GLOBALS['amountType']];
				$yRevenue = $yTotal - $yTax;
			}
			if ($xRevenue == $yRevenue) {
        		return 0;
			}
			return ($xRevenue > $yRevenue) ? -1 : 1;
		}
	}
	if($sortBy == "9") {
		function mainCmp($a, $b) {
			if ($a['dateCreateRaw'] == $b['dateCreateRaw']) {
        		return 0;
			}
			return ($a['dateCreateRaw'] < $b['dateCreateRaw']) ? -1 : 1;
		}
	}
	if($sortBy == "10") {
		function mainCmp($a, $b) {
			if ($a['dateCreateRaw'] == $b['dateCreateRaw']) {
        		return 0;
			}
			return ($a['dateCreateRaw'] > $b['dateCreateRaw']) ? -1 : 1;
		}
	}
	if($sortBy == "11") {
		function mainCmp($a, $b) {
			if ($a['rateType'] == $b['rateType']) {
        		return 0;
			}
			return ($a['rateType'] < $b['rateType']) ? -1 : 1;
		}
	}
	if($sortBy == "12") {
		function mainCmp($a, $b) {
			if ($a['rateType'] == $b['rateType']) {
        		return 0;
			}
			return ($a['rateType'] > $b['rateType']) ? -1 : 1;
		}
	}
	if($sortBy == "13") {
		function mainCmp($a, $b) {
			if ($a['resSource'] == $b['resSource']) {
        		return 0;
			}
			return ($a['resSource'] < $b['resSource']) ? -1 : 1;
		}
	}
	if($sortBy == "14") {
		function mainCmp($a, $b) {
			if ($a['resSource'] == $b['resSource']) {
        		return 0;
			}
			return ($a['resSource'] > $b['resSource']) ? -1 : 1;
		}
	}
	if($sortBy == "15") {
		function mainCmp($a, $b) {
			if ($a['resStatusDateRaw'] == $b['resStatusDateRaw']) {
        		return 0;
			}
			return ($a['resStatusDateRaw'] < $b['resStatusDateRaw']) ? -1 : 1;
		}
	}
	if($sortBy == "16") {
		function mainCmp($a, $b) {
			if ($a['resStatusDateRaw'] == $b['resStatusDateRaw']) {
        		return 0;
			}
			return ($a['resStatusDateRaw'] > $b['resStatusDateRaw']) ? -1 : 1;
		}
	}


	usort($list,"mainCmp");

	if($renderMode == "html") {		
		setLastReport("reservation.php?" . join("+",$_SERVER['argv']));
		$GLOBALS['temp']['headerSection'] = '
			<!--START General details - Res-->
			<td>
				<div id="leftHeaderScrollDiv" style="width: 504px; overflow: hidden;">
					<table id="headerTable" border="0" cellspacing="0" cellpadding="0" width="1070" style="table-layout: fixed;">
						<col id="colResNum" width="60" />
						<col id="colResName" width="95" />
						<col id="colDateCreate" width="110" />
						<col id="colResStatus" width="70" />
						<col id="colResStatusDate" width="100" />
						<col id="colRateType" width="90" />
						<col id="colResAgent" width="70" />
						<col id="colSource" width="80" />
						<col id="colOriginator" width="80" />
						<col id="colPax" width="46" />
						<col id="colBedNights" width="95" />
						<col id="colProperty" width="70" />
						<col id="colDateIn" width="82" />
						<col id="colDateOut" width="72" />
						<col width="30" />
						<tr style="height: 16px;">
							<td class="outDk" colspan="15" align="center" style="white-space: nowrap; overflow: hidden;">General Details</td>        
						</tr>
						<tr valign="top" style="height: !headerHeight!px;">
							<td class="outLt" name="colResNum">Res <span class="txtbbr imgLink" onclick="hideHeaderCol(\'colResNum\');">&lt;&lt;</span></td>
							<td class="outLt" name="colResName">Res Name <img class="imgLink printCollapse" onclick="generateReport(0,1);" id="arrowAsc1" src="/resource/Resrequest/Application/public/img/arrow_ascend_std.gif" width="10" height="10"><img class="imgLink printCollapse" onclick="generateReport(0,2);" id="arrowDsc2" src="/resource/Resrequest/Application/public/img/arrow_descend_std.gif" width="10" height="10"> <span class="txtbbr imgLink" onclick="hideHeaderCol(\'colResName\');">&lt;&lt;</span></td>
							<td class="outLt" name="colDateCreate">Date Created <img class="imgLink printCollapse" onclick="generateReport(0,9);" id="arrowAsc9" src="/resource/Resrequest/Application/public/img/arrow_ascend_std.gif" width="10" height="10"><img class="imgLink printCollapse" onclick="generateReport(0,10);" id="arrowDsc10" src="/resource/Resrequest/Application/public/img/arrow_descend_std.gif" width="10" height="10"> <span class="txtbbr imgLink" onclick="hideHeaderCol(\'colDateCreate\');">&lt;&lt;</span></td>
							<td class="outLt" name="colResStatus">Status <span class="txtbbr imgLink" onclick="hideHeaderCol(\'colResStatus\');">&lt;&lt;</span></td>
							<td class="outLt" name="colResStatusDate">Status Date <img class="imgLink printCollapse" onclick="generateReport(0,15);" id="arrowAsc15" src="/resource/Resrequest/Application/public/img/arrow_ascend_std.gif" width="10" height="10"><img class="imgLink printCollapse" onclick="generateReport(0,16);" id="arrowDsc16" src="/resource/Resrequest/Application/public/img/arrow_descend_std.gif" width="10" height="10"> <span class="txtbbr imgLink" onclick="hideHeaderCol(\'colResStatusDate\');">&lt;&lt;</span></td>
							<td class="outLt" name="colRateType">Rate Type <img class="imgLink printCollapse" onclick="generateReport(0,11);" id="arrowAsc11" src="/resource/Resrequest/Application/public/img/arrow_ascend_std.gif" width="10" height="10"><img class="imgLink printCollapse" onclick="generateReport(0,12);" id="arrowDsc12" src="/resource/Resrequest/Application/public/img/arrow_descend_std.gif" width="10" height="10"> <span class="txtbbr imgLink" onclick="hideHeaderCol(\'colRateType\');">&lt;&lt;</span></td>
							<td class="outLt" name="colResAgent">Agent <span class="txtbbr imgLink" onclick="hideHeaderCol(\'colResAgent\');">&lt;&lt;</span></td>
							<td class="outLt" name="colSource">Source <img class="imgLink printCollapse" onclick="generateReport(0,13);" id="arrowAsc13" src="/resource/Resrequest/Application/public/img/arrow_ascend_std.gif" width="10" height="10"><img class="imgLink printCollapse" onclick="generateReport(0,14);" id="arrowDsc14" src="/resource/Resrequest/Application/public/img/arrow_descend_std.gif" width="10" height="10"> <span class="txtbbr imgLink" onclick="hideHeaderCol(\'colSource\');">&lt;&lt;</span></td>
							<td class="outLt" align="center" name="colOriginator">Originator <span class="txtbbr imgLink" onclick="hideHeaderCol(\'colOriginator\');">&lt;&lt;</span></td>
							<td class="outLt" align="center" name="colPax">PAX <span class="txtbbr imgLink" onclick="hideHeaderCol(\'colPax\');">&lt;&lt;</span></td>
							<td class="outLt" align="center" name="colBedNights">Bed Nights<img class="imgLink printCollapse" onclick="generateReport(0,3);" id="arrowAsc3" src="/resource/Resrequest/Application/public/img/arrow_ascend_std.gif" width="10" height="10"><img class="imgLink printCollapse" onclick="generateReport(0,4);" id="arrowDsc4" src="/resource/Resrequest/Application/public/img/arrow_descend_std.gif" width="10" height="10"> <span class="txtbbr imgLink" onclick="hideHeaderCol(\'colBedNights\');">&lt;&lt;</span></td>
							<td class="outLt" name="colProperty">Properties <span class="txtbbr imgLink" onclick="hideHeaderCol(\'colProperty\');">&lt;&lt;</span></td>
							<td class="outLt" align="center" name="colDateIn">Date in<img class="imgLink printCollapse" onclick="generateReport(0,5);" id="arrowAsc5" src="/resource/Resrequest/Application/public/img/arrow_ascend_std.gif" width="10" height="10"><img class="imgLink printCollapse" onclick="generateReport(0,6);" id="arrowDsc6" src="/resource/Resrequest/Application/public/img/arrow_descend_std.gif" width="10" height="10"> <span class="txtbbr imgLink" onclick="hideHeaderCol(\'colDateIn\');">&lt;&lt;</span></td>
							<td class="outLt" align="center" name="colDateOut">Date out <span class="txtbbr imgLink" onclick="hideHeaderCol(\'colDateOut\');">&lt;&lt;</span></td>          
							<td class="outLt"><img src="/resource/Resrequest/Application/public/img/1x1.gif" /></td>
						</tr>
					</table>
				</div>
				<div id="leftScrollDiv" style="width: 504px; height: 470px;" class="scrollXY">
					<table id="headerTable2" cellspacing="0" cellpadding="0" style="table-layout:fixed;" width="1040" align="left">
						<col id="colResNum2" width="61">
						<col id="colResName2" width="95">
						<col id="colDateCreate2" width="110">
						<col id="colResStatus2" width="70">
						<col id="colResStatusDate2" width="100">
						<col id="colRateType2" width="90">
						<col id="colResAgent2" width="70">
						<col id="colSource2" width="80">
						<col id="colOriginator2" width="80" />
						<col id="colPax2" width="46">
						<col id="colBedNights2" width="95">
						<col id="colProperty2" width="70">
						<col id="colDateIn2" width="82">
						<col id="colDateOut2" width="72">
						!groupRows!
						!headerSectionTotals!
						!groupTotalRows!
						<tr>
							<td><img src="/resource/Resrequest/Application/public/img/1x1.gif" width="1" height="16" alt="" /></td>
						</tr>
					</table>
				</div>
			</td>
    	<!--END General details-->
		';
		
		$GLOBALS['temp']['reportHeaderWidth'] = "1040";
		$GLOBALS['temp']['colHideList'] = "['colResNum','colResName','colDateCreate','colResStatus','colResStatusDate','colRateType','colResAgent','colSource','colOriginator','colPax','colBedNights','colProperty','colDateIn','colDateOut','colCharges','colPayments','colTotals']";
		$paymentSpan = "1";
		if($showPayments == "1") {
			$paymentSpan = sizeof($bankList);
		}
		if($totalDisplay == "2") {
			$paymentSpan += 1;
		}

		$groupHTML = '
			<tr id="groupRow!num!" valign="top" onmouseover="highlightOn(!num!);" onmouseout="highlightOff(!num!);" onclick="rowClick(251,\'\',\'\',\'!currencyId!\',\'!reservationId!\');" style="height: 16px;">
				<td class="bl br bb" style="white-space: nowrap; overflow: hidden;" name="colResNum">!name!</td>
				<td class="br bb" style="white-space: nowrap; overflow: hidden;" name="colResName">!resName!</td>
				<td class="br bb" style="white-space: nowrap; overflow: hidden;" name="colDateCreate">!dateCreate!</td>
				<td class="br bb" style="white-space: nowrap; overflow: hidden; background-color: !resStatusColour!;" name="colResStatus">!resStatus!</td>
				<td class="br bb" style="white-space: nowrap; overflow: hidden;" name="colResStatusDate">!resStatusDate!</td>
				<td class="br bb" style="white-space: nowrap; overflow: hidden;" name="colRateType">!rateType!</td>
				<td class="br bb" style="white-space: nowrap; overflow: hidden;" name="colResAgent">!resAgent!</td>
				<td class="br bb" style="white-space: nowrap; overflow: hidden;" name="colSource">!resSource!</td>
				<td class="br bb" style="white-space: nowrap; overflow: hidden;" name="colOriginator">!resOriginator!</td>
				<td class="br bb" align="center" style="white-space: nowrap; overflow: hidden;" name="colPax">!pax!</td>
				<td class="br bb" align="center" style="white-space: nowrap; overflow: hidden;" name="colBedNights">!bednights!</td>
				<td class="br bb" onmouseover="overlib(\'!propertiesRaw!\');" onmouseout="nd();" style="white-space: nowrap; overflow: hidden;" name="colProperty">!properties!</td>
				<td class="br bb" align="center" style="white-space: nowrap; overflow: hidden;" name="colDateIn">!dateArrive!</td>
				<td class="br bb" align="center" style="white-space: nowrap; overflow: hidden;" name="colDateOut">!dateDepart!</td>
			</tr>
		';
		$groupHeader = "
			<tr>
				<td colspan=\"!chargeSpan!\" class=\"outDk\" align=\"center\" height=\"16\" name=\"colCharges\">Charges <span class=\"txtbbr imgLink\" onclick=\"hideDataCol('colCharges');\">&lt;&lt;</span></td>
				<td colspan=\"" . $paymentSpan . "\" class=\"outDk\" align=\"center\" height=\"16\" name=\"colPayments\">Payments <span class=\"txtbbr imgLink\" onclick=\"hideDataCol('colPayments');\">&lt;&lt;</span></td>
				<td colspan=\"3\" class=\"outDk\" align=\"center\" height=\"16\" name=\"colTotals\">Totals <span class=\"txtbbr imgLink\" onclick=\"hideDataCol('colTotals');\">&lt;&lt;</span></td>
				<td class=\"outDk\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
			</tr>
		";
		$colHeader = "
			<colgroup id=\"colCharges\">
		";
		$colHeader2 = "
			<colgroup id=\"colCharges2\">
		";
		$groupHeader2 = "
			<tr>
				<td rowspan=\"3\" class=\"outLt\" align=\"center\" name=\"colCharges\">Curr</td>
		";
		$groupHeader3 = "
			<tr>
		";
		$groupHeader4 = "
			<tr>
		";
		$colHeader .= "
			<col width=\"40\">
		";
		$colHeader2 .= "
			<col width=\"41\">
		";
		$chargeSpan = 1;
		if($showAccomm == "1") {
			$groupHeader2 .= "		
				<td colspan=\"".(sizeof($compList))."\" rowspan=\"2\" class=\"outLt\" align=\"center\" name=\"colCharges\">Accomm</td>
			";
			foreach($compList as $compItem) {
				$groupHeader4 .= "
					<td class=\"outLt\" height=\"16\" align=\"right\" style=\"white-space: nowrap; overflow: hidden;\" name=\"colCharges\">$compItem[name]</td>
				";
				$colHeader .= "
					<col width=\"80\" />
				";
				$colHeader2 .= "
					<col width=\"80\" />
				";
				$chargeSpan++;
			}
		} else {
			$groupHeader2 .= "
				<td  rowspan=\"3\" class=\"outLt\" align=\"center\" name=\"colCharges\">Accomm</td>
			";
			$colHeader .= "
				<col width=\"80\">
			";
			$colHeader2 .= "
				<col width=\"80\">
			";
			$chargeSpan++;
		}

		if($showExtras == "1") {
			$extraCount = 0;
			foreach($extraList as $extraCat) {
				if($showExtrasType == "1") {
					$groupHeader4 .= "
						<td class=\"outLt\" height=\"16\" align=\"center\" name=\"colCharges\">$extraCat[name]</td>
					";
					$colHeader .= "
						<col width=\"80\">
					";
					$colHeader2 .= "
						<col width=\"80\">
					";
					$chargeSpan++;
					$extraCount++;
				} else {
					$groupHeader3 .= "
						<td class=\"outLt\" height=\"16\" colspan=\"".(sizeof($extraCat['extras']))."\" align=\"center\" name=\"colCharges\">$extraCat[name]</td>
					";
					foreach($extraCat['extras'] as $extra) {
						$groupHeader4 .= "
							<td class=\"outLt\" height=\"16\" align=\"center\" name=\"colCharges\">$extra[name]</td>
						";
						$colHeader .= "
							<col width=\"80\">
						";
						$colHeader2 .= "
							<col width=\"80\">
						";
						$chargeSpan++;
						$extraCount++;
					}
				}
			}
			if($showExtrasType == "1") {
				$groupHeader2 .= "		
					<td rowspan=\"2\" colspan=\"".($extraCount)."\" class=\"outLt\" align=\"center\" name=\"colCharges\">Extras</td>
				";		
			} else {
				$groupHeader2 .= "		
					<td colspan=\"".($extraCount)."\" class=\"outLt\" align=\"center\" name=\"colCharges\">Extras</td>
				";		
			}
		} else {
			$groupHeader2 .= "
				<td  rowspan=\"3\" class=\"outLt\" align=\"center\" name=\"colCharges\">Extras</td>
			";
			$colHeader .= "
				<col width=\"80\">
			";
			$colHeader2 .= "
				<col width=\"80\">
			";
			$chargeSpan++;
		}
	
		if($showTravel == "1") {
			$travelCount = 0;
			foreach($travelList as $travelCat) {
				if($showTravelType == "1") {
					$groupHeader4 .= "
						<td class=\"outLt\" height=\"16\" align=\"center\" name=\"colCharges\">$travelCat[name]</td>
					";
					$colHeader .= "
						<col width=\"80\">
					";
					$colHeader2 .= "
						<col width=\"80\">
					";
					$chargeSpan++;
					$travelCount++;
				} else {
					$groupHeader3 .= "
						<td class=\"outLt\" height=\"16\" colspan=\"".(sizeof($travelCat['travel']))."\" align=\"center\" name=\"colCharges\">$travelCat[name]</td>
					";
					foreach($travelCat['travel'] as $travel) {
						$groupHeader4 .= "
							<td class=\"outLt\" height=\"16\" align=\"center\" name=\"colCharges\">$travel[name]</td>
						";
						$colHeader .= "
							<col width=\"80\">
						";
						$colHeader2 .= "
							<col width=\"80\">
						";
						$chargeSpan++;
						$travelCount++;
					}
				}
			}
			if($showTravelType == "1") {
				$groupHeader2 .= "		
					<td rowspan=\"2\" colspan=\"".($travelCount)."\" class=\"outLt\" align=\"center\" name=\"colCharges\">Travel</td>
				";		
			} else {
				$groupHeader2 .= "		
					<td colspan=\"".($travelCount)."\" class=\"outLt\" align=\"center\" name=\"colCharges\">Travel</td>
				";		
			}
		} else {
			$groupHeader2 .= "
				<td  rowspan=\"3\" class=\"outLt\" align=\"center\" name=\"colCharges\">Travel</td>
			";
			$colHeader .= "
				<col width=\"80\">
			";
			$colHeader2 .= "
				<col width=\"80\">
			";
			$chargeSpan++;
		}

		if($showTax == "1") {
			$colHeader .= "
				<col width=\"80\">
				<col width=\"80\">
				<col width=\"80\">
			";
			$colHeader2 .= "
				<col width=\"80\">
				<col width=\"80\">
				<col width=\"80\">
			";
			$groupHeader4 .= "
					<td class=\"outLt\" height=\"16\" align=\"center\" name=\"colCharges\">Accomm</td>
					<td class=\"outLt\" height=\"16\" align=\"center\" name=\"colCharges\">Extras</td>
					<td class=\"outLt\" height=\"16\" align=\"center\" name=\"colCharges\">Travel</td>
			";
			$groupHeader2 .= "
					<td  colspan=\"3\" rowspan=\"2\" class=\"outLt\" align=\"center\" name=\"colCharges\">Tax</td>
			";
			$chargeSpan += 3;
		} else {
			$colHeader .= "
				<col width=\"80\">
			";
			$colHeader2 .= "
				<col width=\"80\">
			";
			$groupHeader2 .= "
					<td  rowspan=\"3\" class=\"outLt\" align=\"center\" name=\"colCharges\">Tax</td>
			";
			$chargeSpan++;
		}

		$colHeader .= "
			</colgroup>
			<colgroup id=\"colPayments\">
		";
		$colHeader2 .= "
			</colgroup>
			<colgroup id=\"colPayments2\">
		";

		if($showPayments == "1") {
			$groupHeader2 .= "		
				<td colspan=\"".(sizeof($bankList))."\" rowspan=\"2\" class=\"outLt\" align=\"center\" name=\"colPayments\">Received</td>
			";
			foreach($bankList as $bankItem) {
				$groupHeader4 .= "
					<td class=\"outLt\" align=\"right\" name=\"colPayments\">$bankItem[name]</td>
				";
				$colHeader .= "
					<col width=\"80\">
				";
				$colHeader2 .= "
					<col width=\"80\">
				";
			}
		} else {
			$groupHeader2 .= "
				<td  rowspan=\"3\" class=\"outLt\" align=\"center\" name=\"colPayments\">Received</td>
			";
			$colHeader .= "
				<col width=\"80\">
			";
			$colHeader2 .= "
				<col width=\"80\">
			";
		}
		if($showReceipts == "1") {
			$groupHeader2 .= "
				<td  rowspan=\"3\" class=\"outLt\" align=\"center\" name=\"colPayments\">Receipts</td>
			";
			$colHeader .= "
				<col width=\"80\">
			";
			$colHeader2 .= "
				<col width=\"80\">
			";
		}		
		if($totalDisplay == "2") {
			$groupHeader2 .= "
				<td  rowspan=\"3\" class=\"outLt\" align=\"center\" name=\"colPayments\">Other</td>
			";
			$colHeader .= "
				<col width=\"80\">
			";
			$colHeader2 .= "
				<col width=\"80\">
			";
		}
		$colHeader .= "
			</colgroup>
			<colgroup id=\"colTotals\">
		";
		$colHeader2 .= "
			</colgroup>
			<colgroup id=\"colTotals2\">
		";

		$colHeader .= "
			<col width=\"80\">
		";
		$colHeader2 .= "
			<col width=\"80\">
		";
		$groupHeader2 .= "
				<td  rowspan=\"3\" class=\"outLt\" align=\"center\" name=\"colTotals\">Chargeable</td>
		";
	
		$colHeader .= "
			<col width=\"80\">
		";
		$colHeader2 .= "
			<col width=\"80\">
		";
		$groupHeader2 .= "
				<td  rowspan=\"3\" class=\"outLt\" align=\"center\" name=\"colTotals\">Balance</td>
		";
	
		if(sizeof($currencyList) > 1) {
			$colHeader .= "
				<col width=\"80\">
			";
			$colHeader2 .= "
				<col width=\"80\">
			";
			$groupHeader2 .= "
					<td  rowspan=\"3\" class=\"outLt\" align=\"center\" name=\"colTotals\">$revenueHeader</td>
			";
		} else {
			$colHeader .= "
				<col width=\"100\">
			";
			$colHeader2 .= "
				<col width=\"100\">
			";
			$groupHeader2 .= "
					<td  rowspan=\"3\" class=\"outLt\" align=\"center\" name=\"colTotals\">$revenueHeader <img class=\"imgLink printCollapse\" onclick=\"generateReport(0,7);\" id=\"arrowAsc7\" src=\"/resource/Resrequest/Application/public/img/arrow_ascend_std.gif\" width=\"10\" height=\"10\"><img class=\"imgLink printCollapse\" onclick=\"generateReport(0,8);\" id=\"arrowDsc8\" src=\"/resource/Resrequest/Application/public/img/arrow_descend_std.gif\" width=\"10\" height=\"10\"></td>
			";
			 
		}
	
		$colHeader .= "
			</colgroup>
		";
		$colHeader2 .= "
			</colgroup>
		";
		$groupRows = "";
		$groupRows2 = "";
		if($commissionFilterType == "1") {
			$amountType = "nett";
		} elseif($commissionFilterType == "2") {
			$amountType = "gross";
		} else {
			$amountType = "payable";
		}
		$rowNum = 0;
		foreach($list as $groupItem) {
			$groupId = $groupItem['id'];
			//$firstCurrency = true;
			foreach($groupItem['currencies'] as $currencyId=>$currencyItem) {
				/*if(!$firstCurrency) {
					$groupRows .= 
						str_replace("!name!",'&nbsp;',
						str_replace("!resName!","&nbsp;",
						str_replace("!pax!",'&nbsp;',
						str_replace("!bednights!",'&nbsp;',
						str_replace("!properties!","&nbsp;",
						str_replace("!dateArrive!","&nbsp;",
						str_replace("!dateDepart!","&nbsp;",
						str_replace("!num!",$rowNum,
					$groupHTML))))))));
				}
				$groupRows = str_replace("!currencyId!",$currencyId,
					str_replace("!reservationId!",$groupId,$groupRows));*/
				$groupRows .= str_replace("!name!",$groupItem['name'],
					str_replace("!pax!",$currencyItem['pax'],
					str_replace("!bednights!",$currencyItem['bedNights'],
					str_replace("!resName!",$groupItem['resName'],
					str_replace("!dateCreate!",$groupItem['dateCreate'],
					str_replace("!resStatus!",$groupItem['resStatus'],
					str_replace("!resStatusColour!",$groupItem['resStatusColour'],
					str_replace("!resStatusDate!",$groupItem['resStatusDate'],
					str_replace("!rateType!",$groupItem['rateType'],
					str_replace("!resAgent!",$groupItem['resAgent'],
					str_replace("!resSource!",$groupItem['resSource'],
					str_replace("!resOriginator!",$groupItem['resOriginator'],
					str_replace("!propertiesRaw!",$groupItem['propertiesRaw'],
					str_replace("!properties!",$groupItem['properties'],
					str_replace("!dateArrive!",$groupItem['dateArrive'],
					str_replace("!dateDepart!",$groupItem['dateDepart'],
					str_replace("!num!",$rowNum,
					str_replace("!currencyId!",$currencyId,
					str_replace("!reservationId!",$groupId,$groupHTML)))))))))))))))))));
				$groupRows2 .= "
					<tr id=\"groupRowData$rowNum\" onmouseover=\"highlightOn($rowNum);\"  onmouseout=\"highlightOff($rowNum);\" onclick=\"rowClick(251,'','','$currencyId','$groupId');\" style=\"height: 16px;\">
						<td class=\"br bb\" align=\"center\" name=\"colCharges\">".$currencyItem['name']."</td>
				";
				if($showAccomm == "1") {
					foreach($compList as $compItem) {
						$value = isset($currencyItem['accomm'][$compItem['id']][$amountType]) ? $currencyItem['accomm'][$compItem['id']][$amountType] : "";
						if($value == "") { $value = "&nbsp;"; }
						$groupRows2 .= "
							<td class=\"br bb\" align=\"right\" name=\"colCharges\">".$value."</td>
						";
					}
				} else {
					$value = isset($currencyItem['accomm_'.$amountType]) ? $currencyItem['accomm_'.$amountType] : "";
					if($value == "") { $value = "&nbsp;"; }
					$groupRows2 .= "
						<td class=\"br bb\" align=\"right\" name=\"colCharges\">$value</td>
					";
				}
				if($showExtras == "1") {
					foreach($extraList as $extraCat) {
						if($showExtrasType == "1") {
							$value = isset($currencyItem['extraCategories'][$extraCat['id']][$amountType]) ? $currencyItem['extraCategories'][$extraCat['id']][$amountType] : "";
							if($value == "") { $value = "&nbsp;"; }
							$groupRows2 .= "
								<td class=\"br bb\" align=\"right\" name=\"colCharges\">".$value."</td>
							";
						} else {
							foreach($extraCat['extras'] as $extraItem) {
								$value = isset($currencyItem['extras'][$extraItem['id']][$amountType]) ? $currencyItem['extras'][$extraItem['id']][$amountType] : "";
								if($value == "") { $value = "&nbsp;"; }
								$groupRows2 .= "
									<td class=\"br bb\" align=\"right\" name=\"colCharges\">".$value."</td>
								";						
							}
						}
					}
				} else {
					$value = isset($currencyItem['extra_'.$amountType]) ? $currencyItem['extra_'.$amountType] : "";
					if($value == "") { $value = "&nbsp;"; }
					$groupRows2 .= "
						<td class=\"br bb\" align=\"right\" name=\"colCharges\">$value</td>
					";
				}
			
				if($showTravel == "1") {
					foreach($travelList as $travelCat) {
						if($showTravelType == "1") {
							$value = isset($currencyItem['travelCategories'][$travelCat['id']][$amountType]) ? $currencyItem['travelCategories'][$travelCat['id']][$amountType] : "";
							if($value == "") { $value = "&nbsp;"; }
							$groupRows2 .= "
								<td class=\"br bb\" align=\"right\" name=\"colCharges\">".$value."</td>
							";
						} else {
							foreach($travelCat['travel'] as $travelItem) {
								$value = isset($currencyItem['travel'][$travelItem['id']][$amountType]) ? $currencyItem['travel'][$travelItem['id']][$amountType] : "";
								if($value == "") { $value = "&nbsp;"; }
								$groupRows2 .= "
									<td class=\"br bb\" align=\"right\" name=\"colCharges\">".$value."</td>
								";						
							}
						}
					}
				} else {
					$value = isset($currencyItem['travel_'.$amountType]) ? $currencyItem['travel_'.$amountType] : "";
					if($value == "") { $value = "&nbsp;"; }
					$groupRows2 .= "
						<td class=\"br bb\" align=\"right\" name=\"colCharges\">$value</td>
					";
				}

				$currencyItem['accomm_tax'] = isset($currencyItem['accomm_tax']) ? $currencyItem['accomm_tax'] : 0;
				$currencyItem['extra_tax'] = isset($currencyItem['extra_tax']) ? $currencyItem['extra_tax'] : 0;
				$currencyItem['travel_tax'] = isset($currencyItem['travel_tax']) ? $currencyItem['travel_tax'] : 0;

				$tax = $currencyItem['accomm_tax'] +  $currencyItem['extra_tax'] + $currencyItem['travel_tax'];
				fixAmtDisplay($tax,2);
				if($showTax == "1") {
					fixAmtDisplay($currencyItem['accomm_tax'],2);
					fixAmtDisplay($currencyItem['extra_tax'],2);
					fixAmtDisplay($currencyItem['travel_tax'],2);
					$groupRows2 .= "
						<td class=\"br bb\" align=\"right\" name=\"colCharges\">$currencyItem[accomm_tax]</td>
						<td class=\"br bb\" align=\"right\" name=\"colCharges\">$currencyItem[extra_tax]</td>
						<td class=\"br bb\" align=\"right\" name=\"colCharges\">$currencyItem[travel_tax]</td>
					";
				} else {
					$groupRows2 .= "
						<td class=\"br bb\" align=\"right\" name=\"colCharges\">$tax</td>
					";
				}

				if($showPayments == "1") {
					foreach($bankList as $bankItem) {
						$value = isset($currencyItem['payments'][$bankItem['id']]) ? $currencyItem['payments'][$bankItem['id']] : "";
						if($value == "") { $value = "&nbsp;"; }
						$groupRows2 .= "
							<td class=\"br bb\" align=\"right\" name=\"colPayments\">".$value."</td>
						";
					}
				} else {
					$value = isset($currencyItem['payment_total']) ? $currencyItem['payment_total'] : "";
					if($value == "") { $value = "&nbsp;"; }
					$groupRows2 .= "
						<td class=\"br bb\" align=\"right\" name=\"colPayments\">$value</td>
					";
				}
				if($showReceipts == "1") {
					$value = join(", ",$currencyItem['receipts']);
					if($value == "") { $value = "&nbsp;"; }
					$groupRows2 .= "
						<td class=\"br bb\" align=\"left\" name=\"colPayments\" onmouseover=\"overlib('$value');\" onmouseout=\"nd();\">$value</td>
					";
				}				
				if($totalDisplay == "2") {
					$value = isset($currencyItem['payment_other_total']) ? $currencyItem['payment_other_total'] : "";
					if($value == "") { $value = "&nbsp;"; }
					$groupRows2 .= "
						<td class=\"br bb\" align=\"right\" name=\"colPayments\">$value</td>
					";
				}
			
				$currencyItem['accomm_'.$amountType] = isset($currencyItem['accomm_'.$amountType]) ? $currencyItem['accomm_'.$amountType] : 0;
				$currencyItem['extra_'.$amountType] = isset($currencyItem['extra_'.$amountType]) ? $currencyItem['extra_'.$amountType] : 0;
				$currencyItem['travel_'.$amountType] = isset($currencyItem['travel_'.$amountType]) ? $currencyItem['travel_'.$amountType] : 0;

				$total = $currencyItem['accomm_'.$amountType] +  $currencyItem['extra_'.$amountType] + $currencyItem['travel_'.$amountType];
				if($taxFilterType == "1") {
					$total += $tax;
				} 
				$total = round($total,2);
				fixAmtDisplay($total,2);
				$groupRows2 .= "
						<td class=\"br bb\" align=\"right\" name=\"colTotals\">$total</td>
				";

				$currencyItem['accomm_'.$amountType] = isset($currencyItem['accomm_'.$amountType]) ? $currencyItem['accomm_'.$amountType] : 0;
				$currencyItem['extra_'.$amountType] = isset($currencyItem['extra_'.$amountType]) ? $currencyItem['extra_'.$amountType] : 0;
				$currencyItem['travel_'.$amountType] = isset($currencyItem['travel_'.$amountType]) ? $currencyItem['travel_'.$amountType] : 0;
				$currencyItem['payment_total'] = isset($currencyItem['payment_total']) ? $currencyItem['payment_total'] : 0;
				$currencyItem['payment_other_total'] = isset($currencyItem['payment_other_total']) ? $currencyItem['payment_other_total'] : 0;

				$balance = $currencyItem['accomm_'.$amountType] +  $currencyItem['extra_'.$amountType] + $currencyItem['travel_'.$amountType] - $currencyItem['payment_total'] - $currencyItem['payment_other_total'];
				if($taxFilterType == "1") {
					$balance += $tax;
				}
				$balance = round($balance,2);
				fixAmtDisplay($balance,2);
				$groupRows2 .= "
						<td class=\"br bb\" align=\"right\" name=\"colTotals\">$balance</td>
				";
			
				$revenue = $total;
				if($taxFilterType == "1") {
					$revenue -= $tax;
				}
				$revenue = round($revenue,2);
				fixAmtDisplay($revenue,2);
				$groupRows2 .= "
						<td class=\"br bb\" align=\"right\" name=\"colTotals\">$revenue</td>
				";
			
				$groupRows2 .= "
					</tr>
				";
				$firstCurrency = false;
				$rowNum++;
			}
		}

		
		$groupTotalRows = "";
		$totalCount = 0;
		$totalSize = sizeof($totals) -1;
		$first = true;
		foreach($totals as $totalId=>$totalItem) {
			if($totalCount < $totalSize) {
				$bb = "bb";
			} else {
				$bb = "bbdbl";
			}
			$bt = "";
			if($first) {
				$bt = "bt";
			}
			$groupTotalRows .= "<tr><td height=\"20\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td></tr>";
			$groupRows2 .= "<tr>
				<td class=\"br $bb $bt\" align=\"center\" name=\"colCharges2\" height=\"16\">$totalItem[name]</td>
			";
			if($showAccomm == "1") {
				foreach($totalItem['accomm'] as $compItem) {
					$groupRows2 .= "
						<td class=\"br $bb $bt\" align=\"right\" name=\"colCharges2\">".$compItem[$amountType]."</td>
					";				
				}	
			} else {
				$groupRows2 .= "
					<td class=\"br $bb $bt\" align=\"right\" name=\"colCharges2\">".$totalItem['accomm_'.$amountType]."</td>
				";
			}

			if($showExtras == "1") {
				if($showExtrasType == "1") {
					foreach($totalItem['extraCategories'] as $extraItem) {
						$groupRows2 .= "
							<td class=\"br $bb $bt\" align=\"right\" name=\"colCharges2\">".$extraItem[$amountType]."</td>
						";				
					}
				} else {
					foreach($totalItem['extra'] as $extraItem) {
						$groupRows2 .= "
							<td class=\"br $bb $bt\" align=\"right\" name=\"colCharges2\">".$extraItem[$amountType]."</td>
						";				
					}
				}
			} else {
				$groupRows2 .= "
					<td class=\"br $bb $bt\" align=\"right\" name=\"colCharges2\">".$totalItem['extra_'.$amountType]."</td>
				";
			}

			if($showTravel == "1") {
				if($showTravelType == "1") {
					foreach($totalItem['travelCategories'] as $travelItem) {
						$groupRows2 .= "
							<td class=\"br $bb $bt\" align=\"right\" name=\"colCharges2\">".$travelItem[$amountType]."</td>
						";				
					}
				} else {
					foreach($totalItem['travel'] as $travelItem) {
						$groupRows2 .= "
							<td class=\"br $bb $bt\" align=\"right\" name=\"colCharges2\">".$travelItem[$amountType]."</td>
						";				
					}
				}
			} else {
				$groupRows2 .= "
					<td class=\"br $bb $bt\" align=\"right\" name=\"colCharges2\">".$totalItem['travel_'.$amountType]."</td>
				";
			}

			$totalItem['accomm_tax'] = isset($totalItem['accomm_tax']) ? $totalItem['accomm_tax'] : 0;
			$totalItem['extra_tax'] = isset($totalItem['extra_tax']) ? $totalItem['extra_tax'] : 0;
			$totalItem['travel_tax'] = isset($totalItem['travel_tax']) ? $totalItem['travel_tax'] : 0;

			$tax = $totalItem['accomm_tax'] + $totalItem['extra_tax'] + $totalItem['travel_tax'];
			fixAmtDisplay($tax,2);
			if($showTax == "1") {
				fixAmtDisplay($totalItem['accomm_tax'],2);
				fixAmtDisplay($totalItem['extra_tax'],2);
				fixAmtDisplay($totalItem['travel_tax'],2);				
				$groupRows2 .= "
						<td class=\"br $bb $bt\" align=\"right\" name=\"colCharges2\">$totalItem[accomm_tax]</td>
						<td class=\"br $bb $bt\" align=\"right\" name=\"colCharges2\">$totalItem[extra_tax]</td>
						<td class=\"br $bb $bt\" align=\"right\" name=\"colCharges2\">$totalItem[travel_tax]</td>
				";
			} else {
				$groupRows2 .= "
						<td class=\"br $bb $bt\" align=\"right\" name=\"colCharges2\">".$tax."</td>
				";
			}

			if($showPayments == "1") {
				foreach($totalItem['payments'] as $paymentItem) {
					$groupRows2 .= "
						<td class=\"br $bb $bt\" align=\"right\" name=\"colPayments2\">".$paymentItem."</td>
					";								
				}			
			} else {
				$groupRows2 .= "
					<td class=\"br $bb $bt\" align=\"right\" name=\"colPayments2\">".$totalItem['payment_total']."</td>
				";			
			}
			if($showReceipts == "1") {
				$groupRows2 .= "
					<td class=\"br $bb $bt\" align=\"right\" name=\"colPayments2\">&nbsp;</td>
				";			
			}			
			if($totalDisplay == "2") {
				$groupRows2 .= "
					<td class=\"br $bb $bt\" align=\"right\" name=\"colPayments2\">".$totalItem['payment_other_total']."</td>
				";			
			}

			$total = $totalItem['accomm_'.$amountType] + $totalItem['extra_'.$amountType] + $totalItem['travel_'.$amountType];
			if($taxFilterType == "1") {
				$total += $tax;
			} 
			$total = round($total,2);
			fixAmtDisplay($total,2);
			$groupRows2 .= "
					<td class=\"br $bb $bt\" align=\"right\" name=\"colTotals2\">".$total."</td>
			";

			$total = isset($total) ? $total : 0;
			$totalItem['payment_total'] = isset($totalItem['payment_total']) ? $totalItem['payment_total'] : 0;
			$totalItem['payment_other_total'] = isset($totalItem['payment_other_total']) ? $totalItem['payment_other_total'] : 0;

			$balance = $total - $totalItem['payment_total'] - $totalItem['payment_other_total'];
			fixAmtDisplay($balance,2);
			$groupRows2 .= "
					<td class=\"br $bb $bt\" align=\"right\" name=\"colTotals2\">".$balance."</td>
			";

			$revenue = $total;
			if($taxFilterType == "1") {
				$revenue -= $tax;
			}
			$revenue = round($revenue,2);
			fixAmtDisplay($revenue,2);
			$groupRows2 .= "
					<td class=\"br $bb $bt\" align=\"right\" name=\"colTotals2\">".$revenue."</td>
			";
		
		
			$groupRows2 .= "</tr>";		
				
			$first = false;
			$totalCount++;
		}

		$groupHeader = str_replace("!chargeSpan!",$chargeSpan,$groupHeader);
		$groupHeader2 .= "<td rowspan=\"3\" class=\"outDk\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>";
		$groupHeader2 .= "</tr>";
		$groupHeader3 .= "</tr>";
		$groupHeader4 .= "</tr>";
		$GLOBALS['temp']['groupHeader'] = $groupHeader;
		$GLOBALS['temp']['groupHeader2'] = $groupHeader2;
		$GLOBALS['temp']['groupHeader3'] = $groupHeader3;
		$GLOBALS['temp']['groupHeader4'] = $groupHeader4;
		$GLOBALS['temp']['colHeader'] = $colHeader;
		$GLOBALS['temp']['colHeader2'] = $colHeader2;

		$headerSectionTotalHTML = '
			<tr valign="bottom">
				<td height="16"><img src="/resource/Resrequest/Application/public/img/1x1.gif"></td>
				<td class="txtb !bt! bl br !bb!" name="colResNum">!totals!</td>
				<td class="txtb !bt! br !bb!" name="colResName">&nbsp;</td>
				<td class="txtb !bt! br !bb!" name="colDateCreate">&nbsp;</td>
				<td class="txtb !bt! br !bb!" name="colResStatus">&nbsp;</td>
				<td class="txtb !bt! br !bb!" name="colResStatusDate">&nbsp;</td>
				<td class="txtb !bt! br !bb!" name="colRateType">&nbsp;</td>
				<td class="txtb !bt! br !bb!" name="colResAgent">&nbsp;</td>
				<td class="txtb !bt! br !bb!" name="colSource">&nbsp;</td>
				<td class="txtb !bt! br !bb!" align="center" name="colPax">!grandTotalPax!</td>
				<td class="txtb !bt! br !bb!" align="center" name="colBedNights">!grandTotalBedNights!</td>
				<td class="txtb !bt! br !bb!" name="colProperty">&nbsp;</td>
				<td class="txtb !bt! br !bb!" name="colDateIn">&nbsp;</td>
				<td class="txtb !bt! br !bb!" name="colDateOut">&nbsp;</td>
			</tr>
		';
		$headerSectionTotalRows = "";
		$first = true;
		$totalCount = 0;
		$totalSize = sizeof($totals) -1;
		foreach($totals as $totalId=>$totalItem) {
			$item = array(
				'totals'=>"&nbsp;",
				'bt'=>"",
				'bb'=>"",
				'grandTotalPax'=>"&nbsp;",
				'grandTotalBedNights'=>"&nbsp;"
			);
			
			if($first) {
				$item['totals'] = "Totals";
				$item['bt'] = "bt";
				$item['grandTotalPax'] = $grandTotalPax;
				$item['grandTotalBedNights'] = $grandTotalBedNights;
			}
			if($totalCount == $totalSize) {
				$item['bb'] = "bbdbl";
			}
			$headerSectionTotalRows .= showpage($item,$headerSectionTotalHTML);
			$first = false;
			$totalCount++;
		}	

		$headerHeight = 1;
		if($showAccomm == "1" || $showPayments == "1" || ($showExtras == "1" && $showExtrasType == "1") || ($showTravel == "1" && $showTravelType == "1") || $showTax == "1" ) { $headerHeight = 2; }
		if(($showExtras == "1" && $showExtrasType == "2") || ($showTravel == "1" && $showTravelType == "2") ) { $headerHeight = 3; }

		$headerHeight = $headerHeight * 16;
		$GLOBALS['temp']['headerSection'] = str_replace('!headerHeight!',$headerHeight,$GLOBALS['temp']['headerSection']);
		$GLOBALS['temp']['headerSection'] = str_replace('!groupRows!',$groupRows,$GLOBALS['temp']['headerSection']);
		$GLOBALS['temp']['headerSection'] = str_replace('!headerSectionTotals!',$headerSectionTotalRows,$GLOBALS['temp']['headerSection']);
		$GLOBALS['temp']['headerSection'] = str_replace('!groupTotalRows!',"",$GLOBALS['temp']['headerSection']);

		$GLOBALS['temp']['groupRows2'] = $groupRows2;
		$GLOBALS['temp']['groupTotals'] = "";
	
		$GLOBALS['temp']['reportDetailDivWidth'] = "266";

	}
	if ($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {
		$pdf = new PDF("Sales Journal");
		$reportLabel = "Sales Journal";
		// Main PDF header
		$headerArray = array(
			array('name' => "Date Range", 'value' => $fromDate['htmlDate'] . " to " . $toDate['htmlDate'])
		);
		$pdf->ReportHeader($reportLabel, $headerArray);
		$pdfFontSize = 8;
		$pdf->SetFont('Arial', '', $pdfFontSize);
		$pdf->SetFont('Arial', '', 7);

		$rowStart1 = array(
			array('width'=>"10%", 'data'=>"Res", 'fill'=>"1", 'border'=>"LTB"),
			array('width'=>"5%", 'data'=>"Res Name", 'fill'=>"1", 'border'=>"LTB",'align'=>"C"),
			array('width'=>"5%", 'data'=>"Status", 'fill'=>"1", 'border'=>"LTB",'align'=>"C"),
			array('width'=>"5%", 'data'=>"Agent", 'fill'=>"1", 'border'=>"LTB",'align'=>"C"),
			array('width'=>"5%", 'data'=>"Originator", 'fill'=>"1", 'border'=>"LTB",'align'=>"C"),
			array('width'=>"5%", 'data'=>"PAX", 'fill'=>"1", 'border'=>"LTB",'align'=>"C"),
			array('width'=>"5%", 'data'=>"Bed Nights", 'fill'=>"1", 'border'=>"LTB",'align'=>"C"),
			array('width'=>"5%", 'data'=>"Properties", 'fill'=>"1", 'border'=>"LTB",'align'=>"C"),
			array('width'=>"5%", 'data'=>"Date in", 'fill'=>"1", 'border'=>"LTB",'align'=>"C"),
			array('width'=>"5%", 'data'=>"Date out", 'fill'=>"1", 'border'=>"LTB",'align'=>"C"),
			array('width'=>"5%", 'data'=>"Curr", 'fill'=>"1", 'border'=>"LTBR",'align'=>"C")
		);
		$rowStart2 = array(
			array('width'=>"10%", 'fill'=>"1", 'border'=>"LTB"),
			array('width'=>"5%", 'fill'=>"1", 'border'=>"LTB"),
			array('width'=>"5%", 'fill'=>"1", 'border'=>"LTB"),
			array('width'=>"5%", 'fill'=>"1", 'border'=>"LTB"),
			array('width'=>"5%", 'fill'=>"1", 'border'=>"LTB"),
			array('width'=>"5%", 'fill'=>"1", 'border'=>"LTB"),
			array('width'=>"5%", 'fill'=>"1", 'border'=>"LTB"),	
			array('width'=>"5%", 'fill'=>"1", 'border'=>"LTB"),
			array('width'=>"5%", 'fill'=>"1", 'border'=>"LTB"),
			array('width'=>"5%", 'fill'=>"1", 'border'=>"LTBR")			
		);
		$rowStart3 = array(
			array('width'=>"10%", 'fill'=>"1", 'border'=>"LTB"),
			array('width'=>"5%", 'fill'=>"1", 'border'=>"LTB"),
			array('width'=>"5%", 'fill'=>"1", 'border'=>"LTB"),
			array('width'=>"5%", 'fill'=>"1", 'border'=>"LTB"),
			array('width'=>"5%", 'fill'=>"1", 'border'=>"LTB"),
			array('width'=>"5%", 'fill'=>"1", 'border'=>"LTB"),
			array('width'=>"5%", 'fill'=>"1", 'border'=>"LTB"),			
			array('width'=>"5%", 'fill'=>"1", 'border'=>"LTB"),
			array('width'=>"5%", 'fill'=>"1", 'border'=>"LTB"),
			array('width'=>"5%", 'fill'=>"1", 'border'=>"LTBR")			
		);

		$headerRows = array();
		$rowMax = 3;
		$headerRowCount = 0;
		$headerRowColCount = 0;
		$rows = array();

		array_push($headerRows,array($rowStart1,$rowStart2,$rowStart3));

		if($showAccomm == "1") {
			foreach($compList as $compItem) {
				array_push($headerRows[$headerRowCount][0],array('width'=>"12%", 'data'=>"Accommodation", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
				array_push($headerRows[$headerRowCount][1],array('width'=>"12%", 'data'=>$compItem['name'], 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
				array_push($headerRows[$headerRowCount][2],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
				$headerRowColCount++;
				if($headerRowColCount > $rowMax) {
					$headerRowCount++;
					array_push($headerRows,array($rowStart1,$rowStart2,$rowStart3));
					$headerRowColCount = 0;
				}
			}
		} else {
			array_push($headerRows[$headerRowCount][0],array('width'=>"12%", 'data'=>"Accommodation", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
			array_push($headerRows[$headerRowCount][1],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
			array_push($headerRows[$headerRowCount][2],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
			$headerRowColCount++;
			if($headerRowColCount > $rowMax) {
				$headerRowCount++;
				array_push($headerRows,array($rowStart1,$rowStart2,$rowStart3));
				$headerRowColCount = 0;
			}
		}

		if($showExtras == "1") {
			if($showExtrasType == "1") {
				foreach($extraList as $extraCat) {
					array_push($headerRows[$headerRowCount][0],array('width'=>"12%", 'data'=>"Extras", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
					array_push($headerRows[$headerRowCount][1],array('width'=>"12%", 'data'=>$extraCat['name'], 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
					array_push($headerRows[$headerRowCount][2],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
					$headerRowColCount++;
					if($headerRowColCount > $rowMax) {
						$headerRowCount++;
						array_push($headerRows,array($rowStart1,$rowStart2,$rowStart3));
						$headerRowColCount = 0;
					}
				}
			} else {
				foreach($extraList as $extraCat) {
					foreach($extraCat['extras'] as $extra) {
						array_push($headerRows[$headerRowCount][0],array('width'=>"12%", 'data'=>"Extras", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
						array_push($headerRows[$headerRowCount][1],array('width'=>"12%", 'data'=>$extraCat['name'], 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
						array_push($headerRows[$headerRowCount][2],array('width'=>"12%", 'data'=>$extra['name'], 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
						$headerRowColCount++;
						if($headerRowColCount > $rowMax) {
							$headerRowCount++;
							array_push($headerRows,array($rowStart1,$rowStart2,$rowStart3));
						$headerRowColCount = 0;
						}
					}
				}
			}
		} else {
			array_push($headerRows[$headerRowCount][0],array('width'=>"12%", 'data'=>"Extras", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
			array_push($headerRows[$headerRowCount][1],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
			array_push($headerRows[$headerRowCount][2],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
			$headerRowColCount++;
			if($headerRowColCount > $rowMax) {
				$headerRowCount++;
				array_push($headerRows,array($rowStart1,$rowStart2,$rowStart3));
				$headerRowColCount = 0;
			}
		}

		if($showTravel == "1") {
			if($showTravelType == "1") {
				foreach($travelList as $travelCat) {
					array_push($headerRows[$headerRowCount][0],array('width'=>"12%", 'data'=>"Travel", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
					array_push($headerRows[$headerRowCount][1],array('width'=>"12%", 'data'=>$travelCat['name'], 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
					array_push($headerRows[$headerRowCount][2],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
					$headerRowColCount++;
					if($headerRowColCount > $rowMax) {
						$headerRowCount++;
						array_push($headerRows,array($rowStart1,$rowStart2,$rowStart3));
						$headerRowColCount = 0;
					}
				}
			} else {
				foreach($travelList as $travelCat) {
					foreach($travelCat['travel'] as $travel) {
						array_push($headerRows[$headerRowCount][0],array('width'=>"12%", 'data'=>"Travel", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
						array_push($headerRows[$headerRowCount][1],array('width'=>"12%", 'data'=>$travelCat['name'], 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
						array_push($headerRows[$headerRowCount][2],array('width'=>"12%", 'data'=>$travel['name'], 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
						$headerRowColCount++;
						if($headerRowColCount > $rowMax) {
							$headerRowCount++;
							array_push($headerRows,array($rowStart1,$rowStart2,$rowStart3));
							$headerRowColCount = 0;
						}
					}
				}
			}
		} else {
			array_push($headerRows[$headerRowCount][0],array('width'=>"12%", 'data'=>"Travel", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
			array_push($headerRows[$headerRowCount][1],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
			array_push($headerRows[$headerRowCount][2],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
			$headerRowColCount++;
			if($headerRowColCount > $rowMax) {
				$headerRowCount++;
				array_push($headerRows,array($rowStart1,$rowStart2,$rowStart3));
				$headerRowColCount = 0;
			}
		}
		
		if($showTax == "1") {
			array_push($headerRows[$headerRowCount][0],array('width'=>"12%", 'data'=>"Tax", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
			array_push($headerRows[$headerRowCount][1],array('width'=>"12%", 'data'=>"Accommodation", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
			array_push($headerRows[$headerRowCount][2],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
			$headerRowColCount++;
			if($headerRowColCount > $rowMax) {
				$headerRowCount++;
				array_push($headerRows,array($rowStart1,$rowStart2,$rowStart3));
				$headerRowColCount = 0;
			}
			array_push($headerRows[$headerRowCount][0],array('width'=>"12%", 'data'=>"Tax", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
			array_push($headerRows[$headerRowCount][1],array('width'=>"12%", 'data'=>"Extras", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
			array_push($headerRows[$headerRowCount][2],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
			$headerRowColCount++;
			if($headerRowColCount > $rowMax) {
				$headerRowCount++;
				array_push($headerRows,array($rowStart1,$rowStart2,$rowStart3));
				$headerRowColCount = 0;
			}
			array_push($headerRows[$headerRowCount][0],array('width'=>"12%", 'data'=>"Tax", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
			array_push($headerRows[$headerRowCount][1],array('width'=>"12%", 'data'=>"Travel", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
			array_push($headerRows[$headerRowCount][2],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
			$headerRowColCount++;
			if($headerRowColCount > $rowMax) {
				$headerRowCount++;
				array_push($headerRows,array($rowStart1,$rowStart2,$rowStart3));
				$headerRowColCount = 0;
			}
			
		} else {
			array_push($headerRows[$headerRowCount][0],array('width'=>"12%", 'data'=>"Tax", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
			array_push($headerRows[$headerRowCount][1],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
			array_push($headerRows[$headerRowCount][2],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
			$headerRowColCount++;
			if($headerRowColCount > $rowMax) {
				$headerRowCount++;
				array_push($headerRows,array($rowStart1,$rowStart2,$rowStart3));
				$headerRowColCount = 0;
			}
		}

		if($groupBy != "property") {
			if($showPayments == "1") {
				foreach($bankList as $bankItem) {
					array_push($headerRows[$headerRowCount][0],array('width'=>"12%", 'data'=>"Received", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
					array_push($headerRows[$headerRowCount][1],array('width'=>"12%", 'data'=>$bankItem['name'], 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
					array_push($headerRows[$headerRowCount][2],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
					$headerRowColCount++;
					if($headerRowColCount > $rowMax) {
						$headerRowCount++;
						array_push($headerRows,array($rowStart1,$rowStart2,$rowStart3));
						$headerRowColCount = 0;
					}
				}
			} else {
				array_push($headerRows[$headerRowCount][0],array('width'=>"12%", 'data'=>"Received", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
				array_push($headerRows[$headerRowCount][1],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
				array_push($headerRows[$headerRowCount][2],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
				$headerRowColCount++;
				if($headerRowColCount > $rowMax) {
					$headerRowCount++;
					array_push($headerRows,array($rowStart1,$rowStart2,$rowStart3));
					$headerRowColCount = 0;
				}
			}
			if($showReceipts == "1") {
				array_push($headerRows[$headerRowCount][0],array('width'=>"12%", 'data'=>"Receipts", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
				array_push($headerRows[$headerRowCount][1],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
				array_push($headerRows[$headerRowCount][2],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
				$headerRowColCount++;
				if($headerRowColCount > $rowMax) {
					$headerRowCount++;
					array_push($headerRows,array($rowStart1,$rowStart2,$rowStart3));
					$headerRowColCount = 0;
				}
			}			
			if($totalDisplay == "2") {
				array_push($headerRows[$headerRowCount][0],array('width'=>"12%", 'data'=>"Other", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
				array_push($headerRows[$headerRowCount][1],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
				array_push($headerRows[$headerRowCount][2],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
				$headerRowColCount++;
				if($headerRowColCount > $rowMax) {
					$headerRowCount++;
					array_push($headerRows,array($rowStart1,$rowStart2,$rowStart3));
					$headerRowColCount = 0;
				}
			}
		}
		
		array_push($headerRows[$headerRowCount][0],array('width'=>"12%", 'data'=>"Chargeable", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
		array_push($headerRows[$headerRowCount][1],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
		array_push($headerRows[$headerRowCount][2],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
		$headerRowColCount++;
		if($headerRowColCount > $rowMax) {
			$headerRowCount++;
			array_push($headerRows,array($rowStart1,$rowStart2,$rowStart3));
			$headerRowColCount = 0;
		}

		if($groupBy != "property") {
			array_push($headerRows[$headerRowCount][0],array('width'=>"12%", 'data'=>"Balance", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
			array_push($headerRows[$headerRowCount][1],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
			array_push($headerRows[$headerRowCount][2],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
			$headerRowColCount++;
			if($headerRowColCount > $rowMax) {
				$headerRowCount++;
				array_push($headerRows,array($rowStart1,$rowStart2,$rowStart3));
				$headerRowColCount = 0;
			}
		}
	
		array_push($headerRows[$headerRowCount][0],array('width'=>"12%", 'data'=>$revenueHeader, 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
		array_push($headerRows[$headerRowCount][1],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));
		array_push($headerRows[$headerRowCount][2],array('width'=>"12%", 'data'=>"", 'fill'=>"1", 'border'=>"LTBR",'align'=>"R"));

		$currRow = 3;
		foreach($list as $groupItem) {
			$headerRowCount = 0;
			$headerRowColCount = 0;
			$groupId = $groupItem['id'];
			foreach($groupItem['currencies'] as $currencyId=>$currencyItem) {
				$rowStart = array(
					array('width'=>"10%",'data'=>$groupItem['name'],'border'=>"LTBR"),
					array('width'=>"5%",'data'=>$groupItem['resName'],'border'=>"LTBR"),
					array('width'=>"5%",'data'=>$groupItem['dateCreate'],'border'=>"LTBR"),
					array('width'=>"5%",'data'=>$groupItem['resStatus'],'border'=>"LTBR"),
					array('width'=>"5%",'data'=>$groupItem['resStatusDate'],'border'=>"LTBR"),
					array('width'=>"5%",'data'=>$groupItem['rateType'],'border'=>"LTBR"),
					array('width'=>"5%",'data'=>$groupItem['resAgent'],'border'=>"LTBR"),
					array('width'=>"5%",'data'=>$groupItem['resSource'],'border'=>"LTBR"),
					array('width'=>"5%",'data'=>$groupItem['resOriginator'],'border'=>"LTBR"),
					array('width'=>"5%",'data'=>$currencyItem['pax'],'border'=>"LTBR",'align'=>"C"),
					array('width'=>"5%",'data'=>$currencyItem['bedNights'],'border'=>"LTBR",'align'=>"C"),
					array('width'=>"5%",'data'=>$groupItem['properties'],'border'=>"LTBR"),
					array('width'=>"5%",'data'=>$groupItem['dateArrive'],'border'=>"LTBR"),
					array('width'=>"5%",'data'=>$groupItem['dateDepart'],'border'=>"LTBR"),					
					array('width'=>"5%",'data'=>$currencyItem['name'],'border'=>"LTBR",'align'=>"C")
				);
				$headerRows[$headerRowCount][$currRow] = $rowStart;
				if($showAccomm == "1") {
					foreach($compList as $compItem) {
						$currencyItem['accomm'][$compItem['id']][$amountType] = isset($currencyItem['accomm'][$compItem['id']][$amountType]) ? $currencyItem['accomm'][$compItem['id']][$amountType] : 0;
						array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$currencyItem['accomm'][$compItem['id']][$amountType],'border'=>"LTBR",'align'=>"R"));
						$headerRowColCount++;
						if($headerRowColCount > $rowMax) {
							$headerRowCount++;
							$headerRows[$headerRowCount][$currRow] = $rowStart;
							$headerRowColCount = 0;
						}
					}
				} else {
					$currencyItem['accomm_'.$amountType] = isset($currencyItem['accomm_'.$amountType]) ? $currencyItem['accomm_'.$amountType] : 0;
					array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$currencyItem['accomm_'.$amountType],'border'=>"LTBR",'align'=>"R"));
					$headerRowColCount++;
					if($headerRowColCount > $rowMax) {
						$headerRowCount++;
						$headerRows[$headerRowCount][$currRow] = $rowStart;
						$headerRowColCount = 0;
					}
				}
				if($showExtras == "1") {
					if($showExtrasType == "1") {
						foreach($extraList as $extraCat) {
							$currencyItem['extraCategories'][$extraCat['id']][$amountType] = isset($currencyItem['extraCategories'][$extraCat['id']][$amountType]) ? $currencyItem['extraCategories'][$extraCat['id']][$amountType] : 0;
							array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$currencyItem['extraCategories'][$extraCat['id']][$amountType],'border'=>"LTBR",'align'=>"R"));
							$headerRowColCount++;
							if($headerRowColCount > $rowMax) {
								$headerRowCount++;
								$headerRows[$headerRowCount][$currRow] = $rowStart;
								$headerRowColCount = 0;
							}
						}						
					} else {
						foreach($extraList as $extraCat) {
							foreach($extraCat['extras'] as $extraItem) {
								$currencyItem['extras'][$extraItem['id']][$amountType] = isset($currencyItem['extras'][$extraItem['id']][$amountType]) ? $currencyItem['extras'][$extraItem['id']][$amountType] : 0;
								array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$currencyItem['extras'][$extraItem['id']][$amountType],'border'=>"LTBR",'align'=>"R"));
								$headerRowColCount++;
								if($headerRowColCount > $rowMax) {
									$headerRowCount++;
									$headerRows[$headerRowCount][$currRow] = $rowStart;
									$headerRowColCount = 0;
								}
							}
						}
					}
				} else {
					$currencyItem['extra_'.$amountType] = isset($currencyItem['extra_'.$amountType]) ? $currencyItem['extra_'.$amountType] : 0;
					array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$currencyItem['extra_'.$amountType],'border'=>"LTBR",'align'=>"R"));
					$headerRowColCount++;
					if($headerRowColCount > $rowMax) {
						$headerRowCount++;
						$headerRows[$headerRowCount][$currRow] = $rowStart;
						$headerRowColCount = 0;
					}
				}			
				if($showTravel == "1") {
					if($showTravelType == "1") {
						foreach($travelList as $travelCat) {
							$currencyItem['travelCategories'][$travelCat['id']][$amountType] = isset($currencyItem['travelCategories'][$travelCat['id']][$amountType]) ? $currencyItem['travelCategories'][$travelCat['id']][$amountType] : 0;
							array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$currencyItem['travelCategories'][$travelCat['id']][$amountType],'border'=>"LTBR",'align'=>"R"));
							$headerRowColCount++;
							if($headerRowColCount > $rowMax) {
								$headerRowCount++;
								$headerRows[$headerRowCount][$currRow] = $rowStart;
								$headerRowColCount = 0;
							}
						}
					} else {
						foreach($travelList as $travelCat) {
							foreach($travelCat['travel'] as $travelItem) {
								$currencyItem['travel'][$travelItem['id']][$amountType] = isset($currencyItem['travel'][$travelItem['id']][$amountType]) ? $currencyItem['travel'][$travelItem['id']][$amountType] : 0;
								array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$currencyItem['travel'][$travelItem['id']][$amountType],'border'=>"LTBR",'align'=>"R"));
								$headerRowColCount++;
								if($headerRowColCount > $rowMax) {
									$headerRowCount++;
									$headerRows[$headerRowCount][$currRow] = $rowStart;
									$headerRowColCount = 0;
								}
							}
						}
					}
				} else {
					$currencyItem['travel_'.$amountType] = isset($currencyItem['travel_'.$amountType]) ? $currencyItem['travel_'.$amountType] : 0;
					array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$currencyItem['travel_'.$amountType],'border'=>"LTBR",'align'=>"R"));
					$headerRowColCount++;
					if($headerRowColCount > $rowMax) {
						$headerRowCount++;
						$headerRows[$headerRowCount][$currRow] = $rowStart;
						$headerRowColCount = 0;
					}
				}

				$currencyItem['accomm_tax'] = isset($currencyItem['accomm_tax']) ? $currencyItem['accomm_tax'] : 0;
				$currencyItem['extra_tax'] = isset($currencyItem['extra_tax']) ? $currencyItem['extra_tax'] : 0;
				$currencyItem['travel_tax'] = isset($currencyItem['travel_tax']) ? $currencyItem['travel_tax'] : 0;

				$tax = $currencyItem['accomm_tax'] +  $currencyItem['extra_tax'] + $currencyItem['travel_tax'];
				fixAmtDisplay($tax,2);
				if($showTax == "1") {
					fixAmtDisplay($currencyItem['accomm_tax'],2);
					fixAmtDisplay($currencyItem['extra_tax'],2);
					fixAmtDisplay($currencyItem['travel_tax'],2);
					array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$currencyItem['accomm_tax'],'border'=>"LTBR",'align'=>"R"));
					$headerRowColCount++;
					if($headerRowColCount > $rowMax) {
						$headerRowCount++;
						$headerRows[$headerRowCount][$currRow] = $rowStart;
						$headerRowColCount = 0;
					}
					array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$currencyItem['extra_tax'],'border'=>"LTBR",'align'=>"R"));
					$headerRowColCount++;
					if($headerRowColCount > $rowMax) {
						$headerRowCount++;
						$headerRows[$headerRowCount][$currRow] = $rowStart;
						$headerRowColCount = 0;
					}
					array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$currencyItem['travel_tax'],'border'=>"LTBR",'align'=>"R"));
					$headerRowColCount++;
					if($headerRowColCount > $rowMax) {
						$headerRowCount++;
						$headerRows[$headerRowCount][$currRow] = $rowStart;
						$headerRowColCount = 0;
					}
					
				} else {
					array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$tax,'border'=>"LTBR"));
					$headerRowColCount++;
					if($headerRowColCount > $rowMax) {
						$headerRowCount++;
						$headerRows[$headerRowCount][$currRow] = $rowStart;
						$headerRowColCount = 0;
					}
				}

				if($groupBy != "property") {
					if($showPayments == "1") {
						foreach($bankList as $bankItem) {
							$currencyItem['payments'][$bankItem['id']] = isset($currencyItem['payments'][$bankItem['id']]) ? $currencyItem['payments'][$bankItem['id']] : 0;
							array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$currencyItem['payments'][$bankItem['id']],'border'=>"LTBR",'align'=>"R"));
							$headerRowColCount++;
							if($headerRowColCount > $rowMax) {
								$headerRowCount++;
								$headerRows[$headerRowCount][$currRow] = $rowStart;
								$headerRowColCount = 0;
							}
						}
					} else {
						$currencyItem['payment_total'] = isset($currencyItem['payment_total']) ? $currencyItem['payment_total'] : 0;
						array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$currencyItem['payment_total'],'border'=>"LTBR",'align'=>"R"));
						$headerRowColCount++;
						if($headerRowColCount > $rowMax) {
							$headerRowCount++;
							$headerRows[$headerRowCount][$currRow] = $rowStart;
							$headerRowColCount = 0;
						}
					}
					if($showReceipts == "1") {
						$currencyItem['receipts'] = isset($currencyItem['receipts']) ? $currencyItem['receipts'] : 0;
						array_push($headerRows[$headerRowCount][$currRow],array('width'=>"8%", 'data'=>join(", ",$currencyItem['receipts']),'border'=>"LTBR",'align'=>"R"));
						$headerRowColCount++;
						if($headerRowColCount > $rowMax) {
							$headerRowCount++;
							$headerRows[$headerRowCount][$currRow] = $rowStart;
							$headerRowColCount = 0;
						}
					}
					if($totalDisplay == "2") {
						$currencyItem['payment_other_total'] = isset($currencyItem['payment_other_total']) ? $currencyItem['payment_other_total'] : 0;
						array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$currencyItem['payment_other_total'],'border'=>"LTBR",'align'=>"R"));
						$headerRowColCount++;
						if($headerRowColCount > $rowMax) {
							$headerRowCount++;
							$headerRows[$headerRowCount][$currRow] = $rowStart;
							$headerRowColCount = 0;
						}
					}
				}
				
				$currencyItem['accomm_'.$amountType] = isset($currencyItem['accomm_'.$amountType]) ? $currencyItem['accomm_'.$amountType] : 0;
				$currencyItem['extra_'.$amountType] = isset($currencyItem['extra_'.$amountType]) ? $currencyItem['extra_'.$amountType] : 0;
				$currencyItem['travel_'.$amountType] = isset($currencyItem['travel_'.$amountType]) ? $currencyItem['travel_'.$amountType] : 0;

				$total = $currencyItem['accomm_'.$amountType] +  $currencyItem['extra_'.$amountType] + $currencyItem['travel_'.$amountType];
				if($taxFilterType == "1") {
					$total += $tax;
				} 
				$total = round($total,2);
				fixAmtDisplay($total,2);
				array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$total,'border'=>"LTBR",'align'=>"R"));
				$headerRowColCount++;
				if($headerRowColCount > $rowMax) {
					$headerRowCount++;
					$headerRows[$headerRowCount][$currRow] = $rowStart;
					$headerRowColCount = 0;
				}

				if($groupBy != "property") {
					$currencyItem['accomm_'.$amountType] = isset($currencyItem['accomm_'.$amountType]) ? $currencyItem['accomm_'.$amountType] : 0;
					$currencyItem['extra_'.$amountType] = isset($currencyItem['extra_'.$amountType]) ? $currencyItem['extra_'.$amountType] : 0;
					$currencyItem['travel_'.$amountType] = isset($currencyItem['travel_'.$amountType]) ? $currencyItem['travel_'.$amountType] : 0;
					$currencyItem['payment_total'] = isset($currencyItem['payment_total']) ? $currencyItem['payment_total'] : 0;
					$currencyItem['payment_other_total'] = isset($currencyItem['payment_other_total']) ? $currencyItem['payment_other_total'] : 0;

					$balance = $currencyItem['accomm_'.$amountType] +  $currencyItem['extra_'.$amountType] + $currencyItem['travel_'.$amountType] - $currencyItem['payment_total'] - $currencyItem['payment_other_total'];
					if($taxFilterType == "1") {
						$balance += $tax;
					}
					$balance = round($balance,2);
					fixAmtDisplay($balance,2);
					array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$balance,'border'=>"LTBR",'align'=>"R"));
					$headerRowColCount++;
					if($headerRowColCount > $rowMax) {
						$headerRowCount++;
						$headerRows[$headerRowCount][$currRow] = $rowStart;
						$headerRowColCount = 0;
					}
				}
			
				$revenue = $total;
				if($taxFilterType == "1") {
					$revenue -= $tax;
				}
				$revenue = round($revenue,2);
				fixAmtDisplay($revenue,2);
				array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$revenue,'border'=>"LTBR",'align'=>"R"));
			
				$firstCurrency = false;

				$currRow++;
			}
		}
		
		foreach($totals as $totalId=>$totalItem) {
			$headerRowCount = 0;
			$headerRowColCount = 0;
			$rowStart = array(
				array('width'=>"10%",'data'=>"Totals",'border'=>"LTBR",'fill'=>"1"),
				array('width'=>"5%",'data'=>"",'border'=>"LTBR",'fill'=>"1"),
				array('width'=>"5%",'data'=>"",'border'=>"LTBR",'fill'=>"1"),
				array('width'=>"5%",'data'=>"",'border'=>"LTBR",'fill'=>"1"),
				array('width'=>"5%",'data'=>$grandTotalPax,'border'=>"LTBR",'align'=>"C",'fill'=>"1"),
				array('width'=>"5%",'data'=>$grandTotalBedNights,'border'=>"LTBR",'align'=>"C",'fill'=>"1"),
				array('width'=>"5%",'data'=>"",'border'=>"LTBR",'fill'=>"1"),
				array('width'=>"5%",'data'=>"",'border'=>"LTBR",'fill'=>"1"),
				array('width'=>"5%",'data'=>"",'border'=>"LTBR",'fill'=>"1"),
				array('width'=>"5%",'data'=>$totalItem['name'],'border'=>"LTBR",'align'=>"C",'fill'=>"1"),
			);
			$headerRows[$headerRowCount][$currRow] = $rowStart;
			if($showAccomm == "1") {
				foreach($totalItem['accomm'] as $compItem) {
					$compItem[$amountType] = isset($compItem[$amountType]) ? $compItem[$amountType] : 0;
					array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$compItem[$amountType],'border'=>"LTBR",'align'=>"R",'fill'=>"1"));
					$headerRowColCount++;
					if($headerRowColCount > $rowMax) {
						$headerRowCount++;
						$headerRows[$headerRowCount][$currRow] = $rowStart;
						$headerRowColCount = 0;
					}
				}	
			} else {
				$totalItem['accomm_'.$amountType] = isset($totalItem['accomm_'.$amountType]) ? $totalItem['accomm_'.$amountType] : 0;
				array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$totalItem['accomm_'.$amountType],'border'=>"LTBR",'align'=>"R",'fill'=>"1"));
				$headerRowColCount++;
				if($headerRowColCount > $rowMax) {
					$headerRowCount++;
					$headerRows[$headerRowCount][$currRow] = $rowStart;
					$headerRowColCount = 0;
				}
			}
			if($showExtras == "1") {
				if($showExtrasType == "1") {
					foreach($totalItem['extraCategories'] as $extraItem) {
						$extraItem[$amountType] = isset($extraItem[$amountType]) ? $extraItem[$amountType] : 0;
						array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$extraItem[$amountType],'border'=>"LTBR",'align'=>"R",'fill'=>"1"));
						$headerRowColCount++;
						if($headerRowColCount > $rowMax) {
							$headerRowCount++;
							$headerRows[$headerRowCount][$currRow] = $rowStart;
							$headerRowColCount = 0;
						}
					}
				} else {
					foreach($totalItem['extra'] as $extraItem) {
						$extraItem[$amountType] = isset($extraItem[$amountType]) ? $extraItem[$amountType] : 0;
						array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$extraItem[$amountType],'border'=>"LTBR",'align'=>"R",'fill'=>"1"));
						$headerRowColCount++;
						if($headerRowColCount > $rowMax) {
							$headerRowCount++;
							$headerRows[$headerRowCount][$currRow] = $rowStart;
							$headerRowColCount = 0;
						}
					}
				}
			} else {
				$totalItem['extra_'.$amountType] = isset($totalItem['extra_'.$amountType]) ? $totalItem['extra_'.$amountType] : 0;
				array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$totalItem['extra_'.$amountType],'border'=>"LTBR",'align'=>"R",'fill'=>"1"));
				$headerRowColCount++;
				if($headerRowColCount > $rowMax) {
					$headerRowCount++;
					$headerRows[$headerRowCount][$currRow] = $rowStart;
					$headerRowColCount = 0;
				}
			}

			if($showTravel == "1") {
				if($showTravelType == "1") {
					foreach($totalItem['travelCategories'] as $travelItem) {
						$travelItem[$amountType] = isset($travelItem[$amountType]) ? $travelItem[$amountType] : 0;
						array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$travelItem[$amountType],'border'=>"LTBR",'align'=>"R",'fill'=>"1"));
						$headerRowColCount++;
						if($headerRowColCount > $rowMax) {
							$headerRowCount++;
							$headerRows[$headerRowCount][$currRow] = $rowStart;
							$headerRowColCount = 0;
						}
					}
				} else {
					foreach($totalItem['travel'] as $travelItem) {
						$travelItem[$amountType] = isset($travelItem[$amountType]) ? $travelItem[$amountType] : 0;
						array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$travelItem[$amountType],'border'=>"LTBR",'align'=>"R",'fill'=>"1"));
						$headerRowColCount++;
						if($headerRowColCount > $rowMax) {
							$headerRowCount++;
							$headerRows[$headerRowCount][$currRow] = $rowStart;
							$headerRowColCount = 0;
						}
					}
				}
			} else {
				$totalItem['travel_'.$amountType] = isset($totalItem['travel_'.$amountType]) ? $totalItem['travel_'.$amountType] : 0;
				array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$totalItem['travel_'.$amountType],'border'=>"LTBR",'align'=>"R",'fill'=>"1"));
				$headerRowColCount++;
				if($headerRowColCount > $rowMax) {
					$headerRowCount++;
					$headerRows[$headerRowCount][$currRow] = $rowStart;
					$headerRowColCount = 0;
				}
			}

			$totalItem['accomm_tax'] = isset($totalItem['accomm_tax']) ? $totalItem['accomm_tax'] : 0;
			$totalItem['extra_tax'] = isset($totalItem['extra_tax']) ? $totalItem['extra_tax'] : 0;
			$totalItem['travel_tax'] = isset($totalItem['travel_tax']) ? $totalItem['travel_tax'] : 0;

			$tax = $totalItem['accomm_tax'] + $totalItem['extra_tax'] + $totalItem['travel_tax'];
			fixAmtDisplay($tax,2);
			if($showTax == "1") {
				fixAmtDisplay($totalItem['accomm_tax'],2);
				fixAmtDisplay($totalItem['extra_tax'],2);
				fixAmtDisplay($totalItem['travel_tax'],2);				
				array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$totalItem['accomm_tax'],'border'=>"LTBR",'align'=>"R",'fill'=>"1"));
				$headerRowColCount++;
				if($headerRowColCount > $rowMax) {
					$headerRowCount++;
					$headerRows[$headerRowCount][$currRow] = $rowStart;
					$headerRowColCount = 0;
				}
				array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$totalItem['extra_tax'],'border'=>"LTBR",'align'=>"R",'fill'=>"1"));
				$headerRowColCount++;
				if($headerRowColCount > $rowMax) {
					$headerRowCount++;
					$headerRows[$headerRowCount][$currRow] = $rowStart;
					$headerRowColCount = 0;
				}
				array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$totalItem['travel_tax'],'border'=>"LTBR",'align'=>"R",'fill'=>"1"));
				$headerRowColCount++;
				if($headerRowColCount > $rowMax) {
					$headerRowCount++;
					$headerRows[$headerRowCount][$currRow] = $rowStart;
					$headerRowColCount = 0;
				}
			} else {
				array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$tax,'border'=>"LTBR",'align'=>"R",'fill'=>"1"));
				$headerRowColCount++;
				if($headerRowColCount > $rowMax) {
					$headerRowCount++;
					$headerRows[$headerRowCount][$currRow] = $rowStart;
					$headerRowColCount = 0;
				}
			}

			if($groupBy != "property") {
				if($showPayments == "1") {
					foreach($totalItem['payments'] as $paymentItem) {
						array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$paymentItem,'border'=>"LTBR",'align'=>"R",'fill'=>"1"));
						$headerRowColCount++;
						if($headerRowColCount > $rowMax) {
							$headerRowCount++;
							$headerRows[$headerRowCount][$currRow] = $rowStart;
							$headerRowColCount = 0;
						}
					}			
				} else {
					$totalItem['payment_total'] = isset($totalItem['payment_total']) ? $totalItem['payment_total'] : 0;
					array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$totalItem['payment_total'],'border'=>"LTBR",'align'=>"R",'fill'=>"1"));
					$headerRowColCount++;
					if($headerRowColCount > $rowMax) {
						$headerRowCount++;
						$headerRows[$headerRowCount][$currRow] = $rowStart;
						$headerRowColCount = 0;
					}
				}
				if($showReceipts == "1") {
					array_push($headerRows[$headerRowCount][$currRow],array('width'=>"8%", 'data'=>"",'border'=>"LTBR",'align'=>"R",'fill'=>"1"));
					$headerRowColCount++;
					if($headerRowColCount > $rowMax) {
						$headerRowCount++;
						$headerRows[$headerRowCount][$currRow] = $rowStart;
						$headerRowColCount = 0;
					}
				}
				if($totalDisplay == "2") {
					$totalItem['payment_other_total'] = isset($totalItem['payment_other_total']) ? $totalItem['payment_other_total'] : 0;
					array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$totalItem['payment_other_total'],'border'=>"LTBR",'align'=>"R",'fill'=>"1"));
					$headerRowColCount++;
					if($headerRowColCount > $rowMax) {
						$headerRowCount++;
						$headerRows[$headerRowCount][$currRow] = $rowStart;
						$headerRowColCount = 0;
					}
				}
			}

			$total = $totalItem['accomm_'.$amountType] + $totalItem['extra_'.$amountType] + $totalItem['travel_'.$amountType];
			if($taxFilterType == "1") {
				$total += $tax;
			} 
			$total = round($total,2);
			fixAmtDisplay($total,2);
			array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$total,'border'=>"LTBR",'align'=>"R",'fill'=>"1"));
			$headerRowColCount++;
			if($headerRowColCount > $rowMax) {
				$headerRowCount++;
				$headerRows[$headerRowCount][$currRow] = $rowStart;
				$headerRowColCount = 0;
			}

			if($groupBy != "property") {
				$total = isset($total) ? $total : 0;
				$totalItem['payment_total'] = isset($totalItem['payment_total']) ? $totalItem['payment_total'] : 0;
				$totalItem['payment_other_total'] = isset($totalItem['payment_other_total']) ? $totalItem['payment_other_total'] : 0;

				$balance = $total - $totalItem['payment_total'] - $totalItem['payment_other_total'];
				fixAmtDisplay($balance,2);
				array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$balance,'border'=>"LTBR",'align'=>"R",'fill'=>"1"));
				$headerRowColCount++;
				if($headerRowColCount > $rowMax) {
					$headerRowCount++;
					$headerRows[$headerRowCount][$currRow] = $rowStart;
					$headerRowColCount = 0;
				}
			}

			$revenue = $total;
			if($taxFilterType == "1") {
				$revenue -= $tax;
			}
			$revenue = round($revenue,2);
			fixAmtDisplay($revenue,2);
			array_push($headerRows[$headerRowCount][$currRow],array('width'=>"12%", 'data'=>$revenue,'border'=>"LTBR",'align'=>"R",'fill'=>"1"));
		
			$currRow++;
		}

		foreach($headerRows as $headerRow) {
			foreach($headerRow as $headerItem) {
				$pdf->Row($headerItem);
			}
			$pdf->Ln(10);
		}

		$pdf->Ln(2);
		if($renderType == "view") {
			$pdf->OutPut();
			die();
		}
		if($renderType == "send") {
			$to = $_POST['mail_to'];
			$from = $_POST['mail_from'];
			$subject = $_POST['mail_subj'];
			$message = $_POST['mail_body'];
			$attachmentName = $_POST['attachmentName'];

			$headers = "From: ".$GLOBALS['princName']."<$from>\r\n";

			// close the pdf
			if($pdf->state<3) $pdf->Close();

			/* and now mail it */
			if($attachmentName != "!attachmentName!") {
				$pdfName = $attachmentName;
			} else {
				$pdfName = "Update report from $fromDate to $toDate.pdf";
			}

			$error = email($from, $to, $subject, $headers, $message, 0, 0, $_SERVER['argv'][1], $GLOBALS['princName'],$pdf->buffer,$pdfName);     // (from, to, subject, headers, message, action, emailID, resID)
			if(!$error) {
				echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
				die();
			} else {
				echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
				die();
			}
      }
	}
	if($renderMode == "csv") {
		$csvFile = array();
		array_push($csvFile,array("Sales by Reservation"));
		array_push($csvFile,array());
		array_push($csvFile,array("Date Range",$fromDate['htmlDate'] . " to " . $toDate['htmlDate']));
		array_push($csvFile,array("Displaying totals",($totalDisplay=="1"?"By invoice date":"By day")));
		switch($invoiceStatus) {
		case 1:
			$invoiceStatusDesc = "Invoiced";
			break;
		case 2:
			$invoiceStatusDesc = "Uninvoiced";
			break;
		default:
			$invoiceStatusDesc = "Invoiced and uninvoiced";
		}
		array_push($csvFile,array("Invoice Status",$invoiceStatusDesc));
		array_push($csvFile,array("Property / Accommodation Filter",$accommFilter['names']));
		if($extraFilterType == "1") {
			array_push($csvFile,array("Extra Category Filter",$extraCategoryFilter['names']));
		} else {
			array_push($csvFile,array("Extra Category Filter",$extraFilter['names']));
		}
		array_push($csvFile,array("Currency Filter",$currenciesFilter['names']));
		if($agentSelect == "1") {
			array_push($csvFile,array("Agent Name Filter",$agentFilter['names']));
		} else {
			array_push($csvFile,array("Agent Country Filter (Postal)",$agentCountryFilter['names']));
		}
		array_push($csvFile,array("Consultant Filter",$consultantFilter['names']));
		array_push($csvFile,array("Originator Filter",$originatorFilter['names']));
		array_push($csvFile,array("Nationality Filter",$nationalityFilter['names']));
		array_push($csvFile,array("Rate Filter",$rateFilter['names']));
		array_push($csvFile,array("Source Filter",$sourceFilter['names']));
		array_push($csvFile,array("Status Filter",$statusFilter['names']));
		array_push($csvFile,array("Accommodation Details",($showAccomm=="1"?"Yes":"No")));
		array_push($csvFile,array("Travel Details",($showTravel=="1"?"Yes, " . ($showTravelType=="1"?"by category":"by category and item"):"No")));
		array_push($csvFile,array("Extras Details",($showExtras=="1"?"Yes, " . ($showExtrasType=="1"?"by category":"by category and item"):"No")));
		array_push($csvFile,array("Payments Details",($showPayments=="1"?"Yes":"No")));
		array_push($csvFile,array("Receipt Details",($showReceipts=="1"?"Yes":"No")));
		array_push($csvFile,array("Tax Details",($showTax=="1"?"Yes":"No")));
		if($commissionFilterType == "1") {
			array_push($csvFile,array("Commission","Nett"));
		} elseif($commissionFilterType == "2") {
			array_push($csvFile,array("Commission","Gross"));
		} elseif($commissionFilterType == "3") {
			array_push($csvFile,array("Commission","Payable"));
		}
		array_push($csvFile,array("Include Tax",($taxFilterType!="1"?"Yes":"No")));
		array_push($csvFile,array());

		$header1 = array("Reservation Number","Reservation Name","Date Created","Status","Status Date","Rate Type","Agent","Source","Originator","PAX","Bed Nights","Properties","Date In","Date Out","Currency");
		$header2 = array("","","","","","","","","","","","","","","");
		$header3 = array("","","","","","","","","","","","","","","");

		if($showAccomm == "1") {
			foreach($compList as $compItem) {
				array_push($header1,"Accommodation");
				array_push($header2,$compItem['name']);
				array_push($header3,"");
			}
		} else {
			array_push($header1,"Accommodation");
			array_push($header2,"");
			array_push($header3,"");
		}

		if($showExtras == "1") {
			if($showExtrasType == "1") {
				foreach($extraList as $extraCat) {
						array_push($header1,"Extras");
						array_push($header2,$extraCat['name']);
						array_push($header3,"");
				}
			} else {
				foreach($extraList as $extraCat) {
					foreach($extraCat['extras'] as $extra) {
						array_push($header1,"Extras");
						array_push($header2,$extraCat['name']);
						array_push($header3,$extra['name']);
					}
				}
			}
		} else {
			array_push($header1,"Extras");
			array_push($header2,"");
			array_push($header3,"");
		}
	
		if($showTravel == "1") {
			if($showTravelType == "1") {
				foreach($travelList as $travelCat) {
					array_push($header1,"Travel");
					array_push($header2,$travelCat['name']);
					array_push($header3,"");
				}
			} else {
				foreach($travelList as $travelCat) {
					foreach($travelCat['travel'] as $travel) {
						array_push($header1,"Travel");
						array_push($header2,$travelCat['name']);
						array_push($header3,$travel['name']);
					}
				}
			}
		} else {
			array_push($header1,"Travel");
			array_push($header2,"");
			array_push($header3,"");
		}

		if($showTax == "1") {
			array_push($header1,"Tax");
			array_push($header1,"Tax");
			array_push($header1,"Tax");
			array_push($header2,"Accommodation");
			array_push($header2,"Extras");
			array_push($header2,"Travel");
			array_push($header3,"");
			array_push($header3,"");
			array_push($header3,"");
		} else {
			array_push($header1,"Tax");
			array_push($header2,"");
			array_push($header3,"");
		}

		if($groupBy != "property") {
			if($showPayments == "1") {
				foreach($bankList as $bankItem) {
					array_push($header1,"Received");
					array_push($header2,$bankItem['name']);
					array_push($header3,"");
				}
			} else {
				array_push($header1,"Received");
				array_push($header2,"");
				array_push($header3,"");
			}
			if($showReceipts == "1") {
				array_push($header1,"Receipts");
				array_push($header2,"");
				array_push($header3,"");
			}			
			if($totalDisplay == "2") {
				array_push($header1,"Other");
				array_push($header2,"");
				array_push($header3,"");
			}
		}

		array_push($header1,"Chargeable");
		array_push($header2,"");
		array_push($header3,"");
	
		if($groupBy != "property") {
			array_push($header1,"Balance");
			array_push($header2,"");
			array_push($header3,"");
		}
	
		array_push($header1,$revenueHeader);
		array_push($header2,"");
		array_push($header3,"");

		array_push($csvFile,$header1);
		array_push($csvFile,$header2);
		array_push($csvFile,$header3);

		foreach($list as $groupItem) {
			$groupId = $groupItem['id'];
			foreach($groupItem['currencies'] as $currencyId=>$currencyItem) {
				$row = array($groupItem['name'],$groupItem['resName'],$groupItem['dateCreate'],$groupItem['resStatus'],$groupItem['resStatusDate'],$groupItem['rateType'],$groupItem['resAgent'],$groupItem['resSource'],$groupItem['resOriginator'],$currencyItem['pax'],$currencyItem['bedNights'],$groupItem['properties'],$groupItem['dateArrive'],$groupItem['dateDepart'],$currencyItem['name']);
				if($showAccomm == "1") {
					foreach($compList as $compItem) {
						$currencyItem['accomm'][$compItem['id']][$amountType] = isset($currencyItem['accomm'][$compItem['id']][$amountType]) ? $currencyItem['accomm'][$compItem['id']][$amountType] : 0;
						array_push($row,$currencyItem['accomm'][$compItem['id']][$amountType]);
					}
				} else {
					$currencyItem['accomm_'.$amountType] = isset($currencyItem['accomm_'.$amountType]) ? $currencyItem['accomm_'.$amountType] : 0;
					array_push($row,$currencyItem['accomm_'.$amountType]);
				}
				if($showExtras == "1") {
					if($showExtrasType == "1") {
						foreach($extraList as $extraCat) {
							$currencyItem['extraCategories'][$extraCat['id']][$amountType] = isset($currencyItem['extraCategories'][$extraCat['id']][$amountType]) ? $currencyItem['extraCategories'][$extraCat['id']][$amountType] : 0;
							array_push($row,$currencyItem['extraCategories'][$extraCat['id']][$amountType]);
						}						
					} else {
						foreach($extraList as $extraCat) {
							foreach($extraCat['extras'] as $extraItem) {
								$currencyItem['extras'][$extraItem['id']][$amountType] = isset($currencyItem['extras'][$extraItem['id']][$amountType]) ? $currencyItem['extras'][$extraItem['id']][$amountType] : 0;
								array_push($row,$currencyItem['extras'][$extraItem['id']][$amountType]);
							}
						}
					}
				} else {
					$currencyItem['extra_'.$amountType] = isset($currencyItem['extra_'.$amountType]) ? $currencyItem['extra_'.$amountType] : 0;
					array_push($row,$currencyItem['extra_'.$amountType]);
				}			
				if($showTravel == "1") {
					if($showTravelType == "1") {
						foreach($travelList as $travelCat) {
							$currencyItem['travelCategories'][$travelCat['id']][$amountType] = isset($currencyItem['travelCategories'][$travelCat['id']][$amountType]) ? $currencyItem['travelCategories'][$travelCat['id']][$amountType] : 0;
							array_push($row,$currencyItem['travelCategories'][$travelCat['id']][$amountType]);
						}
					} else {
						foreach($travelList as $travelCat) {
							foreach($travelCat['travel'] as $travelItem) {
								$currencyItem['travel'][$travelItem['id']][$amountType] = isset($currencyItem['travel'][$travelItem['id']][$amountType]) ? $currencyItem['travel'][$travelItem['id']][$amountType] : 0;
								array_push($row,$currencyItem['travel'][$travelItem['id']][$amountType]);
							}
						}
					}
				} else {
					$currencyItem['travel_'.$amountType] = isset($currencyItem['travel_'.$amountType]) ? $currencyItem['travel_'.$amountType] : 0;
					array_push($row,$currencyItem['travel_'.$amountType]);
				}

				$currencyItem['accomm_tax'] = isset($currencyItem['accomm_tax']) ? $currencyItem['accomm_tax'] : 0;
				$currencyItem['extra_tax'] = isset($currencyItem['extra_tax']) ? $currencyItem['extra_tax'] : 0;
				$currencyItem['travel_tax'] = isset($currencyItem['travel_tax']) ? $currencyItem['travel_tax'] : 0;

				$tax = $currencyItem['accomm_tax'] +  $currencyItem['extra_tax'] + $currencyItem['travel_tax'];
				fixAmtDisplay($tax,2);
				if($showTax == "1") {
					fixAmtDisplay($currencyItem['accomm_tax'],2);
					fixAmtDisplay($currencyItem['extra_tax'],2);
					fixAmtDisplay($currencyItem['travel_tax'],2);
					array_push($row,$currencyItem['accomm_tax']);
					array_push($row,$currencyItem['extra_tax']);
					array_push($row,$currencyItem['travel_tax']);
				} else {
					array_push($row,$tax);
				}

				if($groupBy != "property") {
					if($showPayments == "1") {
						foreach($bankList as $bankItem) {
							$currencyItem['payments'][$bankItem['id']] = isset($currencyItem['payments'][$bankItem['id']]) ? $currencyItem['payments'][$bankItem['id']] : 0;
							array_push($row,$currencyItem['payments'][$bankItem['id']]);
						}
					} else {
						$currencyItem['payment_total'] = isset($currencyItem['payment_total']) ? $currencyItem['payment_total'] : 0;
						array_push($row,$currencyItem['payment_total']);
					}
					if($showReceipts == "1") {
						array_push($row,join(", ",$currencyItem['receipts']));
					}			
					if($totalDisplay == "2") {
						$currencyItem['payment_other_total'] = isset($currencyItem['payment_other_total']) ? $currencyItem['payment_other_total'] : 0;
						array_push($row,$currencyItem['payment_other_total']);
					}
				}
				
				$currencyItem['accomm_'.$amountType] = isset($currencyItem['accomm_'.$amountType]) ? $currencyItem['accomm_'.$amountType] : 0;
				$currencyItem['extra_'.$amountType] = isset($currencyItem['extra_'.$amountType]) ? $currencyItem['extra_'.$amountType] : 0;
				$currencyItem['travel_'.$amountType] = isset($currencyItem['travel_'.$amountType]) ? $currencyItem['travel_'.$amountType] : 0;

				$total = $currencyItem['accomm_'.$amountType] +  $currencyItem['extra_'.$amountType] + $currencyItem['travel_'.$amountType];
				if($taxFilterType == "1") {
					$total += $tax;
				} 
				$total = round($total,2);
				fixAmtDisplay($total,2);
				array_push($row,$total);

				if($groupBy != "property") {
					$currencyItem['accomm_'.$amountType] = isset($currencyItem['accomm_'.$amountType]) ? $currencyItem['accomm_'.$amountType] : 0;
					$currencyItem['extra_'.$amountType] = isset($currencyItem['extra_'.$amountType]) ? $currencyItem['extra_'.$amountType] : 0;
					$currencyItem['travel_'.$amountType] = isset($currencyItem['travel_'.$amountType]) ? $currencyItem['travel_'.$amountType] : 0;
					$currencyItem['payment_total'] = isset($currencyItem['payment_total']) ? $currencyItem['payment_total'] : 0;
					$currencyItem['payment_other_total'] = isset($currencyItem['payment_other_total']) ? $currencyItem['payment_other_total'] : 0;

					$balance = $currencyItem['accomm_'.$amountType] +  $currencyItem['extra_'.$amountType] + $currencyItem['travel_'.$amountType] - $currencyItem['payment_total'] - $currencyItem['payment_other_total'];
					if($taxFilterType == "1") {
						$balance += $tax;
					}
					$balance = round($balance,2);
					fixAmtDisplay($balance,2);
					array_push($row,$balance);
				}
			
				$revenue = $total;
				if($taxFilterType == "1") {
					$revenue -= $tax;
				}
				$revenue = round($revenue,2);
				fixAmtDisplay($revenue,2);
				array_push($row,$revenue);
			
				$firstCurrency = false;
				array_push($csvFile,$row);
			}
		}

		array_push($csvFile,array());
		foreach($totals as $totalId=>$totalItem) {
			$totalRow = array("Totals","","","","","","","",$grandTotalPax,$grandTotalBedNights,"","","");
			array_push($totalRow,$totalItem['name']);
			if($showAccomm == "1") {
				foreach($totalItem['accomm'] as $compItem) {
					$compItem[$amountType] = isset($compItem[$amountType]) ? $compItem[$amountType] : 0;
					array_push($totalRow,$compItem[$amountType]);
				}	
			} else {
				$totalItem['accomm_'.$amountType] = isset($totalItem['accomm_'.$amountType]) ? $totalItem['accomm_'.$amountType] : 0;
				array_push($totalRow,$totalItem['accomm_'.$amountType]);
			}
			if($showExtras == "1") {
				if($showExtrasType == "1") {
					foreach($totalItem['extraCategories'] as $extraItem) {
						$extraItem[$amountType] = isset($extraItem[$amountType]) ? $extraItem[$amountType] : 0;
						array_push($totalRow,$extraItem[$amountType]);
					}
				} else {
					foreach($totalItem['extra'] as $extraItem) {
						$extraItem[$amountType] = isset($extraItem[$amountType]) ? $extraItem[$amountType] : 0;
						array_push($totalRow,$extraItem[$amountType]);
					}
				}
			} else {
				$totalItem['extra_'.$amountType] = isset($totalItem['extra_'.$amountType]) ? $totalItem['extra_'.$amountType] : 0;
				array_push($totalRow,$totalItem['extra_'.$amountType]);
			}

			if($showTravel == "1") {
				if($showTravelType == "1") {
					foreach($totalItem['travelCategories'] as $travelItem) {
						$travelItem[$amountType] = isset($travelItem[$amountType]) ? $travelItem[$amountType] : 0;
						array_push($totalRow,$travelItem[$amountType]);
					}
				} else {
					foreach($totalItem['travel'] as $travelItem) {
						$travelItem[$amountType] = isset($travelItem[$amountType]) ? $travelItem[$amountType] : 0;
						array_push($totalRow,$travelItem[$amountType]);
					}
				}
			} else {
				$totalItem['travel_'.$amountType] = isset($totalItem['travel_'.$amountType]) ? $totalItem['travel_'.$amountType] : 0;
				array_push($totalRow,$totalItem['travel_'.$amountType]);
			}

			$totalItem['accomm_tax'] = isset($totalItem['accomm_tax']) ? $totalItem['accomm_tax'] : 0;
			$totalItem['extra_tax'] = isset($totalItem['extra_tax']) ? $totalItem['extra_tax'] : 0;
			$totalItem['travel_tax'] = isset($totalItem['travel_tax']) ? $totalItem['travel_tax'] : 0;

			$tax = $totalItem['accomm_tax'] + $totalItem['extra_tax'] + $totalItem['travel_tax'];
			fixAmtDisplay($tax,2);
			if($showTax == "1") {
				fixAmtDisplay($totalItem['accomm_tax'],2);
				fixAmtDisplay($totalItem['extra_tax'],2);
				fixAmtDisplay($totalItem['travel_tax'],2);				
				array_push($totalRow,$totalItem['accomm_tax']);
				array_push($totalRow,$totalItem['extra_tax']);
				array_push($totalRow,$totalItem['travel_tax']);
			} else {
				array_push($totalRow,$tax);
			}

			if($groupBy != "property") {
				if($showPayments == "1") {
					foreach($totalItem['payments'] as $paymentItem) {
						array_push($totalRow,$paymentItem);
					}			
				} else {
					array_push($totalRow,$totalItem['payment_total']);
				}
				if($showReceipts == "1") {
					array_push($totalRow,"");
				}
				if($totalDisplay == "2") {
					array_push($totalRow,$totalItem['payment_other_total']);
				}
			}

			$total = $totalItem['accomm_'.$amountType] + $totalItem['extra_'.$amountType] + $totalItem['travel_'.$amountType];
			if($taxFilterType == "1") {
				$total += $tax;
			} 
			$total = round($total,2);
			fixAmtDisplay($total,2);
			array_push($totalRow,$total);

			if($groupBy != "property") {
				$total = isset($total) ? $total : 0;
				$totalItem['payment_total'] = isset($totalItem['payment_total']) ? $totalItem['payment_total'] : 0;
				$totalItem['payment_other_total'] = isset($totalItem['payment_other_total']) ? $totalItem['payment_other_total'] : 0;

				$balance = $total - $totalItem['payment_total'] - $totalItem['payment_other_total'];
				fixAmtDisplay($balance,2);
				array_push($totalRow,$balance);
			}

			$revenue = $total;
			if($taxFilterType == "1") {
				$revenue -= $tax;
			}
			$revenue = round($revenue,2);
			fixAmtDisplay($revenue,2);
			array_push($totalRow,$revenue);
		
			array_push($csvFile,$totalRow);
		}		
	
		$csvText = "";
		foreach($csvFile as $csvLine) {
			$first = true;
			foreach($csvLine as $csvItem) {
				if(!$first) {
					$csvText .= ",";
				} else {
					$first = false;
				}
				$csvText .= "\"".str_replace("\"","\"\"",$csvItem)."\"";
			}
			$csvText .= "\n";
		}
   
		if(headers_sent()) {
			//    echo('Some data has already been output to browser, can\'t send PDF file');
		}
		header('Content-Type: text/csv');
		header("Cache-control: private");
		header('Content-Length: '.strlen($csvText));
		$filename = str_replace(" ","_",strtolower("sales_journal_reservation_".$fromDate['htmlDate']." to ".$toDate['htmlDate'].".csv"));
		header("Content-Disposition: inline; filename=$filename");
		echo $csvText;
		flush();
		die();
	}
