<?php

/*
 * $Id: init.form327.php,v 1.11 2011-08-25 10:29:46 light Exp $
 *
 * $Log: init.form327.php,v $
 * Revision 1.11  2011-08-25 10:29:46  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.10  2011-05-17 14:08:30  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.9  2007-07-18 14:31:07  gregs
 * Bug #6004 - Cannot add custom note
 *
 */

/**
 * init.form327.php - Custom Notes Listing
 * Job: 758,759,760,761,762,763,766
 * Function: 89 (Code Tables: Custom notes)
 */

if (!isset($GLOBALS[$form]) || !is_object($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"","");
}

if ( sizeof($GLOBALS[$form]->RecordList) < "1" ) {
	$RecordStart = "0";
	$RecordListSQL = "
		SELECT DISTINCT
			rf_note_custom.rf_note_custom_ix,
			rf_note_custom.rf_note_custom_desc,
			rf_note_custom.rf_note_custom_hdg,
			rf_note_custom.rf_note_custom_db
		FROM
			rf_note_custom
		ORDER BY 
			rf_note_custom.rf_note_custom_desc
	";
	$countsql		= "SELECT COUNT(*) FROM rf_note_custom";
	$tempcount	= $GLOBALS['lDB']->get($countsql,"1");

	$GLOBALS['temp']['numrows'] = $tempcount[0];
	$RecordCount = $tempcount[0];

	$imgPath = $GLOBALS['http']. $GLOBALS['images_dir'] ."/" . $GLOBALS['principal_id'] . "/custom/";

	if ( checkjob("761") == true) {
		// Edit
		$selectjob = "761";
	} else {
		// View
		$selectjob = "758";
	}

	$GLOBALS['temp']['sortjob'] = $_SERVER['argv'][0];

	$GLOBALS['temp']['selectjob'] = $selectjob;    
	$GLOBALS['temp']['rows'] = "";

	$counti = 0;
	if ( $RecordCount != 0 ) {
		$recordid = $GLOBALS['lDB']->get($RecordListSQL,2);
		for ( $i = 0; $i < $RecordCount; $i++ ) {
			$rf_note_custom_ix		= $recordid[$i][0];
			$rf_note_custom_desc	= $recordid[$i][1];
			$rf_note_custom_hdg		= $recordid[$i][2];
			$rf_note_custom_db		= $recordid[$i][3];


			if ( $rf_note_custom_ix != "" ) {
				$custom_note = array();
				$custNoteItems = $GLOBALS['lDB']->get("
					SELECT
						rf_note_cust_item.rf_note_cust_item_path AS imgName,
						rf_note_cust_item.rf_note_cust_item_text AS text,
						rf_note_cust_item.rf_note_custom_id
					FROM 
						rf_note_cust_item 
					WHERE 
						rf_note_cust_item.rf_note_custom_id = '" . $rf_note_custom_ix . "'
					ORDER BY 
						rf_note_cust_item.rf_note_cust_item_seq
				",2);

				$custom_note['rf_note_custom_ix']		= $rf_note_custom_ix;
				$custom_note['rf_note_custom_desc']	= $rf_note_custom_desc;
        $custom_note['rf_note_custom_hdg']	= $rf_note_custom_hdg;

				$customNote = '<span class="txtb u">' . $rf_note_custom_hdg . '</span><br />';

				foreach ( $custNoteItems as $items ) {
					if ( $items['text'] != "" || $items['text'] != null ) {
						$customNote .= t_encodeHTML($items['text']) . "<br /><br />";
					} else {
						$imgName = str_replace(".","_thmb.",$items['imgName']);
						$customNote	.= '<img src="' . $imgPath . $imgName . '" alt="" /><br /><br />';
					}
				}

				$custom_note['customNote'] = $customNote;

				if ( $rf_note_custom_ix == $record ) {
					$custom_note['rf_note_custom_desc'] = t_encodeHTML($rf_note_custom_desc);
				} else {
					if ( canEditDB($rf_note_custom_db) ) {						
						$custom_note['rf_note_custom_desc'] = "<div id='name" . (string) $counti++ . "' style='display: inline;'>" . t_encodeHTML($rf_note_custom_desc) . "</div>";
					} else {
						$custom_note['rf_note_custom_desc'] = "<div class='txtg' id='name" . (string) $counti++ . "' style='display: inline;'>" . t_encodeHTML($rf_note_custom_desc) . "</div>";
					}
				}				
				if ( $record == $rf_note_custom_ix && $action == "3" ) {
					$counti--;
					$custom_note['rf_note_custom_desc'] = $rf_note_custom_desc;
				}

				$custom_note['selectjob'] = $selectjob;
				if ( canEditDB($rf_note_custom_db) ) {
					$custom_note['rowClass']	= "linkrow";
					$custom_note['itemClass']	= "";
					$custom_note['canEdit']		= "";
				} else {
					$custom_note['rowClass']	= "";
					$custom_note['itemClass']	= "txtg";
					$custom_note['canEdit']		= "return;";
				}

				// Add this line to each code table ---------------------------------------
				$HTML			= __DIR__ . "/../../../public/html/code_custom_notes_rows.htm";
				$rowHtml = Join("",File($HTML));

				$GLOBALS['temp']['rows'] .= showpage($custom_note,$rowHtml);
			}
		}
	}

	$GLOBALS['temp']['rowCount'] = (string) $counti;

	if ( $GLOBALS['temp']['rows'] == "" ) {
		$it = '
			<tr>
				<td align="center" colspan="2" class="bb">There are no existing custom notes</td>
			</tr>
		';
		$GLOBALS['temp']['rows'] = $it;
	}
}
