<?php

/**
 * init.form333.php - Telephone report
 * Job: 257
 * Function: 90 
*/

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
	$GLOBALS['temp']['url'] = $_POST['url'];
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],11,"");

if(isset($_POST['action']) && $_POST['action'] == "allocate" && $_SESSION['telephone_report_update_flag'] == $_POST['updateFlag']) {
	$phoneInfo = $lDB->get("
		SELECT
			rv_phone_db,
			rv_phone_ix,
			rv_phone_type,
			rv_phone_num,
			rv_phone_dept,
			rv_phone_extn,
			rv_phone_date,
			rv_phone_dur,
			rv_phone_cost
		FROM
			rv_phone
		WHERE
			rv_phone_ix = '$_POST[rv_phone_id]'
	",1);
	$phoneDateArray = preg_split("/\s+/",trim($phoneInfo['rv_phone_date']));
	$phoneDate = $phoneDateArray[0];
	$phoneDateFmt = chng_date($phoneDate,"-");
	$phoneTime = $phoneDateArray[1];
	$taxID = $lDB->get("
		SELECT
			ac_extra.rf_tax_id,
			ac_extra.rf_tax_ind
		FROM
			ac_extra
		WHERE
			ac_extra.ac_extra_ix = '$_POST[ac_extra_id]'
	",1);
	$extraCurrency = $lDB->get("SELECT rf_currency_id FROM ac_extra WHERE ac_extra_ix = '$_POST[ac_extra_id]'",4);
	$note = "Type: $phoneInfo[rv_phone_type]
Number: $phoneInfo[rv_phone_num]
Extension: $phoneInfo[rv_phone_extn]
Date: $phoneDateFmt
Time start: $phoneTime
Duration: $phoneInfo[rv_phone_dur]
";
	$memo = "Department: $phoneInfo[rv_phone_dept]";

	// Ignore passed percentage, look up percentage from Tax Code Table
	$taxPerc = taxPercentage($taxID['rf_tax_id'], $taxID['rf_tax_ind']);

	if($_POST['fn_folio_id'] == "") {
		if($extraCurrency == $_POST['rf_currency_id']) {
			$exchange = "1";
		} else {
			$exchange = $_POST['rv_extra_exch_rate'];
		}
		$extraId = db_rv_extra_insert($_POST['rv_reservation_id'], $_POST['ac_extra_id'], $_POST['pr_business_id'],1,$phoneDate,$phoneInfo['rv_phone_cost'],0,$taxPerc,0,0,$note,$memo,$_POST['rv_res_item_group_id'],$extraCurrency,$_POST['rf_currency_id'],$exchange,false,$_POST['pr_business_id'],'','',0,0,'','',0,0,false,$_POST['rv_phone_id']);
		db_rv_extra_tax_insert($extraId, $taxID['rf_tax_ind'], $taxID['rf_tax_id']);
		verify_extra($extraId);

		$folioId = db_fn_folio_insert_extra($extraId, $_POST['rv_res_item_group_id'],$_POST['fn_folio_to_id'],true);
		db_rv_extra_set_folio($extraId, $folioId);						
		db_rv_phone_set_extra($_POST['rv_phone_id'],$extraId);
	} else {
		$folioInfo = $lDB->get("
			SELECT
				fn_folio.pr_business_id,
				fn_folio.rv_res_item_group_id,
				fn_folio.rf_currency_id
			FROM
				fn_folio
			WHERE
				fn_folio_ix = '$_POST[fn_folio_id]'
		",1);
		if($extraCurrency == $folioInfo['rf_currency_id']) {
			$exchange = "1";
		} else {
			$exchange = $_POST['rv_extra_exch_rate'];
		}
		$extraId = db_rv_extra_insert($_POST['rv_reservation_id'], $_POST['ac_extra_id'], $folioInfo['pr_business_id'],1,$phoneDate,$phoneInfo['rv_phone_cost'],0,$taxPerc,0,0,$note,$memo,$folioInfo['rv_res_item_group_id'],$extraCurrency,$folioInfo['rf_currency_id'],$exchange,false,$folioInfo['pr_business_id'],'','',0,0,'','',0,0,false,$_POST['rv_phone_id']);
		db_rv_extra_tax_insert($extraId, $taxID['rf_tax_ind'], $taxID['rf_tax_id']);
		verify_extra($extraId);
		
		db_rv_extra_set_folio($extraId, $_POST['fn_folio_id']);						
		db_rv_phone_set_extra($_POST['rv_phone_id'],$extraId);
		
	}
}

if(isset($_POST['action']) && $_POST['action'] == "deleteItems" && $_SESSION['telephone_report_update_flag'] == $_POST['updateFlag']) {
	$deleteItems = explode(":",$_POST['deleteItems']);
	foreach($deleteItems as $item) {
		$lDB->put("DELETE FROM rv_phone WHERE rv_phone_ix = '$item'");
	}
}

// BUG #5484 : START ----------------------------------------------------------
// Reports to hide filters by default
$filterStatus = $_SERVER['argv'][9];
$showHideButtonText = $_SERVER['argv'][10];

$GLOBALS['temp']['filterStatus'] = urldecode($filterStatus);
$GLOBALS['temp']['showHideButtonText'] = $showHideButtonText;

if($filterStatus == "") {
	$GLOBALS['temp']['filterStatus'] = "";
}

if($showHideButtonText == "") {
	$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
}

if($_SERVER['argc'] > 1) {
	if($filterStatus == "") {
		$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";
		$GLOBALS['temp']['showHideButtonText'] = ">> Show Filters";
	}
}
// BUG #5484: END -------------------------------------------------------------

$updateFlag = md5(uniqid(rand(),1));
session_set("telephone_report_update_flag",$updateFlag);
$GLOBALS['temp']['updateFlag'] = $updateFlag;


if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_telephone.htm");
}

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));

$envId = $_SERVER['argv'][1];
$fromDate = useDate("from", $_SERVER['argv'][2]);
$toDate = useDate("to", $_SERVER['argv'][3]);
$displayCheck = $_SERVER['argv'][4];
if($displayCheck == "" || $displayCheck == "0") {
	$displayCheck = 2;
}
$GLOBALS['temp']['allocatedChecked'] = "";
$GLOBALS['temp']['unallocatedChecked'] = "";
$showAllocated = false;
$showUnallocated = false;
if( ($displayCheck & 1) == 1 ) {
	$GLOBALS['temp']['allocatedChecked'] = "checked";
	$showAllocated = true;
}
if( ($displayCheck & 2) == 2 ) {
	$GLOBALS['temp']['unallocatedChecked'] = "checked";
	$showUnallocated = true;
}

$extensionFilter = trim($_SERVER['argv'][5]);
$GLOBALS['temp']['extensionFilter'] = $extensionFilter;
$sortOption = $_SERVER['argv'][6];
$sortSQL = "";
if(trim($sortOption) == "") { $sortOption = "8"; }
$GLOBALS['temp']['idUp'] = "std";
$GLOBALS['temp']['idDown'] = "std";
$GLOBALS['temp']['numberUp'] = "std";
$GLOBALS['temp']['numberDown'] = "std";
$GLOBALS['temp']['extUp'] = "std";
$GLOBALS['temp']['extDown'] = "std";
$GLOBALS['temp']['resUp'] = "std";
$GLOBALS['temp']['resDown'] = "std";
$GLOBALS['temp']['dateUp'] = "std";
$GLOBALS['temp']['dateDown'] = "std";
$GLOBALS['temp']['durationUp'] = "std";
$GLOBALS['temp']['durationDown'] = "std";
$GLOBALS['temp']['costUp'] = "std";
$GLOBALS['temp']['costDown'] = "std";
$GLOBALS['temp']['typeUp'] = "std";
$GLOBALS['temp']['typeDown'] = "std";
$GLOBALS['temp']['departmentUp'] = "std";
$GLOBALS['temp']['departmentDown'] = "std";
$GLOBALS['temp']['allocUp'] = "std";
$GLOBALS['temp']['allocDown'] = "std";

// Make sure !rows! doesn't show under Firefox
$GLOBALS['temp']['rows'] = "";

switch($sortOption) {
	case "1":
		$GLOBALS['temp']['idUp'] = "down";
		$sortSQL = " ORDER BY rv_phone.rv_phone_ix ";
		break;
	case "2";
		$GLOBALS['temp']['idDown'] = "down";
		$sortSQL = " ORDER BY rv_phone.rv_phone_ix DESC ";
		break;
	case "3":
		$GLOBALS['temp']['numberUp'] = "down";
		$sortSQL = " ORDER BY rv_phone.rv_phone_num ";
		break;
	case "4":
		$GLOBALS['temp']['numberDown'] = "down";
		$sortSQL = " ORDER BY rv_phone.rv_phone_num DESC ";
		break;
	case "5":
		$GLOBALS['temp']['extUp'] = "down";
		$sortSQL = " ORDER BY rv_phone.rv_phone_extn ";
		break;
	case "6":
		$GLOBALS['temp']['extDown'] = "down";
		$sortSQL = " ORDER BY rv_phone.rv_phone_extn DESC ";
		break;
	case "7":
		$GLOBALS['temp']['dateUp'] = "down";
		$sortSQL = " ORDER BY rv_phone.rv_phone_date ";
		break;
	case "8":
		$GLOBALS['temp']['dateDown'] = "down";
		$sortSQL = " ORDER BY rv_phone.rv_phone_date DESC ";
		break;
	case "9":
		$GLOBALS['temp']['durationUp'] = "down";
		$sortSQL = " ORDER BY rv_phone.rv_phone_dur ";
		break;
	case "10":
		$GLOBALS['temp']['durationDown'] = "down";
		$sortSQL = " ORDER BY rv_phone.rv_phone_dur DESC ";
		break;
	case "11":
		$GLOBALS['temp']['costUp'] = "down";
		$sortSQL = " ORDER BY rv_phone.rv_phone_cost ";
		break;
	case "12":
		$GLOBALS['temp']['costDown'] = "down";
		$sortSQL = " ORDER BY rv_phone.rv_phone_cost DESC ";
		break;
	case "13":
		$GLOBALS['temp']['typeUp'] = "down";
		$sortSQL = " ORDER BY rv_phone.rv_phone_type ";
		break;
	case "14":
		$GLOBALS['temp']['typeDown'] = "down";
		$sortSQL = " ORDER BY rv_phone.rv_phone_type DESC ";
		break;
	case "15":
		$GLOBALS['temp']['departmentUp'] = "down";
		$sortSQL = " ORDER BY rv_phone_dept ";
		break;
	case "16":
		$GLOBALS['temp']['departmentDown'] = "down";
		$sortSQL = " ORDER BY rv_phone_dept DESC ";
		break;
	case "17":
		$GLOBALS['temp']['allocUp'] = "down";
		$sortSQL = " ORDER BY (rv_extra.rv_extra_ix IS NULL) ";
		break;
	case "18":
		$GLOBALS['temp']['allocDown'] = "down";
		$sortSQL = " ORDER BY (rv_extra.rv_extra_ix IS NULL) DESC ";
		break;
	case "19":
		$GLOBALS['temp']['resUp'] = "down";
		$sortSQL = " ORDER BY rv_extra.rv_reservation_id ";
		break;
	case "20":
		$GLOBALS['temp']['resDown'] = "down";
		$sortSQL = " ORDER BY rv_extra.rv_reservation_id DESC ";
		break;
}
$options = $_SERVER['argv'][7];

switch($options & 7) {
   case REP_VIEW_HTML:
      $renderMode = "html";
      $renderType = "";
      break;
   case REP_VIEW_PDF:
      $renderMode = "pdf";
      $renderType = "view";
      break;
   case REP_EMAIL_PDF:
      $renderMode = "pdf";
      $renderType = "email";
      break;
   case REP_SEND_PDF:
      $renderMode = "pdf";
      $renderType = "send";
      break;
   case REP_VIEW_CSV:
      $renderMode = "csv";
      $renderType = "";
}

if($renderMode == "pdf" && $renderType == "email") {
   $pdfName = "Telephone Report - $fromDate[htmlDate] to $toDate[htmlDate]";
	$attachmentTable = "
		<table border=\"0\" cellspacing=\"0\" width=\"100%\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\"></td>
			<td id=\"attachmentLabel\" width=\"100%\">$pdfName.pdf</td>
		</tr></table>
	";
   $newOptions = ($options & ~3) + 3;
   $formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,7))."+".$newOptions;

// echo $formAction."<BR>";

   $GLOBALS[$form]->FormHTML =   str_replace("!formAction!",$formAction,
               str_replace("!attachmentInfo!",$attachmentTable,
               str_replace("!attachmentName!",$pdfName.".pdf",
               str_replace("!hasAttachment!","expand",
               str_replace("!emailBody!","",
               str_replace("!emailSubject!",$pdfName,
               Join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));
   // get principal
   $principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
   $resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
   $principalInfo = getPersonaDetail($principalId);
   $resOfficeInfo = getPersonaDetail($resOfficeId);

   $addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
   $GLOBALS['temp']['princName'] = $principalInfo['name'];
   $GLOBALS['temp']['fax'] = $resOfficeInfo['fax'];
   $GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
   $userId = $_SESSION['userid'];
   $GLOBALS['temp']['emailFrom'] = $lDB->get("   SELECT
                           pr_persona.pr_email
                        FROM
                           pr_persona
                        WHERE
                           pr_persona.pr_persona_ix = '".$userId."'", 4);
   $GLOBALS['temp']['emailTo'] = "";
}

$envList = $lDB->get("
	SELECT DISTINCT
		rf_database.rf_db_code
	FROM
		rf_database
		INNER JOIN rf_db_business ON rf_db_business.rf_db_code = rf_database.rf_db_code
",3);
$envOptions = "";
$envItem = "";
foreach($envList as $envItem) {
	$propertyList = $lDB->get("
		SELECT
			pr_persona.pr_name_last
		FROM
			rf_db_business
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rf_db_business.pr_business_id
		WHERE
			rf_db_business.rf_db_code = '$envItem'
	",3);
	$selected = "";
	if($envItem == $envId) {
		$selected = " selected ";
	}
	$envLabel = "$envItem (" . join(", ",$propertyList) . ")";
	$envOptions .= "<option $selected value=\"$envItem\">$envLabel</option>";
}
$GLOBALS['temp']['envOptions'] = $envOptions;

$GLOBALS['temp']['hide'] = "collapse";
$displayWhere = "";
if($_SERVER['argc'] > 1) {
	setLastReport("reservation.php?" . join("+",$_SERVER['argv']));

	$propertyList = $lDB->get("
		SELECT
			pr_persona.pr_name_last
		FROM
			rf_db_business
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rf_db_business.pr_business_id
		WHERE
			rf_db_business.rf_db_code = '$envId'
	",3);
	$envName = "$envItem (" . join(", ",$propertyList) . ")";
	$GLOBALS['temp']['hide'] = "";

	if($showAllocated && !$showUnallocated) {
		$displayWhere = "
			AND rv_extra.rv_extra_ix IS NOT NULL
		";
	}
	if(!$showAllocated && $showUnallocated) {
		$displayWhere = "
			AND rv_extra.rv_extra_ix IS NULL
		";
	}

	$extensionFilterSQL = "";
	if($extensionFilter != "") {
		$extensionFilterSQL = "
			AND rv_phone_extn LIKE '".str_replace("*","%",$extensionFilter)."'
		";
	}
	$list = $lDB->get("
		SELECT
			rv_phone_db,
			rv_phone_ix,
			rv_phone_type,
			rv_phone_num,
			rv_phone_dept,
			rv_phone_extn,
			rv_phone_date,
			rv_phone_dur,
			rv_phone_cost,
			rv_extra.rv_extra_ix,
			rv_extra.rv_reservation_id,
			rv_extra.rv_extra_void_ind
		FROM
			rv_phone
			LEFT JOIN rv_extra ON rv_extra.rv_extra_ix = rv_phone.rv_extra_id
		WHERE
			rv_phone_db = '$envId'
			AND rv_phone_date >= '$fromDate[jsDate] 00:00:00'
			AND rv_phone_date <= '$toDate[jsDate] 23:59:59'
			$displayWhere
			$extensionFilterSQL
		$sortSQL
	",2);
//			 DESC


	if($renderMode == "html") {
		$rowHTML = "
			<tr !hover!>
				!checkRow!
				<td class=\"br\">!rv_phone_ix!</td>
				<td class=\"br\">!rv_phone_num!</td>
				<td class=\"br\">!rv_phone_extn!</td>
				<td class=\"br\">!rv_reservation_id_display!</td>
				<td class=\"br\" align=\"left\">!rv_phone_date!</td>
				<td class=\"br\" align=\"right\">!rv_phone_dur!</td>
				<td class=\"br\" align=\"right\">!rv_phone_cost!</td>
				<td class=\"br\" align=\"center\">!rv_phone_type!</td>
				<td class=\"br\" align=\"left\">!rv_phone_dept!</td>
				<td class=\"br\" align=\"center\">!alloc!</td>
			</tr>
		";
		$rows = "";
	
		foreach($list as $item) {
			if ($item['rv_reservation_id'] != "") {
				$deletedIcon = "";
				if ($item['rv_extra_void_ind'] != 0) {
					$deletedIcon = '<img src="/resource/Resrequest/Application/public/img/button_alert_msg.gif" style="float:right; height:12px;" title="Extra has been deleted from reservation">';
				}
				$item['rv_reservation_id_display'] = '<a href="reservation.php?0+'.$item['rv_reservation_id'].'" style="text-decoration:none;" title="Click to go to reservation">'.$item['rv_reservation_id'].'</a>'.$deletedIcon.'';
			} else {
				$item['rv_reservation_id_display'] = '';
			}
			$phoneDateArray = explode(" ",$item['rv_phone_date']);
			$phoneDate = $phoneDateArray[0];

			$item['rv_phone_date'] = chng_date($phoneDateArray[0],"-") . " " . $phoneDateArray[1];
			$item['alloc'] = "N";
			if(isset($item['rv_extra_ix'])) {
				$item['alloc'] = "Y";
			}
				
			$item['checkRow'] = "<td class=\"bl br\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>";
			$item['hover'] = "";
			if(!isset($item['rv_extra_ix']) && $item['rv_phone_db'] == $GLOBALS['dbcode']) {
				$item['checkRow'] = "
					<td class=\"bl br\" align=\"center\" onclick=\"event.cancelBubble = true;\"><input type=\"checkbox\" name=\"phoneCheck\" id=\"$item[rv_phone_ix]\" onclick=\"checkDelete();\"></td>
			";
				$item['hover'] = " class=\"imgLink\" onmouseover=\"this.style.backgroundColor = '#CCFFCC'\" onmouseout=\"this.style.backgroundColor = ''\" onclick=\"openFolioPopup('$phoneDate','$item[rv_phone_ix]');\" ";
			}
			$rows .= showpage($item,$rowHTML);
		}
		if(sizeof($list) > 0) {
			$GLOBALS['temp']['rows'] = $rows;
		} else {
			$GLOBALS['temp']['rows'] = "<tr><td colspan=\"10\" align=\"center\" class=\"bl br txti\">No telephone records found</td></tr>";
		}
	}

	if ($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {
		$pdf = new PDF("Telephone Report");
		$reportLabel = "Telephone Report";
		// Main PDF header
		$headerArray = array(
			array('name' => "Property", 'value' => $envName),
			array('name' => "Date Range", 'value' => $fromDate['htmlDate'] . " to " . $toDate['htmlDate'])
		);
		$pdf->ReportHeader($reportLabel, $headerArray);
		$pdfFontSize = 8;
		$pdf->SetFont('Arial', '', $pdfFontSize);
		$pdf->SetFont('Arial', '', 7);

		$pdf->Ln(2);
		//HERE

		$pdf->Row(array(
			array('width'=>"10%", 'data'=>"Id", 'border'=>"LTB", 'fill'=>1),
			array('width'=>"20%", 'data'=>"Number", 'border'=>"LTB", 'fill'=>1),
			array('width'=>"20%", 'data'=>"Ext", 'border'=>"LTB", 'fill'=>1),
			array('width'=>"15%", 'data'=>"Date / Time", 'border'=>"LTB", 'fill'=>1, 'align'=>"C"),
			array('width'=>"10%", 'data'=>"Duration", 'border'=>"LTB", 'fill'=>1, 'align'=>"R"),
			array('width'=>"10%", 'data'=>"Cost", 'border'=>"LTB", 'fill'=>1, 'align'=>"R"),
			array('width'=>"5%", 'data'=>"Type", 'border'=>"LTB", 'fill'=>1, 'align'=>"C"),
			array('width'=>"5%", 'data'=>"Dept", 'border'=>"LTB", 'fill'=>1, 'align'=>"C"),
			array('width'=>"5%", 'data'=>"Alloc", 'border'=>"LTBR", 'fill'=>1, 'align'=>"C")
		));
		
		foreach($list as $item) {
			$phoneDateArray = explode(" ",$item['rv_phone_date']);
			$phoneDate = $phoneDateArray[0];

			$item['rv_phone_date'] = chng_date($phoneDateArray[0],"-") . " " . $phoneDateArray[1];

			$item['alloc'] = "N";
			if(isset($item['rv_extra_ix'])) {
				$item['alloc'] = "Y";
			}
			$pdf->Row(array(
				array('width'=>"10%", 'data'=>$item['rv_phone_ix'], 'border'=>"LTB"),
				array('width'=>"20%", 'data'=>$item['rv_phone_num'], 'border'=>"LTB"),
				array('width'=>"20%", 'data'=>$item['rv_phone_extn'], 'border'=>"LTB"),
				array('width'=>"15%", 'data'=>$item['rv_phone_date'], 'border'=>"LTB", 'align'=>"C"),
				array('width'=>"10%", 'data'=>$item['rv_phone_dur'], 'border'=>"LTB", 'align'=>"R"),
				array('width'=>"10%", 'data'=>$item['rv_phone_cost'], 'border'=>"LTB", 'align'=>"R"),
				array('width'=>"5%", 'data'=>$item['rv_phone_type'], 'border'=>"LTB", 'align'=>"C"),
				array('width'=>"5%", 'data'=>$item['rv_phone_dept'], 'border'=>"LTB", 'align'=>"C"),
				array('width'=>"5%", 'data'=>$item['alloc'], 'border'=>"LTBR", 'align'=>"C")
			));
		}
		
		if($renderType == "view") {
			$pdf->OutPut();
			die();
		}
		if($renderType == "send") {
			$to = $_POST['mail_to'];
			$from = $_POST['mail_from'];
			$subject = $_POST['mail_subj'];
			$message = $_POST['mail_body'];
			$attachmentName = $_POST['attachmentName'];

			$headers = "From: ".$GLOBALS['princName']."<$from>\r\n";

			// close the pdf
			if($pdf->state<3) $pdf->Close();

			/* and now mail it */
			if($attachmentName != "!attachmentName!") {
				$pdfName = $attachmentName;
			} else {
				$pdfName = "Update report from $fromDate to $toDate.pdf";
			}

			$error = email($from, $to, $subject, $headers, $message, 0, 0, $_SERVER['argv'][1], $GLOBALS['princName'],$pdf->buffer,$pdfName);     // (from, to, subject, headers, message, action, emailID, resID)
			if(!$error) {
				echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
				die();
			} else {
				echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
				die();
			}
      }
	}

	if($renderMode == "csv") {
		$csvFile = array();
		array_push($csvFile,array("Telephone Report"));
		array_push($csvFile,array());
		array_push($csvFile,array("Date Range",$fromDate['htmlDate'] . " to " . $toDate['htmlDate']));
		array_push($csvFile,array());
	
		array_push($csvFile,array("Id","Number","Ext","Date / Time","Duration","Cost","Type","Department","Allocated"));
		foreach($list as $item) {
			$item['alloc'] = "N";
			if(isset($item['rv_extra_ix'])) {
				$item['alloc'] = "Y";
			}
			array_push($csvFile,array($item['rv_phone_ix'],$item['rv_phone_num'],$item['rv_phone_extn'],$item['rv_phone_date'],$item['rv_phone_dur'],$item['rv_phone_cost'],$item['rv_phone_type'],$item['rv_phone_dept'],$item['alloc']));
		}

		$csvText = "";
		foreach($csvFile as $csvLine) {
			$first = true;
			foreach($csvLine as $csvItem) {
				if(!$first) {
					$csvText .= ",";
				} else {
					$first = false;
				}
				$csvText .= "\"".str_replace("\"","\"\"",$csvItem)."\"";
			}
			$csvText .= "\n";
		}
   
		if(headers_sent()) {
			//    echo('Some data has already been output to browser, can\'t send PDF file');
		}
		header('Content-Type: text/csv');
		header("Cache-control: private");
		header('Content-Length: '.strlen($csvText));
		header("Content-Disposition: inline; filename=telephone_report_".str_replace(" ", "_", $fromDate['htmlDate'])."_to_".str_replace(" ", "_", $toDate['htmlDate']).".csv");
		//header("Content-Disposition: inline; filename=contact_".date("Y-m-d").".csv");
		echo $csvText;
		flush();
		die();
	}
}

function getPersonaFax($personaId) {
      $fax = $GLOBALS['lDB']->get("
         SELECT
         pr_phone.pr_phone_number
         FROM
         pr_phone, rf_phone_type
         WHERE
         pr_phone.pr_persona_id = '$personaId'
         AND pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
         AND rf_phone_type.rf_phone_type_sys_code = '1'", 4);
      if (trim($fax) == "" || $fax == "0") {
         $fax = "";
      }
      return $fax;
   }
   function getPersonaTelephone($personaId) {
      $tel = $GLOBALS['lDB']->get("
         SELECT
         pr_phone.pr_phone_number
         FROM
         pr_phone
         WHERE
         pr_phone.pr_persona_id = '$personaId'
         AND pr_phone.pr_default_yn = '1'", 4);
      if (trim($tel) == "" || $tel == "0") {
         $tel = "";
      }
      return $tel;
   }
function getPersonaDetail($personaId) {
      $detail = $GLOBALS['lDB']->get("
         SELECT
         pr_persona.pr_name_first,
         pr_persona.pr_name_second,
         pr_persona.pr_name_last,
         pr_persona.pr_email
         FROM
         pr_persona
         WHERE
         pr_persona.pr_persona_ix = '".$personaId."'", 2);
      $detail = $detail[0];
      $name = "";
      if (trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
         $name .= $detail['pr_name_first'] . " ";
      }
      if (trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
         $name .= $detail['pr_name_second'] . " ";
      }
      if (trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
         $name .= $detail['pr_name_last'] . " ";
      }
      $result = array();
      $result['name'] = trim($name);
      $result['fax'] = getPersonaFax($personaId);
      $result['telephone'] = getPersonaTelephone($personaId);
      $result['email'] = $detail['pr_email'];
      if (trim($result['email']) == "" || $result['email'] == "0") {
         $result['email'] = "";
      }
      return $result;
   }
