<?php

/*
 * $Id: init.form335.php,v 1.9 2011-05-30 12:50:02 light Exp $
 *
 * $Log: init.form335.php,v $
 * Revision 1.9  2011-05-30 12:50:02  light
 * Bug #7609 - General system speed (on larger databases)
 *
 * Revision 1.8  2011-05-17 14:08:30  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.7  2010-10-04 18:02:30  light
 * Bug #7301 - Rates phase 1 - Search & Replace
 *
 * Revision 1.6  2010-10-04 16:46:58  light
 * Bug #7301 - Rates phase 1 - Search & Replace
 *
 * Revision 1.5  2007-02-21 11:41:34  light
 * Bug #5383 - Folio/invoice rules
 *
 *
 */

/**
 * init.form335.php - Folio details popup (called from the rooming calendar add payment popup)
 * Job: 774
 * Function: 81 (Rooming Calendar)
*/

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/folio_details_pop.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],2,"");
  
$folioId = $_SERVER['argv'][1];
$folioInfo = $GLOBALS['lDB']->get("
	SELECT
		fn_folio.fn_folio_folio_num,
		rf_currency.rf_currency_symbol,
		pr_persona.pr_name_last,
		pr_persona.pr_name_first
	FROM
		fn_folio
		INNER JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
		LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = fn_folio.fn_folio_to_id
	WHERE
		fn_folio.fn_folio_ix = '$folioId'
",1);
$folioNum = $folioInfo['fn_folio_folio_num'];
$payeeName = trim($folioInfo['pr_name_first'] . " " . $folioInfo['pr_name_last']);
$folioCurr = $folioInfo['rf_currency_symbol'];
  
$GLOBALS['temp']['folioNum'] = $folioNum;
$GLOBALS['temp']['payeeName'] = urldecode($payeeName);
  
$accommAll = $GLOBALS['lDB']->get("
	SELECT
		'Accommodation' as rt_component_desc,
		SUM(rv_res_item_comp.rv_item_comp_amt_comm) as rv_item_comp_amt_comm,
		SUM(rv_res_item_comp.rv_item_comp_amt_gross) as rv_item_comp_amt_gross,
		SUM(rv_res_item_comp.rv_item_comp_amt_nett) as rv_item_comp_amt_nett,
		SUM(rv_res_item_comp.rv_item_comp_amt_payable) as rv_item_comp_amt_payable,
		SUM(rv_res_item_comp.rv_item_comp_amt_tax) as rv_item_comp_amt_tax,
		rv_reservation.rv_commission_deduct_yn,
		rv_res_item_comp.rv_item_comp_tax_perc,
		COUNT(rv_res_item_comp.rv_res_item_comp_id) as accommCount,
		COUNT(rv_reservation_item.rv_reservation_item_ix) as itemCount,
		rv_res_item_comp.rv_item_comp_separate_yn
	FROM
		rv_reservation_item
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
		LEFT JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
		LEFT JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
	WHERE
		rv_reservation_item.fn_folio_id = '$folioId'
		AND (
			rv_res_item_comp.rv_item_comp_separate_yn = 0
			OR rt_component.rt_component_id IS NULL
		)      
	GROUP BY
		rv_reservation_ix,
		rv_res_item_comp.rv_item_comp_tax_perc
",2);
    
$accommList = $GLOBALS['lDB']->get("
	SELECT
		rt_component.rt_component_desc,
		rv_res_item_comp.rv_item_comp_tax_perc,
		SUM(rv_res_item_comp.rv_item_comp_amt_gross) as rv_item_comp_amt_gross,
		SUM(rv_res_item_comp.rv_item_comp_amt_nett) as rv_item_comp_amt_nett,
		SUM(rv_res_item_comp.rv_item_comp_amt_payable) as rv_item_comp_amt_payable,
		SUM(rv_res_item_comp.rv_item_comp_amt_tax) as rv_item_comp_amt_tax,
		rv_reservation.rv_commission_deduct_yn,
		rv_res_item_comp.rv_item_comp_separate_yn
	FROM
		rv_reservation_item
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
		LEFT JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
		LEFT JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
	WHERE
		rv_reservation_item.fn_folio_id = '$folioId'
		AND rv_res_item_comp.rv_item_comp_separate_yn = 1        
	GROUP BY
		rv_res_item_comp.rt_component_id,
		rv_res_item_comp.rv_item_comp_tax_perc
",2);
		 
$hasTBA = false;
foreach($accommAll as $accommKey=>$accommItem) {
	if($accommItem['accommCount'] == 0 && $accommItem['itemCount'] > 0) {
		$accommAll[$accommKey]['rt_component_desc'] = "Accommodation";
		$accommAll[$accommKey]['rv_item_comp_amt_comm'] = "TBA";
		$accommAll[$accommKey]['rv_item_comp_amt_gross'] = "TBA";
		$accommAll[$accommKey]['rv_item_comp_amt_nett'] = "TBA";
		$accommAll[$accommKey]['rv_item_comp_amt_payable'] = "TBA";
		$accommAll[$accommKey]['rv_item_comp_amt_tax'] = "TBA";
		$accommAll[$accommKey]['rv_item_comp_tax_perc'] = "0.00";
		$hasTBA = true;
	}
}
if(sizeof($accommAll) > 0) {
	$accommList = array_merge($accommList,$accommAll);
}

$exclTotal = $taxTotal = $payableTotal = 0;
$foliorows = "";
foreach($accommList as $accommKey=>$accommItem) {    
	if($accommItem['rv_commission_deduct_yn'] == 1) {
		$total = $accommItem['rv_item_comp_amt_nett'];
	} else {
		$total = $accommItem['rv_item_comp_amt_gross'];
	}
	$accommList[$accommKey]['rv_item_comp_amt_payable'] = $total;      
	$accommList[$accommKey]['rv_item_comp_amt_excl'] = $total - $accommItem['rv_item_comp_amt_tax'];
    
	$exclTotal += ($total - $accommItem['rv_item_comp_amt_tax']);
	$taxTotal += $accommItem['rv_item_comp_amt_tax'];
	$payableTotal += $total;

	if($accommList[$accommKey]['rv_item_comp_amt_payable'] != "TBA") {
		fixAmtDisplay($accommList[$accommKey]['rv_item_comp_amt_payable'],2);
		fixAmtDisplay($accommList[$accommKey]['rv_item_comp_amt_tax'],2);
		fixAmtDisplay($accommList[$accommKey]['rv_item_comp_amt_nett'],2);
		fixAmtDisplay($accommList[$accommKey]['rv_item_comp_amt_gross'],2);
		fixAmtDisplay($accommList[$accommKey]['rv_item_comp_amt_excl'],2);
	} else {
		$accommList[$accommKey]['rv_item_comp_amt_excl'] = "TBA";
	}
	$rv_item_comp_amt_excl = $accommList[$accommKey]['rv_item_comp_amt_excl'];
        
	$foliorows .= "
		<tr>
			<td class=\"br\">$accommItem[rt_component_desc]</td>
			<td class=\"br\" align=\"right\">$accommItem[rv_item_comp_tax_perc] %</td>
			<td class=\"br\" align=\"right\">$rv_item_comp_amt_excl</td>
			<td class=\"br\" align=\"right\">$accommItem[rv_item_comp_amt_tax]</td>
			<td class=\"br\" align=\"right\">$accommItem[rv_item_comp_amt_payable] $folioCurr</td>
		</tr>
	";
}
	
$extraList = $GLOBALS['lDB']->get("
	SELECT
		ac_extra.ac_ext_desc,
		rv_extra.rv_extra_tax_perc,
		rv_extra.rv_extra_amt_gross,
		rv_extra.rv_extra_amt_nett,
		rv_extra.rv_extra_ix AS extra_id,
		(
			SELECT SUM(rv_extra_tax_amt)
			FROM rv_extra_tax
			WHERE rv_extra_tax.rv_extra_id = extra_id
		) as rv_extra_amt_tax,
		rv_reservation.rv_commission_deduct_yn
	FROM
		rv_extra
		INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_extra.rv_reservation_id
	WHERE
		rv_extra.fn_folio_id = '$folioId'
",2);
    
foreach($extraList as $extraKey=>$extraItem) {
	if($extraItem['rv_commission_deduct_yn'] == 1) {
		$total = $extraItem['rv_extra_amt_nett'];
	} else {
		$total = $extraItem['rv_extra_amt_gross'];
	}
	$extraList[$extraKey]['rv_extra_amt_payable'] = $total;
	$extraList[$extraKey]['rv_extra_amt_excl'] = $total - $extraItem['rv_extra_amt_tax'];
  
	$exclTotal += ( $total - $extraItem['rv_extra_amt_tax']);
	$taxTotal += $extraItem['rv_extra_amt_tax'];
	$payableTotal += $total;
  
	fixAmtDisplay($extraList[$extraKey]['rv_extra_amt_gross']);
	fixAmtDisplay($extraList[$extraKey]['rv_extra_amt_nett']);
	fixAmtDisplay($extraList[$extraKey]['rv_extra_amt_payable']);
	fixAmtDisplay($extraList[$extraKey]['rv_extra_amt_excl']);
	fixAmtDisplay($extraList[$extraKey]['rv_extra_amt_tax']);
        
	$rv_extra_amt_excl = $extraList[$extraKey]['rv_extra_amt_excl'];
	$rv_extra_amt_tax = $extraList[$extraKey]['rv_extra_amt_tax'];
	$rv_extra_amt_payable = $extraList[$extraKey]['rv_extra_amt_payable'];

	$foliorows .= "
		<tr>
			<td class=\"br\">$extraItem[ac_ext_desc]</td>
			<td class=\"br\" align=\"right\">$extraItem[rv_extra_tax_perc] %</td>
			<td class=\"br\" align=\"right\">$rv_extra_amt_excl</td>
			<td class=\"br\" align=\"right\">$rv_extra_amt_tax</td>
			<td class=\"br\" align=\"right\">$rv_extra_amt_payable $folioCurr</td>
		</tr>
	";
}
$GLOBALS['temp']['folioRows'] = $foliorows;
	  
fixAmtDisplay($exclTotal,2);
fixAmtDisplay($taxTotal,2);
fixAmtDisplay($payableTotal,2);
if($hasTBA) {
	$exclTotal = "TBA";
	$taxTotal = "TBA";
	$payableTotal = "TBA";
	$folioCurr = "";
}

// do total row here
$GLOBALS['temp']['folioTotalRows'] = "
	<tr>
		<td class=\"bt br\" style=\"border-left:none;\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
		<td class=\"bt bb br txtb\" align=\"right\">Total</td>
		<td class=\"bt bb br\" align=\"right\">$exclTotal</td>
		<td class=\"bt bb br\" align=\"right\">$taxTotal</td>
		<td class=\"bt bb br\" align=\"right\">$payableTotal $folioCurr</td>
	</tr>
";
