<?php
/**
 * init.form337.php - Extras Audit Report
 * Job: 260
 * Function: 93
*/

if(isset($_POST['url']) && $_POST['url'] != "") {
   $_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
   $_SERVER['argc'] = sizeof($_SERVER['argv']);
}

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_extras_audit.htm");
}

$GLOBALS['temp']['showButHeader'] = "";
$GLOBALS['temp']['showResults'] = "";
if($_SERVER['argc'] <= 1) {
	$GLOBALS['temp']['showButHeader'] = "collapse";
	$GLOBALS['temp']['showResults'] = "collapse";
} else {
	setLastReport("reservation.php?" . join("+",$_SERVER['argv'])); // This must only work for HTML rendering if PDF/CSV is added
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],23,"");
$filterStatus = $_SERVER['argv'][11];
$filterButtonText = $_SERVER['argv'][13];
$GLOBALS['temp']['filterStatus'] = urldecode($filterStatus);
$GLOBALS['temp']['filterButtonText'] = $filterButtonText;

$propertyACL = $lDB->get("
   SELECT DISTINCT
      ac_accomm_type.pr_business_id
   FROM
      sc_accomm, ac_accomm_type, pr_business, pr_persona
   WHERE
      sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
      AND   sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
      AND   ac_accomm_type.ac_accomm_type_inactive_yn=0
      AND   ac_accomm_type.pr_business_id = pr_business.pr_business_id
      /*AND pr_business.pr_bus_inactive_yn= '0'*/
      AND   pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
", 3);
array_push($propertyACL,"0");

$statusACL = $lDB->get("
   SELECT
      rf_reservation_status_id
    FROM
      rf_reservation_status
    WHERE
      rf_reservation_status_id <> 25
",3);
$propertyFilter = useFilter("propertiesExtra", $_SERVER['argv'][14], "SELECT pr_persona.pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix =", "rv_extra.pr_business_id", $propertyACL, "Not property specific","0");

$extraFilter = useFilter("extras", $_SERVER['argv'][15], "SELECT ac_ext_desc FROM ac_extra WHERE ac_extra.ac_extra_ix =", "ac_extra.ac_extra_ix", false, false, false);
if($extraFilter['ids'] != "") {
   $catList = $lDB->get("
      SELECT DISTINCT
         ac_extra.ac_extra_category_id,
         ac_extra_category.ac_extra_cat_desc
      FROM
         ac_extra
         INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
      WHERE
         ac_extra.ac_extra_ix IN ('".join("','",explode(":",$extraFilter['ids']))."')
   ",2);
   $extraFilterRows = "";
   $extraFilterIds = "";
   foreach($catList as $item) {
      $extraList = $lDB->get("
         SELECT
            ac_extra.ac_extra_ix as ac_extra_ix,
            ac_ext_desc
         FROM
            ac_extra
         WHERE
            ac_extra.ac_extra_ix IN ('".join("','",explode(":",$extraFilter['ids']))."')
            AND ac_extra.ac_extra_category_id = '$item[ac_extra_category_id]'
      ",2);
      $extraNames = "";
      $extraIds = "";
      foreach($extraList as $extraItem) {
         if($extraNames != "") {
            $extraNames .= ", ";
         }
         $extraNames .= $extraItem['ac_ext_desc'];
         if($extraIds != "") {
            $extraIds .= ":";
         }
         $extraIds .= $extraItem['ac_extra_ix'];
      }
      $extraFilterRows .= "
         <tr id=\"extra_$item[ac_extra_category_id]\">
            <td width=\"80\" ><textarea rows=1 style=\"width:80;\" id=\"extraCatText\" class=\"txtg\" readonly tabIndex=\"-1\">$item[ac_extra_cat_desc]</textarea></td>
            <td width=\"300\"><textarea rows=1 style=\"width:300;\" id=\"extraText\" class=\"txtg\" readonly tabIndex=\"-1\">$extraNames</textarea></td>
            <td><input type=button class=\"button bDelete\" style=\"width:20; background-position: center;\" value=\"\" onclick=\"removeExtraIds('$item[ac_extra_category_id]');\"></td>
         </tr>
      ";
      $extraFilterIds .= "
         <input type=\"hidden\" id=\"extraIds_$item[ac_extra_category_id]\" name=\"extraIds\" value=\"$extraIds\">
      ";
   }
   $GLOBALS['temp']['extraFilterRows'] = $extraFilterRows;
   $GLOBALS['temp']['extraFilterIds'] = $extraFilterIds;
   $GLOBALS['temp']['extraAllClass'] = "collapse printCollapse";
} else {
   $GLOBALS['temp']['extraFilterRows'] = "";
   $GLOBALS['temp']['extraFilterIds'] = "";
   $GLOBALS['temp']['extraAllClass'] = "";
}

$extraCategoryFilter = useFilter("extraCategory", $_SERVER['argv'][16], "SELECT ac_extra_cat_desc  FROM ac_extra_category WHERE ac_extra_category_ix =", "ac_extra_category_ix", false, false, false);

$extraFilterType = $_SERVER['argv'][17];

if($extraFilterType == 1) {
   $GLOBALS['temp']['extraFilterTypeCategory'] = "checked";
   $GLOBALS['temp']['extraFilterTypeExtra'] = "";
} else {
   $GLOBALS['temp']['extraFilterTypeCategory'] = "";
   $GLOBALS['temp']['extraFilterTypeExtra'] = "checked";
}

$consultantFilter = useFilter("consultant",$_SERVER['argv'][18],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_consultant_id",false,"No consultant","0");

if ($consultantFilter['all'] != 1) {  
	// Include modify_user in search as well - useFilter() does not seem to allow for 'OR' other than null
	$consultantFilter['where'] = "AND (rv_reservation.rv_consultant_id IN ('" . str_replace(':', "','", $consultantFilter['ids']) . "') OR rv_extra.ad_modify_user_id IN ('" . str_replace(':', "','", $consultantFilter['ids']) . "'))";
}

$options = $_SERVER['argv'][10];

switch($options & 7) {
   case REP_VIEW_HTML:
      $renderMode = "html";
      $renderType = "";
      break;
   case REP_VIEW_PDF:
      $renderMode = "pdf";
      $renderType = "view";
      break;
   case REP_EMAIL_PDF:
      $renderMode = "pdf";
      $renderType = "email";
      break;
   case REP_SEND_PDF:
      $renderMode = "pdf";
      $renderType = "send";
      break;
   case REP_VIEW_CSV:
      $renderMode = "csv";
      $renderType = "";
      break;
}

// Bug #5484 : START ----------------------------------------------------------
// When generating a report, do not display the filters by default.
if($filterStatus == ""){
   $GLOBALS['temp']['filterStatus'] = "";
}

if($filterButtonText == ""){
	$GLOBALS['temp']['filterButtonText'] = "<< Hide Filters";
}

if($_SERVER['argc'] > 1) {
	if($filterStatus == ""){
	   $GLOBALS['temp']['filterStatus'] = "collapse printCollapse";
		 $GLOBALS['temp']['filterButtonText'] = ">> Show Filters";
	}
}
// Bug #5484 : END ------------------------------------------------------------

$dateOption = $_SERVER['argv'][1];
if(trim($dateOption) == "") {
	$dateOption = "1";
}
$GLOBALS['temp']['serviceDateOptionChecked'] = "";
$GLOBALS['temp']['travelDateOptionChecked'] = "";
$GLOBALS['temp']['modifyDateOptionChecked'] = "";
if($dateOption == "3") {
	$GLOBALS['temp']['modifyDateOptionChecked'] = " checked ";
} elseif($dateOption == "2") {
	$GLOBALS['temp']['travelDateOptionChecked'] = " checked ";
} else {
	$GLOBALS['temp']['serviceDateOptionChecked'] = " checked ";
}
$fromDate = useDate("from", $_SERVER['argv'][2]);

$toDate = useDate("to", $_SERVER['argv'][3]);
$fromTravelDate = useDate("fromTravel", $_SERVER['argv'][4]);
$toTravelDate = useDate("toTravel", $_SERVER['argv'][5]);
$fromModifyDate = useDate("fromModify", $_SERVER['argv'][21]);
$toModifyDate = useDate("toModify", $_SERVER['argv'][22]);
$costChange = $_SERVER['argv'][6];
if(trim($costChange) == "") {
	$costChange = "1";
}
$GLOBALS['temp']['costDecreaseOnlyOptionChecked'] = "";
$GLOBALS['temp']['costDecreaseMinimumOptionChecked'] = "";
$GLOBALS['temp']['costIncreaseOnlyOptionChecked'] = "";
$GLOBALS['temp']['costIncreaseMinimumOptionChecked'] = "";
$GLOBALS['temp']['costIncreaseDecreaseOptionChecked'] = "";
switch($costChange) {
case 1:
	$GLOBALS['temp']['costDecreaseOnlyOptionChecked'] = "checked";
	break;
case 2:
	$GLOBALS['temp']['costDecreaseMinimumOptionChecked'] = "checked";
	break;
case 3:
	$GLOBALS['temp']['costIncreaseOnlyOptionChecked'] = "checked";
	break;
case 4:
	$GLOBALS['temp']['costIncreaseMinimumOptionChecked'] = "checked";
	break;
case 5:
	$GLOBALS['temp']['costIncreaseDecreaseOptionChecked'] = "checked";
	break;
}
$costDecreaseMinimum = $_SERVER['argv'][7];
if(trim($costDecreaseMinimum) == "") {
	$costDecreaseMinimum = "0";
}
$GLOBALS['temp']['costDecreaseMinimum'] = $costDecreaseMinimum;

$costIncreaseMinimum = $_SERVER['argv'][8];
if(trim($costIncreaseMinimum) == "") {
	$costIncreaseMinimum = "0";
}
$GLOBALS['temp']['costIncreaseMinimum'] = $costIncreaseMinimum;

$showAudit = false;
$GLOBALS['temp']['showAuditChecked'] = "";
if($_SERVER['argv'][9] == "1") {
	$showAudit = true;
	$GLOBALS['temp']['showAuditChecked'] = "checked";
}

$showDeletedExtras = false;
$GLOBALS['temp']['showDeletedExtrasChecked'] = "";
if($_SERVER['argv'][19] == "1") {
	$showDeletedExtras = true;
	$GLOBALS['temp']['showDeletedExtrasChecked'] = "checked";
}

$showEditedAfterPayment = false;
$GLOBALS['temp']['showEditedAfterPaymentChecked'] = "";
if($_SERVER['argv'][20] == "1") {
	$showEditedAfterPayment = true;
	$GLOBALS['temp']['showEditedAfterPaymentChecked'] = "checked";
}

$sqlFrom = "
	FROM
		rv_extra
		INNER JOIN ac_extra ON rv_extra.ac_extra_id = ac_extra.ac_extra_ix
		INNER JOIN rv_reservation ON rv_extra.rv_reservation_id = rv_reservation.rv_reservation_ix
		LEFT JOIN fn_folio ON rv_extra.fn_folio_id = fn_folio.fn_folio_ix
		LEFT JOIN fn_invoice ON fn_folio.fn_invoice_id = fn_invoice.fn_invoice_ix
		LEFT JOIN rf_currency ON rv_extra.rv_extra_inv_curr_id = rf_currency.rf_currency_ix
		LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_extra.ad_modify_user_id
		LEFT JOIN pr_persona pr_consultant ON pr_consultant.pr_persona_ix = rv_reservation.rv_consultant_id
";
if($dateOption == "1") {
	$sqlDateWhere = "
		AND rv_extra.rv_extra_date_serv >= '$fromDate[jsDate]'
		AND rv_extra.rv_extra_date_serv <= '$toDate[jsDate]'
	";
} elseif ($dateOption == "2") {
	$sqlDateWhere = "
		AND (
			(rv_reservation.rv_date_arrive >= '".$fromTravelDate['jsDate']."' AND rv_reservation.rv_date_arrive <= '".$toTravelDate['jsDate']."')
			OR (rv_reservation.rv_date_depart >= '".$fromTravelDate['jsDate']."' AND rv_reservation.rv_date_depart <= '".$toTravelDate['jsDate']."')
			OR (rv_reservation.rv_date_arrive < '".$fromTravelDate['jsDate']."' AND rv_reservation.rv_date_depart > '".$toTravelDate['jsDate']."')
		)		
	";
} else {
	$sqlDateWhere = "
		AND (
			DATE(rv_extra.ad_modify_date) >= '$fromModifyDate[jsDate]'
			AND DATE(rv_extra.ad_modify_date) <= '$toModifyDate[jsDate]'
			)		
	";
}

if ($showDeletedExtras) {
	// Voided / deleted extras
	$sqlWhere = "
		WHERE
			rv_extra.rv_extra_void_ind = '3'
	";
} else {
	// Non-voided as well as voided / deleted extras
	$sqlWhere = "
		WHERE
			(rv_extra.rv_extra_void_ind = '0' OR rv_extra.rv_extra_void_ind = '3')
	";
}

$sqlWhere .= $sqlDateWhere;

if($extraFilterType == 1) {
   $extraFilterSQL = $extraCategoryFilter['where'];
   $sqlFrom .= "LEFT JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id";
} else {
   $extraFilterSQL = $extraFilter['where'];
}

$extraList = $lDB->get("
	SELECT
		rv_extra.rv_extra_ix,
		rv_extra.rv_extra_void_ind,
		rv_reservation.rv_reservation_ix,
		rv_reservation.rv_res_name,
		rv_extra.rv_extra_date_serv,
		ac_extra.ac_ext_desc,
		rv_extra.rv_extra_amt_payable,
		rv_extra.rv_extra_timestamp,
		rv_extra.rv_extra_void_time,
		fn_folio.fn_folio_ix,
		fn_folio.fn_folio_folio_num,
		fn_invoice.fn_invoice_ix,
		rf_currency.rf_currency_symbol,
		rv_extra.rv_extra_void_reason,
		TRIM(CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last)) as modify_user,
		TRIM(CONCAT(pr_consultant.pr_name_first, ' ', pr_consultant.pr_name_last)) as consultant,
		(
			SELECT
				rv_payment_item.rv_pay_item_timestamp
			FROM
				rv_payment_item
			WHERE
				fn_folio_id = fn_folio.fn_folio_ix
			ORDER BY
				rv_payment_item.rv_pay_item_timestamp DESC
			LIMIT 1
		) AS last_payment
	$sqlFrom
	$sqlWhere
	$extraFilterSQL
	$propertyFilter[where]
	$consultantFilter[where]
",2);

$newExtraList = array();
foreach($extraList as $item) {
	$auditList = $lDB->get("
		SELECT
			rv_extra.rv_extra_amt_payable,
			rv_extra.rv_extra_void_time,
			rv_extra.rv_extra_date_serv,
			rf_currency.rf_currency_symbol,
			rv_extra_void_reason,
			TRIM(CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last)) as modify_user,
			TRIM(CONCAT(pr_consultant.pr_name_first, ' ', pr_consultant.pr_name_last)) as consultant
		FROM
			rv_extra
			LEFT JOIN rf_currency ON rv_extra.rv_extra_inv_curr_id = rf_currency.rf_currency_ix
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_extra.ad_modify_user_id
			LEFT JOIN rv_reservation ON rv_extra.rv_reservation_id = rv_reservation.rv_reservation_ix
			LEFT JOIN pr_persona pr_consultant ON pr_consultant.pr_persona_ix = rv_reservation.rv_consultant_id
		WHERE
			rv_extra_void_link_id = '$item[rv_extra_ix]'
		ORDER BY
			rv_extra_void_seq DESC
	",2);	
	$item['auditList'] = $auditList;

	$item['after_last_payment'] = "";
	$item['after_last_payment_csv'] = "";
	if (!empty($item['last_payment']) && (strtotime($item['rv_extra_timestamp']) > strtotime($item['last_payment']))) {
		$item['after_last_payment'] = "<i class=\"material-icons\" title=\"This Extra has been modified after the last payment made to the folio\" style=\"font-size: 14px; color: orange; float: right; position: relative; top: -1px;\">warning</i>";
		$item['after_last_payment_csv'] = " *";
	}

	$item['rv_extra_timestamp'] = timestampConvert($item['rv_extra_timestamp']);
	if(sizeof($auditList) > 0) {
		$item['rv_extra_void_time'] = dateTimeConvert($auditList[0]['rv_extra_void_time']);
		$item['rv_extra_void_diff'] = $item['rv_extra_amt_payable'] - $auditList[sizeof($auditList)-1]['rv_extra_amt_payable'];
	} else {
		$item['rv_extra_void_time'] = $item['rv_extra_timestamp'];
		$item['rv_extra_void_diff'] = 0;
	}
	if($item['rv_extra_void_ind'] == "3") {
		$item['rv_extra_void_diff'] = -$item['rv_extra_amt_payable'];
	}
	$showRow = false;
	switch($costChange) {
		case 1:
			if($item['rv_extra_void_diff'] < 0) { $showRow = true; }
			break;
		case 2:
			if($item['rv_extra_void_diff'] <= -$costDecreaseMinimum) { $showRow = true; }
			break;
		case 3:
			if($item['rv_extra_void_diff'] > 0) { $showRow = true; }
			break;
		case 4:
			if($item['rv_extra_void_diff'] >= $costIncreaseMinimum) { $showRow = true; }
			break;
		case 5:
			if($item['rv_extra_void_diff'] != 0) { $showRow = true; }
			break;
	}
	if ($showEditedAfterPayment && empty($item['after_last_payment'])) {
		$showRow = false;
	}
	$item['rv_extra_timestamp'] = date("j M Y h:i:s",$item['rv_extra_timestamp']);
	$item['rv_extra_void_time'] = date("j M Y h:i:s",$item['rv_extra_void_time']);
	fixAmtDisplay($item['rv_extra_void_diff']);
	$item['rv_extra_date_serv'] = chng_date($item['rv_extra_date_serv'],"-");
	for($count=0;$count<sizeof($item['auditList']);$count++) {
//	foreach($item['auditList'] as $auditKey=>$auditItem) {
		$item['auditList'][$count]['rv_extra_date_serv'] = chng_date($item['auditList'][$count]['rv_extra_date_serv'],"-");
		if($count < (sizeof($item['auditList']) - 1)) {
			$item['auditList'][$count]['rv_extra_void_diff'] = $item['auditList'][$count]['rv_extra_amt_payable'] - $item['auditList'][$count+1]['rv_extra_amt_payable'];
			$item['auditList'][$count]['bb'] = "";
		} else {
			$item['auditList'][$count]['rv_extra_void_diff'] = "0";
			$item['auditList'][$count]['bb'] = "bb";
		}
		$item['auditList'][$count]['rv_extra_void_time'] = date("j M Y h:i:s",dateTimeConvert($item['auditList'][$count]['rv_extra_void_time']));
		fixAmtDisplay($item['auditList'][$count]['rv_extra_void_diff'],2);
		fixAmtDisplay($item['auditList'][$count]['rv_extra_amt_payable'],2);
	}
	if($showRow) {
		array_push($newExtraList,$item);
	}
}
$extraList = $newExtraList;



$rowHTML = "
	<tr style=\"background-color: !rowBackgroundColor!\" onmouseover=\"this.style.backgroundColor = '#CCFFCC'\"  onmouseout=\"this.style.backgroundColor = '!rowBackgroundColor!'\" class=\"imgLink\" onclick=\"window.location='/reservation.php?609+!rv_reservation_ix!++4++2+1';\"> 
		<td class=\"br\" align=\"center\" valign=\"middle\" onclick=\"toggleAudit('!rv_extra_ix!');\"><img id=\"toggleImage!rv_extra_ix!\" src=\"!expandImage!\"></td>
		<td class=\"br\">!rv_reservation_ix!</td>
		<td class=\"br\">!rv_res_name!</td>
		<td class=\"br\">!rv_extra_date_serv!</td>
		<td class=\"br\">!ac_ext_desc!</td>
		<td class=\"br txtr\">!rv_extra_void_diff! !rf_currency_symbol!</td>
		<td class=\"br txtr\">!rv_extra_amt_payable! !rf_currency_symbol!</td>
		<td class=\"br\">!rv_extra_timestamp!!after_last_payment!</td>
		<td class=\"br\">!rv_extra_void_time!</td>
		<td class=\"br\">!fn_folio_folio_num!</td>          
		<td class=\"br\">!fn_invoice_ix!</td>
		<td class=\"br\" align=\"center\">!rv_extra_void_reason_js!</td>
		<td class=\"br\">!modify_user!</td>
		<td class=\"br\">!consultant!</td>
	</tr>				
";
$auditHTML = "
	<tr style=\"background-color: #E4E3E3;\" id=\"auditHeader!parentId!\" class=\"!auditRowClass!\">
		<td id=\"auditHeader0!parentId!\" rowspan=\"!auditRowCount!\" class=\"br\" style=\"background-color: #ffffff;\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
		<td id=\"auditHeader1!parentId!\" rowspan=\"!auditRowCount!\" class=\"br\" style=\"background-color: #ffffff;\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
		<td id=\"auditHeader2!parentId!\" rowspan=\"!auditRowCount!\" class=\"br bt bb\">Extras Audit:</td>
		<td class=\"\" style=\"background-color: #ffffff;\" colspan=\"11\"></td>
	</tr>
";
$auditRowHTML = "
	<tr id=\"auditRow!rowCount!!parentId!\" class=\"!auditRowClass!\">
		<td class=\"br !bb!\">!rv_extra_date_serv!</td>
		<td class=\"br !bb!\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
		<td align=\"right\" class=\"br !bb!\">!rv_extra_void_diff! !rf_currency_symbol!</td>
		<td align=\"right\" class=\"br !bb!\">!rv_extra_amt_payable! !rf_currency_symbol!</td>
		<td class=\"br !bb!\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
		<td class=\"br !bb!\">!rv_extra_void_time!</td>
		<td class=\"br !bb!\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>		
		<td class=\"br !bb!\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>		
		<td class=\"br !bb!\" align=\"center\">!rv_extra_void_reason_js!</td>
		<td class=\"br !bb!\">!modify_user!</td>
		<td class=\"br !bb!\">!consultant!</td>
	</tr>
";

$rows = "";
foreach($extraList as $item) {
	if(canEditReservation($item['rv_reservation_ix'])) {
		$item['resJob'] = "2";
	} else {
		$item['resJob'] = "0";
	}
	if(trim($item['fn_folio_ix']) == "") {
		$item['fn_folio_ix'] = "&nbsp;";
	}
	if(trim($item['fn_invoice_ix']) == "") {
		$item['fn_invoice_ix'] = "&nbsp;";
	}
	$item['rowBackgroundColor'] = "#FFFFFF";
	if($item['rv_extra_void_ind'] == "3") {
		$item['rowBackgroundColor'] = "#E4E3E3";		
	}
	if(sizeof($item['auditList']) > 0) {
		if($showAudit) {
			$item['expandImage'] = "/resource/Resrequest/Application/public/img/property_expanded.gif";
		} else {
			$item['expandImage'] = "/resource/Resrequest/Application/public/img/property_collapsed.gif";
		}
	} else {
		$item['expandImage'] = "/resource/Resrequest/Application/public/img/1x1.gif";
	}
	$item['rv_extra_void_reason_js'] = t_encodeOverlib($item['rv_extra_void_reason']);
	if(trim($item['rv_extra_void_reason']) == "") {
		$item['showReason'] = "style=\"visibility: hidden;\"";
	} else {
		$item['showReason'] = "";
	}

	if(is_array($item['auditList'])) {
		$auditListTemp = $item['auditList'];
		$item['auditList'] = "";
	}

	$rows .= showpage($item,$rowHTML);
	
	if (isset($auditListTemp)) {
		if($showAudit) {
			$auditRowClass = "expand";
		} else {
			$auditRowClass = "collapse";
		}
		$parentId = $item['rv_extra_ix'];
		$rows .= str_replace("!auditRowCount!",sizeof($auditListTemp)+1,
			str_replace("!auditRowClass!",$auditRowClass,
			str_replace("!parentId!",$parentId,$auditHTML)));
		$count=0;
		foreach($auditListTemp as $auditItem) {
			$auditItem['rv_extra_void_reason_js'] = t_encodeOverlib($auditItem['rv_extra_void_reason']);
			if(trim($auditItem['rv_extra_void_reason']) == "") {
				$auditItem['showReason'] = "style=\"visibility: hidden;\"";
			} else {
				$auditItem['showReason'] = "";
			}
			$auditItem['auditRowClass'] = $auditRowClass;
			$auditItem['parentId'] = $parentId;
			$auditItem['rowCount'] = $count;
			$rows .= showpage($auditItem,$auditRowHTML);
			$count++;
		}
		$item['auditList'] = $auditListTemp;
		unset($auditListTemp);
	}
}

if(trim($rows) == "") {
	$rows = "<tr><td colspan=\"10\" class=\"txti\" align=\"center\">No records found</td></tr>";
}

if ($renderMode == "html") {
	$GLOBALS['temp']['rows'] = $rows;
}

if ($renderMode == "csv" ) {
	$csvFile = array();
	array_push($csvFile,array("Report: Extras Audit"));
	array_push($csvFile,array("Date range: " . $fromDate['jsDate'] . " to " . $toDate['jsDate']));
	array_push($csvFile,array("Consultant: " . $consultantFilter['names']));
	array_push($csvFile,array("Property: " . $propertyFilter['names']));
	if ($extraFilterType == 1) {
 		array_push($csvFile,array("Extra Category: " . $extraCategoryFilter['names']));
	} else {
 		array_push($csvFile,array("Extra: " . $extraFilter['names']));
	}
	if ($showDeletedExtras) {
		array_push($csvFile,array("Deleted Extras only: Yes"));
	}
	if ($showEditedAfterPayment) {
		array_push($csvFile,array("Edited after last payment only: Yes"));
	}

	array_push($csvFile,array());          
	$headers = array(); 
	array_push($headers,"Res No.");
	array_push($headers,"Res Name");
	array_push($headers,"Service Date");
	array_push($headers,"Extra Description");
	array_push($headers,"Variation");
	array_push($headers,"Payable");
	array_push($headers,"Created");
	array_push($headers,"Last Edit");
	array_push($headers,"Folio #");
	array_push($headers,"Invoice");
	array_push($headers,"Reason");
	array_push($headers,"Modified by");
	array_push($headers,"Consultant");

	array_push($csvFile,$headers);


	foreach($extraList as $item) {

		$item['rv_extra_void_reason_js'] = t_encodeOverlib($item['rv_extra_void_reason']);

		if(is_array($item['auditList'])) {
			$auditListTemp = $item['auditList'];
			$item['auditList'] = "";
		}

		$csvLine = array();
		$csvRows = array();
		array_push($csvRows,$item['rv_reservation_ix']);
		array_push($csvRows,$item['rv_res_name']);
		array_push($csvRows,$item['rv_extra_date_serv']);
		array_push($csvRows,$item['ac_ext_desc']);
		array_push($csvRows,$item['rv_extra_void_diff'] . ' ' . $item['rf_currency_symbol']);
		array_push($csvRows,$item['rv_extra_amt_payable'] . ' ' . $item['rf_currency_symbol']);
		array_push($csvRows,$item['rv_extra_timestamp'] . '' . $item['after_last_payment_csv']);
		array_push($csvRows,$item['rv_extra_void_time']);
		array_push($csvRows,$item['fn_folio_folio_num']);
		array_push($csvRows,$item['fn_invoice_ix']);
		array_push($csvRows,$item['rv_extra_void_reason_js']);
		array_push($csvRows,$item['modify_user']);
		array_push($csvRows,$item['consultant']);
		array_push($csvFile,$csvRows);
		
		if (isset($auditListTemp)) {
			foreach($auditListTemp as $auditItem) {
				$auditItem['rv_extra_void_reason_js'] = t_encodeOverlib($auditItem['rv_extra_void_reason']);
				$csvLine = array();
				$csvRows = array();
				array_push($csvRows,'');
				array_push($csvRows,'Extras Audit:');
				array_push($csvRows,$item['rv_extra_date_serv']);
				array_push($csvRows,'');
				array_push($csvRows,$item['rv_extra_void_diff'] . ' ' . $item['rf_currency_symbol']);
				array_push($csvRows,$item['rv_extra_amt_payable'] . ' ' . $item['rf_currency_symbol']);
				array_push($csvRows,'');
				array_push($csvRows,$item['rv_extra_void_time']);
				array_push($csvRows,'');
				array_push($csvRows,'');
				array_push($csvRows,$item['rv_extra_void_reason_js']);
				array_push($csvRows,$item['modify_user']);
				array_push($csvRows,$item['consultant']);
				array_push($csvFile,$csvRows);
			}
			$item['auditList'] = $auditListTemp;
			unset($auditListTemp);
		}
	}

	$csvText = "";
	foreach($csvFile as $csvLine) {
		$first = true;
		foreach($csvLine as $csvItem) {
			if(!$first) {
				$csvText .= ",";
			} else {
				$first = false;
			}
			$csvText .= "\"".str_replace("\"","\"\"",$csvItem)."\"";
		}
		$csvText .= "\n";
	}
	header('Content-Type: text/csv');
	header("Cache-control: private");
	header('Content-Length: '.strlen($csvText));
	header("Content-Disposition: inline; filename=extras_audit_".str_replace(" ","_",chng_date(date("Y-m-d"),"-")).".csv");
	echo $csvText;
	flush();
	die();
}


$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));

function timestampConvert($timeStamp) {
	$timeStamp = preg_replace("/[ :-]/","",$timeStamp);
	$year = substr($timeStamp,0,4);
	$month = substr($timeStamp,4,2);
	$day = substr($timeStamp,6,2);
	$hour = substr($timeStamp,8,2);
	$minute = substr($timeStamp,10,2);
	$second = substr($timeStamp,12,2);
	return mktime($hour,$minute,$second,$month,$day,$year);
}

function dateTimeConvert($dateTime) {
	$dateTimeArray = explode(" ",$dateTime);
	$dateArray = explode("-",$dateTimeArray[0]);
	$timeArray = explode(":",$dateTimeArray[1]);
	return mktime($timeArray[0],$timeArray[1],$timeArray[2],$dateArray[1],$dateArray[2],$dateArray[0]);
}

