<?php

/**
 * init.form338.php - Payments by group
 * Job: 261
 * Function: 53 (Reports: Std, Prov, Contact, Mail, Pay received)
*/

if(isset($_POST['url']) && $_POST['url'] != "") {
   $_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
   $_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$pf_object_id = db_pf_object_by_name("payment_group_report");
processProfileAction($pf_object_id,$profileFields);

$pf_option_id = applyProfile($pf_object_id,$profileFields);
$title = db_pf_option_get_title($pf_option_id);
if(trim($title) == "") {
	$title = "Payments By Group Report";
}
$GLOBALS['temp']['title'] = $title;

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id, $pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/pymnt_group.htm");
}
$GLOBALS['temp']['hidepgsplits'] = "collapse";
$GLOBALS['temp']['showReportBody'] = "collapse printCollapse";
if($_SERVER['argc'] > 1) {
	$GLOBALS['temp']['showReportBody'] = "";
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],12,"");

$GLOBALS['temp']['datePaidChecked'] = "";
$GLOBALS['temp']['dateRecordedChecked'] = "";
$dateOption = $_SERVER['argv'][1];
if($dateOption == "2") {
	$GLOBALS['temp']['dateRecordedChecked'] = "checked";
} else {
	$GLOBALS['temp']['datePaidChecked'] = "checked";
}
$fromPaidDate = useDate("fromPaid", $_SERVER['argv'][2]);
$toPaidDate = useDate("toPaid", $_SERVER['argv'][3]);
$fromRecordDate = useDate("fromRecord", $_SERVER['argv'][4]);
$toRecordDate = useDate("toRecord", $_SERVER['argv'][5]);

$bankFilter = useFilter("bank",$_SERVER['argv'][6],"SELECT rf_bank_acc_name FROM rf_bank WHERE rf_bank.rf_bank_ix =","rv_payment.rf_bank_id",false,"None","0");
if($bankFilter['names'] == "All") { 
	$cashPoints = $lDB->get("SELECT 
			rf_bank.rf_bank_ix
			FROM rf_bank",3);
	$GLOBALS['temp']['bankIds'] = "<input type=\"hidden\" id=\"bankIds\" value=\"" . implode(":",$cashPoints) . "\" />";
}

$GLOBALS['temp']['allowDrillDown'] = "1";
if(trim($bankFilter['ids']) == "") {
	$GLOBALS['temp']['allowDrillDown'] = "0";
}

$recordedBy = $_SERVER['argv'][7];
$recordedList = $lDB->get("SELECT pr_name_first, pr_name_last FROM pr_persona WHERE pr_persona_ix = '$recordedBy'",1);
$recordedByName = trim($recordedList['pr_name_first'] . " " . $recordedList['pr_name_last']);
$GLOBALS['temp']['recId'] = $recordedBy;
$GLOBALS['temp']['recName'] = $recordedByName;
$currenciesFilter = useFilter("currencies",$_SERVER['argv'][8],"SELECT rf_currency.rf_currency_name FROM rf_currency WHERE rf_currency.rf_currency_ix =","rv_payment.rf_currency_id",false,false,false);
$mthdpayFilter = useFilter("mthdpay",$_SERVER['argv'][9],"SELECT rf_mthd_pmnt.rf_mthd_pmnt_desc FROM rf_mthd_pmnt WHERE rf_mthd_pmnt.rf_mthd_pmnt_ix =","rv_payment.rf_mthd_pmnt_id",false,false,false);

function getLevel($level,$value) {
	$GLOBALS['temp']['level'.$level.'All'] = "";
	$GLOBALS['temp']['level'.$level.'CreditDate'] = "";
	$GLOBALS['temp']['level'.$level.'RecordDate'] = "";
	$GLOBALS['temp']['level'.$level.'Bank'] = "";
	$GLOBALS['temp']['level'.$level.'Currency'] = "";
	$GLOBALS['temp']['level'.$level.'Method'] = "";
	$GLOBALS['temp']['level'.$level.'User'] = "";
	$GLOBALS['temp']['level'.$level.'InvoiceUnit'] = "";
	$GLOBALS['temp']['level'.$level.'ResNum'] = "";
	$GLOBALS['temp']['level'.$level.'ResName'] = "";
	$drillDown = "report";
	if ($value == "") {
		$value = "all";
	}
	switch($value) {
	case "all":
		$GLOBALS['temp']['level'.$level.'All'] = "selected";
		$primaryGroup = "";
		$groupSelect = "
			'All' as name$level,
			'' as id$level,
		";
		$groupByName = "All";
		break;
	case "creditDate":
		$GLOBALS['temp']['level'.$level.'CreditDate'] = "selected";
		$primaryGroup = "rv_payment.rv_pmnt_date,";
		$groupSelect = "
			rv_payment.rv_pmnt_date as name$level,
			rv_payment.rv_pmnt_date as id$level,
		";
		$groupByName = "Payment credit date";
		break;
	case "recordDate":
		$GLOBALS['temp']['level'.$level.'RecordDate'] = "selected";
		$primaryGroup = "DATE_FORMAT(rv_payment.rv_pmnt_date_created,'%Y-%m-%d'),";
		$groupSelect = "
			DATE_FORMAT(rv_payment.rv_pmnt_date_created,'%Y-%m-%d') as name$level,
			DATE_FORMAT(rv_payment.rv_pmnt_date_created,'%Y-%m-%d') as id$level,
		";
		$groupByName = "Payment recorded date";
		break;
	case "bank":
		$GLOBALS['temp']['level'.$level.'Bank'] = "selected";
		$primaryGroup = "rf_bank.rf_bank_acc_name,";
		$groupSelect = "
			rf_bank.rf_bank_acc_name as name$level,
			rf_bank.rf_bank_ix as id$level,
		";
		$groupByName = "Bank / Cash point";
		break;
	case "currency":
		$GLOBALS['temp']['level'.$level.'Currency'] = "selected";
		$primaryGroup = "rf_currency.rf_currency_ix,";
		$groupSelect = "
			rf_currency.rf_currency_symbol as name$level,
			rf_currency.rf_currency_ix as id$level,
		";
		$groupByName = "Currency";
		break;
	case "method":
		$GLOBALS['temp']['level'.$level.'Method'] = "selected";
		$primaryGroup = "rf_mthd_pmnt.rf_mthd_pmnt_desc,";
		$groupSelect = "
			rf_mthd_pmnt.rf_mthd_pmnt_desc as name$level,
			rf_mthd_pmnt.rf_mthd_pmnt_ix as id$level,
		";
		$groupByName = "Payment method";
		break;
	case "user":
		$GLOBALS['temp']['level'.$level.'User'] = "selected";
		$primaryGroup = "rv_payment.rv_pmnt_user_id,";
		$groupSelect = "
			trim(concat(pr_persona.pr_name_first,concat(' ',pr_persona.pr_name_last))) as name$level,
			pr_persona.pr_persona_ix as id$level,
		";
		$groupByName = "Recorded by";
		break;
	case "invoiceUnit":
		$GLOBALS['temp']['level'.$level.'InvoiceUnit'] = "selected";
		$primaryGroup = "fn_folio.pr_business_id,";
		$groupSelect = "
			trim(concat(invoice_persona.pr_name_first,concat(' ',invoice_persona.pr_name_last))) as name$level,
			invoice_persona.pr_persona_ix as id$level,
		";
		$groupByName = "Invoicing Unit";
		$drillDown = "none";
		break;
	case "resNum":
		$GLOBALS['temp']['level'.$level.'ResNum'] = "selected";
		$primaryGroup = "fn_folio.rv_reservation_id,";
		$groupSelect = "
			rv_reservation.rv_reservation_ix AS name$level,
			rv_reservation.rv_reservation_ix AS id$level,
		";
		$groupByName = "Reservation Number";
		$drillDown = "reservation";
		break;
	case "resName":
		$GLOBALS['temp']['level'.$level.'ResName'] = "selected";
		$primaryGroup = "fn_folio.rv_reservation_id,";
		$groupSelect = "
			rv_reservation.rv_res_name AS name$level,
			rv_reservation.rv_reservation_ix AS id$level,
		";
		$groupByName = "Reservation Name";
		$drillDown = "reservation";
		break;
	case "serverEnv":
		$GLOBALS['temp']['level'.$level.'ServerEnv'] = "selected";
		$primaryGroup = "rv_payment_item.rv_payment_item_db,";
		$groupSelect = "
			rf_database.rf_db_description AS name$level,
			rv_payment_item.rv_payment_item_db AS id$level,
		";
		$groupByName = "Server Environment";
		$drillDown = "none";
	}
	$GLOBALS['temp']['level'.$level.'Name'] = $groupByName;
	return array('group'=>$primaryGroup,'select'=>$groupSelect,'name'=>$groupByName,'by'=>$value,'drilldown'=>$drillDown);
}

$levels = explode(":",$_SERVER['argv'][10]);
$level1 = getLevel("1",$levels[0]);
$level2 = getLevel("2",(isset($levels[1]) ? $levels[1] : ""));

$options = $_SERVER['argv'][11];
switch($options & 7) {
   case REP_VIEW_HTML:
      $renderMode = "html";
      $renderType = "";
      break;
   case REP_VIEW_PDF:
      $renderMode = "pdf";
      $renderType = "view";
      break;
   case REP_EMAIL_PDF:
      $renderMode = "pdf";
      $renderType = "email";
      break;
   case REP_SEND_PDF:
      $renderMode = "pdf";
      $renderType = "send";
      break;
   case REP_VIEW_CSV:
      $renderMode = "csv";
      $renderType = "";
}

if($renderMode == "pdf" && $renderType == "email") {
	if($dateOption == "1") {
	   $pdfName = "Payments by Group Report - ".$fromPaidDate['htmlDate']." to ".$toPaidDate['htmlDate'];
	} else {
	   $pdfName = "Payments by Group Report - ".$fromRecordDate['htmlDate']." to ".$toRecordDate['htmlDate'];
	}
	$attachmentTable = "
		<table border=\"0\" cellspacing=\"0\" width=\"100%\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\"></td>
			<td id=\"attachmentLabel\" width=\"100%\">$pdfName.pdf</td>
		</tr>
		</table>
	";
   $newOptions = ($options & ~3) + 3;
   $formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,11))."+".$newOptions;

// echo $formAction."<BR>";

   $GLOBALS[$form]->FormHTML =   str_replace("!formAction!",$formAction,
               str_replace("!attachmentInfo!",$attachmentTable,
               str_replace("!attachmentName!",$pdfName.".pdf",
               str_replace("!hasAttachment!","expand",
               str_replace("!emailBody!","",
               str_replace("!emailSubject!",$pdfName,
               Join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));
   // get principal
   $principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
   $resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
   $principalInfo = getPersonaDetail($principalId);
   $resOfficeInfo = getPersonaDetail($resOfficeId);

   $addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
   $GLOBALS['temp']['princName'] = $principalInfo['name'];
   $GLOBALS['temp']['fax'] = $resOfficeInfo['fax'];
   $GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
   $userId = $_SESSION['userid'];
   $GLOBALS['temp']['emailFrom'] = $lDB->get("   SELECT
                           pr_persona.pr_email
                        FROM
                           pr_persona
                        WHERE
                           pr_persona.pr_persona_ix = '".$userId."'", 4);
   $GLOBALS['temp']['emailTo'] = "";
}



$sqlGroup = "
	GROUP BY
		$level1[group]
		$level2[group]
		rf_currency.rf_currency_ix
";

$sqlFrom = "
	FROM
		rv_payment_item
		INNER JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
		INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rv_payment.rf_currency_id
		LEFT JOIN rf_mthd_pmnt ON rf_mthd_pmnt.rf_mthd_pmnt_ix = rv_payment.rf_mthd_pmnt_id
		LEFT JOIN rf_bank ON rf_bank.rf_bank_ix = rv_payment.rf_bank_id
		LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_payment.rv_pmnt_user_id
		INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_payment_item.fn_folio_id
		INNER JOIN pr_persona AS invoice_persona ON invoice_persona.pr_persona_ix = fn_folio.pr_business_id
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_folio.rv_reservation_id
		LEFT JOIN rf_database ON rf_database.rf_db_code = rv_payment_item.rv_payment_item_db
";
$sqlWhere = "
	WHERE
		1
		$bankFilter[where]
		$currenciesFilter[where]
		$mthdpayFilter[where]
";
if($dateOption == "1") {
	$sqlWhere .= "
		AND rv_payment.rv_pmnt_date >= '$fromPaidDate[jsDate]' AND rv_payment.rv_pmnt_date <= '$toPaidDate[jsDate]'
	";
} else {
	$sqlWhere .= "
		AND rv_payment.rv_pmnt_date_created >= '$fromRecordDate[jsDate] 0:00:00' AND rv_payment.rv_pmnt_date_created <= '$toRecordDate[jsDate] 23:59:59'
	";
}
if(trim($recordedBy) != "" && $recordedBy != "0") {
	$sqlWhere .= "
		AND rv_payment.rv_pmnt_user_id = '$recordedBy'
	";
}

$list = $lDB->get("
	SELECT
		$level1[select]
		$level2[select]	
		SUM(rv_payment_item.rv_pay_item_amt_rec) as 'amount',
		rf_currency.rf_currency_symbol
	$sqlFrom
	$sqlWhere
	$sqlGroup
",2);

$currencyTotals = array();
foreach($list as $key=>$item) {
	$list[$key]['level1NameRaw'] = isset($item['level1Name']) ? $item['level1Name'] : "";
	$list[$key]['level2NameRaw'] = isset($item['level2Name']) ? $item['level2Name'] : "";
	if($level1['by'] == "creditDate" || $level1['by'] == "recordDate") {
		$list[$key]['name1'] = chng_date($item['name1'],"-");
	}
	if($level2['by'] == "creditDate" || $level2['by'] == "recordDate") {
		$list[$key]['name2'] = chng_date($item['name2'],"-");
	}
	if (isset($currencyTotals[$item['rf_currency_symbol']])) {
		$currencyTotals[$item['rf_currency_symbol']] += $item['amount'];
	} else {
		$currencyTotals[$item['rf_currency_symbol']] = $item['amount'];
	}
}

if($renderMode == "html") {
	setLastReport("reservation.php?" . join("+",$_SERVER['argv']));

	if($level1['drilldown'] == "reservation" || $level2['drilldown'] == "reservation") {
		$resScrollSet = array();
		if($level1['drilldown'] == "reservation") {
			$resIdTag = "!id1!";
		} else {
			$resIdTag = "!id2!";
		}
		$rowTag = "<tr onclick=\"openReservation('$resIdTag');\" onmouseover=\"this.style.backgroundColor = '#CCFFCC'\"  onmouseout=\"this.style.backgroundColor = ''\" class=\"imglink\">";
	} elseif($level1['drilldown'] == "none" || $level2['drilldown'] == "none") {
		$reason = "";
		if($level1['drilldown'] == "none") {
			$reason = $level1['name'];
		}
		if($level2['drilldown'] == "none") {
			if(!empty($reason)) {
				$reason .= " and ";
			}
			$reason .= $level2['name'];
		}
		$rowTag = "<tr onmouseover=\"overlib('Unable to drill down due to grouping by $reason');\" onmouseout=\"nd();\">"; 		
	} else {
		$rowTag = "<tr onclick=\"openPaymentsReceived('$level1[by]','$level2[by]','!id1!','!id2!');\" onmouseover=\"this.style.backgroundColor = '#CCFFCC'\"  onmouseout=\"this.style.backgroundColor = ''\" class=\"imglink\">";
	}

	$rowHTML = "
		$rowTag
			<td class=\"br\">!name1!</td>
			<td class=\"br\">!name2!</td>
			<td class=\"txtr\">!amount! !rf_currency_symbol!</td>
		</tr>
	";
	$rows = "";

	$lastName1 = "";
	$lastName2 = "";
	foreach($list as $item) {
		if($level1['drilldown'] == "reservation" || $level2['drilldown'] == "reservation") {
			if($level1['drilldown'] == "reservation") {
				array_push($resScrollSet,$item['id1']);
			} else {
				array_push($resScrollSet,$item['id2']);
			}
		}

		if(trim($item['name1']) == "") {
			$item['name1'] = "None";
		}
		if(trim($item['name2']) == "") {
			$item['name2'] = "None";
		}
		if($item['name1'] == $lastName1) {
			$item['name1'] = "&nbsp;";
		} else {
			$lastName1 = $item['name1'];
			$lastName2 = "";
		}
		if($item['name2'] == $lastName2) {
			$item['name2'] = "&nbsp;";
		} else {
			$lastName2 = $item['name2'];
		}
		$rows .= showpage($item,$rowHTML);
	}
	if($level1['drilldown'] == "reservation" || $level2['drilldown'] == "reservation") {
		setRecordScroll($resScrollSet);
	}
	if(sizeof($list) > 0) {
		$first = true;
		foreach($currencyTotals as $currency=>$amount) {
			$item = array('name2'=>"&nbsp;");
			if($first) {
				$item['name1'] = "<span class=\"txtb\">Totals</span>";
			} else {
				$item['name1'] = "&nbsp;";
			}
			fixAmtDisplay($amount,2);
			$item['amount'] = "<span class=\"txtb\">$amount</span>";
			$item['rf_currency_symbol'] = "<span class=\"txtb\">$currency</span>";
			$rows .= showpage($item,$rowHTML);
			$first = false;
		}
		$GLOBALS['temp']['rows'] = $rows;
	} else {
		$GLOBALS['temp']['rows'] = "
			<tr>
				<td colspan=\"2\" align=\"center\"><span class=\"txti\">No records found</span></td>
			</tr>
		";
	}
}

if ($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {
	$pdf = new PDF("Payments by Group Report");
	$reportLabel = "Payments by Group Report";
	// Main PDF header
	if($dateOption == "1") {
		$dateRange = array('name' => "Date of Payment", 'value' => $fromPaidDate['htmlDate'] . " to " . $toPaidDate['htmlDate']);
	} else {
		$dateRange = array('name' => "Date Recorded", 'value' => $fromRecordDate['htmlDate'] . " to " . $toRecordDate['htmlDate']);
	}
	$headerArray = array(
		$dateRange,
		array('name' => "Bank / Cash Point", 'value' => $bankFilter['names']),
		array('name' => "Currency", 'value' => $currenciesFilter['names']),
		array('name' => "Payment Method", 'value' => $mthdpayFilter['names']),
		array('name' => "Level 1", 'value' => $level1['name']),
		array('name' => "Level 2", 'value' => $level2['name'])
	);
	$pdf->ReportHeader($reportLabel, $headerArray);
	$pdfFontSize = 8;
	$pdf->SetFont('Arial', '', $pdfFontSize);
	$pdf->SetFont('Arial', '', 7);

	$pdf->Ln(2);
	$headRow = array();
	array_push($headRow,
		array('width'=>"20%", 'height'=>"4", 'data'=>$level1['name'], 'border'=>"LRTB", 'fill'=>1),
		array('width'=>"20%", 'height'=>"4", 'data'=>$level2['name'], 'border'=>"LRTB", 'fill'=>1),
		array('width'=>"15%", 'height'=>"4", 'data'=>"Amount", 'border'=>"LRTB", 'fill'=>1, 'align'=>"R")
	);
	$pdf->Row($headRow);
	foreach($list as $item) {
		$pdf->Row(array(
			array('width'=>"20%", 'height'=>"4", 'data'=>$item['name1'], 'border'=>"LRTB"),
			array('width'=>"20%", 'height'=>"4", 'data'=>$item['name2'], 'border'=>"LRTB"),
			array('width'=>"15%", 'height'=>"4", 'data'=>$item['amount'] . " " . $item['rf_currency_symbol'], 'border'=>"LRTB", 'align'=>"R")
		));
	}
	$first = true;
	foreach($currencyTotals as $currency=>$amount) {
		if($first) {
			$groupName = "Totals";
		} else {
			$groupName = "";
		}
		fixAmtDisplay($amount,2);
		$pdf->Row(array(
			array('width'=>"20%", 'height'=>"4", 'data'=>$groupName, 'border'=>"LRTB", 'style'=>"B"),
			array('width'=>"20%", 'height'=>"4", 'data'=>"", 'border'=>"LRTB", 'style'=>"B"),
			array('width'=>"15%", 'height'=>"4", 'data'=>$amount . " " . $currency, 'border'=>"LRTB", 'style'=>"B", 'align'=>"R")
		));
		$first = false;
	}
		if($renderType == "view") {
			$pdf->OutPut();
			die();
		}
		if($renderType == "send") {
			$to = $_POST['mail_to'];
			$from = $_POST['mail_from'];
			$subject = stripslashes($_POST['mail_subj']);
			$message = stripslashes($_POST['mail_body']);
			$attachmentName = $_POST['attachmentName'];

			$headers = "From: ".$GLOBALS['princName']."<$from>\r\n";

			// close the pdf
			if($pdf->state<3) $pdf->Close();

			/* and now mail it */
			if($attachmentName != "!attachmentName!") {
				$pdfName = $attachmentName;
			} else {
				$pdfName = "Update report from $fromDate to $toDate.pdf";
			}

			$error = email($from, $to, $subject, $headers, $message, 0, 0, $_SERVER['argv'][1], $GLOBALS['princName'],$pdf->buffer,$pdfName);     // (from, to, subject, headers, message, action, emailID, resID)
			if(!$error) {
				echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
				die();
			} else {
				echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
				die();
			}
      }
}

if($renderMode == "csv") {
   $csvFile = array();
   array_push($csvFile,array("Payments by Group Report"));
   array_push($csvFile,array());
   if($dateOption == "1") {
	   array_push($csvFile,array("Date of Payment",$fromPaidDate['htmlDate'] . " to " . $toPaidDate['htmlDate']));
   } else {
	   array_push($csvFile,array("Date Recorded",$fromRecordDate['htmlDate'] . " to " . $toRecordDate['htmlDate']));
   }
   array_push($csvFile,array("Bank / Cash Point",$bankFilter['names']));
   array_push($csvFile,array("Currency",$currenciesFilter['names']));
   array_push($csvFile,array("Payment Method",$mthdpayFilter['names']));
   array_push($csvFile,array("Level 1",$level1['name']));
   array_push($csvFile,array("Level 2",$level2['name']));
   array_push($csvFile,array());
   array_push($csvFile,array($level1['name'],$level2['name'],"Amount","Currency"));
   foreach($list as $item) {
	   array_push($csvFile,array($item['name1'],$item['name2'],$item['amount'],$item['rf_currency_symbol']));
   }
	$first = true;
	foreach($currencyTotals as $currency=>$amount) {
		if($first) {
			$groupName = "Totals";
		} else {
			$groupName = "";
		}
	   array_push($csvFile,array($groupName,"",$amount,$currency));
		$first = false;
	}
   
  $csvText = "";
   foreach($csvFile as $csvLine) {
      $first = true;
      foreach($csvLine as $csvItem) {
         if(!$first) {
            $csvText .= ",";
         } else {
            $first = false;
         }
         $csvText .= "\"".str_replace("\"","\"\"",$csvItem)."\"";
      }
      $csvText .= "\n";
   }
   
  if(headers_sent()) {
   //    echo('Some data has already been output to browser, can\'t send PDF file');
   }
   header('Content-Type: text/csv');
   header("Cache-control: private");
   header('Content-Length: '.strlen($csvText));
   if($dateOption == "1") {
	   $range = strtolower(str_replace(" ","_",$fromPaidDate['htmlDate']." to ".$toPaidDate['htmlDate']));
   } else {
	   $range = strtolower(str_replace(" ","_",$fromRecordDate['htmlDate']." to ".$toRecordDate['htmlDate']));
   }
   
   header("Content-Disposition: inline; filename=folio_invoice_".$range.".csv");
   //header("Content-Disposition: inline; filename=contact_".date("Y-m-d").".csv");
   echo $csvText;
   flush();
   die();
}


$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));
$GLOBALS['temp']['genDate'] = chng_date(date("Y-m-d"),"-")." ".date("H:i:s");

function getPersonaFax($personaId) {
      $fax = $GLOBALS['lDB']->get("
         SELECT
         pr_phone.pr_phone_number
         FROM
         pr_phone, rf_phone_type
         WHERE
         pr_phone.pr_persona_id = '$personaId'
         AND pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
         AND rf_phone_type.rf_phone_type_sys_code = '1'", 4);
      if (trim($fax) == "" || $fax == "0") {
         $fax = "";
      }
      return $fax;
   }
   function getPersonaTelephone($personaId) {
      $tel = $GLOBALS['lDB']->get("
         SELECT
         pr_phone.pr_phone_number
         FROM
         pr_phone
         WHERE
         pr_phone.pr_persona_id = '$personaId'
         AND pr_phone.pr_default_yn = '1'", 4);
      if (trim($tel) == "" || $tel == "0") {
         $tel = "";
      }
      return $tel;
   }
function getPersonaDetail($personaId) {
      $detail = $GLOBALS['lDB']->get("
         SELECT
         pr_persona.pr_name_first,
         pr_persona.pr_name_second,
         pr_persona.pr_name_last,
         pr_persona.pr_email
         FROM
         pr_persona
         WHERE
         pr_persona.pr_persona_ix = '".$personaId."'", 2);
      $detail = $detail[0];
      $name = "";
      if (trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
         $name .= $detail['pr_name_first'] . " ";
      }
      if (trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
         $name .= $detail['pr_name_second'] . " ";
      }
      if (trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
         $name .= $detail['pr_name_last'] . " ";
      }
      $result = array();
      $result['name'] = trim($name);
      $result['fax'] = getPersonaFax($personaId);
      $result['telephone'] = getPersonaTelephone($personaId);
      $result['email'] = $detail['pr_email'];
      if (trim($result['email']) == "" || $result['email'] == "0") {
         $result['email'] = "";
      }
      return $result;
	}
