<?php

/*
 * init.form339.php - Availability Report
 * Job: 262 - Availability Report 
 * Job: 264 - Occupancy Report
 *
 * Function: 96
 */

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
	$GLOBALS['temp']['url'] = $_POST['url'];
}


// Form setup
if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_availability.htm");
}

require_once(__DIR__ . '/class.stock.php');

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));

$_SERVER['argv'] = array_pad($_SERVER['argv'],19,"");

if ( $_SERVER['argv'][3] == "" ) {
	$toDatePlus = "34";
	} else {
	if ( $_SERVER['argv'][4] == "dateRange" ) {
		$toDatePlus = "";
	} else {
		$toDatePlus = $_SERVER['argv'][3];
	}
}

$GLOBALS['temp']['toDatePlus'] = $toDatePlus;

$urlDateType = $_SERVER['argv'][4];

if ( $urlDateType == "" ) {
	$GLOBALS['temp']['dateType'] = "<input type=\"hidden\" id=\"dateType\" name=\"dateType\" value=\"datePlus\" />";
} else {
	if ( $urlDateType == "fromCal" ) {
		$urlDateType = "dateRange";
	}		
	$GLOBALS['temp']['dateType'] = "<input type=\"hidden\" id=\"dateType\" name=\"dateType\" value=\"" . $urlDateType . "\" />";	
}

// 262 = Report: Availability
// 264 = Report: Occupancy
$jobId = $_SERVER['argv'][0];
$jobName = "";

$GLOBALS['temp']['jobId'] = "<input type=\"hidden\" id=\"jobId\" name=\"jobId\" value=\"" . $jobId . "\" />";

switch($jobId) {
	case "264":
		$jobName = "Occupancy Report";
		$pf_object_id = db_pf_object_by_name("occupancy_chart");
		$GLOBALS['temp']['reportLabel'] = "Occupancy Report";
		$GLOBALS['temp']['reportInfo'] = $GLOBALS['info_dir']."info_rep_occupancy.htm";
		$mode = "occupancy";
		$GLOBALS['temp']['showAgentOcc'] = "";
		$GLOBALS['temp']['showAgentAvail'] = "display: none;";
		$GLOBALS['temp']['hiddenInfo'] = "hiddenInfo";			// Info popup content is wrong, this will hide info icon
		break;
	case "262":
	default:
		$jobId = "262";
		$jobName = "Availability Report";
		$pf_object_id = db_pf_object_by_name("availability_chart");
		$GLOBALS['temp']['reportLabel'] = "Availability Report";
		$GLOBALS['temp']['reportInfo'] = $GLOBALS['info_dir']."info_rep_availability.htm";
		$mode = "availability";
		$GLOBALS['temp']['showAgentOcc'] = "display: none;";
		$GLOBALS['temp']['showAgentAvail'] = "";
		$GLOBALS['temp']['agentIds'] = "";
		break;
}

processProfileAction($pf_object_id,$profileFields);
$pf_option_id = applyProfile($pf_object_id,$profileFields);
$title = db_pf_option_get_title($pf_option_id);
if(trim($title) != "") {
	$jobName = $title;
	$GLOBALS['temp']['reportLabel'] = $title;
}

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id,$pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();

$GLOBALS['temp']['today'] = chng_date(date("Y-m-d"),"-");
$GLOBALS['temp']['propertyFilter'] = "colLt";
$GLOBALS['temp']['unitFilter'] = "colLt";
$GLOBALS['temp']['hideButts'] = "collapse printCollapse";

// Show/Hide Units ------------------------------------------------------------
$showUnits = $_SERVER['argv'][10];

if ( $showUnits == "true" ) {
	$GLOBALS['temp']['showUnits'] = "checked";
}

// Page Breaks ----------------------------------------------------------------
if ( $_SERVER['argv'][12] == "" || $_SERVER['argv'][12] == 'true' ) {
	$GLOBALS['temp']['pageBreaks'] = "checked";
	$pageBreaks = TRUE;
} else {
	$GLOBALS['temp']['pageBreaks'] = "";
	$pageBreaks = FALSE;
}
// ----------------------------------------------------------------------------

// Show/Hide Report Parameters ------------------------------------------------
if ( $_SERVER['argv'][13] == 'true' ) {
	$GLOBALS['temp']['showParameters'] = "checked";
	$showParameters = 1;
} else {
	$GLOBALS['temp']['showParameters'] = "";
	$showParameters = 0;
}
// ----------------------------------------------------------------------------

$page = $_SERVER['argv'][11];
$GLOBALS['temp']['page'] = "<input type=\"hidden\" id=\"currentPage\" name=\"currentPage\" value=\"" . $page . "\">";

// BUG #5484 : START ----------------------------------------------------------
// Reports to hide filters by default                                        --
// ----------------------------------------------------------------------------
$filterStatus = $_SERVER['argv'][8];
$showHideButtonText = $_SERVER['argv'][9];

$GLOBALS['temp']['filterStatus'] = urldecode($filterStatus);
$GLOBALS['temp']['showHideButtonText'] = $showHideButtonText;
$GLOBALS['temp']['showReport'] = "collapse printCollapse";

// Default to datePlus selected -----------------------------------------------
$GLOBALS['temp']['radio1'] = "checked";
$GLOBALS['temp']['radio2'] = "";

if ( $filterStatus == "" ) {
	$GLOBALS['temp']['filterStatus'] = "";
}

if ( $showHideButtonText == "" ) {
	$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
}

if ( $_SERVER['argc'] > 1 && $_SERVER['argv'][4] != "fromCal" ) {
	if ( $filterStatus == "" ) {
		$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";
		$GLOBALS['temp']['showHideButtonText'] = ">> Show Filters";
	}
	$GLOBALS['temp']['showReport'] = "";
}
// BUG #5484: END -------------------------------------------------------------

// Set up the dates -----------------------------------------------------------
switch($_SERVER['argv'][4]) {
	case "datePlus":
		if($_SERVER['argv'][2] == "") {
    	$_SERVER['argv'][2] = "34";
		}		
		$fromDate = useDate("from","");
		$toDate = useDate("to",date("Y-m-d",mktime(0,0,0,date("m"),date("d")+$_SERVER['argv'][3],date("Y"))));
		$GLOBALS['temp']['radio1'] = "checked";
		$GLOBALS['temp']['radio2'] = "";
		break;
	case "fromCal":
		$arrayDate = explode("-",$_SERVER['argv'][1]);
		$fromDate = useDate("from",$_SERVER['argv'][1]);
		$toDate = useDate("to",date("Y-m-d",mktime(0,0,0,$arrayDate[1],$arrayDate[2]+$_SERVER['argv'][3],$arrayDate[0])));
		$GLOBALS['temp']['radio1'] = "";
		$GLOBALS['temp']['radio2'] = "checked";
		break;
	case "dateRange":
		$fromDate = useDate("from",$_SERVER['argv'][1]);
		$toDate = useDate("to", $_SERVER['argv'][2]);
		$GLOBALS['temp']['radio1'] = "";
		$GLOBALS['temp']['radio2'] = "checked";
		break;
	default:
		$fromDate = useDate("from",$_SERVER['argv'][1]);
		$toDate = useDate("to", $_SERVER['argv'][2]);
		$GLOBALS['temp']['radio1'] = "checked";
		$GLOBALS['temp']['radio2'] = "";
		break;
}

// Limit No. Units Shown ------------------------------------------------------
$hideUnits = true;
switch($GLOBALS['userStatusId']) {
	case 0:
	case 1:
		// Hide the Unit Limit input field ----------------------------------------
		$GLOBALS['temp']['showHideLimitUnits'] = "collapse printCollapse";
		$GLOBALS['temp']['showHideOverbookings'] = "collapse printCollapse";
		
		if($GLOBALS['sc_grp_avail_limit_yn'] > 0) {
			$unitLimit = $GLOBALS['sc_grp_avail_limit'];
			if($unitLimit > 1) {
				$hideUnits = false;
			}
		} else {
			$unitLimit = 0;
			$hideUnits = false;
		}
		$showOverBookings = 0;
		break;
	default:
		// Show the Unit Limit input field ----------------------------------------
		$GLOBALS['temp']['showHideLimitUnits'] = "";
		$GLOBALS['temp']['showHideOverbookings'] = "";
		$GLOBALS['temp']['checkShowOverbookings'] = "checked=\"checked\"";
		
		$showOverBookings = 1;
		
		if ( $_SERVER['argv'][18] == "false" ) {
			$showOverBookings = 0;
			$GLOBALS['temp']['checkShowOverbookings'] = "";
		}

		if ( $_SERVER['argv'][14] != "" ) {
			$GLOBALS['temp']['txtLimitUnits'] = $_SERVER['argv'][14];
			$unitLimit = $_SERVER['argv'][14];			
		}	else {
			if ( $GLOBALS['sc_grp_avail_limit_yn'] > 0 ) {
				if ( $GLOBALS['sc_grp_avail_limit'] > 0 ) {
					$GLOBALS['temp']['txtLimitUnits'] = $GLOBALS['sc_grp_avail_limit'];
					$unitLimit = $GLOBALS['sc_grp_avail_limit'];
				} else {
					$GLOBALS['temp']['txtLimitUnits'] = "";
					$unitLimit = 0;
				}
			} else {
				$GLOBALS['temp']['txtLimitUnits'] = "";
				$unitLimit = 0;
			}
		}
		if($unitLimit != 1) {
			$hideUnits = false;
		}
		break;
}

// get principal ------------------------------------------------------------
$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
$principalInfo = getPersonaDetail($principalId);
$resOfficeInfo = getPersonaDetail($resOfficeId);

// Show Provisionals ----------------------------------------------------------
$spU = $spP = $GLOBALS['showProv'];

$showAlloc = false;

if ( $GLOBALS['userStatusId'] < 1 ) {
	if ( $spP == 0 ) {
		$GLOBALS['temp']['provsEnabled'] = "disabled";
	}
} else {
	if ( $spU == 0 ) {
		$GLOBALS['temp']['provsEnabled'] = "disabled";
	}
}

if ( $_SERVER['argv'][15] == "" || $_SERVER['argv'][15] == "true" ) {
	$showProvs = 1;
	$GLOBALS['temp']['chkShowProvs'] = "checked";	
} else {
	$showProvs = 0;
	$GLOBALS['temp']['chkShowProvs'] = "";	
}

if ( $mode == "availability" ) {
	$showAlloc = true;
	$GLOBALS['temp']['chkShowAlloc'] = "checked=\"checked\"";

	if ( $_SERVER['argv'][16] == "false" ) {
		$showAlloc = false;
		$GLOBALS['temp']['chkShowAlloc'] = "";	
	}	
}

if ( $mode == "occupancy" ) {
	$showAlloc = false;
	$GLOBALS['temp']['chkShowAlloc'] = "";

	if ( $_SERVER['argv'][16] == "true" ) {
		$showAlloc = true;
		$GLOBALS['temp']['chkShowAlloc'] = "checked=\"checked\"";	
	}	
}

// In order to keep all the properties and accommodation types in order we have
// to jump through loops.
$property_master_list = $lDB->get("select pr_business_id from pr_business where pr_bus_inactive_yn = '0' order by pr_business_parent asc limit 1",4);

calAcRecurse($property_master_list);
global $calAcRecurseResult;

// Access control for property filter -----------------------------------------
$propertyACL= $lDB->get("
	SELECT DISTINCT
		ac_accomm_type.pr_business_id
	FROM
		sc_accomm,
		ac_accomm_type,
		pr_business,
		pr_persona
	WHERE
		sc_accomm.sc_group_id= '" . $GLOBALS['sc_group_id'] . "'
	AND
		sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
	AND
		ac_accomm_type.ac_accomm_type_inactive_yn = '0'
	AND
		ac_accomm_type.pr_business_id = pr_business.pr_business_id
	AND
		pr_business.pr_bus_inactive_yn= '0'
	AND
		pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
",3);

$propertyFilter = useFilter("properties",$_SERVER['argv'][5],"SELECT pr_persona.pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix =","ac_accomm_type.pr_business_id",$propertyACL,false,false);

$tempPropData = $propertyACL;
$acPropList = array ();
$defaultPropList = array();

foreach ($tempPropData as $item) {
	array_push($acPropList, $item);
}

foreach ( $calAcRecurseResult as $k => $v ) {
	if ( in_array($v, $acPropList) ) {
		array_push($defaultPropList, $v);
	}
}

// Access Control for Accommodation filter ------------------------------------
$accommACL= $lDB->get("
	SELECT DISTINCT
		ac_accomm_type.ac_accomm_type_ix
	FROM
		sc_accomm,
		ac_accomm_type
	WHERE
		sc_accomm.sc_group_id= '" . $GLOBALS['sc_group_id'] . "'
	AND 
		sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
",3);

$accommFilter = useFilter("accomm",$_SERVER['argv'][6],"SELECT CONCAT(ac_accomm_type.ac_accomm_desc,CONCAT(' - ',pr_business.pr_bus_name_short)) FROM ac_accomm_type INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id WHERE ac_accomm_type_ix =","ac_accomm_type.ac_accomm_type_ix",$accommACL,false,false);

// Agent Filter ---------------------------------------------------------------
if ( $userStatusId > 1 ) {
	$GLOBALS['temp']['showAgentFilter'] = "";
	$agentId = "";
	//$GLOBALS['temp']['agentName'] = "Direct";
	$GLOBALS['temp']['agentName'] = "All";

	if ( isset($_SESSION['calendarParms'][3]) && $_SESSION['calendarParms'][3] != "" ) {
		$agentId = $_SESSION['calendarParms'][3];
	}

	if ( $_SERVER['argv'][17] != "" ) {
		$agentId = $_SERVER['argv'][17];
	}

	if ( $jobId == 264 ) {
		$agentACL = false;
		if ( $userStatusId < 2 ) {
			$agentACL = array($calAgentId);
		}
		$agentFilter = useFilter("agent",$_SERVER['argv'][17],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_agent_id",$agentACL,"Direct","0");
	}
} else {
	$agentId = $calAgentId;
	$GLOBALS['temp']['showAgentFilter'] = "style=\"display: none;\"";
	$agentFilter = useFilter("agent",$_SERVER['argv'][17],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_agent_id",false,"Direct","0");
}

if ( $agentId != "" && $agentId != "0" ) {
	$agentArray = explode(":",$agentId);
	$agentNameArray = array();
	foreach ( $agentArray as $a ) {
		$agentName = $lDB->get("
		SELECT 
			pr_persona.pr_name_last
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '" . $a . "'
		",4);
		array_push($agentNameArray,$agentName);
	}
	$agentName = join(", ",$agentNameArray);
} else {
	//$agentName = "Direct";
	$agentName = "All";
}

$GLOBALS['temp']['agentName']	= $agentName;
$GLOBALS['temp']['agentId']		= $agentId;

// Get the accommodation information we need ----------------------------------
$tempAccommIds = array();

foreach ( $defaultPropList as $pID ) {
	$thisAccommId = $lDB -> get("
		SELECT 
			ac_accomm_type.ac_accomm_type_ix,
			ac_accomm_type.ac_accomm_desc AS accommType,		
			pr_persona.pr_name_last AS propertyName	
		FROM
			ac_accomm_type
		INNER JOIN pr_business ON
			pr_business.pr_business_id = ac_accomm_type.pr_business_id
		INNER JOIN pr_persona ON
			pr_persona.pr_persona_ix = pr_business.pr_business_id
		WHERE
			pr_business.pr_business_id = '" . $pID . "' " . $propertyFilter['where'] . " " . $accommFilter['where'] . "
		ORDER BY
			ac_accomm_type.pr_business_id,
			ac_accomm_type.ac_accomm_sequence
	",2);
	array_push($tempAccommIds,$thisAccommId);
}

$accommIds = array();

foreach ( $tempAccommIds as $a ) {
	foreach ( $a as $b ) {
		array_push($accommIds,$b);
	}
}

// Set up the "Previous Report" $_SESSION variable ----------------------------
if ( $_SERVER['argc'] > 1 ) {
	$reportURL = $_SERVER['argv'];

	// Make sure that we only render the HTML report ----------------------------
	$reportURL[7] = 0;
	
	setLastReport("reservation.php?" . join("+",$reportURL));
}

// Renderoption (HTML, PDF, CSV etc.) -----------------------------------------
$options = $_SERVER['argv'][7];

switch($options & 7) {
case REP_VIEW_HTML:
	$renderMode = "html";
	$renderType = "";
	break;
case REP_VIEW_PDF:
	$renderMode = "pdf";
	$renderType = "view";
	break;
case REP_EMAIL_PDF:
	$renderMode = "pdf";
	$renderType = "email";
	break;
case REP_SEND_PDF:
	$renderMode = "pdf";
	$renderType = "send";
	break;
case REP_VIEW_CSV:
	$renderMode = "csv";
	$renderType = "";
}

if ( $renderMode == "pdf" && $renderType == "email" ) {
	$pdfName = $jobName . " - " . $fromDate['htmlDate'] . " to " . $toDate['htmlDate'];
	$attachmentTable = "
		<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
			<tr valign=\"top\">
				<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\" alt=\"\" /></td>
				<td id=\"attachmentLabel\" width=\"100%\">" . $pdfName . ".pdf</td>
			</tr>
		</table>
	";
	$newOptions = ($options & ~7) + 3;
	 
	$formAction = "reservation.php?" . join("+",array_slice($_SERVER['argv'],0,7)) . "+" . $newOptions . "+" . join("+",array_slice($_SERVER['argv'],8,12));

	$GLOBALS[$form]->FormHTML = str_replace("!formAction!",$formAction,
  	str_replace("!attachmentInfo!",$attachmentTable,
    str_replace("!attachmentName!",$pdfName.".pdf",
    str_replace("!hasAttachment!","expand",
    str_replace("!emailBody!","",
    str_replace("!emailSubject!",$pdfName,
    Join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));
	

  $addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
  $GLOBALS['temp']['princName'] = $principalInfo['name'];
  $GLOBALS['temp']['fax'] = $resOfficeInfo['fax'];
  $GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
  $userId = $_SESSION['userid'];
	$GLOBALS['temp']['emailFrom'] = $lDB->get("
		SELECT 
			pr_persona.pr_email 
		FROM 
			pr_persona 
		WHERE 
			pr_persona.pr_persona_ix = '" . $userId . "'
	", 4);
	$GLOBALS['temp']['emailTo'] = "";
}

// GLOBAL Pagination Setup : START --------------------------------------------
$startDate	= "";
$endDate 		= "";
$startPage 	= 1;
$perPage 		= 35;

$dateCount = (dateSubtract($toDate['jsDate'],$fromDate['jsDate']))+1;
$totalPages = ceil($dateCount/$perPage);

$remainder = $dateCount%$perPage;

if ( $page == "" ) {
	$page = $startPage;
}

if ( $page > $totalPages ) {
	$page = $totalPages;
}
// GLOBAL Pagination Setup : END ----------------------------------------------

if ( $_SERVER['argc'] > 1 && $_SERVER['argv'][4] != "fromCal" ) {
	
	// Show the report output buttons
	$GLOBALS['temp']['hideButts'] = "printCollapse outLtt bl br bb";
	$GLOBALS['temp']['emailPDF'] = "button bEmail";
	$GLOBALS['temp']['exportClass'] = "button bExport";
	$GLOBALS['temp']['showHideButtonClass'] = "button";

	/* HTML REPORT : START --------------------------------------------------- */
	if ( $renderMode == "html" ) {
		$GLOBALS['temp']['page'] = "<input type=\"hidden\" id=\"currentPage\" value=\"" . $page . "\" />";
		
		$spacer = "<img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" width=\"770\" height=\"2\" alt=\"\" /><br />";
		
		if ( $pageBreaks == true ) {
			$iterations = 1;

			// [START] Page numbering and navigation --------------------------------
			$GLOBALS['temp']['pageCount'] = $totalPages;
			
			if ( $totalPages > 1 ) {
				$GLOBALS['temp']['pageNum'] = "Page " . $page;
			} else {
				$GLOBALS['temp']['pageNum'] = "";
			}
			
			$GLOBALS['temp']['hidePrevButton'] = "button";
			$GLOBALS['temp']['hideNextButton'] = "button";

			if($page == 1 || $page == 0) {
				$GLOBALS['temp']['hidePrevButton'] = "collapse printCollapse";
			}

			if($page == $totalPages) {
				$GLOBALS['temp']['hideNextButton'] = "collapse printCollapse";
			}

			$currPageList = "";
			$totalList = 8;
			$startList = 1;
			$pageList = "";

			if ( $totalPages < $totalList ) {
				$startList = 1;
				$totalList = $totalPages;
			} else if ( $page <= ($totalList/2) ) {
				$startList = 1;
			} else if ( $page > ($totalList/2) && $page < ($totalPages-($totalList/2)) ) {
				$startList = $page-($totalList/2)+1;
			} else {
				$startList = $totalPages-$totalList+1;
			}

			if ( $page > 1 && $totalPages > 1 && $startList > 1 ) {
				if ( $pageList != "" ) {
					$pageList .= ", ";
				}
				$pageList .= "<a href=\"#\" class=\"txtbr\" onclick=\"gotoPage(1);\">First</a>";
			}

			for ( $count = $startList; $count < ($totalList+$startList); $count++ ) {
				if ( isset($pageList) && $pageList != "" ) {
					$pageList .= ", ";
				}
				
				if ( $count == $page ) {
					$pageList .= "<span class=\"txt\">" . $count . "</span>";
				} else {
					$pageList .= "<a href=\"#\" class=\"txtbr\" onclick=\"gotoPage(" . $count . ");\">" . $count . "</a>";
				}
			}        

			if ( $page < $totalPages && ($startList+$totalList-1) < $totalPages ) {
				if ( $pageList != "" ) {
					$pageList .= ", ";
				}
				$pageList .= "<a href=\"#\" class=\"txtbr\" onclick=\"gotoPage(" . $totalPages . ");\">Last</a>";
			}
			$GLOBALS['temp']['pageList'] = $pageList;
			$GLOBALS['temp']['hidePageSplit'] = "";
			// [ END ] Page numbering and navigation --------------------------------

		} else {
			$iterations = $totalPages;
			$GLOBALS['temp']['hidePageSplit'] = "class=\"collapse printCollapse\"";
		}

		$GLOBALS['temp']['rows'] = "";

		for ( $c = 1; $c <= $iterations; $c++ ) {
			if ( $iterations > 1 ) {
				$currPage = $c;
			} else {
				$currPage = $page;
			}

			$startCount = ($currPage-1)*$perPage;

			if ( $currPage == $totalPages && $remainder != 0 ) {
				$endCount = $remainder;
			} else {
				$endCount = $perPage;
			}

			// Column Groups Setup : START ----------------------------------------------
			$propertyColWidth = 90;
			$unitColWidth 		= 45;
			$dayColWidth 			= 16;
		
			if ( $showUnits == 'false' ) {
				$propertyColWidth = $propertyColWidth + $unitColWidth;				
			}

			$colHTML = "";

			$colHTML .= "
									<colgroup>
										<col id=\"propertyCol" . $c . "\" width=\"" . $propertyColWidth . "\" />
									</colgroup>
			";
			
			if ( $showUnits == 'true' ) {
				$colHTML .= "
					<colgroup id=\"unitCol" . $c . "\">
						<col width=\"" . $unitColWidth . "\" />
					</colgroup>
				";
			}

			$colHTML .= "<colgroup id=\"dayCol\">";

			for ( $j = 0; $j < $endCount; $j++ ) {
				$colHTML .= "<col width=\"" . $dayColWidth . "\" />";
			}

			$colHTML .= "</colgroup>";
			// Column Groups Setup : END ------------------------------------------------
			
			if ( $startCount >= $perPage ) {
				$startDate 	= dateAddDay($fromDate['jsDate'],$startCount);
				$endDate 		= dateAddDay($startDate,$endCount-1);
			} else {
				$startDate 	= $fromDate['jsDate'];
				$endDate 		= dateAddDay($fromDate['jsDate'],$endCount-1);
			}

			$tempAccommCount = array();
			$masterTotals = array();
			foreach ( $accommIds as $k => $v ) {
				switch($mode) {
				case "availability":
					$getAvail = new Stock($v['ac_accomm_type_ix'],$startDate,$endDate);

					$accommIds[$k]['availability']	= $getAvail->ToAvailability($showProvs,false,$showOverBookings,0);
					$accommIds[$k]['allocations']		= $getAvail->ToAllocation();
					$accommIds[$k]['block']					= $getAvail->ToBlock();
					$accommIds[$k]['roomsForToday'] = $getAvail->ToAccomm();

					$accommMax = $getAvail->ToAccommMax();
					$accommMin = $getAvail->ToAccommMin();

					if ( $unitLimit != "0" ) {
						if ( $accommMax > $unitLimit ) {
							$accommMax = $unitLimit;
						}
						if ( $accommMin > $unitLimit ) {
							$accommMin = $unitLimit;
						}
					}

					if ( $accommMax != $accommMin ) {
						$accommIds[$k]['units'] = $accommMin . " - " . $accommMax;
					} else {
						$accommIds[$k]['units'] = $accommMax;
					}

					if ( $showProvs > 0 ) {
						$accommIds[$k]['provCount'] = $getAvail->ToProvisional();
					}

					// We now have all the availability ( including everyone's allocations )
					// Now we simply subtract all allocations from availability.
					foreach ( $accommIds[$k]['availability'] as $avKey => $a ) {
						$accommIds[$k]['availability'][$avKey] -= $accommIds[$k]['allocations'][$avKey];

						// Apply the unit limit while we're here --------------	
						/*if ( $unitLimit != "0" && $accommIds[$k]['availability'][$avKey] > $unitLimit ) {
							$accommIds[$k]['availability'][$avKey] = $unitLimit;							
						}*/
					}

					if ( $showProvs > 0 ) {
						$accommIds[$k]['provCount'] = $getAvail->ToProvisional();
					}

					if ( $showAlloc && $agentId != "" && $agentId != "0" ) {
						$accommIds[$k]['agentAllocation'] = $getAvail->ToAllocationAgent(true,$agentId);
						foreach ( $accommIds[$k]['availability'] as $date => $avail ) {						
							if ( isset($accommIds[$k]['agentAllocation'][$agentId]['total_balance']) || (!isset($agentId) || $agentId == "") ) {
								if ( array_key_exists($date,$accommIds[$k]['agentAllocation'][$agentId]['total_balance']) ) {
									if(isset($accommIds[$k]['availability'][$date])) {
										$accommIds[$k]['availability'][$date] += $accommIds[$k]['agentAllocation'][$agentId]['total_balance'][$date];
									} else {
										$accommIds[$k]['availability'][$date] = $accommIds[$k]['agentAllocation'][$agentId]['total_balance'][$date];
									}
									if ( $accommIds[$k]['availability'][$date] > $accommIds[$k]['units'] ) {
										$accommIds[$k]['availability'][$date] = $accommIds[$k]['units'];
									}
								}
							}
										
							/*if ( $unitLimit != "0" && $accommIds[$k]['availability'][$date] > $unitLimit ) {
								$accommIds[$k]['availability'][$date] = $unitLimit;														
							}*/
						}
					}

					foreach ( $accommIds[$k]['availability'] as $avKey => $a ) {
						// Apply the unit limit while we're here --------------	
						if ( $unitLimit != "0" && $accommIds[$k]['availability'][$avKey] > $unitLimit ) {
							$accommIds[$k]['availability'][$avKey] = $unitLimit;							
						}
					}

					break;

				case "occupancy":
					if ( $agentId != "0" && $agentId != "" ) {
						// We have selected to view specific agents, not just all ---------
						$agentArray = explode(":",$agentId);
						$tempAgentAllocation = array();
						foreach ( $agentArray as $ag ) {
							$getAvail = new Stock($v['ac_accomm_type_ix'],$startDate,$endDate,false,$ag);

							$resStatus = "30";
							if ( $showProvs > 0 ) {
								$resStatus .= ":20";
							}

							$accommIds[$k]['availability']	= $getAvail->ToOccupancy($resStatus);
							$accommIds[$k]['allocations']		= $getAvail->ToAllocation();
							$accommIds[$k]['block']					= $getAvail->ToBlock();
							$accommIds[$k]['roomsForToday'] = $getAvail->ToAccomm();

							$accommMax = $getAvail->ToAccommMax();
							$accommMin = $getAvail->ToAccommMin();

							if ( $unitLimit != "0" ) {
								if ( $accommMax > $unitLimit ) {
									$accommMax = $unitLimit;
								}
								if ( $accommMin > $unitLimit ) {
									$accommMin = $unitLimit;
								}
							}

							if ( $accommMax != $accommMin ) {
								$accommIds[$k]['units'] = $accommMin . " - " . $accommMax;
							} else {
								$accommIds[$k]['units'] = $accommMax;
							}

							if ( $showProvs > 0 ) {
								$accommIds[$k]['provCount'] = $getAvail->ToProvisional();
							}

							if ( $showAlloc ) {
								$tempAgentAllocation = $getAvail->ToAllocationAgent(true,$ag);
								$accommIds[$k]['agentAllocation'][$ag] = isset($tempAgentAllocation[$ag]) ? $tempAgentAllocation[$ag] : "";

								foreach ( $accommIds[$k]['availability'] as $date => $avail ) {
									if ( isset($accommIds[$k]['agentAllocation'][$ag]['total_balance']) || $ag == "" ) {
										if ( array_key_exists($date,$accommIds[$k]['agentAllocation'][$ag]['total_balance']) ) {
											if (isset($tempAccommCount[$k][$date])) {
												$tempAccommCount[$k][$date] += $accommIds[$k]['agentAllocation'][$ag]['total_balance'][$date];
											} else {
												$tempAccommCount[$k][$date] = $accommIds[$k]['agentAllocation'][$ag]['total_balance'][$date];
											}

											if ( $accommIds[$k]['availability'][$date] > $accommIds[$k]['units'] ) {
												$accommIds[$k]['availability'][$date] = $accommIds[$k]['units'];
											}
										}
									}

									if ( $unitLimit != "0" && $accommIds[$k]['availability'][$date] > $unitLimit ) {
										$accommIds[$k]['availability'][$date] = $unitLimit;														
									}
								}
							}

							// Add totals to master array, then back into individual array (to "add up" all agents)
							if (isset($accommIds[$k]['availability'])) {
								foreach ($accommIds[$k]['availability'] as $date => $value) {
									if (!isset($masterTotals[$k])) { $masterTotals[$k] = array(); }
									if (!isset($masterTotals[$k]['availability'])) { $masterTotals[$k]['availability'] = array(); }
									if (!isset($masterTotals[$k]['availability'][$date])) { $masterTotals[$k]['availability'][$date] = 0; }
									$masterTotals[$k]['availability'][$date] += $value;
								}
							}

							foreach ($masterTotals[$k]['availability'] as $date => $value) {
								if (!isset($accommIds[$k])) { $accommIds[$k] = array(); }
								if (!isset($accommIds[$k]['availability'])) { $accommIds[$k]['availability'] = array(); }
								if (!isset($accommIds[$k]['availability'][$date])) { $accommIds[$k]['availability'][$date] = 0; }
								$accommIds[$k]['availability'][$date] = $value;
							}

						}

						// Having built up an array of the total number of allocations per 
						// accomm type per day, we now need to add them to the occupancy 
						// count
						foreach ( $accommIds[$k]['availability'] as $date => $avail ) {
							if ( isset($tempAccommCount[$k]) ) {
								if ( array_key_exists($date,$tempAccommCount[$k]) ) {
									if (isset($accommIds[$k]['availability'][$date])) {
										$accommIds[$k]['availability'][$date] += $tempAccommCount[$k][$date];
									} else {
										$accommIds[$k]['availability'][$date] = $tempAccommCount[$k][$date];
									}
								}
							}
						}

					} else {
						$getAvail = new Stock($v['ac_accomm_type_ix'],$startDate,$endDate,false,$agentId);
						
						$resStatus = "30";
						if ( $showProvs > 0 ) {
							$resStatus .= ":20";
						}

						$accommIds[$k]['availability']	= $getAvail->ToOccupancy($resStatus);
						$accommIds[$k]['allocations']		= $getAvail->ToAllocation();
						$accommIds[$k]['block']					= $getAvail->ToBlock();
						$accommIds[$k]['roomsForToday'] = $getAvail->ToAccomm();

						$accommMax = $getAvail->ToAccommMax();
						$accommMin = $getAvail->ToAccommMin();

						if ( $unitLimit != "0" ) {
							if ( $accommMax > $unitLimit ) {
								$accommMax = $unitLimit;
							}
							if ( $accommMin > $unitLimit ) {
								$accommMin = $unitLimit;
							}
						}

						if ( $accommMax != $accommMin ) {
							$accommIds[$k]['units'] = $accommMin . " - " . $accommMax;
						} else {
							$accommIds[$k]['units'] = $accommMax;
						}

						if ( $showProvs > 0 ) {
							$accommIds[$k]['provCount'] = $getAvail->ToProvisional();
						}

						if ( $showAlloc ) {
							foreach ( $accommIds[$k]['availability'] as $date => $avail ) {
								if (isset($accommIds[$k]['availability'][$date])) {
									$accommIds[$k]['availability'][$date] += $accommIds[$k]['allocations'][$date];
								} else {
									$accommIds[$k]['availability'][$date] = $accommIds[$k]['allocations'][$date];
								}

								if ( $unitLimit != "0" && $accommIds[$k]['availability'][$date] > $unitLimit ) {
									$accommIds[$k]['availability'][$date] = $unitLimit;														
								}
							}
						}
					}
					break;
				}
			}

			//debug($accommIds);

			$propertyName = "";
			$rowHTML = "";

			// ----------------------------------------------------------------------
			// Year, Month, Date & Day table headings : START ///////////////////////
			// ----------------------------------------------------------------------
								
			// Month & Year Display : END -------------------------------------------
			if ( $showUnits == 'true' ) {
				$rowHTML .= '<tr><td>&nbsp;</td><td>&nbsp;</td>';
			} else {
				$rowHTML .= '<tr><td>&nbsp;</td>';
			}

			$dates = array_keys($accommIds[0]['availability']);

			$monthArray = buildMonthYearHeader($dates);

			for($i = 0; $i < count($monthArray); $i++) {
				if($monthArray[$i]['span'] > 2) {
					$rowHTML .= "<td align=\"left\" class=\"bt bl\" colspan=\"" . $monthArray[$i]['span'] . "\">" . $monthArray[$i]['monthyear'] . "</td>";
				} else {
					$rowHTML .= "<td align=\"left\" class=\"bt\" colspan=\"" . $monthArray[$i]['span'] . "\">&nbsp;</td>";
				}
			}
			
			$rowHTML .= "</tr>";
			// Month & Year Display : END -------------------------------------------

			if($showUnits == 'false') {
				$rowHTML .= "<tr><td>&nbsp;</td>";
			} else {
				$rowHTML .= "<tr><td>&nbsp;</td><td>&nbsp;</td>";
			}
			
			foreach($dates as $k => $v) {
				$dateArr = explode("-",$v);
				$dayOfWeek = date("w",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0])); 
				$dayLetter = substr(date("D",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0])),0,1);

				if($dayOfWeek == 0 || $dayOfWeek == 6) {
					$rowHTML .= "<td align=\"center\" valign=\"middle\" class=\"colDk bt bl\">" . $dayLetter . "</td>";
				} else {
					$rowHTML .= "<td align=\"center\" valign=\"middle\" class=\"colLt bt bl\">" . $dayLetter . "</td>";
				}
			}
			$rowHTML .= "</tr>";
			
			$rowHTML .= "<tr>";
			if($showUnits == "true") {
				$rowHTML .= "<td>&nbsp;</td><td align=\"center\" valign=\"middle\" class=\"colLt bt bl\" style=\"cursor: pointer;\" onclick=\"showHideCol('" . $c . "');\">Units <<</td>";
			} else {
				$rowHTML .= "<td>&nbsp;</td>";
			}

			foreach($dates as $k => $v) {
				$dateArr = explode("-",$v);
				$dayOfWeek = date("w",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0])); 
				$dayNumber = date("j",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));

				if($dayOfWeek == 0 || $dayOfWeek == 6) {
					$rowHTML .= "<td align=\"center\" valign=\"middle\" class=\"colDk bt bl\">" . $dayNumber . "</td>";
				} else {
					$rowHTML .= "<td align=\"center\" valign=\"middle\" class=\"colLt bt bl\">" . $dayNumber . "</td>";
				}
			}
			$rowHTML .= "</tr>";
			// --------------------------------------------------------------------------
			// Year, Month, Date & Day table headings : END /////////////////////////////
			// --------------------------------------------------------------------------

			$max = count($accommIds);
			for($i = 0; $i < $max; $i++) {

				$rowHTML .= "<tr>";
				if($propertyName != $accommIds[$i]['propertyName']) {
					$propertyName = $accommIds[$i]['propertyName'];
					if($showUnits == 'true') {
						$rowHTML .= "<td colspan=\"" . (count($accommIds[$i]['availability'])+2) . "\"  class=\"colLt bt bl\">&nbsp;<strong>" . $propertyName . "</strong></td></tr><tr>";
					} else {
						$rowHTML .= "<td colspan=\"" . (count($accommIds[$i]['availability'])+1) . "\"  class=\"colLt bt bl\">&nbsp;<strong>" . $propertyName . "</strong></td></tr><tr>";
					}
				}

				if ( strlen($accommIds[$i]['accommType']) > 20 ) {
					$accommName = "<span style=\"cursor: pointer;\" onmouseover=\"overlib('" . $accommIds[$i]['accommType'] . "');\" onmouseout=\"nd();\">" . substr($accommIds[$i]['accommType'],0,17) . "..." . "</span>";
				} else {
					$accommName = $accommIds[$i]['accommType'];
				}

				if ( $showUnits == "true" ) {
					$rowHTML .= "<td class=\"colLtt bt bl\">" . $accommName . "</td>";
					$rowHTML .= "<td align=\"center\" valign=\"middle\" class=\"bt bl\"><b>" . $accommIds[$i]['units'] .  "</b></td>";
				} else {
					$rowHTML .= "<td class=\"colLtt bt bl\">" . $accommName . "</td>";
				}

				foreach($accommIds[$i]['availability'] as $k => $v) {

					$dateArr = explode("-",$k);
					$dayOfWeek = date("w",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));



					if ( $showProvs > 0 ) {
						if ( $accommIds[$i]['provCount'][$k] > 0 ) {
							$v .= "*";
						}
					}

					// Figure out cell CSS classes --------------------------------------
					$cellClass = "bt bl";
					

					if ( $jobId == 262 ) {
						// Availability Report cell colouring -----------------------------
						if ( $v <= 0 ) {
							$cellClass = "bt bl noavailability";
						}

						if ( $accommIds[$i]['block'][$k] == $accommIds[$i]['roomsForToday'][$k] ) {
							$cellClass = "bt bl bgBlock";
							$v = "&nbsp;";
						}

						if ( $showAlloc && isset($accommIds[$i]['agentAllocation'][$agentId]['total_balance'][$k]) && $accommIds[$i]['agentAllocation'][$agentId]['total_balance'][$k] > 0 ) {
							$cellClass .= " allocationIndicator";
						}

						if($hideUnits) {
							$v = "&nbsp;";
						}
					}

					if ( $jobId == 264 ) {
						// Occupancy Report cell colouring --------------------------------
						if ( $v == ( $accommIds[$i]['roomsForToday'][$k] - $accommIds[$i]['block'][$k]) ) {
							$cellClass = "bt bl bgFull";
						}

						if ( $v > ( $accommIds[$i]['roomsForToday'][$k] - $accommIds[$i]['block'][$k]) ) {
							$cellClass = "bt bl noavailability";
						}
	
						if ( $accommIds[$i]['block'][$k] == $accommIds[$i]['roomsForToday'][$k] ) {
							$cellClass = "bt bl bgBlock";
						}

						if ( $agentId != "0" & $agentId != "" ) {
							$agentArray = explode(":",$agentId);
							foreach ( $agentArray as $ag ) {
								if ( $showAlloc && isset($accommIds[$i]['agentAllocation'][$ag]['total_balance'][$k]) && $accommIds[$i]['agentAllocation'][$ag]['total_balance'][$k] > 0 ) {
									$cellClass .= " allocationIndicator";
								}
							}
						} else {
							if ( $agentId != "0" ) {
								if ( $showAlloc && $accommIds[$i]['allocations'][$k] > 0 ) {
									$cellClass .= " allocationIndicator";
								}
							}
						}
						if ( $v == "0" ) {
							$v = "&nbsp;";
						}
					}

					if ( $dayOfWeek == 0 || $dayOfWeek == 6 ) {
						$rowHTML .= "<td align=\"center\" valign=\"middle\" class=\"colDk " . $cellClass . "\">" . $v . "</td>";
					} else {
						$rowHTML .= "<td align=\"center\" valign=\"middle\" class=\"" . $cellClass . "\">" . $v . "</td>";
					}
				}
				$rowHTML .= "</tr>";
			}
			$GLOBALS['temp']['rows'] .= $spacer . "<table width=\"770\" cellspacing=\"0\" cellpadding=\"1\" class=\"br bb\" border=\"0\" style=\"table-layout: fixed;\">" . $colHTML . $rowHTML . "</table>" . $spacer;
		}
	}
	/* HTML REPORT : END ----------------------------------------------------- */

	/* PDF REPORT : START ---------------------------------------------------- */
	if ($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {

		// Parameter Bar Setup : START --------------------------------------------
		$paramBar = array();
		$paramBar["P"] 	= ( $propertyFilter['ids'] != "" ) ? 1 : 0;
		$paramBar["AT"] = ( $accommFilter['ids'] != "" ) ? 1 : 0;
		$paramBar["AG"] = ( $agentId != "" && $agentId != "0" ) ? 1 : 0;
		$paramBar["IP"] = ( $showProvs > 0 ) ? 1 : 0;
		$paramBar["AL"] = ( $showAlloc ) ? 1 : 0;
		$paramBar["SU"]	= ( $showUnits == 'true' ) ? 1 : 0;
		$paramBar["O"]	= ( $showOverBookings > 0 ) ? 1 : 0;
		$paramBar["MU"] = ( $unitLimit > 0 ) ? 1 : 0;
		$paramBar["PB"] = ( $pageBreaks ) ? 1 : 0;		
		// Parameter Bar Setup : END ----------------------------------------------

		// [START] Colours --------------------------------------------------------
		$cWkEnd				= array(0xca,0xa6,0x3b);
		$cOverBooking		= array(0xbd,0x30,0x31);
		$cFull				= array(0x39,0x55,0x94);
		$cWhite				= array(0xff,0xff,0xff);
		$cBlock				= array(0xcc,0xcc,0xcc);
		$cColLt				= array(0xf8,0xe8,0xbb);
		$cColLtt			= array(0xfc,0xf3,0xda);
		$cColDk				= array(0xe5,0xd1,0x99);
		$tWhite				= array(0xff,0xff,0xff);
		$tBlack				= array(0x00,0x00,0x00);
		// [ END ] Colours --------------------------------------------------------

		if($showUnits == 'true') {
			$accommCellWidth = "10%";
		} else {
			$accommCellWidth = "15%";
		}

		$maxRowsPerPage = 40;

		// PDF Pagination setup to mitigate rows breaking across pages : START ----
		$propertyArr = array();
		
		foreach($accommIds as $k => $v) {
			array_push($propertyArr,$accommIds[$k]['propertyName']);
		}

		$propertyCount = count(array_unique($propertyArr));
		$accommCount = count($accommIds);

		// Number of rows taken per page ------------------------------------------
		$rowCount = $propertyCount + $accommCount + 3;
		
		$splitPoint = floor($maxRowsPerPage/$rowCount);
		if($splitPoint < 1) { $splitPoint = 1; }
		// PDF Pagination setup to mitigate rows breaking across pages : END ------

		$pdf = new PDF($jobName,'L');
		$reportLabel = $jobName;

		//$pdf -> SetFillColor(0x9c,0x9e,0x98);

		$headerArray = array(array('name' => "Date Range", 'value' => $fromDate['htmlDate'] . " to " . $toDate['htmlDate']));
		
		$pdfHeadPropertyFilter 		= $propertyFilter['names'];
		$pdfHeadAccommodationFilter = $accommFilter['names'];
		$pdfHeadAgentFilter			= $agentName;
		$pdfHeadShowProvisionals	= ( $showProvs > 0 ) ? "Yes" : "No";
		$pdfHeadShowAllocations		= ( $showAlloc ) ? "Yes" : "No";
		$pdfHeadShowUnits 			= ( $showUnits ) ? "Yes" : "No";
		$pdfHeadUnitLimit 			= ( $unitLimit == "" || $unitLimit == "0" ) ? "No limit" : $unitLimit;
		$pdfHeadShowOverbookings 	= ( $showOverBookings ) ? "Yes" : "No";
		$pdfHeadPageBreaks			= ( $pageBreaks > 0 ) ? "Yes" : "No";
		$pdfHeadShowParams			= ( $showParameters > 0 ) ? "Yes" : "No";

		array_push($headerArray,array('name' => "Properties", 'value' => $pdfHeadPropertyFilter));
		array_push($headerArray,array('name' => "Accommodation Types", 'value' => $pdfHeadAccommodationFilter));
		array_push($headerArray,array('name' => "Agents", 'value' => $pdfHeadAgentFilter));
		array_push($headerArray,array('name' => "Include Provisionals", 'value' => $pdfHeadShowProvisionals));
		array_push($headerArray,array('name' => "Add agent Allocations", 'value' => $pdfHeadShowAllocations));
		array_push($headerArray,array('name' => "Show units", 'value' => $pdfHeadShowUnits));
		array_push($headerArray,array('name' => "Max. units", 'value' => $pdfHeadUnitLimit));
		array_push($headerArray,array('name' => "Show Overbookings", 'value' => $pdfHeadShowOverbookings));
		array_push($headerArray,array('name' => "Insert page breaks", 'value' => $pdfHeadPageBreaks));
		array_push($headerArray,array('name' => "Show report parameters", 'value' => $pdfHeadShowParams));

		$pdfFontSize = 8;
		$pdf->SetFont('Arial', '', $pdfFontSize);
		
		$pdf->Ln(4);

		$logo = "top_clientlogo.jpg";
		$principal_id = $_SESSION['principal_id'];
		
		if ( file_exists("$GLOBALS[images_dir_on_disk]/" . $principal_id . "/" . $logo) ) {
			$pic = $pdf->_parsejpg("$GLOBALS[images_dir_on_disk]/" . $principal_id . "/" . $logo);

			$h = $pic['h']/4;
			$w = $pic['w']/4;

			require_once(__DIR__ . '/functions.imageset.php');
			$logoWidth = imagesetLogoSizeOverride("availabilityReportPdfLogoWidthOverride", $w);
			$pdf->Image("$GLOBALS[images_dir_on_disk]/" . $principal_id."/" . $logo, $h, 5, $logoWidth);
			if ( ($h + 8) > $pdf->y ) {
      	$pdf->y = $h + 8;
			}
		} 

		for( $c = 1; $c <= $totalPages; $c++ ) {
			if ( $c%$splitPoint == 1 && $c > 1 && $pageBreaks != 'true' ) {
				$pdf -> addPage();
			}

			$startCount = ($c-1)*$perPage;

			if($c == $totalPages && $remainder != 0) {
				$endCount = $remainder;
				$lastPage = 1;
				$propertyCellWidth = $accommCellWidth + ($remainder*2.42);
				if($showUnits == 'true') {
					$propertyCellWidth += 5;
				}
				$propertyCellWidth .= "%";
			} else {
				$endCount = $perPage;
				$lastPage = 0;
				$propertyCellWidth = "99.7%";
			}

			$startDate = dateAddDay($fromDate['jsDate'],$startCount);
			$endDate = dateAddDay($startDate,$endCount-1);

			/*
			foreach($accommIds as $k => $v) {
				if ( ( $agentId != "" && $agentId != "0" ) && $mode == "occupancy" ) {
					$getAvail = new Stock($v['ac_accomm_type_ix'],$startDate,$endDate,false,$agentId);
				} else {
					$getAvail = new Stock($v['ac_accomm_type_ix'],$startDate,$endDate);
				}
				
				switch($mode) {
				case "availability":
					$accommIds[$k]['availability'] = $getAvail->ToAvailability($showProvs,false,$showOverBookings);
					$accommIds[$k]['allocations'] = $getAvail->ToAllocation();
					
					// We now have all the availability ( including everyone's allocations )
					// Now we simply subtract all allocations from availability.
					foreach ( $accommIds[$k]['availability'] as $avKey => $a ) {
						$accommIds[$k]['availability'][$avKey] -= $accommIds[$k]['allocations'][$avKey];
						
						// Apply the unit limit while we're here --------------	
						if ( $unitLimit != "0" && $accommIds[$k]['availability'][$avKey] > $unitLimit ) {
							$accommIds[$k]['availability'][$avKey] = $unitLimit;							
						}
					}
					break;
				case "occupancy":
					$resStatus = "30";
					if ( $showProvs > 0 ) {
						$resStatus .= ":20";
					}
					
					if ( $showAllocs ) {
						$resStatus .= ":15";
					}

					$accommIds[$k]['availability'] = $getAvail->ToOccupancy($resStatus);
					$accommIds[$k]['allocations'] = $getAvail->ToAllocation();
					
					if ( $showAlloc ) {
						$agentArray = explode(":",$agentId);
						foreach ( $agentArray as $a ) {
							$accommIds[$k]['agentAllocation'] = $getAvail->ToAllocationAgent(true,$a);
							foreach ( $accommIds[$k]['availability'] as $date => $avail ) {
								if ( $accommIds[$k]['agentAllocation'][$a]['total_balance'] || $a == "" ) {
									if ( array_key_exists($date,$accommIds[$k]['agentAllocation'][$a]['total_balance']) ) {
										$accommIds[$k]['availability'][$date] += $accommIds[$k]['agentAllocation'][$a]['total_balance'][$date];
										if ( $accommIds[$k]['availability'][$date] > $accommIds[$k]['units'] ) {
											$accommIds[$k]['availability'][$date] = $accommIds[$k]['units'];
										}
									}
								}
							}
						}
					}
					
					// Apply the unit limit -----------------------------------
					if ( $unitLimit != "0" && $a  > $unitLimit ) {
						$accommIds[$k]['availability'][$key] = $unitLimit;
					}
					break;
				}
				
				$accommMax = $getAvail->ToAccommMax();
				$accommMin = $getAvail->ToAccommMin();

				if ( $unitLimit != 0 ) {
					if ( $accommMax > $unitLimit ) {
						$accommMax = $unitLimit;
					}
					if ( $accommMin > $unitLimit ) {
						$accommMin = $unitLimit;
					}
				}

				if ( $accommMax != $accommMin ) {
					$accommIds[$k]['units'] = $accommMin . " - " . $accommMax;
				} else {
					$accommIds[$k]['units'] = $accommMax;
				}
				
				if ( $showProvs > 0 ) {
					$accommIds[$k]['provCount'] = $getAvail->ToProvisional();
				}

				if ( $showAlloc && $agentId != "" && $agentId != "0" && $mode == "availability" ) {
					$accommIds[$k]['agentAllocation'] = $getAvail->ToAllocationAgent(true,$agentId);
					foreach ( $accommIds[$k]['availability'] as $date => $avail ) {						
						if ( $accommIds[$k]['agentAllocation'][$agentId]['total_balance'] || $agentId == "" ) {
							if ( array_key_exists($date,$accommIds[$k]['agentAllocation'][$agentId]['total_balance']) ) {
								$accommIds[$k]['availability'][$date] += $accommIds[$k]['agentAllocation'][$agentId]['total_balance'][$date];
								if ( $accommIds[$k]['availability'][$date] > $accommIds[$k]['units'] ) {
									$accommIds[$k]['availability'][$date] = $accommIds[$k]['units'];
								}
							}
						}

						if ( $unitLimit != "0" && $accommIds[$k]['availability'][$date] > $unitLimit ) {
							$accommIds[$k]['availability'][$date] = $unitLimit;														
						}								
					}
				}
			}*/
			$tempAccommCount = array();
			$masterTotals = array();
			foreach ( $accommIds as $k => $v ) {
				switch($mode) {
				case "availability":
					$getAvail = new Stock($v['ac_accomm_type_ix'],$startDate,$endDate);

					$accommIds[$k]['availability']	= $getAvail->ToAvailability($showProvs,false,$showOverBookings,0);
					$accommIds[$k]['allocations']		= $getAvail->ToAllocation();
					$accommIds[$k]['block']				= $getAvail->ToBlock();
					$accommIds[$k]['roomsForToday'] = $getAvail->ToAccomm();

					$accommMax = $getAvail->ToAccommMax();
					$accommMin = $getAvail->ToAccommMin();

					if ( $unitLimit != "0" ) {
						if ( $accommMax > $unitLimit ) {
							$accommMax = $unitLimit;
						}
						if ( $accommMin > $unitLimit ) {
							$accommMin = $unitLimit;
						}
					}

					if ( $accommMax != $accommMin ) {
						$accommIds[$k]['units'] = $accommMin . " - " . $accommMax;
					} else {
						$accommIds[$k]['units'] = $accommMax;
					}

					if ( $showProvs > 0 ) {
						$accommIds[$k]['provCount'] = $getAvail->ToProvisional();
					}

					// We now have all the availability ( including everyone's allocations )
					// Now we simply subtract all allocations from availability.
					foreach ( $accommIds[$k]['availability'] as $avKey => $a ) {
						$accommIds[$k]['availability'][$avKey] -= $accommIds[$k]['allocations'][$avKey];

						// Apply the unit limit while we're here --------------	
						/*if ( $unitLimit != "0" && $accommIds[$k]['availability'][$avKey] > $unitLimit ) {
							$accommIds[$k]['availability'][$avKey] = $unitLimit;							
						}*/
					}

					if ( $showProvs > 0 ) {
						$accommIds[$k]['provCount'] = $getAvail->ToProvisional();
					}

					if ( $showAlloc && $agentId != "" && $agentId != "0" ) {
						$accommIds[$k]['agentAllocation'] = $getAvail->ToAllocationAgent(true,$agentId);
						foreach ( $accommIds[$k]['availability'] as $date => $avail ) {						
							if (
								(
									isset($accommIds) &&
									isset($accommIds[$k]) &&
									isset($accommIds[$k]['agentAllocation']) &&
									isset($accommIds[$k]['agentAllocation'][$agentId]) &&
									isset($accommIds[$k]['agentAllocation'][$agentId]['total_balance'])
								) ||
								$agentId == ""
							) {
								if ( array_key_exists($date,$accommIds[$k]['agentAllocation'][$agentId]['total_balance']) ) {
									if (isset($accommIds[$k]['availability'][$date])) {
										$accommIds[$k]['availability'][$date] += $accommIds[$k]['agentAllocation'][$agentId]['total_balance'][$date];
									} else {
										$accommIds[$k]['availability'][$date] = $accommIds[$k]['agentAllocation'][$agentId]['total_balance'][$date];
									}
									if ( $accommIds[$k]['availability'][$date] > $accommIds[$k]['units'] ) {
										$accommIds[$k]['availability'][$date] = $accommIds[$k]['units'];
									}
								}
							}
										
							/*if ( $unitLimit != "0" && $accommIds[$k]['availability'][$date] > $unitLimit ) {
								$accommIds[$k]['availability'][$date] = $unitLimit;														
							}*/
						}
					}

					foreach ( $accommIds[$k]['availability'] as $avKey => $a ) {
						// Apply the unit limit while we're here --------------	
						if ( $unitLimit != "0" && $accommIds[$k]['availability'][$avKey] > $unitLimit ) {
							$accommIds[$k]['availability'][$avKey] = $unitLimit;							
						}
					}
					
					break;

				case "occupancy":
					if ( $agentId != "0" && $agentId != "" ) {
						// We have selected to view specific agents, not just all ---------
						$agentArray = explode(":",$agentId);
						$tempAgentAllocation = array();
						foreach ( $agentArray as $ag ) {
							$getAvail = new Stock($v['ac_accomm_type_ix'],$startDate,$endDate,false,$ag);

							$resStatus = "30";
							if ( $showProvs > 0 ) {
								$resStatus .= ":20";
							}

							$accommIds[$k]['availability']	= $getAvail->ToOccupancy($resStatus);
							$accommIds[$k]['allocations']		= $getAvail->ToAllocation();
							$accommIds[$k]['block']					= $getAvail->ToBlock();
							$accommIds[$k]['roomsForToday'] = $getAvail->ToAccomm();

							$accommMax = $getAvail->ToAccommMax();
							$accommMin = $getAvail->ToAccommMin();

							if ( $unitLimit != "0" ) {
								if ( $accommMax > $unitLimit ) {
									$accommMax = $unitLimit;
								}
								if ( $accommMin > $unitLimit ) {
									$accommMin = $unitLimit;
								}
							}

							if ( $accommMax != $accommMin ) {
								$accommIds[$k]['units'] = $accommMin . " - " . $accommMax;
							} else {
								$accommIds[$k]['units'] = $accommMax;
							}

							if ( $showProvs > 0 ) {
								$accommIds[$k]['provCount'] = $getAvail->ToProvisional();
							}

							if ( $showAlloc ) {
								$tempAgentAllocation = $getAvail->ToAllocationAgent(true,$ag);
								$accommIds[$k]['agentAllocation'][$ag] = $tempAgentAllocation[$ag];

								foreach ( $accommIds[$k]['availability'] as $date => $avail ) {
									if ( $accommIds[$k]['agentAllocation'][$ag]['total_balance'] || $ag == "" ) {
										if ( array_key_exists($date,$accommIds[$k]['agentAllocation'][$ag]['total_balance']) ) {
											if (isset($tempAccommCount[$k][$date])) {
												$tempAccommCount[$k][$date] += $accommIds[$k]['agentAllocation'][$ag]['total_balance'][$date];
											} else {
												$tempAccommCount[$k][$date] = $accommIds[$k]['agentAllocation'][$ag]['total_balance'][$date];
											}

											if ( $accommIds[$k]['availability'][$date] > $accommIds[$k]['units'] ) {
												$accommIds[$k]['availability'][$date] = $accommIds[$k]['units'];
											}
										}
									}

									if ( $unitLimit != "0" && $accommIds[$k]['availability'][$date] > $unitLimit ) {
										$accommIds[$k]['availability'][$date] = $unitLimit;														
									}
								}
							}

							// Add totals to master array, then back into individual array (to "add up" all agents)
							if (isset($accommIds[$k]['availability'])) {
								foreach ($accommIds[$k]['availability'] as $date => $value) {
									if (!isset($masterTotals[$k])) { $masterTotals[$k] = array(); }
									if (!isset($masterTotals[$k]['availability'])) { $masterTotals[$k]['availability'] = array(); }
									if (!isset($masterTotals[$k]['availability'][$date])) { $masterTotals[$k]['availability'][$date] = 0; }
									$masterTotals[$k]['availability'][$date] += $value;
								}
							}

							foreach ($masterTotals[$k]['availability'] as $date => $value) {
								if (!isset($accommIds[$k])) { $accommIds[$k] = array(); }
								if (!isset($accommIds[$k]['availability'])) { $accommIds[$k]['availability'] = array(); }
								if (!isset($accommIds[$k]['availability'][$date])) { $accommIds[$k]['availability'][$date] = 0; }
								$accommIds[$k]['availability'][$date] = $value;
							}
						}

						// Having built up an array of the total number of allocations per 
						// accomm type per day, we now need to add them to the occupancy 
						// count
						foreach ( $accommIds[$k]['availability'] as $date => $avail ) {
							if ( $tempAccommCount && $tempAccommCount[$k] ) {
								if ( array_key_exists($date,$tempAccommCount[$k]) ) {
									if (isset($accommIds[$k]['availability'][$date])) {
										$accommIds[$k]['availability'][$date] += $tempAccommCount[$k][$date];
									} else {
										$accommIds[$k]['availability'][$date] = $tempAccommCount[$k][$date];
									}
								}
							}
						}
					} else {
						$getAvail = new Stock($v['ac_accomm_type_ix'],$startDate,$endDate,false,$agentId);
						
						$resStatus = "30";
						if ( $showProvs > 0 ) {
							$resStatus .= ":20";
						}

						$accommIds[$k]['availability']	= $getAvail->ToOccupancy($resStatus);
						$accommIds[$k]['allocations']		= $getAvail->ToAllocation();
						$accommIds[$k]['block']					= $getAvail->ToBlock();
						$accommIds[$k]['roomsForToday'] = $getAvail->ToAccomm();

						$accommMax = $getAvail->ToAccommMax();
						$accommMin = $getAvail->ToAccommMin();

						if ( $unitLimit != "0" ) {
							if ( $accommMax > $unitLimit ) {
								$accommMax = $unitLimit;
							}
							if ( $accommMin > $unitLimit ) {
								$accommMin = $unitLimit;
							}
						}

						if ( $accommMax != $accommMin ) {
							$accommIds[$k]['units'] = $accommMin . " - " . $accommMax;
						} else {
							$accommIds[$k]['units'] = $accommMax;
						}

						if ( $showProvs > 0 ) {
							$accommIds[$k]['provCount'] = $getAvail->ToProvisional();
						}

						if ( $showAlloc ) {
							foreach ( $accommIds[$k]['availability'] as $date => $avail ) {
								if (isset($accommIds[$k]['availability'][$date])) {
									$accommIds[$k]['availability'][$date] += $accommIds[$k]['allocations'][$date];
								} else {
									$accommIds[$k]['availability'][$date] = $accommIds[$k]['allocations'][$date];
								}

								if ( $unitLimit != "0" && $accommIds[$k]['availability'][$date] > $unitLimit ) {
									$accommIds[$k]['availability'][$date] = $unitLimit;														
								}
							}
						}
					}
					break;
				}
			}
			
			// Month & Year Headings : START ----------------------------------------
			$dates = array_keys($accommIds[0]['availability']);
			
			$monthYearArr = array(array('width' => $accommCellWidth,'data' => '', 'border' => 'LT'));
			
			if($showUnits == 'true') {
				array_push($monthYearArr,array('width' => '5%', 'data' => '', 'border' => 'T'));
			}

			$monthArray = buildMonthYearHeader($dates);

			$dStyle = "LT";		
			
			for($i = 0; $i < count($monthArray); $i++) {
				$cellwidth = $monthArray[$i]['span']*2.42 . "%";

				if($i == count($monthArray)-1) {
					$dStyle .= "R";
				}

				if($monthArray[$i]['span'] > 2) {
					array_push($monthYearArr,array('width' => $cellwidth, 'data' => $monthArray[$i]['monthyear'], 'border' => $dStyle));
				} else {
					array_push($monthYearArr,array('width' => $cellwidth, 'data' => '', 'border' => $dStyle));
				}
			}
			
			$pdf -> Row($monthYearArr);
			// Month & Year Headings : END ------------------------------------------

			// Day Letter Row : START -----------------------------------------------
			$dayRowArray = array(array('width' => $accommCellWidth, 'data' => '', 'border' => 'L'));
			
			if($showUnits == 'true') {
				array_push($dayRowArray,array('width' => "5%", 'data' => ''));
			}

			foreach($accommIds[0]['availability'] as $k => $v) {
				$dateArr = explode("-",$k);
				$dayOfWeek = date("w",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));
				$dayLetter = substr(date("D",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0])),0,1);

				if($dayOfWeek == 0 || $dayOfWeek == 6) {
					array_push($dayRowArray,array('width' => "2.42%", 'data' => $dayLetter, 'border' => "LRTB", 'align' => 'C', 'fill' => '1', 'fillColor'	=> $cColDk));
				} else {
					array_push($dayRowArray,array('width' => '2.42%', 'data' => $dayLetter, 'border' => "LRTB", 'align' => 'C', 'fill' => '1', 'fillColor'	=> $cColLt));
				}
			}
			$pdf -> Row($dayRowArray);
			// Day Letter Row : END -----------------------------------------------------

			// Day Number Row : START ---------------------------------------------------
			$dayNumberRowArray = array(array('width' => $accommCellWidth, 'data' => '', 'border' => 'L'));

			if($showUnits == 'true') {
				array_push($dayNumberRowArray,array('width' => "5%", 'data' => 'Units', 'border' => 'LRTB', 'fill' => '1', 'fillColor'	=> $cColLt));
			}

			foreach($accommIds[0]['availability'] as $k => $v) {
				$dateArr = explode("-",$k);
				$dayOfWeek = date("w",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));
				$dayNumber = date("j",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));

				if($dayOfWeek == 0 || $dayOfWeek == 6) {
						array_push($dayNumberRowArray,array('width' => "2.42%", 'data' => $dayNumber, 'border' => "LRTB", 'align' => 'C', 'fill' => '1', 'fillColor'	=> $cColDk));
				} else {
					array_push($dayNumberRowArray,array('width' => '2.42%', 'data' => $dayNumber, 'border' => "LRTB", 'align' => 'C', 'fill' => '1', 'fillColor'	=> $cColLt));
				}				
			}
			$pdf -> Row($dayNumberRowArray);
			// Day Number Row : END -----------------------------------------------------

			// Main Content : START -----------------------------------------------------
			$propertyName = "";
			for($i = 0; $i < count($accommIds); $i++) {
				if($accommIds[$i]['propertyName'] != $propertyName) {
					$propertyName = $accommIds[$i]['propertyName'];
					$pdf->Row(array(array('width' => $propertyCellWidth, 'data' => $accommIds[$i]['propertyName'], 'border' => "LRBT", 'fill' => '1', 'fillColor'	=> $cColLt)));
				}

				$currRowArray = array(array('width' => $accommCellWidth, 'data' => $accommIds[$i]['accommType'], 'border' => 'LRTB', 'fill' => '1', 'fillColor'	=> $cColLtt));

				if($showUnits == 'true') {
					array_push($currRowArray,array('width' => "5%", 'data' => $accommIds[$i]['units'], 'border' => 'LRTB', 'align' => 'C'));
				}

				foreach($accommIds[$i]['availability'] as $k => $v) {
					$fillColour = $cWhite;
					$textColour = $tBlack;

					$dateArr = explode("-",$k);
					$dayOfWeek = date("w",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));

					if ( $dayOfWeek == 0 || $dayOfWeek == 6 ) {
						$fillColour = $cColDk;
					}

					if($showProvs > 0) {
						if($accommIds[$i]['provCount'][$k] > 0) {
							$v .= "*";
						}
					}

					if ( $jobId == 262 ) {
						// Availability Report cell colouring -----------------------------
						if ( $v <= 0 ) {
							$fillColour = array(0xbd,0x30,0x31);
						}

						if ( $accommIds[$i]['block'][$k] == $accommIds[$i]['roomsForToday'][$k] ) {
							$fillColour = array(0xcc,0xcc,0xcc);
							$v = "";
						}

						if($hideUnits) {
							$v = "";
						}
					}


					if ( $jobId == 264 ) {
						// Occupancy Report cell colouring --------------------------------
						if ( $v == ( $accommIds[$i]['roomsForToday'][$k] - $accommIds[$i]['block'][$k]) ) {
							$fillColour = $cFull;
							$textColour = $tWhite;
						}

						if ( $v > ( $accommIds[$i]['roomsForToday'][$k] - $accommIds[$i]['block'][$k]) ) {
							$fillColour = $cOverBooking;
							$textColour = $tWhite;
						}
	
						if ( $accommIds[$i]['block'][$k] == $accommIds[$i]['roomsForToday'][$k] ) {
							$fillColour = $cBlock;
						}

						if ( $v == "0" ) {
							$v = "";
						}
					}

					array_push($currRowArray,array('width' => "2.42%", 'data' => $v,'border' => "LRTB", 'align' => 'C', 'fill' => '1', 'fillColor' => $fillColour, 'textColor' => $textColour ));
				}
				$pdf -> Row($currRowArray);
			}
			// Main Content : END -------------------------------------------------------
			$pdf -> Ln(4);
			if($pageBreaks == 'true' && ($c != $totalPages)) {
				$pdf -> addPage();
			}
		}

		// Parameter Bar : START ----------------------------------------------------
		$pdf -> Ln(8);

		$paramRow = array();
		array_push($paramRow,array('width' => "72.7%", 'data' => "", 'border' => "", 'align' => "C"));

		foreach($paramBar as $k => $v) {
			if($v == 1) {
				array_push($paramRow,array('width' => "3%", 'data' => $k, 'border' => "LRTB", 'align' => "C", 'fill' => '1'));
			} else {
				array_push($paramRow,array('width' => "3%", 'data' => $k, 'border' => "LRTB", 'align' => "C"));
			}
		}
		$pdf -> Row($paramRow);
		// Parameter Bar : END ------------------------------------------------------

		// Standard Parameters
		if($showParameters == 1) {
			$pdf->ReportHeader($reportLabel, $headerArray);
		}

		if($renderType == "view") {
			$pdf->OutPut();
			die();
		}
		
		if($renderType == "send") {
			$to = $_POST['mail_to'];
			$from = $_POST['mail_from'];
			$subject = $_POST['mail_subj'];
			$message = $_POST['mail_body'];
			$attachmentName = $_POST['attachmentName'];

			$headers = "From: " . $principalInfo['name'] . "<$from>\r\n";

			// Close the PDF
			if($pdf->state < 3) {
				$pdf->Close();
			}

			// Mail the PDF
			if($attachmentName != "!attachmentName!") {
				$pdfName = $attachmentName;
			} else {
				$pdfName = "Update report from $fromDate to $toDate.pdf";
			}

			$error = email($from, $to, $subject, $headers, $message, 0, 0, $_SERVER['argv'][1], $principalInfo['name'],$pdf->buffer,$pdfName);     // (from, to, subject, headers, message, action, emailID, resID)

			if(!$error) {
				echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
				die();
			} else {
				echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
				die();
			}
		}
	}
	/* PDF REPORT : END ------------------------------------------------------ */

	/* CSV REPORT : START ---------------------------------------------------- */
	if ( $renderMode == "csv" ) {
		$csvFile = array();
		array_push($csvFile,array($jobName));
		array_push($csvFile,array());
		array_push($csvFile,array("Date Range",$fromDate['htmlDate'] . " to " . $toDate['htmlDate']));

		$csvHeadPropertyFilter 		= $propertyFilter['names'];
		$csvHeadAccommodationFilter = $accommFilter['names'];
		$csvHeadAgentFilter			= $agentName;
		$csvHeadShowProvisionals	= ( $showProvs > 0 ) ? "Yes" : "No";
		$csvHeadShowAlloc			= ( $showAlloc ) ? "Yes" : "No";
		$csvHeadShowUnits 			= ( $showUnits ) ? "Yes" : "No";
		$csvHeadUnitLimit 			= ( $unitLimit == "" || $unitLimit == "0" ) ? "No limit" : $unitLimit;
		$csvHeadShowOverbookings	= ( $showOverBookings ) ? "Yes" : "No";

		array_push($csvFile,array("Property filter:",$csvHeadPropertyFilter));
		array_push($csvFile,array("Accommodation types:",$csvHeadAccommodationFilter));
		array_push($csvFile,array("Agents:",$csvHeadAgentFilter));
		array_push($csvFile,array("Include provisionals:",$csvHeadShowProvisionals));
		array_push($csvFile,array("Add agent allocations:",$csvHeadShowAlloc));
		array_push($csvFile,array("Show unit totals:",$csvHeadShowUnits));
		array_push($csvFile,array("Available rooms limit:",$csvHeadUnitLimit));

		array_push($csvFile,array());

		/*
		foreach($accommIds as $k => $v) {
			if ( ( $agentId != "" && $agentId != "0" ) && $mode == "occupancy" ) {
					$getAvail = new Stock($v['ac_accomm_type_ix'],$fromDate['jsDate'],$toDate['jsDate'],false,$agentId);
			} else {
					$getAvail = new Stock($v['ac_accomm_type_ix'],$fromDate['jsDate'],$toDate['jsDate']);
			}
				
			switch($mode) {
			case "availability":
				$accommIds[$k]['availability'] = $getAvail->ToAvailability($showProvs,false,$showOverBookings);
				$accommIds[$k]['allocations'] = $getAvail->ToAllocation();
					
				// We now have all the availability ( including everyone's allocations )
				// Now we simply subtract all allocations from availability.
				foreach ( $accommIds[$k]['availability'] as $avKey => $a ) {
					$accommIds[$k]['availability'][$avKey] -= $accommIds[$k]['allocations'][$avKey];
						
					// Apply the unit limit while we're here --------------	
					if ( $unitLimit != "0" && $accommIds[$k]['availability'][$avKey] > $unitLimit ) {
						$accommIds[$k]['availability'][$avKey] = $unitLimit;							
					}
				}
				break;
			case "occupancy":
				$resStatus = "30";
				if ( $showProvs > 0 ) {
					$resStatus .= ":20";
				}

				if ( $showAllocs ) {
					$resStatus .= ":15";
				}

				$accommIds[$k]['availability'] = $getAvail->ToOccupancy($resStatus);
				$accommIds[$k]['allocations'] = $getAvail->ToAllocation();
					
				if ( $showAlloc ) {
					foreach ( $accommIds[$k]['availability'] as $avKey => $a ) {
						$accommIds[$k]['availability'][$avKey] += $accommIds[$k]['allocations'][$avKey];		
					}						
				}
					
				// Apply the unit limit -----------------------------------
				if ( $unitLimit != "0" && $a  > $unitLimit ) {
					$accommIds[$k]['availability'][$key] = $unitLimit;
				}
				break;
			}
				
			$accommMax = $getAvail->ToAccommMax();
			$accommMin = $getAvail->ToAccommMin();

			if ( $unitLimit != 0 ) {
				if ( $accommMax > $unitLimit ) {
					$accommMax = $unitLimit;
				}
				if ( $accommMin > $unitLimit ) {
					$accommMin = $unitLimit;
				}
			}

			if ( $accommMax != $accommMin ) {
				$accommIds[$k]['units'] = $accommMin . " - " . $accommMax;
			} else {
				$accommIds[$k]['units'] = $accommMax;
			}
				
			if ( $showProvs > 0 ) {
				$accommIds[$k]['provCount'] = $getAvail->ToProvisional();
			}

			if ( $showAlloc && $agentId != "" && $agentId != "0" && $mode == "availability" ) {
				$agentArray = explode(":",$agentId);
				foreach ( $agentArray as $a ) {
					$accommIds[$k]['agentAllocation'] = $getAvail->ToAllocationAgent(true,$a);
					foreach ( $accommIds[$k]['availability'] as $date => $avail ) {
						if ( $accommIds[$k]['agentAllocation'][$a]['total_balance'] || $a == "" ) {
							if ( array_key_exists($date,$accommIds[$k]['agentAllocation'][$a]['total_balance']) ) {
								$accommIds[$k]['availability'][$date] += $accommIds[$k]['agentAllocation'][$a]['total_balance'][$date];
								if ( $accommIds[$k]['availability'][$date] > $accommIds[$k]['units'] ) {
									$accommIds[$k]['availability'][$date] = $accommIds[$k]['units'];
								}
							}
						}

						if ( $unitLimit != "0" && $accommIds[$k]['availability'][$date] > $unitLimit ) {
							$accommIds[$k]['availability'][$date] = $unitLimit;														
						}								
					}
				}
			}
		}
		*/
		$tempAccommCount = array();
		$masterTotals = array();
		foreach ( $accommIds as $k => $v ) {
			switch($mode) {
			case "availability":
				$getAvail = new Stock($v['ac_accomm_type_ix'],$fromDate['jsDate'],$toDate['jsDate']);

				$accommIds[$k]['availability']	= $getAvail->ToAvailability($showProvs,false,$showOverBookings,0);
				$accommIds[$k]['allocations']		= $getAvail->ToAllocation();
				$accommIds[$k]['block']					= $getAvail->ToBlock();
				$accommIds[$k]['roomsForToday'] = $getAvail->ToAccomm();

				$accommMax = $getAvail->ToAccommMax();
				$accommMin = $getAvail->ToAccommMin();

				if ( $unitLimit != "0" ) {
					if ( $accommMax > $unitLimit ) {
						$accommMax = $unitLimit;
					}
					if ( $accommMin > $unitLimit ) {
						$accommMin = $unitLimit;
					}
				}

				if ( $accommMax != $accommMin ) {
					$accommIds[$k]['units'] = $accommMin . " - " . $accommMax;
				} else {
					$accommIds[$k]['units'] = $accommMax;
				}

				if ( $showProvs > 0 ) {
					$accommIds[$k]['provCount'] = $getAvail->ToProvisional();
				}

				// We now have all the availability ( including everyone's allocations )
				// Now we simply subtract all allocations from availability.
				foreach ( $accommIds[$k]['availability'] as $avKey => $a ) {
					$accommIds[$k]['availability'][$avKey] -= $accommIds[$k]['allocations'][$avKey];

					// Apply the unit limit while we're here --------------	
					/*if ( $unitLimit != "0" && $accommIds[$k]['availability'][$avKey] > $unitLimit ) {
						$accommIds[$k]['availability'][$avKey] = $unitLimit;							
					}*/
				}

				if ( $showProvs > 0 ) {
					$accommIds[$k]['provCount'] = $getAvail->ToProvisional();
				}

				if ( $showAlloc && $agentId != "" && $agentId != "0" ) {
					$accommIds[$k]['agentAllocation'] = $getAvail->ToAllocationAgent(true,$agentId);
					foreach ( $accommIds[$k]['availability'] as $date => $avail ) {						
						if ( $accommIds[$k]['agentAllocation'][$agentId]['total_balance'] || $agentId == "" ) {
							if ( array_key_exists($date,$accommIds[$k]['agentAllocation'][$agentId]['total_balance']) ) {
								if (isset($accommIds[$k]['availability'][$date])) {
									$accommIds[$k]['availability'][$date] += $accommIds[$k]['agentAllocation'][$agentId]['total_balance'][$date];
								} else {
									$accommIds[$k]['availability'][$date] = $accommIds[$k]['agentAllocation'][$agentId]['total_balance'][$date];
								}
								if ( $accommIds[$k]['availability'][$date] > $accommIds[$k]['units'] ) {
									$accommIds[$k]['availability'][$date] = $accommIds[$k]['units'];
								}
							}
						}
									
						/*if ( $unitLimit != "0" && $accommIds[$k]['availability'][$date] > $unitLimit ) {
							$accommIds[$k]['availability'][$date] = $unitLimit;														
						}*/
					}
				}
				
				foreach ( $accommIds[$k]['availability'] as $avKey => $a ) {
					// Apply the unit limit while we're here --------------	
					if ( $unitLimit != "0" && $accommIds[$k]['availability'][$avKey] > $unitLimit ) {
						$accommIds[$k]['availability'][$avKey] = $unitLimit;							
					}
				}
			
				break;

			case "occupancy":
				if ( $agentId != "0" && $agentId != "" ) {
					// We have selected to view specific agents, not just all ---------
					$agentArray = explode(":",$agentId);
					$tempAgentAllocation = array();
					foreach ( $agentArray as $ag ) {
						$getAvail = new Stock($v['ac_accomm_type_ix'],$fromDate['jsDate'],$toDate['jsDate'],false,$ag);

						$resStatus = "30";
						if ( $showProvs > 0 ) {
							$resStatus .= ":20";
						}

						$accommIds[$k]['availability']	= $getAvail->ToOccupancy($resStatus);
						$accommIds[$k]['allocations']		= $getAvail->ToAllocation();
						$accommIds[$k]['block']					= $getAvail->ToBlock();
						$accommIds[$k]['roomsForToday'] = $getAvail->ToAccomm();

						$accommMax = $getAvail->ToAccommMax();
						$accommMin = $getAvail->ToAccommMin();

						if ( $unitLimit != "0" ) {
							if ( $accommMax > $unitLimit ) {
								$accommMax = $unitLimit;
							}
							if ( $accommMin > $unitLimit ) {
								$accommMin = $unitLimit;
							}
						}

						if ( $accommMax != $accommMin ) {
							$accommIds[$k]['units'] = $accommMin . " - " . $accommMax;
						} else {
							$accommIds[$k]['units'] = $accommMax;
						}

						if ( $showProvs > 0 ) {
							$accommIds[$k]['provCount'] = $getAvail->ToProvisional();
						}

						if ( $showAlloc ) {
							$tempAgentAllocation = $getAvail->ToAllocationAgent(true,$ag);
							$accommIds[$k]['agentAllocation'][$ag] = $tempAgentAllocation[$ag];

							foreach ( $accommIds[$k]['availability'] as $date => $avail ) {
								if ( $accommIds[$k]['agentAllocation'][$ag]['total_balance'] || $ag == "" ) {
									if ( array_key_exists($date,$accommIds[$k]['agentAllocation'][$ag]['total_balance']) ) {
										if (isset($tempAccommCount[$k][$date])) {
											$tempAccommCount[$k][$date] += $accommIds[$k]['agentAllocation'][$ag]['total_balance'][$date];
										} else {
											$tempAccommCount[$k][$date] = $accommIds[$k]['agentAllocation'][$ag]['total_balance'][$date];
										}

										if ( $accommIds[$k]['availability'][$date] > $accommIds[$k]['units'] ) {
											$accommIds[$k]['availability'][$date] = $accommIds[$k]['units'];
										}
									}
								}

								if ( $unitLimit != "0" && $accommIds[$k]['availability'][$date] > $unitLimit ) {
									$accommIds[$k]['availability'][$date] = $unitLimit;														
								}
							}
						}

							// Add totals to master array, then back into individual array (to "add up" all agents)
							if (isset($accommIds[$k]['availability'])) {
								foreach ($accommIds[$k]['availability'] as $date => $value) {
									if (!isset($masterTotals[$k])) { $masterTotals[$k] = array(); }
									if (!isset($masterTotals[$k]['availability'])) { $masterTotals[$k]['availability'] = array(); }
									if (!isset($masterTotals[$k]['availability'][$date])) { $masterTotals[$k]['availability'][$date] = 0; }
									$masterTotals[$k]['availability'][$date] += $value;
								}
							}

							foreach ($masterTotals[$k]['availability'] as $date => $value) {
								if (!isset($accommIds[$k])) { $accommIds[$k] = array(); }
								if (!isset($accommIds[$k]['availability'])) { $accommIds[$k]['availability'] = array(); }
								if (!isset($accommIds[$k]['availability'][$date])) { $accommIds[$k]['availability'][$date] = 0; }
								$accommIds[$k]['availability'][$date] = $value;
							}
					}

					// Having built up an array of the total number of allocations per 
					// accomm type per day, we now need to add them to the occupancy 
					// count
					foreach ( $accommIds[$k]['availability'] as $date => $avail ) {
						if ( $tempAccommCount && $tempAccommCount[$k] ) {
							if ( array_key_exists($date,$tempAccommCount[$k]) ) {
								if (isset($accommIds[$k]['availability'][$date])) {
									$accommIds[$k]['availability'][$date] += $tempAccommCount[$k][$date];
								} else {
									$accommIds[$k]['availability'][$date] = $tempAccommCount[$k][$date];
								}
							}
						}
					}
				} else {
					$getAvail = new Stock($v['ac_accomm_type_ix'],$fromDate['jsDate'],$toDate['jsDate'],false,$agentId);
					
					$resStatus = "30";
					if ( $showProvs > 0 ) {
						$resStatus .= ":20";
					}

					$accommIds[$k]['availability']	= $getAvail->ToOccupancy($resStatus);
					$accommIds[$k]['allocations']		= $getAvail->ToAllocation();
					$accommIds[$k]['block']					= $getAvail->ToBlock();
					$accommIds[$k]['roomsForToday'] = $getAvail->ToAccomm();

					$accommMax = $getAvail->ToAccommMax();
					$accommMin = $getAvail->ToAccommMin();

					if ( $unitLimit != "0" ) {
						if ( $accommMax > $unitLimit ) {
							$accommMax = $unitLimit;
						}
						if ( $accommMin > $unitLimit ) {
							$accommMin = $unitLimit;
						}
					}

					if ( $accommMax != $accommMin ) {
						$accommIds[$k]['units'] = $accommMin . " - " . $accommMax;
					} else {
						$accommIds[$k]['units'] = $accommMax;
					}

					if ( $showProvs > 0 ) {
						$accommIds[$k]['provCount'] = $getAvail->ToProvisional();
					}

					if ( $showAlloc ) {
						foreach ( $accommIds[$k]['availability'] as $date => $avail ) {
							if(isset($accommIds[$k]['availability'][$date])) {
								$accommIds[$k]['availability'][$date] += $accommIds[$k]['allocations'][$date];
							} else {
								$accommIds[$k]['availability'][$date] = $accommIds[$k]['allocations'][$date];
							}

							if ( $unitLimit != "0" && $accommIds[$k]['availability'][$date] > $unitLimit ) {
								$accommIds[$k]['availability'][$date] = $unitLimit;														
							}
						}
					}
				}
				break;
			}
		}	
			
		// Year & Month Row : START -----------------------------------------------
		$yearMonthArray = array('','');

		if($showUnits == 'true') {
			array_push($yearMonthArray,'');
		}

		foreach($accommIds[0]['availability'] as $k => $v) {
			$dateArr 	= explode("-",$k);
			$Month 		= date("M",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));
			$Year 		= date("Y",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));

			$yearMonth = $Month . " " . $Year;
			array_push($yearMonthArray,$yearMonth);
		}
		array_push($csvFile,$yearMonthArray);
		// Year & Month Row : END   -------------------------------------------------

		// Day Letter Row : START ---------------------------------------------------
		$dayRowArray = array('','');

		if($showUnits == 'true') {
			array_push($dayRowArray,'');
		}

		foreach($accommIds[0]['availability'] as $k => $v) {
			$dateArr = explode("-",$k);
			$dayOfWeek = date("w",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));
			$dayLetter = substr(date("D",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0])),0,1);

			array_push($dayRowArray,$dayLetter);
		}
		array_push($csvFile,$dayRowArray);
		// Day Letter Row : END -----------------------------------------------------

		// Day Number Row : START ---------------------------------------------------
		$dayNumberRowArray = array('','');

		if($showUnits == 'true') {
			array_push($dayNumberRowArray,'Units');
		}

		foreach($accommIds[0]['availability'] as $k => $v) {
			$dateArr = explode("-",$k);
			$dayOfWeek = date("w",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));
			$dayNumber = date("j",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));

			array_push($dayNumberRowArray,$dayNumber);
		}
		array_push($csvFile,$dayNumberRowArray);
		// Day Number Row : END -----------------------------------------------------

		// Main Content : START -----------------------------------------------------
		for ( $i = 0; $i < count($accommIds); $i++ ) {
			$currRowArray = array($accommIds[$i]['propertyName'],$accommIds[$i]['accommType']);
			if($showUnits == 'true') {
				array_push($currRowArray,$accommIds[$i]['units']);
			}

			foreach($accommIds[$i]['availability'] as $k => $v) {
				if($showProvs > 0) {
					if($accommIds[$i]['provCount'][$k] > 0) {
						$v .= "*";
					}
				}
				if($jobId == 262 && $hideUnits) {
					if($v > 0) {
						$v = "";
					} else {
						$v = "X";
					}
				}

				array_push($currRowArray,$v);
			}
			array_push($csvFile,$currRowArray);
		}

		if($jobId == 262 && $hideUnits) {
			array_push($csvFile,array());
			array_push($csvFile,array("X indicates no availability"));
		}
		// Main Content : END -------------------------------------------------------

		$csvText = "";

		foreach($csvFile as $csvLine) {
			$first = true;

			foreach($csvLine as $csvItem) {
				if(!$first) {
					$csvText .= ",";
				} else {
					$first = false;
				}
				$csvText .= "\"".str_replace("\"","\"\"",$csvItem)."\"";
			}
			$csvText .= "\n";
		}

		if(headers_sent()) {
			// echo('Some data has already been output to browser, can\'t send PDF file');
		}

		header('Content-Type: text/csv');
		header("Cache-control: private");
		header('Content-Length: '.strlen($csvText));
		header("Content-Disposition: inline; filename=" . str_replace(" ","_",strtolower($jobName . "_".$fromDate['htmlDate']." to ".$toDate['htmlDate'].".csv")));
		echo $csvText;

		flush();
		die();
	}
	/* CSV REPORT : END ------------------------------------------------------ */
}

// Related Functions : START --------------------------------------------------
function getPersonaFax($personaId) {
	global $lDB;
   $fax = $lDB->get("
      SELECT
         pr_phone.pr_phone_number
      FROM
         pr_phone, rf_phone_type
      WHERE
         pr_phone.pr_persona_id = '$personaId'
         AND pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
         AND rf_phone_type.rf_phone_type_sys_code = '1'",4);
   if(trim($fax) == "" || $fax == "0") {
      $fax = "";
   }
   return $fax;
}

function getPersonaTelephone($personaId) {
	global $lDB;
   $tel = $lDB->get("
      SELECT
         pr_phone.pr_phone_number
      FROM
         pr_phone
      WHERE
         pr_phone.pr_persona_id = '$personaId'
         AND pr_phone.pr_default_yn = '1'",4);
   if(trim($tel) == "" || $tel == "0") {
      $tel = "";
   }
   return $tel;
}

function getPersonaDetail($personaId) {
	global $lDB;
   $detail = $lDB->get("
      SELECT
         pr_persona.pr_name_first,
         pr_persona.pr_name_second,
         pr_persona.pr_name_last,
         pr_persona.pr_email
      FROM
         pr_persona
      WHERE
         pr_persona.pr_persona_ix = '" . $personaId . "'",2);

	 $detail = $detail[0];
	 $name = "";

	 if(trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
      $name .= $detail['pr_name_first'] . " ";
   }

	 if(trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
      $name .= $detail['pr_name_second'] . " ";
   }

	 if(trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
      $name .= $detail['pr_name_last'] . " ";
   }

	 $result = array();
   $result['name'] = trim($name);
   $result['fax'] = getPersonaFax($personaId);
   $result['telephone'] = getPersonaTelephone($personaId);
   $result['email'] = $detail['pr_email'];

	 if(trim($result['email']) == "" || $result['email'] == "0") {
      $result['email'] = "";
   }
   return $result;
}

function buildMonthYearHeader($dates) {
	$datesCount = count($dates);
	$cMonth = "";
	$count = 0;
	$monthArray = array();

	for($i = 0; $i < $datesCount; $i++) {
		$dateArr 		= explode("-",$dates[$i]);
		$thisMonth 	= date("M",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0])); 
		$thisYear 	= date("Y",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));

		if($cMonth != $thisMonth) {
			$monthArray[$count]['monthyear'] = $thisMonth . " " . $thisYear;
			$cMonth = $thisMonth;
			$totalSpan = $i;
			$count++;					
		}
		$monthArray[$count-1]['span'] = ($i+1) - $totalSpan;
	}
	return $monthArray;
}
// Related Functions : END ----------------------------------------------------

$GLOBALS['temp']['SAServer'] = $GLOBALS['SAServer'];
$GLOBALS['temp']['USServer'] = $GLOBALS['USServer'];
$GLOBALS['temp']['EUServer'] = $GLOBALS['EUServer'];

// Print Header Setup
$GLOBALS['temp']['genDate'] 						= chng_date(date("Y-m-d"),"-")." ".date("H:i:s");
$GLOBALS['temp']['printEnv'] 						= $GLOBALS['dbcode'];
$GLOBALS['temp']['printUser'] 					= $GLOBALS['firstname'] . " " . $GLOBALS['lastname'];
$GLOBALS['temp']['printServer'] 				= $GLOBALS['domain'];
$GLOBALS['temp']['accommodationNames'] 	= $accommFilter['names'];
$GLOBALS['temp']['printPage'] 					= $page;
