<?php

require_once(__DIR__ . "/functions.report.php");
require_once(__DIR__ . "/functions.persona.php");
require_once(__DIR__ . "/functions.mail.php");
require_once(__DIR__ . "/functions.property.php");	
require_once(__DIR__ . '/functions.profile.php');

$profileFields = array(
	/*  1 */ "fromDate",
	/*  2 */ "toDate",
	/*  3 */ "toDatePlus",
	/*  4 */ "dateType",
	/*  5 */ "propertiesIds", // This has been removed but will be kept here for backwards compatibility
	/*  6 */ "accommIds",
	/*  7 */ "renderOption",
	/*  8 */ "filterStatus",
	/*  9 */ "showHideButtonText",
	/*  10 */ "currentPage",
	/*  11 */ "checkShowUnits",
	/*  12 */ "checkPageBreaks",
	/*  13 */ "checkShowParameters",
	/*  14 */ "allocatedRoomsFilter",
	/*  15 */ "allocationDetailLevelFilter",
	/*  16 */ "allocationIncludeExpired",
	/*  17 */ "agentAllocIds",
	/*  18 */ "allocationIds",
	/*  19 */ "",
	/*  20 */ "showTotals",
	/*  21 */ "allocationGroupByFilter",
);

function calculateAllocations($accommIds,$startDate,$endDate,$agentFilter,$showExpiredAllocations,$detailLevel,$allocRooms,$agentIdArray,$allocationIds,$removeEmptyResults=true) {
	$first = true;
	$dayList = null;
	$materialisation = ($allocRooms == 3);
	foreach($accommIds as $k=>$v) {
		$allocations = new Stock($v['ac_accomm_type_ix'],$startDate,$endDate,false,$agentFilter,$showExpiredAllocations,false,false,$allocationIds);
		$allocationDays = $allocations->ToAllocation("", $materialisation);
		if (count(array_unique(array_values($allocationDays))) === 1 && $removeEmptyResults) {
			unset($accommIds[$k]);
		} else {
			$accommIds[$k]['allocation'] = $allocationDays;

			$tempArray = array();
			foreach($agentIdArray as $agentId) {
				if($detailLevel == 2) {
					$tempArray = $tempArray + $allocations->ToAllocationAgent(false,$agentId,$materialisation);
				} else {
					$tempArray = $tempArray + $allocations->ToAllocationAgent(true,$agentId,$materialisation);
				}
			}
			$accommIds[$k]['agentAllocation'] = $tempArray;
					
			$accommMax = $allocations->ToAccommMax();
			$accommMin = $allocations->ToAccommMin();

			if($accommMax != $accommMin) {
				$accommIds[$k]['units'] = $accommMin . " - " . $accommMax;
			} else {
				$accommIds[$k]['units'] = $accommMax;
			}

			if($first) {
				// A list of all the days used. Might be handy ----------------------------
				$dayList = $allocations->ToDate();
			}
			$first = false;
		}
	}

	return array($accommIds, $dayList);
}

function getMaterialisationDescription($label) {
	switch ($label) {
		case "allocation":
			return "Allocated";
			break;
		case "total":
			return "Allocated";
			break;
		case "allocation_used":
			return "Used";
			break;
		case "total_used":
			return "Used";
			break;
		case "allocation_balance":
			return "Not used";
			break;
		case "total_balance":
			return "Not used";
			break;
		case "allocation_materialisation":
			return "Materialisation (%)";
			break;
		case "materialisation":
			return "Materialisation (%)";
			break;
		default:
			return $label;
			break;
	}
}

function getMaterialisationTotalDescription($label) {
	switch ($label) {
		case "allocation":
			return "sum_total";
			break;
		case "total":
			return "sum_total";
			break;
		case "total_used":
			return "sum_used";
			break;
		case "total_balance":
			return "sum_balance";
			break;
		case "materialisation":
			return "average_materialisation";
			break;
		default:
			return $label;
			break;
	}
}

function getMaterialisationAmount($description, $descriptionCompare, $totalAmount, $usedValue, $totalValue) {
    $materialisation = 0;
    if ($description != $descriptionCompare) {
        $materialisation = $totalAmount;
    } else {
        $materialisation = $usedValue == 0 || $totalValue == 0 ? 0 : round(($usedValue/$totalValue)*100, 0, PHP_ROUND_HALF_UP);
    }
    return $materialisation;
}

function generateTotalsFooter($dayTotals, $renderMode, $parameters = array(), $settings = array()) {
	if ($renderMode == "html") {
		$footer = "";
		$footer = "<tfoot>";
		$footer .= "<tr>";
		$footer .= "<td style=\"background-color: #FFFFFF;\">&nbsp;</td>\n";
		$footer .= "<td style=\"background-color: #FFFFFF; border-right: 1px; border-color: #000000;\"><strong>Total</strong></td>\n";
		$footer .= "<td style=\"background-color: #FFFFFF;\">&nbsp;</td>\n";
		$footer .= "<td style=\"background-color: #FFFFFF;\">&nbsp;</td>\n";
		foreach ($dayTotals as $day => $total) {
			$footer .= "<td align=\"center\" class=\"noBottomLeft\">" . $total . "</td>\n";
		}
		$footer .= "</tr>\n";
		$footer .= "</tfoot>\n";
		return $footer;
	} elseif ($renderMode == "pdf") {
		$row = array();
		array_push($row,array('width' => $settings['accommCellWidth'] . "%", 'data' => "Total", 'border' => 'LRTB', 'align' => 'R'));
		if ( isset($parameters['showUnits']) && $parameters['showUnits'] == true ) {
			array_push($row,array('width' => "5%", 'data' => " ", 'border' => 'LRTB', 'align' => 'C'));
		}
		if ( isset($parameters['showTotals']) && $parameters['showTotals'] == true ) {
			array_push($row,array('width' => "5%", 'data' => " ", 'border' => 'LRTB', 'align' => 'C'));
		}
		foreach ($dayTotals as $day => $total) {
			array_push($row,array('width' => $settings['pdfDayCellWidth']."%", 'data' => $total, 'border' => 'LRTB', 'align' => 'C'));
		}
		return $row;
	} elseif ($renderMode == "csv") {
		$row = array();
		array_push($row,"");
		array_push($row,"Total");
		if ( isset($parameters['showUnits']) && $parameters['showUnits'] == true ) {
			array_push($row," ");
		}
		if ( isset($parameters['showTotals']) && $parameters['showTotals'] == true ) {
			array_push($row," ");
		}
		foreach ($dayTotals as $day => $total) {
			array_push($row, $total);
		}
		return $row;
	}
}

function buildMonthYearHeader($dates) {
	$datesCount = count($dates);
	$cMonth = "";
	$count = 0;
	$monthArray = array();
			
	for($i = 0; $i < $datesCount; $i++) {
		$dateArr 		= explode("-",$dates[$i]);
		$thisMonth 	= date("M",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0])); 
		$thisYear 	= date("Y",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));

		if($cMonth != $thisMonth) {
			$monthArray[$count]['monthyear'] = $thisMonth . " " . $thisYear;
			$cMonth = $thisMonth;
			$totalSpan = $i;
			$count++;					
		}
		$monthArray[$count-1]['span'] = ($i+1) - $totalSpan;
	}
	return $monthArray;
}

function blockStyle($k) {
	if($k == 0) {
		$s = "style=\"border-left: 1px solid #630;\"";	
	} else {
		$s = "";
	}
	return $s;
}

function addEmptyDayColumns($days,$class,$style) {
	$html = "";
	foreach ( $days as $dayKey => $day ) {
		$html .= "<td class=\"".$class."\" style=\"".$style."\">&nbsp;</td>";
	}
	return $html;
}

function getPersonaFax($personaId) {
	global $lDB;
	$fax = $lDB->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone,
			rf_phone_type
		WHERE
			pr_phone.pr_persona_id = '" . $personaId . "'
		AND 
			pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
		AND 
			rf_phone_type.rf_phone_type_sys_code = '1'
	",4);

	if ( trim($fax) == "" || $fax == "0" ) {
		$fax = "";
	}
	return $fax;
}

function getPersonaTelephone($personaId) {
	global $lDB;
	$tel = $lDB->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
		WHERE
			pr_phone.pr_persona_id = '" . $personaId . "'
		AND 
			pr_phone.pr_default_yn = '1'
	",4);

	if ( trim($tel) == "" || $tel == "0" ) {
		$tel = "";
	}
	return $tel;
}

function getPersonaDetail($personaId) {
	global $lDB;
	$detail = $lDB->get("
		SELECT
			pr_persona.pr_name_first,
			pr_persona.pr_name_second,
			pr_persona.pr_name_last,
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '" . $personaId . "'
	",2);

	$detail = $detail[0];
	$name = "";

	if ( trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0" ) {
		$name .= $detail['pr_name_first'] . " ";
	}

	if ( trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0" ) {
		$name .= $detail['pr_name_second'] . " ";
	}

	if ( trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0" ) {
		$name .= $detail['pr_name_last'] . " ";
	}

	$result = array();
	$result['name']				= trim($name);
	$result['fax']				= getPersonaFax($personaId);
	$result['telephone']	= getPersonaTelephone($personaId);
	$result['email']			= $detail['pr_email'];

	if ( trim($result['email']) == "" || $result['email'] == "0" ) {
		$result['email'] = "";
	}
	return $result;
}

function generateTotals(&$accommodations) {
	foreach ($accommodations as $key => $accommodation) {
		$accommodations[$key]['sum_total'] = 0;
		$accommodations[$key]['sum_used'] = 0;
		$accommodations[$key]['sum_balance'] = 0;
		if (!empty($accommodation['agentAllocation'])) {
			foreach ($accommodation['agentAllocation'] as $agentId => $agent) {
				$totalAgent = 0;
				$sumTotalAgent = array_sum($agent['total']);
				$sumTotalUsedAgent = array_sum($agent['total_used']);
				$sumTotalBalanceAgent = array_sum($agent['total_balance']);
				if (!empty($agent['allocation'])) {
					foreach ($agent['allocation'] as $allocationId => $allocation) {
						$sumOccupancy = array_sum($allocation['occupancy']);
						$totalAgent += $sumOccupancy;
						$accommodations[$key]['agentAllocation'][$agentId]['allocation'][$allocationId]['sum_total'] = $sumOccupancy; 
					}
				}
				if (!empty($agent['allocation_used'])) {
					foreach ($agent['allocation_used'] as $allocationId => $allocation) {
						if (isset($allocation['occupancy'])) {
							$sumOccupancy = array_sum($allocation['occupancy']);
							$accommodations[$key]['agentAllocation'][$agentId]['allocation_used'][$allocationId]['sum_total'] = $sumOccupancy; 
						}
					}
				}
				if (!empty($agent['allocation_balance'])) {
					foreach ($agent['allocation_balance'] as $allocationId => $allocation) {
						if (isset($allocation['occupancy'])) {
							$sumOccupancy = array_sum($allocation['occupancy']);
							$accommodations[$key]['agentAllocation'][$agentId]['allocation_balance'][$allocationId]['sum_total'] = $sumOccupancy; 
						}
					}
				}

				$accommodations[$key]['agentAllocation'][$agentId]['sum_total'] = $sumTotalAgent; 
				$accommodations[$key]['sum_total'] += $sumTotalAgent;
				$accommodations[$key]['agentAllocation'][$agentId]['sum_used'] = $sumTotalUsedAgent; 
				$accommodations[$key]['sum_used'] += $sumTotalUsedAgent;
				$accommodations[$key]['agentAllocation'][$agentId]['sum_balance'] = $sumTotalBalanceAgent; 
				$accommodations[$key]['sum_balance'] += $sumTotalBalanceAgent;
				$average_materialisation = isset($agent['materialisation']) ? round(array_sum($agent['materialisation'])/count($agent['materialisation']), 0, PHP_ROUND_HALF_UP) : 0;
				$accommodations[$key]['agentAllocation'][$agentId]['average_materialisation'] = $average_materialisation; 
				$accommodations[$key]['agentAllocation'][$agentId]['day_count'] = count($agent['total']); 
			}
		} else {
			$accommodations[$key]['sum_total'] = array_sum($accommodation['allocation']);
			$accommodations[$key]['sum_used'] = 0;
			$accommodations[$key]['sum_balance'] = 0;
		}
	}
}

function dateStyle($date) {
	$style = "";
	$day = date('d', strtotime($date));
	if ($day == "1") {
		$style = " bl ";
	}
	return $style;
}
