<?php
/**
 * init.form341.php - Allocation Summary Report
 * Job: 265
 * Function: 98
*/

if ( isset($_POST['url']) && $_POST['url'] != "" ) {
	$_SERVER['argv']				= explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc']				= sizeof($_SERVER['argv']);
	$GLOBALS['temp']['url']	= $_POST['url'];
}

$sc_group_id = $GLOBALS['sc_group_id'];
$pf_object_id = db_pf_object_by_name("allocation_summary_report");
processProfileAction($pf_object_id,$profileFields);

$pf_option_id = applyProfile($pf_object_id,$profileFields);
$title = db_pf_option_get_title($pf_option_id);
if(trim($title) == "") {
	$title = "Allocation Summary Report";
}
$GLOBALS['temp']['title'] = $title;

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id, $pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = t_encodeHTMLField(createProfileName($pf_option_id));
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();

// Form setup
if ( !isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_allocation_summary.htm");
}

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));

$_SERVER['argv'] = array_pad($_SERVER['argv'],22,"");
$jobId 							= $_SERVER['argv'][0];
$fromDateArgv 					= $_SERVER['argv'][1];
$toDateArgv 					= $_SERVER['argv'][2];
$toDatePlusArgv 				= $_SERVER['argv'][3];
$urlDateType 					= $_SERVER['argv'][4];
$propertyFilterArgv 			= $_SERVER['argv'][5]; // This has been removed but will be kept here for backwards compatibility
$accommFilterArgv 				= $_SERVER['argv'][6];
$options 						= $_SERVER['argv'][7];
$filterStatus 					= $_SERVER['argv'][8];
$showHideButtonText 			= $_SERVER['argv'][9];
$showUnits 						= $_SERVER['argv'][10];
$page 							= $_SERVER['argv'][11];
$pageBreaksArgv 				= $_SERVER['argv'][12];
$showParametersArgv 			= $_SERVER['argv'][13];
$allocRooms 					= $_SERVER['argv'][14];
$detailLevel					= $_SERVER['argv'][15];
$showExpiredAllocationsArgv 	= $_SERVER['argv'][16];
$agentFilterArgv 				= $_SERVER['argv'][17];
$allocationFilterArgv 			= $_SERVER['argv'][18];
$showTotals						= $_SERVER['argv'][20];
$groupBy 						= $_SERVER['argv'][21];

$hideColumns = array();

require_once(__DIR__ . "/class.stock.php");

if ( $toDatePlusArgv == "" ) {
	$GLOBALS['temp']['toDatePlus'] = "34";
} else {
	if ( $urlDateType == "dateRange" ) {
		$GLOBALS['temp']['toDatePlus'] = "";
	} else {
		$GLOBALS['temp']['toDatePlus'] = $toDatePlusArgv;
	}
}

if ( $urlDateType == "" ) {
	$GLOBALS['temp']['dateType'] = "<input type=\"hidden\" id=\"dateType\" name=\"dateType\" value=\"datePlus\" />\n";
} else {
	if ( $urlDateType == "fromCal" ) {
		$urlDateType = "dateRange";
	}
	$GLOBALS['temp']['dateType'] = "<input type=\"hidden\" id=\"dateType\" name=\"dateType\" value=\"" . $urlDateType . "\" />\n";
}


$jobName = "";

$GLOBALS['temp']['jobId'] = "<input type=\"hidden\" id=\"jobId\" name=\"jobId\" value=\"" . $jobId . "\" />\n";

$jobName = "Allocation Summary";

$GLOBALS['temp']['reportLabel']		= "Allocation Summary Report";
$GLOBALS['temp']['reportInfo']		= $GLOBALS['info_dir']."info_rep_allocation_summary.htm";

$GLOBALS['temp']['today']						= chng_date(date("Y-m-d"),"-");
$GLOBALS['temp']['unitFilter']			= "colLt";
$GLOBALS['temp']['hideButts']				= "collapse printCollapse";

// Prop / accomm filter
$accommIds = !empty($accommFilterArgv) ? explode(":", $accommFilterArgv) : array();
$accommNames = array();
$propertyIds = array();
$propertyNames = array();
if (count($accommIds)) {
	$propertyIds = $lDB->get("
		SELECT DISTINCT
			ac_accomm_type.pr_business_id
		FROM
			ac_accomm_type
		WHERE
			ac_accomm_type.ac_accomm_type_ix IN ('".implode("','", $accommIds)."')
	",3);
	$propertyNames = $lDB->get("
		SELECT DISTINCT
			pr_persona.pr_name_last
		FROM
			pr_business
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
		WHERE
			pr_business.pr_business_id IN ('".implode("','", $propertyIds)."')
	",3);
	$accommNames = $lDB->get("
		SELECT DISTINCT
			ac_accomm_type.ac_accomm_desc
		FROM
			ac_accomm_type
		WHERE
			ac_accomm_type.ac_accomm_type_ix IN ('".implode("','", $accommIds)."')
	",3);
}
$accommDetailsWhere = "";
if (count($accommIds) > 0) {
	$accommDetailsWhere = " AND ac_accomm_type.ac_accomm_type_ix IN ('".implode("','", $accommIds)."')";
}
$accommDetails = $lDB -> get("
	SELECT
		ac_accomm_type.ac_accomm_type_ix,
		ac_accomm_type.ac_accomm_desc AS accommType,
		pr_persona.pr_name_last AS propertyName
	FROM
		ac_accomm_type
		INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
		INNER JOIN sc_accomm ON sc_accomm.ac_accomm_type_id  = ac_accomm_type.ac_accomm_type_ix
	WHERE
		sc_accomm.sc_group_id='$sc_group_id'
		AND ac_accomm_type.ac_accomm_type_inactive_yn = '0'
		AND pr_business.pr_bus_inactive_yn = '0'
		$accommDetailsWhere
	ORDER BY
		ac_accomm_type.pr_business_id,
		ac_accomm_type.ac_accomm_sequence
",2);
$GLOBALS['temp']['accommNames'] = count($accommNames) == 0 ? "All" : implode(', ', $accommNames);
$GLOBALS['temp']['accommIds'] = $accommFilterArgv;
$GLOBALS['temp']['propertyIds'] = implode(":",$propertyIds);

// Allocations filter
$allocationFilter = useFilter("allocation",$allocationFilterArgv,"SELECT rv_reservation.rv_reservation_ix AS id, IF ( bl_block.bl_block_abbrev = '' OR bl_block.bl_block_abbrev IS NULL, rv_reservation.rv_res_name, CONCAT('Block (', bl_block.bl_block_abbrev, '): ', rv_reservation.rv_res_name)) AS namelast FROM rv_reservation LEFT JOIN bl_block_period ON bl_block_period.bl_block_period_ix = rv_reservation.bl_block_period_id LEFT JOIN bl_block ON bl_block.bl_block_ix = bl_block_period.bl_block_id WHERE rv_reservation_ix =","rv_reservation.rv_reservation_ix",false,"All",0);
$allocationList = $allocationFilter['ids'] == "All" ? "" : $allocationFilter['ids'];

// Allocation Rooms Filter ----------------------------------------------------
$GLOBALS['temp']['allocatedRoomsFilter'] = $allocRooms;

// Allocation Group By --------------------------------------------------------
$GLOBALS['temp']['allocationGroupBy'] = $groupBy;

// Detail Level --------------------------------------------------------
$GLOBALS['temp']['allocationDetailLevel'] = $detailLevel;

// Include Expired Allocations ------------------------------------------------
$GLOBALS['temp']['chkAllocationIncludeExpired'] = "";
if ( $showExpiredAllocationsArgv == "true" ) {
	$GLOBALS['temp']['chkAllocationIncludeExpired'] = "checked=\"checked\"";
	$showExpiredAllocations = true;
} else {
	$GLOBALS['temp']['chkAllocationIncludeExpired'] = "";
	$showExpiredAllocations = false;
}

// Show/Hide Units ------------------------------------------------------------
if ( $showUnits == "true" ) {
	$showUnits = true;
	$GLOBALS['temp']['showUnits'] = "checked";
} else {
	$showUnits = false;
	$GLOBALS['temp']['showUnits'] = "";
	$hideColumns[] = 2;
}

// Show/Hide totals ------------------------------------------------------------
if ( $showTotals == "true" ) {
	$showTotals = true;
	$GLOBALS['temp']['showTotals'] = "checked";
} else {
	$showTotals = false;
	$GLOBALS['temp']['showTotals'] = "";
	$hideColumns[] = 3;
}

// Page Breaks ----------------------------------------------------------------
if ( $pageBreaksArgv == "" || $pageBreaksArgv == 'true' ) {
	$GLOBALS['temp']['pageBreaks'] = "checked";
	$pageBreaks = true;
} else {
	$GLOBALS['temp']['pageBreaks'] = "";
	$pageBreaks = false;
}

// Show/Hide Report Parameters ------------------------------------------------
if ( $showParametersArgv == 'true' ) {
	$GLOBALS['temp']['showParameters'] = "checked";
	$showParameters = 1;
} else {
	$GLOBALS['temp']['showParameters'] = "";
	$showParameters = 0;
}

$GLOBALS['temp']['page'] = "<input type=\"hidden\" id=\"currentPage\" name=\"currentPage\" value=\"" . $page . "\" />\n";

// [START] BUG #5484 : Reports to hide filters by default ---------------------

$GLOBALS['temp']['filterStatus']				= urldecode($filterStatus);
$GLOBALS['temp']['showHideButtonText']	= $showHideButtonText;
$GLOBALS['temp']['showReport']					= "collapse printCollapse";

// Default to datePlus selected -----------------------------------------------
$GLOBALS['temp']['radio1'] = "checked";
$GLOBALS['temp']['radio2'] = "";

if ( $filterStatus == "" ) {
	$GLOBALS['temp']['filterStatus'] = "";
}

if ( $showHideButtonText == "" ) {
	$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
}

if ( $_SERVER['argc'] > 1 && $urlDateType != "fromCal" ) {
	if ( $filterStatus == "" ) {
		$GLOBALS['temp']['filterStatus']				= "collapse printCollapse";
		$GLOBALS['temp']['showHideButtonText']	= ">> Show Filters";
	}
	$GLOBALS['temp']['showReport'] = "";
}
// [ END ] BUG #5484 ----------------------------------------------------------

// Set up the dates -----------------------------------------------------------
switch ( $urlDateType ) {
	case "datePlus":
		if ( $toDateArgv == "" ) {
			$toDateArgv = "34";
		}
		$fromDate	= useDate("from","");
		$toDate		= useDate("to",date("Y-m-d",mktime(0,0,0,date("m"),date("d")+$toDatePlusArgv,date("Y"))));

		$GLOBALS['temp']['radio1'] = "checked";
		$GLOBALS['temp']['radio2'] = "";
		break;

	case "fromCal":
		$arrayDate	= explode("-",$fromDateArgv);
		$fromDate		= useDate("from",$fromDateArgv);
		$toDate			= useDate("to",date("Y-m-d",mktime(0,0,0,$arrayDate[1],$arrayDate[2]+$toDatePlusArgv,$arrayDate[0])));

		$GLOBALS['temp']['radio1'] = "";
		$GLOBALS['temp']['radio2'] = "checked";
		break;

	case "dateRange":
		$fromDate	= useDate("from",$fromDateArgv);
		$toDate		= useDate("to", $toDateArgv);

		$GLOBALS['temp']['radio1'] = "";
		$GLOBALS['temp']['radio2'] = "checked";
		break;

	default:
		$fromDate	= useDate("from",$fromDateArgv);
		$toDate		= useDate("to", $toDateArgv);

		$GLOBALS['temp']['radio1'] = "checked";
		$GLOBALS['temp']['radio2'] = "";
		break;
}

// Limit the number of units shown --------------------------------------------
switch($GLOBALS['userStatusId']) {
	case 0:
	case 1:
		// Hide the Unit Limit input field ------------------------------------------
		$GLOBALS['temp']['showHideLimitUnits'] = "collapse printCollapse";

		if ( $GLOBALS['sc_grp_avail_limit_yn'] > 0 ) {
			$unitLimit = $GLOBALS['sc_grp_avail_limit'];
		} else {
			$unitLimit = 0;
		}
		// The user IS NOT allowed to see overbookings ------------------------------
		$showOverBookings = 0;
		break;

	default:
		// Show the Unit Limit input field ------------------------------------------
		$GLOBALS['temp']['showHideLimitUnits'] = "";
		// The user IS allowed to see overbookings ----------------------------------
		$showOverBookings = 1;

		if ( $GLOBALS['sc_grp_avail_limit_yn'] > 0 ) {
			if ( $GLOBALS['sc_grp_avail_limit'] > 0 ) {
				$GLOBALS['temp']['txtLimitUnits'] = $GLOBALS['sc_grp_avail_limit'];
				$unitLimit = $GLOBALS['sc_grp_avail_limit'];
			} else {
				$GLOBALS['temp']['txtLimitUnits'] = "";
				$unitLimit = 0;
			}
		} else {
			$GLOBALS['temp']['txtLimitUnits'] = "";
			$unitLimit = 0;
		}
		break;
}

// Access Control for Agent filter --------------------------------------------
$agentACL = false;

if ( $userStatusId < 2 ) {
	$agentACL = array($calAgentId);
}

$agentFilter = useFilter("agentAlloc",$agentFilterArgv,"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_agent_id",$agentACL,"All",0);

$agentIdArray = explode(":",$agentFilter['ids']);

// Set up the "Previous Report" $_SESSION variable ----------------------------
if ( $_SERVER['argc'] > 1 ) {
	setLastReport("reservation.php?" . join("+",$_SERVER['argv']));
}

// Renderoption (HTML, PDF, CSV etc.) -----------------------------------------

switch($options & 7) {
	case REP_VIEW_HTML:
		$renderMode = "html";
		$renderType = "";
		break;
	case REP_VIEW_PDF:
		$renderMode = "pdf";
		$renderType = "view";
		break;
	case REP_EMAIL_PDF:
		$renderMode = "pdf";
		$renderType = "email";
		break;
	case REP_SEND_PDF:
		$renderMode = "pdf";
		$renderType = "send";
		break;
	case REP_VIEW_CSV:
		$renderMode = "csv";
		$renderType = "";
		break;
}

if ( $renderMode == "pdf" && $renderType == "email" ) {
	$pdfName = $jobName . " Report - " . $fromDate['htmlDate'] . " to " . $toDate['htmlDate'];

	$attachmentTable = "
		<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" summary=\"\">\n
			<tr>\n
				<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\" alt=\"\" /></td>\n
				<td id=\"attachmentLabel\" width=\"100%\">" . $pdfName . ".pdf</td>\n
			</tr>\n
		</table>\n
	";

	$newOptions = ($options & ~7) + 3;

	$formAction = "reservation.php?" . join("+",array_slice($_SERVER['argv'],0,7)) . "+" . $newOptions . "+" . join("+",array_slice($_SERVER['argv'],8,11));

	$GLOBALS[$form]->FormHTML = str_replace("!formAction!",$formAction,
		str_replace("!attachmentInfo!",$attachmentTable,
		str_replace("!attachmentName!",$pdfName.".pdf",
		str_replace("!hasAttachment!","expand",
		str_replace("!emailBody!","",
		str_replace("!emailSubject!",$pdfName,
		join("", file(__DIR__ . "/../../../public/html/email_popup.htm")
	)))))));

	// Get principal details -----------------------------------------------------
	$principalId		= $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId		= $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
	$principalInfo	= getPersonaDetail($principalId);
	$resOfficeInfo	= getPersonaDetail($resOfficeId);

	$addressee										= t_encodeHTML(getContactCorrAddress($resOfficeId));
	$GLOBALS['temp']['princName']	= $principalInfo['name'];
	$GLOBALS['temp']['fax']				= $resOfficeInfo['fax'];
	$GLOBALS['temp']['resOffTel']	= $resOfficeInfo['telephone'];
	$userId												= $_SESSION['userid'];

	$GLOBALS['temp']['emailFrom'] = $lDB->get("
		SELECT
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '" . $userId . "'
	",4);
	$GLOBALS['temp']['emailTo'] = "";
}

// [START] GLOBAL Pagination Setup --------------------------------------------
$startDate	= "";
$endDate 		= "";
$startPage 	= 1;
$perPage 		= 35;

// [ END ] GLOBAL Pagination Setup --------------------------------------------

if($_SERVER['argc'] > 1 && $urlDateType != "fromCal") {

	// Show the report output buttons --------------------------------------------
	$GLOBALS['temp']['hideButts']						= "printCollapse outLtt bl br bb";
	$GLOBALS['temp']['emailPDF']						= "button bEmail";
	$GLOBALS['temp']['exportClass']					= "button bExport";
	$GLOBALS['temp']['showHideButtonClass']	= "button";

	$propertyName = "";
	$agentName = "";
	// [START] HTML Report -------------------------------------------------------
	if ( $renderMode == "html" ) {
		$GLOBALS['temp']['rows'] = "";

		$c = 1;
		$startDate = $fromDate['jsDate'];
		$endDate = $toDate['jsDate'];
		list($accommIds,$daylist) = calculateAllocations($accommDetails,$startDate,$endDate,$agentFilter['ids'],$showExpiredAllocations,$detailLevel,$allocRooms,$agentIdArray,$allocationList);

		switch ( $allocRooms ) {
			case 0:
				$allocType = "allocation";
				$totalType = "total";
				$allocRoomsDescription = "";
				break;
			case 1:
				$allocType = "allocation_used";
				$totalType = "total_used";
				$allocRoomsDescription = "used";
				break;
			case 2:
				$allocType = "allocation_balance";
				$totalType = "total_balance";
				$allocRoomsDescription = "remaining";
				break;
			case 3:
				$allocType = "all";
				$totalType = "materialisation";
				$allocRoomsDescription = "";
				break;
		}
		$rowHTML = "";
		$headerHTML = "";
		$bodyHTML = "";
		$footerHTML = "";
		$firstAccommId = reset($accommIds);

		// [START] Year, Month, Date & Day table headings --------------------------

		// [START] Month & Year Display --------------------------------------------
		if (!empty($accommIds)) {
			$headerHTML .= "<thead>";
			$headerHTML .= "<tr>\n<th style=\"background-color: #FFFFFF; border-bottom: 0px;\">&nbsp;</th><th class=\"br\" style=\"background-color: #FFFFFF; border-bottom: 0px;\">&nbsp;</th>\n<th class=\"br\" style=\"background-color: #FFFFFF; border-bottom: 0px;\">&nbsp;</th>\n<th style=\"background-color: #FFFFFF; border-bottom: 0px;\">&nbsp;</th>\n";

			$dates = $firstAccommId != false ? array_keys($firstAccommId['allocation']) : array();

			$monthArray = buildMonthYearHeader($dates);

			$dStyle = "border-bottom: 1px solid #630; border-left: 1px solid #630;background-color: #FFFFFF;";

			for ( $i = 0; $i < count($monthArray); $i++ ) {
				if ( $i == 0 ) {
					$dStyle .= "border-left: 1px solid #630;background-color: #FFFFFF;";
				}
				if ( $i == count($monthArray)-1 ) {
					$dStyle .= "border-right: 1px solid #630;background-color: #FFFFFF;";
				}

				if ( $monthArray[$i]['span'] > 2 ) {
					$headerHTML .= "<th align=\"left\" class=\"colWh\" style=\"" . $dStyle . "\" colspan=\"" . $monthArray[$i]['span'] . "\">&nbsp;" . $monthArray[$i]['monthyear'] . "</th>\n";
				} else {
					$headerHTML .= "<th align=\"left\" class=\"colWh\" style=\"" . $dStyle . "\" colspan=\"" . $monthArray[$i]['span'] . "\">&nbsp;</th>\n";
				}
			}
			$headerHTML .= "</tr>\n";
			// [ END ] Month & Year Display --------------------------------------------

			$headerHTML .= "<tr>\n<th style=\"background-color: #FFFFFF; border-bottom: 0px;\">&nbsp;</th>\n<th class=\"colWh br\" style=\"border-bottom: 0px;background-color: #FFFFFF;\">&nbsp;</th>\n<th class=\"br\" style=\"background-color: #FFFFFF; border-bottom: 0px;\">&nbsp;</th>\n<th style=\"background-color: #FFFFFF; border-bottom: 0px;\">&nbsp;</th>\n";

			$dayTotals = array();
			foreach ( $dates as $k => $v ) {
				$dayTotals[$v] = 0;
				$dateArr = explode("-",$v);
				$dayOfWeek = date("w",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));
				$dayLetter = substr(date("D",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0])),0,1);

				$blockStyle = blockStyle($k);

				if($dayOfWeek == 0 || $dayOfWeek == 6) {
					$headerHTML .= "<th align=\"center\" valign=\"middle\" class=\"outDk\" " . $blockStyle . ">" . $dayLetter . "</th>\n";
				} else {
					$headerHTML .= "<th align=\"center\" valign=\"middle\" class=\"outLt\" " . $blockStyle . ">" . $dayLetter . "</th>\n";
				}
			}
			$headerHTML .= "</tr>\n";

			$headerHTML .= "<tr>\n";
			$headerHTML .= "<th style=\"border-bottom: 1px solid #630;background-color: #FFFFFF;\">&nbsp;</th><th class=\"br\" style=\"background-color: #FFFFFF;\">&nbsp;</th><th class=\"br\" style=\"background-color: #FFFFFF;\"><div class=\"rotate90 nowrap\" style=\"max-width:8px;\">Units</div></th>\n<th style=\"background-color: #FFFFFF;\"><div class=\"rotate90 nowrap\" style=\"max-width:8px;\">Total Alloc</div></th>\n";

			foreach ( $dates as $k => $v ) {
				$dateArr = explode("-",$v);
				$dayOfWeek = date("w",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));
				$dayNumber = date("j",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));

				$blockStyle = blockStyle($k);

				if ( $dayOfWeek == 0 || $dayOfWeek == 6 ) {
					$headerHTML .= "<th align=\"center\" valign=\"middle\" class=\"outDk blkBord\" " . $blockStyle . ">" . $dayNumber . "</th>\n";
				} else {
					$headerHTML .= "<th align=\"center\" valign=\"middle\" class=\"outLt blkBord\" " . $blockStyle . ">" . $dayNumber . "</th>\n";
				}
			}
			$headerHTML .= "</tr></thead>\n";
		}
		// [ END ] Year, Month, Date & Day table headings --------------------------

		$colspan = count($daylist);

		// [START] Main Content ----------------------------------------------------
		$bodyHTML .= "<tbody>";
		if (empty($accommIds)) {
			$bodyHTML .= "<tr><td colspan=\"4\" align=\"middle\"><strong>No data found</strong></td</tr>";
		}
		generateTotals($accommIds);
		foreach ( $accommIds as $accomKey => $v ) {
			$accommId = $v['ac_accomm_type_ix'];
			$bodyHTML .= "<tr>";
			if ( $propertyName != $v['propertyName'] ) {
				$propertyName = $v['propertyName'];
				$bodyHTML .= "<td class=\"flat colDk nowrap\" style=\"border-right: 0; border-bottom: 0;\"><b>&nbsp;" . $propertyName . "</b></td>\n";
			} else {
				$bodyHTML .= "<td class=\"flat colDk nowrap\" style=\"border-right: 0; border-bottom: 0;\">&nbsp;</td>\n";
			}
			$totalAccommodation = 0;
			switch ($allocRooms) {
				case 0:
					$totalAccommodation = $accommIds[$accomKey]['sum_total'];
					break;
				case 1:
					$totalAccommodation = $accommIds[$accomKey]['sum_used'];
					break;
				case 2:
					$totalAccommodation = $accommIds[$accomKey]['sum_balance'];
					break;
				case 3:
					$totalAccommodation = $accommIds[$accomKey]['sum_total'];
					break;
				default:
					$totalAccommodation = $accommIds[$accomKey]['sum_total'];
					break;
			}
			if ( $detailLevel > 0 || $allocRooms == 3) {
				$bodyHTML .= "<td class=\"outLt nowrap\" style=\"border-right: 0px; border-top: 0px;\">".$v['accommType']."</td>\n<td align=\"center\" class=\"noBottomLeft outLt\">" . $v['units'] . "</td>\n<td align=\"center\" class=\"noBottomLeft outLt\">".$totalAccommodation."</td>\n";
				$bodyHTML .= addEmptyDayColumns($daylist,"outLt","border: 0px;");
			} else {
				$bodyHTML .= "<td class=\"outLt nowrap\">" . $v['accommType'] . "</td>\n<td class=\"noBottomLeft\" align=\"center\">" . $v['units'] . "</td>\n<td class=\"noBottomLeft\" align=\"center\">".$totalAccommodation."</td>\n";
			}

			if ( $detailLevel > 0 ) {
				// Group by: Accommodation Type
				// Detail level: Agent or Agent & Allocation

				// Allocations are grouped by either Agent or they are to be listed
				// seperately. -----------------------------------------------------------
				foreach ( $v['agentAllocation'] as $agentDetails ) {
					$agentName = $agentDetails['pr_name_last'];
					// Make a layout-friendly agent name with mouseover --------------------
					$agentName = "<span style=\"cursor: default;\">" . $agentName . "</span>";

					$totalAgent = $agentDetails['sum_total'];
					$bodyHTML .= "</tr>\n<tr>\n<td class=\"colLtt nowrap noBottomLeft\" style=\"border-right: 0px;\">&nbsp;" . $agentName . "</td><td class=\"colLtt noBottomLeft\" style=\"border-right: 1px;\">&nbsp;</td>\n<td class=\"noBottomLeft colLtt\">&nbsp;</td>\n<td class=\"noBottomLeft colLtt\" align=\"center\">".$totalAgent."</td>\n\n";
					if ($allocRooms == 3) {
						// Adjust colspan for materialisation view
						$bodyHTML .= addEmptyDayColumns($daylist,"colLtt","border: 0px;");
					}

					if ( $detailLevel > 1 ) {
						// Group by: Accommodation Type
						// Detail level: Agent & Allocation

						// Results grouped by agent and allocation ----------------------------

						// Display the overall totals for the agent : START -------------------
						if ($allocRooms != 3) {
							if ( isset($agentDetails[$totalType]) ) {
								foreach ( $daylist as $dayKey => $day ) {
									if ( !array_key_exists($day,$agentDetails[$totalType]) ) {
										$allocNumber = "&nbsp;";
									} else {
										$allocNumber = $agentDetails[$totalType][$day];
										$dayTotals[$day] += $allocNumber;
									}

									$bodyHTML .= "<td align=\"center\" class=\"noBottomLeft " . dateStyle($day) ."\">" . $allocNumber . "</td>\n";
								}
								$bodyHTML .= "</tr>\n";
							} else {
								$bodyHTML .= "<td colspan=\"" . $colspan . "\" class=\"noBottomLeft colWh\" align=\"center\"><i>No allocations " . $allocRoomsDescription . "</i></td>\n</tr>\n";
							}
						}
						// [ END ] Display the overall totals for the agent -------------------

						if ( isset($agentDetails[$allocType]) ) {
							// Show non-materialisation data
							foreach ($agentDetails[$allocType] as $allocID) {
								// User-friendly name for the allocation ----------------------------
								$allocName = $allocID['rv_res_name'];
								if (trim($allocName) != "") {
									$bodyHTML .= "</tr>\n<tr>";

									if (!empty($allocID['bl_block_abbrev'])) {
										$allocName = $allocID['bl_block_abbrev'] . ": " . $allocName;
									}
									$allocName = "<span style=\"cursor: default;\">" . $allocName . "</span>";

									$totalAllocation = $allocID['sum_total'];
									$bodyHTML .= "<td class=\"noBottomLeft nowrap\" style=\"border-right: 0px;\">&nbsp;&nbsp;" . $allocName . "</td><td class=\"noBottomLeft\" style=\"border-bottom: 1px;\">&nbsp;</td>\n<td class=\"noBottomLeft\" style=\"border-bottom: 1px;\">&nbsp;</td>\n<td class=\"noBottomLeft\" style=\"border-bottom: 1px;\" align=\"center\">".$totalAllocation."</td>\n";

									foreach ( $daylist as $dayKey => $day ) {
										if ( !isset($allocID['occupancy'][$day]) ) {
											$allocNumber = "&nbsp;";
										} else {
											$allocNumber = $allocID['occupancy'][$day];
										}
										$bodyHTML .= "<td align=\"center\" class=\"noBottomLeft " . dateStyle($day) ."\">" . $allocNumber . "</td>\n";
									}
									$bodyHTML .= "</tr>\n";
								}
							}
						} else if ( $allocType == "all" ) {
							// Show materialisation data
							$allocTypes = array("allocation", "allocation_used", "allocation_balance", "allocation_materialisation");
							foreach ( $agentDetails["allocation_materialisation"] as $allocationId => $allocData ) {
								$materialisationTotals = array();
								foreach ($allocTypes as $allocationType) {
									$bodyHTML .= "</tr>";
									$allocID = isset($agentDetails[$allocationType][$allocationId]) ? $agentDetails[$allocationType][$allocationId] : array();
									if (in_array($allocationType, array("allocation"))) {
										$allocName = $allocID['rv_res_name'];
										if (!empty($allocID['bl_block_abbrev'])) {
											$allocName = $allocID['bl_block_abbrev'] . ": " . $allocName;
										}
										$allocationName = "<span style=\"cursor: default;\">" . $allocName . "</span>";
										$bodyHTML .= "\n<tr>\n<td class=\"bt nowrap\">&nbsp;&nbsp;" . $allocationName . "</td><td class=\"bt\">&nbsp;</td>\n<td class=\"bt\">&nbsp;</td><td class=\"br bt\" align=\"center\">&nbsp;</td>\n".addEmptyDayColumns($daylist,"bb","border: 0px;")."</tr><tr>";
									} else {
										$bodyHTML .= "\n<tr>";
									}

									// User-friendly name for the allocation ----------------------------
									$allocName = "<span style=\"cursor: default;\">&nbsp;&nbsp;&nbsp;" . getMaterialisationDescription($allocationType) . "</span>";

									if ($detailLevel == 2) {
										if ($allocationType != "allocation_materialisation" && isset($agentDetails[$allocationType][$allocationId])) {
											$totalAmount = $agentDetails[$allocationType][$allocationId]['sum_total'];
										} else {
											$totalAmount = 0;
										}
										$materialisationTotals[$allocationType] = $totalAmount;
										$totalMaterialisation = $allocationType != "allocation_materialisation" ? $totalAmount : round(($materialisationTotals['allocation_used']/(empty($materialisationTotals['allocation']) ? 1 : $materialisationTotals['allocation']))*100, 0, PHP_ROUND_HALF_UP);
									} else {
										$totalAmount = array_sum($agentDetails[$allocationType]);
										$materialisationTotals[$allocationType] = $totalAmount;
                                        $totalMaterialisation = getMaterialisationAmount(getMaterialisationTotalDescription($allocationType), "average_materialisation", $totalAmount, $materialisationTotals['total_used'], $materialisationTotals['total']);
									}
									$bodyHTML .= "<td class=\"noBottomLeft nowrap\" style=\"border-right: 0px;\">&nbsp;&nbsp;" . $allocName . "</td><td class=\"noBottomLeft nowrap\">&nbsp;</td>\n<td class=\"noBottomLeft nowrap\">&nbsp;</td>\n<td class=\"noBottomLeft nowrap\" align=\"center\">".$totalMaterialisation."</td>\n";

									foreach ( $daylist as $dayKey => $day ) {
										$hasValues = false;
										foreach ($allocTypes as $at) {
											if (isset($agentDetails[$at][$allocationId]['occupancy'][$day])) {
												if ($agentDetails[$at][$allocationId]['occupancy'][$day] != 0) {
													$hasValues = true;
												}
											}
										}
										if ( !isset($allocID['occupancy']) || (!array_key_exists($day,$allocID['occupancy']) && $allocType != "allocation_materialisation" )) {
											if ($hasValues) {
												$allocNumber = 0;
											} else {
												$allocNumber = "&nbsp;";
											}
										} else {
											$allocNumber = ($allocationType == "allocation_materialisation" && trim($allocID['occupancy'][$day]) == "") ? "&npsp;" : round($allocID['occupancy'][$day], 0, PHP_ROUND_HALF_UP);
											if ($allocationType == "allocation_materialisation" && trim($allocID['occupancy'][$day]) != "") {
												$allocNumber .= "%";
											}
											$dayTotals[$day] += $allocNumber != "&nbsp;" ? $allocNumber : 0;
										}
										$materialisationStyle = $allocationType != "allocation_materialisation" ? "noBottomLeft" : "bb br bt";
										$bodyHTML .= "<td align=\"center\" class=\"".$materialisationStyle . " " . dateStyle($day) ."\">" . $allocNumber . "</td>\n";
									}
									$bodyHTML .= "</tr>\n";
								}
							}
						}
					} else {
						// Group by: Accommodation Type
						// Detail level: Agent

						// Group By Agent only ------------------------------------------------
						if ( isset($agentDetails[$totalType]) && $allocType != "all" ) {
							foreach ( $daylist as $dayKey => $day ) {
								if ( !array_key_exists($day,$agentDetails[$totalType]) && $allocType != "all" ) {
									$allocNumber = "&nbsp;";
								} elseif ( !array_key_exists($day,$agentDetails[$totalType]) && $allocType == "all" ) {
									$allocNumber = "&npsp;";
								} else {
									$allocNumber = round($agentDetails[$totalType][$day], 0, PHP_ROUND_HALF_UP);
									$dayTotals[$day] += $allocNumber;
								}
								$bodyHTML .= "<td align=\"center\" class=\"noBottomLeft " . dateStyle($day) ."\">" . $allocNumber . "</td>\n";
							}
							$bodyHTML .= "</tr>\n";
						} else if ($allocType == "all" ) {
							// Show materialisation data
							$allocTypes = array("total", "total_used", "total_balance", "materialisation");
							$bodyHTML .= "</tr>\n";
							$materialisationTotals = array();
							foreach ($allocTypes as $allocationType) {
								$bodyHTML .= "<tr>";

								// User-friendly name for the allocation type ----------------------------
								$allocName = "<span style=\"cursor: default;\">&nbsp;&nbsp;&nbsp;" . getMaterialisationDescription($allocationType) . "</span>";

								$totalAmount = array_sum($agentDetails[$allocationType]);
								$materialisationTotals[$allocationType] = $totalAmount;
                                $usedValue = isset($materialisationTotals['total_used'])?$materialisationTotals['total_used']:0;
                                $totalMaterialisation = getMaterialisationAmount(getMaterialisationTotalDescription($allocationType), "average_materialisation", $totalAmount, $usedValue, $materialisationTotals['total']);
								if ($allocationType == "materialisation" && trim($totalMaterialisation) != "") {
									$totalMaterialisation .= "%";
								}
								$bodyHTML .= "<td class=\"noBottomLeft nowrap\" style=\"border-right: 0px;\">&nbsp;&nbsp;" . $allocName . "</td><td class=\"noBottomLeft nowrap\">&nbsp;</td>\n<td class=\"noBottomLeft nowrap\">&nbsp;</td>\n<td class=\"noBottomLeft nowrap\" align=\"center\">".$totalMaterialisation."</td>\n";

								foreach ( $daylist as $dayKey => $day ) {
									if ( !array_key_exists($day,$agentDetails[$allocationType]) && $allocType != "allocation_materialisation" ) {
										$allocNumber = "&nbsp;";
									} else {
										$allocNumber = ($allocationType == "allocation_materialisation" && trim($agentDetails[$allocationType][$day]) == "") ? "&npsp;" : round($agentDetails[$allocationType][$day], 0, PHP_ROUND_HALF_UP);
										$dayTotals[$day] += $allocNumber != "&nbsp;" ? $allocNumber : 0;
									}
									if ($allocationType == "materialisation" && $allocNumber != "&nbsp;") {
										$allocNumber .= "%";
									}
									$bodyHTML .= "<td align=\"center\" class=\"noBottomLeft " . dateStyle($day) ."\">" . $allocNumber . "</td>\n";
								}
								$bodyHTML .= "</tr>\n";
							}
						} else {
							$bodyHTML .= "<td colspan=\"" . $colspan . "\" class=\"noBottomLeft colWh\" align=\"center\"><i>No allocations " . $allocRoomsDescription . "</i></td>\n</tr>\n";
						}
					}
				}
			} else {
				// Group by: Accommodation Type
				// Detail level: All

				if ( $allocRooms > 0 ) {
					// Array to hold data as we process through each agentAllocation for this
					// $accommId ------------------------------------------------------------
					$allocNumberArray = array();

					// Boolean to help decide whether to show data or a message to the effect
					// that this $accommId has no allocation data matching the filters ------
					$typeExists = false;

					// Calculate the unused allocations totals ------------------------------
					$allocTypes = array();
					if ($allocType != "all") {
						$allocTypes = array($totalType);
					} else if ($v['agentAllocation'] && $allocType == "all" ) {
						$allocTypes = array("total", "total_used", "total_balance", "materialisation");
					}
					foreach ($allocTypes as $allocationType) {
						foreach ( $daylist as $dayKey => $day ) {
							if (!isset($allocNumberArray[$accommId][$allocationType])) { $allocNumberArray[$accommId][$allocationType] = array(); }

							if(!array_key_exists($day,$allocNumberArray[$accommId])) {
								$allocNumberArray[$accommId][$allocationType][$day] = null;
							}

							if ( $v['agentAllocation']) {
								foreach ( $v['agentAllocation'] as $agentDetails ) {
									if (isset($agentDetails[$allocationType])) {
										$typeExists = true;
										if(array_key_exists($day,$agentDetails[$allocationType]) ) {
											if(is_null($allocNumberArray[$accommId][$allocationType][$day])) {
												$allocNumberArray[$accommId][$allocationType][$day] = 0;
											}
											if ($allocationType != "materialisation") {
												$allocNumberArray[$accommId][$allocationType][$day] += $agentDetails[$allocationType][$day];
											} else {
												$allocNumberArray[$accommId][$allocationType][$day] = $agentDetails[$allocationType][$day];
											}
										}
									}
								}
							}
						}
					}

					// Compile totals of all allocationTypes
					$allocationTypeSum = array();
					if (isset($allocNumberArray[$accommId])) {
						foreach($allocNumberArray[$accommId] as $allocationType => $allocationTypeValues) {
							foreach ($allocationTypeValues as $date => $value) {
								if(array_key_exists($date,$allocationTypeSum)) {
									$allocationTypeSum[$date] = $allocationTypeSum[$date] + (($value == "" || $value == null) ? 0 : $value);
								} else {
									$allocationTypeSum[$date] = $value;
								}
							}
						}
					}

					$materialisationTotals = array();

					// Now that we have a single array with all the information for this
					// allocation type, we need to step through it to output the data -------
					if ($typeExists) {
						foreach ($allocTypes as $allocationType) {
							if ($allocType == "all") {
								$bodyHTML .= "</tr>\n<tr>";
								// User-friendly name for the allocation type ----------------------------
								$allocName = "<span style=\"cursor: default;\">&nbsp;&nbsp;&nbsp;" . getMaterialisationDescription($allocationType) . "</span>";

								$totalAmount = array_sum($allocNumberArray[$accommId][$allocationType]);
								$materialisationTotals[$allocationType] = $totalAmount;
								if (!isset($materialisationTotals['total_used'])) {
									$materialisationTotals['total_used'] = 0;
								}
                                $totalMaterialisation = getMaterialisationAmount(getMaterialisationTotalDescription($allocationType), "average_materialisation", $totalAmount, $materialisationTotals['total_used'], $materialisationTotals['total']) . "%";
								$bodyHTML .= "<td class=\"noBottomLeft nowrap\" style=\"border-right: 0px;\">&nbsp;&nbsp;" . $allocName . "</td>\n<td class=\"noBottomLeft\"></td>\n<td class=\"noBottomLeft\">&nbsp;</td>\n<td class=\"noBottomLeft\" align=\"center\">".$totalMaterialisation."</td>\n";
							}
							foreach ($allocNumberArray[$accommId][$allocationType] as $date => $a ) {
								if (is_null($a) || $allocationTypeSum[$date] == 0)  {
									$a = "&nbsp;";
								} else {
									$a = round($a, 0, PHP_ROUND_HALF_UP);
									$dayTotals[$date] += $a;
								}
								$bodyHTML .= "<td align=\"center\" class=\"noBottomLeft " . dateStyle($date) ."\">" . $a . "</td>\n";
							}
						}
					} else {
						if ($allocType == "all") {
							$bodyHTML .= "</tr>\n<tr><td colspan=\"" . $colspan . "\" class=\"noBottomLeft colWh\" align=\"center\"><i>No allocations " . $allocRoomsDescription . "</i></td>\n</tr>";
						} else {
							$bodyHTML .= "<td colspan=\"" . $colspan . "\" class=\"noBottomLeft colWh\" align=\"center\"><i>No allocations " . $allocRoomsDescription . "</i></td>\n</tr>";
						}
					}
				} else {
					// Just list the total allocation sum for each Accommodation type -------
					$allocationType = $totalType;
					$allocationTypeSum = array();
					foreach ($daylist as $dayKey => $day) {
						$allocationTypeSum[$day] = 0;
						if (!isset($allocNumberArray[$accommId][$allocationType])) { $allocNumberArray[$accommId][$allocationType] = array(); }

						if(!array_key_exists($day,$allocNumberArray[$accommId])) {
							$allocNumberArray[$accommId][$allocationType][$day] = null;
						}

						if ($v['agentAllocation']) {
							foreach ( $v['agentAllocation'] as $agentDetails ) {
								if (isset($agentDetails[$allocationType])) {
									if(array_key_exists($day,$agentDetails[$allocationType]) ) {
										if(is_null($allocNumberArray[$accommId][$allocationType][$day])) {
											$allocNumberArray[$accommId][$allocationType][$day] = 0;
										}
										$allocNumberArray[$accommId][$allocationType][$day] += $agentDetails[$allocationType][$day];
									}
								}
							}
						}
					}

					if (isset($allocNumberArray[$accommId])) {
						foreach($allocNumberArray[$accommId] as $allocationType => $allocationTypeValues) {
							foreach ($allocationTypeValues as $date => $value) {
								$allocationTypeSum[$date] = $allocationTypeSum[$date] + (($value == "" || $value == null) ? 0 : $value);
							}
						}
					}
					foreach ($allocationTypeSum as $allocDate => $allocNumber ) {
						$dateArr = explode("-",$allocDate);
						$dayOfWeek = date("w",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));

						if ( $allocNumber == 0 ) {
							$allocNumber = "&nbsp;";
						} else {
							$dayTotals[$allocDate] += $allocNumber;
						}
						$bodyHTML .= "<td align=\"center\" valign=\"middle\" class=\"noBottomLeft " . dateStyle($allocDate) ."\">" . $allocNumber . "</td>";
					}
				}
				$bodyHTML .= "</tr>";
			}
		}
		$bodyHTML .= "</tbody>";
		if (!empty($accommIds) && $allocRooms != 3) {
			$footerHTML .= generateTotalsFooter($dayTotals, $renderMode);
		}
		$GLOBALS['temp']['rows'] .= "<table id=\"tblAllocationSummaryReport\" width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"display: none;\">" . $headerHTML . $bodyHTML . $footerHTML . "</table>" ;
	}
	// [ END ] HTML Report -------------------------------------------------------

	// [START] PDF Report --------------------------------------------------------
	if ($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {
		$dateCount = (dateSubtract($toDate['jsDate'],$fromDate['jsDate']))+1;
		$remainder = $dateCount%$perPage;
		$totalPages = ceil($dateCount/$perPage);

		$accommCellWidth = "15";
		if ( $showUnits ) {
			$accommCellWidth -= 5;
		}
		if ( $showTotals ) {
			$accommCellWidth -= 5;
		}

		$maxRowsPerPage = 38;

		$startDate = $fromDate['jsDate'];
		$endDate = $toDate['jsDate'];
		list($accommIds,$daylist) = calculateAllocations($accommDetails,$startDate,$endDate,$agentFilter['ids'],$showExpiredAllocations,$detailLevel,$allocRooms,$agentIdArray,$allocationList);

		// PDF Pagination setup to mitigate rows breaking across pages : START ------
		$propertyArr = array();

		foreach ( $accommIds as $k => $v ) {
			array_push($propertyArr,$accommIds[$k]['propertyName']);
		}

		$propertyCount = count(array_unique($propertyArr));
		$accommCount = count($accommIds);

		// Number of rows taken per page --------------------------------------------
		$rowCount = $propertyCount + $accommCount + 3;

		$splitPoint = floor($maxRowsPerPage/$rowCount);
		// PDF Pagination setup to mitigate rows breaking across pages : END --------

		$pdf = new PDF($jobName . " Report",'L');
		$reportLabel = $jobName . " Report";

		$pdf -> SetFillColor('0x9c','0x9e','0x98');

		$headerArray = array(array(
			'name'	=> "Date Range",
			'value'	=> $fromDate['htmlDate'] . " to " . $toDate['htmlDate']
		));

		$pdfHeadPropertyFilter = implode(" ", $propertyNames);
		$pdfHeadAccommodationFilter = count($accommNames) == 0 ? "All" : implode(" ", $accommNames);;
		$pdfHeadShowExpired = ( $showExpiredAllocations ) ? "Yes" : "No";
		$pdfHeadShowUnits = ( $showUnits == 'true' ) ? "Yes" : "No";
		$pdfHeadShowTotals = ( $showTotals == 'true' ) ? "Yes" : "No";
		$pdfHeadPageBreaks = ( $pageBreaks > 0 ) ? "Yes" : "No";
		$pdfHeadShowParams = ( $showParameters > 0 ) ? "Yes" : "No";

		switch ( $detailLevel ) {
			case 0:
				$pdfHeadGroupBy = "All";
				break;
			case 1:
				$pdfHeadGroupBy = "Agent";
				break;
			case 2:
				$pdfHeadGroupBy = "Agent and Allocation";
				break;
		}

		switch ( $allocRooms ) {
			case 0:
				$pdfHeadAllocRooms = "Allocated";
				break;
			case 1:
				$pdfHeadAllocRooms = "Used";
				break;
			case 2:
				$pdfHeadAllocRooms = "Balance";
				break;
			case 3:
				$pdfHeadAllocRooms = "Materialisation";
				break;
		}

		array_push($headerArray,array('name' => "Properties", 'value' => $pdfHeadPropertyFilter));
		array_push($headerArray,array('name' => "Accommodation types", 'value' => $pdfHeadAccommodationFilter));
		array_push($headerArray,array('name' => "Allocated rooms", 'value' => $pdfHeadAllocRooms));
		array_push($headerArray,array('name' => "Group by", 'value' => $pdfHeadGroupBy));
		array_push($headerArray,array('name' => "Show expired allocations", 'value' => $pdfHeadShowExpired));
		array_push($headerArray,array('name' => "Show units", 'value' => $pdfHeadShowUnits));
		array_push($headerArray,array('name' => "Show total allocations", 'value' => $pdfHeadShowTotals));
		array_push($headerArray,array('name' => "Insert page breaks", 'value' => $pdfHeadPageBreaks));
		array_push($headerArray,array('name' => "Show report parameters", 'value' => $pdfHeadShowParams));

		// Parameter Bar Setup : START ----------------------------------------------
		$paramBar = array();
		$paramBar["P"] 	= (count($propertyIds) > 0) ? 1 : 0;
		$paramBar["AT"] = (count($accommIds) > 0) ? 1 : 0;

		switch ($allocRooms) {
			case 0:
				$paramBar["AA"] = "1";
				break;
			case 1:
				$paramBar["AU"] = "1";
				break;
			case 2:
				$paramBar["AB"] = "1";
				break;
			case 3:
				$paramBar["AM"] = "1";
				break;
		}

		switch ( $detailLevel ) {
			case 0:
				$paramBar["G1"] = "1";
				break;
			case 1:
				$paramBar["G2"] = "1";
				break;
			case 2:
				$paramBar["G3"] = "1";
				break;
		}

		$paramBar["EX"] = ( $showExpiredAllocations ) ? 1 : 0;
		$paramBar["SU"] = ( $showUnits ) ? 1 : 0;
		$paramBar["PB"] = ( $pageBreaks ) ? 1 : 0;
		// Parameter Bar Setup : END ------------------------------------------------

		$pdfFontSize = 7;
		$pdfDayCellWidth = 2.42;
		$pdf->SetFont('Arial', '', $pdfFontSize);

		$pdf->Ln(4);

		$logo = "top_clientlogo.jpg";
		$principal_id = $_SESSION['principal_id'];

		if ( file_exists("$GLOBALS[images_dir_on_disk]/" . $principal_id . "/" . $logo) ) {
			$pic = $pdf->_parsejpg("$GLOBALS[images_dir_on_disk]/" . $principal_id . "/" . $logo);

			$h = $pic['h']/4;
			$w = $pic['w']/4;

			require_once(__DIR__ . '/functions.imageset.php');
			$logoWidth = imagesetLogoSizeOverride("allocationSummaryReportPdfLogoWidthOverride", $w);
			$pdf->Image("$GLOBALS[images_dir_on_disk]/".$principal_id."/" . $logo, $h, 5, $logoWidth);
			if ( ($h + 8) > $pdf->y ) {
				$pdf->y = $h + 8;
			}
		}

		for ( $pdfPage = 1; $pdfPage <= $totalPages; $pdfPage++ ) {
			if ( $splitPoint != 0 && $pdfPage%$splitPoint == 1 && $pdfPage > 1 && $pageBreaks != 'true' ) {
				$pdf -> addPage();
			}

			$startCount = ($pdfPage-1)*$perPage;

			if ($pdfPage == $totalPages) {
				if($remainder == 0) {
					$endCount = $startCount+35;
				}
				else {
					$endCount = $startCount+$remainder;
				}
				$propertyCellWidth = $accommCellWidth + (($remainder)*$pdfDayCellWidth);

				if ($showUnits) {
					$propertyCellWidth += 5;
				}
				if ($showTotals) {
					$propertyCellWidth += 5;
				}

			} else {
				$endCount = $startCount+$perPage;
				$propertyCellWidth = $accommCellWidth + (($endCount)*$pdfDayCellWidth);
				if ($showUnits) {
					$propertyCellWidth += 5;
				}
				if ($showTotals) {
					$propertyCellWidth += 5;
				}
			}

			if (!empty($accommIds)) {
				switch ( $allocRooms ) {
				case 0:
					$allocType = "allocation";
					$totalType = "total";
					$allocRoomsDescription = "";
					break;
				case 1:
					$allocType = "allocation_used";
					$totalType = "total_used";
					$allocRoomsDescription = "used";
					break;
				case 2:
					$allocType = "allocation_balance";
					$totalType = "total_balance";
					$allocRoomsDescription = "remaining";
					break;
				case 3:
					$allocType = "all";
					$totalType = "materialisation";
					$allocRoomsDescription = "";
					break;
				}
				$startDate = dateAddDay($fromDate['jsDate'],$startCount);
				$endDate = dateAddDay($startDate,$endCount);

				// Month & Year Headings : START ----------------------------------------
				$firstAccommId = reset($accommIds);
				$dates = array_slice(array_keys($firstAccommId['allocation']), $startCount, $endCount);

				$monthYearArr = array(array(
					'width'		=> $accommCellWidth . "%",
					'data'		=> '',
					'border'	=> 'LT'
				));

				$monthArray = buildMonthYearHeader($dates);

				if ( $showUnits ) {
					array_push($monthYearArr,array('width' => '5%', 'data' => '', 'border' => 'T'));
				}
				if ( $showTotals ) {
					array_push($monthYearArr,array('width' => '5%', 'data' => '', 'border' => 'T'));
				}

				$dStyle = "LT";

				for ( $i = 0; $i < count($monthArray); $i++ ) {
					$cellwidth = $monthArray[$i]['span']*$pdfDayCellWidth . "%";

					if ( $i == count($monthArray)-1) {
						$dStyle .= "R";
					}

					if ( $monthArray[$i]['span'] > 2 ) {
						array_push($monthYearArr,array('width' => $cellwidth, 'data' => $monthArray[$i]['monthyear'], 'border' => $dStyle));
					} else {
						array_push($monthYearArr,array('width' => $cellwidth, 'data' => '', 'border' => $dStyle));
					}
				}
				$pdf -> Row($monthYearArr);
				// Month & Year Headings : END ---------------------------------------------
				// Day Letter Row : START --------------------------------------------------
				$dayRowArray = array(array('width' => $accommCellWidth . "%", 'data' => '', 'border' => 'L'));

				if( $showUnits ) {
					array_push($dayRowArray,array('width' => "5%", 'data' => ''));
				}
				if( $showTotals ) {
					array_push($dayRowArray,array('width' => "5%", 'data' => ''));
				}

				$dayTotals = array();
				foreach (new LimitIterator(new ArrayIterator($firstAccommId['allocation']), $startCount, $endCount) as $k => $v ) {
					$dayTotals[$k] = 0;
					$dateArr = explode("-",$k);
					$dayOfWeek = date("w",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));
					$dayLetter = substr(date("D",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0])),0,1);

					if ( $dayOfWeek == 0 || $dayOfWeek == 6 ) {
						array_push($dayRowArray,array('width' => $pdfDayCellWidth."%", 'data' => $dayLetter, 'border' => "LRTB", 'align' => 'C', 'fill' => '1'));
					} else {
						array_push($dayRowArray,array('width' => $pdfDayCellWidth.'%', 'data' => $dayLetter, 'border' => "LRTB", 'align' => 'C'));
					}
				}
				$pdf -> Row($dayRowArray);
				// Day Letter Row : END ----------------------------------------------------

				// Day Number Row : START --------------------------------------------------
				$dayNumberRowArray = array(array(
					'width'		=> $accommCellWidth . "%",
					'data'		=> '',
					'border'	=> 'L'
				));

				if ( $showUnits ) {
					array_push($dayNumberRowArray,array('width' => "5%", 'data' => 'Units', 'border' => 'LRTB', 'align' => 'C'));
				}
				if ( $showTotals ) {
					array_push($dayNumberRowArray,array('width' => "5%", 'data' => 'Totals', 'border' => 'LRTB', 'align' => 'C'));
				}

				foreach (new LimitIterator(new ArrayIterator($firstAccommId['allocation']), $startCount, $endCount) as $k => $v ) {
					$dateArr = explode("-",$k);
					$dayOfWeek = date("w",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));
					$dayNumber = date("j",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));

					if ( $dayOfWeek == 0 || $dayOfWeek == 6 ) {
						array_push($dayNumberRowArray,array('width' => $pdfDayCellWidth."%",	'data' => $dayNumber,	'border' => "LRTB",	'align' => 'C',	'fill' => '1'));
					} else {
						array_push($dayNumberRowArray,array('width' => $pdfDayCellWidth.'%',	'data' => $dayNumber,	'border' => "LRTB",	'align' => 'C'));
					}
				}
				$pdf -> Row($dayNumberRowArray);
				// Day Number Row : END ----------------------------------------------------

				// Main Content : START ----------------------------------------------------
				$propertyName = "";
				generateTotals($accommIds);
				foreach ( $accommIds as $accomKey => $v ) {
					$accommId = $v['ac_accomm_type_ix'];
					if ( $propertyName != $v['propertyName'] ) {
						$propertyName = $v['propertyName'];
						$pdf->Row(array(array(
							'width'		=> $propertyCellWidth . "%",
							'data'		=> $v['propertyName'],
							'border'	=> "LRBT",
							'fill'		=> '0'
						)));
					}

					$totalAccommodation = 0;
					switch ($allocRooms) {
						case 0:
							$totalAccommodation = $accommIds[$accomKey]['sum_total'];
							break;
						case 1:
							$totalAccommodation = $accommIds[$accomKey]['sum_used'];
							break;
						case 2:
							$totalAccommodation = $accommIds[$accomKey]['sum_balance'];
							break;
						case 3:
							$totalAccommodation = $accommIds[$accomKey]['sum_total'];
							break;
						default:
							$totalAccommodation = $accommIds[$accomKey]['sum_total'];
							break;
					}
					if ( $detailLevel > 0 || $allocRooms == 3 ) {
						if ( $showUnits || $showTotals) {
							$accommRow = array(array(
								'width'		=> $accommCellWidth . "%",
								'data'		=> "  ".$v['accommType'],
								'border'	=> 'LRTB'
							));
							$showItemsWidth = 0;
							if ($showUnits) {
								array_push($accommRow,array('width' => "5%", 'data' => $v['units'],	'border' => 'LRTB',	'align' => 'C'));
								$showItemsWidth += 5;
							}
							if ($showTotals) {
								array_push($accommRow,array('width' => "5%", 'data' => $totalAccommodation,	'border' => 'LRTB',	'align' => 'C'));
								$showItemsWidth += 5;
							}
							array_push($accommRow, array('width' => $propertyCellWidth - $accommCellWidth - $showItemsWidth . "%", 'data' => " ", 'border' => 'LRTB',	'align' => 'C'));
						} else {
							$accommRow = array(array(
								'width'		=> $propertyCellWidth . "%",
								'data'		=> "  ".$v['accommType'],
								'border'	=> 'LRTB'
							));
						}
						$pdf->Row($accommRow);
					}

					if ( $detailLevel > 0 ) {
						// Allocations are grouped by either Agent or they are to be listed
						// seperately. -----------------------------------------------------------
						foreach ( $v['agentAllocation'] as $agentDetails ) {
							$agentName = " ".$agentDetails['pr_name_last'];
							$totalAgent = $agentDetails['sum_total'];

							if ( $detailLevel > 1 ) {
								// Results grouped by agent and allocation ----------------------------
								// Display the overall totals for the agent : START -------------------
								if ($allocRooms != 3) {
									$currRowArray = array(array('width' => $accommCellWidth . "%", 'data' => $agentName, 'border' => "LRTB", 'align' => "L"));
									if ( $showUnits ) {
										array_push($currRowArray,array('width' => "5%", 'data' => " ", 'border' => 'LRTB', 'align' => 'C'));
									}
									if ( $showTotals ) {
										array_push($currRowArray,array('width' => "5%", 'data' => $totalAgent, 'border' => 'LRTB', 'align' => 'C'));
									}
									if ( $agentDetails[$totalType] ) {
										foreach (new LimitIterator(new ArrayIterator($daylist), $startCount, $endCount) as $dayKey => $day ) {
											if ( !array_key_exists($day,$agentDetails[$totalType]) ) {
													$allocNumber = " ";
												} else {
													$allocNumber = $agentDetails[$totalType][$day];
													$dayTotals[$day] += $allocNumber;
												}
												$dateArr = explode("-",$day);
												$dayOfWeek = date("w",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));

												if ( $dayOfWeek == 0 || $dayOfWeek == 6 ) {
													array_push($currRowArray,array(
														'width'		=> $pdfDayCellWidth."%",
														'data'		=> $allocNumber,
														'border'	=> "LRTB",
														'align'		=> 'C',
														'fill'		=> "1"
													));
												} else {
													array_push($currRowArray,array(
														'width'		=> $pdfDayCellWidth."%",
														'data'		=> $allocNumber,
														'border'	=> "LRTB",
														'align'		=> 'C'
													));
												}
											}
										$pdf->Row($currRowArray);
									} else {
										array_push($currRowArray,array(
											'width'		=> $propertyCellWidth - $accommCellWidth - ($showUnits ? 5 : 0) - ($showTotals ? 5 : 0) . "%",
											'data'		=> "No allocations " . $allocRoomsDescription,
											'border'	=> "LRTB",
											'align'		=> "C"
										));
										$pdf->Row($currRowArray);
									}
								}
								// Display the overall totals for the agent : END ---------------------

								// Display each allocation item : START -------------------------------
								if ( isset($agentDetails[$allocType]) ) {
									foreach ( $agentDetails[$allocType] as $allocID ) {
										// User-friendly name for the allocation ----------------------------
										$allocName = $allocID['rv_res_name'];
										if (trim($allocName) != "") {
											if (!empty($allocID['bl_block_abbrev'])) {
												$allocName = $allocID['bl_block_abbrev'] . ": " . $allocName;
											}
											$allocName = "  " . $allocName;

											$totalAllocation = $allocID['sum_total'];
											$currRowArray = array(array('width' => $accommCellWidth . "%", 'data' => $allocName, 'border' => "LRTB", 'align' => "L"));
											if ( $showUnits ) {
												array_push($currRowArray,array('width' => "5%", 'data' => " ", 'border' => 'LRTB', 'align' => 'C'));
											}
											if ( $showTotals ) {
												array_push($currRowArray,array('width' => "5%", 'data' => $totalAllocation, 'border' => 'LRTB', 'align' => 'C'));
											}

											foreach (new LimitIterator(new ArrayIterator($daylist), $startCount, $endCount) as $dayKey => $day ) {
												if ( !array_key_exists($day,$allocID['occupancy']) ) {
													$allocNumber = " ";
												} else {
													$allocNumber = $allocID['occupancy'][$day];
												}

												$dateArr = explode("-",$day);
												$dayOfWeek = date("w",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));

												if ( $dayOfWeek == 0 || $dayOfWeek == 6 ) {
													array_push($currRowArray,array('width' => $pdfDayCellWidth."%", 'data' => $allocNumber, 'border' => "LRTB", 'align' => 'C', 'fill' => "1"));
												} else {
													array_push($currRowArray,array('width' => $pdfDayCellWidth."%", 'data' => $allocNumber, 'border' => "LRTB", 'align' => 'C'));
												}
											}
											$pdf->Row($currRowArray);
										}
									}
								} else if ( $allocType == "all" ) {
									// Show materialisation data
									$materialisationTotals = array();
									$allocTypes = array("allocation", "allocation_used", "allocation_balance", "allocation_materialisation");
									foreach ( $agentDetails["allocation_materialisation"] as $allocationId => $allocData ) {
										foreach ($allocTypes as $allocationType) {
											$currRowArray = array();
											$allocID = isset($agentDetails[$allocationType][$allocationId]) ? $agentDetails[$allocationType][$allocationId] : array();
											if (in_array($allocationType, array("allocation"))) {
												$allocationName = $allocID['rv_res_name'];
												if (!empty($allocID['bl_block_abbrev'])) {
													$allocationName = $allocID['bl_block_abbrev'] . ": " . $allocationName;
												}
												$pdf->Row(array(array('width' => $propertyCellWidth . "%", 'data' => $allocationName, 'border' => "LRTB", 'align' => "L")));
											}

											// User-friendly name for the allocation ----------------------------
											$allocName = "   " . getMaterialisationDescription($allocationType);
											if ($detailLevel == 2) {
												if ($allocationType != "allocation_materialisation" && isset($agentDetails[$allocationType][$allocationId])) {
													$totalAmount = $agentDetails[$allocationType][$allocationId]['sum_total'];
												} else {
													$totalAmount = 0;
												}
												$materialisationTotals[$allocationType] = $totalAmount;
                                                $totalMaterialisation = getMaterialisationAmount(getMaterialisationTotalDescription($allocationType), "allocation_materialisation", $totalAmount, $materialisationTotals['allocation_used'], $materialisationTotals['allocation']);
											} else {
												$totalAmount = array_sum($agentDetails[$allocationType]);
												$materialisationTotals[$allocationType] = $totalAmount;
                                                $totalMaterialisation = getMaterialisationAmount(getMaterialisationTotalDescription($allocationType), "average_materialisation", $totalAmount, $materialisationTotals['total_used'], $materialisationTotals['total']);
											}

											array_push($currRowArray,array('width' => $accommCellWidth . "%", 'data' => $allocName, 'border' => "LRTB", 'align' => "L"));
											if ( $showUnits ) {
												array_push($currRowArray,array('width' => "5%", 'data' => " ", 'border' => 'LRTB', 'align' => 'C'));
											}
											if ( $showTotals ) {
												array_push($currRowArray,array('width' => "5%", 'data' => $totalMaterialisation, 'border' => 'LRTB', 'align' => 'C'));
											}

											foreach (new LimitIterator(new ArrayIterator($daylist), $startCount, $endCount) as $dayKey => $day ) {
												$hasValues = false;
												foreach ($allocTypes as $at) {
													if (isset($agentDetails[$at][$allocationId]['occupancy'][$day])) {
														if ($agentDetails[$at][$allocationId]['occupancy'][$day] != 0) {
															$hasValues = true;
														}
													}
												}
												if ( !isset($allocID['occupancy']) || (!array_key_exists($day,$allocID['occupancy']) && $allocType != "allocation_materialisation" )) {
													if ($hasValues) {
														$allocNumber = 0;
													} else {
														$allocNumber = " ";
													}
												} else {
													if ($allocationType == "allocation_materialisation") {
														if (trim($allocID['occupancy'][$day]) == "") {
															$allocNumber = "&npsp;";
														} else  {
															$allocNumber = $allocID['occupancy'][$day] == 100 ? $allocID['occupancy'][$day] : number_format((float)round($allocID['occupancy'][$day], 0, PHP_ROUND_HALF_UP), 1, '.', '');
															$dayTotals[$day] += $allocNumber;
														}
													} else {
														$allocNumber = $allocID['occupancy'][$day];
													}
												}
												$dateArr = explode("-",$day);
												$dayOfWeek = date("w",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));

												if ( $dayOfWeek == 0 || $dayOfWeek == 6 ) {
													array_push($currRowArray,array('width' => $pdfDayCellWidth."%", 'data' => $allocNumber, 'border' => "LRTB", 'align' => 'C', 'fill' => "1"));
												} else {
													array_push($currRowArray,array('width' => $pdfDayCellWidth."%", 'data' => $allocNumber, 'border' => "LRTB", 'align' => 'C', 'fill' => "0"));
												}
											}
											$pdf->Row($currRowArray);
										}
									}
								}
							} else {
								// Group By Agent only ------------------------------------------------
								if ( isset($agentDetails[$totalType]) && $allocType != "all" ) {
									$currRowArray = array(array('width' => $accommCellWidth . "%", 'data' => $agentName, 'border' => "LRTB", 'align' => "L"));
									if ( $showUnits ) {
										array_push($currRowArray,array('width' => "5%", 'data' => " ", 'border' => 'LRTB', 'align' => 'C'));
									}
									if ( $showTotals ) {
										array_push($currRowArray,array('width' => "5%", 'data' => array_sum($agentDetails[$totalType]), 'border' => 'LRTB', 'align' => 'C'));
									}
									foreach (new LimitIterator(new ArrayIterator($daylist), $startCount, $endCount) as $dayKey => $day ) {
										if ( !array_key_exists($day,$agentDetails[$totalType]) && $allocType != "all" ) {
											$allocNumber = " ";
										} elseif ( !array_key_exists($day,$agentDetails[$totalType]) && $allocType == "all" ) {
											$allocNumber = " ";
										} else {
											$allocNumber = round($agentDetails[$totalType][$day], 0, PHP_ROUND_HALF_UP);
											$dayTotals[$day] += $allocNumber;
										}

										$dateArr = explode("-",$day);
										$dayOfWeek = date("w",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));

										if ( $dayOfWeek == 0 || $dayOfWeek == 6 ) {
											array_push($currRowArray,array('width' => $pdfDayCellWidth."%", 'data' => $allocNumber, 'border' => "LRTB", 'align' => 'C', 'fill' => "1"));
										} else {
											array_push($currRowArray,array('width' => $pdfDayCellWidth."%", 'data' => $allocNumber, 'border' => "LRTB", 'align' => 'C'));
										}
									}
									$pdf->Row($currRowArray);
								} else if ($allocType == "all" ) {
									$currRowArray = array(array('width' => $accommCellWidth . "%", 'data' => $agentName, 'border' => "LRTB", 'align' => "L"));
									$pdf->Row($currRowArray);
									// Show materialisation data
									$allocTypes = array("total", "total_used", "total_balance", "materialisation");
									foreach ($allocTypes as $allocationType) {
										$currRowArray = array();

										// User-friendly name for the allocation type ----------------------------
										$allocName = "   " . getMaterialisationDescription($allocationType);

										$totalAmount = array_sum($agentDetails[$allocationType]);
										$materialisationTotals[$allocationType] = $totalAmount;
                                        $totalMaterialisation = getMaterialisationAmount(getMaterialisationTotalDescription($allocationType), "average_materialisation", $totalAmount, $materialisationTotals['total_used'], $materialisationTotals['total']);

										array_push($currRowArray,array('width' => $accommCellWidth . "%", 'data' => $allocName, 'border' => "LRTB", 'align' => "L"));
										if ( $showUnits ) {
											array_push($currRowArray,array('width' => "5%", 'data' => " ", 'border' => 'LRTB', 'align' => 'C'));
										}
										if ( $showTotals ) {
											array_push($currRowArray,array('width' => "5%", 'data' => $totalMaterialisation, 'border' => 'LRTB', 'align' => 'C'));
										}

										foreach (new LimitIterator(new ArrayIterator($daylist), $startCount, $endCount) as $dayKey => $day ) {
											if ( !array_key_exists($day,$agentDetails[$allocationType]) && $allocType != "allocation_materialisation" ) {
												$allocNumber = " ";
											} else {
												$allocNumber = ($allocationType == "allocation_materialisation" && trim($agentDetails[$allocationType][$day]) == "") ? " " : round($agentDetails[$allocationType][$day], 0, PHP_ROUND_HALF_UP);
												$dayTotals[$day] += $allocNumber != " " ? $allocNumber : 0;
											}
											$dateArr = explode("-",$day);
											$dayOfWeek = date("w",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));

											if ( $dayOfWeek == 0 || $dayOfWeek == 6 ) {
												array_push($currRowArray,array('width' => $pdfDayCellWidth."%", 'data' => $allocNumber, 'border' => "LRTB", 'align' => 'C', 'fill' => "1"));
											} else {
												array_push($currRowArray,array('width' => $pdfDayCellWidth."%", 'data' => $allocNumber, 'border' => "LRTB", 'align' => 'C'));
											}
										}
										$pdf->Row($currRowArray);
									}
								} else {
									array_push($currRowArray,array('width' => $propertyCellWidth - $accommCellWidth - ($showUnits ? 5 : 0) - ($showTotals ? 5 : 0) . "%", 'data' => "No allocations " . $allocRoomsDescription, 'border' => "LRTB", 'align' => "C"));
									$pdf->Row($currRowArray);
								}
							}
						}
					} else {
						if ( $allocRooms > 0 ) {
							// Array to hold data as we process through each agentAllocation for this
							// $accommId ------------------------------------------------------------
							$allocNumberArray = array();

							// Boolean to help decide whether to show data or a message to the effect
							// that this $accommId has no allocation data matching the filters ------
							$typeExists = false;

							// Calculate the unused allocations totals ------------------------------
							$allocTypes = array();
							if ($allocType != "all") {
								$allocTypes = array($totalType);
							} else if ($v['agentAllocation'] && $allocType == "all" ) {
								$allocTypes = array("total", "total_used", "total_balance", "materialisation");
							}
							$materialisationTotals = array();
							foreach ($allocTypes as $allocationType) {
								if ($allocType == "all") {
									foreach ( $v['agentAllocation'] as $agentDetails ) {
										$totalAmount = array_sum($agentDetails[$allocationType]);
										if (!isset($materialisationTotals['total'])) {
											$materialisationTotals['total'] = 0;
										}
										if (!isset($materialisationTotals['total_used'])) {
											$materialisationTotals['total_used'] = 0;
										}
                                        $materialisation = getMaterialisationAmount(getMaterialisationTotalDescription($allocationType), "average_materialisation", $totalAmount, $materialisationTotals['total_used'], $materialisationTotals['total']);
										$materialisationTotals[$allocationType] = isset($materialisationTotals[$allocationType]) && getMaterialisationTotalDescription($allocationType) != "average_materialisation" ? $materialisationTotals[$allocationType] + $materialisation : $materialisation;
									}
								}
								foreach (new LimitIterator(new ArrayIterator($daylist), $startCount, $endCount) as $dayKey => $day ) {
									if (!isset($allocNumberArray[$accommId][$allocationType])) { $allocNumberArray[$accommId][$allocationType] = array(); }

									if(!array_key_exists($day,$allocNumberArray[$accommId])) {
										$allocNumberArray[$accommId][$allocationType][$day] = null;
									}

									if ( $v['agentAllocation'] ) {
										foreach ( $v['agentAllocation'] as $agentDetails ) {
											if (isset($agentDetails[$allocationType])) {
												$typeExists = true;
												if (array_key_exists($day,$agentDetails[$allocationType]) ) {
													if(is_null($allocNumberArray[$accommId][$allocationType][$day])) {
														$allocNumberArray[$accommId][$allocationType][$day] = 0;
													}
													if ($allocationType != "materialisation") {
														$allocNumberArray[$accommId][$allocationType][$day] += $agentDetails[$allocationType][$day];
													} else {
														$allocNumberArray[$accommId][$allocationType][$day] = $agentDetails[$allocationType][$day];
													}
												}
											}
										}
									}
								}
							}

							// Compile totals of all allocationTypes
							$allocationTypeSum = array();
							if (isset($allocNumberArray[$accommId])) {
								foreach($allocNumberArray[$accommId] as $allocationType => $allocationTypeValues) {
									foreach ($allocationTypeValues as $date => $value) {
										if(array_key_exists($date,$allocationTypeSum)) {
											$allocationTypeSum[$date] = $allocationTypeSum[$date] + (($value == "" || $value == null) ? 0 : $value);
										} else {
											$allocationTypeSum[$date] = $value;
										}
									}
								}
							}

							// Now that we have a single array with all the information for
							// this allocation type, we need to step through it to output the
							// data -----------------------------------------------------------
							$currRowArray = array(array('width' => $accommCellWidth . "%", 'data' => $v['accommType'], 'border' => 'LRTB'));

							if ( $showUnits ) {
								array_push($currRowArray,array('width' => "5%", 'data' => $v['units'], 'border' => 'LRTB', 'align' => 'C'));
							}
							if ( $showTotals ) {
								array_push($currRowArray,array('width' => "5%", 'data' => $totalAccommodation, 'border' => 'LRTB', 'align' => 'C'));
							}


							if ( $typeExists ) {
								foreach ($allocTypes as $allocationType) {
									if ($allocType == "all") {
										// User-friendly name for the allocation type ----------------------------
										$allocName = "   " . getMaterialisationDescription($allocationType);

										$totalMaterialisation = $materialisationTotals[$allocationType];

										$currRowArray = array(array('width' => $accommCellWidth . "%", 'data' => $allocName, 'border' => 'LRTB'));

										if ( $showUnits ) {
											array_push($currRowArray,array('width' => "5%", 'data' => " ", 'border' => 'LRTB', 'align' => 'C'));
										}
										if ( $showTotals ) {
											array_push($currRowArray,array('width' => "5%", 'data' => $totalMaterialisation, 'border' => 'LRTB', 'align' => 'C'));
										}
									}
									foreach ( $allocNumberArray[$accommId][$allocationType] as $day => $a ) {
										if ( is_null($a) || $allocationTypeSum[$day] == 0)  {
											$a = " ";
										} else {
											$a = round($a, 0, PHP_ROUND_HALF_UP);
											$dayTotals[$day] += $a;
										}

										$dateArr = explode("-",$day);
										$dayOfWeek = date("w",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));

										if ( $dayOfWeek == 0 || $dayOfWeek == 6 ) {
											array_push($currRowArray,array('width' => $pdfDayCellWidth."%", 'data' => $a, 'border' => "LRTB", 'align' => 'C', 'fill' => "1"));
										} else {
											array_push($currRowArray,array('width' => $pdfDayCellWidth."%", 'data' => $a, 'border' => "LRTB", 'align' => 'C'));
										}
									}
									$pdf->Row($currRowArray);
								}
							} else {
								array_push($currRowArray,array('width' => $propertyCellWidth - $accommCellWidth - ($showUnits ? 5 : 0) - ($showTotals ? 5 : 0) . "%", 'data' => "No allocations " . $allocRoomsDescription, 'border' => "LRTB", 'align' => "C"));
								$pdf->Row($currRowArray);
							}
						} else {
							// No allocation grouping. Just show the total allocations per day
							// for each accommodation type. -------------------------------------
							$allocationType = $totalType;
							$allocationTypeSum = array();
							foreach (new LimitIterator(new ArrayIterator($daylist), $startCount, $endCount) as $dayKey => $day) {
								$allocationTypeSum[$day] = 0;
								if (!isset($allocNumberArray[$accommId][$allocationType])) { $allocNumberArray[$accommId][$allocationType] = array(); }

								if(!array_key_exists($day,$allocNumberArray[$accommId])) {
									$allocNumberArray[$accommId][$allocationType][$day] = null;
								}

								if ($v['agentAllocation']) {
									foreach ( $v['agentAllocation'] as $agentDetails ) {
										if (isset($agentDetails[$allocationType])) {
											if(array_key_exists($day,$agentDetails[$allocationType]) ) {
												if(is_null($allocNumberArray[$accommId][$allocationType][$day])) {
													$allocNumberArray[$accommId][$allocationType][$day] = 0;
												}
												$allocNumberArray[$accommId][$allocationType][$day] += $agentDetails[$allocationType][$day];
											}
										}
									}
								}
							}

							if (isset($allocNumberArray[$accommId])) {
								foreach($allocNumberArray[$accommId] as $allocationType => $allocationTypeValues) {
									foreach (new LimitIterator(new ArrayIterator($allocationTypeValues), $startCount, $endCount) as $date => $value) {
										$allocationTypeSum[$date] = $allocationTypeSum[$date] + (($value == "" || $value == null) ? 0 : $value);
									}
								}
							}
							$currRowArray = array(array('width' => $accommCellWidth . "%", 'data' => "  ".$v['accommType'], 'border' => 'LRTB'));

							if ( $showUnits ) {
								array_push($currRowArray,array('width' => "5%", 'data' => $v['units'], 'border' => 'LRTB', 'align' => 'C'));
							}
							if ( $showTotals ) {
								array_push($currRowArray,array('width' => "5%", 'data' => $v['sum_total'], 'border' => 'LRTB', 'align' => 'C'));
							}
							foreach ($allocationTypeSum as $allocDate => $allocNumber) {
								$dateArr = explode("-",$allocDate);
								$dayOfWeek = date("w",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));

								if ( $allocNumber == 0 ) {
									$allocNumber = " ";
								} else if (isset($dayTotals[$allocDate])) {
									$dayTotals[$allocDate] += $allocNumber;
								}

								if ( $dayOfWeek == 0 || $dayOfWeek == 6 ) {
									array_push($currRowArray,array('width' => $pdfDayCellWidth."%", 'data' => $allocNumber, 'border' => "LRTB", 'align' => "C", 'fill' => "1"));
								} else {
									array_push($currRowArray,array('width' => $pdfDayCellWidth."%", 'data' => $allocNumber, 'border' => "LRTB", 'align' => "C"));
								}
							}
							$pdf -> Row($currRowArray);
						}
					}
				}
				if (!empty($accommIds) && $allocRooms != 3) {
					$pdf->SetFont('Arial', 'B', $pdfFontSize);
					$pdf->Row(generateTotalsFooter(
						$dayTotals,
						$renderMode,
						array('showUnits'=>$showUnits,'showTotals'=>$showTotals),
						array('propertyCellWidth'=>$propertyCellWidth,'accommCellWidth'=>$accommCellWidth,'pdfDayCellWidth'=>$pdfDayCellWidth)
					));
					$pdf->SetFont('Arial', '', $pdfFontSize);
				}
				// Main Content : END -------------------------------------------------------
				$pdf -> Ln(4);
				if ( $pageBreaks == 'true' && ($pdfPage != $totalPages) ) {
					$pdf -> addPage();
				}
			}
		}
		// Parameter Bar : START ----------------------------------------------------
		$pdf -> Ln(8);

		$paramRow = array();
		array_push($paramRow,array('width' => "72.7%", 'data' => "", 'border' => "", 'align' => "C"));

		foreach($paramBar as $k => $v) {
			if($v == 1) {
				array_push($paramRow,array('width' => "3%", 'data' => $k, 'border' => "LRTB", 'align' => "C", 'fill' => '1'));
			} else {
				array_push($paramRow,array('width' => "3%", 'data' => $k, 'border' => "LRTB", 'align' => "C"));
			}
		}
		$pdf -> Row($paramRow);
		// Parameter Bar : END ------------------------------------------------------

		// Standard Parameters ------------------------------------------------------
		if ( $showParameters == 1 ) {
			$pdf->ReportHeader($reportLabel, $headerArray);
		}

		if ( $renderType == "view" ) {
			$pdf->OutPut();
			die();
		}

		if ( $renderType == "send" ) {
			$to = $_POST['mail_to'];
			$from = $_POST['mail_from'];
			$subject = stripslashes($_POST['mail_subj']);
			$message = stripslashes($_POST['mail_body']);
			$attachmentName = $_POST['attachmentName'];
			$GLOBALS['princName'] = (isset($GLOBALS['princName']) ? $GLOBALS['princName'] : $from);

			$headers = "From: " . $GLOBALS['princName'] . "<$from>\r\n";

			if ( $pdf->state < 3 ) {
				$pdf->Close();
			}

			// Mail the PDF ------------------------------------------------------------
			if ( $attachmentName != "!attachmentName!" ) {
				$pdfName = $attachmentName;
			} else {
				$pdfName = "Update report from " . $fromDate . " to " . $toDate . ".pdf";
			}

			// (from, to, subject, headers, message, action, emailID, resID) -----------
			$error = email($from, $to, $subject, $headers, $message, 0, 0, $fromDateArgv, $GLOBALS['princName'],$pdf->buffer,$pdfName);

			if ( !$error ) {
				echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
				die();
			} else {
				echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
				die();
			}
		}
	}
	/* PDF REPORT : END ------------------------------------------------------ */

	/* CSV REPORT : START ---------------------------------------------------- */
	if ( $renderMode == "csv" ) {
		$csvFile = array();
		array_push($csvFile,array("Allocation Summary Report"));
		array_push($csvFile,array());
		array_push($csvFile,array("Date Range",$fromDate['htmlDate'] . " to " . $toDate['htmlDate']));

		$csvHeadPropertyFilter 			= implode(" ", $propertyNames);
		$csvHeadAccommodationFilter = implode(" ", $accommNames);

		switch ( $detailLevel ) {
		case 0:
			$csvHeadGroupByFilter = "All";
			break;
		case 1:
			$csvHeadGroupByFilter = "Agent";
			break;
		case 2:
			$csvHeadGroupByFilter = "Agent and Allocation";
			break;
		}

		switch ( $allocRooms ) {
		case 0:
			$csvHeadAllocatedRoomsFilter = "Allocated";
			break;
		case 1:
			$csvHeadAllocatedRoomsFilter = "Used";
			break;
		case 2:
			$csvHeadAllocatedRoomsFilter = "Balance";
			break;
		case 3:
			$csvHeadAllocatedRoomsFilter = "Materialisation";
			break;
		}

		$csvHeadShowUnits = ($showUnits == 'true') ? "Yes" : "No";
		$csvHeadShowTotals = ($showTotals == 'true') ? "Yes" : "No";

		array_push($csvFile,array("Property filter:",$csvHeadPropertyFilter));
		array_push($csvFile,array("Accommodation types:",$csvHeadAccommodationFilter));
		array_push($csvFile,array("Allocated rooms:",$csvHeadAllocatedRoomsFilter));
		array_push($csvFile,array("Group by:",$csvHeadGroupByFilter));
		array_push($csvFile,array("Show unit totals:",$csvHeadShowUnits));
		array_push($csvFile,array("Show total allocations:",$csvHeadShowTotals));

		array_push($csvFile,array());

		list($accommIds,$daylist) = calculateAllocations($accommDetails,$fromDate['jsDate'],$toDate['jsDate'],$agentFilter['ids'],$showExpiredAllocations,$detailLevel,$allocRooms,$agentIdArray,$allocationList);

		switch ( $allocRooms ) {
		case 0:
			$allocType = "allocation";
			$totalType = "total";
			$allocRoomsDescription = "";
			break;
		case 1:
			$allocType = "allocation_used";
			$totalType = "total_used";
			$allocRoomsDescription = "used";
			break;
		case 2:
			$allocType = "allocation_balance";
			$totalType = "total_balance";
			$allocRoomsDescription = "remaining";
			break;
		case 3:
			$allocType = "all";
			$totalType = "materialisation";
			$allocRoomsDescription = "";
			break;
		}

		// Year & Month Row : START -------------------------------------------------
		$yearMonthArray = array('','');

		if ( $showUnits ) {
			array_push($yearMonthArray," ");
		}
		if ( $showTotals ) {
			array_push($yearMonthArray," ");
		}

		if ( $detailLevel > 1 ) {
			array_push($yearMonthArray," ");
		}

		$firstAccommId = reset($accommIds);
		$dayTotals = array();
		foreach ( $firstAccommId['allocation'] as $k => $v ) {
			$dayTotals[$k] = 0;
			$dateArr 	= explode("-",$k);
			$Month 		= date("M",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));
			$Year 		= date("Y",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));

			$yearMonth = $Month . " " . $Year;
			array_push($yearMonthArray,$yearMonth);
		}
		array_push($csvFile,$yearMonthArray);
		// Year & Month Row : END   -------------------------------------------------

		// Day Letter Row : START ---------------------------------------------------
		$dayRowArray = array("","");

		if ( $showUnits ) {
			array_push($dayRowArray,"");
		}
		if ( $showTotals ) {
			array_push($dayRowArray,"");
		}

		if ( $detailLevel > 1 ) {
			array_push($dayRowArray,"");
		}

		foreach ( $firstAccommId['allocation'] as $k => $v ) {
			$dateArr = explode("-",$k);
			$dayOfWeek = date("w",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));
			$dayLetter = date("D",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));

			array_push($dayRowArray,$dayLetter);
		}
		array_push($csvFile,$dayRowArray);
		// Day Letter Row : END -----------------------------------------------------

		// Day Number Row : START ---------------------------------------------------
		$dayNumberRowArray = array('','');

		if ( $showUnits ) {
			array_push($dayNumberRowArray,'Units');
		}
		if ( $showTotals ) {
			array_push($dayNumberRowArray,'Totals');
		}

		if ( $detailLevel > 1 ) {
			array_push($dayNumberRowArray,"");
		}

		foreach ( $firstAccommId['allocation'] as $k => $v ) {
			$dateArr = explode("-",$k);
			$dayOfWeek = date("w",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));
			$dayNumber = date("j",mktime(0,0,0,$dateArr[1],$dateArr[2],$dateArr[0]));

			array_push($dayNumberRowArray,$dayNumber);
		}
		array_push($csvFile,$dayNumberRowArray);
		// Day Number Row : END -----------------------------------------------------

		// Main Content : START -----------------------------------------------------
		$propertyName = "";
		generateTotals($accommIds);
		foreach ( $accommIds as $accomKey => $v ) {
			$accommId = $v['ac_accomm_type_ix'];
			$accommArray = array();
			if ( $propertyName != $v['propertyName'] ) {
				$propertyName = $v['propertyName'];
				array_push($accommArray,$v['propertyName']);
			} else {
				array_push($accommArray,"");
			}

			if ($showUnits || $showTotals) {
				array_push($accommArray,$v['accommType']);
				if ($showUnits) {
					array_push($accommArray,$v['units']);
				}
				if ($showTotals) {
					$totalAccommodation = 0;
					switch ($allocRooms) {
						case 0:
							$totalAccommodation = $accommIds[$accomKey]['sum_total'];
							break;
						case 1:
							$totalAccommodation = $accommIds[$accomKey]['sum_used'];
							break;
						case 2:
							$totalAccommodation = $accommIds[$accomKey]['sum_balance'];
							break;
						case 3:
						default:
							$totalAccommodation = $accommIds[$accomKey]['sum_total'];
							break;
					}
					array_push($accommArray,$totalAccommodation);
				}
			} else {
				array_push($accommArray,$v['accommType']);
			}
			if ( $detailLevel > 0 ) {
				array_push($csvFile,$accommArray);
			}

			if ( $detailLevel > 0 ) {
				// Allocations are grouped by either Agent or they are to be listed
				// seperately. --------------------------------------------------------
				foreach ( $v['agentAllocation'] as $agentDetails ) {
					$row = array();
					array_push($row,"");
					if ($agentName != $agentDetails['pr_name_last']) {
						$agentName = $agentDetails['pr_name_last'];
						array_push($row,$agentName);
						if ($showTotals) {
							$totalAgent = $agentDetails['sum_total'];
							array_push($row,$totalAgent);
						}
					}
					if ($showUnits) {
						array_push($row,"");
					}
					if ($showTotals) {
						array_push($row,"");
					}
					if ($allocRooms == 3) {
						// Adjust for materialisation view
						array_push($csvFile,$row);
					}

					if ( $detailLevel > 1 ) {

						// Results grouped by agent and allocation ----------------------------

						// Display the overall totals for the agent : START -------------------
						if ($allocRooms != 3) {
							if ( $agentDetails[$totalType] ) {
								foreach ( $daylist as $dayKey => $day ) {
									if ( !array_key_exists($day,$agentDetails[$totalType]) ) {
										$allocNumber = " ";
									} else {
										$allocNumber = $agentDetails[$totalType][$day];
										$dayTotals[$day] += $allocNumber != " " ? $allocNumber : 0;
									}

									array_push($row,$allocNumber);
								}
								array_push($csvFile,$row);
							}
						}

						// Display each allocation item : START -------------------------
						if ( isset($agentDetails[$allocType]) ) {
							foreach ( $agentDetails[$allocType] as $allocID ) {
								$row = array();

								$allocName = $allocID['rv_res_name'];
								if (trim($allocName) != "") {
									array_push($row,"");
									if (!empty($allocID['bl_block_abbrev'])) {
										$allocName = $allocID['bl_block_abbrev'] . ": " . $allocName;
									}

									array_push($row,$allocName);
									$totalAllocation = $allocID['sum_total'];
									array_push($row,$totalAllocation);
									if ($showUnits) {
										array_push($row,"");
									}
									if ($showTotals) {
										array_push($row,"");
									}

									foreach ( $daylist as $dayKey => $day ) {
										if ( !isset($allocID['occupancy'][$day]) ) {
											$allocNumber = " ";
										} else {
											$allocNumber = $allocID['occupancy'][$day];
										}
										array_push($row,$allocNumber);
									}
									array_push($csvFile,$row);
								}
							}
						} else if ( $allocType == "all" ) {
							// Show materialisation data
							$allocTypes = array("allocation", "allocation_used", "allocation_balance", "allocation_materialisation");
							foreach ( $agentDetails["allocation_materialisation"] as $allocationId => $allocData ) {
								$materialisationTotals = array();
								foreach ($allocTypes as $allocationType) {
									$currRowArray = array();
									$allocID = isset($agentDetails[$allocationType][$allocationId]) ? $agentDetails[$allocationType][$allocationId] : array();
									if (in_array($allocationType, array("allocation"))) {
										$allocationName = $allocID['rv_res_name'];
										if (!empty($allocID['bl_block_abbrev'])) {
											$allocationName = $allocID['bl_block_abbrev'] . ": " . $allocationName;
										}
										array_push($currRowArray,"");
										array_push($currRowArray,$allocationName);
										array_push($csvFile,$currRowArray);
										$currRowArray = array();
										array_push($currRowArray,"");
									} else {
										array_push($currRowArray,"");
									}
									// User-friendly name for the allocation ----------------------------
									$allocName = "   " . getMaterialisationDescription($allocationType);
									$totalMaterialisation = 0;
									if ($detailLevel == 2) {
										if ($allocationType != "allocation_materialisation" && isset($agentDetails[$allocationType][$allocationId])) {
											$totalAmount = $agentDetails[$allocationType][$allocationId]['sum_total'];
										} else {
											$totalAmount = 0;
										}
										$materialisationTotals[$allocationType] = $totalAmount;
                                        $totalMaterialisation = getMaterialisationAmount(getMaterialisationTotalDescription($allocationType), "allocation_materialisation", $totalAmount, $materialisationTotals['allocation_used'], $materialisationTotals['allocation']);
									} else {
										$totalAmount = array_sum($agentDetails[$allocationType]);
										$materialisationTotals[$allocationType] = $totalAmount;
                                        $totalMaterialisation = getMaterialisationAmount(getMaterialisationTotalDescription($allocationType), "average_materialisation", $totalAmount, $materialisationTotals['total_used'], $materialisationTotals['total']);
									}
									array_push($currRowArray,$allocName);
									if ($showUnits) {
										array_push($currRowArray,"");
									}
									if ($showTotals) {
										array_push($currRowArray,$totalMaterialisation);
									}
									if ( $detailLevel > 0 ) {
										array_push($currRowArray,"");
									} elseif ( $detailLevel > 1 ) {
										array_push($currRowArray,"");
									}

									foreach ( $daylist as $dayKey => $day ) {
										$hasValues = false;
										foreach ($allocTypes as $at) {
											if (isset($agentDetails[$at][$allocationId]['occupancy'][$day])) {
												if ($agentDetails[$at][$allocationId]['occupancy'][$day] != 0) {
													$hasValues = true;
												}
											}
										}
										if ( !isset($allocID['occupancy']) || (!array_key_exists($day,$allocID['occupancy']) && $allocType != "allocation_materialisation" )) {
											if ($hasValues) {
												$allocNumber = 0;
											} else {
												$allocNumber = " ";
											}
										} else {
											$allocNumber = ($allocationType == "allocation_materialisation" && trim($allocID['occupancy'][$day]) == "") ? "&npsp;" : round($allocID['occupancy'][$day], 0, PHP_ROUND_HALF_UP);
											$dayTotals[$day] += $allocNumber != "&nbsp;" ? $allocNumber : 0;
										}
										array_push($currRowArray,$allocNumber);
									}
									array_push($csvFile,$currRowArray);
								}
							}
						}
					} else {
						// Group By Agent only ------------------------------------------
						if ( isset($agentDetails[$totalType]) && $allocType != "all" ) {
							$row = array();
							array_push($row,"");

							$agentName = $agentDetails['pr_name_last'];
							array_push($row,$agentName);
							if ( $showUnits ) {
								array_push($row,"");
							}
							$totalAgent = $agentDetails['sum_total'];
							array_push($row,$totalAgent);

							foreach ( $daylist as $dayKey => $day ) {
								if ( !array_key_exists($day,$agentDetails[$totalType]) ) {
									$allocNumber = " ";
								} else {
									$allocNumber = $agentDetails[$totalType][$day];
									$dayTotals[$day] += $allocNumber;
								}
								array_push($row,$allocNumber);
							}
							array_push($csvFile,$row);
						} else if ($allocType == "all" ) {
							// Show materialisation data
							$allocTypes = array("total", "total_used", "total_balance", "materialisation");
							foreach ($allocTypes as $allocationType) {
								$currRowArray = array();

								// User-friendly name for the allocation type ----------------------------
								array_push($currRowArray,"");
								$allocName = "   " . getMaterialisationDescription($allocationType);
								array_push($currRowArray,$allocName);

								if ( $showUnits ) {
									array_push($currRowArray,"");
								}
								if ( $showTotals ) {
									$totalAmount = array_sum($agentDetails[$allocationType]);
									$materialisationTotals[$allocationType] = $totalAmount;
                                    $totalMaterialisation = getMaterialisationAmount(getMaterialisationTotalDescription($allocationType), "average_materialisation", $totalAmount, $materialisationTotals['total_used'], $materialisationTotals['total']);
									array_push($currRowArray,$totalMaterialisation);
								}

								foreach ( $daylist as $dayKey => $day ) {
									if ( !array_key_exists($day,$agentDetails[$allocationType]) && $allocType != "allocation_materialisation" ) {
										$allocNumber = " ";
									} else {
										$allocNumber = ($allocationType == "allocation_materialisation" && trim($agentDetails[$allocationType][$day]) == "") ? "&npsp;" : round($agentDetails[$allocationType][$day], 0, PHP_ROUND_HALF_UP);
										$dayTotals[$day] += $allocNumber != "&nbsp;" ? $allocNumber : 0;
									}
									array_push($currRowArray,$allocNumber);
								}
								array_push($csvFile,$currRowArray);
							}
						}
					}
				}
			} else {
				if ( $allocRooms > 0 ) {
					// Array to hold data as we process through each agentAllocation
					// for this $accommId -------------------------------------------
					$allocNumberArray = array();

					// Boolean to help decide whether to show data or a message to the
					// effect that this $accommId has no allocation data matching the
					// filters --------------------------------------------------------
					$typeExists = false;

					$allocTypes = array();
					if ($allocType != "all") {
						$allocTypes = array($totalType);
					} else if ($v['agentAllocation'] && $allocType == "all" ) {
						$allocTypes = array("total", "total_used", "total_balance", "materialisation");
					}
					// Calculate the unused allocations totals ------------------------
					foreach ($allocTypes as $allocationType) {
						foreach ( $daylist as $dayKey => $day ) {
							if (!isset($allocNumberArray[$accommId][$allocationType])) { $allocNumberArray[$accommId][$allocationType] = array(); }

							if(!array_key_exists($day,$allocNumberArray[$accommId])) {
								$allocNumberArray[$accommId][$allocationType][$day] = null;
							}

							if ( $v['agentAllocation']) {
								foreach ( $v['agentAllocation'] as $agentDetails ) {
									if (isset($agentDetails[$allocationType])) {
										$typeExists = true;
										if(array_key_exists($day,$agentDetails[$allocationType]) ) {
											if(is_null($allocNumberArray[$accommId][$allocationType][$day])) {
												$allocNumberArray[$accommId][$allocationType][$day] = 0;
											}
											if ($allocationType != "materialisation") {
												$allocNumberArray[$accommId][$allocationType][$day] += $agentDetails[$allocationType][$day];
											} else {
												$allocNumberArray[$accommId][$allocationType][$day] = $agentDetails[$allocationType][$day];
											}
										}
									}
								}
							}
						}
					}

					// Compile totals of all allocationTypes
					$allocationTypeSum = array();
					if (isset($allocNumberArray[$accommId])) {
						foreach($allocNumberArray[$accommId] as $allocationType => $allocationTypeValues) {
							foreach ($allocationTypeValues as $date => $value) {
								if(array_key_exists($date,$allocationTypeSum)) {
									$allocationTypeSum[$date] = $allocationTypeSum[$date] + (($value == "" || $value == null) ? 0 : $value);
								} else {
									$allocationTypeSum[$date] = $value;
								}
							}
						}
					}

					$materialisationTotals = array();

					// Now that we have a single array with all the information for
					// this allocation type, we need to step through it to output the
					// data -----------------------------------------------------------
					if ($allocRooms < 3) {
						$row = $accommArray;
					} else {
						array_push($csvFile,$accommArray);
					}

					if ( $typeExists ) {
						foreach ($allocTypes as $allocationType) {
							if ($allocType == "all") {
								$row = array();
								array_push($row, "");
								// User-friendly name for the allocation type ----------------------------
								$allocName = getMaterialisationDescription($allocationType);
								if (!isset($materialisationTotals['total_used'])) {
									$materialisationTotals['total_used'] = 0;
								}
								$totalAmount = array_sum($allocNumberArray[$accommId][$allocationType]);
								$materialisationTotals[$allocationType] = $totalAmount;
                                $totalMaterialisation = getMaterialisationAmount(getMaterialisationTotalDescription($allocationType), "average_materialisation", $totalAmount, $materialisationTotals['total_used'], $materialisationTotals['total']);
								array_push($row,$allocName);
								array_push($row,$totalMaterialisation);

							}
							foreach ( $allocNumberArray[$accommId][$allocationType] as $date => $a ) {
								if ( is_null($a) || $allocationTypeSum[$date] == 0)  {
									$a = "";
								} else {
									$a = round($a, 0, PHP_ROUND_HALF_UP);
									$dayTotals[$date] += $a;
								}
								array_push($row,$a);
							}
							array_push($csvFile,$row);
						}
					} else {
						if ($allocType == "all") {
							array_push($row,$allocRoomsDescription);
							array_push($csvFile,$row);
						}
					}
				} else {
					// No allocation grouping. Just show the total allocations per day for
					// each accommodation type. -------------------------------------------
					$row = $accommArray;
					$allocationType = $totalType;
					$allocationTypeSum = array();
					foreach ($daylist as $dayKey => $day) {
						$allocationTypeSum[$day] = 0;
						if (!isset($allocNumberArray[$accommId][$allocationType])) { $allocNumberArray[$accommId][$allocationType] = array(); }

						if(!array_key_exists($day,$allocNumberArray[$accommId])) {
							$allocNumberArray[$accommId][$allocationType][$day] = null;
						}

						if ($v['agentAllocation']) {
							foreach ( $v['agentAllocation'] as $agentDetails ) {
								if (isset($agentDetails[$allocationType])) {
									if(array_key_exists($day,$agentDetails[$allocationType]) ) {
										if(is_null($allocNumberArray[$accommId][$allocationType][$day])) {
											$allocNumberArray[$accommId][$allocationType][$day] = 0;
										}
										$allocNumberArray[$accommId][$allocationType][$day] += $agentDetails[$allocationType][$day];
									}
								}
							}
						}
					}

					if (isset($allocNumberArray[$accommId])) {
						foreach($allocNumberArray[$accommId] as $allocationType => $allocationTypeValues) {
							foreach ($allocationTypeValues as $date => $value) {
								$allocationTypeSum[$date] = $allocationTypeSum[$date] + (($value == "" || $value == null) ? 0 : $value);
							}
						}
					}

					foreach ($allocationTypeSum as $allocDate => $allocNumber) {
						if ( $allocNumber == 0 ) {
							$allocNumber = " ";
						} else if (isset($dayTotals[$allocDate])) {
							$dayTotals[$allocDate] += $allocNumber;
						}
						array_push($row,$allocNumber);
					}
					array_push($csvFile,$row);
				}
			}
		}
		if (!empty($accommIds) && $allocRooms != 3) {
			array_push($csvFile, generateTotalsFooter(
				$dayTotals,
				$renderMode,
				array('showUnits'=>$showUnits,'showTotals'=>$showTotals,'allocRooms'=>$allocRooms)
			));
		}
		// Main Content : END -------------------------------------------------------

		$csvText = "";

		foreach ( $csvFile as $csvLine ) {
			$first = true;

			foreach ( $csvLine as $csvItem ) {
				if ( !$first ) {
					$csvText .= ",";
				} else {
					$first = false;
				}
				$csvText .= "\"".str_replace("\"","\"\"",$csvItem)."\"";
			}
			$csvText .= "\n";
		}

		header('Content-Type: text/csv');
		header("Cache-control: private");
		header('Content-Length: '.strlen($csvText));
		$filename = str_replace(" ","_",strtolower("allocation_summary_report_".$fromDate['htmlDate'] . " to " . $toDate['htmlDate'] . ".csv"));
		header("Content-Disposition: inline; filename=$filename");
		echo $csvText;

		flush();
		die();
	}
	// [ END ] CSV Report --------------------------------------------------------
}

$GLOBALS['temp']['SAServer'] = $GLOBALS['SAServer'];
$GLOBALS['temp']['USServer'] = $GLOBALS['USServer'];
$GLOBALS['temp']['EUServer'] = $GLOBALS['EUServer'];
// Print Header Setup ---------------------------------------------------------
$GLOBALS['temp']['genDate'] = chng_date(date("Y-m-d"),"-")." ".date("H:i:s");
$GLOBALS['temp']['printEnv'] = $GLOBALS['dbcode'];
$GLOBALS['temp']['printUser'] = $GLOBALS['firstname'] . " " . $GLOBALS['lastname'];
$GLOBALS['temp']['printServer'] = $GLOBALS['domain'];
$GLOBALS['temp']['printPage'] = $page;
$GLOBALS['temp']['hideColumns'] = json_encode($hideColumns);
$GLOBALS['temp']['noData'] = "";

$propertyNameList = empty($propertyNames) ? "All" : implode(', ',$propertyNames);
$accommNamesList = empty($accommNames) ? "All" : implode(', ',$accommNames);
$GLOBALS['temp']['propertiesNames'] = $propertyNameList;
$GLOBALS['temp']['accommodationNames'] = $accommNamesList;

if (empty($accommIds)) {
	$GLOBALS['temp']['noData'] = "true";
}
