<?php
/*
 * init.form342.php - Allocation List Report
 * Job: 266
 * Function: 99
*/
if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
	$GLOBALS['temp']['url'] = $_POST['url'];
}

$pf_object_id = db_pf_object_by_name("allocation_report");
processProfileAction($pf_object_id,$profileFields);

$pf_option_id = applyProfile($pf_object_id,$profileFields);
$title = db_pf_option_get_title($pf_option_id);
if(trim($title) == "") {
	$title = "Allocation List Report";
}
$GLOBALS['temp']['title'] = $title;

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id, $pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();

$_SERVER['argv'] = array_pad($_SERVER['argv'],13,"");
$jobId 							= $_SERVER['argv'][0];
$startDateArgv 					= $_SERVER['argv'][1];
$endDateArgv 					= $_SERVER['argv'][2];
$agentArgv 						= $_SERVER['argv'][3];
$propertyFilterArgv 			= $_SERVER['argv'][4];
$accommFilterArgv 				= $_SERVER['argv'][5];
$consultantFilterArgv 			= $_SERVER['argv'][6];
$options 						= $_SERVER['argv'][7];
$filterStatus 					= $_SERVER['argv'][8];
$showHideButtonText 			= $_SERVER['argv'][9];
$allocationNumber 				= $_SERVER['argv'][10];
$expiredAllocationsArgv 		= $_SERVER['argv'][11];
$orderDetailsArgv 				= $_SERVER['argv'][12];

// Form setup -----------------------------------------------------------------
if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_allocation_list.htm");
}

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));

$GLOBALS['temp']['rows'] = "";

$GLOBALS['temp']['jobId'] = "<input type=\"hidden\" id=\"jobId\" name=\"jobId\" value=\"" . $jobId . "\" />";

$GLOBALS['temp']['today'] = chng_date(date("Y-m-d"),"-");
$GLOBALS['temp']['propertyFilter'] = "colLt";
$GLOBALS['temp']['hideButts'] = "collapse printCollapse";

// Allocation number ----------------------------------------------------------
$GLOBALS['temp']['allocationNumber'] = "";

if ( array_key_exists("url",$_POST) ) {
	$GLOBALS['temp']['allocationNumber'] = $allocationNumber;	
}
// Allocation number ----------------------------------------------------------

/* BUG #5484 : START ----------------------------------------------------------
Reports to hide filters by default
---------------------------------------------------------------------------- */	

$GLOBALS['temp']['filterStatus'] = urldecode($filterStatus);
$GLOBALS['temp']['showHideButtonText'] = $showHideButtonText;
$GLOBALS['temp']['showReport'] = "collapse printCollapse";

if ( $filterStatus == "" ) {
	$GLOBALS['temp']['filterStatus'] = "";
}

if ( $showHideButtonText == "" ) {
	$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
}

if ( $_SERVER['argc'] > 1 && $propertyFilterArgv != "fromCal" ) {
	if ( $filterStatus == "" ) {
		$GLOBALS['temp']['filterStatus'] 				= "collapse printCollapse";
		$GLOBALS['temp']['showHideButtonText'] 	= ">> Show Filters";
	}
	$GLOBALS['temp']['showReport'] = "";
}
// BUG #5484: END -------------------------------------------------------------

// Date range -----------------------------------------------------------------
if ( $_SERVER['argc'] > 1 || ($startDateArgv != "" && $endDateArgv != "")) {
	$startDate 	= useDate("from",$startDateArgv);
	$endDate 		= useDate("to", $endDateArgv);

	$GLOBALS['temp']['fromDate'] 	= $startDate['jsDate'];
	$GLOBALS['temp']['toDate'] 		= $endDate['jsDate'];

	$GLOBALS['temp']['fromD'] = $startDate['dateArray'][2];
	$GLOBALS['temp']['fromM'] = $startDate['dateArray'][1];
	$GLOBALS['temp']['fromY'] = $startDate['dateArray'][0];

	$GLOBALS['temp']['toD'] = $endDate['dateArray'][2];
	$GLOBALS['temp']['toM'] = $endDate['dateArray'][1];
	$GLOBALS['temp']['toY'] = $endDate['dateArray'][0];
} else {
	// Populate the dropdowns with today's date
	$defaultDay		= date("d");
	$defaultMonth = date("m");
	$defaultYear	= date("Y");
	
	$GLOBALS['temp']['fromD'] = $defaultDay;
	$GLOBALS['temp']['fromM'] = $defaultMonth;
	$GLOBALS['temp']['fromY'] = $defaultYear;

	$GLOBALS['temp']['toD'] = $defaultDay;
	$GLOBALS['temp']['toM'] = $defaultMonth;
	$GLOBALS['temp']['toY'] = $defaultYear;
}

// Agent Filter ---------------------------------------------------------------
$agentACL = $lDB->get("
	SELECT 
		pr_agent.pr_agent_id
	FROM
		pr_agent
	WHERE
		pr_agent.pr_agent_inactive_yn = 0
",3);

$agentFilter = useFilter("agent",$agentArgv,"SELECT pr_persona.pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix =","pr_agent.pr_agent_id",$agentACL,false,false);

// Access control for property filter -----------------------------------------
$propertyACL = $lDB->get("
	SELECT DISTINCT
		ac_accomm_type.pr_business_id 
	FROM 
		sc_accomm, ac_accomm_type, 
		pr_business, pr_persona 
	WHERE 
		sc_accomm.sc_group_id= '" . $GLOBALS['sc_group_id'] . "' 
	AND 
		sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
	AND 
		ac_accomm_type.ac_accomm_type_inactive_yn = 0 
	AND 
		ac_accomm_type.pr_business_id = pr_business.pr_business_id 
	AND 
		pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
",3);

$propertyFilter = useFilter("properties",$propertyFilterArgv,"SELECT pr_persona.pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix =","ac_accomm_type.pr_business_id",$propertyACL,false,false);

// Access Control for Accommodation filter ------------------------------------
$accommACL= $lDB->get("
	SELECT DISTINCT
		ac_accomm_type.ac_accomm_type_ix
	FROM
		sc_accomm, ac_accomm_type
	WHERE
		sc_accomm.sc_group_id= '" . $GLOBALS['sc_group_id'] . "'
	AND 
		sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
",3);

$accommFilter = useFilter("accomm",$accommFilterArgv,"SELECT CONCAT(ac_accomm_type.ac_accomm_desc,CONCAT(' - ',pr_business.pr_bus_name_short)) FROM ac_accomm_type INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id WHERE ac_accomm_type_ix =","ac_accomm_type.ac_accomm_type_ix",$accommACL,false,false);

// Consultant Filter ----------------------------------------------------------
$consultantFilter = useFilter("consultant",$consultantFilterArgv,"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_consultant_id",false,"No consultant","0");

// Build the accommodation and property filter SQL
$accommIds = $lDB -> get("
	SELECT 
		ac_accomm_type.ac_accomm_type_ix,
		ac_accomm_type.ac_accomm_desc AS accommType,
		pr_persona.pr_name_last AS propertyName	
	FROM
		ac_accomm_type
	INNER JOIN pr_business ON
		pr_business.pr_business_id = ac_accomm_type.pr_business_id
	INNER JOIN pr_persona ON
		pr_persona.pr_persona_ix = pr_business.pr_business_id
	WHERE
		1 " . $propertyFilter['where'] . " " .  $accommFilter['where'] . "
	ORDER BY
		pr_business.pr_business_sequence, 
		ac_accomm_type.ac_accomm_sequence
",2);

// Include expired allocations checkbox ---------------------------------------
$GLOBALS['temp']['checkExpiredAllocations'] = "checked=\"checked\'";

// Set up the "Previous Report" $_SESSION variable ----------------------------
if ( $_SERVER['argc'] > 1 ) {
	setLastReport("reservation.php?" . join("+",$_SERVER['argv']));
}

// Renderoption (HTML, PDF, CSV etc.) -----------------------------------------

switch ( $options & 7 ) {
   case REP_VIEW_HTML:
      $renderMode = "html";
      $renderType = "";
      break;
   case REP_VIEW_PDF:
      $renderMode = "pdf";
      $renderType = "view";
      break;
   case REP_EMAIL_PDF:
      $renderMode = "pdf";
      $renderType = "email";
      break;
   case REP_SEND_PDF:
      $renderMode = "pdf";
      $renderType = "send";
      break;
   case REP_VIEW_CSV:
      $renderMode = "csv";
      $renderType = "";
}

if ( $renderMode == "pdf" && $renderType == "email" ) {
	$pdfName = "Allocation List Report - " . $startDate['htmlDate'] . " to " . $endDate['htmlDate'];
	$attachmentTable = "
		<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\" alt=\"\" /></td>
			<td id=\"attachmentLabel\" width=\"100%\">" . $pdfName . ".pdf</td>
		</tr>
		</table>
	";
	$newOptions = ($options & ~7) + 3;
	
	$formAction = "reservation.php?" . join("+",array_slice($_SERVER['argv'],0,7)) . "+" . $newOptions . "+"  . join("+",array_slice($_SERVER['argv'],8,6));	

	$GLOBALS[$form]->FormHTML = str_replace("!formAction!",$formAction,
		str_replace("!attachmentInfo!",$attachmentTable,
		str_replace("!attachmentName!",$pdfName.".pdf",
		str_replace("!hasAttachment!","expand",
		str_replace("!emailBody!","",
		str_replace("!emailSubject!",$pdfName,
		Join("", file(__DIR__ . "/../../../public/html/email_popup.htm")))))))
	);
	
	$principalId		= $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId		= $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
	$principalInfo 	= getPersonaDetail($principalId);
	$resOfficeInfo 	= getPersonaDetail($resOfficeId);
	
	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));

	$GLOBALS['temp']['princName'] = $principalInfo['name'];
	$GLOBALS['temp']['fax'] 			= $resOfficeInfo['fax'];
	$GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
	
	$userId = $_SESSION['userid'];
	
	$GLOBALS['temp']['emailFrom'] = $lDB->get("
		SELECT
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE 
		pr_persona.pr_persona_ix = '" . $userId . "'
	", 4);
	
	$GLOBALS['temp']['emailTo'] = "";

}

$GLOBALS['temp']['orderBy'] = $orderDetailsArgv;

$GLOBALS['temp']['checkExpiredAllocations'] = "checked=\"checked\"";
$GLOBALS['temp']['hideRowDiv'] = "collapse printCollapse";

if ( $_SERVER['argc'] > 1 ) {
	/* ============================================================================
	 *  SQL from filters : START 
	 * ========================================================================= */
	$agentList = "";
	$agentSQL = "";
	$propertyList = "";
	$propertySQL = "";
	$accommodationList = "";
	$accommodationSQL = "";
	$consultantList = "";
	$consultantSQL = "";
	$expiredAllocationsSQL = "";
	$allocationNumberSQL = "";

	if ( $allocationNumber == "" ) {
		// If there is no Allocation number, the other filters can be used.

		// Agent filter SQL ---------------------------------------------------------
		if ( $agentArgv ) {
			$agentSQL = " AND rv_reservation.rv_agent_id IN ('" . str_replace(":","','",$agentArgv) . "') ";
		} else {
			if ( $userStatusId == 1 ) {
				$agentSQL = " AND rv_reservation.rv_agent_id = '" . $_SESSION['calAgentId'] . "' ";
			}
		}


		// Property Filter SQL ------------------------------------------------------
		if ( $propertyFilterArgv != "" ) {
			$propertyList = str_replace(":","','",$propertyFilterArgv);
			$propertySQL = " AND rv_reservation_item.pr_business_id IN ('" . $propertyList . "') ";
		}

		// Accommodation Filter SQL -------------------------------------------------
		if ( $accommFilterArgv ) {
			$accommodationList = str_replace(":","','",$accommFilterArgv);
			$accommodationSQL = " AND rv_reservation_item.ac_accomm_type_id IN ('" . $accommodationList . "') ";
		}

		// Consultant Filter SQL ----------------------------------------------------
		if ( $consultantFilterArgv ) {
			$consultantList = str_replace(":","','",$consultantFilterArgv);
			$consultantSQL = " AND rv_reservation.rv_consultant_id IN ('" . $consultantList . "') ";
		}	

		// Expired allocation SQL ---------------------------------------------------
		if ( $expiredAllocationsArgv == "true" ) {
			$GLOBALS['temp']['checkExpiredAllocations'] = "checked=\"checked\"";
			// Include all allocations that span the specified date range -------------
			$expiredAllocationsSQL = " AND 
				(
					rv_reservation_item.rv_item_date_depart >= '" . $startDate['jsDate'] . "'
					AND 
					rv_reservation_item.rv_item_date_arrive <= '" . $endDate['jsDate'] . "'
				) ";
		} else {
			$GLOBALS['temp']['checkExpiredAllocations'] = "";
			// Take into account the expiry date and then later filter on lead time ---
			$expiredAllocationsSQL = " AND 
				(
					(
						rv_reservation.rv_alloc_expiry_date >= '" . $startDate['jsDate'] . "'
						AND 
						rv_reservation.rv_alloc_expiry_days = '0'
					) 
					OR 
					(
							rv_reservation.rv_alloc_expiry_date = '0000-00-00' 
							AND 
							rv_reservation.rv_alloc_expiry_days >= '0'							
					)
				) 
				AND 
					rv_reservation_item.rv_item_date_depart >= '" . $startDate['jsDate'] . "' 
					AND 
					rv_reservation_item.rv_item_date_arrive <= '" . $endDate['jsDate'] . "'
			";
		}
	} else {
		// Ignore all the other filters, use only allocation number ---------------
		$allocationNumberSQL = " AND rv_reservation.rv_reservation_ix = '" . $allocationNumber . "'";
		// Make sure we don't show allocations not belonging to an Agent ----------
		if ( $userStatusId == 1 ) {
			$agentSQL = " AND rv_reservation.rv_agent_id = '" . $_SESSION['calAgentId'] . "' ";
		}
	}
	/* ============================================================================
	 *  SQL from filters : END
	 * ========================================================================= */

	// Order
	$order = "";
	$orderDetails = explode(":",$orderDetailsArgv);
	$ascDesc = " ";

	if ( !isset($orderDetails[1]) || $orderDetails[1] == 0 ) {
		$ascDesc = " ASC ";
	} else {
		$ascDesc = " DESC ";
	}

	switch ( $orderDetails[0] ) {
		case 1:
			$order = " ORDER BY TRIM(agent_name)" . $ascDesc;
			break;
		case 2:
			$order = " ORDER BY rv_reservation.rv_reservation_ix" . $ascDesc;
			break;
		case 3:
			$order = " ORDER BY rv_reservation.rv_res_name" . $ascDesc;
			break;
		case 4:
			$order = " ORDER BY ifnull(rv_reservation.rv_alloc_expiry_date, rv_reservation.rv_alloc_expiry_days )" . $ascDesc . ", ifnull(rv_reservation.rv_alloc_expiry_days, rv_reservation.rv_alloc_expiry_date )" . $ascDesc;
			break;
		case 5:
			$order = " ORDER BY TRIM(consultant_name)" . $ascDesc;
			break;
		case 6:
			$order = " ORDER BY TRIM(contact_name)" . $ascDesc;
			break;
		case 7:
			$order = " ORDER BY TRIM(property_name)" . $ascDesc;
			break;
		case 8:
			$order = " ORDER BY ac_accomm_type.ac_accomm_desc" . $ascDesc;
			break;
		case 9:
			$order = " ORDER BY rv_reservation_item.rv_item_date_arrive" . $ascDesc;
			break;			
	}

	$uncleanAllocations = $lDB->get("
		SELECT 
			agent.pr_name_last as agent_name,
			rv_reservation.rv_reservation_ix,
			IFNULL(CONCAT(bl_block.bl_block_abbrev, ': ', rv_reservation.rv_res_name),rv_reservation.rv_res_name) AS rv_res_name,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			rv_reservation_item.rv_item_accomm_count,
			CASE rv_reservation_item.rv_alloc_expiry_date
				WHEN '0000-00-00' THEN rv_reservation.rv_alloc_expiry_date
				WHEN NULL THEN rv_reservation.rv_alloc_expiry_date
				ELSE rv_reservation_item.rv_alloc_expiry_date
			END AS rv_alloc_expiry_date,
			rv_reservation.rv_alloc_expiry_days,
			IFNULL(CONCAT(CONCAT(consultant.pr_name_first, ' '),consultant.pr_name_last),consultant.pr_name_last) as consultant_name,
			IFNULL(CONCAT(CONCAT(contact.pr_name_first, ' '),contact.pr_name_last),contact.pr_name_last) as contact_name,
			IFNULL(CONCAT(CONCAT(business.pr_name_first, ' '),business.pr_name_last),business.pr_name_last) as property_name,
			rv_reservation_item.ac_accomm_type_id,
			ac_accomm_type.ac_accomm_desc,
			agent.pr_persona_ix as agent_id
		FROM
			rv_reservation_item
		INNER JOIN rv_reservation ON
			rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
		INNER JOIN pr_agent ON
			pr_agent.pr_agent_id = rv_reservation.rv_agent_id
		INNER JOIN ac_accomm_type ON
			rv_reservation_item.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
		LEFT JOIN pr_persona AS agent ON
			agent.pr_persona_ix = rv_reservation.rv_agent_id
		LEFT JOIN pr_persona AS business ON
			business.pr_persona_ix = rv_reservation_item.pr_business_id
		LEFT JOIN pr_persona AS contact ON
			contact.pr_persona_ix = rv_reservation.rv_corr_persona_id
		LEFT JOIN pr_persona AS consultant ON
			consultant.pr_persona_ix = rv_reservation.rv_consultant_id
		LEFT JOIN bl_block_period ON bl_block_period.bl_block_period_ix = rv_reservation.bl_block_period_id
		LEFT JOIN bl_block ON bl_block.bl_block_ix = bl_block_period.bl_block_id
		WHERE 
			rv_reservation.rf_reservation_status_id  = 15 
		" . $expiredAllocationsSQL . "
		" . $agentSQL . "
		" . $propertySQL . "
		" . $accommodationSQL . "
		" . $consultantSQL . "
		" . $allocationNumberSQL . "
		" . $order . "
	",2);

	$allocations = array();

	foreach ( $uncleanAllocations as $k => $v ) {
		// Ignore any used allocations ----------------------------------------------
		if ( $v['rv_item_accomm_count'] > 0 ) {
			if ( ( $v['rv_alloc_expiry_date'] == "0000-00-00" && $v['rv_alloc_expiry_days'] >= 0 ) && $expiredAllocationsArgv == "false" ) {
				// We have discounted all allocations with an expiry date set.
				// 
				// Now we need to check that the remaining allocations have lead times 
				// that do not allow the allocation to completely expire within the 
				// specified time frame
				// 
				// Checks:
				// 1. $v['rv_item_date_depart'] - $v['rv_alloc_expiry_days'] > $startDate

				// Turn everything into useful numbers (i.e. seconds)	
				$expiryDate = strtotime($v['rv_item_date_depart']);
				$leadTime = $v['rv_alloc_expiry_days']*86400;
				$beginDate = strtotime($startDate['jsDate']);

				if ( ($expiryDate - $leadTime) >= $beginDate ) {
					// If the lead time results in this allocation falling into the 
					// timeframe, add it to the $allocations array						
					array_push($allocations,$uncleanAllocations[$k]);			
				}
			} else {
				array_push($allocations,$uncleanAllocations[$k]);
			}
		}
	}
	
	// Show the report output buttons -------------------------------------------
	$GLOBALS['temp']['hideButts'] 					= "printCollapse outLt bl br bb";
	$GLOBALS['temp']['emailPDF'] 						= "button bEmail";
	$GLOBALS['temp']['exportClass'] 				= "button bExport";
	$GLOBALS['temp']['showHideButtonClass']	= "button";
	$GLOBALS['temp']['hideRowDiv']					= "";

	/* HTML REPORT : START --------------------------------------------------- */
	if ( $renderMode == "html" ) {
		$tableHead = "<table width=\"1200\" border=\"0\" cellpadding=\"2\" cellspacing=\"0\" align=\"center\">
			<thead>
			<tr>
				<th class=\"outDk\">Agent Name&nbsp;<img src=\"/resource/Resrequest/Application/public/img/arrow_up_16.gif\" border=\"0\" alt=\"\" onclick=\"setOrder(1,0);\" style=\"cursor: pointer;\" alt=\"Sort Ascending\" title=\"Sort Ascending\" /><img src=\"/resource/Resrequest/Application/public/img/arrow_down_16.gif\" border=\"0\" alt=\"\" onclick=\"setOrder(1,1);\" style=\"cursor: pointer;\" alt=\"Sort Descending\" title=\"Sort Descending\" /></th>
				<th class=\"outDk\">Alloc. #&nbsp;<img src=\"/resource/Resrequest/Application/public/img/arrow_up_16.gif\" border=\"0\" alt=\"\" onclick=\"setOrder(2,0);\" style=\"cursor: pointer;\" alt=\"Sort Ascending\" title=\"Sort Ascending\" /><img src=\"/resource/Resrequest/Application/public/img/arrow_down_16.gif\" border=\"0\" alt=\"\" onclick=\"setOrder(2,1);\" style=\"cursor: pointer;\" alt=\"Sort Descending\" title=\"Sort Descending\" /></th>
				<th class=\"outDk\">Allocation name&nbsp;<img src=\"/resource/Resrequest/Application/public/img/arrow_up_16.gif\" border=\"0\" alt=\"\" onclick=\"setOrder(3,0);\" style=\"cursor: pointer;\" alt=\"Sort Ascending\" title=\"Sort Ascending\" /><img src=\"/resource/Resrequest/Application/public/img/arrow_down_16.gif\" border=\"0\" alt=\"\" onclick=\"setOrder(3,1);\" style=\"cursor: pointer;\" alt=\"Sort Descending\" title=\"Sort Descending\" /></th>
				<th class=\"outDk\">Property <img src=\"/resource/Resrequest/Application/public/img/arrow_up_16.gif\" border=\"0\" alt=\"\" onclick=\"setOrder(7,0);\" style=\"cursor: pointer;\" alt=\"Sort Ascending\" title=\"Sort Ascending\" /><img src=\"/resource/Resrequest/Application/public/img/arrow_down_16.gif\" border=\"0\" alt=\"\" onclick=\"setOrder(7,1);\" style=\"cursor: pointer;\" alt=\"Sort Descending\" title=\"Sort Descending\" /></th>
				<th class=\"outDk\">Accomm. type <img src=\"/resource/Resrequest/Application/public/img/arrow_up_16.gif\" border=\"0\" alt=\"\" onclick=\"setOrder(8,0);\" style=\"cursor: pointer;\" alt=\"Sort Ascending\" title=\"Sort Ascending\" /><img src=\"/resource/Resrequest/Application/public/img/arrow_down_16.gif\" border=\"0\" alt=\"\" onclick=\"setOrder(8,1);\" style=\"cursor: pointer;\" alt=\"Sort Descending\" title=\"Sort Descending\" /></th>
				<th class=\"outDk\">Start  <img src=\"/resource/Resrequest/Application/public/img/arrow_up_16.gif\" border=\"0\" alt=\"\" onclick=\"setOrder(9,0);\" style=\"cursor: pointer;\" alt=\"Sort Ascending\" title=\"Sort Ascending\" /><img src=\"/resource/Resrequest/Application/public/img/arrow_down_16.gif\" border=\"0\" alt=\"\" onclick=\"setOrder(9,1);\" style=\"cursor: pointer;\" alt=\"Sort Descending\" title=\"Sort Descending\" /></th>
				<th class=\"outDk\">End</th>
				<th class=\"outDk\">Nights</th>
				<th class=\"outDk\">Rooms</th>
				<th class=\"outDk\">Expiry <img src=\"/resource/Resrequest/Application/public/img/arrow_up_16.gif\" border=\"0\" alt=\"\" onclick=\"setOrder(4,0);\" style=\"cursor: pointer;\" alt=\"Sort Ascending\" title=\"Sort Ascending\" /><img src=\"/resource/Resrequest/Application/public/img/arrow_down_16.gif\" border=\"0\" alt=\"\" onclick=\"setOrder(4,1);\" style=\"cursor: pointer;\" alt=\"Sort Descending\" title=\"Sort Descending\" /></th>
				<th class=\"outDk\">Consultant <img src=\"/resource/Resrequest/Application/public/img/arrow_up_16.gif\" border=\"0\" alt=\"\" onclick=\"setOrder(5,0);\" style=\"cursor: pointer;\" alt=\"Sort Ascending\" title=\"Sort Ascending\" /><img src=\"/resource/Resrequest/Application/public/img/arrow_down_16.gif\" border=\"0\" alt=\"\" onclick=\"setOrder(5,1);\" style=\"cursor: pointer;\" alt=\"Sort Descending\" title=\"Sort Descending\" /></th>
				<th class=\"outDk\">Contact</th>
			</tr>
			</thead>";
			
			// So I don't have to type it all out again
			//<th class=\"outDk\">Contact <img src=\"/resource/Resrequest/Application/public/img/arrow_up_16.gif\" border=\"0\" alt=\"\" onclick=\"setOrder(6,0);\" style=\"cursor: pointer;\" alt=\"Sort Ascending\" title=\"Sort Ascending\" /><img src=\"/resource/Resrequest/Application/public/img/arrow_down_16.gif\" border=\"0\" alt=\"\" onclick=\"setOrder(6,1);\" style=\"cursor: pointer;\" alt=\"Sort Descending\" title=\"Sort Descending\" /></th>

		$t = "";

		// If "Include expired allocations" is false, iterate and unset expired allocations
		if ( $expiredAllocationsArgv == "false" ) {
			foreach ( $allocations as $k => $v ) {
				if ( $v['rv_alloc_expiry_date'] != "0000-00-00" ) {
					if ( $v['rv_alloc_expiry_date'] < date("Y-m-d") ) {
						unset($allocations[$k]);
					}
				} else {
					$daysToEnd = dateSubtract($v['rv_item_date_depart'],date("Y-m-d"));
					if ( $v['rv_alloc_expiry_days'] > $daysToEnd ) {
						unset($allocations[$k]);
					}
				}
			}
		}

		foreach ( $allocations as $k => $v ) {
			$bgColour = "";
			$nights = dateSubtract($v[4],$v[3]);
			
			if ( isset($v[14]) && $v[14] == "0" ) {
				$v[14] = "<em>None specified</em>";
			}
			
			if ( !isset($v[6]) || $v[6] == "0000-00-00" ) {
				$v[7] .= ( $v[7] == 1 ) ? " day" : " days";
				$expiry = $v[7] . " lead time";
			} else {
				$expiry = chng_date($v[6],"-");
			}

			// Overlibs for long fields ---------------------------------------------
			for ( $i = 0; $i < count($v); $i++ ) {
				if ( isset($v[$i]) && strlen($v[$i]) > 22 ) {
					$v[$i] = "<span onmouseover=\"overlib('" . $v[$i] . "');\" onmouseout=\"nd();\">" . substr($v[$i],0,19) . "...</span>";
				}
			}
			
			// Figure out the background colours ------------------------------------
			$bgColour = "colWh";
			
			if ( $v['rv_alloc_expiry_date'] != "0000-00-00" ) {
				if ( $v['rv_alloc_expiry_date'] < date("Y-m-d") ) {
					$bgColour = "colRed";
					$v[13] .= "+++1";
				}
			} else {
				$daysToStart = dateSubtract($v['rv_item_date_arrive'],date("Y-m-d"));
				$daysToEnd = dateSubtract($v['rv_item_date_depart'],date("Y-m-d"));
				
				if ( $v['rv_alloc_expiry_days'] > $daysToStart) {
					$bgColour = "colOrange";
				}
				
				if ( $v['rv_alloc_expiry_days'] > $daysToEnd ) {
					$bgColour = "colRed";
					$v[13] .= "+++1";
				}
			}
			
			// If there is no data in an array item,insert an &nbsp; for formatting -
			foreach ( $v as $vk => $vv ) {
				if ( $vv == "" ) {
					$v[$vk] = "&nbsp;";
				}
			}
			
			$t .= "<tr onclick=\"openPopup('reservation.php?267+" . $v[13] . "',700,550)\" onmouseover=\"mouseOverRes(this);\"  onmouseout=\"mouseOutRes(this);\" style=\"cursor: pointer;\" rv_reservation_ix=\"" . $v[1] . "\" class=\"" . $bgColour . "\">
				<td class=\"bl bb br\">" . $v[0] . "</td>
				<td class=\"br bb\">" . $v[1] . "</td>
				<td class=\"br bb\">" . $v[2] . "</td>
				<td class=\"br bb\">" . $v[10] . "</td>
				<td class=\"br bb\">" . $v[12] . "</td>
				<td class=\"br bb\" align=\"center\">" . chng_date($v[3],"-") . "</td>
				<td class=\"br bb\" align=\"center\">" . chng_date($v[4],"-") . "</td>
				<td class=\"br bb\" align=\"center\">" . $nights . "</td>
				<td class=\"br bb\" align=\"center\">" . $v[5] . "</td>
				<td class=\"br bb\">" . $expiry . "</td>
				<td class=\"br bb\">" . $v[8] . "</td>
				<td class=\"br bb\">" . $v[9] . "</td>
			</tr>";			
		}
				
		if ( $t != "" ) {
			$GLOBALS['temp']['rows'] = $tableHead . $t . "</table>";
		} else {
			$GLOBALS['temp']['rows'] = "<table width=\"770\" border=\"0\" cellpadding=\"10\" cellspacing=\"0\" align=\"center\"><tr><td align=\"center\">There are no allocations that match your filter criteria.</td></tr></table>";
		}		
	}
	/* HTML REPORT : END ----------------------------------------------------- */

	/* PDF REPORT : START ---------------------------------------------------- */
	if ( $renderMode == "pdf" && ( $renderType == "view" || $renderType == "send" ) ) {
		$pdf = new PDF("Allocations List Report",'L');
		$reportLabel = "Allocations List Report";

		$pdf -> SetFillColor('0x9c','0x9e','0x98');

		$headerArray = array(array('name' => "Date Range", 'value' => $startDate['htmlDate'] . " to " . $endDate['htmlDate']));
		
		$pdfHeadAgentFilter			= $agentFilter['names'];
		$pdfHeadPropertyFilter		= $propertyFilter['names'];
		$pdfHeadAccommodationFilter = $accommFilter['names'];
		$pdfHeadConsultantFilter	= $consultantFilter['names'];
		$pdfHeadIncludeExpired		= $expiredAllocationsArgv;
		
		array_push($headerArray,array('name' => "Agents", 'value' => $pdfHeadAgentFilter));
		array_push($headerArray,array('name' => "Properties", 'value' => $pdfHeadPropertyFilter));
		array_push($headerArray,array('name' => "Accommodation Types", 'value' => $pdfHeadAccommodationFilter));
		array_push($headerArray,array('name' => "Consultant", 'value' => $pdfHeadConsultantFilter));

		if ( $allocationNumber != "" ) {
			array_push($headerArray,array('name' => "Allocation number", 'value' => $allocationNumber));
		}
		array_push($headerArray,array('name' => "Include expired alloc", 'value' => $pdfHeadIncludeExpired));

		$pdfFontSize = 7;
		$pdf->SetFont('Arial', '', $pdfFontSize);
		
		$pdf->Ln(4);

		$logo = "top_clientlogo.jpg";
		$principal_id = $_SESSION['principal_id'];
		
		if ( file_exists("$GLOBALS[images_dir_on_disk]/" . $principal_id . "/" . $logo) ) {
			$pic = $pdf->_parsejpg("$GLOBALS[images_dir_on_disk]/" . $principal_id . "/" . $logo);

			$h = $pic['h']/4;
			$w = $pic['w']/4;

			require_once(__DIR__ . '/functions.imageset.php');
			$logoWidth = imagesetLogoSizeOverride("allocationListReportPdfLogoWidthOverride", $w);
			$pdf->Image("$GLOBALS[images_dir_on_disk]/".$principal_id."/" . $logo, $h, 5, $logoWidth);
			if (($h + 8) > $pdf->y) {
      	$pdf->y = $h + 8;
			}
		} 

		$tableHeaders = array();
		
		array_push($tableHeaders,array('width' => "15%", 'data' => "Agent name", 'border' => "LRTB", 'align' => "C", 'fill' => "1"));
		array_push($tableHeaders,array('width' => "5%", 'data' => "Alloc. #", 'border' => "LRTB", 'align' => "C", 'fill' => "1"));
		array_push($tableHeaders,array('width' => "11%", 'data' => "Alloc. name", 'border' => "LRTB", 'align' => "C", 'fill' => "1"));
		array_push($tableHeaders,array('width' => "11%", 'data' => "Property", 'border' => "LRTB", 'align' => "C", 'fill' => "1"));
		array_push($tableHeaders,array('width' => "11%", 'data' => "Accomm.", 'border' => "LRTB", 'align' => "C", 'fill' => "1"));
		array_push($tableHeaders,array('width' => "6%", 'data' => "Start", 'border' => "LRTB", 'align' => "C", 'fill' => "1"));
		array_push($tableHeaders,array('width' => "6%", 'data' => "End", 'border' => "LRTB", 'align' => "C", 'fill' => "1"));
		array_push($tableHeaders,array('width' => "4%", 'data' => "Nights", 'border' => "LRTB", 'align' => "C", 'fill' => "1"));
		array_push($tableHeaders,array('width' => "4%", 'data' => "Rooms", 'border' => "LRTB", 'align' => "C", 'fill' => "1"));
		array_push($tableHeaders,array('width' => "10%", 'data' => "Expiry", 'border' => "LRTB", 'align' => "C", 'fill' => "1"));
		array_push($tableHeaders,array('width' => "7%", 'data' => "Consultant", 'border' => "LRTB", 'align' => "C", 'fill' => "1"));
		array_push($tableHeaders,array('width' => "10%", 'data' => "Contact", 'border' => "LRTB", 'align' => "C", 'fill' => "1"));
		
		$pdf -> Row($tableHeaders);
		
		foreach ( $allocations as $k => $v) {
			$currRowArray = array();

			$nights = dateSubtract($v[4],$v[3]);
			
			if ( $v[6] == "0000-00-00" ) {
				$v[7] .= ( $v[7] == 1 ) ? " day" : " days";
				$expiry = $v[7] . " lead time";
			} else {
				$expiry = chng_date($v[6],"-");
			}
			
			// Format dates nicely --------------------------------------------
			$v[3] = chng_date($v[3],"-");
			$v[4] = chng_date($v[4],"-");

			array_push($currRowArray,array('width' => "15%", 'data' => $v['agent_name'],'border' => "LRTB", 'align' => 'L'));
			array_push($currRowArray,array('width' => "5%", 'data' => $v['rv_reservation_ix'],'border' => "LRTB", 'align' => 'C'));
			array_push($currRowArray,array('width' => "11%", 'data' => $v['rv_res_name'],'border' => "LRTB", 'align' => 'L'));
			array_push($currRowArray,array('width' => "11%", 'data' => $v['property_name'],'border' => "LRTB", 'align' => 'L'));
			array_push($currRowArray,array('width' => "11%", 'data' => $v['ac_accomm_desc'],'border' => "LRTB", 'align' => 'L'));
			array_push($currRowArray,array('width' => "6%", 'data' => $v['rv_item_date_arrive'],'border' => "LRTB", 'align' => 'C'));
			array_push($currRowArray,array('width' => "6%", 'data' => $v['rv_item_date_depart'],'border' => "LRTB", 'align' => 'C'));
			array_push($currRowArray,array('width' => "4%", 'data' => $nights,'border' => "LRTB", 'align' => 'C'));
			array_push($currRowArray,array('width' => "4%", 'data' => $v[5],'border' => "LRTB", 'align' => 'C'));
			array_push($currRowArray,array('width' => "10%", 'data' => $expiry,'border' => "LRTB", 'align' => 'L'));			
			array_push($currRowArray,array('width' => "7%", 'data' => $v['consultant_name'],'border' => "LRTB", 'align' => 'L'));
			array_push($currRowArray,array('width' => "10%", 'data' => $v['contact_name'],'border' => "LRTB", 'align' => 'L'));

    		$pdf -> Row($currRowArray);
		}
		
		$pdf -> Ln(4);
		
		$pdf->ReportHeader($reportLabel, $headerArray);
		
		if ( $renderType == "view" ) {
			$pdf->OutPut();
			die();
		}
		
		if ( $renderType == "send" ) {
			$to = $_POST['mail_to'];
			$from = $_POST['mail_from'];
			$subject = stripslashes($_POST['mail_subj']);
			$message = stripslashes($_POST['mail_body']);
			$attachmentName = $_POST['attachmentName'];
			$GLOBALS['princName'] = (isset($GLOBALS['princName']) ? $GLOBALS['princName'] : "");

			$headers = "From: " . $GLOBALS['princName'] . "<$from>\r\n";

			// Close the PDF
			if ( $pdf->state < 3 ) {
				$pdf->Close();
			}

			// Mail the PDF
			if ( $attachmentName != "!attachmentName!" ) {
				$pdfName = $attachmentName;
			} else {
				$pdfName = "Update report from " . $startDate . " to " . $endDate . ".pdf";
			}

			$error = email($from, $to, $subject, $headers, $message, 0, 0, "", $GLOBALS['princName'],$pdf->buffer,$pdfName);     // (from, to, subject, headers, message, action, emailID, resID)
			
			if ( !$error ) {
				echo "<script type=\"text/javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
				die();
			} else {
				echo "<script type=\"text/javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
				die();
			}
		}
	}
	/* PDF REPORT : END ------------------------------------------------------ */

	/* CSV REPORT : START ---------------------------------------------------- */
	if($renderMode == "csv") {
  	$csvFile = array();
   	array_push($csvFile,array("Allocation List Report"));
   	array_push($csvFile,array());
		array_push($csvFile,array("Date Range",$startDate['htmlDate'] . " to " . $endDate['htmlDate']));

		$csvHeadAgentFilter			= str_replace(","," ",$agentFilter['names']);
		$csvHeadPropertyFilter		= str_replace(","," ",$propertyFilter['names']);
		$csvHeadAccommodationFilter = str_replace(","," ",$accommFilter['names']);
		$csvHeadConsultantFilter	= str_replace(","," ",$consultantFilter['names']);
		$csvHeadIncludeExpired		= $expiredAllocationsArgv;
		
		array_push($csvFile,array("Agents:",$csvHeadAgentFilter));
		array_push($csvFile,array("Properties",$csvHeadPropertyFilter));
		array_push($csvFile,array("Accommodation Types",$csvHeadAccommodationFilter));
		array_push($csvFile,array("Consultant",$csvHeadConsultantFilter));
		
		if ( $allocationNumber != "" ) {
			array_push($csvFile,array("Allocation number",$allocationNumber));
		}
		
		array_push($csvFile,array("Include expired alloc",$csvHeadIncludeExpired));
		
		array_push($csvFile,array());

		// Header Cells : START ---------------------------------------------------
		$headerCells = array();
		
		array_push($headerCells,"Agent name");
		array_push($headerCells,"Allocation number");
		array_push($headerCells,"Allocation name");
		array_push($headerCells,"Property");
		array_push($headerCells,"Accomm");
		array_push($headerCells,"Start");
		array_push($headerCells,"End");
		array_push($headerCells,"Nights");
		array_push($headerCells,"Rooms");
		array_push($headerCells,"Expiry");
		array_push($headerCells,"Consultant");
		array_push($headerCells,"Contact");		

		array_push($csvFile,$headerCells);

		// Main Content : START ---------------------------------------------------
		foreach ($allocations as $k => $v ) {
			$currRowArray = array();

			$nights = dateSubtract($v[4],$startDate['jsDate']);

			if ( $v[6] == "0000-00-00" ) {
				$v[7] .= ( $v[7] == 1 ) ? " day" : " days";
				$expiry = $v[7] . " lead time";
			} else {
				$expiry = chng_date($v[6],"-");
			}
			
			// Format dates nicely --------------------------------------------
			$v['rv_item_date_arrive'] = chng_date($v['rv_item_date_arrive'],"-");
			$v['rv_item_date_depart'] = chng_date($v['rv_item_date_depart'],"-");

			array_push($currRowArray,$v['agent_name']);			
			array_push($currRowArray,$v['rv_reservation_ix']);
			array_push($currRowArray,$v['rv_res_name']);
			array_push($currRowArray,$v['property_name']);
			array_push($currRowArray,$v['ac_accomm_desc']);
			array_push($currRowArray,$v['rv_item_date_arrive']);
			array_push($currRowArray,$v['rv_item_date_depart']);
			array_push($currRowArray,$nights);
			array_push($currRowArray,$v[5]);
			array_push($currRowArray,$expiry);
			array_push($currRowArray,$v['consultant_name']);
			array_push($currRowArray,$v['contact_name']);			
						
			array_push($csvFile,$currRowArray);
		}
		// Main Content : END -------------------------------------------------------

		$csvText = "";
		
		foreach ( $csvFile as $csvLine ) {
    	$first = true;
			
			foreach ( $csvLine as $csvItem ) {
      	if ( !$first ) {
      		$csvText .= ",";
				} else {
        	$first = false;
        }
        $csvText .= "\"".str_replace("\"","\"\"",$csvItem)."\"";
      }
      $csvText .= "\n";
		}
   
		header('Content-Type: text/csv');
		header("Cache-control: private");
		header('Content-Length: '.strlen($csvText));
		header("Content-Disposition: inline; filename=allocation_list_report_".str_replace(" ","_",$startDate['htmlDate'])."_to_".str_replace(" ","_",$endDate['htmlDate']).".csv");
		echo $csvText;
		
		flush();
		die();
	}
	/* CSV REPORT : END ------------------------------------------------------ */
}		

function getPersonaFax($personaId) {
	global $lDB;
	$fax = $lDB->get("
		SELECT 
			pr_phone.pr_phone_number 
		FROM 
			pr_phone, rf_phone_type 
		WHERE 
			pr_phone.pr_persona_id = '" . $personaId . "' 
		AND 
			pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix 
		AND 
			rf_phone_type.rf_phone_type_sys_code = '1'
	",4);
	
	if ( trim($fax) == "" || $fax == "0" ) {
		$fax = "";
	}
	return $fax;
}

function getPersonaTelephone($personaId) {
	global $lDB;
	$tel = $lDB->get("
		SELECT
			pr_phone.pr_phone_number 
		FROM 
			pr_phone 
		WHERE 
			pr_phone.pr_persona_id = '" . $personaId . "' 
		AND 
			pr_phone.pr_default_yn = '1'
	",4);
	
	if ( trim($tel) == "" || $tel == "0" ) {
		$tel = "";
	}
	return $tel;
}


function getPersonaDetail($personaId) {
	global $lDB;
	$detail = $lDB->get("
		SELECT
			pr_persona.pr_name_first,
			pr_persona.pr_name_second,
			pr_persona.pr_name_last,
			pr_persona.pr_email 
		FROM 
			pr_persona 
		WHERE 
			pr_persona.pr_persona_ix = '" . $personaId . "'
	",2);

	$detail = $detail[0];
	$name = "";

	if ( trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0" ) {
		$name .= $detail['pr_name_first'] . " ";
	}
	
	if ( trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0" ) {
		$name .= $detail['pr_name_second'] . " ";
	}
	
	if ( trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0" ) {
		$name .= $detail['pr_name_last'] . " ";
	}
	
	$result = array();
	
	$result['name'] 			= trim($name);
	$result['fax'] 				= getPersonaFax($personaId);
	$result['telephone']	= getPersonaTelephone($personaId);
	$result['email'] 			= $detail['pr_email'];
	
	if ( trim($result['email']) == "" || $result['email'] == "0" ) {
		$result['email'] = "";
	}
	return $result;
}


$GLOBALS['temp']['SAServer'] = $GLOBALS['SAServer'];
$GLOBALS['temp']['USServer'] = $GLOBALS['USServer'];
$GLOBALS['temp']['EUServer'] = $GLOBALS['EUServer'];

// Print Header Setup
$GLOBALS['temp']['genDate'] 						= chng_date(date("Y-m-d"),"-")." ".date("H:i:s");
$GLOBALS['temp']['printEnv'] 						= $GLOBALS['dbcode'];
$GLOBALS['temp']['printUser'] 					= $GLOBALS['firstname'] . " " . $GLOBALS['lastname'];
$GLOBALS['temp']['printServer'] 				= $GLOBALS['domain'];
$GLOBALS['temp']['accommodationNames']	= $accommFilter['names'];
$GLOBALS['temp']['printPage'] 					= (isset($page) ? $page : "");
