<?php

require_once(__DIR__ . "/db.rv_reservation.php");
require_once(__DIR__ . '/db.rv_note.php');
require_once(__DIR__ . '/db.sc_group.php');
require_once(__DIR__ . '/db.bl_block_period.php');
require_once(__DIR__ . '/class.stock.php');
require_once(__DIR__ . '/functions.reservation.php');
require_once(__DIR__ . '/functions.reservation.itinerary.php');
require_once(__DIR__ . '/functions.financial.php');
require_once(__DIR__ . '/functions.reservation.block.php');
require_once(__DIR__ . '/class.audit.php');

function validateAllocation($rv_reservation_ix=false) {
	global $lDB;

	$unitGroup = $lDB->get("SELECT rt_rate_group_ix FROM rt_rate_group WHERE rt_rate_group_sys_code = 1", 4);
	$allocationItems = unserialize(stripslashes($_POST['allocationItems']));
	foreach($allocationItems as $key=>$item) {
		$rateGroups = explode("~",$item['rateGroups']);
		$unitCount = 0;
		foreach($rateGroups as $rateGroup) {
			list($rateGroupId,$rateGroupCount) = explode("_",$rateGroup);
			if($rateGroupId == $unitGroup) {
				$unitCount += $rateGroupCount;
			}
		}
		$allocationItems[$key]['rv_item_accomm_count'] = $unitCount;
	}

	// Check for negative dates
	$used = $lDB->get("
		SELECT
			link_reservation.rv_reservation_ix,
			link_reservation.rv_res_name,
			rv_reservation_item.ac_accomm_type_id,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			rv_reservation_item.rv_item_accomm_count,
			'1' as is_used
		FROM
			rv_reservation_item
			LEFT JOIN rv_reservation_item as link_item ON link_item.rv_reservation_item_ix = rv_reservation_item.rv_link_res_item_id
      LEFT JOIN rv_reservation link_reservation ON link_reservation.rv_reservation_ix = link_item.rv_reservation_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$rv_reservation_ix'
			AND link_item.rv_reservation_item_ix IS NOT NULL
      AND (
            link_reservation.rf_reservation_status_id IN ('0', '10', '25', '30')
            OR (
              link_reservation.rf_reservation_status_id = '20' 
              AND link_reservation.rv_provision_expiry_date >= CURDATE()
            )
          )
	",2);
	$totalAllocationItems = array_merge($allocationItems,$used);
	$accommRoomCount = array();
	$accommIsUsed = array();
	$drawDowns = array();
	foreach($totalAllocationItems as $item) {
		if(!array_key_exists($item['ac_accomm_type_id'],$accommRoomCount)) {
			$accommRoomCount[$item['ac_accomm_type_id']] = array();
		}
		if(!array_key_exists($item['ac_accomm_type_id'],$accommIsUsed)) {
			$accommIsUsed[$item['ac_accomm_type_id']] = array();
			$drawDowns[$item['ac_accomm_type_id']] = array();
		}
		$numNights = dateSubtract($item['rv_item_date_depart'],$item['rv_item_date_arrive']);
		$startArray = explode("-",$item['rv_item_date_arrive']);
		for($count = 0; $count < $numNights; $count++) {
			$currDate = date("Y-m-d",mktime (0,0,0,$startArray[1],$startArray[2]+$count,$startArray[0]));
			if(!array_key_exists($currDate,$accommRoomCount[$item['ac_accomm_type_id']])) {
				$accommRoomCount[$item['ac_accomm_type_id']][$currDate] = 0;
			}
			$accommRoomCount[$item['ac_accomm_type_id']][$currDate] += $item['rv_item_accomm_count'];
			if(array_key_exists("is_used",$item) && $item['is_used'] == "1") {
				$accommIsUsed[$item['ac_accomm_type_id']][$currDate] = true;
				$drawDowns[$item['ac_accomm_type_id']][$currDate][] = array('rv_reservation_id'=>$item['rv_reservation_ix'], 'rv_res_name'=>$item['rv_res_name']);
			}
		}
	}
	$hasNegative = false;
	$negativeDates = array();
	$hasUsed = false;
	foreach($accommRoomCount as $accommId=>$accommItem) {
		foreach($accommItem as $date=>$dateItem) {
			if($dateItem < 0) {
        $negativeDates[$date] = array('rooms'=>$dateItem, 'drawDowns'=>array());
				if(isset($accommIsUsed[$accommId][$date]) && $accommIsUsed[$accommId][$date]) {
					$hasUsed = true;
					$negativeDates[$date]['drawDowns'] = $drawDowns[$accommId][$date];
				}
				$hasNegative = true;
			}
		}
	}

	$hasOverbooking = false;
	foreach($allocationItems as $item) {
		if($item['deleted'] != "1" && $item['edited'] == "1") {

			$dateArray = explode("-",$item['rv_item_date_depart']);
			$dateDepart = date("Y-m-d",mktime(0,0,0,$dateArray[1],$dateArray[2]-1,$dateArray[0]));

			$stock = new Stock($item['ac_accomm_type_id'],$item['rv_item_date_arrive'],$dateDepart,false,false,false,$item['rv_reservation_item_ix']);
			$avail = $stock->ToAvailability();
			$hasOverbooking = false;
			$overbookingArray = array();
			foreach($avail as $thisDate=>$availItem) {
				if($availItem - $item['rv_item_accomm_count'] < 0) {
					$hasOverbooking = true;
					array_push($overbookingArray,$thisDate);
				}
			}
		}
		if($hasOverbooking) {
			$dateMin = false;
			$dateMax = false;
			foreach($overbookingArray as $date) {
				if($dateMin === false) {
					$dateMin = $date;
				}
				if($dateMax === false) {
					$dateMax = $date;
				}
				if($date < $dateMin) {
					$dateMin = $date;
				}
				if($date > $dateMax) {
					$dateMax = $date;
				}
				$dateFmt = chng_date($date,"-");
				$GLOBALS['temp']['overbooking'] .= "overbookingList[overbookingList.length] = '$dateFmt';\n";
			}
			$dateMaxArray = explode("-",$dateMax);
			$dateMax = date("Y-m-d",mktime (0,0,0,$dateMaxArray[1],$dateMaxArray[2]+1,$dateMaxArray[0]));
			
			$GLOBALS['temp']['overbooking'] .= "var overbookingDateMax = '$dateMax';\n";
			$GLOBALS['temp']['overbooking'] .= "var overbookingDateMin = '$dateMin';\n";
			$overbookingAccommId = $item['ac_accomm_type_id'];
			$GLOBALS['temp']['overbooking'] .= "var overbookingAccommId = '$overbookingAccommId';\n";
		}
	}	
	if($hasNegative) {
		$list = array("<table cellspacing='0' cellpadding='0' border='0' class='bAll' width='100%'><tr class='colDk bAll'><th>Date</th><th>Rms</th><th>Reservations</th></tr>");
		foreach($negativeDates as $date=>$item) {
			$date = chng_date($date,"-");
      $reservations = array();
      foreach($item['drawDowns'] as $reservation) {
        $onclick = "newWindow = openPopup('/reservation.php?2+".$reservation['rv_reservation_id']."',0,0,0,0,1,1,'ResRequestWin' + generateUUID(),false,true); newWindow.moveTo(0,0); newWindow.resizeTo(screenWidth,screenHeight);";
        $reservations[] = "<a title=\"".$reservation['rv_res_name']."\" href=\"#\" onclick=\"$onclick\">".$reservation['rv_reservation_id']."</a>";
      }
      $reservations = join("; ", $reservations);
			$list[] = "<tr><td class='bAll'>$date</td><td class='bAll'>".$item['rooms']."</td><td class='bAll'>$reservations</td></tr>";
		}
    $list[] = "</table>";
		echo "true|".join("|",$list)."\n";
	} else {
		echo "false\n";
	}
	if($hasOverbooking) {
		echo "true\n";
	} else {
		echo "false\n";
	}
	echo (isset($dateMin) ? $dateMin : "") . "\n";
	echo (isset($dateMax) ? $dateMax : "") . "\n";
	echo (isset($overbookingAccommId) ? $overbookingAccommId : "") . "\n";	
	if($hasUsed) {
		echo "true\n";
	} else {
		echo "false\n";
	}
}


function updateAllocation($pr_agent_id,$rv_reservation_ix=false) {
	global $lDB;
	if (!isset($_POST['allocationItems'])) {
		return;
	}
	$allocationItems = unserialize($_POST['allocationItems']);
	$hasOverbooking = false;
	
	if(!$hasOverbooking) {
		if ( $rv_reservation_ix === false ) {
			$rv_reservation_ix = db_rv_reservation_insert($_POST['rt_rate_type_id'],false,$pr_agent_id,$_POST['rv_commission_perc']);
		}

		$_POST['rv_res_name'] 			= isset($_POST['rv_res_name']) ? $_POST['rv_res_name'] : "";
		$_POST['rv_agent_ref'] 			= isset($_POST['rv_agent_ref']) ? $_POST['rv_agent_ref'] : "";
		$_POST['rv_consultant_id'] 		= isset($_POST['rv_consultant_id']) ? $_POST['rv_consultant_id'] : "";
		$_POST['rv_corr_persona_id'] 	= isset($_POST['rv_corr_persona_id']) ? $_POST['rv_corr_persona_id'] : "";
		$_POST['rt_rate_type_id'] 		= isset($_POST['rt_rate_type_id']) ? $_POST['rt_rate_type_id'] : "";
		$_POST['rv_alloc_expiry_days'] 	= isset($_POST['rv_alloc_expiry_days']) ? $_POST['rv_alloc_expiry_days'] : "";
		$_POST['rv_alloc_expiry_date'] 	= isset($_POST['rv_alloc_expiry_date']) ? $_POST['rv_alloc_expiry_date'] : "";
		$_POST['rv_commission_perc'] 	= isset($_POST['rv_commission_perc']) ? $_POST['rv_commission_perc'] : "";

		$moduleFieldValues = [
			["ad_module_field_name"=>"rv_reservation.rv_res_name", "rf_audit_module"=>"resdetail"],
			["ad_module_field_name"=>"rv_reservation.rv_agent_ref", "rf_audit_module"=>"resdetail"],
			["ad_module_field_name"=>"rv_reservation.rv_consultant_id", "rf_audit_module"=>"resdetail"],
			["ad_module_field_name"=>"rv_reservation.rv_corr_persona_id", "rf_audit_module"=>"resdetail"],
			["ad_module_field_name"=>"rv_reservation.rt_rate_type_id", "rf_audit_module"=>"resfinancial"],
			["ad_module_field_name"=>"rv_reservation.rv_commission_perc", "rf_audit_module"=>"resdetail"],
		];

		$bl_block_period_id = $GLOBALS['lDB']->get("
			SELECT 
				bl_block_period_id
			FROM
				rv_reservation
			WHERE
				rv_reservation_ix = '$rv_reservation_ix'
		",4);
		$allocationUpdateJoin = "";
		$allocationUpdateSet = "
				rv_alloc_expiry_days = '".$lDB->escape($_POST['rv_alloc_expiry_days'])."',
				rv_alloc_expiry_date = '".$lDB->escape($_POST['rv_alloc_expiry_date'])."',
			";
		if (!empty($bl_block_period_id)) {
			$allocationUpdateJoin = "INNER JOIN bl_block_period ON bl_block_period.bl_block_period_ix = rv_reservation.bl_block_period_id";
			$allocationUpdateSet = "
					rv_reservation.rv_alloc_expiry_days = bl_block_period.bl_per_expiry_lead_time_days,
					rv_reservation.rv_alloc_expiry_date = bl_block_period.bl_per_expiry_lead_time_date,
				";
		} else {
			$moduleFieldValues[] = ["ad_module_field_name"=>"rv_reservation.rv_alloc_expiry_days", "rf_audit_module"=>"resdetail"];
			$moduleFieldValues[] = ["ad_module_field_name"=>"rv_reservation.rv_alloc_expiry_date", "rf_audit_module"=>"resdetail"];
		}

		$headerBefore = $lDB->get("
			SELECT
				" . join(",",array_map(function($field) { return $field['ad_module_field_name']; }, $moduleFieldValues)) . "
			FROM
				rv_reservation
			WHERE
				rv_reservation.rv_reservation_ix = '" . $lDB->escape($rv_reservation_ix) . "'
		",1);
		if(array_key_exists("rv_alloc_expiry_date",$headerBefore) && $headerBefore['rv_alloc_expiry_date'] == "0000-00-00") {
			$headerBefore['rv_alloc_expiry_date'] = "";
		}
		$GLOBALS['lDB']->put("
			UPDATE
				rv_reservation
				$allocationUpdateJoin
			SET
				rv_res_name = '".$lDB->escape($_POST['rv_res_name'])."',
				rv_agent_ref = '".$lDB->escape($_POST['rv_agent_ref'])."',
				rv_consultant_id = '".$lDB->escape($_POST['rv_consultant_id'])."',
				rv_corr_persona_id = '".$lDB->escape($_POST['rv_corr_persona_id'])."',
				rt_rate_type_id = '".$lDB->escape($_POST['rt_rate_type_id'])."',
				rv_reservation_type_ind = '5',
				rf_reservation_status_id = '15',
				$allocationUpdateSet
				rv_commission_perc = '".$lDB->escape($_POST['rv_commission_perc'])."'
			WHERE
				rv_reservation_ix = '$rv_reservation_ix'
		");
		db_rv_note_insert($rv_reservation_ix,false,false,$_POST['rv_note_general'],false,$_POST['rv_note_internal']);

		$reservationAuditTrail = new AuditTrail($rv_reservation_ix,TYPE_RESERVATION);
		$hasHeaderAudit = false;
		foreach ($moduleFieldValues as $moduleFieldValue) {
			$moduleFieldName = explode(".", $moduleFieldValue['ad_module_field_name'])[1];
			if(array_key_exists($moduleFieldName, $headerBefore) && array_key_exists($moduleFieldName, $_POST) && $headerBefore[$moduleFieldName] != $_POST[$moduleFieldName]) {
				$hasHeaderAudit = true;
				$reservationAuditTrail->addDetail(
					$headerBefore[$moduleFieldName],
					$_POST[$moduleFieldName],
					Null,
					Null,
					DB_AD_RES_DETAIL_ACTION_EDIT,
					$moduleFieldValue['rf_audit_module'],
					$moduleFieldValue['ad_module_field_name']
				);
			}
		}
		if($hasHeaderAudit) { 
			$reservationAuditTrail->save("Allocation Details");
		}

		$moduleFieldValues = array(
			array("ad_module_field_name"=>"rv_reservation_item.rv_item_date_arrive"),
			array("ad_module_field_name"=>"rv_reservation_item.rv_item_date_depart"),
			array("ad_module_field_name"=>"rv_reservation_item.rv_item_adult_count"),
			array("ad_module_field_name"=>"rv_reservation_item.rv_item_child_count"),
			array("ad_module_field_name"=>"rv_reservation_item.rv_item_nights"),
			array("ad_module_field_name"=>"rv_reservation_item.rv_item_accomm_count"),
			array("ad_module_field_name"=>"rv_reservation_item.rv_alloc_expiry_date"),
			array("ad_module_field_name"=>"rv_reservation_item.ac_accomm_type_id")
		);
		foreach($allocationItems as $item) {
			if($item['deleted'] == "1" && $item['rv_reservation_item_ix'] != "") {
                $allocationItem = $GLOBALS['lDB']->get("
                    SELECT
                        rv_reservation_item.rv_reservation_item_ix,
                        rv_reservation_item.rv_item_date_arrive,
                        rv_reservation_item.rv_item_date_depart,
                        rv_reservation_item.rv_item_adult_count,
                        rv_reservation_item.rv_item_child_count,
                        rv_reservation_item.rv_item_nights,
                        rv_reservation_item.rv_item_accomm_count,
                        rv_reservation_item.rv_alloc_expiry_date,
                        rv_reservation_item.ac_accomm_type_id,
                        rv_reservation.bl_block_period_id
                    FROM
                        rv_reservation_item
                        INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
                    WHERE
                        rv_reservation_item_ix = '".$item['rv_reservation_item_ix']."'
                ", 1);
                $allocationSeriesCount = $GLOBALS['lDB']->get("
                    SELECT
                        COUNT(DISTINCT rv_reservation_item.bl_series_id)
                    FROM
                        rv_reservation_item
                    WHERE
                        rv_reservation_item.rv_reservation_id = '".$rv_reservation_ix."'
                        AND rv_reservation_item.rv_item_accomm_count > 0
                ",4);
                if (empty($allocationItem['bl_block_period_id']) || $allocationSeriesCount > 1) {
                    // delete item
                    $allocationAuditTrail = new AuditTrail($rv_reservation_ix,TYPE_RESERVATION);
                    foreach ($moduleFieldValues as $moduleFieldValue) {
                        $moduleFieldName = explode(".", $moduleFieldValue['ad_module_field_name'])[1];
                        $allocationAuditTrail->addDetail(
                            $allocationItem[$moduleFieldName],
                            "",
                            $allocationItem['rv_reservation_item_ix'],
                            Null,
                            DB_AD_RES_DETAIL_ACTION_DELETE,
                            "resitinerary",
                            $moduleFieldValue['ad_module_field_name']
                        );
                    }
                    calDeleteItem($item['rv_reservation_item_ix'],$rv_reservation_ix);
                    $allocationAuditTrail->save("Allocation item deleted");
                }
			}
			if($item['deleted'] != "1" && $item['edited'] == "1") {
				if(!$hasOverbooking) {
					$numNights = dateSubtract($item['rv_item_date_depart'],$item['rv_item_date_arrive']);
					$itemInfo = join(":",array(
						$item['ac_accomm_type_id'],
						$item['rv_item_date_arrive'],
						$item['rv_item_date_depart'],
						$numNights,
						$item['rateGroups']
					));
					$items = array();
					$itemsBefore = array();
					if($item['rv_reservation_item_ix'] == "") {
						//add item
						$items = calCreateItem($rv_reservation_ix,$itemInfo,"",array(),"BLANK","0","0");
					} else {
						//edit item
						$beforeValues = array(
							'id'=>$item['rv_reservation_item_ix'],
							'values'=>$GLOBALS['lDB']->get("
								SELECT
									rv_reservation_item.rv_reservation_item_ix,
									rv_reservation_item.rv_item_date_arrive,
									rv_reservation_item.rv_item_date_depart,
									rv_reservation_item.rv_item_adult_count,
									rv_reservation_item.rv_item_child_count,
									rv_reservation_item.rv_item_nights,
									rv_reservation_item.rv_item_accomm_count,
									rv_reservation_item.rv_alloc_expiry_date,
									rv_reservation_item.ac_accomm_type_id
								FROM
									rv_reservation_item
								WHERE
									rv_reservation_item_ix = '".$item['rv_reservation_item_ix']."'
							", 1)
						);

						$items = calCreateItem($rv_reservation_ix,$itemInfo,"",array(),"BLANK","0","0",$item['rv_reservation_item_ix']);
						if (!empty($items)) {
							$existingResItem = $GLOBALS['lDB']->get("
								SELECT
									bl_series_id,
									bl_series_sequence_number
								FROM
									rv_reservation_item
								WHERE
									rv_reservation_item_ix = '".$item['rv_reservation_item_ix']."'
							", 1);

							foreach ($items as $newResItem) {
								$GLOBALS['lDB']->put("
									UPDATE
										rv_reservation_item
									SET
										bl_series_id = '" . $existingResItem['bl_series_id'] . "',
										bl_series_sequence_number = '" . $existingResItem['bl_series_sequence_number'] . "'
									WHERE
										rv_reservation_item_ix = '" . $newResItem . "'
								");
							}
							calDeleteItem($item['rv_reservation_item_ix'], $rv_reservation_ix);
						}

						foreach ($items as $afterItems) {
							$itemsBefore[$afterItems] = $beforeValues;
						}
					}
					// Update block departure expiry date here
					if (!empty($item['rv_alloc_expiry_date'])) {
						foreach ($items as $itemId) {
							db_rv_reservation_item_set_departure_expiry($itemId, $item['rv_alloc_expiry_date']);
						}
					}
					if($item['rv_reservation_item_ix'] == "") {
						calCreateItemAudit($items, $rv_reservation_ix);
					} else {
						$allocationAuditTrail = new AuditTrail($rv_reservation_ix,TYPE_RESERVATION);
						foreach ($items as $allocationItemId) {
							$allocationItemAfter = $GLOBALS['lDB']->get("
								SELECT
									rv_reservation_item.rv_reservation_item_ix,
									rv_reservation_item.rv_item_date_arrive,
									rv_reservation_item.rv_item_date_depart,
									rv_reservation_item.rv_item_adult_count,
									rv_reservation_item.rv_item_child_count,
									rv_reservation_item.rv_item_nights,
									rv_reservation_item.rv_item_accomm_count,
									rv_reservation_item.rv_alloc_expiry_date,
									rv_reservation_item.ac_accomm_type_id
								FROM
									rv_reservation_item
								WHERE
									rv_reservation_item_ix = '$allocationItemId'
							", 1);
							foreach ($moduleFieldValues as $moduleFieldValue) {
								$moduleFieldName = explode(".", $moduleFieldValue['ad_module_field_name'])[1];
								$allocationAuditTrail->addDetail(
									$itemsBefore[$allocationItemId]['values'][$moduleFieldName],
									$allocationItemAfter[$moduleFieldName],
									$itemsBefore[$allocationItemId]['id'],
									$allocationItemId,
									DB_AD_RES_DETAIL_ACTION_EDIT,
									"resitinerary",
									$moduleFieldValue['ad_module_field_name']
								);
							}
						}
						$allocationAuditTrail->save("Itinerary (Edit)");
					}
				}
			}
		}
	}
}

function deleteAllocation($rv_reservation_ix,$rv_reservation_item_ix,$bl_series_id=null) {
	if($rv_reservation_item_ix == "") {
		$linkList = $GLOBALS['lDB']->get("
			SELECT
				COUNT(*)
			FROM
				rv_reservation_item
				INNER JOIN rv_reservation_item AS link_item ON link_item.rv_reservation_item_ix = rv_reservation_item.rv_link_res_item_id
			WHERE
				rv_reservation_item.rv_reservation_id = '$rv_reservation_ix'
		",4);
		if($linkList > 0) {
            $yesterday = date("Y-m-d",strtotime("-1 days"));
			$GLOBALS['lDB']->put("
				UPDATE
					rv_reservation
				SET
					rv_alloc_expiry_date = '$yesterday',
					rv_alloc_expiry_days = '0'
				WHERE
					rv_reservation.rv_reservation_ix = '$rv_reservation_ix'
			");
			ammendReservation($rv_reservation_ix,"Delete (Expired: $yesterday)");
            $blockAllocationItems = $GLOBALS['lDB']->get("
                SELECT
                    rv_reservation_item.rv_reservation_item_ix
                FROM
                    rv_reservation_item
                    INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
                WHERE
                    rv_reservation_item.rv_reservation_id = '$rv_reservation_ix'
                    AND (
                        rv_reservation.bl_block_period_id IS NOT NULL
                        AND rv_reservation.bl_block_period_id != ''
                    )
                    AND (
                        rv_reservation_item.rv_alloc_expiry_date = '0000-00-00'
                        OR rv_reservation_item.rv_alloc_expiry_date >= CURDATE()
                        OR rv_reservation_item.rv_alloc_expiry_date IS NULL
                    )
            ",6);
            foreach($blockAllocationItems as $blockAllocationItem) {
                $GLOBALS['lDB']->put("
                    UPDATE
                        rv_reservation_item
                    SET
                        rv_reservation_item.rv_alloc_expiry_date = '$yesterday'
                    WHERE
                        rv_reservation_item.rv_reservation_item_ix = '".$blockAllocationItem['rv_reservation_item_ix']."'
                ");
                ammendReservation($rv_reservation_ix,"Delete (Expired item: $yesterday)");
            }
		} else {
			$GLOBALS['lDB']->put("
				UPDATE rv_reservation SET rf_reservation_status_id = '97' WHERE rv_reservation.rv_reservation_ix = '$rv_reservation_ix'
			");
			ammendReservation($rv_reservation_ix,"Delete (Status 97)");
		}
		$allocationItems = $GLOBALS['lDB']->get("
			SELECT
				rv_reservation_item.ac_accomm_type_id,
				rv_reservation_item.rv_item_date_arrive,
				rv_reservation_item.rv_item_date_depart
			FROM
				rv_reservation_item
			WHERE
				rv_reservation_item.rv_reservation_id = '$rv_reservation_ix'
		",6);
		foreach ($allocationItems as $allocationItem) {
			// Clear cache
			$dates = makeDates($allocationItem['rv_item_date_arrive'].":".$allocationItem['rv_item_date_depart'],dateSubtract($allocationItem['rv_item_date_depart'],$allocationItem['rv_item_date_arrive']) + 1);
			$stock = new Stock($allocationItem['ac_accomm_type_id'],$allocationItem['rv_item_date_arrive'],$allocationItem['rv_item_date_depart']);
			$stock->ClearCache(array('agentAllocation','occupancy'), $dates);
		}
	} else {
		if (empty($bl_series_id)) {
			calDeleteItem($rv_reservation_item_ix,$rv_reservation_ix);
			ammendReservation($rv_reservation_ix,"Allocation item deleted");
		} else {
			$allocationItems = $GLOBALS['lDB']->get("
				SELECT
					rv_reservation_item.rv_reservation_item_ix
				FROM
					rv_reservation_item
				WHERE
					rv_reservation_item.bl_series_id = '$bl_series_id'
			",6);
			$allocationSeriesCount = $GLOBALS['lDB']->get("
                SELECT
                    COUNT(DISTINCT rv_reservation_item.bl_series_id)
                FROM
                    rv_reservation_item
                WHERE
                    rv_reservation_item.rv_reservation_id = '".$rv_reservation_ix."'
                    AND rv_reservation_item.rv_item_accomm_count > 0
			",4);
            if ($allocationSeriesCount > 1) {
                foreach ($allocationItems as $allocationItem) {
                    calDeleteItem($allocationItem['rv_reservation_item_ix'],$rv_reservation_ix);
                    ammendReservation($rv_reservation_ix,"Allocation block item deleted");
                }
            }
		}
	}
}

function generateList($pr_agent_id,$pastCheck,$showOverbookingsOnly) {
	$pastSQL = "
		AND rv_reservation.rf_reservation_status_id <> '97'
		AND rv_reservation.rv_date_depart >= '".date("Y-m-d")."'
	";
	if($pastCheck) {
		$pastSQL = "";
	}
	$allocationList = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			rv_reservation.rv_reservation_ix,
			rv_reservation.rv_res_name,
			rv_reservation.rf_reservation_status_id,
			CASE rv_reservation_item.rv_alloc_expiry_date
				WHEN '0000-00-00' THEN rv_reservation.rv_alloc_expiry_date
				WHEN NULL THEN rv_reservation.rv_alloc_expiry_date
				ELSE rv_reservation_item.rv_alloc_expiry_date
			END AS rv_alloc_expiry_date,
			rv_reservation.rv_alloc_expiry_days,
			rv_reservation.rv_date_arrive,
			rv_reservation.rv_date_depart,
			rv_reservation_item.rv_reservation_item_ix,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			rv_reservation_item.rv_item_nights,
			rv_reservation_item.rv_item_accomm_count,
			rv_reservation_item.rv_item_adult_count,
			rv_reservation_item.rv_item_child_count,
			rv_reservation_item.pr_business_id,
			property.pr_name_last as property_name,
			ac_accomm_type.ac_accomm_type_ix,
			CASE
				WHEN LENGTH(ac_accomm_type.ac_accomm_desc) > 15 THEN CONCAT(LEFT(ac_accomm_type.ac_accomm_desc, 15), '...')
				ELSE ac_accomm_type.ac_accomm_desc
			END AS ac_accomm_desc,
			consultant.pr_name_last as consultant_name_last,
			consultant.pr_name_first as consultant_name_first,
			consultant.pr_persona_ix as consultant_id,
			contact.pr_name_last as contact_name_last,
			contact.pr_name_first as contact_name_first,
			contact.pr_persona_ix as contact_id,
			bl_block.bl_block_ix,
			bl_block.bl_block_name,
			bl_block_period.bl_per_expiry_ind,
			bl_block_period.bl_per_expiry_lead_time_days,
			bl_block_period.bl_per_expiry_lead_time_date,
			rv_reservation_item.bl_series_sequence_number,
			rv_reservation_item.bl_series_id,
			MAX(rv_reservation_item.bl_series_sequence_number) AS sequence_max
		FROM
			rv_reservation_item
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			INNER JOIN pr_persona as property ON property.pr_persona_ix = rv_reservation_item.pr_business_id
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
			LEFT JOIN pr_persona as consultant ON consultant.pr_persona_ix = rv_reservation.rv_consultant_id
			LEFT JOIN pr_persona as contact ON contact.pr_persona_ix = rv_reservation.rv_corr_persona_id
			LEFT JOIN rv_reservation_item as link_item ON link_item.rv_reservation_item_ix = rv_reservation_item.rv_link_res_item_id
			LEFT JOIN bl_block_itinerary ON bl_block_itinerary.bl_block_itinerary_ix = rv_reservation_item.bl_block_itinerary_id
			LEFT JOIN bl_block_period ON bl_block_period.bl_block_period_ix = bl_block_itinerary.bl_block_period_id
			LEFT JOIN bl_block ON bl_block.bl_block_ix = bl_block_period.bl_block_id
		WHERE
			rv_reservation.rv_agent_id = '$pr_agent_id'
			AND rv_reservation.rv_reservation_type_ind = 5
			AND link_item.rv_reservation_item_ix IS NULL
			$pastSQL
		GROUP BY
			rv_reservation.rv_reservation_ix,
			rv_reservation.rv_res_name,
			rv_reservation.rf_reservation_status_id,
			rv_alloc_expiry_date,
			rv_reservation.rv_alloc_expiry_days,
			rv_reservation.rv_date_arrive,
			rv_reservation.rv_date_depart,
			rv_reservation_item.rv_reservation_item_ix,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			rv_reservation_item.rv_item_nights,
			rv_reservation_item.rv_item_accomm_count,
			rv_reservation_item.rv_item_adult_count,
			rv_reservation_item.rv_item_child_count,
			rv_reservation_item.pr_business_id,
			property_name,
			ac_accomm_type.ac_accomm_type_ix,
			ac_accomm_desc,
			consultant_name_last,
			consultant_name_first,
			consultant_id,
			contact_name_last,
			contact_name_first,
			contact_id,
			bl_block.bl_block_ix,
			bl_block.bl_block_name,
			rv_reservation_item.bl_series_sequence_number
		ORDER BY
			rv_reservation.rv_reservation_ix,
			rv_reservation_item.bl_series_id,
			rv_reservation_item.bl_series_sequence_number,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			rv_reservation_item.rv_item_nights
	",2);
	$allocationRows = "";
	$onClickAction = $GLOBALS['lDB']->isMaster == 0 ? "" : "allocationResEdit(this);";
	$deleteButtonDisplay = $GLOBALS['lDB']->isMaster == 0 ? "display: none;" : "";
	$allocationHeaderHTML = "
		<tr class=\"linkrow colLtt\" onmouseover=\"mouseOverRes(this);\"  onmouseout=\"mouseOutRes(this);\" onclick=\"" . $onClickAction . "\" rv_reservation_ix=\"!rv_reservation_ix!\">
			<td class=\"txtb\" colspan=\"10\">!rv_reservation_ix!; !rv_res_name!; !consultant_name!; !contact_name!; !expire!!block_name!</td>
			<td align=\"center\">!res_delete_button!</td>
			<td align=\"center\"><input type=\"button\" class=\"button bCenterBG bAudit\" onclick=\"openPopup('/reservation.php?700+!rv_reservation_ix!',1080,600); event.cancelBubble=true;\" onmouseover=\"overlib('Audit trail',LEFT,ABOVE,WIDTH,60);\" onmouseout=\"nd();\" style=\"width: 24px;\"/>
		</tr>
	";
	$allocationInactiveHeaderHTML = "
		<tr class=\"colLtt\" rv_reservation_ix=\"!rv_reservation_ix!\">
			<td class=\"txtg\" colspan=\"10\">!rv_reservation_ix!; !rv_res_name!; !consultant_name!; !contact_name!; !expire! !block_name!</td>
			<td class=\"txtg\" align=\"center\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" width=\"1\" height=\"20\" alt=\"\" /></td>
		</tr>
	";
	$allocationHTML = "
		<tr class=\"linkrow !textClass!\" onmouseover=\"mouseOverRes(this);\"  onmouseout=\"mouseOutRes(this);\" onclick=\"" . $onClickAction . "\" rv_reservation_ix=\"!rv_reservation_ix!\">
			<td class=\"!cellClass1!\" style=\"height: 20px; line-height: 20px;\">!bl_series_sequence_number!</td>
			<td class=\"!cellClass2!\" style=\"height: 20px; line-height: 20px;\">!property_name!</td>
			<td class=\"!cellClass2!\" style=\"height: 20px; line-height: 20px;\" ac_accomm_type_id=\"!ac_accomm_type_ix!\" onmouseover=\"overlib('!ac_accomm_desc_js!');\" onmouseout=\"nd();\">!ac_accomm_desc!</td>
			<td class=\"!cellClass2!\">!rv_alloc_expiry_date_fmt!</td>
			<td class=\"!cellClass2!\">!rv_item_date_arrive_fmt!</td>
			<td class=\"!cellClass2!\">!rv_item_date_depart_fmt!</td>
			<td class=\"!cellClass2!\" align=\"center\">!rv_item_nights!</td>
			<td class=\"!cellClass2!\" align=\"center\">!rv_item_accomm_count!</td>
			<td class=\"!cellClass2!\" align=\"center\">!rv_item_adult_count!</td>
			<td class=\"!cellClass2!\" align=\"center\">!overbooking_button!</td>
			<td class=\"!cellClass2!\" align=\"center\">!delete_button!</td>
		</tr>
	";
	$allocationInactiveHTML = "
		<tr rv_reservation_ix=\"!rv_reservation_ix!\">
			<td class=\"txtg !cellClass1!\" style=\"height: 20px; line-height: 20px;\">!bl_series_sequence_number!</td>
			<td class=\"txtg !cellClass2!\">!property_name!</td>
			<td class=\"txtg !cellClass2!\" ac_accomm_type_id=\"!ac_accomm_type_ix!\" onmouseover=\"overlib('!ac_accomm_desc_js!');\" onmouseout=\"nd();\">!ac_accomm_desc!</td>
			<td class=\"txtg !cellClass2!\">!rv_alloc_expiry_date_fmt!</td>
			<td class=\"txtg !cellClass2!\">!rv_item_date_arrive_fmt!</td>
			<td class=\"txtg !cellClass2!\">!rv_item_date_depart_fmt!</td>
			<td class=\"txtg !cellClass2!\" align=\"center\">!rv_item_nights!</td>
			<td class=\"txtg !cellClass2!\" align=\"center\">!rv_item_accomm_count!</td>
			<td class=\"txtg !cellClass2!\" align=\"center\">!rv_item_adult_count!</td>
			<td class=\"txtg !cellClass2!\" align=\"center\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" width=\"1\" height=\"20\" alt=\"\" /></td>
			<td class=\"txtg !cellClass3!\" align=\"center\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" width=\"1\" height=\"20\" alt=\"\" /></td>
		</tr>
	";
	$rv_reservation_ix = null;
	$isBlockBooking = false;
	$allocationOverbookings = array();
	$sequence_max = 0;
	$blClassTop1 = "";
	$blClassTop2 = "";
	$blClassTop3 = "";
	$blClassMiddle1 = "";
	$blClassMiddle2 = "";
	$blClassBottom1 = "";
	$blClassBottom2 = "";
	$blClassBottom3 = "";

	$overbookedItems = array();
	$item_count = array();
	$numberAllocations = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			COUNT(rv_reservation.rv_reservation_ix) AS num_allocations
		FROM
			rv_reservation
		WHERE
			rv_reservation.rv_agent_id = '$pr_agent_id'
			AND rv_reservation.rv_reservation_type_ind = 5
			$pastSQL
	",4);
	$allocationCounter = 0;
	foreach($allocationList as $item) {
		if (!isset($item_count[$item['rv_reservation_ix']])) {
			$item_count[$item['rv_reservation_ix']] = 1;
		} else {
			$item_count[$item['rv_reservation_ix']]++;
		}
		if($rv_reservation_ix != $item['rv_reservation_ix'] || $allocationCounter == $numberAllocations) {
			$rv_reservation_ix = empty($rv_reservation_ix) ? $item['rv_reservation_ix'] : $rv_reservation_ix;
			$isBlockBooking = $item['bl_block_ix'] != "" ? true : false;
			$sequence_max = $isBlockBooking ? $item['sequence_max'] : 0;
			$overbookings = getOverbookings($rv_reservation_ix);
			$allocationOverbookings[$rv_reservation_ix] = $overbookings;
			if ($showOverbookingsOnly) {
				$overbookedItems = array_merge(array_keys($overbookings), $overbookedItems);
			}
			$allocationCounter += 1;
		}
		$rv_reservation_ix = $item['rv_reservation_ix'];
	}
	$rv_reservation_ix = null;
	foreach($allocationList as $item) {
		// if showOverbookingsOnly == true remove all items that aren't part of an overbooking scenario
		// if it is part of a block, show show only the overbooked items or those that are part of its block
		$showItem = true;
		if ($showOverbookingsOnly) {
			if (!(in_array($item['rv_reservation_item_ix'], $overbookedItems) || in_array($item['bl_series_id'], $overbookedItems))) {
				$showItem = false;
			}
		}
		if ($showItem) {
			$linkCount = $GLOBALS['lDB']->get("
				SELECT
					COUNT(*)
				FROM
					rv_reservation_item
					INNER JOIN rv_reservation_item as link_item ON link_item.rv_reservation_item_ix = rv_reservation_item.rv_link_res_item_id
				WHERE
					rv_reservation_item.rv_reservation_id = '$item[rv_reservation_ix]'
					AND link_item.pr_business_id =  '$item[pr_business_id]'
					AND link_item.ac_accomm_type_id = '$item[ac_accomm_type_ix]'
					
			",4);
			$item['delete_button'] = "";
			$item['overbooking_button'] = "<img src=\"/resource/Resrequest/Application/public/img/1x1.gif\">";
			$item['ac_accomm_desc_js'] = t_encodeOverlib($item['ac_accomm_desc']);
			$item['item_count'] = $item_count[$item['rv_reservation_ix']];
			if($linkCount == "0") {
				$item['delete_button'] = "<input type=\"button\" class=\"button bDelete16 bCenterBG\" onclick=\"delListItemConfirm(event,'$item[rv_reservation_ix]','$item[rv_reservation_item_ix]',$item[item_count],'$item[bl_series_id]');\" style=\"" . $deleteButtonDisplay . "\" />";
			} else {
				$item['delete_button'] = "<img src=\"/resource/Resrequest/Application/public/img/1x1.gif\">";
			}
			$textClass = "";
			if($item['rv_alloc_expiry_date'] != "0000-00-00") {
				if($item['rv_alloc_expiry_date'] < date("Y-m-d")) {
					$textClass = "colRed";
				}
			} else {
				$daysToStart = dateSubtract($item['rv_item_date_arrive'],date("Y-m-d"));
				$daysToEnd = dateSubtract($item['rv_item_date_depart'],date("Y-m-d"));
				if($item['rv_alloc_expiry_days'] > $daysToStart) {
					$textClass = "colOrange";
				}
				if($item['rv_alloc_expiry_days'] > $daysToEnd) {
					$textClass = "colRed";
				}
			}
			$item['block_name'] = (empty($item['bl_block_name'])) ? "" : "; Block: " . $item['bl_block_name'];
			
			if($rv_reservation_ix != $item['rv_reservation_ix']) {
				$isBlockBooking = $item['bl_block_ix'] != "" ? true : false;
				$sequence_max = $isBlockBooking ? $item['sequence_max'] : 0;
				if ($isBlockBooking) {
					$blClassFirst1 = " bl bt ";
					$blClassFirst2 = " bt ";
					$blClassFirst3 = " bt br ";
					$blClassMiddle1 = " bl ";
					$blClassMiddle2 = " br ";
					$blClassLast1 = " bl bb ";
					$blClassLast2 = " bb ";
					$blClassLast3 = " bb br ";
				} else {
					$blClassFirst1 = "";
					$blClassFirst2 = "";
					$blClassFirst3 = "";
					$blClassMiddle1 = "";
					$blClassMiddle2 = "";
					$blClassLast1 = "";
					$blClassLast2 = "";
					$blClassLast3 = "";
				}
				$totalLinkCount = $GLOBALS['lDB']->get("
					SELECT
						COUNT(*)
					FROM
						rv_reservation_item
						INNER JOIN rv_reservation_item as link_item ON link_item.rv_reservation_item_ix = rv_reservation_item.rv_link_res_item_id
					WHERE
						rv_reservation_item.rv_reservation_id = '$item[rv_reservation_ix]'				
				",4);
				$item['res_delete_button'] = "";
				$item['res_link_button'] = "<input type=\"button\" class=\"button bCenterBG bSummary16\" onclick=\"event.cancelBubble = true; showReservations(event,'" .  $item['rv_reservation_ix'] . "');\" onmouseover=\"overlib('Linked reservations',LEFT,ABOVE,WIDTH,105);\" onmouseout=\"nd();\">";
				if($totalLinkCount == "0") {
					$item['res_delete_button'] = "<input type=\"button\" class=\"button bCenterBG bDelete16\" onclick=\"delListConfirm(event,'" . $item['rv_reservation_ix'] . "');\" style=\"" . $deleteButtonDisplay . "\">";
					$item['res_link_button'] = "";
				}
				$item['consultant_name'] = trim($item['consultant_name_first'] . " " . $item['consultant_name_last']);
				if($item['consultant_name'] == "") {
					$item['consultant_name'] = "No consultant";
				}
				$item['contact_name'] = trim($item['contact_name_first'] . " " . $item['contact_name_last']);
				if($item['contact_name'] == "") {
					$item['contact_name'] = "No contact";
				}
				$rv_reservation_ix = $item['rv_reservation_ix'];
				$expire = "";
				if ($item['bl_block_ix'] == "") {
					if($item['rv_alloc_expiry_date'] != "0000-00-00") {
						$expire = "Expires on " . chng_date($item['rv_alloc_expiry_date'],"-");
					} else {
						$expire = "Expiry lead time of $item[rv_alloc_expiry_days] day";
						if($item['rv_alloc_expiry_days'] > 1) {
							$expire .= "s";
						}
					}
				} else {
					$expire = getExpiryDescription(
						$item["bl_per_expiry_ind"],
						$item["bl_per_expiry_lead_time_days"],
						$item["bl_per_expiry_lead_time_date"]
					);
				}
				$item['expire'] = $expire;
				$item['property_list'] = join(":",$GLOBALS['lDB']->get("SELECT pr_business_id FROM rv_reservation_item WHERE rv_reservation_id = '$item[rv_reservation_ix]'",3));
				if($item['rf_reservation_status_id'] == "97") {
					$allocationRows .= showpage($item,$allocationInactiveHeaderHTML);
				} else {
					$item['textClass'] = $textClass;
					$allocationRows .= showpage($item,$allocationHeaderHTML);
				}
			}
			$item['rv_alloc_expiry_date_fmt'] = $item['bl_series_sequence_number'] == 1 ? chng_date($item['rv_alloc_expiry_date'],"-") : "&nbsp;";
			$item['rv_item_date_arrive_fmt'] = chng_date($item['rv_item_date_arrive'],"-");
			$item['rv_item_date_depart_fmt'] = chng_date($item['rv_item_date_depart'],"-");
			$item['textClass'] = $textClass;
			$item['cellClass1'] = "";
			$item['cellClass2'] = "";
			$item['cellClass3'] = "";
			if ($isBlockBooking) {
				if ($item['bl_series_sequence_number'] == 1) {
					// first in sequence
					$item['cellClass1'] = $blClassFirst1;
					$item['cellClass2'] = $blClassFirst2;
					$item['cellClass3'] = $blClassFirst3;
				} elseif ($item['bl_series_sequence_number'] == $sequence_max) {
					// last in sequence
					$item['cellClass1'] = $blClassLast1;
					$item['cellClass2'] = $blClassLast2;
					$item['cellClass3'] = $blClassLast3;
				} else {
					// in between first and last
					$item['cellClass1'] = $blClassMiddle1;
					$item['cellClass2'] = "";
					$item['cellClass3'] = $blClassMiddle2;
				}
			}
			if (isset($allocationOverbookings[$item['rv_reservation_ix']][$item['rv_reservation_item_ix']])) {
				// this allocation item has overbookings
				$item['overbooking_button'] = "<input type=\"button\" class=\"button bCenterBG bOverbook16\" onclick=\"overbookPopup(event,'".$item['rv_reservation_ix']."');\" onmouseover=\"overlib('View overbooking details',LEFT, WIDTH, 80);\" onmouseout=\"nd();\" />";
			}
			if($item['rf_reservation_status_id'] == "97") {
				$allocationRows .= showpage($item,$allocationInactiveHTML);
			} else {
				$item['textClass'] = $textClass;
				$allocationRows .= showpage($item,$allocationHTML);
			}
		}
	}
	if($allocationRows == "") {
		$allocationRows = "
			<tr>
				<td colspan=\"11\" align=\"center\"><em>No allocations defined</em></td>	
			</tr>
		";
	} else {
		$allocationRows = "<tbody id=\"allocationRows\">" . $allocationRows . "</tbody>";
	}
	$GLOBALS['temp']['allocationRows'] = $allocationRows;	

	$GLOBALS['temp']['propertyIdList'] = join(":",$GLOBALS['lDB']->get("
		SELECT DISTINCT
			ac_accomm_type.pr_business_id
		FROM
			sc_accomm, ac_accomm_type, pr_business, pr_persona
		WHERE
			sc_accomm.sc_group_id= '$GLOBALS[sc_group_id]'
			AND sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
			AND ac_accomm_type.ac_accomm_type_inactive_yn=0
			AND ac_accomm_type.pr_business_id = pr_business.pr_business_id
			/*AND pr_business.pr_bus_inactive_yn= '0'*/
			AND pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
	",3));
	$GLOBALS['temp']['accommIdList'] = join(":",$GLOBALS['lDB']->get("
		SELECT DISTINCT
			ac_accomm_type.ac_accomm_type_ix
		FROM
			sc_accomm, ac_accomm_type
		WHERE
			sc_accomm.sc_group_id= '$GLOBALS[sc_group_id]'
			AND sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
	",3));
	$GLOBALS['temp']['displayBlock'] = "none";
	$GLOBALS['temp']['tblAllocationsTitle'] = "
		<table cellspacing=\"0\" align=\"center\" width=\"100%\">
			<tbody>
				<tr>
					<td class=\"outDk\" height=\"25\" align=\"center\" width=\"20\">
						<img class=\"imgLink\" height=\"18\" width=\"18\" onmouseout=\"cancelTimer()\" onmouseover=\"\" src=\"/resource/Resrequest/Application/public/img/info_std.gif\" name=\"info1\"></img>
					</td>
					<td class=\"outDk txtb\">
						<span id=\"titleSpan\">
							Allocation List
						</span>
					</td>
				</tr>
			</tbody>
		</table>
	";
}

function generateAdd($pr_agent_id) {
	global $lDB;
	$GLOBALS['temp']['rv_res_name'] = "";
	$GLOBALS['temp']['rv_agent_ref'] = "";
	$GLOBALS['temp']['contact_name'] = "";
	$GLOBALS['temp']['rv_date_recorded_fmt'] = chng_date(date("Y-m-d"),"-");
	$GLOBALS['temp']['rv_date_changed_fmt'] = chng_date(date("Y-m-d"),"-");
	$GLOBALS['temp']['rv_commission_perc'] = $lDB->get("SELECT pr_agent_commission_perc FROM pr_agent WHERE pr_agent_id = '$pr_agent_id'",4);
	$GLOBALS['temp']['rv_alloc_expiry_days'] = "0";
	$GLOBALS['temp']['rv_alloc_expiry_date'] = "";
	$GLOBALS['temp']['rv_note_general'] = "";
	$GLOBALS['temp']['rv_note_internal'] = "";
	$GLOBALS['temp']['rv_corr_persona_id'] = "";
	$GLOBALS['temp']['bl_block_ix'] = "";
	$GLOBALS['temp']['displayBlock'] = "none";
	$GLOBALS['temp']['newModeRow'] = "true";
	$GLOBALS['temp']['allocationRows'] = "
		<tr>
			<td colspan=\"11\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>
		</tr>
	";	
	createAccommOptions();
	createRateOptions();
	createConsultantOptions();	
	$GLOBALS['temp']['tblAllocationsTitle'] = "
		<table cellspacing=\"0\" align=\"center\" width=\"100%\">
			<tbody>
				<tr>
					<td class=\"outDk\" height=\"25\" align=\"center\" width=\"20\">
						<img class=\"imgLink\" height=\"18\" width=\"18\" onmouseout=\"cancelTimer()\" onmouseover=\"\" src=\"/resource/Resrequest/Application/public/img/info_std.gif\" name=\"info1\"></img>
					</td>
					<td class=\"outDk txtb\">
						<span id=\"titleSpan\">
							Allocation Add
						</span>
					</td>
				</tr>
			</tbody>
		</table>
	";
}

function generateEdit($rv_reservation_ix,$showOverbookingsOnly) {
	$allocationList = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			rv_reservation.rv_reservation_ix,
			rv_reservation.rv_res_name,
			rv_reservation.rf_reservation_status_id,
			rv_reservation.rv_agent_ref,
			rv_reservation.rv_note_general,
			rv_reservation.rv_note_internal,
			rv_reservation.rv_date_recorded,
			rv_reservation.rv_date_changed,
			rv_reservation.rv_commission_perc,
			rv_reservation.rv_alloc_expiry_days,
			CASE rv_reservation_item.rv_alloc_expiry_date
				WHEN '0000-00-00' THEN rv_reservation.rv_alloc_expiry_date
				WHEN NULL THEN rv_reservation.rv_alloc_expiry_date
				ELSE rv_reservation_item.rv_alloc_expiry_date
			END AS rv_alloc_expiry_date,
			rv_reservation.rv_alloc_expiry_date AS rv_alloc_expiry_date_top,
			rv_reservation.rv_corr_persona_id,
			rv_reservation_item.rv_reservation_item_ix,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			rv_reservation_item.rv_item_nights,
			rv_reservation_item.rv_item_accomm_count,
			rv_reservation_item.rv_item_adult_count,
			rv_reservation_item.rv_item_child_count,
			rv_reservation_item.pr_business_id,
			property.pr_name_last as property_name,
			ac_accomm_type.ac_accomm_type_ix,
			CASE
				WHEN LENGTH(ac_accomm_type.ac_accomm_desc) > 15 THEN CONCAT(LEFT(ac_accomm_type.ac_accomm_desc, 15), '...')
				ELSE ac_accomm_type.ac_accomm_desc
			END AS ac_accomm_desc,
			consultant.pr_name_last as consultant_name_last,
			consultant.pr_name_first as consultant_name_first,
			consultant.pr_persona_ix as consultant_id,
			contact.pr_name_last as contact_name_last,
			contact.pr_name_first as contact_name_first,
			contact.pr_persona_ix as contact_id,
			rt_rate_type.rt_rate_type_ix AS rt_rate_type_id,
			rt_rate_type.rt_rate_type_desc,
			bl_block.bl_block_ix,
			bl_block.bl_block_name,
			rv_reservation_item.bl_series_sequence_number,
			rv_reservation_item.bl_series_id
		FROM
			rv_reservation_item
			LEFT JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			LEFT JOIN pr_persona as property ON property.pr_persona_ix = rv_reservation_item.pr_business_id
			LEFT JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
			LEFT JOIN pr_persona as consultant ON consultant.pr_persona_ix = rv_reservation.rv_consultant_id
			LEFT JOIN pr_persona as contact ON contact.pr_persona_ix = rv_reservation.rv_corr_persona_id
			LEFT JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id
			LEFT JOIN rv_reservation_item as link_item ON link_item.rv_reservation_item_ix = rv_reservation_item.rv_link_res_item_id			
			LEFT JOIN bl_block_itinerary ON bl_block_itinerary.bl_block_itinerary_ix = rv_reservation_item.bl_block_itinerary_id
			LEFT JOIN bl_block_period ON bl_block_period.bl_block_period_ix = bl_block_itinerary.bl_block_period_id
			LEFT JOIN bl_block ON bl_block.bl_block_ix = bl_block_period.bl_block_id
		WHERE
			rv_reservation.rv_reservation_ix = '$rv_reservation_ix'
			AND link_item.rv_reservation_item_ix IS NULL
		ORDER BY
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			rv_reservation_item.bl_series_id,
			rv_reservation_item.bl_series_sequence_number,
			rv_reservation_item.rv_item_nights

	",2);

    $allocationStatus = "";
	if ( sizeof($allocationList) > 0 ) {
		$allocationList[0]['rv_date_recorded_fmt'] = chng_date($allocationList[0]['rv_date_recorded'],"-");
		$allocationList[0]['rv_date_changed_fmt'] = chng_date($allocationList[0]['rv_date_changed'],"-");
		$allocationList[0]['consultant_name'] = trim($allocationList[0]['consultant_name_first'] . " " . $allocationList[0]['consultant_name_last']);
		$allocationList[0]['contact_name'] = trim($allocationList[0]['contact_name_first'] . " " . $allocationList[0]['contact_name_last']);
		$GLOBALS['temp'] = array_merge($GLOBALS['temp'],$allocationList[0]);
		$GLOBALS['temp']['rv_alloc_expiry_date'] = $allocationList[0]['rv_alloc_expiry_date_top'];

        $allocationStatus = $allocationList[0]['rf_reservation_status_id'];
	}
	$GLOBALS['temp']['allocationDeleted'] = $allocationStatus == '97' ? "hide" : "";

	$allocationRows = "";

	$allocationHTML = "
		<tr !row_attributes!  rv_reservation_item_ix=\"!rv_reservation_item_ix!\" bl_series_id=\"!bl_series_id!\" deleted=\"\" edited=\"\">
			<td class=\"!cellClass1! !cell_class!\" style=\"height: 20px; line-height: 20px;\">!bl_series_sequence_number!</td>
			<td class=\"!cellClass2! !cell_class!\">!property_name!</td>
			<td class=\"!cellClass2! !cell_class!\"ac_accomm_type_id=\"!ac_accomm_type_ix!\" onmouseover=\"overlib('!ac_accomm_desc_js!');\" onmouseout=\"nd();\">!ac_accomm_desc!</td>
			<td class=\"!cellClass2! !cell_class! !cell_class_transparent!\">!rv_alloc_expiry_date_fmt!</td>
			<td class=\"!cellClass2! !cell_class!\">!rv_item_date_arrive_fmt!</td>
			<td class=\"!cellClass2! !cell_class!\">!rv_item_date_depart_fmt!</td>
			<td class=\"!cellClass2! !cell_class!\" align=\"center\">!rv_item_nights!</td>
			<td class=\"!cellClass2! !cell_class!\" align=\"center\">!rv_item_accomm_count!</td>
			<td class=\"!cellClass2! !cell_class!\" align=\"center\">!rv_item_adult_count!</td>
			<td class=\"!cellClass2!\" align=\"center\">!overbooking_button!</td>
			<td class=\"!cellClass2! !cell_class!\" align=\"center\" !drawdown_reservations!>!drawdown_count!</td>
			<td class=\"!cellClass3! !cell_class!\" align=\"center\">!delete_button!</td>
		</tr>
	";

	$isBlockBooking = false;
	$allocationOverbookings = array();
	$overbookings = getOverbookings($rv_reservation_ix);
	$overbookedItems = array();
	if ($showOverbookingsOnly) {
		$overbookedItems = array_keys($overbookings);
	}
	$allocationOverbookings[$rv_reservation_ix] = $overbookings;
	$sequence_max = 0;
	$blClassTop1 = "";
	$blClassTop2 = "";
	$blClassTop3 = "";
	$blClassMiddle1 = "";
	$blClassMiddle2 = "";
	$blClassBottom1 = "";
	$blClassBottom2 = "";
	$blClassBottom3 = "";

	foreach($allocationList as $item) {
		// if showOverbookingsOnly == true remove all items that aren't part of an overbooking scenario
		// if it is part of a block, show show only the overbooked items or those that are part of its block
		$showItem = true;
		if ($showOverbookingsOnly) {
			if (!(in_array($item['rv_reservation_item_ix'], $overbookedItems) || in_array($item['bl_series_id'], $overbookedItems))) {
				$showItem = false;
			}
		}
		if ($showItem) {
			$isBlockBooking = $item['bl_block_ix'] != "" ? true : false;
			$textClass = "";
			if($item['rv_alloc_expiry_date'] != "0000-00-00") {
				if($item['rv_alloc_expiry_date'] < date("Y-m-d")) {
					$textClass = "colRed";
				}
			} else {
				$daysToStart = dateSubtract($item['rv_item_date_arrive'],date("Y-m-d"));
				$daysToEnd = dateSubtract($item['rv_item_date_depart'],date("Y-m-d"));
				if($item['rv_alloc_expiry_days'] > $daysToStart) {
					$textClass = "colOrange";
				}
				if($item['rv_alloc_expiry_days'] > $daysToEnd) {
					$textClass = "colRed";
				}
			}
            $item['delete_button'] = "&nbsp;";

            if ($allocationStatus != '97') {
                $item['row_attributes'] = 'class="linkrow '.$textClass.'" onclick="allocationEdit(this);"';
                if (empty($item['bl_series_sequence_number']) || $item['bl_series_sequence_number'] == 1) {
                    $item['delete_button'] = '<input type="button" class="button bDelete16 bCenterBG" onclick="delItemConfirm(event,this);" onmouseover="overlib(\'Delete Itinerary\',LEFT, WIDTH, 80);" onmouseout="nd();" /><input type="button" class="button bUnDelete16" style="display: none;" onclick="undeleteItem(event,this);" onmouseover="overlib(\'Undelete Itinerary\',LEFT,WIDTH,90);" onmouseout="nd();" />';
                }
                $item['cell_class'] = "txt"; 
            } else {
                $item['cell_class'] = "txtg";
            }
			$item['overbooking_button'] = "<img src=\"/resource/Resrequest/Application/public/img/1x1.gif\">";
			$item['ac_accomm_desc_js'] = t_encodeOverlib($item['ac_accomm_desc']);
			$item['rv_item_date_arrive_fmt'] = chng_date($item['rv_item_date_arrive'],"-");
			$item['rv_item_date_depart_fmt'] = chng_date($item['rv_item_date_depart'],"-");
			$item['cell_class_transparent'] = $item['bl_series_sequence_number'] > 1 ? "txttransparent" : "txt";
			$item['rv_alloc_expiry_date_fmt'] = chng_date($item['rv_alloc_expiry_date'],"-");
			if ($isBlockBooking) {
				$blClassFirst1 = " bl bt ";
				$blClassFirst2 = " bt ";
				$blClassFirst3 = " bt br ";
				$blClassMiddle1 = " bl ";
				$blClassMiddle2 = " br ";
				$blClassLast1 = " bl bb ";
				$blClassLast2 = " bb ";
				$blClassLast3 = " bb br ";
			} else {
				$blClassFirst1 = "";
				$blClassFirst2 = "";
				$blClassFirst3 = "";
				$blClassMiddle1 = "";
				$blClassMiddle2 = "";
				$blClassLast1 = "";
				$blClassLast2 = "";
				$blClassLast3 = "";
			}
			if ($item['bl_series_sequence_number'] == 1) {
				// first in sequence
				$item['cellClass1'] = $blClassFirst1;
				$item['cellClass2'] = $blClassFirst2;
				$item['cellClass3'] = $blClassFirst3;
			} elseif ($item['bl_series_sequence_number'] == $sequence_max) {
				// last in sequence
				$item['cellClass1'] = $blClassLast1;
				$item['cellClass2'] = $blClassLast2;
				$item['cellClass3'] = $blClassLast3;
			} else {
				// in between first and last
				$item['cellClass1'] = $blClassMiddle1;
				$item['cellClass2'] = "";
				$item['cellClass3'] = $blClassMiddle2;
			}
			if (isset($allocationOverbookings[$item['rv_reservation_ix']][$item['rv_reservation_item_ix']])) {
				// this allocation item has overbookings
				$item['overbooking_button'] = "<input type=\"button\" class=\"button bCenterBG bOverbook16\" onclick=\"overbookPopup(event,'".$item['rv_reservation_ix']."');\" onmouseover=\"overlib('View overbooking details',LEFT, WIDTH, 80);\" onmouseout=\"nd();\" />";
			}

			$allocation = $GLOBALS['lDB']->get("
				SELECT
					rv_item_date_arrive,
					rv_item_date_depart,
					ac_accomm_type_id,
					pr_business_id,
					rv_reservation_id
				FROM
					rv_reservation_item
				WHERE
					rv_reservation_item_ix = '" . $item['rv_reservation_item_ix'] . "'
			", 1);
		
			$drawdowns = $GLOBALS['lDB']->get("
				SELECT
					linked.rv_reservation_id as rv_reservation_id
				FROM
					rv_reservation_item
					LEFT JOIN rv_reservation_item linked ON linked.rv_reservation_item_ix = rv_reservation_item.rv_link_res_item_id
				WHERE
					rv_reservation_item.rv_item_date_arrive = '" . $allocation['rv_item_date_arrive'] . "'
					AND rv_reservation_item.rv_item_date_depart = '" . $allocation['rv_item_date_depart'] . "'
					AND rv_reservation_item.ac_accomm_type_id = '" . $allocation['ac_accomm_type_id'] . "'
					AND rv_reservation_item.pr_business_id = '" . $allocation['pr_business_id'] . "'
					AND rv_reservation_item.rv_reservation_id = '" . $allocation['rv_reservation_id'] . "'
					AND rv_reservation_item.rv_link_res_item_id IS NOT NULL
					AND rv_reservation_item.rv_item_accomm_count < 0
			", 3);

			$item['drawdown_count'] = count($drawdowns);
			$item['drawdown_reservations'] = "";
			if (count($drawdowns) > 0) {
				$item['drawdown_reservations'] = "onmouseover=\"overlib('" . join(', ', array_unique($drawdowns)) . "',LEFT,WIDTH,90);\" onmouseout=\"nd();\"";
				// temporarily allow all edits
				$item['row_attributes'] = 'class="linkrow '.$textClass.'" onclick="allocationEdit(this);"';
			}

			$allocationRows .= showpage($item,$allocationHTML);
		}
	}
	if($allocationRows == "") {
		if ($showOverbookingsOnly) {
			$allocationRows = "
				<tr>
					<td colspan=\"11\" class=\"txti\" align=\"center\">No allocations with overbookings found</td>	
				</tr>
			";
		} else {
			$allocationRows = "
				<tr>
					<td colspan=\"11\" class=\"txti\" align=\"center\">No allocations defined</td>	
				</tr>
			";
		}
	}
	$GLOBALS['temp']['allocationRows'] = $allocationRows;

	createAccommOptions();
	if (count($allocationList) > 0) {
		createRateOptions($allocationList[0]['rt_rate_type_id']);
		createConsultantOptions($allocationList[0]['consultant_id']);
	} else {
		createRateOptions(false);
		createConsultantOptions(false);
	}

    $titleText = "Allocation Edit";
    if ($allocationStatus == '97') {
        $titleText = "Allocation Deleted";
    }
	$GLOBALS['temp']['tblAllocationsTitle'] = "
		<table cellspacing=\"0\" align=\"center\" width=\"100%\">
			<tbody>
				<tr>
					<td class=\"outDk\" height=\"25\" align=\"center\" width=\"20\">
						<img class=\"imgLink\" height=\"18\" width=\"18\" onmouseout=\"cancelTimer()\" onmouseover=\"\" src=\"/resource/Resrequest/Application/public/img/info_std.gif\" name=\"info1\"></img>
					</td>
					<td class=\"outDk txtb\">
						<span id=\"titleSpan\">
							$titleText
						</span>
					</td>
				</tr>
			</tbody>
		</table>
	";
	$GLOBALS['temp']['bl_block_ix'] = "";
	$GLOBALS['temp']['bl_block_name'] = "";
	$blockDetails = $GLOBALS['lDB']->get("
		SELECT
			bl_block.bl_block_ix,
			bl_block.bl_block_name
		FROM
			bl_block
			INNER JOIN bl_block_period ON bl_block_period.bl_block_id = bl_block.bl_block_ix
			LEFT JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix AND allocation.rv_reservation_type_ind = '5'
		WHERE
			allocation.rv_reservation_ix = '$rv_reservation_ix'
	",1);
	if (!empty($blockDetails)) {
		$GLOBALS['temp']['displayBlock'] = "";
		$GLOBALS['temp']['hideBlockDetails'] = "display:block;";
		$GLOBALS['temp']['bl_block_ix'] = $blockDetails['bl_block_ix'];
		$GLOBALS['temp']['bl_block_name'] = $blockDetails['bl_block_name'];
	}

	$GLOBALS['temp']['auditHeader'] = "<input type=\"button\" class=\"button bCenterBG bAudit\" onclick=\"openPopup('/reservation.php?700+$rv_reservation_ix',1080,600); event.cancelBubble=true;\" onmouseover=\"overlib('Audit trail',LEFT,ABOVE,WIDTH,60);\" onmouseout=\"nd();\" style=\"width: 24px;\"/>";
}

function createAccommOptions() {
	$accommArray = $GLOBALS['lDB']->get("
		SELECT
			ac_accomm_type.ac_accomm_type_ix,
			pr_name_last,
			ac_accomm_type.ac_accomm_desc,
			ac_accomm_type.ac_accomm_capacity
		FROM
			sc_accomm
			INNER JOIN sc_user ON sc_accomm.sc_group_id = sc_user.sc_group_id AND sc_user.pr_user_id = '$GLOBALS[userid]'
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = sc_accomm.ac_accomm_type_id
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
			INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		WHERE
			ac_accomm_type.ac_accomm_type_inactive_yn = 0
			AND ac_accomm_type.pr_business_id IN ('".join("','",$GLOBALS['property_id'])."')
		ORDER BY
			pr_name_last, ac_accomm_type.ac_accomm_desc	
	",2);
	$accommOptions = "";
	$accommAdults = "";
	foreach($accommArray as $accommItem) {
		$accommOptions .= "
			<tr class=\"imgLink\" onmouseover=\"this.style.backgroundColor = '#CCFFCC'\"  onmouseout=\"this.style.backgroundColor = ''\" onclick=\"allocationSelectAccomm('$accommItem[ac_accomm_type_ix]','".t_encodeOverlib($accommItem['ac_accomm_desc'])."','".t_encodeOverlib($accommItem['pr_name_last'])."');\">
				<td value=\"$accommItem[ac_accomm_type_ix]\" width=\"300\">$accommItem[pr_name_last], $accommItem[ac_accomm_desc]</td>
			</tr>
		";
		$accommAdults .= "accommAdults['$accommItem[ac_accomm_type_ix]'] = $accommItem[ac_accomm_capacity];\n";
	}
	$GLOBALS['temp']['accommOptions'] = $accommOptions;	
	$GLOBALS['temp']['accommAdults'] = $accommAdults;
}

function createRateOptions($rt_rate_type_id=false) {
	if ( $rt_rate_type_id === "false" ) {
		$inactiveRateSQL = "";
	} else {
		$inactiveRateSQL = "
			OR (
				rt_rate_type.rt_rate_type_inactive_yn <> 0
				AND rt_rate_type.rt_rate_type_ix = '".$rt_rate_type_id . "'
			)		
		";
	}
	$rateList = $GLOBALS['lDB']->get("
		SELECT
			rt_rate_type.rt_rate_type_ix AS rt_rate_type_id,
			rt_rate_type.rt_rate_type_desc,
			rf_currency.rf_currency_symbol,
			rt_rate_type.rt_rate_type_inactive_yn
		FROM
			rt_rate_type
			LEFT JOIN rf_currency ON  rt_rate_type.rf_currency_id = rf_currency.rf_currency_ix
		WHERE
			rt_rate_type.rt_rate_type_inactive_yn = 0
			$inactiveRateSQL
	",2);
	$rateOptions = "";
	foreach($rateList as $item) {
		if($item['rt_rate_type_inactive_yn'] == "1") {
			$item['rt_rate_type_desc'] = "* " . $item['rt_rate_type_desc'];
		}
		$selected = "";
		if($rt_rate_type_id == $item['rt_rate_type_id']) {
			$selected = " selected ";
		}
		$rateOptions .= "<option $selected value=\"$item[rt_rate_type_id]\">$item[rt_rate_type_desc], $item[rf_currency_symbol]</option>";
	}
	$GLOBALS['temp']['rateOptions'] = $rateOptions;
	
}

function createConsultantOptions($rv_consultant_id=false) {
	if($rv_consultant_id === false) {
		$inactiveConsultantSQL = "";
	} else {
		$inactiveConsultantSQL = "
				OR (
					pr_persona.pr_persona_inactive_yn<>0
					AND pr_persona.pr_persona_ix = '".$rv_consultant_id."'
				)
		";
	}
	$consultantList = $GLOBALS['lDB']->get("
		SELECT
			sc_user.pr_user_id,
			pr_persona.pr_name_last,
			pr_persona.pr_name_first,
			pr_persona.pr_persona_inactive_yn
		FROM
			sc_group
			INNER JOIN sc_user ON sc_group.sc_group_id = sc_user.sc_group_id
			INNER JOIN pr_persona ON sc_user.pr_user_id = pr_persona.pr_persona_ix
		WHERE
			sc_group.sc_grp_consultant_yn=1
			AND (
				pr_persona.pr_persona_inactive_yn=0
				$inactiveConsultantSQL
			)
		ORDER BY
			pr_persona.pr_name_first,
			pr_persona.pr_name_last		
	",2);
	$consultantOptions = "";
	foreach($consultantList as $item) {
		$selected = "";
		if($item['pr_user_id'] == $rv_consultant_id) {
			$selected = " selected ";
		}
		if($rv_consultant_id === false && $item['pr_user_id'] == $GLOBALS['pr_user_id']){
			$selected = " selected ";
		}
		$consultantName = trim($item['pr_name_last']);
		if(trim($item['pr_name_first']) != "") {
			if($consultantName != "") {
				$consultantName .= ", ";
			}
			$consultantName .= trim($item['pr_name_first']);
		}
		if($item['pr_persona_inactive_yn'] == "1") {
			$consultantName = "* " . $consultantName;
		}
		$consultantOptions .= "<option $selected value=\"$item[pr_user_id]\">$consultantName</option>";
	}
	$GLOBALS['temp']['consultantOptions'] = $consultantOptions;	
}	

function getOverbookings($rv_reservation_id) {
	$overbookings = array();
	$allocationItems = $GLOBALS['lDB']->get("
		SELECT
			rv_reservation_item.rv_reservation_item_ix,
			rv_reservation_item.rv_item_accomm_count,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			rv_reservation_item.rv_item_adult_count,
			rv_reservation_item.rv_item_child_count,
			rv_reservation_item.rv_item_nights,
			rv_reservation_item.rv_item_split_yn,
			rv_reservation_item.rt_rate_type_id,
			rv_reservation_item.rv_alloc_expiry_date,
			rv_reservation_item.ac_accomm_type_id,
			rv_reservation_item.pr_business_id,
			rv_reservation_item.rv_reservation_id,
			bl_block_period.bl_block_period_ix
		FROM
			bl_block_period
			INNER JOIN bl_block_itinerary ON bl_block_itinerary.bl_block_period_id = bl_block_period.bl_block_period_ix
			INNER JOIN rv_reservation_item ON rv_reservation_item.bl_block_itinerary_id = bl_block_itinerary.bl_block_itinerary_ix
		WHERE
			rv_reservation_item.rv_reservation_id = '$rv_reservation_id'
	", 6);
	$excludeItems = array();
	foreach ($allocationItems as $blockItem) {
		$excludeItems[] = $blockItem['rv_reservation_item_ix'];
	}
	list($hasAvailability, $overbookingdetails) = check_multi_item_availability($allocationItems,$excludeItems,true,true);
	//If an allocation item for this block booking has an overbooking
	//situation, for all days between each allocation items' arrival and departure dates
	//check to see if the item has a date with an overbooking for the relevant 
	//accommodation type
	if (!$hasAvailability) {
		foreach ($allocationItems as $item) {
			$dateSpan = new DatePeriod(
				 new DateTime($item['rv_item_date_arrive']),
				 new DateInterval('P1D'),
				 new DateTime($item['rv_item_date_depart'])
			);
			foreach ($dateSpan as $date) {
				foreach ($overbookingdetails as $ac_accomm_type_id=>$overbookingdates) {
					foreach ($overbookingdates as $overbookingdate=>$availability) {
						if ($overbookingdate == $date->format("Y-m-d") && $item['ac_accomm_type_id'] == $ac_accomm_type_id) {
							if(!array_key_exists($item['rv_reservation_item_ix'],$overbookings)) {
								$overbookings[$item['rv_reservation_item_ix']] = array();
							}
							$overbookings[$item['rv_reservation_item_ix']][$date->format("Y-m-d")] = $availability;
						}
					}
				}
			}
		}
	}
	return $overbookings;
}
