<?php
/*
 * $Id: init.form344.php,v 1.6 2011-05-17 14:08:30 light Exp $
 *
 * $Log: init.form344.php,v $
 * Revision 1.6  2011-05-17 14:08:30  light
 * Bug #7585 - PHP5 fixes
 *
 */

/**
 * init.form344.php - Contact agent allocation reservations list popup
 * Job: 273
 * Function: 83 (Contact Agent Role)
 */

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/contact_agent_allocation_res_pop.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],3,"");
$rv_reservation_ix = isset($_SERVER['argv'][1]) ? $_SERVER['argv'][1] : "";
$options = $_SERVER['argv'][2];
switch ( $options & 7 ) {
   case REP_VIEW_HTML:
      $renderMode = "html";
      $renderType = "";
      break;
   case REP_VIEW_PDF:
      $renderMode = "pdf";
      $renderType = "view";
      break;
   case REP_EMAIL_PDF:
      $renderMode = "pdf";
      $renderType = "email";
      break;
   case REP_SEND_PDF:
      $renderMode = "pdf";
      $renderType = "send";
      break;
   case REP_VIEW_CSV:
      $renderMode = "csv";
      $renderType = "";
}

$allocDetail = $lDB->get("
	SELECT
		rv_reservation.rv_res_name,
		pr_persona.pr_name_last
	FROM
		rv_reservation
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
	WHERE
		rv_reservation_ix = '$rv_reservation_ix'
",1);


$resList = $lDB->get("
	SELECT DISTINCT
		link_res.rv_reservation_ix,
		link_res.rv_res_name,
		link_res.rv_date_arrive,
		link_res.rv_date_depart,
		rf_reservation_status.rf_reservation_status_desc,
		agent_persona.pr_name_last as agent_name,
		consultant_persona.pr_name_first as consultant_name_first,
		consultant_persona.pr_name_last as consultant_name_last
	FROM
		rv_reservation_item
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
		INNER JOIN rv_reservation_item as link_item ON link_item.rv_reservation_item_ix = rv_reservation_item.rv_link_res_item_id
		INNER JOIN rv_reservation as link_res ON link_res.rv_reservation_ix = link_item.rv_reservation_id
		INNER JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = link_res.rf_reservation_status_id
		LEFT JOIN pr_persona as agent_persona ON agent_persona.pr_persona_ix = link_res.rv_agent_id
		LEFT JOIN pr_persona as consultant_persona ON consultant_persona.pr_persona_ix = link_res.rv_consultant_id
	WHERE
		rv_reservation.rv_reservation_ix = '$rv_reservation_ix'
",2);

$GLOBALS['temp']['subTitle'] = "Found " . sizeof($resList) . " reservations linked to allocation '$allocDetail[rv_res_name]' for agent '$allocDetail[pr_name_last]'";
$GLOBALS['temp']['agent_name'] = $allocDetail['pr_name_last'];
$GLOBALS['temp']['rv_reservation_ix'] = $rv_reservation_ix;
$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));

$reportLabel = "Agent Allocations - $allocDetail[pr_name_last]";
if ( $renderMode == "pdf" && ( $renderType == "view" || $renderType == "send" ) ) {
	$pdf = new PDF($reportLabel,'L');

	$pdf -> SetFillColor('0x9c','0x9e','0x98');

	$headerArray = array();

	$pdfHeadAgentFilter	= $allocDetail['pr_name_last'];

	array_push($headerArray,array('name' => "Agents", 'value' => $pdfHeadAgentFilter));

	$pdfFontSize = 7;
	$pdf->SetFont('Arial', '', $pdfFontSize);

	$pdf->Ln(4);

	$logo = "top_clientlogo.jpg";
	$principal_id = $_SESSION['principal_id'];

	if ( file_exists("$GLOBALS[images_dir_on_disk]/" . $principal_id . "/" . $logo) ) {
		$pic = $pdf->_parsejpg("$GLOBALS[images_dir_on_disk]/" . $principal_id . "/" . $logo);

		$h = $pic['h']/4;
		$w = $pic['w']/4;
		
		require_once(__DIR__ . '/functions.imageset.php');
		$logoWidth = imagesetLogoSizeOverride("contactAgentAllocationReservationsListPdfLogoWidthOverride", $w);
		$pdf->Image("$GLOBALS[images_dir_on_disk]/".$principal_id."/" . $logo, $h, 5, $logoWidth);
		if (($h + 8) > $pdf->y) {
			$pdf->y = $h + 8;
		}
	} 

	$tableHeaders = array();

	array_push($tableHeaders,array('width' => "10%", 'data' => "Res No", 'border' => "LRTB", 'align' => "C", 'fill' => "1"));
	array_push($tableHeaders,array('width' => "14%", 'data' => "Res Name", 'border' => "LRTB", 'align' => "C", 'fill' => "1"));
	array_push($tableHeaders,array('width' => "14%", 'data' => "Arrive", 'border' => "LRTB", 'align' => "C", 'fill' => "1"));
	array_push($tableHeaders,array('width' => "14%", 'data' => "Depart", 'border' => "LRTB", 'align' => "C", 'fill' => "1"));
	array_push($tableHeaders,array('width' => "14%", 'data' => "Status", 'border' => "LRTB", 'align' => "C", 'fill' => "1"));
	array_push($tableHeaders,array('width' => "20%", 'data' => "Consultant", 'border' => "LRTB", 'align' => "C", 'fill' => "1"));
	array_push($tableHeaders,array('width' => "14%", 'data' => "Agent", 'border' => "LRTB", 'align' => "C", 'fill' => "1"));

	$pdf -> Row($tableHeaders);

	foreach ( $resList as $item) {
		$currRowArray = array();

		array_push($currRowArray,array('width' => "10%", 'data' => $item['rv_reservation_ix'],'border' => "LRTB", 'align' => 'L'));
		array_push($currRowArray,array('width' => "14%", 'data' => $item['rv_res_name'],'border' => "LRTB", 'align' => 'L'));
		array_push($currRowArray,array('width' => "14%", 'data' => chng_date($item['rv_date_arrive'],"-"),'border' => "LRTB", 'align' => 'C'));
		array_push($currRowArray,array('width' => "14%", 'data' => chng_date($item['rv_date_depart'],"-"),'border' => "LRTB", 'align' => 'C'));
		array_push($currRowArray,array('width' => "14%", 'data' => $item['rf_reservation_status_desc'],'border' => "LRTB", 'align' => 'C'));
		array_push($currRowArray,array('width' => "20%", 'data' => trim($item['consultant_name_first'] . " " . $item['consultant_name_last']),'border' => "LRTB", 'align' => 'C'));
		array_push($currRowArray,array('width' => "14%", 'data' => $item['agent_name'],'border' => "LRTB", 'align' => 'L'));			

		$pdf -> Row($currRowArray);
	}

	$pdf -> Ln(4);

	$pdf->ReportHeader($reportLabel, $headerArray);

	if ( $renderType == "view" ) {
		$pdf->OutPut();
		die();
	}

	if ( $renderType == "send" ) {
		$to = $_POST['mail_to'];
		$from = $_POST['mail_from'];
		$subject = stripslashes($_POST['mail_subj']);
		$message = stripslashes($_POST['mail_body']);
		$attachmentName = $_POST['attachmentName'];
		$GLOBALS['princName'] = (isset($GLOBALS['princName']) ? $GLOBALS['princName'] : "");

		$headers = "From: " . $GLOBALS['princName'] . "<$from>\r\n";

		// Close the PDF
		if ( $pdf->state < 3 ) {
			$pdf->Close();
		}

		// Mail the PDF
		if ( $attachmentName != "!attachmentName!" ) {
			$pdfName = $attachmentName;
		} else {
			$pdfName = $reportLabel . ".pdf";
		}

		$error = email($from, $to, $subject, $headers, $message, 0, 0, "", $GLOBALS['princName'],$pdf->buffer,$pdfName);     // (from, to, subject, headers, message, action, emailID, resID)

		if ( !$error ) {
			echo "<script type=\"text/javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
			die();
		} else {
			echo "<script type=\"text/javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
			die();
		}
	}
}

if ( $renderMode == "pdf" && $renderType == "email" ) {
	$pdfName = $reportLabel;
	$attachmentTable = "
		<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\" alt=\"\" /></td>
			<td id=\"attachmentLabel\" width=\"100%\">" . $pdfName . ".pdf</td>
		</tr>
		</table>
	";
	$newOptions = ($options & ~7) + 3;
	
	$formAction = "reservation.php?" . join("+",array_slice($_SERVER['argv'],0,2)) . "+" . $newOptions;	

	$GLOBALS[$form]->FormHTML = str_replace("!formAction!",$formAction,
		str_replace("!attachmentInfo!",$attachmentTable,
		str_replace("!attachmentName!",$pdfName.".pdf",
		str_replace("!hasAttachment!","expand",
		str_replace("!emailBody!","",
		str_replace("!emailSubject!",$pdfName,
		Join("", file(__DIR__ . "/../../../public/html/email_popup.htm")))))))
	);
	
	$principalId		= $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId		= $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
	$principalInfo 	= getPersonaDetail($principalId);
	$resOfficeInfo 	= getPersonaDetail($resOfficeId);
	
	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));

	$GLOBALS['temp']['princName'] = $principalInfo['name'];
	$GLOBALS['temp']['fax'] 			= $resOfficeInfo['fax'];
	$GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
	
	$userId = $_SESSION['userid'];
	
	$GLOBALS['temp']['emailFrom'] = $lDB->get("
		SELECT
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE 
		pr_persona.pr_persona_ix = '" . $userId . "'
	", 4);
	
	$GLOBALS['temp']['emailTo'] = "";

}

if($renderMode == "csv") {
	$csvFile = array();
	array_push($csvFile,array($reportLabel));
	array_push($csvFile,array());

	$csvHeadAgentFilter	= str_replace(","," ",$allocDetail['pr_name_last']);

	array_push($csvFile,array("Agents:",$csvHeadAgentFilter));

	array_push($csvFile,array());

	// Header Cells : START ---------------------------------------------------
	$headerCells = array();

	array_push($headerCells, "Res No");
	array_push($headerCells, "Res Name");
	array_push($headerCells, "Arrive");
	array_push($headerCells, "Depart");
	array_push($headerCells, "Status");
	array_push($headerCells, "Consultant");
	array_push($headerCells, "Agent");

	array_push($csvFile,$headerCells);

	// Main Content : START ---------------------------------------------------
	foreach ( $resList as $item) {
		$currRowArray = array();

		array_push($currRowArray, $item['rv_reservation_ix']);
		array_push($currRowArray, $item['rv_res_name']);
		array_push($currRowArray, chng_date($item['rv_date_arrive'],"-"));
		array_push($currRowArray, chng_date($item['rv_date_depart'],"-"));
		array_push($currRowArray, $item['rf_reservation_status_desc']);
		array_push($currRowArray, trim($item['consultant_name_first'] . " " . $item['consultant_name_last']));
		array_push($currRowArray, $item['agent_name']);

		array_push($csvFile,$currRowArray);
	}
	csv_output($reportLabel,$csvFile,$die=true,$unixLines=true,$useTabs=false,$fixFilename=true);
}

$resJob = "0";
if(checkjob(2)) {
	$resJob = "2";
}

$resRowHTML = "
<tr valign=\"top\" height=\"20\" onmouseover=\"this.style.backgroundColor = '#CCFFCC'\" onmouseout=\"this.style.backgroundColor = '#FFFFFF'\" class=\"imgLink\" onclick=\"!onclickCode!\">
	<td>!rv_reservation_ix!</td>
	<td>!rv_res_name!</td>
	<td>!rv_date_arrive!</td>
	<td>!rv_date_depart!</td>
	<td>!rf_reservation_status_desc!</td>
	<td>!consultant_name!</td>
	<td>!agent_name!</td>
</tr> 
";


$rows = "";
foreach($resList as $item) {
	$item['rv_date_arrive'] = chng_date($item['rv_date_arrive'],"-");
	$item['rv_date_depart'] = chng_date($item['rv_date_depart'],"-");
	$item['consultant_name'] = trim($item['consultant_name_first'] . " " . $item['consultant_name_last']);
	$item['onclickCode'] = "opener.opener.location = 'reservation.php?$resJob+$item[rv_reservation_ix]'; opener.close(); window.close();";

	$rows .= showpage($item,$resRowHTML);
}
$GLOBALS['temp']['rows'] = $rows;
