<?php

/**
 * init.form345.php - General Ledger Code Table / General Ledger Batch Administration
 * Job: 276,289
 * Function: 100 (GL Code), 101 (GL Batch)
 */

// Form setup
if(!isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/fin_ledger_account_detail.htm");
}

function getChildren($businessId) {
	$list = $GLOBALS['lDB']->get("
		SELECT
			pr_business_id
		FROM
			pr_business
		WHERE
			pr_business_parent = '$businessId'
	",3);
	$children = array();
	foreach($list as $item) {
		$children = array_merge($children,getChildren($item));
	}
	array_push($children, $businessId);
	return $children;
}


$businessInternal = $GLOBALS['lDB']->get("
	SELECT
		pr_link_to
	FROM
		pr_link
	WHERE
		pr_link_from = '$GLOBALS[userid]'
		AND rf_link_type_id = 'RS1'
",4);

$businessACL = getChildren($businessInternal);


$invoicingUnitIDs = $GLOBALS['lDB']->get("
	SELECT 
		pr_business_id 
	FROM 
		pr_business 
	WHERE 
		pr_bus_inactive_yn = '0' 
		AND pr_business.pr_bus_billing_yn = '1'
		OR pr_business.pr_bus_billing_prop_yn = '1'
	ORDER BY 
		pr_business_sequence ASC
",3);

$invoicingUnitIDs = array_intersect($invoicingUnitIDs,$businessACL);

$invoicingUnits = $GLOBALS['lDB']->get("
	SELECT 
		pr_persona.pr_persona_ix AS id,
		pr_persona.pr_name_last AS name, 
		pr_business.pr_bus_post_inventory_yn AS isInventory
	FROM 
		pr_persona 
		INNER JOIN pr_business ON pr_business.pr_business_id = pr_persona.pr_persona_ix
	WHERE 
		pr_persona.pr_persona_ix IN ('" . join("','",$invoicingUnitIDs) . "')
	ORDER BY
		pr_business.pr_business_sequence
",2);

$jobId = "277";
$GLOBALS['temp']['title'] = "Financial Setup &amp; Processing";
if($_SERVER['argv'][0] == "289") {
	$jobId = "290";
	$GLOBALS['temp']['title'] = "GL Batch Administration";
}

/*$html = "
	<center>
		<br />
		<span class=\"txtb\">Click on the invoice unit to setup the financial account details</span>
		<br />
		<br />
		";*/
$html = "
	<br />
	<table width=\"770\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\" style=\"table-layout: fixed; border-collapse: collapse;\">
	<tr>
		<td class=\"colLt bl bt bb\">Invoice Unit</td>
		<td class=\"colLt bt bb\" style=\"width:60px;\">&nbsp;</td>
		<td class=\"colLt bt bb\" style=\"width:70px;\">&nbsp;</td>
		<td class=\"colLt bt bb\" style=\"width:70px;\">&nbsp;</td>
		<td class=\"colLt bt bb\" style=\"width:70px;\">&nbsp;</td>
		<td class=\"colLt bt bb\" style=\"width:90px;\">&nbsp;</td>
		<td class=\"colLt bt bb\" style=\"width:70px;\">&nbsp;</td>
		<td class=\"colLt bt bb br\" style=\"width:70px;\">&nbsp;</td>
	</tr>
";
$copyHTML = "";
foreach($invoicingUnits as $unit ) {
	$isInventoryButton = $unit['isInventory'] ? "button" : "btn-disabled";
	$isInventory = $unit['isInventory'] ? "" : "disabled";
	$html .= "
		<tr onmouseout=\"this.style.backgroundColor = '';\" onmouseover=\"this.style.backgroundColor='#cfc';\">
			<td class=\"bl br\">".t_encodeHTMLField($unit['name'])."</td>
			<td class=\"br\" align=\"center\"><button class=\"button\" onclick=\"getPage($jobId,'$unit[id]'); applyTrans(1);\" style=\"text-align:center; width:52px;\">Setup</button></td>
			<td class=\"br\" align=\"center\"><button class=\"button\" onclick=\"openInvoices('$unit[id]');\" style=\"text-align:center; width:62px;\">Invoices</button></td>
			<td class=\"br\" align=\"center\"><button class=\"button\" onclick=\"openPayments();\" style=\"text-align:center; width:62px;\">Payments</button></td>
			<td class=\"br\" align=\"center\"><button class=\"$isInventoryButton\" onclick=\"openInventory('$unit[id]');\" style=\"text-align:center; width:62px;\" id='btnInventory$unit[id]' $isInventory>Inventory</button></td>
			<td class=\"br\" align=\"center\"><button class=\"button\" onclick=\"openTransactions('$unit[id]');\" style=\"text-align:center; width:82px;\">Transactions</button></td>
			<td class=\"br\" align=\"center\"><button class=\"button\" onclick=\"openDebtors('$unit[id]');\" style=\"text-align:center; width:62px;\">Debtors</button></td>
			<td class=\"br\" align=\"center\"><button class=\"button\" onclick=\"openBatchPopup('$unit[id]');\" style=\"text-align:center; width:62px;\">Batches</button></td>
		</tr>
	";
	// For the GL Code copying capabilities --------------------------------------
	$copyHTML .= "<option value=\"$unit[id]\">$unit[name]</option>";
}
$html .= "
	<tr>
		<td class=\"bt\" colspan=\"8\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
	</tr>
	</table>
";
/*$html .= "
	</center>
	";*/

$GLOBALS['temp']['html'] = $html;
$GLOBALS['temp']['copyHTML'] = $copyHTML;
