<?php

/**
 * init.form346.php - General Ledger account detail popup - General Tab
 * Job: 277
 * Function: 100
 */

// Form setup -----------------------------------------------------------------
if(!isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/fin_ledger_account_detail_popup.htm");
}

if(isset($_POST['url']) && $_POST['url'] != "" ) {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
	$GLOBALS['temp']['url'] = $_POST['url'];
}

$iUnitID = $_SERVER['argv'][1];

if ( $_SERVER['argc'] > 2 ) {
	// Process the data to be saved ----------------------------------------------
	$d = explode(":",$_SERVER['argv'][3]);
	if(sizeof($d) > 1) {
		db_pr_business_ledger_update($iUnitID,$d[0],$d[1],$d[2],$d[3],$d[4],$d[5],$d[6],$d[7],$d[8],$d[9],$d[10],$d[11],$d[12],$d[13],$d[15],$d[16],$d[17],$d[18],$d[19],$d[20],$d[21],$d[22],$d[23],$d[24],$d[25],$d[26],$d[27],$d[28],$d[29],$d[30],$d[31],$d[32],$d[33],$d[34],$d[35],$d[36]);
	}
	$envDebtorPairs = explode("!",$d[14]);
	$envDebtors = array();
	foreach($envDebtorPairs as $pair) {
		list($rf_db_code,$default) = explode("=",$pair);
		$rf_database_id = $GLOBALS['lDB']->get("SELECT rf_database_id FROM rf_database WHERE rf_db_code = '$rf_db_code'",4);
		if($default == "cash") {
			db_fn_db_business_set($iUnitID,$rf_database_id,DB_FN_DB_BUS_DEBTOR_CASH);
		} else {
			db_fn_db_business_set($iUnitID,$rf_database_id,DB_FN_DB_BUS_DEBTOR_SUSPENSE);
		}
	}
}

// Display the current data ---------------------------------------------------
$unitDetails = $GLOBALS['lDB']->get("
	SELECT 
		*
	FROM
		pr_business
	WHERE 
		pr_business.pr_business_id = '" . $iUnitID . "'
",1);

$unitName = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix = '" . $iUnitID . "'",4);

$postType = trim($GLOBALS['lDB']->get("SELECT fn_system_desc FROM fn_system WHERE fn_system_ix = '$unitDetails[fn_system_id]'",4));

if(empty($postType)) {
	$postType = "None";
	$GLOBALS['temp']['hideConfigureOptions'] = 'collapse';
} else {
	$GLOBALS['temp']['hideConfigureOptions'] = '';
}

$systems = $GLOBALS['lDB']->get("
	SELECT fn_system_ix, fn_system_desc
	FROM fn_system
	WHERE fn_system_ix <> 'RS1'
	AND fn_system_inactive_yn = 0
	ORDER BY fn_system_desc
", 6);
$disableSystemOptions = db_pr_business_ledger_allow($iUnitID) ? '' : ' disabled';
$systemOptions = '<select id="systemOptions" name="systemOptions" onchange="glEdit()"' . $disableSystemOptions . '>';
$systemOptions .= '<option value="">None</option>';

foreach ($systems as $system) {
	$selected = $system['fn_system_ix'] == $unitDetails['fn_system_id'] ? 'selected' : '';
	$systemOptions .= "<option value=\"{$system['fn_system_ix']}\" $selected>";
	$systemOptions .= $system['fn_system_desc'];
	$systemOptions .= '</option>';
}

$systemOptions .= '</select>';
$GLOBALS['temp']['financialSystemOptions'] = $systemOptions;

$GLOBALS['temp']['fn_system_email'] = $unitDetails['fn_system_email'];

$isCensysadUser = isCensysadUser();
$GLOBALS['temp']['hideForNonCensysad'] = !$isCensysadUser ? 'class="collapse"' : '';
$GLOBALS['temp']['hideForCensysad'] = $isCensysadUser ? 'class="collapse"' : '';
$GLOBALS['temp']['invoicingUnit'] = $iUnitID;
$GLOBALS['temp']['isInventory'] = '';
$GLOBALS['temp']['allowInventory'] = '';
if (db_pr_business_is_inventory($iUnitID) == '0') {
	$GLOBALS['temp']['isInventory'] = 'tab-disabled';
	$GLOBALS['temp']['allowInventory'] = 'return false;';
}

if($unitDetails['pr_bus_post_pmt_yn'] == "1") {
	$paymentGenerate = "Yes";
	$GLOBALS['temp']['CheckedPaymentTransactionsYes']	= "checked=\"checked\"";
	$GLOBALS['temp']['CheckedPaymentTransactionsNo']		= "";
} else {
	$paymentGenerate = "No";
	$GLOBALS['temp']['CheckedPaymentTransactionsYes']	= "";
	$GLOBALS['temp']['CheckedPaymentTransactionsNo']		= "checked=\"checked\"";
}

if($unitDetails['pr_bus_ignore_past_pmt_yn'] == "1") {
	$paymentIgnorePast = "Yes";
	$GLOBALS['temp']['CheckedPaymentIgnorePastYes']	= "checked=\"checked\"";
	$GLOBALS['temp']['CheckedPaymentIgnorePastNo']		= "";
} else {
	$paymentIgnorePast = "No";
	$GLOBALS['temp']['CheckedPaymentIgnorePastYes']	= "";
	$GLOBALS['temp']['CheckedPaymentIgnorePastNo']		= "checked=\"checked\"";
}

if($unitDetails['pr_bus_post_dep_yn'] == "1") {
	$GLOBALS['temp']['depositGenerate'] = "Yes";
	$GLOBALS['temp']['CheckedDepositGenerateYes']	= "checked=\"checked\"";
	$GLOBALS['temp']['CheckedDepositGenerateNo']		= "";
} else {
	$GLOBALS['temp']['depositGenerate'] = "No";
	$GLOBALS['temp']['CheckedDepositGenerateYes']	= "";
	$GLOBALS['temp']['CheckedDepositGenerateNo']		= "checked=\"checked\"";
}

if($unitDetails['pr_bus_post_inv_yn'] == "1") {
	$GLOBALS['temp']['invoiceGenerate'] = "Yes";	
	$GLOBALS['temp']['CheckedInvoiceGenerateYes']	= "checked=\"checked\"";
	$GLOBALS['temp']['CheckedInvoiceGenerateNo']		= "";
} else {
	$GLOBALS['temp']['invoiceGenerate'] = "No";
	$GLOBALS['temp']['CheckedInvoiceGenerateYes']		= "";
	$GLOBALS['temp']['CheckedInvoiceGenerateNo']		= "checked=\"checked\"";
}
if($unitDetails['pr_bus_post_inventory_yn'] == "1") {
	$GLOBALS['temp']['inventoryGenerate'] 				= "Yes";	
	$GLOBALS['temp']['CheckedInventoryGenerateYes']		= "checked=\"checked\"";
	$GLOBALS['temp']['CheckedInventoryGenerateNo']		= "";
	$GLOBALS['temp']['showInventoryDetails']			= "";
} else {
	$GLOBALS['temp']['inventoryGenerate']				= "No";
	$GLOBALS['temp']['CheckedInventoryGenerateYes']		= "";
	$GLOBALS['temp']['CheckedInventoryGenerateNo']		= "checked=\"checked\"";
	$GLOBALS['temp']['showInventoryDetails']			= "collapse";
}
if($unitDetails['pr_bus_post_in_po_yn'] == "1") {
	$GLOBALS['temp']['genInvPOGenerateYes']				= "Yes";	
	$GLOBALS['temp']['CheckedinvPOGenerateYes']			= "checked=\"checked\"";
	$GLOBALS['temp']['CheckedinvPOGenerateNo']			= "";
} else {
	$GLOBALS['temp']['genInvPOGenerateYes']				= "No";
	$GLOBALS['temp']['CheckedinvPOGenerateYes']			= "";
	$GLOBALS['temp']['CheckedinvPOGenerateNo']			= "checked=\"checked\"";
}
if($unitDetails['pr_bus_post_in_returns_yn'] == "1") {
	$GLOBALS['temp']['genInvRetGenerateYes']			= "Yes";
	$GLOBALS['temp']['CheckedinvRetGenerateYes']		= "checked=\"checked\"";
	$GLOBALS['temp']['CheckedinvRetGenerateNo']			= "";
} else {
	$GLOBALS['temp']['genInvRetGenerateYes']			= "No";
	$GLOBALS['temp']['CheckedinvRetGenerateYes']		= "";
	$GLOBALS['temp']['CheckedinvRetGenerateNo']			= "checked=\"checked\"";
}
if($unitDetails['pr_bus_post_in_returns_yn'] == "1") {
	$GLOBALS['temp']['genInvRetGenerateYes']			= "Yes";	
	$GLOBALS['temp']['CheckedinvRetGenerateYes']		= "checked=\"checked\"";
	$GLOBALS['temp']['CheckedinvRetGenerateNo']			= "";
} else {
	$GLOBALS['temp']['genInvRetGenerateYes']			= "No";
	$GLOBALS['temp']['CheckedinvRetGenerateYes']		= "";
	$GLOBALS['temp']['CheckedinvRetGenerateNo']			= "checked=\"checked\"";
}
if($unitDetails['pr_bus_post_in_cos_yn'] == "1") {
	$GLOBALS['temp']['genInvCoSGenerateYes']			= "Yes";	
	$GLOBALS['temp']['CheckedinvCoSGenerateYes']		= "checked=\"checked\"";
	$GLOBALS['temp']['CheckedinvCoSGenerateNo']			= "";
} else {
	$GLOBALS['temp']['genInvCoSGenerateYes']			= "No";
	$GLOBALS['temp']['CheckedinvCoSGenerateYes']		= "";
	$GLOBALS['temp']['CheckedinvCoSGenerateNo']			= "checked=\"checked\"";
}
if($unitDetails['pr_bus_post_in_issues_yn'] == "1") {
	$GLOBALS['temp']['genInvStIssueGenerateYes']		= "Yes";	
	$GLOBALS['temp']['CheckedinvStIssueGenerateYes']	= "checked=\"checked\"";
	$GLOBALS['temp']['CheckedinvStIssueGenerateNo']		= "";
} else {
	$GLOBALS['temp']['genInvStIssueGenerateYes']		= "No";
	$GLOBALS['temp']['CheckedinvStIssueGenerateYes']	= "";
	$GLOBALS['temp']['CheckedinvStIssueGenerateNo']		= "checked=\"checked\"";
}
if($unitDetails['pr_bus_post_in_trfs_yn'] == "1") {
	$GLOBALS['temp']['genInvStTfrGenerateYes']			= "Yes";	
	$GLOBALS['temp']['CheckedinvStTfrGenerateYes']		= "checked=\"checked\"";
	$GLOBALS['temp']['CheckedinvStTfrGenerateNo']		= "";
} else {
	$GLOBALS['temp']['genInvStTfrGenerateYes']			= "No";
	$GLOBALS['temp']['CheckedinvStTfrGenerateYes']		= "";
	$GLOBALS['temp']['CheckedinvStTfrGenerateNo']		= "checked=\"checked\"";
}

$GLOBALS['temp']['unitName'] = $unitName;
$GLOBALS['temp']['iUnitID']	 = $iUnitID;

$GLOBALS['temp']['fn_ledger_id_input_vat']	 = $unitDetails['fn_ledger_id_input_vat'];
$GLOBALS['temp']['pr_bus_api_client']		 = $unitDetails['pr_bus_api_client'];
$GLOBALS['temp']['pr_bus_api_token']		 = $unitDetails['pr_bus_api_token'];
$GLOBALS['temp']['pr_bus_api_url_base']		 = $unitDetails['pr_bus_api_url_base'];
$GLOBALS['temp']['pr_bus_api_url_po']		 = $unitDetails['pr_bus_api_url_po'];
$GLOBALS['temp']['pr_bus_api_url_returns']	 = $unitDetails['pr_bus_api_url_returns'];
$GLOBALS['temp']['pr_bus_api_url_cos']		 = $unitDetails['pr_bus_api_url_cos'];
$GLOBALS['temp']['pr_bus_api_url_issues']	 = $unitDetails['pr_bus_api_url_issues'];
//  Transfer fields are disabled and hidden in the html. Remove the disabled tag when feature this is added.
$GLOBALS['temp']['pr_bus_api_url_transfers'] = $unitDetails['pr_bus_api_url_transfers'];

$GLCodes = $GLOBALS['lDB']->get("
	SELECT 
		fn_ledger_ix,
		fn_ledger_code,
		fn_ledger_desc
	FROM
		fn_ledger
	WHERE 
		fn_ledger.pr_business_id = '$iUnitID'
		AND fn_ledger.fn_ledger_inactive_yn = '0'
	ORDER BY
		fn_ledger.fn_ledger_code
",2);
$GLOptions = $cashOptions = $suspenseOptions = $suspenseForeignOptions = $InventoryOptions = "<option value=\"\">None</option>";
foreach ( $GLCodes as $g ) {
	$GLSelected = "";
	$cashSelected = "";
	$suspenseSelected = "";
	$suspenseForeignSelected = "";
	$InventorySelected = "";

	if ( $g['fn_ledger_ix'] == $unitDetails['fn_ledger_id_debtors'] ) {
		$GLSelected = " selected=\"selected\"";
	}

	if ( $g['fn_ledger_ix'] == $unitDetails['fn_ledger_id_input_vat'] ) {
		$InventorySelected = " selected=\"selected\"";
	}

	if ( $g['fn_ledger_ix'] == $unitDetails['fn_ledger_id_cash'] ) {
		$cashSelected = " selected=\"selected\"";
	}

	if ( $g['fn_ledger_ix'] == $unitDetails['fn_ledger_id_suspense'] ) {
		$suspenseSelected = " selected=\"selected\"";
	}

	if ( $g['fn_ledger_ix'] == $unitDetails['fn_ledger_id_suspense_foreign'] ) {
		$suspenseForeignSelected = " selected=\"selected\"";
	}

	$GLOptions .= "<option value=\"$g[fn_ledger_ix]\" $GLSelected>".t_encodeHTMLField($g['fn_ledger_code'].": ".$g['fn_ledger_desc'])."</option>\n";
	$cashOptions .= "<option value=\"$g[fn_ledger_ix]\" $cashSelected>".t_encodeHTMLField($g['fn_ledger_code'].": ".$g['fn_ledger_desc'])."</option>\n";
	$suspenseOptions .= "<option value=\"$g[fn_ledger_ix]\" $suspenseSelected>".t_encodeHTMLField($g['fn_ledger_code'].": ".$g['fn_ledger_desc'])."</option>\n";
	$suspenseForeignOptions .= "<option value=\"$g[fn_ledger_ix]\" $suspenseForeignSelected>".t_encodeHTMLField($g['fn_ledger_code'].": ".$g['fn_ledger_desc'])."</option>\n";
	$InventoryOptions .= "<option value=\"$g[fn_ledger_ix]\" $InventorySelected>".t_encodeHTMLField($g['fn_ledger_code'].": ".$g['fn_ledger_desc'])."</option>\n";
}

$DebtorCodes = $GLOBALS['lDB']->get("
	SELECT
		fn_debtor_ix,
		fn_debtor_code,
		fn_debtor_desc
	FROM
		fn_debtor
	WHERE
		fn_debtor.pr_business_id = '$iUnitID'
		AND fn_debtor.fn_debtor_inactive_yn = '0'
	ORDER BY
		fn_debtor.fn_debtor_code
",2);
$cashDebtorOptions = $suspenseDebtorOptions = $suspenseDebtorForeignOptions = "<option value=\"\">None</option>";
foreach($DebtorCodes as $item) {
	$cashSelected = "";
	$suspenseSelected = "";
	$suspenseForeignSelected = "";

	if($item['fn_debtor_ix'] == $unitDetails['fn_debtor_id_cash']) {
		$cashSelected = "selected=\"selected\"";
	}

	if($item['fn_debtor_ix'] == $unitDetails['fn_debtor_id_suspense']) {
		$suspenseSelected = "selected=\"selected\"";
	}

	if($item['fn_debtor_ix'] == $unitDetails['fn_debtor_id_suspense_foreign']) {
		$suspenseForeignSelected = "selected=\"selected\"";
	}

	$cashDebtorOptions .= "<option value=\"$item[fn_debtor_ix]\" $cashSelected>".t_encodeHTMLField($item['fn_debtor_code'].": ".$item['fn_debtor_desc'])."</option>\n";
	$suspenseDebtorOptions .= "<option value=\"$item[fn_debtor_ix]\" $suspenseSelected>".t_encodeHTMLField($item['fn_debtor_code'].": ".$item['fn_debtor_desc'])."</option>\n";
	$suspenseDebtorForeignOptions .= "<option value=\"$item[fn_debtor_ix]\" $suspenseForeignSelected>".t_encodeHTMLField($item['fn_debtor_code'].": ".$item['fn_debtor_desc'])."</option>\n";
}


$revenueCentres = $GLOBALS['lDB']->get("
	SELECT
		fn_cost_centre.fn_cost_centre_ix,
		fn_cost_centre.fn_cost_centre_code,
		fn_cost_centre.fn_cost_centre_desc
	FROM
		fn_cost_centre
	WHERE
		fn_cost_centre.pr_business_id = '$iUnitID'
		AND fn_cost_centre.fn_cost_centre_ind <> '2' 
	ORDER BY
		fn_cost_centre.fn_cost_centre_code
",2);
$revenueCentreOptions = "<option value=\"\">None</option>";
foreach($revenueCentres as $revenueCentre) {
	$selected = "";
	if($unitDetails['fn_cost_centre_1_default_id'] == $revenueCentre['fn_cost_centre_ix']) {
		$selected = "selected";
	}
	$revenueCentreOptions .= "<option $selected value=\"$revenueCentre[fn_cost_centre_ix]\">".t_encodeHTMLField($revenueCentre['fn_cost_centre_code'].": ".$revenueCentre['fn_cost_centre_desc'])."</option>";
}

$mealPlans = $GLOBALS['lDB']->get("
	SELECT
		rt_component.rt_component_ix,
		rt_component.rt_component_desc
	FROM
		rt_component
	WHERE
		rt_component.rt_component_inactive_yn = '0'
		AND rt_component.rt_component_type_ind = '" . DB_RT_COMPONENT_TYPE_MEAL_PLAN . "'
",6);
$mealPlanOptions = "<option value=\"\">None</option>";
foreach($mealPlans as $mealPlan) {
	$selected = "";
	if($unitDetails['fn_meal_component_default_id'] == $mealPlan['rt_component_ix']) {
		$selected = "selected";
	}
	$mealPlanOptions .= "<option $selected value=\"$mealPlan[rt_component_ix]\">".t_encodeHTMLField($mealPlan['rt_component_desc'])."</option>";
}

if ( $unitDetails['pr_bus_post_tax_cost_ctr_yn'] == 1 ) {
	$GLOBALS['temp']['CheckedCostCentreTaxYes']	= "checked=\"checked\"";
	$GLOBALS['temp']['CheckedCostCentreTaxNo']		= "";
} else {
	$GLOBALS['temp']['CheckedCostCentreTaxYes']	= "";
	$GLOBALS['temp']['CheckedCostCentreTaxNo']		= "checked=\"checked\"";
}

if ( $unitDetails['pr_bus_post_source_curr_yn'] == 1 ) {
	$GLOBALS['temp']['CheckedShowSourceCurrencyYes']	= "checked=\"checked\"";
	$GLOBALS['temp']['CheckedShowSourceCurrencyNo']		= "";
} else {
	$GLOBALS['temp']['CheckedShowSourceCurrencyYes']	= "";
	$GLOBALS['temp']['CheckedShowSourceCurrencyNo']		= "checked=\"checked\"";
}

$postingEnvironments = $GLOBALS['lDB']->get("
	SELECT 
		rf_database.rf_database_id,
		rf_database.rf_db_code,
		rf_database.rf_db_description,
		fn_db_business.fn_db_bus_debtor_ind
	FROM
		rf_database
		LEFT JOIN fn_db_business ON fn_db_business.rf_database_id = rf_database.rf_database_id AND fn_db_business.pr_business_id = '$iUnitID'
	WHERE
		rf_database.rf_db_inactive_yn <> 1
",2);


$postingEnvironmentHTML = "<option value=\"\">None</option>";
foreach ( $postingEnvironments as $post => $p ) {
	$selected = "";
	if ( $p['rf_database_id'] == $unitDetails['pr_bus_post_env_id'] ) {
		$selected = " selected=\"selected\"";
	}
	$postingEnvironmentHTML .= "<option value=\"" . $p['rf_database_id'] . "\"" . $selected . ">" . t_encodeHTMLField($p['rf_db_code'] . " : " . $p['rf_db_description']) . "</option>";
}

if ( $unitDetails['pr_bus_post_clear_dtrs_yn'] == 1 ) {
	$GLOBALS['temp']['CheckedClearDebtorsYes']	= "checked=\"checked\"";
	$GLOBALS['temp']['CheckedClearDebtorsNo']		= "";
} else {
	$GLOBALS['temp']['CheckedClearDebtorsYes']	= "";
	$GLOBALS['temp']['CheckedClearDebtorsNo']		= "checked=\"checked\"";
}

$debtorEnvRows = "";
$debtorEnvRowHTML = "
	<tr>
		<td class=\"bl br\" style=\"width: 150px;\">!rf_db_code! : !rf_db_description!</td>
		<td class=\"br\" style=\"width: 50px;\" align=\"center\"><input type=\"radio\" name=\"!rf_db_code!debtorEnv\" id=\"!rf_db_code!debtorEnvCash\" !cash_checked! onchange=\"glEdit();\" /></td>
		<td class=\"br\" style=\"width: 50px;\" align=\"center\"><input type=\"radio\" name=\"!rf_db_code!debtorEnv\" id=\"!rf_db_code!debtorEnvSuspense\" !suspense_checked! onchange=\"glEdit();\" /></td>
	</tr>
	";
$envArray = array();
foreach($postingEnvironments as $env) {
	$env['cash_checked'] = "";
	$env['suspense_checked'] = "";
	if($env['fn_db_bus_debtor_ind'] != DB_FN_DB_BUS_DEBTOR_CASH) {
		$env['suspense_checked'] = "checked";
	} else {
		$env['cash_checked'] = "checked";
	}
	$envArray[] = $env['rf_db_code'];
	$debtorEnvRows .= showpage($env,$debtorEnvRowHTML);
}
$GLOBALS['temp']['debtorEnvRows'] = $debtorEnvRows;
$GLOBALS['temp']['envArray'] = join(":",$envArray);

$GLOBALS['temp']['GLOptions'] = $GLOptions;
$GLOBALS['temp']['cashOptions'] = $cashOptions;
$GLOBALS['temp']['suspenseOptions'] = $suspenseOptions;
$GLOBALS['temp']['InventoryOptions'] = $InventoryOptions;
$GLOBALS['temp']['suspenseForeignOptions'] = $suspenseForeignOptions;
$GLOBALS['temp']['cashDebtorOptions'] = $cashDebtorOptions;
$GLOBALS['temp']['suspenseDebtorOptions'] = $suspenseDebtorOptions;
$GLOBALS['temp']['suspenseDebtorForeignOptions'] = $suspenseDebtorForeignOptions;
$GLOBALS['temp']['revenueCentreOptions'] = $revenueCentreOptions;
$GLOBALS['temp']['mealPlanOptions'] = $mealPlanOptions;
$GLOBALS['temp']['postingEnvironments']	= $postingEnvironmentHTML;
$GLOBALS['temp']['fun_job_id']					= $_SERVER['argv'][0];
$GLOBALS['temp']['iUnitID']							= $iUnitID;
$GLOBALS['temp']['postType'] = $postType;
$GLOBALS['temp']['paymentGenerate'] = $paymentGenerate;
$GLOBALS['temp']['paymentIgnorePast'] = $paymentIgnorePast;

$GLOBALS['temp']['glPostingPerCodeChecked'] = "";
$GLOBALS['temp']['glPostingPerTransactionChecked'] = "";
$GLOBALS['temp']['debtorPostingControlChecked'] = "";
$GLOBALS['temp']['debtorPostingPerDebtorChecked'] = "";
$GLOBALS['temp']['debtorPostingPerTransactionChecked'] = "";
switch($unitDetails['pr_bus_post_level_gl']) {
case 1:
	$GLOBALS['temp']['glPostingPerTransactionChecked'] = "checked";
	break;
case 2:
	$GLOBALS['temp']['glPostingPerCodeChecked'] = "checked";
	break;
}

switch($unitDetails['pr_bus_post_level_dtrs']) {
case 1:
	$GLOBALS['temp']['debtorPostingPerTransactionChecked'] = "checked";
	break;
case 2:
	$GLOBALS['temp']['debtorPostingPerDebtorChecked'] = "checked";
	break;
case 3:
	$GLOBALS['temp']['debtorPostingControlChecked'] = "checked";
	break;
}

$GLOBALS['temp']['pr_bus_post_in_po_ynChecked'] = $unitDetails['pr_bus_post_in_po_yn'];
$GLOBALS['temp']['pr_bus_post_in_returns_ynChecked'] = $unitDetails['pr_bus_post_in_returns_yn'];
$GLOBALS['temp']['pr_bus_post_in_cos_ynChecked'] = $unitDetails['pr_bus_post_in_cos_yn'];
$GLOBALS['temp']['pr_bus_post_in_issues_ynChecked'] = $unitDetails['pr_bus_post_in_issues_yn'];
$GLOBALS['temp']['pr_bus_post_in_trfs_ynChecked'] = $unitDetails['pr_bus_post_in_trfs_yn'];

if(db_pr_business_ledger_allow($iUnitID)) {
	$GLOBALS['temp']['allowEdit'] = "";
	$GLOBALS['temp']['allowEditStyle'] = "";
} else {
	$GLOBALS['temp']['allowEdit'] = "disabled";
	$GLOBALS['temp']['allowEditStyle'] = "style=\"display: none;\"";
}
