<?php

/**
 * init.form347.php - General Ledger account detail popup - GL Codes Tab
 * Job: 278
 * Function: 100
 */

// Form setup -----------------------------------------------------------------
if(!isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/fin_ledger_account_detail_popup_gl_codes.htm");
}

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
	$GLOBALS['temp']['url'] = $_POST['url'];
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

$iUnitID = $_SERVER['argv'][1];
$filterSQL = "";
$sortSQL = " ORDER BY fn_ledger.fn_ledger_code ";
$error = array();
$GLOBALS['temp']['showError'] = "display: none;";
$exists = false;
$GLOBALS['temp']['isInventory'] = '';
$GLOBALS['temp']['allowInventory'] = '';
if (db_pr_business_is_inventory($iUnitID) == '0') {
	$GLOBALS['temp']['isInventory'] = 'tab-disabled';
	$GLOBALS['temp']['allowInventory'] = 'return false;';
}

$GLOBALS['temp']['lastFilterDBField'] = "";
$GLOBALS['temp']['lastFilterText'] = "";

if ( $_SERVER['argc'] > 2 ) {
	switch ( $_SERVER['argv'][2] ) {
		case ("add") :
			// Process the data to be saved
			$addedFields = explode("_",$_SERVER['argv'][3]);
			// Knock off the extra empty array
			array_pop($addedFields);
			foreach ( $addedFields as $data ) {
				$thisData = explode(":",$data);
				foreach($thisData as $key=>$item) {
					$thisData[$key] = rawurldecode($item);
				}
				$dupe = db_fn_ledger_check_duplicate($thisData[1],$thisData[2],$iUnitID);

				if ( $dupe > 0 ) {
					array_push($error,array($thisData[1],$thisData[2]));
				} else {
					db_fn_ledger_insert($thisData[1],$thisData[2],$iUnitID);
				}				
			}
			break;

		case ("edit"):
			// Process the data to be saved
			$editedFields = explode("_",$_SERVER['argv'][3]);
			// Knock off the extra empty array
			array_pop($editedFields);
			foreach ( $editedFields as $data ) {
				$thisData = explode(":",$data);
				foreach($thisData as $key=>$item) {
					$thisData[$key] = rawurldecode($item);
				}
				$dupe = db_fn_ledger_check_duplicate($thisData[1],$thisData[2],$iUnitID,$thisData[0]);

				if ( $dupe > 0 ) {
					array_push($error,array($thisData[1],$thisData[2]));
				} else {
					db_fn_ledger_update($thisData[0],$thisData[1],$thisData[2],$iUnitID);
				}
			}
			break;

		case ("copy") :
			$sourceUnitID = $_SERVER['argv'][3];
			$codes = $GLOBALS['lDB']->get("
				SELECT
					fn_ledger_code,
					fn_ledger_desc
				FROM
					fn_ledger
				WHERE
					pr_business_id = '" . $sourceUnitID . "'
			",2);

			foreach ( $codes as $c ) {
				$dupe = db_fn_ledger_check_duplicate($c[0],$c[1],$iUnitID);

				if ( $dupe > 0 ) {
					array_push($error,array($c[0],$c[1]));
				} else {
					db_fn_ledger_insert($c[0],$c[1],$iUnitID);
				}
			}		
			break;

		case ("delete") :
			$codes = explode(":",$_SERVER['argv'][3]);
			foreach ( $codes as $c ) {
				// Check if this GL Code is used somewhere. If so, set to inactive, rather
				// than deleting it
				$folio_link = false;
				$where[$c] = array();

				$ac_extra_inv_count = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM ac_extra_inv WHERE ac_extra_inv.fn_ledger_id = '" . $c . "'",4);
				if ( $ac_extra_inv_count > 0 ) { 
					$exists = true;
					array_push($where[$c],"Extras");
				}

				$rf_bank_inv_account_count = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM rf_bank_inv WHERE rf_bank_inv.fn_ledger_id_account = '" . $c . "'",4);
				if ( $rf_bank_inv_account_count > 0 ) {
					$exists = true;
					array_push($where[$c],"Bank / cash point");
				}

				$rf_bank_inv_deposit_count = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM rf_bank_inv WHERE rf_bank_inv.fn_ledger_id_deposit = '" . $c . "'",4);
				if ( $rf_bank_inv_deposit_count > 0 ) {
					$exists = true;
					array_push($where[$c],"Deposit account");
				}

				$pr_business_debtors_count = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM pr_business WHERE pr_business.fn_ledger_id_debtors = '" . $c . "'",4);
				if ( $pr_business_debtors_count > 0 ) {
					$exists = true;
					array_push($where[$c],"Debtors control account code");
				}

				$pr_business_suspense_count = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM pr_business WHERE pr_business.fn_ledger_id_suspense = '" . $c . "'",4);
				if ( $pr_business_suspense_count > 0 ) {
					$exists = true;
					array_push($where[$c],"Business posting suspense account");
				}

				$pr_business_cash_count = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM pr_business WHERE pr_business.fn_ledger_id_cash = '" . $c . "'",4);
				if ( $pr_business_cash_count > 0 ) {
					$exists = true;
					array_push($where[$c],"Business cash sales account");
				}

				$rt_component_inv_count = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM rt_component_inv WHERE rt_component_inv.fn_ledger_id = '" . $c . "'",4);
				if ( $rt_component_inv_count > 0 ) {
					$exists = true;
					array_push($where[$c],"Rate components");
				}

				$fn_invoice_item_count = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM fn_invoice_item WHERE fn_invoice_item.fn_ledger_id = '" . $c . "'",4);
				if ( $fn_invoice_item_count > 0 ) {
					// We need to check whether the GL Code is used anywhere else, if not,
					// it is only used against an invoice and so we mark it as inactive in
					// the next step.
					if ( !$exists ) {					
						$folio_link = true;
					}
				}

				if ( !$exists ) {
					// The GL code is not used anywhere, so go ahead and delete it -----------
					db_fn_ledger_delete('delete',$c);
				} else {
					if ( $folio_link ) {
						db_fn_ledger_delete('inactive',$c);
					}
				}
			}
			break;

		case ("filter") :
			$glFilterData = explode(":",$_SERVER['argv'][3]);
			$filterField = $glFilterData[0];
			$filterText = rawurldecode($glFilterData[1]);
			if(empty($filterText)) {
				$filterText = "*";
			}

			if ( $filterText == "*" )	{
				$filterSQL = "";
			} else {
				// Looking for a partial match, so field LIKE filterText
				$filterSQL .= " AND fn_ledger." . $filterField . " LIKE '" . $lDB->like($filterText) . "'";
			}
			$GLOBALS['temp']['lastFilterDBField'] = t_encodeHTMLField($filterField);
			$GLOBALS['temp']['lastFilterText'] = t_encodeHTMLField($filterText);
			break;

		case ("sort") :
			$sortData = explode(":",$_SERVER['argv'][3]);
			break;
		case "importUpload":
			$type = $_POST['glUploadType'];
			$uploadData = file($_FILES['glUploadFile']['tmp_name']);
			$data = array();
			$duplicates = [];
			foreach($uploadData as $line) {
				$line = str_getcsv($line);
				if(sizeof($line) < 2) {
					continue; // ignore empty lines
				}
				list($code,$desc) = $line;
				$code = trim($code);
				$desc = trim($desc);
				if($code != "") { // Ignore blank codes
					array_push($data,array(
						'code'=>$code,
						'description'=>$desc,
					));
					$check = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM fn_ledger WHERE fn_ledger_code = '$code' AND pr_business_id = '$iUnitID'",4);
					if($check > 0) {
						$duplicates[] = [
							'code'=>$code,
							'description'=>$desc
						];
					}					
				}
			}
			session_set("glUploadData",$data);
				
			echo "
				<script language=\"javascript\">
					var records = ".sizeof($data)."
					var duplicates = ".json_encode($duplicates).";
					parent.importGLConfirm(records,duplicates);
				</script>
			";
			die();
			break;
		case "importConfirm":
			if(is_array($_SESSION['glUploadData'])) {
				$data = $_SESSION['glUploadData'];
			} else {
				$data = array();
			}
			$type = $_SERVER['argv'][3];

			foreach($data as $item) {
				$code = addslashes($item['code']);
				$desc = addslashes($item['description']);
				$check = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM fn_ledger WHERE fn_ledger_code = '$code' AND pr_business_id = '$iUnitID'",4);
				if($check > 0) {
					$fn_ledger_id = $GLOBALS['lDB']->get("SELECT fn_ledger_ix FROM fn_ledger WHERE fn_ledger_code = '$code' AND pr_business_id = '$iUnitID'",4);
					db_fn_ledger_update($fn_ledger_id,$code,$desc,$iUnitID);
				} else {
					db_fn_ledger_insert($code,$desc,$iUnitID);
				}
			}
			break;
	}
}

// Display the current data ---------------------------------------------------

$unitDetails = $GLOBALS['lDB']->get("
	SELECT 
		*
	FROM
		pr_business
	WHERE 
		pr_business.pr_business_id = '" . $iUnitID . "'
",1);

$unitName = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix = '" . $iUnitID . "'",4);

$GLOBALS['temp']['unitName'] = $unitName;
$GLOBALS['temp']['iUnitID']	 = $iUnitID;

$GLCodes = $GLOBALS['lDB']->get("
	SELECT 
		fn_ledger_ix,
		fn_ledger_code,
		fn_ledger_desc
	FROM
		fn_ledger
	WHERE 
		fn_ledger.pr_business_id = '" . $iUnitID . "'
		" . $filterSQL . "
	AND
		fn_ledger.fn_ledger_inactive_yn = '0'
",2);

// Natural sorting ------------------------------------------------------------
if ( $_SERVER['argv'][2] == "sort" ) {
	$sort_field = $sortData[0];
	$sort_order = $sortData[1];
} else {
	$sort_field = "fn_ledger_code";
	$sort_order = "ASC";
}

$sort_array = array();
foreach ( $GLCodes as $g ) {
	array_push($sort_array,$g[$sort_field]);
}

natsort($sort_array);

if ( $sort_order == "DESC" ) {
	$sort_array = array_reverse($sort_array,TRUE);
}

$keys = array_keys($sort_array);
// ----------------------------------------------------------------------------

if(db_pr_business_ledger_allow($iUnitID)) {
	$allowEdit = true;
	$GLOBALS['temp']['allowEditStyle'] = "";
} else {
	$allowEdit = false;
	$GLOBALS['temp']['allowEditStyle'] = "style=\"display: none;\"";
}


$codes = array();
$GLCodesHTML = "";
foreach ( $keys as $k ) {
	array_push($codes,$GLCodes[$k]['fn_ledger_code']);

	if($allowEdit) {
		$mouseOver = 'style="cursor: pointer;" onmouseover="hover(\'' . $GLCodes[$k]['fn_ledger_ix'] . '\',1);" onmouseout="hover(\'' . $GLCodes[$k]['fn_ledger_ix'] . '\',0);"';
		$onClick = 'onclick="glEdit(\'' . $GLCodes[$k]['fn_ledger_ix'] . '\',event);"';
		$checkbox = '<input type="checkbox" id="check' . $GLCodes[$k]['fn_ledger_ix'] . '" />';
	} else {
		$mouseOver = "";
		$onClick = "";
		$checkbox = '&nbsp;';
	}

	$GLCodesHTML .= '
		<tr id="' . $GLCodes[$k]['fn_ledger_ix'] . '" ' . $mouseOver . '>
			<td class="bl br" style="width:26px">' . $checkbox .'</td>
			<td class="br" style="width:150px; overflow:hidden;" id="input1' . $GLCodes[$k]['fn_ledger_ix'] . '" class="br" ' . $onClick . '>' . t_encodeHTMLField($GLCodes[$k]['fn_ledger_code']) . '</td>
			<td class="br" style="width:314px; overflow:hidden;" id="input2' . $GLCodes[$k]['fn_ledger_ix'] . '" class="br" ' . $onClick . '>' . t_encodeHTMLField($GLCodes[$k]['fn_ledger_desc']) . '</td>
			<td class="br"><img src="/resource/Resrequest/Application/public/img/1x1.gif" /></td>
		</tr>';
}

$GLOBALS['temp']['GLCodes']			= implode(",",$codes);
$GLOBALS['temp']['GLCodeRows']	= $GLCodesHTML;
$GLOBALS['temp']['fun_job_id']	= $_SERVER['argv'][0];
$GLOBALS['temp']['iUnitID']			= $iUnitID;

// Error notification on duplicate --------------------------------------------
if ( count($error) > 0 ) {

	$GLOBALS['temp']['showError'] = '';
	
	$GLOBALS['temp']['errorContents'] = '<span class="txtwh txtb">Some of the data you entered duplicates data in the database already. Below is a list of your input that contains either a duplicate GL Code or a duplicate description:</span><br /><br />';
	
	$GLOBALS['temp']['errorContents'] .= '<table width="95%" border="0" cellpadding="2" cellspacing="0" summary="" class="bt br bl">';
	
	$GLOBALS['temp']['errorContents'] .= '<tr>
																					<thead>
																						<th class="colDk bb br">GL Code</th>
																						<th class="colDk bb">GL Code Description</th>
																					</thead>
																				</tr>';

	foreach ( $error as $e ) {
		$GLOBALS['temp']['errorContents'] .= '<tr>
																						<td class="colWh bb br">' . $e[0] . '</td>
																						<td class="colWh bb">' . $e[1] . '</td>
																					</tr>';
	}

	$GLOBALS['temp']['errorContents'] .= '<tr class="colLt">
																					<td colspan="3" align="right">
																						<button type="button" class="button" onclick="closeError();">
																							<img src="/resource/Resrequest/Application/public/img/icon_ok_16.gif" width="16" height="16" alt="OK" />
																							<span>OK</span>
																						</button>
																					</td>
																				</tr>';

	$GLOBALS['temp']['errorContents'] .= '</table>';
}

// Error notification on delete -----------------------------------------------
if ( $exists ) {

	$GLOBALS['temp']['showError'] = "";
	
	$GLOBALS['temp']['errorContents'] = '<span class="txtwh txtb">Some of the GL Codes you selected to delete are used elsewhere in the system. Below is a list of the codes and where they are used:</span><br /><br />';

	$GLOBALS['temp']['errorContents'] .= '<table width="95%" border="0" cellpadding="2" cellspacing="0" summary="" class="bt br bl">';

	$GLOBALS['temp']['errorContents'] .= '<tr>
																					<thead>
																						<th class="colDk bb br">GL Code</th>
																						<th class="colDk bb">Section</th>
																					</thead>
																				</tr>';

	foreach( $where as $code => $section ) {
		if ( $section ) {
			$glCode = $GLOBALS['lDB']->get("SELECT fn_ledger.fn_ledger_code FROM fn_ledger WHERE fn_ledger.fn_ledger_ix = '" . $code . "'",4);

			$GLOBALS['temp']['errorContents'] .= '<tr>
																							<td class="colWh bb br" valign="top">' . $glCode . '</td>';

			$GLOBALS['temp']['errorContents'] .= '<td class="colWh bb" valign="top">';

			foreach ( $section as $s ) {
				$GLOBALS['temp']['errorContents'] .= $s . '<br />';
			}
			$GLOBALS['temp']['errorContents'] .= '</td></tr>';
		}
	}

	$GLOBALS['temp']['errorContents'] .= '<tr class="colLt">
																					<td colspan="2" align="right">
																						<button type="button" class="button" onclick="closeError();">
																							<img src="/resource/Resrequest/Application/public/img/icon_ok_16.gif" width="16" height="16" alt="OK" />
																							<span>OK</span>
																						</button>
																					</td>
																				</tr>';
	$GLOBALS['temp']['errorContents'] .= '</table>';
}

