<?php

/**
 * init.form348.php - General Ledger account detail popup - Cost Centres Tab
 * Job: 279
 * Function: 100
 */

if(!isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/fin_ledger_account_detail_popup_cost_centres.htm");
}

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
	$GLOBALS['temp']['url'] = $_POST['url'];
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

$iUnitID = $_SERVER['argv'][1];
$filterSQL = "";
$sortSQL = " ORDER BY fn_cost_centre.fn_cost_centre_desc ";
$error = array();
$GLOBALS['temp']['showError'] = "display: none;";

$GLOBALS['temp']['lastFilterDBField'] = "";
$GLOBALS['temp']['lastFilterText'] = "";
$GLOBALS['temp']['isInventory'] = '';
$GLOBALS['temp']['allowInventory'] = '';
if (db_pr_business_is_inventory($iUnitID) == '0') {
	$GLOBALS['temp']['isInventory'] = 'tab-disabled';
	$GLOBALS['temp']['allowInventory'] = 'return false;';
}

$exists = false;
if ( $_SERVER['argc'] > 2 ) {
	// Process the data to be saved ----------------------------------------------
	switch ( $_SERVER['argv'][2] ) {
		case ("add") :
			$addedFields = explode("_",$_SERVER['argv'][3]);
			// Knock off the extra empty array
			array_pop($addedFields);
			foreach ( $addedFields as $data ) {
				$thisData = explode(":",$data);
				foreach($thisData as $key=>$item) {
					$thisData[$key] = rawurldecode($item);
				}
				$dupe = db_fn_cost_centre_check_duplicate($thisData[1],$thisData[2],$iUnitID);

				if ( $dupe > 0 ) {
					array_push($error,array($thisData[1],$thisData[2]));
				} else {
					db_fn_cost_centre_insert($thisData[1],$thisData[2],$thisData[3],$iUnitID);
				}				
			}
			break;

		case ("edit"):
			// Process the data to be saved
			$editedFields = explode("_",$_SERVER['argv'][3]);
			// Knock off the extra empty array
			array_pop($editedFields);
			foreach ( $editedFields as $data ) {
				$thisData = explode(":",$data);
				foreach($thisData as $key=>$item) {
					$thisData[$key] = rawurldecode($item);
				}
				$dupe = db_fn_cost_centre_check_duplicate($thisData[1],$thisData[2],$iUnitID,$thisData[0]);

				if ( $dupe > 0 ) {
					array_push($error,array($thisData[1],$thisData[2]));
				} else {
					db_fn_cost_centre_update($thisData[0],$thisData[1],$thisData[2],$thisData[3],$iUnitID);
				}
			}
			break;

		case ("delete") :
			$costCentres = explode(":",$_SERVER['argv'][3]);
			foreach ( $costCentres as $c ) {
				// Check if this Cost Centre ID is used somewhere. If so, set to inactive, rather
				// than deleting it
				$where[$c] = array();
				
				$ac_accomm_type_count = $GLOBALS['lDB']->get("SELECT COUNT (*) FROM ac_accomm_type WHERE ac_accomm_type.fn_cost_centre_id = '" . $c . "'",4);
				if ( $ac_accomm_type_count > 0 ) {
					$exists = true;
					array_push($where[$c],"Accommodation");
				}

				$ac_extra_cat_inv_count = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM ac_extra_cat_inv WHERE ac_extra_cat_inv.fn_cost_centre_2_id = '" . $c . "'",4);
				if ( $ac_extra_cat_inv_count > 0 ) {
					$exists = true;
					array_push($where[$c],"Extra Categories");
				}

				$ac_extra_inv_count = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM ac_extra_inv WHERE ac_extra_inv.fn_cost_centre_2_id = '" . $c . "'",4);
				if ( $ac_extra_inv_count > 0 ) {
					$exists = true;
					array_push($where[$c],"Extras");
				}

				$pr_business_count = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM pr_business WHERE pr_business.fn_cost_centre_1_id = '" . $c . "'",4);
				if ( $pr_business_count > 0 ) {
					$exists = true;
					array_push($where[$c],"Properties");
				}

				if ( !$exists ) {
					db_fn_cost_centre_delete('delete',$c);					
				}				
			}
			break;
			debug($where);

		case ("filter") :
			$glFilterData = explode(":",$_SERVER['argv'][3]);
			$filterField = $glFilterData[0];
			$filterText = rawurldecode($glFilterData[1]);
			if(empty($filterText)) {
				$filterText = "*";
			}

			if($filterField == "fn_cost_centre_ind") {
				$filterText = preg_replace("/level\s*/i","",$filterText);
			}

			if ( $filterText == "*" )	{
				$filterSQL = "";
			} else {
				// Looking for a partial match, so field LIKE filterText
				$filterSQL .= " AND fn_cost_centre." . $filterField . " LIKE '" . $lDB->like($filterText) . "'";
			}
			$GLOBALS['temp']['lastFilterDBField'] = t_encodeHTMLField($filterField);
			$GLOBALS['temp']['lastFilterText'] = t_encodeHTMLField($filterText);
			break;

		case ("sort") :
			$sortData = explode(":",$_SERVER['argv'][3]);
			break;
	}
}

// Display the current data ---------------------------------------------------
$unitDetails = $GLOBALS['lDB']->get("
	SELECT 
		*
	FROM
		pr_business
	WHERE 
		pr_business.pr_business_id = '" . $iUnitID . "'
",1);

$unitName = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix = '" . $iUnitID . "'",4);

$costCentres = $GLOBALS['lDB']->get("
	SELECT
		fn_cost_centre.fn_cost_centre_ix,
		fn_cost_centre.fn_cost_centre_code,
		fn_cost_centre.fn_cost_centre_desc,
		fn_cost_centre.fn_cost_centre_ind
	FROM
		fn_cost_centre
	WHERE
		fn_cost_centre.fn_cost_centre_inactive_yn = '0' 
		" . $filterSQL . "
	AND 
		fn_cost_centre.pr_business_id = '" . $iUnitID . "'
",2);

// Natural sorting ------------------------------------------------------------
if ( $_SERVER['argv'][2] == "sort" ) {
	$sort_field = $sortData[0];
	$sort_order = $sortData[1];
} else {
	$sort_field = "fn_cost_centre_desc";
	$sort_order = "ASC";
}

$sort_array = array();
foreach ( $costCentres as $g ) {
	array_push($sort_array,$g[$sort_field]);
}

natsort($sort_array);

if ( $sort_order == "DESC" ) {
	$sort_array = array_reverse($sort_array,TRUE);
}

$keys = array_keys($sort_array);
// ----------------------------------------------------------------------------

if(db_pr_business_ledger_allow($iUnitID)) {
	$allowEdit = true;
	$GLOBALS['temp']['allowEditStyle'] = "";
} else {
	$allowEdit = false;
	$GLOBALS['temp']['allowEditStyle'] = "style=\"display: none;\"";
}


$costCentreHTML = "";
foreach ( $keys as $k ) {
	if($allowEdit) {
		$mouseOver = "style=\"cursor: pointer;\" onmouseover=\"hover('" . $costCentres[$k]['fn_cost_centre_ix'] . "',1);\" onmouseout=\"hover('" . $costCentres[$k]['fn_cost_centre_ix'] . "',0);\"";
		$onClick = "onclick=\"glEdit('" . $costCentres[$k]['fn_cost_centre_ix'] . "',event);\"";
		$checkbox = "<input type=\"checkbox\" id=\"check" . $costCentres[$k]['fn_cost_centre_ix'] . "\" />";
	} else {
		$mouseOver = "";
		$onClick = "";
		$checkbox = "&nbsp;";
	}
	
	$costCentreHTML .= "
		<tr id=\"" . $costCentres[$k]['fn_cost_centre_ix'] . "\" " . $mouseOver . ">
			<td class=\"bl br\" style=\"width: 26px\">$checkbox</td>\n
			<td id=\"cell1" . $costCentres[$k]['fn_cost_centre_ix'] . "\" class=\"br\" style=\"width: 120px\"" . $onClick . ">" . t_encodeHTMLField($costCentres[$k]['fn_cost_centre_code']) . "</td>
			<td id=\"cell2" . $costCentres[$k]['fn_cost_centre_ix'] . "\" class=\"br\" style=\"width: 194px\"" . $onClick . ">" . t_encodeHTMLField($costCentres[$k]['fn_cost_centre_desc']) . "</td>
			<td id=\"cell3" . $costCentres[$k]['fn_cost_centre_ix'] . "\" class=\"br\" style=\"width: 150px\"" . $onClick . ">Level " . t_encodeHTMLField($costCentres[$k]['fn_cost_centre_ind']) . "</td>
			<td class=\"br\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
		</tr>
	";
}

// Error notification on duplicates -------------------------------------------
if ( count($error) > 0 ) {

	$GLOBALS['temp']['showError'] = "";
	
	$GLOBALS['temp']['errorContents'] = '<span class="txtwh txtb">Some of the data you entered duplicates data in the database already. Below is a list of your input that contains either a duplicate GL Code or a duplicate description:</span><br /><br />';
	
	$GLOBALS['temp']['errorContents'] .= '<table width="95%" border="0" cellpadding="2" cellspacing="0" summary="" class="bt br bl">';
	
	$GLOBALS['temp']['errorContents'] .= '<tr>
																					<thead>
																						<th class="colDk bb br">Cost Centre Name</th>
																						<th class="colDk bb">Cost Centre Code</th>
																					</thead>
																				</tr>';

	foreach ( $error as $e ) {
		$GLOBALS['temp']['errorContents'] .= '<tr>
																						<td class="colWh bb br">' . $e[0] . '</td>
																						<td class="colWh bb br">' . $e[1] . '</td>
																					</tr>';
	}

	$GLOBALS['temp']['errorContents'] .= '<tr class="colLt">
																					<td colspan="3" align="right">
																						<button type="button" class="button" onclick="closeError();">
																							<img src="/resource/Resrequest/Application/public/img/icon_ok_16.gif" width="16" height="16" alt="OK" />
																							<span>OK</span>
																						</button>
																					</td>
																				</tr>';

	$GLOBALS['temp']['errorContents'] .= '</table>';
}

// Error notification on delete -----------------------------------------------
if ( $exists ) {

	$GLOBALS['temp']['showError'] = "";
	
	$GLOBALS['temp']['errorContents'] = '<span class="txtwh txtb">Some of the Cost Centres you selected to delete are used elsewhere in the system. Below is a list of the Cost Centres and where they are used:</span><br /><br />';

	$GLOBALS['temp']['errorContents'] .= '<table width="95%" border="0" cellpadding="2" cellspacing="0" summary="" class="bt br bl">';
	$GLOBALS['temp']['errorContents'] .= '<tr>
																					<thead>
																						<th class="colDk bb br">Cost Centre Code</th>
																						<th class="colDk bb br">Cost Centre Name</th>
																						<th class="colDk bb">Section</th>
																					</thead>
																				</tr>';

	foreach( $where as $centre => $section ) {
		if ( $section ) {
			$details = $GLOBALS['lDB']->get("
				SELECT 
					fn_cost_centre.fn_cost_centre_code,
					fn_cost_centre.fn_cost_centre_desc
				FROM 
					fn_cost_centre 
				WHERE 
					fn_cost_centre.fn_cost_centre_ix = '" . $centre . "'
			",1);

			$GLOBALS['temp']['errorContents'] .= '<tr>
																							<td class="colWh bb br" valign="top">' . $details[0] . '</td>
																							<td class="colWh bb br" valign="top">' . $details[1] . '</td>
																							<td class="colWh bb" valign="top">';

			foreach ( $section as $s ) {
				$GLOBALS['temp']['errorContents'] .= $s . '<br />';
			}
			$GLOBALS['temp']['errorContents'] .= '</td></tr>';
		}
	}

	$GLOBALS['temp']['errorContents'] .= '<tr class="colLt">
																					<td colspan="3" align="right">
																						<button type="button" class="button" onclick="closeError();">
																							<img src="/resource/Resrequest/Application/public/img/icon_ok_16.gif" width="16" height="16" alt="OK" />
																							<span>OK</span>
																						</button>
																					</td>
																				</tr>';
	$GLOBALS['temp']['errorContents'] .= '</table>';
}

$GLOBALS['temp']['costCentreRows']	= $costCentreHTML;
$GLOBALS['temp']['unitName']				= $unitName;
$GLOBALS['temp']['fun_job_id']			= $_SERVER['argv'][0];
$GLOBALS['temp']['iUnitID']					= $iUnitID;

