<?php

/**
 * init.form349.php - General Ledger account detail popup - Properties Tab
 * Job: 280
 * Function: 100
 */

// Form setup -----------------------------------------------------------------
if(!isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/fin_ledger_account_detail_popup_properties.htm");
}

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
	$GLOBALS['temp']['url'] = $_POST['url'];
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

$iUnitID = $_SERVER['argv'][1];
$filterSQL = "";
$sortSQL = "";

$GLOBALS['temp']['lastFilterDBField'] = "";
$GLOBALS['temp']['lastFilterText'] = "";
$GLOBALS['temp']['isInventory'] = '';
$GLOBALS['temp']['allowInventory'] = '';
if (db_pr_business_is_inventory($iUnitID) == '0') {
	$GLOBALS['temp']['isInventory'] = 'tab-disabled';
	$GLOBALS['temp']['allowInventory'] = 'return false;';
}

if ( $_SERVER['argc'] > 2 ) {
	// Process the data to be saved ----------------------------------------------
	switch ( $_SERVER['argv'][2] ) {
		case ("edit"):
			if(db_pr_business_ledger_allow($iUnitID)) {
				// Process the data to be saved
				$editedFields = explode("_",$_SERVER['argv'][3]);
				// Knock off the extra empty array
				array_pop($editedFields);
				$master = $lDB->isMaster;
				$lDB->isMaster = "1";
				foreach ( $editedFields as $data ) {
					$d = explode(":",$data);
					$GLOBALS['lDB']->put("
						UPDATE
							pr_business
						SET
							pr_business.fn_cost_centre_1_id = '" . $d[1] . "'
						WHERE
							pr_business.pr_business_id = '" . $d[0] . "'
					");
				}
				$lDB->isMaster = $master;
			}
			break;

		case ("filter") :
			$glFilterData = explode(":",$_SERVER['argv'][3]);
			$filterField = $glFilterData[0];
			$filterText = rawurldecode($glFilterData[1]);

			if ( $filterText == "*" )	{
				$filterSQL = "";
			} elseif($filterField == "fn_cost_centre") {
				if(empty($filterText)) {
					$filterSQL .= "
						AND fn_cost_centre.fn_cost_centre_ix IS NULL
					";
				} else {
					$filterSQL .= "
						AND (
							(fn_cost_centre.fn_cost_centre_code LIKE '" . $lDB->like($filterText) . "')
							OR (fn_cost_centre.fn_cost_centre_desc LIKE '" . $lDB->like($filterText) . "')
							OR (
								CONCAT(fn_cost_centre.fn_cost_centre_code, ': ', fn_cost_centre.fn_cost_centre_desc) LIKE '" . $lDB->like($filterText) . "')
						)
					";
				}
			} else {
				if(empty($filterText)) {
					$filterText = "*";
				}
				$filterSQL .= " AND " . $filterField . " LIKE '" . $lDB->like($filterText) . "'";
			}
			$GLOBALS['temp']['lastFilterDBField'] = t_encodeHTMLField($filterField);
			$GLOBALS['temp']['lastFilterText'] = t_encodeHTMLField($filterText);
			break;

		case ("sort") :
			$sortData = explode(":",$_SERVER['argv'][3]);
			/*$sortSQL = " ORDER BY " . $sortData[0] . " " . $sortData[1];*/
			break;
	}
}	

// Display the current data --------------------------------------------------
$unitName = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix = '" . $iUnitID . "'",4);

$p1 = getPropChildren($iUnitID);
$p2 = getPropChildren($iUnitID,true);
$allProperties = array_merge($p1,$p2);
$nonFilteredPropertyIDs = array_unique($allProperties);

// Filter or sort the properties as per the user input ------------------------
$filteredProperties = $GLOBALS['lDB']->get("
	SELECT 
		pr_business.pr_business_id
	FROM
		pr_business
		LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
		LEFT JOIN fn_cost_centre ON fn_cost_centre.fn_cost_centre_ix = pr_business.fn_cost_centre_1_id
	WHERE 
		pr_business.pr_business_id IN ('" . implode("','",$nonFilteredPropertyIDs) . "')
		" . $filterSQL . "
		" . $sortSQL . "
",3);

$costCentres = $GLOBALS['lDB']->get("
	SELECT
		fn_cost_centre.fn_cost_centre_ix,
		fn_cost_centre.fn_cost_centre_code,
		fn_cost_centre.fn_cost_centre_desc
	FROM
		fn_cost_centre
	WHERE
		fn_cost_centre.pr_business_id = '" . $iUnitID  . "'
	AND 
		fn_cost_centre.fn_cost_centre_ind = '1' 
	ORDER BY 
		fn_cost_centre.fn_cost_centre_desc
",2);

$data = array();
foreach ( $filteredProperties as $pID ) {
	$propertyData = $GLOBALS['lDB']->get("
		SELECT
			pr_business.pr_business_id,
			pr_persona.pr_name_last,
			fn_cost_centre.fn_cost_centre_code,
			fn_cost_centre.fn_cost_centre_desc,
			fn_cost_centre.fn_cost_centre_ix
		FROM
			pr_business
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
			LEFT JOIN fn_cost_centre ON fn_cost_centre.fn_cost_centre_ix = pr_business.fn_cost_centre_1_id
		WHERE
			pr_business.pr_business_id = '$pID'
	",1);
	array_push($data,$propertyData);
}

// Natural sorting ------------------------------------------------------------
if ( $_SERVER['argv'][2] == "sort" ) {
	$sort_field = $sortData[0];
	$sort_order = $sortData[1];
} else {
	$sort_field = "pr_name_last";
	$sort_order = "ASC";
}

$sort_array = array();
foreach ( $data as $g ) {
	array_push($sort_array,$g[$sort_field]);
}

natsort($sort_array);

if ( $sort_order == "DESC" ) {
	$sort_array = array_reverse($sort_array,TRUE);
}

$keys = array_keys($sort_array);
// ----------------------------------------------------------------------------


$hiddenDiv = "";

if(db_pr_business_ledger_allow($iUnitID)) {
	$allowEdit = true;
	$GLOBALS['temp']['allowEditStyle'] = "";
} else {
	$allowEdit = false;
	$GLOBALS['temp']['allowEditStyle'] = "style=\"display: none;\"";
}


$propertiesHTML = "";
foreach ( $keys as $k ) {
	// Build the cost centre selection box ---------------------------------------
	$options = "<select id=\"cell2Select" . $data[$k]['pr_business_id'] . "\" style=\"width: 144px;\">
			<option value=\"\">None</option>
	";
	foreach ( $costCentres as $cc ) {
		$selected = "";
		if ( $cc['fn_cost_centre_ix'] == $data[$k]['fn_cost_centre_ix'] ) {
			$selected = " selected=\"selected\"";
		}
		$options .= "<option value=\"$cc[fn_cost_centre_ix]\" $selected>".t_encodeHTMLField($cc['fn_cost_centre_code'].": ".$cc['fn_cost_centre_desc'])."</option>\n";
	}
	$options .= "</select>\n";

	if($allowEdit) {
		$mouseOver = "style=\"cursor: pointer;\" onmouseover=\"hover('" . $data[$k]['pr_business_id'] . "',1);\" onmouseout=\"hover('" . $data[$k]['pr_business_id'] . "',0);\"";
		$onClick = "onclick=\"glEdit('" . $data[$k]['pr_business_id'] . "',event);\"";
	} else {
		$mouseOver = "";
		$onClick = "";
	}

	if ( $data[$k]['fn_cost_centre_desc'] == "" ) {
		$desc = "<span class=\"txti txtg\">Click here to assign a revenue centre</span>";
	} else {
		$desc = t_encodeHTMLField($data[$k]['fn_cost_centre_code'] . ": ". $data[$k]['fn_cost_centre_desc']);
	}

	$propertiesHTML .= "
		<tr id=\"" . $data[$k]['pr_business_id'] . "\" " . $mouseOver . ">\n
			<td id=\"cell1" . $data[$k]['pr_business_id'] . "\" class=\"bl br\" style=\"width:250px;\"" . $onClick . ">" . t_encodeHTMLField($data[$k]['pr_name_last']) . "</td>
			<td id=\"cell2" . $data[$k]['pr_business_id'] . "\" class=\"br\" style=\"width:250px;\"" . $onClick . ">" . $desc . "</td>
			<td class=\"br\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
		</tr>";
		
	$hiddenDiv .= "<span id=\"hidden" . $data[$k]['pr_business_id'] . "\">" . $options . "</span>\n";
}

$GLOBALS['temp']['propertyHTML']	= $propertiesHTML;
$GLOBALS['temp']['hiddenDiv']			= $hiddenDiv;
$GLOBALS['temp']['unitName']			= $unitName;
$GLOBALS['temp']['fun_job_id']		= $_SERVER['argv'][0];
$GLOBALS['temp']['iUnitID']				= $iUnitID;

