<?php
/*
 * $Id: init.form35.php,v 1.6 2011-05-17 14:08:30 light Exp $
 *
 * $Log: init.form35.php,v $
 * Revision 1.6  2011-05-17 14:08:30  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.5  2005-05-09 12:02:58  mbaxendale
 * (Bug#4205) - Unique description
 *
 * Revision 1.4  2004/07/18 13:18:01  light
 * Property Access Fixes
 *
 * Revision 1.3  2004/04/26 08:20:51  tvdspuy
 * ix fields part 3
 *
 * Revision 1.2  2004/04/23 09:34:16  light
 * Bug #2004 - Phone Type (Telephone pop-up)
 *
 */

/**
* init.form35.php - Phone Type Code Table
* Job: 87
* Function: 57 (Code Tables: General)
*/

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/code_phone_type_list.htm");
}

$orderby = (isset($_SERVER['argv'][2]) ? $_SERVER['argv'][2] : 0);

if (isset($_SERVER['argv'][3])) {
	$order = ($_SERVER['argv'][3] == "1" ? " desc" : " asc");
} else {
	$order = " asc";
}

// Counter for preventing duplicate entries
$counti = 0;

$GLOBALS['temp']['imgSort1'] = "";
$GLOBALS['temp']['imgSort2'] = "";
$GLOBALS['temp']['imgSort3'] = "";
$GLOBALS['temp']['imgSort4'] = "";

$GLOBALS['temp']['imgSort1Mode'] = "std"; #(name, asc)
$GLOBALS['temp']['imgSort2Mode'] = "std"; #(name, desc)
$GLOBALS['temp']['imgSort3Mode'] = "std"; #(abbrev, asc)
$GLOBALS['temp']['imgSort4Mode'] = "std"; #(abbrev, desc)

switch ($orderby) {
	case 0:
		$orderbyfield = "rf_phone_type_desc";
		if ($order == " asc") {
			$GLOBALS['temp']['imgSort1Mode'] = "down"; #(name, asc)
		} else {
			$GLOBALS['temp']['imgSort2Mode'] = "down"; #(name, desc)
		}
		break;
	case 1:
		$orderbyfield = "rf_phone_inactive_yn";
		if ($order == " asc") {
			$GLOBALS['temp']['imgSort4Mode'] = "down"; #(name, asc)
		} else {
			$GLOBALS['temp']['imgSort3Mode'] = "down"; #(name, desc)
		}
		break;
}

if (sizeof($GLOBALS[$form]->RecordList) < "1") {

	$where = "";
	$RecordListSQL = "
		SELECT
			rf_phone_type.rf_phone_type_ix as rf_phone_type_ix,
			rf_phone_type_desc,
			rf_phone_inactive_yn,
		 	rf_phone_type_db
		FROM
			rf_phone_type
		".$where
		.(isset($orderbyfield) ? " order by ".$orderbyfield.$order : "");
	$countsql = "select count(*) from rf_phone_type".$where;
	$tempcount = $lDB->get($countsql,1);
	$GLOBALS['temp']['numrows'] = $tempcount[0];
	$RecordCount = $tempcount[0];

	$sortclick = "0";
	if(checkjob("90") == true) {
		$selectjob = "90";
		if($record == "") {
			$sortclick = "88";
		}
	} else {
		$selectjob = "87";
	}
	if($sortclick == "0") {
		$sortclick = $selectjob;
	}

	$GLOBALS['temp']['selectjob'] = $selectjob;
	$GLOBALS['temp']['sortclick'] = $sortclick;
	$GLOBALS['temp']['rows'] = "";
	if ($RecordCount != "0") {
		$recordid = $lDB->get($RecordListSQL,2);
		for ($i = 0; $i < $RecordCount; $i++) {
			$phone_type_id = $recordid[$i]['rf_phone_type_ix'];
			$phone_type_description = $recordid[$i]['rf_phone_type_desc'];
			$phone_inactive = $recordid[$i]['rf_phone_inactive_yn'];
		 $phone_db = $recordid[$i]['rf_phone_type_db'];

			if ($phone_type_id != "") {
				if($phone_type_description == "") {
					$phone_type_description = "&nbsp;";
				}
				$phone_type = array();
				$phone_type['phone_type_id'] = $phone_type_id;
						if(canEditDB($phone_db)) {
					$phone_type['phone_type_description'] = "<span id='phone".(string) $counti++."'>".$phone_type_description."</span>";
						} else {
					$phone_type['phone_type_description'] = "<span class='txtg' id='phone".(string) $counti++."'>".$phone_type_description."</span>";
						}					
				
				$phone_type['phone_inactive'] = "";
				if ($phone_inactive != "0") {
					$phone_type['phone_inactive'] = "x";
				}
				$phone_type['selectjob'] = $selectjob;
			if(canEditDB($phone_db)) {
				$phone_type['rowClass'] = "linkrow";
				$phone_type['itemClass'] = "";
				$phone_type['canEdit'] = "";
			} else {
				$phone_type['rowClass'] = "";
				$phone_type['itemClass'] = "txtg";
				$phone_type['canEdit'] = "return;";
			}

				# Add this line to each code table
				$HTML = __DIR__ . "/../../../public/html/code_phone_type_rows.htm";
				$rowHtml = Join("",File($HTML));
				$GLOBALS['temp']['rows'] .= showpage($phone_type,$rowHtml);
			}
		}
	} else {
		$it ="
			<tr class='txt' height='20'>
				<td height='20' class='txt' colspan=2 align=center>&nbsp;&nbsp;There are no existing phone types.</td>
			</tr></a>";
		$GLOBALS['temp']['rows'] = $it;
	}
}

$hidelist = array();
$GLOBALS[$form]->Hide($hidelist);

$disablelist = array();
$GLOBALS[$form]->Disable($disablelist);

$GLOBALS['temp']['rowCount'] = (string) $counti;
